package docs

func init() {

	Definition["<stdin>"] = "# `<stdin>`  - Command Reference\n\n> Read the STDIN belonging to the parent code block\n\n## Description\n\nThis is used inside functions and other code blocks to pass that block's\nSTDIN down a pipeline\n\n## Usage\n\n    <stdin> -> <stdout>\n\n## Examples\n\nWhen writing more complex scripts, you cannot always invoke your read as the\nfirst command in a code block. For example a simple pipeline might be:\n\n    » function: example { -> match: 2 }\n    \nBut this only works if `->` is the very first command. The following would\nfail:\n\n    # Incorrect code\n    function: example {\n        out: \"only match 2\"\n        -> match 2\n    }\n    \nThis is where `<stdin>` comes to our rescue:\n\n    function: example {\n        out: \"only match 2\"\n        <stdin> -> match 2\n    }\n    \nThis could also be written as:\n\n    function: example { out: \"only match 2\"; <stdin> -> match 2 }\n\n## Detail\n\n`<stdin>` makes use of a feature called **named pipes**, which are a way of\npiping data between processes without chaining them together as a single\ncommand pipeline (eg commands delimited with `|`, `->`, `=>`, `?` tokens).\n\n### What are Murex named pipes?\n\nIn POSIX, there is a concept of STDIN, STDOUT and STDERR, these are FIFO files\nwhile are \"piped\" from one executable to another. ie STDOUT for application 'A'\nwould be the same file as STDIN for application 'B' when A is piped to B:\n`A | B`. Murex adds a another layer around this to enable support for passing\ndata types and builtins which are agnostic to the data serialization format\ntraversing the pipeline. While this does add overhead the advantage is this new\nwrapper can be used as a primitive for channelling any data from one point to\nanother.\n\nMurex named pipes are where these pipes are created in a global store,\ndecoupled from any executing functions, named and can then be used to pass\ndata along asynchronously.\n\nFor example\n\n    pipe: example\n    \n    bg {\n        <example> -> match: Hello\n    }\n    \n    out: \"foobar\"        -> <example>\n    out: \"Hello, world!\" -> <example>\n    out: \"foobar\"        -> <example>\n    \n    !pipe: example\n    \nThis returns `Hello, world!` because `out` is writing to the **example** named\npipe and `match` is also reading from it in the background (`bg`).\n\nNamed pipes can also be inlined into the command parameters with `<>` tags\n\n    pipe: example\n    \n    bg {\n        <example> -> match: Hello\n    }\n    \n    out: <example> \"foobar\"\n    out: <example> \"Hello, world!\"\n    out: <example> \"foobar\"\n    \n    !pipe: example\n    \n> Please note this is also how `test` works.\n\nMurex named pipes can also represent network sockets, files on a disk or any\nother read and/or write endpoint. Custom builtins can also be written in Golang\nto support different abstractions so your Murex code can work with those read\nor write endpoints transparently.\n\nTo see the different supported types run\n\n    runtime --pipes\n    \n### Namespaces and usage in modules and packages\n\nPipes created via `pipe` are created in the global namespace. This allows pipes\nto be used across different functions easily however it does pose a risk with\nname clashes where Murex named pipes are used heavily. Thus is it recommended\nthat pipes created in modules should be prefixed with the name of its package.\n\n## Synonyms\n\n* `<stdin>`\n\n\n## See Also\n\n* [Pipeline](../user-guide/pipeline.md):\n  Overview of what a \"pipeline\" is\n* [`<>` / `read-named-pipe`](../commands/namedpipe.md):\n  Reads from a Murex named pipe\n* [`function`](../commands/function.md):\n  Define a function block\n* [`match`](../commands/match.md):\n  Match an exact value in an array\n* [`out`](../commands/out.md):\n  Print a string to the STDOUT with a trailing new line character\n* [`pipe`](../commands/pipe.md):\n  Manage Murex named pipes\n* [`runtime`](../commands/runtime.md):\n  Returns runtime information on the internal state of Murex"

}
