# What's new in murex v2.2 - Change Log

This is mainly a bug fix release but it does include one breaking change for `config`. Please read for details.

This release sees new optional features plus major bug fixes to the existing
code base:

### Breaking Changes:

One `config` **shell** key has changed it's name:

* spellcheck-block -> `spellcheck-func`

This is to bring spellcheck inline with other keys that contain executable
code.

**This change might break some of your existing profile config!**

### User Facing Changes:

* Windows coreutils no longer returns exit code of 13 for aliases 

* Fixed regression bug in fg (added stronger testing here to prevent future
  regressions)

* Generic data type, `*`, now uses `tabwriter` to align columns

* Spellchecker error handling tweaked to be more user friendly

* Environmental variables can been created per command:

      <pre><code>» env <env:foo=bar> | grep foo
      foo=bar</code></pre>

* stdstream.SetDataType() only works on first call -- ignored thereafter.
  This will impact pipes that are written to by many processes but results
  in more predictable code due possible timing errors where different
  processes are overwriting the stream data type

* stdstream.SetDataType() only works on first call -- ignored thereafter.
  This will impact pipes that are written to by many processes but results
  in more predictable code due possible timing errors where different
  processes are overwriting the stream data type

### Non-User Facing / Maintenance Changes

* All dependencies have been updated, pinned and the `vendors` directory
  rebuilt

* Fixed some issues flagged up in [goreportcard.com](https://goreportcard.com/report/github.com/lmorg/murex)

* Some internal API changes that have no UI/UX ramifications but makes the
  code more maintainable

* Lots more unit tests added

* Lots of code rewritten to avoid potential data races

<hr>

Published: 21.06.2021 at 21:51

## See Also

* [`*` (generic) ](../types/generic.md):
  generic (primitive)
* [`fg`](../commands/fg.md):
  Sends a background process into the foreground