package docs

func init() {

	Definition["="] = "# `=` (arithmetic evaluation) - Command Reference\n\n> Evaluate a mathematical function (deprecated)\n\n## Description\n\n`=` evaluates a mathematical function and returns it's output\n\n**This is a deprecated feature. Please refer to [`expr`](expr.md) instead.**\n\n## Usage\n\n    <stdin> -> = evaluation -> <stdout>\n    \n    = evaluation -> <stdout>\n\n## Examples\n\nAs a method:\n\n    » let: age=18\n    » $age -> = < 21\n    true\n    \n    » $age -> = < 21 -> if { out: \"Under 21\" } else { out: \"Over 21\" }\n    Under 21\n    \nAs a function:\n\n    » let: age=18\n    » = age < 21\n    true\n    \n    » = age < 21 -> if { out: \"Under 21\" } else { out: \"Over 21\" }\n    Under 21\n    \nInlining as a function:\n\n    » let: age=18\n    » if { = age < 21 } then { out: \"Under 21\" } else { out: \"Over 21\" }\n    Under 21\n\n## Detail\n\n### Variables\n\nThere are two ways you can use variables with the math functions. Either by\nstring interpolation like you would normally with any other function, or\ndirectly by name.\n\nString interpolation:\n\n    » set abc=123\n    » = $abc==123\n    true\n    \nDirectly by name:\n\n    » set abc=123\n    » = abc==123\n    false\n    \nTo understand the difference between the two, you must first understand how\nstring interpolation works; which is where the parser tokenised the parameters\nlike so\n\n    command line: = $abc==123\n    token 1: command (name: \"=\")\n    token 2: parameter 1, string (content: \"\")\n    token 3: parameter 1, variable (name: \"abc\")\n    token 4: parameter 1, string (content: \"==123\")\n    \nThen when the command line gets executed, the parameters are compiled on demand\nsimilarly to this crude pseudo-code\n\n    command: \"=\"\n    parameters 1: concatenate(\"\", GetValue(abc), \"==123\")\n    output: \"=\" \"123==123\"\n    \nThus the actual command getting run is literally `123==123` due to the variable\nbeing replace **before** the command executes.\n\nWhereas when you call the variable by name it's up to `=` or `let` to do the\nvariable substitution.\n\n    command line: = abc==123\n    token 1: command (name: \"=\")\n    token 2: parameter 1, string (content: \"abc==123\")\n    \n    command: \"=\"\n    parameters 1: concatenate(\"abc==123\")\n    output: \"=\" \"abc==123\"\n    \nThe main advantage (or disadvantage, depending on your perspective) of using\nvariables this way is that their data-type is preserved.\n\n    » set str abc=123\n    » = abc==123\n    false\n    \n    » set int abc=123\n    » = abc==123\n    true\n    \nUnfortunately is one of the biggest areas in _murex_ where you'd need to be\ncareful. The simple addition or omission of the dollar prefix, `$`, can change\nthe behavior of `=` and `let`.\n\n### Strings\n\nBecause the usual _murex_ tools for encapsulating a string (`\"`, `'` and `()`)\nare interpreted by the shell language parser, it means we need a new token for\nhandling strings inside `=` and `let`. This is where backtick comes to our\nrescue.\n\n    » set str abc=123\n    » = abc==`123`\n    true\n    \nPlease be mindful that if you use string interpolation then you will need to\ninstruct `=` and `let` that your field is a string\n\n    » set str abc=123\n    » = `$abc`==`123`\n    true\n    \n### Best practice recommendation\n\nAs you can see from the sections above, string interpolation offers us some\nconveniences when comparing variables of differing data-types, such as a `str`\ntype with a number (eg `num` or `int`). However it makes for less readable code\nwhen just comparing strings. Thus the recommendation is to avoid using string\ninterpolation except only where it really makes sense (ie use it sparingly).\n\n### Non-boolean logic\n\nThus far the examples given have been focused on comparisons however `=` and\n`let` supports all the usual arithmetic operators:\n\n    » = 10+10\n    20\n    \n    » = 10/10\n    1\n    \n    » = (4 * (3 + 2))\n    20\n    \n    » = `foo`+`bar`\n    foobar\n    \n### Read more\n\n_murex_ uses the [govaluate package](https://github.com/Knetic/govaluate). More information can be found in it's manual.\n\n## Synonyms\n\n* `=`\n\n\n## See Also\n\n* [Reserved Variables](../user-guide/reserved-vars.md):\n  Special variables reserved by _murex_\n* [Variable and Config Scoping](../user-guide/scoping.md):\n  How scoping works within _murex_\n* [`(` (brace quote)](../commands/brace-quote.md):\n  Write a string to the STDOUT without new line\n* [`[[` (element)](../commands/element.md):\n  Outputs an element from a nested structure\n* [`[` (index)](../commands/index.md):\n  Outputs an element from an array, map or table\n* [`export`](../commands/export.md):\n  Define an environmental variable and set it's value\n* [`expr`](../commands/expr.md):\n  Expressions: mathematical, string comparisons, logical operators\n* [`global`](../commands/global.md):\n  Define a global variable and set it's value\n* [`global`](../commands/global.md):\n  Define a global variable and set it's value\n* [`if`](../commands/if.md):\n  Conditional statement to execute different blocks of code depending on the result of the condition\n* [`let`](../commands/let.md):\n  Evaluate a mathematical function and assign to variable (deprecated)\n* [`set`](../commands/set.md):\n  Define a local variable and set it's value"

}
