# _murex_ Change Log

## What's new in murex v2.10

Breaking Changes:

* None

Features:

* Added support for ranges to be used as variables. eg

    <pre><code>f: +f -> set v
    echo: @v[2..]</code></pre>

* Complete re-write of `f`. It is now the tool I had always intended when I first created that builtin

* `g` now supports being run as a method (eg to filter items from a file list)

* `rx` now supports being run as a method (eg to filter items from a file list)

* Updated autocompletes for `git`

* Updated autocompletes for `terraform`

Minor Changes:

* Added support for profiling

* Removed unused data types

* Dropped `profile/` prefix from the module string for modules and profiles (as seen in `FileRef`)

Bug Fixes:

* Lots of improvements to how `||` and `&&` are used in other `runmode`'s, `try`, and `trypipe`

* autoglob prompt now has a mutex wrapped around it to prevent concurrent processes sending the prompt haywire

* Spellchecker no longer underlines partial words

* Better removal of \\x16 and other non-printable characters leaking into readline

<hr>

Published: 01.08.2022 at 20:10

## See Also

* [And (`&&`) Logical Operator](../parser/logical-and.md):
  Continues next operation if previous operation passes
* [FileRef](../user-guide/fileref.md):
  How to track what code was loaded and from where
* [Modules and Packages](../user-guide/modules.md):
  An introduction to _murex_ modules and packages
* [Or (`||`) Logical Operator](../parser/logical-or.md):
  Continues next operation only if previous operation fails
* [Schedulers](../user-guide/schedulers.md):
  Overview of the different schedulers (or 'run modes') in _murex_
* [Spellcheck](../user-guide/spellcheck.md):
  How to enable inline spellchecking
* [_murex_ Profile Files](../user-guide/profile.md):
  A breakdown of the different files loaded on start up
* [`[` (range) ](../commands/range.md):
  Outputs a ranged subset of data from STDIN
* [`autocomplete`](../commands/autocomplete.md):
  Set definitions for tab-completion in the command line
* [`f`](../commands/f.md):
  Lists or filters file system objects (eg files)
* [`g`](../commands/g.md):
  Glob pattern matching for file system objects (eg `*.txt`)
* [`runmode`](../commands/runmode.md):
  Alter the scheduler's behaviour at higher scoping level
* [`rx`](../commands/rx.md):
  Regexp pattern matching for file system objects (eg `.*\\.txt`)
* [`try`](../commands/try.md):
  Handles errors inside a block of code
* [`trypipe`](../commands/trypipe.md):
  Checks state of each function in a pipeline and exits block on error