# _murex_ Shell Docs

## Command Reference: `ja` (mkarray)

> A sophisticated yet simply way to build a JSON array

## Description

_murex_ has a pretty sophisticated builtin for generating JSON arrays.
It works a little bit like Bash's `{1..9}` syntax but includes a few
additional nifty features.

## Usage

    ja: [start..end] -> <stdout>
    ja: [start..end.base] -> <stdout>
    ja: [start..end,start..end] -> <stdout>
    ja: [start..end][start..end] -> <stdout>

## Examples

    » ja: [1..5]
    [
        "1",
        "2",
        "3",
        "4",
        "5"
    ]
    
    » ja: [Monday..Sunday]
    [
        "Monday",
        "Tuesday",
        "Wednesday",
        "Thursday",
        "Friday",
        "Saturday",
        "Sunday"
    ]
    
Please note that as per the first example, all arrays generated by `ja` are
arrays of strings - even if you're command is ranging over integers.

## Detail

Please read the documentation on `a` for a more detailed breakdown on of
`ja`'s supported features.

## See Also

* [commands/`[[` (element)](../commands/element.md):
  Outputs an element from a nested structure
* [commands/`[` (index)](../commands/index.md):
  Outputs an element from an array, map or table
* [commands/`[` (range) ](../commands/range.md):
  Outputs a ranged subset of data from STDIN
* [commands/`a` (mkarray)](../commands/a.md):
  A sophisticated yet simple way to build an array or list
* [commands/`count`](../commands/count.md):
  Count items in a map, list or array
* [types/`json` ](../types/json.md):
  JavaScript Object Notation (JSON) (primitive)
* [commands/`mtac`](../commands/mtac.md):
  Reverse the order of an array
* [commands/`ta` (mkarray)](../commands/ta.md):
  A sophisticated yet simple way to build an array of a user defined data-type