# _murex_ Shell Docs

## User Guide: Pipeline

> Overview of what a "pipeline" is

In the _murex_ docs you'll often see the term "pipeline". This refers to any
commands sequenced together.

A pipeline can be joined via any pipe token (eg `|`, `->`, `=>`, `?`). But,
for the sake of documentation, a pipeline might even be a solitary command.

## Examples

Typical _murex_ pipeline:

    open: example.json -> [[ /node/0 ]]
    
Example of a single command pipeline:

    top
    
Pipeline you might see in Bash / Zsh (this is also valid in _murex_):

    cat names.txt | sort | uniq
    
Pipeline filtering out a specific error from `example-cmd`

    example-cmd ? grep: "File not found"
    
## Detail

A pipeline isn't a _murex_ specific construct but rather something inherited
from Unix. Where _murex_ differs is that it can support sending typed
information to compatible functions (unlike standard Unix pipes which are
dumb-byte streams).

Wikipedia has a page on [Pipeline (Unix)](https://en.wikipedia.org/wiki/Pipeline_(Unix)):

> In Unix-like computer operating systems, a pipeline is a mechanism for
> inter-process communication using message passing. A pipeline is a set of
> processes chained together by their standard streams, so that the output
> text of each process (stdout) is passed directly as input (stdin) to the
> next one. The second process is started as the first process is still
> executing, and they are executed concurrently. The concept of pipelines was
> championed by Douglas McIlroy at Unix's ancestral home of Bell Labs, during
> the development of Unix, shaping its toolbox philosophy. It is named by
> analogy to a physical pipeline. A key feature of these pipelines is their
> "hiding of internals" (Ritchie & Thompson, 1974). This in turn allows for
> more clarity and simplicity in the system. 

## See Also

* [parser/Arrow Pipe (`->`) Token](../parser/pipe-arrow.md):
  Pipes STDOUT from the left hand command to STDIN of the right hand command
* [user-guide/Bang Prefix](../user-guide/bang-prefix.md):
  Bang prefixing to reverse default actions
* [parser/Generic Pipe (`=>`) Token](../parser/pipe-generic.md):
  Pipes a reformatted STDOUT stream from the left hand command to STDIN of the right hand command
* [parser/POSIX Pipe (`|`) Token](../parser/pipe-posix.md):
  Pipes STDOUT from the left hand command to STDIN of the right hand command
* [parser/STDERR Pipe (`?`) Token](../parser/pipe-err.md):
  Pipes STDERR from the left hand command to STDIN of the right hand command
* [user-guide/Schedulers](../user-guide/schedulers.md):
  Overview of the different schedulers (or 'run modes') in _murex_