package docs

func init() {

	Definition["summary"] = "# _murex_ Shell Docs\n\n## Command Reference: `summary` \n\n> Defines a summary help text for a command\n\n## Description\n\n`summary` define help text for a command. This is effectively like a tooltip\nmessage that appears, by default, in blue in the interactive shell.\n\nNormally this text is populated from the `man` pages or `murex-docs`, however\nif neither exist or if you wish to override their text, then you can use\n`summary` to define that text.\n\n## Usage\n\nDefine a commands summary\n\n    summary command description\n    \nUndefine a summary\n\n    !summary command\n\n## Examples\n\nDefine a commands summary\n\n    » summary: foobar \"Hello, world!\"\n    » runtime: --summaries -> [ foobar ]\n    Hello, world! \n    \nUndefine a summary\n\n    » !summary: foobar\n\n## Synonyms\n\n* `summary`\n* `!summary`\n\n\n## See Also\n\n* [commands/`bexists`](../commands/bexists.md):\n  Check which builtins exist\n* [commands/`builtins`](../commands/runtime.md):\n  Returns runtime information on the internal state of _murex_\n* [commands/`config`](../commands/config.md):\n  Query or define _murex_ runtime settings\n* [commands/`exec`](../commands/exec.md):\n  Runs an executable\n* [commands/`fid-list`](../commands/fid-list.md):\n  Lists all running functions within the current _murex_ session\n* [commands/`murex-docs`](../commands/murex-docs.md):\n  Displays the man pages for _murex_ builtins\n* [commands/`murex-update-exe-list`](../commands/murex-update-exe-list.md):\n  Forces _murex_ to rescan $PATH looking for exectables\n* [commands/`runtime`](../commands/runtime.md):\n  Returns runtime information on the internal state of _murex_"

}
