package docs

func init() {

	Definition["left"] = "# _murex_ Shell Docs\n\n## Command Reference: `left`\n\n> Left substring every item in a list\n\n## Description\n\nTakes a list from STDIN and returns a left substring of that same list.\n\nOne parameter is required and that is the number of characters to return. If\nthe parameter is a negative then `left` counts from the right.\n\n## Usage\n\n    <stdin> -> left int -> <stdout>\n\n## Examples\n\nCount from the left\n\n    » ja: [Monday..Wednesday] -> left 2\n    [\n        \"Mo\",\n        \"Tu\",\n        \"We\"\n    ]\n    \nCount from the right\n\n    » ja: [Monday..Wednesday] -> left -3\n    [\n        \"Mon\",\n        \"Tues\",\n        \"Wednes\"\n    ]\n\n## Detail\n\nSupported data types can queried via `runtime`\n\n    runtime: --marshallers\n    runtime: --unmarshallers\n\n## See Also\n\n* [commands/`a` (mkarray)](../commands/a.md):\n  A sophisticated yet simple way to build an array or list\n* [commands/`ja`](../commands/ja.md):\n  A sophisticated yet simply way to build a JSON array\n* [apis/`lang.MarshalData()` (system API)](../apis/lang.MarshalData.md):\n  Converts structured memory into a _murex_ data-type (eg for stdio)\n* [apis/`lang.UnmarshalData()` (system API)](../apis/lang.UnmarshalData.md):\n  Converts a _murex_ data-type into structured memory\n* [commands/`len` ](../commands/len.md):\n  Outputs the length of an array\n* [commands/`prefix`](../commands/prefix.md):\n  Prefix a string to every item in a list\n* [commands/`right`](../commands/right.md):\n  Right substring every item in a list\n* [commands/`runtime`](../commands/runtime.md):\n  Returns runtime information on the internal state of _murex_\n* [commands/`suffix`](../commands/suffix.md):\n  Prefix a string to every item in a list"

}
