package docs

func init() {

	Definition["exec"] = "# _murex_ Shell Docs\n\n## Command Reference: `exec`\n\n> Runs an executable\n\n## Description\n\nWith _murex_, like most other shells, you launch a process by calling the\nname of that executable directly. While this is suitable 99% of the time,\noccasionally you might run into an edge case where that wouldn't work. The\nprimary reason being if you needed to launch a process from a variable, eg\n\n    » set exe=uname\n    » $exe\n    uname\n    \nAs you can see here, _murex_'s behavior here is to output the contents of\nthe variable rather then executing the contents of the variable. This is\ndone for safety reasons, however if you wanted to override that behavior\nthen you could prefix the variable with exec:\n\n    » set exe=uname\n    » exec $exe\n    Linux\n\n## Usage\n\n    <stdin> -> exec\n    <stdin> -> exec -> <stdout>\n               exec -> <stdout>\n\n## Examples\n\n    » exec printf \"Hello, world!\"\n    Hello, world!\n\n## Detail\n\nIf any command doesn't exist as a builtin, function nor alias, then _murex_\nwill default to forking out to any command with this name (subject to an\nabsolute path or the order of precedence in `$PATH`). Any forked process will\nshow up in both the operating systems process viewer (eg `ps`) but also\n_murex_'s own process viewer, `fid-list`. However inside `fid-list` you will\nnotice that all external processes are listed as `exec` with the process name\nas part of `exec`'s parameters. That is because that is literally how _murex_\nhandles any programs that aren't native to _murex_.\n\n## See Also\n\n* [commands/`=` (arithmetic evaluation)](../commands/equ.md):\n  Evaluate a mathematical function\n* [commands/`bexists`](../commands/bexists.md):\n  Check which builtins exist\n* [commands/`bg`](../commands/bg.md):\n  Run processes in the background\n* [commands/`builtins`](../commands/runtime.md):\n  Returns runtime information on the internal state of _murex_\n* [commands/`fg`](../commands/fg.md):\n  Sends a background process into the foreground\n* [commands/`fid-kill`](../commands/fid-kill.md):\n  Terminate a running _murex_ function\n* [commands/`fid-killall`](../commands/fid-killall.md):\n  Terminate _all_ running _murex_ functions\n* [commands/`fid-list`](../commands/fid-list.md):\n  Lists all running functions within the current _murex_ session\n* [commands/`jobs`](../commands/fid-list.md):\n  Lists all running functions within the current _murex_ session\n* [commands/`let`](../commands/let.md):\n  Evaluate a mathematical function and assign to variable\n* [commands/`murex-update-exe-list`](../commands/murex-update-exe-list.md):\n  Forces _murex_ to rescan $PATH looking for exectables\n* [commands/`set`](../commands/set.md):\n  Define a local variable and set it's value"

}
