package main

import (
	"bytes"
	"os"
	"os/exec"
)

const fileName = "test.txt"

func main() {
	// Config git user
	cmd := exec.Command("git", "config", "user.email", "john@doe.com")
	if err := cmd.Run(); err != nil {
		panic(err)
	}
	cmd = exec.Command("git", "config", "user.name", "John Doe")
	if err := cmd.Run(); err != nil {
		panic(err)
	}

	data, err := os.ReadFile(fileName)
	if err != nil {
		panic(err)
	}

	data = bytes.ReplaceAll(data, []byte("apple"), []byte("banana"))
	err = os.WriteFile(fileName, data, 0600)
	if err != nil {
		panic(err)
	}

	cmd = exec.Command("git", "commit", "-am", "Manual commit message 1", "-m", "With a body")
	if err := cmd.Run(); err != nil {
		panic(err)
	}

	data = bytes.ReplaceAll(data, []byte("banana"), []byte("pineapple"))
	err = os.WriteFile(fileName, data, 0600)
	if err != nil {
		panic(err)
	}

	cmd = exec.Command("git", "commit", "-am", "Manual commit message 2")
	if err := cmd.Run(); err != nil {
		panic(err)
	}
}
