package mp4

import (
	"bytes"
	"io/ioutil"
	"testing"

	"github.com/Eyevinn/mp4ff/bits"
)

// Test decode + encode file with slice reader and writer
func TestDecodeEncodeSRW(t *testing.T) {
	testFiles := []string{
		"testdata/1.m4s",
		"testdata/prog_8s_enc_dashinit.mp4",
		"testdata/prog_8s.mp4",
	}
	for _, testFile := range testFiles {

		inData, err := ioutil.ReadFile(testFile)
		if err != nil {
			t.Error(err)
		}
		sr := bits.NewFixedSliceReader(inData)
		decFile, err := DecodeFileSR(sr)
		if err != nil {
			t.Error(err)
		}
		decFile.FragEncMode = EncModeBoxTree
		sw := bits.NewFixedSliceWriter(len(inData))
		err = decFile.EncodeSW(sw)
		if err != nil {
			t.Error(err)
		}
		if !bytes.Equal(inData, sw.Bytes()) {
			t.Errorf("mismatch for testfile %s. Generated bytes differ from input", testFile)
		}
	}
}
