#!/bin/sh

(
cat <<EOF
/*
Command mox is a modern full-featured open source secure mail server for
low-maintenance self-hosted email.

  - Quick and easy to set up with quickstart and automatic TLS with ACME and
    Let's Encrypt.
  - IMAP4 with extensions for accessing email.
  - SMTP with SPF, DKIM, DMARC, DNSBL, MTA-STS, TLSRPT for exchanging email.
  - Reputation-based and content-based spam filtering.
  - Internationalized email.
  - Admin web interface.

# Commands

EOF

./mox 2>&1 | sed 's/^\( *\|usage: \)/\t/'

cat <<EOF

Many commands talk to a running mox instance, through the ctl file in the data
directory. Specify the configuration file (that holds the path to the data
directory) through the -config flag or MOXCONF environment variable.

EOF

./mox helpall 2>&1

cat <<EOF
*/
package main

// NOTE: DO NOT EDIT, this file is generated by gendoc.sh.
EOF
)>doc.go
gofmt -w doc.go

(
cat <<EOF
/*
Package config holds the configuration file definitions for mox.conf (Static)
and domains.conf (Dynamic).

Annotated empty/default configuration files you could use as a starting point
for your mox.conf and domains.conf, as generated by "mox config
describe-static" and "mox config describe-domains":

# mox.conf

EOF
./mox config describe-static | sed 's/^/\t/'

cat <<EOF

# domains.conf

EOF
./mox config describe-domains | sed 's/^/\t/'

cat <<EOF
*/
package config

// NOTE: DO NOT EDIT, this file is generated by ../gendoc.sh.
EOF
)>config/doc.go
gofmt -w config/doc.go
