// Code generated by gocc; DO NOT EDIT.

package lexer

import (
	"io/ioutil"
	"unicode/utf8"

	"github.com/johnkerl/miller/internal/pkg/parsing/token"
)

const (
	NoState    = -1
	NumStates  = 328
	NumSymbols = 634
)

type Lexer struct {
	src     []byte
	pos     int
	line    int
	column  int
	Context token.Context
}

func NewLexer(src []byte) *Lexer {
	lexer := &Lexer{
		src:     src,
		pos:     0,
		line:    1,
		column:  1,
		Context: nil,
	}
	return lexer
}

// SourceContext is a simple instance of a token.Context which
// contains the name of the source file.
type SourceContext struct {
	Filepath string
}

func (s *SourceContext) Source() string {
	return s.Filepath
}

func NewLexerFile(fpath string) (*Lexer, error) {
	src, err := ioutil.ReadFile(fpath)
	if err != nil {
		return nil, err
	}
	lexer := NewLexer(src)
	lexer.Context = &SourceContext{Filepath: fpath}
	return lexer, nil
}

func (l *Lexer) Scan() (tok *token.Token) {
	tok = &token.Token{}
	if l.pos >= len(l.src) {
		tok.Type = token.EOF
		tok.Pos.Offset, tok.Pos.Line, tok.Pos.Column = l.pos, l.line, l.column
		tok.Pos.Context = l.Context
		return
	}
	start, startLine, startColumn, end := l.pos, l.line, l.column, 0
	tok.Type = token.INVALID
	state, rune1, size := 0, rune(-1), 0
	for state != -1 {
		if l.pos >= len(l.src) {
			rune1 = -1
		} else {
			rune1, size = utf8.DecodeRune(l.src[l.pos:])
			l.pos += size
		}

		nextState := -1
		if rune1 != -1 {
			nextState = TransTab[state](rune1)
		}
		state = nextState

		if state != -1 {

			switch rune1 {
			case '\n':
				l.line++
				l.column = 1
			case '\r':
				l.column = 1
			case '\t':
				l.column += 4
			default:
				l.column++
			}

			switch {
			case ActTab[state].Accept != -1:
				tok.Type = ActTab[state].Accept
				end = l.pos
			case ActTab[state].Ignore != "":
				start, startLine, startColumn = l.pos, l.line, l.column
				state = 0
				if start >= len(l.src) {
					tok.Type = token.EOF
				}

			}
		} else {
			if tok.Type == token.INVALID {
				end = l.pos
			}
		}
	}
	if end > start {
		l.pos = end
		tok.Lit = l.src[start:end]
	} else {
		tok.Lit = []byte{}
	}
	tok.Pos.Offset, tok.Pos.Line, tok.Pos.Column = start, startLine, startColumn
	tok.Pos.Context = l.Context

	return
}

func (l *Lexer) Reset() {
	l.pos = 0
}

/*
Lexer symbols:
0: '"'
1: '"'
2: '"'
3: '"'
4: 'i'
5: '0'
6: 'x'
7: '0'
8: 'o'
9: '0'
10: 'b'
11: '.'
12: '.'
13: '-'
14: '.'
15: '.'
16: '-'
17: '.'
18: '.'
19: '-'
20: 'M'
21: '_'
22: 'P'
23: 'I'
24: 'M'
25: '_'
26: 'E'
27: 'n'
28: 'u'
29: 'l'
30: 'l'
31: 'I'
32: 'n'
33: 'f'
34: 'N'
35: 'a'
36: 'N'
37: 'I'
38: 'P'
39: 'S'
40: 'I'
41: 'F'
42: 'S'
43: 'I'
44: 'R'
45: 'S'
46: 'O'
47: 'P'
48: 'S'
49: 'O'
50: 'F'
51: 'S'
52: 'O'
53: 'R'
54: 'S'
55: 'F'
56: 'L'
57: 'A'
58: 'T'
59: 'S'
60: 'E'
61: 'P'
62: 'N'
63: 'F'
64: 'N'
65: 'R'
66: 'F'
67: 'N'
68: 'R'
69: 'F'
70: 'I'
71: 'L'
72: 'E'
73: 'N'
74: 'A'
75: 'M'
76: 'E'
77: 'F'
78: 'I'
79: 'L'
80: 'E'
81: 'N'
82: 'U'
83: 'M'
84: 'E'
85: 'N'
86: 'V'
87: 'b'
88: 'e'
89: 'g'
90: 'i'
91: 'n'
92: 'd'
93: 'o'
94: 'e'
95: 'l'
96: 'i'
97: 'f'
98: 'e'
99: 'l'
100: 's'
101: 'e'
102: 'e'
103: 'n'
104: 'd'
105: 'f'
106: 'i'
107: 'l'
108: 't'
109: 'e'
110: 'r'
111: 'f'
112: 'o'
113: 'r'
114: 'i'
115: 'f'
116: 'i'
117: 'n'
118: 'w'
119: 'h'
120: 'i'
121: 'l'
122: 'e'
123: 'b'
124: 'r'
125: 'e'
126: 'a'
127: 'k'
128: 'c'
129: 'o'
130: 'n'
131: 't'
132: 'i'
133: 'n'
134: 'u'
135: 'e'
136: 'r'
137: 'e'
138: 't'
139: 'u'
140: 'r'
141: 'n'
142: 'f'
143: 'u'
144: 'n'
145: 'c'
146: 's'
147: 'u'
148: 'b'
149: 'r'
150: 'c'
151: 'a'
152: 'l'
153: 'l'
154: 'a'
155: 'r'
156: 'r'
157: 'b'
158: 'o'
159: 'o'
160: 'l'
161: 'f'
162: 'l'
163: 'o'
164: 'a'
165: 't'
166: 'i'
167: 'n'
168: 't'
169: 'm'
170: 'a'
171: 'p'
172: 'n'
173: 'u'
174: 'm'
175: 's'
176: 't'
177: 'r'
178: 'v'
179: 'a'
180: 'r'
181: 'f'
182: 'u'
183: 'n'
184: 'c'
185: 't'
186: 'u'
187: 'n'
188: 's'
189: 'e'
190: 't'
191: 'd'
192: 'u'
193: 'm'
194: 'p'
195: 'e'
196: 'd'
197: 'u'
198: 'm'
199: 'p'
200: 'e'
201: 'm'
202: 'i'
203: 't'
204: '1'
205: 'e'
206: 'm'
207: 'i'
208: 't'
209: 'e'
210: 'm'
211: 'i'
212: 't'
213: 'p'
214: 'e'
215: 'm'
216: 'i'
217: 't'
218: 'f'
219: 'e'
220: 'p'
221: 'r'
222: 'i'
223: 'n'
224: 't'
225: 'e'
226: 'p'
227: 'r'
228: 'i'
229: 'n'
230: 't'
231: 'n'
232: 'p'
233: 'r'
234: 'i'
235: 'n'
236: 't'
237: 'p'
238: 'r'
239: 'i'
240: 'n'
241: 't'
242: 'n'
243: 't'
244: 'e'
245: 'e'
246: 's'
247: 't'
248: 'd'
249: 'o'
250: 'u'
251: 't'
252: 's'
253: 't'
254: 'd'
255: 'e'
256: 'r'
257: 'r'
258: '$'
259: '$'
260: '{'
261: '}'
262: '$'
263: '*'
264: '@'
265: '@'
266: '{'
267: '}'
268: '@'
269: '*'
270: 'a'
271: 'l'
272: 'l'
273: '%'
274: '%'
275: '%'
276: 'p'
277: 'a'
278: 'n'
279: 'i'
280: 'c'
281: '%'
282: '%'
283: '%'
284: ';'
285: '{'
286: '}'
287: '='
288: '>'
289: '>'
290: '>'
291: '|'
292: ','
293: '('
294: ')'
295: '$'
296: '['
297: ']'
298: '$'
299: '['
300: '['
301: '$'
302: '['
303: '['
304: '['
305: '@'
306: '['
307: '|'
308: '|'
309: '='
310: '^'
311: '^'
312: '='
313: '&'
314: '&'
315: '='
316: '?'
317: '?'
318: '='
319: '?'
320: '?'
321: '?'
322: '='
323: '|'
324: '='
325: '&'
326: '='
327: '^'
328: '='
329: '<'
330: '<'
331: '='
332: '>'
333: '>'
334: '='
335: '>'
336: '>'
337: '>'
338: '='
339: '+'
340: '='
341: '.'
342: '='
343: '-'
344: '='
345: '*'
346: '='
347: '/'
348: '='
349: '/'
350: '/'
351: '='
352: '%'
353: '='
354: '*'
355: '*'
356: '='
357: '?'
358: ':'
359: '|'
360: '|'
361: '^'
362: '^'
363: '&'
364: '&'
365: '?'
366: '?'
367: '?'
368: '?'
369: '?'
370: '='
371: '~'
372: '!'
373: '='
374: '~'
375: '='
376: '='
377: '!'
378: '='
379: '<'
380: '='
381: '>'
382: '>'
383: '='
384: '<'
385: '<'
386: '='
387: '^'
388: '&'
389: '<'
390: '<'
391: '>'
392: '>'
393: '>'
394: '+'
395: '-'
396: '.'
397: '+'
398: '.'
399: '-'
400: '*'
401: '/'
402: '/'
403: '/'
404: '%'
405: '.'
406: '*'
407: '.'
408: '/'
409: '.'
410: '/'
411: '/'
412: '.'
413: '!'
414: '~'
415: '*'
416: '*'
417: '['
418: '['
419: '['
420: '['
421: '['
422: '['
423: '_'
424: '_'
425: ' '
426: '!'
427: '#'
428: '$'
429: '%'
430: '&'
431: '''
432: '\'
433: '('
434: ')'
435: '*'
436: '+'
437: ','
438: '-'
439: '.'
440: '/'
441: ':'
442: ';'
443: '<'
444: '='
445: '>'
446: '?'
447: '@'
448: '['
449: ']'
450: '^'
451: '_'
452: '`'
453: '{'
454: '|'
455: '}'
456: '~'
457: '\'
458: '\'
459: '\'
460: '"'
461: '\'
462: '['
463: '\'
464: ']'
465: '\'
466: '.'
467: '\'
468: '*'
469: '\'
470: '%'
471: '\'
472: 'A'
473: '\'
474: 'B'
475: '\'
476: 'C'
477: '\'
478: 'D'
479: '\'
480: 'G'
481: '\'
482: 'H'
483: '\'
484: 'K'
485: '\'
486: 'L'
487: '\'
488: 'N'
489: '\'
490: 'P'
491: '\'
492: 'R'
493: '\'
494: 'S'
495: '\'
496: 'U'
497: '\'
498: 'V'
499: '\'
500: 'W'
501: '\'
502: 'X'
503: '\'
504: 'Z'
505: '\'
506: 'a'
507: '\'
508: 'b'
509: '\'
510: 'c'
511: '\'
512: 'd'
513: '\'
514: 'f'
515: '\'
516: 'g'
517: '\'
518: 'h'
519: '\'
520: 'k'
521: '\'
522: 'l'
523: '\'
524: 'n'
525: '\'
526: 'p'
527: '\'
528: 'r'
529: '\'
530: 's'
531: '\'
532: 't'
533: '\'
534: 'u'
535: '\'
536: 'v'
537: '\'
538: 'w'
539: '\'
540: 'x'
541: '\'
542: 'z'
543: '\'
544: '0'
545: '\'
546: '1'
547: '\'
548: '2'
549: '\'
550: '3'
551: '\'
552: '4'
553: '\'
554: '5'
555: '\'
556: '6'
557: '\'
558: '7'
559: '\'
560: '8'
561: '\'
562: '9'
563: 'e'
564: 'E'
565: 't'
566: 'r'
567: 'u'
568: 'e'
569: 'f'
570: 'a'
571: 'l'
572: 's'
573: 'e'
574: ' '
575: '!'
576: '#'
577: '$'
578: '%'
579: '&'
580: '''
581: '\'
582: '('
583: ')'
584: '*'
585: '+'
586: ','
587: '-'
588: '.'
589: '/'
590: ':'
591: ';'
592: '<'
593: '='
594: '>'
595: '?'
596: '@'
597: '['
598: ']'
599: '^'
600: '_'
601: '`'
602: '|'
603: '~'
604: '\'
605: '{'
606: '\'
607: '}'
608: ' '
609: '\t'
610: '\n'
611: '\r'
612: '#'
613: '\n'
614: 'a'-'z'
615: 'A'-'Z'
616: \u00a0-\u00ff
617: \u0100-\U0010ffff
618: '0'-'9'
619: '0'-'9'
620: 'a'-'f'
621: 'A'-'F'
622: '0'-'7'
623: '0'-'1'
624: 'A'-'Z'
625: 'a'-'z'
626: '0'-'9'
627: \u00a0-\u00ff
628: \u0100-\U0010ffff
629: 'A'-'Z'
630: 'a'-'z'
631: '0'-'9'
632: \u0100-\U0010ffff
633: .
*/
