package handlers

import (
	"encoding/hex"
	"testing"
)

func Test_BlankPNG(t *testing.T) {
	tests := []struct {
		tilesize uint32
		data     string
	}{
		{
			// tilesize not detected, defaults to 256
			tilesize: 0, data: "89504e470d0a1a0a0000000d494844520000010000000100010300000066bc3a2500000003504c5445000000a77a3dda0000000174524e530040e6d8660000001f4944415468deedc1010d000000c220fba736c737600000000000000000710721000001a75729d70000000049454e44ae426082",
		},
		{
			// not available, defaults to 256
			tilesize: 128, data: "89504e470d0a1a0a0000000d494844520000010000000100010300000066bc3a2500000003504c5445000000a77a3dda0000000174524e530040e6d8660000001f4944415468deedc1010d000000c220fba736c737600000000000000000710721000001a75729d70000000049454e44ae426082",
		},
		{
			tilesize: 256, data: "89504e470d0a1a0a0000000d494844520000010000000100010300000066bc3a2500000003504c5445000000a77a3dda0000000174524e530040e6d8660000001f4944415468deedc1010d000000c220fba736c737600000000000000000710721000001a75729d70000000049454e44ae426082",
		},
		{
			tilesize: 512, data: "89504e470d0a1a0a0000000d4948445200000200000002000103000000ceb646b900000003504c5445000000a77a3dda0000000174524e530040e6d866000000364944415478daedc1010100000082a0feaf6e88c00000000000000000000000000000000000000000000000000000000000000000e20e8200000101f5375e0000000049454e44ae426082",
		},
	}

	for _, tc := range tests {
		blankPNG := hex.EncodeToString(BlankPNG(tc.tilesize))
		if blankPNG != tc.data {
			t.Error("BlankPNG returned unexpected value for size ", tc.tilesize, " :", blankPNG)
		}
	}
}
