// Code generated by msgraph.go/gen DO NOT EDIT.

package msgraph

import (
	"context"
	"fmt"
	"io/ioutil"
	"net/http"

	"github.com/yaegashi/msgraph.go/jsonx"
)

// UserAssignLicenseRequestParameter undocumented
type UserAssignLicenseRequestParameter struct {
	// AddLicenses undocumented
	AddLicenses []AssignedLicense `json:"addLicenses,omitempty"`
	// RemoveLicenses undocumented
	RemoveLicenses []UUID `json:"removeLicenses,omitempty"`
}

// UserChangePasswordRequestParameter undocumented
type UserChangePasswordRequestParameter struct {
	// CurrentPassword undocumented
	CurrentPassword *string `json:"currentPassword,omitempty"`
	// NewPassword undocumented
	NewPassword *string `json:"newPassword,omitempty"`
}

// UserInvalidateAllRefreshTokensRequestParameter undocumented
type UserInvalidateAllRefreshTokensRequestParameter struct {
}

// UserRevokeSignInSessionsRequestParameter undocumented
type UserRevokeSignInSessionsRequestParameter struct {
}

// UserReprocessLicenseAssignmentRequestParameter undocumented
type UserReprocessLicenseAssignmentRequestParameter struct {
}

// UserFindMeetingTimesRequestParameter undocumented
type UserFindMeetingTimesRequestParameter struct {
	// Attendees undocumented
	Attendees []AttendeeBase `json:"attendees,omitempty"`
	// LocationConstraint undocumented
	LocationConstraint *LocationConstraint `json:"locationConstraint,omitempty"`
	// TimeConstraint undocumented
	TimeConstraint *TimeConstraint `json:"timeConstraint,omitempty"`
	// MeetingDuration undocumented
	MeetingDuration *Duration `json:"meetingDuration,omitempty"`
	// MaxCandidates undocumented
	MaxCandidates *int `json:"maxCandidates,omitempty"`
	// IsOrganizerOptional undocumented
	IsOrganizerOptional *bool `json:"isOrganizerOptional,omitempty"`
	// ReturnSuggestionReasons undocumented
	ReturnSuggestionReasons *bool `json:"returnSuggestionReasons,omitempty"`
	// MinimumAttendeePercentage undocumented
	MinimumAttendeePercentage *float64 `json:"minimumAttendeePercentage,omitempty"`
}

// UserSendMailRequestParameter undocumented
type UserSendMailRequestParameter struct {
	// Message undocumented
	Message *Message `json:"Message,omitempty"`
	// SaveToSentItems undocumented
	SaveToSentItems *bool `json:"SaveToSentItems,omitempty"`
}

// UserGetMailTipsRequestParameter undocumented
type UserGetMailTipsRequestParameter struct {
	// EmailAddresses undocumented
	EmailAddresses []string `json:"EmailAddresses,omitempty"`
	// MailTipsOptions undocumented
	MailTipsOptions *MailTipsType `json:"MailTipsOptions,omitempty"`
}

// UserTranslateExchangeIDsRequestParameter undocumented
type UserTranslateExchangeIDsRequestParameter struct {
	// InputIDs undocumented
	InputIDs []string `json:"InputIds,omitempty"`
	// TargetIDType undocumented
	TargetIDType *ExchangeIDFormat `json:"TargetIdType,omitempty"`
	// SourceIDType undocumented
	SourceIDType *ExchangeIDFormat `json:"SourceIdType,omitempty"`
}

// UserRemoveAllDevicesFromManagementRequestParameter undocumented
type UserRemoveAllDevicesFromManagementRequestParameter struct {
}

// UserWipeManagedAppRegistrationByDeviceTagRequestParameter undocumented
type UserWipeManagedAppRegistrationByDeviceTagRequestParameter struct {
	// DeviceTag undocumented
	DeviceTag *string `json:"deviceTag,omitempty"`
}

// UserWipeManagedAppRegistrationsByDeviceTagRequestParameter undocumented
type UserWipeManagedAppRegistrationsByDeviceTagRequestParameter struct {
	// DeviceTag undocumented
	DeviceTag *string `json:"deviceTag,omitempty"`
}

// UserExportPersonalDataRequestParameter undocumented
type UserExportPersonalDataRequestParameter struct {
	// StorageLocation undocumented
	StorageLocation *string `json:"storageLocation,omitempty"`
}

// Activities returns request builder for UserActivity collection
func (b *UserRequestBuilder) Activities() *UserActivitiesCollectionRequestBuilder {
	bb := &UserActivitiesCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/activities"
	return bb
}

// UserActivitiesCollectionRequestBuilder is request builder for UserActivity collection
type UserActivitiesCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for UserActivity collection
func (b *UserActivitiesCollectionRequestBuilder) Request() *UserActivitiesCollectionRequest {
	return &UserActivitiesCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for UserActivity item
func (b *UserActivitiesCollectionRequestBuilder) ID(id string) *UserActivityRequestBuilder {
	bb := &UserActivityRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// UserActivitiesCollectionRequest is request for UserActivity collection
type UserActivitiesCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for UserActivity collection
func (r *UserActivitiesCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]UserActivity, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []UserActivity
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []UserActivity
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for UserActivity collection, max N pages
func (r *UserActivitiesCollectionRequest) GetN(ctx context.Context, n int) ([]UserActivity, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for UserActivity collection
func (r *UserActivitiesCollectionRequest) Get(ctx context.Context) ([]UserActivity, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for UserActivity collection
func (r *UserActivitiesCollectionRequest) Add(ctx context.Context, reqObj *UserActivity) (resObj *UserActivity, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// AgreementAcceptances returns request builder for AgreementAcceptance collection
func (b *UserRequestBuilder) AgreementAcceptances() *UserAgreementAcceptancesCollectionRequestBuilder {
	bb := &UserAgreementAcceptancesCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/agreementAcceptances"
	return bb
}

// UserAgreementAcceptancesCollectionRequestBuilder is request builder for AgreementAcceptance collection
type UserAgreementAcceptancesCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for AgreementAcceptance collection
func (b *UserAgreementAcceptancesCollectionRequestBuilder) Request() *UserAgreementAcceptancesCollectionRequest {
	return &UserAgreementAcceptancesCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for AgreementAcceptance item
func (b *UserAgreementAcceptancesCollectionRequestBuilder) ID(id string) *AgreementAcceptanceRequestBuilder {
	bb := &AgreementAcceptanceRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// UserAgreementAcceptancesCollectionRequest is request for AgreementAcceptance collection
type UserAgreementAcceptancesCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for AgreementAcceptance collection
func (r *UserAgreementAcceptancesCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]AgreementAcceptance, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []AgreementAcceptance
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []AgreementAcceptance
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for AgreementAcceptance collection, max N pages
func (r *UserAgreementAcceptancesCollectionRequest) GetN(ctx context.Context, n int) ([]AgreementAcceptance, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for AgreementAcceptance collection
func (r *UserAgreementAcceptancesCollectionRequest) Get(ctx context.Context) ([]AgreementAcceptance, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for AgreementAcceptance collection
func (r *UserAgreementAcceptancesCollectionRequest) Add(ctx context.Context, reqObj *AgreementAcceptance) (resObj *AgreementAcceptance, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// Analytics is navigation property
func (b *UserRequestBuilder) Analytics() *UserAnalyticsRequestBuilder {
	bb := &UserAnalyticsRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/analytics"
	return bb
}

// AppRoleAssignments returns request builder for AppRoleAssignment collection
func (b *UserRequestBuilder) AppRoleAssignments() *UserAppRoleAssignmentsCollectionRequestBuilder {
	bb := &UserAppRoleAssignmentsCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/appRoleAssignments"
	return bb
}

// UserAppRoleAssignmentsCollectionRequestBuilder is request builder for AppRoleAssignment collection
type UserAppRoleAssignmentsCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for AppRoleAssignment collection
func (b *UserAppRoleAssignmentsCollectionRequestBuilder) Request() *UserAppRoleAssignmentsCollectionRequest {
	return &UserAppRoleAssignmentsCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for AppRoleAssignment item
func (b *UserAppRoleAssignmentsCollectionRequestBuilder) ID(id string) *AppRoleAssignmentRequestBuilder {
	bb := &AppRoleAssignmentRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// UserAppRoleAssignmentsCollectionRequest is request for AppRoleAssignment collection
type UserAppRoleAssignmentsCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for AppRoleAssignment collection
func (r *UserAppRoleAssignmentsCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]AppRoleAssignment, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []AppRoleAssignment
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []AppRoleAssignment
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for AppRoleAssignment collection, max N pages
func (r *UserAppRoleAssignmentsCollectionRequest) GetN(ctx context.Context, n int) ([]AppRoleAssignment, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for AppRoleAssignment collection
func (r *UserAppRoleAssignmentsCollectionRequest) Get(ctx context.Context) ([]AppRoleAssignment, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for AppRoleAssignment collection
func (r *UserAppRoleAssignmentsCollectionRequest) Add(ctx context.Context, reqObj *AppRoleAssignment) (resObj *AppRoleAssignment, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// Calendar is navigation property
func (b *UserRequestBuilder) Calendar() *CalendarRequestBuilder {
	bb := &CalendarRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/calendar"
	return bb
}

// CalendarGroups returns request builder for CalendarGroup collection
func (b *UserRequestBuilder) CalendarGroups() *UserCalendarGroupsCollectionRequestBuilder {
	bb := &UserCalendarGroupsCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/calendarGroups"
	return bb
}

// UserCalendarGroupsCollectionRequestBuilder is request builder for CalendarGroup collection
type UserCalendarGroupsCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for CalendarGroup collection
func (b *UserCalendarGroupsCollectionRequestBuilder) Request() *UserCalendarGroupsCollectionRequest {
	return &UserCalendarGroupsCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for CalendarGroup item
func (b *UserCalendarGroupsCollectionRequestBuilder) ID(id string) *CalendarGroupRequestBuilder {
	bb := &CalendarGroupRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// UserCalendarGroupsCollectionRequest is request for CalendarGroup collection
type UserCalendarGroupsCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for CalendarGroup collection
func (r *UserCalendarGroupsCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]CalendarGroup, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []CalendarGroup
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []CalendarGroup
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for CalendarGroup collection, max N pages
func (r *UserCalendarGroupsCollectionRequest) GetN(ctx context.Context, n int) ([]CalendarGroup, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for CalendarGroup collection
func (r *UserCalendarGroupsCollectionRequest) Get(ctx context.Context) ([]CalendarGroup, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for CalendarGroup collection
func (r *UserCalendarGroupsCollectionRequest) Add(ctx context.Context, reqObj *CalendarGroup) (resObj *CalendarGroup, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// CalendarView returns request builder for Event collection
func (b *UserRequestBuilder) CalendarView() *UserCalendarViewCollectionRequestBuilder {
	bb := &UserCalendarViewCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/calendarView"
	return bb
}

// UserCalendarViewCollectionRequestBuilder is request builder for Event collection
type UserCalendarViewCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for Event collection
func (b *UserCalendarViewCollectionRequestBuilder) Request() *UserCalendarViewCollectionRequest {
	return &UserCalendarViewCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for Event item
func (b *UserCalendarViewCollectionRequestBuilder) ID(id string) *EventRequestBuilder {
	bb := &EventRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// UserCalendarViewCollectionRequest is request for Event collection
type UserCalendarViewCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for Event collection
func (r *UserCalendarViewCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]Event, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []Event
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []Event
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for Event collection, max N pages
func (r *UserCalendarViewCollectionRequest) GetN(ctx context.Context, n int) ([]Event, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for Event collection
func (r *UserCalendarViewCollectionRequest) Get(ctx context.Context) ([]Event, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for Event collection
func (r *UserCalendarViewCollectionRequest) Add(ctx context.Context, reqObj *Event) (resObj *Event, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// Calendars returns request builder for Calendar collection
func (b *UserRequestBuilder) Calendars() *UserCalendarsCollectionRequestBuilder {
	bb := &UserCalendarsCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/calendars"
	return bb
}

// UserCalendarsCollectionRequestBuilder is request builder for Calendar collection
type UserCalendarsCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for Calendar collection
func (b *UserCalendarsCollectionRequestBuilder) Request() *UserCalendarsCollectionRequest {
	return &UserCalendarsCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for Calendar item
func (b *UserCalendarsCollectionRequestBuilder) ID(id string) *CalendarRequestBuilder {
	bb := &CalendarRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// UserCalendarsCollectionRequest is request for Calendar collection
type UserCalendarsCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for Calendar collection
func (r *UserCalendarsCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]Calendar, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []Calendar
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []Calendar
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for Calendar collection, max N pages
func (r *UserCalendarsCollectionRequest) GetN(ctx context.Context, n int) ([]Calendar, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for Calendar collection
func (r *UserCalendarsCollectionRequest) Get(ctx context.Context) ([]Calendar, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for Calendar collection
func (r *UserCalendarsCollectionRequest) Add(ctx context.Context, reqObj *Calendar) (resObj *Calendar, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// Chats returns request builder for Chat collection
func (b *UserRequestBuilder) Chats() *UserChatsCollectionRequestBuilder {
	bb := &UserChatsCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/chats"
	return bb
}

// UserChatsCollectionRequestBuilder is request builder for Chat collection
type UserChatsCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for Chat collection
func (b *UserChatsCollectionRequestBuilder) Request() *UserChatsCollectionRequest {
	return &UserChatsCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for Chat item
func (b *UserChatsCollectionRequestBuilder) ID(id string) *ChatRequestBuilder {
	bb := &ChatRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// UserChatsCollectionRequest is request for Chat collection
type UserChatsCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for Chat collection
func (r *UserChatsCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]Chat, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []Chat
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []Chat
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for Chat collection, max N pages
func (r *UserChatsCollectionRequest) GetN(ctx context.Context, n int) ([]Chat, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for Chat collection
func (r *UserChatsCollectionRequest) Get(ctx context.Context) ([]Chat, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for Chat collection
func (r *UserChatsCollectionRequest) Add(ctx context.Context, reqObj *Chat) (resObj *Chat, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// ContactFolders returns request builder for ContactFolder collection
func (b *UserRequestBuilder) ContactFolders() *UserContactFoldersCollectionRequestBuilder {
	bb := &UserContactFoldersCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/contactFolders"
	return bb
}

// UserContactFoldersCollectionRequestBuilder is request builder for ContactFolder collection
type UserContactFoldersCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for ContactFolder collection
func (b *UserContactFoldersCollectionRequestBuilder) Request() *UserContactFoldersCollectionRequest {
	return &UserContactFoldersCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for ContactFolder item
func (b *UserContactFoldersCollectionRequestBuilder) ID(id string) *ContactFolderRequestBuilder {
	bb := &ContactFolderRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// UserContactFoldersCollectionRequest is request for ContactFolder collection
type UserContactFoldersCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for ContactFolder collection
func (r *UserContactFoldersCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]ContactFolder, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []ContactFolder
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []ContactFolder
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for ContactFolder collection, max N pages
func (r *UserContactFoldersCollectionRequest) GetN(ctx context.Context, n int) ([]ContactFolder, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for ContactFolder collection
func (r *UserContactFoldersCollectionRequest) Get(ctx context.Context) ([]ContactFolder, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for ContactFolder collection
func (r *UserContactFoldersCollectionRequest) Add(ctx context.Context, reqObj *ContactFolder) (resObj *ContactFolder, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// Contacts returns request builder for Contact collection
func (b *UserRequestBuilder) Contacts() *UserContactsCollectionRequestBuilder {
	bb := &UserContactsCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/contacts"
	return bb
}

// UserContactsCollectionRequestBuilder is request builder for Contact collection
type UserContactsCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for Contact collection
func (b *UserContactsCollectionRequestBuilder) Request() *UserContactsCollectionRequest {
	return &UserContactsCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for Contact item
func (b *UserContactsCollectionRequestBuilder) ID(id string) *ContactRequestBuilder {
	bb := &ContactRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// UserContactsCollectionRequest is request for Contact collection
type UserContactsCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for Contact collection
func (r *UserContactsCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]Contact, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []Contact
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []Contact
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for Contact collection, max N pages
func (r *UserContactsCollectionRequest) GetN(ctx context.Context, n int) ([]Contact, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for Contact collection
func (r *UserContactsCollectionRequest) Get(ctx context.Context) ([]Contact, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for Contact collection
func (r *UserContactsCollectionRequest) Add(ctx context.Context, reqObj *Contact) (resObj *Contact, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// CreatedObjects returns request builder for DirectoryObject collection
func (b *UserRequestBuilder) CreatedObjects() *UserCreatedObjectsCollectionRequestBuilder {
	bb := &UserCreatedObjectsCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/createdObjects"
	return bb
}

// UserCreatedObjectsCollectionRequestBuilder is request builder for DirectoryObject collection
type UserCreatedObjectsCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for DirectoryObject collection
func (b *UserCreatedObjectsCollectionRequestBuilder) Request() *UserCreatedObjectsCollectionRequest {
	return &UserCreatedObjectsCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for DirectoryObject item
func (b *UserCreatedObjectsCollectionRequestBuilder) ID(id string) *DirectoryObjectRequestBuilder {
	bb := &DirectoryObjectRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// UserCreatedObjectsCollectionRequest is request for DirectoryObject collection
type UserCreatedObjectsCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for DirectoryObject collection
func (r *UserCreatedObjectsCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]DirectoryObject, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []DirectoryObject
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []DirectoryObject
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for DirectoryObject collection, max N pages
func (r *UserCreatedObjectsCollectionRequest) GetN(ctx context.Context, n int) ([]DirectoryObject, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for DirectoryObject collection
func (r *UserCreatedObjectsCollectionRequest) Get(ctx context.Context) ([]DirectoryObject, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for DirectoryObject collection
func (r *UserCreatedObjectsCollectionRequest) Add(ctx context.Context, reqObj *DirectoryObject) (resObj *DirectoryObject, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// DeviceEnrollmentConfigurations returns request builder for DeviceEnrollmentConfiguration collection
func (b *UserRequestBuilder) DeviceEnrollmentConfigurations() *UserDeviceEnrollmentConfigurationsCollectionRequestBuilder {
	bb := &UserDeviceEnrollmentConfigurationsCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/deviceEnrollmentConfigurations"
	return bb
}

// UserDeviceEnrollmentConfigurationsCollectionRequestBuilder is request builder for DeviceEnrollmentConfiguration collection
type UserDeviceEnrollmentConfigurationsCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for DeviceEnrollmentConfiguration collection
func (b *UserDeviceEnrollmentConfigurationsCollectionRequestBuilder) Request() *UserDeviceEnrollmentConfigurationsCollectionRequest {
	return &UserDeviceEnrollmentConfigurationsCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for DeviceEnrollmentConfiguration item
func (b *UserDeviceEnrollmentConfigurationsCollectionRequestBuilder) ID(id string) *DeviceEnrollmentConfigurationRequestBuilder {
	bb := &DeviceEnrollmentConfigurationRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// UserDeviceEnrollmentConfigurationsCollectionRequest is request for DeviceEnrollmentConfiguration collection
type UserDeviceEnrollmentConfigurationsCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for DeviceEnrollmentConfiguration collection
func (r *UserDeviceEnrollmentConfigurationsCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]DeviceEnrollmentConfiguration, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []DeviceEnrollmentConfiguration
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []DeviceEnrollmentConfiguration
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for DeviceEnrollmentConfiguration collection, max N pages
func (r *UserDeviceEnrollmentConfigurationsCollectionRequest) GetN(ctx context.Context, n int) ([]DeviceEnrollmentConfiguration, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for DeviceEnrollmentConfiguration collection
func (r *UserDeviceEnrollmentConfigurationsCollectionRequest) Get(ctx context.Context) ([]DeviceEnrollmentConfiguration, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for DeviceEnrollmentConfiguration collection
func (r *UserDeviceEnrollmentConfigurationsCollectionRequest) Add(ctx context.Context, reqObj *DeviceEnrollmentConfiguration) (resObj *DeviceEnrollmentConfiguration, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// DeviceManagementTroubleshootingEvents returns request builder for DeviceManagementTroubleshootingEvent collection
func (b *UserRequestBuilder) DeviceManagementTroubleshootingEvents() *UserDeviceManagementTroubleshootingEventsCollectionRequestBuilder {
	bb := &UserDeviceManagementTroubleshootingEventsCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/deviceManagementTroubleshootingEvents"
	return bb
}

// UserDeviceManagementTroubleshootingEventsCollectionRequestBuilder is request builder for DeviceManagementTroubleshootingEvent collection
type UserDeviceManagementTroubleshootingEventsCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for DeviceManagementTroubleshootingEvent collection
func (b *UserDeviceManagementTroubleshootingEventsCollectionRequestBuilder) Request() *UserDeviceManagementTroubleshootingEventsCollectionRequest {
	return &UserDeviceManagementTroubleshootingEventsCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for DeviceManagementTroubleshootingEvent item
func (b *UserDeviceManagementTroubleshootingEventsCollectionRequestBuilder) ID(id string) *DeviceManagementTroubleshootingEventRequestBuilder {
	bb := &DeviceManagementTroubleshootingEventRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// UserDeviceManagementTroubleshootingEventsCollectionRequest is request for DeviceManagementTroubleshootingEvent collection
type UserDeviceManagementTroubleshootingEventsCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for DeviceManagementTroubleshootingEvent collection
func (r *UserDeviceManagementTroubleshootingEventsCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]DeviceManagementTroubleshootingEvent, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []DeviceManagementTroubleshootingEvent
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []DeviceManagementTroubleshootingEvent
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for DeviceManagementTroubleshootingEvent collection, max N pages
func (r *UserDeviceManagementTroubleshootingEventsCollectionRequest) GetN(ctx context.Context, n int) ([]DeviceManagementTroubleshootingEvent, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for DeviceManagementTroubleshootingEvent collection
func (r *UserDeviceManagementTroubleshootingEventsCollectionRequest) Get(ctx context.Context) ([]DeviceManagementTroubleshootingEvent, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for DeviceManagementTroubleshootingEvent collection
func (r *UserDeviceManagementTroubleshootingEventsCollectionRequest) Add(ctx context.Context, reqObj *DeviceManagementTroubleshootingEvent) (resObj *DeviceManagementTroubleshootingEvent, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// Devices returns request builder for Device collection
func (b *UserRequestBuilder) Devices() *UserDevicesCollectionRequestBuilder {
	bb := &UserDevicesCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/devices"
	return bb
}

// UserDevicesCollectionRequestBuilder is request builder for Device collection
type UserDevicesCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for Device collection
func (b *UserDevicesCollectionRequestBuilder) Request() *UserDevicesCollectionRequest {
	return &UserDevicesCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for Device item
func (b *UserDevicesCollectionRequestBuilder) ID(id string) *DeviceRequestBuilder {
	bb := &DeviceRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// UserDevicesCollectionRequest is request for Device collection
type UserDevicesCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for Device collection
func (r *UserDevicesCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]Device, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []Device
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []Device
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for Device collection, max N pages
func (r *UserDevicesCollectionRequest) GetN(ctx context.Context, n int) ([]Device, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for Device collection
func (r *UserDevicesCollectionRequest) Get(ctx context.Context) ([]Device, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for Device collection
func (r *UserDevicesCollectionRequest) Add(ctx context.Context, reqObj *Device) (resObj *Device, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// DirectReports returns request builder for DirectoryObject collection
func (b *UserRequestBuilder) DirectReports() *UserDirectReportsCollectionRequestBuilder {
	bb := &UserDirectReportsCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/directReports"
	return bb
}

// UserDirectReportsCollectionRequestBuilder is request builder for DirectoryObject collection
type UserDirectReportsCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for DirectoryObject collection
func (b *UserDirectReportsCollectionRequestBuilder) Request() *UserDirectReportsCollectionRequest {
	return &UserDirectReportsCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for DirectoryObject item
func (b *UserDirectReportsCollectionRequestBuilder) ID(id string) *DirectoryObjectRequestBuilder {
	bb := &DirectoryObjectRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// UserDirectReportsCollectionRequest is request for DirectoryObject collection
type UserDirectReportsCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for DirectoryObject collection
func (r *UserDirectReportsCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]DirectoryObject, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []DirectoryObject
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []DirectoryObject
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for DirectoryObject collection, max N pages
func (r *UserDirectReportsCollectionRequest) GetN(ctx context.Context, n int) ([]DirectoryObject, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for DirectoryObject collection
func (r *UserDirectReportsCollectionRequest) Get(ctx context.Context) ([]DirectoryObject, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for DirectoryObject collection
func (r *UserDirectReportsCollectionRequest) Add(ctx context.Context, reqObj *DirectoryObject) (resObj *DirectoryObject, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// Drive is navigation property
func (b *UserRequestBuilder) Drive() *DriveRequestBuilder {
	bb := &DriveRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/drive"
	return bb
}

// Drives returns request builder for Drive collection
func (b *UserRequestBuilder) Drives() *UserDrivesCollectionRequestBuilder {
	bb := &UserDrivesCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/drives"
	return bb
}

// UserDrivesCollectionRequestBuilder is request builder for Drive collection
type UserDrivesCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for Drive collection
func (b *UserDrivesCollectionRequestBuilder) Request() *UserDrivesCollectionRequest {
	return &UserDrivesCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for Drive item
func (b *UserDrivesCollectionRequestBuilder) ID(id string) *DriveRequestBuilder {
	bb := &DriveRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// UserDrivesCollectionRequest is request for Drive collection
type UserDrivesCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for Drive collection
func (r *UserDrivesCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]Drive, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []Drive
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []Drive
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for Drive collection, max N pages
func (r *UserDrivesCollectionRequest) GetN(ctx context.Context, n int) ([]Drive, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for Drive collection
func (r *UserDrivesCollectionRequest) Get(ctx context.Context) ([]Drive, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for Drive collection
func (r *UserDrivesCollectionRequest) Add(ctx context.Context, reqObj *Drive) (resObj *Drive, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// Events returns request builder for Event collection
func (b *UserRequestBuilder) Events() *UserEventsCollectionRequestBuilder {
	bb := &UserEventsCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/events"
	return bb
}

// UserEventsCollectionRequestBuilder is request builder for Event collection
type UserEventsCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for Event collection
func (b *UserEventsCollectionRequestBuilder) Request() *UserEventsCollectionRequest {
	return &UserEventsCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for Event item
func (b *UserEventsCollectionRequestBuilder) ID(id string) *EventRequestBuilder {
	bb := &EventRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// UserEventsCollectionRequest is request for Event collection
type UserEventsCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for Event collection
func (r *UserEventsCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]Event, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []Event
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []Event
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for Event collection, max N pages
func (r *UserEventsCollectionRequest) GetN(ctx context.Context, n int) ([]Event, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for Event collection
func (r *UserEventsCollectionRequest) Get(ctx context.Context) ([]Event, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for Event collection
func (r *UserEventsCollectionRequest) Add(ctx context.Context, reqObj *Event) (resObj *Event, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// Extensions returns request builder for Extension collection
func (b *UserRequestBuilder) Extensions() *UserExtensionsCollectionRequestBuilder {
	bb := &UserExtensionsCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/extensions"
	return bb
}

// UserExtensionsCollectionRequestBuilder is request builder for Extension collection
type UserExtensionsCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for Extension collection
func (b *UserExtensionsCollectionRequestBuilder) Request() *UserExtensionsCollectionRequest {
	return &UserExtensionsCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for Extension item
func (b *UserExtensionsCollectionRequestBuilder) ID(id string) *ExtensionRequestBuilder {
	bb := &ExtensionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// UserExtensionsCollectionRequest is request for Extension collection
type UserExtensionsCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for Extension collection
func (r *UserExtensionsCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]Extension, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []Extension
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []Extension
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for Extension collection, max N pages
func (r *UserExtensionsCollectionRequest) GetN(ctx context.Context, n int) ([]Extension, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for Extension collection
func (r *UserExtensionsCollectionRequest) Get(ctx context.Context) ([]Extension, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for Extension collection
func (r *UserExtensionsCollectionRequest) Add(ctx context.Context, reqObj *Extension) (resObj *Extension, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// FollowedSites returns request builder for Site collection
func (b *UserRequestBuilder) FollowedSites() *UserFollowedSitesCollectionRequestBuilder {
	bb := &UserFollowedSitesCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/followedSites"
	return bb
}

// UserFollowedSitesCollectionRequestBuilder is request builder for Site collection
type UserFollowedSitesCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for Site collection
func (b *UserFollowedSitesCollectionRequestBuilder) Request() *UserFollowedSitesCollectionRequest {
	return &UserFollowedSitesCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for Site item
func (b *UserFollowedSitesCollectionRequestBuilder) ID(id string) *SiteRequestBuilder {
	bb := &SiteRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// UserFollowedSitesCollectionRequest is request for Site collection
type UserFollowedSitesCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for Site collection
func (r *UserFollowedSitesCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]Site, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []Site
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []Site
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for Site collection, max N pages
func (r *UserFollowedSitesCollectionRequest) GetN(ctx context.Context, n int) ([]Site, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for Site collection
func (r *UserFollowedSitesCollectionRequest) Get(ctx context.Context) ([]Site, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for Site collection
func (r *UserFollowedSitesCollectionRequest) Add(ctx context.Context, reqObj *Site) (resObj *Site, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// InferenceClassification is navigation property
func (b *UserRequestBuilder) InferenceClassification() *InferenceClassificationRequestBuilder {
	bb := &InferenceClassificationRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/inferenceClassification"
	return bb
}

// InformationProtection is navigation property
func (b *UserRequestBuilder) InformationProtection() *InformationProtectionRequestBuilder {
	bb := &InformationProtectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/informationProtection"
	return bb
}

// Insights is navigation property
func (b *UserRequestBuilder) Insights() *OfficeGraphInsightsRequestBuilder {
	bb := &OfficeGraphInsightsRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/insights"
	return bb
}

// JoinedGroups returns request builder for Group collection
func (b *UserRequestBuilder) JoinedGroups() *UserJoinedGroupsCollectionRequestBuilder {
	bb := &UserJoinedGroupsCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/joinedGroups"
	return bb
}

// UserJoinedGroupsCollectionRequestBuilder is request builder for Group collection
type UserJoinedGroupsCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for Group collection
func (b *UserJoinedGroupsCollectionRequestBuilder) Request() *UserJoinedGroupsCollectionRequest {
	return &UserJoinedGroupsCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for Group item
func (b *UserJoinedGroupsCollectionRequestBuilder) ID(id string) *GroupRequestBuilder {
	bb := &GroupRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// UserJoinedGroupsCollectionRequest is request for Group collection
type UserJoinedGroupsCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for Group collection
func (r *UserJoinedGroupsCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]Group, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []Group
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []Group
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for Group collection, max N pages
func (r *UserJoinedGroupsCollectionRequest) GetN(ctx context.Context, n int) ([]Group, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for Group collection
func (r *UserJoinedGroupsCollectionRequest) Get(ctx context.Context) ([]Group, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for Group collection
func (r *UserJoinedGroupsCollectionRequest) Add(ctx context.Context, reqObj *Group) (resObj *Group, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// JoinedTeams returns request builder for Team collection
func (b *UserRequestBuilder) JoinedTeams() *UserJoinedTeamsCollectionRequestBuilder {
	bb := &UserJoinedTeamsCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/joinedTeams"
	return bb
}

// UserJoinedTeamsCollectionRequestBuilder is request builder for Team collection
type UserJoinedTeamsCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for Team collection
func (b *UserJoinedTeamsCollectionRequestBuilder) Request() *UserJoinedTeamsCollectionRequest {
	return &UserJoinedTeamsCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for Team item
func (b *UserJoinedTeamsCollectionRequestBuilder) ID(id string) *TeamRequestBuilder {
	bb := &TeamRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// UserJoinedTeamsCollectionRequest is request for Team collection
type UserJoinedTeamsCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for Team collection
func (r *UserJoinedTeamsCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]Team, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []Team
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []Team
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for Team collection, max N pages
func (r *UserJoinedTeamsCollectionRequest) GetN(ctx context.Context, n int) ([]Team, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for Team collection
func (r *UserJoinedTeamsCollectionRequest) Get(ctx context.Context) ([]Team, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for Team collection
func (r *UserJoinedTeamsCollectionRequest) Add(ctx context.Context, reqObj *Team) (resObj *Team, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// LicenseDetails returns request builder for LicenseDetails collection
func (b *UserRequestBuilder) LicenseDetails() *UserLicenseDetailsCollectionRequestBuilder {
	bb := &UserLicenseDetailsCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/licenseDetails"
	return bb
}

// UserLicenseDetailsCollectionRequestBuilder is request builder for LicenseDetails collection
type UserLicenseDetailsCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for LicenseDetails collection
func (b *UserLicenseDetailsCollectionRequestBuilder) Request() *UserLicenseDetailsCollectionRequest {
	return &UserLicenseDetailsCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for LicenseDetails item
func (b *UserLicenseDetailsCollectionRequestBuilder) ID(id string) *LicenseDetailsRequestBuilder {
	bb := &LicenseDetailsRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// UserLicenseDetailsCollectionRequest is request for LicenseDetails collection
type UserLicenseDetailsCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for LicenseDetails collection
func (r *UserLicenseDetailsCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]LicenseDetails, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []LicenseDetails
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []LicenseDetails
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for LicenseDetails collection, max N pages
func (r *UserLicenseDetailsCollectionRequest) GetN(ctx context.Context, n int) ([]LicenseDetails, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for LicenseDetails collection
func (r *UserLicenseDetailsCollectionRequest) Get(ctx context.Context) ([]LicenseDetails, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for LicenseDetails collection
func (r *UserLicenseDetailsCollectionRequest) Add(ctx context.Context, reqObj *LicenseDetails) (resObj *LicenseDetails, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// MailFolders returns request builder for MailFolder collection
func (b *UserRequestBuilder) MailFolders() *UserMailFoldersCollectionRequestBuilder {
	bb := &UserMailFoldersCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/mailFolders"
	return bb
}

// UserMailFoldersCollectionRequestBuilder is request builder for MailFolder collection
type UserMailFoldersCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for MailFolder collection
func (b *UserMailFoldersCollectionRequestBuilder) Request() *UserMailFoldersCollectionRequest {
	return &UserMailFoldersCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for MailFolder item
func (b *UserMailFoldersCollectionRequestBuilder) ID(id string) *MailFolderRequestBuilder {
	bb := &MailFolderRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// UserMailFoldersCollectionRequest is request for MailFolder collection
type UserMailFoldersCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for MailFolder collection
func (r *UserMailFoldersCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]MailFolder, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []MailFolder
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []MailFolder
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for MailFolder collection, max N pages
func (r *UserMailFoldersCollectionRequest) GetN(ctx context.Context, n int) ([]MailFolder, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for MailFolder collection
func (r *UserMailFoldersCollectionRequest) Get(ctx context.Context) ([]MailFolder, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for MailFolder collection
func (r *UserMailFoldersCollectionRequest) Add(ctx context.Context, reqObj *MailFolder) (resObj *MailFolder, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// ManagedAppRegistrations returns request builder for ManagedAppRegistration collection
func (b *UserRequestBuilder) ManagedAppRegistrations() *UserManagedAppRegistrationsCollectionRequestBuilder {
	bb := &UserManagedAppRegistrationsCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/managedAppRegistrations"
	return bb
}

// UserManagedAppRegistrationsCollectionRequestBuilder is request builder for ManagedAppRegistration collection
type UserManagedAppRegistrationsCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for ManagedAppRegistration collection
func (b *UserManagedAppRegistrationsCollectionRequestBuilder) Request() *UserManagedAppRegistrationsCollectionRequest {
	return &UserManagedAppRegistrationsCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for ManagedAppRegistration item
func (b *UserManagedAppRegistrationsCollectionRequestBuilder) ID(id string) *ManagedAppRegistrationRequestBuilder {
	bb := &ManagedAppRegistrationRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// UserManagedAppRegistrationsCollectionRequest is request for ManagedAppRegistration collection
type UserManagedAppRegistrationsCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for ManagedAppRegistration collection
func (r *UserManagedAppRegistrationsCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]ManagedAppRegistration, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []ManagedAppRegistration
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []ManagedAppRegistration
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for ManagedAppRegistration collection, max N pages
func (r *UserManagedAppRegistrationsCollectionRequest) GetN(ctx context.Context, n int) ([]ManagedAppRegistration, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for ManagedAppRegistration collection
func (r *UserManagedAppRegistrationsCollectionRequest) Get(ctx context.Context) ([]ManagedAppRegistration, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for ManagedAppRegistration collection
func (r *UserManagedAppRegistrationsCollectionRequest) Add(ctx context.Context, reqObj *ManagedAppRegistration) (resObj *ManagedAppRegistration, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// ManagedDevices returns request builder for ManagedDevice collection
func (b *UserRequestBuilder) ManagedDevices() *UserManagedDevicesCollectionRequestBuilder {
	bb := &UserManagedDevicesCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/managedDevices"
	return bb
}

// UserManagedDevicesCollectionRequestBuilder is request builder for ManagedDevice collection
type UserManagedDevicesCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for ManagedDevice collection
func (b *UserManagedDevicesCollectionRequestBuilder) Request() *UserManagedDevicesCollectionRequest {
	return &UserManagedDevicesCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for ManagedDevice item
func (b *UserManagedDevicesCollectionRequestBuilder) ID(id string) *ManagedDeviceRequestBuilder {
	bb := &ManagedDeviceRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// UserManagedDevicesCollectionRequest is request for ManagedDevice collection
type UserManagedDevicesCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for ManagedDevice collection
func (r *UserManagedDevicesCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]ManagedDevice, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []ManagedDevice
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []ManagedDevice
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for ManagedDevice collection, max N pages
func (r *UserManagedDevicesCollectionRequest) GetN(ctx context.Context, n int) ([]ManagedDevice, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for ManagedDevice collection
func (r *UserManagedDevicesCollectionRequest) Get(ctx context.Context) ([]ManagedDevice, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for ManagedDevice collection
func (r *UserManagedDevicesCollectionRequest) Add(ctx context.Context, reqObj *ManagedDevice) (resObj *ManagedDevice, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// Manager is navigation property
func (b *UserRequestBuilder) Manager() *DirectoryObjectRequestBuilder {
	bb := &DirectoryObjectRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/manager"
	return bb
}

// MemberOf returns request builder for DirectoryObject collection
func (b *UserRequestBuilder) MemberOf() *UserMemberOfCollectionRequestBuilder {
	bb := &UserMemberOfCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/memberOf"
	return bb
}

// UserMemberOfCollectionRequestBuilder is request builder for DirectoryObject collection
type UserMemberOfCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for DirectoryObject collection
func (b *UserMemberOfCollectionRequestBuilder) Request() *UserMemberOfCollectionRequest {
	return &UserMemberOfCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for DirectoryObject item
func (b *UserMemberOfCollectionRequestBuilder) ID(id string) *DirectoryObjectRequestBuilder {
	bb := &DirectoryObjectRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// UserMemberOfCollectionRequest is request for DirectoryObject collection
type UserMemberOfCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for DirectoryObject collection
func (r *UserMemberOfCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]DirectoryObject, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []DirectoryObject
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []DirectoryObject
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for DirectoryObject collection, max N pages
func (r *UserMemberOfCollectionRequest) GetN(ctx context.Context, n int) ([]DirectoryObject, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for DirectoryObject collection
func (r *UserMemberOfCollectionRequest) Get(ctx context.Context) ([]DirectoryObject, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for DirectoryObject collection
func (r *UserMemberOfCollectionRequest) Add(ctx context.Context, reqObj *DirectoryObject) (resObj *DirectoryObject, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// Messages returns request builder for Message collection
func (b *UserRequestBuilder) Messages() *UserMessagesCollectionRequestBuilder {
	bb := &UserMessagesCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/messages"
	return bb
}

// UserMessagesCollectionRequestBuilder is request builder for Message collection
type UserMessagesCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for Message collection
func (b *UserMessagesCollectionRequestBuilder) Request() *UserMessagesCollectionRequest {
	return &UserMessagesCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for Message item
func (b *UserMessagesCollectionRequestBuilder) ID(id string) *MessageRequestBuilder {
	bb := &MessageRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// UserMessagesCollectionRequest is request for Message collection
type UserMessagesCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for Message collection
func (r *UserMessagesCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]Message, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []Message
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []Message
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for Message collection, max N pages
func (r *UserMessagesCollectionRequest) GetN(ctx context.Context, n int) ([]Message, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for Message collection
func (r *UserMessagesCollectionRequest) Get(ctx context.Context) ([]Message, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for Message collection
func (r *UserMessagesCollectionRequest) Add(ctx context.Context, reqObj *Message) (resObj *Message, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// MobileAppIntentAndStates returns request builder for MobileAppIntentAndState collection
func (b *UserRequestBuilder) MobileAppIntentAndStates() *UserMobileAppIntentAndStatesCollectionRequestBuilder {
	bb := &UserMobileAppIntentAndStatesCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/mobileAppIntentAndStates"
	return bb
}

// UserMobileAppIntentAndStatesCollectionRequestBuilder is request builder for MobileAppIntentAndState collection
type UserMobileAppIntentAndStatesCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for MobileAppIntentAndState collection
func (b *UserMobileAppIntentAndStatesCollectionRequestBuilder) Request() *UserMobileAppIntentAndStatesCollectionRequest {
	return &UserMobileAppIntentAndStatesCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for MobileAppIntentAndState item
func (b *UserMobileAppIntentAndStatesCollectionRequestBuilder) ID(id string) *MobileAppIntentAndStateRequestBuilder {
	bb := &MobileAppIntentAndStateRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// UserMobileAppIntentAndStatesCollectionRequest is request for MobileAppIntentAndState collection
type UserMobileAppIntentAndStatesCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for MobileAppIntentAndState collection
func (r *UserMobileAppIntentAndStatesCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]MobileAppIntentAndState, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []MobileAppIntentAndState
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []MobileAppIntentAndState
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for MobileAppIntentAndState collection, max N pages
func (r *UserMobileAppIntentAndStatesCollectionRequest) GetN(ctx context.Context, n int) ([]MobileAppIntentAndState, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for MobileAppIntentAndState collection
func (r *UserMobileAppIntentAndStatesCollectionRequest) Get(ctx context.Context) ([]MobileAppIntentAndState, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for MobileAppIntentAndState collection
func (r *UserMobileAppIntentAndStatesCollectionRequest) Add(ctx context.Context, reqObj *MobileAppIntentAndState) (resObj *MobileAppIntentAndState, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// MobileAppTroubleshootingEvents returns request builder for MobileAppTroubleshootingEvent collection
func (b *UserRequestBuilder) MobileAppTroubleshootingEvents() *UserMobileAppTroubleshootingEventsCollectionRequestBuilder {
	bb := &UserMobileAppTroubleshootingEventsCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/mobileAppTroubleshootingEvents"
	return bb
}

// UserMobileAppTroubleshootingEventsCollectionRequestBuilder is request builder for MobileAppTroubleshootingEvent collection
type UserMobileAppTroubleshootingEventsCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for MobileAppTroubleshootingEvent collection
func (b *UserMobileAppTroubleshootingEventsCollectionRequestBuilder) Request() *UserMobileAppTroubleshootingEventsCollectionRequest {
	return &UserMobileAppTroubleshootingEventsCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for MobileAppTroubleshootingEvent item
func (b *UserMobileAppTroubleshootingEventsCollectionRequestBuilder) ID(id string) *MobileAppTroubleshootingEventRequestBuilder {
	bb := &MobileAppTroubleshootingEventRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// UserMobileAppTroubleshootingEventsCollectionRequest is request for MobileAppTroubleshootingEvent collection
type UserMobileAppTroubleshootingEventsCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for MobileAppTroubleshootingEvent collection
func (r *UserMobileAppTroubleshootingEventsCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]MobileAppTroubleshootingEvent, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []MobileAppTroubleshootingEvent
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []MobileAppTroubleshootingEvent
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for MobileAppTroubleshootingEvent collection, max N pages
func (r *UserMobileAppTroubleshootingEventsCollectionRequest) GetN(ctx context.Context, n int) ([]MobileAppTroubleshootingEvent, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for MobileAppTroubleshootingEvent collection
func (r *UserMobileAppTroubleshootingEventsCollectionRequest) Get(ctx context.Context) ([]MobileAppTroubleshootingEvent, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for MobileAppTroubleshootingEvent collection
func (r *UserMobileAppTroubleshootingEventsCollectionRequest) Add(ctx context.Context, reqObj *MobileAppTroubleshootingEvent) (resObj *MobileAppTroubleshootingEvent, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// Notifications returns request builder for Notification collection
func (b *UserRequestBuilder) Notifications() *UserNotificationsCollectionRequestBuilder {
	bb := &UserNotificationsCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/notifications"
	return bb
}

// UserNotificationsCollectionRequestBuilder is request builder for Notification collection
type UserNotificationsCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for Notification collection
func (b *UserNotificationsCollectionRequestBuilder) Request() *UserNotificationsCollectionRequest {
	return &UserNotificationsCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for Notification item
func (b *UserNotificationsCollectionRequestBuilder) ID(id string) *NotificationRequestBuilder {
	bb := &NotificationRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// UserNotificationsCollectionRequest is request for Notification collection
type UserNotificationsCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for Notification collection
func (r *UserNotificationsCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]Notification, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []Notification
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []Notification
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for Notification collection, max N pages
func (r *UserNotificationsCollectionRequest) GetN(ctx context.Context, n int) ([]Notification, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for Notification collection
func (r *UserNotificationsCollectionRequest) Get(ctx context.Context) ([]Notification, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for Notification collection
func (r *UserNotificationsCollectionRequest) Add(ctx context.Context, reqObj *Notification) (resObj *Notification, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// Onenote is navigation property
func (b *UserRequestBuilder) Onenote() *OnenoteRequestBuilder {
	bb := &OnenoteRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/onenote"
	return bb
}

// OnlineMeetings returns request builder for OnlineMeeting collection
func (b *UserRequestBuilder) OnlineMeetings() *UserOnlineMeetingsCollectionRequestBuilder {
	bb := &UserOnlineMeetingsCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/onlineMeetings"
	return bb
}

// UserOnlineMeetingsCollectionRequestBuilder is request builder for OnlineMeeting collection
type UserOnlineMeetingsCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for OnlineMeeting collection
func (b *UserOnlineMeetingsCollectionRequestBuilder) Request() *UserOnlineMeetingsCollectionRequest {
	return &UserOnlineMeetingsCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for OnlineMeeting item
func (b *UserOnlineMeetingsCollectionRequestBuilder) ID(id string) *OnlineMeetingRequestBuilder {
	bb := &OnlineMeetingRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// UserOnlineMeetingsCollectionRequest is request for OnlineMeeting collection
type UserOnlineMeetingsCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for OnlineMeeting collection
func (r *UserOnlineMeetingsCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]OnlineMeeting, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []OnlineMeeting
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []OnlineMeeting
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for OnlineMeeting collection, max N pages
func (r *UserOnlineMeetingsCollectionRequest) GetN(ctx context.Context, n int) ([]OnlineMeeting, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for OnlineMeeting collection
func (r *UserOnlineMeetingsCollectionRequest) Get(ctx context.Context) ([]OnlineMeeting, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for OnlineMeeting collection
func (r *UserOnlineMeetingsCollectionRequest) Add(ctx context.Context, reqObj *OnlineMeeting) (resObj *OnlineMeeting, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// Outlook is navigation property
func (b *UserRequestBuilder) Outlook() *OutlookUserRequestBuilder {
	bb := &OutlookUserRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/outlook"
	return bb
}

// OwnedDevices returns request builder for DirectoryObject collection
func (b *UserRequestBuilder) OwnedDevices() *UserOwnedDevicesCollectionRequestBuilder {
	bb := &UserOwnedDevicesCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/ownedDevices"
	return bb
}

// UserOwnedDevicesCollectionRequestBuilder is request builder for DirectoryObject collection
type UserOwnedDevicesCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for DirectoryObject collection
func (b *UserOwnedDevicesCollectionRequestBuilder) Request() *UserOwnedDevicesCollectionRequest {
	return &UserOwnedDevicesCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for DirectoryObject item
func (b *UserOwnedDevicesCollectionRequestBuilder) ID(id string) *DirectoryObjectRequestBuilder {
	bb := &DirectoryObjectRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// UserOwnedDevicesCollectionRequest is request for DirectoryObject collection
type UserOwnedDevicesCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for DirectoryObject collection
func (r *UserOwnedDevicesCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]DirectoryObject, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []DirectoryObject
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []DirectoryObject
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for DirectoryObject collection, max N pages
func (r *UserOwnedDevicesCollectionRequest) GetN(ctx context.Context, n int) ([]DirectoryObject, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for DirectoryObject collection
func (r *UserOwnedDevicesCollectionRequest) Get(ctx context.Context) ([]DirectoryObject, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for DirectoryObject collection
func (r *UserOwnedDevicesCollectionRequest) Add(ctx context.Context, reqObj *DirectoryObject) (resObj *DirectoryObject, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// OwnedObjects returns request builder for DirectoryObject collection
func (b *UserRequestBuilder) OwnedObjects() *UserOwnedObjectsCollectionRequestBuilder {
	bb := &UserOwnedObjectsCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/ownedObjects"
	return bb
}

// UserOwnedObjectsCollectionRequestBuilder is request builder for DirectoryObject collection
type UserOwnedObjectsCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for DirectoryObject collection
func (b *UserOwnedObjectsCollectionRequestBuilder) Request() *UserOwnedObjectsCollectionRequest {
	return &UserOwnedObjectsCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for DirectoryObject item
func (b *UserOwnedObjectsCollectionRequestBuilder) ID(id string) *DirectoryObjectRequestBuilder {
	bb := &DirectoryObjectRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// UserOwnedObjectsCollectionRequest is request for DirectoryObject collection
type UserOwnedObjectsCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for DirectoryObject collection
func (r *UserOwnedObjectsCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]DirectoryObject, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []DirectoryObject
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []DirectoryObject
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for DirectoryObject collection, max N pages
func (r *UserOwnedObjectsCollectionRequest) GetN(ctx context.Context, n int) ([]DirectoryObject, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for DirectoryObject collection
func (r *UserOwnedObjectsCollectionRequest) Get(ctx context.Context) ([]DirectoryObject, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for DirectoryObject collection
func (r *UserOwnedObjectsCollectionRequest) Add(ctx context.Context, reqObj *DirectoryObject) (resObj *DirectoryObject, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// People returns request builder for Person collection
func (b *UserRequestBuilder) People() *UserPeopleCollectionRequestBuilder {
	bb := &UserPeopleCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/people"
	return bb
}

// UserPeopleCollectionRequestBuilder is request builder for Person collection
type UserPeopleCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for Person collection
func (b *UserPeopleCollectionRequestBuilder) Request() *UserPeopleCollectionRequest {
	return &UserPeopleCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for Person item
func (b *UserPeopleCollectionRequestBuilder) ID(id string) *PersonRequestBuilder {
	bb := &PersonRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// UserPeopleCollectionRequest is request for Person collection
type UserPeopleCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for Person collection
func (r *UserPeopleCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]Person, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []Person
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []Person
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for Person collection, max N pages
func (r *UserPeopleCollectionRequest) GetN(ctx context.Context, n int) ([]Person, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for Person collection
func (r *UserPeopleCollectionRequest) Get(ctx context.Context) ([]Person, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for Person collection
func (r *UserPeopleCollectionRequest) Add(ctx context.Context, reqObj *Person) (resObj *Person, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// Photo is navigation property
func (b *UserRequestBuilder) Photo() *ProfilePhotoRequestBuilder {
	bb := &ProfilePhotoRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/photo"
	return bb
}

// Photos returns request builder for ProfilePhoto collection
func (b *UserRequestBuilder) Photos() *UserPhotosCollectionRequestBuilder {
	bb := &UserPhotosCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/photos"
	return bb
}

// UserPhotosCollectionRequestBuilder is request builder for ProfilePhoto collection
type UserPhotosCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for ProfilePhoto collection
func (b *UserPhotosCollectionRequestBuilder) Request() *UserPhotosCollectionRequest {
	return &UserPhotosCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for ProfilePhoto item
func (b *UserPhotosCollectionRequestBuilder) ID(id string) *ProfilePhotoRequestBuilder {
	bb := &ProfilePhotoRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// UserPhotosCollectionRequest is request for ProfilePhoto collection
type UserPhotosCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for ProfilePhoto collection
func (r *UserPhotosCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]ProfilePhoto, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []ProfilePhoto
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []ProfilePhoto
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for ProfilePhoto collection, max N pages
func (r *UserPhotosCollectionRequest) GetN(ctx context.Context, n int) ([]ProfilePhoto, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for ProfilePhoto collection
func (r *UserPhotosCollectionRequest) Get(ctx context.Context) ([]ProfilePhoto, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for ProfilePhoto collection
func (r *UserPhotosCollectionRequest) Add(ctx context.Context, reqObj *ProfilePhoto) (resObj *ProfilePhoto, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// Planner is navigation property
func (b *UserRequestBuilder) Planner() *PlannerUserRequestBuilder {
	bb := &PlannerUserRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/planner"
	return bb
}

// Presence is navigation property
func (b *UserRequestBuilder) Presence() *PresenceRequestBuilder {
	bb := &PresenceRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/presence"
	return bb
}

// Profile is navigation property
func (b *UserRequestBuilder) Profile() *ProfileRequestBuilder {
	bb := &ProfileRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/profile"
	return bb
}

// RegisteredDevices returns request builder for DirectoryObject collection
func (b *UserRequestBuilder) RegisteredDevices() *UserRegisteredDevicesCollectionRequestBuilder {
	bb := &UserRegisteredDevicesCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/registeredDevices"
	return bb
}

// UserRegisteredDevicesCollectionRequestBuilder is request builder for DirectoryObject collection
type UserRegisteredDevicesCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for DirectoryObject collection
func (b *UserRegisteredDevicesCollectionRequestBuilder) Request() *UserRegisteredDevicesCollectionRequest {
	return &UserRegisteredDevicesCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for DirectoryObject item
func (b *UserRegisteredDevicesCollectionRequestBuilder) ID(id string) *DirectoryObjectRequestBuilder {
	bb := &DirectoryObjectRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// UserRegisteredDevicesCollectionRequest is request for DirectoryObject collection
type UserRegisteredDevicesCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for DirectoryObject collection
func (r *UserRegisteredDevicesCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]DirectoryObject, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []DirectoryObject
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []DirectoryObject
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for DirectoryObject collection, max N pages
func (r *UserRegisteredDevicesCollectionRequest) GetN(ctx context.Context, n int) ([]DirectoryObject, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for DirectoryObject collection
func (r *UserRegisteredDevicesCollectionRequest) Get(ctx context.Context) ([]DirectoryObject, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for DirectoryObject collection
func (r *UserRegisteredDevicesCollectionRequest) Add(ctx context.Context, reqObj *DirectoryObject) (resObj *DirectoryObject, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// ScopedRoleMemberOf returns request builder for ScopedRoleMembership collection
func (b *UserRequestBuilder) ScopedRoleMemberOf() *UserScopedRoleMemberOfCollectionRequestBuilder {
	bb := &UserScopedRoleMemberOfCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/scopedRoleMemberOf"
	return bb
}

// UserScopedRoleMemberOfCollectionRequestBuilder is request builder for ScopedRoleMembership collection
type UserScopedRoleMemberOfCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for ScopedRoleMembership collection
func (b *UserScopedRoleMemberOfCollectionRequestBuilder) Request() *UserScopedRoleMemberOfCollectionRequest {
	return &UserScopedRoleMemberOfCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for ScopedRoleMembership item
func (b *UserScopedRoleMemberOfCollectionRequestBuilder) ID(id string) *ScopedRoleMembershipRequestBuilder {
	bb := &ScopedRoleMembershipRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// UserScopedRoleMemberOfCollectionRequest is request for ScopedRoleMembership collection
type UserScopedRoleMemberOfCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for ScopedRoleMembership collection
func (r *UserScopedRoleMemberOfCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]ScopedRoleMembership, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []ScopedRoleMembership
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []ScopedRoleMembership
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for ScopedRoleMembership collection, max N pages
func (r *UserScopedRoleMemberOfCollectionRequest) GetN(ctx context.Context, n int) ([]ScopedRoleMembership, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for ScopedRoleMembership collection
func (r *UserScopedRoleMemberOfCollectionRequest) Get(ctx context.Context) ([]ScopedRoleMembership, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for ScopedRoleMembership collection
func (r *UserScopedRoleMemberOfCollectionRequest) Add(ctx context.Context, reqObj *ScopedRoleMembership) (resObj *ScopedRoleMembership, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// Settings is navigation property
func (b *UserRequestBuilder) Settings() *UserSettingsRequestBuilder {
	bb := &UserSettingsRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/settings"
	return bb
}

// Teamwork is navigation property
func (b *UserRequestBuilder) Teamwork() *UserTeamworkRequestBuilder {
	bb := &UserTeamworkRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/teamwork"
	return bb
}

// TransitiveMemberOf returns request builder for DirectoryObject collection
func (b *UserRequestBuilder) TransitiveMemberOf() *UserTransitiveMemberOfCollectionRequestBuilder {
	bb := &UserTransitiveMemberOfCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/transitiveMemberOf"
	return bb
}

// UserTransitiveMemberOfCollectionRequestBuilder is request builder for DirectoryObject collection
type UserTransitiveMemberOfCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for DirectoryObject collection
func (b *UserTransitiveMemberOfCollectionRequestBuilder) Request() *UserTransitiveMemberOfCollectionRequest {
	return &UserTransitiveMemberOfCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for DirectoryObject item
func (b *UserTransitiveMemberOfCollectionRequestBuilder) ID(id string) *DirectoryObjectRequestBuilder {
	bb := &DirectoryObjectRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// UserTransitiveMemberOfCollectionRequest is request for DirectoryObject collection
type UserTransitiveMemberOfCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for DirectoryObject collection
func (r *UserTransitiveMemberOfCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]DirectoryObject, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []DirectoryObject
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []DirectoryObject
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for DirectoryObject collection, max N pages
func (r *UserTransitiveMemberOfCollectionRequest) GetN(ctx context.Context, n int) ([]DirectoryObject, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for DirectoryObject collection
func (r *UserTransitiveMemberOfCollectionRequest) Get(ctx context.Context) ([]DirectoryObject, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for DirectoryObject collection
func (r *UserTransitiveMemberOfCollectionRequest) Add(ctx context.Context, reqObj *DirectoryObject) (resObj *DirectoryObject, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// WindowsInformationProtectionDeviceRegistrations returns request builder for WindowsInformationProtectionDeviceRegistration collection
func (b *UserRequestBuilder) WindowsInformationProtectionDeviceRegistrations() *UserWindowsInformationProtectionDeviceRegistrationsCollectionRequestBuilder {
	bb := &UserWindowsInformationProtectionDeviceRegistrationsCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/windowsInformationProtectionDeviceRegistrations"
	return bb
}

// UserWindowsInformationProtectionDeviceRegistrationsCollectionRequestBuilder is request builder for WindowsInformationProtectionDeviceRegistration collection
type UserWindowsInformationProtectionDeviceRegistrationsCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for WindowsInformationProtectionDeviceRegistration collection
func (b *UserWindowsInformationProtectionDeviceRegistrationsCollectionRequestBuilder) Request() *UserWindowsInformationProtectionDeviceRegistrationsCollectionRequest {
	return &UserWindowsInformationProtectionDeviceRegistrationsCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for WindowsInformationProtectionDeviceRegistration item
func (b *UserWindowsInformationProtectionDeviceRegistrationsCollectionRequestBuilder) ID(id string) *WindowsInformationProtectionDeviceRegistrationRequestBuilder {
	bb := &WindowsInformationProtectionDeviceRegistrationRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// UserWindowsInformationProtectionDeviceRegistrationsCollectionRequest is request for WindowsInformationProtectionDeviceRegistration collection
type UserWindowsInformationProtectionDeviceRegistrationsCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for WindowsInformationProtectionDeviceRegistration collection
func (r *UserWindowsInformationProtectionDeviceRegistrationsCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]WindowsInformationProtectionDeviceRegistration, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []WindowsInformationProtectionDeviceRegistration
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []WindowsInformationProtectionDeviceRegistration
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for WindowsInformationProtectionDeviceRegistration collection, max N pages
func (r *UserWindowsInformationProtectionDeviceRegistrationsCollectionRequest) GetN(ctx context.Context, n int) ([]WindowsInformationProtectionDeviceRegistration, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for WindowsInformationProtectionDeviceRegistration collection
func (r *UserWindowsInformationProtectionDeviceRegistrationsCollectionRequest) Get(ctx context.Context) ([]WindowsInformationProtectionDeviceRegistration, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for WindowsInformationProtectionDeviceRegistration collection
func (r *UserWindowsInformationProtectionDeviceRegistrationsCollectionRequest) Add(ctx context.Context, reqObj *WindowsInformationProtectionDeviceRegistration) (resObj *WindowsInformationProtectionDeviceRegistration, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// HistoryItems returns request builder for ActivityHistoryItem collection
func (b *UserActivityRequestBuilder) HistoryItems() *UserActivityHistoryItemsCollectionRequestBuilder {
	bb := &UserActivityHistoryItemsCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/historyItems"
	return bb
}

// UserActivityHistoryItemsCollectionRequestBuilder is request builder for ActivityHistoryItem collection
type UserActivityHistoryItemsCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for ActivityHistoryItem collection
func (b *UserActivityHistoryItemsCollectionRequestBuilder) Request() *UserActivityHistoryItemsCollectionRequest {
	return &UserActivityHistoryItemsCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for ActivityHistoryItem item
func (b *UserActivityHistoryItemsCollectionRequestBuilder) ID(id string) *ActivityHistoryItemRequestBuilder {
	bb := &ActivityHistoryItemRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// UserActivityHistoryItemsCollectionRequest is request for ActivityHistoryItem collection
type UserActivityHistoryItemsCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for ActivityHistoryItem collection
func (r *UserActivityHistoryItemsCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]ActivityHistoryItem, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []ActivityHistoryItem
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []ActivityHistoryItem
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for ActivityHistoryItem collection, max N pages
func (r *UserActivityHistoryItemsCollectionRequest) GetN(ctx context.Context, n int) ([]ActivityHistoryItem, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for ActivityHistoryItem collection
func (r *UserActivityHistoryItemsCollectionRequest) Get(ctx context.Context) ([]ActivityHistoryItem, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for ActivityHistoryItem collection
func (r *UserActivityHistoryItemsCollectionRequest) Add(ctx context.Context, reqObj *ActivityHistoryItem) (resObj *ActivityHistoryItem, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// ActivityStatistics returns request builder for ActivityStatistics collection
func (b *UserAnalyticsRequestBuilder) ActivityStatistics() *UserAnalyticsActivityStatisticsCollectionRequestBuilder {
	bb := &UserAnalyticsActivityStatisticsCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/activityStatistics"
	return bb
}

// UserAnalyticsActivityStatisticsCollectionRequestBuilder is request builder for ActivityStatistics collection
type UserAnalyticsActivityStatisticsCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for ActivityStatistics collection
func (b *UserAnalyticsActivityStatisticsCollectionRequestBuilder) Request() *UserAnalyticsActivityStatisticsCollectionRequest {
	return &UserAnalyticsActivityStatisticsCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for ActivityStatistics item
func (b *UserAnalyticsActivityStatisticsCollectionRequestBuilder) ID(id string) *ActivityStatisticsRequestBuilder {
	bb := &ActivityStatisticsRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// UserAnalyticsActivityStatisticsCollectionRequest is request for ActivityStatistics collection
type UserAnalyticsActivityStatisticsCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for ActivityStatistics collection
func (r *UserAnalyticsActivityStatisticsCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]ActivityStatistics, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []ActivityStatistics
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []ActivityStatistics
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for ActivityStatistics collection, max N pages
func (r *UserAnalyticsActivityStatisticsCollectionRequest) GetN(ctx context.Context, n int) ([]ActivityStatistics, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for ActivityStatistics collection
func (r *UserAnalyticsActivityStatisticsCollectionRequest) Get(ctx context.Context) ([]ActivityStatistics, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for ActivityStatistics collection
func (r *UserAnalyticsActivityStatisticsCollectionRequest) Add(ctx context.Context, reqObj *ActivityStatistics) (resObj *ActivityStatistics, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// App is navigation property
func (b *UserAppInstallStatusRequestBuilder) App() *MobileAppRequestBuilder {
	bb := &MobileAppRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/app"
	return bb
}

// DeviceStatuses returns request builder for MobileAppInstallStatus collection
func (b *UserAppInstallStatusRequestBuilder) DeviceStatuses() *UserAppInstallStatusDeviceStatusesCollectionRequestBuilder {
	bb := &UserAppInstallStatusDeviceStatusesCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/deviceStatuses"
	return bb
}

// UserAppInstallStatusDeviceStatusesCollectionRequestBuilder is request builder for MobileAppInstallStatus collection
type UserAppInstallStatusDeviceStatusesCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for MobileAppInstallStatus collection
func (b *UserAppInstallStatusDeviceStatusesCollectionRequestBuilder) Request() *UserAppInstallStatusDeviceStatusesCollectionRequest {
	return &UserAppInstallStatusDeviceStatusesCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for MobileAppInstallStatus item
func (b *UserAppInstallStatusDeviceStatusesCollectionRequestBuilder) ID(id string) *MobileAppInstallStatusRequestBuilder {
	bb := &MobileAppInstallStatusRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// UserAppInstallStatusDeviceStatusesCollectionRequest is request for MobileAppInstallStatus collection
type UserAppInstallStatusDeviceStatusesCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for MobileAppInstallStatus collection
func (r *UserAppInstallStatusDeviceStatusesCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]MobileAppInstallStatus, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []MobileAppInstallStatus
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []MobileAppInstallStatus
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for MobileAppInstallStatus collection, max N pages
func (r *UserAppInstallStatusDeviceStatusesCollectionRequest) GetN(ctx context.Context, n int) ([]MobileAppInstallStatus, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for MobileAppInstallStatus collection
func (r *UserAppInstallStatusDeviceStatusesCollectionRequest) Get(ctx context.Context) ([]MobileAppInstallStatus, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for MobileAppInstallStatus collection
func (r *UserAppInstallStatusDeviceStatusesCollectionRequest) Add(ctx context.Context, reqObj *MobileAppInstallStatus) (resObj *MobileAppInstallStatus, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// BestPracticesMetrics is navigation property
func (b *UserExperienceAnalyticsBaselineRequestBuilder) BestPracticesMetrics() *UserExperienceAnalyticsCategoryRequestBuilder {
	bb := &UserExperienceAnalyticsCategoryRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/bestPracticesMetrics"
	return bb
}

// DeviceBootPerformanceMetrics is navigation property
func (b *UserExperienceAnalyticsBaselineRequestBuilder) DeviceBootPerformanceMetrics() *UserExperienceAnalyticsCategoryRequestBuilder {
	bb := &UserExperienceAnalyticsCategoryRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/deviceBootPerformanceMetrics"
	return bb
}

// MetricValues returns request builder for UserExperienceAnalyticsMetric collection
func (b *UserExperienceAnalyticsCategoryRequestBuilder) MetricValues() *UserExperienceAnalyticsCategoryMetricValuesCollectionRequestBuilder {
	bb := &UserExperienceAnalyticsCategoryMetricValuesCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/metricValues"
	return bb
}

// UserExperienceAnalyticsCategoryMetricValuesCollectionRequestBuilder is request builder for UserExperienceAnalyticsMetric collection
type UserExperienceAnalyticsCategoryMetricValuesCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for UserExperienceAnalyticsMetric collection
func (b *UserExperienceAnalyticsCategoryMetricValuesCollectionRequestBuilder) Request() *UserExperienceAnalyticsCategoryMetricValuesCollectionRequest {
	return &UserExperienceAnalyticsCategoryMetricValuesCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for UserExperienceAnalyticsMetric item
func (b *UserExperienceAnalyticsCategoryMetricValuesCollectionRequestBuilder) ID(id string) *UserExperienceAnalyticsMetricRequestBuilder {
	bb := &UserExperienceAnalyticsMetricRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// UserExperienceAnalyticsCategoryMetricValuesCollectionRequest is request for UserExperienceAnalyticsMetric collection
type UserExperienceAnalyticsCategoryMetricValuesCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for UserExperienceAnalyticsMetric collection
func (r *UserExperienceAnalyticsCategoryMetricValuesCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]UserExperienceAnalyticsMetric, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []UserExperienceAnalyticsMetric
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []UserExperienceAnalyticsMetric
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for UserExperienceAnalyticsMetric collection, max N pages
func (r *UserExperienceAnalyticsCategoryMetricValuesCollectionRequest) GetN(ctx context.Context, n int) ([]UserExperienceAnalyticsMetric, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for UserExperienceAnalyticsMetric collection
func (r *UserExperienceAnalyticsCategoryMetricValuesCollectionRequest) Get(ctx context.Context) ([]UserExperienceAnalyticsMetric, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for UserExperienceAnalyticsMetric collection
func (r *UserExperienceAnalyticsCategoryMetricValuesCollectionRequest) Add(ctx context.Context, reqObj *UserExperienceAnalyticsMetric) (resObj *UserExperienceAnalyticsMetric, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// ManufacturerRegression returns request builder for UserExperienceAnalyticsMetric collection
func (b *UserExperienceAnalyticsRegressionSummaryRequestBuilder) ManufacturerRegression() *UserExperienceAnalyticsRegressionSummaryManufacturerRegressionCollectionRequestBuilder {
	bb := &UserExperienceAnalyticsRegressionSummaryManufacturerRegressionCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/manufacturerRegression"
	return bb
}

// UserExperienceAnalyticsRegressionSummaryManufacturerRegressionCollectionRequestBuilder is request builder for UserExperienceAnalyticsMetric collection
type UserExperienceAnalyticsRegressionSummaryManufacturerRegressionCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for UserExperienceAnalyticsMetric collection
func (b *UserExperienceAnalyticsRegressionSummaryManufacturerRegressionCollectionRequestBuilder) Request() *UserExperienceAnalyticsRegressionSummaryManufacturerRegressionCollectionRequest {
	return &UserExperienceAnalyticsRegressionSummaryManufacturerRegressionCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for UserExperienceAnalyticsMetric item
func (b *UserExperienceAnalyticsRegressionSummaryManufacturerRegressionCollectionRequestBuilder) ID(id string) *UserExperienceAnalyticsMetricRequestBuilder {
	bb := &UserExperienceAnalyticsMetricRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// UserExperienceAnalyticsRegressionSummaryManufacturerRegressionCollectionRequest is request for UserExperienceAnalyticsMetric collection
type UserExperienceAnalyticsRegressionSummaryManufacturerRegressionCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for UserExperienceAnalyticsMetric collection
func (r *UserExperienceAnalyticsRegressionSummaryManufacturerRegressionCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]UserExperienceAnalyticsMetric, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []UserExperienceAnalyticsMetric
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []UserExperienceAnalyticsMetric
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for UserExperienceAnalyticsMetric collection, max N pages
func (r *UserExperienceAnalyticsRegressionSummaryManufacturerRegressionCollectionRequest) GetN(ctx context.Context, n int) ([]UserExperienceAnalyticsMetric, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for UserExperienceAnalyticsMetric collection
func (r *UserExperienceAnalyticsRegressionSummaryManufacturerRegressionCollectionRequest) Get(ctx context.Context) ([]UserExperienceAnalyticsMetric, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for UserExperienceAnalyticsMetric collection
func (r *UserExperienceAnalyticsRegressionSummaryManufacturerRegressionCollectionRequest) Add(ctx context.Context, reqObj *UserExperienceAnalyticsMetric) (resObj *UserExperienceAnalyticsMetric, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// ModelRegression returns request builder for UserExperienceAnalyticsMetric collection
func (b *UserExperienceAnalyticsRegressionSummaryRequestBuilder) ModelRegression() *UserExperienceAnalyticsRegressionSummaryModelRegressionCollectionRequestBuilder {
	bb := &UserExperienceAnalyticsRegressionSummaryModelRegressionCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/modelRegression"
	return bb
}

// UserExperienceAnalyticsRegressionSummaryModelRegressionCollectionRequestBuilder is request builder for UserExperienceAnalyticsMetric collection
type UserExperienceAnalyticsRegressionSummaryModelRegressionCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for UserExperienceAnalyticsMetric collection
func (b *UserExperienceAnalyticsRegressionSummaryModelRegressionCollectionRequestBuilder) Request() *UserExperienceAnalyticsRegressionSummaryModelRegressionCollectionRequest {
	return &UserExperienceAnalyticsRegressionSummaryModelRegressionCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for UserExperienceAnalyticsMetric item
func (b *UserExperienceAnalyticsRegressionSummaryModelRegressionCollectionRequestBuilder) ID(id string) *UserExperienceAnalyticsMetricRequestBuilder {
	bb := &UserExperienceAnalyticsMetricRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// UserExperienceAnalyticsRegressionSummaryModelRegressionCollectionRequest is request for UserExperienceAnalyticsMetric collection
type UserExperienceAnalyticsRegressionSummaryModelRegressionCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for UserExperienceAnalyticsMetric collection
func (r *UserExperienceAnalyticsRegressionSummaryModelRegressionCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]UserExperienceAnalyticsMetric, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []UserExperienceAnalyticsMetric
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []UserExperienceAnalyticsMetric
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for UserExperienceAnalyticsMetric collection, max N pages
func (r *UserExperienceAnalyticsRegressionSummaryModelRegressionCollectionRequest) GetN(ctx context.Context, n int) ([]UserExperienceAnalyticsMetric, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for UserExperienceAnalyticsMetric collection
func (r *UserExperienceAnalyticsRegressionSummaryModelRegressionCollectionRequest) Get(ctx context.Context) ([]UserExperienceAnalyticsMetric, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for UserExperienceAnalyticsMetric collection
func (r *UserExperienceAnalyticsRegressionSummaryModelRegressionCollectionRequest) Add(ctx context.Context, reqObj *UserExperienceAnalyticsMetric) (resObj *UserExperienceAnalyticsMetric, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// OperatingSystemRegression returns request builder for UserExperienceAnalyticsMetric collection
func (b *UserExperienceAnalyticsRegressionSummaryRequestBuilder) OperatingSystemRegression() *UserExperienceAnalyticsRegressionSummaryOperatingSystemRegressionCollectionRequestBuilder {
	bb := &UserExperienceAnalyticsRegressionSummaryOperatingSystemRegressionCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/operatingSystemRegression"
	return bb
}

// UserExperienceAnalyticsRegressionSummaryOperatingSystemRegressionCollectionRequestBuilder is request builder for UserExperienceAnalyticsMetric collection
type UserExperienceAnalyticsRegressionSummaryOperatingSystemRegressionCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for UserExperienceAnalyticsMetric collection
func (b *UserExperienceAnalyticsRegressionSummaryOperatingSystemRegressionCollectionRequestBuilder) Request() *UserExperienceAnalyticsRegressionSummaryOperatingSystemRegressionCollectionRequest {
	return &UserExperienceAnalyticsRegressionSummaryOperatingSystemRegressionCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for UserExperienceAnalyticsMetric item
func (b *UserExperienceAnalyticsRegressionSummaryOperatingSystemRegressionCollectionRequestBuilder) ID(id string) *UserExperienceAnalyticsMetricRequestBuilder {
	bb := &UserExperienceAnalyticsMetricRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// UserExperienceAnalyticsRegressionSummaryOperatingSystemRegressionCollectionRequest is request for UserExperienceAnalyticsMetric collection
type UserExperienceAnalyticsRegressionSummaryOperatingSystemRegressionCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for UserExperienceAnalyticsMetric collection
func (r *UserExperienceAnalyticsRegressionSummaryOperatingSystemRegressionCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]UserExperienceAnalyticsMetric, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []UserExperienceAnalyticsMetric
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []UserExperienceAnalyticsMetric
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for UserExperienceAnalyticsMetric collection, max N pages
func (r *UserExperienceAnalyticsRegressionSummaryOperatingSystemRegressionCollectionRequest) GetN(ctx context.Context, n int) ([]UserExperienceAnalyticsMetric, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for UserExperienceAnalyticsMetric collection
func (r *UserExperienceAnalyticsRegressionSummaryOperatingSystemRegressionCollectionRequest) Get(ctx context.Context) ([]UserExperienceAnalyticsMetric, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for UserExperienceAnalyticsMetric collection
func (r *UserExperienceAnalyticsRegressionSummaryOperatingSystemRegressionCollectionRequest) Add(ctx context.Context, reqObj *UserExperienceAnalyticsMetric) (resObj *UserExperienceAnalyticsMetric, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// DeviceStates returns request builder for DeviceInstallState collection
func (b *UserInstallStateSummaryRequestBuilder) DeviceStates() *UserInstallStateSummaryDeviceStatesCollectionRequestBuilder {
	bb := &UserInstallStateSummaryDeviceStatesCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/deviceStates"
	return bb
}

// UserInstallStateSummaryDeviceStatesCollectionRequestBuilder is request builder for DeviceInstallState collection
type UserInstallStateSummaryDeviceStatesCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for DeviceInstallState collection
func (b *UserInstallStateSummaryDeviceStatesCollectionRequestBuilder) Request() *UserInstallStateSummaryDeviceStatesCollectionRequest {
	return &UserInstallStateSummaryDeviceStatesCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for DeviceInstallState item
func (b *UserInstallStateSummaryDeviceStatesCollectionRequestBuilder) ID(id string) *DeviceInstallStateRequestBuilder {
	bb := &DeviceInstallStateRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// UserInstallStateSummaryDeviceStatesCollectionRequest is request for DeviceInstallState collection
type UserInstallStateSummaryDeviceStatesCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for DeviceInstallState collection
func (r *UserInstallStateSummaryDeviceStatesCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]DeviceInstallState, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []DeviceInstallState
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []DeviceInstallState
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for DeviceInstallState collection, max N pages
func (r *UserInstallStateSummaryDeviceStatesCollectionRequest) GetN(ctx context.Context, n int) ([]DeviceInstallState, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for DeviceInstallState collection
func (r *UserInstallStateSummaryDeviceStatesCollectionRequest) Get(ctx context.Context) ([]DeviceInstallState, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for DeviceInstallState collection
func (r *UserInstallStateSummaryDeviceStatesCollectionRequest) Add(ctx context.Context, reqObj *DeviceInstallState) (resObj *DeviceInstallState, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// InstalledApps returns request builder for TeamsAppInstallation collection
func (b *UserTeamworkRequestBuilder) InstalledApps() *UserTeamworkInstalledAppsCollectionRequestBuilder {
	bb := &UserTeamworkInstalledAppsCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/installedApps"
	return bb
}

// UserTeamworkInstalledAppsCollectionRequestBuilder is request builder for TeamsAppInstallation collection
type UserTeamworkInstalledAppsCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for TeamsAppInstallation collection
func (b *UserTeamworkInstalledAppsCollectionRequestBuilder) Request() *UserTeamworkInstalledAppsCollectionRequest {
	return &UserTeamworkInstalledAppsCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for TeamsAppInstallation item
func (b *UserTeamworkInstalledAppsCollectionRequestBuilder) ID(id string) *TeamsAppInstallationRequestBuilder {
	bb := &TeamsAppInstallationRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// UserTeamworkInstalledAppsCollectionRequest is request for TeamsAppInstallation collection
type UserTeamworkInstalledAppsCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for TeamsAppInstallation collection
func (r *UserTeamworkInstalledAppsCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]TeamsAppInstallation, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []TeamsAppInstallation
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []TeamsAppInstallation
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for TeamsAppInstallation collection, max N pages
func (r *UserTeamworkInstalledAppsCollectionRequest) GetN(ctx context.Context, n int) ([]TeamsAppInstallation, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for TeamsAppInstallation collection
func (r *UserTeamworkInstalledAppsCollectionRequest) Get(ctx context.Context) ([]TeamsAppInstallation, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for TeamsAppInstallation collection
func (r *UserTeamworkInstalledAppsCollectionRequest) Add(ctx context.Context, reqObj *TeamsAppInstallation) (resObj *TeamsAppInstallation, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}
