// Code generated by protoc-gen-go. DO NOT EDIT.
// source: Mumble.proto

package MumbleProto

import (
	fmt "fmt"
	proto "github.com/golang/protobuf/proto"
	math "math"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

type Reject_RejectType int32

const (
	// The rejection reason is unknown (details should be available
	// in Reject.reason).
	Reject_None Reject_RejectType = 0
	// The client attempted to connect with an incompatible version.
	Reject_WrongVersion Reject_RejectType = 1
	// The user name supplied by the client was invalid.
	Reject_InvalidUsername Reject_RejectType = 2
	// The client attempted to authenticate as a user with a password but it
	// was wrong.
	Reject_WrongUserPW Reject_RejectType = 3
	// The client attempted to connect to a passworded server but the password
	// was wrong.
	Reject_WrongServerPW Reject_RejectType = 4
	// Supplied username is already in use.
	Reject_UsernameInUse Reject_RejectType = 5
	// Server is currently full and cannot accept more users.
	Reject_ServerFull Reject_RejectType = 6
	// The user did not provide a certificate but one is required.
	Reject_NoCertificate     Reject_RejectType = 7
	Reject_AuthenticatorFail Reject_RejectType = 8
)

var Reject_RejectType_name = map[int32]string{
	0: "None",
	1: "WrongVersion",
	2: "InvalidUsername",
	3: "WrongUserPW",
	4: "WrongServerPW",
	5: "UsernameInUse",
	6: "ServerFull",
	7: "NoCertificate",
	8: "AuthenticatorFail",
}

var Reject_RejectType_value = map[string]int32{
	"None":              0,
	"WrongVersion":      1,
	"InvalidUsername":   2,
	"WrongUserPW":       3,
	"WrongServerPW":     4,
	"UsernameInUse":     5,
	"ServerFull":        6,
	"NoCertificate":     7,
	"AuthenticatorFail": 8,
}

func (x Reject_RejectType) Enum() *Reject_RejectType {
	p := new(Reject_RejectType)
	*p = x
	return p
}

func (x Reject_RejectType) String() string {
	return proto.EnumName(Reject_RejectType_name, int32(x))
}

func (x *Reject_RejectType) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(Reject_RejectType_value, data, "Reject_RejectType")
	if err != nil {
		return err
	}
	*x = Reject_RejectType(value)
	return nil
}

func (Reject_RejectType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_56c09c2dce0fb003, []int{4, 0}
}

type PermissionDenied_DenyType int32

const (
	// Operation denied for other reason, see reason field.
	PermissionDenied_Text PermissionDenied_DenyType = 0
	// Permissions were denied.
	PermissionDenied_Permission PermissionDenied_DenyType = 1
	// Cannot modify SuperUser.
	PermissionDenied_SuperUser PermissionDenied_DenyType = 2
	// Invalid channel name.
	PermissionDenied_ChannelName PermissionDenied_DenyType = 3
	// Text message too long.
	PermissionDenied_TextTooLong PermissionDenied_DenyType = 4
	// The flux capacitor was spelled wrong.
	PermissionDenied_H9K PermissionDenied_DenyType = 5
	// Operation not permitted in temporary channel.
	PermissionDenied_TemporaryChannel PermissionDenied_DenyType = 6
	// Operation requires certificate.
	PermissionDenied_MissingCertificate PermissionDenied_DenyType = 7
	// Invalid username.
	PermissionDenied_UserName PermissionDenied_DenyType = 8
	// Channel is full.
	PermissionDenied_ChannelFull PermissionDenied_DenyType = 9
	// Channels are nested too deply.
	PermissionDenied_NestingLimit PermissionDenied_DenyType = 10
	// Maximum channel count reached.
	PermissionDenied_ChannelCountLimit PermissionDenied_DenyType = 11
)

var PermissionDenied_DenyType_name = map[int32]string{
	0:  "Text",
	1:  "Permission",
	2:  "SuperUser",
	3:  "ChannelName",
	4:  "TextTooLong",
	5:  "H9K",
	6:  "TemporaryChannel",
	7:  "MissingCertificate",
	8:  "UserName",
	9:  "ChannelFull",
	10: "NestingLimit",
	11: "ChannelCountLimit",
}

var PermissionDenied_DenyType_value = map[string]int32{
	"Text":               0,
	"Permission":         1,
	"SuperUser":          2,
	"ChannelName":        3,
	"TextTooLong":        4,
	"H9K":                5,
	"TemporaryChannel":   6,
	"MissingCertificate": 7,
	"UserName":           8,
	"ChannelFull":        9,
	"NestingLimit":       10,
	"ChannelCountLimit":  11,
}

func (x PermissionDenied_DenyType) Enum() *PermissionDenied_DenyType {
	p := new(PermissionDenied_DenyType)
	*p = x
	return p
}

func (x PermissionDenied_DenyType) String() string {
	return proto.EnumName(PermissionDenied_DenyType_name, int32(x))
}

func (x *PermissionDenied_DenyType) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(PermissionDenied_DenyType_value, data, "PermissionDenied_DenyType")
	if err != nil {
		return err
	}
	*x = PermissionDenied_DenyType(value)
	return nil
}

func (PermissionDenied_DenyType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_56c09c2dce0fb003, []int{12, 0}
}

type ContextActionModify_Context int32

const (
	// Action is applicable to the server.
	ContextActionModify_Server ContextActionModify_Context = 1
	// Action can target a Channel.
	ContextActionModify_Channel ContextActionModify_Context = 2
	// Action can target a User.
	ContextActionModify_User ContextActionModify_Context = 4
)

var ContextActionModify_Context_name = map[int32]string{
	1: "Server",
	2: "Channel",
	4: "User",
}

var ContextActionModify_Context_value = map[string]int32{
	"Server":  1,
	"Channel": 2,
	"User":    4,
}

func (x ContextActionModify_Context) Enum() *ContextActionModify_Context {
	p := new(ContextActionModify_Context)
	*p = x
	return p
}

func (x ContextActionModify_Context) String() string {
	return proto.EnumName(ContextActionModify_Context_name, int32(x))
}

func (x *ContextActionModify_Context) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(ContextActionModify_Context_value, data, "ContextActionModify_Context")
	if err != nil {
		return err
	}
	*x = ContextActionModify_Context(value)
	return nil
}

func (ContextActionModify_Context) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_56c09c2dce0fb003, []int{16, 0}
}

type ContextActionModify_Operation int32

const (
	ContextActionModify_Add    ContextActionModify_Operation = 0
	ContextActionModify_Remove ContextActionModify_Operation = 1
)

var ContextActionModify_Operation_name = map[int32]string{
	0: "Add",
	1: "Remove",
}

var ContextActionModify_Operation_value = map[string]int32{
	"Add":    0,
	"Remove": 1,
}

func (x ContextActionModify_Operation) Enum() *ContextActionModify_Operation {
	p := new(ContextActionModify_Operation)
	*p = x
	return p
}

func (x ContextActionModify_Operation) String() string {
	return proto.EnumName(ContextActionModify_Operation_name, int32(x))
}

func (x *ContextActionModify_Operation) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(ContextActionModify_Operation_value, data, "ContextActionModify_Operation")
	if err != nil {
		return err
	}
	*x = ContextActionModify_Operation(value)
	return nil
}

func (ContextActionModify_Operation) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_56c09c2dce0fb003, []int{16, 1}
}

type Version struct {
	// 2-byte Major, 1-byte Minor and 1-byte Patch version number.
	Version *uint32 `protobuf:"varint,1,opt,name=version" json:"version,omitempty"`
	// Client release name.
	Release *string `protobuf:"bytes,2,opt,name=release" json:"release,omitempty"`
	// Client OS name.
	Os *string `protobuf:"bytes,3,opt,name=os" json:"os,omitempty"`
	// Client OS version.
	OsVersion            *string  `protobuf:"bytes,4,opt,name=os_version,json=osVersion" json:"os_version,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Version) Reset()         { *m = Version{} }
func (m *Version) String() string { return proto.CompactTextString(m) }
func (*Version) ProtoMessage()    {}
func (*Version) Descriptor() ([]byte, []int) {
	return fileDescriptor_56c09c2dce0fb003, []int{0}
}

func (m *Version) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Version.Unmarshal(m, b)
}
func (m *Version) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Version.Marshal(b, m, deterministic)
}
func (m *Version) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Version.Merge(m, src)
}
func (m *Version) XXX_Size() int {
	return xxx_messageInfo_Version.Size(m)
}
func (m *Version) XXX_DiscardUnknown() {
	xxx_messageInfo_Version.DiscardUnknown(m)
}

var xxx_messageInfo_Version proto.InternalMessageInfo

func (m *Version) GetVersion() uint32 {
	if m != nil && m.Version != nil {
		return *m.Version
	}
	return 0
}

func (m *Version) GetRelease() string {
	if m != nil && m.Release != nil {
		return *m.Release
	}
	return ""
}

func (m *Version) GetOs() string {
	if m != nil && m.Os != nil {
		return *m.Os
	}
	return ""
}

func (m *Version) GetOsVersion() string {
	if m != nil && m.OsVersion != nil {
		return *m.OsVersion
	}
	return ""
}

// Not used. Not even for tunneling UDP through TCP.
type UDPTunnel struct {
	// Not used.
	Packet               []byte   `protobuf:"bytes,1,req,name=packet" json:"packet,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *UDPTunnel) Reset()         { *m = UDPTunnel{} }
func (m *UDPTunnel) String() string { return proto.CompactTextString(m) }
func (*UDPTunnel) ProtoMessage()    {}
func (*UDPTunnel) Descriptor() ([]byte, []int) {
	return fileDescriptor_56c09c2dce0fb003, []int{1}
}

func (m *UDPTunnel) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UDPTunnel.Unmarshal(m, b)
}
func (m *UDPTunnel) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UDPTunnel.Marshal(b, m, deterministic)
}
func (m *UDPTunnel) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UDPTunnel.Merge(m, src)
}
func (m *UDPTunnel) XXX_Size() int {
	return xxx_messageInfo_UDPTunnel.Size(m)
}
func (m *UDPTunnel) XXX_DiscardUnknown() {
	xxx_messageInfo_UDPTunnel.DiscardUnknown(m)
}

var xxx_messageInfo_UDPTunnel proto.InternalMessageInfo

func (m *UDPTunnel) GetPacket() []byte {
	if m != nil {
		return m.Packet
	}
	return nil
}

// Used by the client to send the authentication credentials to the server.
type Authenticate struct {
	// UTF-8 encoded username.
	Username *string `protobuf:"bytes,1,opt,name=username" json:"username,omitempty"`
	// Server or user password.
	Password *string `protobuf:"bytes,2,opt,name=password" json:"password,omitempty"`
	// Additional access tokens for server ACL groups.
	Tokens []string `protobuf:"bytes,3,rep,name=tokens" json:"tokens,omitempty"`
	// A list of CELT bitstream version constants supported by the client.
	CeltVersions         []int32  `protobuf:"varint,4,rep,name=celt_versions,json=celtVersions" json:"celt_versions,omitempty"`
	Opus                 *bool    `protobuf:"varint,5,opt,name=opus,def=0" json:"opus,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Authenticate) Reset()         { *m = Authenticate{} }
func (m *Authenticate) String() string { return proto.CompactTextString(m) }
func (*Authenticate) ProtoMessage()    {}
func (*Authenticate) Descriptor() ([]byte, []int) {
	return fileDescriptor_56c09c2dce0fb003, []int{2}
}

func (m *Authenticate) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Authenticate.Unmarshal(m, b)
}
func (m *Authenticate) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Authenticate.Marshal(b, m, deterministic)
}
func (m *Authenticate) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Authenticate.Merge(m, src)
}
func (m *Authenticate) XXX_Size() int {
	return xxx_messageInfo_Authenticate.Size(m)
}
func (m *Authenticate) XXX_DiscardUnknown() {
	xxx_messageInfo_Authenticate.DiscardUnknown(m)
}

var xxx_messageInfo_Authenticate proto.InternalMessageInfo

const Default_Authenticate_Opus bool = false

func (m *Authenticate) GetUsername() string {
	if m != nil && m.Username != nil {
		return *m.Username
	}
	return ""
}

func (m *Authenticate) GetPassword() string {
	if m != nil && m.Password != nil {
		return *m.Password
	}
	return ""
}

func (m *Authenticate) GetTokens() []string {
	if m != nil {
		return m.Tokens
	}
	return nil
}

func (m *Authenticate) GetCeltVersions() []int32 {
	if m != nil {
		return m.CeltVersions
	}
	return nil
}

func (m *Authenticate) GetOpus() bool {
	if m != nil && m.Opus != nil {
		return *m.Opus
	}
	return Default_Authenticate_Opus
}

// Sent by the client to notify the server that the client is still alive.
// Server must reply to the packet with the same timestamp and its own
// good/late/lost/resync numbers. None of the fields is strictly required.
type Ping struct {
	// Client timestamp. Server should not attempt to decode.
	Timestamp *uint64 `protobuf:"varint,1,opt,name=timestamp" json:"timestamp,omitempty"`
	// The amount of good packets received.
	Good *uint32 `protobuf:"varint,2,opt,name=good" json:"good,omitempty"`
	// The amount of late packets received.
	Late *uint32 `protobuf:"varint,3,opt,name=late" json:"late,omitempty"`
	// The amount of packets never received.
	Lost *uint32 `protobuf:"varint,4,opt,name=lost" json:"lost,omitempty"`
	// The amount of nonce resyncs.
	Resync *uint32 `protobuf:"varint,5,opt,name=resync" json:"resync,omitempty"`
	// The total amount of UDP packets received.
	UdpPackets *uint32 `protobuf:"varint,6,opt,name=udp_packets,json=udpPackets" json:"udp_packets,omitempty"`
	// The total amount of TCP packets received.
	TcpPackets *uint32 `protobuf:"varint,7,opt,name=tcp_packets,json=tcpPackets" json:"tcp_packets,omitempty"`
	// UDP ping average.
	UdpPingAvg *float32 `protobuf:"fixed32,8,opt,name=udp_ping_avg,json=udpPingAvg" json:"udp_ping_avg,omitempty"`
	// UDP ping variance.
	UdpPingVar *float32 `protobuf:"fixed32,9,opt,name=udp_ping_var,json=udpPingVar" json:"udp_ping_var,omitempty"`
	// TCP ping average.
	TcpPingAvg *float32 `protobuf:"fixed32,10,opt,name=tcp_ping_avg,json=tcpPingAvg" json:"tcp_ping_avg,omitempty"`
	// TCP ping variance.
	TcpPingVar           *float32 `protobuf:"fixed32,11,opt,name=tcp_ping_var,json=tcpPingVar" json:"tcp_ping_var,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Ping) Reset()         { *m = Ping{} }
func (m *Ping) String() string { return proto.CompactTextString(m) }
func (*Ping) ProtoMessage()    {}
func (*Ping) Descriptor() ([]byte, []int) {
	return fileDescriptor_56c09c2dce0fb003, []int{3}
}

func (m *Ping) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Ping.Unmarshal(m, b)
}
func (m *Ping) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Ping.Marshal(b, m, deterministic)
}
func (m *Ping) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Ping.Merge(m, src)
}
func (m *Ping) XXX_Size() int {
	return xxx_messageInfo_Ping.Size(m)
}
func (m *Ping) XXX_DiscardUnknown() {
	xxx_messageInfo_Ping.DiscardUnknown(m)
}

var xxx_messageInfo_Ping proto.InternalMessageInfo

func (m *Ping) GetTimestamp() uint64 {
	if m != nil && m.Timestamp != nil {
		return *m.Timestamp
	}
	return 0
}

func (m *Ping) GetGood() uint32 {
	if m != nil && m.Good != nil {
		return *m.Good
	}
	return 0
}

func (m *Ping) GetLate() uint32 {
	if m != nil && m.Late != nil {
		return *m.Late
	}
	return 0
}

func (m *Ping) GetLost() uint32 {
	if m != nil && m.Lost != nil {
		return *m.Lost
	}
	return 0
}

func (m *Ping) GetResync() uint32 {
	if m != nil && m.Resync != nil {
		return *m.Resync
	}
	return 0
}

func (m *Ping) GetUdpPackets() uint32 {
	if m != nil && m.UdpPackets != nil {
		return *m.UdpPackets
	}
	return 0
}

func (m *Ping) GetTcpPackets() uint32 {
	if m != nil && m.TcpPackets != nil {
		return *m.TcpPackets
	}
	return 0
}

func (m *Ping) GetUdpPingAvg() float32 {
	if m != nil && m.UdpPingAvg != nil {
		return *m.UdpPingAvg
	}
	return 0
}

func (m *Ping) GetUdpPingVar() float32 {
	if m != nil && m.UdpPingVar != nil {
		return *m.UdpPingVar
	}
	return 0
}

func (m *Ping) GetTcpPingAvg() float32 {
	if m != nil && m.TcpPingAvg != nil {
		return *m.TcpPingAvg
	}
	return 0
}

func (m *Ping) GetTcpPingVar() float32 {
	if m != nil && m.TcpPingVar != nil {
		return *m.TcpPingVar
	}
	return 0
}

// Sent by the server when it rejects the user connection.
type Reject struct {
	// Rejection type.
	Type *Reject_RejectType `protobuf:"varint,1,opt,name=type,enum=MumbleProto.Reject_RejectType" json:"type,omitempty"`
	// Human readable rejection reason.
	Reason               *string  `protobuf:"bytes,2,opt,name=reason" json:"reason,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Reject) Reset()         { *m = Reject{} }
func (m *Reject) String() string { return proto.CompactTextString(m) }
func (*Reject) ProtoMessage()    {}
func (*Reject) Descriptor() ([]byte, []int) {
	return fileDescriptor_56c09c2dce0fb003, []int{4}
}

func (m *Reject) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Reject.Unmarshal(m, b)
}
func (m *Reject) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Reject.Marshal(b, m, deterministic)
}
func (m *Reject) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Reject.Merge(m, src)
}
func (m *Reject) XXX_Size() int {
	return xxx_messageInfo_Reject.Size(m)
}
func (m *Reject) XXX_DiscardUnknown() {
	xxx_messageInfo_Reject.DiscardUnknown(m)
}

var xxx_messageInfo_Reject proto.InternalMessageInfo

func (m *Reject) GetType() Reject_RejectType {
	if m != nil && m.Type != nil {
		return *m.Type
	}
	return Reject_None
}

func (m *Reject) GetReason() string {
	if m != nil && m.Reason != nil {
		return *m.Reason
	}
	return ""
}

// ServerSync message is sent by the server when it has authenticated the user
// and finished synchronizing the server state.
type ServerSync struct {
	// The session of the current user.
	Session *uint32 `protobuf:"varint,1,opt,name=session" json:"session,omitempty"`
	// Maximum bandwidth that the user should use.
	MaxBandwidth *uint32 `protobuf:"varint,2,opt,name=max_bandwidth,json=maxBandwidth" json:"max_bandwidth,omitempty"`
	// Server welcome text.
	WelcomeText *string `protobuf:"bytes,3,opt,name=welcome_text,json=welcomeText" json:"welcome_text,omitempty"`
	// Current user permissions in the root channel.
	Permissions          *uint64  `protobuf:"varint,4,opt,name=permissions" json:"permissions,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ServerSync) Reset()         { *m = ServerSync{} }
func (m *ServerSync) String() string { return proto.CompactTextString(m) }
func (*ServerSync) ProtoMessage()    {}
func (*ServerSync) Descriptor() ([]byte, []int) {
	return fileDescriptor_56c09c2dce0fb003, []int{5}
}

func (m *ServerSync) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ServerSync.Unmarshal(m, b)
}
func (m *ServerSync) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ServerSync.Marshal(b, m, deterministic)
}
func (m *ServerSync) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ServerSync.Merge(m, src)
}
func (m *ServerSync) XXX_Size() int {
	return xxx_messageInfo_ServerSync.Size(m)
}
func (m *ServerSync) XXX_DiscardUnknown() {
	xxx_messageInfo_ServerSync.DiscardUnknown(m)
}

var xxx_messageInfo_ServerSync proto.InternalMessageInfo

func (m *ServerSync) GetSession() uint32 {
	if m != nil && m.Session != nil {
		return *m.Session
	}
	return 0
}

func (m *ServerSync) GetMaxBandwidth() uint32 {
	if m != nil && m.MaxBandwidth != nil {
		return *m.MaxBandwidth
	}
	return 0
}

func (m *ServerSync) GetWelcomeText() string {
	if m != nil && m.WelcomeText != nil {
		return *m.WelcomeText
	}
	return ""
}

func (m *ServerSync) GetPermissions() uint64 {
	if m != nil && m.Permissions != nil {
		return *m.Permissions
	}
	return 0
}

// Sent by the client when it wants a channel removed. Sent by the server when
// a channel has been removed and clients should be notified.
type ChannelRemove struct {
	ChannelId            *uint32  `protobuf:"varint,1,req,name=channel_id,json=channelId" json:"channel_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ChannelRemove) Reset()         { *m = ChannelRemove{} }
func (m *ChannelRemove) String() string { return proto.CompactTextString(m) }
func (*ChannelRemove) ProtoMessage()    {}
func (*ChannelRemove) Descriptor() ([]byte, []int) {
	return fileDescriptor_56c09c2dce0fb003, []int{6}
}

func (m *ChannelRemove) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ChannelRemove.Unmarshal(m, b)
}
func (m *ChannelRemove) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ChannelRemove.Marshal(b, m, deterministic)
}
func (m *ChannelRemove) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ChannelRemove.Merge(m, src)
}
func (m *ChannelRemove) XXX_Size() int {
	return xxx_messageInfo_ChannelRemove.Size(m)
}
func (m *ChannelRemove) XXX_DiscardUnknown() {
	xxx_messageInfo_ChannelRemove.DiscardUnknown(m)
}

var xxx_messageInfo_ChannelRemove proto.InternalMessageInfo

func (m *ChannelRemove) GetChannelId() uint32 {
	if m != nil && m.ChannelId != nil {
		return *m.ChannelId
	}
	return 0
}

// Used to communicate channel properties between the client and the server.
// Sent by the server during the login process or when channel properties are
// updated. Client may use this message to update said channel properties.
type ChannelState struct {
	// Unique ID for the channel within the server.
	ChannelId *uint32 `protobuf:"varint,1,opt,name=channel_id,json=channelId" json:"channel_id,omitempty"`
	// channel_id of the parent channel.
	Parent *uint32 `protobuf:"varint,2,opt,name=parent" json:"parent,omitempty"`
	// UTF-8 encoded channel name.
	Name *string `protobuf:"bytes,3,opt,name=name" json:"name,omitempty"`
	// A collection of channel id values of the linked channels. Absent during
	// the first channel listing.
	Links []uint32 `protobuf:"varint,4,rep,name=links" json:"links,omitempty"`
	// UTF-8 encoded channel description. Only if the description is less than
	// 128 bytes
	Description *string `protobuf:"bytes,5,opt,name=description" json:"description,omitempty"`
	// A collection of channel_id values that should be added to links.
	LinksAdd []uint32 `protobuf:"varint,6,rep,name=links_add,json=linksAdd" json:"links_add,omitempty"`
	// A collection of channel_id values that should be removed from links.
	LinksRemove []uint32 `protobuf:"varint,7,rep,name=links_remove,json=linksRemove" json:"links_remove,omitempty"`
	// True if the channel is temporary.
	Temporary *bool `protobuf:"varint,8,opt,name=temporary,def=0" json:"temporary,omitempty"`
	// Position weight to tweak the channel position in the channel list.
	Position *int32 `protobuf:"varint,9,opt,name=position,def=0" json:"position,omitempty"`
	// SHA1 hash of the description if the description is 128 bytes or more.
	DescriptionHash []byte `protobuf:"bytes,10,opt,name=description_hash,json=descriptionHash" json:"description_hash,omitempty"`
	// Maximum number of users allowed in the channel. If this value is zero,
	// the maximum number of users allowed in the channel is given by the
	// server's "usersperchannel" setting.
	MaxUsers *uint32 `protobuf:"varint,11,opt,name=max_users,json=maxUsers" json:"max_users,omitempty"`
	// Whether this channel has enter restrictions (ACL denying ENTER) set
	IsEnterRestricted *bool `protobuf:"varint,12,opt,name=is_enter_restricted,json=isEnterRestricted" json:"is_enter_restricted,omitempty"`
	// Whether the receiver of this msg is considered to be able to enter this channel
	CanEnter             *bool    `protobuf:"varint,13,opt,name=can_enter,json=canEnter" json:"can_enter,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ChannelState) Reset()         { *m = ChannelState{} }
func (m *ChannelState) String() string { return proto.CompactTextString(m) }
func (*ChannelState) ProtoMessage()    {}
func (*ChannelState) Descriptor() ([]byte, []int) {
	return fileDescriptor_56c09c2dce0fb003, []int{7}
}

func (m *ChannelState) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ChannelState.Unmarshal(m, b)
}
func (m *ChannelState) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ChannelState.Marshal(b, m, deterministic)
}
func (m *ChannelState) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ChannelState.Merge(m, src)
}
func (m *ChannelState) XXX_Size() int {
	return xxx_messageInfo_ChannelState.Size(m)
}
func (m *ChannelState) XXX_DiscardUnknown() {
	xxx_messageInfo_ChannelState.DiscardUnknown(m)
}

var xxx_messageInfo_ChannelState proto.InternalMessageInfo

const Default_ChannelState_Temporary bool = false
const Default_ChannelState_Position int32 = 0

func (m *ChannelState) GetChannelId() uint32 {
	if m != nil && m.ChannelId != nil {
		return *m.ChannelId
	}
	return 0
}

func (m *ChannelState) GetParent() uint32 {
	if m != nil && m.Parent != nil {
		return *m.Parent
	}
	return 0
}

func (m *ChannelState) GetName() string {
	if m != nil && m.Name != nil {
		return *m.Name
	}
	return ""
}

func (m *ChannelState) GetLinks() []uint32 {
	if m != nil {
		return m.Links
	}
	return nil
}

func (m *ChannelState) GetDescription() string {
	if m != nil && m.Description != nil {
		return *m.Description
	}
	return ""
}

func (m *ChannelState) GetLinksAdd() []uint32 {
	if m != nil {
		return m.LinksAdd
	}
	return nil
}

func (m *ChannelState) GetLinksRemove() []uint32 {
	if m != nil {
		return m.LinksRemove
	}
	return nil
}

func (m *ChannelState) GetTemporary() bool {
	if m != nil && m.Temporary != nil {
		return *m.Temporary
	}
	return Default_ChannelState_Temporary
}

func (m *ChannelState) GetPosition() int32 {
	if m != nil && m.Position != nil {
		return *m.Position
	}
	return Default_ChannelState_Position
}

func (m *ChannelState) GetDescriptionHash() []byte {
	if m != nil {
		return m.DescriptionHash
	}
	return nil
}

func (m *ChannelState) GetMaxUsers() uint32 {
	if m != nil && m.MaxUsers != nil {
		return *m.MaxUsers
	}
	return 0
}

func (m *ChannelState) GetIsEnterRestricted() bool {
	if m != nil && m.IsEnterRestricted != nil {
		return *m.IsEnterRestricted
	}
	return false
}

func (m *ChannelState) GetCanEnter() bool {
	if m != nil && m.CanEnter != nil {
		return *m.CanEnter
	}
	return false
}

// Used to communicate user leaving or being kicked. May be sent by the client
// when it attempts to kick a user. Sent by the server when it informs the
// clients that a user is not present anymore.
type UserRemove struct {
	// The user who is being kicked, identified by their session, not present
	// when no one is being kicked.
	Session *uint32 `protobuf:"varint,1,req,name=session" json:"session,omitempty"`
	// The user who initiated the removal. Either the user who performs the kick
	// or the user who is currently leaving.
	Actor *uint32 `protobuf:"varint,2,opt,name=actor" json:"actor,omitempty"`
	// Reason for the kick, stored as the ban reason if the user is banned.
	Reason *string `protobuf:"bytes,3,opt,name=reason" json:"reason,omitempty"`
	// True if the kick should result in a ban.
	Ban                  *bool    `protobuf:"varint,4,opt,name=ban" json:"ban,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *UserRemove) Reset()         { *m = UserRemove{} }
func (m *UserRemove) String() string { return proto.CompactTextString(m) }
func (*UserRemove) ProtoMessage()    {}
func (*UserRemove) Descriptor() ([]byte, []int) {
	return fileDescriptor_56c09c2dce0fb003, []int{8}
}

func (m *UserRemove) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UserRemove.Unmarshal(m, b)
}
func (m *UserRemove) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UserRemove.Marshal(b, m, deterministic)
}
func (m *UserRemove) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UserRemove.Merge(m, src)
}
func (m *UserRemove) XXX_Size() int {
	return xxx_messageInfo_UserRemove.Size(m)
}
func (m *UserRemove) XXX_DiscardUnknown() {
	xxx_messageInfo_UserRemove.DiscardUnknown(m)
}

var xxx_messageInfo_UserRemove proto.InternalMessageInfo

func (m *UserRemove) GetSession() uint32 {
	if m != nil && m.Session != nil {
		return *m.Session
	}
	return 0
}

func (m *UserRemove) GetActor() uint32 {
	if m != nil && m.Actor != nil {
		return *m.Actor
	}
	return 0
}

func (m *UserRemove) GetReason() string {
	if m != nil && m.Reason != nil {
		return *m.Reason
	}
	return ""
}

func (m *UserRemove) GetBan() bool {
	if m != nil && m.Ban != nil {
		return *m.Ban
	}
	return false
}

// Sent by the server when it communicates new and changed users to client.
// First seen during login procedure. May be sent by the client when it wishes
// to alter its state.
type UserState struct {
	// Unique user session ID of the user whose state this is, may change on
	// reconnect.
	Session *uint32 `protobuf:"varint,1,opt,name=session" json:"session,omitempty"`
	// The session of the user who is updating this user.
	Actor *uint32 `protobuf:"varint,2,opt,name=actor" json:"actor,omitempty"`
	// User name, UTF-8 encoded.
	Name *string `protobuf:"bytes,3,opt,name=name" json:"name,omitempty"`
	// Registered user ID if the user is registered.
	UserId *uint32 `protobuf:"varint,4,opt,name=user_id,json=userId" json:"user_id,omitempty"`
	// Channel on which the user is.
	ChannelId *uint32 `protobuf:"varint,5,opt,name=channel_id,json=channelId" json:"channel_id,omitempty"`
	// True if the user is muted by admin.
	Mute *bool `protobuf:"varint,6,opt,name=mute" json:"mute,omitempty"`
	// True if the user is deafened by admin.
	Deaf *bool `protobuf:"varint,7,opt,name=deaf" json:"deaf,omitempty"`
	// True if the user has been suppressed from talking by a reason other than
	// being muted.
	Suppress *bool `protobuf:"varint,8,opt,name=suppress" json:"suppress,omitempty"`
	// True if the user has muted self.
	SelfMute *bool `protobuf:"varint,9,opt,name=self_mute,json=selfMute" json:"self_mute,omitempty"`
	// True if the user has deafened self.
	SelfDeaf *bool `protobuf:"varint,10,opt,name=self_deaf,json=selfDeaf" json:"self_deaf,omitempty"`
	// User image if it is less than 128 bytes.
	Texture []byte `protobuf:"bytes,11,opt,name=texture" json:"texture,omitempty"`
	// The positional audio plugin identifier.
	// Positional audio information is only sent to users who share
	// identical plugin contexts.
	//
	// This value is not trasmitted to clients.
	PluginContext []byte `protobuf:"bytes,12,opt,name=plugin_context,json=pluginContext" json:"plugin_context,omitempty"`
	// The user's plugin-specific identity.
	// This value is not transmitted to clients.
	PluginIdentity *string `protobuf:"bytes,13,opt,name=plugin_identity,json=pluginIdentity" json:"plugin_identity,omitempty"`
	// User comment if it is less than 128 bytes.
	Comment *string `protobuf:"bytes,14,opt,name=comment" json:"comment,omitempty"`
	// The hash of the user certificate.
	Hash *string `protobuf:"bytes,15,opt,name=hash" json:"hash,omitempty"`
	// SHA1 hash of the user comment if it 128 bytes or more.
	CommentHash []byte `protobuf:"bytes,16,opt,name=comment_hash,json=commentHash" json:"comment_hash,omitempty"`
	// SHA1 hash of the user picture if it 128 bytes or more.
	TextureHash []byte `protobuf:"bytes,17,opt,name=texture_hash,json=textureHash" json:"texture_hash,omitempty"`
	// True if the user is a priority speaker.
	PrioritySpeaker *bool `protobuf:"varint,18,opt,name=priority_speaker,json=prioritySpeaker" json:"priority_speaker,omitempty"`
	// True if the user is currently recording.
	Recording *bool `protobuf:"varint,19,opt,name=recording" json:"recording,omitempty"`
	// A list of temporary acces tokens to be respected when processing this request.
	TemporaryAccessTokens []string `protobuf:"bytes,20,rep,name=temporary_access_tokens,json=temporaryAccessTokens" json:"temporary_access_tokens,omitempty"`
	XXX_NoUnkeyedLiteral  struct{} `json:"-"`
	XXX_unrecognized      []byte   `json:"-"`
	XXX_sizecache         int32    `json:"-"`
}

func (m *UserState) Reset()         { *m = UserState{} }
func (m *UserState) String() string { return proto.CompactTextString(m) }
func (*UserState) ProtoMessage()    {}
func (*UserState) Descriptor() ([]byte, []int) {
	return fileDescriptor_56c09c2dce0fb003, []int{9}
}

func (m *UserState) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UserState.Unmarshal(m, b)
}
func (m *UserState) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UserState.Marshal(b, m, deterministic)
}
func (m *UserState) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UserState.Merge(m, src)
}
func (m *UserState) XXX_Size() int {
	return xxx_messageInfo_UserState.Size(m)
}
func (m *UserState) XXX_DiscardUnknown() {
	xxx_messageInfo_UserState.DiscardUnknown(m)
}

var xxx_messageInfo_UserState proto.InternalMessageInfo

func (m *UserState) GetSession() uint32 {
	if m != nil && m.Session != nil {
		return *m.Session
	}
	return 0
}

func (m *UserState) GetActor() uint32 {
	if m != nil && m.Actor != nil {
		return *m.Actor
	}
	return 0
}

func (m *UserState) GetName() string {
	if m != nil && m.Name != nil {
		return *m.Name
	}
	return ""
}

func (m *UserState) GetUserId() uint32 {
	if m != nil && m.UserId != nil {
		return *m.UserId
	}
	return 0
}

func (m *UserState) GetChannelId() uint32 {
	if m != nil && m.ChannelId != nil {
		return *m.ChannelId
	}
	return 0
}

func (m *UserState) GetMute() bool {
	if m != nil && m.Mute != nil {
		return *m.Mute
	}
	return false
}

func (m *UserState) GetDeaf() bool {
	if m != nil && m.Deaf != nil {
		return *m.Deaf
	}
	return false
}

func (m *UserState) GetSuppress() bool {
	if m != nil && m.Suppress != nil {
		return *m.Suppress
	}
	return false
}

func (m *UserState) GetSelfMute() bool {
	if m != nil && m.SelfMute != nil {
		return *m.SelfMute
	}
	return false
}

func (m *UserState) GetSelfDeaf() bool {
	if m != nil && m.SelfDeaf != nil {
		return *m.SelfDeaf
	}
	return false
}

func (m *UserState) GetTexture() []byte {
	if m != nil {
		return m.Texture
	}
	return nil
}

func (m *UserState) GetPluginContext() []byte {
	if m != nil {
		return m.PluginContext
	}
	return nil
}

func (m *UserState) GetPluginIdentity() string {
	if m != nil && m.PluginIdentity != nil {
		return *m.PluginIdentity
	}
	return ""
}

func (m *UserState) GetComment() string {
	if m != nil && m.Comment != nil {
		return *m.Comment
	}
	return ""
}

func (m *UserState) GetHash() string {
	if m != nil && m.Hash != nil {
		return *m.Hash
	}
	return ""
}

func (m *UserState) GetCommentHash() []byte {
	if m != nil {
		return m.CommentHash
	}
	return nil
}

func (m *UserState) GetTextureHash() []byte {
	if m != nil {
		return m.TextureHash
	}
	return nil
}

func (m *UserState) GetPrioritySpeaker() bool {
	if m != nil && m.PrioritySpeaker != nil {
		return *m.PrioritySpeaker
	}
	return false
}

func (m *UserState) GetRecording() bool {
	if m != nil && m.Recording != nil {
		return *m.Recording
	}
	return false
}

func (m *UserState) GetTemporaryAccessTokens() []string {
	if m != nil {
		return m.TemporaryAccessTokens
	}
	return nil
}

// Relays information on the bans. The client may send the BanList message to
// either modify the list of bans or query them from the server. The server
// sends this list only after a client queries for it.
type BanList struct {
	// List of ban entries currently in place.
	Bans []*BanList_BanEntry `protobuf:"bytes,1,rep,name=bans" json:"bans,omitempty"`
	// True if the server should return the list, false if it should replace old
	// ban list with the one provided.
	Query                *bool    `protobuf:"varint,2,opt,name=query,def=0" json:"query,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *BanList) Reset()         { *m = BanList{} }
func (m *BanList) String() string { return proto.CompactTextString(m) }
func (*BanList) ProtoMessage()    {}
func (*BanList) Descriptor() ([]byte, []int) {
	return fileDescriptor_56c09c2dce0fb003, []int{10}
}

func (m *BanList) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BanList.Unmarshal(m, b)
}
func (m *BanList) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BanList.Marshal(b, m, deterministic)
}
func (m *BanList) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BanList.Merge(m, src)
}
func (m *BanList) XXX_Size() int {
	return xxx_messageInfo_BanList.Size(m)
}
func (m *BanList) XXX_DiscardUnknown() {
	xxx_messageInfo_BanList.DiscardUnknown(m)
}

var xxx_messageInfo_BanList proto.InternalMessageInfo

const Default_BanList_Query bool = false

func (m *BanList) GetBans() []*BanList_BanEntry {
	if m != nil {
		return m.Bans
	}
	return nil
}

func (m *BanList) GetQuery() bool {
	if m != nil && m.Query != nil {
		return *m.Query
	}
	return Default_BanList_Query
}

type BanList_BanEntry struct {
	// Banned IP address.
	Address []byte `protobuf:"bytes,1,req,name=address" json:"address,omitempty"`
	// The length of the subnet mask for the ban.
	Mask *uint32 `protobuf:"varint,2,req,name=mask" json:"mask,omitempty"`
	// User name for identification purposes (does not affect the ban).
	Name *string `protobuf:"bytes,3,opt,name=name" json:"name,omitempty"`
	// The certificate hash of the banned user.
	Hash *string `protobuf:"bytes,4,opt,name=hash" json:"hash,omitempty"`
	// Reason for the ban (does not affect the ban).
	Reason *string `protobuf:"bytes,5,opt,name=reason" json:"reason,omitempty"`
	// Ban start time.
	Start *string `protobuf:"bytes,6,opt,name=start" json:"start,omitempty"`
	// Ban duration in seconds.
	Duration             *uint32  `protobuf:"varint,7,opt,name=duration" json:"duration,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *BanList_BanEntry) Reset()         { *m = BanList_BanEntry{} }
func (m *BanList_BanEntry) String() string { return proto.CompactTextString(m) }
func (*BanList_BanEntry) ProtoMessage()    {}
func (*BanList_BanEntry) Descriptor() ([]byte, []int) {
	return fileDescriptor_56c09c2dce0fb003, []int{10, 0}
}

func (m *BanList_BanEntry) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BanList_BanEntry.Unmarshal(m, b)
}
func (m *BanList_BanEntry) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BanList_BanEntry.Marshal(b, m, deterministic)
}
func (m *BanList_BanEntry) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BanList_BanEntry.Merge(m, src)
}
func (m *BanList_BanEntry) XXX_Size() int {
	return xxx_messageInfo_BanList_BanEntry.Size(m)
}
func (m *BanList_BanEntry) XXX_DiscardUnknown() {
	xxx_messageInfo_BanList_BanEntry.DiscardUnknown(m)
}

var xxx_messageInfo_BanList_BanEntry proto.InternalMessageInfo

func (m *BanList_BanEntry) GetAddress() []byte {
	if m != nil {
		return m.Address
	}
	return nil
}

func (m *BanList_BanEntry) GetMask() uint32 {
	if m != nil && m.Mask != nil {
		return *m.Mask
	}
	return 0
}

func (m *BanList_BanEntry) GetName() string {
	if m != nil && m.Name != nil {
		return *m.Name
	}
	return ""
}

func (m *BanList_BanEntry) GetHash() string {
	if m != nil && m.Hash != nil {
		return *m.Hash
	}
	return ""
}

func (m *BanList_BanEntry) GetReason() string {
	if m != nil && m.Reason != nil {
		return *m.Reason
	}
	return ""
}

func (m *BanList_BanEntry) GetStart() string {
	if m != nil && m.Start != nil {
		return *m.Start
	}
	return ""
}

func (m *BanList_BanEntry) GetDuration() uint32 {
	if m != nil && m.Duration != nil {
		return *m.Duration
	}
	return 0
}

// Used to send and broadcast text messages.
type TextMessage struct {
	// The message sender, identified by its session.
	Actor *uint32 `protobuf:"varint,1,opt,name=actor" json:"actor,omitempty"`
	// Target users for the message, identified by their session.
	Session []uint32 `protobuf:"varint,2,rep,name=session" json:"session,omitempty"`
	// The channels to which the message is sent, identified by their
	// channel_ids.
	ChannelId []uint32 `protobuf:"varint,3,rep,name=channel_id,json=channelId" json:"channel_id,omitempty"`
	// The root channels when sending message recursively to several channels,
	// identified by their channel_ids.
	TreeId []uint32 `protobuf:"varint,4,rep,name=tree_id,json=treeId" json:"tree_id,omitempty"`
	// The UTF-8 encoded message. May be HTML if the server allows.
	Message              *string  `protobuf:"bytes,5,req,name=message" json:"message,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *TextMessage) Reset()         { *m = TextMessage{} }
func (m *TextMessage) String() string { return proto.CompactTextString(m) }
func (*TextMessage) ProtoMessage()    {}
func (*TextMessage) Descriptor() ([]byte, []int) {
	return fileDescriptor_56c09c2dce0fb003, []int{11}
}

func (m *TextMessage) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TextMessage.Unmarshal(m, b)
}
func (m *TextMessage) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TextMessage.Marshal(b, m, deterministic)
}
func (m *TextMessage) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TextMessage.Merge(m, src)
}
func (m *TextMessage) XXX_Size() int {
	return xxx_messageInfo_TextMessage.Size(m)
}
func (m *TextMessage) XXX_DiscardUnknown() {
	xxx_messageInfo_TextMessage.DiscardUnknown(m)
}

var xxx_messageInfo_TextMessage proto.InternalMessageInfo

func (m *TextMessage) GetActor() uint32 {
	if m != nil && m.Actor != nil {
		return *m.Actor
	}
	return 0
}

func (m *TextMessage) GetSession() []uint32 {
	if m != nil {
		return m.Session
	}
	return nil
}

func (m *TextMessage) GetChannelId() []uint32 {
	if m != nil {
		return m.ChannelId
	}
	return nil
}

func (m *TextMessage) GetTreeId() []uint32 {
	if m != nil {
		return m.TreeId
	}
	return nil
}

func (m *TextMessage) GetMessage() string {
	if m != nil && m.Message != nil {
		return *m.Message
	}
	return ""
}

type PermissionDenied struct {
	// The denied permission when type is Permission.
	Permission *uint32 `protobuf:"varint,1,opt,name=permission" json:"permission,omitempty"`
	// channel_id for the channel where the permission was denied when type is
	// Permission.
	ChannelId *uint32 `protobuf:"varint,2,opt,name=channel_id,json=channelId" json:"channel_id,omitempty"`
	// The user who was denied permissions, identified by session.
	Session *uint32 `protobuf:"varint,3,opt,name=session" json:"session,omitempty"`
	// Textual reason for the denial.
	Reason *string `protobuf:"bytes,4,opt,name=reason" json:"reason,omitempty"`
	// Type of the denial.
	Type *PermissionDenied_DenyType `protobuf:"varint,5,opt,name=type,enum=MumbleProto.PermissionDenied_DenyType" json:"type,omitempty"`
	// The name that is invalid when type is UserName.
	Name                 *string  `protobuf:"bytes,6,opt,name=name" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *PermissionDenied) Reset()         { *m = PermissionDenied{} }
func (m *PermissionDenied) String() string { return proto.CompactTextString(m) }
func (*PermissionDenied) ProtoMessage()    {}
func (*PermissionDenied) Descriptor() ([]byte, []int) {
	return fileDescriptor_56c09c2dce0fb003, []int{12}
}

func (m *PermissionDenied) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PermissionDenied.Unmarshal(m, b)
}
func (m *PermissionDenied) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PermissionDenied.Marshal(b, m, deterministic)
}
func (m *PermissionDenied) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PermissionDenied.Merge(m, src)
}
func (m *PermissionDenied) XXX_Size() int {
	return xxx_messageInfo_PermissionDenied.Size(m)
}
func (m *PermissionDenied) XXX_DiscardUnknown() {
	xxx_messageInfo_PermissionDenied.DiscardUnknown(m)
}

var xxx_messageInfo_PermissionDenied proto.InternalMessageInfo

func (m *PermissionDenied) GetPermission() uint32 {
	if m != nil && m.Permission != nil {
		return *m.Permission
	}
	return 0
}

func (m *PermissionDenied) GetChannelId() uint32 {
	if m != nil && m.ChannelId != nil {
		return *m.ChannelId
	}
	return 0
}

func (m *PermissionDenied) GetSession() uint32 {
	if m != nil && m.Session != nil {
		return *m.Session
	}
	return 0
}

func (m *PermissionDenied) GetReason() string {
	if m != nil && m.Reason != nil {
		return *m.Reason
	}
	return ""
}

func (m *PermissionDenied) GetType() PermissionDenied_DenyType {
	if m != nil && m.Type != nil {
		return *m.Type
	}
	return PermissionDenied_Text
}

func (m *PermissionDenied) GetName() string {
	if m != nil && m.Name != nil {
		return *m.Name
	}
	return ""
}

type ACL struct {
	// Channel ID of the channel this message affects.
	ChannelId *uint32 `protobuf:"varint,1,req,name=channel_id,json=channelId" json:"channel_id,omitempty"`
	// True if the channel inherits its parent's ACLs.
	InheritAcls *bool `protobuf:"varint,2,opt,name=inherit_acls,json=inheritAcls,def=1" json:"inherit_acls,omitempty"`
	// User group specifications.
	Groups []*ACL_ChanGroup `protobuf:"bytes,3,rep,name=groups" json:"groups,omitempty"`
	// ACL specifications.
	Acls []*ACL_ChanACL `protobuf:"bytes,4,rep,name=acls" json:"acls,omitempty"`
	// True if the message is a query for ACLs instead of setting them.
	Query                *bool    `protobuf:"varint,5,opt,name=query,def=0" json:"query,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ACL) Reset()         { *m = ACL{} }
func (m *ACL) String() string { return proto.CompactTextString(m) }
func (*ACL) ProtoMessage()    {}
func (*ACL) Descriptor() ([]byte, []int) {
	return fileDescriptor_56c09c2dce0fb003, []int{13}
}

func (m *ACL) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ACL.Unmarshal(m, b)
}
func (m *ACL) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ACL.Marshal(b, m, deterministic)
}
func (m *ACL) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ACL.Merge(m, src)
}
func (m *ACL) XXX_Size() int {
	return xxx_messageInfo_ACL.Size(m)
}
func (m *ACL) XXX_DiscardUnknown() {
	xxx_messageInfo_ACL.DiscardUnknown(m)
}

var xxx_messageInfo_ACL proto.InternalMessageInfo

const Default_ACL_InheritAcls bool = true
const Default_ACL_Query bool = false

func (m *ACL) GetChannelId() uint32 {
	if m != nil && m.ChannelId != nil {
		return *m.ChannelId
	}
	return 0
}

func (m *ACL) GetInheritAcls() bool {
	if m != nil && m.InheritAcls != nil {
		return *m.InheritAcls
	}
	return Default_ACL_InheritAcls
}

func (m *ACL) GetGroups() []*ACL_ChanGroup {
	if m != nil {
		return m.Groups
	}
	return nil
}

func (m *ACL) GetAcls() []*ACL_ChanACL {
	if m != nil {
		return m.Acls
	}
	return nil
}

func (m *ACL) GetQuery() bool {
	if m != nil && m.Query != nil {
		return *m.Query
	}
	return Default_ACL_Query
}

type ACL_ChanGroup struct {
	// Name of the channel group, UTF-8 encoded.
	Name *string `protobuf:"bytes,1,req,name=name" json:"name,omitempty"`
	// True if the group has been inherited from the parent (Read only).
	Inherited *bool `protobuf:"varint,2,opt,name=inherited,def=1" json:"inherited,omitempty"`
	// True if the group members are inherited.
	Inherit *bool `protobuf:"varint,3,opt,name=inherit,def=1" json:"inherit,omitempty"`
	// True if the group can be inherited by sub channels.
	Inheritable *bool `protobuf:"varint,4,opt,name=inheritable,def=1" json:"inheritable,omitempty"`
	// Users explicitly included in this group, identified by user_id.
	Add []uint32 `protobuf:"varint,5,rep,name=add" json:"add,omitempty"`
	// Users explicitly removed from this group in this channel if the group
	// has been inherited, identified by user_id.
	Remove []uint32 `protobuf:"varint,6,rep,name=remove" json:"remove,omitempty"`
	// Users inherited, identified by user_id.
	InheritedMembers     []uint32 `protobuf:"varint,7,rep,name=inherited_members,json=inheritedMembers" json:"inherited_members,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ACL_ChanGroup) Reset()         { *m = ACL_ChanGroup{} }
func (m *ACL_ChanGroup) String() string { return proto.CompactTextString(m) }
func (*ACL_ChanGroup) ProtoMessage()    {}
func (*ACL_ChanGroup) Descriptor() ([]byte, []int) {
	return fileDescriptor_56c09c2dce0fb003, []int{13, 0}
}

func (m *ACL_ChanGroup) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ACL_ChanGroup.Unmarshal(m, b)
}
func (m *ACL_ChanGroup) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ACL_ChanGroup.Marshal(b, m, deterministic)
}
func (m *ACL_ChanGroup) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ACL_ChanGroup.Merge(m, src)
}
func (m *ACL_ChanGroup) XXX_Size() int {
	return xxx_messageInfo_ACL_ChanGroup.Size(m)
}
func (m *ACL_ChanGroup) XXX_DiscardUnknown() {
	xxx_messageInfo_ACL_ChanGroup.DiscardUnknown(m)
}

var xxx_messageInfo_ACL_ChanGroup proto.InternalMessageInfo

const Default_ACL_ChanGroup_Inherited bool = true
const Default_ACL_ChanGroup_Inherit bool = true
const Default_ACL_ChanGroup_Inheritable bool = true

func (m *ACL_ChanGroup) GetName() string {
	if m != nil && m.Name != nil {
		return *m.Name
	}
	return ""
}

func (m *ACL_ChanGroup) GetInherited() bool {
	if m != nil && m.Inherited != nil {
		return *m.Inherited
	}
	return Default_ACL_ChanGroup_Inherited
}

func (m *ACL_ChanGroup) GetInherit() bool {
	if m != nil && m.Inherit != nil {
		return *m.Inherit
	}
	return Default_ACL_ChanGroup_Inherit
}

func (m *ACL_ChanGroup) GetInheritable() bool {
	if m != nil && m.Inheritable != nil {
		return *m.Inheritable
	}
	return Default_ACL_ChanGroup_Inheritable
}

func (m *ACL_ChanGroup) GetAdd() []uint32 {
	if m != nil {
		return m.Add
	}
	return nil
}

func (m *ACL_ChanGroup) GetRemove() []uint32 {
	if m != nil {
		return m.Remove
	}
	return nil
}

func (m *ACL_ChanGroup) GetInheritedMembers() []uint32 {
	if m != nil {
		return m.InheritedMembers
	}
	return nil
}

type ACL_ChanACL struct {
	// True if this ACL applies to the current channel.
	ApplyHere *bool `protobuf:"varint,1,opt,name=apply_here,json=applyHere,def=1" json:"apply_here,omitempty"`
	// True if this ACL applies to the sub channels.
	ApplySubs *bool `protobuf:"varint,2,opt,name=apply_subs,json=applySubs,def=1" json:"apply_subs,omitempty"`
	// True if the ACL has been inherited from the parent.
	Inherited *bool `protobuf:"varint,3,opt,name=inherited,def=1" json:"inherited,omitempty"`
	// ID of the user that is affected by this ACL.
	UserId *uint32 `protobuf:"varint,4,opt,name=user_id,json=userId" json:"user_id,omitempty"`
	// ID of the group that is affected by this ACL.
	Group *string `protobuf:"bytes,5,opt,name=group" json:"group,omitempty"`
	// Bit flag field of the permissions granted by this ACL.
	Grant *uint32 `protobuf:"varint,6,opt,name=grant" json:"grant,omitempty"`
	// Bit flag field of the permissions denied by this ACL.
	Deny                 *uint32  `protobuf:"varint,7,opt,name=deny" json:"deny,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ACL_ChanACL) Reset()         { *m = ACL_ChanACL{} }
func (m *ACL_ChanACL) String() string { return proto.CompactTextString(m) }
func (*ACL_ChanACL) ProtoMessage()    {}
func (*ACL_ChanACL) Descriptor() ([]byte, []int) {
	return fileDescriptor_56c09c2dce0fb003, []int{13, 1}
}

func (m *ACL_ChanACL) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ACL_ChanACL.Unmarshal(m, b)
}
func (m *ACL_ChanACL) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ACL_ChanACL.Marshal(b, m, deterministic)
}
func (m *ACL_ChanACL) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ACL_ChanACL.Merge(m, src)
}
func (m *ACL_ChanACL) XXX_Size() int {
	return xxx_messageInfo_ACL_ChanACL.Size(m)
}
func (m *ACL_ChanACL) XXX_DiscardUnknown() {
	xxx_messageInfo_ACL_ChanACL.DiscardUnknown(m)
}

var xxx_messageInfo_ACL_ChanACL proto.InternalMessageInfo

const Default_ACL_ChanACL_ApplyHere bool = true
const Default_ACL_ChanACL_ApplySubs bool = true
const Default_ACL_ChanACL_Inherited bool = true

func (m *ACL_ChanACL) GetApplyHere() bool {
	if m != nil && m.ApplyHere != nil {
		return *m.ApplyHere
	}
	return Default_ACL_ChanACL_ApplyHere
}

func (m *ACL_ChanACL) GetApplySubs() bool {
	if m != nil && m.ApplySubs != nil {
		return *m.ApplySubs
	}
	return Default_ACL_ChanACL_ApplySubs
}

func (m *ACL_ChanACL) GetInherited() bool {
	if m != nil && m.Inherited != nil {
		return *m.Inherited
	}
	return Default_ACL_ChanACL_Inherited
}

func (m *ACL_ChanACL) GetUserId() uint32 {
	if m != nil && m.UserId != nil {
		return *m.UserId
	}
	return 0
}

func (m *ACL_ChanACL) GetGroup() string {
	if m != nil && m.Group != nil {
		return *m.Group
	}
	return ""
}

func (m *ACL_ChanACL) GetGrant() uint32 {
	if m != nil && m.Grant != nil {
		return *m.Grant
	}
	return 0
}

func (m *ACL_ChanACL) GetDeny() uint32 {
	if m != nil && m.Deny != nil {
		return *m.Deny
	}
	return 0
}

// Client may use this message to refresh its registered user information. The
// client should fill the IDs or Names of the users it wants to refresh. The
// server fills the missing parts and sends the message back.
type QueryUsers struct {
	// user_ids.
	Ids []uint32 `protobuf:"varint,1,rep,name=ids" json:"ids,omitempty"`
	// User names in the same order as ids.
	Names                []string `protobuf:"bytes,2,rep,name=names" json:"names,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *QueryUsers) Reset()         { *m = QueryUsers{} }
func (m *QueryUsers) String() string { return proto.CompactTextString(m) }
func (*QueryUsers) ProtoMessage()    {}
func (*QueryUsers) Descriptor() ([]byte, []int) {
	return fileDescriptor_56c09c2dce0fb003, []int{14}
}

func (m *QueryUsers) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_QueryUsers.Unmarshal(m, b)
}
func (m *QueryUsers) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_QueryUsers.Marshal(b, m, deterministic)
}
func (m *QueryUsers) XXX_Merge(src proto.Message) {
	xxx_messageInfo_QueryUsers.Merge(m, src)
}
func (m *QueryUsers) XXX_Size() int {
	return xxx_messageInfo_QueryUsers.Size(m)
}
func (m *QueryUsers) XXX_DiscardUnknown() {
	xxx_messageInfo_QueryUsers.DiscardUnknown(m)
}

var xxx_messageInfo_QueryUsers proto.InternalMessageInfo

func (m *QueryUsers) GetIds() []uint32 {
	if m != nil {
		return m.Ids
	}
	return nil
}

func (m *QueryUsers) GetNames() []string {
	if m != nil {
		return m.Names
	}
	return nil
}

// Used to initialize and resync the UDP encryption. Either side may request a
// resync by sending the message without any values filled. The resync is
// performed by sending the message with only the client or server nonce
// filled.
type CryptSetup struct {
	// Encryption key.
	Key []byte `protobuf:"bytes,1,opt,name=key" json:"key,omitempty"`
	// Client nonce.
	ClientNonce []byte `protobuf:"bytes,2,opt,name=client_nonce,json=clientNonce" json:"client_nonce,omitempty"`
	// Server nonce.
	ServerNonce          []byte   `protobuf:"bytes,3,opt,name=server_nonce,json=serverNonce" json:"server_nonce,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CryptSetup) Reset()         { *m = CryptSetup{} }
func (m *CryptSetup) String() string { return proto.CompactTextString(m) }
func (*CryptSetup) ProtoMessage()    {}
func (*CryptSetup) Descriptor() ([]byte, []int) {
	return fileDescriptor_56c09c2dce0fb003, []int{15}
}

func (m *CryptSetup) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CryptSetup.Unmarshal(m, b)
}
func (m *CryptSetup) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CryptSetup.Marshal(b, m, deterministic)
}
func (m *CryptSetup) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CryptSetup.Merge(m, src)
}
func (m *CryptSetup) XXX_Size() int {
	return xxx_messageInfo_CryptSetup.Size(m)
}
func (m *CryptSetup) XXX_DiscardUnknown() {
	xxx_messageInfo_CryptSetup.DiscardUnknown(m)
}

var xxx_messageInfo_CryptSetup proto.InternalMessageInfo

func (m *CryptSetup) GetKey() []byte {
	if m != nil {
		return m.Key
	}
	return nil
}

func (m *CryptSetup) GetClientNonce() []byte {
	if m != nil {
		return m.ClientNonce
	}
	return nil
}

func (m *CryptSetup) GetServerNonce() []byte {
	if m != nil {
		return m.ServerNonce
	}
	return nil
}

type ContextActionModify struct {
	// The action name.
	Action *string `protobuf:"bytes,1,req,name=action" json:"action,omitempty"`
	// The display name of the action.
	Text *string `protobuf:"bytes,2,opt,name=text" json:"text,omitempty"`
	// Context bit flags defining where the action should be displayed.
	Context              *uint32                        `protobuf:"varint,3,opt,name=context" json:"context,omitempty"`
	Operation            *ContextActionModify_Operation `protobuf:"varint,4,opt,name=operation,enum=MumbleProto.ContextActionModify_Operation" json:"operation,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                       `json:"-"`
	XXX_unrecognized     []byte                         `json:"-"`
	XXX_sizecache        int32                          `json:"-"`
}

func (m *ContextActionModify) Reset()         { *m = ContextActionModify{} }
func (m *ContextActionModify) String() string { return proto.CompactTextString(m) }
func (*ContextActionModify) ProtoMessage()    {}
func (*ContextActionModify) Descriptor() ([]byte, []int) {
	return fileDescriptor_56c09c2dce0fb003, []int{16}
}

func (m *ContextActionModify) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ContextActionModify.Unmarshal(m, b)
}
func (m *ContextActionModify) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ContextActionModify.Marshal(b, m, deterministic)
}
func (m *ContextActionModify) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ContextActionModify.Merge(m, src)
}
func (m *ContextActionModify) XXX_Size() int {
	return xxx_messageInfo_ContextActionModify.Size(m)
}
func (m *ContextActionModify) XXX_DiscardUnknown() {
	xxx_messageInfo_ContextActionModify.DiscardUnknown(m)
}

var xxx_messageInfo_ContextActionModify proto.InternalMessageInfo

func (m *ContextActionModify) GetAction() string {
	if m != nil && m.Action != nil {
		return *m.Action
	}
	return ""
}

func (m *ContextActionModify) GetText() string {
	if m != nil && m.Text != nil {
		return *m.Text
	}
	return ""
}

func (m *ContextActionModify) GetContext() uint32 {
	if m != nil && m.Context != nil {
		return *m.Context
	}
	return 0
}

func (m *ContextActionModify) GetOperation() ContextActionModify_Operation {
	if m != nil && m.Operation != nil {
		return *m.Operation
	}
	return ContextActionModify_Add
}

// Sent by the client when it wants to initiate a Context action.
type ContextAction struct {
	// The target User for the action, identified by session.
	Session *uint32 `protobuf:"varint,1,opt,name=session" json:"session,omitempty"`
	// The target Channel for the action, identified by channel_id.
	ChannelId *uint32 `protobuf:"varint,2,opt,name=channel_id,json=channelId" json:"channel_id,omitempty"`
	// The action that should be executed.
	Action               *string  `protobuf:"bytes,3,req,name=action" json:"action,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ContextAction) Reset()         { *m = ContextAction{} }
func (m *ContextAction) String() string { return proto.CompactTextString(m) }
func (*ContextAction) ProtoMessage()    {}
func (*ContextAction) Descriptor() ([]byte, []int) {
	return fileDescriptor_56c09c2dce0fb003, []int{17}
}

func (m *ContextAction) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ContextAction.Unmarshal(m, b)
}
func (m *ContextAction) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ContextAction.Marshal(b, m, deterministic)
}
func (m *ContextAction) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ContextAction.Merge(m, src)
}
func (m *ContextAction) XXX_Size() int {
	return xxx_messageInfo_ContextAction.Size(m)
}
func (m *ContextAction) XXX_DiscardUnknown() {
	xxx_messageInfo_ContextAction.DiscardUnknown(m)
}

var xxx_messageInfo_ContextAction proto.InternalMessageInfo

func (m *ContextAction) GetSession() uint32 {
	if m != nil && m.Session != nil {
		return *m.Session
	}
	return 0
}

func (m *ContextAction) GetChannelId() uint32 {
	if m != nil && m.ChannelId != nil {
		return *m.ChannelId
	}
	return 0
}

func (m *ContextAction) GetAction() string {
	if m != nil && m.Action != nil {
		return *m.Action
	}
	return ""
}

// Lists the registered users.
type UserList struct {
	// A list of registered users.
	Users                []*UserList_User `protobuf:"bytes,1,rep,name=users" json:"users,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *UserList) Reset()         { *m = UserList{} }
func (m *UserList) String() string { return proto.CompactTextString(m) }
func (*UserList) ProtoMessage()    {}
func (*UserList) Descriptor() ([]byte, []int) {
	return fileDescriptor_56c09c2dce0fb003, []int{18}
}

func (m *UserList) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UserList.Unmarshal(m, b)
}
func (m *UserList) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UserList.Marshal(b, m, deterministic)
}
func (m *UserList) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UserList.Merge(m, src)
}
func (m *UserList) XXX_Size() int {
	return xxx_messageInfo_UserList.Size(m)
}
func (m *UserList) XXX_DiscardUnknown() {
	xxx_messageInfo_UserList.DiscardUnknown(m)
}

var xxx_messageInfo_UserList proto.InternalMessageInfo

func (m *UserList) GetUsers() []*UserList_User {
	if m != nil {
		return m.Users
	}
	return nil
}

type UserList_User struct {
	// Registered user ID.
	UserId *uint32 `protobuf:"varint,1,req,name=user_id,json=userId" json:"user_id,omitempty"`
	// Registered user name.
	Name                 *string  `protobuf:"bytes,2,opt,name=name" json:"name,omitempty"`
	LastSeen             *string  `protobuf:"bytes,3,opt,name=last_seen,json=lastSeen" json:"last_seen,omitempty"`
	LastChannel          *uint32  `protobuf:"varint,4,opt,name=last_channel,json=lastChannel" json:"last_channel,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *UserList_User) Reset()         { *m = UserList_User{} }
func (m *UserList_User) String() string { return proto.CompactTextString(m) }
func (*UserList_User) ProtoMessage()    {}
func (*UserList_User) Descriptor() ([]byte, []int) {
	return fileDescriptor_56c09c2dce0fb003, []int{18, 0}
}

func (m *UserList_User) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UserList_User.Unmarshal(m, b)
}
func (m *UserList_User) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UserList_User.Marshal(b, m, deterministic)
}
func (m *UserList_User) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UserList_User.Merge(m, src)
}
func (m *UserList_User) XXX_Size() int {
	return xxx_messageInfo_UserList_User.Size(m)
}
func (m *UserList_User) XXX_DiscardUnknown() {
	xxx_messageInfo_UserList_User.DiscardUnknown(m)
}

var xxx_messageInfo_UserList_User proto.InternalMessageInfo

func (m *UserList_User) GetUserId() uint32 {
	if m != nil && m.UserId != nil {
		return *m.UserId
	}
	return 0
}

func (m *UserList_User) GetName() string {
	if m != nil && m.Name != nil {
		return *m.Name
	}
	return ""
}

func (m *UserList_User) GetLastSeen() string {
	if m != nil && m.LastSeen != nil {
		return *m.LastSeen
	}
	return ""
}

func (m *UserList_User) GetLastChannel() uint32 {
	if m != nil && m.LastChannel != nil {
		return *m.LastChannel
	}
	return 0
}

// Sent by the client when it wants to register or clear whisper targets.
//
// Note: The first available target ID is 1 as 0 is reserved for normal
// talking. Maximum target ID is 30.
type VoiceTarget struct {
	// Voice target ID.
	Id *uint32 `protobuf:"varint,1,opt,name=id" json:"id,omitempty"`
	// The receivers that this voice target includes.
	Targets              []*VoiceTarget_Target `protobuf:"bytes,2,rep,name=targets" json:"targets,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *VoiceTarget) Reset()         { *m = VoiceTarget{} }
func (m *VoiceTarget) String() string { return proto.CompactTextString(m) }
func (*VoiceTarget) ProtoMessage()    {}
func (*VoiceTarget) Descriptor() ([]byte, []int) {
	return fileDescriptor_56c09c2dce0fb003, []int{19}
}

func (m *VoiceTarget) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_VoiceTarget.Unmarshal(m, b)
}
func (m *VoiceTarget) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_VoiceTarget.Marshal(b, m, deterministic)
}
func (m *VoiceTarget) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VoiceTarget.Merge(m, src)
}
func (m *VoiceTarget) XXX_Size() int {
	return xxx_messageInfo_VoiceTarget.Size(m)
}
func (m *VoiceTarget) XXX_DiscardUnknown() {
	xxx_messageInfo_VoiceTarget.DiscardUnknown(m)
}

var xxx_messageInfo_VoiceTarget proto.InternalMessageInfo

func (m *VoiceTarget) GetId() uint32 {
	if m != nil && m.Id != nil {
		return *m.Id
	}
	return 0
}

func (m *VoiceTarget) GetTargets() []*VoiceTarget_Target {
	if m != nil {
		return m.Targets
	}
	return nil
}

type VoiceTarget_Target struct {
	// Users that are included as targets.
	Session []uint32 `protobuf:"varint,1,rep,name=session" json:"session,omitempty"`
	// Channel that is included as a target.
	ChannelId *uint32 `protobuf:"varint,2,opt,name=channel_id,json=channelId" json:"channel_id,omitempty"`
	// ACL group that is included as a target.
	Group *string `protobuf:"bytes,3,opt,name=group" json:"group,omitempty"`
	// True if the voice should follow links from the specified channel.
	Links *bool `protobuf:"varint,4,opt,name=links,def=0" json:"links,omitempty"`
	// True if the voice should also be sent to children of the specific
	// channel.
	Children             *bool    `protobuf:"varint,5,opt,name=children,def=0" json:"children,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *VoiceTarget_Target) Reset()         { *m = VoiceTarget_Target{} }
func (m *VoiceTarget_Target) String() string { return proto.CompactTextString(m) }
func (*VoiceTarget_Target) ProtoMessage()    {}
func (*VoiceTarget_Target) Descriptor() ([]byte, []int) {
	return fileDescriptor_56c09c2dce0fb003, []int{19, 0}
}

func (m *VoiceTarget_Target) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_VoiceTarget_Target.Unmarshal(m, b)
}
func (m *VoiceTarget_Target) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_VoiceTarget_Target.Marshal(b, m, deterministic)
}
func (m *VoiceTarget_Target) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VoiceTarget_Target.Merge(m, src)
}
func (m *VoiceTarget_Target) XXX_Size() int {
	return xxx_messageInfo_VoiceTarget_Target.Size(m)
}
func (m *VoiceTarget_Target) XXX_DiscardUnknown() {
	xxx_messageInfo_VoiceTarget_Target.DiscardUnknown(m)
}

var xxx_messageInfo_VoiceTarget_Target proto.InternalMessageInfo

const Default_VoiceTarget_Target_Links bool = false
const Default_VoiceTarget_Target_Children bool = false

func (m *VoiceTarget_Target) GetSession() []uint32 {
	if m != nil {
		return m.Session
	}
	return nil
}

func (m *VoiceTarget_Target) GetChannelId() uint32 {
	if m != nil && m.ChannelId != nil {
		return *m.ChannelId
	}
	return 0
}

func (m *VoiceTarget_Target) GetGroup() string {
	if m != nil && m.Group != nil {
		return *m.Group
	}
	return ""
}

func (m *VoiceTarget_Target) GetLinks() bool {
	if m != nil && m.Links != nil {
		return *m.Links
	}
	return Default_VoiceTarget_Target_Links
}

func (m *VoiceTarget_Target) GetChildren() bool {
	if m != nil && m.Children != nil {
		return *m.Children
	}
	return Default_VoiceTarget_Target_Children
}

// Sent by the client when it wants permissions for a certain channel. Sent by
// the server when it replies to the query or wants the user to resync all
// channel permissions.
type PermissionQuery struct {
	// channel_id of the channel for which the permissions are queried.
	ChannelId *uint32 `protobuf:"varint,1,opt,name=channel_id,json=channelId" json:"channel_id,omitempty"`
	// Channel permissions.
	Permissions *uint32 `protobuf:"varint,2,opt,name=permissions" json:"permissions,omitempty"`
	// True if the client should drop its current permission information for all
	// channels.
	Flush                *bool    `protobuf:"varint,3,opt,name=flush,def=0" json:"flush,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *PermissionQuery) Reset()         { *m = PermissionQuery{} }
func (m *PermissionQuery) String() string { return proto.CompactTextString(m) }
func (*PermissionQuery) ProtoMessage()    {}
func (*PermissionQuery) Descriptor() ([]byte, []int) {
	return fileDescriptor_56c09c2dce0fb003, []int{20}
}

func (m *PermissionQuery) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PermissionQuery.Unmarshal(m, b)
}
func (m *PermissionQuery) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PermissionQuery.Marshal(b, m, deterministic)
}
func (m *PermissionQuery) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PermissionQuery.Merge(m, src)
}
func (m *PermissionQuery) XXX_Size() int {
	return xxx_messageInfo_PermissionQuery.Size(m)
}
func (m *PermissionQuery) XXX_DiscardUnknown() {
	xxx_messageInfo_PermissionQuery.DiscardUnknown(m)
}

var xxx_messageInfo_PermissionQuery proto.InternalMessageInfo

const Default_PermissionQuery_Flush bool = false

func (m *PermissionQuery) GetChannelId() uint32 {
	if m != nil && m.ChannelId != nil {
		return *m.ChannelId
	}
	return 0
}

func (m *PermissionQuery) GetPermissions() uint32 {
	if m != nil && m.Permissions != nil {
		return *m.Permissions
	}
	return 0
}

func (m *PermissionQuery) GetFlush() bool {
	if m != nil && m.Flush != nil {
		return *m.Flush
	}
	return Default_PermissionQuery_Flush
}

// Sent by the server to notify the users of the version of the CELT codec they
// should use. This may change during the connection when new users join.
type CodecVersion struct {
	// The version of the CELT Alpha codec.
	Alpha *int32 `protobuf:"varint,1,req,name=alpha" json:"alpha,omitempty"`
	// The version of the CELT Beta codec.
	Beta *int32 `protobuf:"varint,2,req,name=beta" json:"beta,omitempty"`
	// True if the user should prefer Alpha over Beta.
	PreferAlpha          *bool    `protobuf:"varint,3,req,name=prefer_alpha,json=preferAlpha,def=1" json:"prefer_alpha,omitempty"`
	Opus                 *bool    `protobuf:"varint,4,opt,name=opus,def=0" json:"opus,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CodecVersion) Reset()         { *m = CodecVersion{} }
func (m *CodecVersion) String() string { return proto.CompactTextString(m) }
func (*CodecVersion) ProtoMessage()    {}
func (*CodecVersion) Descriptor() ([]byte, []int) {
	return fileDescriptor_56c09c2dce0fb003, []int{21}
}

func (m *CodecVersion) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CodecVersion.Unmarshal(m, b)
}
func (m *CodecVersion) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CodecVersion.Marshal(b, m, deterministic)
}
func (m *CodecVersion) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CodecVersion.Merge(m, src)
}
func (m *CodecVersion) XXX_Size() int {
	return xxx_messageInfo_CodecVersion.Size(m)
}
func (m *CodecVersion) XXX_DiscardUnknown() {
	xxx_messageInfo_CodecVersion.DiscardUnknown(m)
}

var xxx_messageInfo_CodecVersion proto.InternalMessageInfo

const Default_CodecVersion_PreferAlpha bool = true
const Default_CodecVersion_Opus bool = false

func (m *CodecVersion) GetAlpha() int32 {
	if m != nil && m.Alpha != nil {
		return *m.Alpha
	}
	return 0
}

func (m *CodecVersion) GetBeta() int32 {
	if m != nil && m.Beta != nil {
		return *m.Beta
	}
	return 0
}

func (m *CodecVersion) GetPreferAlpha() bool {
	if m != nil && m.PreferAlpha != nil {
		return *m.PreferAlpha
	}
	return Default_CodecVersion_PreferAlpha
}

func (m *CodecVersion) GetOpus() bool {
	if m != nil && m.Opus != nil {
		return *m.Opus
	}
	return Default_CodecVersion_Opus
}

// Used to communicate user stats between the server and clients.
type UserStats struct {
	// User whose stats these are.
	Session *uint32 `protobuf:"varint,1,opt,name=session" json:"session,omitempty"`
	// True if the message contains only mutable stats (packets, ping).
	StatsOnly *bool `protobuf:"varint,2,opt,name=stats_only,json=statsOnly,def=0" json:"stats_only,omitempty"`
	// Full user certificate chain of the user certificate in DER format.
	Certificates [][]byte `protobuf:"bytes,3,rep,name=certificates" json:"certificates,omitempty"`
	// Packet statistics for packets received from the client.
	FromClient *UserStats_Stats `protobuf:"bytes,4,opt,name=from_client,json=fromClient" json:"from_client,omitempty"`
	// Packet statistics for packets sent by the server.
	FromServer *UserStats_Stats `protobuf:"bytes,5,opt,name=from_server,json=fromServer" json:"from_server,omitempty"`
	// Amount of UDP packets sent.
	UdpPackets *uint32 `protobuf:"varint,6,opt,name=udp_packets,json=udpPackets" json:"udp_packets,omitempty"`
	// Amount of TCP packets sent.
	TcpPackets *uint32 `protobuf:"varint,7,opt,name=tcp_packets,json=tcpPackets" json:"tcp_packets,omitempty"`
	// UDP ping average.
	UdpPingAvg *float32 `protobuf:"fixed32,8,opt,name=udp_ping_avg,json=udpPingAvg" json:"udp_ping_avg,omitempty"`
	// UDP ping variance.
	UdpPingVar *float32 `protobuf:"fixed32,9,opt,name=udp_ping_var,json=udpPingVar" json:"udp_ping_var,omitempty"`
	// TCP ping average.
	TcpPingAvg *float32 `protobuf:"fixed32,10,opt,name=tcp_ping_avg,json=tcpPingAvg" json:"tcp_ping_avg,omitempty"`
	// TCP ping variance.
	TcpPingVar *float32 `protobuf:"fixed32,11,opt,name=tcp_ping_var,json=tcpPingVar" json:"tcp_ping_var,omitempty"`
	// Client version.
	Version *Version `protobuf:"bytes,12,opt,name=version" json:"version,omitempty"`
	// A list of CELT bitstream version constants supported by the client of this
	// user.
	CeltVersions []int32 `protobuf:"varint,13,rep,name=celt_versions,json=celtVersions" json:"celt_versions,omitempty"`
	// Client IP address.
	Address []byte `protobuf:"bytes,14,opt,name=address" json:"address,omitempty"`
	// Bandwith used by this client.
	Bandwidth *uint32 `protobuf:"varint,15,opt,name=bandwidth" json:"bandwidth,omitempty"`
	// Connection duration.
	Onlinesecs *uint32 `protobuf:"varint,16,opt,name=onlinesecs" json:"onlinesecs,omitempty"`
	// Duration since last activity.
	Idlesecs *uint32 `protobuf:"varint,17,opt,name=idlesecs" json:"idlesecs,omitempty"`
	// True if the user has a strong certificate.
	StrongCertificate    *bool    `protobuf:"varint,18,opt,name=strong_certificate,json=strongCertificate,def=0" json:"strong_certificate,omitempty"`
	Opus                 *bool    `protobuf:"varint,19,opt,name=opus,def=0" json:"opus,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *UserStats) Reset()         { *m = UserStats{} }
func (m *UserStats) String() string { return proto.CompactTextString(m) }
func (*UserStats) ProtoMessage()    {}
func (*UserStats) Descriptor() ([]byte, []int) {
	return fileDescriptor_56c09c2dce0fb003, []int{22}
}

func (m *UserStats) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UserStats.Unmarshal(m, b)
}
func (m *UserStats) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UserStats.Marshal(b, m, deterministic)
}
func (m *UserStats) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UserStats.Merge(m, src)
}
func (m *UserStats) XXX_Size() int {
	return xxx_messageInfo_UserStats.Size(m)
}
func (m *UserStats) XXX_DiscardUnknown() {
	xxx_messageInfo_UserStats.DiscardUnknown(m)
}

var xxx_messageInfo_UserStats proto.InternalMessageInfo

const Default_UserStats_StatsOnly bool = false
const Default_UserStats_StrongCertificate bool = false
const Default_UserStats_Opus bool = false

func (m *UserStats) GetSession() uint32 {
	if m != nil && m.Session != nil {
		return *m.Session
	}
	return 0
}

func (m *UserStats) GetStatsOnly() bool {
	if m != nil && m.StatsOnly != nil {
		return *m.StatsOnly
	}
	return Default_UserStats_StatsOnly
}

func (m *UserStats) GetCertificates() [][]byte {
	if m != nil {
		return m.Certificates
	}
	return nil
}

func (m *UserStats) GetFromClient() *UserStats_Stats {
	if m != nil {
		return m.FromClient
	}
	return nil
}

func (m *UserStats) GetFromServer() *UserStats_Stats {
	if m != nil {
		return m.FromServer
	}
	return nil
}

func (m *UserStats) GetUdpPackets() uint32 {
	if m != nil && m.UdpPackets != nil {
		return *m.UdpPackets
	}
	return 0
}

func (m *UserStats) GetTcpPackets() uint32 {
	if m != nil && m.TcpPackets != nil {
		return *m.TcpPackets
	}
	return 0
}

func (m *UserStats) GetUdpPingAvg() float32 {
	if m != nil && m.UdpPingAvg != nil {
		return *m.UdpPingAvg
	}
	return 0
}

func (m *UserStats) GetUdpPingVar() float32 {
	if m != nil && m.UdpPingVar != nil {
		return *m.UdpPingVar
	}
	return 0
}

func (m *UserStats) GetTcpPingAvg() float32 {
	if m != nil && m.TcpPingAvg != nil {
		return *m.TcpPingAvg
	}
	return 0
}

func (m *UserStats) GetTcpPingVar() float32 {
	if m != nil && m.TcpPingVar != nil {
		return *m.TcpPingVar
	}
	return 0
}

func (m *UserStats) GetVersion() *Version {
	if m != nil {
		return m.Version
	}
	return nil
}

func (m *UserStats) GetCeltVersions() []int32 {
	if m != nil {
		return m.CeltVersions
	}
	return nil
}

func (m *UserStats) GetAddress() []byte {
	if m != nil {
		return m.Address
	}
	return nil
}

func (m *UserStats) GetBandwidth() uint32 {
	if m != nil && m.Bandwidth != nil {
		return *m.Bandwidth
	}
	return 0
}

func (m *UserStats) GetOnlinesecs() uint32 {
	if m != nil && m.Onlinesecs != nil {
		return *m.Onlinesecs
	}
	return 0
}

func (m *UserStats) GetIdlesecs() uint32 {
	if m != nil && m.Idlesecs != nil {
		return *m.Idlesecs
	}
	return 0
}

func (m *UserStats) GetStrongCertificate() bool {
	if m != nil && m.StrongCertificate != nil {
		return *m.StrongCertificate
	}
	return Default_UserStats_StrongCertificate
}

func (m *UserStats) GetOpus() bool {
	if m != nil && m.Opus != nil {
		return *m.Opus
	}
	return Default_UserStats_Opus
}

type UserStats_Stats struct {
	// The amount of good packets received.
	Good *uint32 `protobuf:"varint,1,opt,name=good" json:"good,omitempty"`
	// The amount of late packets received.
	Late *uint32 `protobuf:"varint,2,opt,name=late" json:"late,omitempty"`
	// The amount of packets never received.
	Lost *uint32 `protobuf:"varint,3,opt,name=lost" json:"lost,omitempty"`
	// The amount of nonce resyncs.
	Resync               *uint32  `protobuf:"varint,4,opt,name=resync" json:"resync,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *UserStats_Stats) Reset()         { *m = UserStats_Stats{} }
func (m *UserStats_Stats) String() string { return proto.CompactTextString(m) }
func (*UserStats_Stats) ProtoMessage()    {}
func (*UserStats_Stats) Descriptor() ([]byte, []int) {
	return fileDescriptor_56c09c2dce0fb003, []int{22, 0}
}

func (m *UserStats_Stats) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UserStats_Stats.Unmarshal(m, b)
}
func (m *UserStats_Stats) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UserStats_Stats.Marshal(b, m, deterministic)
}
func (m *UserStats_Stats) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UserStats_Stats.Merge(m, src)
}
func (m *UserStats_Stats) XXX_Size() int {
	return xxx_messageInfo_UserStats_Stats.Size(m)
}
func (m *UserStats_Stats) XXX_DiscardUnknown() {
	xxx_messageInfo_UserStats_Stats.DiscardUnknown(m)
}

var xxx_messageInfo_UserStats_Stats proto.InternalMessageInfo

func (m *UserStats_Stats) GetGood() uint32 {
	if m != nil && m.Good != nil {
		return *m.Good
	}
	return 0
}

func (m *UserStats_Stats) GetLate() uint32 {
	if m != nil && m.Late != nil {
		return *m.Late
	}
	return 0
}

func (m *UserStats_Stats) GetLost() uint32 {
	if m != nil && m.Lost != nil {
		return *m.Lost
	}
	return 0
}

func (m *UserStats_Stats) GetResync() uint32 {
	if m != nil && m.Resync != nil {
		return *m.Resync
	}
	return 0
}

// Used by the client to request binary data from the server. By default large
// comments or textures are not sent within standard messages but instead the
// hash is. If the client does not recognize the hash it may request the
// resource when it needs it. The client does so by sending a RequestBlob
// message with the correct fields filled with the user sessions or channel_ids
// it wants to receive. The server replies to this by sending a new
// UserState/ChannelState message with the resources filled even if they would
// normally be transmitted as hashes.
type RequestBlob struct {
	// sessions of the requested UserState textures.
	SessionTexture []uint32 `protobuf:"varint,1,rep,name=session_texture,json=sessionTexture" json:"session_texture,omitempty"`
	// sessions of the requested UserState comments.
	SessionComment []uint32 `protobuf:"varint,2,rep,name=session_comment,json=sessionComment" json:"session_comment,omitempty"`
	// channel_ids of the requested ChannelState descriptions.
	ChannelDescription   []uint32 `protobuf:"varint,3,rep,name=channel_description,json=channelDescription" json:"channel_description,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RequestBlob) Reset()         { *m = RequestBlob{} }
func (m *RequestBlob) String() string { return proto.CompactTextString(m) }
func (*RequestBlob) ProtoMessage()    {}
func (*RequestBlob) Descriptor() ([]byte, []int) {
	return fileDescriptor_56c09c2dce0fb003, []int{23}
}

func (m *RequestBlob) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RequestBlob.Unmarshal(m, b)
}
func (m *RequestBlob) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RequestBlob.Marshal(b, m, deterministic)
}
func (m *RequestBlob) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RequestBlob.Merge(m, src)
}
func (m *RequestBlob) XXX_Size() int {
	return xxx_messageInfo_RequestBlob.Size(m)
}
func (m *RequestBlob) XXX_DiscardUnknown() {
	xxx_messageInfo_RequestBlob.DiscardUnknown(m)
}

var xxx_messageInfo_RequestBlob proto.InternalMessageInfo

func (m *RequestBlob) GetSessionTexture() []uint32 {
	if m != nil {
		return m.SessionTexture
	}
	return nil
}

func (m *RequestBlob) GetSessionComment() []uint32 {
	if m != nil {
		return m.SessionComment
	}
	return nil
}

func (m *RequestBlob) GetChannelDescription() []uint32 {
	if m != nil {
		return m.ChannelDescription
	}
	return nil
}

// Sent by the server when it informs the clients on server configuration
// details.
type ServerConfig struct {
	// The maximum bandwidth the clients should use.
	MaxBandwidth *uint32 `protobuf:"varint,1,opt,name=max_bandwidth,json=maxBandwidth" json:"max_bandwidth,omitempty"`
	// Server welcome text.
	WelcomeText *string `protobuf:"bytes,2,opt,name=welcome_text,json=welcomeText" json:"welcome_text,omitempty"`
	// True if the server allows HTML.
	AllowHtml *bool `protobuf:"varint,3,opt,name=allow_html,json=allowHtml" json:"allow_html,omitempty"`
	// Maximum text message length.
	MessageLength *uint32 `protobuf:"varint,4,opt,name=message_length,json=messageLength" json:"message_length,omitempty"`
	// Maximum image message length.
	ImageMessageLength *uint32 `protobuf:"varint,5,opt,name=image_message_length,json=imageMessageLength" json:"image_message_length,omitempty"`
	// The maximum number of users allowed on the server.
	MaxUsers             *uint32  `protobuf:"varint,6,opt,name=max_users,json=maxUsers" json:"max_users,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ServerConfig) Reset()         { *m = ServerConfig{} }
func (m *ServerConfig) String() string { return proto.CompactTextString(m) }
func (*ServerConfig) ProtoMessage()    {}
func (*ServerConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_56c09c2dce0fb003, []int{24}
}

func (m *ServerConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ServerConfig.Unmarshal(m, b)
}
func (m *ServerConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ServerConfig.Marshal(b, m, deterministic)
}
func (m *ServerConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ServerConfig.Merge(m, src)
}
func (m *ServerConfig) XXX_Size() int {
	return xxx_messageInfo_ServerConfig.Size(m)
}
func (m *ServerConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_ServerConfig.DiscardUnknown(m)
}

var xxx_messageInfo_ServerConfig proto.InternalMessageInfo

func (m *ServerConfig) GetMaxBandwidth() uint32 {
	if m != nil && m.MaxBandwidth != nil {
		return *m.MaxBandwidth
	}
	return 0
}

func (m *ServerConfig) GetWelcomeText() string {
	if m != nil && m.WelcomeText != nil {
		return *m.WelcomeText
	}
	return ""
}

func (m *ServerConfig) GetAllowHtml() bool {
	if m != nil && m.AllowHtml != nil {
		return *m.AllowHtml
	}
	return false
}

func (m *ServerConfig) GetMessageLength() uint32 {
	if m != nil && m.MessageLength != nil {
		return *m.MessageLength
	}
	return 0
}

func (m *ServerConfig) GetImageMessageLength() uint32 {
	if m != nil && m.ImageMessageLength != nil {
		return *m.ImageMessageLength
	}
	return 0
}

func (m *ServerConfig) GetMaxUsers() uint32 {
	if m != nil && m.MaxUsers != nil {
		return *m.MaxUsers
	}
	return 0
}

// Sent by the server to inform the clients of suggested client configuration
// specified by the server administrator.
type SuggestConfig struct {
	// Suggested client version.
	Version *uint32 `protobuf:"varint,1,opt,name=version" json:"version,omitempty"`
	// True if the administrator suggests positional audio to be used on this
	// server.
	Positional *bool `protobuf:"varint,2,opt,name=positional" json:"positional,omitempty"`
	// True if the administrator suggests push to talk to be used on this server.
	PushToTalk           *bool    `protobuf:"varint,3,opt,name=push_to_talk,json=pushToTalk" json:"push_to_talk,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SuggestConfig) Reset()         { *m = SuggestConfig{} }
func (m *SuggestConfig) String() string { return proto.CompactTextString(m) }
func (*SuggestConfig) ProtoMessage()    {}
func (*SuggestConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_56c09c2dce0fb003, []int{25}
}

func (m *SuggestConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SuggestConfig.Unmarshal(m, b)
}
func (m *SuggestConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SuggestConfig.Marshal(b, m, deterministic)
}
func (m *SuggestConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SuggestConfig.Merge(m, src)
}
func (m *SuggestConfig) XXX_Size() int {
	return xxx_messageInfo_SuggestConfig.Size(m)
}
func (m *SuggestConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_SuggestConfig.DiscardUnknown(m)
}

var xxx_messageInfo_SuggestConfig proto.InternalMessageInfo

func (m *SuggestConfig) GetVersion() uint32 {
	if m != nil && m.Version != nil {
		return *m.Version
	}
	return 0
}

func (m *SuggestConfig) GetPositional() bool {
	if m != nil && m.Positional != nil {
		return *m.Positional
	}
	return false
}

func (m *SuggestConfig) GetPushToTalk() bool {
	if m != nil && m.PushToTalk != nil {
		return *m.PushToTalk
	}
	return false
}

func init() {
	proto.RegisterEnum("MumbleProto.Reject_RejectType", Reject_RejectType_name, Reject_RejectType_value)
	proto.RegisterEnum("MumbleProto.PermissionDenied_DenyType", PermissionDenied_DenyType_name, PermissionDenied_DenyType_value)
	proto.RegisterEnum("MumbleProto.ContextActionModify_Context", ContextActionModify_Context_name, ContextActionModify_Context_value)
	proto.RegisterEnum("MumbleProto.ContextActionModify_Operation", ContextActionModify_Operation_name, ContextActionModify_Operation_value)
	proto.RegisterType((*Version)(nil), "MumbleProto.Version")
	proto.RegisterType((*UDPTunnel)(nil), "MumbleProto.UDPTunnel")
	proto.RegisterType((*Authenticate)(nil), "MumbleProto.Authenticate")
	proto.RegisterType((*Ping)(nil), "MumbleProto.Ping")
	proto.RegisterType((*Reject)(nil), "MumbleProto.Reject")
	proto.RegisterType((*ServerSync)(nil), "MumbleProto.ServerSync")
	proto.RegisterType((*ChannelRemove)(nil), "MumbleProto.ChannelRemove")
	proto.RegisterType((*ChannelState)(nil), "MumbleProto.ChannelState")
	proto.RegisterType((*UserRemove)(nil), "MumbleProto.UserRemove")
	proto.RegisterType((*UserState)(nil), "MumbleProto.UserState")
	proto.RegisterType((*BanList)(nil), "MumbleProto.BanList")
	proto.RegisterType((*BanList_BanEntry)(nil), "MumbleProto.BanList.BanEntry")
	proto.RegisterType((*TextMessage)(nil), "MumbleProto.TextMessage")
	proto.RegisterType((*PermissionDenied)(nil), "MumbleProto.PermissionDenied")
	proto.RegisterType((*ACL)(nil), "MumbleProto.ACL")
	proto.RegisterType((*ACL_ChanGroup)(nil), "MumbleProto.ACL.ChanGroup")
	proto.RegisterType((*ACL_ChanACL)(nil), "MumbleProto.ACL.ChanACL")
	proto.RegisterType((*QueryUsers)(nil), "MumbleProto.QueryUsers")
	proto.RegisterType((*CryptSetup)(nil), "MumbleProto.CryptSetup")
	proto.RegisterType((*ContextActionModify)(nil), "MumbleProto.ContextActionModify")
	proto.RegisterType((*ContextAction)(nil), "MumbleProto.ContextAction")
	proto.RegisterType((*UserList)(nil), "MumbleProto.UserList")
	proto.RegisterType((*UserList_User)(nil), "MumbleProto.UserList.User")
	proto.RegisterType((*VoiceTarget)(nil), "MumbleProto.VoiceTarget")
	proto.RegisterType((*VoiceTarget_Target)(nil), "MumbleProto.VoiceTarget.Target")
	proto.RegisterType((*PermissionQuery)(nil), "MumbleProto.PermissionQuery")
	proto.RegisterType((*CodecVersion)(nil), "MumbleProto.CodecVersion")
	proto.RegisterType((*UserStats)(nil), "MumbleProto.UserStats")
	proto.RegisterType((*UserStats_Stats)(nil), "MumbleProto.UserStats.Stats")
	proto.RegisterType((*RequestBlob)(nil), "MumbleProto.RequestBlob")
	proto.RegisterType((*ServerConfig)(nil), "MumbleProto.ServerConfig")
	proto.RegisterType((*SuggestConfig)(nil), "MumbleProto.SuggestConfig")
}

func init() { proto.RegisterFile("Mumble.proto", fileDescriptor_56c09c2dce0fb003) }

var fileDescriptor_56c09c2dce0fb003 = []byte{
	// 2523 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xdc, 0x58, 0x4f, 0x6f, 0x24, 0x47,
	0x15, 0x4f, 0xcf, 0xff, 0x79, 0x33, 0x63, 0xb7, 0x6b, 0x9d, 0x64, 0x70, 0xb2, 0x89, 0xd3, 0x0b,
	0x89, 0x03, 0x91, 0x09, 0x56, 0x84, 0x94, 0x48, 0x1c, 0xbc, 0xde, 0x04, 0xaf, 0xb0, 0x37, 0x4b,
	0xdb, 0xd9, 0x1c, 0x38, 0x34, 0xe5, 0xee, 0xf2, 0x4c, 0xe3, 0x9e, 0xee, 0x4e, 0x55, 0xb5, 0x77,
	0x47, 0xe2, 0x08, 0x5c, 0xc9, 0x8d, 0x1b, 0x1f, 0x20, 0x87, 0x48, 0x7c, 0x05, 0x3e, 0x01, 0x07,
	0x3e, 0x01, 0xe2, 0xc6, 0x0d, 0x89, 0x3b, 0x7a, 0xaf, 0xaa, 0xff, 0x79, 0x9d, 0x6c, 0xb8, 0x72,
	0x99, 0xa9, 0xf7, 0x7b, 0xbf, 0xfa, 0xd3, 0x55, 0xef, 0x5f, 0x15, 0x4c, 0x4f, 0x8b, 0xd5, 0x45,
	0x22, 0xf6, 0x73, 0x99, 0xe9, 0x8c, 0x4d, 0x8c, 0xf4, 0x18, 0x05, 0x2f, 0x81, 0xe1, 0x13, 0x21,
	0x55, 0x9c, 0xa5, 0x6c, 0x0e, 0xc3, 0x6b, 0xd3, 0x9c, 0x3b, 0xbb, 0xce, 0xde, 0xcc, 0x2f, 0x45,
	0xd4, 0x48, 0x91, 0x08, 0xae, 0xc4, 0xbc, 0xb3, 0xeb, 0xec, 0x8d, 0xfd, 0x52, 0x64, 0x1b, 0xd0,
	0xc9, 0xd4, 0xbc, 0x4b, 0x60, 0x27, 0x53, 0xec, 0x2e, 0x40, 0xa6, 0x82, 0x72, 0x98, 0x1e, 0xe1,
	0xe3, 0x4c, 0xd9, 0x29, 0xbc, 0x7b, 0x30, 0xfe, 0xec, 0xc1, 0xe3, 0xf3, 0x22, 0x4d, 0x45, 0xc2,
	0x5e, 0x81, 0x41, 0xce, 0xc3, 0x2b, 0xa1, 0xe7, 0xce, 0x6e, 0x67, 0x6f, 0xea, 0x5b, 0xc9, 0xfb,
	0xb3, 0x03, 0xd3, 0xc3, 0x42, 0x2f, 0x45, 0xaa, 0xe3, 0x90, 0x6b, 0xc1, 0x76, 0x60, 0x54, 0x28,
	0x21, 0x53, 0xbe, 0x12, 0xb4, 0xb2, 0xb1, 0x5f, 0xc9, 0xa8, 0xcb, 0xb9, 0x52, 0x4f, 0x33, 0x19,
	0xd9, 0xb5, 0x55, 0x32, 0x4e, 0xa0, 0xb3, 0x2b, 0x91, 0xe2, 0x02, 0xbb, 0x7b, 0x63, 0xdf, 0x4a,
	0xec, 0x1e, 0xcc, 0x42, 0x91, 0xe8, 0x72, 0x99, 0x6a, 0xde, 0xdb, 0xed, 0xee, 0xf5, 0xfd, 0x29,
	0x82, 0x76, 0xa5, 0x8a, 0x7d, 0x0f, 0x7a, 0x59, 0x5e, 0xa8, 0x79, 0x7f, 0xd7, 0xd9, 0x1b, 0x7d,
	0xd4, 0xbf, 0xe4, 0x89, 0x12, 0x3e, 0x41, 0xde, 0x5f, 0x3b, 0xd0, 0x7b, 0x1c, 0xa7, 0x0b, 0xf6,
	0x3a, 0x8c, 0x75, 0xbc, 0x12, 0x4a, 0xf3, 0x55, 0x4e, 0x2b, 0xeb, 0xf9, 0x35, 0xc0, 0x18, 0xf4,
	0x16, 0x59, 0x66, 0x96, 0x35, 0xf3, 0xa9, 0x8d, 0x58, 0xc2, 0xb5, 0xa0, 0x1d, 0x9b, 0xf9, 0xd4,
	0x26, 0x2c, 0x53, 0x9a, 0x76, 0x0b, 0xb1, 0x4c, 0x69, 0x5c, 0xba, 0x14, 0x6a, 0x9d, 0x86, 0x34,
	0xff, 0xcc, 0xb7, 0x12, 0x7b, 0x13, 0x26, 0x45, 0x94, 0x07, 0x66, 0xa7, 0xd4, 0x7c, 0x40, 0x4a,
	0x28, 0xa2, 0xfc, 0xb1, 0x41, 0x90, 0xa0, 0xc3, 0x9a, 0x30, 0x34, 0x04, 0x1d, 0x56, 0x84, 0x5d,
	0x98, 0xd2, 0x08, 0x71, 0xba, 0x08, 0xf8, 0xf5, 0x62, 0x3e, 0xda, 0x75, 0xf6, 0x3a, 0x66, 0x88,
	0x38, 0x5d, 0x1c, 0x5e, 0x2f, 0x5a, 0x8c, 0x6b, 0x2e, 0xe7, 0xe3, 0x16, 0xe3, 0x09, 0x97, 0xc8,
	0xa0, 0x49, 0xca, 0x31, 0xc0, 0x30, 0x70, 0x96, 0x7a, 0x8c, 0x8a, 0x81, 0x63, 0x4c, 0x5a, 0x8c,
	0x27, 0x5c, 0x7a, 0xbf, 0xef, 0xc0, 0xc0, 0x17, 0xbf, 0x11, 0xa1, 0x66, 0x07, 0xd0, 0xd3, 0xeb,
	0xdc, 0x9c, 0xed, 0xc6, 0xc1, 0x1b, 0xfb, 0x0d, 0xfb, 0xdc, 0x37, 0x14, 0xfb, 0x77, 0xbe, 0xce,
	0x85, 0x4f, 0x5c, 0xb3, 0x41, 0x5c, 0x65, 0xa9, 0x3d, 0x75, 0x2b, 0x79, 0x5f, 0x3b, 0x00, 0x35,
	0x99, 0x8d, 0xa0, 0xf7, 0x28, 0x4b, 0x85, 0xfb, 0x12, 0x73, 0x61, 0xfa, 0xb9, 0xcc, 0xd2, 0x85,
	0x3d, 0x60, 0xd7, 0x61, 0x77, 0x60, 0xf3, 0x61, 0x7a, 0xcd, 0x93, 0x38, 0xfa, 0xcc, 0x5a, 0x93,
	0xdb, 0x61, 0x9b, 0x30, 0x21, 0x1a, 0x42, 0x8f, 0x3f, 0x77, 0xbb, 0x6c, 0x0b, 0x66, 0x04, 0x9c,
	0x09, 0x79, 0x4d, 0x50, 0x0f, 0xa1, 0xb2, 0xc7, 0xc3, 0xf4, 0x33, 0x25, 0xdc, 0x3e, 0xdb, 0x00,
	0x30, 0x84, 0x4f, 0x8a, 0x24, 0x71, 0x07, 0x48, 0x79, 0x94, 0x1d, 0x09, 0xa9, 0xe3, 0x4b, 0xb2,
	0x61, 0x77, 0xc8, 0x5e, 0x86, 0xad, 0x86, 0x55, 0x67, 0xf2, 0x13, 0x1e, 0x27, 0xee, 0xc8, 0xfb,
	0xd2, 0x29, 0xbb, 0x9e, 0xe1, 0x01, 0xcf, 0x61, 0xa8, 0x84, 0x6a, 0x3a, 0xa1, 0x15, 0xd1, 0x6a,
	0x57, 0xfc, 0x59, 0x70, 0xc1, 0xd3, 0xe8, 0x69, 0x1c, 0xe9, 0xa5, 0xb5, 0xab, 0xe9, 0x8a, 0x3f,
	0xbb, 0x5f, 0x62, 0xec, 0x2d, 0x98, 0x3e, 0x15, 0x49, 0x98, 0xad, 0x44, 0xa0, 0xc5, 0x33, 0x6d,
	0x3d, 0x73, 0x62, 0xb1, 0x73, 0xf1, 0x4c, 0xb3, 0x5d, 0x98, 0xe4, 0x42, 0xae, 0x62, 0x55, 0xda,
	0x3e, 0x9a, 0x6d, 0x13, 0xf2, 0xf6, 0x61, 0x76, 0xb4, 0xe4, 0xe8, 0xa3, 0xbe, 0x58, 0x65, 0xd7,
	0x02, 0xbd, 0x3a, 0x34, 0x40, 0x10, 0x47, 0xe4, 0xad, 0x33, 0x7f, 0x6c, 0x91, 0x87, 0x91, 0xf7,
	0x55, 0x17, 0xa6, 0xb6, 0xc3, 0x99, 0x46, 0x8b, 0xbe, 0xc9, 0x77, 0x5a, 0x7c, 0xe3, 0xf8, 0x52,
	0xa4, 0xda, 0x7e, 0x82, 0x95, 0xd0, 0x11, 0xc8, 0xc7, 0xcd, 0xa2, 0xa9, 0xcd, 0xb6, 0xa1, 0x9f,
	0xc4, 0xe9, 0x95, 0xf1, 0xd1, 0x99, 0x6f, 0x04, 0xfc, 0x86, 0x48, 0xa8, 0x50, 0xc6, 0xb9, 0xc6,
	0x9d, 0xea, 0x9b, 0xaf, 0x6c, 0x40, 0xec, 0x35, 0x18, 0x13, 0x35, 0xe0, 0x51, 0x34, 0x1f, 0x50,
	0xdf, 0x11, 0x01, 0x87, 0x51, 0x84, 0xbb, 0x64, 0x94, 0x92, 0xbe, 0x6f, 0x3e, 0x24, 0xfd, 0x84,
	0x30, 0xfb, 0xc9, 0xf7, 0x60, 0xac, 0xc5, 0x2a, 0xcf, 0x24, 0x97, 0x6b, 0xf2, 0x91, 0x2a, 0x06,
	0xd4, 0x38, 0xbb, 0x0b, 0xa3, 0x3c, 0x53, 0x31, 0xad, 0x01, 0xbd, 0xa4, 0xff, 0x91, 0xf3, 0xbe,
	0x5f, 0x41, 0xec, 0x5d, 0x70, 0x1b, 0x4b, 0x0a, 0x96, 0x5c, 0x2d, 0xc9, 0x55, 0xa6, 0xfe, 0x66,
	0x03, 0x3f, 0xe6, 0x6a, 0x89, 0xcb, 0xc5, 0xc3, 0xc5, 0xb0, 0xa6, 0xc8, 0x59, 0x66, 0xfe, 0x68,
	0xc5, 0x9f, 0xa1, 0x99, 0x29, 0xb6, 0x0f, 0x77, 0x62, 0x15, 0x88, 0x54, 0x0b, 0x19, 0x48, 0xa1,
	0xb4, 0x8c, 0x43, 0x2d, 0xa2, 0xf9, 0x14, 0x57, 0xe5, 0x6f, 0xc5, 0xea, 0x63, 0xd4, 0xf8, 0x95,
	0x02, 0x07, 0x0b, 0x79, 0x6a, 0x3a, 0xcc, 0x67, 0xc4, 0x1a, 0x85, 0x3c, 0x25, 0x9a, 0x77, 0x09,
	0x80, 0xa3, 0xda, 0xcf, 0x6c, 0x99, 0x5b, 0xa7, 0x69, 0x6e, 0xdb, 0xd0, 0xe7, 0xa1, 0xce, 0xa4,
	0x3d, 0x23, 0x23, 0x34, 0xdc, 0xae, 0xdb, 0x74, 0x3b, 0xe6, 0x42, 0xf7, 0x82, 0x9b, 0x80, 0x3f,
	0xf2, 0xb1, 0xe9, 0xfd, 0xb3, 0x07, 0x63, 0x9c, 0xc8, 0x58, 0xc4, 0x37, 0x9b, 0xf5, 0xed, 0xf3,
	0xdc, 0x66, 0x0a, 0xaf, 0xc2, 0x10, 0xf7, 0x07, 0x4d, 0xca, 0x84, 0xca, 0x01, 0x8a, 0x0f, 0xa3,
	0x1b, 0xe6, 0xd6, 0xbf, 0x69, 0x6e, 0x0c, 0x7a, 0xab, 0x42, 0x0b, 0x0a, 0x96, 0x23, 0x9f, 0xda,
	0x88, 0x45, 0x82, 0x5f, 0x52, 0x7c, 0x1c, 0xf9, 0xd4, 0xc6, 0x54, 0xa2, 0x8a, 0x3c, 0x97, 0x42,
	0x29, 0x73, 0xe2, 0x7e, 0x25, 0xe3, 0x96, 0x2a, 0x91, 0x5c, 0x06, 0x34, 0xd0, 0xd8, 0x2a, 0x45,
	0x72, 0x79, 0x8a, 0x83, 0x95, 0x4a, 0x1a, 0x11, 0x6a, 0xe5, 0x03, 0x1c, 0x75, 0x0e, 0x43, 0xf4,
	0xc4, 0x42, 0x0a, 0x3a, 0xd7, 0xa9, 0x5f, 0x8a, 0xec, 0x07, 0xb0, 0x91, 0x27, 0xc5, 0x22, 0x4e,
	0x83, 0x30, 0x4b, 0xc9, 0x5b, 0xa7, 0x44, 0x98, 0x19, 0xf4, 0xc8, 0x80, 0xec, 0x1d, 0xd8, 0xb4,
	0xb4, 0x38, 0xc2, 0xe0, 0xa1, 0xd7, 0x74, 0xa6, 0x63, 0xdf, 0xf6, 0x7e, 0x68, 0x51, 0x9c, 0x29,
	0xcc, 0x56, 0x2b, 0xf4, 0xab, 0x0d, 0x93, 0xa5, 0xad, 0x88, 0x5f, 0x4b, 0xc6, 0xb7, 0x69, 0x76,
	0x13, 0xdb, 0xe8, 0x03, 0x56, 0x6d, 0x0c, 0xd3, 0xa5, 0xb9, 0x27, 0x16, 0x3b, 0xb6, 0x14, 0xbb,
	0x56, 0x43, 0xd9, 0x32, 0x14, 0x8b, 0x11, 0xe5, 0x5d, 0x70, 0x73, 0x19, 0x67, 0x32, 0xd6, 0xeb,
	0x40, 0xe5, 0x82, 0x5f, 0x09, 0x39, 0x67, 0xb4, 0x03, 0x9b, 0x25, 0x7e, 0x66, 0x60, 0x4c, 0x96,
	0x52, 0x84, 0x99, 0x8c, 0xe2, 0x74, 0x31, 0xbf, 0x43, 0x9c, 0x1a, 0x60, 0x3f, 0x85, 0x57, 0x2b,
	0xbf, 0x0a, 0x78, 0x18, 0x0a, 0xa5, 0x02, 0x9b, 0xbc, 0xb7, 0x29, 0x79, 0xbf, 0x5c, 0xa9, 0x0f,
	0x49, 0x7b, 0x4e, 0x4a, 0xef, 0x0f, 0x1d, 0x18, 0xde, 0xe7, 0xe9, 0x49, 0xac, 0x34, 0xfb, 0x09,
	0xf4, 0x2e, 0x78, 0xaa, 0xe6, 0xce, 0x6e, 0x77, 0x6f, 0x72, 0x70, 0xb7, 0x95, 0x47, 0x2c, 0x07,
	0xff, 0x3f, 0x4e, 0xb5, 0x5c, 0xfb, 0x44, 0x65, 0xaf, 0x41, 0xff, 0x8b, 0x42, 0xc8, 0x35, 0x59,
	0x5f, 0xe5, 0xe2, 0x06, 0xdb, 0xf9, 0xca, 0x81, 0x51, 0xc9, 0xc7, 0xdd, 0xe5, 0x51, 0x44, 0xc6,
	0x61, 0xca, 0x95, 0x52, 0x24, 0xfb, 0xe2, 0xea, 0x6a, 0xde, 0x21, 0x07, 0xa2, 0xf6, 0xad, 0xf6,
	0x5b, 0x9e, 0x42, 0xaf, 0x71, 0x0a, 0xb5, 0x3f, 0xf5, 0x5b, 0xfe, 0xb4, 0x0d, 0x7d, 0xa5, 0xb9,
	0xd4, 0x64, 0xb4, 0x63, 0xdf, 0x08, 0x68, 0xa1, 0x51, 0x21, 0x39, 0xc5, 0x1b, 0x93, 0xd9, 0x2b,
	0xd9, 0xfb, 0xa3, 0x03, 0x13, 0x8c, 0xef, 0xa7, 0x42, 0x29, 0xbe, 0x10, 0xb5, 0x5f, 0x39, 0x4d,
	0xbf, 0x6a, 0xf8, 0x61, 0x87, 0x82, 0x5e, 0xe5, 0x87, 0x6d, 0x27, 0xea, 0x92, 0xb2, 0xe1, 0x44,
	0xaf, 0xc2, 0x50, 0x4b, 0x21, 0x8c, 0xf3, 0xa1, 0x6e, 0x80, 0xe2, 0xc3, 0x08, 0x47, 0x5c, 0x99,
	0x29, 0xe7, 0xfd, 0xdd, 0x0e, 0x5a, 0x9d, 0x15, 0x31, 0x2d, 0xb8, 0x8f, 0xab, 0xb4, 0xf2, 0x40,
	0xa4, 0xb1, 0x88, 0xd8, 0x1b, 0x00, 0x75, 0xaa, 0xb1, 0x6b, 0x6b, 0x20, 0x37, 0x96, 0xd1, 0xb9,
	0xe9, 0xcb, 0x8d, 0xf5, 0x77, 0xdb, 0x71, 0xa4, 0xde, 0xc9, 0x5e, 0x6b, 0x27, 0x3f, 0xb2, 0xc5,
	0x45, 0x9f, 0x8a, 0x8b, 0xb7, 0x5b, 0x46, 0x71, 0x73, 0x75, 0xfb, 0x0f, 0x44, 0xba, 0x6e, 0x14,
	0x19, 0xe5, 0x29, 0x0e, 0xea, 0x53, 0xf4, 0xfe, 0xee, 0xc0, 0xa8, 0xa4, 0x61, 0x79, 0x81, 0x7b,
	0xee, 0xbe, 0x84, 0x05, 0x40, 0x3d, 0x9a, 0xeb, 0xb0, 0x19, 0x8c, 0xcf, 0x8a, 0x5c, 0x48, 0x0c,
	0x81, 0xa6, 0xac, 0xb0, 0x19, 0xf2, 0x11, 0xd6, 0x19, 0x5d, 0x04, 0xb0, 0xe7, 0x79, 0x96, 0x9d,
	0x64, 0xe9, 0xc2, 0xed, 0xb1, 0x21, 0x74, 0x8f, 0x3f, 0xfc, 0x85, 0xdb, 0x67, 0xdb, 0xe0, 0x9e,
	0x97, 0xa6, 0x6e, 0xfb, 0xb8, 0x03, 0xf6, 0x0a, 0xb0, 0x53, 0x1c, 0x3c, 0x5d, 0xb4, 0xab, 0x8a,
	0x29, 0x8c, 0x70, 0x0a, 0x1a, 0x75, 0xd4, 0x98, 0x86, 0xea, 0x90, 0x31, 0x56, 0x3d, 0x8f, 0x84,
	0xd2, 0x71, 0xba, 0x38, 0x89, 0x57, 0xb1, 0x76, 0x01, 0xcb, 0x10, 0x4b, 0x39, 0xca, 0x8a, 0x54,
	0x1b, 0x78, 0xe2, 0xfd, 0xae, 0x0f, 0xdd, 0xc3, 0xa3, 0x93, 0x17, 0xa4, 0x7a, 0xf6, 0x0e, 0x4c,
	0xe3, 0x74, 0x29, 0x64, 0xac, 0x03, 0x1e, 0x26, 0xca, 0xba, 0x4d, 0x4f, 0xcb, 0x42, 0xf8, 0x13,
	0xab, 0x39, 0x0c, 0x13, 0xc5, 0x0e, 0x60, 0xb0, 0x90, 0x59, 0x91, 0x9b, 0xda, 0x7b, 0x72, 0xb0,
	0xd3, 0xda, 0xf8, 0xc3, 0xa3, 0x93, 0x7d, 0x5c, 0xc5, 0xcf, 0x91, 0xe2, 0x5b, 0x26, 0x7b, 0x0f,
	0x7a, 0x34, 0x68, 0x8f, 0x7a, 0xcc, 0x6f, 0xed, 0x71, 0x78, 0x74, 0xe2, 0x13, 0xab, 0x76, 0xdd,
	0xfe, 0x2d, 0xae, 0xfb, 0x0f, 0x07, 0xc6, 0xd5, 0x04, 0xd5, 0x39, 0x3a, 0x64, 0xa0, 0xc6, 0x1b,
	0x3d, 0x18, 0xdb, 0xf5, 0x8a, 0xa8, 0xf5, 0x19, 0x35, 0xcc, 0xde, 0x80, 0xa1, 0x15, 0xc8, 0xda,
	0x4a, 0x46, 0x09, 0xb2, 0xb7, 0xa1, 0xfc, 0x66, 0x7e, 0x91, 0x08, 0x93, 0xfd, 0x6e, 0x6c, 0x06,
	0x2a, 0x30, 0x3b, 0x62, 0x19, 0xd2, 0x27, 0xc7, 0xc1, 0xa6, 0xb1, 0x56, 0xaa, 0x3d, 0x4c, 0x6d,
	0x62, 0x25, 0xf6, 0x23, 0xd8, 0xaa, 0xa6, 0x0f, 0x56, 0x62, 0x75, 0x81, 0xf5, 0x80, 0x29, 0x4f,
	0xdc, 0x4a, 0x71, 0x6a, 0xf0, 0x9d, 0xbf, 0x39, 0x30, 0xb4, 0x7b, 0xc2, 0xee, 0x01, 0xf0, 0x3c,
	0x4f, 0xd6, 0xc1, 0x52, 0x48, 0x53, 0x49, 0x57, 0xdf, 0x43, 0xf8, 0xb1, 0x90, 0xa2, 0x26, 0xa9,
	0xe2, 0xa2, 0x7d, 0x76, 0x86, 0x74, 0x56, 0x5c, 0xa8, 0xf6, 0xc6, 0x74, 0x6f, 0xdf, 0x98, 0x6f,
	0x4c, 0xc5, 0xdb, 0xd0, 0xa7, 0xc3, 0xb4, 0xe1, 0xcc, 0x08, 0x06, 0xe5, 0xa9, 0xb6, 0xf7, 0x15,
	0x23, 0x98, 0x1c, 0x9c, 0xae, 0x6d, 0x24, 0xa3, 0xb6, 0xf7, 0x01, 0xc0, 0x2f, 0xf1, 0x00, 0x4d,
	0xe1, 0xe3, 0x42, 0x37, 0x8e, 0x4c, 0x3c, 0x9f, 0xf9, 0xd8, 0xc4, 0x91, 0xf0, 0xf4, 0x14, 0x45,
	0xaf, 0xb1, 0x6f, 0x04, 0x2f, 0x02, 0x38, 0x92, 0xeb, 0x5c, 0x9f, 0x09, 0x5d, 0xe4, 0xd8, 0xeb,
	0x4a, 0xac, 0x69, 0x0f, 0xa6, 0x3e, 0x36, 0x29, 0xd7, 0x25, 0x31, 0xa6, 0xba, 0x34, 0x4b, 0x43,
	0x73, 0x89, 0xc5, 0x5c, 0x47, 0xd8, 0x23, 0x84, 0x90, 0xa2, 0xa8, 0x0a, 0xb7, 0x94, 0xae, 0xa1,
	0x18, 0x8c, 0x28, 0xde, 0x7f, 0x1c, 0xb8, 0x63, 0x93, 0xf2, 0x61, 0x88, 0x31, 0xf7, 0x34, 0x8b,
	0xe2, 0xcb, 0x35, 0x9e, 0x25, 0x27, 0xd9, 0xda, 0x97, 0x95, 0xf0, 0xfb, 0x28, 0xab, 0x9b, 0x0b,
	0x0a, 0xb5, 0x4d, 0x8e, 0x4e, 0xab, 0xd2, 0x7c, 0xe6, 0x97, 0x22, 0x3b, 0x86, 0x71, 0x96, 0x0b,
	0x1b, 0xdc, 0x7b, 0x14, 0xac, 0x7e, 0xd8, 0xf2, 0x80, 0x5b, 0xa6, 0xde, 0xff, 0xb4, 0xec, 0xe1,
	0xd7, 0x9d, 0xbd, 0xf7, 0x60, 0x58, 0xd6, 0x0e, 0x00, 0x03, 0x73, 0xb7, 0x70, 0x1d, 0x36, 0x31,
	0xc6, 0x82, 0xe1, 0xa4, 0x83, 0x81, 0x8b, 0x22, 0x53, 0xcf, 0xdb, 0x85, 0x71, 0x35, 0x0a, 0x06,
	0xa1, 0xc3, 0x28, 0x72, 0x5f, 0xc2, 0x8e, 0xa6, 0x42, 0x74, 0x1d, 0xef, 0xd7, 0x30, 0x6b, 0xcd,
	0xfd, 0x2d, 0xc5, 0xdc, 0x0b, 0xa2, 0x77, 0xbd, 0x53, 0xdd, 0xe6, 0x4e, 0x79, 0x7f, 0x71, 0x4c,
	0x14, 0xa3, 0x2c, 0xfe, 0x3e, 0xf4, 0x4d, 0x19, 0xec, 0xdc, 0x12, 0x38, 0x4a, 0x16, 0x35, 0x7c,
	0x43, 0xdc, 0x51, 0xe6, 0x63, 0x9a, 0x56, 0x69, 0x02, 0x57, 0x69, 0x95, 0xa5, 0xff, 0x77, 0x1a,
	0xd9, 0x18, 0x2f, 0x08, 0x5c, 0xe9, 0x40, 0x09, 0x51, 0x16, 0xb3, 0x23, 0x04, 0xce, 0x84, 0x48,
	0xe9, 0x82, 0x80, 0x4a, 0xbb, 0x74, 0x6b, 0xe4, 0x13, 0xc4, 0xec, 0x1e, 0x7a, 0xff, 0x76, 0x60,
	0xf2, 0x24, 0x8b, 0x43, 0x71, 0xce, 0xe5, 0x42, 0x68, 0xb6, 0x01, 0x9d, 0xea, 0xae, 0xd3, 0x89,
	0x23, 0xf6, 0x21, 0x0c, 0x35, 0x69, 0x8c, 0xad, 0x4e, 0x0e, 0xde, 0x6c, 0x7d, 0x48, 0xa3, 0xeb,
	0xbe, 0xf9, 0xf3, 0x4b, 0xfe, 0xce, 0x9f, 0x1c, 0x18, 0xd8, 0x51, 0x5b, 0x5b, 0xdd, 0xfd, 0x1f,
	0xb6, 0xba, 0x72, 0xc4, 0x6e, 0xd3, 0x11, 0x5f, 0xab, 0x6f, 0x53, 0xcd, 0x98, 0x69, 0x2e, 0x55,
	0x6f, 0xc1, 0x28, 0x5c, 0xc6, 0x49, 0x24, 0x45, 0xda, 0x8e, 0xa9, 0x15, 0xec, 0x65, 0xb0, 0x59,
	0x67, 0x39, 0x72, 0xd4, 0x17, 0xdd, 0xf5, 0x6e, 0xdc, 0x36, 0xcd, 0x3a, 0x9b, 0x10, 0xae, 0xe9,
	0x32, 0x29, 0xd4, 0xd2, 0xc6, 0x9a, 0x72, 0x4d, 0x84, 0x79, 0xbf, 0x85, 0xe9, 0x51, 0x16, 0x89,
	0xb0, 0x7c, 0xa3, 0xc2, 0xaa, 0x26, 0xc9, 0x97, 0x9c, 0x0e, 0xb8, 0xef, 0x1b, 0x01, 0xcf, 0xf7,
	0x42, 0x68, 0x4e, 0x15, 0x58, 0xdf, 0xa7, 0x36, 0x66, 0xaa, 0x5c, 0x8a, 0x4b, 0x21, 0x03, 0xd3,
	0x01, 0x2d, 0xae, 0x0a, 0xce, 0x46, 0x73, 0x48, 0x9d, 0xcb, 0x87, 0x9e, 0xde, 0xf3, 0x0f, 0x3d,
	0x5f, 0x0f, 0xea, 0x3b, 0x8c, 0xfa, 0x16, 0xb3, 0xff, 0x3e, 0x80, 0x42, 0x4a, 0x90, 0xa5, 0xc9,
	0x8d, 0x52, 0x72, 0x4c, 0x8a, 0x4f, 0xd3, 0x64, 0xcd, 0x3c, 0x98, 0x86, 0x75, 0xee, 0x36, 0x89,
	0x71, 0xea, 0xb7, 0x30, 0xf6, 0x33, 0x98, 0x5c, 0xca, 0x6c, 0x15, 0x98, 0xd0, 0x44, 0x6b, 0x9a,
	0x1c, 0xbc, 0xfe, 0x9c, 0x0b, 0xd0, 0x82, 0xf6, 0xe9, 0xd7, 0x07, 0xec, 0x70, 0x44, 0xfc, 0xaa,
	0xbb, 0x09, 0x5b, 0x74, 0x8a, 0xdf, 0xa9, 0xbb, 0x09, 0x12, 0xff, 0x3f, 0xaf, 0x4b, 0x6c, 0xbf,
	0x7e, 0xcb, 0x9c, 0xd2, 0x26, 0x6c, 0xb7, 0xbd, 0xcf, 0xe8, 0xea, 0x17, 0xce, 0xe7, 0x9e, 0x04,
	0x67, 0xb7, 0x3c, 0x09, 0x36, 0xae, 0x00, 0x1b, 0xe6, 0x2a, 0x57, 0x5e, 0x01, 0x5e, 0x87, 0x71,
	0xfd, 0x2e, 0xb3, 0x69, 0x7c, 0xa0, 0x02, 0xb0, 0xe6, 0xcd, 0xd2, 0x24, 0x4e, 0x85, 0x12, 0xa1,
	0xa2, 0x8b, 0xd6, 0xcc, 0x6f, 0x20, 0x58, 0xd6, 0xc7, 0x51, 0x62, 0xb4, 0x5b, 0xa6, 0xac, 0x2f,
	0x65, 0xf6, 0x01, 0x30, 0xa5, 0x65, 0x96, 0x2e, 0x82, 0x86, 0x9d, 0x98, 0x2b, 0x56, 0x69, 0x62,
	0x5b, 0x86, 0xd0, 0xa8, 0x0b, 0x2b, 0x9b, 0xbe, 0xf3, 0x9c, 0x4d, 0xef, 0xfc, 0x0a, 0xfa, 0xc6,
	0x9c, 0xcb, 0xe7, 0x49, 0xe7, 0x96, 0xe7, 0xc9, 0xce, 0x2d, 0xcf, 0x93, 0xdd, 0x5b, 0x9f, 0x27,
	0x7b, 0xcd, 0xe7, 0x49, 0xef, 0x4b, 0x07, 0x26, 0xbe, 0xf8, 0xa2, 0x10, 0x4a, 0xdf, 0x4f, 0xb2,
	0x0b, 0xbc, 0xbb, 0x5a, 0x1f, 0x09, 0xca, 0x4b, 0xb0, 0x09, 0x63, 0x1b, 0x16, 0x3e, 0xb7, 0x77,
	0xe1, 0x06, 0xb1, 0xbc, 0xc3, 0x76, 0x5a, 0xc4, 0x23, 0x7b, 0x95, 0xfd, 0x31, 0xdc, 0x29, 0xc3,
	0x4d, 0xf3, 0x05, 0xc8, 0xdc, 0x57, 0x98, 0x55, 0x3d, 0xa8, 0x35, 0xde, 0xbf, 0x1c, 0x98, 0x1a,
	0xf3, 0x3e, 0xca, 0xd2, 0xcb, 0x78, 0xf1, 0xfc, 0x3b, 0x9a, 0xf3, 0x1d, 0xde, 0xd1, 0x3a, 0xcf,
	0xbf, 0xa3, 0xdd, 0x05, 0xe0, 0x49, 0x92, 0x3d, 0x0d, 0x96, 0x7a, 0x95, 0x98, 0xe0, 0xe5, 0x8f,
	0x09, 0x39, 0xd6, 0xab, 0x04, 0x6f, 0xf7, 0xf6, 0x22, 0x14, 0x24, 0x22, 0x5d, 0xe8, 0xa5, 0xdd,
	0xaa, 0x99, 0x45, 0x4f, 0x08, 0x64, 0xef, 0xc3, 0x76, 0xbc, 0x42, 0xd2, 0x0d, 0xb2, 0x79, 0xc5,
	0x60, 0xa4, 0x3b, 0x6d, 0xf5, 0x68, 0x3d, 0x15, 0x0d, 0xda, 0x4f, 0x45, 0xde, 0x15, 0xcc, 0xce,
	0x8a, 0xc5, 0x42, 0x28, 0x6d, 0xbf, 0xf6, 0x9b, 0x1f, 0xf5, 0xf1, 0x26, 0x66, 0x5f, 0xaa, 0x78,
	0x62, 0x82, 0x96, 0xdf, 0x40, 0xd0, 0xc9, 0xf2, 0x42, 0x2d, 0x03, 0x9d, 0x05, 0x9a, 0x27, 0x57,
	0xf6, 0x0b, 0x01, 0xb1, 0xf3, 0xec, 0x9c, 0x27, 0x57, 0xf7, 0x3b, 0xc7, 0xce, 0x7f, 0x03, 0x00,
	0x00, 0xff, 0xff, 0x86, 0xf1, 0xdf, 0x29, 0x5b, 0x18, 0x00, 0x00,
}
