// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.23.0
// 	protoc        v3.17.3
// source: chat/v1/channels.proto

package chatv1

import (
	proto "github.com/golang/protobuf/proto"
	v1 "github.com/harmony-development/shibshib/gen/harmonytypes/v1"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

// What kind the channel is.
type ChannelKind int32

const (
	// A text channel. Allows you to simply send messages to a group of people.
	ChannelKind_CHANNEL_KIND_TEXT_UNSPECIFIED ChannelKind = 0
	// A voice channel. Allows you to talk to other people with voice.
	ChannelKind_CHANNEL_KIND_VOICE_MEDIA ChannelKind = 1
	// A category channel. All channels under this channel down to another
	// category channel belongs to this category channel.
	ChannelKind_CHANNEL_KIND_CATEGORY ChannelKind = 2
)

// Enum value maps for ChannelKind.
var (
	ChannelKind_name = map[int32]string{
		0: "CHANNEL_KIND_TEXT_UNSPECIFIED",
		1: "CHANNEL_KIND_VOICE_MEDIA",
		2: "CHANNEL_KIND_CATEGORY",
	}
	ChannelKind_value = map[string]int32{
		"CHANNEL_KIND_TEXT_UNSPECIFIED": 0,
		"CHANNEL_KIND_VOICE_MEDIA":      1,
		"CHANNEL_KIND_CATEGORY":         2,
	}
)

func (x ChannelKind) Enum() *ChannelKind {
	p := new(ChannelKind)
	*p = x
	return p
}

func (x ChannelKind) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ChannelKind) Descriptor() protoreflect.EnumDescriptor {
	return file_chat_v1_channels_proto_enumTypes[0].Descriptor()
}

func (ChannelKind) Type() protoreflect.EnumType {
	return &file_chat_v1_channels_proto_enumTypes[0]
}

func (x ChannelKind) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ChannelKind.Descriptor instead.
func (ChannelKind) EnumDescriptor() ([]byte, []int) {
	return file_chat_v1_channels_proto_rawDescGZIP(), []int{0}
}

// An object representing a channel, without the ID.
type Channel struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of this channel.
	ChannelName string `protobuf:"bytes,1,opt,name=channel_name,json=channelName,proto3" json:"channel_name,omitempty"`
	// The kind of channel this is.
	// Data does not get inherently stored in the Channel type
	// Instead, clients who understand a certain ChannelKind should
	// fetch them from a separate RPC.
	Kind ChannelKind `protobuf:"varint,2,opt,name=kind,proto3,enum=protocol.chat.v1.ChannelKind" json:"kind,omitempty"`
	// The metadata of this channel.
	Metadata *v1.Metadata `protobuf:"bytes,3,opt,name=metadata,proto3,oneof" json:"metadata,omitempty"`
}

func (x *Channel) Reset() {
	*x = Channel{}
	if protoimpl.UnsafeEnabled {
		mi := &file_chat_v1_channels_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Channel) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Channel) ProtoMessage() {}

func (x *Channel) ProtoReflect() protoreflect.Message {
	mi := &file_chat_v1_channels_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Channel.ProtoReflect.Descriptor instead.
func (*Channel) Descriptor() ([]byte, []int) {
	return file_chat_v1_channels_proto_rawDescGZIP(), []int{0}
}

func (x *Channel) GetChannelName() string {
	if x != nil {
		return x.ChannelName
	}
	return ""
}

func (x *Channel) GetKind() ChannelKind {
	if x != nil {
		return x.Kind
	}
	return ChannelKind_CHANNEL_KIND_TEXT_UNSPECIFIED
}

func (x *Channel) GetMetadata() *v1.Metadata {
	if x != nil {
		return x.Metadata
	}
	return nil
}

// The channel alongside with an ID.
type ChannelWithId struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// ID of the channel.
	ChannelId uint64 `protobuf:"varint,1,opt,name=channel_id,json=channelId,proto3" json:"channel_id,omitempty"`
	// The channel data.
	Channel *Channel `protobuf:"bytes,2,opt,name=channel,proto3" json:"channel,omitempty"`
}

func (x *ChannelWithId) Reset() {
	*x = ChannelWithId{}
	if protoimpl.UnsafeEnabled {
		mi := &file_chat_v1_channels_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ChannelWithId) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ChannelWithId) ProtoMessage() {}

func (x *ChannelWithId) ProtoReflect() protoreflect.Message {
	mi := &file_chat_v1_channels_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ChannelWithId.ProtoReflect.Descriptor instead.
func (*ChannelWithId) Descriptor() ([]byte, []int) {
	return file_chat_v1_channels_proto_rawDescGZIP(), []int{1}
}

func (x *ChannelWithId) GetChannelId() uint64 {
	if x != nil {
		return x.ChannelId
	}
	return 0
}

func (x *ChannelWithId) GetChannel() *Channel {
	if x != nil {
		return x.Channel
	}
	return nil
}

// Channel Kinds:
//
// Channel kinds specified in an official Harmony protocol will start with a
// "h." prefix. Third-party extensions should not use the "h." prefix. If no
// kind is specified, the channel is a text channel.
//
// Kinds indicate additional functionality a channel may have: for example,
// h.voice can indicate that a channel has voice functionalities alongside
// the usual text fare.
//
// Used in the `CreateChannel` endpoint.
type CreateChannelRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Guild ID of the guild to create a channel in.
	GuildId uint64 `protobuf:"varint,1,opt,name=guild_id,json=guildId,proto3" json:"guild_id,omitempty"`
	// The name of this channel.
	ChannelName string `protobuf:"bytes,2,opt,name=channel_name,json=channelName,proto3" json:"channel_name,omitempty"`
	// The kind of this channel.
	Kind ChannelKind `protobuf:"varint,3,opt,name=kind,proto3,enum=protocol.chat.v1.ChannelKind" json:"kind,omitempty"`
	// The metadata of this channel.
	Metadata *v1.Metadata `protobuf:"bytes,4,opt,name=metadata,proto3,oneof" json:"metadata,omitempty"`
	// The position of your new channel in the channel list.
	//
	// If not specified, it will be put at the bottom of the channel list.
	Position *v1.ItemPosition `protobuf:"bytes,5,opt,name=position,proto3,oneof" json:"position,omitempty"`
}

func (x *CreateChannelRequest) Reset() {
	*x = CreateChannelRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_chat_v1_channels_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateChannelRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateChannelRequest) ProtoMessage() {}

func (x *CreateChannelRequest) ProtoReflect() protoreflect.Message {
	mi := &file_chat_v1_channels_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateChannelRequest.ProtoReflect.Descriptor instead.
func (*CreateChannelRequest) Descriptor() ([]byte, []int) {
	return file_chat_v1_channels_proto_rawDescGZIP(), []int{2}
}

func (x *CreateChannelRequest) GetGuildId() uint64 {
	if x != nil {
		return x.GuildId
	}
	return 0
}

func (x *CreateChannelRequest) GetChannelName() string {
	if x != nil {
		return x.ChannelName
	}
	return ""
}

func (x *CreateChannelRequest) GetKind() ChannelKind {
	if x != nil {
		return x.Kind
	}
	return ChannelKind_CHANNEL_KIND_TEXT_UNSPECIFIED
}

func (x *CreateChannelRequest) GetMetadata() *v1.Metadata {
	if x != nil {
		return x.Metadata
	}
	return nil
}

func (x *CreateChannelRequest) GetPosition() *v1.ItemPosition {
	if x != nil {
		return x.Position
	}
	return nil
}

// Used in the `CreateChannel` endpoint.
type CreateChannelResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// ID of the channel that was created.
	ChannelId uint64 `protobuf:"varint,1,opt,name=channel_id,json=channelId,proto3" json:"channel_id,omitempty"`
}

func (x *CreateChannelResponse) Reset() {
	*x = CreateChannelResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_chat_v1_channels_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateChannelResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateChannelResponse) ProtoMessage() {}

func (x *CreateChannelResponse) ProtoReflect() protoreflect.Message {
	mi := &file_chat_v1_channels_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateChannelResponse.ProtoReflect.Descriptor instead.
func (*CreateChannelResponse) Descriptor() ([]byte, []int) {
	return file_chat_v1_channels_proto_rawDescGZIP(), []int{3}
}

func (x *CreateChannelResponse) GetChannelId() uint64 {
	if x != nil {
		return x.ChannelId
	}
	return 0
}

// Used in the `GetGuildChannels` endpoint.
type GetGuildChannelsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Guild ID of the guild you want to get channels from.
	GuildId uint64 `protobuf:"varint,1,opt,name=guild_id,json=guildId,proto3" json:"guild_id,omitempty"`
}

func (x *GetGuildChannelsRequest) Reset() {
	*x = GetGuildChannelsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_chat_v1_channels_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetGuildChannelsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetGuildChannelsRequest) ProtoMessage() {}

func (x *GetGuildChannelsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_chat_v1_channels_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetGuildChannelsRequest.ProtoReflect.Descriptor instead.
func (*GetGuildChannelsRequest) Descriptor() ([]byte, []int) {
	return file_chat_v1_channels_proto_rawDescGZIP(), []int{4}
}

func (x *GetGuildChannelsRequest) GetGuildId() uint64 {
	if x != nil {
		return x.GuildId
	}
	return 0
}

// Used in the `GetGuildChannels` endpoint.
type GetGuildChannelsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Channels' data and ID the server responded with.
	Channels []*ChannelWithId `protobuf:"bytes,1,rep,name=channels,proto3" json:"channels,omitempty"`
}

func (x *GetGuildChannelsResponse) Reset() {
	*x = GetGuildChannelsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_chat_v1_channels_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetGuildChannelsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetGuildChannelsResponse) ProtoMessage() {}

func (x *GetGuildChannelsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_chat_v1_channels_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetGuildChannelsResponse.ProtoReflect.Descriptor instead.
func (*GetGuildChannelsResponse) Descriptor() ([]byte, []int) {
	return file_chat_v1_channels_proto_rawDescGZIP(), []int{5}
}

func (x *GetGuildChannelsResponse) GetChannels() []*ChannelWithId {
	if x != nil {
		return x.Channels
	}
	return nil
}

// Used in the `UpdateChannelInformation` endpoint.
type UpdateChannelInformationRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Guild ID of the guild where the channel is.
	GuildId uint64 `protobuf:"varint,1,opt,name=guild_id,json=guildId,proto3" json:"guild_id,omitempty"`
	// Channel ID of the channel you want to change the information of.
	ChannelId uint64 `protobuf:"varint,2,opt,name=channel_id,json=channelId,proto3" json:"channel_id,omitempty"`
	// New name to set for this channel.
	NewName *string `protobuf:"bytes,3,opt,name=new_name,json=newName,proto3,oneof" json:"new_name,omitempty"`
	// New metadata to set for this channel.
	NewMetadata *v1.Metadata `protobuf:"bytes,4,opt,name=new_metadata,json=newMetadata,proto3,oneof" json:"new_metadata,omitempty"`
}

func (x *UpdateChannelInformationRequest) Reset() {
	*x = UpdateChannelInformationRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_chat_v1_channels_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateChannelInformationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateChannelInformationRequest) ProtoMessage() {}

func (x *UpdateChannelInformationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_chat_v1_channels_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateChannelInformationRequest.ProtoReflect.Descriptor instead.
func (*UpdateChannelInformationRequest) Descriptor() ([]byte, []int) {
	return file_chat_v1_channels_proto_rawDescGZIP(), []int{6}
}

func (x *UpdateChannelInformationRequest) GetGuildId() uint64 {
	if x != nil {
		return x.GuildId
	}
	return 0
}

func (x *UpdateChannelInformationRequest) GetChannelId() uint64 {
	if x != nil {
		return x.ChannelId
	}
	return 0
}

func (x *UpdateChannelInformationRequest) GetNewName() string {
	if x != nil && x.NewName != nil {
		return *x.NewName
	}
	return ""
}

func (x *UpdateChannelInformationRequest) GetNewMetadata() *v1.Metadata {
	if x != nil {
		return x.NewMetadata
	}
	return nil
}

// Used in the `UpdateChannelInformation` endpoint.
type UpdateChannelInformationResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *UpdateChannelInformationResponse) Reset() {
	*x = UpdateChannelInformationResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_chat_v1_channels_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateChannelInformationResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateChannelInformationResponse) ProtoMessage() {}

func (x *UpdateChannelInformationResponse) ProtoReflect() protoreflect.Message {
	mi := &file_chat_v1_channels_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateChannelInformationResponse.ProtoReflect.Descriptor instead.
func (*UpdateChannelInformationResponse) Descriptor() ([]byte, []int) {
	return file_chat_v1_channels_proto_rawDescGZIP(), []int{7}
}

// Used in the `UpdateChannelOrder` endpoint.
type UpdateChannelOrderRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Guild ID of the guild that has the channel.
	GuildId uint64 `protobuf:"varint,1,opt,name=guild_id,json=guildId,proto3" json:"guild_id,omitempty"`
	// Channel ID of the channel that you want to move.
	ChannelId uint64 `protobuf:"varint,2,opt,name=channel_id,json=channelId,proto3" json:"channel_id,omitempty"`
	// The new position of this channel.
	NewPosition *v1.ItemPosition `protobuf:"bytes,3,opt,name=new_position,json=newPosition,proto3" json:"new_position,omitempty"`
}

func (x *UpdateChannelOrderRequest) Reset() {
	*x = UpdateChannelOrderRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_chat_v1_channels_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateChannelOrderRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateChannelOrderRequest) ProtoMessage() {}

func (x *UpdateChannelOrderRequest) ProtoReflect() protoreflect.Message {
	mi := &file_chat_v1_channels_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateChannelOrderRequest.ProtoReflect.Descriptor instead.
func (*UpdateChannelOrderRequest) Descriptor() ([]byte, []int) {
	return file_chat_v1_channels_proto_rawDescGZIP(), []int{8}
}

func (x *UpdateChannelOrderRequest) GetGuildId() uint64 {
	if x != nil {
		return x.GuildId
	}
	return 0
}

func (x *UpdateChannelOrderRequest) GetChannelId() uint64 {
	if x != nil {
		return x.ChannelId
	}
	return 0
}

func (x *UpdateChannelOrderRequest) GetNewPosition() *v1.ItemPosition {
	if x != nil {
		return x.NewPosition
	}
	return nil
}

// Used in the `UpdateChannelOrder` endpoint.
type UpdateChannelOrderResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *UpdateChannelOrderResponse) Reset() {
	*x = UpdateChannelOrderResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_chat_v1_channels_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateChannelOrderResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateChannelOrderResponse) ProtoMessage() {}

func (x *UpdateChannelOrderResponse) ProtoReflect() protoreflect.Message {
	mi := &file_chat_v1_channels_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateChannelOrderResponse.ProtoReflect.Descriptor instead.
func (*UpdateChannelOrderResponse) Descriptor() ([]byte, []int) {
	return file_chat_v1_channels_proto_rawDescGZIP(), []int{9}
}

// Request specifiying the order of all channels in a guild at once
type UpdateAllChannelOrderRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// guild_id: the guild to specify the new channel order for
	GuildId uint64 `protobuf:"varint,1,opt,name=guild_id,json=guildId,proto3" json:"guild_id,omitempty"`
	// channel_ids: the new order of channel ids
	ChannelIds []uint64 `protobuf:"varint,2,rep,packed,name=channel_ids,json=channelIds,proto3" json:"channel_ids,omitempty"`
}

func (x *UpdateAllChannelOrderRequest) Reset() {
	*x = UpdateAllChannelOrderRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_chat_v1_channels_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateAllChannelOrderRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateAllChannelOrderRequest) ProtoMessage() {}

func (x *UpdateAllChannelOrderRequest) ProtoReflect() protoreflect.Message {
	mi := &file_chat_v1_channels_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateAllChannelOrderRequest.ProtoReflect.Descriptor instead.
func (*UpdateAllChannelOrderRequest) Descriptor() ([]byte, []int) {
	return file_chat_v1_channels_proto_rawDescGZIP(), []int{10}
}

func (x *UpdateAllChannelOrderRequest) GetGuildId() uint64 {
	if x != nil {
		return x.GuildId
	}
	return 0
}

func (x *UpdateAllChannelOrderRequest) GetChannelIds() []uint64 {
	if x != nil {
		return x.ChannelIds
	}
	return nil
}

// Used in the `UpdateAllChannelOrder` endpoint.
type UpdateAllChannelOrderResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *UpdateAllChannelOrderResponse) Reset() {
	*x = UpdateAllChannelOrderResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_chat_v1_channels_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateAllChannelOrderResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateAllChannelOrderResponse) ProtoMessage() {}

func (x *UpdateAllChannelOrderResponse) ProtoReflect() protoreflect.Message {
	mi := &file_chat_v1_channels_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateAllChannelOrderResponse.ProtoReflect.Descriptor instead.
func (*UpdateAllChannelOrderResponse) Descriptor() ([]byte, []int) {
	return file_chat_v1_channels_proto_rawDescGZIP(), []int{11}
}

// Used in the `DeleteChannel` endpoint.
type DeleteChannelRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Guild ID of the guild that has the channel.
	GuildId uint64 `protobuf:"varint,1,opt,name=guild_id,json=guildId,proto3" json:"guild_id,omitempty"`
	// Channel ID of the channel you want to delete.
	ChannelId uint64 `protobuf:"varint,2,opt,name=channel_id,json=channelId,proto3" json:"channel_id,omitempty"`
}

func (x *DeleteChannelRequest) Reset() {
	*x = DeleteChannelRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_chat_v1_channels_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteChannelRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteChannelRequest) ProtoMessage() {}

func (x *DeleteChannelRequest) ProtoReflect() protoreflect.Message {
	mi := &file_chat_v1_channels_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteChannelRequest.ProtoReflect.Descriptor instead.
func (*DeleteChannelRequest) Descriptor() ([]byte, []int) {
	return file_chat_v1_channels_proto_rawDescGZIP(), []int{12}
}

func (x *DeleteChannelRequest) GetGuildId() uint64 {
	if x != nil {
		return x.GuildId
	}
	return 0
}

func (x *DeleteChannelRequest) GetChannelId() uint64 {
	if x != nil {
		return x.ChannelId
	}
	return 0
}

// Used in the `DeleteChannel` endpoint.
type DeleteChannelResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *DeleteChannelResponse) Reset() {
	*x = DeleteChannelResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_chat_v1_channels_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteChannelResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteChannelResponse) ProtoMessage() {}

func (x *DeleteChannelResponse) ProtoReflect() protoreflect.Message {
	mi := &file_chat_v1_channels_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteChannelResponse.ProtoReflect.Descriptor instead.
func (*DeleteChannelResponse) Descriptor() ([]byte, []int) {
	return file_chat_v1_channels_proto_rawDescGZIP(), []int{13}
}

// Used in `Typing` endpoint.
type TypingRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The guild id of the channel the user is typing in.
	GuildId uint64 `protobuf:"varint,1,opt,name=guild_id,json=guildId,proto3" json:"guild_id,omitempty"`
	// The channel id of the channel the user is typing in.
	ChannelId uint64 `protobuf:"varint,2,opt,name=channel_id,json=channelId,proto3" json:"channel_id,omitempty"`
}

func (x *TypingRequest) Reset() {
	*x = TypingRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_chat_v1_channels_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TypingRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TypingRequest) ProtoMessage() {}

func (x *TypingRequest) ProtoReflect() protoreflect.Message {
	mi := &file_chat_v1_channels_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TypingRequest.ProtoReflect.Descriptor instead.
func (*TypingRequest) Descriptor() ([]byte, []int) {
	return file_chat_v1_channels_proto_rawDescGZIP(), []int{14}
}

func (x *TypingRequest) GetGuildId() uint64 {
	if x != nil {
		return x.GuildId
	}
	return 0
}

func (x *TypingRequest) GetChannelId() uint64 {
	if x != nil {
		return x.ChannelId
	}
	return 0
}

// Used in `Typing` endpoint.
type TypingResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *TypingResponse) Reset() {
	*x = TypingResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_chat_v1_channels_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TypingResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TypingResponse) ProtoMessage() {}

func (x *TypingResponse) ProtoReflect() protoreflect.Message {
	mi := &file_chat_v1_channels_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TypingResponse.ProtoReflect.Descriptor instead.
func (*TypingResponse) Descriptor() ([]byte, []int) {
	return file_chat_v1_channels_proto_rawDescGZIP(), []int{15}
}

var File_chat_v1_channels_proto protoreflect.FileDescriptor

var file_chat_v1_channels_proto_rawDesc = []byte{
	0x0a, 0x16, 0x63, 0x68, 0x61, 0x74, 0x2f, 0x76, 0x31, 0x2f, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65,
	0x6c, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x10, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63,
	0x6f, 0x6c, 0x2e, 0x63, 0x68, 0x61, 0x74, 0x2e, 0x76, 0x31, 0x1a, 0x1b, 0x68, 0x61, 0x72, 0x6d,
	0x6f, 0x6e, 0x79, 0x74, 0x79, 0x70, 0x65, 0x73, 0x2f, 0x76, 0x31, 0x2f, 0x74, 0x79, 0x70, 0x65,
	0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xb1, 0x01, 0x0a, 0x07, 0x43, 0x68, 0x61, 0x6e,
	0x6e, 0x65, 0x6c, 0x12, 0x21, 0x0a, 0x0c, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x5f, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x63, 0x68, 0x61, 0x6e, 0x6e,
	0x65, 0x6c, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x31, 0x0a, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x1d, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x2e,
	0x63, 0x68, 0x61, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x4b,
	0x69, 0x6e, 0x64, 0x52, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x12, 0x43, 0x0a, 0x08, 0x6d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x2e, 0x68, 0x61, 0x72, 0x6d, 0x6f, 0x6e, 0x79, 0x74, 0x79,
	0x70, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x48,
	0x00, 0x52, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x88, 0x01, 0x01, 0x42, 0x0b,
	0x0a, 0x09, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x22, 0x63, 0x0a, 0x0d, 0x43,
	0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x57, 0x69, 0x74, 0x68, 0x49, 0x64, 0x12, 0x1d, 0x0a, 0x0a,
	0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x04,
	0x52, 0x09, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x49, 0x64, 0x12, 0x33, 0x0a, 0x07, 0x63,
	0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x2e, 0x63, 0x68, 0x61, 0x74, 0x2e, 0x76, 0x31, 0x2e,
	0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x52, 0x07, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c,
	0x22, 0xaf, 0x02, 0x0a, 0x14, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x68, 0x61, 0x6e, 0x6e,
	0x65, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x19, 0x0a, 0x08, 0x67, 0x75, 0x69,
	0x6c, 0x64, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x04, 0x52, 0x07, 0x67, 0x75, 0x69,
	0x6c, 0x64, 0x49, 0x64, 0x12, 0x21, 0x0a, 0x0c, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x5f,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x63, 0x68, 0x61, 0x6e,
	0x6e, 0x65, 0x6c, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x31, 0x0a, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1d, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c,
	0x2e, 0x63, 0x68, 0x61, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c,
	0x4b, 0x69, 0x6e, 0x64, 0x52, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x12, 0x43, 0x0a, 0x08, 0x6d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x2e, 0x68, 0x61, 0x72, 0x6d, 0x6f, 0x6e, 0x79, 0x74,
	0x79, 0x70, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x48, 0x00, 0x52, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x88, 0x01, 0x01, 0x12,
	0x47, 0x0a, 0x08, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x26, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x2e, 0x68, 0x61, 0x72,
	0x6d, 0x6f, 0x6e, 0x79, 0x74, 0x79, 0x70, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x74, 0x65,
	0x6d, 0x50, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x01, 0x52, 0x08, 0x70, 0x6f, 0x73,
	0x69, 0x74, 0x69, 0x6f, 0x6e, 0x88, 0x01, 0x01, 0x42, 0x0b, 0x0a, 0x09, 0x5f, 0x6d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x42, 0x0b, 0x0a, 0x09, 0x5f, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x69,
	0x6f, 0x6e, 0x22, 0x36, 0x0a, 0x15, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x68, 0x61, 0x6e,
	0x6e, 0x65, 0x6c, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x63,
	0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x04, 0x52,
	0x09, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x49, 0x64, 0x22, 0x34, 0x0a, 0x17, 0x47, 0x65,
	0x74, 0x47, 0x75, 0x69, 0x6c, 0x64, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x19, 0x0a, 0x08, 0x67, 0x75, 0x69, 0x6c, 0x64, 0x5f, 0x69,
	0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x04, 0x52, 0x07, 0x67, 0x75, 0x69, 0x6c, 0x64, 0x49, 0x64,
	0x22, 0x57, 0x0a, 0x18, 0x47, 0x65, 0x74, 0x47, 0x75, 0x69, 0x6c, 0x64, 0x43, 0x68, 0x61, 0x6e,
	0x6e, 0x65, 0x6c, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x3b, 0x0a, 0x08,
	0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1f,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x2e, 0x63, 0x68, 0x61, 0x74, 0x2e, 0x76,
	0x31, 0x2e, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x57, 0x69, 0x74, 0x68, 0x49, 0x64, 0x52,
	0x08, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x73, 0x22, 0xe5, 0x01, 0x0a, 0x1f, 0x55, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x49, 0x6e, 0x66, 0x6f, 0x72,
	0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x19, 0x0a,
	0x08, 0x67, 0x75, 0x69, 0x6c, 0x64, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x04, 0x52,
	0x07, 0x67, 0x75, 0x69, 0x6c, 0x64, 0x49, 0x64, 0x12, 0x1d, 0x0a, 0x0a, 0x63, 0x68, 0x61, 0x6e,
	0x6e, 0x65, 0x6c, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x04, 0x52, 0x09, 0x63, 0x68,
	0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x49, 0x64, 0x12, 0x1e, 0x0a, 0x08, 0x6e, 0x65, 0x77, 0x5f, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x07, 0x6e, 0x65, 0x77,
	0x4e, 0x61, 0x6d, 0x65, 0x88, 0x01, 0x01, 0x12, 0x4a, 0x0a, 0x0c, 0x6e, 0x65, 0x77, 0x5f, 0x6d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x2e, 0x68, 0x61, 0x72, 0x6d, 0x6f, 0x6e, 0x79,
	0x74, 0x79, 0x70, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x48, 0x01, 0x52, 0x0b, 0x6e, 0x65, 0x77, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x88, 0x01, 0x01, 0x42, 0x0b, 0x0a, 0x09, 0x5f, 0x6e, 0x65, 0x77, 0x5f, 0x6e, 0x61, 0x6d, 0x65,
	0x42, 0x0f, 0x0a, 0x0d, 0x5f, 0x6e, 0x65, 0x77, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x22, 0x22, 0x0a, 0x20, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x43, 0x68, 0x61, 0x6e, 0x6e,
	0x65, 0x6c, 0x49, 0x6e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0xa0, 0x01, 0x0a, 0x19, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x4f, 0x72, 0x64, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x19, 0x0a, 0x08, 0x67, 0x75, 0x69, 0x6c, 0x64, 0x5f, 0x69, 0x64, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x04, 0x52, 0x07, 0x67, 0x75, 0x69, 0x6c, 0x64, 0x49, 0x64, 0x12, 0x1d,
	0x0a, 0x0a, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x04, 0x52, 0x09, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x49, 0x64, 0x12, 0x49, 0x0a,
	0x0c, 0x6e, 0x65, 0x77, 0x5f, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x2e, 0x68,
	0x61, 0x72, 0x6d, 0x6f, 0x6e, 0x79, 0x74, 0x79, 0x70, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x49,
	0x74, 0x65, 0x6d, 0x50, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0b, 0x6e, 0x65, 0x77,
	0x50, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x1c, 0x0a, 0x1a, 0x55, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x4f, 0x72, 0x64, 0x65, 0x72, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x5a, 0x0a, 0x1c, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x41, 0x6c, 0x6c, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x4f, 0x72, 0x64, 0x65, 0x72, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x19, 0x0a, 0x08, 0x67, 0x75, 0x69, 0x6c, 0x64, 0x5f,
	0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x04, 0x52, 0x07, 0x67, 0x75, 0x69, 0x6c, 0x64, 0x49,
	0x64, 0x12, 0x1f, 0x0a, 0x0b, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x5f, 0x69, 0x64, 0x73,
	0x18, 0x02, 0x20, 0x03, 0x28, 0x04, 0x52, 0x0a, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x49,
	0x64, 0x73, 0x22, 0x1f, 0x0a, 0x1d, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x41, 0x6c, 0x6c, 0x43,
	0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x4f, 0x72, 0x64, 0x65, 0x72, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x22, 0x50, 0x0a, 0x14, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x43, 0x68, 0x61,
	0x6e, 0x6e, 0x65, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x19, 0x0a, 0x08, 0x67,
	0x75, 0x69, 0x6c, 0x64, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x04, 0x52, 0x07, 0x67,
	0x75, 0x69, 0x6c, 0x64, 0x49, 0x64, 0x12, 0x1d, 0x0a, 0x0a, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65,
	0x6c, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x04, 0x52, 0x09, 0x63, 0x68, 0x61, 0x6e,
	0x6e, 0x65, 0x6c, 0x49, 0x64, 0x22, 0x17, 0x0a, 0x15, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x43,
	0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x49,
	0x0a, 0x0d, 0x54, 0x79, 0x70, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x19, 0x0a, 0x08, 0x67, 0x75, 0x69, 0x6c, 0x64, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x04, 0x52, 0x07, 0x67, 0x75, 0x69, 0x6c, 0x64, 0x49, 0x64, 0x12, 0x1d, 0x0a, 0x0a, 0x63, 0x68,
	0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x04, 0x52, 0x09,
	0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x49, 0x64, 0x22, 0x10, 0x0a, 0x0e, 0x54, 0x79, 0x70,
	0x69, 0x6e, 0x67, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2a, 0x69, 0x0a, 0x0b, 0x43,
	0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x4b, 0x69, 0x6e, 0x64, 0x12, 0x21, 0x0a, 0x1d, 0x43, 0x48,
	0x41, 0x4e, 0x4e, 0x45, 0x4c, 0x5f, 0x4b, 0x49, 0x4e, 0x44, 0x5f, 0x54, 0x45, 0x58, 0x54, 0x5f,
	0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x1c, 0x0a,
	0x18, 0x43, 0x48, 0x41, 0x4e, 0x4e, 0x45, 0x4c, 0x5f, 0x4b, 0x49, 0x4e, 0x44, 0x5f, 0x56, 0x4f,
	0x49, 0x43, 0x45, 0x5f, 0x4d, 0x45, 0x44, 0x49, 0x41, 0x10, 0x01, 0x12, 0x19, 0x0a, 0x15, 0x43,
	0x48, 0x41, 0x4e, 0x4e, 0x45, 0x4c, 0x5f, 0x4b, 0x49, 0x4e, 0x44, 0x5f, 0x43, 0x41, 0x54, 0x45,
	0x47, 0x4f, 0x52, 0x59, 0x10, 0x02, 0x42, 0xc3, 0x01, 0x0a, 0x14, 0x63, 0x6f, 0x6d, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x2e, 0x63, 0x68, 0x61, 0x74, 0x2e, 0x76, 0x31, 0x42,
	0x0d, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x73, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01,
	0x5a, 0x3a, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x68, 0x61, 0x72,
	0x6d, 0x6f, 0x6e, 0x79, 0x2d, 0x64, 0x65, 0x76, 0x65, 0x6c, 0x6f, 0x70, 0x6d, 0x65, 0x6e, 0x74,
	0x2f, 0x73, 0x68, 0x69, 0x62, 0x73, 0x68, 0x69, 0x62, 0x2f, 0x67, 0x65, 0x6e, 0x2f, 0x63, 0x68,
	0x61, 0x74, 0x2f, 0x76, 0x31, 0x3b, 0x63, 0x68, 0x61, 0x74, 0x76, 0x31, 0xa2, 0x02, 0x03, 0x50,
	0x43, 0x58, 0xaa, 0x02, 0x10, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x2e, 0x43, 0x68,
	0x61, 0x74, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x10, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c,
	0x5c, 0x43, 0x68, 0x61, 0x74, 0x5c, 0x56, 0x31, 0xe2, 0x02, 0x1c, 0x50, 0x72, 0x6f, 0x74, 0x6f,
	0x63, 0x6f, 0x6c, 0x5c, 0x43, 0x68, 0x61, 0x74, 0x5c, 0x56, 0x31, 0x5c, 0x47, 0x50, 0x42, 0x4d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xea, 0x02, 0x12, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63,
	0x6f, 0x6c, 0x3a, 0x3a, 0x43, 0x68, 0x61, 0x74, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_chat_v1_channels_proto_rawDescOnce sync.Once
	file_chat_v1_channels_proto_rawDescData = file_chat_v1_channels_proto_rawDesc
)

func file_chat_v1_channels_proto_rawDescGZIP() []byte {
	file_chat_v1_channels_proto_rawDescOnce.Do(func() {
		file_chat_v1_channels_proto_rawDescData = protoimpl.X.CompressGZIP(file_chat_v1_channels_proto_rawDescData)
	})
	return file_chat_v1_channels_proto_rawDescData
}

var file_chat_v1_channels_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_chat_v1_channels_proto_msgTypes = make([]protoimpl.MessageInfo, 16)
var file_chat_v1_channels_proto_goTypes = []interface{}{
	(ChannelKind)(0),                         // 0: protocol.chat.v1.ChannelKind
	(*Channel)(nil),                          // 1: protocol.chat.v1.Channel
	(*ChannelWithId)(nil),                    // 2: protocol.chat.v1.ChannelWithId
	(*CreateChannelRequest)(nil),             // 3: protocol.chat.v1.CreateChannelRequest
	(*CreateChannelResponse)(nil),            // 4: protocol.chat.v1.CreateChannelResponse
	(*GetGuildChannelsRequest)(nil),          // 5: protocol.chat.v1.GetGuildChannelsRequest
	(*GetGuildChannelsResponse)(nil),         // 6: protocol.chat.v1.GetGuildChannelsResponse
	(*UpdateChannelInformationRequest)(nil),  // 7: protocol.chat.v1.UpdateChannelInformationRequest
	(*UpdateChannelInformationResponse)(nil), // 8: protocol.chat.v1.UpdateChannelInformationResponse
	(*UpdateChannelOrderRequest)(nil),        // 9: protocol.chat.v1.UpdateChannelOrderRequest
	(*UpdateChannelOrderResponse)(nil),       // 10: protocol.chat.v1.UpdateChannelOrderResponse
	(*UpdateAllChannelOrderRequest)(nil),     // 11: protocol.chat.v1.UpdateAllChannelOrderRequest
	(*UpdateAllChannelOrderResponse)(nil),    // 12: protocol.chat.v1.UpdateAllChannelOrderResponse
	(*DeleteChannelRequest)(nil),             // 13: protocol.chat.v1.DeleteChannelRequest
	(*DeleteChannelResponse)(nil),            // 14: protocol.chat.v1.DeleteChannelResponse
	(*TypingRequest)(nil),                    // 15: protocol.chat.v1.TypingRequest
	(*TypingResponse)(nil),                   // 16: protocol.chat.v1.TypingResponse
	(*v1.Metadata)(nil),                      // 17: protocol.harmonytypes.v1.Metadata
	(*v1.ItemPosition)(nil),                  // 18: protocol.harmonytypes.v1.ItemPosition
}
var file_chat_v1_channels_proto_depIdxs = []int32{
	0,  // 0: protocol.chat.v1.Channel.kind:type_name -> protocol.chat.v1.ChannelKind
	17, // 1: protocol.chat.v1.Channel.metadata:type_name -> protocol.harmonytypes.v1.Metadata
	1,  // 2: protocol.chat.v1.ChannelWithId.channel:type_name -> protocol.chat.v1.Channel
	0,  // 3: protocol.chat.v1.CreateChannelRequest.kind:type_name -> protocol.chat.v1.ChannelKind
	17, // 4: protocol.chat.v1.CreateChannelRequest.metadata:type_name -> protocol.harmonytypes.v1.Metadata
	18, // 5: protocol.chat.v1.CreateChannelRequest.position:type_name -> protocol.harmonytypes.v1.ItemPosition
	2,  // 6: protocol.chat.v1.GetGuildChannelsResponse.channels:type_name -> protocol.chat.v1.ChannelWithId
	17, // 7: protocol.chat.v1.UpdateChannelInformationRequest.new_metadata:type_name -> protocol.harmonytypes.v1.Metadata
	18, // 8: protocol.chat.v1.UpdateChannelOrderRequest.new_position:type_name -> protocol.harmonytypes.v1.ItemPosition
	9,  // [9:9] is the sub-list for method output_type
	9,  // [9:9] is the sub-list for method input_type
	9,  // [9:9] is the sub-list for extension type_name
	9,  // [9:9] is the sub-list for extension extendee
	0,  // [0:9] is the sub-list for field type_name
}

func init() { file_chat_v1_channels_proto_init() }
func file_chat_v1_channels_proto_init() {
	if File_chat_v1_channels_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_chat_v1_channels_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Channel); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_chat_v1_channels_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ChannelWithId); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_chat_v1_channels_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateChannelRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_chat_v1_channels_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateChannelResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_chat_v1_channels_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetGuildChannelsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_chat_v1_channels_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetGuildChannelsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_chat_v1_channels_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateChannelInformationRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_chat_v1_channels_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateChannelInformationResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_chat_v1_channels_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateChannelOrderRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_chat_v1_channels_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateChannelOrderResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_chat_v1_channels_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateAllChannelOrderRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_chat_v1_channels_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateAllChannelOrderResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_chat_v1_channels_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteChannelRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_chat_v1_channels_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteChannelResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_chat_v1_channels_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TypingRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_chat_v1_channels_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TypingResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_chat_v1_channels_proto_msgTypes[0].OneofWrappers = []interface{}{}
	file_chat_v1_channels_proto_msgTypes[2].OneofWrappers = []interface{}{}
	file_chat_v1_channels_proto_msgTypes[6].OneofWrappers = []interface{}{}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_chat_v1_channels_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   16,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_chat_v1_channels_proto_goTypes,
		DependencyIndexes: file_chat_v1_channels_proto_depIdxs,
		EnumInfos:         file_chat_v1_channels_proto_enumTypes,
		MessageInfos:      file_chat_v1_channels_proto_msgTypes,
	}.Build()
	File_chat_v1_channels_proto = out.File
	file_chat_v1_channels_proto_rawDesc = nil
	file_chat_v1_channels_proto_goTypes = nil
	file_chat_v1_channels_proto_depIdxs = nil
}
