// Code generated by msgraph.go/gen DO NOT EDIT.

package msgraph

import "time"

// DepEnrollmentBaseProfile The DepEnrollmentBaseProfile resource represents an Apple Device Enrollment Program (DEP) enrollment profile. This type of profile must be assigned to Apple DEP serial numbers before the corresponding devices can enroll via DEP.
type DepEnrollmentBaseProfile struct {
	// EnrollmentProfile is the base model of DepEnrollmentBaseProfile
	EnrollmentProfile
	// IsDefault Indicates if this is the default profile
	IsDefault *bool `json:"isDefault,omitempty"`
	// SupervisedModeEnabled Supervised mode, True to enable, false otherwise. See https://docs.microsoft.com/en-us/intune/deploy-use/enroll-devices-in-microsoft-intune for additional information.
	SupervisedModeEnabled *bool `json:"supervisedModeEnabled,omitempty"`
	// SupportDepartment Support department information
	SupportDepartment *string `json:"supportDepartment,omitempty"`
	// PassCodeDisabled Indicates if Passcode setup pane is disabled
	PassCodeDisabled *bool `json:"passCodeDisabled,omitempty"`
	// IsMandatory Indicates if the profile is mandatory
	IsMandatory *bool `json:"isMandatory,omitempty"`
	// LocationDisabled Indicates if Location service setup pane is disabled
	LocationDisabled *bool `json:"locationDisabled,omitempty"`
	// SupportPhoneNumber Support phone number
	SupportPhoneNumber *string `json:"supportPhoneNumber,omitempty"`
	// ProfileRemovalDisabled Indicates if the profile removal option is disabled
	ProfileRemovalDisabled *bool `json:"profileRemovalDisabled,omitempty"`
	// RestoreBlocked Indicates if Restore setup pane is blocked
	RestoreBlocked *bool `json:"restoreBlocked,omitempty"`
	// AppleIDDisabled Indicates if Apple id setup pane is disabled
	AppleIDDisabled *bool `json:"appleIdDisabled,omitempty"`
	// TermsAndConditionsDisabled Indicates if 'Terms and Conditions' setup pane is disabled
	TermsAndConditionsDisabled *bool `json:"termsAndConditionsDisabled,omitempty"`
	// TouchIDDisabled Indicates if touch id setup pane is disabled
	TouchIDDisabled *bool `json:"touchIdDisabled,omitempty"`
	// ApplePayDisabled Indicates if Apple pay setup pane is disabled
	ApplePayDisabled *bool `json:"applePayDisabled,omitempty"`
	// ZoomDisabled Indicates if zoom setup pane is disabled
	ZoomDisabled *bool `json:"zoomDisabled,omitempty"`
	// SiriDisabled Indicates if siri setup pane is disabled
	SiriDisabled *bool `json:"siriDisabled,omitempty"`
	// DiagnosticsDisabled Indicates if diagnostics setup pane is disabled
	DiagnosticsDisabled *bool `json:"diagnosticsDisabled,omitempty"`
	// DisplayToneSetupDisabled Indicates if displaytone setup screen is disabled
	DisplayToneSetupDisabled *bool `json:"displayToneSetupDisabled,omitempty"`
	// PrivacyPaneDisabled Indicates if privacy screen is disabled
	PrivacyPaneDisabled *bool `json:"privacyPaneDisabled,omitempty"`
	// ScreenTimeScreenDisabled Indicates if screen timeout setup is disabled
	ScreenTimeScreenDisabled *bool `json:"screenTimeScreenDisabled,omitempty"`
	// DeviceNameTemplate Sets a literal or name pattern.
	DeviceNameTemplate *string `json:"deviceNameTemplate,omitempty"`
	// ConfigurationWebURL URL for setup assistant login
	ConfigurationWebURL *bool `json:"configurationWebUrl,omitempty"`
}

// DepEnrollmentProfile The depEnrollmentProfile resource represents an Apple Device Enrollment Program (DEP) enrollment profile. This type of profile must be assigned to Apple DEP serial numbers before the corresponding devices can enroll via DEP.
type DepEnrollmentProfile struct {
	// EnrollmentProfile is the base model of DepEnrollmentProfile
	EnrollmentProfile
	// IsDefault Indicates if this is the default profile
	IsDefault *bool `json:"isDefault,omitempty"`
	// SupervisedModeEnabled Supervised mode, True to enable, false otherwise. See https://docs.microsoft.com/en-us/intune/deploy-use/enroll-devices-in-microsoft-intune for additional information.
	SupervisedModeEnabled *bool `json:"supervisedModeEnabled,omitempty"`
	// SupportDepartment Support department information
	SupportDepartment *string `json:"supportDepartment,omitempty"`
	// PassCodeDisabled Indicates if Passcode setup pane is disabled
	PassCodeDisabled *bool `json:"passCodeDisabled,omitempty"`
	// IsMandatory Indicates if the profile is mandatory
	IsMandatory *bool `json:"isMandatory,omitempty"`
	// LocationDisabled Indicates if Location service setup pane is disabled
	LocationDisabled *bool `json:"locationDisabled,omitempty"`
	// SupportPhoneNumber Support phone number
	SupportPhoneNumber *string `json:"supportPhoneNumber,omitempty"`
	// ITunesPairingMode Indicates the iTunes pairing mode
	ITunesPairingMode *ITunesPairingMode `json:"iTunesPairingMode,omitempty"`
	// ProfileRemovalDisabled Indicates if the profile removal option is disabled
	ProfileRemovalDisabled *bool `json:"profileRemovalDisabled,omitempty"`
	// ManagementCertificates Management certificates for Apple Configurator
	ManagementCertificates []ManagementCertificateWithThumbprint `json:"managementCertificates,omitempty"`
	// RestoreBlocked Indicates if Restore setup pane is blocked
	RestoreBlocked *bool `json:"restoreBlocked,omitempty"`
	// RestoreFromAndroidDisabled Indicates if Restore from Android is disabled
	RestoreFromAndroidDisabled *bool `json:"restoreFromAndroidDisabled,omitempty"`
	// AppleIDDisabled Indicates if Apple id setup pane is disabled
	AppleIDDisabled *bool `json:"appleIdDisabled,omitempty"`
	// TermsAndConditionsDisabled Indicates if 'Terms and Conditions' setup pane is disabled
	TermsAndConditionsDisabled *bool `json:"termsAndConditionsDisabled,omitempty"`
	// TouchIDDisabled Indicates if touch id setup pane is disabled
	TouchIDDisabled *bool `json:"touchIdDisabled,omitempty"`
	// ApplePayDisabled Indicates if Apple pay setup pane is disabled
	ApplePayDisabled *bool `json:"applePayDisabled,omitempty"`
	// ZoomDisabled Indicates if zoom setup pane is disabled
	ZoomDisabled *bool `json:"zoomDisabled,omitempty"`
	// SiriDisabled Indicates if siri setup pane is disabled
	SiriDisabled *bool `json:"siriDisabled,omitempty"`
	// DiagnosticsDisabled Indicates if diagnostics setup pane is disabled
	DiagnosticsDisabled *bool `json:"diagnosticsDisabled,omitempty"`
	// MacOSRegistrationDisabled Indicates if Mac OS registration is disabled
	MacOSRegistrationDisabled *bool `json:"macOSRegistrationDisabled,omitempty"`
	// MacOSFileVaultDisabled Indicates if Mac OS file vault is disabled
	MacOSFileVaultDisabled *bool `json:"macOSFileVaultDisabled,omitempty"`
	// AwaitDeviceConfiguredConfirmation Indicates if the device will need to wait for configured confirmation
	AwaitDeviceConfiguredConfirmation *bool `json:"awaitDeviceConfiguredConfirmation,omitempty"`
	// SharedIPadMaximumUserCount This specifies the maximum number of users that can use a shared iPad. Only applicable in shared iPad mode.
	SharedIPadMaximumUserCount *int `json:"sharedIPadMaximumUserCount,omitempty"`
	// EnableSharedIPad This indicates whether the device is to be enrolled in a mode which enables multi user scenarios. Only applicable in shared iPads.
	EnableSharedIPad *bool `json:"enableSharedIPad,omitempty"`
}

// DepIOSEnrollmentProfile The DepIOSEnrollmentProfile resource represents an Apple Device Enrollment Program (DEP) enrollment profile specific to iOS configuration. This type of profile must be assigned to Apple DEP serial numbers before the corresponding devices can enroll via DEP.
type DepIOSEnrollmentProfile struct {
	// DepEnrollmentBaseProfile is the base model of DepIOSEnrollmentProfile
	DepEnrollmentBaseProfile
	// ITunesPairingMode Indicates the iTunes pairing mode
	ITunesPairingMode *ITunesPairingMode `json:"iTunesPairingMode,omitempty"`
	// ManagementCertificates Management certificates for Apple Configurator
	ManagementCertificates []ManagementCertificateWithThumbprint `json:"managementCertificates,omitempty"`
	// RestoreFromAndroidDisabled Indicates if Restore from Android is disabled
	RestoreFromAndroidDisabled *bool `json:"restoreFromAndroidDisabled,omitempty"`
	// AwaitDeviceConfiguredConfirmation Indicates if the device will need to wait for configured confirmation
	AwaitDeviceConfiguredConfirmation *bool `json:"awaitDeviceConfiguredConfirmation,omitempty"`
	// SharedIPadMaximumUserCount This specifies the maximum number of users that can use a shared iPad. Only applicable in shared iPad mode.
	SharedIPadMaximumUserCount *int `json:"sharedIPadMaximumUserCount,omitempty"`
	// EnableSharedIPad This indicates whether the device is to be enrolled in a mode which enables multi user scenarios. Only applicable in shared iPads.
	EnableSharedIPad *bool `json:"enableSharedIPad,omitempty"`
	// CompanyPortalVPPTokenID If set, indicates which Vpp token should be used to deploy the Company Portal w/ device licensing. 'enableAuthenticationViaCompanyPortal' must be set in order for this property to be set.
	CompanyPortalVPPTokenID *string `json:"companyPortalVppTokenId,omitempty"`
	// EnableSingleAppEnrollmentMode Tells the device to enable single app mode and apply app-lock during enrollment. Default is false. 'enableAuthenticationViaCompanyPortal' and 'companyPortalVppTokenId' must be set for this property to be set.
	EnableSingleAppEnrollmentMode *bool `json:"enableSingleAppEnrollmentMode,omitempty"`
	// HomeButtonScreenDisabled Indicates if home button sensitivity screen is disabled
	HomeButtonScreenDisabled *bool `json:"homeButtonScreenDisabled,omitempty"`
	// IMessageAndFaceTimeScreenDisabled Indicates if iMessage and FaceTime screen is disabled
	IMessageAndFaceTimeScreenDisabled *bool `json:"iMessageAndFaceTimeScreenDisabled,omitempty"`
	// OnBoardingScreenDisabled Indicates if onboarding setup screen is disabled
	OnBoardingScreenDisabled *bool `json:"onBoardingScreenDisabled,omitempty"`
	// SimSetupScreenDisabled Indicates if the SIMSetup screen is disabled
	SimSetupScreenDisabled *bool `json:"simSetupScreenDisabled,omitempty"`
	// SoftwareUpdateScreenDisabled Indicates if the mandatory sofware update screen is disabled
	SoftwareUpdateScreenDisabled *bool `json:"softwareUpdateScreenDisabled,omitempty"`
	// WatchMigrationScreenDisabled Indicates if the watch migration screen is disabled
	WatchMigrationScreenDisabled *bool `json:"watchMigrationScreenDisabled,omitempty"`
	// AppearanceScreenDisabled Indicates if Apperance screen is disabled
	AppearanceScreenDisabled *bool `json:"appearanceScreenDisabled,omitempty"`
	// ExpressLanguageScreenDisabled Indicates if Express Language screen is disabled
	ExpressLanguageScreenDisabled *bool `json:"expressLanguageScreenDisabled,omitempty"`
	// PreferredLanguageScreenDisabled Indicates if Preferred language screen is disabled
	PreferredLanguageScreenDisabled *bool `json:"preferredLanguageScreenDisabled,omitempty"`
	// DeviceToDeviceMigrationDisabled Indicates if Device To Device Migration is disabled
	DeviceToDeviceMigrationDisabled *bool `json:"deviceToDeviceMigrationDisabled,omitempty"`
	// WelcomeScreenDisabled Indicates if Weclome screen is disabled
	WelcomeScreenDisabled *bool `json:"welcomeScreenDisabled,omitempty"`
}

// DepMacOSEnrollmentProfile The DepMacOSEnrollmentProfile resource represents an Apple Device Enrollment Program (DEP) enrollment profile specific to macOS configuration. This type of profile must be assigned to Apple DEP serial numbers before the corresponding devices can enroll via DEP.
type DepMacOSEnrollmentProfile struct {
	// DepEnrollmentBaseProfile is the base model of DepMacOSEnrollmentProfile
	DepEnrollmentBaseProfile
	// RegistrationDisabled Indicates if registration is disabled
	RegistrationDisabled *bool `json:"registrationDisabled,omitempty"`
	// FileVaultDisabled Indicates if file vault is disabled
	FileVaultDisabled *bool `json:"fileVaultDisabled,omitempty"`
	// ICloudDiagnosticsDisabled Indicates if iCloud Analytics screen is disabled
	ICloudDiagnosticsDisabled *bool `json:"iCloudDiagnosticsDisabled,omitempty"`
	// ICloudStorageDisabled Indicates if iCloud Documents and Desktop screen is disabled
	ICloudStorageDisabled *bool `json:"iCloudStorageDisabled,omitempty"`
	// ChooseYourLockScreenDisabled Indicates if iCloud Documents and Desktop screen is disabled
	ChooseYourLockScreenDisabled *bool `json:"chooseYourLockScreenDisabled,omitempty"`
}

// DepOnboardingSetting The depOnboardingSetting represents an instance of the Apple DEP service being onboarded to Intune. The onboarded service instance manages an Apple Token used to synchronize data between Apple and Intune.
type DepOnboardingSetting struct {
	// Entity is the base model of DepOnboardingSetting
	Entity
	// AppleIdentifier The Apple ID used to obtain the current token.
	AppleIdentifier *string `json:"appleIdentifier,omitempty"`
	// TokenExpirationDateTime When the token will expire.
	TokenExpirationDateTime *time.Time `json:"tokenExpirationDateTime,omitempty"`
	// LastModifiedDateTime When the service was onboarded.
	LastModifiedDateTime *time.Time `json:"lastModifiedDateTime,omitempty"`
	// LastSuccessfulSyncDateTime When the service last syned with Intune
	LastSuccessfulSyncDateTime *time.Time `json:"lastSuccessfulSyncDateTime,omitempty"`
	// LastSyncTriggeredDateTime When Intune last requested a sync.
	LastSyncTriggeredDateTime *time.Time `json:"lastSyncTriggeredDateTime,omitempty"`
	// ShareTokenWithSchoolDataSyncService Whether or not the Dep token sharing is enabled with the School Data Sync service.
	ShareTokenWithSchoolDataSyncService *bool `json:"shareTokenWithSchoolDataSyncService,omitempty"`
	// LastSyncErrorCode Error code reported by Apple during last dep sync.
	LastSyncErrorCode *int `json:"lastSyncErrorCode,omitempty"`
	// TokenType Gets or sets the Dep Token Type.
	TokenType *DepTokenType `json:"tokenType,omitempty"`
	// TokenName Friendly Name for Dep Token
	TokenName *string `json:"tokenName,omitempty"`
	// SyncedDeviceCount Gets synced device count
	SyncedDeviceCount *int `json:"syncedDeviceCount,omitempty"`
	// DataSharingConsentGranted Consent granted for data sharing with Apple Dep Service
	DataSharingConsentGranted *bool `json:"dataSharingConsentGranted,omitempty"`
	// RoleScopeTagIDs List of Scope Tags for this Entity instance.
	RoleScopeTagIDs []string `json:"roleScopeTagIds,omitempty"`
	// DefaultIOSEnrollmentProfile undocumented
	DefaultIOSEnrollmentProfile *DepIOSEnrollmentProfile `json:"defaultIosEnrollmentProfile,omitempty"`
	// DefaultMacOsEnrollmentProfile undocumented
	DefaultMacOsEnrollmentProfile *DepMacOSEnrollmentProfile `json:"defaultMacOsEnrollmentProfile,omitempty"`
	// EnrollmentProfiles undocumented
	EnrollmentProfiles []EnrollmentProfile `json:"enrollmentProfiles,omitempty"`
	// ImportedAppleDeviceIdentities undocumented
	ImportedAppleDeviceIdentities []ImportedAppleDeviceIdentity `json:"importedAppleDeviceIdentities,omitempty"`
}
