// Code generated by msgraph.go/gen DO NOT EDIT.

package msgraph

import (
	"context"
	"fmt"
	"io/ioutil"
	"net/http"

	"github.com/yaegashi/msgraph.go/jsonx"
)

// AccessPackageAssignmentPolicies returns request builder for AccessPackageAssignmentPolicy collection
func (b *GraphServiceRequestBuilder) AccessPackageAssignmentPolicies() *GraphServiceAccessPackageAssignmentPoliciesCollectionRequestBuilder {
	bb := &GraphServiceAccessPackageAssignmentPoliciesCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/accessPackageAssignmentPolicies"
	return bb
}

// GraphServiceAccessPackageAssignmentPoliciesCollectionRequestBuilder is request builder for AccessPackageAssignmentPolicy collection
type GraphServiceAccessPackageAssignmentPoliciesCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for AccessPackageAssignmentPolicy collection
func (b *GraphServiceAccessPackageAssignmentPoliciesCollectionRequestBuilder) Request() *GraphServiceAccessPackageAssignmentPoliciesCollectionRequest {
	return &GraphServiceAccessPackageAssignmentPoliciesCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for AccessPackageAssignmentPolicy item
func (b *GraphServiceAccessPackageAssignmentPoliciesCollectionRequestBuilder) ID(id string) *AccessPackageAssignmentPolicyRequestBuilder {
	bb := &AccessPackageAssignmentPolicyRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// GraphServiceAccessPackageAssignmentPoliciesCollectionRequest is request for AccessPackageAssignmentPolicy collection
type GraphServiceAccessPackageAssignmentPoliciesCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for AccessPackageAssignmentPolicy collection
func (r *GraphServiceAccessPackageAssignmentPoliciesCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]AccessPackageAssignmentPolicy, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []AccessPackageAssignmentPolicy
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []AccessPackageAssignmentPolicy
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for AccessPackageAssignmentPolicy collection, max N pages
func (r *GraphServiceAccessPackageAssignmentPoliciesCollectionRequest) GetN(ctx context.Context, n int) ([]AccessPackageAssignmentPolicy, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for AccessPackageAssignmentPolicy collection
func (r *GraphServiceAccessPackageAssignmentPoliciesCollectionRequest) Get(ctx context.Context) ([]AccessPackageAssignmentPolicy, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for AccessPackageAssignmentPolicy collection
func (r *GraphServiceAccessPackageAssignmentPoliciesCollectionRequest) Add(ctx context.Context, reqObj *AccessPackageAssignmentPolicy) (resObj *AccessPackageAssignmentPolicy, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// AccessPackageAssignmentRequests returns request builder for AccessPackageAssignmentRequestObject collection
func (b *GraphServiceRequestBuilder) AccessPackageAssignmentRequests() *GraphServiceAccessPackageAssignmentRequestsCollectionRequestBuilder {
	bb := &GraphServiceAccessPackageAssignmentRequestsCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/accessPackageAssignmentRequests"
	return bb
}

// GraphServiceAccessPackageAssignmentRequestsCollectionRequestBuilder is request builder for AccessPackageAssignmentRequestObject collection
type GraphServiceAccessPackageAssignmentRequestsCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for AccessPackageAssignmentRequestObject collection
func (b *GraphServiceAccessPackageAssignmentRequestsCollectionRequestBuilder) Request() *GraphServiceAccessPackageAssignmentRequestsCollectionRequest {
	return &GraphServiceAccessPackageAssignmentRequestsCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for AccessPackageAssignmentRequestObject item
func (b *GraphServiceAccessPackageAssignmentRequestsCollectionRequestBuilder) ID(id string) *AccessPackageAssignmentRequestObjectRequestBuilder {
	bb := &AccessPackageAssignmentRequestObjectRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// GraphServiceAccessPackageAssignmentRequestsCollectionRequest is request for AccessPackageAssignmentRequestObject collection
type GraphServiceAccessPackageAssignmentRequestsCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for AccessPackageAssignmentRequestObject collection
func (r *GraphServiceAccessPackageAssignmentRequestsCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]AccessPackageAssignmentRequestObject, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []AccessPackageAssignmentRequestObject
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []AccessPackageAssignmentRequestObject
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for AccessPackageAssignmentRequestObject collection, max N pages
func (r *GraphServiceAccessPackageAssignmentRequestsCollectionRequest) GetN(ctx context.Context, n int) ([]AccessPackageAssignmentRequestObject, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for AccessPackageAssignmentRequestObject collection
func (r *GraphServiceAccessPackageAssignmentRequestsCollectionRequest) Get(ctx context.Context) ([]AccessPackageAssignmentRequestObject, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for AccessPackageAssignmentRequestObject collection
func (r *GraphServiceAccessPackageAssignmentRequestsCollectionRequest) Add(ctx context.Context, reqObj *AccessPackageAssignmentRequestObject) (resObj *AccessPackageAssignmentRequestObject, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// AccessPackageAssignmentResourceRoles returns request builder for AccessPackageAssignmentResourceRole collection
func (b *GraphServiceRequestBuilder) AccessPackageAssignmentResourceRoles() *GraphServiceAccessPackageAssignmentResourceRolesCollectionRequestBuilder {
	bb := &GraphServiceAccessPackageAssignmentResourceRolesCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/accessPackageAssignmentResourceRoles"
	return bb
}

// GraphServiceAccessPackageAssignmentResourceRolesCollectionRequestBuilder is request builder for AccessPackageAssignmentResourceRole collection
type GraphServiceAccessPackageAssignmentResourceRolesCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for AccessPackageAssignmentResourceRole collection
func (b *GraphServiceAccessPackageAssignmentResourceRolesCollectionRequestBuilder) Request() *GraphServiceAccessPackageAssignmentResourceRolesCollectionRequest {
	return &GraphServiceAccessPackageAssignmentResourceRolesCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for AccessPackageAssignmentResourceRole item
func (b *GraphServiceAccessPackageAssignmentResourceRolesCollectionRequestBuilder) ID(id string) *AccessPackageAssignmentResourceRoleRequestBuilder {
	bb := &AccessPackageAssignmentResourceRoleRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// GraphServiceAccessPackageAssignmentResourceRolesCollectionRequest is request for AccessPackageAssignmentResourceRole collection
type GraphServiceAccessPackageAssignmentResourceRolesCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for AccessPackageAssignmentResourceRole collection
func (r *GraphServiceAccessPackageAssignmentResourceRolesCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]AccessPackageAssignmentResourceRole, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []AccessPackageAssignmentResourceRole
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []AccessPackageAssignmentResourceRole
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for AccessPackageAssignmentResourceRole collection, max N pages
func (r *GraphServiceAccessPackageAssignmentResourceRolesCollectionRequest) GetN(ctx context.Context, n int) ([]AccessPackageAssignmentResourceRole, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for AccessPackageAssignmentResourceRole collection
func (r *GraphServiceAccessPackageAssignmentResourceRolesCollectionRequest) Get(ctx context.Context) ([]AccessPackageAssignmentResourceRole, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for AccessPackageAssignmentResourceRole collection
func (r *GraphServiceAccessPackageAssignmentResourceRolesCollectionRequest) Add(ctx context.Context, reqObj *AccessPackageAssignmentResourceRole) (resObj *AccessPackageAssignmentResourceRole, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// AccessPackageAssignments returns request builder for AccessPackageAssignment collection
func (b *GraphServiceRequestBuilder) AccessPackageAssignments() *GraphServiceAccessPackageAssignmentsCollectionRequestBuilder {
	bb := &GraphServiceAccessPackageAssignmentsCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/accessPackageAssignments"
	return bb
}

// GraphServiceAccessPackageAssignmentsCollectionRequestBuilder is request builder for AccessPackageAssignment collection
type GraphServiceAccessPackageAssignmentsCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for AccessPackageAssignment collection
func (b *GraphServiceAccessPackageAssignmentsCollectionRequestBuilder) Request() *GraphServiceAccessPackageAssignmentsCollectionRequest {
	return &GraphServiceAccessPackageAssignmentsCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for AccessPackageAssignment item
func (b *GraphServiceAccessPackageAssignmentsCollectionRequestBuilder) ID(id string) *AccessPackageAssignmentRequestBuilder {
	bb := &AccessPackageAssignmentRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// GraphServiceAccessPackageAssignmentsCollectionRequest is request for AccessPackageAssignment collection
type GraphServiceAccessPackageAssignmentsCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for AccessPackageAssignment collection
func (r *GraphServiceAccessPackageAssignmentsCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]AccessPackageAssignment, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []AccessPackageAssignment
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []AccessPackageAssignment
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for AccessPackageAssignment collection, max N pages
func (r *GraphServiceAccessPackageAssignmentsCollectionRequest) GetN(ctx context.Context, n int) ([]AccessPackageAssignment, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for AccessPackageAssignment collection
func (r *GraphServiceAccessPackageAssignmentsCollectionRequest) Get(ctx context.Context) ([]AccessPackageAssignment, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for AccessPackageAssignment collection
func (r *GraphServiceAccessPackageAssignmentsCollectionRequest) Add(ctx context.Context, reqObj *AccessPackageAssignment) (resObj *AccessPackageAssignment, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// AccessPackageCatalogs returns request builder for AccessPackageCatalog collection
func (b *GraphServiceRequestBuilder) AccessPackageCatalogs() *GraphServiceAccessPackageCatalogsCollectionRequestBuilder {
	bb := &GraphServiceAccessPackageCatalogsCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/accessPackageCatalogs"
	return bb
}

// GraphServiceAccessPackageCatalogsCollectionRequestBuilder is request builder for AccessPackageCatalog collection
type GraphServiceAccessPackageCatalogsCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for AccessPackageCatalog collection
func (b *GraphServiceAccessPackageCatalogsCollectionRequestBuilder) Request() *GraphServiceAccessPackageCatalogsCollectionRequest {
	return &GraphServiceAccessPackageCatalogsCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for AccessPackageCatalog item
func (b *GraphServiceAccessPackageCatalogsCollectionRequestBuilder) ID(id string) *AccessPackageCatalogRequestBuilder {
	bb := &AccessPackageCatalogRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// GraphServiceAccessPackageCatalogsCollectionRequest is request for AccessPackageCatalog collection
type GraphServiceAccessPackageCatalogsCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for AccessPackageCatalog collection
func (r *GraphServiceAccessPackageCatalogsCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]AccessPackageCatalog, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []AccessPackageCatalog
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []AccessPackageCatalog
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for AccessPackageCatalog collection, max N pages
func (r *GraphServiceAccessPackageCatalogsCollectionRequest) GetN(ctx context.Context, n int) ([]AccessPackageCatalog, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for AccessPackageCatalog collection
func (r *GraphServiceAccessPackageCatalogsCollectionRequest) Get(ctx context.Context) ([]AccessPackageCatalog, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for AccessPackageCatalog collection
func (r *GraphServiceAccessPackageCatalogsCollectionRequest) Add(ctx context.Context, reqObj *AccessPackageCatalog) (resObj *AccessPackageCatalog, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// AccessPackageResourceRequests returns request builder for AccessPackageResourceRequestObject collection
func (b *GraphServiceRequestBuilder) AccessPackageResourceRequests() *GraphServiceAccessPackageResourceRequestsCollectionRequestBuilder {
	bb := &GraphServiceAccessPackageResourceRequestsCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/accessPackageResourceRequests"
	return bb
}

// GraphServiceAccessPackageResourceRequestsCollectionRequestBuilder is request builder for AccessPackageResourceRequestObject collection
type GraphServiceAccessPackageResourceRequestsCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for AccessPackageResourceRequestObject collection
func (b *GraphServiceAccessPackageResourceRequestsCollectionRequestBuilder) Request() *GraphServiceAccessPackageResourceRequestsCollectionRequest {
	return &GraphServiceAccessPackageResourceRequestsCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for AccessPackageResourceRequestObject item
func (b *GraphServiceAccessPackageResourceRequestsCollectionRequestBuilder) ID(id string) *AccessPackageResourceRequestObjectRequestBuilder {
	bb := &AccessPackageResourceRequestObjectRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// GraphServiceAccessPackageResourceRequestsCollectionRequest is request for AccessPackageResourceRequestObject collection
type GraphServiceAccessPackageResourceRequestsCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for AccessPackageResourceRequestObject collection
func (r *GraphServiceAccessPackageResourceRequestsCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]AccessPackageResourceRequestObject, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []AccessPackageResourceRequestObject
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []AccessPackageResourceRequestObject
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for AccessPackageResourceRequestObject collection, max N pages
func (r *GraphServiceAccessPackageResourceRequestsCollectionRequest) GetN(ctx context.Context, n int) ([]AccessPackageResourceRequestObject, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for AccessPackageResourceRequestObject collection
func (r *GraphServiceAccessPackageResourceRequestsCollectionRequest) Get(ctx context.Context) ([]AccessPackageResourceRequestObject, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for AccessPackageResourceRequestObject collection
func (r *GraphServiceAccessPackageResourceRequestsCollectionRequest) Add(ctx context.Context, reqObj *AccessPackageResourceRequestObject) (resObj *AccessPackageResourceRequestObject, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// AccessPackageResourceRoleScopes returns request builder for AccessPackageResourceRoleScope collection
func (b *GraphServiceRequestBuilder) AccessPackageResourceRoleScopes() *GraphServiceAccessPackageResourceRoleScopesCollectionRequestBuilder {
	bb := &GraphServiceAccessPackageResourceRoleScopesCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/accessPackageResourceRoleScopes"
	return bb
}

// GraphServiceAccessPackageResourceRoleScopesCollectionRequestBuilder is request builder for AccessPackageResourceRoleScope collection
type GraphServiceAccessPackageResourceRoleScopesCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for AccessPackageResourceRoleScope collection
func (b *GraphServiceAccessPackageResourceRoleScopesCollectionRequestBuilder) Request() *GraphServiceAccessPackageResourceRoleScopesCollectionRequest {
	return &GraphServiceAccessPackageResourceRoleScopesCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for AccessPackageResourceRoleScope item
func (b *GraphServiceAccessPackageResourceRoleScopesCollectionRequestBuilder) ID(id string) *AccessPackageResourceRoleScopeRequestBuilder {
	bb := &AccessPackageResourceRoleScopeRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// GraphServiceAccessPackageResourceRoleScopesCollectionRequest is request for AccessPackageResourceRoleScope collection
type GraphServiceAccessPackageResourceRoleScopesCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for AccessPackageResourceRoleScope collection
func (r *GraphServiceAccessPackageResourceRoleScopesCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]AccessPackageResourceRoleScope, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []AccessPackageResourceRoleScope
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []AccessPackageResourceRoleScope
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for AccessPackageResourceRoleScope collection, max N pages
func (r *GraphServiceAccessPackageResourceRoleScopesCollectionRequest) GetN(ctx context.Context, n int) ([]AccessPackageResourceRoleScope, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for AccessPackageResourceRoleScope collection
func (r *GraphServiceAccessPackageResourceRoleScopesCollectionRequest) Get(ctx context.Context) ([]AccessPackageResourceRoleScope, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for AccessPackageResourceRoleScope collection
func (r *GraphServiceAccessPackageResourceRoleScopesCollectionRequest) Add(ctx context.Context, reqObj *AccessPackageResourceRoleScope) (resObj *AccessPackageResourceRoleScope, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// AccessPackageResources returns request builder for AccessPackageResource collection
func (b *GraphServiceRequestBuilder) AccessPackageResources() *GraphServiceAccessPackageResourcesCollectionRequestBuilder {
	bb := &GraphServiceAccessPackageResourcesCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/accessPackageResources"
	return bb
}

// GraphServiceAccessPackageResourcesCollectionRequestBuilder is request builder for AccessPackageResource collection
type GraphServiceAccessPackageResourcesCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for AccessPackageResource collection
func (b *GraphServiceAccessPackageResourcesCollectionRequestBuilder) Request() *GraphServiceAccessPackageResourcesCollectionRequest {
	return &GraphServiceAccessPackageResourcesCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for AccessPackageResource item
func (b *GraphServiceAccessPackageResourcesCollectionRequestBuilder) ID(id string) *AccessPackageResourceRequestBuilder {
	bb := &AccessPackageResourceRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// GraphServiceAccessPackageResourcesCollectionRequest is request for AccessPackageResource collection
type GraphServiceAccessPackageResourcesCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for AccessPackageResource collection
func (r *GraphServiceAccessPackageResourcesCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]AccessPackageResource, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []AccessPackageResource
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []AccessPackageResource
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for AccessPackageResource collection, max N pages
func (r *GraphServiceAccessPackageResourcesCollectionRequest) GetN(ctx context.Context, n int) ([]AccessPackageResource, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for AccessPackageResource collection
func (r *GraphServiceAccessPackageResourcesCollectionRequest) Get(ctx context.Context) ([]AccessPackageResource, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for AccessPackageResource collection
func (r *GraphServiceAccessPackageResourcesCollectionRequest) Add(ctx context.Context, reqObj *AccessPackageResource) (resObj *AccessPackageResource, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// AccessPackages returns request builder for AccessPackage collection
func (b *GraphServiceRequestBuilder) AccessPackages() *GraphServiceAccessPackagesCollectionRequestBuilder {
	bb := &GraphServiceAccessPackagesCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/accessPackages"
	return bb
}

// GraphServiceAccessPackagesCollectionRequestBuilder is request builder for AccessPackage collection
type GraphServiceAccessPackagesCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for AccessPackage collection
func (b *GraphServiceAccessPackagesCollectionRequestBuilder) Request() *GraphServiceAccessPackagesCollectionRequest {
	return &GraphServiceAccessPackagesCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for AccessPackage item
func (b *GraphServiceAccessPackagesCollectionRequestBuilder) ID(id string) *AccessPackageRequestBuilder {
	bb := &AccessPackageRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// GraphServiceAccessPackagesCollectionRequest is request for AccessPackage collection
type GraphServiceAccessPackagesCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for AccessPackage collection
func (r *GraphServiceAccessPackagesCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]AccessPackage, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []AccessPackage
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []AccessPackage
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for AccessPackage collection, max N pages
func (r *GraphServiceAccessPackagesCollectionRequest) GetN(ctx context.Context, n int) ([]AccessPackage, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for AccessPackage collection
func (r *GraphServiceAccessPackagesCollectionRequest) Get(ctx context.Context) ([]AccessPackage, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for AccessPackage collection
func (r *GraphServiceAccessPackagesCollectionRequest) Add(ctx context.Context, reqObj *AccessPackage) (resObj *AccessPackage, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// AccessReviewDecisions returns request builder for AccessReviewDecision collection
func (b *GraphServiceRequestBuilder) AccessReviewDecisions() *GraphServiceAccessReviewDecisionsCollectionRequestBuilder {
	bb := &GraphServiceAccessReviewDecisionsCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/accessReviewDecisions"
	return bb
}

// GraphServiceAccessReviewDecisionsCollectionRequestBuilder is request builder for AccessReviewDecision collection
type GraphServiceAccessReviewDecisionsCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for AccessReviewDecision collection
func (b *GraphServiceAccessReviewDecisionsCollectionRequestBuilder) Request() *GraphServiceAccessReviewDecisionsCollectionRequest {
	return &GraphServiceAccessReviewDecisionsCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for AccessReviewDecision item
func (b *GraphServiceAccessReviewDecisionsCollectionRequestBuilder) ID(id string) *AccessReviewDecisionRequestBuilder {
	bb := &AccessReviewDecisionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// GraphServiceAccessReviewDecisionsCollectionRequest is request for AccessReviewDecision collection
type GraphServiceAccessReviewDecisionsCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for AccessReviewDecision collection
func (r *GraphServiceAccessReviewDecisionsCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]AccessReviewDecision, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []AccessReviewDecision
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []AccessReviewDecision
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for AccessReviewDecision collection, max N pages
func (r *GraphServiceAccessReviewDecisionsCollectionRequest) GetN(ctx context.Context, n int) ([]AccessReviewDecision, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for AccessReviewDecision collection
func (r *GraphServiceAccessReviewDecisionsCollectionRequest) Get(ctx context.Context) ([]AccessReviewDecision, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for AccessReviewDecision collection
func (r *GraphServiceAccessReviewDecisionsCollectionRequest) Add(ctx context.Context, reqObj *AccessReviewDecision) (resObj *AccessReviewDecision, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// AccessReviews returns request builder for AccessReview collection
func (b *GraphServiceRequestBuilder) AccessReviews() *GraphServiceAccessReviewsCollectionRequestBuilder {
	bb := &GraphServiceAccessReviewsCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/accessReviews"
	return bb
}

// GraphServiceAccessReviewsCollectionRequestBuilder is request builder for AccessReview collection
type GraphServiceAccessReviewsCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for AccessReview collection
func (b *GraphServiceAccessReviewsCollectionRequestBuilder) Request() *GraphServiceAccessReviewsCollectionRequest {
	return &GraphServiceAccessReviewsCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for AccessReview item
func (b *GraphServiceAccessReviewsCollectionRequestBuilder) ID(id string) *AccessReviewRequestBuilder {
	bb := &AccessReviewRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// GraphServiceAccessReviewsCollectionRequest is request for AccessReview collection
type GraphServiceAccessReviewsCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for AccessReview collection
func (r *GraphServiceAccessReviewsCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]AccessReview, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []AccessReview
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []AccessReview
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for AccessReview collection, max N pages
func (r *GraphServiceAccessReviewsCollectionRequest) GetN(ctx context.Context, n int) ([]AccessReview, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for AccessReview collection
func (r *GraphServiceAccessReviewsCollectionRequest) Get(ctx context.Context) ([]AccessReview, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for AccessReview collection
func (r *GraphServiceAccessReviewsCollectionRequest) Add(ctx context.Context, reqObj *AccessReview) (resObj *AccessReview, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// Activitystatistics returns request builder for ActivityStatistics collection
func (b *GraphServiceRequestBuilder) Activitystatistics() *GraphServiceActivitystatisticsCollectionRequestBuilder {
	bb := &GraphServiceActivitystatisticsCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/activitystatistics"
	return bb
}

// GraphServiceActivitystatisticsCollectionRequestBuilder is request builder for ActivityStatistics collection
type GraphServiceActivitystatisticsCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for ActivityStatistics collection
func (b *GraphServiceActivitystatisticsCollectionRequestBuilder) Request() *GraphServiceActivitystatisticsCollectionRequest {
	return &GraphServiceActivitystatisticsCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for ActivityStatistics item
func (b *GraphServiceActivitystatisticsCollectionRequestBuilder) ID(id string) *ActivityStatisticsRequestBuilder {
	bb := &ActivityStatisticsRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// GraphServiceActivitystatisticsCollectionRequest is request for ActivityStatistics collection
type GraphServiceActivitystatisticsCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for ActivityStatistics collection
func (r *GraphServiceActivitystatisticsCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]ActivityStatistics, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []ActivityStatistics
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []ActivityStatistics
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for ActivityStatistics collection, max N pages
func (r *GraphServiceActivitystatisticsCollectionRequest) GetN(ctx context.Context, n int) ([]ActivityStatistics, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for ActivityStatistics collection
func (r *GraphServiceActivitystatisticsCollectionRequest) Get(ctx context.Context) ([]ActivityStatistics, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for ActivityStatistics collection
func (r *GraphServiceActivitystatisticsCollectionRequest) Add(ctx context.Context, reqObj *ActivityStatistics) (resObj *ActivityStatistics, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// AdministrativeUnits returns request builder for AdministrativeUnit collection
func (b *GraphServiceRequestBuilder) AdministrativeUnits() *GraphServiceAdministrativeUnitsCollectionRequestBuilder {
	bb := &GraphServiceAdministrativeUnitsCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/administrativeUnits"
	return bb
}

// GraphServiceAdministrativeUnitsCollectionRequestBuilder is request builder for AdministrativeUnit collection
type GraphServiceAdministrativeUnitsCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for AdministrativeUnit collection
func (b *GraphServiceAdministrativeUnitsCollectionRequestBuilder) Request() *GraphServiceAdministrativeUnitsCollectionRequest {
	return &GraphServiceAdministrativeUnitsCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for AdministrativeUnit item
func (b *GraphServiceAdministrativeUnitsCollectionRequestBuilder) ID(id string) *AdministrativeUnitRequestBuilder {
	bb := &AdministrativeUnitRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// GraphServiceAdministrativeUnitsCollectionRequest is request for AdministrativeUnit collection
type GraphServiceAdministrativeUnitsCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for AdministrativeUnit collection
func (r *GraphServiceAdministrativeUnitsCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]AdministrativeUnit, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []AdministrativeUnit
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []AdministrativeUnit
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for AdministrativeUnit collection, max N pages
func (r *GraphServiceAdministrativeUnitsCollectionRequest) GetN(ctx context.Context, n int) ([]AdministrativeUnit, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for AdministrativeUnit collection
func (r *GraphServiceAdministrativeUnitsCollectionRequest) Get(ctx context.Context) ([]AdministrativeUnit, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for AdministrativeUnit collection
func (r *GraphServiceAdministrativeUnitsCollectionRequest) Add(ctx context.Context, reqObj *AdministrativeUnit) (resObj *AdministrativeUnit, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// AgreementAcceptances returns request builder for AgreementAcceptance collection
func (b *GraphServiceRequestBuilder) AgreementAcceptances() *GraphServiceAgreementAcceptancesCollectionRequestBuilder {
	bb := &GraphServiceAgreementAcceptancesCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/agreementAcceptances"
	return bb
}

// GraphServiceAgreementAcceptancesCollectionRequestBuilder is request builder for AgreementAcceptance collection
type GraphServiceAgreementAcceptancesCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for AgreementAcceptance collection
func (b *GraphServiceAgreementAcceptancesCollectionRequestBuilder) Request() *GraphServiceAgreementAcceptancesCollectionRequest {
	return &GraphServiceAgreementAcceptancesCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for AgreementAcceptance item
func (b *GraphServiceAgreementAcceptancesCollectionRequestBuilder) ID(id string) *AgreementAcceptanceRequestBuilder {
	bb := &AgreementAcceptanceRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// GraphServiceAgreementAcceptancesCollectionRequest is request for AgreementAcceptance collection
type GraphServiceAgreementAcceptancesCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for AgreementAcceptance collection
func (r *GraphServiceAgreementAcceptancesCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]AgreementAcceptance, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []AgreementAcceptance
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []AgreementAcceptance
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for AgreementAcceptance collection, max N pages
func (r *GraphServiceAgreementAcceptancesCollectionRequest) GetN(ctx context.Context, n int) ([]AgreementAcceptance, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for AgreementAcceptance collection
func (r *GraphServiceAgreementAcceptancesCollectionRequest) Get(ctx context.Context) ([]AgreementAcceptance, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for AgreementAcceptance collection
func (r *GraphServiceAgreementAcceptancesCollectionRequest) Add(ctx context.Context, reqObj *AgreementAcceptance) (resObj *AgreementAcceptance, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// Agreements returns request builder for Agreement collection
func (b *GraphServiceRequestBuilder) Agreements() *GraphServiceAgreementsCollectionRequestBuilder {
	bb := &GraphServiceAgreementsCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/agreements"
	return bb
}

// GraphServiceAgreementsCollectionRequestBuilder is request builder for Agreement collection
type GraphServiceAgreementsCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for Agreement collection
func (b *GraphServiceAgreementsCollectionRequestBuilder) Request() *GraphServiceAgreementsCollectionRequest {
	return &GraphServiceAgreementsCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for Agreement item
func (b *GraphServiceAgreementsCollectionRequestBuilder) ID(id string) *AgreementRequestBuilder {
	bb := &AgreementRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// GraphServiceAgreementsCollectionRequest is request for Agreement collection
type GraphServiceAgreementsCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for Agreement collection
func (r *GraphServiceAgreementsCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]Agreement, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []Agreement
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []Agreement
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for Agreement collection, max N pages
func (r *GraphServiceAgreementsCollectionRequest) GetN(ctx context.Context, n int) ([]Agreement, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for Agreement collection
func (r *GraphServiceAgreementsCollectionRequest) Get(ctx context.Context) ([]Agreement, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for Agreement collection
func (r *GraphServiceAgreementsCollectionRequest) Add(ctx context.Context, reqObj *Agreement) (resObj *Agreement, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// AllowedDataLocations returns request builder for AllowedDataLocation collection
func (b *GraphServiceRequestBuilder) AllowedDataLocations() *GraphServiceAllowedDataLocationsCollectionRequestBuilder {
	bb := &GraphServiceAllowedDataLocationsCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/allowedDataLocations"
	return bb
}

// GraphServiceAllowedDataLocationsCollectionRequestBuilder is request builder for AllowedDataLocation collection
type GraphServiceAllowedDataLocationsCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for AllowedDataLocation collection
func (b *GraphServiceAllowedDataLocationsCollectionRequestBuilder) Request() *GraphServiceAllowedDataLocationsCollectionRequest {
	return &GraphServiceAllowedDataLocationsCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for AllowedDataLocation item
func (b *GraphServiceAllowedDataLocationsCollectionRequestBuilder) ID(id string) *AllowedDataLocationRequestBuilder {
	bb := &AllowedDataLocationRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// GraphServiceAllowedDataLocationsCollectionRequest is request for AllowedDataLocation collection
type GraphServiceAllowedDataLocationsCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for AllowedDataLocation collection
func (r *GraphServiceAllowedDataLocationsCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]AllowedDataLocation, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []AllowedDataLocation
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []AllowedDataLocation
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for AllowedDataLocation collection, max N pages
func (r *GraphServiceAllowedDataLocationsCollectionRequest) GetN(ctx context.Context, n int) ([]AllowedDataLocation, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for AllowedDataLocation collection
func (r *GraphServiceAllowedDataLocationsCollectionRequest) Get(ctx context.Context) ([]AllowedDataLocation, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for AllowedDataLocation collection
func (r *GraphServiceAllowedDataLocationsCollectionRequest) Add(ctx context.Context, reqObj *AllowedDataLocation) (resObj *AllowedDataLocation, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// AnonymousIPRiskEvents returns request builder for AnonymousIPRiskEvent collection
func (b *GraphServiceRequestBuilder) AnonymousIPRiskEvents() *GraphServiceAnonymousIPRiskEventsCollectionRequestBuilder {
	bb := &GraphServiceAnonymousIPRiskEventsCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/anonymousIpRiskEvents"
	return bb
}

// GraphServiceAnonymousIPRiskEventsCollectionRequestBuilder is request builder for AnonymousIPRiskEvent collection
type GraphServiceAnonymousIPRiskEventsCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for AnonymousIPRiskEvent collection
func (b *GraphServiceAnonymousIPRiskEventsCollectionRequestBuilder) Request() *GraphServiceAnonymousIPRiskEventsCollectionRequest {
	return &GraphServiceAnonymousIPRiskEventsCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for AnonymousIPRiskEvent item
func (b *GraphServiceAnonymousIPRiskEventsCollectionRequestBuilder) ID(id string) *AnonymousIPRiskEventRequestBuilder {
	bb := &AnonymousIPRiskEventRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// GraphServiceAnonymousIPRiskEventsCollectionRequest is request for AnonymousIPRiskEvent collection
type GraphServiceAnonymousIPRiskEventsCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for AnonymousIPRiskEvent collection
func (r *GraphServiceAnonymousIPRiskEventsCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]AnonymousIPRiskEvent, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []AnonymousIPRiskEvent
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []AnonymousIPRiskEvent
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for AnonymousIPRiskEvent collection, max N pages
func (r *GraphServiceAnonymousIPRiskEventsCollectionRequest) GetN(ctx context.Context, n int) ([]AnonymousIPRiskEvent, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for AnonymousIPRiskEvent collection
func (r *GraphServiceAnonymousIPRiskEventsCollectionRequest) Get(ctx context.Context) ([]AnonymousIPRiskEvent, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for AnonymousIPRiskEvent collection
func (r *GraphServiceAnonymousIPRiskEventsCollectionRequest) Add(ctx context.Context, reqObj *AnonymousIPRiskEvent) (resObj *AnonymousIPRiskEvent, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// AppRoleAssignments returns request builder for AppRoleAssignment collection
func (b *GraphServiceRequestBuilder) AppRoleAssignments() *GraphServiceAppRoleAssignmentsCollectionRequestBuilder {
	bb := &GraphServiceAppRoleAssignmentsCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/appRoleAssignments"
	return bb
}

// GraphServiceAppRoleAssignmentsCollectionRequestBuilder is request builder for AppRoleAssignment collection
type GraphServiceAppRoleAssignmentsCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for AppRoleAssignment collection
func (b *GraphServiceAppRoleAssignmentsCollectionRequestBuilder) Request() *GraphServiceAppRoleAssignmentsCollectionRequest {
	return &GraphServiceAppRoleAssignmentsCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for AppRoleAssignment item
func (b *GraphServiceAppRoleAssignmentsCollectionRequestBuilder) ID(id string) *AppRoleAssignmentRequestBuilder {
	bb := &AppRoleAssignmentRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// GraphServiceAppRoleAssignmentsCollectionRequest is request for AppRoleAssignment collection
type GraphServiceAppRoleAssignmentsCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for AppRoleAssignment collection
func (r *GraphServiceAppRoleAssignmentsCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]AppRoleAssignment, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []AppRoleAssignment
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []AppRoleAssignment
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for AppRoleAssignment collection, max N pages
func (r *GraphServiceAppRoleAssignmentsCollectionRequest) GetN(ctx context.Context, n int) ([]AppRoleAssignment, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for AppRoleAssignment collection
func (r *GraphServiceAppRoleAssignmentsCollectionRequest) Get(ctx context.Context) ([]AppRoleAssignment, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for AppRoleAssignment collection
func (r *GraphServiceAppRoleAssignmentsCollectionRequest) Add(ctx context.Context, reqObj *AppRoleAssignment) (resObj *AppRoleAssignment, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// ApplicationTemplates returns request builder for ApplicationTemplate collection
func (b *GraphServiceRequestBuilder) ApplicationTemplates() *GraphServiceApplicationTemplatesCollectionRequestBuilder {
	bb := &GraphServiceApplicationTemplatesCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/applicationTemplates"
	return bb
}

// GraphServiceApplicationTemplatesCollectionRequestBuilder is request builder for ApplicationTemplate collection
type GraphServiceApplicationTemplatesCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for ApplicationTemplate collection
func (b *GraphServiceApplicationTemplatesCollectionRequestBuilder) Request() *GraphServiceApplicationTemplatesCollectionRequest {
	return &GraphServiceApplicationTemplatesCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for ApplicationTemplate item
func (b *GraphServiceApplicationTemplatesCollectionRequestBuilder) ID(id string) *ApplicationTemplateRequestBuilder {
	bb := &ApplicationTemplateRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// GraphServiceApplicationTemplatesCollectionRequest is request for ApplicationTemplate collection
type GraphServiceApplicationTemplatesCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for ApplicationTemplate collection
func (r *GraphServiceApplicationTemplatesCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]ApplicationTemplate, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []ApplicationTemplate
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []ApplicationTemplate
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for ApplicationTemplate collection, max N pages
func (r *GraphServiceApplicationTemplatesCollectionRequest) GetN(ctx context.Context, n int) ([]ApplicationTemplate, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for ApplicationTemplate collection
func (r *GraphServiceApplicationTemplatesCollectionRequest) Get(ctx context.Context) ([]ApplicationTemplate, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for ApplicationTemplate collection
func (r *GraphServiceApplicationTemplatesCollectionRequest) Add(ctx context.Context, reqObj *ApplicationTemplate) (resObj *ApplicationTemplate, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// Applications returns request builder for Application collection
func (b *GraphServiceRequestBuilder) Applications() *GraphServiceApplicationsCollectionRequestBuilder {
	bb := &GraphServiceApplicationsCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/applications"
	return bb
}

// GraphServiceApplicationsCollectionRequestBuilder is request builder for Application collection
type GraphServiceApplicationsCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for Application collection
func (b *GraphServiceApplicationsCollectionRequestBuilder) Request() *GraphServiceApplicationsCollectionRequest {
	return &GraphServiceApplicationsCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for Application item
func (b *GraphServiceApplicationsCollectionRequestBuilder) ID(id string) *ApplicationRequestBuilder {
	bb := &ApplicationRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// GraphServiceApplicationsCollectionRequest is request for Application collection
type GraphServiceApplicationsCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for Application collection
func (r *GraphServiceApplicationsCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]Application, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []Application
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []Application
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for Application collection, max N pages
func (r *GraphServiceApplicationsCollectionRequest) GetN(ctx context.Context, n int) ([]Application, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for Application collection
func (r *GraphServiceApplicationsCollectionRequest) Get(ctx context.Context) ([]Application, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for Application collection
func (r *GraphServiceApplicationsCollectionRequest) Add(ctx context.Context, reqObj *Application) (resObj *Application, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// ApprovalWorkflowProviders returns request builder for ApprovalWorkflowProvider collection
func (b *GraphServiceRequestBuilder) ApprovalWorkflowProviders() *GraphServiceApprovalWorkflowProvidersCollectionRequestBuilder {
	bb := &GraphServiceApprovalWorkflowProvidersCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/approvalWorkflowProviders"
	return bb
}

// GraphServiceApprovalWorkflowProvidersCollectionRequestBuilder is request builder for ApprovalWorkflowProvider collection
type GraphServiceApprovalWorkflowProvidersCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for ApprovalWorkflowProvider collection
func (b *GraphServiceApprovalWorkflowProvidersCollectionRequestBuilder) Request() *GraphServiceApprovalWorkflowProvidersCollectionRequest {
	return &GraphServiceApprovalWorkflowProvidersCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for ApprovalWorkflowProvider item
func (b *GraphServiceApprovalWorkflowProvidersCollectionRequestBuilder) ID(id string) *ApprovalWorkflowProviderRequestBuilder {
	bb := &ApprovalWorkflowProviderRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// GraphServiceApprovalWorkflowProvidersCollectionRequest is request for ApprovalWorkflowProvider collection
type GraphServiceApprovalWorkflowProvidersCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for ApprovalWorkflowProvider collection
func (r *GraphServiceApprovalWorkflowProvidersCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]ApprovalWorkflowProvider, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []ApprovalWorkflowProvider
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []ApprovalWorkflowProvider
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for ApprovalWorkflowProvider collection, max N pages
func (r *GraphServiceApprovalWorkflowProvidersCollectionRequest) GetN(ctx context.Context, n int) ([]ApprovalWorkflowProvider, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for ApprovalWorkflowProvider collection
func (r *GraphServiceApprovalWorkflowProvidersCollectionRequest) Get(ctx context.Context) ([]ApprovalWorkflowProvider, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for ApprovalWorkflowProvider collection
func (r *GraphServiceApprovalWorkflowProvidersCollectionRequest) Add(ctx context.Context, reqObj *ApprovalWorkflowProvider) (resObj *ApprovalWorkflowProvider, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// BookingBusinesses returns request builder for BookingBusiness collection
func (b *GraphServiceRequestBuilder) BookingBusinesses() *GraphServiceBookingBusinessesCollectionRequestBuilder {
	bb := &GraphServiceBookingBusinessesCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/bookingBusinesses"
	return bb
}

// GraphServiceBookingBusinessesCollectionRequestBuilder is request builder for BookingBusiness collection
type GraphServiceBookingBusinessesCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for BookingBusiness collection
func (b *GraphServiceBookingBusinessesCollectionRequestBuilder) Request() *GraphServiceBookingBusinessesCollectionRequest {
	return &GraphServiceBookingBusinessesCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for BookingBusiness item
func (b *GraphServiceBookingBusinessesCollectionRequestBuilder) ID(id string) *BookingBusinessRequestBuilder {
	bb := &BookingBusinessRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// GraphServiceBookingBusinessesCollectionRequest is request for BookingBusiness collection
type GraphServiceBookingBusinessesCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for BookingBusiness collection
func (r *GraphServiceBookingBusinessesCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]BookingBusiness, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []BookingBusiness
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []BookingBusiness
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for BookingBusiness collection, max N pages
func (r *GraphServiceBookingBusinessesCollectionRequest) GetN(ctx context.Context, n int) ([]BookingBusiness, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for BookingBusiness collection
func (r *GraphServiceBookingBusinessesCollectionRequest) Get(ctx context.Context) ([]BookingBusiness, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for BookingBusiness collection
func (r *GraphServiceBookingBusinessesCollectionRequest) Add(ctx context.Context, reqObj *BookingBusiness) (resObj *BookingBusiness, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// BookingCurrencies returns request builder for BookingCurrency collection
func (b *GraphServiceRequestBuilder) BookingCurrencies() *GraphServiceBookingCurrenciesCollectionRequestBuilder {
	bb := &GraphServiceBookingCurrenciesCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/bookingCurrencies"
	return bb
}

// GraphServiceBookingCurrenciesCollectionRequestBuilder is request builder for BookingCurrency collection
type GraphServiceBookingCurrenciesCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for BookingCurrency collection
func (b *GraphServiceBookingCurrenciesCollectionRequestBuilder) Request() *GraphServiceBookingCurrenciesCollectionRequest {
	return &GraphServiceBookingCurrenciesCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for BookingCurrency item
func (b *GraphServiceBookingCurrenciesCollectionRequestBuilder) ID(id string) *BookingCurrencyRequestBuilder {
	bb := &BookingCurrencyRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// GraphServiceBookingCurrenciesCollectionRequest is request for BookingCurrency collection
type GraphServiceBookingCurrenciesCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for BookingCurrency collection
func (r *GraphServiceBookingCurrenciesCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]BookingCurrency, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []BookingCurrency
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []BookingCurrency
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for BookingCurrency collection, max N pages
func (r *GraphServiceBookingCurrenciesCollectionRequest) GetN(ctx context.Context, n int) ([]BookingCurrency, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for BookingCurrency collection
func (r *GraphServiceBookingCurrenciesCollectionRequest) Get(ctx context.Context) ([]BookingCurrency, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for BookingCurrency collection
func (r *GraphServiceBookingCurrenciesCollectionRequest) Add(ctx context.Context, reqObj *BookingCurrency) (resObj *BookingCurrency, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// BusinessFlowTemplates returns request builder for BusinessFlowTemplate collection
func (b *GraphServiceRequestBuilder) BusinessFlowTemplates() *GraphServiceBusinessFlowTemplatesCollectionRequestBuilder {
	bb := &GraphServiceBusinessFlowTemplatesCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/businessFlowTemplates"
	return bb
}

// GraphServiceBusinessFlowTemplatesCollectionRequestBuilder is request builder for BusinessFlowTemplate collection
type GraphServiceBusinessFlowTemplatesCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for BusinessFlowTemplate collection
func (b *GraphServiceBusinessFlowTemplatesCollectionRequestBuilder) Request() *GraphServiceBusinessFlowTemplatesCollectionRequest {
	return &GraphServiceBusinessFlowTemplatesCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for BusinessFlowTemplate item
func (b *GraphServiceBusinessFlowTemplatesCollectionRequestBuilder) ID(id string) *BusinessFlowTemplateRequestBuilder {
	bb := &BusinessFlowTemplateRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// GraphServiceBusinessFlowTemplatesCollectionRequest is request for BusinessFlowTemplate collection
type GraphServiceBusinessFlowTemplatesCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for BusinessFlowTemplate collection
func (r *GraphServiceBusinessFlowTemplatesCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]BusinessFlowTemplate, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []BusinessFlowTemplate
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []BusinessFlowTemplate
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for BusinessFlowTemplate collection, max N pages
func (r *GraphServiceBusinessFlowTemplatesCollectionRequest) GetN(ctx context.Context, n int) ([]BusinessFlowTemplate, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for BusinessFlowTemplate collection
func (r *GraphServiceBusinessFlowTemplatesCollectionRequest) Get(ctx context.Context) ([]BusinessFlowTemplate, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for BusinessFlowTemplate collection
func (r *GraphServiceBusinessFlowTemplatesCollectionRequest) Add(ctx context.Context, reqObj *BusinessFlowTemplate) (resObj *BusinessFlowTemplate, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// CertificateBasedAuthConfiguration returns request builder for CertificateBasedAuthConfiguration collection
func (b *GraphServiceRequestBuilder) CertificateBasedAuthConfiguration() *GraphServiceCertificateBasedAuthConfigurationCollectionRequestBuilder {
	bb := &GraphServiceCertificateBasedAuthConfigurationCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/certificateBasedAuthConfiguration"
	return bb
}

// GraphServiceCertificateBasedAuthConfigurationCollectionRequestBuilder is request builder for CertificateBasedAuthConfiguration collection
type GraphServiceCertificateBasedAuthConfigurationCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for CertificateBasedAuthConfiguration collection
func (b *GraphServiceCertificateBasedAuthConfigurationCollectionRequestBuilder) Request() *GraphServiceCertificateBasedAuthConfigurationCollectionRequest {
	return &GraphServiceCertificateBasedAuthConfigurationCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for CertificateBasedAuthConfiguration item
func (b *GraphServiceCertificateBasedAuthConfigurationCollectionRequestBuilder) ID(id string) *CertificateBasedAuthConfigurationRequestBuilder {
	bb := &CertificateBasedAuthConfigurationRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// GraphServiceCertificateBasedAuthConfigurationCollectionRequest is request for CertificateBasedAuthConfiguration collection
type GraphServiceCertificateBasedAuthConfigurationCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for CertificateBasedAuthConfiguration collection
func (r *GraphServiceCertificateBasedAuthConfigurationCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]CertificateBasedAuthConfiguration, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []CertificateBasedAuthConfiguration
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []CertificateBasedAuthConfiguration
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for CertificateBasedAuthConfiguration collection, max N pages
func (r *GraphServiceCertificateBasedAuthConfigurationCollectionRequest) GetN(ctx context.Context, n int) ([]CertificateBasedAuthConfiguration, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for CertificateBasedAuthConfiguration collection
func (r *GraphServiceCertificateBasedAuthConfigurationCollectionRequest) Get(ctx context.Context) ([]CertificateBasedAuthConfiguration, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for CertificateBasedAuthConfiguration collection
func (r *GraphServiceCertificateBasedAuthConfigurationCollectionRequest) Add(ctx context.Context, reqObj *CertificateBasedAuthConfiguration) (resObj *CertificateBasedAuthConfiguration, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// Chats returns request builder for Chat collection
func (b *GraphServiceRequestBuilder) Chats() *GraphServiceChatsCollectionRequestBuilder {
	bb := &GraphServiceChatsCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/chats"
	return bb
}

// GraphServiceChatsCollectionRequestBuilder is request builder for Chat collection
type GraphServiceChatsCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for Chat collection
func (b *GraphServiceChatsCollectionRequestBuilder) Request() *GraphServiceChatsCollectionRequest {
	return &GraphServiceChatsCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for Chat item
func (b *GraphServiceChatsCollectionRequestBuilder) ID(id string) *ChatRequestBuilder {
	bb := &ChatRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// GraphServiceChatsCollectionRequest is request for Chat collection
type GraphServiceChatsCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for Chat collection
func (r *GraphServiceChatsCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]Chat, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []Chat
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []Chat
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for Chat collection, max N pages
func (r *GraphServiceChatsCollectionRequest) GetN(ctx context.Context, n int) ([]Chat, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for Chat collection
func (r *GraphServiceChatsCollectionRequest) Get(ctx context.Context) ([]Chat, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for Chat collection
func (r *GraphServiceChatsCollectionRequest) Add(ctx context.Context, reqObj *Chat) (resObj *Chat, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// Commands returns request builder for Command collection
func (b *GraphServiceRequestBuilder) Commands() *GraphServiceCommandsCollectionRequestBuilder {
	bb := &GraphServiceCommandsCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/commands"
	return bb
}

// GraphServiceCommandsCollectionRequestBuilder is request builder for Command collection
type GraphServiceCommandsCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for Command collection
func (b *GraphServiceCommandsCollectionRequestBuilder) Request() *GraphServiceCommandsCollectionRequest {
	return &GraphServiceCommandsCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for Command item
func (b *GraphServiceCommandsCollectionRequestBuilder) ID(id string) *CommandRequestBuilder {
	bb := &CommandRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// GraphServiceCommandsCollectionRequest is request for Command collection
type GraphServiceCommandsCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for Command collection
func (r *GraphServiceCommandsCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]Command, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []Command
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []Command
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for Command collection, max N pages
func (r *GraphServiceCommandsCollectionRequest) GetN(ctx context.Context, n int) ([]Command, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for Command collection
func (r *GraphServiceCommandsCollectionRequest) Get(ctx context.Context) ([]Command, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for Command collection
func (r *GraphServiceCommandsCollectionRequest) Add(ctx context.Context, reqObj *Command) (resObj *Command, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// Connections returns request builder for ExternalConnection collection
func (b *GraphServiceRequestBuilder) Connections() *GraphServiceConnectionsCollectionRequestBuilder {
	bb := &GraphServiceConnectionsCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/connections"
	return bb
}

// GraphServiceConnectionsCollectionRequestBuilder is request builder for ExternalConnection collection
type GraphServiceConnectionsCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for ExternalConnection collection
func (b *GraphServiceConnectionsCollectionRequestBuilder) Request() *GraphServiceConnectionsCollectionRequest {
	return &GraphServiceConnectionsCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for ExternalConnection item
func (b *GraphServiceConnectionsCollectionRequestBuilder) ID(id string) *ExternalConnectionRequestBuilder {
	bb := &ExternalConnectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// GraphServiceConnectionsCollectionRequest is request for ExternalConnection collection
type GraphServiceConnectionsCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for ExternalConnection collection
func (r *GraphServiceConnectionsCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]ExternalConnection, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []ExternalConnection
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []ExternalConnection
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for ExternalConnection collection, max N pages
func (r *GraphServiceConnectionsCollectionRequest) GetN(ctx context.Context, n int) ([]ExternalConnection, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for ExternalConnection collection
func (r *GraphServiceConnectionsCollectionRequest) Get(ctx context.Context) ([]ExternalConnection, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for ExternalConnection collection
func (r *GraphServiceConnectionsCollectionRequest) Add(ctx context.Context, reqObj *ExternalConnection) (resObj *ExternalConnection, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// Contacts returns request builder for OrgContact collection
func (b *GraphServiceRequestBuilder) Contacts() *GraphServiceContactsCollectionRequestBuilder {
	bb := &GraphServiceContactsCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/contacts"
	return bb
}

// GraphServiceContactsCollectionRequestBuilder is request builder for OrgContact collection
type GraphServiceContactsCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for OrgContact collection
func (b *GraphServiceContactsCollectionRequestBuilder) Request() *GraphServiceContactsCollectionRequest {
	return &GraphServiceContactsCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for OrgContact item
func (b *GraphServiceContactsCollectionRequestBuilder) ID(id string) *OrgContactRequestBuilder {
	bb := &OrgContactRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// GraphServiceContactsCollectionRequest is request for OrgContact collection
type GraphServiceContactsCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for OrgContact collection
func (r *GraphServiceContactsCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]OrgContact, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []OrgContact
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []OrgContact
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for OrgContact collection, max N pages
func (r *GraphServiceContactsCollectionRequest) GetN(ctx context.Context, n int) ([]OrgContact, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for OrgContact collection
func (r *GraphServiceContactsCollectionRequest) Get(ctx context.Context) ([]OrgContact, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for OrgContact collection
func (r *GraphServiceContactsCollectionRequest) Add(ctx context.Context, reqObj *OrgContact) (resObj *OrgContact, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// Contracts returns request builder for Contract collection
func (b *GraphServiceRequestBuilder) Contracts() *GraphServiceContractsCollectionRequestBuilder {
	bb := &GraphServiceContractsCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/contracts"
	return bb
}

// GraphServiceContractsCollectionRequestBuilder is request builder for Contract collection
type GraphServiceContractsCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for Contract collection
func (b *GraphServiceContractsCollectionRequestBuilder) Request() *GraphServiceContractsCollectionRequest {
	return &GraphServiceContractsCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for Contract item
func (b *GraphServiceContractsCollectionRequestBuilder) ID(id string) *ContractRequestBuilder {
	bb := &ContractRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// GraphServiceContractsCollectionRequest is request for Contract collection
type GraphServiceContractsCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for Contract collection
func (r *GraphServiceContractsCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]Contract, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []Contract
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []Contract
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for Contract collection, max N pages
func (r *GraphServiceContractsCollectionRequest) GetN(ctx context.Context, n int) ([]Contract, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for Contract collection
func (r *GraphServiceContractsCollectionRequest) Get(ctx context.Context) ([]Contract, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for Contract collection
func (r *GraphServiceContractsCollectionRequest) Add(ctx context.Context, reqObj *Contract) (resObj *Contract, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// DataPolicyOperations returns request builder for DataPolicyOperation collection
func (b *GraphServiceRequestBuilder) DataPolicyOperations() *GraphServiceDataPolicyOperationsCollectionRequestBuilder {
	bb := &GraphServiceDataPolicyOperationsCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/dataPolicyOperations"
	return bb
}

// GraphServiceDataPolicyOperationsCollectionRequestBuilder is request builder for DataPolicyOperation collection
type GraphServiceDataPolicyOperationsCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for DataPolicyOperation collection
func (b *GraphServiceDataPolicyOperationsCollectionRequestBuilder) Request() *GraphServiceDataPolicyOperationsCollectionRequest {
	return &GraphServiceDataPolicyOperationsCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for DataPolicyOperation item
func (b *GraphServiceDataPolicyOperationsCollectionRequestBuilder) ID(id string) *DataPolicyOperationRequestBuilder {
	bb := &DataPolicyOperationRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// GraphServiceDataPolicyOperationsCollectionRequest is request for DataPolicyOperation collection
type GraphServiceDataPolicyOperationsCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for DataPolicyOperation collection
func (r *GraphServiceDataPolicyOperationsCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]DataPolicyOperation, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []DataPolicyOperation
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []DataPolicyOperation
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for DataPolicyOperation collection, max N pages
func (r *GraphServiceDataPolicyOperationsCollectionRequest) GetN(ctx context.Context, n int) ([]DataPolicyOperation, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for DataPolicyOperation collection
func (r *GraphServiceDataPolicyOperationsCollectionRequest) Get(ctx context.Context) ([]DataPolicyOperation, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for DataPolicyOperation collection
func (r *GraphServiceDataPolicyOperationsCollectionRequest) Add(ctx context.Context, reqObj *DataPolicyOperation) (resObj *DataPolicyOperation, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// Devices returns request builder for Device collection
func (b *GraphServiceRequestBuilder) Devices() *GraphServiceDevicesCollectionRequestBuilder {
	bb := &GraphServiceDevicesCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/devices"
	return bb
}

// GraphServiceDevicesCollectionRequestBuilder is request builder for Device collection
type GraphServiceDevicesCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for Device collection
func (b *GraphServiceDevicesCollectionRequestBuilder) Request() *GraphServiceDevicesCollectionRequest {
	return &GraphServiceDevicesCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for Device item
func (b *GraphServiceDevicesCollectionRequestBuilder) ID(id string) *DeviceRequestBuilder {
	bb := &DeviceRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// GraphServiceDevicesCollectionRequest is request for Device collection
type GraphServiceDevicesCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for Device collection
func (r *GraphServiceDevicesCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]Device, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []Device
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []Device
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for Device collection, max N pages
func (r *GraphServiceDevicesCollectionRequest) GetN(ctx context.Context, n int) ([]Device, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for Device collection
func (r *GraphServiceDevicesCollectionRequest) Get(ctx context.Context) ([]Device, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for Device collection
func (r *GraphServiceDevicesCollectionRequest) Add(ctx context.Context, reqObj *Device) (resObj *Device, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// Directories returns request builder for DirectoryDefinition collection
func (b *GraphServiceRequestBuilder) Directories() *GraphServiceDirectoriesCollectionRequestBuilder {
	bb := &GraphServiceDirectoriesCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/directories"
	return bb
}

// GraphServiceDirectoriesCollectionRequestBuilder is request builder for DirectoryDefinition collection
type GraphServiceDirectoriesCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for DirectoryDefinition collection
func (b *GraphServiceDirectoriesCollectionRequestBuilder) Request() *GraphServiceDirectoriesCollectionRequest {
	return &GraphServiceDirectoriesCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for DirectoryDefinition item
func (b *GraphServiceDirectoriesCollectionRequestBuilder) ID(id string) *DirectoryDefinitionRequestBuilder {
	bb := &DirectoryDefinitionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// GraphServiceDirectoriesCollectionRequest is request for DirectoryDefinition collection
type GraphServiceDirectoriesCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for DirectoryDefinition collection
func (r *GraphServiceDirectoriesCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]DirectoryDefinition, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []DirectoryDefinition
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []DirectoryDefinition
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for DirectoryDefinition collection, max N pages
func (r *GraphServiceDirectoriesCollectionRequest) GetN(ctx context.Context, n int) ([]DirectoryDefinition, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for DirectoryDefinition collection
func (r *GraphServiceDirectoriesCollectionRequest) Get(ctx context.Context) ([]DirectoryDefinition, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for DirectoryDefinition collection
func (r *GraphServiceDirectoriesCollectionRequest) Add(ctx context.Context, reqObj *DirectoryDefinition) (resObj *DirectoryDefinition, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// DirectoryObjects returns request builder for DirectoryObject collection
func (b *GraphServiceRequestBuilder) DirectoryObjects() *GraphServiceDirectoryObjectsCollectionRequestBuilder {
	bb := &GraphServiceDirectoryObjectsCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/directoryObjects"
	return bb
}

// GraphServiceDirectoryObjectsCollectionRequestBuilder is request builder for DirectoryObject collection
type GraphServiceDirectoryObjectsCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for DirectoryObject collection
func (b *GraphServiceDirectoryObjectsCollectionRequestBuilder) Request() *GraphServiceDirectoryObjectsCollectionRequest {
	return &GraphServiceDirectoryObjectsCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for DirectoryObject item
func (b *GraphServiceDirectoryObjectsCollectionRequestBuilder) ID(id string) *DirectoryObjectRequestBuilder {
	bb := &DirectoryObjectRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// GraphServiceDirectoryObjectsCollectionRequest is request for DirectoryObject collection
type GraphServiceDirectoryObjectsCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for DirectoryObject collection
func (r *GraphServiceDirectoryObjectsCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]DirectoryObject, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []DirectoryObject
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []DirectoryObject
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for DirectoryObject collection, max N pages
func (r *GraphServiceDirectoryObjectsCollectionRequest) GetN(ctx context.Context, n int) ([]DirectoryObject, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for DirectoryObject collection
func (r *GraphServiceDirectoryObjectsCollectionRequest) Get(ctx context.Context) ([]DirectoryObject, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for DirectoryObject collection
func (r *GraphServiceDirectoryObjectsCollectionRequest) Add(ctx context.Context, reqObj *DirectoryObject) (resObj *DirectoryObject, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// DirectoryRoleTemplates returns request builder for DirectoryRoleTemplate collection
func (b *GraphServiceRequestBuilder) DirectoryRoleTemplates() *GraphServiceDirectoryRoleTemplatesCollectionRequestBuilder {
	bb := &GraphServiceDirectoryRoleTemplatesCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/directoryRoleTemplates"
	return bb
}

// GraphServiceDirectoryRoleTemplatesCollectionRequestBuilder is request builder for DirectoryRoleTemplate collection
type GraphServiceDirectoryRoleTemplatesCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for DirectoryRoleTemplate collection
func (b *GraphServiceDirectoryRoleTemplatesCollectionRequestBuilder) Request() *GraphServiceDirectoryRoleTemplatesCollectionRequest {
	return &GraphServiceDirectoryRoleTemplatesCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for DirectoryRoleTemplate item
func (b *GraphServiceDirectoryRoleTemplatesCollectionRequestBuilder) ID(id string) *DirectoryRoleTemplateRequestBuilder {
	bb := &DirectoryRoleTemplateRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// GraphServiceDirectoryRoleTemplatesCollectionRequest is request for DirectoryRoleTemplate collection
type GraphServiceDirectoryRoleTemplatesCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for DirectoryRoleTemplate collection
func (r *GraphServiceDirectoryRoleTemplatesCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]DirectoryRoleTemplate, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []DirectoryRoleTemplate
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []DirectoryRoleTemplate
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for DirectoryRoleTemplate collection, max N pages
func (r *GraphServiceDirectoryRoleTemplatesCollectionRequest) GetN(ctx context.Context, n int) ([]DirectoryRoleTemplate, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for DirectoryRoleTemplate collection
func (r *GraphServiceDirectoryRoleTemplatesCollectionRequest) Get(ctx context.Context) ([]DirectoryRoleTemplate, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for DirectoryRoleTemplate collection
func (r *GraphServiceDirectoryRoleTemplatesCollectionRequest) Add(ctx context.Context, reqObj *DirectoryRoleTemplate) (resObj *DirectoryRoleTemplate, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// DirectoryRoles returns request builder for DirectoryRole collection
func (b *GraphServiceRequestBuilder) DirectoryRoles() *GraphServiceDirectoryRolesCollectionRequestBuilder {
	bb := &GraphServiceDirectoryRolesCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/directoryRoles"
	return bb
}

// GraphServiceDirectoryRolesCollectionRequestBuilder is request builder for DirectoryRole collection
type GraphServiceDirectoryRolesCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for DirectoryRole collection
func (b *GraphServiceDirectoryRolesCollectionRequestBuilder) Request() *GraphServiceDirectoryRolesCollectionRequest {
	return &GraphServiceDirectoryRolesCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for DirectoryRole item
func (b *GraphServiceDirectoryRolesCollectionRequestBuilder) ID(id string) *DirectoryRoleRequestBuilder {
	bb := &DirectoryRoleRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// GraphServiceDirectoryRolesCollectionRequest is request for DirectoryRole collection
type GraphServiceDirectoryRolesCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for DirectoryRole collection
func (r *GraphServiceDirectoryRolesCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]DirectoryRole, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []DirectoryRole
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []DirectoryRole
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for DirectoryRole collection, max N pages
func (r *GraphServiceDirectoryRolesCollectionRequest) GetN(ctx context.Context, n int) ([]DirectoryRole, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for DirectoryRole collection
func (r *GraphServiceDirectoryRolesCollectionRequest) Get(ctx context.Context) ([]DirectoryRole, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for DirectoryRole collection
func (r *GraphServiceDirectoryRolesCollectionRequest) Add(ctx context.Context, reqObj *DirectoryRole) (resObj *DirectoryRole, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// DirectorySettingTemplates returns request builder for DirectorySettingTemplate collection
func (b *GraphServiceRequestBuilder) DirectorySettingTemplates() *GraphServiceDirectorySettingTemplatesCollectionRequestBuilder {
	bb := &GraphServiceDirectorySettingTemplatesCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/directorySettingTemplates"
	return bb
}

// GraphServiceDirectorySettingTemplatesCollectionRequestBuilder is request builder for DirectorySettingTemplate collection
type GraphServiceDirectorySettingTemplatesCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for DirectorySettingTemplate collection
func (b *GraphServiceDirectorySettingTemplatesCollectionRequestBuilder) Request() *GraphServiceDirectorySettingTemplatesCollectionRequest {
	return &GraphServiceDirectorySettingTemplatesCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for DirectorySettingTemplate item
func (b *GraphServiceDirectorySettingTemplatesCollectionRequestBuilder) ID(id string) *DirectorySettingTemplateRequestBuilder {
	bb := &DirectorySettingTemplateRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// GraphServiceDirectorySettingTemplatesCollectionRequest is request for DirectorySettingTemplate collection
type GraphServiceDirectorySettingTemplatesCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for DirectorySettingTemplate collection
func (r *GraphServiceDirectorySettingTemplatesCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]DirectorySettingTemplate, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []DirectorySettingTemplate
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []DirectorySettingTemplate
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for DirectorySettingTemplate collection, max N pages
func (r *GraphServiceDirectorySettingTemplatesCollectionRequest) GetN(ctx context.Context, n int) ([]DirectorySettingTemplate, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for DirectorySettingTemplate collection
func (r *GraphServiceDirectorySettingTemplatesCollectionRequest) Get(ctx context.Context) ([]DirectorySettingTemplate, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for DirectorySettingTemplate collection
func (r *GraphServiceDirectorySettingTemplatesCollectionRequest) Add(ctx context.Context, reqObj *DirectorySettingTemplate) (resObj *DirectorySettingTemplate, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// DomainDNSRecords returns request builder for DomainDNSRecord collection
func (b *GraphServiceRequestBuilder) DomainDNSRecords() *GraphServiceDomainDNSRecordsCollectionRequestBuilder {
	bb := &GraphServiceDomainDNSRecordsCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/domainDnsRecords"
	return bb
}

// GraphServiceDomainDNSRecordsCollectionRequestBuilder is request builder for DomainDNSRecord collection
type GraphServiceDomainDNSRecordsCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for DomainDNSRecord collection
func (b *GraphServiceDomainDNSRecordsCollectionRequestBuilder) Request() *GraphServiceDomainDNSRecordsCollectionRequest {
	return &GraphServiceDomainDNSRecordsCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for DomainDNSRecord item
func (b *GraphServiceDomainDNSRecordsCollectionRequestBuilder) ID(id string) *DomainDNSRecordRequestBuilder {
	bb := &DomainDNSRecordRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// GraphServiceDomainDNSRecordsCollectionRequest is request for DomainDNSRecord collection
type GraphServiceDomainDNSRecordsCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for DomainDNSRecord collection
func (r *GraphServiceDomainDNSRecordsCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]DomainDNSRecord, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []DomainDNSRecord
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []DomainDNSRecord
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for DomainDNSRecord collection, max N pages
func (r *GraphServiceDomainDNSRecordsCollectionRequest) GetN(ctx context.Context, n int) ([]DomainDNSRecord, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for DomainDNSRecord collection
func (r *GraphServiceDomainDNSRecordsCollectionRequest) Get(ctx context.Context) ([]DomainDNSRecord, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for DomainDNSRecord collection
func (r *GraphServiceDomainDNSRecordsCollectionRequest) Add(ctx context.Context, reqObj *DomainDNSRecord) (resObj *DomainDNSRecord, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// Domains returns request builder for Domain collection
func (b *GraphServiceRequestBuilder) Domains() *GraphServiceDomainsCollectionRequestBuilder {
	bb := &GraphServiceDomainsCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/domains"
	return bb
}

// GraphServiceDomainsCollectionRequestBuilder is request builder for Domain collection
type GraphServiceDomainsCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for Domain collection
func (b *GraphServiceDomainsCollectionRequestBuilder) Request() *GraphServiceDomainsCollectionRequest {
	return &GraphServiceDomainsCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for Domain item
func (b *GraphServiceDomainsCollectionRequestBuilder) ID(id string) *DomainRequestBuilder {
	bb := &DomainRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// GraphServiceDomainsCollectionRequest is request for Domain collection
type GraphServiceDomainsCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for Domain collection
func (r *GraphServiceDomainsCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]Domain, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []Domain
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []Domain
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for Domain collection, max N pages
func (r *GraphServiceDomainsCollectionRequest) GetN(ctx context.Context, n int) ([]Domain, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for Domain collection
func (r *GraphServiceDomainsCollectionRequest) Get(ctx context.Context) ([]Domain, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for Domain collection
func (r *GraphServiceDomainsCollectionRequest) Add(ctx context.Context, reqObj *Domain) (resObj *Domain, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// Drives returns request builder for Drive collection
func (b *GraphServiceRequestBuilder) Drives() *GraphServiceDrivesCollectionRequestBuilder {
	bb := &GraphServiceDrivesCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/drives"
	return bb
}

// GraphServiceDrivesCollectionRequestBuilder is request builder for Drive collection
type GraphServiceDrivesCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for Drive collection
func (b *GraphServiceDrivesCollectionRequestBuilder) Request() *GraphServiceDrivesCollectionRequest {
	return &GraphServiceDrivesCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for Drive item
func (b *GraphServiceDrivesCollectionRequestBuilder) ID(id string) *DriveRequestBuilder {
	bb := &DriveRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// GraphServiceDrivesCollectionRequest is request for Drive collection
type GraphServiceDrivesCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for Drive collection
func (r *GraphServiceDrivesCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]Drive, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []Drive
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []Drive
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for Drive collection, max N pages
func (r *GraphServiceDrivesCollectionRequest) GetN(ctx context.Context, n int) ([]Drive, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for Drive collection
func (r *GraphServiceDrivesCollectionRequest) Get(ctx context.Context) ([]Drive, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for Drive collection
func (r *GraphServiceDrivesCollectionRequest) Add(ctx context.Context, reqObj *Drive) (resObj *Drive, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// FilterOperators returns request builder for FilterOperatorSchema collection
func (b *GraphServiceRequestBuilder) FilterOperators() *GraphServiceFilterOperatorsCollectionRequestBuilder {
	bb := &GraphServiceFilterOperatorsCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/filterOperators"
	return bb
}

// GraphServiceFilterOperatorsCollectionRequestBuilder is request builder for FilterOperatorSchema collection
type GraphServiceFilterOperatorsCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for FilterOperatorSchema collection
func (b *GraphServiceFilterOperatorsCollectionRequestBuilder) Request() *GraphServiceFilterOperatorsCollectionRequest {
	return &GraphServiceFilterOperatorsCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for FilterOperatorSchema item
func (b *GraphServiceFilterOperatorsCollectionRequestBuilder) ID(id string) *FilterOperatorSchemaRequestBuilder {
	bb := &FilterOperatorSchemaRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// GraphServiceFilterOperatorsCollectionRequest is request for FilterOperatorSchema collection
type GraphServiceFilterOperatorsCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for FilterOperatorSchema collection
func (r *GraphServiceFilterOperatorsCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]FilterOperatorSchema, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []FilterOperatorSchema
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []FilterOperatorSchema
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for FilterOperatorSchema collection, max N pages
func (r *GraphServiceFilterOperatorsCollectionRequest) GetN(ctx context.Context, n int) ([]FilterOperatorSchema, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for FilterOperatorSchema collection
func (r *GraphServiceFilterOperatorsCollectionRequest) Get(ctx context.Context) ([]FilterOperatorSchema, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for FilterOperatorSchema collection
func (r *GraphServiceFilterOperatorsCollectionRequest) Add(ctx context.Context, reqObj *FilterOperatorSchema) (resObj *FilterOperatorSchema, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// Functions returns request builder for AttributeMappingFunctionSchema collection
func (b *GraphServiceRequestBuilder) Functions() *GraphServiceFunctionsCollectionRequestBuilder {
	bb := &GraphServiceFunctionsCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/functions"
	return bb
}

// GraphServiceFunctionsCollectionRequestBuilder is request builder for AttributeMappingFunctionSchema collection
type GraphServiceFunctionsCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for AttributeMappingFunctionSchema collection
func (b *GraphServiceFunctionsCollectionRequestBuilder) Request() *GraphServiceFunctionsCollectionRequest {
	return &GraphServiceFunctionsCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for AttributeMappingFunctionSchema item
func (b *GraphServiceFunctionsCollectionRequestBuilder) ID(id string) *AttributeMappingFunctionSchemaRequestBuilder {
	bb := &AttributeMappingFunctionSchemaRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// GraphServiceFunctionsCollectionRequest is request for AttributeMappingFunctionSchema collection
type GraphServiceFunctionsCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for AttributeMappingFunctionSchema collection
func (r *GraphServiceFunctionsCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]AttributeMappingFunctionSchema, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []AttributeMappingFunctionSchema
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []AttributeMappingFunctionSchema
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for AttributeMappingFunctionSchema collection, max N pages
func (r *GraphServiceFunctionsCollectionRequest) GetN(ctx context.Context, n int) ([]AttributeMappingFunctionSchema, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for AttributeMappingFunctionSchema collection
func (r *GraphServiceFunctionsCollectionRequest) Get(ctx context.Context) ([]AttributeMappingFunctionSchema, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for AttributeMappingFunctionSchema collection
func (r *GraphServiceFunctionsCollectionRequest) Add(ctx context.Context, reqObj *AttributeMappingFunctionSchema) (resObj *AttributeMappingFunctionSchema, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// GovernanceResources returns request builder for GovernanceResource collection
func (b *GraphServiceRequestBuilder) GovernanceResources() *GraphServiceGovernanceResourcesCollectionRequestBuilder {
	bb := &GraphServiceGovernanceResourcesCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/governanceResources"
	return bb
}

// GraphServiceGovernanceResourcesCollectionRequestBuilder is request builder for GovernanceResource collection
type GraphServiceGovernanceResourcesCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for GovernanceResource collection
func (b *GraphServiceGovernanceResourcesCollectionRequestBuilder) Request() *GraphServiceGovernanceResourcesCollectionRequest {
	return &GraphServiceGovernanceResourcesCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for GovernanceResource item
func (b *GraphServiceGovernanceResourcesCollectionRequestBuilder) ID(id string) *GovernanceResourceRequestBuilder {
	bb := &GovernanceResourceRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// GraphServiceGovernanceResourcesCollectionRequest is request for GovernanceResource collection
type GraphServiceGovernanceResourcesCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for GovernanceResource collection
func (r *GraphServiceGovernanceResourcesCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]GovernanceResource, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []GovernanceResource
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []GovernanceResource
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for GovernanceResource collection, max N pages
func (r *GraphServiceGovernanceResourcesCollectionRequest) GetN(ctx context.Context, n int) ([]GovernanceResource, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for GovernanceResource collection
func (r *GraphServiceGovernanceResourcesCollectionRequest) Get(ctx context.Context) ([]GovernanceResource, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for GovernanceResource collection
func (r *GraphServiceGovernanceResourcesCollectionRequest) Add(ctx context.Context, reqObj *GovernanceResource) (resObj *GovernanceResource, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// GovernanceRoleAssignmentRequests returns request builder for GovernanceRoleAssignmentRequestObject collection
func (b *GraphServiceRequestBuilder) GovernanceRoleAssignmentRequests() *GraphServiceGovernanceRoleAssignmentRequestsCollectionRequestBuilder {
	bb := &GraphServiceGovernanceRoleAssignmentRequestsCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/governanceRoleAssignmentRequests"
	return bb
}

// GraphServiceGovernanceRoleAssignmentRequestsCollectionRequestBuilder is request builder for GovernanceRoleAssignmentRequestObject collection
type GraphServiceGovernanceRoleAssignmentRequestsCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for GovernanceRoleAssignmentRequestObject collection
func (b *GraphServiceGovernanceRoleAssignmentRequestsCollectionRequestBuilder) Request() *GraphServiceGovernanceRoleAssignmentRequestsCollectionRequest {
	return &GraphServiceGovernanceRoleAssignmentRequestsCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for GovernanceRoleAssignmentRequestObject item
func (b *GraphServiceGovernanceRoleAssignmentRequestsCollectionRequestBuilder) ID(id string) *GovernanceRoleAssignmentRequestObjectRequestBuilder {
	bb := &GovernanceRoleAssignmentRequestObjectRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// GraphServiceGovernanceRoleAssignmentRequestsCollectionRequest is request for GovernanceRoleAssignmentRequestObject collection
type GraphServiceGovernanceRoleAssignmentRequestsCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for GovernanceRoleAssignmentRequestObject collection
func (r *GraphServiceGovernanceRoleAssignmentRequestsCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]GovernanceRoleAssignmentRequestObject, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []GovernanceRoleAssignmentRequestObject
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []GovernanceRoleAssignmentRequestObject
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for GovernanceRoleAssignmentRequestObject collection, max N pages
func (r *GraphServiceGovernanceRoleAssignmentRequestsCollectionRequest) GetN(ctx context.Context, n int) ([]GovernanceRoleAssignmentRequestObject, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for GovernanceRoleAssignmentRequestObject collection
func (r *GraphServiceGovernanceRoleAssignmentRequestsCollectionRequest) Get(ctx context.Context) ([]GovernanceRoleAssignmentRequestObject, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for GovernanceRoleAssignmentRequestObject collection
func (r *GraphServiceGovernanceRoleAssignmentRequestsCollectionRequest) Add(ctx context.Context, reqObj *GovernanceRoleAssignmentRequestObject) (resObj *GovernanceRoleAssignmentRequestObject, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// GovernanceRoleAssignments returns request builder for GovernanceRoleAssignment collection
func (b *GraphServiceRequestBuilder) GovernanceRoleAssignments() *GraphServiceGovernanceRoleAssignmentsCollectionRequestBuilder {
	bb := &GraphServiceGovernanceRoleAssignmentsCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/governanceRoleAssignments"
	return bb
}

// GraphServiceGovernanceRoleAssignmentsCollectionRequestBuilder is request builder for GovernanceRoleAssignment collection
type GraphServiceGovernanceRoleAssignmentsCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for GovernanceRoleAssignment collection
func (b *GraphServiceGovernanceRoleAssignmentsCollectionRequestBuilder) Request() *GraphServiceGovernanceRoleAssignmentsCollectionRequest {
	return &GraphServiceGovernanceRoleAssignmentsCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for GovernanceRoleAssignment item
func (b *GraphServiceGovernanceRoleAssignmentsCollectionRequestBuilder) ID(id string) *GovernanceRoleAssignmentRequestBuilder {
	bb := &GovernanceRoleAssignmentRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// GraphServiceGovernanceRoleAssignmentsCollectionRequest is request for GovernanceRoleAssignment collection
type GraphServiceGovernanceRoleAssignmentsCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for GovernanceRoleAssignment collection
func (r *GraphServiceGovernanceRoleAssignmentsCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]GovernanceRoleAssignment, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []GovernanceRoleAssignment
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []GovernanceRoleAssignment
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for GovernanceRoleAssignment collection, max N pages
func (r *GraphServiceGovernanceRoleAssignmentsCollectionRequest) GetN(ctx context.Context, n int) ([]GovernanceRoleAssignment, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for GovernanceRoleAssignment collection
func (r *GraphServiceGovernanceRoleAssignmentsCollectionRequest) Get(ctx context.Context) ([]GovernanceRoleAssignment, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for GovernanceRoleAssignment collection
func (r *GraphServiceGovernanceRoleAssignmentsCollectionRequest) Add(ctx context.Context, reqObj *GovernanceRoleAssignment) (resObj *GovernanceRoleAssignment, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// GovernanceRoleDefinitions returns request builder for GovernanceRoleDefinition collection
func (b *GraphServiceRequestBuilder) GovernanceRoleDefinitions() *GraphServiceGovernanceRoleDefinitionsCollectionRequestBuilder {
	bb := &GraphServiceGovernanceRoleDefinitionsCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/governanceRoleDefinitions"
	return bb
}

// GraphServiceGovernanceRoleDefinitionsCollectionRequestBuilder is request builder for GovernanceRoleDefinition collection
type GraphServiceGovernanceRoleDefinitionsCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for GovernanceRoleDefinition collection
func (b *GraphServiceGovernanceRoleDefinitionsCollectionRequestBuilder) Request() *GraphServiceGovernanceRoleDefinitionsCollectionRequest {
	return &GraphServiceGovernanceRoleDefinitionsCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for GovernanceRoleDefinition item
func (b *GraphServiceGovernanceRoleDefinitionsCollectionRequestBuilder) ID(id string) *GovernanceRoleDefinitionRequestBuilder {
	bb := &GovernanceRoleDefinitionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// GraphServiceGovernanceRoleDefinitionsCollectionRequest is request for GovernanceRoleDefinition collection
type GraphServiceGovernanceRoleDefinitionsCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for GovernanceRoleDefinition collection
func (r *GraphServiceGovernanceRoleDefinitionsCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]GovernanceRoleDefinition, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []GovernanceRoleDefinition
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []GovernanceRoleDefinition
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for GovernanceRoleDefinition collection, max N pages
func (r *GraphServiceGovernanceRoleDefinitionsCollectionRequest) GetN(ctx context.Context, n int) ([]GovernanceRoleDefinition, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for GovernanceRoleDefinition collection
func (r *GraphServiceGovernanceRoleDefinitionsCollectionRequest) Get(ctx context.Context) ([]GovernanceRoleDefinition, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for GovernanceRoleDefinition collection
func (r *GraphServiceGovernanceRoleDefinitionsCollectionRequest) Add(ctx context.Context, reqObj *GovernanceRoleDefinition) (resObj *GovernanceRoleDefinition, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// GovernanceRoleSettings returns request builder for GovernanceRoleSetting collection
func (b *GraphServiceRequestBuilder) GovernanceRoleSettings() *GraphServiceGovernanceRoleSettingsCollectionRequestBuilder {
	bb := &GraphServiceGovernanceRoleSettingsCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/governanceRoleSettings"
	return bb
}

// GraphServiceGovernanceRoleSettingsCollectionRequestBuilder is request builder for GovernanceRoleSetting collection
type GraphServiceGovernanceRoleSettingsCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for GovernanceRoleSetting collection
func (b *GraphServiceGovernanceRoleSettingsCollectionRequestBuilder) Request() *GraphServiceGovernanceRoleSettingsCollectionRequest {
	return &GraphServiceGovernanceRoleSettingsCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for GovernanceRoleSetting item
func (b *GraphServiceGovernanceRoleSettingsCollectionRequestBuilder) ID(id string) *GovernanceRoleSettingRequestBuilder {
	bb := &GovernanceRoleSettingRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// GraphServiceGovernanceRoleSettingsCollectionRequest is request for GovernanceRoleSetting collection
type GraphServiceGovernanceRoleSettingsCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for GovernanceRoleSetting collection
func (r *GraphServiceGovernanceRoleSettingsCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]GovernanceRoleSetting, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []GovernanceRoleSetting
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []GovernanceRoleSetting
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for GovernanceRoleSetting collection, max N pages
func (r *GraphServiceGovernanceRoleSettingsCollectionRequest) GetN(ctx context.Context, n int) ([]GovernanceRoleSetting, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for GovernanceRoleSetting collection
func (r *GraphServiceGovernanceRoleSettingsCollectionRequest) Get(ctx context.Context) ([]GovernanceRoleSetting, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for GovernanceRoleSetting collection
func (r *GraphServiceGovernanceRoleSettingsCollectionRequest) Add(ctx context.Context, reqObj *GovernanceRoleSetting) (resObj *GovernanceRoleSetting, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// GovernanceSubjects returns request builder for GovernanceSubject collection
func (b *GraphServiceRequestBuilder) GovernanceSubjects() *GraphServiceGovernanceSubjectsCollectionRequestBuilder {
	bb := &GraphServiceGovernanceSubjectsCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/governanceSubjects"
	return bb
}

// GraphServiceGovernanceSubjectsCollectionRequestBuilder is request builder for GovernanceSubject collection
type GraphServiceGovernanceSubjectsCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for GovernanceSubject collection
func (b *GraphServiceGovernanceSubjectsCollectionRequestBuilder) Request() *GraphServiceGovernanceSubjectsCollectionRequest {
	return &GraphServiceGovernanceSubjectsCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for GovernanceSubject item
func (b *GraphServiceGovernanceSubjectsCollectionRequestBuilder) ID(id string) *GovernanceSubjectRequestBuilder {
	bb := &GovernanceSubjectRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// GraphServiceGovernanceSubjectsCollectionRequest is request for GovernanceSubject collection
type GraphServiceGovernanceSubjectsCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for GovernanceSubject collection
func (r *GraphServiceGovernanceSubjectsCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]GovernanceSubject, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []GovernanceSubject
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []GovernanceSubject
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for GovernanceSubject collection, max N pages
func (r *GraphServiceGovernanceSubjectsCollectionRequest) GetN(ctx context.Context, n int) ([]GovernanceSubject, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for GovernanceSubject collection
func (r *GraphServiceGovernanceSubjectsCollectionRequest) Get(ctx context.Context) ([]GovernanceSubject, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for GovernanceSubject collection
func (r *GraphServiceGovernanceSubjectsCollectionRequest) Add(ctx context.Context, reqObj *GovernanceSubject) (resObj *GovernanceSubject, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// GroupLifecyclePolicies returns request builder for GroupLifecyclePolicy collection
func (b *GraphServiceRequestBuilder) GroupLifecyclePolicies() *GraphServiceGroupLifecyclePoliciesCollectionRequestBuilder {
	bb := &GraphServiceGroupLifecyclePoliciesCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/groupLifecyclePolicies"
	return bb
}

// GraphServiceGroupLifecyclePoliciesCollectionRequestBuilder is request builder for GroupLifecyclePolicy collection
type GraphServiceGroupLifecyclePoliciesCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for GroupLifecyclePolicy collection
func (b *GraphServiceGroupLifecyclePoliciesCollectionRequestBuilder) Request() *GraphServiceGroupLifecyclePoliciesCollectionRequest {
	return &GraphServiceGroupLifecyclePoliciesCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for GroupLifecyclePolicy item
func (b *GraphServiceGroupLifecyclePoliciesCollectionRequestBuilder) ID(id string) *GroupLifecyclePolicyRequestBuilder {
	bb := &GroupLifecyclePolicyRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// GraphServiceGroupLifecyclePoliciesCollectionRequest is request for GroupLifecyclePolicy collection
type GraphServiceGroupLifecyclePoliciesCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for GroupLifecyclePolicy collection
func (r *GraphServiceGroupLifecyclePoliciesCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]GroupLifecyclePolicy, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []GroupLifecyclePolicy
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []GroupLifecyclePolicy
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for GroupLifecyclePolicy collection, max N pages
func (r *GraphServiceGroupLifecyclePoliciesCollectionRequest) GetN(ctx context.Context, n int) ([]GroupLifecyclePolicy, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for GroupLifecyclePolicy collection
func (r *GraphServiceGroupLifecyclePoliciesCollectionRequest) Get(ctx context.Context) ([]GroupLifecyclePolicy, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for GroupLifecyclePolicy collection
func (r *GraphServiceGroupLifecyclePoliciesCollectionRequest) Add(ctx context.Context, reqObj *GroupLifecyclePolicy) (resObj *GroupLifecyclePolicy, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// Groups returns request builder for Group collection
func (b *GraphServiceRequestBuilder) Groups() *GraphServiceGroupsCollectionRequestBuilder {
	bb := &GraphServiceGroupsCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/groups"
	return bb
}

// GraphServiceGroupsCollectionRequestBuilder is request builder for Group collection
type GraphServiceGroupsCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for Group collection
func (b *GraphServiceGroupsCollectionRequestBuilder) Request() *GraphServiceGroupsCollectionRequest {
	return &GraphServiceGroupsCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for Group item
func (b *GraphServiceGroupsCollectionRequestBuilder) ID(id string) *GroupRequestBuilder {
	bb := &GroupRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// GraphServiceGroupsCollectionRequest is request for Group collection
type GraphServiceGroupsCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for Group collection
func (r *GraphServiceGroupsCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]Group, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []Group
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []Group
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for Group collection, max N pages
func (r *GraphServiceGroupsCollectionRequest) GetN(ctx context.Context, n int) ([]Group, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for Group collection
func (r *GraphServiceGroupsCollectionRequest) Get(ctx context.Context) ([]Group, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for Group collection
func (r *GraphServiceGroupsCollectionRequest) Add(ctx context.Context, reqObj *Group) (resObj *Group, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// IdentityProviders returns request builder for IdentityProvider collection
func (b *GraphServiceRequestBuilder) IdentityProviders() *GraphServiceIdentityProvidersCollectionRequestBuilder {
	bb := &GraphServiceIdentityProvidersCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/identityProviders"
	return bb
}

// GraphServiceIdentityProvidersCollectionRequestBuilder is request builder for IdentityProvider collection
type GraphServiceIdentityProvidersCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for IdentityProvider collection
func (b *GraphServiceIdentityProvidersCollectionRequestBuilder) Request() *GraphServiceIdentityProvidersCollectionRequest {
	return &GraphServiceIdentityProvidersCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for IdentityProvider item
func (b *GraphServiceIdentityProvidersCollectionRequestBuilder) ID(id string) *IdentityProviderRequestBuilder {
	bb := &IdentityProviderRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// GraphServiceIdentityProvidersCollectionRequest is request for IdentityProvider collection
type GraphServiceIdentityProvidersCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for IdentityProvider collection
func (r *GraphServiceIdentityProvidersCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]IdentityProvider, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []IdentityProvider
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []IdentityProvider
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for IdentityProvider collection, max N pages
func (r *GraphServiceIdentityProvidersCollectionRequest) GetN(ctx context.Context, n int) ([]IdentityProvider, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for IdentityProvider collection
func (r *GraphServiceIdentityProvidersCollectionRequest) Get(ctx context.Context) ([]IdentityProvider, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for IdentityProvider collection
func (r *GraphServiceIdentityProvidersCollectionRequest) Add(ctx context.Context, reqObj *IdentityProvider) (resObj *IdentityProvider, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// IdentityRiskEvents returns request builder for IdentityRiskEvent collection
func (b *GraphServiceRequestBuilder) IdentityRiskEvents() *GraphServiceIdentityRiskEventsCollectionRequestBuilder {
	bb := &GraphServiceIdentityRiskEventsCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/identityRiskEvents"
	return bb
}

// GraphServiceIdentityRiskEventsCollectionRequestBuilder is request builder for IdentityRiskEvent collection
type GraphServiceIdentityRiskEventsCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for IdentityRiskEvent collection
func (b *GraphServiceIdentityRiskEventsCollectionRequestBuilder) Request() *GraphServiceIdentityRiskEventsCollectionRequest {
	return &GraphServiceIdentityRiskEventsCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for IdentityRiskEvent item
func (b *GraphServiceIdentityRiskEventsCollectionRequestBuilder) ID(id string) *IdentityRiskEventRequestBuilder {
	bb := &IdentityRiskEventRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// GraphServiceIdentityRiskEventsCollectionRequest is request for IdentityRiskEvent collection
type GraphServiceIdentityRiskEventsCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for IdentityRiskEvent collection
func (r *GraphServiceIdentityRiskEventsCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]IdentityRiskEvent, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []IdentityRiskEvent
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []IdentityRiskEvent
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for IdentityRiskEvent collection, max N pages
func (r *GraphServiceIdentityRiskEventsCollectionRequest) GetN(ctx context.Context, n int) ([]IdentityRiskEvent, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for IdentityRiskEvent collection
func (r *GraphServiceIdentityRiskEventsCollectionRequest) Get(ctx context.Context) ([]IdentityRiskEvent, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for IdentityRiskEvent collection
func (r *GraphServiceIdentityRiskEventsCollectionRequest) Add(ctx context.Context, reqObj *IdentityRiskEvent) (resObj *IdentityRiskEvent, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// ImpossibleTravelRiskEvents returns request builder for ImpossibleTravelRiskEvent collection
func (b *GraphServiceRequestBuilder) ImpossibleTravelRiskEvents() *GraphServiceImpossibleTravelRiskEventsCollectionRequestBuilder {
	bb := &GraphServiceImpossibleTravelRiskEventsCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/impossibleTravelRiskEvents"
	return bb
}

// GraphServiceImpossibleTravelRiskEventsCollectionRequestBuilder is request builder for ImpossibleTravelRiskEvent collection
type GraphServiceImpossibleTravelRiskEventsCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for ImpossibleTravelRiskEvent collection
func (b *GraphServiceImpossibleTravelRiskEventsCollectionRequestBuilder) Request() *GraphServiceImpossibleTravelRiskEventsCollectionRequest {
	return &GraphServiceImpossibleTravelRiskEventsCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for ImpossibleTravelRiskEvent item
func (b *GraphServiceImpossibleTravelRiskEventsCollectionRequestBuilder) ID(id string) *ImpossibleTravelRiskEventRequestBuilder {
	bb := &ImpossibleTravelRiskEventRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// GraphServiceImpossibleTravelRiskEventsCollectionRequest is request for ImpossibleTravelRiskEvent collection
type GraphServiceImpossibleTravelRiskEventsCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for ImpossibleTravelRiskEvent collection
func (r *GraphServiceImpossibleTravelRiskEventsCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]ImpossibleTravelRiskEvent, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []ImpossibleTravelRiskEvent
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []ImpossibleTravelRiskEvent
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for ImpossibleTravelRiskEvent collection, max N pages
func (r *GraphServiceImpossibleTravelRiskEventsCollectionRequest) GetN(ctx context.Context, n int) ([]ImpossibleTravelRiskEvent, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for ImpossibleTravelRiskEvent collection
func (r *GraphServiceImpossibleTravelRiskEventsCollectionRequest) Get(ctx context.Context) ([]ImpossibleTravelRiskEvent, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for ImpossibleTravelRiskEvent collection
func (r *GraphServiceImpossibleTravelRiskEventsCollectionRequest) Add(ctx context.Context, reqObj *ImpossibleTravelRiskEvent) (resObj *ImpossibleTravelRiskEvent, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// Invitations returns request builder for Invitation collection
func (b *GraphServiceRequestBuilder) Invitations() *GraphServiceInvitationsCollectionRequestBuilder {
	bb := &GraphServiceInvitationsCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/invitations"
	return bb
}

// GraphServiceInvitationsCollectionRequestBuilder is request builder for Invitation collection
type GraphServiceInvitationsCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for Invitation collection
func (b *GraphServiceInvitationsCollectionRequestBuilder) Request() *GraphServiceInvitationsCollectionRequest {
	return &GraphServiceInvitationsCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for Invitation item
func (b *GraphServiceInvitationsCollectionRequestBuilder) ID(id string) *InvitationRequestBuilder {
	bb := &InvitationRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// GraphServiceInvitationsCollectionRequest is request for Invitation collection
type GraphServiceInvitationsCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for Invitation collection
func (r *GraphServiceInvitationsCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]Invitation, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []Invitation
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []Invitation
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for Invitation collection, max N pages
func (r *GraphServiceInvitationsCollectionRequest) GetN(ctx context.Context, n int) ([]Invitation, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for Invitation collection
func (r *GraphServiceInvitationsCollectionRequest) Get(ctx context.Context) ([]Invitation, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for Invitation collection
func (r *GraphServiceInvitationsCollectionRequest) Add(ctx context.Context, reqObj *Invitation) (resObj *Invitation, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// LeakedCredentialsRiskEvents returns request builder for LeakedCredentialsRiskEvent collection
func (b *GraphServiceRequestBuilder) LeakedCredentialsRiskEvents() *GraphServiceLeakedCredentialsRiskEventsCollectionRequestBuilder {
	bb := &GraphServiceLeakedCredentialsRiskEventsCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/leakedCredentialsRiskEvents"
	return bb
}

// GraphServiceLeakedCredentialsRiskEventsCollectionRequestBuilder is request builder for LeakedCredentialsRiskEvent collection
type GraphServiceLeakedCredentialsRiskEventsCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for LeakedCredentialsRiskEvent collection
func (b *GraphServiceLeakedCredentialsRiskEventsCollectionRequestBuilder) Request() *GraphServiceLeakedCredentialsRiskEventsCollectionRequest {
	return &GraphServiceLeakedCredentialsRiskEventsCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for LeakedCredentialsRiskEvent item
func (b *GraphServiceLeakedCredentialsRiskEventsCollectionRequestBuilder) ID(id string) *LeakedCredentialsRiskEventRequestBuilder {
	bb := &LeakedCredentialsRiskEventRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// GraphServiceLeakedCredentialsRiskEventsCollectionRequest is request for LeakedCredentialsRiskEvent collection
type GraphServiceLeakedCredentialsRiskEventsCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for LeakedCredentialsRiskEvent collection
func (r *GraphServiceLeakedCredentialsRiskEventsCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]LeakedCredentialsRiskEvent, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []LeakedCredentialsRiskEvent
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []LeakedCredentialsRiskEvent
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for LeakedCredentialsRiskEvent collection, max N pages
func (r *GraphServiceLeakedCredentialsRiskEventsCollectionRequest) GetN(ctx context.Context, n int) ([]LeakedCredentialsRiskEvent, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for LeakedCredentialsRiskEvent collection
func (r *GraphServiceLeakedCredentialsRiskEventsCollectionRequest) Get(ctx context.Context) ([]LeakedCredentialsRiskEvent, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for LeakedCredentialsRiskEvent collection
func (r *GraphServiceLeakedCredentialsRiskEventsCollectionRequest) Add(ctx context.Context, reqObj *LeakedCredentialsRiskEvent) (resObj *LeakedCredentialsRiskEvent, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// MalwareRiskEvents returns request builder for MalwareRiskEvent collection
func (b *GraphServiceRequestBuilder) MalwareRiskEvents() *GraphServiceMalwareRiskEventsCollectionRequestBuilder {
	bb := &GraphServiceMalwareRiskEventsCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/malwareRiskEvents"
	return bb
}

// GraphServiceMalwareRiskEventsCollectionRequestBuilder is request builder for MalwareRiskEvent collection
type GraphServiceMalwareRiskEventsCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for MalwareRiskEvent collection
func (b *GraphServiceMalwareRiskEventsCollectionRequestBuilder) Request() *GraphServiceMalwareRiskEventsCollectionRequest {
	return &GraphServiceMalwareRiskEventsCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for MalwareRiskEvent item
func (b *GraphServiceMalwareRiskEventsCollectionRequestBuilder) ID(id string) *MalwareRiskEventRequestBuilder {
	bb := &MalwareRiskEventRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// GraphServiceMalwareRiskEventsCollectionRequest is request for MalwareRiskEvent collection
type GraphServiceMalwareRiskEventsCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for MalwareRiskEvent collection
func (r *GraphServiceMalwareRiskEventsCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]MalwareRiskEvent, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []MalwareRiskEvent
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []MalwareRiskEvent
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for MalwareRiskEvent collection, max N pages
func (r *GraphServiceMalwareRiskEventsCollectionRequest) GetN(ctx context.Context, n int) ([]MalwareRiskEvent, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for MalwareRiskEvent collection
func (r *GraphServiceMalwareRiskEventsCollectionRequest) Get(ctx context.Context) ([]MalwareRiskEvent, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for MalwareRiskEvent collection
func (r *GraphServiceMalwareRiskEventsCollectionRequest) Add(ctx context.Context, reqObj *MalwareRiskEvent) (resObj *MalwareRiskEvent, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// OAuth2PermissionGrants returns request builder for OAuth2PermissionGrant collection
func (b *GraphServiceRequestBuilder) OAuth2PermissionGrants() *GraphServiceOAuth2PermissionGrantsCollectionRequestBuilder {
	bb := &GraphServiceOAuth2PermissionGrantsCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/oauth2PermissionGrants"
	return bb
}

// GraphServiceOAuth2PermissionGrantsCollectionRequestBuilder is request builder for OAuth2PermissionGrant collection
type GraphServiceOAuth2PermissionGrantsCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for OAuth2PermissionGrant collection
func (b *GraphServiceOAuth2PermissionGrantsCollectionRequestBuilder) Request() *GraphServiceOAuth2PermissionGrantsCollectionRequest {
	return &GraphServiceOAuth2PermissionGrantsCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for OAuth2PermissionGrant item
func (b *GraphServiceOAuth2PermissionGrantsCollectionRequestBuilder) ID(id string) *OAuth2PermissionGrantRequestBuilder {
	bb := &OAuth2PermissionGrantRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// GraphServiceOAuth2PermissionGrantsCollectionRequest is request for OAuth2PermissionGrant collection
type GraphServiceOAuth2PermissionGrantsCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for OAuth2PermissionGrant collection
func (r *GraphServiceOAuth2PermissionGrantsCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]OAuth2PermissionGrant, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []OAuth2PermissionGrant
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []OAuth2PermissionGrant
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for OAuth2PermissionGrant collection, max N pages
func (r *GraphServiceOAuth2PermissionGrantsCollectionRequest) GetN(ctx context.Context, n int) ([]OAuth2PermissionGrant, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for OAuth2PermissionGrant collection
func (r *GraphServiceOAuth2PermissionGrantsCollectionRequest) Get(ctx context.Context) ([]OAuth2PermissionGrant, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for OAuth2PermissionGrant collection
func (r *GraphServiceOAuth2PermissionGrantsCollectionRequest) Add(ctx context.Context, reqObj *OAuth2PermissionGrant) (resObj *OAuth2PermissionGrant, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// OnPremisesPublishingProfiles returns request builder for OnPremisesPublishingProfile collection
func (b *GraphServiceRequestBuilder) OnPremisesPublishingProfiles() *GraphServiceOnPremisesPublishingProfilesCollectionRequestBuilder {
	bb := &GraphServiceOnPremisesPublishingProfilesCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/onPremisesPublishingProfiles"
	return bb
}

// GraphServiceOnPremisesPublishingProfilesCollectionRequestBuilder is request builder for OnPremisesPublishingProfile collection
type GraphServiceOnPremisesPublishingProfilesCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for OnPremisesPublishingProfile collection
func (b *GraphServiceOnPremisesPublishingProfilesCollectionRequestBuilder) Request() *GraphServiceOnPremisesPublishingProfilesCollectionRequest {
	return &GraphServiceOnPremisesPublishingProfilesCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for OnPremisesPublishingProfile item
func (b *GraphServiceOnPremisesPublishingProfilesCollectionRequestBuilder) ID(id string) *OnPremisesPublishingProfileRequestBuilder {
	bb := &OnPremisesPublishingProfileRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// GraphServiceOnPremisesPublishingProfilesCollectionRequest is request for OnPremisesPublishingProfile collection
type GraphServiceOnPremisesPublishingProfilesCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for OnPremisesPublishingProfile collection
func (r *GraphServiceOnPremisesPublishingProfilesCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]OnPremisesPublishingProfile, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []OnPremisesPublishingProfile
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []OnPremisesPublishingProfile
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for OnPremisesPublishingProfile collection, max N pages
func (r *GraphServiceOnPremisesPublishingProfilesCollectionRequest) GetN(ctx context.Context, n int) ([]OnPremisesPublishingProfile, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for OnPremisesPublishingProfile collection
func (r *GraphServiceOnPremisesPublishingProfilesCollectionRequest) Get(ctx context.Context) ([]OnPremisesPublishingProfile, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for OnPremisesPublishingProfile collection
func (r *GraphServiceOnPremisesPublishingProfilesCollectionRequest) Add(ctx context.Context, reqObj *OnPremisesPublishingProfile) (resObj *OnPremisesPublishingProfile, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// Organization returns request builder for Organization collection
func (b *GraphServiceRequestBuilder) Organization() *GraphServiceOrganizationCollectionRequestBuilder {
	bb := &GraphServiceOrganizationCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/organization"
	return bb
}

// GraphServiceOrganizationCollectionRequestBuilder is request builder for Organization collection
type GraphServiceOrganizationCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for Organization collection
func (b *GraphServiceOrganizationCollectionRequestBuilder) Request() *GraphServiceOrganizationCollectionRequest {
	return &GraphServiceOrganizationCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for Organization item
func (b *GraphServiceOrganizationCollectionRequestBuilder) ID(id string) *OrganizationRequestBuilder {
	bb := &OrganizationRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// GraphServiceOrganizationCollectionRequest is request for Organization collection
type GraphServiceOrganizationCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for Organization collection
func (r *GraphServiceOrganizationCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]Organization, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []Organization
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []Organization
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for Organization collection, max N pages
func (r *GraphServiceOrganizationCollectionRequest) GetN(ctx context.Context, n int) ([]Organization, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for Organization collection
func (r *GraphServiceOrganizationCollectionRequest) Get(ctx context.Context) ([]Organization, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for Organization collection
func (r *GraphServiceOrganizationCollectionRequest) Add(ctx context.Context, reqObj *Organization) (resObj *Organization, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// PayloadResponse returns request builder for PayloadResponse collection
func (b *GraphServiceRequestBuilder) PayloadResponse() *GraphServicePayloadResponseCollectionRequestBuilder {
	bb := &GraphServicePayloadResponseCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/payloadResponse"
	return bb
}

// GraphServicePayloadResponseCollectionRequestBuilder is request builder for PayloadResponse collection
type GraphServicePayloadResponseCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for PayloadResponse collection
func (b *GraphServicePayloadResponseCollectionRequestBuilder) Request() *GraphServicePayloadResponseCollectionRequest {
	return &GraphServicePayloadResponseCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for PayloadResponse item
func (b *GraphServicePayloadResponseCollectionRequestBuilder) ID(id string) *PayloadResponseRequestBuilder {
	bb := &PayloadResponseRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// GraphServicePayloadResponseCollectionRequest is request for PayloadResponse collection
type GraphServicePayloadResponseCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for PayloadResponse collection
func (r *GraphServicePayloadResponseCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]PayloadResponse, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []PayloadResponse
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []PayloadResponse
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for PayloadResponse collection, max N pages
func (r *GraphServicePayloadResponseCollectionRequest) GetN(ctx context.Context, n int) ([]PayloadResponse, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for PayloadResponse collection
func (r *GraphServicePayloadResponseCollectionRequest) Get(ctx context.Context) ([]PayloadResponse, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for PayloadResponse collection
func (r *GraphServicePayloadResponseCollectionRequest) Add(ctx context.Context, reqObj *PayloadResponse) (resObj *PayloadResponse, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// PermissionGrants returns request builder for ResourceSpecificPermissionGrant collection
func (b *GraphServiceRequestBuilder) PermissionGrants() *GraphServicePermissionGrantsCollectionRequestBuilder {
	bb := &GraphServicePermissionGrantsCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/permissionGrants"
	return bb
}

// GraphServicePermissionGrantsCollectionRequestBuilder is request builder for ResourceSpecificPermissionGrant collection
type GraphServicePermissionGrantsCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for ResourceSpecificPermissionGrant collection
func (b *GraphServicePermissionGrantsCollectionRequestBuilder) Request() *GraphServicePermissionGrantsCollectionRequest {
	return &GraphServicePermissionGrantsCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for ResourceSpecificPermissionGrant item
func (b *GraphServicePermissionGrantsCollectionRequestBuilder) ID(id string) *ResourceSpecificPermissionGrantRequestBuilder {
	bb := &ResourceSpecificPermissionGrantRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// GraphServicePermissionGrantsCollectionRequest is request for ResourceSpecificPermissionGrant collection
type GraphServicePermissionGrantsCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for ResourceSpecificPermissionGrant collection
func (r *GraphServicePermissionGrantsCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]ResourceSpecificPermissionGrant, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []ResourceSpecificPermissionGrant
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []ResourceSpecificPermissionGrant
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for ResourceSpecificPermissionGrant collection, max N pages
func (r *GraphServicePermissionGrantsCollectionRequest) GetN(ctx context.Context, n int) ([]ResourceSpecificPermissionGrant, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for ResourceSpecificPermissionGrant collection
func (r *GraphServicePermissionGrantsCollectionRequest) Get(ctx context.Context) ([]ResourceSpecificPermissionGrant, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for ResourceSpecificPermissionGrant collection
func (r *GraphServicePermissionGrantsCollectionRequest) Add(ctx context.Context, reqObj *ResourceSpecificPermissionGrant) (resObj *ResourceSpecificPermissionGrant, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// Places returns request builder for Place collection
func (b *GraphServiceRequestBuilder) Places() *GraphServicePlacesCollectionRequestBuilder {
	bb := &GraphServicePlacesCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/places"
	return bb
}

// GraphServicePlacesCollectionRequestBuilder is request builder for Place collection
type GraphServicePlacesCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for Place collection
func (b *GraphServicePlacesCollectionRequestBuilder) Request() *GraphServicePlacesCollectionRequest {
	return &GraphServicePlacesCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for Place item
func (b *GraphServicePlacesCollectionRequestBuilder) ID(id string) *PlaceRequestBuilder {
	bb := &PlaceRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// GraphServicePlacesCollectionRequest is request for Place collection
type GraphServicePlacesCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for Place collection
func (r *GraphServicePlacesCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]Place, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []Place
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []Place
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for Place collection, max N pages
func (r *GraphServicePlacesCollectionRequest) GetN(ctx context.Context, n int) ([]Place, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for Place collection
func (r *GraphServicePlacesCollectionRequest) Get(ctx context.Context) ([]Place, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for Place collection
func (r *GraphServicePlacesCollectionRequest) Add(ctx context.Context, reqObj *Place) (resObj *Place, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// Policies returns request builder for Policy collection
func (b *GraphServiceRequestBuilder) Policies() *GraphServicePoliciesCollectionRequestBuilder {
	bb := &GraphServicePoliciesCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/policies"
	return bb
}

// GraphServicePoliciesCollectionRequestBuilder is request builder for Policy collection
type GraphServicePoliciesCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for Policy collection
func (b *GraphServicePoliciesCollectionRequestBuilder) Request() *GraphServicePoliciesCollectionRequest {
	return &GraphServicePoliciesCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for Policy item
func (b *GraphServicePoliciesCollectionRequestBuilder) ID(id string) *PolicyRequestBuilder {
	bb := &PolicyRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// GraphServicePoliciesCollectionRequest is request for Policy collection
type GraphServicePoliciesCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for Policy collection
func (r *GraphServicePoliciesCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]Policy, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []Policy
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []Policy
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for Policy collection, max N pages
func (r *GraphServicePoliciesCollectionRequest) GetN(ctx context.Context, n int) ([]Policy, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for Policy collection
func (r *GraphServicePoliciesCollectionRequest) Get(ctx context.Context) ([]Policy, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for Policy collection
func (r *GraphServicePoliciesCollectionRequest) Add(ctx context.Context, reqObj *Policy) (resObj *Policy, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// PrivilegedAccess returns request builder for PrivilegedAccess collection
func (b *GraphServiceRequestBuilder) PrivilegedAccess() *GraphServicePrivilegedAccessCollectionRequestBuilder {
	bb := &GraphServicePrivilegedAccessCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/privilegedAccess"
	return bb
}

// GraphServicePrivilegedAccessCollectionRequestBuilder is request builder for PrivilegedAccess collection
type GraphServicePrivilegedAccessCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for PrivilegedAccess collection
func (b *GraphServicePrivilegedAccessCollectionRequestBuilder) Request() *GraphServicePrivilegedAccessCollectionRequest {
	return &GraphServicePrivilegedAccessCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for PrivilegedAccess item
func (b *GraphServicePrivilegedAccessCollectionRequestBuilder) ID(id string) *PrivilegedAccessRequestBuilder {
	bb := &PrivilegedAccessRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// GraphServicePrivilegedAccessCollectionRequest is request for PrivilegedAccess collection
type GraphServicePrivilegedAccessCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for PrivilegedAccess collection
func (r *GraphServicePrivilegedAccessCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]PrivilegedAccess, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []PrivilegedAccess
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []PrivilegedAccess
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for PrivilegedAccess collection, max N pages
func (r *GraphServicePrivilegedAccessCollectionRequest) GetN(ctx context.Context, n int) ([]PrivilegedAccess, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for PrivilegedAccess collection
func (r *GraphServicePrivilegedAccessCollectionRequest) Get(ctx context.Context) ([]PrivilegedAccess, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for PrivilegedAccess collection
func (r *GraphServicePrivilegedAccessCollectionRequest) Add(ctx context.Context, reqObj *PrivilegedAccess) (resObj *PrivilegedAccess, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// PrivilegedApproval returns request builder for PrivilegedApproval collection
func (b *GraphServiceRequestBuilder) PrivilegedApproval() *GraphServicePrivilegedApprovalCollectionRequestBuilder {
	bb := &GraphServicePrivilegedApprovalCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/privilegedApproval"
	return bb
}

// GraphServicePrivilegedApprovalCollectionRequestBuilder is request builder for PrivilegedApproval collection
type GraphServicePrivilegedApprovalCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for PrivilegedApproval collection
func (b *GraphServicePrivilegedApprovalCollectionRequestBuilder) Request() *GraphServicePrivilegedApprovalCollectionRequest {
	return &GraphServicePrivilegedApprovalCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for PrivilegedApproval item
func (b *GraphServicePrivilegedApprovalCollectionRequestBuilder) ID(id string) *PrivilegedApprovalRequestBuilder {
	bb := &PrivilegedApprovalRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// GraphServicePrivilegedApprovalCollectionRequest is request for PrivilegedApproval collection
type GraphServicePrivilegedApprovalCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for PrivilegedApproval collection
func (r *GraphServicePrivilegedApprovalCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]PrivilegedApproval, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []PrivilegedApproval
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []PrivilegedApproval
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for PrivilegedApproval collection, max N pages
func (r *GraphServicePrivilegedApprovalCollectionRequest) GetN(ctx context.Context, n int) ([]PrivilegedApproval, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for PrivilegedApproval collection
func (r *GraphServicePrivilegedApprovalCollectionRequest) Get(ctx context.Context) ([]PrivilegedApproval, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for PrivilegedApproval collection
func (r *GraphServicePrivilegedApprovalCollectionRequest) Add(ctx context.Context, reqObj *PrivilegedApproval) (resObj *PrivilegedApproval, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// PrivilegedOperationEvents returns request builder for PrivilegedOperationEvent collection
func (b *GraphServiceRequestBuilder) PrivilegedOperationEvents() *GraphServicePrivilegedOperationEventsCollectionRequestBuilder {
	bb := &GraphServicePrivilegedOperationEventsCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/privilegedOperationEvents"
	return bb
}

// GraphServicePrivilegedOperationEventsCollectionRequestBuilder is request builder for PrivilegedOperationEvent collection
type GraphServicePrivilegedOperationEventsCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for PrivilegedOperationEvent collection
func (b *GraphServicePrivilegedOperationEventsCollectionRequestBuilder) Request() *GraphServicePrivilegedOperationEventsCollectionRequest {
	return &GraphServicePrivilegedOperationEventsCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for PrivilegedOperationEvent item
func (b *GraphServicePrivilegedOperationEventsCollectionRequestBuilder) ID(id string) *PrivilegedOperationEventRequestBuilder {
	bb := &PrivilegedOperationEventRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// GraphServicePrivilegedOperationEventsCollectionRequest is request for PrivilegedOperationEvent collection
type GraphServicePrivilegedOperationEventsCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for PrivilegedOperationEvent collection
func (r *GraphServicePrivilegedOperationEventsCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]PrivilegedOperationEvent, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []PrivilegedOperationEvent
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []PrivilegedOperationEvent
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for PrivilegedOperationEvent collection, max N pages
func (r *GraphServicePrivilegedOperationEventsCollectionRequest) GetN(ctx context.Context, n int) ([]PrivilegedOperationEvent, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for PrivilegedOperationEvent collection
func (r *GraphServicePrivilegedOperationEventsCollectionRequest) Get(ctx context.Context) ([]PrivilegedOperationEvent, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for PrivilegedOperationEvent collection
func (r *GraphServicePrivilegedOperationEventsCollectionRequest) Add(ctx context.Context, reqObj *PrivilegedOperationEvent) (resObj *PrivilegedOperationEvent, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// PrivilegedRoleAssignmentRequests returns request builder for PrivilegedRoleAssignmentRequestObject collection
func (b *GraphServiceRequestBuilder) PrivilegedRoleAssignmentRequests() *GraphServicePrivilegedRoleAssignmentRequestsCollectionRequestBuilder {
	bb := &GraphServicePrivilegedRoleAssignmentRequestsCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/privilegedRoleAssignmentRequests"
	return bb
}

// GraphServicePrivilegedRoleAssignmentRequestsCollectionRequestBuilder is request builder for PrivilegedRoleAssignmentRequestObject collection
type GraphServicePrivilegedRoleAssignmentRequestsCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for PrivilegedRoleAssignmentRequestObject collection
func (b *GraphServicePrivilegedRoleAssignmentRequestsCollectionRequestBuilder) Request() *GraphServicePrivilegedRoleAssignmentRequestsCollectionRequest {
	return &GraphServicePrivilegedRoleAssignmentRequestsCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for PrivilegedRoleAssignmentRequestObject item
func (b *GraphServicePrivilegedRoleAssignmentRequestsCollectionRequestBuilder) ID(id string) *PrivilegedRoleAssignmentRequestObjectRequestBuilder {
	bb := &PrivilegedRoleAssignmentRequestObjectRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// GraphServicePrivilegedRoleAssignmentRequestsCollectionRequest is request for PrivilegedRoleAssignmentRequestObject collection
type GraphServicePrivilegedRoleAssignmentRequestsCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for PrivilegedRoleAssignmentRequestObject collection
func (r *GraphServicePrivilegedRoleAssignmentRequestsCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]PrivilegedRoleAssignmentRequestObject, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []PrivilegedRoleAssignmentRequestObject
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []PrivilegedRoleAssignmentRequestObject
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for PrivilegedRoleAssignmentRequestObject collection, max N pages
func (r *GraphServicePrivilegedRoleAssignmentRequestsCollectionRequest) GetN(ctx context.Context, n int) ([]PrivilegedRoleAssignmentRequestObject, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for PrivilegedRoleAssignmentRequestObject collection
func (r *GraphServicePrivilegedRoleAssignmentRequestsCollectionRequest) Get(ctx context.Context) ([]PrivilegedRoleAssignmentRequestObject, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for PrivilegedRoleAssignmentRequestObject collection
func (r *GraphServicePrivilegedRoleAssignmentRequestsCollectionRequest) Add(ctx context.Context, reqObj *PrivilegedRoleAssignmentRequestObject) (resObj *PrivilegedRoleAssignmentRequestObject, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// PrivilegedRoleAssignments returns request builder for PrivilegedRoleAssignment collection
func (b *GraphServiceRequestBuilder) PrivilegedRoleAssignments() *GraphServicePrivilegedRoleAssignmentsCollectionRequestBuilder {
	bb := &GraphServicePrivilegedRoleAssignmentsCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/privilegedRoleAssignments"
	return bb
}

// GraphServicePrivilegedRoleAssignmentsCollectionRequestBuilder is request builder for PrivilegedRoleAssignment collection
type GraphServicePrivilegedRoleAssignmentsCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for PrivilegedRoleAssignment collection
func (b *GraphServicePrivilegedRoleAssignmentsCollectionRequestBuilder) Request() *GraphServicePrivilegedRoleAssignmentsCollectionRequest {
	return &GraphServicePrivilegedRoleAssignmentsCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for PrivilegedRoleAssignment item
func (b *GraphServicePrivilegedRoleAssignmentsCollectionRequestBuilder) ID(id string) *PrivilegedRoleAssignmentRequestBuilder {
	bb := &PrivilegedRoleAssignmentRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// GraphServicePrivilegedRoleAssignmentsCollectionRequest is request for PrivilegedRoleAssignment collection
type GraphServicePrivilegedRoleAssignmentsCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for PrivilegedRoleAssignment collection
func (r *GraphServicePrivilegedRoleAssignmentsCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]PrivilegedRoleAssignment, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []PrivilegedRoleAssignment
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []PrivilegedRoleAssignment
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for PrivilegedRoleAssignment collection, max N pages
func (r *GraphServicePrivilegedRoleAssignmentsCollectionRequest) GetN(ctx context.Context, n int) ([]PrivilegedRoleAssignment, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for PrivilegedRoleAssignment collection
func (r *GraphServicePrivilegedRoleAssignmentsCollectionRequest) Get(ctx context.Context) ([]PrivilegedRoleAssignment, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for PrivilegedRoleAssignment collection
func (r *GraphServicePrivilegedRoleAssignmentsCollectionRequest) Add(ctx context.Context, reqObj *PrivilegedRoleAssignment) (resObj *PrivilegedRoleAssignment, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// PrivilegedRoles returns request builder for PrivilegedRole collection
func (b *GraphServiceRequestBuilder) PrivilegedRoles() *GraphServicePrivilegedRolesCollectionRequestBuilder {
	bb := &GraphServicePrivilegedRolesCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/privilegedRoles"
	return bb
}

// GraphServicePrivilegedRolesCollectionRequestBuilder is request builder for PrivilegedRole collection
type GraphServicePrivilegedRolesCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for PrivilegedRole collection
func (b *GraphServicePrivilegedRolesCollectionRequestBuilder) Request() *GraphServicePrivilegedRolesCollectionRequest {
	return &GraphServicePrivilegedRolesCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for PrivilegedRole item
func (b *GraphServicePrivilegedRolesCollectionRequestBuilder) ID(id string) *PrivilegedRoleRequestBuilder {
	bb := &PrivilegedRoleRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// GraphServicePrivilegedRolesCollectionRequest is request for PrivilegedRole collection
type GraphServicePrivilegedRolesCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for PrivilegedRole collection
func (r *GraphServicePrivilegedRolesCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]PrivilegedRole, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []PrivilegedRole
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []PrivilegedRole
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for PrivilegedRole collection, max N pages
func (r *GraphServicePrivilegedRolesCollectionRequest) GetN(ctx context.Context, n int) ([]PrivilegedRole, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for PrivilegedRole collection
func (r *GraphServicePrivilegedRolesCollectionRequest) Get(ctx context.Context) ([]PrivilegedRole, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for PrivilegedRole collection
func (r *GraphServicePrivilegedRolesCollectionRequest) Add(ctx context.Context, reqObj *PrivilegedRole) (resObj *PrivilegedRole, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// PrivilegedSignupStatus returns request builder for PrivilegedSignupStatus collection
func (b *GraphServiceRequestBuilder) PrivilegedSignupStatus() *GraphServicePrivilegedSignupStatusCollectionRequestBuilder {
	bb := &GraphServicePrivilegedSignupStatusCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/privilegedSignupStatus"
	return bb
}

// GraphServicePrivilegedSignupStatusCollectionRequestBuilder is request builder for PrivilegedSignupStatus collection
type GraphServicePrivilegedSignupStatusCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for PrivilegedSignupStatus collection
func (b *GraphServicePrivilegedSignupStatusCollectionRequestBuilder) Request() *GraphServicePrivilegedSignupStatusCollectionRequest {
	return &GraphServicePrivilegedSignupStatusCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for PrivilegedSignupStatus item
func (b *GraphServicePrivilegedSignupStatusCollectionRequestBuilder) ID(id string) *PrivilegedSignupStatusRequestBuilder {
	bb := &PrivilegedSignupStatusRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// GraphServicePrivilegedSignupStatusCollectionRequest is request for PrivilegedSignupStatus collection
type GraphServicePrivilegedSignupStatusCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for PrivilegedSignupStatus collection
func (r *GraphServicePrivilegedSignupStatusCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]PrivilegedSignupStatus, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []PrivilegedSignupStatus
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []PrivilegedSignupStatus
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for PrivilegedSignupStatus collection, max N pages
func (r *GraphServicePrivilegedSignupStatusCollectionRequest) GetN(ctx context.Context, n int) ([]PrivilegedSignupStatus, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for PrivilegedSignupStatus collection
func (r *GraphServicePrivilegedSignupStatusCollectionRequest) Get(ctx context.Context) ([]PrivilegedSignupStatus, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for PrivilegedSignupStatus collection
func (r *GraphServicePrivilegedSignupStatusCollectionRequest) Add(ctx context.Context, reqObj *PrivilegedSignupStatus) (resObj *PrivilegedSignupStatus, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// ProgramControlTypes returns request builder for ProgramControlType collection
func (b *GraphServiceRequestBuilder) ProgramControlTypes() *GraphServiceProgramControlTypesCollectionRequestBuilder {
	bb := &GraphServiceProgramControlTypesCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/programControlTypes"
	return bb
}

// GraphServiceProgramControlTypesCollectionRequestBuilder is request builder for ProgramControlType collection
type GraphServiceProgramControlTypesCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for ProgramControlType collection
func (b *GraphServiceProgramControlTypesCollectionRequestBuilder) Request() *GraphServiceProgramControlTypesCollectionRequest {
	return &GraphServiceProgramControlTypesCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for ProgramControlType item
func (b *GraphServiceProgramControlTypesCollectionRequestBuilder) ID(id string) *ProgramControlTypeRequestBuilder {
	bb := &ProgramControlTypeRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// GraphServiceProgramControlTypesCollectionRequest is request for ProgramControlType collection
type GraphServiceProgramControlTypesCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for ProgramControlType collection
func (r *GraphServiceProgramControlTypesCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]ProgramControlType, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []ProgramControlType
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []ProgramControlType
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for ProgramControlType collection, max N pages
func (r *GraphServiceProgramControlTypesCollectionRequest) GetN(ctx context.Context, n int) ([]ProgramControlType, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for ProgramControlType collection
func (r *GraphServiceProgramControlTypesCollectionRequest) Get(ctx context.Context) ([]ProgramControlType, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for ProgramControlType collection
func (r *GraphServiceProgramControlTypesCollectionRequest) Add(ctx context.Context, reqObj *ProgramControlType) (resObj *ProgramControlType, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// ProgramControls returns request builder for ProgramControl collection
func (b *GraphServiceRequestBuilder) ProgramControls() *GraphServiceProgramControlsCollectionRequestBuilder {
	bb := &GraphServiceProgramControlsCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/programControls"
	return bb
}

// GraphServiceProgramControlsCollectionRequestBuilder is request builder for ProgramControl collection
type GraphServiceProgramControlsCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for ProgramControl collection
func (b *GraphServiceProgramControlsCollectionRequestBuilder) Request() *GraphServiceProgramControlsCollectionRequest {
	return &GraphServiceProgramControlsCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for ProgramControl item
func (b *GraphServiceProgramControlsCollectionRequestBuilder) ID(id string) *ProgramControlRequestBuilder {
	bb := &ProgramControlRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// GraphServiceProgramControlsCollectionRequest is request for ProgramControl collection
type GraphServiceProgramControlsCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for ProgramControl collection
func (r *GraphServiceProgramControlsCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]ProgramControl, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []ProgramControl
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []ProgramControl
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for ProgramControl collection, max N pages
func (r *GraphServiceProgramControlsCollectionRequest) GetN(ctx context.Context, n int) ([]ProgramControl, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for ProgramControl collection
func (r *GraphServiceProgramControlsCollectionRequest) Get(ctx context.Context) ([]ProgramControl, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for ProgramControl collection
func (r *GraphServiceProgramControlsCollectionRequest) Add(ctx context.Context, reqObj *ProgramControl) (resObj *ProgramControl, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// Programs returns request builder for Program collection
func (b *GraphServiceRequestBuilder) Programs() *GraphServiceProgramsCollectionRequestBuilder {
	bb := &GraphServiceProgramsCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/programs"
	return bb
}

// GraphServiceProgramsCollectionRequestBuilder is request builder for Program collection
type GraphServiceProgramsCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for Program collection
func (b *GraphServiceProgramsCollectionRequestBuilder) Request() *GraphServiceProgramsCollectionRequest {
	return &GraphServiceProgramsCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for Program item
func (b *GraphServiceProgramsCollectionRequestBuilder) ID(id string) *ProgramRequestBuilder {
	bb := &ProgramRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// GraphServiceProgramsCollectionRequest is request for Program collection
type GraphServiceProgramsCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for Program collection
func (r *GraphServiceProgramsCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]Program, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []Program
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []Program
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for Program collection, max N pages
func (r *GraphServiceProgramsCollectionRequest) GetN(ctx context.Context, n int) ([]Program, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for Program collection
func (r *GraphServiceProgramsCollectionRequest) Get(ctx context.Context) ([]Program, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for Program collection
func (r *GraphServiceProgramsCollectionRequest) Add(ctx context.Context, reqObj *Program) (resObj *Program, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// RiskDetections returns request builder for RiskDetection collection
func (b *GraphServiceRequestBuilder) RiskDetections() *GraphServiceRiskDetectionsCollectionRequestBuilder {
	bb := &GraphServiceRiskDetectionsCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/riskDetections"
	return bb
}

// GraphServiceRiskDetectionsCollectionRequestBuilder is request builder for RiskDetection collection
type GraphServiceRiskDetectionsCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for RiskDetection collection
func (b *GraphServiceRiskDetectionsCollectionRequestBuilder) Request() *GraphServiceRiskDetectionsCollectionRequest {
	return &GraphServiceRiskDetectionsCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for RiskDetection item
func (b *GraphServiceRiskDetectionsCollectionRequestBuilder) ID(id string) *RiskDetectionRequestBuilder {
	bb := &RiskDetectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// GraphServiceRiskDetectionsCollectionRequest is request for RiskDetection collection
type GraphServiceRiskDetectionsCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for RiskDetection collection
func (r *GraphServiceRiskDetectionsCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]RiskDetection, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []RiskDetection
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []RiskDetection
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for RiskDetection collection, max N pages
func (r *GraphServiceRiskDetectionsCollectionRequest) GetN(ctx context.Context, n int) ([]RiskDetection, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for RiskDetection collection
func (r *GraphServiceRiskDetectionsCollectionRequest) Get(ctx context.Context) ([]RiskDetection, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for RiskDetection collection
func (r *GraphServiceRiskDetectionsCollectionRequest) Add(ctx context.Context, reqObj *RiskDetection) (resObj *RiskDetection, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// RiskyUsers returns request builder for RiskyUser collection
func (b *GraphServiceRequestBuilder) RiskyUsers() *GraphServiceRiskyUsersCollectionRequestBuilder {
	bb := &GraphServiceRiskyUsersCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/riskyUsers"
	return bb
}

// GraphServiceRiskyUsersCollectionRequestBuilder is request builder for RiskyUser collection
type GraphServiceRiskyUsersCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for RiskyUser collection
func (b *GraphServiceRiskyUsersCollectionRequestBuilder) Request() *GraphServiceRiskyUsersCollectionRequest {
	return &GraphServiceRiskyUsersCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for RiskyUser item
func (b *GraphServiceRiskyUsersCollectionRequestBuilder) ID(id string) *RiskyUserRequestBuilder {
	bb := &RiskyUserRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// GraphServiceRiskyUsersCollectionRequest is request for RiskyUser collection
type GraphServiceRiskyUsersCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for RiskyUser collection
func (r *GraphServiceRiskyUsersCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]RiskyUser, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []RiskyUser
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []RiskyUser
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for RiskyUser collection, max N pages
func (r *GraphServiceRiskyUsersCollectionRequest) GetN(ctx context.Context, n int) ([]RiskyUser, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for RiskyUser collection
func (r *GraphServiceRiskyUsersCollectionRequest) Get(ctx context.Context) ([]RiskyUser, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for RiskyUser collection
func (r *GraphServiceRiskyUsersCollectionRequest) Add(ctx context.Context, reqObj *RiskyUser) (resObj *RiskyUser, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// SchemaExtensions returns request builder for SchemaExtension collection
func (b *GraphServiceRequestBuilder) SchemaExtensions() *GraphServiceSchemaExtensionsCollectionRequestBuilder {
	bb := &GraphServiceSchemaExtensionsCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/schemaExtensions"
	return bb
}

// GraphServiceSchemaExtensionsCollectionRequestBuilder is request builder for SchemaExtension collection
type GraphServiceSchemaExtensionsCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for SchemaExtension collection
func (b *GraphServiceSchemaExtensionsCollectionRequestBuilder) Request() *GraphServiceSchemaExtensionsCollectionRequest {
	return &GraphServiceSchemaExtensionsCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for SchemaExtension item
func (b *GraphServiceSchemaExtensionsCollectionRequestBuilder) ID(id string) *SchemaExtensionRequestBuilder {
	bb := &SchemaExtensionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// GraphServiceSchemaExtensionsCollectionRequest is request for SchemaExtension collection
type GraphServiceSchemaExtensionsCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for SchemaExtension collection
func (r *GraphServiceSchemaExtensionsCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]SchemaExtension, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []SchemaExtension
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []SchemaExtension
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for SchemaExtension collection, max N pages
func (r *GraphServiceSchemaExtensionsCollectionRequest) GetN(ctx context.Context, n int) ([]SchemaExtension, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for SchemaExtension collection
func (r *GraphServiceSchemaExtensionsCollectionRequest) Get(ctx context.Context) ([]SchemaExtension, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for SchemaExtension collection
func (r *GraphServiceSchemaExtensionsCollectionRequest) Add(ctx context.Context, reqObj *SchemaExtension) (resObj *SchemaExtension, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// ScopedRoleMemberships returns request builder for ScopedRoleMembership collection
func (b *GraphServiceRequestBuilder) ScopedRoleMemberships() *GraphServiceScopedRoleMembershipsCollectionRequestBuilder {
	bb := &GraphServiceScopedRoleMembershipsCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/scopedRoleMemberships"
	return bb
}

// GraphServiceScopedRoleMembershipsCollectionRequestBuilder is request builder for ScopedRoleMembership collection
type GraphServiceScopedRoleMembershipsCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for ScopedRoleMembership collection
func (b *GraphServiceScopedRoleMembershipsCollectionRequestBuilder) Request() *GraphServiceScopedRoleMembershipsCollectionRequest {
	return &GraphServiceScopedRoleMembershipsCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for ScopedRoleMembership item
func (b *GraphServiceScopedRoleMembershipsCollectionRequestBuilder) ID(id string) *ScopedRoleMembershipRequestBuilder {
	bb := &ScopedRoleMembershipRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// GraphServiceScopedRoleMembershipsCollectionRequest is request for ScopedRoleMembership collection
type GraphServiceScopedRoleMembershipsCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for ScopedRoleMembership collection
func (r *GraphServiceScopedRoleMembershipsCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]ScopedRoleMembership, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []ScopedRoleMembership
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []ScopedRoleMembership
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for ScopedRoleMembership collection, max N pages
func (r *GraphServiceScopedRoleMembershipsCollectionRequest) GetN(ctx context.Context, n int) ([]ScopedRoleMembership, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for ScopedRoleMembership collection
func (r *GraphServiceScopedRoleMembershipsCollectionRequest) Get(ctx context.Context) ([]ScopedRoleMembership, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for ScopedRoleMembership collection
func (r *GraphServiceScopedRoleMembershipsCollectionRequest) Add(ctx context.Context, reqObj *ScopedRoleMembership) (resObj *ScopedRoleMembership, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// ServicePrincipals returns request builder for ServicePrincipal collection
func (b *GraphServiceRequestBuilder) ServicePrincipals() *GraphServiceServicePrincipalsCollectionRequestBuilder {
	bb := &GraphServiceServicePrincipalsCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/servicePrincipals"
	return bb
}

// GraphServiceServicePrincipalsCollectionRequestBuilder is request builder for ServicePrincipal collection
type GraphServiceServicePrincipalsCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for ServicePrincipal collection
func (b *GraphServiceServicePrincipalsCollectionRequestBuilder) Request() *GraphServiceServicePrincipalsCollectionRequest {
	return &GraphServiceServicePrincipalsCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for ServicePrincipal item
func (b *GraphServiceServicePrincipalsCollectionRequestBuilder) ID(id string) *ServicePrincipalRequestBuilder {
	bb := &ServicePrincipalRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// GraphServiceServicePrincipalsCollectionRequest is request for ServicePrincipal collection
type GraphServiceServicePrincipalsCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for ServicePrincipal collection
func (r *GraphServiceServicePrincipalsCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]ServicePrincipal, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []ServicePrincipal
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []ServicePrincipal
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for ServicePrincipal collection, max N pages
func (r *GraphServiceServicePrincipalsCollectionRequest) GetN(ctx context.Context, n int) ([]ServicePrincipal, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for ServicePrincipal collection
func (r *GraphServiceServicePrincipalsCollectionRequest) Get(ctx context.Context) ([]ServicePrincipal, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for ServicePrincipal collection
func (r *GraphServiceServicePrincipalsCollectionRequest) Add(ctx context.Context, reqObj *ServicePrincipal) (resObj *ServicePrincipal, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// Settings returns request builder for DirectorySetting collection
func (b *GraphServiceRequestBuilder) Settings() *GraphServiceSettingsCollectionRequestBuilder {
	bb := &GraphServiceSettingsCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/settings"
	return bb
}

// GraphServiceSettingsCollectionRequestBuilder is request builder for DirectorySetting collection
type GraphServiceSettingsCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for DirectorySetting collection
func (b *GraphServiceSettingsCollectionRequestBuilder) Request() *GraphServiceSettingsCollectionRequest {
	return &GraphServiceSettingsCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for DirectorySetting item
func (b *GraphServiceSettingsCollectionRequestBuilder) ID(id string) *DirectorySettingRequestBuilder {
	bb := &DirectorySettingRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// GraphServiceSettingsCollectionRequest is request for DirectorySetting collection
type GraphServiceSettingsCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for DirectorySetting collection
func (r *GraphServiceSettingsCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]DirectorySetting, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []DirectorySetting
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []DirectorySetting
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for DirectorySetting collection, max N pages
func (r *GraphServiceSettingsCollectionRequest) GetN(ctx context.Context, n int) ([]DirectorySetting, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for DirectorySetting collection
func (r *GraphServiceSettingsCollectionRequest) Get(ctx context.Context) ([]DirectorySetting, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for DirectorySetting collection
func (r *GraphServiceSettingsCollectionRequest) Add(ctx context.Context, reqObj *DirectorySetting) (resObj *DirectorySetting, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// Shares returns request builder for SharedDriveItem collection
func (b *GraphServiceRequestBuilder) Shares() *GraphServiceSharesCollectionRequestBuilder {
	bb := &GraphServiceSharesCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/shares"
	return bb
}

// GraphServiceSharesCollectionRequestBuilder is request builder for SharedDriveItem collection
type GraphServiceSharesCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for SharedDriveItem collection
func (b *GraphServiceSharesCollectionRequestBuilder) Request() *GraphServiceSharesCollectionRequest {
	return &GraphServiceSharesCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for SharedDriveItem item
func (b *GraphServiceSharesCollectionRequestBuilder) ID(id string) *SharedDriveItemRequestBuilder {
	bb := &SharedDriveItemRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// GraphServiceSharesCollectionRequest is request for SharedDriveItem collection
type GraphServiceSharesCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for SharedDriveItem collection
func (r *GraphServiceSharesCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]SharedDriveItem, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []SharedDriveItem
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []SharedDriveItem
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for SharedDriveItem collection, max N pages
func (r *GraphServiceSharesCollectionRequest) GetN(ctx context.Context, n int) ([]SharedDriveItem, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for SharedDriveItem collection
func (r *GraphServiceSharesCollectionRequest) Get(ctx context.Context) ([]SharedDriveItem, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for SharedDriveItem collection
func (r *GraphServiceSharesCollectionRequest) Add(ctx context.Context, reqObj *SharedDriveItem) (resObj *SharedDriveItem, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// Sites returns request builder for Site collection
func (b *GraphServiceRequestBuilder) Sites() *GraphServiceSitesCollectionRequestBuilder {
	bb := &GraphServiceSitesCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/sites"
	return bb
}

// GraphServiceSitesCollectionRequestBuilder is request builder for Site collection
type GraphServiceSitesCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for Site collection
func (b *GraphServiceSitesCollectionRequestBuilder) Request() *GraphServiceSitesCollectionRequest {
	return &GraphServiceSitesCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for Site item
func (b *GraphServiceSitesCollectionRequestBuilder) ID(id string) *SiteRequestBuilder {
	bb := &SiteRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// GraphServiceSitesCollectionRequest is request for Site collection
type GraphServiceSitesCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for Site collection
func (r *GraphServiceSitesCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]Site, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []Site
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []Site
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for Site collection, max N pages
func (r *GraphServiceSitesCollectionRequest) GetN(ctx context.Context, n int) ([]Site, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for Site collection
func (r *GraphServiceSitesCollectionRequest) Get(ctx context.Context) ([]Site, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for Site collection
func (r *GraphServiceSitesCollectionRequest) Add(ctx context.Context, reqObj *Site) (resObj *Site, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// SubscribedSKUs returns request builder for SubscribedSKU collection
func (b *GraphServiceRequestBuilder) SubscribedSKUs() *GraphServiceSubscribedSKUsCollectionRequestBuilder {
	bb := &GraphServiceSubscribedSKUsCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/subscribedSkus"
	return bb
}

// GraphServiceSubscribedSKUsCollectionRequestBuilder is request builder for SubscribedSKU collection
type GraphServiceSubscribedSKUsCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for SubscribedSKU collection
func (b *GraphServiceSubscribedSKUsCollectionRequestBuilder) Request() *GraphServiceSubscribedSKUsCollectionRequest {
	return &GraphServiceSubscribedSKUsCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for SubscribedSKU item
func (b *GraphServiceSubscribedSKUsCollectionRequestBuilder) ID(id string) *SubscribedSKURequestBuilder {
	bb := &SubscribedSKURequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// GraphServiceSubscribedSKUsCollectionRequest is request for SubscribedSKU collection
type GraphServiceSubscribedSKUsCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for SubscribedSKU collection
func (r *GraphServiceSubscribedSKUsCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]SubscribedSKU, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []SubscribedSKU
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []SubscribedSKU
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for SubscribedSKU collection, max N pages
func (r *GraphServiceSubscribedSKUsCollectionRequest) GetN(ctx context.Context, n int) ([]SubscribedSKU, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for SubscribedSKU collection
func (r *GraphServiceSubscribedSKUsCollectionRequest) Get(ctx context.Context) ([]SubscribedSKU, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for SubscribedSKU collection
func (r *GraphServiceSubscribedSKUsCollectionRequest) Add(ctx context.Context, reqObj *SubscribedSKU) (resObj *SubscribedSKU, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// Subscriptions returns request builder for Subscription collection
func (b *GraphServiceRequestBuilder) Subscriptions() *GraphServiceSubscriptionsCollectionRequestBuilder {
	bb := &GraphServiceSubscriptionsCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/subscriptions"
	return bb
}

// GraphServiceSubscriptionsCollectionRequestBuilder is request builder for Subscription collection
type GraphServiceSubscriptionsCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for Subscription collection
func (b *GraphServiceSubscriptionsCollectionRequestBuilder) Request() *GraphServiceSubscriptionsCollectionRequest {
	return &GraphServiceSubscriptionsCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for Subscription item
func (b *GraphServiceSubscriptionsCollectionRequestBuilder) ID(id string) *SubscriptionRequestBuilder {
	bb := &SubscriptionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// GraphServiceSubscriptionsCollectionRequest is request for Subscription collection
type GraphServiceSubscriptionsCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for Subscription collection
func (r *GraphServiceSubscriptionsCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]Subscription, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []Subscription
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []Subscription
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for Subscription collection, max N pages
func (r *GraphServiceSubscriptionsCollectionRequest) GetN(ctx context.Context, n int) ([]Subscription, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for Subscription collection
func (r *GraphServiceSubscriptionsCollectionRequest) Get(ctx context.Context) ([]Subscription, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for Subscription collection
func (r *GraphServiceSubscriptionsCollectionRequest) Add(ctx context.Context, reqObj *Subscription) (resObj *Subscription, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// SuspiciousIPRiskEvents returns request builder for SuspiciousIPRiskEvent collection
func (b *GraphServiceRequestBuilder) SuspiciousIPRiskEvents() *GraphServiceSuspiciousIPRiskEventsCollectionRequestBuilder {
	bb := &GraphServiceSuspiciousIPRiskEventsCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/suspiciousIpRiskEvents"
	return bb
}

// GraphServiceSuspiciousIPRiskEventsCollectionRequestBuilder is request builder for SuspiciousIPRiskEvent collection
type GraphServiceSuspiciousIPRiskEventsCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for SuspiciousIPRiskEvent collection
func (b *GraphServiceSuspiciousIPRiskEventsCollectionRequestBuilder) Request() *GraphServiceSuspiciousIPRiskEventsCollectionRequest {
	return &GraphServiceSuspiciousIPRiskEventsCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for SuspiciousIPRiskEvent item
func (b *GraphServiceSuspiciousIPRiskEventsCollectionRequestBuilder) ID(id string) *SuspiciousIPRiskEventRequestBuilder {
	bb := &SuspiciousIPRiskEventRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// GraphServiceSuspiciousIPRiskEventsCollectionRequest is request for SuspiciousIPRiskEvent collection
type GraphServiceSuspiciousIPRiskEventsCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for SuspiciousIPRiskEvent collection
func (r *GraphServiceSuspiciousIPRiskEventsCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]SuspiciousIPRiskEvent, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []SuspiciousIPRiskEvent
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []SuspiciousIPRiskEvent
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for SuspiciousIPRiskEvent collection, max N pages
func (r *GraphServiceSuspiciousIPRiskEventsCollectionRequest) GetN(ctx context.Context, n int) ([]SuspiciousIPRiskEvent, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for SuspiciousIPRiskEvent collection
func (r *GraphServiceSuspiciousIPRiskEventsCollectionRequest) Get(ctx context.Context) ([]SuspiciousIPRiskEvent, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for SuspiciousIPRiskEvent collection
func (r *GraphServiceSuspiciousIPRiskEventsCollectionRequest) Add(ctx context.Context, reqObj *SuspiciousIPRiskEvent) (resObj *SuspiciousIPRiskEvent, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// Teams returns request builder for Team collection
func (b *GraphServiceRequestBuilder) Teams() *GraphServiceTeamsCollectionRequestBuilder {
	bb := &GraphServiceTeamsCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/teams"
	return bb
}

// GraphServiceTeamsCollectionRequestBuilder is request builder for Team collection
type GraphServiceTeamsCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for Team collection
func (b *GraphServiceTeamsCollectionRequestBuilder) Request() *GraphServiceTeamsCollectionRequest {
	return &GraphServiceTeamsCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for Team item
func (b *GraphServiceTeamsCollectionRequestBuilder) ID(id string) *TeamRequestBuilder {
	bb := &TeamRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// GraphServiceTeamsCollectionRequest is request for Team collection
type GraphServiceTeamsCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for Team collection
func (r *GraphServiceTeamsCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]Team, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []Team
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []Team
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for Team collection, max N pages
func (r *GraphServiceTeamsCollectionRequest) GetN(ctx context.Context, n int) ([]Team, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for Team collection
func (r *GraphServiceTeamsCollectionRequest) Get(ctx context.Context) ([]Team, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for Team collection
func (r *GraphServiceTeamsCollectionRequest) Add(ctx context.Context, reqObj *Team) (resObj *Team, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// TeamsTemplates returns request builder for TeamsTemplate collection
func (b *GraphServiceRequestBuilder) TeamsTemplates() *GraphServiceTeamsTemplatesCollectionRequestBuilder {
	bb := &GraphServiceTeamsTemplatesCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/teamsTemplates"
	return bb
}

// GraphServiceTeamsTemplatesCollectionRequestBuilder is request builder for TeamsTemplate collection
type GraphServiceTeamsTemplatesCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for TeamsTemplate collection
func (b *GraphServiceTeamsTemplatesCollectionRequestBuilder) Request() *GraphServiceTeamsTemplatesCollectionRequest {
	return &GraphServiceTeamsTemplatesCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for TeamsTemplate item
func (b *GraphServiceTeamsTemplatesCollectionRequestBuilder) ID(id string) *TeamsTemplateRequestBuilder {
	bb := &TeamsTemplateRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// GraphServiceTeamsTemplatesCollectionRequest is request for TeamsTemplate collection
type GraphServiceTeamsTemplatesCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for TeamsTemplate collection
func (r *GraphServiceTeamsTemplatesCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]TeamsTemplate, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []TeamsTemplate
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []TeamsTemplate
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for TeamsTemplate collection, max N pages
func (r *GraphServiceTeamsTemplatesCollectionRequest) GetN(ctx context.Context, n int) ([]TeamsTemplate, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for TeamsTemplate collection
func (r *GraphServiceTeamsTemplatesCollectionRequest) Get(ctx context.Context) ([]TeamsTemplate, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for TeamsTemplate collection
func (r *GraphServiceTeamsTemplatesCollectionRequest) Add(ctx context.Context, reqObj *TeamsTemplate) (resObj *TeamsTemplate, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// UnfamiliarLocationRiskEvents returns request builder for UnfamiliarLocationRiskEvent collection
func (b *GraphServiceRequestBuilder) UnfamiliarLocationRiskEvents() *GraphServiceUnfamiliarLocationRiskEventsCollectionRequestBuilder {
	bb := &GraphServiceUnfamiliarLocationRiskEventsCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/unfamiliarLocationRiskEvents"
	return bb
}

// GraphServiceUnfamiliarLocationRiskEventsCollectionRequestBuilder is request builder for UnfamiliarLocationRiskEvent collection
type GraphServiceUnfamiliarLocationRiskEventsCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for UnfamiliarLocationRiskEvent collection
func (b *GraphServiceUnfamiliarLocationRiskEventsCollectionRequestBuilder) Request() *GraphServiceUnfamiliarLocationRiskEventsCollectionRequest {
	return &GraphServiceUnfamiliarLocationRiskEventsCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for UnfamiliarLocationRiskEvent item
func (b *GraphServiceUnfamiliarLocationRiskEventsCollectionRequestBuilder) ID(id string) *UnfamiliarLocationRiskEventRequestBuilder {
	bb := &UnfamiliarLocationRiskEventRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// GraphServiceUnfamiliarLocationRiskEventsCollectionRequest is request for UnfamiliarLocationRiskEvent collection
type GraphServiceUnfamiliarLocationRiskEventsCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for UnfamiliarLocationRiskEvent collection
func (r *GraphServiceUnfamiliarLocationRiskEventsCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]UnfamiliarLocationRiskEvent, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []UnfamiliarLocationRiskEvent
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []UnfamiliarLocationRiskEvent
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for UnfamiliarLocationRiskEvent collection, max N pages
func (r *GraphServiceUnfamiliarLocationRiskEventsCollectionRequest) GetN(ctx context.Context, n int) ([]UnfamiliarLocationRiskEvent, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for UnfamiliarLocationRiskEvent collection
func (r *GraphServiceUnfamiliarLocationRiskEventsCollectionRequest) Get(ctx context.Context) ([]UnfamiliarLocationRiskEvent, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for UnfamiliarLocationRiskEvent collection
func (r *GraphServiceUnfamiliarLocationRiskEventsCollectionRequest) Add(ctx context.Context, reqObj *UnfamiliarLocationRiskEvent) (resObj *UnfamiliarLocationRiskEvent, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// Users returns request builder for User collection
func (b *GraphServiceRequestBuilder) Users() *GraphServiceUsersCollectionRequestBuilder {
	bb := &GraphServiceUsersCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/users"
	return bb
}

// GraphServiceUsersCollectionRequestBuilder is request builder for User collection
type GraphServiceUsersCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for User collection
func (b *GraphServiceUsersCollectionRequestBuilder) Request() *GraphServiceUsersCollectionRequest {
	return &GraphServiceUsersCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for User item
func (b *GraphServiceUsersCollectionRequestBuilder) ID(id string) *UserRequestBuilder {
	bb := &UserRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// GraphServiceUsersCollectionRequest is request for User collection
type GraphServiceUsersCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for User collection
func (r *GraphServiceUsersCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]User, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []User
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []User
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for User collection, max N pages
func (r *GraphServiceUsersCollectionRequest) GetN(ctx context.Context, n int) ([]User, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for User collection
func (r *GraphServiceUsersCollectionRequest) Get(ctx context.Context) ([]User, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for User collection
func (r *GraphServiceUsersCollectionRequest) Add(ctx context.Context, reqObj *User) (resObj *User, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// Workbooks returns request builder for DriveItem collection
func (b *GraphServiceRequestBuilder) Workbooks() *GraphServiceWorkbooksCollectionRequestBuilder {
	bb := &GraphServiceWorkbooksCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/workbooks"
	return bb
}

// GraphServiceWorkbooksCollectionRequestBuilder is request builder for DriveItem collection
type GraphServiceWorkbooksCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for DriveItem collection
func (b *GraphServiceWorkbooksCollectionRequestBuilder) Request() *GraphServiceWorkbooksCollectionRequest {
	return &GraphServiceWorkbooksCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for DriveItem item
func (b *GraphServiceWorkbooksCollectionRequestBuilder) ID(id string) *DriveItemRequestBuilder {
	bb := &DriveItemRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// GraphServiceWorkbooksCollectionRequest is request for DriveItem collection
type GraphServiceWorkbooksCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for DriveItem collection
func (r *GraphServiceWorkbooksCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]DriveItem, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []DriveItem
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []DriveItem
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for DriveItem collection, max N pages
func (r *GraphServiceWorkbooksCollectionRequest) GetN(ctx context.Context, n int) ([]DriveItem, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for DriveItem collection
func (r *GraphServiceWorkbooksCollectionRequest) Get(ctx context.Context) ([]DriveItem, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for DriveItem collection
func (r *GraphServiceWorkbooksCollectionRequest) Add(ctx context.Context, reqObj *DriveItem) (resObj *DriveItem, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// Security is navigation property
func (b *GraphServiceRequestBuilder) Security() *SecurityRequestBuilder {
	bb := &SecurityRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/Security"
	return bb
}

// App is navigation property
func (b *GraphServiceRequestBuilder) App() *CommsApplicationRequestBuilder {
	bb := &CommsApplicationRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/app"
	return bb
}

// AppCatalogs is navigation property
func (b *GraphServiceRequestBuilder) AppCatalogs() *AppCatalogsRequestBuilder {
	bb := &AppCatalogsRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/appCatalogs"
	return bb
}

// AuditLogs is navigation property
func (b *GraphServiceRequestBuilder) AuditLogs() *AuditLogRootRequestBuilder {
	bb := &AuditLogRootRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/auditLogs"
	return bb
}

// Communications is navigation property
func (b *GraphServiceRequestBuilder) Communications() *CloudCommunicationsRequestBuilder {
	bb := &CloudCommunicationsRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/communications"
	return bb
}

// ConditionalAccess is navigation property
func (b *GraphServiceRequestBuilder) ConditionalAccess() *ConditionalAccessRootRequestBuilder {
	bb := &ConditionalAccessRootRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/conditionalAccess"
	return bb
}

// DataClassification is navigation property
func (b *GraphServiceRequestBuilder) DataClassification() *DataClassificationServiceRequestBuilder {
	bb := &DataClassificationServiceRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/dataClassification"
	return bb
}

// DeviceAppManagement is navigation property
func (b *GraphServiceRequestBuilder) DeviceAppManagement() *DeviceAppManagementRequestBuilder {
	bb := &DeviceAppManagementRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/deviceAppManagement"
	return bb
}

// DeviceManagement is navigation property
func (b *GraphServiceRequestBuilder) DeviceManagement() *DeviceManagementRequestBuilder {
	bb := &DeviceManagementRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/deviceManagement"
	return bb
}

// Directory is navigation property
func (b *GraphServiceRequestBuilder) Directory() *DirectoryRequestBuilder {
	bb := &DirectoryRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/directory"
	return bb
}

// Drive is navigation property
func (b *GraphServiceRequestBuilder) Drive() *DriveRequestBuilder {
	bb := &DriveRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/drive"
	return bb
}

// Education is navigation property
func (b *GraphServiceRequestBuilder) Education() *EducationRootRequestBuilder {
	bb := &EducationRootRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/education"
	return bb
}

// EntitlementManagement is navigation property
func (b *GraphServiceRequestBuilder) EntitlementManagement() *EntitlementManagementRequestBuilder {
	bb := &EntitlementManagementRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/entitlementManagement"
	return bb
}

// External is navigation property
func (b *GraphServiceRequestBuilder) External() *ExternalRequestBuilder {
	bb := &ExternalRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/external"
	return bb
}

// Financials is navigation property
func (b *GraphServiceRequestBuilder) Financials() *FinancialsRequestBuilder {
	bb := &FinancialsRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/financials"
	return bb
}

// Identity is navigation property
func (b *GraphServiceRequestBuilder) Identity() *IdentityContainerRequestBuilder {
	bb := &IdentityContainerRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/identity"
	return bb
}

// IdentityGovernance is navigation property
func (b *GraphServiceRequestBuilder) IdentityGovernance() *IdentityGovernanceRequestBuilder {
	bb := &IdentityGovernanceRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/identityGovernance"
	return bb
}

// InformationProtection is navigation property
func (b *GraphServiceRequestBuilder) InformationProtection() *InformationProtectionRequestBuilder {
	bb := &InformationProtectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/informationProtection"
	return bb
}

// Me is navigation property
func (b *GraphServiceRequestBuilder) Me() *UserRequestBuilder {
	bb := &UserRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/me"
	return bb
}

// OfficeConfiguration is navigation property
func (b *GraphServiceRequestBuilder) OfficeConfiguration() *OfficeConfigurationRequestBuilder {
	bb := &OfficeConfigurationRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/officeConfiguration"
	return bb
}

// Planner is navigation property
func (b *GraphServiceRequestBuilder) Planner() *PlannerRequestBuilder {
	bb := &PlannerRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/planner"
	return bb
}

// Reports is navigation property
func (b *GraphServiceRequestBuilder) Reports() *ReportRootRequestBuilder {
	bb := &ReportRootRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/reports"
	return bb
}

// RoleManagement is navigation property
func (b *GraphServiceRequestBuilder) RoleManagement() *RoleManagementRequestBuilder {
	bb := &RoleManagementRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/roleManagement"
	return bb
}

// Search is navigation property
func (b *GraphServiceRequestBuilder) Search() *SearchRequestBuilder {
	bb := &SearchRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/search"
	return bb
}

// Teamwork is navigation property
func (b *GraphServiceRequestBuilder) Teamwork() *TeamworkRequestBuilder {
	bb := &TeamworkRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/teamwork"
	return bb
}

// TrustFramework is navigation property
func (b *GraphServiceRequestBuilder) TrustFramework() *TrustFrameworkRequestBuilder {
	bb := &TrustFrameworkRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/trustFramework"
	return bb
}
