// Code generated by msgraph.go/gen DO NOT EDIT.

package msgraph

import "context"

// ConversationRequestBuilder is request builder for Conversation
type ConversationRequestBuilder struct{ BaseRequestBuilder }

// Request returns ConversationRequest
func (b *ConversationRequestBuilder) Request() *ConversationRequest {
	return &ConversationRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ConversationRequest is request for Conversation
type ConversationRequest struct{ BaseRequest }

// Get performs GET request for Conversation
func (r *ConversationRequest) Get(ctx context.Context) (resObj *Conversation, err error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	err = r.JSONRequest(ctx, "GET", query, nil, &resObj)
	return
}

// Update performs PATCH request for Conversation
func (r *ConversationRequest) Update(ctx context.Context, reqObj *Conversation) error {
	return r.JSONRequest(ctx, "PATCH", "", reqObj, nil)
}

// Delete performs DELETE request for Conversation
func (r *ConversationRequest) Delete(ctx context.Context) error {
	return r.JSONRequest(ctx, "DELETE", "", nil, nil)
}

// ConversationMemberRequestBuilder is request builder for ConversationMember
type ConversationMemberRequestBuilder struct{ BaseRequestBuilder }

// Request returns ConversationMemberRequest
func (b *ConversationMemberRequestBuilder) Request() *ConversationMemberRequest {
	return &ConversationMemberRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ConversationMemberRequest is request for ConversationMember
type ConversationMemberRequest struct{ BaseRequest }

// Get performs GET request for ConversationMember
func (r *ConversationMemberRequest) Get(ctx context.Context) (resObj *ConversationMember, err error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	err = r.JSONRequest(ctx, "GET", query, nil, &resObj)
	return
}

// Update performs PATCH request for ConversationMember
func (r *ConversationMemberRequest) Update(ctx context.Context, reqObj *ConversationMember) error {
	return r.JSONRequest(ctx, "PATCH", "", reqObj, nil)
}

// Delete performs DELETE request for ConversationMember
func (r *ConversationMemberRequest) Delete(ctx context.Context) error {
	return r.JSONRequest(ctx, "DELETE", "", nil, nil)
}

// ConversationThreadRequestBuilder is request builder for ConversationThread
type ConversationThreadRequestBuilder struct{ BaseRequestBuilder }

// Request returns ConversationThreadRequest
func (b *ConversationThreadRequestBuilder) Request() *ConversationThreadRequest {
	return &ConversationThreadRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ConversationThreadRequest is request for ConversationThread
type ConversationThreadRequest struct{ BaseRequest }

// Get performs GET request for ConversationThread
func (r *ConversationThreadRequest) Get(ctx context.Context) (resObj *ConversationThread, err error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	err = r.JSONRequest(ctx, "GET", query, nil, &resObj)
	return
}

// Update performs PATCH request for ConversationThread
func (r *ConversationThreadRequest) Update(ctx context.Context, reqObj *ConversationThread) error {
	return r.JSONRequest(ctx, "PATCH", "", reqObj, nil)
}

// Delete performs DELETE request for ConversationThread
func (r *ConversationThreadRequest) Delete(ctx context.Context) error {
	return r.JSONRequest(ctx, "DELETE", "", nil, nil)
}

//
type ConversationThreadReplyRequestBuilder struct{ BaseRequestBuilder }

// Reply action undocumented
func (b *ConversationThreadRequestBuilder) Reply(reqObj *ConversationThreadReplyRequestParameter) *ConversationThreadReplyRequestBuilder {
	bb := &ConversationThreadReplyRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/reply"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

//
type ConversationThreadReplyRequest struct{ BaseRequest }

//
func (b *ConversationThreadReplyRequestBuilder) Request() *ConversationThreadReplyRequest {
	return &ConversationThreadReplyRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client, requestObject: b.requestObject},
	}
}

//
func (r *ConversationThreadReplyRequest) Post(ctx context.Context) error {
	return r.JSONRequest(ctx, "POST", "", r.requestObject, nil)
}
