// Code generated by msgraph.go/gen DO NOT EDIT.

package msgraph

import (
	"context"
	"fmt"
	"io/ioutil"
	"net/http"

	"github.com/yaegashi/msgraph.go/jsonx"
)

// NotebookCollectionGetNotebookFromWebURLRequestParameter undocumented
type NotebookCollectionGetNotebookFromWebURLRequestParameter struct {
	// WebURL undocumented
	WebURL *string `json:"webUrl,omitempty"`
}

// NotebookCopyNotebookRequestParameter undocumented
type NotebookCopyNotebookRequestParameter struct {
	// GroupID undocumented
	GroupID *string `json:"groupId,omitempty"`
	// RenameAs undocumented
	RenameAs *string `json:"renameAs,omitempty"`
	// NotebookFolder undocumented
	NotebookFolder *string `json:"notebookFolder,omitempty"`
	// SiteCollectionID undocumented
	SiteCollectionID *string `json:"siteCollectionId,omitempty"`
	// SiteID undocumented
	SiteID *string `json:"siteId,omitempty"`
}

// SectionGroups returns request builder for SectionGroup collection
func (b *NotebookRequestBuilder) SectionGroups() *NotebookSectionGroupsCollectionRequestBuilder {
	bb := &NotebookSectionGroupsCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/sectionGroups"
	return bb
}

// NotebookSectionGroupsCollectionRequestBuilder is request builder for SectionGroup collection
type NotebookSectionGroupsCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for SectionGroup collection
func (b *NotebookSectionGroupsCollectionRequestBuilder) Request() *NotebookSectionGroupsCollectionRequest {
	return &NotebookSectionGroupsCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for SectionGroup item
func (b *NotebookSectionGroupsCollectionRequestBuilder) ID(id string) *SectionGroupRequestBuilder {
	bb := &SectionGroupRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// NotebookSectionGroupsCollectionRequest is request for SectionGroup collection
type NotebookSectionGroupsCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for SectionGroup collection
func (r *NotebookSectionGroupsCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]SectionGroup, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []SectionGroup
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []SectionGroup
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for SectionGroup collection, max N pages
func (r *NotebookSectionGroupsCollectionRequest) GetN(ctx context.Context, n int) ([]SectionGroup, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for SectionGroup collection
func (r *NotebookSectionGroupsCollectionRequest) Get(ctx context.Context) ([]SectionGroup, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for SectionGroup collection
func (r *NotebookSectionGroupsCollectionRequest) Add(ctx context.Context, reqObj *SectionGroup) (resObj *SectionGroup, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// Sections returns request builder for OnenoteSection collection
func (b *NotebookRequestBuilder) Sections() *NotebookSectionsCollectionRequestBuilder {
	bb := &NotebookSectionsCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/sections"
	return bb
}

// NotebookSectionsCollectionRequestBuilder is request builder for OnenoteSection collection
type NotebookSectionsCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for OnenoteSection collection
func (b *NotebookSectionsCollectionRequestBuilder) Request() *NotebookSectionsCollectionRequest {
	return &NotebookSectionsCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for OnenoteSection item
func (b *NotebookSectionsCollectionRequestBuilder) ID(id string) *OnenoteSectionRequestBuilder {
	bb := &OnenoteSectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// NotebookSectionsCollectionRequest is request for OnenoteSection collection
type NotebookSectionsCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for OnenoteSection collection
func (r *NotebookSectionsCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]OnenoteSection, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []OnenoteSection
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []OnenoteSection
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for OnenoteSection collection, max N pages
func (r *NotebookSectionsCollectionRequest) GetN(ctx context.Context, n int) ([]OnenoteSection, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for OnenoteSection collection
func (r *NotebookSectionsCollectionRequest) Get(ctx context.Context) ([]OnenoteSection, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for OnenoteSection collection
func (r *NotebookSectionsCollectionRequest) Add(ctx context.Context, reqObj *OnenoteSection) (resObj *OnenoteSection, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}
