// Code generated by msgraph.go/gen DO NOT EDIT.

package msgraph

import (
	"context"
	"fmt"
	"io/ioutil"
	"net/http"

	"github.com/yaegashi/msgraph.go/jsonx"
)

// IntuneBrandingProfileAssignRequestParameter undocumented
type IntuneBrandingProfileAssignRequestParameter struct {
	// Assignments undocumented
	Assignments []IntuneBrandingProfileAssignment `json:"assignments,omitempty"`
}

// Assignments returns request builder for IntuneBrandingProfileAssignment collection
func (b *IntuneBrandingProfileRequestBuilder) Assignments() *IntuneBrandingProfileAssignmentsCollectionRequestBuilder {
	bb := &IntuneBrandingProfileAssignmentsCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/assignments"
	return bb
}

// IntuneBrandingProfileAssignmentsCollectionRequestBuilder is request builder for IntuneBrandingProfileAssignment collection
type IntuneBrandingProfileAssignmentsCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for IntuneBrandingProfileAssignment collection
func (b *IntuneBrandingProfileAssignmentsCollectionRequestBuilder) Request() *IntuneBrandingProfileAssignmentsCollectionRequest {
	return &IntuneBrandingProfileAssignmentsCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for IntuneBrandingProfileAssignment item
func (b *IntuneBrandingProfileAssignmentsCollectionRequestBuilder) ID(id string) *IntuneBrandingProfileAssignmentRequestBuilder {
	bb := &IntuneBrandingProfileAssignmentRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// IntuneBrandingProfileAssignmentsCollectionRequest is request for IntuneBrandingProfileAssignment collection
type IntuneBrandingProfileAssignmentsCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for IntuneBrandingProfileAssignment collection
func (r *IntuneBrandingProfileAssignmentsCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]IntuneBrandingProfileAssignment, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []IntuneBrandingProfileAssignment
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []IntuneBrandingProfileAssignment
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for IntuneBrandingProfileAssignment collection, max N pages
func (r *IntuneBrandingProfileAssignmentsCollectionRequest) GetN(ctx context.Context, n int) ([]IntuneBrandingProfileAssignment, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for IntuneBrandingProfileAssignment collection
func (r *IntuneBrandingProfileAssignmentsCollectionRequest) Get(ctx context.Context) ([]IntuneBrandingProfileAssignment, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for IntuneBrandingProfileAssignment collection
func (r *IntuneBrandingProfileAssignmentsCollectionRequest) Add(ctx context.Context, reqObj *IntuneBrandingProfileAssignment) (resObj *IntuneBrandingProfileAssignment, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}
