// Code generated by msgraph.go/gen DO NOT EDIT.

package msgraph

// RoleAssignment The Role Assignment resource. Role assignments tie together a role definition with members and scopes. There can be one or more role assignments per role. This applies to custom and built-in roles.
type RoleAssignment struct {
	// Entity is the base model of RoleAssignment
	Entity
	// DisplayName The display or friendly name of the role Assignment.
	DisplayName *string `json:"displayName,omitempty"`
	// Description Description of the Role Assignment.
	Description *string `json:"description,omitempty"`
	// ScopeMembers List of ids of role scope member security groups.  These are IDs from Azure Active Directory.
	ScopeMembers []string `json:"scopeMembers,omitempty"`
	// ScopeType Specifies the type of scope for a Role Assignment. Default type 'ResourceScope' allows assignment of ResourceScopes. For 'AllDevices', 'AllLicensedUsers', and 'AllDevicesAndLicensedUsers', the ResourceScopes property should be left empty.
	ScopeType *RoleAssignmentScopeType `json:"scopeType,omitempty"`
	// ResourceScopes List of ids of role scope member security groups.  These are IDs from Azure Active Directory.
	ResourceScopes []string `json:"resourceScopes,omitempty"`
	// RoleDefinition undocumented
	RoleDefinition *RoleDefinition `json:"roleDefinition,omitempty"`
}

// RoleDefinition The Role Definition resource. The role definition is the foundation of role based access in Intune. The role combines an Intune resource such as a Mobile App and associated role permissions such as Create or Read for the resource. There are two types of roles, built-in and custom. Built-in roles cannot be modified. Both built-in roles and custom roles must have assignments to be enforced. Create custom roles if you want to define a role that allows any of the available resources and role permissions to be combined into a single role.
type RoleDefinition struct {
	// Entity is the base model of RoleDefinition
	Entity
	// DisplayName Display Name of the Role definition.
	DisplayName *string `json:"displayName,omitempty"`
	// Description Description of the Role definition.
	Description *string `json:"description,omitempty"`
	// Permissions List of Role Permissions this role is allowed to perform. These must match the actionName that is defined as part of the rolePermission.
	Permissions []RolePermission `json:"permissions,omitempty"`
	// RolePermissions List of Role Permissions this role is allowed to perform. These must match the actionName that is defined as part of the rolePermission.
	RolePermissions []RolePermission `json:"rolePermissions,omitempty"`
	// IsBuiltInRoleDefinition Type of Role. Set to True if it is built-in, or set to False if it is a custom role definition.
	IsBuiltInRoleDefinition *bool `json:"isBuiltInRoleDefinition,omitempty"`
	// IsBuiltIn Type of Role. Set to True if it is built-in, or set to False if it is a custom role definition.
	IsBuiltIn *bool `json:"isBuiltIn,omitempty"`
	// RoleScopeTagIDs List of Scope Tags for this Entity instance.
	RoleScopeTagIDs []string `json:"roleScopeTagIds,omitempty"`
	// RoleAssignments undocumented
	RoleAssignments []RoleAssignment `json:"roleAssignments,omitempty"`
}

// RoleManagement undocumented
type RoleManagement struct {
	// Entity is the base model of RoleManagement
	Entity
	// Directory undocumented
	Directory *RbacApplication `json:"directory,omitempty"`
}

// RoleMembershipGovernanceCriteria undocumented
type RoleMembershipGovernanceCriteria struct {
	// GovernanceCriteria is the base model of RoleMembershipGovernanceCriteria
	GovernanceCriteria
	// RoleID undocumented
	RoleID *string `json:"roleId,omitempty"`
	// RoleTemplateID undocumented
	RoleTemplateID *string `json:"roleTemplateId,omitempty"`
}

// RolePermission undocumented
type RolePermission struct {
	// Object is the base model of RolePermission
	Object
	// Actions Allowed Actions - Deprecated
	Actions []string `json:"actions,omitempty"`
	// ResourceActions Resource Actions each containing a set of allowed and not allowed permissions.
	ResourceActions []ResourceAction `json:"resourceActions,omitempty"`
}

// RoleScopeTag Role Scope Tag
type RoleScopeTag struct {
	// Entity is the base model of RoleScopeTag
	Entity
	// DisplayName The display or friendly name of the Role Scope Tag.
	DisplayName *string `json:"displayName,omitempty"`
	// Description Description of the Role Scope Tag.
	Description *string `json:"description,omitempty"`
	// IsBuiltIn Description of the Role Scope Tag.
	IsBuiltIn *bool `json:"isBuiltIn,omitempty"`
	// Assignments undocumented
	Assignments []RoleScopeTagAutoAssignment `json:"assignments,omitempty"`
}

// RoleScopeTagAutoAssignment Contains the properties for auto-assigning a Role Scope Tag to a group to be applied to Devices.
type RoleScopeTagAutoAssignment struct {
	// Entity is the base model of RoleScopeTagAutoAssignment
	Entity
	// Target The auto-assignment target for the specific Role Scope Tag.
	Target *DeviceAndAppManagementAssignmentTarget `json:"target,omitempty"`
}

// RoleScopeTagInfo undocumented
type RoleScopeTagInfo struct {
	// Object is the base model of RoleScopeTagInfo
	Object
	// DisplayName Scope Tag Display name.
	DisplayName *string `json:"displayName,omitempty"`
	// RoleScopeTagID Scope Tag Id.
	RoleScopeTagID *string `json:"roleScopeTagId,omitempty"`
}

// RoleSuccessStatistics undocumented
type RoleSuccessStatistics struct {
	// Object is the base model of RoleSuccessStatistics
	Object
	// RoleID undocumented
	RoleID *string `json:"roleId,omitempty"`
	// RoleName undocumented
	RoleName *string `json:"roleName,omitempty"`
	// TemporarySuccess undocumented
	TemporarySuccess *int `json:"temporarySuccess,omitempty"`
	// TemporaryFail undocumented
	TemporaryFail *int `json:"temporaryFail,omitempty"`
	// PermanentSuccess undocumented
	PermanentSuccess *int `json:"permanentSuccess,omitempty"`
	// PermanentFail undocumented
	PermanentFail *int `json:"permanentFail,omitempty"`
	// RemoveSuccess undocumented
	RemoveSuccess *int `json:"removeSuccess,omitempty"`
	// RemoveFail undocumented
	RemoveFail *int `json:"removeFail,omitempty"`
	// UnknownFail undocumented
	UnknownFail *int `json:"unknownFail,omitempty"`
}
