# Verifiable Publish and Import

## Encrypting instance archives

`alpine publish <instance name>` creates a `.tar.gz` archive of the filesystem and configurations of an instance. These archives can be used for backup or sharing
purposes.

If instances are published for sharing, it may be desirable to authenticate them using strong cryptography. This allows for verifiable publishing and importing of
instances over untrusted channels such as the internet or shared storage. It also allows for encrypted backups of sensitive instances.

* `alpine publish -e <instance name>` / `alpine publish --encrypt <instance name>`: encrypt and authenticate archive with key derived from a passphrase (interactive prompt)

To provide this functionality, `macpine` uses [`age`](https://github.com/FiloSottile/age), a modern, efficient, and vetted Go implementation of strong cryptographic
tools which enable authenticated encryption of files.

### Encrypting with a password

```bash
$ alpine list
NAME       STATUS      SSH    PORTS         ARCH        PID       TAGS
devel      Stopped     22                   aarch64     -         daemon,dev
$ alpine publish -e devel                                        # publish instance `devel` with password
Enter passphrase (leave empty to autogenerate a secure one): [return]
age: using autogenerated passphrase "better-avocado-regret-marriage-acoustic-beyond-search-record-drum-shadow"
$ ls devel.tar.gz.age                                            # encrypted archive is created
devel.tar.gz.age
$ alpine delete devel
$ alpine list
NAME       STATUS      SSH    PORTS         ARCH        PID       TAGS
$ alpine import devel.tar.gz.age                                 # import requires the corresponding private key
Enter passphrase: better-avocado-regret-marriage-acoustic-beyond-search-record-drum-shadow
$ alpine list
NAME       STATUS      SSH    PORTS         ARCH        PID       TAGS
devel      Stopped     22                   aarch64     -         daemon,dev
```

### Further information

For the details of `age`, such as the [`age` file format](https://github.com/C2SP/C2SP/blob/main/age.md), refer to the documentation of the project.

`age` also supports asymmetric cryptography, encrypting & signing using `age` public keys or even `ssh` keys. In order to share a `macpine`
instance (e.g. `example-instance`) to a GitHub user (e.g. `example-user`) with the `ssh` keys listed in their profile:

```bash
brew install age
curl -s https://github.com/example-user.keys | head -n1 > example-user.pub
alpine publish example-instance
age -e -o example-instance.tar.gz.age -R example-user.pub example-instance.tar.gz
# example-instance.tar.gz.age can be decrypted with example-user's private key
```

Note that `ssh` keys are generally used for authentication rather than long-term encryption and therefore may not be kept private. This
approach should be used only if this caveat can be considered an acceptable risk.
