/*
 * Decompiled with CFR 0.152.
 */
package org.lionsoul.ip2region;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.LinkedList;
import org.lionsoul.ip2region.DataBlock;
import org.lionsoul.ip2region.DbConfig;
import org.lionsoul.ip2region.DbMakerConfigException;
import org.lionsoul.ip2region.HeaderBlock;
import org.lionsoul.ip2region.IndexBlock;
import org.lionsoul.ip2region.Util;

public class DbMaker {
    private DbConfig dbConfig;
    private File ipSrcFile;
    private LinkedList<IndexBlock> indexPool;
    private LinkedList<HeaderBlock> headerPool;
    private File globalRegionFile = null;
    private HashMap<String, Integer> globalRegionMap = null;
    private HashMap<String, DataBlock> regionPtrPool = null;

    public DbMaker(DbConfig dbConfig, String string, String string2) throws DbMakerConfigException, IOException {
        this.dbConfig = dbConfig;
        this.ipSrcFile = new File(string);
        this.globalRegionMap = new HashMap();
        this.regionPtrPool = new HashMap();
        if (string2 != null) {
            this.globalRegionFile = new File(string2);
        }
        if (!this.ipSrcFile.exists()) {
            throw new IOException("Error: Invalid file path " + string);
        }
    }

    private void initDbFile(RandomAccessFile randomAccessFile) throws IOException {
        randomAccessFile.seek(0L);
        randomAccessFile.write(new byte[8]);
        randomAccessFile.write(new byte[this.dbConfig.getTotalHeaderSize()]);
        this.headerPool = new LinkedList();
        this.indexPool = new LinkedList();
    }

    public void make(String string) throws IOException {
        Object object2;
        Object object3;
        BufferedReader bufferedReader;
        if (this.globalRegionFile != null) {
            System.out.println("+-Try to load the global region data ...");
            bufferedReader = new BufferedReader(new FileReader(this.globalRegionFile));
            object3 = null;
            while ((object3 = bufferedReader.readLine()) != null) {
                object2 = ((String)object3).split(",");
                if (((String[])object2).length != 5) continue;
                this.globalRegionMap.put(object2[2], Integer.valueOf((String)object2[0]));
            }
            bufferedReader.close();
            System.out.println("|--[Ok]");
        }
        bufferedReader = new BufferedReader(new FileReader(this.ipSrcFile));
        object3 = new RandomAccessFile(string, "rw");
        this.initDbFile((RandomAccessFile)object3);
        System.out.println("+-Db file initialized.");
        System.out.println("+-Try to write the data blocks ... ");
        object2 = null;
        while ((object2 = bufferedReader.readLine()) != null) {
            if (((String)(object2 = ((String)object2).trim())).length() == 0 || ((String)object2).charAt(0) == '#') continue;
            int n = 0;
            int n2 = 0;
            n2 = ((String)object2).indexOf(124, n + 1);
            if (n2 == -1) continue;
            String string2 = ((String)object2).substring(n, n2);
            n = n2 + 1;
            if ((n2 = ((String)object2).indexOf(124, n + 1)) == -1) continue;
            String string3 = ((String)object2).substring(n, n2);
            n = n2 + 1;
            String string4 = ((String)object2).substring(n);
            System.out.println("+-Try to process item " + (String)object2);
            this.addDataBlock((RandomAccessFile)object3, string2, string3, string4);
            System.out.println("|--[Ok]");
        }
        System.out.println("|--Data block flushed!");
        System.out.println("|--Data file pointer: " + ((RandomAccessFile)object3).getFilePointer() + "\n");
        System.out.println("+-Try to write index blocks ... ");
        IndexBlock indexBlock22 = null;
        HeaderBlock headerBlock = null;
        indexBlock22 = this.indexPool.getFirst();
        long l = indexBlock22.getStartIp();
        long l2 = ((RandomAccessFile)object3).getFilePointer();
        this.headerPool.add(new HeaderBlock(l, (int)l2));
        int n = IndexBlock.getIndexBlockLength();
        int n3 = 0;
        int n4 = this.dbConfig.getIndexBlockSize() / n - 1;
        for (IndexBlock indexBlock22 : this.indexPool) {
            if (++n3 >= n4) {
                headerBlock = new HeaderBlock(indexBlock22.getStartIp(), (int)((RandomAccessFile)object3).getFilePointer());
                this.headerPool.add(headerBlock);
                n3 = 0;
            }
            ((RandomAccessFile)object3).write(indexBlock22.getBytes());
        }
        if (n3 > 0) {
            indexBlock22 = this.indexPool.getLast();
            headerBlock = new HeaderBlock(indexBlock22.getStartIp(), (int)((RandomAccessFile)object3).getFilePointer() - IndexBlock.getIndexBlockLength());
            this.headerPool.add(headerBlock);
        }
        long l3 = ((RandomAccessFile)object3).getFilePointer();
        System.out.println("|--[Ok]");
        System.out.println("+-Try to write the super blocks ... ");
        ((RandomAccessFile)object3).seek(0L);
        byte[] byArray = new byte[8];
        Util.writeIntLong(byArray, 0, l2);
        Util.writeIntLong(byArray, 4, l3 - (long)n);
        ((RandomAccessFile)object3).write(byArray);
        System.out.println("|--[Ok]");
        System.out.println("+-Try to write the header blocks ... ");
        for (HeaderBlock object4 : this.headerPool) {
            ((RandomAccessFile)object3).write(object4.getBytes());
        }
        System.out.println("+-Try to write the copyright and release date info ... ");
        ((RandomAccessFile)object3).seek(((RandomAccessFile)object3).length());
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy/MM/dd");
        String string2 = "Created by lionsoul at " + simpleDateFormat.format(calendar.getTime());
        ((RandomAccessFile)object3).write((int)(calendar.getTime().getTime() / 1000L));
        ((RandomAccessFile)object3).write(string2.getBytes());
        System.out.println("|--[Ok]");
        bufferedReader.close();
        ((RandomAccessFile)object3).close();
    }

    private void addDataBlock(RandomAccessFile randomAccessFile, String string, String string2, String string3) {
        try {
            Object object;
            byte[] byArray = string3.getBytes("UTF-8");
            int n = 0;
            if (this.regionPtrPool.containsKey(string3)) {
                object = this.regionPtrPool.get(string3);
                n = ((DataBlock)object).getDataPtr();
                System.out.println("dataPtr: " + n + ", region: " + string3);
            } else {
                object = new byte[4];
                int n2 = this.getCityId(string3);
                Util.writeIntLong((byte[])object, 0, n2);
                n = (int)randomAccessFile.getFilePointer();
                randomAccessFile.write((byte[])object);
                randomAccessFile.write(byArray);
                this.regionPtrPool.put(string3, new DataBlock(n2, string3, n));
            }
            object = new IndexBlock(Util.ip2long(string), Util.ip2long(string2), n, byArray.length + 4);
            this.indexPool.add((IndexBlock)object);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public int getCityId(String string) {
        String[] stringArray = string.split("\\|");
        if (stringArray.length != 5) {
            return 0;
        }
        String string2 = null;
        Integer n = null;
        for (int i = 3; i >= 0; --i) {
            if (stringArray[i].equals("0")) continue;
            string2 = i == 3 && stringArray[i].indexOf("\u7701\u76f4\u8f96\u53bf\u7ea7") > -1 ? stringArray[2] + stringArray[3] : stringArray[i];
            n = this.globalRegionMap.get(string2);
            if (n == null) {
                return 0;
            }
            return n;
        }
        return 0;
    }

    public DbConfig getDbConfig() {
        return this.dbConfig;
    }

    public DbMaker setDbConfig(DbConfig dbConfig) {
        this.dbConfig = dbConfig;
        return this;
    }

    public File getIpSrcFile() {
        return this.ipSrcFile;
    }

    public DbMaker setIpSrcFile(File file) {
        this.ipSrcFile = file;
        return this;
    }

    public static void main(String[] stringArray) {
        int n;
        String string = "./data/";
        String[] stringArray2 = new String[]{null, null};
        for (n = 0; n < stringArray.length; ++n) {
            if (stringArray[n].equals("-src")) {
                stringArray2[0] = stringArray[++n];
                continue;
            }
            if (stringArray[n].equals("-region")) {
                stringArray2[1] = stringArray[++n];
                continue;
            }
            if (!stringArray[n].equals("-dst")) continue;
            string = stringArray[++n];
        }
        for (n = 0; n < stringArray2.length; ++n) {
            if (stringArray2[n] != null) continue;
            System.out.println("Usage: java -jar dbMaker.jar -src [source text file path] -region [global region file path]");
            System.out.println("eg: java -jar dbMaker.jar -src ./data/ip.merge.txt -region ./data/origin/global_region.csv");
            System.exit(0);
        }
        if (!string.endsWith("/")) {
            string = string + "/";
        }
        try {
            DbConfig dbConfig = new DbConfig();
            DbMaker dbMaker = new DbMaker(dbConfig, stringArray2[0], stringArray2[1]);
            dbMaker.make(string + "ip2region.db");
        }
        catch (DbMakerConfigException dbMakerConfigException) {
            dbMakerConfigException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

