// Copyright 2023 The Libc Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

//go:generate go run generator.go

//TODO
// # POSIX pthreads
//
// A TLS instance represents a main thread or a thread created by
// Xpthread_create. A TLS instance is not safe for concurrent use by multiple
// goroutines.
//
// If a program starts the C main function, a TLS instance is created
// automatically and the goroutine entering main() is locked to the OS thread.
// The translated C code then may create other pthreads by calling
// Xpthread_create.
//
// If the translated C code is part of a library package, new TLS instances
// must be created manually in user/client code. The first TLS instance created
// will be the "main" libc thread, but it will be not locked to OS thread
// automatically. Any subsequently manually created TLS instances will call
// Xpthread_create, but without spawning a new goroutine.
//
// A manual call to Xpthread_create will create a new TLS instance automatically
// and spawn a new goroutine executing the thread function.

// Package libc provides run time support for programs generated by the
// [ccgo] C to Go transpiler, version 4 or later.
//
// # Concurrency
//
// Many C libc functions are not thread safe. Such functions are not safe
// for concurrent use by multiple goroutines in the Go translation as well.
//
// # Thread Local Storage
//
// C threads are modeled as Go goroutines.  Every such C thread, ie. a Go
// goroutine, must use its own Thread Local Storage instance implemented by the
// [TLS] type.
//
// # Signals
//
// Signal handling in translated C code is not coordinated with the Go runtime.
// This is probably the same as when running C code via CGo.
//
// # Environmental variables
//
// This package synchronizes its environ with the current Go environ only once,
// when the first TLS instance is created.
//
// # libc API documentation copyright
//
// From [Linux man-pages Copyleft]
//
//	Permission is granted to make and distribute verbatim copies of this
//	manual provided the copyright notice and this permission notice are
//	preserved on all copies.
//
//	Permission is granted to copy and distribute modified versions of this
//	manual under the conditions for verbatim copying, provided that the
//	entire resulting derived work is distributed under the terms of a
//	permission notice identical to this one.
//
//	Since the Linux kernel and libraries are constantly changing, this
//	manual page may be incorrect or out-of-date. The author(s) assume no
//	responsibility for errors or omissions, or for damages resulting from
//	the use of the information contained herein. The author(s) may not have
//	taken the same level of care in the production of this manual, which is
//	licensed free of charge, as they might when working professionally.
//
//	Formatted or processed versions of this manual, if unaccompanied by the
//	source, must acknowledge the copyright and authors of this work.
//
// [Linux man-pages Copyleft]: https://spdx.org/licenses/Linux-man-pages-copyleft.html
// [ccgo]: http://modernc.org/ccgo/v4
package libc // import "modernc.org/libc/v2"

//TODO fix abort(): ->tid
