package i18n

const russianIntroPopupMessage = `
Благодарю за использование lazygit! Серьёзно, вы просто супер. Три вещи, которыми я хочу поделиться:

 1) Чтобы узнать о возможностях lazygit, посмотрите это видео:
      https://youtu.be/CPLdltN7wgE

 2) Обязательно ознакомьтесь с последними примечаниями к выпуску перейдя по ссылке:
      https://github.com/jesseduffield/lazygit/releases

 3) Используете git? Значит Вы программист! С Вашей помощью мы можем сделать lazygit лучше,
    станьте участником и присоединиться к веселью в
      https://github.com/jesseduffield/lazygit
    Вы также можете поддержать меня и рассказать, над чем мне ещё стоит поработать,
    нажав на кнопку "Поддержать" в правом нижнем углу.
    Или поделиться любовь просто добавив репозиторий в избранные.
`

const russianDeprecatedEditConfigWarning = `
### Предупреждение об устаревшей конфигурации ###

Следующие параметры конфигурации устарели и будут удалены в будущей
версии:
{{configs}}

Пожалуйста, ознакомьтесь с

  https://github.com/jesseduffield/lazygit/blob/master/docs/Config.md#configuring-file-editing

для получения актуальной информации о том, как настроить ваш редактор.

`

// exporting this so we can use it in tests
func RussianTranslationSet() TranslationSet {
	return TranslationSet{
		NotEnoughSpace:                      "Недостаточно места для отрисовки панелей",
		DiffTitle:                           "Сравнения",
		FilesTitle:                          "Файлы",
		BranchesTitle:                       "Ветки",
		CommitsTitle:                        "Коммиты",
		StashTitle:                          "Хранилище",
		SnakeTitle:                          "Змейка",
		EasterEgg:                           "Пасхалка",
		UnstagedChanges:                     `Непроиндексированные Изменения`,
		StagedChanges:                       `Проиндексированные Изменения`,
		MainTitle:                           "Главная",
		MergeConfirmTitle:                   "Слияние",
		StagingTitle:                        "Главная панель (Индексирование)",
		MergingTitle:                        "Главная панель (Слияние)",
		NormalTitle:                         "Главная панель (Обычный)",
		LogTitle:                            "Журнал",
		CommitSummary:                       "Сводка коммита",
		CredentialsUsername:                 "Имя пользователя",
		CredentialsPassword:                 "Пароль",
		CredentialsPassphrase:               "Введите пароль для SSH ключа",
		CredentialsPIN:                      "Введите PIN-код для SSH ключа",
		PassUnameWrong:                      "Неверный пароль, кодовая фраза и/или имя пользователя",
		CommitChanges:                       "Сохранить изменения",
		AmendLastCommit:                     "Правка последнего коммита",
		AmendLastCommitTitle:                "Правка Последнего Коммита",
		SureToAmend:                         "Вы уверены, что хотите править последний коммит? Впоследствии можно изменить сообщение коммита на панели коммитов.",
		NoCommitToAmend:                     "Не найден коммит для внесения поправок.",
		CommitChangesWithEditor:             "Сохранить изменения с помощью редактора git",
		StatusTitle:                         "Статус",
		Menu:                                "Меню",
		Execute:                             "Выполнить",
		ToggleStaged:                        "Переключить индекс",
		ToggleStagedAll:                     "Все проиндексированные/непроиндексированные",
		ToggleTreeView:                      "Переключить вид дерева файлов",
		OpenMergeTool:                       "Открыть внешний инструмент слияния (git mergetool)",
		Refresh:                             "Обновить",
		Push:                                "Отправить изменения",
		Pull:                                "Получить и слить изменения",
		Scroll:                              "Прокрутить",
		MergeConflictsTitle:                 "Конфликты Слияния",
		Checkout:                            "Переключить",
		FileFilter:                          "Фильтровать файлы (проиндексированные/непроиндексированные)",
		FilterStagedFiles:                   "Показывать только проиндексированные файлы",
		FilterUnstagedFiles:                 "Показывать только непроиндексированные файлы",
		ResetFilter:                         "Сбросить фильтр",
		NoChangedFiles:                      "Нет изменённых файлов",
		PullWait:                            "Получение и слияние изменении...",
		PushWait:                            "Отправка изменении...",
		FetchWait:                           "Получение изменении...",
		SoftReset:                           "Мягкий сброс",
		AlreadyCheckedOutBranch:             "Вы уже переключились в эту ветку",
		SureForceCheckout:                   "Вы уверены, что хотите принудительная переключить? Вы потеряете все локальные изменения",
		ForceCheckoutBranch:                 "Принудительное Переключение Ветки",
		BranchName:                          "Название ветки",
		NewBranchNameBranchOff:              "Название новой ветки (Ветка с '{{.branchName}}')",
		CantDeleteCheckOutBranch:            "Невозможно удалить переключённую ветку!",
		DeleteBranch:                        "Удалить ветку",
		DeleteBranchMessage:                 "Вы уверены, что хотите удалить ветку '{{.selectedBranchName}}'?",
		ForceDeleteBranchMessage:            "'{{.selectedBranchName}}' не полностью слилась. Вы уверены, что хотите удалить его?",
		RebaseBranch:                        "Перебазировать переключённую ветку на эту ветку",
		CantRebaseOntoSelf:                  "Невозможно перебазировать ветку на себя",
		CantMergeBranchIntoItself:           "Невозможно объединить ветку в себя",
		ForceCheckout:                       "Принудительное переключение",
		CheckoutByName:                      "Переключить по названию",
		NewBranch:                           "Новая ветка",
		NoBranchesThisRepo:                  "Нет веток для этого репозитория",
		CommitWithoutMessageErr:             "Вы не можете сохранить изменения без сообщения коммита",
		Close:                               "Закрыть",
		CloseCancel:                         "Закрыть/отменить",
		Confirm:                             "Подтвердить",
		Quit:                                "Выйти",
		SquashDown:                          "Объединить несколько коммитов в один нижний",
		FixupCommit:                         "Объединить несколько коммитов в один отбросив сообщение коммита",
		NoCommitsThisBranch:                 "Нет коммитов для этой ветки",
		UpdateRefHere:                       "Обновить ветку '{{.ref}}' здесь",
		CannotSquashOrFixupFirstCommit:      "Ниже нет коммита, который можно было бы объединить",
		Fixup:                               "Объединить несколько коммитов в один отбросив сообщение коммита (Fixup) ",
		SureFixupThisCommit:                 "Вы уверены, что хотите объединить несколько коммитов, отбросив сообщение коммита? Он будет объединён с коммитом ниже",
		SureSquashThisCommit:                "Вы уверены, что хотите объединить несколько коммитов в нижний коммит?",
		Squash:                              "Объединить коммиты (Squash)",
		PickCommit:                          "Выбрать коммит (в середине перебазирования)",
		RevertCommit:                        "Отменить коммит",
		RewordCommit:                        "Перефразировать коммит",
		DeleteCommit:                        "Удалить коммит",
		MoveDownCommit:                      "Переместить коммит вниз на один",
		MoveUpCommit:                        "Переместить коммит вверх на один",
		EditCommit:                          "Изменить коммит",
		AmendToCommit:                       "Править последний коммит с проиндексированными изменениями",
		ResetAuthor:                         "Сброс автора коммита",
		SetAuthor:                           "Установить автора",
		SetResetCommitAuthor:                "Установить/убрать автора коммита",
		SetAuthorPromptTitle:                "Установить автора (должно выглядеть как «Имя <Email>»)",
		SureResetCommitAuthor:               "Поле автора этого автора будет обновлено в соответствии с настроенным пользователем. Это также обновляет временную метку автора. Продолжить?",
		RenameCommitEditor:                  "Переписать коммит с помощью редактора",
		Error:                               "Ошибка",
		PickHunk:                            "Выбрать эту часть",
		PickAllHunks:                        "Выбрать все части",
		Undo:                                "Отменить",
		UndoReflog:                          "Отменить (через reflog) (экспериментальный)",
		RedoReflog:                          "Повторить (через reflog) (экспериментальный)",
		UndoTooltip:                         "Журнал ссылок (reflog) будет использоваться для определения того, какую команду git запустить, чтобы отменить последнюю команду git. Сюда не входят изменения в рабочем дереве; учитываются только коммиты.",
		RedoTooltip:                         "Журнал ссылок (reflog) будет использоваться для определения того, какую команду git нужно запустить, чтобы повторить последнюю команду git. Сюда не входят изменения в рабочем дереве; учитываются только коммиты.",
		DiscardAllTooltip:                   "Отменить проиндексированные и непроиндексированные изменения в '{{.path}}'.",
		DiscardUnstagedTooltip:              "Отменить непроиндексированные изменения в '{{.path}}'.",
		Pop:                                 "Применить припрятанные изменения и тут же удалить их из хранилища",
		Drop:                                "Удалить припрятанные изменения из хранилища",
		Apply:                               "Применить припрятанные изменения",
		NoStashEntries:                      "Нет записей в хранилище",
		StashDrop:                           "Сбросить хранилище",
		SureDropStashEntry:                  "Вы уверены, что хотите удалить эту запись хранилища?",
		StashPop:                            "Применить припрятанные изменения и тут же удалить их из хранилища",
		SurePopStashEntry:                   "Вы уверены, что хотите применить эти припрятанные изменения и тут же удалить их из хранилища?",
		StashApply:                          "Применить припрятанные изменения",
		SureApplyStashEntry:                 "Вы уверены, что хотите применить эти припрятанные изменения?",
		NoTrackedStagedFilesStash:           "У вас нет отслеженных/проиндексированных файлов для хранения",
		NoFilesToStash:                      "У вас нет файлов для хранения",
		StashChanges:                        "Припрятать изменения",
		RenameStash:                         "Переименовать хранилище",
		RenameStashPrompt:                   "Переименовать хранилище: {{.stashName}}",
		OpenConfig:                          "Открыть файл конфигурации",
		EditConfig:                          "Редактировать файл конфигурации",
		ForcePush:                           "Принудительная отправка изменении",
		ForcePushPrompt:                     "Ветка отклонилась от удалённой ветки. Нажмите «esc», чтобы отменить, или «enter», чтобы начать принудительную отправку изменении.",
		ForcePushDisabled:                   "Ветка отклонилась от удалённой ветки. Принудительная отправка изменении была отключена",
		UpdatesRejectedAndForcePushDisabled: "Обновления были отклонены. Принудительная отправка изменении была отключена",
		CheckForUpdate:                      "Проверить обновления",
		CheckingForUpdates:                  "Проверка обновлений...",
		UpdateAvailableTitle:                "Доступно обновление!",
		UpdateAvailable:                     "Скачать и установить версию {{.newVersion}}?",
		UpdateInProgressWaitingStatus:       "Обновление",
		UpdateCompletedTitle:                "Обновление завершено!",
		UpdateCompleted:                     "Обновление успешно установлено. Перезапустите lazygit, чтобы обновление вступило в силу.",
		FailedToRetrieveLatestVersionErr:    "Не удалось получить информацию о версии",
		OnLatestVersionErr:                  "Установлена последняя версия",
		MajorVersionErr:                     "Новая версия ({{.newVersion}}) содержит несовместимые с предыдущими версии изменения по сравнению с текущей версией ({{.currentVersion}})",
		CouldNotFindBinaryErr:               "Не удалось найти бинарный файл на {{.url}}",
		UpdateFailedErr:                     "Не удалось обновить: {{.errMessage}}",
		ConfirmQuitDuringUpdateTitle:        "Идёт Обновление",
		ConfirmQuitDuringUpdate:             "Выполняется обновление. Вы уверены, что хотите выйти?",
		MergeToolTitle:                      "Инструмент слияния",
		MergeToolPrompt:                     "Вы уверены, что хотите открыть `git mergetool`?",
		IntroPopupMessage:                   russianIntroPopupMessage,
		DeprecatedEditConfigWarning:         russianDeprecatedEditConfigWarning,
		GitconfigParseErr:                   `Gogit не удалось проанализировать ваш файл gitconfig из-за наличия символов «\» без кавычек. Их удаление должно решить проблему.`,
		EditFile:                            `Редактировать файл`,
		OpenFile:                            `Открыть файл`,
		IgnoreFile:                          `Добавить в .gitignore`,
		ExcludeFile:                         `Добавить в .git/info/exclude`,
		RefreshFiles:                        `Обновить файлы`,
		MergeIntoCurrentBranch:              `Слияние с текущей переключённой веткой`,
		ConfirmQuit:                         `Вы уверены, что хотите выйти?`,
		SwitchRepo:                          `Переключиться на последний репозиторий`,
		AllBranchesLogGraph:                 `Показать все логи ветки`,
		UnsupportedGitService:               `Неподдерживаемая служба git`,
		CreatePullRequest:                   `Создать запрос на принятие изменений`,
		CopyPullRequestURL:                  `Скопировать URL запроса на принятие изменений в буфер обмена`,
		NoBranchOnRemote:                    `Этой ветки не существует в удалённом репозитории. Сначала вам нужно его отправить в удалённый репозитории.`,
		Fetch:                               `Получить изменения`,
		NoAutomaticGitFetchTitle:            `Нет автоматического получения изменении`,
		NoAutomaticGitFetchBody:             `Lazygit не может использовать «git fetch» в приватном репозитории; используйте «f» на панели файлов, чтобы запустить «git fetch» вручную`,
		FileEnter:                           `Проиндексировать отдельные части/строки для файла или свернуть/развернуть для каталога`,
		FileStagingRequirements:             `Можно проиндексировать только отдельные строки для отслеживаемых файлов`,
		StageSelection:                      `Переключить строку в проиндексированные / непроиндексированные`,
		DiscardSelection:                    `Отменить изменение (git reset)`,
		ToggleDragSelect:                    `Переключить выборку перетаскивания`,
		ToggleSelectHunk:                    `Переключить выборку частей`,
		ToggleSelectionForPatch:             `Добавить/удалить строку(и) для патча`,
		EditHunk:                            `Изменить эту часть`,
		ToggleStagingPanel:                  `Переключиться на другую панель (проиндексированные/непроиндексированные изменения)`,
		ReturnToFilesPanel:                  `Вернуться к панели файлов`,
		FastForward:                         `Перемотать эту ветку вперёд из её upstream-ветки`,
		Fetching:                            "Получить изменения и перемотать вперёд {{.from}} -> {{.to}} ...",
		FoundConflictsTitle:                 "Конфликты!",
		ViewConflictsMenuItem:               "Просмотр конфликтов",
		AbortMenuItem:                       "Прервать %s",
		ViewMergeRebaseOptions:              "Просмотреть параметры слияния/перебазирования",
		NotMergingOrRebasing:                "В данный момент вы не выполняете ни перебазирования, ни слияние",
		AlreadyRebasing:                     "Невозможно выполнить это действие во время перебазирования",
		RecentRepos:                         "Последние репозитории",
		MergeOptionsTitle:                   "Параметры слияния",
		RebaseOptionsTitle:                  "Параметры перебазирования",
		CommitMessageTitle:                  "Сводка коммита",
		CommitDescriptionTitle:              "Описание коммита",
		CommitDescriptionSubTitle:           "Нажмите вкладку, чтобы переключить фокус",
		LocalBranchesTitle:                  "Локальные Ветки",
		SearchTitle:                         "Поиск",
		TagsTitle:                           "Теги",
		MenuTitle:                           "Меню",
		RemotesTitle:                        "Удалённые репозитории",
		RemoteBranchesTitle:                 "Удалённые ветки",
		PatchBuildingTitle:                  "Главная панель (сборка патчей)",
		InformationTitle:                    "Информация",
		SecondaryTitle:                      "Вторичный",
		ReflogCommitsTitle:                  "Журнал ссылок (Reflog)",
		GlobalTitle:                         "Глобальные сочетания клавиш",
		ConflictsResolved:                   "Все конфликты слияния разрешены. Продолжить?",
		Continue:                            "Продолжить",
		Keybindings:                         "Связки клавиш",
		RebasingTitle:                       "Перебазировать '{{.checkedOutBranch}}' на '{{.ref}}'",
		SimpleRebase:                        "Простая перебазировка",
		InteractiveRebase:                   "Интерактивная перебазировка",
		InteractiveRebaseTooltip:            "Начать интерактивную перебазировку с перерыва в начале, чтобы можно было обновить TODO коммиты, прежде чем продолжить.",
		ConfirmMerge:                        "Вы уверены, что хотите to merge '{{.selectedBranch}}' into '{{.checkedOutBranch}}'?",
		FwdNoUpstream:                       "Невозможно перемотать ветку без upstream-ветки",
		FwdNoLocalUpstream:                  "Невозможно перемотать ветку. Удалённый репозитории не зарегистрирован локально",
		FwdCommitsToPush:                    "Невозможно перемотать ветку с коммитами для отправки",
		ErrorOccurred:                       "Произошла ошибка! Пожалуйста, заявите о проблеме на",
		NoRoom:                              "Недостаточно места",
		YouAreHere:                          "ВЫ ЗДЕСЬ",
		YouDied:                             "ТЫ УМЕР!",
		RewordNotSupported:                  "Переформулировка коммитов при интерактивном перебазировании в настоящее время не поддерживается",
		ChangingThisActionIsNotAllowed:      "Изменение этого типа записи todo перебазирования не допускается",
		CherryPickCopy:                      "Скопировать отобранные коммит (cherry-pick)",
		CherryPickCopyRange:                 "Скопировать несколько отобранных коммитов (cherry-pick)",
		PasteCommits:                        "Вставить отобранные коммиты (cherry-pick)",
		SureCherryPick:                      "Вы уверены, что хотите выборочно применить (cherry-picked) отобранные коммиты в эту ветку?",
		CherryPick:                          "Выборочная отборка (Cherry-Pick)",
		Donate:                              "Пожертвовать",
		AskQuestion:                         "Задать вопрос",
		PrevLine:                            "Выбрать предыдущую строку",
		NextLine:                            "Выбрать следующую строку",
		PrevHunk:                            "Выбрать предыдущую часть",
		NextHunk:                            "Выбрать следующую часть",
		PrevConflict:                        "Выбрать предыдущий конфликт",
		NextConflict:                        "Выбрать следующий конфликт",
		SelectPrevHunk:                      "Выбрать предыдущую часть",
		SelectNextHunk:                      "Выбрать следующую часть",
		ScrollDown:                          "Прокрутить вниз",
		ScrollUp:                            "Прокрутить вверх",
		ScrollUpMainPanel:                   "Прокрутить вверх главную панель",
		ScrollDownMainPanel:                 "Прокрутить вниз главную панель",
		AmendCommitTitle:                    "Править коммит (amend)",
		AmendCommitPrompt:                   "Вы уверены, что хотите править этот коммит проиндексированными файлами?",
		DeleteCommitTitle:                   "Удалить коммит",
		DeleteCommitPrompt:                  "Вы уверены, что хотите удалить этот коммит?",
		SquashingStatus:                     "Объединение коммитов",
		FixingStatus:                        "Объединение коммитов, отбросив сообщение коммита",
		DeletingStatus:                      "Удаление",
		MovingStatus:                        "Перемещение",
		RebasingStatus:                      "Перебазирование",
		MergingStatus:                       "Слияние",
		LowercaseRebasingStatus:             "перебазировка", // lowercase because it shows up in parentheses
		LowercaseMergingStatus:              "слияние",       // lowercase because it shows up in parentheses
		AmendingStatus:                      "Правка коммита",
		CherryPickingStatus:                 "Выборочная отборка (cherry-picking)",
		UndoingStatus:                       "Отмена последней команды",
		RedoingStatus:                       "Выполнение последней команды",
		CheckingOutStatus:                   "Переключение",
		CommittingStatus:                    "Сохранение изменении",
		CommitFiles:                         "Сохранить изменения файлов",
		SubCommitsDynamicTitle:              "Коммиты (%s)",
		CommitFilesDynamicTitle:             "Различия файлов (%s)",
		RemoteBranchesDynamicTitle:          "Удалённые ветки (%s)",
		ViewItemFiles:                       "Просмотреть файлы выбранного элемента",
		CommitFilesTitle:                    "Сохранить Изменения Файлов",
		CheckoutCommitFile:                  "Переключить файл",
		CanOnlyDiscardFromLocalCommits:      "Изменения можно отменить только из локальных коммитов.",
		DiscardOldFileChange:                "Отменить изменения коммита в этом файле",
		DiscardFileChangesTitle:             "Отменить изменения файла",
		DiscardFileChangesPrompt:            "Вы уверены, что хотите отменить изменения коммита в этом файле? Если файл был создан в этом коммите, он будет удалён",
		DiscardAddedFileChangesPrompt:       "Вы уверены, что хотите отменить изменения, внесённые в этот файл коммитом? Файл был добавлен в этот коммит, поэтому он снова будет удален.",
		DiscardDeletedFileChangesPrompt:     "Вы уверены, что хотите отменить изменения, внесённые в этот файл коммитом? Файл был удалён в этом коммите, поэтому он снова появится.",
		DiscardNotSupportedForDirectory:     "Отмена изменений не поддерживается для всех каталогов. Используйте для этого специальный патч.",
		DisabledForGPG:                      "Функция недоступна для пользователей, использующих GPG",
		CreateRepo:                          "Не в git репозитории. Создать новый git репозиторий? (y/n):",
		BareRepo:                            "Вы пытались открыть Lazygit в пустом репозитории, но Lazygit ещё не поддерживает пустые репозитории. Открыть последний репозиторий? (y/n)",
		InitialBranch:                       "Название ветки? (оставьте пустым для git по умолчанию):",
		NoRecentRepositories:                "Необходимо открыть lazygit в git репозитории. Нет валидных последних репозиториев. Выход.",
		IncorrectNotARepository:             "Неверное значение 'notARepository'. Это должно быть одним из 'prompt', 'create', 'skip', или 'quit'.",
		AutoStashTitle:                      "Автосохранить изменения?",
		AutoStashPrompt:                     "Чтобы перенести изменения, их нужно сохранить и вынуть. Сделать это автоматически? (enter/esc)",
		StashPrefix:                         "Автосохранение изменений для",
		ViewDiscardOptions:                  "Просмотреть параметры «отмены изменении»",
		Cancel:                              "Отменить",
		DiscardAllChanges:                   "Отменить все изменения",
		DiscardUnstagedChanges:              "Отменить непроиндексированные изменения",
		DiscardAllChangesToAllFiles:         "Разбомбить рабочее дерево?",
		DiscardAnyUnstagedChanges:           "Отменить непроиндексированные изменения",
		DiscardUntrackedFiles:               "Удалить неотслеживаемые файлы",
		DiscardStagedChanges:                "Отменить проиндексированные изменения",
		HardReset:                           "Жёсткий сброс",
		ViewResetOptions:                    `Просмотреть параметры сброса`,
		CreateFixupCommitDescription:        `Создать fixup коммит для этого коммита`,
		SquashAboveCommits:                  `Объединить все 'fixup!' коммиты выше в выбранный коммит (автосохранение)`,
		SureSquashAboveCommits:              `Вы уверены, что хотите объединить все fixup! коммиты выше {{.commit}}?`,
		CreateFixupCommit:                   `Создать fixup коммит`,
		SureCreateFixupCommit:               `Вы уверены, что хотите создать fixup! коммит для коммита {{.commit}}?`,
		ExecuteCustomCommand:                "Выполнить пользовательскую команду",
		CustomCommand:                       "Пользовательская Команда:",
		CommitChangesWithoutHook:            "Закоммитить изменения без предварительного хука коммита",
		SkipHookPrefixNotConfigured:         "Вы не настроили префикс сообщения коммита для пропуска хуков. Установите `git.skipHookPrefix = 'WIP'` в вашей конфигурации",
		ResetTo:                             `Сбросить на`,
		PressEnterToReturn:                  "Нажмите Enter, чтобы вернуться в lazygit",
		ViewStashOptions:                    "Просмотреть параметры хранилища",
		StashAllChanges:                     "Припрятать все изменения",
		StashStagedChanges:                  "Припрятать проиндексированные изменения",
		StashAllChangesKeepIndex:            "Припрятать все изменения и сохранить индекс",
		StashUnstagedChanges:                "Припрятать непроиндексированные изменения",
		StashIncludeUntrackedChanges:        "Припрятать все изменения, включая неотслеживаемые файлы",
		StashOptions:                        "Параметры хранилища",
		NotARepository:                      "Ошибка: необходимо запустить внутри git репозитория",
		Jump:                                "Перейти к панели",
		ScrollLeftRight:                     "Прокрутить влево/вправо",
		ScrollLeft:                          "Прокрутить влево",
		ScrollRight:                         "Прокрутить вправо",
		DiscardPatch:                        "Отменить патч",
		DiscardPatchConfirm:                 "Вы можете собрать патч только из одной записи коммита/хранилища за раз. Отменить текущий патч?",
		CantPatchWhileRebasingError:         "Вы не можете создавать патчи или запускать команды патча, находясь в состоянии слияния или перемещения.",
		ToggleAddToPatch:                    "Переключить файлы включённые в патч",
		ToggleAllInPatch:                    "Переключить все файлы, включённые в патч",
		UpdatingPatch:                       "Обновление патча",
		ViewPatchOptions:                    "Просмотреть пользовательские параметры патча",
		PatchOptionsTitle:                   "Параметры патча",
		NoPatchError:                        "Патч ещё не создан. Чтобы начать сборку патча, используйте «пробел» в файле коммита или введите, чтобы добавить определённые строки.",
		EnterFile:                           "Введите файл, чтобы добавить выбранные строки в патч (или свернуть каталог переключения)",
		ExitCustomPatchBuilder:              `Выйти из сборщика пользовательских патчей`,
		EnterUpstream:                       `Введите upstream как '<remote> <branchname>'`,
		InvalidUpstream:                     "Недействительный upstream. Должен быть в формате '<remote> <branchname>'",
		ReturnToRemotesList:                 `Вернуться к списку удалённых репозитории`,
		AddNewRemote:                        `Добавить новую удалённую ветку`,
		NewRemoteName:                       `Название новой удалённой ветки`,
		NewRemoteUrl:                        `Ссылка новой удалённой ветки`,
		EditRemoteName:                      `Введите новое название для удалённое ветки {{.remoteName}}:`,
		EditRemoteUrl:                       `Введите новую ссылку для удалённое ветки {{.remoteName}}:`,
		RemoveRemote:                        `Удалить удалённую ветку`,
		RemoveRemotePrompt:                  "Вы уверены, что хотите удалить удалённую ветку?",
		DeleteRemoteBranch:                  "Удалить Удалённую Ветку",
		DeleteRemoteBranchMessage:           "Вы уверены, что хотите удалить удалённую ветку",
		SetAsUpstream:                       "Установить как upstream-ветку переключённую ветку",
		SetUpstream:                         "Установить upstream-ветку из выбранной ветки",
		UnsetUpstream:                       "Убрать upstream-ветку из выбранной ветки",
		SetUpstreamTitle:                    "Установить upstream-ветку",
		SetUpstreamMessage:                  "Вы уверены, что хотите установить upstream-ветвь '{{.checkedOut}}' на '{{.selected}}'",
		EditRemote:                          "Редактировать удалённый репозитории",
		TagCommit:                           "Пометить коммит тегом",
		TagMenuTitle:                        "Создать тег",
		TagNameTitle:                        "Название тега:",
		TagMessageTitle:                     "Сообщения тега:",
		AnnotatedTag:                        "Аннотированный тег",
		LightweightTag:                      "Легковесный тег",
		DeleteTag:                           "Удалить тег",
		DeleteTagTitle:                      "Удалить тег",
		DeleteTagPrompt:                     "Вы уверены, что хотите удалить тег '{{.tagName}}'?",
		PushTagTitle:                        "Удалённый репозитории для отправки тега '{{.tagName}}' в:",
		PushTag:                             "Отправить тег",
		CreateTag:                           "Создать тег",
		CreateTagTitle:                      "Название тега:",
		FetchRemote:                         "Получение изменения из удалённого репозитория",
		FetchingRemoteStatus:                "Получение статуса удалённого репозитория",
		CheckoutCommit:                      "Переключить коммит",
		SureCheckoutThisCommit:              "Вы уверены, что хотите переключить коммит?",
		GitFlowOptions:                      "Показать параметры git-flow",
		NotAGitFlowBranch:                   "Это не похоже на ветку git-flow",
		NewGitFlowBranchPrompt:              "Новое {{.branchType}} название:",
		IgnoreTracked:                       "Игнорировать отслеживаемый файл",
		IgnoreTrackedPrompt:                 "Вы уверены, что хотите игнорировать отслеживаемый файл?",
		ExcludeTracked:                      "Исключить отслеживаемый файл",
		ExcludeTrackedPrompt:                "Вы уверены, что хотите исключить отслеживаемый файл?",
		ViewResetToUpstreamOptions:          "Просмотреть параметры сброса upstream-ветки",
		NextScreenMode:                      "Следующий режим экрана (нормальный/полуэкранный/полноэкранный)",
		PrevScreenMode:                      "Предыдущий режим экрана",
		StartSearch:                         "Найти",
		Panel:                               "Панель",
		KeybindingsLegend:                   "Связки клавиш",
		RenameBranch:                        "Переименовать ветку",
		SetUnsetUpstream:                    "Установить/убрать upstream-ветку",
		NewBranchNamePrompt:                 "Введите новое название ветки",
		RenameBranchWarning:                 "Эта ветвь отслеживает удалённый репозитории. Это действие переименует только имя локальной ветки, а не имя удалённой ветки. Продолжать?",
		OpenMenu:                            "Открыть меню",
		ResetCherryPick:                     "Сбросить отобранную (скопированную | cherry-picked) выборку коммитов",
		NextTab:                             "Следующая вкладка",
		PrevTab:                             "Предыдущая вкладка",
		CantUndoWhileRebasing:               "Невозможно отменить во время перебазирования",
		CantRedoWhileRebasing:               "Невозможно повторить при перебазировании",
		MustStashWarning:                    "Вытаскивание исправления в индекс требует сохранения и распаковки ваших изменений. Если что-то пойдёт не так, можно получить доступ к файлам из хранилища. Продолжить?",
		MustStashTitle:                      "Необходимо припрятать",
		ConfirmationTitle:                   "Панель Подтверждения",
		PrevPage:                            "Предыдущая страница",
		NextPage:                            "Следующая страница",
		GotoTop:                             "Пролистать наверх",
		GotoBottom:                          "Прокрутить вниз",
		FilteringBy:                         "Фильтрация по",
		ResetInParentheses:                  "(сбросить)",
		OpenFilteringMenu:                   "Просмотреть параметры фильтрации по пути",
		FilterBy:                            "Фильтровать по",
		ExitFilterMode:                      "Прекратить фильтрацию по пути",
		FilterPathOption:                    "Введите путь для фильтрации",
		EnterFileName:                       "Введите путь:",
		FilteringMenuTitle:                  "Фильтрация",
		MustExitFilterModeTitle:             "Команда недоступна",
		MustExitFilterModePrompt:            "Команда недоступна в режиме фильтрации. Выйти из режима фильтрации?",
		Diff:                                "Разница",
		EnterRefToDiff:                      "Введите ссылку для сравнения",
		EnterRefName:                        "Введите ссылку:",
		ExitDiffMode:                        "Выйти из режима сравнения",
		DiffingMenuTitle:                    "Сравнение",
		SwapDiff:                            "Обратное направление сравнении",
		OpenDiffingMenu:                     "Открыть меню сравнении",
		// the actual view is the extras view which I intend to give more tabs in future but for now we'll only mention the command log part
		OpenExtrasMenu:                      "Открыть меню журнала команд",
		ShowingGitDiff:                      "Показывает вывод для:",
		CommitDiff:                          "Разница коммита",
		CopyCommitShaToClipboard:            "Скопировать SHA коммита в буфер обмена",
		CommitSha:                           "SHA коммита",
		CommitURL:                           "URL коммита",
		CopyCommitMessageToClipboard:        "Скопировать сообщение коммита в буфер обмена",
		CommitMessage:                       "Сообщение коммита",
		CommitAuthor:                        "Автор коммита",
		CopyCommitAttributeToClipboard:      "Скопировать атрибут коммита",
		CopyBranchNameToClipboard:           "Скопировать название ветки в буфер обмена",
		CopyFileNameToClipboard:             "Скопировать название файла в буфер обмена",
		CopyCommitFileNameToClipboard:       "Скопировать закомиченное имя файла в буфер обмена",
		CopySelectedTexToClipboard:          "Скопировать выделенный текст в буфер обмена",
		CommitPrefixPatternError:            "Ошибка в шаблоне commitPrefix",
		NoFilesStagedTitle:                  "Нет проиндексированных файлов",
		NoFilesStagedPrompt:                 "Нет проиндексированых файлов. Закоммитить все файлы?",
		BranchNotFoundTitle:                 "Ветка не найдена",
		BranchNotFoundPrompt:                "Ветка не найден. Создайте новую ветку с названием",
		BranchUnknown:                       "Ветка неизвестна",
		DiscardChangeTitle:                  "Отменить изменение",
		DiscardChangePrompt:                 "Вы уверены, что хотите отменить это изменение (git reset)? Это необратимо.\nЧтобы отключить этот диалог, установите для конфигурационного ключа 'gui.skipDiscardChangeWarning' значение true.",
		CreateNewBranchFromCommit:           "Создать новую ветку с этого коммита",
		BuildingPatch:                       "Сборка патча",
		ViewCommits:                         "Просмотреть коммиты",
		MinGitVersionError:                  "Версия Git должна быть не ниже 2.20 (т. е. начиная с 2018 года). Пожалуйста, обновите версию git. В качестве альтернативы заявите о проблеме на https://github.com/jesseduffield/lazygit/issues, чтобы lazygit был более совместим с предыдущими версиями.",
		RunningCustomCommandStatus:          "Запуск пользовательской команды",
		SubmoduleStashAndReset:              "Спрятать непроиндексированные изменения подмодуля и обновить",
		AndResetSubmodules:                  "И сбросить подмодули",
		EnterSubmodule:                      "Ввести подмодуль",
		CopySubmoduleNameToClipboard:        "Скопировать название подмодуля в буфер обмена",
		RemoveSubmodule:                     "Удалить подмодуль",
		RemoveSubmodulePrompt:               "Вы уверены, что хотите удалить подмодуль '%s' и соответствующий ему каталог? Это необратимо.",
		ResettingSubmoduleStatus:            "Сброс подмодуля",
		NewSubmoduleName:                    "Названия нового подмодуля:",
		NewSubmoduleUrl:                     "URL нового подмодуля:",
		NewSubmodulePath:                    "Путь нового подмодуля:",
		AddSubmodule:                        "Добавить новый подмодуль",
		AddingSubmoduleStatus:               "Добавление подмодуля",
		UpdateSubmoduleUrl:                  "Обновить URL подмодуля '%s'",
		UpdatingSubmoduleUrlStatus:          "Обновление URL",
		EditSubmoduleUrl:                    "Обновить URL подмодуля",
		InitializingSubmoduleStatus:         "Инициализация подмодуля",
		InitSubmodule:                       "Инициализировать подмодуль",
		SubmoduleUpdate:                     "Обновить подмодуль",
		UpdatingSubmoduleStatus:             "Обновление подмодуля",
		BulkInitSubmodules:                  "Массовая инициализация подмодулей",
		BulkUpdateSubmodules:                "Массовое обновление подмодулей",
		BulkDeinitSubmodules:                "Массовая деинициализация подмодулей",
		ViewBulkSubmoduleOptions:            "Просмотреть параметры массового подмодуля",
		BulkSubmoduleOptions:                "Параметры массового подмодуля",
		RunningCommand:                      "Выполнение команды",
		SubCommitsTitle:                     "Подкоммиты",
		SubmodulesTitle:                     "Подмодули",
		NavigationTitle:                     "Навигация по панели списка",
		SuggestionsCheatsheetTitle:          "Подсказки",
		SuggestionsTitle:                    "Подсказки (нажмите %s, чтобы сфокусироваться)",
		ExtrasTitle:                         "Журнал команд",
		PushingTagStatus:                    "Отправка тега",
		PullRequestURLCopiedToClipboard:     "URL запроса на принятие изменений скопирован в буфер обмена",
		CommitDiffCopiedToClipboard:         "Сравнения коммита скопированы в буфер обмена",
		CommitSHACopiedToClipboard:          "SHA коммита скопировано в буфер обмена",
		CommitURLCopiedToClipboard:          "URL коммита скопирован в буфер обмена",
		CommitMessageCopiedToClipboard:      "Сообщение коммита скопировано в буфер обмена",
		CommitAuthorCopiedToClipboard:       "Автор коммита скопирован в буфер обмена",
		PatchCopiedToClipboard:              "Патч скопирован в буфер обмена",
		CopiedToClipboard:                   "Скопировано в буфер обмена",
		ErrCannotEditDirectory:              "Невозможно редактировать каталог: вы можете редактировать только отдельные файлы",
		ErrStageDirWithInlineMergeConflicts: "Невозможно подготовить/удалить каталог, содержащий файлы со встроенными конфликтами слияния. Сначала устраните конфликты слияния",
		ErrRepositoryMovedOrDeleted:         "Не могу найти репозиторий. Возможно, он был перемещён или удалён ¯\\_(ツ)_/¯",
		CommandLog:                          "Журнал команд",
		ToggleShowCommandLog:                "Показать/скрыть журнал команд",
		FocusCommandLog:                     "Сфокусировать журнал команд",
		CommandLogHeader:                    "Вы можете скрыть/сфокусировать эту панель, нажав '%s'\n",
		RandomTip:                           "Случайный совет",
		SelectParentCommitForMerge:          "Выберите родительский коммит для слияния",
		ToggleWhitespaceInDiffView:          "Переключить отображение изменении пробелов в просмотрщике сравнении",
		IgnoreWhitespaceDiffViewSubTitle:    "(игнорирование пробелов)",
		IgnoreWhitespaceNotSupportedHere:    "Игнорирование пробелов не поддерживается в этом представлении",
		IncreaseContextInDiffView:           "Увеличить размер контекста, отображаемого вокруг изменений в просмотрщике сравнении",
		DecreaseContextInDiffView:           "Уменьшите размер контекста, отображаемого вокруг изменений в просмотрщике сравнении",
		CreatePullRequestOptions:            "Создать параметры запроса принятие изменений",
		DefaultBranch:                       "Ветка по-умолчанию",
		SelectBranch:                        "Выбрать ветку",
		SelectConfigFile:                    "Выбрать файл конфигурации",
		NoConfigFileFoundErr:                "Файл конфигурации не найден",
		LoadingFileSuggestions:              "Загрузка подсказок по файлам",
		LoadingCommits:                      "Загрузка коммитов",
		MustSpecifyOriginError:              "Необходимо указать удалённый репозитории, если указываете ветку",
		GitOutput:                           "Вывод git:",
		GitCommandFailed:                    "Ошибка команды Git. Подробности смотрите в журнале команд (открыть с помощью %s)",
		AbortTitle:                          "Прервать %s",
		AbortPrompt:                         "Вы уверены, что хотите прервать текущий %s?",
		OpenLogMenu:                         "Открыть меню журнала",
		LogMenuTitle:                        "Параметры журнала коммитов",
		ToggleShowGitGraphAll:               "Переключить отображение всего git графа (передать флаг --all в git log )",
		ShowGitGraph:                        "Показать git граф",
		SortCommits:                         "Упорядочить коммиты",
		CantChangeContextSizeError:          "Невозможно изменить контекст в режиме создания патча, потому что мы были слишком ленивы, чтобы поддерживать его при выпуске функции. Если вы действительно этого хотите, пожалуйста, дайте нам знать!",
		OpenCommitInBrowser:                 "Открыть коммит в браузере",
		ViewBisectOptions:                   "Просмотреть параметры бинарного поиска",
		ConfirmRevertCommit:                 "Вы уверены, что хотите отменить {{.selectedCommit}}?",
		RewordInEditorTitle:                 "Перефразировать в редакторе",
		RewordInEditorPrompt:                "Вы уверены, что хотите перефразировать этот коммит вашем редакторе?",
		HardResetAutostashPrompt:            "Вы уверены, что хотите сделать жёсткий сброс на '%s'? При необходимости будет выполнен автосохранение в хранилище.",
		CheckoutPrompt:                      "Вы уверены, что хотите переключить '%s'?",
		UpstreamGone:                        "(upstream gone)",
		NukeDescription:                     "Если вы хотите, чтобы все изменения в рабочем дереве исчезли, это способ сделать это. Если есть какие-либо изменения подмодуля, эти изменения будут припрятаны в подмодуле(-ях).",
		DiscardStagedChangesDescription:     "Это создаст новую запись в хранилище, содержащую только проиндексированные файлы, а затем удалит её, так что в рабочем дереве останутся только непроиндексированные изменения.",
		EmptyOutput:                         "<Пустой вывод>",
		Patch:                               "Патч",
		CustomPatch:                         "Пользовательский патч",
		CommitsCopied:                       "коммиты скопированы", // lowercase because it's used in a sentence
		CommitCopied:                        "коммит скопирован",   // lowercase because it's used in a sentence
		ResetPatch:                          "Сбросить патч",
		ApplyPatch:                          "Применить патч",
		ApplyPatchInReverse:                 "Применить патч в обратном порядке",
		RemovePatchFromOriginalCommit:       "Удалить патч из исходного коммита (%s)",
		MovePatchOutIntoIndex:               "Переместить патч в индекс",
		MovePatchIntoNewCommit:              "Переместить патч в новый коммит",
		MovePatchToSelectedCommit:           "Переместить патч в выбранный коммит (%s)",
		CopyPatchToClipboard:                "Скопировать патч в буфер обмена",
		NoMatchesFor:                        "Нет совпадений для '%s' %s",
		ExitSearchMode:                      "%s: Выйти из режима поиска",
		MatchesFor:                          "совпадений для '%s' (%d из %d) %s", // lowercase because it's after other text
		SearchKeybindings:                   "%s: Следующее совпадение, %s: Предыдущее совпадение, %s: Выйти из режима поиска",
		SearchPrefix:                        "Поиск: ",
		Actions: Actions{
			// TODO: combine this with the original keybinding descriptions (those are all in lowercase atm)
			CheckoutCommit:                    "Переключить коммит",
			CheckoutTag:                       "Переключить тег",
			CheckoutBranch:                    "Переключить ветку",
			ForceCheckoutBranch:               "Принудительное переключение ветки",
			DeleteBranch:                      "Удалить ветку",
			Merge:                             "Слить",
			RebaseBranch:                      "Перебазировать ветку",
			RenameBranch:                      "Переименовать ветку",
			SetUnsetUpstream:                  "Установить/убрать upstream-ветку",
			CreateBranch:                      "Создать ветку",
			CherryPick:                        "(Cherry-pick) Вставить коммиты",
			CheckoutFile:                      "Переключить файл",
			DiscardOldFileChange:              "Отменить старое изменение файла",
			SquashCommitDown:                  "Объединить несколько коммитов в один нижний",
			FixupCommit:                       "Объединить несколько коммитов в один, отбросив сообщение коммита",
			RewordCommit:                      "Перефразировать коммит",
			DropCommit:                        "Сбросить коммит",
			EditCommit:                        "Изменить коммит",
			AmendCommit:                       "Править коммит (amend)",
			ResetCommitAuthor:                 "Сброс автора коммита",
			SetCommitAuthor:                   "Установить автора коммита",
			RevertCommit:                      "Отменить коммит",
			CreateFixupCommit:                 "Создать fixup коммит",
			SquashAllAboveFixupCommits:        "Объединить все выше fixup коммиты",
			CreateLightweightTag:              "Создать легковесный тег",
			CreateAnnotatedTag:                "Создать аннотированный тег",
			CopyCommitMessageToClipboard:      "Скопировать сообщение коммита в буфер обмена",
			CopyCommitDiffToClipboard:         "Скопировать сравнения коммита в буфер обмена",
			CopyCommitSHAToClipboard:          "Скопировать SHA коммита в буфер обмена",
			CopyCommitURLToClipboard:          "Скопировать URL коммита в буфер обмена",
			CopyCommitAuthorToClipboard:       "Скопировать автора коммита в буфер обмена",
			CopyCommitAttributeToClipboard:    "Скопировать в буфер обмена",
			CopyPatchToClipboard:              "Скопировать патч в буфер обмена",
			MoveCommitUp:                      "Переместить коммит вверх",
			MoveCommitDown:                    "Переместить коммит вниз",
			CustomCommand:                     "Пользовательская команда",
			DiscardAllChangesInDirectory:      "Отменить все изменения в каталоге",
			DiscardUnstagedChangesInDirectory: "Отменить непроиндексированные изменения в каталоге",
			DiscardAllChangesInFile:           "Отменить все изменения в файле",
			DiscardAllUnstagedChangesInFile:   "Отменить все непроиндексированные изменения в файле",
			StageFile:                         "Проиндексировать файл",
			StageResolvedFiles:                "Проиндексированные файлы, конфликты слияния которых были устранены",
			UnstageFile:                       "Непроиндексированные файл",
			UnstageAllFiles:                   "Удалить все файлы из индекса",
			StageAllFiles:                     "Проиндексировать все файлы",
			IgnoreExcludeFile:                 "Игнорировать или исключить файл",
			IgnoreFileErr:                     "Невозможно игнорировать .gitignore",
			ExcludeFile:                       "Исключить файл",
			ExcludeFileErr:                    "Невозможно исключить .git/info/exclude",
			ExcludeGitIgnoreErr:               "Невозможно исключить .gitignore",
			Commit:                            "Коммит",
			EditFile:                          "Редактировать файл",
			Push:                              "Отправить изменения",
			Pull:                              "Получить и слить изменения",
			OpenFile:                          "Открыть файл",
			StashAllChanges:                   "Припрятать все изменения",
			StashAllChangesKeepIndex:          "Припрятать все изменения и сохранить индекс",
			StashStagedChanges:                "Припрятать проиндексированные изменения",
			StashUnstagedChanges:              "Припрятать непроиндексированные изменения",
			StashIncludeUntrackedChanges:      "Припрятать все изменения, включая неотслеживаемые файлы",
			GitFlowFinish:                     "Завершение Git-потока",
			GitFlowStart:                      "Запуск Git-потока",
			CopyToClipboard:                   "Скопировать в буфер обмена",
			CopySelectedTextToClipboard:       "Скопировать выделенный текст в буфер обмена",
			RemovePatchFromCommit:             "Удалить патч из коммита",
			MovePatchToSelectedCommit:         "Переместить патч в выбранный коммит",
			MovePatchIntoIndex:                "Переместите патч в индекс",
			MovePatchIntoNewCommit:            "Переместить патч в новый коммит",
			DeleteRemoteBranch:                "Удалить удалённую ветку",
			SetBranchUpstream:                 "Установить ветку как upstream",
			AddRemote:                         "Добавить удалённую ветку",
			RemoveRemote:                      "Удалить удалённую ветку",
			UpdateRemote:                      "Обновить удалённую ветку",
			ApplyPatch:                        "Применить патч",
			Stash:                             "Хранилище",
			RenameStash:                       "Переименовать хранилище",
			RemoveSubmodule:                   "Удалить подмодуль",
			ResetSubmodule:                    "Сброс подмодуля",
			AddSubmodule:                      "Добавить подмодуль",
			UpdateSubmoduleUrl:                "Обновить URL подмодуля",
			InitialiseSubmodule:               "Инициализация подмодуля",
			BulkInitialiseSubmodules:          "Массовая инициализация подмодулей",
			BulkUpdateSubmodules:              "Массовое обновление подмодулей",
			BulkDeinitialiseSubmodules:        "Массовая деинициализация подмодулей",
			UpdateSubmodule:                   "Обновить подмодуль",
			DeleteTag:                         "Удалить тег",
			PushTag:                           "Отправить тег",
			NukeWorkingTree:                   "Уничтожить рабочее дерево",
			DiscardUnstagedFileChanges:        "Отменить непроиндексированные изменения файла",
			RemoveUntrackedFiles:              "Удалить неотслеживаемые файлы",
			RemoveStagedFiles:                 "Удалить проиндексированные файлы",
			SoftReset:                         "Мягкий сброс",
			MixedReset:                        "Смешанный сброс",
			HardReset:                         "Жёсткий сброс",
			FastForwardBranch:                 "Ветка перемотки вперёд",
			Undo:                              "Отменить",
			Redo:                              "Повторить",
			CopyPullRequestURL:                "Скопировать запрос на принятие изменений URL",
			OpenMergeTool:                     "Открыть инструмент слияния",
			OpenCommitInBrowser:               "Открыть коммит в браузере",
			OpenPullRequest:                   "Открыть запрос на принятие изменений в браузера",
			StartBisect:                       "Начать бинарный поиск",
			ResetBisect:                       "Сбросить бинарный поиск",
			BisectSkip:                        "Пропустить бинарный поиск",
			BisectMark:                        "Отметить бинарный поиск",
		},
		Bisect: Bisect{
			Mark:                        "Отметить %s как %s",
			MarkStart:                   "Отметить %s как %s (начать бинарный поиск)",
			Skip:                        "Пропустить %s",
			ResetTitle:                  "Сбросить 'git bisect'",
			ResetPrompt:                 "Вы уверены, что хотите сбросить 'git bisect'?",
			ResetOption:                 "Сбросить бинарный поиск",
			BisectMenuTitle:             "Бинарный поиск",
			CompleteTitle:               "Бинарный поиск завершён",
			CompletePrompt:              "Бинарный поиск завершён! Изменения внесённые следующим коммитом:\n\n%s\n\nСбросить 'git bisect' сейчас?",
			CompletePromptIndeterminate: "Бинарный поиск завершён! Некоторые коммиты были пропущены, поэтому любое из следующих коммитов могло внести изменения::\n\n%s\n\nСбросить 'git bisect' сейчас?",
			Bisecting:                   "Бинарный поиск",
		},
	}
}
