---
title: "v3.3.0"
linkTitle: "v3.3.0"
date: 2019-10-24
description: >
  Kustomize v3.3.0
---

 
[versioning policy documentation]: /site/content/en/faq/versioningPolicy.md
[release process documentation]: /releasing

## Summary of changes

### First release of the Go API-only module

Many of the PRs since the last vrelease were
around restructuring the _sigs.k8s.io/kustomize_
repository into three Go modules instead of just one.

The reasons for this are detailed in the [versioning
policy documentation], and what it means for releasing
is explained in the [release process documentation].

The tl;dr is that the top level module
`sigs.k8s.io/kustomize` now defines the kustomize Go
API, and the _kustomize_ CLI sits below it in an
independent module `sigs.k8s.io/kustomize/kustomize`.

The modules release independently, though in practice a
new release of the kustomize Go API will likely be
followed quickly by a new release of the `kustomize`
executable.

This is a necessary step to creating a much smaller
kustomize Go API surface that has some hope of
conforming to semantic versioning and being of some use
to clients.

The kustomize CLI will see the same kustomize Go API as
any other client.

The new semver-able API will begin with `v4.0.0` (not
yet released) and be a clean break with `v3` etc.

### Change log since v3.2.0

```
3c9d828f - Have kustomize CLI depend on kustomize Go API v3.3.0 (Jeffrey Regan)
5d800f0b - Merge pull request #1595 from monopole/threeReleases (Jeff Regan)
4eb2d5bc - Three builders. (Jeffrey Regan)
988af1ff - Update README.md (Jeff Regan)
1617183e - Merge pull request #1590 from monopole/releaseProcessUpdate (Kubernetes Prow Robot)
ee727464 - update release process doc (jregan)
c9e7dc3b - Merge pull request #1589 from monopole/moreTestsAroundKustFileName (Jeff Regan)
07e0e46a - improve tests for alternative kustomization file names (Jeffrey Regan)
404d2d63 - Merge pull request #1587 from monopole/reducePgmconfig (Jeff Regan)
baa0296a - Reduce size of pgmconfig package (Jeffrey Regan)
0f665ac1 - Merge pull request #1544 from ptux/add-transformer-href (Jeff Regan)
14b0a650 - Merge pull request #1581 from monopole/refactorFs (Jeff Regan)
2d58f8b8 - Break the dep between fs and pgmconfig. (Jeffrey Regan)
9a43ca53 - Merge pull request #1578 from nlamirault/fix/build-plugins-doc (Jeff Regan)
5372fc6f - Merge pull request #1579 from monopole/fsPackageCleanup (Jeff Regan)
86bc3440 - Merge pull request #1513 from nimohunter/fix_empty_list_item (Kubernetes Prow Robot)
a014f7d4 - Merge pull request #1561 from beautytiger/dev-190925 (Jeff Regan)
9a94bcb8 - Improve fs package and doc in prep to officially go public (Jeffrey Regan)
07634ef0 - Merge pull request #1575 from monopole/versioning (Jeff Regan)
995f88d6 - Update versioning notes. (jregan)
334a6467 - Fix: documentation link for plugins (Nicolas Lamirault)
08963ba5 - improve test code coverage in transformers (Guangming Wang)
326fb689 - Merge pull request #1570 from bzub/1234-go_plugin_doc (Jeff Regan)
970ce67c - Update goPluginCaveats.md (Jeff Regan)
98d18930 - Update INSTALL.md (Jeff Regan)
d89b448c - Fix git tag recovery in cloud build. (Jeff Regan)
17bf9d32 - Update releasing README. (Jeff Regan)
a99aff1d - Merge pull request #1571 from monopole/updateCloudBuildProcess (Kubernetes Prow Robot)
a694ac7b - Update cloud build process for kustomize. (Jeffrey Regan)
b5b11ef6 - Fix compile kustomize example. (bzub)
fa1af6f5 - Merge pull request #1473 from richardmarshall/execpluginhash (Jeff Regan)
9288dec0 - Fix failing BashedConfigMapTest (Jeff Regan)
1a45dd0b - Merge pull request #1566 from monopole/releaseNotes3.2.1 (Kubernetes Prow Robot)
592c5acf - docs: Exec plugin generator options (Richard Marshall)
ac9424fa - tests: Add unit tests for update resource options (Richard Marshall)
79fbe7c4 - Support resource generator options in exec plugins (Richard Marshall)
f69d526f - v3.2.1 release notes (Jeff Regan)
07a95a60 - Merge pull request #1565 from monopole/tweakBinaryDepsBeforeTagging (Jeff Regan)
032b3857 - Pin the kustomize binary's dependence on kustomize libs. (jregan)
81062959 - Merge pull request #1564 from monopole/moveKustomizeBinaryToOwnModule (Kubernetes Prow Robot)
b82a8fd3 - Move the kustomize binary to its own module. (Jeffrey Regan)
2d0c22d6 - Merge pull request #1562 from keleustes/tools (Kubernetes Prow Robot)
aa342def - Pin tool versions using go modules (Ian Howell)
10786ec0 - Merge pull request #1554 from keleustes/readme (Kubernetes Prow Robot)
7c705687 - Update README.md to include Kubernetes 1.16 (Jerome Brette)
e8933d97 - Merge pull request #1560 from monopole/precommitTuneup (Jeff Regan)
9d7b6544 - Make pre-commit more portable and less tricky. (jregan)
7a0946a9 - Merge pull request #1558 from monopole/dependOnNewPluginatorModule (Jeff Regan)
def4f045 - Depend on new pluginator location. (Jeffrey Regan)
2f2408f1 - Merge pull request #1559 from monopole/compressCopyright (Jeff Regan)
3b9bcc48 - Compress copyright in the commands package. (Jeffrey Regan)
d0429ff4 - Merge pull request #1557 from monopole/pluginatorModule (Jeff Regan)
33deefc3 - Copy pluginator to its own module. (Jeffrey Regan)
9b3de82b - Merge pull request #1506 from Liujingfang1/release (Jeff Regan)
d217074f - Merge pull request #1550 from keleustes/apiversion (Kubernetes Prow Robot)
1d90ba7c - Fix typo in apiVersion yaml declaration (Jerome Brette)
eeeb4c36 - Merge pull request #1547 from keleustes/extensions (Kubernetes Prow Robot)
b1faa989 - Update Ingress apiVersion to networking.k8s.io/v1beta1 (Jerome Brette)
d8250c9e - move test case (nimohunter)
c9500466 - add transformer href (Wang(わん))
0c32691e - Merge pull request #1537 from jaypipes/gomod-install-note (Kubernetes Prow Robot)
88b1d627 - Merge pull request #1541 from rtnpro/patch-1 (Jeff Regan)
aec82066 - Update INSTALL.md (Jeff Regan)
20c2b53a - Merge pull request #1542 from monopole/tweakFilePathsInTest (Jeff Regan)
274b5c3b - Tweak file path handling and logging in test. (Jeffrey Regan)
b1fdaa23 - Fix typo in transformerconfigs README (Ratnadeep Debnath)
b5d5e70b - empty list or map item return error (nimohunter)
2e829853 - empty list or map item return error (nimohunter)
55941f57 - add note about GO111MODULE for source install (Jay Pipes)
9e226001 - empty list or map item return error (nimohunter)
77b63f96 - add release note for v3.2.0 (jingfangliu)
```
