// Copyright 2020 The Kubernetes Authors.
// SPDX-License-Identifier: Apache-2.0

// Package k8sgen contains code generated by copying bits of k8s.io code.
// The copier is in generator/main.go.
//
// kyaml (and indirectly kustomize) wants to reuse the k/k label selection code.
// Labels and annotations are a key part of k8s metadata.
//
// kyaml cannot depend on it via a normal Go import because kubectl will
// depend on kyaml eventually (see kubernetes-sigs/kustomize/issues/1500).
// While kubectl remains in the k/k repo, it depends on local relative symlinked
// path to a 'staging' version of k8s.io code.  No code imported by kubectl can
// refer to any other version of k8s.io code.
//
// So to do what that code does, kyaml must either reimplement it or copy it.
// When/if kubectl is finally extracted from k/k to its own repo, it can
// depend on apimachinery code via normal imports, and so can kyaml.
// At that point, this copy (and copying mechanism) can be dropped.
//
// Until then, if a bug is found in a particular instance of copied k8s.io
// (unlikely, since this code is old and stable), just increment
// apiMachineryVersion below to match the fixed version, possibly change
// the files copied, re-generate, and if need be adjust call points.
//
//go:generate go run generator/main.go
package k8sgen
