---
title: "v2.1.0"
linkTitle: "v2.1.0"
date: 2019-06-18
description: >
  Kustomize v2.1.0
---

[Go modules]: https://github.com/golang/go/wiki/Modules
[generator options]: https://github.com/kubernetes-sigs/kustomize/tree/master/examples/generatorOptions.md
[imgModules]: /kustomize/images/goModules.png
[imgPlugins]: /kustomize/images/plugins.png
[imgPruning]: /kustomize/images/pruning.png
[imgSorted]: /kustomize/images/sorted.png
[imgWheels]: /kustomize/images/abandonedTrainingWheels.png
[kustomization]: glossary#kustomization
[_kustomization_]: /kustomize/api-reference/glossary#kustomization
[base]: /kustomize/api-reference/glossary#base
[bases]: /kustomize/api-reference/glossary#base
[_base_]: /kustomize/api-reference/glossary#base
[kustomize inventory object documentation]: https://github.com/kubernetes-sigs/kustomize/tree/master/docs/inventory_object.md
[kustomize plugin documentation]: plugins
[root]: /kustomize/api-reference/glossary#kustomization-root
[transformer configs]: https://github.com/kubernetes-sigs/kustomize/tree/master/examples/transformerconfigs
[v1.0.9]: https://github.com/kubernetes-sigs/kustomize/releases/tag/v1.0.9
[v2.0.3]: https://github.com/kubernetes-sigs/kustomize/releases/tag/v1.0.9releases/tag/v2.0.3
[v2.1.0]: https://github.com/kubernetes-sigs/kustomize/releases/tag/v1.0.9releases/tag/v2.1.0
[versioning policy]: /kustomize/faq/versioningpolicy

Go modules, resource ordering respected, generator and transformer plugins, eased
loading restrictions, the notion of inventory, eased replica count modification.
About ~90 issues closed since [v2.0.3] in ~400 commits.

Download [here][v2.1.0].

## Go modules

![gopher with boxes][imgModules]

Kustomize now defines its dependencies in a top
level `go.mod` file.  This is the first step
towards a package structure intentially exported
as one or more [Go modules] for use in other
programs (kubectl, kubebuilder, etc.) and in
kustomize plugins (see below).

## Resource ordering

![sort order retained][imgSorted]

Kustomize now retains the depth-first order of
resources as read, a frequently requested
feature.

This means resource order can be controlled
by editting kustomization files.  This is
also vital to applying user-defined
transformations (plugins) in a particular
order.

Nothing needs to be done to activate this;
it happens automatically.

The `build` command now accepts a `--reorder`
flag with values `legacy` and `none`,
with a default value of `legacy`.

`legacy` means apply an ordering based on
GVK, that currently emits `Namespace` objects
first, and `ValidatingWebhookConfiguration`
objects last.  This means that despite
automatic retention of load order, your
`build` output won't change by default.

`none` means _don't_ reorder the resources before
output.  Specify this to see output order
respect input order.

## Generator and transformer plugins

![kid putting knife in electrical outlet][imgPlugins]

Since the beginning (as `kinflate` back in Sep
2017), kustomize has read or generated resources,
applied a series of pipelined transformation to
them, and emitted the result to `stdout`.

At that time, the only way to change the behavior
of a generator (e.g. a secret generator), or
change the behavior of a transformer (e.g. a name
changer, or json patcher), was to modify source
code and put out a release.

[v1.0.9] introduced [generator options] as a means
to change the behavior of the only two generators
available at the time - Secret and ConfigMap
generators.  It also introduced
[transformer configs] as a way to fine tune the
targets of transformations (e.g. to which fields
_selectors_ should be added).  Most of the feature
requests for kustomize revolve around changing the
behavior of the builtin generators and
transformers.

[v2.1.0] adds an _alpha_ plugin framework, that
encourages users to write their own generators or
transformers, _declaring them as kubernetes
objects just like everything else_, and apply them
as part of the `kustomize build` process.

To inform the API exposed to plugins, and to
confirm that the plugin framework can offer plugin
authors the same capabilities as builtin
operations, all the builtin generators and
tranformers have been converted to plugin form
(with one exceptions awaiting Go module
refinements).  This means that adding, say, a
`secretGenerator` or `commonAnnotations` directive
to your kustomization will (in [v2.1.0]) trigger
execution of
[code committed as a plugin](https://github.com/kubernetes-sigs/kustomize/tree/master/plugin/builtin).

For more information, see the
[kustomize plugin documentation].

## Remove load restrictions

![removed training wheels][imgWheels]

The following usage:

```
kustomize build --load_restrictor none $target
```

allows a `kustomization.yaml` file used in this
build to refer to files outside its own directory
(i.e. outside its [root]).

This is an opt-in to suppress a security feature
that denies this precise behavior.

This feature should only be used to allow multiple
overlays (e.g. prod, staging and dev) to share a
patch file.  To share _resources_, use a relative
path or URL to a kustomization directory in the
`resources` directive.

## Inventory generation for pruning

![pruning dead branches][imgPruning]

_Alpha_
 
Users can add an `inventory` stanza to their
kustomization file, to add a special _inventory
object_ to the `build` result.

This object applies to the cluster along with
everything else in the build result and can be
used by other clients to intelligently _prune_
orphaned cluster resources.

For more information see the
[kustomize inventory object documentation].


## Field changes / deprecations

###  `resources` expanded, `bases` deprecated

The `resources` field has been generalized; it now
accepts what formerly could only be specified in
the `bases` field.

This change was made to allow users fine control
over resource processing order.  With a distinct
`bases` field, bases had to be loaded separately
from resources as a group.  Now, base loading may
be interleaved as desired with the loading of
resource files from the current
directory. [Resource ordering](#resource-ordering)
had to be respected before this feature could be
introduced.

The `bases` field is now deprecated, and will be
deleted in some future major release.  Manage the
deprecation simply moving the arguments of the
`bases` field to the `resources` field in the
desired order, e.g.

> ```
> resources:
> - someResouceFile.yaml
> - someOtherResourceFile.yaml
> bases:
> - ../../someBaseDir
> ```

could become

> ```
> resources:
> - someResouceFile.yaml
> - ../../someBaseDir
> - someOtherResourceFile.yaml
> ```

The `kustomized edit fix` command will do this for
you, though it will always put the bases at the
end.

As an aside, the `resources`, `generators` and
`transformers` fields now all accept the same
argument format.

> Each field's argument is a _string list_,
> where each entry is either a _resource_ (a
> relative path to a YAML file) or a
> [_kustomization_] (a path or URL
> pointing to a directory with a kustomization
> file).  A kustomization directory used in this
> context is called a [_base_].

The fact that the `generators` and `transformers`
field accept [bases] and the fact that generator
and transformer configuration objects are just
normal k8s resources means that one can generate
or transform a generator or a transformer (see
[TestTransformerTransformers]).

[TestTransformerTransformers]: https://github.com/kubernetes-sigs/kustomize/tree/master/api/internal/target/transformerplugin_test.go

### `replicas` field

The common task of patching a deployment to edit
the number of replicas is now made easier
with the new [replicas](/kustomize/api-reference/kustomization/replicas) field. 

### `envs` field

An `envs` sub-field has been added to both
`configMapGenerator` and `secretGenerator`,
replacing the now deprecated (and singular)
`env` field.  The new field accepts lists, just
like its sibling fields `files` and `literals`.

Optionally use `kustomize edit fix` to merge
singular `env` field into a plural field.
