//go:build go1.16
// +build go1.16

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armcontainerservice

import (
	"context"
	"net/http"
	"time"

	armruntime "github.com/Azure/azure-sdk-for-go/sdk/azcore/arm/runtime"
)

// AgentPoolsCreateOrUpdatePollerResponse contains the response from method AgentPools.CreateOrUpdate.
type AgentPoolsCreateOrUpdatePollerResponse struct {
	// Poller contains an initialized poller.
	Poller *AgentPoolsCreateOrUpdatePoller

	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// PollUntilDone will poll the service endpoint until a terminal state is reached or an error is received.
func (l AgentPoolsCreateOrUpdatePollerResponse) PollUntilDone(ctx context.Context, freq time.Duration) (AgentPoolsCreateOrUpdateResponse, error) {
	respType := AgentPoolsCreateOrUpdateResponse{}
	resp, err := l.Poller.pt.PollUntilDone(ctx, freq, &respType.AgentPool)
	if err != nil {
		return respType, err
	}
	respType.RawResponse = resp
	return respType, nil
}

// Resume rehydrates a AgentPoolsCreateOrUpdatePollerResponse from the provided client and resume token.
func (l *AgentPoolsCreateOrUpdatePollerResponse) Resume(ctx context.Context, client *AgentPoolsClient, token string) error {
	pt, err := armruntime.NewPollerFromResumeToken("AgentPoolsClient.CreateOrUpdate", token, client.pl, client.createOrUpdateHandleError)
	if err != nil {
		return err
	}
	poller := &AgentPoolsCreateOrUpdatePoller{
		pt: pt,
	}
	resp, err := poller.Poll(ctx)
	if err != nil {
		return err
	}
	l.Poller = poller
	l.RawResponse = resp
	return nil
}

// AgentPoolsCreateOrUpdateResponse contains the response from method AgentPools.CreateOrUpdate.
type AgentPoolsCreateOrUpdateResponse struct {
	AgentPoolsCreateOrUpdateResult
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// AgentPoolsCreateOrUpdateResult contains the result from method AgentPools.CreateOrUpdate.
type AgentPoolsCreateOrUpdateResult struct {
	AgentPool
}

// AgentPoolsDeletePollerResponse contains the response from method AgentPools.Delete.
type AgentPoolsDeletePollerResponse struct {
	// Poller contains an initialized poller.
	Poller *AgentPoolsDeletePoller

	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// PollUntilDone will poll the service endpoint until a terminal state is reached or an error is received.
func (l AgentPoolsDeletePollerResponse) PollUntilDone(ctx context.Context, freq time.Duration) (AgentPoolsDeleteResponse, error) {
	respType := AgentPoolsDeleteResponse{}
	resp, err := l.Poller.pt.PollUntilDone(ctx, freq, nil)
	if err != nil {
		return respType, err
	}
	respType.RawResponse = resp
	return respType, nil
}

// Resume rehydrates a AgentPoolsDeletePollerResponse from the provided client and resume token.
func (l *AgentPoolsDeletePollerResponse) Resume(ctx context.Context, client *AgentPoolsClient, token string) error {
	pt, err := armruntime.NewPollerFromResumeToken("AgentPoolsClient.Delete", token, client.pl, client.deleteHandleError)
	if err != nil {
		return err
	}
	poller := &AgentPoolsDeletePoller{
		pt: pt,
	}
	resp, err := poller.Poll(ctx)
	if err != nil {
		return err
	}
	l.Poller = poller
	l.RawResponse = resp
	return nil
}

// AgentPoolsDeleteResponse contains the response from method AgentPools.Delete.
type AgentPoolsDeleteResponse struct {
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// AgentPoolsGetAvailableAgentPoolVersionsResponse contains the response from method AgentPools.GetAvailableAgentPoolVersions.
type AgentPoolsGetAvailableAgentPoolVersionsResponse struct {
	AgentPoolsGetAvailableAgentPoolVersionsResult
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// AgentPoolsGetAvailableAgentPoolVersionsResult contains the result from method AgentPools.GetAvailableAgentPoolVersions.
type AgentPoolsGetAvailableAgentPoolVersionsResult struct {
	AgentPoolAvailableVersions
}

// AgentPoolsGetResponse contains the response from method AgentPools.Get.
type AgentPoolsGetResponse struct {
	AgentPoolsGetResult
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// AgentPoolsGetResult contains the result from method AgentPools.Get.
type AgentPoolsGetResult struct {
	AgentPool
}

// AgentPoolsGetUpgradeProfileResponse contains the response from method AgentPools.GetUpgradeProfile.
type AgentPoolsGetUpgradeProfileResponse struct {
	AgentPoolsGetUpgradeProfileResult
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// AgentPoolsGetUpgradeProfileResult contains the result from method AgentPools.GetUpgradeProfile.
type AgentPoolsGetUpgradeProfileResult struct {
	AgentPoolUpgradeProfile
}

// AgentPoolsListResponse contains the response from method AgentPools.List.
type AgentPoolsListResponse struct {
	AgentPoolsListResult
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// AgentPoolsListResult contains the result from method AgentPools.List.
type AgentPoolsListResult struct {
	AgentPoolListResult
}

// AgentPoolsUpgradeNodeImageVersionPollerResponse contains the response from method AgentPools.UpgradeNodeImageVersion.
type AgentPoolsUpgradeNodeImageVersionPollerResponse struct {
	// Poller contains an initialized poller.
	Poller *AgentPoolsUpgradeNodeImageVersionPoller

	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// PollUntilDone will poll the service endpoint until a terminal state is reached or an error is received.
func (l AgentPoolsUpgradeNodeImageVersionPollerResponse) PollUntilDone(ctx context.Context, freq time.Duration) (AgentPoolsUpgradeNodeImageVersionResponse, error) {
	respType := AgentPoolsUpgradeNodeImageVersionResponse{}
	resp, err := l.Poller.pt.PollUntilDone(ctx, freq, &respType.AgentPool)
	if err != nil {
		return respType, err
	}
	respType.RawResponse = resp
	return respType, nil
}

// Resume rehydrates a AgentPoolsUpgradeNodeImageVersionPollerResponse from the provided client and resume token.
func (l *AgentPoolsUpgradeNodeImageVersionPollerResponse) Resume(ctx context.Context, client *AgentPoolsClient, token string) error {
	pt, err := armruntime.NewPollerFromResumeToken("AgentPoolsClient.UpgradeNodeImageVersion", token, client.pl, client.upgradeNodeImageVersionHandleError)
	if err != nil {
		return err
	}
	poller := &AgentPoolsUpgradeNodeImageVersionPoller{
		pt: pt,
	}
	resp, err := poller.Poll(ctx)
	if err != nil {
		return err
	}
	l.Poller = poller
	l.RawResponse = resp
	return nil
}

// AgentPoolsUpgradeNodeImageVersionResponse contains the response from method AgentPools.UpgradeNodeImageVersion.
type AgentPoolsUpgradeNodeImageVersionResponse struct {
	AgentPoolsUpgradeNodeImageVersionResult
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// AgentPoolsUpgradeNodeImageVersionResult contains the result from method AgentPools.UpgradeNodeImageVersion.
type AgentPoolsUpgradeNodeImageVersionResult struct {
	AgentPool
}

// MaintenanceConfigurationsCreateOrUpdateResponse contains the response from method MaintenanceConfigurations.CreateOrUpdate.
type MaintenanceConfigurationsCreateOrUpdateResponse struct {
	MaintenanceConfigurationsCreateOrUpdateResult
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// MaintenanceConfigurationsCreateOrUpdateResult contains the result from method MaintenanceConfigurations.CreateOrUpdate.
type MaintenanceConfigurationsCreateOrUpdateResult struct {
	MaintenanceConfiguration
}

// MaintenanceConfigurationsDeleteResponse contains the response from method MaintenanceConfigurations.Delete.
type MaintenanceConfigurationsDeleteResponse struct {
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// MaintenanceConfigurationsGetResponse contains the response from method MaintenanceConfigurations.Get.
type MaintenanceConfigurationsGetResponse struct {
	MaintenanceConfigurationsGetResult
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// MaintenanceConfigurationsGetResult contains the result from method MaintenanceConfigurations.Get.
type MaintenanceConfigurationsGetResult struct {
	MaintenanceConfiguration
}

// MaintenanceConfigurationsListByManagedClusterResponse contains the response from method MaintenanceConfigurations.ListByManagedCluster.
type MaintenanceConfigurationsListByManagedClusterResponse struct {
	MaintenanceConfigurationsListByManagedClusterResult
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// MaintenanceConfigurationsListByManagedClusterResult contains the result from method MaintenanceConfigurations.ListByManagedCluster.
type MaintenanceConfigurationsListByManagedClusterResult struct {
	MaintenanceConfigurationListResult
}

// ManagedClustersCreateOrUpdatePollerResponse contains the response from method ManagedClusters.CreateOrUpdate.
type ManagedClustersCreateOrUpdatePollerResponse struct {
	// Poller contains an initialized poller.
	Poller *ManagedClustersCreateOrUpdatePoller

	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// PollUntilDone will poll the service endpoint until a terminal state is reached or an error is received.
func (l ManagedClustersCreateOrUpdatePollerResponse) PollUntilDone(ctx context.Context, freq time.Duration) (ManagedClustersCreateOrUpdateResponse, error) {
	respType := ManagedClustersCreateOrUpdateResponse{}
	resp, err := l.Poller.pt.PollUntilDone(ctx, freq, &respType.ManagedCluster)
	if err != nil {
		return respType, err
	}
	respType.RawResponse = resp
	return respType, nil
}

// Resume rehydrates a ManagedClustersCreateOrUpdatePollerResponse from the provided client and resume token.
func (l *ManagedClustersCreateOrUpdatePollerResponse) Resume(ctx context.Context, client *ManagedClustersClient, token string) error {
	pt, err := armruntime.NewPollerFromResumeToken("ManagedClustersClient.CreateOrUpdate", token, client.pl, client.createOrUpdateHandleError)
	if err != nil {
		return err
	}
	poller := &ManagedClustersCreateOrUpdatePoller{
		pt: pt,
	}
	resp, err := poller.Poll(ctx)
	if err != nil {
		return err
	}
	l.Poller = poller
	l.RawResponse = resp
	return nil
}

// ManagedClustersCreateOrUpdateResponse contains the response from method ManagedClusters.CreateOrUpdate.
type ManagedClustersCreateOrUpdateResponse struct {
	ManagedClustersCreateOrUpdateResult
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// ManagedClustersCreateOrUpdateResult contains the result from method ManagedClusters.CreateOrUpdate.
type ManagedClustersCreateOrUpdateResult struct {
	ManagedCluster
}

// ManagedClustersDeletePollerResponse contains the response from method ManagedClusters.Delete.
type ManagedClustersDeletePollerResponse struct {
	// Poller contains an initialized poller.
	Poller *ManagedClustersDeletePoller

	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// PollUntilDone will poll the service endpoint until a terminal state is reached or an error is received.
func (l ManagedClustersDeletePollerResponse) PollUntilDone(ctx context.Context, freq time.Duration) (ManagedClustersDeleteResponse, error) {
	respType := ManagedClustersDeleteResponse{}
	resp, err := l.Poller.pt.PollUntilDone(ctx, freq, nil)
	if err != nil {
		return respType, err
	}
	respType.RawResponse = resp
	return respType, nil
}

// Resume rehydrates a ManagedClustersDeletePollerResponse from the provided client and resume token.
func (l *ManagedClustersDeletePollerResponse) Resume(ctx context.Context, client *ManagedClustersClient, token string) error {
	pt, err := armruntime.NewPollerFromResumeToken("ManagedClustersClient.Delete", token, client.pl, client.deleteHandleError)
	if err != nil {
		return err
	}
	poller := &ManagedClustersDeletePoller{
		pt: pt,
	}
	resp, err := poller.Poll(ctx)
	if err != nil {
		return err
	}
	l.Poller = poller
	l.RawResponse = resp
	return nil
}

// ManagedClustersDeleteResponse contains the response from method ManagedClusters.Delete.
type ManagedClustersDeleteResponse struct {
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// ManagedClustersGetAccessProfileResponse contains the response from method ManagedClusters.GetAccessProfile.
type ManagedClustersGetAccessProfileResponse struct {
	ManagedClustersGetAccessProfileResult
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// ManagedClustersGetAccessProfileResult contains the result from method ManagedClusters.GetAccessProfile.
type ManagedClustersGetAccessProfileResult struct {
	ManagedClusterAccessProfile
}

// ManagedClustersGetCommandResultResponse contains the response from method ManagedClusters.GetCommandResult.
type ManagedClustersGetCommandResultResponse struct {
	ManagedClustersGetCommandResultResult
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// ManagedClustersGetCommandResultResult contains the result from method ManagedClusters.GetCommandResult.
type ManagedClustersGetCommandResultResult struct {
	RunCommandResult
}

// ManagedClustersGetOSOptionsResponse contains the response from method ManagedClusters.GetOSOptions.
type ManagedClustersGetOSOptionsResponse struct {
	ManagedClustersGetOSOptionsResult
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// ManagedClustersGetOSOptionsResult contains the result from method ManagedClusters.GetOSOptions.
type ManagedClustersGetOSOptionsResult struct {
	OSOptionProfile
}

// ManagedClustersGetResponse contains the response from method ManagedClusters.Get.
type ManagedClustersGetResponse struct {
	ManagedClustersGetResult
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// ManagedClustersGetResult contains the result from method ManagedClusters.Get.
type ManagedClustersGetResult struct {
	ManagedCluster
}

// ManagedClustersGetUpgradeProfileResponse contains the response from method ManagedClusters.GetUpgradeProfile.
type ManagedClustersGetUpgradeProfileResponse struct {
	ManagedClustersGetUpgradeProfileResult
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// ManagedClustersGetUpgradeProfileResult contains the result from method ManagedClusters.GetUpgradeProfile.
type ManagedClustersGetUpgradeProfileResult struct {
	ManagedClusterUpgradeProfile
}

// ManagedClustersListByResourceGroupResponse contains the response from method ManagedClusters.ListByResourceGroup.
type ManagedClustersListByResourceGroupResponse struct {
	ManagedClustersListByResourceGroupResult
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// ManagedClustersListByResourceGroupResult contains the result from method ManagedClusters.ListByResourceGroup.
type ManagedClustersListByResourceGroupResult struct {
	ManagedClusterListResult
}

// ManagedClustersListClusterAdminCredentialsResponse contains the response from method ManagedClusters.ListClusterAdminCredentials.
type ManagedClustersListClusterAdminCredentialsResponse struct {
	ManagedClustersListClusterAdminCredentialsResult
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// ManagedClustersListClusterAdminCredentialsResult contains the result from method ManagedClusters.ListClusterAdminCredentials.
type ManagedClustersListClusterAdminCredentialsResult struct {
	CredentialResults
}

// ManagedClustersListClusterMonitoringUserCredentialsResponse contains the response from method ManagedClusters.ListClusterMonitoringUserCredentials.
type ManagedClustersListClusterMonitoringUserCredentialsResponse struct {
	ManagedClustersListClusterMonitoringUserCredentialsResult
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// ManagedClustersListClusterMonitoringUserCredentialsResult contains the result from method ManagedClusters.ListClusterMonitoringUserCredentials.
type ManagedClustersListClusterMonitoringUserCredentialsResult struct {
	CredentialResults
}

// ManagedClustersListClusterUserCredentialsResponse contains the response from method ManagedClusters.ListClusterUserCredentials.
type ManagedClustersListClusterUserCredentialsResponse struct {
	ManagedClustersListClusterUserCredentialsResult
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// ManagedClustersListClusterUserCredentialsResult contains the result from method ManagedClusters.ListClusterUserCredentials.
type ManagedClustersListClusterUserCredentialsResult struct {
	CredentialResults
}

// ManagedClustersListOutboundNetworkDependenciesEndpointsResponse contains the response from method ManagedClusters.ListOutboundNetworkDependenciesEndpoints.
type ManagedClustersListOutboundNetworkDependenciesEndpointsResponse struct {
	ManagedClustersListOutboundNetworkDependenciesEndpointsResult
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// ManagedClustersListOutboundNetworkDependenciesEndpointsResult contains the result from method ManagedClusters.ListOutboundNetworkDependenciesEndpoints.
type ManagedClustersListOutboundNetworkDependenciesEndpointsResult struct {
	OutboundEnvironmentEndpointCollection
}

// ManagedClustersListResponse contains the response from method ManagedClusters.List.
type ManagedClustersListResponse struct {
	ManagedClustersListResult
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// ManagedClustersListResult contains the result from method ManagedClusters.List.
type ManagedClustersListResult struct {
	ManagedClusterListResult
}

// ManagedClustersResetAADProfilePollerResponse contains the response from method ManagedClusters.ResetAADProfile.
type ManagedClustersResetAADProfilePollerResponse struct {
	// Poller contains an initialized poller.
	Poller *ManagedClustersResetAADProfilePoller

	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// PollUntilDone will poll the service endpoint until a terminal state is reached or an error is received.
func (l ManagedClustersResetAADProfilePollerResponse) PollUntilDone(ctx context.Context, freq time.Duration) (ManagedClustersResetAADProfileResponse, error) {
	respType := ManagedClustersResetAADProfileResponse{}
	resp, err := l.Poller.pt.PollUntilDone(ctx, freq, nil)
	if err != nil {
		return respType, err
	}
	respType.RawResponse = resp
	return respType, nil
}

// Resume rehydrates a ManagedClustersResetAADProfilePollerResponse from the provided client and resume token.
func (l *ManagedClustersResetAADProfilePollerResponse) Resume(ctx context.Context, client *ManagedClustersClient, token string) error {
	pt, err := armruntime.NewPollerFromResumeToken("ManagedClustersClient.ResetAADProfile", token, client.pl, client.resetAADProfileHandleError)
	if err != nil {
		return err
	}
	poller := &ManagedClustersResetAADProfilePoller{
		pt: pt,
	}
	resp, err := poller.Poll(ctx)
	if err != nil {
		return err
	}
	l.Poller = poller
	l.RawResponse = resp
	return nil
}

// ManagedClustersResetAADProfileResponse contains the response from method ManagedClusters.ResetAADProfile.
type ManagedClustersResetAADProfileResponse struct {
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// ManagedClustersResetServicePrincipalProfilePollerResponse contains the response from method ManagedClusters.ResetServicePrincipalProfile.
type ManagedClustersResetServicePrincipalProfilePollerResponse struct {
	// Poller contains an initialized poller.
	Poller *ManagedClustersResetServicePrincipalProfilePoller

	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// PollUntilDone will poll the service endpoint until a terminal state is reached or an error is received.
func (l ManagedClustersResetServicePrincipalProfilePollerResponse) PollUntilDone(ctx context.Context, freq time.Duration) (ManagedClustersResetServicePrincipalProfileResponse, error) {
	respType := ManagedClustersResetServicePrincipalProfileResponse{}
	resp, err := l.Poller.pt.PollUntilDone(ctx, freq, nil)
	if err != nil {
		return respType, err
	}
	respType.RawResponse = resp
	return respType, nil
}

// Resume rehydrates a ManagedClustersResetServicePrincipalProfilePollerResponse from the provided client and resume token.
func (l *ManagedClustersResetServicePrincipalProfilePollerResponse) Resume(ctx context.Context, client *ManagedClustersClient, token string) error {
	pt, err := armruntime.NewPollerFromResumeToken("ManagedClustersClient.ResetServicePrincipalProfile", token, client.pl, client.resetServicePrincipalProfileHandleError)
	if err != nil {
		return err
	}
	poller := &ManagedClustersResetServicePrincipalProfilePoller{
		pt: pt,
	}
	resp, err := poller.Poll(ctx)
	if err != nil {
		return err
	}
	l.Poller = poller
	l.RawResponse = resp
	return nil
}

// ManagedClustersResetServicePrincipalProfileResponse contains the response from method ManagedClusters.ResetServicePrincipalProfile.
type ManagedClustersResetServicePrincipalProfileResponse struct {
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// ManagedClustersRotateClusterCertificatesPollerResponse contains the response from method ManagedClusters.RotateClusterCertificates.
type ManagedClustersRotateClusterCertificatesPollerResponse struct {
	// Poller contains an initialized poller.
	Poller *ManagedClustersRotateClusterCertificatesPoller

	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// PollUntilDone will poll the service endpoint until a terminal state is reached or an error is received.
func (l ManagedClustersRotateClusterCertificatesPollerResponse) PollUntilDone(ctx context.Context, freq time.Duration) (ManagedClustersRotateClusterCertificatesResponse, error) {
	respType := ManagedClustersRotateClusterCertificatesResponse{}
	resp, err := l.Poller.pt.PollUntilDone(ctx, freq, nil)
	if err != nil {
		return respType, err
	}
	respType.RawResponse = resp
	return respType, nil
}

// Resume rehydrates a ManagedClustersRotateClusterCertificatesPollerResponse from the provided client and resume token.
func (l *ManagedClustersRotateClusterCertificatesPollerResponse) Resume(ctx context.Context, client *ManagedClustersClient, token string) error {
	pt, err := armruntime.NewPollerFromResumeToken("ManagedClustersClient.RotateClusterCertificates", token, client.pl, client.rotateClusterCertificatesHandleError)
	if err != nil {
		return err
	}
	poller := &ManagedClustersRotateClusterCertificatesPoller{
		pt: pt,
	}
	resp, err := poller.Poll(ctx)
	if err != nil {
		return err
	}
	l.Poller = poller
	l.RawResponse = resp
	return nil
}

// ManagedClustersRotateClusterCertificatesResponse contains the response from method ManagedClusters.RotateClusterCertificates.
type ManagedClustersRotateClusterCertificatesResponse struct {
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// ManagedClustersRunCommandPollerResponse contains the response from method ManagedClusters.RunCommand.
type ManagedClustersRunCommandPollerResponse struct {
	// Poller contains an initialized poller.
	Poller *ManagedClustersRunCommandPoller

	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// PollUntilDone will poll the service endpoint until a terminal state is reached or an error is received.
func (l ManagedClustersRunCommandPollerResponse) PollUntilDone(ctx context.Context, freq time.Duration) (ManagedClustersRunCommandResponse, error) {
	respType := ManagedClustersRunCommandResponse{}
	resp, err := l.Poller.pt.PollUntilDone(ctx, freq, &respType.RunCommandResult)
	if err != nil {
		return respType, err
	}
	respType.RawResponse = resp
	return respType, nil
}

// Resume rehydrates a ManagedClustersRunCommandPollerResponse from the provided client and resume token.
func (l *ManagedClustersRunCommandPollerResponse) Resume(ctx context.Context, client *ManagedClustersClient, token string) error {
	pt, err := armruntime.NewPollerFromResumeToken("ManagedClustersClient.RunCommand", token, client.pl, client.runCommandHandleError)
	if err != nil {
		return err
	}
	poller := &ManagedClustersRunCommandPoller{
		pt: pt,
	}
	resp, err := poller.Poll(ctx)
	if err != nil {
		return err
	}
	l.Poller = poller
	l.RawResponse = resp
	return nil
}

// ManagedClustersRunCommandResponse contains the response from method ManagedClusters.RunCommand.
type ManagedClustersRunCommandResponse struct {
	ManagedClustersRunCommandResult
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// ManagedClustersRunCommandResult contains the result from method ManagedClusters.RunCommand.
type ManagedClustersRunCommandResult struct {
	RunCommandResult
}

// ManagedClustersStartPollerResponse contains the response from method ManagedClusters.Start.
type ManagedClustersStartPollerResponse struct {
	// Poller contains an initialized poller.
	Poller *ManagedClustersStartPoller

	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// PollUntilDone will poll the service endpoint until a terminal state is reached or an error is received.
func (l ManagedClustersStartPollerResponse) PollUntilDone(ctx context.Context, freq time.Duration) (ManagedClustersStartResponse, error) {
	respType := ManagedClustersStartResponse{}
	resp, err := l.Poller.pt.PollUntilDone(ctx, freq, nil)
	if err != nil {
		return respType, err
	}
	respType.RawResponse = resp
	return respType, nil
}

// Resume rehydrates a ManagedClustersStartPollerResponse from the provided client and resume token.
func (l *ManagedClustersStartPollerResponse) Resume(ctx context.Context, client *ManagedClustersClient, token string) error {
	pt, err := armruntime.NewPollerFromResumeToken("ManagedClustersClient.Start", token, client.pl, client.startHandleError)
	if err != nil {
		return err
	}
	poller := &ManagedClustersStartPoller{
		pt: pt,
	}
	resp, err := poller.Poll(ctx)
	if err != nil {
		return err
	}
	l.Poller = poller
	l.RawResponse = resp
	return nil
}

// ManagedClustersStartResponse contains the response from method ManagedClusters.Start.
type ManagedClustersStartResponse struct {
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// ManagedClustersStopPollerResponse contains the response from method ManagedClusters.Stop.
type ManagedClustersStopPollerResponse struct {
	// Poller contains an initialized poller.
	Poller *ManagedClustersStopPoller

	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// PollUntilDone will poll the service endpoint until a terminal state is reached or an error is received.
func (l ManagedClustersStopPollerResponse) PollUntilDone(ctx context.Context, freq time.Duration) (ManagedClustersStopResponse, error) {
	respType := ManagedClustersStopResponse{}
	resp, err := l.Poller.pt.PollUntilDone(ctx, freq, nil)
	if err != nil {
		return respType, err
	}
	respType.RawResponse = resp
	return respType, nil
}

// Resume rehydrates a ManagedClustersStopPollerResponse from the provided client and resume token.
func (l *ManagedClustersStopPollerResponse) Resume(ctx context.Context, client *ManagedClustersClient, token string) error {
	pt, err := armruntime.NewPollerFromResumeToken("ManagedClustersClient.Stop", token, client.pl, client.stopHandleError)
	if err != nil {
		return err
	}
	poller := &ManagedClustersStopPoller{
		pt: pt,
	}
	resp, err := poller.Poll(ctx)
	if err != nil {
		return err
	}
	l.Poller = poller
	l.RawResponse = resp
	return nil
}

// ManagedClustersStopResponse contains the response from method ManagedClusters.Stop.
type ManagedClustersStopResponse struct {
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// ManagedClustersUpdateTagsPollerResponse contains the response from method ManagedClusters.UpdateTags.
type ManagedClustersUpdateTagsPollerResponse struct {
	// Poller contains an initialized poller.
	Poller *ManagedClustersUpdateTagsPoller

	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// PollUntilDone will poll the service endpoint until a terminal state is reached or an error is received.
func (l ManagedClustersUpdateTagsPollerResponse) PollUntilDone(ctx context.Context, freq time.Duration) (ManagedClustersUpdateTagsResponse, error) {
	respType := ManagedClustersUpdateTagsResponse{}
	resp, err := l.Poller.pt.PollUntilDone(ctx, freq, &respType.ManagedCluster)
	if err != nil {
		return respType, err
	}
	respType.RawResponse = resp
	return respType, nil
}

// Resume rehydrates a ManagedClustersUpdateTagsPollerResponse from the provided client and resume token.
func (l *ManagedClustersUpdateTagsPollerResponse) Resume(ctx context.Context, client *ManagedClustersClient, token string) error {
	pt, err := armruntime.NewPollerFromResumeToken("ManagedClustersClient.UpdateTags", token, client.pl, client.updateTagsHandleError)
	if err != nil {
		return err
	}
	poller := &ManagedClustersUpdateTagsPoller{
		pt: pt,
	}
	resp, err := poller.Poll(ctx)
	if err != nil {
		return err
	}
	l.Poller = poller
	l.RawResponse = resp
	return nil
}

// ManagedClustersUpdateTagsResponse contains the response from method ManagedClusters.UpdateTags.
type ManagedClustersUpdateTagsResponse struct {
	ManagedClustersUpdateTagsResult
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// ManagedClustersUpdateTagsResult contains the result from method ManagedClusters.UpdateTags.
type ManagedClustersUpdateTagsResult struct {
	ManagedCluster
}

// OperationsListResponse contains the response from method Operations.List.
type OperationsListResponse struct {
	OperationsListResult
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// OperationsListResult contains the result from method Operations.List.
type OperationsListResult struct {
	OperationListResult
}

// PrivateEndpointConnectionsDeletePollerResponse contains the response from method PrivateEndpointConnections.Delete.
type PrivateEndpointConnectionsDeletePollerResponse struct {
	// Poller contains an initialized poller.
	Poller *PrivateEndpointConnectionsDeletePoller

	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// PollUntilDone will poll the service endpoint until a terminal state is reached or an error is received.
func (l PrivateEndpointConnectionsDeletePollerResponse) PollUntilDone(ctx context.Context, freq time.Duration) (PrivateEndpointConnectionsDeleteResponse, error) {
	respType := PrivateEndpointConnectionsDeleteResponse{}
	resp, err := l.Poller.pt.PollUntilDone(ctx, freq, nil)
	if err != nil {
		return respType, err
	}
	respType.RawResponse = resp
	return respType, nil
}

// Resume rehydrates a PrivateEndpointConnectionsDeletePollerResponse from the provided client and resume token.
func (l *PrivateEndpointConnectionsDeletePollerResponse) Resume(ctx context.Context, client *PrivateEndpointConnectionsClient, token string) error {
	pt, err := armruntime.NewPollerFromResumeToken("PrivateEndpointConnectionsClient.Delete", token, client.pl, client.deleteHandleError)
	if err != nil {
		return err
	}
	poller := &PrivateEndpointConnectionsDeletePoller{
		pt: pt,
	}
	resp, err := poller.Poll(ctx)
	if err != nil {
		return err
	}
	l.Poller = poller
	l.RawResponse = resp
	return nil
}

// PrivateEndpointConnectionsDeleteResponse contains the response from method PrivateEndpointConnections.Delete.
type PrivateEndpointConnectionsDeleteResponse struct {
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// PrivateEndpointConnectionsGetResponse contains the response from method PrivateEndpointConnections.Get.
type PrivateEndpointConnectionsGetResponse struct {
	PrivateEndpointConnectionsGetResult
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// PrivateEndpointConnectionsGetResult contains the result from method PrivateEndpointConnections.Get.
type PrivateEndpointConnectionsGetResult struct {
	PrivateEndpointConnection
}

// PrivateEndpointConnectionsListResponse contains the response from method PrivateEndpointConnections.List.
type PrivateEndpointConnectionsListResponse struct {
	PrivateEndpointConnectionsListResult
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// PrivateEndpointConnectionsListResult contains the result from method PrivateEndpointConnections.List.
type PrivateEndpointConnectionsListResult struct {
	PrivateEndpointConnectionListResult
}

// PrivateEndpointConnectionsUpdateResponse contains the response from method PrivateEndpointConnections.Update.
type PrivateEndpointConnectionsUpdateResponse struct {
	PrivateEndpointConnectionsUpdateResult
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// PrivateEndpointConnectionsUpdateResult contains the result from method PrivateEndpointConnections.Update.
type PrivateEndpointConnectionsUpdateResult struct {
	PrivateEndpointConnection
}

// PrivateLinkResourcesListResponse contains the response from method PrivateLinkResources.List.
type PrivateLinkResourcesListResponse struct {
	PrivateLinkResourcesListResultEnvelope
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// PrivateLinkResourcesListResultEnvelope contains the result from method PrivateLinkResources.List.
type PrivateLinkResourcesListResultEnvelope struct {
	PrivateLinkResourcesListResult
}

// ResolvePrivateLinkServiceIDPOSTResponse contains the response from method ResolvePrivateLinkServiceID.POST.
type ResolvePrivateLinkServiceIDPOSTResponse struct {
	ResolvePrivateLinkServiceIDPOSTResult
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// ResolvePrivateLinkServiceIDPOSTResult contains the result from method ResolvePrivateLinkServiceID.POST.
type ResolvePrivateLinkServiceIDPOSTResult struct {
	PrivateLinkResource
}

// SnapshotsCreateOrUpdateResponse contains the response from method Snapshots.CreateOrUpdate.
type SnapshotsCreateOrUpdateResponse struct {
	SnapshotsCreateOrUpdateResult
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// SnapshotsCreateOrUpdateResult contains the result from method Snapshots.CreateOrUpdate.
type SnapshotsCreateOrUpdateResult struct {
	Snapshot
}

// SnapshotsDeleteResponse contains the response from method Snapshots.Delete.
type SnapshotsDeleteResponse struct {
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// SnapshotsGetResponse contains the response from method Snapshots.Get.
type SnapshotsGetResponse struct {
	SnapshotsGetResult
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// SnapshotsGetResult contains the result from method Snapshots.Get.
type SnapshotsGetResult struct {
	Snapshot
}

// SnapshotsListByResourceGroupResponse contains the response from method Snapshots.ListByResourceGroup.
type SnapshotsListByResourceGroupResponse struct {
	SnapshotsListByResourceGroupResult
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// SnapshotsListByResourceGroupResult contains the result from method Snapshots.ListByResourceGroup.
type SnapshotsListByResourceGroupResult struct {
	SnapshotListResult
}

// SnapshotsListResponse contains the response from method Snapshots.List.
type SnapshotsListResponse struct {
	SnapshotsListResult
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// SnapshotsListResult contains the result from method Snapshots.List.
type SnapshotsListResult struct {
	SnapshotListResult
}

// SnapshotsUpdateTagsResponse contains the response from method Snapshots.UpdateTags.
type SnapshotsUpdateTagsResponse struct {
	SnapshotsUpdateTagsResult
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// SnapshotsUpdateTagsResult contains the result from method Snapshots.UpdateTags.
type SnapshotsUpdateTagsResult struct {
	Snapshot
}
