/*
Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved. This file is licensed under the Apache Software License, v. 2 except as noted otherwise in the LICENSE file

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: github.com/gardener/gardener/pkg/apis/seedmanagement/v1alpha1/generated.proto

package v1alpha1

import (
	fmt "fmt"

	v1beta1 "github.com/gardener/gardener/pkg/apis/core/v1beta1"

	io "io"

	proto "github.com/gogo/protobuf/proto"
	github_com_gogo_protobuf_sortkeys "github.com/gogo/protobuf/sortkeys"
	k8s_io_api_core_v1 "k8s.io/api/core/v1"
	v1 "k8s.io/api/core/v1"

	math "math"
	math_bits "math/bits"
	reflect "reflect"
	strings "strings"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion3 // please upgrade the proto package

func (m *Gardenlet) Reset()      { *m = Gardenlet{} }
func (*Gardenlet) ProtoMessage() {}
func (*Gardenlet) Descriptor() ([]byte, []int) {
	return fileDescriptor_d64c05a219673fe5, []int{0}
}
func (m *Gardenlet) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Gardenlet) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalToSizedBuffer(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (m *Gardenlet) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Gardenlet.Merge(m, src)
}
func (m *Gardenlet) XXX_Size() int {
	return m.Size()
}
func (m *Gardenlet) XXX_DiscardUnknown() {
	xxx_messageInfo_Gardenlet.DiscardUnknown(m)
}

var xxx_messageInfo_Gardenlet proto.InternalMessageInfo

func (m *GardenletDeployment) Reset()      { *m = GardenletDeployment{} }
func (*GardenletDeployment) ProtoMessage() {}
func (*GardenletDeployment) Descriptor() ([]byte, []int) {
	return fileDescriptor_d64c05a219673fe5, []int{1}
}
func (m *GardenletDeployment) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GardenletDeployment) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalToSizedBuffer(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (m *GardenletDeployment) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GardenletDeployment.Merge(m, src)
}
func (m *GardenletDeployment) XXX_Size() int {
	return m.Size()
}
func (m *GardenletDeployment) XXX_DiscardUnknown() {
	xxx_messageInfo_GardenletDeployment.DiscardUnknown(m)
}

var xxx_messageInfo_GardenletDeployment proto.InternalMessageInfo

func (m *Image) Reset()      { *m = Image{} }
func (*Image) ProtoMessage() {}
func (*Image) Descriptor() ([]byte, []int) {
	return fileDescriptor_d64c05a219673fe5, []int{2}
}
func (m *Image) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Image) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalToSizedBuffer(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (m *Image) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Image.Merge(m, src)
}
func (m *Image) XXX_Size() int {
	return m.Size()
}
func (m *Image) XXX_DiscardUnknown() {
	xxx_messageInfo_Image.DiscardUnknown(m)
}

var xxx_messageInfo_Image proto.InternalMessageInfo

func (m *ManagedSeed) Reset()      { *m = ManagedSeed{} }
func (*ManagedSeed) ProtoMessage() {}
func (*ManagedSeed) Descriptor() ([]byte, []int) {
	return fileDescriptor_d64c05a219673fe5, []int{3}
}
func (m *ManagedSeed) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ManagedSeed) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalToSizedBuffer(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (m *ManagedSeed) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ManagedSeed.Merge(m, src)
}
func (m *ManagedSeed) XXX_Size() int {
	return m.Size()
}
func (m *ManagedSeed) XXX_DiscardUnknown() {
	xxx_messageInfo_ManagedSeed.DiscardUnknown(m)
}

var xxx_messageInfo_ManagedSeed proto.InternalMessageInfo

func (m *ManagedSeedList) Reset()      { *m = ManagedSeedList{} }
func (*ManagedSeedList) ProtoMessage() {}
func (*ManagedSeedList) Descriptor() ([]byte, []int) {
	return fileDescriptor_d64c05a219673fe5, []int{4}
}
func (m *ManagedSeedList) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ManagedSeedList) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalToSizedBuffer(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (m *ManagedSeedList) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ManagedSeedList.Merge(m, src)
}
func (m *ManagedSeedList) XXX_Size() int {
	return m.Size()
}
func (m *ManagedSeedList) XXX_DiscardUnknown() {
	xxx_messageInfo_ManagedSeedList.DiscardUnknown(m)
}

var xxx_messageInfo_ManagedSeedList proto.InternalMessageInfo

func (m *ManagedSeedSpec) Reset()      { *m = ManagedSeedSpec{} }
func (*ManagedSeedSpec) ProtoMessage() {}
func (*ManagedSeedSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_d64c05a219673fe5, []int{5}
}
func (m *ManagedSeedSpec) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ManagedSeedSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalToSizedBuffer(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (m *ManagedSeedSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ManagedSeedSpec.Merge(m, src)
}
func (m *ManagedSeedSpec) XXX_Size() int {
	return m.Size()
}
func (m *ManagedSeedSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_ManagedSeedSpec.DiscardUnknown(m)
}

var xxx_messageInfo_ManagedSeedSpec proto.InternalMessageInfo

func (m *ManagedSeedStatus) Reset()      { *m = ManagedSeedStatus{} }
func (*ManagedSeedStatus) ProtoMessage() {}
func (*ManagedSeedStatus) Descriptor() ([]byte, []int) {
	return fileDescriptor_d64c05a219673fe5, []int{6}
}
func (m *ManagedSeedStatus) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ManagedSeedStatus) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalToSizedBuffer(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (m *ManagedSeedStatus) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ManagedSeedStatus.Merge(m, src)
}
func (m *ManagedSeedStatus) XXX_Size() int {
	return m.Size()
}
func (m *ManagedSeedStatus) XXX_DiscardUnknown() {
	xxx_messageInfo_ManagedSeedStatus.DiscardUnknown(m)
}

var xxx_messageInfo_ManagedSeedStatus proto.InternalMessageInfo

func (m *Shoot) Reset()      { *m = Shoot{} }
func (*Shoot) ProtoMessage() {}
func (*Shoot) Descriptor() ([]byte, []int) {
	return fileDescriptor_d64c05a219673fe5, []int{7}
}
func (m *Shoot) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Shoot) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalToSizedBuffer(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (m *Shoot) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Shoot.Merge(m, src)
}
func (m *Shoot) XXX_Size() int {
	return m.Size()
}
func (m *Shoot) XXX_DiscardUnknown() {
	xxx_messageInfo_Shoot.DiscardUnknown(m)
}

var xxx_messageInfo_Shoot proto.InternalMessageInfo

func init() {
	proto.RegisterType((*Gardenlet)(nil), "github.com.gardener.gardener.pkg.apis.seedmanagement.v1alpha1.Gardenlet")
	proto.RegisterType((*GardenletDeployment)(nil), "github.com.gardener.gardener.pkg.apis.seedmanagement.v1alpha1.GardenletDeployment")
	proto.RegisterMapType((map[string]string)(nil), "github.com.gardener.gardener.pkg.apis.seedmanagement.v1alpha1.GardenletDeployment.PodAnnotationsEntry")
	proto.RegisterMapType((map[string]string)(nil), "github.com.gardener.gardener.pkg.apis.seedmanagement.v1alpha1.GardenletDeployment.PodLabelsEntry")
	proto.RegisterType((*Image)(nil), "github.com.gardener.gardener.pkg.apis.seedmanagement.v1alpha1.Image")
	proto.RegisterType((*ManagedSeed)(nil), "github.com.gardener.gardener.pkg.apis.seedmanagement.v1alpha1.ManagedSeed")
	proto.RegisterType((*ManagedSeedList)(nil), "github.com.gardener.gardener.pkg.apis.seedmanagement.v1alpha1.ManagedSeedList")
	proto.RegisterType((*ManagedSeedSpec)(nil), "github.com.gardener.gardener.pkg.apis.seedmanagement.v1alpha1.ManagedSeedSpec")
	proto.RegisterType((*ManagedSeedStatus)(nil), "github.com.gardener.gardener.pkg.apis.seedmanagement.v1alpha1.ManagedSeedStatus")
	proto.RegisterType((*Shoot)(nil), "github.com.gardener.gardener.pkg.apis.seedmanagement.v1alpha1.Shoot")
}

func init() {
	proto.RegisterFile("github.com/gardener/gardener/pkg/apis/seedmanagement/v1alpha1/generated.proto", fileDescriptor_d64c05a219673fe5)
}

var fileDescriptor_d64c05a219673fe5 = []byte{
	// 1191 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xb4, 0x56, 0x4f, 0x6f, 0xdb, 0x36,
	0x14, 0x8f, 0xec, 0x38, 0x8d, 0xe8, 0x34, 0x7f, 0x98, 0x20, 0x50, 0x0d, 0xcc, 0x0e, 0x7c, 0xca,
	0x0e, 0x95, 0x97, 0xa0, 0x18, 0xb2, 0x61, 0x01, 0x66, 0xa5, 0x59, 0xff, 0x20, 0x69, 0x0c, 0xa6,
	0xcd, 0x80, 0x61, 0x87, 0xd1, 0x12, 0x23, 0x73, 0x91, 0x44, 0x55, 0xa4, 0xdd, 0xfa, 0x36, 0xec,
	0x13, 0x0c, 0xfd, 0x0a, 0x03, 0xf6, 0x59, 0x72, 0x2c, 0x76, 0x2a, 0x30, 0xc0, 0x48, 0xb4, 0xe3,
	0xbe, 0x41, 0x4f, 0x03, 0x29, 0xd9, 0x92, 0x63, 0x07, 0xcb, 0x96, 0xec, 0xc6, 0xf7, 0xf8, 0xde,
	0xef, 0xf7, 0xf8, 0xf8, 0xf8, 0x1e, 0xc1, 0xa1, 0x4b, 0x45, 0xa7, 0xdb, 0x36, 0x6d, 0xe6, 0x37,
	0x5c, 0x1c, 0x39, 0x24, 0x20, 0x51, 0xb6, 0x08, 0xcf, 0xdc, 0x06, 0x0e, 0x29, 0x6f, 0x70, 0x42,
	0x1c, 0x1f, 0x07, 0xd8, 0x25, 0x3e, 0x09, 0x44, 0xa3, 0xb7, 0x85, 0xbd, 0xb0, 0x83, 0xb7, 0x1a,
	0xae, 0x34, 0xc3, 0x82, 0x38, 0x66, 0x18, 0x31, 0xc1, 0xe0, 0x6e, 0x06, 0x67, 0x0e, 0x51, 0xb2,
	0x45, 0x78, 0xe6, 0x9a, 0x12, 0xce, 0x1c, 0x87, 0x33, 0x87, 0x70, 0x15, 0xeb, 0x66, 0xd1, 0xd8,
	0x2c, 0x22, 0x8d, 0xde, 0x56, 0x9b, 0x88, 0xc9, 0x10, 0x2a, 0x0f, 0xf3, 0x18, 0xcc, 0x65, 0x0d,
	0xa5, 0x6e, 0x77, 0x4f, 0x95, 0xa4, 0x04, 0xb5, 0x4a, 0xcd, 0xeb, 0x67, 0x3b, 0xdc, 0xa4, 0x4c,
	0x02, 0x0f, 0x71, 0x27, 0x20, 0x1f, 0x65, 0x36, 0x3e, 0xb6, 0x3b, 0x34, 0x20, 0x51, 0x3f, 0x8b,
	0xc6, 0x27, 0x02, 0x4f, 0xf3, 0x6a, 0x5c, 0xe7, 0x15, 0x75, 0x03, 0x41, 0x7d, 0x32, 0xe1, 0xf0,
	0xf9, 0x3f, 0x39, 0x70, 0xbb, 0x43, 0x7c, 0x7c, 0xd5, 0xaf, 0x7e, 0x51, 0x00, 0xfa, 0x13, 0x95,
	0x24, 0x8f, 0x08, 0xf8, 0xb3, 0x06, 0x80, 0x43, 0x42, 0x8f, 0xf5, 0x65, 0x6e, 0x0d, 0x6d, 0x43,
	0xdb, 0x2c, 0x6f, 0x23, 0xf3, 0x56, 0x17, 0x63, 0x8e, 0xe0, 0x1f, 0x8f, 0x90, 0xad, 0xc5, 0x78,
	0x50, 0x03, 0x99, 0x8c, 0x72, 0xac, 0xf0, 0x15, 0x98, 0xb3, 0x59, 0x70, 0x4a, 0x5d, 0xa3, 0xa0,
	0xf8, 0x1f, 0x9a, 0xc9, 0xd9, 0xcc, 0xfc, 0xd9, 0x14, 0x6d, 0x7a, 0x36, 0x13, 0xe1, 0x37, 0xfb,
	0x6f, 0x05, 0x09, 0x38, 0x65, 0x81, 0xb5, 0x78, 0x3e, 0xa8, 0xcd, 0xc4, 0x83, 0xda, 0xdc, 0x9e,
	0x02, 0x41, 0x29, 0x18, 0xdc, 0x01, 0x7a, 0x9b, 0x31, 0xc1, 0x45, 0x84, 0x43, 0xa3, 0xb8, 0xa1,
	0x6d, 0xea, 0x56, 0x25, 0x1e, 0xd4, 0x74, 0x6b, 0xa8, 0xfc, 0x98, 0x17, 0x50, 0x66, 0x0c, 0x77,
	0xc1, 0x92, 0x4f, 0x22, 0x97, 0x7c, 0x4b, 0x45, 0xa7, 0x85, 0x23, 0x99, 0x99, 0xd9, 0x0d, 0x6d,
	0x73, 0xde, 0x5a, 0x8d, 0x07, 0xb5, 0xa5, 0xc3, 0xf1, 0x2d, 0x74, 0xd5, 0xb6, 0xfe, 0x4e, 0x07,
	0xab, 0x53, 0x72, 0x00, 0x1f, 0x81, 0x85, 0x88, 0x84, 0x1e, 0xb5, 0xf1, 0x1e, 0xeb, 0xa6, 0xd9,
	0x2e, 0x59, 0xcb, 0xf1, 0xa0, 0xb6, 0x80, 0x72, 0x7a, 0x34, 0x66, 0x05, 0x0f, 0xc0, 0x5a, 0x44,
	0x7a, 0x54, 0x1e, 0xf5, 0x29, 0xe5, 0x82, 0x45, 0xfd, 0x03, 0xea, 0x53, 0xa1, 0x72, 0x55, 0xb2,
	0x8c, 0x78, 0x50, 0x5b, 0x43, 0x53, 0xf6, 0xd1, 0x54, 0x2f, 0xf8, 0x0d, 0x80, 0x9c, 0x44, 0x3d,
	0x6a, 0x93, 0xa6, 0x6d, 0x4b, 0xfc, 0x17, 0xd8, 0x27, 0x69, 0x76, 0xd6, 0xe3, 0x41, 0x0d, 0x1e,
	0x4f, 0xec, 0xa2, 0x29, 0x1e, 0x90, 0x80, 0x12, 0xf5, 0xb1, 0x4b, 0x54, 0x62, 0xca, 0xdb, 0x8f,
	0x6f, 0x59, 0x32, 0xcf, 0x24, 0x96, 0xa5, 0xc7, 0x83, 0x5a, 0x49, 0x2d, 0x51, 0x82, 0x0e, 0x5f,
	0x01, 0x3d, 0x22, 0x9c, 0x75, 0x23, 0x9b, 0x70, 0xa3, 0xa4, 0xa8, 0x36, 0x73, 0xd5, 0x61, 0xca,
	0x47, 0x68, 0xf6, 0xb6, 0x4c, 0x94, 0x1a, 0x21, 0xf2, 0xba, 0x4b, 0x23, 0x05, 0xce, 0xad, 0xfb,
	0xf2, 0xb6, 0x87, 0x3b, 0x1c, 0x65, 0x48, 0xf0, 0x9d, 0x06, 0xf4, 0x90, 0x39, 0x07, 0xb8, 0x4d,
	0x3c, 0x6e, 0xcc, 0x6d, 0x14, 0x37, 0xcb, 0xdb, 0xf8, 0xee, 0xab, 0xde, 0x6c, 0x0d, 0x39, 0xf6,
	0x03, 0x11, 0xf5, 0xad, 0x95, 0xb4, 0x52, 0xf5, 0x91, 0x1e, 0x65, 0x61, 0xc0, 0xdf, 0x34, 0xb0,
	0x18, 0x32, 0xa7, 0x19, 0x04, 0x4c, 0x60, 0x41, 0x59, 0xc0, 0x8d, 0x7b, 0x2a, 0xb2, 0xd3, 0xff,
	0x27, 0xb2, 0x1c, 0x51, 0x12, 0xde, 0x7a, 0x1a, 0xde, 0xe2, 0xf8, 0x26, 0xba, 0x12, 0x15, 0xb4,
	0xc1, 0x0a, 0x76, 0x1c, 0x2a, 0x05, 0xec, 0x9d, 0x30, 0xaf, 0xeb, 0x13, 0x6e, 0xcc, 0xab, 0x50,
	0x2b, 0xd3, 0x2e, 0x27, 0x31, 0xb1, 0x1e, 0xa4, 0xf0, 0x2b, 0xcd, 0xab, 0xce, 0x68, 0x12, 0x0f,
	0xbe, 0x01, 0xeb, 0x57, 0x95, 0x87, 0xb2, 0xfa, 0xb8, 0xa1, 0x2b, 0xa6, 0xda, 0xf5, 0x4c, 0xca,
	0xce, 0xaa, 0xa6, 0x74, 0xeb, 0xcd, 0xa9, 0x30, 0xe8, 0x1a, 0x78, 0xf8, 0x05, 0x28, 0x92, 0xa0,
	0x67, 0x80, 0xeb, 0xcf, 0xb3, 0x1f, 0xf4, 0x4e, 0x70, 0x64, 0x95, 0x53, 0x82, 0xe2, 0x7e, 0xd0,
	0x43, 0xd2, 0x07, 0x3e, 0x00, 0xc5, 0x5e, 0x88, 0x8d, 0xb2, 0xea, 0x15, 0xf7, 0xe4, 0xd6, 0x49,
	0xab, 0x89, 0xa4, 0xae, 0xf2, 0x15, 0x58, 0x1c, 0x2f, 0x06, 0xb8, 0x0c, 0x8a, 0x67, 0xa4, 0xaf,
	0x9a, 0x80, 0x8e, 0xe4, 0x12, 0xae, 0x81, 0x52, 0x0f, 0x7b, 0x5d, 0xa2, 0x9e, 0xb6, 0x8e, 0x12,
	0xe1, 0xcb, 0xc2, 0x8e, 0x56, 0x69, 0x82, 0xd5, 0x29, 0x17, 0xf6, 0x6f, 0x20, 0xea, 0xbf, 0x6a,
	0x20, 0x79, 0x5a, 0xd0, 0x04, 0x20, 0x22, 0x21, 0xe3, 0x54, 0x76, 0x85, 0xc4, 0x39, 0x69, 0xcf,
	0x68, 0xa4, 0x45, 0x39, 0x0b, 0x79, 0x2a, 0x81, 0x93, 0xde, 0xac, 0x27, 0xa7, 0x7a, 0x89, 0x5d,
	0x24, 0x75, 0xf0, 0x08, 0x80, 0xb0, 0xeb, 0x79, 0x2d, 0xe6, 0x51, 0xbb, 0x9f, 0x76, 0x91, 0x86,
	0x84, 0x6a, 0x8d, 0xb4, 0x1f, 0x07, 0xb5, 0x4f, 0x26, 0xa7, 0xa6, 0x99, 0x19, 0xa0, 0x1c, 0x44,
	0xfd, 0x8f, 0x02, 0x28, 0x1f, 0xaa, 0x12, 0x76, 0x8e, 0x09, 0x71, 0xe0, 0x0f, 0x60, 0x5e, 0x4e,
	0x4c, 0x07, 0x0b, 0x9c, 0x0e, 0xa7, 0xcf, 0xae, 0x1d, 0x0e, 0xea, 0x0d, 0x48, 0x6b, 0x79, 0x47,
	0x47, 0xed, 0x1f, 0x89, 0x2d, 0x0e, 0x89, 0xc0, 0x16, 0x4c, 0xef, 0x09, 0x64, 0x3a, 0x34, 0x42,
	0x85, 0x21, 0x98, 0xe5, 0x21, 0xb1, 0xd3, 0xd1, 0xf3, 0xe2, 0x96, 0x4f, 0x2d, 0x17, 0xfb, 0x71,
	0x48, 0x6c, 0x6b, 0x21, 0xe5, 0x9e, 0x95, 0x12, 0x52, 0x4c, 0xf0, 0x2d, 0x98, 0xe3, 0x02, 0x8b,
	0x2e, 0x57, 0x09, 0x2b, 0x6f, 0xb7, 0xee, 0x90, 0x53, 0xe1, 0x66, 0x13, 0x31, 0x91, 0x51, 0xca,
	0x57, 0xbf, 0xd0, 0xc0, 0x52, 0xce, 0xfa, 0x80, 0x72, 0x01, 0xbf, 0x9f, 0xc8, 0xb0, 0x79, 0xb3,
	0x0c, 0x4b, 0x6f, 0x95, 0xdf, 0xe5, 0x94, 0x6d, 0x7e, 0xa8, 0xc9, 0x65, 0x97, 0x81, 0x12, 0x15,
	0xc4, 0xe7, 0x46, 0x41, 0x3d, 0xa7, 0xe7, 0x77, 0x77, 0x54, 0xeb, 0x7e, 0x4a, 0x5b, 0x7a, 0x26,
	0x09, 0x50, 0xc2, 0x53, 0xff, 0xab, 0x30, 0x76, 0x44, 0x99, 0x76, 0x48, 0x41, 0x89, 0x77, 0x18,
	0x1b, 0x7e, 0x6f, 0x6e, 0x3b, 0xab, 0x8e, 0x25, 0x56, 0x46, 0xaf, 0x44, 0x94, 0x30, 0xc0, 0x1e,
	0x58, 0x90, 0x6e, 0x2f, 0x89, 0x1f, 0x7a, 0x58, 0x90, 0xb4, 0xaa, 0xbe, 0xbe, 0x21, 0x63, 0xda,
	0x60, 0xd4, 0x57, 0xd5, 0x3c, 0xce, 0xe1, 0x24, 0x9f, 0x84, 0xbc, 0x06, 0x8d, 0xf1, 0xc0, 0x2e,
	0xd0, 0xdd, 0x61, 0x97, 0x4f, 0xcb, 0xea, 0xe9, 0x5d, 0x4d, 0x8d, 0x64, 0x8e, 0x8e, 0x44, 0x94,
	0x31, 0xd5, 0x7f, 0xd7, 0xc0, 0xca, 0x44, 0xf9, 0xc1, 0xd7, 0x00, 0xd8, 0x2c, 0x48, 0x9a, 0x2b,
	0x37, 0x34, 0x75, 0xf3, 0xbb, 0xff, 0x25, 0x05, 0x7b, 0x43, 0x94, 0xec, 0x0d, 0x8f, 0x54, 0x1c,
	0xe5, 0x48, 0xe0, 0x73, 0x00, 0x59, 0x5b, 0x7e, 0x53, 0x88, 0xf3, 0x24, 0xf9, 0xf0, 0x52, 0x16,
	0xa8, 0xec, 0x17, 0xad, 0x4a, 0xea, 0x0b, 0x8f, 0x26, 0x2c, 0xd0, 0x14, 0xaf, 0xfa, 0xa7, 0x20,
	0xb9, 0x53, 0xb8, 0x01, 0x66, 0x03, 0xf9, 0x3b, 0x4a, 0x5a, 0xe4, 0xe8, 0x29, 0xab, 0x3f, 0x91,
	0xda, 0xb1, 0xcc, 0xf3, 0xcb, 0xea, 0xcc, 0xfb, 0xcb, 0xea, 0xcc, 0x87, 0xcb, 0xea, 0xcc, 0x4f,
	0x71, 0x55, 0x3b, 0x8f, 0xab, 0xda, 0xfb, 0xb8, 0xaa, 0x7d, 0x88, 0xab, 0xda, 0x45, 0x5c, 0xd5,
	0x7e, 0xf9, 0xb3, 0x3a, 0xf3, 0xdd, 0xfc, 0x30, 0xa7, 0x7f, 0x07, 0x00, 0x00, 0xff, 0xff, 0x60,
	0xdf, 0xee, 0x25, 0x41, 0x0d, 0x00, 0x00,
}

func (m *Gardenlet) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Gardenlet) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Gardenlet) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.MergeWithParent != nil {
		i--
		if *m.MergeWithParent {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x20
	}
	if m.Bootstrap != nil {
		i -= len(*m.Bootstrap)
		copy(dAtA[i:], *m.Bootstrap)
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Bootstrap)))
		i--
		dAtA[i] = 0x1a
	}
	{
		size, err := m.Config.MarshalToSizedBuffer(dAtA[:i])
		if err != nil {
			return 0, err
		}
		i -= size
		i = encodeVarintGenerated(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0x12
	if m.Deployment != nil {
		{
			size, err := m.Deployment.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintGenerated(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *GardenletDeployment) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GardenletDeployment) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GardenletDeployment) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.VPA != nil {
		i--
		if *m.VPA {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x58
	}
	if len(m.Env) > 0 {
		for iNdEx := len(m.Env) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Env[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintGenerated(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x52
		}
	}
	if len(m.AdditionalVolumeMounts) > 0 {
		for iNdEx := len(m.AdditionalVolumeMounts) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.AdditionalVolumeMounts[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintGenerated(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x4a
		}
	}
	if len(m.AdditionalVolumes) > 0 {
		for iNdEx := len(m.AdditionalVolumes) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.AdditionalVolumes[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintGenerated(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x42
		}
	}
	if len(m.PodAnnotations) > 0 {
		keysForPodAnnotations := make([]string, 0, len(m.PodAnnotations))
		for k := range m.PodAnnotations {
			keysForPodAnnotations = append(keysForPodAnnotations, string(k))
		}
		github_com_gogo_protobuf_sortkeys.Strings(keysForPodAnnotations)
		for iNdEx := len(keysForPodAnnotations) - 1; iNdEx >= 0; iNdEx-- {
			v := m.PodAnnotations[string(keysForPodAnnotations[iNdEx])]
			baseI := i
			i -= len(v)
			copy(dAtA[i:], v)
			i = encodeVarintGenerated(dAtA, i, uint64(len(v)))
			i--
			dAtA[i] = 0x12
			i -= len(keysForPodAnnotations[iNdEx])
			copy(dAtA[i:], keysForPodAnnotations[iNdEx])
			i = encodeVarintGenerated(dAtA, i, uint64(len(keysForPodAnnotations[iNdEx])))
			i--
			dAtA[i] = 0xa
			i = encodeVarintGenerated(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x3a
		}
	}
	if len(m.PodLabels) > 0 {
		keysForPodLabels := make([]string, 0, len(m.PodLabels))
		for k := range m.PodLabels {
			keysForPodLabels = append(keysForPodLabels, string(k))
		}
		github_com_gogo_protobuf_sortkeys.Strings(keysForPodLabels)
		for iNdEx := len(keysForPodLabels) - 1; iNdEx >= 0; iNdEx-- {
			v := m.PodLabels[string(keysForPodLabels[iNdEx])]
			baseI := i
			i -= len(v)
			copy(dAtA[i:], v)
			i = encodeVarintGenerated(dAtA, i, uint64(len(v)))
			i--
			dAtA[i] = 0x12
			i -= len(keysForPodLabels[iNdEx])
			copy(dAtA[i:], keysForPodLabels[iNdEx])
			i = encodeVarintGenerated(dAtA, i, uint64(len(keysForPodLabels[iNdEx])))
			i--
			dAtA[i] = 0xa
			i = encodeVarintGenerated(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x32
		}
	}
	if m.Resources != nil {
		{
			size, err := m.Resources.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintGenerated(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x2a
	}
	if m.Image != nil {
		{
			size, err := m.Image.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintGenerated(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	if m.ServiceAccountName != nil {
		i -= len(*m.ServiceAccountName)
		copy(dAtA[i:], *m.ServiceAccountName)
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.ServiceAccountName)))
		i--
		dAtA[i] = 0x1a
	}
	if m.RevisionHistoryLimit != nil {
		i = encodeVarintGenerated(dAtA, i, uint64(*m.RevisionHistoryLimit))
		i--
		dAtA[i] = 0x10
	}
	if m.ReplicaCount != nil {
		i = encodeVarintGenerated(dAtA, i, uint64(*m.ReplicaCount))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *Image) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Image) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Image) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.PullPolicy != nil {
		i -= len(*m.PullPolicy)
		copy(dAtA[i:], *m.PullPolicy)
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.PullPolicy)))
		i--
		dAtA[i] = 0x1a
	}
	if m.Tag != nil {
		i -= len(*m.Tag)
		copy(dAtA[i:], *m.Tag)
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Tag)))
		i--
		dAtA[i] = 0x12
	}
	if m.Repository != nil {
		i -= len(*m.Repository)
		copy(dAtA[i:], *m.Repository)
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Repository)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ManagedSeed) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ManagedSeed) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ManagedSeed) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	{
		size, err := m.Status.MarshalToSizedBuffer(dAtA[:i])
		if err != nil {
			return 0, err
		}
		i -= size
		i = encodeVarintGenerated(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0x1a
	{
		size, err := m.Spec.MarshalToSizedBuffer(dAtA[:i])
		if err != nil {
			return 0, err
		}
		i -= size
		i = encodeVarintGenerated(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0x12
	{
		size, err := m.ObjectMeta.MarshalToSizedBuffer(dAtA[:i])
		if err != nil {
			return 0, err
		}
		i -= size
		i = encodeVarintGenerated(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0xa
	return len(dAtA) - i, nil
}

func (m *ManagedSeedList) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ManagedSeedList) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ManagedSeedList) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Items) > 0 {
		for iNdEx := len(m.Items) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Items[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintGenerated(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	{
		size, err := m.ListMeta.MarshalToSizedBuffer(dAtA[:i])
		if err != nil {
			return 0, err
		}
		i -= size
		i = encodeVarintGenerated(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0xa
	return len(dAtA) - i, nil
}

func (m *ManagedSeedSpec) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ManagedSeedSpec) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ManagedSeedSpec) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Gardenlet != nil {
		{
			size, err := m.Gardenlet.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintGenerated(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if m.SeedTemplate != nil {
		{
			size, err := m.SeedTemplate.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintGenerated(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	{
		size, err := m.Shoot.MarshalToSizedBuffer(dAtA[:i])
		if err != nil {
			return 0, err
		}
		i -= size
		i = encodeVarintGenerated(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0xa
	return len(dAtA) - i, nil
}

func (m *ManagedSeedStatus) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ManagedSeedStatus) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ManagedSeedStatus) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	i = encodeVarintGenerated(dAtA, i, uint64(m.ObservedGeneration))
	i--
	dAtA[i] = 0x10
	if len(m.Conditions) > 0 {
		for iNdEx := len(m.Conditions) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Conditions[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintGenerated(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *Shoot) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Shoot) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Shoot) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	i -= len(m.Name)
	copy(dAtA[i:], m.Name)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.Name)))
	i--
	dAtA[i] = 0xa
	return len(dAtA) - i, nil
}

func encodeVarintGenerated(dAtA []byte, offset int, v uint64) int {
	offset -= sovGenerated(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *Gardenlet) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Deployment != nil {
		l = m.Deployment.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	l = m.Config.Size()
	n += 1 + l + sovGenerated(uint64(l))
	if m.Bootstrap != nil {
		l = len(*m.Bootstrap)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.MergeWithParent != nil {
		n += 2
	}
	return n
}

func (m *GardenletDeployment) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ReplicaCount != nil {
		n += 1 + sovGenerated(uint64(*m.ReplicaCount))
	}
	if m.RevisionHistoryLimit != nil {
		n += 1 + sovGenerated(uint64(*m.RevisionHistoryLimit))
	}
	if m.ServiceAccountName != nil {
		l = len(*m.ServiceAccountName)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Image != nil {
		l = m.Image.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Resources != nil {
		l = m.Resources.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if len(m.PodLabels) > 0 {
		for k, v := range m.PodLabels {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovGenerated(uint64(len(k))) + 1 + len(v) + sovGenerated(uint64(len(v)))
			n += mapEntrySize + 1 + sovGenerated(uint64(mapEntrySize))
		}
	}
	if len(m.PodAnnotations) > 0 {
		for k, v := range m.PodAnnotations {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovGenerated(uint64(len(k))) + 1 + len(v) + sovGenerated(uint64(len(v)))
			n += mapEntrySize + 1 + sovGenerated(uint64(mapEntrySize))
		}
	}
	if len(m.AdditionalVolumes) > 0 {
		for _, e := range m.AdditionalVolumes {
			l = e.Size()
			n += 1 + l + sovGenerated(uint64(l))
		}
	}
	if len(m.AdditionalVolumeMounts) > 0 {
		for _, e := range m.AdditionalVolumeMounts {
			l = e.Size()
			n += 1 + l + sovGenerated(uint64(l))
		}
	}
	if len(m.Env) > 0 {
		for _, e := range m.Env {
			l = e.Size()
			n += 1 + l + sovGenerated(uint64(l))
		}
	}
	if m.VPA != nil {
		n += 2
	}
	return n
}

func (m *Image) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Repository != nil {
		l = len(*m.Repository)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Tag != nil {
		l = len(*m.Tag)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.PullPolicy != nil {
		l = len(*m.PullPolicy)
		n += 1 + l + sovGenerated(uint64(l))
	}
	return n
}

func (m *ManagedSeed) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.ObjectMeta.Size()
	n += 1 + l + sovGenerated(uint64(l))
	l = m.Spec.Size()
	n += 1 + l + sovGenerated(uint64(l))
	l = m.Status.Size()
	n += 1 + l + sovGenerated(uint64(l))
	return n
}

func (m *ManagedSeedList) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.ListMeta.Size()
	n += 1 + l + sovGenerated(uint64(l))
	if len(m.Items) > 0 {
		for _, e := range m.Items {
			l = e.Size()
			n += 1 + l + sovGenerated(uint64(l))
		}
	}
	return n
}

func (m *ManagedSeedSpec) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.Shoot.Size()
	n += 1 + l + sovGenerated(uint64(l))
	if m.SeedTemplate != nil {
		l = m.SeedTemplate.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Gardenlet != nil {
		l = m.Gardenlet.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	return n
}

func (m *ManagedSeedStatus) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Conditions) > 0 {
		for _, e := range m.Conditions {
			l = e.Size()
			n += 1 + l + sovGenerated(uint64(l))
		}
	}
	n += 1 + sovGenerated(uint64(m.ObservedGeneration))
	return n
}

func (m *Shoot) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Name)
	n += 1 + l + sovGenerated(uint64(l))
	return n
}

func sovGenerated(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozGenerated(x uint64) (n int) {
	return sovGenerated(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (this *Gardenlet) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Gardenlet{`,
		`Deployment:` + strings.Replace(this.Deployment.String(), "GardenletDeployment", "GardenletDeployment", 1) + `,`,
		`Config:` + strings.Replace(strings.Replace(fmt.Sprintf("%v", this.Config), "RawExtension", "runtime.RawExtension", 1), `&`, ``, 1) + `,`,
		`Bootstrap:` + valueToStringGenerated(this.Bootstrap) + `,`,
		`MergeWithParent:` + valueToStringGenerated(this.MergeWithParent) + `,`,
		`}`,
	}, "")
	return s
}
func (this *GardenletDeployment) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForAdditionalVolumes := "[]Volume{"
	for _, f := range this.AdditionalVolumes {
		repeatedStringForAdditionalVolumes += fmt.Sprintf("%v", f) + ","
	}
	repeatedStringForAdditionalVolumes += "}"
	repeatedStringForAdditionalVolumeMounts := "[]VolumeMount{"
	for _, f := range this.AdditionalVolumeMounts {
		repeatedStringForAdditionalVolumeMounts += fmt.Sprintf("%v", f) + ","
	}
	repeatedStringForAdditionalVolumeMounts += "}"
	repeatedStringForEnv := "[]EnvVar{"
	for _, f := range this.Env {
		repeatedStringForEnv += fmt.Sprintf("%v", f) + ","
	}
	repeatedStringForEnv += "}"
	keysForPodLabels := make([]string, 0, len(this.PodLabels))
	for k := range this.PodLabels {
		keysForPodLabels = append(keysForPodLabels, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForPodLabels)
	mapStringForPodLabels := "map[string]string{"
	for _, k := range keysForPodLabels {
		mapStringForPodLabels += fmt.Sprintf("%v: %v,", k, this.PodLabels[k])
	}
	mapStringForPodLabels += "}"
	keysForPodAnnotations := make([]string, 0, len(this.PodAnnotations))
	for k := range this.PodAnnotations {
		keysForPodAnnotations = append(keysForPodAnnotations, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForPodAnnotations)
	mapStringForPodAnnotations := "map[string]string{"
	for _, k := range keysForPodAnnotations {
		mapStringForPodAnnotations += fmt.Sprintf("%v: %v,", k, this.PodAnnotations[k])
	}
	mapStringForPodAnnotations += "}"
	s := strings.Join([]string{`&GardenletDeployment{`,
		`ReplicaCount:` + valueToStringGenerated(this.ReplicaCount) + `,`,
		`RevisionHistoryLimit:` + valueToStringGenerated(this.RevisionHistoryLimit) + `,`,
		`ServiceAccountName:` + valueToStringGenerated(this.ServiceAccountName) + `,`,
		`Image:` + strings.Replace(this.Image.String(), "Image", "Image", 1) + `,`,
		`Resources:` + strings.Replace(fmt.Sprintf("%v", this.Resources), "ResourceRequirements", "v1.ResourceRequirements", 1) + `,`,
		`PodLabels:` + mapStringForPodLabels + `,`,
		`PodAnnotations:` + mapStringForPodAnnotations + `,`,
		`AdditionalVolumes:` + repeatedStringForAdditionalVolumes + `,`,
		`AdditionalVolumeMounts:` + repeatedStringForAdditionalVolumeMounts + `,`,
		`Env:` + repeatedStringForEnv + `,`,
		`VPA:` + valueToStringGenerated(this.VPA) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Image) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Image{`,
		`Repository:` + valueToStringGenerated(this.Repository) + `,`,
		`Tag:` + valueToStringGenerated(this.Tag) + `,`,
		`PullPolicy:` + valueToStringGenerated(this.PullPolicy) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ManagedSeed) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ManagedSeed{`,
		`ObjectMeta:` + strings.Replace(strings.Replace(fmt.Sprintf("%v", this.ObjectMeta), "ObjectMeta", "v11.ObjectMeta", 1), `&`, ``, 1) + `,`,
		`Spec:` + strings.Replace(strings.Replace(this.Spec.String(), "ManagedSeedSpec", "ManagedSeedSpec", 1), `&`, ``, 1) + `,`,
		`Status:` + strings.Replace(strings.Replace(this.Status.String(), "ManagedSeedStatus", "ManagedSeedStatus", 1), `&`, ``, 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ManagedSeedList) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForItems := "[]ManagedSeed{"
	for _, f := range this.Items {
		repeatedStringForItems += strings.Replace(strings.Replace(f.String(), "ManagedSeed", "ManagedSeed", 1), `&`, ``, 1) + ","
	}
	repeatedStringForItems += "}"
	s := strings.Join([]string{`&ManagedSeedList{`,
		`ListMeta:` + strings.Replace(strings.Replace(fmt.Sprintf("%v", this.ListMeta), "ListMeta", "v11.ListMeta", 1), `&`, ``, 1) + `,`,
		`Items:` + repeatedStringForItems + `,`,
		`}`,
	}, "")
	return s
}
func (this *ManagedSeedSpec) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ManagedSeedSpec{`,
		`Shoot:` + strings.Replace(strings.Replace(this.Shoot.String(), "Shoot", "Shoot", 1), `&`, ``, 1) + `,`,
		`SeedTemplate:` + strings.Replace(fmt.Sprintf("%v", this.SeedTemplate), "SeedTemplate", "v1beta1.SeedTemplate", 1) + `,`,
		`Gardenlet:` + strings.Replace(this.Gardenlet.String(), "Gardenlet", "Gardenlet", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ManagedSeedStatus) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForConditions := "[]Condition{"
	for _, f := range this.Conditions {
		repeatedStringForConditions += fmt.Sprintf("%v", f) + ","
	}
	repeatedStringForConditions += "}"
	s := strings.Join([]string{`&ManagedSeedStatus{`,
		`Conditions:` + repeatedStringForConditions + `,`,
		`ObservedGeneration:` + fmt.Sprintf("%v", this.ObservedGeneration) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Shoot) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Shoot{`,
		`Name:` + fmt.Sprintf("%v", this.Name) + `,`,
		`}`,
	}, "")
	return s
}
func valueToStringGenerated(v interface{}) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("*%v", pv)
}
func (m *Gardenlet) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGenerated
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Gardenlet: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Gardenlet: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Deployment", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthGenerated
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Deployment == nil {
				m.Deployment = &GardenletDeployment{}
			}
			if err := m.Deployment.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Config", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthGenerated
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Config.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Bootstrap", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthGenerated
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := Bootstrap(dAtA[iNdEx:postIndex])
			m.Bootstrap = &s
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MergeWithParent", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			b := bool(v != 0)
			m.MergeWithParent = &b
		default:
			iNdEx = preIndex
			skippy, err := skipGenerated(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthGenerated
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthGenerated
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GardenletDeployment) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGenerated
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GardenletDeployment: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GardenletDeployment: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReplicaCount", wireType)
			}
			var v int32
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.ReplicaCount = &v
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RevisionHistoryLimit", wireType)
			}
			var v int32
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.RevisionHistoryLimit = &v
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ServiceAccountName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthGenerated
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.ServiceAccountName = &s
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Image", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthGenerated
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Image == nil {
				m.Image = &Image{}
			}
			if err := m.Image.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Resources", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthGenerated
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Resources == nil {
				m.Resources = &v1.ResourceRequirements{}
			}
			if err := m.Resources.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PodLabels", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthGenerated
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.PodLabels == nil {
				m.PodLabels = make(map[string]string)
			}
			var mapkey string
			var mapvalue string
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowGenerated
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowGenerated
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthGenerated
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthGenerated
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var stringLenmapvalue uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowGenerated
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapvalue |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapvalue := int(stringLenmapvalue)
					if intStringLenmapvalue < 0 {
						return ErrInvalidLengthGenerated
					}
					postStringIndexmapvalue := iNdEx + intStringLenmapvalue
					if postStringIndexmapvalue < 0 {
						return ErrInvalidLengthGenerated
					}
					if postStringIndexmapvalue > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = string(dAtA[iNdEx:postStringIndexmapvalue])
					iNdEx = postStringIndexmapvalue
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipGenerated(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthGenerated
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.PodLabels[mapkey] = mapvalue
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PodAnnotations", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthGenerated
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.PodAnnotations == nil {
				m.PodAnnotations = make(map[string]string)
			}
			var mapkey string
			var mapvalue string
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowGenerated
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowGenerated
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthGenerated
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthGenerated
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var stringLenmapvalue uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowGenerated
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapvalue |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapvalue := int(stringLenmapvalue)
					if intStringLenmapvalue < 0 {
						return ErrInvalidLengthGenerated
					}
					postStringIndexmapvalue := iNdEx + intStringLenmapvalue
					if postStringIndexmapvalue < 0 {
						return ErrInvalidLengthGenerated
					}
					if postStringIndexmapvalue > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = string(dAtA[iNdEx:postStringIndexmapvalue])
					iNdEx = postStringIndexmapvalue
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipGenerated(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthGenerated
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.PodAnnotations[mapkey] = mapvalue
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AdditionalVolumes", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthGenerated
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.AdditionalVolumes = append(m.AdditionalVolumes, v1.Volume{})
			if err := m.AdditionalVolumes[len(m.AdditionalVolumes)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AdditionalVolumeMounts", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthGenerated
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.AdditionalVolumeMounts = append(m.AdditionalVolumeMounts, v1.VolumeMount{})
			if err := m.AdditionalVolumeMounts[len(m.AdditionalVolumeMounts)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Env", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthGenerated
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Env = append(m.Env, v1.EnvVar{})
			if err := m.Env[len(m.Env)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 11:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field VPA", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			b := bool(v != 0)
			m.VPA = &b
		default:
			iNdEx = preIndex
			skippy, err := skipGenerated(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthGenerated
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthGenerated
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Image) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGenerated
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Image: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Image: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Repository", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthGenerated
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Repository = &s
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Tag", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthGenerated
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Tag = &s
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PullPolicy", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthGenerated
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := k8s_io_api_core_v1.PullPolicy(dAtA[iNdEx:postIndex])
			m.PullPolicy = &s
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipGenerated(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthGenerated
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthGenerated
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ManagedSeed) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGenerated
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ManagedSeed: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ManagedSeed: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ObjectMeta", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthGenerated
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ObjectMeta.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Spec", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthGenerated
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Spec.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Status", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthGenerated
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Status.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipGenerated(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthGenerated
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthGenerated
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ManagedSeedList) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGenerated
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ManagedSeedList: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ManagedSeedList: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ListMeta", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthGenerated
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ListMeta.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Items", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthGenerated
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Items = append(m.Items, ManagedSeed{})
			if err := m.Items[len(m.Items)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipGenerated(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthGenerated
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthGenerated
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ManagedSeedSpec) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGenerated
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ManagedSeedSpec: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ManagedSeedSpec: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Shoot", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthGenerated
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Shoot.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SeedTemplate", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthGenerated
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.SeedTemplate == nil {
				m.SeedTemplate = &v1beta1.SeedTemplate{}
			}
			if err := m.SeedTemplate.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Gardenlet", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthGenerated
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Gardenlet == nil {
				m.Gardenlet = &Gardenlet{}
			}
			if err := m.Gardenlet.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipGenerated(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthGenerated
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthGenerated
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ManagedSeedStatus) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGenerated
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ManagedSeedStatus: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ManagedSeedStatus: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Conditions", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthGenerated
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Conditions = append(m.Conditions, v1beta1.Condition{})
			if err := m.Conditions[len(m.Conditions)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ObservedGeneration", wireType)
			}
			m.ObservedGeneration = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ObservedGeneration |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipGenerated(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthGenerated
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthGenerated
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Shoot) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGenerated
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Shoot: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Shoot: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthGenerated
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipGenerated(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthGenerated
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthGenerated
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipGenerated(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowGenerated
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthGenerated
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupGenerated
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthGenerated
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthGenerated        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowGenerated          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupGenerated = fmt.Errorf("proto: unexpected end of group")
)
