/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by lister-gen. DO NOT EDIT.

package v1

import (
	v1 "k8s.io/apiextensions-apiserver/examples/client-go/pkg/apis/cr/v1"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/listers"
	"k8s.io/client-go/tools/cache"
)

// ExampleLister helps list Examples.
// All objects returned here must be treated as read-only.
type ExampleLister interface {
	// List lists all Examples in the indexer.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v1.Example, err error)
	// Examples returns an object that can list and get Examples.
	Examples(namespace string) ExampleNamespaceLister
	ExampleListerExpansion
}

// exampleLister implements the ExampleLister interface.
type exampleLister struct {
	listers.ResourceIndexer[*v1.Example]
}

// NewExampleLister returns a new ExampleLister.
func NewExampleLister(indexer cache.Indexer) ExampleLister {
	return &exampleLister{listers.New[*v1.Example](indexer, v1.Resource("example"))}
}

// Examples returns an object that can list and get Examples.
func (s *exampleLister) Examples(namespace string) ExampleNamespaceLister {
	return exampleNamespaceLister{listers.NewNamespaced[*v1.Example](s.ResourceIndexer, namespace)}
}

// ExampleNamespaceLister helps list and get Examples.
// All objects returned here must be treated as read-only.
type ExampleNamespaceLister interface {
	// List lists all Examples in the indexer for a given namespace.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v1.Example, err error)
	// Get retrieves the Example from the indexer for a given namespace and name.
	// Objects returned here must be treated as read-only.
	Get(name string) (*v1.Example, error)
	ExampleNamespaceListerExpansion
}

// exampleNamespaceLister implements the ExampleNamespaceLister
// interface.
type exampleNamespaceLister struct {
	listers.ResourceIndexer[*v1.Example]
}
