//go:build !ignore_autogenerated
// +build !ignore_autogenerated

/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by conversion-gen. DO NOT EDIT.

package v1alpha2

import (
	unsafe "unsafe"

	v1 "k8s.io/api/core/v1"
	v1alpha2 "k8s.io/api/resource/v1alpha2"
	apiresource "k8s.io/apimachinery/pkg/api/resource"
	conversion "k8s.io/apimachinery/pkg/conversion"
	runtime "k8s.io/apimachinery/pkg/runtime"
	types "k8s.io/apimachinery/pkg/types"
	core "k8s.io/kubernetes/pkg/apis/core"
	resource "k8s.io/kubernetes/pkg/apis/resource"
)

func init() {
	localSchemeBuilder.Register(RegisterConversions)
}

// RegisterConversions adds conversion functions to the given scheme.
// Public to allow building arbitrary schemes.
func RegisterConversions(s *runtime.Scheme) error {
	if err := s.AddGeneratedConversionFunc((*v1alpha2.AllocationResult)(nil), (*resource.AllocationResult)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha2_AllocationResult_To_resource_AllocationResult(a.(*v1alpha2.AllocationResult), b.(*resource.AllocationResult), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resource.AllocationResult)(nil), (*v1alpha2.AllocationResult)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_resource_AllocationResult_To_v1alpha2_AllocationResult(a.(*resource.AllocationResult), b.(*v1alpha2.AllocationResult), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha2.AllocationResultModel)(nil), (*resource.AllocationResultModel)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha2_AllocationResultModel_To_resource_AllocationResultModel(a.(*v1alpha2.AllocationResultModel), b.(*resource.AllocationResultModel), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resource.AllocationResultModel)(nil), (*v1alpha2.AllocationResultModel)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_resource_AllocationResultModel_To_v1alpha2_AllocationResultModel(a.(*resource.AllocationResultModel), b.(*v1alpha2.AllocationResultModel), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha2.DriverAllocationResult)(nil), (*resource.DriverAllocationResult)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha2_DriverAllocationResult_To_resource_DriverAllocationResult(a.(*v1alpha2.DriverAllocationResult), b.(*resource.DriverAllocationResult), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resource.DriverAllocationResult)(nil), (*v1alpha2.DriverAllocationResult)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_resource_DriverAllocationResult_To_v1alpha2_DriverAllocationResult(a.(*resource.DriverAllocationResult), b.(*v1alpha2.DriverAllocationResult), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha2.DriverRequests)(nil), (*resource.DriverRequests)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha2_DriverRequests_To_resource_DriverRequests(a.(*v1alpha2.DriverRequests), b.(*resource.DriverRequests), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resource.DriverRequests)(nil), (*v1alpha2.DriverRequests)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_resource_DriverRequests_To_v1alpha2_DriverRequests(a.(*resource.DriverRequests), b.(*v1alpha2.DriverRequests), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha2.NamedResourcesAllocationResult)(nil), (*resource.NamedResourcesAllocationResult)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha2_NamedResourcesAllocationResult_To_resource_NamedResourcesAllocationResult(a.(*v1alpha2.NamedResourcesAllocationResult), b.(*resource.NamedResourcesAllocationResult), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resource.NamedResourcesAllocationResult)(nil), (*v1alpha2.NamedResourcesAllocationResult)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_resource_NamedResourcesAllocationResult_To_v1alpha2_NamedResourcesAllocationResult(a.(*resource.NamedResourcesAllocationResult), b.(*v1alpha2.NamedResourcesAllocationResult), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha2.NamedResourcesAttribute)(nil), (*resource.NamedResourcesAttribute)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha2_NamedResourcesAttribute_To_resource_NamedResourcesAttribute(a.(*v1alpha2.NamedResourcesAttribute), b.(*resource.NamedResourcesAttribute), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resource.NamedResourcesAttribute)(nil), (*v1alpha2.NamedResourcesAttribute)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_resource_NamedResourcesAttribute_To_v1alpha2_NamedResourcesAttribute(a.(*resource.NamedResourcesAttribute), b.(*v1alpha2.NamedResourcesAttribute), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha2.NamedResourcesAttributeValue)(nil), (*resource.NamedResourcesAttributeValue)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha2_NamedResourcesAttributeValue_To_resource_NamedResourcesAttributeValue(a.(*v1alpha2.NamedResourcesAttributeValue), b.(*resource.NamedResourcesAttributeValue), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resource.NamedResourcesAttributeValue)(nil), (*v1alpha2.NamedResourcesAttributeValue)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_resource_NamedResourcesAttributeValue_To_v1alpha2_NamedResourcesAttributeValue(a.(*resource.NamedResourcesAttributeValue), b.(*v1alpha2.NamedResourcesAttributeValue), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha2.NamedResourcesFilter)(nil), (*resource.NamedResourcesFilter)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha2_NamedResourcesFilter_To_resource_NamedResourcesFilter(a.(*v1alpha2.NamedResourcesFilter), b.(*resource.NamedResourcesFilter), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resource.NamedResourcesFilter)(nil), (*v1alpha2.NamedResourcesFilter)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_resource_NamedResourcesFilter_To_v1alpha2_NamedResourcesFilter(a.(*resource.NamedResourcesFilter), b.(*v1alpha2.NamedResourcesFilter), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha2.NamedResourcesInstance)(nil), (*resource.NamedResourcesInstance)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha2_NamedResourcesInstance_To_resource_NamedResourcesInstance(a.(*v1alpha2.NamedResourcesInstance), b.(*resource.NamedResourcesInstance), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resource.NamedResourcesInstance)(nil), (*v1alpha2.NamedResourcesInstance)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_resource_NamedResourcesInstance_To_v1alpha2_NamedResourcesInstance(a.(*resource.NamedResourcesInstance), b.(*v1alpha2.NamedResourcesInstance), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha2.NamedResourcesIntSlice)(nil), (*resource.NamedResourcesIntSlice)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha2_NamedResourcesIntSlice_To_resource_NamedResourcesIntSlice(a.(*v1alpha2.NamedResourcesIntSlice), b.(*resource.NamedResourcesIntSlice), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resource.NamedResourcesIntSlice)(nil), (*v1alpha2.NamedResourcesIntSlice)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_resource_NamedResourcesIntSlice_To_v1alpha2_NamedResourcesIntSlice(a.(*resource.NamedResourcesIntSlice), b.(*v1alpha2.NamedResourcesIntSlice), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha2.NamedResourcesRequest)(nil), (*resource.NamedResourcesRequest)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha2_NamedResourcesRequest_To_resource_NamedResourcesRequest(a.(*v1alpha2.NamedResourcesRequest), b.(*resource.NamedResourcesRequest), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resource.NamedResourcesRequest)(nil), (*v1alpha2.NamedResourcesRequest)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_resource_NamedResourcesRequest_To_v1alpha2_NamedResourcesRequest(a.(*resource.NamedResourcesRequest), b.(*v1alpha2.NamedResourcesRequest), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha2.NamedResourcesResources)(nil), (*resource.NamedResourcesResources)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha2_NamedResourcesResources_To_resource_NamedResourcesResources(a.(*v1alpha2.NamedResourcesResources), b.(*resource.NamedResourcesResources), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resource.NamedResourcesResources)(nil), (*v1alpha2.NamedResourcesResources)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_resource_NamedResourcesResources_To_v1alpha2_NamedResourcesResources(a.(*resource.NamedResourcesResources), b.(*v1alpha2.NamedResourcesResources), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha2.NamedResourcesStringSlice)(nil), (*resource.NamedResourcesStringSlice)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha2_NamedResourcesStringSlice_To_resource_NamedResourcesStringSlice(a.(*v1alpha2.NamedResourcesStringSlice), b.(*resource.NamedResourcesStringSlice), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resource.NamedResourcesStringSlice)(nil), (*v1alpha2.NamedResourcesStringSlice)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_resource_NamedResourcesStringSlice_To_v1alpha2_NamedResourcesStringSlice(a.(*resource.NamedResourcesStringSlice), b.(*v1alpha2.NamedResourcesStringSlice), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha2.PodSchedulingContext)(nil), (*resource.PodSchedulingContext)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha2_PodSchedulingContext_To_resource_PodSchedulingContext(a.(*v1alpha2.PodSchedulingContext), b.(*resource.PodSchedulingContext), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resource.PodSchedulingContext)(nil), (*v1alpha2.PodSchedulingContext)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_resource_PodSchedulingContext_To_v1alpha2_PodSchedulingContext(a.(*resource.PodSchedulingContext), b.(*v1alpha2.PodSchedulingContext), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha2.PodSchedulingContextList)(nil), (*resource.PodSchedulingContextList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha2_PodSchedulingContextList_To_resource_PodSchedulingContextList(a.(*v1alpha2.PodSchedulingContextList), b.(*resource.PodSchedulingContextList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resource.PodSchedulingContextList)(nil), (*v1alpha2.PodSchedulingContextList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_resource_PodSchedulingContextList_To_v1alpha2_PodSchedulingContextList(a.(*resource.PodSchedulingContextList), b.(*v1alpha2.PodSchedulingContextList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha2.PodSchedulingContextSpec)(nil), (*resource.PodSchedulingContextSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha2_PodSchedulingContextSpec_To_resource_PodSchedulingContextSpec(a.(*v1alpha2.PodSchedulingContextSpec), b.(*resource.PodSchedulingContextSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resource.PodSchedulingContextSpec)(nil), (*v1alpha2.PodSchedulingContextSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_resource_PodSchedulingContextSpec_To_v1alpha2_PodSchedulingContextSpec(a.(*resource.PodSchedulingContextSpec), b.(*v1alpha2.PodSchedulingContextSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha2.PodSchedulingContextStatus)(nil), (*resource.PodSchedulingContextStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha2_PodSchedulingContextStatus_To_resource_PodSchedulingContextStatus(a.(*v1alpha2.PodSchedulingContextStatus), b.(*resource.PodSchedulingContextStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resource.PodSchedulingContextStatus)(nil), (*v1alpha2.PodSchedulingContextStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_resource_PodSchedulingContextStatus_To_v1alpha2_PodSchedulingContextStatus(a.(*resource.PodSchedulingContextStatus), b.(*v1alpha2.PodSchedulingContextStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha2.ResourceClaim)(nil), (*resource.ResourceClaim)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha2_ResourceClaim_To_resource_ResourceClaim(a.(*v1alpha2.ResourceClaim), b.(*resource.ResourceClaim), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resource.ResourceClaim)(nil), (*v1alpha2.ResourceClaim)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_resource_ResourceClaim_To_v1alpha2_ResourceClaim(a.(*resource.ResourceClaim), b.(*v1alpha2.ResourceClaim), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha2.ResourceClaimConsumerReference)(nil), (*resource.ResourceClaimConsumerReference)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha2_ResourceClaimConsumerReference_To_resource_ResourceClaimConsumerReference(a.(*v1alpha2.ResourceClaimConsumerReference), b.(*resource.ResourceClaimConsumerReference), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resource.ResourceClaimConsumerReference)(nil), (*v1alpha2.ResourceClaimConsumerReference)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_resource_ResourceClaimConsumerReference_To_v1alpha2_ResourceClaimConsumerReference(a.(*resource.ResourceClaimConsumerReference), b.(*v1alpha2.ResourceClaimConsumerReference), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha2.ResourceClaimList)(nil), (*resource.ResourceClaimList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha2_ResourceClaimList_To_resource_ResourceClaimList(a.(*v1alpha2.ResourceClaimList), b.(*resource.ResourceClaimList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resource.ResourceClaimList)(nil), (*v1alpha2.ResourceClaimList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_resource_ResourceClaimList_To_v1alpha2_ResourceClaimList(a.(*resource.ResourceClaimList), b.(*v1alpha2.ResourceClaimList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha2.ResourceClaimParameters)(nil), (*resource.ResourceClaimParameters)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha2_ResourceClaimParameters_To_resource_ResourceClaimParameters(a.(*v1alpha2.ResourceClaimParameters), b.(*resource.ResourceClaimParameters), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resource.ResourceClaimParameters)(nil), (*v1alpha2.ResourceClaimParameters)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_resource_ResourceClaimParameters_To_v1alpha2_ResourceClaimParameters(a.(*resource.ResourceClaimParameters), b.(*v1alpha2.ResourceClaimParameters), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha2.ResourceClaimParametersList)(nil), (*resource.ResourceClaimParametersList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha2_ResourceClaimParametersList_To_resource_ResourceClaimParametersList(a.(*v1alpha2.ResourceClaimParametersList), b.(*resource.ResourceClaimParametersList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resource.ResourceClaimParametersList)(nil), (*v1alpha2.ResourceClaimParametersList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_resource_ResourceClaimParametersList_To_v1alpha2_ResourceClaimParametersList(a.(*resource.ResourceClaimParametersList), b.(*v1alpha2.ResourceClaimParametersList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha2.ResourceClaimParametersReference)(nil), (*resource.ResourceClaimParametersReference)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha2_ResourceClaimParametersReference_To_resource_ResourceClaimParametersReference(a.(*v1alpha2.ResourceClaimParametersReference), b.(*resource.ResourceClaimParametersReference), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resource.ResourceClaimParametersReference)(nil), (*v1alpha2.ResourceClaimParametersReference)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_resource_ResourceClaimParametersReference_To_v1alpha2_ResourceClaimParametersReference(a.(*resource.ResourceClaimParametersReference), b.(*v1alpha2.ResourceClaimParametersReference), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha2.ResourceClaimSchedulingStatus)(nil), (*resource.ResourceClaimSchedulingStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha2_ResourceClaimSchedulingStatus_To_resource_ResourceClaimSchedulingStatus(a.(*v1alpha2.ResourceClaimSchedulingStatus), b.(*resource.ResourceClaimSchedulingStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resource.ResourceClaimSchedulingStatus)(nil), (*v1alpha2.ResourceClaimSchedulingStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_resource_ResourceClaimSchedulingStatus_To_v1alpha2_ResourceClaimSchedulingStatus(a.(*resource.ResourceClaimSchedulingStatus), b.(*v1alpha2.ResourceClaimSchedulingStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha2.ResourceClaimSpec)(nil), (*resource.ResourceClaimSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha2_ResourceClaimSpec_To_resource_ResourceClaimSpec(a.(*v1alpha2.ResourceClaimSpec), b.(*resource.ResourceClaimSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resource.ResourceClaimSpec)(nil), (*v1alpha2.ResourceClaimSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_resource_ResourceClaimSpec_To_v1alpha2_ResourceClaimSpec(a.(*resource.ResourceClaimSpec), b.(*v1alpha2.ResourceClaimSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha2.ResourceClaimStatus)(nil), (*resource.ResourceClaimStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha2_ResourceClaimStatus_To_resource_ResourceClaimStatus(a.(*v1alpha2.ResourceClaimStatus), b.(*resource.ResourceClaimStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resource.ResourceClaimStatus)(nil), (*v1alpha2.ResourceClaimStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_resource_ResourceClaimStatus_To_v1alpha2_ResourceClaimStatus(a.(*resource.ResourceClaimStatus), b.(*v1alpha2.ResourceClaimStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha2.ResourceClaimTemplate)(nil), (*resource.ResourceClaimTemplate)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha2_ResourceClaimTemplate_To_resource_ResourceClaimTemplate(a.(*v1alpha2.ResourceClaimTemplate), b.(*resource.ResourceClaimTemplate), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resource.ResourceClaimTemplate)(nil), (*v1alpha2.ResourceClaimTemplate)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_resource_ResourceClaimTemplate_To_v1alpha2_ResourceClaimTemplate(a.(*resource.ResourceClaimTemplate), b.(*v1alpha2.ResourceClaimTemplate), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha2.ResourceClaimTemplateList)(nil), (*resource.ResourceClaimTemplateList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha2_ResourceClaimTemplateList_To_resource_ResourceClaimTemplateList(a.(*v1alpha2.ResourceClaimTemplateList), b.(*resource.ResourceClaimTemplateList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resource.ResourceClaimTemplateList)(nil), (*v1alpha2.ResourceClaimTemplateList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_resource_ResourceClaimTemplateList_To_v1alpha2_ResourceClaimTemplateList(a.(*resource.ResourceClaimTemplateList), b.(*v1alpha2.ResourceClaimTemplateList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha2.ResourceClaimTemplateSpec)(nil), (*resource.ResourceClaimTemplateSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha2_ResourceClaimTemplateSpec_To_resource_ResourceClaimTemplateSpec(a.(*v1alpha2.ResourceClaimTemplateSpec), b.(*resource.ResourceClaimTemplateSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resource.ResourceClaimTemplateSpec)(nil), (*v1alpha2.ResourceClaimTemplateSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_resource_ResourceClaimTemplateSpec_To_v1alpha2_ResourceClaimTemplateSpec(a.(*resource.ResourceClaimTemplateSpec), b.(*v1alpha2.ResourceClaimTemplateSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha2.ResourceClass)(nil), (*resource.ResourceClass)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha2_ResourceClass_To_resource_ResourceClass(a.(*v1alpha2.ResourceClass), b.(*resource.ResourceClass), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resource.ResourceClass)(nil), (*v1alpha2.ResourceClass)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_resource_ResourceClass_To_v1alpha2_ResourceClass(a.(*resource.ResourceClass), b.(*v1alpha2.ResourceClass), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha2.ResourceClassList)(nil), (*resource.ResourceClassList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha2_ResourceClassList_To_resource_ResourceClassList(a.(*v1alpha2.ResourceClassList), b.(*resource.ResourceClassList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resource.ResourceClassList)(nil), (*v1alpha2.ResourceClassList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_resource_ResourceClassList_To_v1alpha2_ResourceClassList(a.(*resource.ResourceClassList), b.(*v1alpha2.ResourceClassList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha2.ResourceClassParameters)(nil), (*resource.ResourceClassParameters)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha2_ResourceClassParameters_To_resource_ResourceClassParameters(a.(*v1alpha2.ResourceClassParameters), b.(*resource.ResourceClassParameters), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resource.ResourceClassParameters)(nil), (*v1alpha2.ResourceClassParameters)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_resource_ResourceClassParameters_To_v1alpha2_ResourceClassParameters(a.(*resource.ResourceClassParameters), b.(*v1alpha2.ResourceClassParameters), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha2.ResourceClassParametersList)(nil), (*resource.ResourceClassParametersList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha2_ResourceClassParametersList_To_resource_ResourceClassParametersList(a.(*v1alpha2.ResourceClassParametersList), b.(*resource.ResourceClassParametersList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resource.ResourceClassParametersList)(nil), (*v1alpha2.ResourceClassParametersList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_resource_ResourceClassParametersList_To_v1alpha2_ResourceClassParametersList(a.(*resource.ResourceClassParametersList), b.(*v1alpha2.ResourceClassParametersList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha2.ResourceClassParametersReference)(nil), (*resource.ResourceClassParametersReference)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha2_ResourceClassParametersReference_To_resource_ResourceClassParametersReference(a.(*v1alpha2.ResourceClassParametersReference), b.(*resource.ResourceClassParametersReference), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resource.ResourceClassParametersReference)(nil), (*v1alpha2.ResourceClassParametersReference)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_resource_ResourceClassParametersReference_To_v1alpha2_ResourceClassParametersReference(a.(*resource.ResourceClassParametersReference), b.(*v1alpha2.ResourceClassParametersReference), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha2.ResourceFilter)(nil), (*resource.ResourceFilter)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha2_ResourceFilter_To_resource_ResourceFilter(a.(*v1alpha2.ResourceFilter), b.(*resource.ResourceFilter), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resource.ResourceFilter)(nil), (*v1alpha2.ResourceFilter)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_resource_ResourceFilter_To_v1alpha2_ResourceFilter(a.(*resource.ResourceFilter), b.(*v1alpha2.ResourceFilter), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha2.ResourceFilterModel)(nil), (*resource.ResourceFilterModel)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha2_ResourceFilterModel_To_resource_ResourceFilterModel(a.(*v1alpha2.ResourceFilterModel), b.(*resource.ResourceFilterModel), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resource.ResourceFilterModel)(nil), (*v1alpha2.ResourceFilterModel)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_resource_ResourceFilterModel_To_v1alpha2_ResourceFilterModel(a.(*resource.ResourceFilterModel), b.(*v1alpha2.ResourceFilterModel), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha2.ResourceHandle)(nil), (*resource.ResourceHandle)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha2_ResourceHandle_To_resource_ResourceHandle(a.(*v1alpha2.ResourceHandle), b.(*resource.ResourceHandle), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resource.ResourceHandle)(nil), (*v1alpha2.ResourceHandle)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_resource_ResourceHandle_To_v1alpha2_ResourceHandle(a.(*resource.ResourceHandle), b.(*v1alpha2.ResourceHandle), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha2.ResourceModel)(nil), (*resource.ResourceModel)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha2_ResourceModel_To_resource_ResourceModel(a.(*v1alpha2.ResourceModel), b.(*resource.ResourceModel), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resource.ResourceModel)(nil), (*v1alpha2.ResourceModel)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_resource_ResourceModel_To_v1alpha2_ResourceModel(a.(*resource.ResourceModel), b.(*v1alpha2.ResourceModel), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha2.ResourceRequest)(nil), (*resource.ResourceRequest)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha2_ResourceRequest_To_resource_ResourceRequest(a.(*v1alpha2.ResourceRequest), b.(*resource.ResourceRequest), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resource.ResourceRequest)(nil), (*v1alpha2.ResourceRequest)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_resource_ResourceRequest_To_v1alpha2_ResourceRequest(a.(*resource.ResourceRequest), b.(*v1alpha2.ResourceRequest), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha2.ResourceRequestModel)(nil), (*resource.ResourceRequestModel)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha2_ResourceRequestModel_To_resource_ResourceRequestModel(a.(*v1alpha2.ResourceRequestModel), b.(*resource.ResourceRequestModel), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resource.ResourceRequestModel)(nil), (*v1alpha2.ResourceRequestModel)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_resource_ResourceRequestModel_To_v1alpha2_ResourceRequestModel(a.(*resource.ResourceRequestModel), b.(*v1alpha2.ResourceRequestModel), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha2.ResourceSlice)(nil), (*resource.ResourceSlice)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha2_ResourceSlice_To_resource_ResourceSlice(a.(*v1alpha2.ResourceSlice), b.(*resource.ResourceSlice), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resource.ResourceSlice)(nil), (*v1alpha2.ResourceSlice)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_resource_ResourceSlice_To_v1alpha2_ResourceSlice(a.(*resource.ResourceSlice), b.(*v1alpha2.ResourceSlice), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha2.ResourceSliceList)(nil), (*resource.ResourceSliceList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha2_ResourceSliceList_To_resource_ResourceSliceList(a.(*v1alpha2.ResourceSliceList), b.(*resource.ResourceSliceList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resource.ResourceSliceList)(nil), (*v1alpha2.ResourceSliceList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_resource_ResourceSliceList_To_v1alpha2_ResourceSliceList(a.(*resource.ResourceSliceList), b.(*v1alpha2.ResourceSliceList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha2.StructuredResourceHandle)(nil), (*resource.StructuredResourceHandle)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha2_StructuredResourceHandle_To_resource_StructuredResourceHandle(a.(*v1alpha2.StructuredResourceHandle), b.(*resource.StructuredResourceHandle), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resource.StructuredResourceHandle)(nil), (*v1alpha2.StructuredResourceHandle)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_resource_StructuredResourceHandle_To_v1alpha2_StructuredResourceHandle(a.(*resource.StructuredResourceHandle), b.(*v1alpha2.StructuredResourceHandle), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha2.VendorParameters)(nil), (*resource.VendorParameters)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha2_VendorParameters_To_resource_VendorParameters(a.(*v1alpha2.VendorParameters), b.(*resource.VendorParameters), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resource.VendorParameters)(nil), (*v1alpha2.VendorParameters)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_resource_VendorParameters_To_v1alpha2_VendorParameters(a.(*resource.VendorParameters), b.(*v1alpha2.VendorParameters), scope)
	}); err != nil {
		return err
	}
	return nil
}

func autoConvert_v1alpha2_AllocationResult_To_resource_AllocationResult(in *v1alpha2.AllocationResult, out *resource.AllocationResult, s conversion.Scope) error {
	if in.ResourceHandles != nil {
		in, out := &in.ResourceHandles, &out.ResourceHandles
		*out = make([]resource.ResourceHandle, len(*in))
		for i := range *in {
			if err := Convert_v1alpha2_ResourceHandle_To_resource_ResourceHandle(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.ResourceHandles = nil
	}
	out.AvailableOnNodes = (*core.NodeSelector)(unsafe.Pointer(in.AvailableOnNodes))
	out.Shareable = in.Shareable
	return nil
}

// Convert_v1alpha2_AllocationResult_To_resource_AllocationResult is an autogenerated conversion function.
func Convert_v1alpha2_AllocationResult_To_resource_AllocationResult(in *v1alpha2.AllocationResult, out *resource.AllocationResult, s conversion.Scope) error {
	return autoConvert_v1alpha2_AllocationResult_To_resource_AllocationResult(in, out, s)
}

func autoConvert_resource_AllocationResult_To_v1alpha2_AllocationResult(in *resource.AllocationResult, out *v1alpha2.AllocationResult, s conversion.Scope) error {
	if in.ResourceHandles != nil {
		in, out := &in.ResourceHandles, &out.ResourceHandles
		*out = make([]v1alpha2.ResourceHandle, len(*in))
		for i := range *in {
			if err := Convert_resource_ResourceHandle_To_v1alpha2_ResourceHandle(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.ResourceHandles = nil
	}
	out.AvailableOnNodes = (*v1.NodeSelector)(unsafe.Pointer(in.AvailableOnNodes))
	out.Shareable = in.Shareable
	return nil
}

// Convert_resource_AllocationResult_To_v1alpha2_AllocationResult is an autogenerated conversion function.
func Convert_resource_AllocationResult_To_v1alpha2_AllocationResult(in *resource.AllocationResult, out *v1alpha2.AllocationResult, s conversion.Scope) error {
	return autoConvert_resource_AllocationResult_To_v1alpha2_AllocationResult(in, out, s)
}

func autoConvert_v1alpha2_AllocationResultModel_To_resource_AllocationResultModel(in *v1alpha2.AllocationResultModel, out *resource.AllocationResultModel, s conversion.Scope) error {
	out.NamedResources = (*resource.NamedResourcesAllocationResult)(unsafe.Pointer(in.NamedResources))
	return nil
}

// Convert_v1alpha2_AllocationResultModel_To_resource_AllocationResultModel is an autogenerated conversion function.
func Convert_v1alpha2_AllocationResultModel_To_resource_AllocationResultModel(in *v1alpha2.AllocationResultModel, out *resource.AllocationResultModel, s conversion.Scope) error {
	return autoConvert_v1alpha2_AllocationResultModel_To_resource_AllocationResultModel(in, out, s)
}

func autoConvert_resource_AllocationResultModel_To_v1alpha2_AllocationResultModel(in *resource.AllocationResultModel, out *v1alpha2.AllocationResultModel, s conversion.Scope) error {
	out.NamedResources = (*v1alpha2.NamedResourcesAllocationResult)(unsafe.Pointer(in.NamedResources))
	return nil
}

// Convert_resource_AllocationResultModel_To_v1alpha2_AllocationResultModel is an autogenerated conversion function.
func Convert_resource_AllocationResultModel_To_v1alpha2_AllocationResultModel(in *resource.AllocationResultModel, out *v1alpha2.AllocationResultModel, s conversion.Scope) error {
	return autoConvert_resource_AllocationResultModel_To_v1alpha2_AllocationResultModel(in, out, s)
}

func autoConvert_v1alpha2_DriverAllocationResult_To_resource_DriverAllocationResult(in *v1alpha2.DriverAllocationResult, out *resource.DriverAllocationResult, s conversion.Scope) error {
	if err := runtime.Convert_runtime_RawExtension_To_runtime_Object(&in.VendorRequestParameters, &out.VendorRequestParameters, s); err != nil {
		return err
	}
	if err := Convert_v1alpha2_AllocationResultModel_To_resource_AllocationResultModel(&in.AllocationResultModel, &out.AllocationResultModel, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1alpha2_DriverAllocationResult_To_resource_DriverAllocationResult is an autogenerated conversion function.
func Convert_v1alpha2_DriverAllocationResult_To_resource_DriverAllocationResult(in *v1alpha2.DriverAllocationResult, out *resource.DriverAllocationResult, s conversion.Scope) error {
	return autoConvert_v1alpha2_DriverAllocationResult_To_resource_DriverAllocationResult(in, out, s)
}

func autoConvert_resource_DriverAllocationResult_To_v1alpha2_DriverAllocationResult(in *resource.DriverAllocationResult, out *v1alpha2.DriverAllocationResult, s conversion.Scope) error {
	if err := runtime.Convert_runtime_Object_To_runtime_RawExtension(&in.VendorRequestParameters, &out.VendorRequestParameters, s); err != nil {
		return err
	}
	if err := Convert_resource_AllocationResultModel_To_v1alpha2_AllocationResultModel(&in.AllocationResultModel, &out.AllocationResultModel, s); err != nil {
		return err
	}
	return nil
}

// Convert_resource_DriverAllocationResult_To_v1alpha2_DriverAllocationResult is an autogenerated conversion function.
func Convert_resource_DriverAllocationResult_To_v1alpha2_DriverAllocationResult(in *resource.DriverAllocationResult, out *v1alpha2.DriverAllocationResult, s conversion.Scope) error {
	return autoConvert_resource_DriverAllocationResult_To_v1alpha2_DriverAllocationResult(in, out, s)
}

func autoConvert_v1alpha2_DriverRequests_To_resource_DriverRequests(in *v1alpha2.DriverRequests, out *resource.DriverRequests, s conversion.Scope) error {
	out.DriverName = in.DriverName
	if err := runtime.Convert_runtime_RawExtension_To_runtime_Object(&in.VendorParameters, &out.VendorParameters, s); err != nil {
		return err
	}
	if in.Requests != nil {
		in, out := &in.Requests, &out.Requests
		*out = make([]resource.ResourceRequest, len(*in))
		for i := range *in {
			if err := Convert_v1alpha2_ResourceRequest_To_resource_ResourceRequest(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Requests = nil
	}
	return nil
}

// Convert_v1alpha2_DriverRequests_To_resource_DriverRequests is an autogenerated conversion function.
func Convert_v1alpha2_DriverRequests_To_resource_DriverRequests(in *v1alpha2.DriverRequests, out *resource.DriverRequests, s conversion.Scope) error {
	return autoConvert_v1alpha2_DriverRequests_To_resource_DriverRequests(in, out, s)
}

func autoConvert_resource_DriverRequests_To_v1alpha2_DriverRequests(in *resource.DriverRequests, out *v1alpha2.DriverRequests, s conversion.Scope) error {
	out.DriverName = in.DriverName
	if err := runtime.Convert_runtime_Object_To_runtime_RawExtension(&in.VendorParameters, &out.VendorParameters, s); err != nil {
		return err
	}
	if in.Requests != nil {
		in, out := &in.Requests, &out.Requests
		*out = make([]v1alpha2.ResourceRequest, len(*in))
		for i := range *in {
			if err := Convert_resource_ResourceRequest_To_v1alpha2_ResourceRequest(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Requests = nil
	}
	return nil
}

// Convert_resource_DriverRequests_To_v1alpha2_DriverRequests is an autogenerated conversion function.
func Convert_resource_DriverRequests_To_v1alpha2_DriverRequests(in *resource.DriverRequests, out *v1alpha2.DriverRequests, s conversion.Scope) error {
	return autoConvert_resource_DriverRequests_To_v1alpha2_DriverRequests(in, out, s)
}

func autoConvert_v1alpha2_NamedResourcesAllocationResult_To_resource_NamedResourcesAllocationResult(in *v1alpha2.NamedResourcesAllocationResult, out *resource.NamedResourcesAllocationResult, s conversion.Scope) error {
	out.Name = in.Name
	return nil
}

// Convert_v1alpha2_NamedResourcesAllocationResult_To_resource_NamedResourcesAllocationResult is an autogenerated conversion function.
func Convert_v1alpha2_NamedResourcesAllocationResult_To_resource_NamedResourcesAllocationResult(in *v1alpha2.NamedResourcesAllocationResult, out *resource.NamedResourcesAllocationResult, s conversion.Scope) error {
	return autoConvert_v1alpha2_NamedResourcesAllocationResult_To_resource_NamedResourcesAllocationResult(in, out, s)
}

func autoConvert_resource_NamedResourcesAllocationResult_To_v1alpha2_NamedResourcesAllocationResult(in *resource.NamedResourcesAllocationResult, out *v1alpha2.NamedResourcesAllocationResult, s conversion.Scope) error {
	out.Name = in.Name
	return nil
}

// Convert_resource_NamedResourcesAllocationResult_To_v1alpha2_NamedResourcesAllocationResult is an autogenerated conversion function.
func Convert_resource_NamedResourcesAllocationResult_To_v1alpha2_NamedResourcesAllocationResult(in *resource.NamedResourcesAllocationResult, out *v1alpha2.NamedResourcesAllocationResult, s conversion.Scope) error {
	return autoConvert_resource_NamedResourcesAllocationResult_To_v1alpha2_NamedResourcesAllocationResult(in, out, s)
}

func autoConvert_v1alpha2_NamedResourcesAttribute_To_resource_NamedResourcesAttribute(in *v1alpha2.NamedResourcesAttribute, out *resource.NamedResourcesAttribute, s conversion.Scope) error {
	out.Name = in.Name
	if err := Convert_v1alpha2_NamedResourcesAttributeValue_To_resource_NamedResourcesAttributeValue(&in.NamedResourcesAttributeValue, &out.NamedResourcesAttributeValue, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1alpha2_NamedResourcesAttribute_To_resource_NamedResourcesAttribute is an autogenerated conversion function.
func Convert_v1alpha2_NamedResourcesAttribute_To_resource_NamedResourcesAttribute(in *v1alpha2.NamedResourcesAttribute, out *resource.NamedResourcesAttribute, s conversion.Scope) error {
	return autoConvert_v1alpha2_NamedResourcesAttribute_To_resource_NamedResourcesAttribute(in, out, s)
}

func autoConvert_resource_NamedResourcesAttribute_To_v1alpha2_NamedResourcesAttribute(in *resource.NamedResourcesAttribute, out *v1alpha2.NamedResourcesAttribute, s conversion.Scope) error {
	out.Name = in.Name
	if err := Convert_resource_NamedResourcesAttributeValue_To_v1alpha2_NamedResourcesAttributeValue(&in.NamedResourcesAttributeValue, &out.NamedResourcesAttributeValue, s); err != nil {
		return err
	}
	return nil
}

// Convert_resource_NamedResourcesAttribute_To_v1alpha2_NamedResourcesAttribute is an autogenerated conversion function.
func Convert_resource_NamedResourcesAttribute_To_v1alpha2_NamedResourcesAttribute(in *resource.NamedResourcesAttribute, out *v1alpha2.NamedResourcesAttribute, s conversion.Scope) error {
	return autoConvert_resource_NamedResourcesAttribute_To_v1alpha2_NamedResourcesAttribute(in, out, s)
}

func autoConvert_v1alpha2_NamedResourcesAttributeValue_To_resource_NamedResourcesAttributeValue(in *v1alpha2.NamedResourcesAttributeValue, out *resource.NamedResourcesAttributeValue, s conversion.Scope) error {
	out.QuantityValue = (*apiresource.Quantity)(unsafe.Pointer(in.QuantityValue))
	out.BoolValue = (*bool)(unsafe.Pointer(in.BoolValue))
	out.IntValue = (*int64)(unsafe.Pointer(in.IntValue))
	out.IntSliceValue = (*resource.NamedResourcesIntSlice)(unsafe.Pointer(in.IntSliceValue))
	out.StringValue = (*string)(unsafe.Pointer(in.StringValue))
	out.StringSliceValue = (*resource.NamedResourcesStringSlice)(unsafe.Pointer(in.StringSliceValue))
	out.VersionValue = (*string)(unsafe.Pointer(in.VersionValue))
	return nil
}

// Convert_v1alpha2_NamedResourcesAttributeValue_To_resource_NamedResourcesAttributeValue is an autogenerated conversion function.
func Convert_v1alpha2_NamedResourcesAttributeValue_To_resource_NamedResourcesAttributeValue(in *v1alpha2.NamedResourcesAttributeValue, out *resource.NamedResourcesAttributeValue, s conversion.Scope) error {
	return autoConvert_v1alpha2_NamedResourcesAttributeValue_To_resource_NamedResourcesAttributeValue(in, out, s)
}

func autoConvert_resource_NamedResourcesAttributeValue_To_v1alpha2_NamedResourcesAttributeValue(in *resource.NamedResourcesAttributeValue, out *v1alpha2.NamedResourcesAttributeValue, s conversion.Scope) error {
	out.QuantityValue = (*apiresource.Quantity)(unsafe.Pointer(in.QuantityValue))
	out.BoolValue = (*bool)(unsafe.Pointer(in.BoolValue))
	out.IntValue = (*int64)(unsafe.Pointer(in.IntValue))
	out.IntSliceValue = (*v1alpha2.NamedResourcesIntSlice)(unsafe.Pointer(in.IntSliceValue))
	out.StringValue = (*string)(unsafe.Pointer(in.StringValue))
	out.StringSliceValue = (*v1alpha2.NamedResourcesStringSlice)(unsafe.Pointer(in.StringSliceValue))
	out.VersionValue = (*string)(unsafe.Pointer(in.VersionValue))
	return nil
}

// Convert_resource_NamedResourcesAttributeValue_To_v1alpha2_NamedResourcesAttributeValue is an autogenerated conversion function.
func Convert_resource_NamedResourcesAttributeValue_To_v1alpha2_NamedResourcesAttributeValue(in *resource.NamedResourcesAttributeValue, out *v1alpha2.NamedResourcesAttributeValue, s conversion.Scope) error {
	return autoConvert_resource_NamedResourcesAttributeValue_To_v1alpha2_NamedResourcesAttributeValue(in, out, s)
}

func autoConvert_v1alpha2_NamedResourcesFilter_To_resource_NamedResourcesFilter(in *v1alpha2.NamedResourcesFilter, out *resource.NamedResourcesFilter, s conversion.Scope) error {
	out.Selector = in.Selector
	return nil
}

// Convert_v1alpha2_NamedResourcesFilter_To_resource_NamedResourcesFilter is an autogenerated conversion function.
func Convert_v1alpha2_NamedResourcesFilter_To_resource_NamedResourcesFilter(in *v1alpha2.NamedResourcesFilter, out *resource.NamedResourcesFilter, s conversion.Scope) error {
	return autoConvert_v1alpha2_NamedResourcesFilter_To_resource_NamedResourcesFilter(in, out, s)
}

func autoConvert_resource_NamedResourcesFilter_To_v1alpha2_NamedResourcesFilter(in *resource.NamedResourcesFilter, out *v1alpha2.NamedResourcesFilter, s conversion.Scope) error {
	out.Selector = in.Selector
	return nil
}

// Convert_resource_NamedResourcesFilter_To_v1alpha2_NamedResourcesFilter is an autogenerated conversion function.
func Convert_resource_NamedResourcesFilter_To_v1alpha2_NamedResourcesFilter(in *resource.NamedResourcesFilter, out *v1alpha2.NamedResourcesFilter, s conversion.Scope) error {
	return autoConvert_resource_NamedResourcesFilter_To_v1alpha2_NamedResourcesFilter(in, out, s)
}

func autoConvert_v1alpha2_NamedResourcesInstance_To_resource_NamedResourcesInstance(in *v1alpha2.NamedResourcesInstance, out *resource.NamedResourcesInstance, s conversion.Scope) error {
	out.Name = in.Name
	out.Attributes = *(*[]resource.NamedResourcesAttribute)(unsafe.Pointer(&in.Attributes))
	return nil
}

// Convert_v1alpha2_NamedResourcesInstance_To_resource_NamedResourcesInstance is an autogenerated conversion function.
func Convert_v1alpha2_NamedResourcesInstance_To_resource_NamedResourcesInstance(in *v1alpha2.NamedResourcesInstance, out *resource.NamedResourcesInstance, s conversion.Scope) error {
	return autoConvert_v1alpha2_NamedResourcesInstance_To_resource_NamedResourcesInstance(in, out, s)
}

func autoConvert_resource_NamedResourcesInstance_To_v1alpha2_NamedResourcesInstance(in *resource.NamedResourcesInstance, out *v1alpha2.NamedResourcesInstance, s conversion.Scope) error {
	out.Name = in.Name
	out.Attributes = *(*[]v1alpha2.NamedResourcesAttribute)(unsafe.Pointer(&in.Attributes))
	return nil
}

// Convert_resource_NamedResourcesInstance_To_v1alpha2_NamedResourcesInstance is an autogenerated conversion function.
func Convert_resource_NamedResourcesInstance_To_v1alpha2_NamedResourcesInstance(in *resource.NamedResourcesInstance, out *v1alpha2.NamedResourcesInstance, s conversion.Scope) error {
	return autoConvert_resource_NamedResourcesInstance_To_v1alpha2_NamedResourcesInstance(in, out, s)
}

func autoConvert_v1alpha2_NamedResourcesIntSlice_To_resource_NamedResourcesIntSlice(in *v1alpha2.NamedResourcesIntSlice, out *resource.NamedResourcesIntSlice, s conversion.Scope) error {
	out.Ints = *(*[]int64)(unsafe.Pointer(&in.Ints))
	return nil
}

// Convert_v1alpha2_NamedResourcesIntSlice_To_resource_NamedResourcesIntSlice is an autogenerated conversion function.
func Convert_v1alpha2_NamedResourcesIntSlice_To_resource_NamedResourcesIntSlice(in *v1alpha2.NamedResourcesIntSlice, out *resource.NamedResourcesIntSlice, s conversion.Scope) error {
	return autoConvert_v1alpha2_NamedResourcesIntSlice_To_resource_NamedResourcesIntSlice(in, out, s)
}

func autoConvert_resource_NamedResourcesIntSlice_To_v1alpha2_NamedResourcesIntSlice(in *resource.NamedResourcesIntSlice, out *v1alpha2.NamedResourcesIntSlice, s conversion.Scope) error {
	out.Ints = *(*[]int64)(unsafe.Pointer(&in.Ints))
	return nil
}

// Convert_resource_NamedResourcesIntSlice_To_v1alpha2_NamedResourcesIntSlice is an autogenerated conversion function.
func Convert_resource_NamedResourcesIntSlice_To_v1alpha2_NamedResourcesIntSlice(in *resource.NamedResourcesIntSlice, out *v1alpha2.NamedResourcesIntSlice, s conversion.Scope) error {
	return autoConvert_resource_NamedResourcesIntSlice_To_v1alpha2_NamedResourcesIntSlice(in, out, s)
}

func autoConvert_v1alpha2_NamedResourcesRequest_To_resource_NamedResourcesRequest(in *v1alpha2.NamedResourcesRequest, out *resource.NamedResourcesRequest, s conversion.Scope) error {
	out.Selector = in.Selector
	return nil
}

// Convert_v1alpha2_NamedResourcesRequest_To_resource_NamedResourcesRequest is an autogenerated conversion function.
func Convert_v1alpha2_NamedResourcesRequest_To_resource_NamedResourcesRequest(in *v1alpha2.NamedResourcesRequest, out *resource.NamedResourcesRequest, s conversion.Scope) error {
	return autoConvert_v1alpha2_NamedResourcesRequest_To_resource_NamedResourcesRequest(in, out, s)
}

func autoConvert_resource_NamedResourcesRequest_To_v1alpha2_NamedResourcesRequest(in *resource.NamedResourcesRequest, out *v1alpha2.NamedResourcesRequest, s conversion.Scope) error {
	out.Selector = in.Selector
	return nil
}

// Convert_resource_NamedResourcesRequest_To_v1alpha2_NamedResourcesRequest is an autogenerated conversion function.
func Convert_resource_NamedResourcesRequest_To_v1alpha2_NamedResourcesRequest(in *resource.NamedResourcesRequest, out *v1alpha2.NamedResourcesRequest, s conversion.Scope) error {
	return autoConvert_resource_NamedResourcesRequest_To_v1alpha2_NamedResourcesRequest(in, out, s)
}

func autoConvert_v1alpha2_NamedResourcesResources_To_resource_NamedResourcesResources(in *v1alpha2.NamedResourcesResources, out *resource.NamedResourcesResources, s conversion.Scope) error {
	out.Instances = *(*[]resource.NamedResourcesInstance)(unsafe.Pointer(&in.Instances))
	return nil
}

// Convert_v1alpha2_NamedResourcesResources_To_resource_NamedResourcesResources is an autogenerated conversion function.
func Convert_v1alpha2_NamedResourcesResources_To_resource_NamedResourcesResources(in *v1alpha2.NamedResourcesResources, out *resource.NamedResourcesResources, s conversion.Scope) error {
	return autoConvert_v1alpha2_NamedResourcesResources_To_resource_NamedResourcesResources(in, out, s)
}

func autoConvert_resource_NamedResourcesResources_To_v1alpha2_NamedResourcesResources(in *resource.NamedResourcesResources, out *v1alpha2.NamedResourcesResources, s conversion.Scope) error {
	out.Instances = *(*[]v1alpha2.NamedResourcesInstance)(unsafe.Pointer(&in.Instances))
	return nil
}

// Convert_resource_NamedResourcesResources_To_v1alpha2_NamedResourcesResources is an autogenerated conversion function.
func Convert_resource_NamedResourcesResources_To_v1alpha2_NamedResourcesResources(in *resource.NamedResourcesResources, out *v1alpha2.NamedResourcesResources, s conversion.Scope) error {
	return autoConvert_resource_NamedResourcesResources_To_v1alpha2_NamedResourcesResources(in, out, s)
}

func autoConvert_v1alpha2_NamedResourcesStringSlice_To_resource_NamedResourcesStringSlice(in *v1alpha2.NamedResourcesStringSlice, out *resource.NamedResourcesStringSlice, s conversion.Scope) error {
	out.Strings = *(*[]string)(unsafe.Pointer(&in.Strings))
	return nil
}

// Convert_v1alpha2_NamedResourcesStringSlice_To_resource_NamedResourcesStringSlice is an autogenerated conversion function.
func Convert_v1alpha2_NamedResourcesStringSlice_To_resource_NamedResourcesStringSlice(in *v1alpha2.NamedResourcesStringSlice, out *resource.NamedResourcesStringSlice, s conversion.Scope) error {
	return autoConvert_v1alpha2_NamedResourcesStringSlice_To_resource_NamedResourcesStringSlice(in, out, s)
}

func autoConvert_resource_NamedResourcesStringSlice_To_v1alpha2_NamedResourcesStringSlice(in *resource.NamedResourcesStringSlice, out *v1alpha2.NamedResourcesStringSlice, s conversion.Scope) error {
	out.Strings = *(*[]string)(unsafe.Pointer(&in.Strings))
	return nil
}

// Convert_resource_NamedResourcesStringSlice_To_v1alpha2_NamedResourcesStringSlice is an autogenerated conversion function.
func Convert_resource_NamedResourcesStringSlice_To_v1alpha2_NamedResourcesStringSlice(in *resource.NamedResourcesStringSlice, out *v1alpha2.NamedResourcesStringSlice, s conversion.Scope) error {
	return autoConvert_resource_NamedResourcesStringSlice_To_v1alpha2_NamedResourcesStringSlice(in, out, s)
}

func autoConvert_v1alpha2_PodSchedulingContext_To_resource_PodSchedulingContext(in *v1alpha2.PodSchedulingContext, out *resource.PodSchedulingContext, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1alpha2_PodSchedulingContextSpec_To_resource_PodSchedulingContextSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_v1alpha2_PodSchedulingContextStatus_To_resource_PodSchedulingContextStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1alpha2_PodSchedulingContext_To_resource_PodSchedulingContext is an autogenerated conversion function.
func Convert_v1alpha2_PodSchedulingContext_To_resource_PodSchedulingContext(in *v1alpha2.PodSchedulingContext, out *resource.PodSchedulingContext, s conversion.Scope) error {
	return autoConvert_v1alpha2_PodSchedulingContext_To_resource_PodSchedulingContext(in, out, s)
}

func autoConvert_resource_PodSchedulingContext_To_v1alpha2_PodSchedulingContext(in *resource.PodSchedulingContext, out *v1alpha2.PodSchedulingContext, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_resource_PodSchedulingContextSpec_To_v1alpha2_PodSchedulingContextSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_resource_PodSchedulingContextStatus_To_v1alpha2_PodSchedulingContextStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_resource_PodSchedulingContext_To_v1alpha2_PodSchedulingContext is an autogenerated conversion function.
func Convert_resource_PodSchedulingContext_To_v1alpha2_PodSchedulingContext(in *resource.PodSchedulingContext, out *v1alpha2.PodSchedulingContext, s conversion.Scope) error {
	return autoConvert_resource_PodSchedulingContext_To_v1alpha2_PodSchedulingContext(in, out, s)
}

func autoConvert_v1alpha2_PodSchedulingContextList_To_resource_PodSchedulingContextList(in *v1alpha2.PodSchedulingContextList, out *resource.PodSchedulingContextList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	out.Items = *(*[]resource.PodSchedulingContext)(unsafe.Pointer(&in.Items))
	return nil
}

// Convert_v1alpha2_PodSchedulingContextList_To_resource_PodSchedulingContextList is an autogenerated conversion function.
func Convert_v1alpha2_PodSchedulingContextList_To_resource_PodSchedulingContextList(in *v1alpha2.PodSchedulingContextList, out *resource.PodSchedulingContextList, s conversion.Scope) error {
	return autoConvert_v1alpha2_PodSchedulingContextList_To_resource_PodSchedulingContextList(in, out, s)
}

func autoConvert_resource_PodSchedulingContextList_To_v1alpha2_PodSchedulingContextList(in *resource.PodSchedulingContextList, out *v1alpha2.PodSchedulingContextList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	out.Items = *(*[]v1alpha2.PodSchedulingContext)(unsafe.Pointer(&in.Items))
	return nil
}

// Convert_resource_PodSchedulingContextList_To_v1alpha2_PodSchedulingContextList is an autogenerated conversion function.
func Convert_resource_PodSchedulingContextList_To_v1alpha2_PodSchedulingContextList(in *resource.PodSchedulingContextList, out *v1alpha2.PodSchedulingContextList, s conversion.Scope) error {
	return autoConvert_resource_PodSchedulingContextList_To_v1alpha2_PodSchedulingContextList(in, out, s)
}

func autoConvert_v1alpha2_PodSchedulingContextSpec_To_resource_PodSchedulingContextSpec(in *v1alpha2.PodSchedulingContextSpec, out *resource.PodSchedulingContextSpec, s conversion.Scope) error {
	out.SelectedNode = in.SelectedNode
	out.PotentialNodes = *(*[]string)(unsafe.Pointer(&in.PotentialNodes))
	return nil
}

// Convert_v1alpha2_PodSchedulingContextSpec_To_resource_PodSchedulingContextSpec is an autogenerated conversion function.
func Convert_v1alpha2_PodSchedulingContextSpec_To_resource_PodSchedulingContextSpec(in *v1alpha2.PodSchedulingContextSpec, out *resource.PodSchedulingContextSpec, s conversion.Scope) error {
	return autoConvert_v1alpha2_PodSchedulingContextSpec_To_resource_PodSchedulingContextSpec(in, out, s)
}

func autoConvert_resource_PodSchedulingContextSpec_To_v1alpha2_PodSchedulingContextSpec(in *resource.PodSchedulingContextSpec, out *v1alpha2.PodSchedulingContextSpec, s conversion.Scope) error {
	out.SelectedNode = in.SelectedNode
	out.PotentialNodes = *(*[]string)(unsafe.Pointer(&in.PotentialNodes))
	return nil
}

// Convert_resource_PodSchedulingContextSpec_To_v1alpha2_PodSchedulingContextSpec is an autogenerated conversion function.
func Convert_resource_PodSchedulingContextSpec_To_v1alpha2_PodSchedulingContextSpec(in *resource.PodSchedulingContextSpec, out *v1alpha2.PodSchedulingContextSpec, s conversion.Scope) error {
	return autoConvert_resource_PodSchedulingContextSpec_To_v1alpha2_PodSchedulingContextSpec(in, out, s)
}

func autoConvert_v1alpha2_PodSchedulingContextStatus_To_resource_PodSchedulingContextStatus(in *v1alpha2.PodSchedulingContextStatus, out *resource.PodSchedulingContextStatus, s conversion.Scope) error {
	out.ResourceClaims = *(*[]resource.ResourceClaimSchedulingStatus)(unsafe.Pointer(&in.ResourceClaims))
	return nil
}

// Convert_v1alpha2_PodSchedulingContextStatus_To_resource_PodSchedulingContextStatus is an autogenerated conversion function.
func Convert_v1alpha2_PodSchedulingContextStatus_To_resource_PodSchedulingContextStatus(in *v1alpha2.PodSchedulingContextStatus, out *resource.PodSchedulingContextStatus, s conversion.Scope) error {
	return autoConvert_v1alpha2_PodSchedulingContextStatus_To_resource_PodSchedulingContextStatus(in, out, s)
}

func autoConvert_resource_PodSchedulingContextStatus_To_v1alpha2_PodSchedulingContextStatus(in *resource.PodSchedulingContextStatus, out *v1alpha2.PodSchedulingContextStatus, s conversion.Scope) error {
	out.ResourceClaims = *(*[]v1alpha2.ResourceClaimSchedulingStatus)(unsafe.Pointer(&in.ResourceClaims))
	return nil
}

// Convert_resource_PodSchedulingContextStatus_To_v1alpha2_PodSchedulingContextStatus is an autogenerated conversion function.
func Convert_resource_PodSchedulingContextStatus_To_v1alpha2_PodSchedulingContextStatus(in *resource.PodSchedulingContextStatus, out *v1alpha2.PodSchedulingContextStatus, s conversion.Scope) error {
	return autoConvert_resource_PodSchedulingContextStatus_To_v1alpha2_PodSchedulingContextStatus(in, out, s)
}

func autoConvert_v1alpha2_ResourceClaim_To_resource_ResourceClaim(in *v1alpha2.ResourceClaim, out *resource.ResourceClaim, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1alpha2_ResourceClaimSpec_To_resource_ResourceClaimSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_v1alpha2_ResourceClaimStatus_To_resource_ResourceClaimStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1alpha2_ResourceClaim_To_resource_ResourceClaim is an autogenerated conversion function.
func Convert_v1alpha2_ResourceClaim_To_resource_ResourceClaim(in *v1alpha2.ResourceClaim, out *resource.ResourceClaim, s conversion.Scope) error {
	return autoConvert_v1alpha2_ResourceClaim_To_resource_ResourceClaim(in, out, s)
}

func autoConvert_resource_ResourceClaim_To_v1alpha2_ResourceClaim(in *resource.ResourceClaim, out *v1alpha2.ResourceClaim, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_resource_ResourceClaimSpec_To_v1alpha2_ResourceClaimSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_resource_ResourceClaimStatus_To_v1alpha2_ResourceClaimStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_resource_ResourceClaim_To_v1alpha2_ResourceClaim is an autogenerated conversion function.
func Convert_resource_ResourceClaim_To_v1alpha2_ResourceClaim(in *resource.ResourceClaim, out *v1alpha2.ResourceClaim, s conversion.Scope) error {
	return autoConvert_resource_ResourceClaim_To_v1alpha2_ResourceClaim(in, out, s)
}

func autoConvert_v1alpha2_ResourceClaimConsumerReference_To_resource_ResourceClaimConsumerReference(in *v1alpha2.ResourceClaimConsumerReference, out *resource.ResourceClaimConsumerReference, s conversion.Scope) error {
	out.APIGroup = in.APIGroup
	out.Resource = in.Resource
	out.Name = in.Name
	out.UID = types.UID(in.UID)
	return nil
}

// Convert_v1alpha2_ResourceClaimConsumerReference_To_resource_ResourceClaimConsumerReference is an autogenerated conversion function.
func Convert_v1alpha2_ResourceClaimConsumerReference_To_resource_ResourceClaimConsumerReference(in *v1alpha2.ResourceClaimConsumerReference, out *resource.ResourceClaimConsumerReference, s conversion.Scope) error {
	return autoConvert_v1alpha2_ResourceClaimConsumerReference_To_resource_ResourceClaimConsumerReference(in, out, s)
}

func autoConvert_resource_ResourceClaimConsumerReference_To_v1alpha2_ResourceClaimConsumerReference(in *resource.ResourceClaimConsumerReference, out *v1alpha2.ResourceClaimConsumerReference, s conversion.Scope) error {
	out.APIGroup = in.APIGroup
	out.Resource = in.Resource
	out.Name = in.Name
	out.UID = types.UID(in.UID)
	return nil
}

// Convert_resource_ResourceClaimConsumerReference_To_v1alpha2_ResourceClaimConsumerReference is an autogenerated conversion function.
func Convert_resource_ResourceClaimConsumerReference_To_v1alpha2_ResourceClaimConsumerReference(in *resource.ResourceClaimConsumerReference, out *v1alpha2.ResourceClaimConsumerReference, s conversion.Scope) error {
	return autoConvert_resource_ResourceClaimConsumerReference_To_v1alpha2_ResourceClaimConsumerReference(in, out, s)
}

func autoConvert_v1alpha2_ResourceClaimList_To_resource_ResourceClaimList(in *v1alpha2.ResourceClaimList, out *resource.ResourceClaimList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]resource.ResourceClaim, len(*in))
		for i := range *in {
			if err := Convert_v1alpha2_ResourceClaim_To_resource_ResourceClaim(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

// Convert_v1alpha2_ResourceClaimList_To_resource_ResourceClaimList is an autogenerated conversion function.
func Convert_v1alpha2_ResourceClaimList_To_resource_ResourceClaimList(in *v1alpha2.ResourceClaimList, out *resource.ResourceClaimList, s conversion.Scope) error {
	return autoConvert_v1alpha2_ResourceClaimList_To_resource_ResourceClaimList(in, out, s)
}

func autoConvert_resource_ResourceClaimList_To_v1alpha2_ResourceClaimList(in *resource.ResourceClaimList, out *v1alpha2.ResourceClaimList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]v1alpha2.ResourceClaim, len(*in))
		for i := range *in {
			if err := Convert_resource_ResourceClaim_To_v1alpha2_ResourceClaim(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

// Convert_resource_ResourceClaimList_To_v1alpha2_ResourceClaimList is an autogenerated conversion function.
func Convert_resource_ResourceClaimList_To_v1alpha2_ResourceClaimList(in *resource.ResourceClaimList, out *v1alpha2.ResourceClaimList, s conversion.Scope) error {
	return autoConvert_resource_ResourceClaimList_To_v1alpha2_ResourceClaimList(in, out, s)
}

func autoConvert_v1alpha2_ResourceClaimParameters_To_resource_ResourceClaimParameters(in *v1alpha2.ResourceClaimParameters, out *resource.ResourceClaimParameters, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	out.GeneratedFrom = (*resource.ResourceClaimParametersReference)(unsafe.Pointer(in.GeneratedFrom))
	out.Shareable = in.Shareable
	if in.DriverRequests != nil {
		in, out := &in.DriverRequests, &out.DriverRequests
		*out = make([]resource.DriverRequests, len(*in))
		for i := range *in {
			if err := Convert_v1alpha2_DriverRequests_To_resource_DriverRequests(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.DriverRequests = nil
	}
	return nil
}

// Convert_v1alpha2_ResourceClaimParameters_To_resource_ResourceClaimParameters is an autogenerated conversion function.
func Convert_v1alpha2_ResourceClaimParameters_To_resource_ResourceClaimParameters(in *v1alpha2.ResourceClaimParameters, out *resource.ResourceClaimParameters, s conversion.Scope) error {
	return autoConvert_v1alpha2_ResourceClaimParameters_To_resource_ResourceClaimParameters(in, out, s)
}

func autoConvert_resource_ResourceClaimParameters_To_v1alpha2_ResourceClaimParameters(in *resource.ResourceClaimParameters, out *v1alpha2.ResourceClaimParameters, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	out.GeneratedFrom = (*v1alpha2.ResourceClaimParametersReference)(unsafe.Pointer(in.GeneratedFrom))
	out.Shareable = in.Shareable
	if in.DriverRequests != nil {
		in, out := &in.DriverRequests, &out.DriverRequests
		*out = make([]v1alpha2.DriverRequests, len(*in))
		for i := range *in {
			if err := Convert_resource_DriverRequests_To_v1alpha2_DriverRequests(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.DriverRequests = nil
	}
	return nil
}

// Convert_resource_ResourceClaimParameters_To_v1alpha2_ResourceClaimParameters is an autogenerated conversion function.
func Convert_resource_ResourceClaimParameters_To_v1alpha2_ResourceClaimParameters(in *resource.ResourceClaimParameters, out *v1alpha2.ResourceClaimParameters, s conversion.Scope) error {
	return autoConvert_resource_ResourceClaimParameters_To_v1alpha2_ResourceClaimParameters(in, out, s)
}

func autoConvert_v1alpha2_ResourceClaimParametersList_To_resource_ResourceClaimParametersList(in *v1alpha2.ResourceClaimParametersList, out *resource.ResourceClaimParametersList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]resource.ResourceClaimParameters, len(*in))
		for i := range *in {
			if err := Convert_v1alpha2_ResourceClaimParameters_To_resource_ResourceClaimParameters(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

// Convert_v1alpha2_ResourceClaimParametersList_To_resource_ResourceClaimParametersList is an autogenerated conversion function.
func Convert_v1alpha2_ResourceClaimParametersList_To_resource_ResourceClaimParametersList(in *v1alpha2.ResourceClaimParametersList, out *resource.ResourceClaimParametersList, s conversion.Scope) error {
	return autoConvert_v1alpha2_ResourceClaimParametersList_To_resource_ResourceClaimParametersList(in, out, s)
}

func autoConvert_resource_ResourceClaimParametersList_To_v1alpha2_ResourceClaimParametersList(in *resource.ResourceClaimParametersList, out *v1alpha2.ResourceClaimParametersList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]v1alpha2.ResourceClaimParameters, len(*in))
		for i := range *in {
			if err := Convert_resource_ResourceClaimParameters_To_v1alpha2_ResourceClaimParameters(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

// Convert_resource_ResourceClaimParametersList_To_v1alpha2_ResourceClaimParametersList is an autogenerated conversion function.
func Convert_resource_ResourceClaimParametersList_To_v1alpha2_ResourceClaimParametersList(in *resource.ResourceClaimParametersList, out *v1alpha2.ResourceClaimParametersList, s conversion.Scope) error {
	return autoConvert_resource_ResourceClaimParametersList_To_v1alpha2_ResourceClaimParametersList(in, out, s)
}

func autoConvert_v1alpha2_ResourceClaimParametersReference_To_resource_ResourceClaimParametersReference(in *v1alpha2.ResourceClaimParametersReference, out *resource.ResourceClaimParametersReference, s conversion.Scope) error {
	out.APIGroup = in.APIGroup
	out.Kind = in.Kind
	out.Name = in.Name
	return nil
}

// Convert_v1alpha2_ResourceClaimParametersReference_To_resource_ResourceClaimParametersReference is an autogenerated conversion function.
func Convert_v1alpha2_ResourceClaimParametersReference_To_resource_ResourceClaimParametersReference(in *v1alpha2.ResourceClaimParametersReference, out *resource.ResourceClaimParametersReference, s conversion.Scope) error {
	return autoConvert_v1alpha2_ResourceClaimParametersReference_To_resource_ResourceClaimParametersReference(in, out, s)
}

func autoConvert_resource_ResourceClaimParametersReference_To_v1alpha2_ResourceClaimParametersReference(in *resource.ResourceClaimParametersReference, out *v1alpha2.ResourceClaimParametersReference, s conversion.Scope) error {
	out.APIGroup = in.APIGroup
	out.Kind = in.Kind
	out.Name = in.Name
	return nil
}

// Convert_resource_ResourceClaimParametersReference_To_v1alpha2_ResourceClaimParametersReference is an autogenerated conversion function.
func Convert_resource_ResourceClaimParametersReference_To_v1alpha2_ResourceClaimParametersReference(in *resource.ResourceClaimParametersReference, out *v1alpha2.ResourceClaimParametersReference, s conversion.Scope) error {
	return autoConvert_resource_ResourceClaimParametersReference_To_v1alpha2_ResourceClaimParametersReference(in, out, s)
}

func autoConvert_v1alpha2_ResourceClaimSchedulingStatus_To_resource_ResourceClaimSchedulingStatus(in *v1alpha2.ResourceClaimSchedulingStatus, out *resource.ResourceClaimSchedulingStatus, s conversion.Scope) error {
	out.Name = in.Name
	out.UnsuitableNodes = *(*[]string)(unsafe.Pointer(&in.UnsuitableNodes))
	return nil
}

// Convert_v1alpha2_ResourceClaimSchedulingStatus_To_resource_ResourceClaimSchedulingStatus is an autogenerated conversion function.
func Convert_v1alpha2_ResourceClaimSchedulingStatus_To_resource_ResourceClaimSchedulingStatus(in *v1alpha2.ResourceClaimSchedulingStatus, out *resource.ResourceClaimSchedulingStatus, s conversion.Scope) error {
	return autoConvert_v1alpha2_ResourceClaimSchedulingStatus_To_resource_ResourceClaimSchedulingStatus(in, out, s)
}

func autoConvert_resource_ResourceClaimSchedulingStatus_To_v1alpha2_ResourceClaimSchedulingStatus(in *resource.ResourceClaimSchedulingStatus, out *v1alpha2.ResourceClaimSchedulingStatus, s conversion.Scope) error {
	out.Name = in.Name
	out.UnsuitableNodes = *(*[]string)(unsafe.Pointer(&in.UnsuitableNodes))
	return nil
}

// Convert_resource_ResourceClaimSchedulingStatus_To_v1alpha2_ResourceClaimSchedulingStatus is an autogenerated conversion function.
func Convert_resource_ResourceClaimSchedulingStatus_To_v1alpha2_ResourceClaimSchedulingStatus(in *resource.ResourceClaimSchedulingStatus, out *v1alpha2.ResourceClaimSchedulingStatus, s conversion.Scope) error {
	return autoConvert_resource_ResourceClaimSchedulingStatus_To_v1alpha2_ResourceClaimSchedulingStatus(in, out, s)
}

func autoConvert_v1alpha2_ResourceClaimSpec_To_resource_ResourceClaimSpec(in *v1alpha2.ResourceClaimSpec, out *resource.ResourceClaimSpec, s conversion.Scope) error {
	out.ResourceClassName = in.ResourceClassName
	out.ParametersRef = (*resource.ResourceClaimParametersReference)(unsafe.Pointer(in.ParametersRef))
	out.AllocationMode = resource.AllocationMode(in.AllocationMode)
	return nil
}

// Convert_v1alpha2_ResourceClaimSpec_To_resource_ResourceClaimSpec is an autogenerated conversion function.
func Convert_v1alpha2_ResourceClaimSpec_To_resource_ResourceClaimSpec(in *v1alpha2.ResourceClaimSpec, out *resource.ResourceClaimSpec, s conversion.Scope) error {
	return autoConvert_v1alpha2_ResourceClaimSpec_To_resource_ResourceClaimSpec(in, out, s)
}

func autoConvert_resource_ResourceClaimSpec_To_v1alpha2_ResourceClaimSpec(in *resource.ResourceClaimSpec, out *v1alpha2.ResourceClaimSpec, s conversion.Scope) error {
	out.ResourceClassName = in.ResourceClassName
	out.ParametersRef = (*v1alpha2.ResourceClaimParametersReference)(unsafe.Pointer(in.ParametersRef))
	out.AllocationMode = v1alpha2.AllocationMode(in.AllocationMode)
	return nil
}

// Convert_resource_ResourceClaimSpec_To_v1alpha2_ResourceClaimSpec is an autogenerated conversion function.
func Convert_resource_ResourceClaimSpec_To_v1alpha2_ResourceClaimSpec(in *resource.ResourceClaimSpec, out *v1alpha2.ResourceClaimSpec, s conversion.Scope) error {
	return autoConvert_resource_ResourceClaimSpec_To_v1alpha2_ResourceClaimSpec(in, out, s)
}

func autoConvert_v1alpha2_ResourceClaimStatus_To_resource_ResourceClaimStatus(in *v1alpha2.ResourceClaimStatus, out *resource.ResourceClaimStatus, s conversion.Scope) error {
	out.DriverName = in.DriverName
	if in.Allocation != nil {
		in, out := &in.Allocation, &out.Allocation
		*out = new(resource.AllocationResult)
		if err := Convert_v1alpha2_AllocationResult_To_resource_AllocationResult(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Allocation = nil
	}
	out.ReservedFor = *(*[]resource.ResourceClaimConsumerReference)(unsafe.Pointer(&in.ReservedFor))
	out.DeallocationRequested = in.DeallocationRequested
	return nil
}

// Convert_v1alpha2_ResourceClaimStatus_To_resource_ResourceClaimStatus is an autogenerated conversion function.
func Convert_v1alpha2_ResourceClaimStatus_To_resource_ResourceClaimStatus(in *v1alpha2.ResourceClaimStatus, out *resource.ResourceClaimStatus, s conversion.Scope) error {
	return autoConvert_v1alpha2_ResourceClaimStatus_To_resource_ResourceClaimStatus(in, out, s)
}

func autoConvert_resource_ResourceClaimStatus_To_v1alpha2_ResourceClaimStatus(in *resource.ResourceClaimStatus, out *v1alpha2.ResourceClaimStatus, s conversion.Scope) error {
	out.DriverName = in.DriverName
	if in.Allocation != nil {
		in, out := &in.Allocation, &out.Allocation
		*out = new(v1alpha2.AllocationResult)
		if err := Convert_resource_AllocationResult_To_v1alpha2_AllocationResult(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Allocation = nil
	}
	out.ReservedFor = *(*[]v1alpha2.ResourceClaimConsumerReference)(unsafe.Pointer(&in.ReservedFor))
	out.DeallocationRequested = in.DeallocationRequested
	return nil
}

// Convert_resource_ResourceClaimStatus_To_v1alpha2_ResourceClaimStatus is an autogenerated conversion function.
func Convert_resource_ResourceClaimStatus_To_v1alpha2_ResourceClaimStatus(in *resource.ResourceClaimStatus, out *v1alpha2.ResourceClaimStatus, s conversion.Scope) error {
	return autoConvert_resource_ResourceClaimStatus_To_v1alpha2_ResourceClaimStatus(in, out, s)
}

func autoConvert_v1alpha2_ResourceClaimTemplate_To_resource_ResourceClaimTemplate(in *v1alpha2.ResourceClaimTemplate, out *resource.ResourceClaimTemplate, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1alpha2_ResourceClaimTemplateSpec_To_resource_ResourceClaimTemplateSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1alpha2_ResourceClaimTemplate_To_resource_ResourceClaimTemplate is an autogenerated conversion function.
func Convert_v1alpha2_ResourceClaimTemplate_To_resource_ResourceClaimTemplate(in *v1alpha2.ResourceClaimTemplate, out *resource.ResourceClaimTemplate, s conversion.Scope) error {
	return autoConvert_v1alpha2_ResourceClaimTemplate_To_resource_ResourceClaimTemplate(in, out, s)
}

func autoConvert_resource_ResourceClaimTemplate_To_v1alpha2_ResourceClaimTemplate(in *resource.ResourceClaimTemplate, out *v1alpha2.ResourceClaimTemplate, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_resource_ResourceClaimTemplateSpec_To_v1alpha2_ResourceClaimTemplateSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	return nil
}

// Convert_resource_ResourceClaimTemplate_To_v1alpha2_ResourceClaimTemplate is an autogenerated conversion function.
func Convert_resource_ResourceClaimTemplate_To_v1alpha2_ResourceClaimTemplate(in *resource.ResourceClaimTemplate, out *v1alpha2.ResourceClaimTemplate, s conversion.Scope) error {
	return autoConvert_resource_ResourceClaimTemplate_To_v1alpha2_ResourceClaimTemplate(in, out, s)
}

func autoConvert_v1alpha2_ResourceClaimTemplateList_To_resource_ResourceClaimTemplateList(in *v1alpha2.ResourceClaimTemplateList, out *resource.ResourceClaimTemplateList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	out.Items = *(*[]resource.ResourceClaimTemplate)(unsafe.Pointer(&in.Items))
	return nil
}

// Convert_v1alpha2_ResourceClaimTemplateList_To_resource_ResourceClaimTemplateList is an autogenerated conversion function.
func Convert_v1alpha2_ResourceClaimTemplateList_To_resource_ResourceClaimTemplateList(in *v1alpha2.ResourceClaimTemplateList, out *resource.ResourceClaimTemplateList, s conversion.Scope) error {
	return autoConvert_v1alpha2_ResourceClaimTemplateList_To_resource_ResourceClaimTemplateList(in, out, s)
}

func autoConvert_resource_ResourceClaimTemplateList_To_v1alpha2_ResourceClaimTemplateList(in *resource.ResourceClaimTemplateList, out *v1alpha2.ResourceClaimTemplateList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	out.Items = *(*[]v1alpha2.ResourceClaimTemplate)(unsafe.Pointer(&in.Items))
	return nil
}

// Convert_resource_ResourceClaimTemplateList_To_v1alpha2_ResourceClaimTemplateList is an autogenerated conversion function.
func Convert_resource_ResourceClaimTemplateList_To_v1alpha2_ResourceClaimTemplateList(in *resource.ResourceClaimTemplateList, out *v1alpha2.ResourceClaimTemplateList, s conversion.Scope) error {
	return autoConvert_resource_ResourceClaimTemplateList_To_v1alpha2_ResourceClaimTemplateList(in, out, s)
}

func autoConvert_v1alpha2_ResourceClaimTemplateSpec_To_resource_ResourceClaimTemplateSpec(in *v1alpha2.ResourceClaimTemplateSpec, out *resource.ResourceClaimTemplateSpec, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1alpha2_ResourceClaimSpec_To_resource_ResourceClaimSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1alpha2_ResourceClaimTemplateSpec_To_resource_ResourceClaimTemplateSpec is an autogenerated conversion function.
func Convert_v1alpha2_ResourceClaimTemplateSpec_To_resource_ResourceClaimTemplateSpec(in *v1alpha2.ResourceClaimTemplateSpec, out *resource.ResourceClaimTemplateSpec, s conversion.Scope) error {
	return autoConvert_v1alpha2_ResourceClaimTemplateSpec_To_resource_ResourceClaimTemplateSpec(in, out, s)
}

func autoConvert_resource_ResourceClaimTemplateSpec_To_v1alpha2_ResourceClaimTemplateSpec(in *resource.ResourceClaimTemplateSpec, out *v1alpha2.ResourceClaimTemplateSpec, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_resource_ResourceClaimSpec_To_v1alpha2_ResourceClaimSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	return nil
}

// Convert_resource_ResourceClaimTemplateSpec_To_v1alpha2_ResourceClaimTemplateSpec is an autogenerated conversion function.
func Convert_resource_ResourceClaimTemplateSpec_To_v1alpha2_ResourceClaimTemplateSpec(in *resource.ResourceClaimTemplateSpec, out *v1alpha2.ResourceClaimTemplateSpec, s conversion.Scope) error {
	return autoConvert_resource_ResourceClaimTemplateSpec_To_v1alpha2_ResourceClaimTemplateSpec(in, out, s)
}

func autoConvert_v1alpha2_ResourceClass_To_resource_ResourceClass(in *v1alpha2.ResourceClass, out *resource.ResourceClass, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	out.DriverName = in.DriverName
	out.ParametersRef = (*resource.ResourceClassParametersReference)(unsafe.Pointer(in.ParametersRef))
	out.SuitableNodes = (*core.NodeSelector)(unsafe.Pointer(in.SuitableNodes))
	out.StructuredParameters = (*bool)(unsafe.Pointer(in.StructuredParameters))
	return nil
}

// Convert_v1alpha2_ResourceClass_To_resource_ResourceClass is an autogenerated conversion function.
func Convert_v1alpha2_ResourceClass_To_resource_ResourceClass(in *v1alpha2.ResourceClass, out *resource.ResourceClass, s conversion.Scope) error {
	return autoConvert_v1alpha2_ResourceClass_To_resource_ResourceClass(in, out, s)
}

func autoConvert_resource_ResourceClass_To_v1alpha2_ResourceClass(in *resource.ResourceClass, out *v1alpha2.ResourceClass, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	out.DriverName = in.DriverName
	out.ParametersRef = (*v1alpha2.ResourceClassParametersReference)(unsafe.Pointer(in.ParametersRef))
	out.SuitableNodes = (*v1.NodeSelector)(unsafe.Pointer(in.SuitableNodes))
	out.StructuredParameters = (*bool)(unsafe.Pointer(in.StructuredParameters))
	return nil
}

// Convert_resource_ResourceClass_To_v1alpha2_ResourceClass is an autogenerated conversion function.
func Convert_resource_ResourceClass_To_v1alpha2_ResourceClass(in *resource.ResourceClass, out *v1alpha2.ResourceClass, s conversion.Scope) error {
	return autoConvert_resource_ResourceClass_To_v1alpha2_ResourceClass(in, out, s)
}

func autoConvert_v1alpha2_ResourceClassList_To_resource_ResourceClassList(in *v1alpha2.ResourceClassList, out *resource.ResourceClassList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	out.Items = *(*[]resource.ResourceClass)(unsafe.Pointer(&in.Items))
	return nil
}

// Convert_v1alpha2_ResourceClassList_To_resource_ResourceClassList is an autogenerated conversion function.
func Convert_v1alpha2_ResourceClassList_To_resource_ResourceClassList(in *v1alpha2.ResourceClassList, out *resource.ResourceClassList, s conversion.Scope) error {
	return autoConvert_v1alpha2_ResourceClassList_To_resource_ResourceClassList(in, out, s)
}

func autoConvert_resource_ResourceClassList_To_v1alpha2_ResourceClassList(in *resource.ResourceClassList, out *v1alpha2.ResourceClassList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	out.Items = *(*[]v1alpha2.ResourceClass)(unsafe.Pointer(&in.Items))
	return nil
}

// Convert_resource_ResourceClassList_To_v1alpha2_ResourceClassList is an autogenerated conversion function.
func Convert_resource_ResourceClassList_To_v1alpha2_ResourceClassList(in *resource.ResourceClassList, out *v1alpha2.ResourceClassList, s conversion.Scope) error {
	return autoConvert_resource_ResourceClassList_To_v1alpha2_ResourceClassList(in, out, s)
}

func autoConvert_v1alpha2_ResourceClassParameters_To_resource_ResourceClassParameters(in *v1alpha2.ResourceClassParameters, out *resource.ResourceClassParameters, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	out.GeneratedFrom = (*resource.ResourceClassParametersReference)(unsafe.Pointer(in.GeneratedFrom))
	if in.VendorParameters != nil {
		in, out := &in.VendorParameters, &out.VendorParameters
		*out = make([]resource.VendorParameters, len(*in))
		for i := range *in {
			if err := Convert_v1alpha2_VendorParameters_To_resource_VendorParameters(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.VendorParameters = nil
	}
	out.Filters = *(*[]resource.ResourceFilter)(unsafe.Pointer(&in.Filters))
	return nil
}

// Convert_v1alpha2_ResourceClassParameters_To_resource_ResourceClassParameters is an autogenerated conversion function.
func Convert_v1alpha2_ResourceClassParameters_To_resource_ResourceClassParameters(in *v1alpha2.ResourceClassParameters, out *resource.ResourceClassParameters, s conversion.Scope) error {
	return autoConvert_v1alpha2_ResourceClassParameters_To_resource_ResourceClassParameters(in, out, s)
}

func autoConvert_resource_ResourceClassParameters_To_v1alpha2_ResourceClassParameters(in *resource.ResourceClassParameters, out *v1alpha2.ResourceClassParameters, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	out.GeneratedFrom = (*v1alpha2.ResourceClassParametersReference)(unsafe.Pointer(in.GeneratedFrom))
	if in.VendorParameters != nil {
		in, out := &in.VendorParameters, &out.VendorParameters
		*out = make([]v1alpha2.VendorParameters, len(*in))
		for i := range *in {
			if err := Convert_resource_VendorParameters_To_v1alpha2_VendorParameters(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.VendorParameters = nil
	}
	out.Filters = *(*[]v1alpha2.ResourceFilter)(unsafe.Pointer(&in.Filters))
	return nil
}

// Convert_resource_ResourceClassParameters_To_v1alpha2_ResourceClassParameters is an autogenerated conversion function.
func Convert_resource_ResourceClassParameters_To_v1alpha2_ResourceClassParameters(in *resource.ResourceClassParameters, out *v1alpha2.ResourceClassParameters, s conversion.Scope) error {
	return autoConvert_resource_ResourceClassParameters_To_v1alpha2_ResourceClassParameters(in, out, s)
}

func autoConvert_v1alpha2_ResourceClassParametersList_To_resource_ResourceClassParametersList(in *v1alpha2.ResourceClassParametersList, out *resource.ResourceClassParametersList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]resource.ResourceClassParameters, len(*in))
		for i := range *in {
			if err := Convert_v1alpha2_ResourceClassParameters_To_resource_ResourceClassParameters(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

// Convert_v1alpha2_ResourceClassParametersList_To_resource_ResourceClassParametersList is an autogenerated conversion function.
func Convert_v1alpha2_ResourceClassParametersList_To_resource_ResourceClassParametersList(in *v1alpha2.ResourceClassParametersList, out *resource.ResourceClassParametersList, s conversion.Scope) error {
	return autoConvert_v1alpha2_ResourceClassParametersList_To_resource_ResourceClassParametersList(in, out, s)
}

func autoConvert_resource_ResourceClassParametersList_To_v1alpha2_ResourceClassParametersList(in *resource.ResourceClassParametersList, out *v1alpha2.ResourceClassParametersList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]v1alpha2.ResourceClassParameters, len(*in))
		for i := range *in {
			if err := Convert_resource_ResourceClassParameters_To_v1alpha2_ResourceClassParameters(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

// Convert_resource_ResourceClassParametersList_To_v1alpha2_ResourceClassParametersList is an autogenerated conversion function.
func Convert_resource_ResourceClassParametersList_To_v1alpha2_ResourceClassParametersList(in *resource.ResourceClassParametersList, out *v1alpha2.ResourceClassParametersList, s conversion.Scope) error {
	return autoConvert_resource_ResourceClassParametersList_To_v1alpha2_ResourceClassParametersList(in, out, s)
}

func autoConvert_v1alpha2_ResourceClassParametersReference_To_resource_ResourceClassParametersReference(in *v1alpha2.ResourceClassParametersReference, out *resource.ResourceClassParametersReference, s conversion.Scope) error {
	out.APIGroup = in.APIGroup
	out.Kind = in.Kind
	out.Name = in.Name
	out.Namespace = in.Namespace
	return nil
}

// Convert_v1alpha2_ResourceClassParametersReference_To_resource_ResourceClassParametersReference is an autogenerated conversion function.
func Convert_v1alpha2_ResourceClassParametersReference_To_resource_ResourceClassParametersReference(in *v1alpha2.ResourceClassParametersReference, out *resource.ResourceClassParametersReference, s conversion.Scope) error {
	return autoConvert_v1alpha2_ResourceClassParametersReference_To_resource_ResourceClassParametersReference(in, out, s)
}

func autoConvert_resource_ResourceClassParametersReference_To_v1alpha2_ResourceClassParametersReference(in *resource.ResourceClassParametersReference, out *v1alpha2.ResourceClassParametersReference, s conversion.Scope) error {
	out.APIGroup = in.APIGroup
	out.Kind = in.Kind
	out.Name = in.Name
	out.Namespace = in.Namespace
	return nil
}

// Convert_resource_ResourceClassParametersReference_To_v1alpha2_ResourceClassParametersReference is an autogenerated conversion function.
func Convert_resource_ResourceClassParametersReference_To_v1alpha2_ResourceClassParametersReference(in *resource.ResourceClassParametersReference, out *v1alpha2.ResourceClassParametersReference, s conversion.Scope) error {
	return autoConvert_resource_ResourceClassParametersReference_To_v1alpha2_ResourceClassParametersReference(in, out, s)
}

func autoConvert_v1alpha2_ResourceFilter_To_resource_ResourceFilter(in *v1alpha2.ResourceFilter, out *resource.ResourceFilter, s conversion.Scope) error {
	out.DriverName = in.DriverName
	if err := Convert_v1alpha2_ResourceFilterModel_To_resource_ResourceFilterModel(&in.ResourceFilterModel, &out.ResourceFilterModel, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1alpha2_ResourceFilter_To_resource_ResourceFilter is an autogenerated conversion function.
func Convert_v1alpha2_ResourceFilter_To_resource_ResourceFilter(in *v1alpha2.ResourceFilter, out *resource.ResourceFilter, s conversion.Scope) error {
	return autoConvert_v1alpha2_ResourceFilter_To_resource_ResourceFilter(in, out, s)
}

func autoConvert_resource_ResourceFilter_To_v1alpha2_ResourceFilter(in *resource.ResourceFilter, out *v1alpha2.ResourceFilter, s conversion.Scope) error {
	out.DriverName = in.DriverName
	if err := Convert_resource_ResourceFilterModel_To_v1alpha2_ResourceFilterModel(&in.ResourceFilterModel, &out.ResourceFilterModel, s); err != nil {
		return err
	}
	return nil
}

// Convert_resource_ResourceFilter_To_v1alpha2_ResourceFilter is an autogenerated conversion function.
func Convert_resource_ResourceFilter_To_v1alpha2_ResourceFilter(in *resource.ResourceFilter, out *v1alpha2.ResourceFilter, s conversion.Scope) error {
	return autoConvert_resource_ResourceFilter_To_v1alpha2_ResourceFilter(in, out, s)
}

func autoConvert_v1alpha2_ResourceFilterModel_To_resource_ResourceFilterModel(in *v1alpha2.ResourceFilterModel, out *resource.ResourceFilterModel, s conversion.Scope) error {
	out.NamedResources = (*resource.NamedResourcesFilter)(unsafe.Pointer(in.NamedResources))
	return nil
}

// Convert_v1alpha2_ResourceFilterModel_To_resource_ResourceFilterModel is an autogenerated conversion function.
func Convert_v1alpha2_ResourceFilterModel_To_resource_ResourceFilterModel(in *v1alpha2.ResourceFilterModel, out *resource.ResourceFilterModel, s conversion.Scope) error {
	return autoConvert_v1alpha2_ResourceFilterModel_To_resource_ResourceFilterModel(in, out, s)
}

func autoConvert_resource_ResourceFilterModel_To_v1alpha2_ResourceFilterModel(in *resource.ResourceFilterModel, out *v1alpha2.ResourceFilterModel, s conversion.Scope) error {
	out.NamedResources = (*v1alpha2.NamedResourcesFilter)(unsafe.Pointer(in.NamedResources))
	return nil
}

// Convert_resource_ResourceFilterModel_To_v1alpha2_ResourceFilterModel is an autogenerated conversion function.
func Convert_resource_ResourceFilterModel_To_v1alpha2_ResourceFilterModel(in *resource.ResourceFilterModel, out *v1alpha2.ResourceFilterModel, s conversion.Scope) error {
	return autoConvert_resource_ResourceFilterModel_To_v1alpha2_ResourceFilterModel(in, out, s)
}

func autoConvert_v1alpha2_ResourceHandle_To_resource_ResourceHandle(in *v1alpha2.ResourceHandle, out *resource.ResourceHandle, s conversion.Scope) error {
	out.DriverName = in.DriverName
	out.Data = in.Data
	if in.StructuredData != nil {
		in, out := &in.StructuredData, &out.StructuredData
		*out = new(resource.StructuredResourceHandle)
		if err := Convert_v1alpha2_StructuredResourceHandle_To_resource_StructuredResourceHandle(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.StructuredData = nil
	}
	return nil
}

// Convert_v1alpha2_ResourceHandle_To_resource_ResourceHandle is an autogenerated conversion function.
func Convert_v1alpha2_ResourceHandle_To_resource_ResourceHandle(in *v1alpha2.ResourceHandle, out *resource.ResourceHandle, s conversion.Scope) error {
	return autoConvert_v1alpha2_ResourceHandle_To_resource_ResourceHandle(in, out, s)
}

func autoConvert_resource_ResourceHandle_To_v1alpha2_ResourceHandle(in *resource.ResourceHandle, out *v1alpha2.ResourceHandle, s conversion.Scope) error {
	out.DriverName = in.DriverName
	out.Data = in.Data
	if in.StructuredData != nil {
		in, out := &in.StructuredData, &out.StructuredData
		*out = new(v1alpha2.StructuredResourceHandle)
		if err := Convert_resource_StructuredResourceHandle_To_v1alpha2_StructuredResourceHandle(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.StructuredData = nil
	}
	return nil
}

// Convert_resource_ResourceHandle_To_v1alpha2_ResourceHandle is an autogenerated conversion function.
func Convert_resource_ResourceHandle_To_v1alpha2_ResourceHandle(in *resource.ResourceHandle, out *v1alpha2.ResourceHandle, s conversion.Scope) error {
	return autoConvert_resource_ResourceHandle_To_v1alpha2_ResourceHandle(in, out, s)
}

func autoConvert_v1alpha2_ResourceModel_To_resource_ResourceModel(in *v1alpha2.ResourceModel, out *resource.ResourceModel, s conversion.Scope) error {
	out.NamedResources = (*resource.NamedResourcesResources)(unsafe.Pointer(in.NamedResources))
	return nil
}

// Convert_v1alpha2_ResourceModel_To_resource_ResourceModel is an autogenerated conversion function.
func Convert_v1alpha2_ResourceModel_To_resource_ResourceModel(in *v1alpha2.ResourceModel, out *resource.ResourceModel, s conversion.Scope) error {
	return autoConvert_v1alpha2_ResourceModel_To_resource_ResourceModel(in, out, s)
}

func autoConvert_resource_ResourceModel_To_v1alpha2_ResourceModel(in *resource.ResourceModel, out *v1alpha2.ResourceModel, s conversion.Scope) error {
	out.NamedResources = (*v1alpha2.NamedResourcesResources)(unsafe.Pointer(in.NamedResources))
	return nil
}

// Convert_resource_ResourceModel_To_v1alpha2_ResourceModel is an autogenerated conversion function.
func Convert_resource_ResourceModel_To_v1alpha2_ResourceModel(in *resource.ResourceModel, out *v1alpha2.ResourceModel, s conversion.Scope) error {
	return autoConvert_resource_ResourceModel_To_v1alpha2_ResourceModel(in, out, s)
}

func autoConvert_v1alpha2_ResourceRequest_To_resource_ResourceRequest(in *v1alpha2.ResourceRequest, out *resource.ResourceRequest, s conversion.Scope) error {
	if err := runtime.Convert_runtime_RawExtension_To_runtime_Object(&in.VendorParameters, &out.VendorParameters, s); err != nil {
		return err
	}
	if err := Convert_v1alpha2_ResourceRequestModel_To_resource_ResourceRequestModel(&in.ResourceRequestModel, &out.ResourceRequestModel, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1alpha2_ResourceRequest_To_resource_ResourceRequest is an autogenerated conversion function.
func Convert_v1alpha2_ResourceRequest_To_resource_ResourceRequest(in *v1alpha2.ResourceRequest, out *resource.ResourceRequest, s conversion.Scope) error {
	return autoConvert_v1alpha2_ResourceRequest_To_resource_ResourceRequest(in, out, s)
}

func autoConvert_resource_ResourceRequest_To_v1alpha2_ResourceRequest(in *resource.ResourceRequest, out *v1alpha2.ResourceRequest, s conversion.Scope) error {
	if err := runtime.Convert_runtime_Object_To_runtime_RawExtension(&in.VendorParameters, &out.VendorParameters, s); err != nil {
		return err
	}
	if err := Convert_resource_ResourceRequestModel_To_v1alpha2_ResourceRequestModel(&in.ResourceRequestModel, &out.ResourceRequestModel, s); err != nil {
		return err
	}
	return nil
}

// Convert_resource_ResourceRequest_To_v1alpha2_ResourceRequest is an autogenerated conversion function.
func Convert_resource_ResourceRequest_To_v1alpha2_ResourceRequest(in *resource.ResourceRequest, out *v1alpha2.ResourceRequest, s conversion.Scope) error {
	return autoConvert_resource_ResourceRequest_To_v1alpha2_ResourceRequest(in, out, s)
}

func autoConvert_v1alpha2_ResourceRequestModel_To_resource_ResourceRequestModel(in *v1alpha2.ResourceRequestModel, out *resource.ResourceRequestModel, s conversion.Scope) error {
	out.NamedResources = (*resource.NamedResourcesRequest)(unsafe.Pointer(in.NamedResources))
	return nil
}

// Convert_v1alpha2_ResourceRequestModel_To_resource_ResourceRequestModel is an autogenerated conversion function.
func Convert_v1alpha2_ResourceRequestModel_To_resource_ResourceRequestModel(in *v1alpha2.ResourceRequestModel, out *resource.ResourceRequestModel, s conversion.Scope) error {
	return autoConvert_v1alpha2_ResourceRequestModel_To_resource_ResourceRequestModel(in, out, s)
}

func autoConvert_resource_ResourceRequestModel_To_v1alpha2_ResourceRequestModel(in *resource.ResourceRequestModel, out *v1alpha2.ResourceRequestModel, s conversion.Scope) error {
	out.NamedResources = (*v1alpha2.NamedResourcesRequest)(unsafe.Pointer(in.NamedResources))
	return nil
}

// Convert_resource_ResourceRequestModel_To_v1alpha2_ResourceRequestModel is an autogenerated conversion function.
func Convert_resource_ResourceRequestModel_To_v1alpha2_ResourceRequestModel(in *resource.ResourceRequestModel, out *v1alpha2.ResourceRequestModel, s conversion.Scope) error {
	return autoConvert_resource_ResourceRequestModel_To_v1alpha2_ResourceRequestModel(in, out, s)
}

func autoConvert_v1alpha2_ResourceSlice_To_resource_ResourceSlice(in *v1alpha2.ResourceSlice, out *resource.ResourceSlice, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	out.NodeName = in.NodeName
	out.DriverName = in.DriverName
	if err := Convert_v1alpha2_ResourceModel_To_resource_ResourceModel(&in.ResourceModel, &out.ResourceModel, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1alpha2_ResourceSlice_To_resource_ResourceSlice is an autogenerated conversion function.
func Convert_v1alpha2_ResourceSlice_To_resource_ResourceSlice(in *v1alpha2.ResourceSlice, out *resource.ResourceSlice, s conversion.Scope) error {
	return autoConvert_v1alpha2_ResourceSlice_To_resource_ResourceSlice(in, out, s)
}

func autoConvert_resource_ResourceSlice_To_v1alpha2_ResourceSlice(in *resource.ResourceSlice, out *v1alpha2.ResourceSlice, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	out.NodeName = in.NodeName
	out.DriverName = in.DriverName
	if err := Convert_resource_ResourceModel_To_v1alpha2_ResourceModel(&in.ResourceModel, &out.ResourceModel, s); err != nil {
		return err
	}
	return nil
}

// Convert_resource_ResourceSlice_To_v1alpha2_ResourceSlice is an autogenerated conversion function.
func Convert_resource_ResourceSlice_To_v1alpha2_ResourceSlice(in *resource.ResourceSlice, out *v1alpha2.ResourceSlice, s conversion.Scope) error {
	return autoConvert_resource_ResourceSlice_To_v1alpha2_ResourceSlice(in, out, s)
}

func autoConvert_v1alpha2_ResourceSliceList_To_resource_ResourceSliceList(in *v1alpha2.ResourceSliceList, out *resource.ResourceSliceList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	out.Items = *(*[]resource.ResourceSlice)(unsafe.Pointer(&in.Items))
	return nil
}

// Convert_v1alpha2_ResourceSliceList_To_resource_ResourceSliceList is an autogenerated conversion function.
func Convert_v1alpha2_ResourceSliceList_To_resource_ResourceSliceList(in *v1alpha2.ResourceSliceList, out *resource.ResourceSliceList, s conversion.Scope) error {
	return autoConvert_v1alpha2_ResourceSliceList_To_resource_ResourceSliceList(in, out, s)
}

func autoConvert_resource_ResourceSliceList_To_v1alpha2_ResourceSliceList(in *resource.ResourceSliceList, out *v1alpha2.ResourceSliceList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	out.Items = *(*[]v1alpha2.ResourceSlice)(unsafe.Pointer(&in.Items))
	return nil
}

// Convert_resource_ResourceSliceList_To_v1alpha2_ResourceSliceList is an autogenerated conversion function.
func Convert_resource_ResourceSliceList_To_v1alpha2_ResourceSliceList(in *resource.ResourceSliceList, out *v1alpha2.ResourceSliceList, s conversion.Scope) error {
	return autoConvert_resource_ResourceSliceList_To_v1alpha2_ResourceSliceList(in, out, s)
}

func autoConvert_v1alpha2_StructuredResourceHandle_To_resource_StructuredResourceHandle(in *v1alpha2.StructuredResourceHandle, out *resource.StructuredResourceHandle, s conversion.Scope) error {
	if err := runtime.Convert_runtime_RawExtension_To_runtime_Object(&in.VendorClassParameters, &out.VendorClassParameters, s); err != nil {
		return err
	}
	if err := runtime.Convert_runtime_RawExtension_To_runtime_Object(&in.VendorClaimParameters, &out.VendorClaimParameters, s); err != nil {
		return err
	}
	out.NodeName = in.NodeName
	if in.Results != nil {
		in, out := &in.Results, &out.Results
		*out = make([]resource.DriverAllocationResult, len(*in))
		for i := range *in {
			if err := Convert_v1alpha2_DriverAllocationResult_To_resource_DriverAllocationResult(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Results = nil
	}
	return nil
}

// Convert_v1alpha2_StructuredResourceHandle_To_resource_StructuredResourceHandle is an autogenerated conversion function.
func Convert_v1alpha2_StructuredResourceHandle_To_resource_StructuredResourceHandle(in *v1alpha2.StructuredResourceHandle, out *resource.StructuredResourceHandle, s conversion.Scope) error {
	return autoConvert_v1alpha2_StructuredResourceHandle_To_resource_StructuredResourceHandle(in, out, s)
}

func autoConvert_resource_StructuredResourceHandle_To_v1alpha2_StructuredResourceHandle(in *resource.StructuredResourceHandle, out *v1alpha2.StructuredResourceHandle, s conversion.Scope) error {
	if err := runtime.Convert_runtime_Object_To_runtime_RawExtension(&in.VendorClassParameters, &out.VendorClassParameters, s); err != nil {
		return err
	}
	if err := runtime.Convert_runtime_Object_To_runtime_RawExtension(&in.VendorClaimParameters, &out.VendorClaimParameters, s); err != nil {
		return err
	}
	out.NodeName = in.NodeName
	if in.Results != nil {
		in, out := &in.Results, &out.Results
		*out = make([]v1alpha2.DriverAllocationResult, len(*in))
		for i := range *in {
			if err := Convert_resource_DriverAllocationResult_To_v1alpha2_DriverAllocationResult(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Results = nil
	}
	return nil
}

// Convert_resource_StructuredResourceHandle_To_v1alpha2_StructuredResourceHandle is an autogenerated conversion function.
func Convert_resource_StructuredResourceHandle_To_v1alpha2_StructuredResourceHandle(in *resource.StructuredResourceHandle, out *v1alpha2.StructuredResourceHandle, s conversion.Scope) error {
	return autoConvert_resource_StructuredResourceHandle_To_v1alpha2_StructuredResourceHandle(in, out, s)
}

func autoConvert_v1alpha2_VendorParameters_To_resource_VendorParameters(in *v1alpha2.VendorParameters, out *resource.VendorParameters, s conversion.Scope) error {
	out.DriverName = in.DriverName
	if err := runtime.Convert_runtime_RawExtension_To_runtime_Object(&in.Parameters, &out.Parameters, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1alpha2_VendorParameters_To_resource_VendorParameters is an autogenerated conversion function.
func Convert_v1alpha2_VendorParameters_To_resource_VendorParameters(in *v1alpha2.VendorParameters, out *resource.VendorParameters, s conversion.Scope) error {
	return autoConvert_v1alpha2_VendorParameters_To_resource_VendorParameters(in, out, s)
}

func autoConvert_resource_VendorParameters_To_v1alpha2_VendorParameters(in *resource.VendorParameters, out *v1alpha2.VendorParameters, s conversion.Scope) error {
	out.DriverName = in.DriverName
	if err := runtime.Convert_runtime_Object_To_runtime_RawExtension(&in.Parameters, &out.Parameters, s); err != nil {
		return err
	}
	return nil
}

// Convert_resource_VendorParameters_To_v1alpha2_VendorParameters is an autogenerated conversion function.
func Convert_resource_VendorParameters_To_v1alpha2_VendorParameters(in *resource.VendorParameters, out *v1alpha2.VendorParameters, s conversion.Scope) error {
	return autoConvert_resource_VendorParameters_To_v1alpha2_VendorParameters(in, out, s)
}
