// Code generated by protoc-gen-go. DO NOT EDIT.
// source: api/api.proto

/*
Package api is a generated protocol buffer package.

It is generated from these files:
	api/api.proto

It has these top-level messages:
	StorageResource
	StoragePool
	VolumeLocator
	Source
	Group
	VolumeSpec
	ReplicaSet
	RuntimeStateMap
	Volume
	Stats
	Alert
	Alerts
	VolumeCreateRequest
	VolumeResponse
	VolumeCreateResponse
	VolumeStateAction
	VolumeSetRequest
	VolumeSetResponse
	SnapCreateRequest
	SnapCreateResponse
	VolumeInfo
	GraphDriverChanges
	ClusterResponse
	ActiveRequest
	ActiveRequests
*/
package api

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import google_protobuf "github.com/golang/protobuf/ptypes/timestamp"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

type Status int32

const (
	Status_STATUS_NONE                  Status = 0
	Status_STATUS_INIT                  Status = 1
	Status_STATUS_OK                    Status = 2
	Status_STATUS_OFFLINE               Status = 3
	Status_STATUS_ERROR                 Status = 4
	Status_STATUS_NOT_IN_QUORUM         Status = 5
	Status_STATUS_DECOMMISSION          Status = 6
	Status_STATUS_MAINTENANCE           Status = 7
	Status_STATUS_STORAGE_DOWN          Status = 8
	Status_STATUS_STORAGE_DEGRADED      Status = 9
	Status_STATUS_NEEDS_REBOOT          Status = 10
	Status_STATUS_STORAGE_REBALANCE     Status = 11
	Status_STATUS_STORAGE_DRIVE_REPLACE Status = 12
	// Add statuses before MAX and update the number for MAX
	Status_STATUS_MAX Status = 13
)

var Status_name = map[int32]string{
	0:  "STATUS_NONE",
	1:  "STATUS_INIT",
	2:  "STATUS_OK",
	3:  "STATUS_OFFLINE",
	4:  "STATUS_ERROR",
	5:  "STATUS_NOT_IN_QUORUM",
	6:  "STATUS_DECOMMISSION",
	7:  "STATUS_MAINTENANCE",
	8:  "STATUS_STORAGE_DOWN",
	9:  "STATUS_STORAGE_DEGRADED",
	10: "STATUS_NEEDS_REBOOT",
	11: "STATUS_STORAGE_REBALANCE",
	12: "STATUS_STORAGE_DRIVE_REPLACE",
	13: "STATUS_MAX",
}
var Status_value = map[string]int32{
	"STATUS_NONE":                  0,
	"STATUS_INIT":                  1,
	"STATUS_OK":                    2,
	"STATUS_OFFLINE":               3,
	"STATUS_ERROR":                 4,
	"STATUS_NOT_IN_QUORUM":         5,
	"STATUS_DECOMMISSION":          6,
	"STATUS_MAINTENANCE":           7,
	"STATUS_STORAGE_DOWN":          8,
	"STATUS_STORAGE_DEGRADED":      9,
	"STATUS_NEEDS_REBOOT":          10,
	"STATUS_STORAGE_REBALANCE":     11,
	"STATUS_STORAGE_DRIVE_REPLACE": 12,
	"STATUS_MAX":                   13,
}

func (x Status) String() string {
	return proto.EnumName(Status_name, int32(x))
}
func (Status) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

type DriverType int32

const (
	DriverType_DRIVER_TYPE_NONE      DriverType = 0
	DriverType_DRIVER_TYPE_FILE      DriverType = 1
	DriverType_DRIVER_TYPE_BLOCK     DriverType = 2
	DriverType_DRIVER_TYPE_OBJECT    DriverType = 3
	DriverType_DRIVER_TYPE_CLUSTERED DriverType = 4
	DriverType_DRIVER_TYPE_GRAPH     DriverType = 5
)

var DriverType_name = map[int32]string{
	0: "DRIVER_TYPE_NONE",
	1: "DRIVER_TYPE_FILE",
	2: "DRIVER_TYPE_BLOCK",
	3: "DRIVER_TYPE_OBJECT",
	4: "DRIVER_TYPE_CLUSTERED",
	5: "DRIVER_TYPE_GRAPH",
}
var DriverType_value = map[string]int32{
	"DRIVER_TYPE_NONE":      0,
	"DRIVER_TYPE_FILE":      1,
	"DRIVER_TYPE_BLOCK":     2,
	"DRIVER_TYPE_OBJECT":    3,
	"DRIVER_TYPE_CLUSTERED": 4,
	"DRIVER_TYPE_GRAPH":     5,
}

func (x DriverType) String() string {
	return proto.EnumName(DriverType_name, int32(x))
}
func (DriverType) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{1} }

type FSType int32

const (
	FSType_FS_TYPE_NONE  FSType = 0
	FSType_FS_TYPE_BTRFS FSType = 1
	FSType_FS_TYPE_EXT4  FSType = 2
	FSType_FS_TYPE_FUSE  FSType = 3
	FSType_FS_TYPE_NFS   FSType = 4
	FSType_FS_TYPE_VFS   FSType = 5
	FSType_FS_TYPE_XFS   FSType = 6
	FSType_FS_TYPE_ZFS   FSType = 7
)

var FSType_name = map[int32]string{
	0: "FS_TYPE_NONE",
	1: "FS_TYPE_BTRFS",
	2: "FS_TYPE_EXT4",
	3: "FS_TYPE_FUSE",
	4: "FS_TYPE_NFS",
	5: "FS_TYPE_VFS",
	6: "FS_TYPE_XFS",
	7: "FS_TYPE_ZFS",
}
var FSType_value = map[string]int32{
	"FS_TYPE_NONE":  0,
	"FS_TYPE_BTRFS": 1,
	"FS_TYPE_EXT4":  2,
	"FS_TYPE_FUSE":  3,
	"FS_TYPE_NFS":   4,
	"FS_TYPE_VFS":   5,
	"FS_TYPE_XFS":   6,
	"FS_TYPE_ZFS":   7,
}

func (x FSType) String() string {
	return proto.EnumName(FSType_name, int32(x))
}
func (FSType) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{2} }

type GraphDriverChangeType int32

const (
	GraphDriverChangeType_GRAPH_DRIVER_CHANGE_TYPE_NONE     GraphDriverChangeType = 0
	GraphDriverChangeType_GRAPH_DRIVER_CHANGE_TYPE_MODIFIED GraphDriverChangeType = 1
	GraphDriverChangeType_GRAPH_DRIVER_CHANGE_TYPE_ADDED    GraphDriverChangeType = 2
	GraphDriverChangeType_GRAPH_DRIVER_CHANGE_TYPE_DELETED  GraphDriverChangeType = 3
)

var GraphDriverChangeType_name = map[int32]string{
	0: "GRAPH_DRIVER_CHANGE_TYPE_NONE",
	1: "GRAPH_DRIVER_CHANGE_TYPE_MODIFIED",
	2: "GRAPH_DRIVER_CHANGE_TYPE_ADDED",
	3: "GRAPH_DRIVER_CHANGE_TYPE_DELETED",
}
var GraphDriverChangeType_value = map[string]int32{
	"GRAPH_DRIVER_CHANGE_TYPE_NONE":     0,
	"GRAPH_DRIVER_CHANGE_TYPE_MODIFIED": 1,
	"GRAPH_DRIVER_CHANGE_TYPE_ADDED":    2,
	"GRAPH_DRIVER_CHANGE_TYPE_DELETED":  3,
}

func (x GraphDriverChangeType) String() string {
	return proto.EnumName(GraphDriverChangeType_name, int32(x))
}
func (GraphDriverChangeType) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{3} }

type SeverityType int32

const (
	SeverityType_SEVERITY_TYPE_NONE    SeverityType = 0
	SeverityType_SEVERITY_TYPE_ALARM   SeverityType = 1
	SeverityType_SEVERITY_TYPE_WARNING SeverityType = 2
	SeverityType_SEVERITY_TYPE_NOTIFY  SeverityType = 3
)

var SeverityType_name = map[int32]string{
	0: "SEVERITY_TYPE_NONE",
	1: "SEVERITY_TYPE_ALARM",
	2: "SEVERITY_TYPE_WARNING",
	3: "SEVERITY_TYPE_NOTIFY",
}
var SeverityType_value = map[string]int32{
	"SEVERITY_TYPE_NONE":    0,
	"SEVERITY_TYPE_ALARM":   1,
	"SEVERITY_TYPE_WARNING": 2,
	"SEVERITY_TYPE_NOTIFY":  3,
}

func (x SeverityType) String() string {
	return proto.EnumName(SeverityType_name, int32(x))
}
func (SeverityType) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{4} }

type ResourceType int32

const (
	ResourceType_RESOURCE_TYPE_NONE    ResourceType = 0
	ResourceType_RESOURCE_TYPE_VOLUME  ResourceType = 1
	ResourceType_RESOURCE_TYPE_NODE    ResourceType = 2
	ResourceType_RESOURCE_TYPE_CLUSTER ResourceType = 3
	ResourceType_RESOURCE_TYPE_DRIVE   ResourceType = 4
)

var ResourceType_name = map[int32]string{
	0: "RESOURCE_TYPE_NONE",
	1: "RESOURCE_TYPE_VOLUME",
	2: "RESOURCE_TYPE_NODE",
	3: "RESOURCE_TYPE_CLUSTER",
	4: "RESOURCE_TYPE_DRIVE",
}
var ResourceType_value = map[string]int32{
	"RESOURCE_TYPE_NONE":    0,
	"RESOURCE_TYPE_VOLUME":  1,
	"RESOURCE_TYPE_NODE":    2,
	"RESOURCE_TYPE_CLUSTER": 3,
	"RESOURCE_TYPE_DRIVE":   4,
}

func (x ResourceType) String() string {
	return proto.EnumName(ResourceType_name, int32(x))
}
func (ResourceType) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{5} }

type AlertActionType int32

const (
	AlertActionType_ALERT_ACTION_TYPE_NONE   AlertActionType = 0
	AlertActionType_ALERT_ACTION_TYPE_DELETE AlertActionType = 1
	AlertActionType_ALERT_ACTION_TYPE_CREATE AlertActionType = 2
	AlertActionType_ALERT_ACTION_TYPE_UPDATE AlertActionType = 3
)

var AlertActionType_name = map[int32]string{
	0: "ALERT_ACTION_TYPE_NONE",
	1: "ALERT_ACTION_TYPE_DELETE",
	2: "ALERT_ACTION_TYPE_CREATE",
	3: "ALERT_ACTION_TYPE_UPDATE",
}
var AlertActionType_value = map[string]int32{
	"ALERT_ACTION_TYPE_NONE":   0,
	"ALERT_ACTION_TYPE_DELETE": 1,
	"ALERT_ACTION_TYPE_CREATE": 2,
	"ALERT_ACTION_TYPE_UPDATE": 3,
}

func (x AlertActionType) String() string {
	return proto.EnumName(AlertActionType_name, int32(x))
}
func (AlertActionType) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{6} }

type VolumeActionParam int32

const (
	VolumeActionParam_VOLUME_ACTION_PARAM_NONE VolumeActionParam = 0
	// Maps to the boolean value false
	VolumeActionParam_VOLUME_ACTION_PARAM_OFF VolumeActionParam = 1
	// Maps to the boolean value true.
	VolumeActionParam_VOLUME_ACTION_PARAM_ON VolumeActionParam = 2
)

var VolumeActionParam_name = map[int32]string{
	0: "VOLUME_ACTION_PARAM_NONE",
	1: "VOLUME_ACTION_PARAM_OFF",
	2: "VOLUME_ACTION_PARAM_ON",
}
var VolumeActionParam_value = map[string]int32{
	"VOLUME_ACTION_PARAM_NONE": 0,
	"VOLUME_ACTION_PARAM_OFF":  1,
	"VOLUME_ACTION_PARAM_ON":   2,
}

func (x VolumeActionParam) String() string {
	return proto.EnumName(VolumeActionParam_name, int32(x))
}
func (VolumeActionParam) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{7} }

type CosType int32

const (
	CosType_NONE   CosType = 0
	CosType_LOW    CosType = 1
	CosType_MEDIUM CosType = 2
	CosType_HIGH   CosType = 3
)

var CosType_name = map[int32]string{
	0: "NONE",
	1: "LOW",
	2: "MEDIUM",
	3: "HIGH",
}
var CosType_value = map[string]int32{
	"NONE":   0,
	"LOW":    1,
	"MEDIUM": 2,
	"HIGH":   3,
}

func (x CosType) String() string {
	return proto.EnumName(CosType_name, int32(x))
}
func (CosType) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{8} }

type IoProfile int32

const (
	IoProfile_IO_PROFILE_SEQUENTIAL IoProfile = 0
	IoProfile_IO_PROFILE_RANDOM     IoProfile = 1
	IoProfile_IO_PROFILE_DB         IoProfile = 2
	IoProfile_IO_PROFILE_DB_REMOTE  IoProfile = 3
)

var IoProfile_name = map[int32]string{
	0: "IO_PROFILE_SEQUENTIAL",
	1: "IO_PROFILE_RANDOM",
	2: "IO_PROFILE_DB",
	3: "IO_PROFILE_DB_REMOTE",
}
var IoProfile_value = map[string]int32{
	"IO_PROFILE_SEQUENTIAL": 0,
	"IO_PROFILE_RANDOM":     1,
	"IO_PROFILE_DB":         2,
	"IO_PROFILE_DB_REMOTE":  3,
}

func (x IoProfile) String() string {
	return proto.EnumName(IoProfile_name, int32(x))
}
func (IoProfile) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{9} }

// VolumeState represents the state of a volume.
type VolumeState int32

const (
	VolumeState_VOLUME_STATE_NONE VolumeState = 0
	// Volume is transitioning to new state
	VolumeState_VOLUME_STATE_PENDING VolumeState = 1
	// Volume is ready to be assigned to a container
	VolumeState_VOLUME_STATE_AVAILABLE VolumeState = 2
	// Volume is attached to container
	VolumeState_VOLUME_STATE_ATTACHED VolumeState = 3
	// Volume is detached but associated with a container
	VolumeState_VOLUME_STATE_DETACHED VolumeState = 4
	// Volume detach is in progress
	VolumeState_VOLUME_STATE_DETATCHING VolumeState = 5
	// Volume is in error state
	VolumeState_VOLUME_STATE_ERROR VolumeState = 6
	// Volume is deleted, it will remain in this state
	// while resources are asynchronously reclaimed
	VolumeState_VOLUME_STATE_DELETED VolumeState = 7
	// Volume is trying to be detached
	VolumeState_VOLUME_STATE_TRY_DETACHING VolumeState = 8
	// Volume is undergoing restore
	VolumeState_VOLUME_STATE_RESTORE VolumeState = 9
)

var VolumeState_name = map[int32]string{
	0: "VOLUME_STATE_NONE",
	1: "VOLUME_STATE_PENDING",
	2: "VOLUME_STATE_AVAILABLE",
	3: "VOLUME_STATE_ATTACHED",
	4: "VOLUME_STATE_DETACHED",
	5: "VOLUME_STATE_DETATCHING",
	6: "VOLUME_STATE_ERROR",
	7: "VOLUME_STATE_DELETED",
	8: "VOLUME_STATE_TRY_DETACHING",
	9: "VOLUME_STATE_RESTORE",
}
var VolumeState_value = map[string]int32{
	"VOLUME_STATE_NONE":          0,
	"VOLUME_STATE_PENDING":       1,
	"VOLUME_STATE_AVAILABLE":     2,
	"VOLUME_STATE_ATTACHED":      3,
	"VOLUME_STATE_DETACHED":      4,
	"VOLUME_STATE_DETATCHING":    5,
	"VOLUME_STATE_ERROR":         6,
	"VOLUME_STATE_DELETED":       7,
	"VOLUME_STATE_TRY_DETACHING": 8,
	"VOLUME_STATE_RESTORE":       9,
}

func (x VolumeState) String() string {
	return proto.EnumName(VolumeState_name, int32(x))
}
func (VolumeState) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{10} }

// VolumeStatus represents a health status for a volume.
type VolumeStatus int32

const (
	VolumeStatus_VOLUME_STATUS_NONE VolumeStatus = 0
	// Volume is not present
	VolumeStatus_VOLUME_STATUS_NOT_PRESENT VolumeStatus = 1
	// Volume is healthy
	VolumeStatus_VOLUME_STATUS_UP VolumeStatus = 2
	// Volume is in fail mode
	VolumeStatus_VOLUME_STATUS_DOWN VolumeStatus = 3
	// Volume is up but with degraded performance
	// In a RAID group, this may indicate a problem with one or more drives
	VolumeStatus_VOLUME_STATUS_DEGRADED VolumeStatus = 4
)

var VolumeStatus_name = map[int32]string{
	0: "VOLUME_STATUS_NONE",
	1: "VOLUME_STATUS_NOT_PRESENT",
	2: "VOLUME_STATUS_UP",
	3: "VOLUME_STATUS_DOWN",
	4: "VOLUME_STATUS_DEGRADED",
}
var VolumeStatus_value = map[string]int32{
	"VOLUME_STATUS_NONE":        0,
	"VOLUME_STATUS_NOT_PRESENT": 1,
	"VOLUME_STATUS_UP":          2,
	"VOLUME_STATUS_DOWN":        3,
	"VOLUME_STATUS_DEGRADED":    4,
}

func (x VolumeStatus) String() string {
	return proto.EnumName(VolumeStatus_name, int32(x))
}
func (VolumeStatus) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{11} }

type StorageMedium int32

const (
	// Magnetic spinning disk.
	StorageMedium_STORAGE_MEDIUM_MAGNETIC StorageMedium = 0
	// SSD disk
	StorageMedium_STORAGE_MEDIUM_SSD StorageMedium = 1
	// NVME disk
	StorageMedium_STORAGE_MEDIUM_NVME StorageMedium = 2
)

var StorageMedium_name = map[int32]string{
	0: "STORAGE_MEDIUM_MAGNETIC",
	1: "STORAGE_MEDIUM_SSD",
	2: "STORAGE_MEDIUM_NVME",
}
var StorageMedium_value = map[string]int32{
	"STORAGE_MEDIUM_MAGNETIC": 0,
	"STORAGE_MEDIUM_SSD":      1,
	"STORAGE_MEDIUM_NVME":     2,
}

func (x StorageMedium) String() string {
	return proto.EnumName(StorageMedium_name, int32(x))
}
func (StorageMedium) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{12} }

type ClusterNotify int32

const (
	// Node is down
	ClusterNotify_CLUSTER_NOTIFY_DOWN ClusterNotify = 0
)

var ClusterNotify_name = map[int32]string{
	0: "CLUSTER_NOTIFY_DOWN",
}
var ClusterNotify_value = map[string]int32{
	"CLUSTER_NOTIFY_DOWN": 0,
}

func (x ClusterNotify) String() string {
	return proto.EnumName(ClusterNotify_name, int32(x))
}
func (ClusterNotify) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{13} }

type AttachState int32

const (
	// Attached and available externally
	AttachState_ATTACH_STATE_EXTERNAL AttachState = 0
	// Attached but only available internally
	AttachState_ATTACH_STATE_INTERNAL AttachState = 1
	// Switching from External to Internal
	AttachState_ATTACH_STATE_INTERNAL_SWITCH AttachState = 2
)

var AttachState_name = map[int32]string{
	0: "ATTACH_STATE_EXTERNAL",
	1: "ATTACH_STATE_INTERNAL",
	2: "ATTACH_STATE_INTERNAL_SWITCH",
}
var AttachState_value = map[string]int32{
	"ATTACH_STATE_EXTERNAL":        0,
	"ATTACH_STATE_INTERNAL":        1,
	"ATTACH_STATE_INTERNAL_SWITCH": 2,
}

func (x AttachState) String() string {
	return proto.EnumName(AttachState_name, int32(x))
}
func (AttachState) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{14} }

// StorageResource groups properties of a storage device.
type StorageResource struct {
	// Id is the LUN identifier.
	Id string `protobuf:"bytes,1,opt,name=id" json:"id,omitempty"`
	// Path device path for this storage resource.
	Path string `protobuf:"bytes,2,opt,name=path" json:"path,omitempty"`
	// Storage medium.
	Medium StorageMedium `protobuf:"varint,3,opt,name=medium,enum=openstorage.api.StorageMedium" json:"medium,omitempty"`
	// True if this device is online.
	Online bool `protobuf:"varint,4,opt,name=online" json:"online,omitempty"`
	// IOPS
	Iops uint64 `protobuf:"varint,5,opt,name=iops" json:"iops,omitempty"`
	// SeqWrite
	SeqWrite float64 `protobuf:"fixed64,6,opt,name=seq_write,json=seqWrite" json:"seq_write,omitempty"`
	// SeqRead
	SeqRead float64 `protobuf:"fixed64,7,opt,name=seq_read,json=seqRead" json:"seq_read,omitempty"`
	// RandRW
	RandRW float64 `protobuf:"fixed64,8,opt,name=randRW" json:"randRW,omitempty"`
	// Total size in bytes.
	Size uint64 `protobuf:"varint,9,opt,name=size" json:"size,omitempty"`
	// Physical Bytes used.
	Used uint64 `protobuf:"varint,10,opt,name=used" json:"used,omitempty"`
	// True if this device is rotational.
	RotationSpeed string `protobuf:"bytes,11,opt,name=rotation_speed,json=rotationSpeed" json:"rotation_speed,omitempty"`
	// Timestamp of last time this device was scanned.
	LastScan *google_protobuf.Timestamp `protobuf:"bytes,12,opt,name=last_scan,json=lastScan" json:"last_scan,omitempty"`
}

func (m *StorageResource) Reset()                    { *m = StorageResource{} }
func (m *StorageResource) String() string            { return proto.CompactTextString(m) }
func (*StorageResource) ProtoMessage()               {}
func (*StorageResource) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

func (m *StorageResource) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *StorageResource) GetPath() string {
	if m != nil {
		return m.Path
	}
	return ""
}

func (m *StorageResource) GetMedium() StorageMedium {
	if m != nil {
		return m.Medium
	}
	return StorageMedium_STORAGE_MEDIUM_MAGNETIC
}

func (m *StorageResource) GetOnline() bool {
	if m != nil {
		return m.Online
	}
	return false
}

func (m *StorageResource) GetIops() uint64 {
	if m != nil {
		return m.Iops
	}
	return 0
}

func (m *StorageResource) GetSeqWrite() float64 {
	if m != nil {
		return m.SeqWrite
	}
	return 0
}

func (m *StorageResource) GetSeqRead() float64 {
	if m != nil {
		return m.SeqRead
	}
	return 0
}

func (m *StorageResource) GetRandRW() float64 {
	if m != nil {
		return m.RandRW
	}
	return 0
}

func (m *StorageResource) GetSize() uint64 {
	if m != nil {
		return m.Size
	}
	return 0
}

func (m *StorageResource) GetUsed() uint64 {
	if m != nil {
		return m.Used
	}
	return 0
}

func (m *StorageResource) GetRotationSpeed() string {
	if m != nil {
		return m.RotationSpeed
	}
	return ""
}

func (m *StorageResource) GetLastScan() *google_protobuf.Timestamp {
	if m != nil {
		return m.LastScan
	}
	return nil
}

// StoragePool groups different storage devices based on their CosType
type StoragePool struct {
	// ID pool ID
	ID int32 `protobuf:"varint,1,opt,name=ID,json=iD" json:"ID,omitempty"`
	// Cos reflects the capabilities of this drive pool
	Cos CosType `protobuf:"varint,2,opt,name=Cos,json=cos,enum=openstorage.api.CosType" json:"Cos,omitempty"`
	// Medium underlying storage type
	Medium StorageMedium `protobuf:"varint,3,opt,name=Medium,json=medium,enum=openstorage.api.StorageMedium" json:"Medium,omitempty"`
	// RaidLevel storage raid level
	RaidLevel string `protobuf:"bytes,4,opt,name=RaidLevel,json=raidLevel" json:"RaidLevel,omitempty"`
	// TotalSize of the pool
	TotalSize uint64 `protobuf:"varint,7,opt,name=TotalSize,json=totalSize" json:"TotalSize,omitempty"`
	// Used size of the pool
	Used uint64 `protobuf:"varint,8,opt,name=Used,json=used" json:"Used,omitempty"`
	// Labels is a list of user defined name-value pairs
	Labels map[string]string `protobuf:"bytes,9,rep,name=labels" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
}

func (m *StoragePool) Reset()                    { *m = StoragePool{} }
func (m *StoragePool) String() string            { return proto.CompactTextString(m) }
func (*StoragePool) ProtoMessage()               {}
func (*StoragePool) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{1} }

func (m *StoragePool) GetID() int32 {
	if m != nil {
		return m.ID
	}
	return 0
}

func (m *StoragePool) GetCos() CosType {
	if m != nil {
		return m.Cos
	}
	return CosType_NONE
}

func (m *StoragePool) GetMedium() StorageMedium {
	if m != nil {
		return m.Medium
	}
	return StorageMedium_STORAGE_MEDIUM_MAGNETIC
}

func (m *StoragePool) GetRaidLevel() string {
	if m != nil {
		return m.RaidLevel
	}
	return ""
}

func (m *StoragePool) GetTotalSize() uint64 {
	if m != nil {
		return m.TotalSize
	}
	return 0
}

func (m *StoragePool) GetUsed() uint64 {
	if m != nil {
		return m.Used
	}
	return 0
}

func (m *StoragePool) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

// VolumeLocator is a structure that is attached to a volume
// and is used to carry opaque metadata.
type VolumeLocator struct {
	// User friendly identifier
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// A set of name-value pairs that acts as search filters
	VolumeLabels map[string]string `protobuf:"bytes,2,rep,name=volume_labels,json=volumeLabels" json:"volume_labels,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
}

func (m *VolumeLocator) Reset()                    { *m = VolumeLocator{} }
func (m *VolumeLocator) String() string            { return proto.CompactTextString(m) }
func (*VolumeLocator) ProtoMessage()               {}
func (*VolumeLocator) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{2} }

func (m *VolumeLocator) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *VolumeLocator) GetVolumeLabels() map[string]string {
	if m != nil {
		return m.VolumeLabels
	}
	return nil
}

type Source struct {
	// A volume id, if specified will create a clone of the parent.
	Parent string `protobuf:"bytes,1,opt,name=parent" json:"parent,omitempty"`
	// Seed will seed the volume from the specified URI
	// Any additional config for the source comes from the labels in the spec
	Seed string `protobuf:"bytes,2,opt,name=seed" json:"seed,omitempty"`
}

func (m *Source) Reset()                    { *m = Source{} }
func (m *Source) String() string            { return proto.CompactTextString(m) }
func (*Source) ProtoMessage()               {}
func (*Source) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{3} }

func (m *Source) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *Source) GetSeed() string {
	if m != nil {
		return m.Seed
	}
	return ""
}

type Group struct {
	// Id common identifier across volumes that have the same group.
	Id string `protobuf:"bytes,1,opt,name=id" json:"id,omitempty"`
}

func (m *Group) Reset()                    { *m = Group{} }
func (m *Group) String() string            { return proto.CompactTextString(m) }
func (*Group) ProtoMessage()               {}
func (*Group) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{4} }

func (m *Group) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

// VolumeSpec has the properties needed to create a volume.
type VolumeSpec struct {
	// Ephemeral storage
	Ephemeral bool `protobuf:"varint,1,opt,name=ephemeral" json:"ephemeral,omitempty"`
	// Size specifies the thin provisioned volume size.
	Size uint64 `protobuf:"varint,2,opt,name=size" json:"size,omitempty"`
	// Format specifies the filesystem for this volume.
	Format FSType `protobuf:"varint,3,opt,name=format,enum=openstorage.api.FSType" json:"format,omitempty"`
	// BlockSize for the filesystem.
	BlockSize int64 `protobuf:"varint,4,opt,name=block_size,json=blockSize" json:"block_size,omitempty"`
	// HaLevel specifies the number of copies of data.
	HaLevel int64 `protobuf:"varint,5,opt,name=ha_level,json=haLevel" json:"ha_level,omitempty"`
	// Cos specifies the relative class of service.
	Cos CosType `protobuf:"varint,6,opt,name=cos,enum=openstorage.api.CosType" json:"cos,omitempty"`
	// IoProfile provides a hint about application using this volume.
	IoProfile IoProfile `protobuf:"varint,7,opt,name=io_profile,json=ioProfile,enum=openstorage.api.IoProfile" json:"io_profile,omitempty"`
	// Dedupe specifies if the volume data is to be de-duplicated.
	Dedupe bool `protobuf:"varint,8,opt,name=dedupe" json:"dedupe,omitempty"`
	// SnapshotInterval in minutes, set to 0 to disable snapshots
	SnapshotInterval uint32 `protobuf:"varint,9,opt,name=snapshot_interval,json=snapshotInterval" json:"snapshot_interval,omitempty"`
	// VolumeLabels configuration labels
	VolumeLabels map[string]string `protobuf:"bytes,10,rep,name=volume_labels,json=volumeLabels" json:"volume_labels,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// Shared is true if this volume can be remotely accessed.
	Shared bool `protobuf:"varint,11,opt,name=shared" json:"shared,omitempty"`
	// ReplicaSet is the desired set of nodes for the volume data.
	ReplicaSet *ReplicaSet `protobuf:"bytes,12,opt,name=replica_set,json=replicaSet" json:"replica_set,omitempty"`
	// Aggregatiokn level Specifies the number of parts the volume can be aggregated from.
	AggregationLevel uint32 `protobuf:"varint,13,opt,name=aggregation_level,json=aggregationLevel" json:"aggregation_level,omitempty"`
	// Encrypted is true if this volume will be cryptographically secured.
	Encrypted bool `protobuf:"varint,14,opt,name=encrypted" json:"encrypted,omitempty"`
	// Passphrase for an encrypted volume
	Passphrase string `protobuf:"bytes,15,opt,name=passphrase" json:"passphrase,omitempty"`
	// SnapshotSchedule a well known string that specifies when snapshots should be taken.
	SnapshotSchedule string `protobuf:"bytes,16,opt,name=snapshot_schedule,json=snapshotSchedule" json:"snapshot_schedule,omitempty"`
	// Scale allows autocreation of volumes.
	Scale uint32 `protobuf:"varint,17,opt,name=scale" json:"scale,omitempty"`
	// Sticky volumes cannot be deleted until the flag is removed.
	Sticky bool `protobuf:"varint,18,opt,name=sticky" json:"sticky,omitempty"`
	// Group identifies a consistency group
	Group *Group `protobuf:"bytes,21,opt,name=group" json:"group,omitempty"`
	// GroupEnforced is true if consistency group creation is enforced.
	GroupEnforced bool `protobuf:"varint,22,opt,name=group_enforced,json=groupEnforced" json:"group_enforced,omitempty"`
	// Compressed is true if this volume is to be compressed.
	Compressed bool `protobuf:"varint,23,opt,name=compressed" json:"compressed,omitempty"`
}

func (m *VolumeSpec) Reset()                    { *m = VolumeSpec{} }
func (m *VolumeSpec) String() string            { return proto.CompactTextString(m) }
func (*VolumeSpec) ProtoMessage()               {}
func (*VolumeSpec) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{5} }

func (m *VolumeSpec) GetEphemeral() bool {
	if m != nil {
		return m.Ephemeral
	}
	return false
}

func (m *VolumeSpec) GetSize() uint64 {
	if m != nil {
		return m.Size
	}
	return 0
}

func (m *VolumeSpec) GetFormat() FSType {
	if m != nil {
		return m.Format
	}
	return FSType_FS_TYPE_NONE
}

func (m *VolumeSpec) GetBlockSize() int64 {
	if m != nil {
		return m.BlockSize
	}
	return 0
}

func (m *VolumeSpec) GetHaLevel() int64 {
	if m != nil {
		return m.HaLevel
	}
	return 0
}

func (m *VolumeSpec) GetCos() CosType {
	if m != nil {
		return m.Cos
	}
	return CosType_NONE
}

func (m *VolumeSpec) GetIoProfile() IoProfile {
	if m != nil {
		return m.IoProfile
	}
	return IoProfile_IO_PROFILE_SEQUENTIAL
}

func (m *VolumeSpec) GetDedupe() bool {
	if m != nil {
		return m.Dedupe
	}
	return false
}

func (m *VolumeSpec) GetSnapshotInterval() uint32 {
	if m != nil {
		return m.SnapshotInterval
	}
	return 0
}

func (m *VolumeSpec) GetVolumeLabels() map[string]string {
	if m != nil {
		return m.VolumeLabels
	}
	return nil
}

func (m *VolumeSpec) GetShared() bool {
	if m != nil {
		return m.Shared
	}
	return false
}

func (m *VolumeSpec) GetReplicaSet() *ReplicaSet {
	if m != nil {
		return m.ReplicaSet
	}
	return nil
}

func (m *VolumeSpec) GetAggregationLevel() uint32 {
	if m != nil {
		return m.AggregationLevel
	}
	return 0
}

func (m *VolumeSpec) GetEncrypted() bool {
	if m != nil {
		return m.Encrypted
	}
	return false
}

func (m *VolumeSpec) GetPassphrase() string {
	if m != nil {
		return m.Passphrase
	}
	return ""
}

func (m *VolumeSpec) GetSnapshotSchedule() string {
	if m != nil {
		return m.SnapshotSchedule
	}
	return ""
}

func (m *VolumeSpec) GetScale() uint32 {
	if m != nil {
		return m.Scale
	}
	return 0
}

func (m *VolumeSpec) GetSticky() bool {
	if m != nil {
		return m.Sticky
	}
	return false
}

func (m *VolumeSpec) GetGroup() *Group {
	if m != nil {
		return m.Group
	}
	return nil
}

func (m *VolumeSpec) GetGroupEnforced() bool {
	if m != nil {
		return m.GroupEnforced
	}
	return false
}

func (m *VolumeSpec) GetCompressed() bool {
	if m != nil {
		return m.Compressed
	}
	return false
}

// ReplicaSet set of machine IDs (nodes) to which part of this volume is erasure
// coded - for clustered storage arrays
type ReplicaSet struct {
	Nodes []string `protobuf:"bytes,1,rep,name=nodes" json:"nodes,omitempty"`
}

func (m *ReplicaSet) Reset()                    { *m = ReplicaSet{} }
func (m *ReplicaSet) String() string            { return proto.CompactTextString(m) }
func (*ReplicaSet) ProtoMessage()               {}
func (*ReplicaSet) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{6} }

func (m *ReplicaSet) GetNodes() []string {
	if m != nil {
		return m.Nodes
	}
	return nil
}

// RuntimeStateMap is a list of name value mapping of driver specific runtime
// information.
type RuntimeStateMap struct {
	RuntimeState map[string]string `protobuf:"bytes,1,rep,name=runtime_state,json=runtimeState" json:"runtime_state,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
}

func (m *RuntimeStateMap) Reset()                    { *m = RuntimeStateMap{} }
func (m *RuntimeStateMap) String() string            { return proto.CompactTextString(m) }
func (*RuntimeStateMap) ProtoMessage()               {}
func (*RuntimeStateMap) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{7} }

func (m *RuntimeStateMap) GetRuntimeState() map[string]string {
	if m != nil {
		return m.RuntimeState
	}
	return nil
}

// Volume represents an abstract storage volume.
// Volume represents an abstract storage volume.
type Volume struct {
	// Self referential volume ID.
	Id string `protobuf:"bytes,1,opt,name=id" json:"id,omitempty"`
	// Source specified seed data for the volume.
	Source *Source `protobuf:"bytes,2,opt,name=source" json:"source,omitempty"`
	// Group volumes in the same group have the same group id.
	Group *Group `protobuf:"bytes,3,opt,name=group" json:"group,omitempty"`
	// Readonly is true if this volume is to be mounted with readonly access.
	Readonly bool `protobuf:"varint,4,opt,name=readonly" json:"readonly,omitempty"`
	// User specified locator
	Locator *VolumeLocator `protobuf:"bytes,5,opt,name=locator" json:"locator,omitempty"`
	// Volume creation time
	Ctime *google_protobuf.Timestamp `protobuf:"bytes,6,opt,name=ctime" json:"ctime,omitempty"`
	// User specified VolumeSpec
	Spec *VolumeSpec `protobuf:"bytes,7,opt,name=spec" json:"spec,omitempty"`
	// Usage is bytes consumed by vtheis volume.
	Usage uint64 `protobuf:"varint,8,opt,name=usage" json:"usage,omitempty"`
	// LastScan is the time when an integrity check was run.
	LastScan *google_protobuf.Timestamp `protobuf:"bytes,9,opt,name=last_scan,json=lastScan" json:"last_scan,omitempty"`
	// Format specifies the filesytem for this volume.
	Format FSType `protobuf:"varint,10,opt,name=format,enum=openstorage.api.FSType" json:"format,omitempty"`
	// Status is the availability status of this volume.
	Status VolumeStatus `protobuf:"varint,11,opt,name=status,enum=openstorage.api.VolumeStatus" json:"status,omitempty"`
	// State is the current runtime state of this volume.
	State VolumeState `protobuf:"varint,12,opt,name=state,enum=openstorage.api.VolumeState" json:"state,omitempty"`
	// AttachedOn is the node instance identifier for clustered systems.
	AttachedOn string `protobuf:"bytes,13,opt,name=attached_on,json=attachedOn" json:"attached_on,omitempty"`
	// AttachedState shows whether the device is attached for internal or external use.
	AttachedState AttachState `protobuf:"varint,14,opt,name=attached_state,json=attachedState,enum=openstorage.api.AttachState" json:"attached_state,omitempty"`
	// DevicePath is the device exported by block device implementations.
	DevicePath string `protobuf:"bytes,15,opt,name=device_path,json=devicePath" json:"device_path,omitempty"`
	// SecureDevicePath is the device path for an encrypted volume.
	SecureDevicePath string `protobuf:"bytes,16,opt,name=secure_device_path,json=secureDevicePath" json:"secure_device_path,omitempty"`
	// AttachPath is the mounted path in the host namespace.
	AttachPath []string `protobuf:"bytes,17,rep,name=attach_path,json=attachPath" json:"attach_path,omitempty"`
	// AttachInfo is a list of name value mappings that provides attach information.
	AttachInfo map[string]string `protobuf:"bytes,18,rep,name=attach_info,json=attachInfo" json:"attach_info,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// ReplicatSets storage for this volumefor clustered storage arrays.
	ReplicaSets []*ReplicaSet `protobuf:"bytes,19,rep,name=replica_sets,json=replicaSets" json:"replica_sets,omitempty"`
	// RuntimeState is a lst of name value mapping of driver specific runtime
	// information.
	RuntimeState []*RuntimeStateMap `protobuf:"bytes,20,rep,name=runtime_state,json=runtimeState" json:"runtime_state,omitempty"`
	// Error is the Last recorded error.
	Error string `protobuf:"bytes,21,opt,name=error" json:"error,omitempty"`
}

func (m *Volume) Reset()                    { *m = Volume{} }
func (m *Volume) String() string            { return proto.CompactTextString(m) }
func (*Volume) ProtoMessage()               {}
func (*Volume) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{8} }

func (m *Volume) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *Volume) GetSource() *Source {
	if m != nil {
		return m.Source
	}
	return nil
}

func (m *Volume) GetGroup() *Group {
	if m != nil {
		return m.Group
	}
	return nil
}

func (m *Volume) GetReadonly() bool {
	if m != nil {
		return m.Readonly
	}
	return false
}

func (m *Volume) GetLocator() *VolumeLocator {
	if m != nil {
		return m.Locator
	}
	return nil
}

func (m *Volume) GetCtime() *google_protobuf.Timestamp {
	if m != nil {
		return m.Ctime
	}
	return nil
}

func (m *Volume) GetSpec() *VolumeSpec {
	if m != nil {
		return m.Spec
	}
	return nil
}

func (m *Volume) GetUsage() uint64 {
	if m != nil {
		return m.Usage
	}
	return 0
}

func (m *Volume) GetLastScan() *google_protobuf.Timestamp {
	if m != nil {
		return m.LastScan
	}
	return nil
}

func (m *Volume) GetFormat() FSType {
	if m != nil {
		return m.Format
	}
	return FSType_FS_TYPE_NONE
}

func (m *Volume) GetStatus() VolumeStatus {
	if m != nil {
		return m.Status
	}
	return VolumeStatus_VOLUME_STATUS_NONE
}

func (m *Volume) GetState() VolumeState {
	if m != nil {
		return m.State
	}
	return VolumeState_VOLUME_STATE_NONE
}

func (m *Volume) GetAttachedOn() string {
	if m != nil {
		return m.AttachedOn
	}
	return ""
}

func (m *Volume) GetAttachedState() AttachState {
	if m != nil {
		return m.AttachedState
	}
	return AttachState_ATTACH_STATE_EXTERNAL
}

func (m *Volume) GetDevicePath() string {
	if m != nil {
		return m.DevicePath
	}
	return ""
}

func (m *Volume) GetSecureDevicePath() string {
	if m != nil {
		return m.SecureDevicePath
	}
	return ""
}

func (m *Volume) GetAttachPath() []string {
	if m != nil {
		return m.AttachPath
	}
	return nil
}

func (m *Volume) GetAttachInfo() map[string]string {
	if m != nil {
		return m.AttachInfo
	}
	return nil
}

func (m *Volume) GetReplicaSets() []*ReplicaSet {
	if m != nil {
		return m.ReplicaSets
	}
	return nil
}

func (m *Volume) GetRuntimeState() []*RuntimeStateMap {
	if m != nil {
		return m.RuntimeState
	}
	return nil
}

func (m *Volume) GetError() string {
	if m != nil {
		return m.Error
	}
	return ""
}

type Stats struct {
	// Reads completed successfully
	Reads uint64 `protobuf:"varint,1,opt,name=reads" json:"reads,omitempty"`
	// Time spent in reads in ms
	ReadMs    uint64 `protobuf:"varint,2,opt,name=read_ms,json=readMs" json:"read_ms,omitempty"`
	ReadBytes uint64 `protobuf:"varint,3,opt,name=read_bytes,json=readBytes" json:"read_bytes,omitempty"`
	// Writes completed successfully
	Writes uint64 `protobuf:"varint,4,opt,name=writes" json:"writes,omitempty"`
	// Time spent in writes in ms
	WriteMs    uint64 `protobuf:"varint,5,opt,name=write_ms,json=writeMs" json:"write_ms,omitempty"`
	WriteBytes uint64 `protobuf:"varint,6,opt,name=write_bytes,json=writeBytes" json:"write_bytes,omitempty"`
	// IOs curently in progress
	IoProgress uint64 `protobuf:"varint,7,opt,name=io_progress,json=ioProgress" json:"io_progress,omitempty"`
	// Time spent doing IOs ms
	IoMs uint64 `protobuf:"varint,8,opt,name=io_ms,json=ioMs" json:"io_ms,omitempty"`
	// BytesUsed
	BytesUsed uint64 `protobuf:"varint,9,opt,name=bytes_used,json=bytesUsed" json:"bytes_used,omitempty"`
	// Interval in ms during which stats were collected
	IntervalMs uint64 `protobuf:"varint,10,opt,name=interval_ms,json=intervalMs" json:"interval_ms,omitempty"`
}

func (m *Stats) Reset()                    { *m = Stats{} }
func (m *Stats) String() string            { return proto.CompactTextString(m) }
func (*Stats) ProtoMessage()               {}
func (*Stats) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{9} }

func (m *Stats) GetReads() uint64 {
	if m != nil {
		return m.Reads
	}
	return 0
}

func (m *Stats) GetReadMs() uint64 {
	if m != nil {
		return m.ReadMs
	}
	return 0
}

func (m *Stats) GetReadBytes() uint64 {
	if m != nil {
		return m.ReadBytes
	}
	return 0
}

func (m *Stats) GetWrites() uint64 {
	if m != nil {
		return m.Writes
	}
	return 0
}

func (m *Stats) GetWriteMs() uint64 {
	if m != nil {
		return m.WriteMs
	}
	return 0
}

func (m *Stats) GetWriteBytes() uint64 {
	if m != nil {
		return m.WriteBytes
	}
	return 0
}

func (m *Stats) GetIoProgress() uint64 {
	if m != nil {
		return m.IoProgress
	}
	return 0
}

func (m *Stats) GetIoMs() uint64 {
	if m != nil {
		return m.IoMs
	}
	return 0
}

func (m *Stats) GetBytesUsed() uint64 {
	if m != nil {
		return m.BytesUsed
	}
	return 0
}

func (m *Stats) GetIntervalMs() uint64 {
	if m != nil {
		return m.IntervalMs
	}
	return 0
}

type Alert struct {
	// Id for Alert
	Id int64 `protobuf:"varint,1,opt,name=id" json:"id,omitempty"`
	// Severity of the Alert
	Severity SeverityType `protobuf:"varint,2,opt,name=severity,enum=openstorage.api.SeverityType" json:"severity,omitempty"`
	// AlertType user defined alert type
	AlertType int64 `protobuf:"varint,3,opt,name=alert_type,json=alertType" json:"alert_type,omitempty"`
	// Message describing the Alert
	Message string `protobuf:"bytes,4,opt,name=message" json:"message,omitempty"`
	// Timestamp when Alert occured
	Timestamp *google_protobuf.Timestamp `protobuf:"bytes,5,opt,name=timestamp" json:"timestamp,omitempty"`
	// ResourceId where Alert occured
	ResourceId string `protobuf:"bytes,6,opt,name=resource_id,json=resourceId" json:"resource_id,omitempty"`
	// Resource where Alert occured
	Resource ResourceType `protobuf:"varint,7,opt,name=resource,enum=openstorage.api.ResourceType" json:"resource,omitempty"`
	// Cleared Flag
	Cleared bool `protobuf:"varint,8,opt,name=cleared" json:"cleared,omitempty"`
	// TTL in seconds for this Alert
	Ttl uint64 `protobuf:"varint,9,opt,name=ttl" json:"ttl,omitempty"`
	// UniqueTag helps identify a unique alert for a given resouce
	UniqueTag string `protobuf:"bytes,10,opt,name=unique_tag,json=uniqueTag" json:"unique_tag,omitempty"`
}

func (m *Alert) Reset()                    { *m = Alert{} }
func (m *Alert) String() string            { return proto.CompactTextString(m) }
func (*Alert) ProtoMessage()               {}
func (*Alert) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{10} }

func (m *Alert) GetId() int64 {
	if m != nil {
		return m.Id
	}
	return 0
}

func (m *Alert) GetSeverity() SeverityType {
	if m != nil {
		return m.Severity
	}
	return SeverityType_SEVERITY_TYPE_NONE
}

func (m *Alert) GetAlertType() int64 {
	if m != nil {
		return m.AlertType
	}
	return 0
}

func (m *Alert) GetMessage() string {
	if m != nil {
		return m.Message
	}
	return ""
}

func (m *Alert) GetTimestamp() *google_protobuf.Timestamp {
	if m != nil {
		return m.Timestamp
	}
	return nil
}

func (m *Alert) GetResourceId() string {
	if m != nil {
		return m.ResourceId
	}
	return ""
}

func (m *Alert) GetResource() ResourceType {
	if m != nil {
		return m.Resource
	}
	return ResourceType_RESOURCE_TYPE_NONE
}

func (m *Alert) GetCleared() bool {
	if m != nil {
		return m.Cleared
	}
	return false
}

func (m *Alert) GetTtl() uint64 {
	if m != nil {
		return m.Ttl
	}
	return 0
}

func (m *Alert) GetUniqueTag() string {
	if m != nil {
		return m.UniqueTag
	}
	return ""
}

type Alerts struct {
	Alert []*Alert `protobuf:"bytes,1,rep,name=alert" json:"alert,omitempty"`
}

func (m *Alerts) Reset()                    { *m = Alerts{} }
func (m *Alerts) String() string            { return proto.CompactTextString(m) }
func (*Alerts) ProtoMessage()               {}
func (*Alerts) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{11} }

func (m *Alerts) GetAlert() []*Alert {
	if m != nil {
		return m.Alert
	}
	return nil
}

type VolumeCreateRequest struct {
	// User specified volume name and labels
	Locator *VolumeLocator `protobuf:"bytes,1,opt,name=locator" json:"locator,omitempty"`
	// Source to create volume
	Source *Source `protobuf:"bytes,2,opt,name=source" json:"source,omitempty"`
	// The storage spec for the volume
	Spec *VolumeSpec `protobuf:"bytes,3,opt,name=spec" json:"spec,omitempty"`
}

func (m *VolumeCreateRequest) Reset()                    { *m = VolumeCreateRequest{} }
func (m *VolumeCreateRequest) String() string            { return proto.CompactTextString(m) }
func (*VolumeCreateRequest) ProtoMessage()               {}
func (*VolumeCreateRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{12} }

func (m *VolumeCreateRequest) GetLocator() *VolumeLocator {
	if m != nil {
		return m.Locator
	}
	return nil
}

func (m *VolumeCreateRequest) GetSource() *Source {
	if m != nil {
		return m.Source
	}
	return nil
}

func (m *VolumeCreateRequest) GetSpec() *VolumeSpec {
	if m != nil {
		return m.Spec
	}
	return nil
}

type VolumeResponse struct {
	Error string `protobuf:"bytes,1,opt,name=error" json:"error,omitempty"`
}

func (m *VolumeResponse) Reset()                    { *m = VolumeResponse{} }
func (m *VolumeResponse) String() string            { return proto.CompactTextString(m) }
func (*VolumeResponse) ProtoMessage()               {}
func (*VolumeResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{13} }

func (m *VolumeResponse) GetError() string {
	if m != nil {
		return m.Error
	}
	return ""
}

type VolumeCreateResponse struct {
	// ID of the newly created volume
	Id             string          `protobuf:"bytes,1,opt,name=id" json:"id,omitempty"`
	VolumeResponse *VolumeResponse `protobuf:"bytes,2,opt,name=volume_response,json=volumeResponse" json:"volume_response,omitempty"`
}

func (m *VolumeCreateResponse) Reset()                    { *m = VolumeCreateResponse{} }
func (m *VolumeCreateResponse) String() string            { return proto.CompactTextString(m) }
func (*VolumeCreateResponse) ProtoMessage()               {}
func (*VolumeCreateResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{14} }

func (m *VolumeCreateResponse) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *VolumeCreateResponse) GetVolumeResponse() *VolumeResponse {
	if m != nil {
		return m.VolumeResponse
	}
	return nil
}

// VolumeStateAction specifies desired actions.
type VolumeStateAction struct {
	// Attach or Detach volume
	Attach VolumeActionParam `protobuf:"varint,1,opt,name=attach,enum=openstorage.api.VolumeActionParam" json:"attach,omitempty"`
	// Mount or unmount volume
	Mount VolumeActionParam `protobuf:"varint,2,opt,name=mount,enum=openstorage.api.VolumeActionParam" json:"mount,omitempty"`
	// MountPath Path where the device is mounted
	MountPath string `protobuf:"bytes,3,opt,name=mount_path,json=mountPath" json:"mount_path,omitempty"`
	// DevicePath Path returned in attach
	DevicePath string `protobuf:"bytes,4,opt,name=device_path,json=devicePath" json:"device_path,omitempty"`
	// UnmountBeforeDetach is used to check whether unmount should be done before
	// a detach
	UnmountBeforeDetach bool `protobuf:"varint,5,opt,name=unmount_before_detach,json=unmountBeforeDetach" json:"unmount_before_detach,omitempty"`
}

func (m *VolumeStateAction) Reset()                    { *m = VolumeStateAction{} }
func (m *VolumeStateAction) String() string            { return proto.CompactTextString(m) }
func (*VolumeStateAction) ProtoMessage()               {}
func (*VolumeStateAction) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{15} }

func (m *VolumeStateAction) GetAttach() VolumeActionParam {
	if m != nil {
		return m.Attach
	}
	return VolumeActionParam_VOLUME_ACTION_PARAM_NONE
}

func (m *VolumeStateAction) GetMount() VolumeActionParam {
	if m != nil {
		return m.Mount
	}
	return VolumeActionParam_VOLUME_ACTION_PARAM_NONE
}

func (m *VolumeStateAction) GetMountPath() string {
	if m != nil {
		return m.MountPath
	}
	return ""
}

func (m *VolumeStateAction) GetDevicePath() string {
	if m != nil {
		return m.DevicePath
	}
	return ""
}

func (m *VolumeStateAction) GetUnmountBeforeDetach() bool {
	if m != nil {
		return m.UnmountBeforeDetach
	}
	return false
}

type VolumeSetRequest struct {
	// User specified volume name and labels
	Locator *VolumeLocator `protobuf:"bytes,1,opt,name=locator" json:"locator,omitempty"`
	// The storage spec for the volume
	Spec *VolumeSpec `protobuf:"bytes,2,opt,name=spec" json:"spec,omitempty"`
	// State modification on this volume.
	Action *VolumeStateAction `protobuf:"bytes,3,opt,name=action" json:"action,omitempty"`
	// additional options
	// required for the Set operation.
	Options map[string]string `protobuf:"bytes,4,rep,name=options" json:"options,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
}

func (m *VolumeSetRequest) Reset()                    { *m = VolumeSetRequest{} }
func (m *VolumeSetRequest) String() string            { return proto.CompactTextString(m) }
func (*VolumeSetRequest) ProtoMessage()               {}
func (*VolumeSetRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{16} }

func (m *VolumeSetRequest) GetLocator() *VolumeLocator {
	if m != nil {
		return m.Locator
	}
	return nil
}

func (m *VolumeSetRequest) GetSpec() *VolumeSpec {
	if m != nil {
		return m.Spec
	}
	return nil
}

func (m *VolumeSetRequest) GetAction() *VolumeStateAction {
	if m != nil {
		return m.Action
	}
	return nil
}

func (m *VolumeSetRequest) GetOptions() map[string]string {
	if m != nil {
		return m.Options
	}
	return nil
}

type VolumeSetResponse struct {
	Volume         *Volume         `protobuf:"bytes,1,opt,name=volume" json:"volume,omitempty"`
	VolumeResponse *VolumeResponse `protobuf:"bytes,2,opt,name=volume_response,json=volumeResponse" json:"volume_response,omitempty"`
}

func (m *VolumeSetResponse) Reset()                    { *m = VolumeSetResponse{} }
func (m *VolumeSetResponse) String() string            { return proto.CompactTextString(m) }
func (*VolumeSetResponse) ProtoMessage()               {}
func (*VolumeSetResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{17} }

func (m *VolumeSetResponse) GetVolume() *Volume {
	if m != nil {
		return m.Volume
	}
	return nil
}

func (m *VolumeSetResponse) GetVolumeResponse() *VolumeResponse {
	if m != nil {
		return m.VolumeResponse
	}
	return nil
}

type SnapCreateRequest struct {
	// volume id
	Id       string         `protobuf:"bytes,1,opt,name=id" json:"id,omitempty"`
	Locator  *VolumeLocator `protobuf:"bytes,2,opt,name=locator" json:"locator,omitempty"`
	Readonly bool           `protobuf:"varint,3,opt,name=readonly" json:"readonly,omitempty"`
}

func (m *SnapCreateRequest) Reset()                    { *m = SnapCreateRequest{} }
func (m *SnapCreateRequest) String() string            { return proto.CompactTextString(m) }
func (*SnapCreateRequest) ProtoMessage()               {}
func (*SnapCreateRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{18} }

func (m *SnapCreateRequest) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *SnapCreateRequest) GetLocator() *VolumeLocator {
	if m != nil {
		return m.Locator
	}
	return nil
}

func (m *SnapCreateRequest) GetReadonly() bool {
	if m != nil {
		return m.Readonly
	}
	return false
}

type SnapCreateResponse struct {
	VolumeCreateResponse *VolumeCreateResponse `protobuf:"bytes,1,opt,name=volume_create_response,json=volumeCreateResponse" json:"volume_create_response,omitempty"`
}

func (m *SnapCreateResponse) Reset()                    { *m = SnapCreateResponse{} }
func (m *SnapCreateResponse) String() string            { return proto.CompactTextString(m) }
func (*SnapCreateResponse) ProtoMessage()               {}
func (*SnapCreateResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{19} }

func (m *SnapCreateResponse) GetVolumeCreateResponse() *VolumeCreateResponse {
	if m != nil {
		return m.VolumeCreateResponse
	}
	return nil
}

type VolumeInfo struct {
	VolumeId string      `protobuf:"bytes,1,opt,name=volume_id,json=volumeId" json:"volume_id,omitempty"`
	Path     string      `protobuf:"bytes,2,opt,name=path" json:"path,omitempty"`
	Storage  *VolumeSpec `protobuf:"bytes,3,opt,name=storage" json:"storage,omitempty"`
}

func (m *VolumeInfo) Reset()                    { *m = VolumeInfo{} }
func (m *VolumeInfo) String() string            { return proto.CompactTextString(m) }
func (*VolumeInfo) ProtoMessage()               {}
func (*VolumeInfo) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{20} }

func (m *VolumeInfo) GetVolumeId() string {
	if m != nil {
		return m.VolumeId
	}
	return ""
}

func (m *VolumeInfo) GetPath() string {
	if m != nil {
		return m.Path
	}
	return ""
}

func (m *VolumeInfo) GetStorage() *VolumeSpec {
	if m != nil {
		return m.Storage
	}
	return nil
}

// GraphDriverChanges represent a list of changes between the filesystem layers
// specified by the ID and Parent.  // Parent may be an empty string, in which
// case there is no parent.
// Where the Path is the filesystem path within the layered filesystem
type GraphDriverChanges struct {
	Path string                `protobuf:"bytes,1,opt,name=path" json:"path,omitempty"`
	Kind GraphDriverChangeType `protobuf:"varint,2,opt,name=kind,enum=openstorage.api.GraphDriverChangeType" json:"kind,omitempty"`
}

func (m *GraphDriverChanges) Reset()                    { *m = GraphDriverChanges{} }
func (m *GraphDriverChanges) String() string            { return proto.CompactTextString(m) }
func (*GraphDriverChanges) ProtoMessage()               {}
func (*GraphDriverChanges) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{21} }

func (m *GraphDriverChanges) GetPath() string {
	if m != nil {
		return m.Path
	}
	return ""
}

func (m *GraphDriverChanges) GetKind() GraphDriverChangeType {
	if m != nil {
		return m.Kind
	}
	return GraphDriverChangeType_GRAPH_DRIVER_CHANGE_TYPE_NONE
}

type ClusterResponse struct {
	Error string `protobuf:"bytes,1,opt,name=error" json:"error,omitempty"`
}

func (m *ClusterResponse) Reset()                    { *m = ClusterResponse{} }
func (m *ClusterResponse) String() string            { return proto.CompactTextString(m) }
func (*ClusterResponse) ProtoMessage()               {}
func (*ClusterResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{22} }

func (m *ClusterResponse) GetError() string {
	if m != nil {
		return m.Error
	}
	return ""
}

type ActiveRequest struct {
	ReqestKV map[int64]string `protobuf:"bytes,1,rep,name=ReqestKV,json=reqestKV" json:"ReqestKV,omitempty" protobuf_key:"varint,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
}

func (m *ActiveRequest) Reset()                    { *m = ActiveRequest{} }
func (m *ActiveRequest) String() string            { return proto.CompactTextString(m) }
func (*ActiveRequest) ProtoMessage()               {}
func (*ActiveRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{23} }

func (m *ActiveRequest) GetReqestKV() map[int64]string {
	if m != nil {
		return m.ReqestKV
	}
	return nil
}

type ActiveRequests struct {
	RequestCount  int64            `protobuf:"varint,1,opt,name=RequestCount,json=requestCount" json:"RequestCount,omitempty"`
	ActiveRequest []*ActiveRequest `protobuf:"bytes,2,rep,name=ActiveRequest,json=activeRequest" json:"ActiveRequest,omitempty"`
}

func (m *ActiveRequests) Reset()                    { *m = ActiveRequests{} }
func (m *ActiveRequests) String() string            { return proto.CompactTextString(m) }
func (*ActiveRequests) ProtoMessage()               {}
func (*ActiveRequests) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{24} }

func (m *ActiveRequests) GetRequestCount() int64 {
	if m != nil {
		return m.RequestCount
	}
	return 0
}

func (m *ActiveRequests) GetActiveRequest() []*ActiveRequest {
	if m != nil {
		return m.ActiveRequest
	}
	return nil
}

func init() {
	proto.RegisterType((*StorageResource)(nil), "openstorage.api.StorageResource")
	proto.RegisterType((*StoragePool)(nil), "openstorage.api.StoragePool")
	proto.RegisterType((*VolumeLocator)(nil), "openstorage.api.VolumeLocator")
	proto.RegisterType((*Source)(nil), "openstorage.api.Source")
	proto.RegisterType((*Group)(nil), "openstorage.api.Group")
	proto.RegisterType((*VolumeSpec)(nil), "openstorage.api.VolumeSpec")
	proto.RegisterType((*ReplicaSet)(nil), "openstorage.api.ReplicaSet")
	proto.RegisterType((*RuntimeStateMap)(nil), "openstorage.api.RuntimeStateMap")
	proto.RegisterType((*Volume)(nil), "openstorage.api.Volume")
	proto.RegisterType((*Stats)(nil), "openstorage.api.Stats")
	proto.RegisterType((*Alert)(nil), "openstorage.api.Alert")
	proto.RegisterType((*Alerts)(nil), "openstorage.api.Alerts")
	proto.RegisterType((*VolumeCreateRequest)(nil), "openstorage.api.VolumeCreateRequest")
	proto.RegisterType((*VolumeResponse)(nil), "openstorage.api.VolumeResponse")
	proto.RegisterType((*VolumeCreateResponse)(nil), "openstorage.api.VolumeCreateResponse")
	proto.RegisterType((*VolumeStateAction)(nil), "openstorage.api.VolumeStateAction")
	proto.RegisterType((*VolumeSetRequest)(nil), "openstorage.api.VolumeSetRequest")
	proto.RegisterType((*VolumeSetResponse)(nil), "openstorage.api.VolumeSetResponse")
	proto.RegisterType((*SnapCreateRequest)(nil), "openstorage.api.SnapCreateRequest")
	proto.RegisterType((*SnapCreateResponse)(nil), "openstorage.api.SnapCreateResponse")
	proto.RegisterType((*VolumeInfo)(nil), "openstorage.api.VolumeInfo")
	proto.RegisterType((*GraphDriverChanges)(nil), "openstorage.api.GraphDriverChanges")
	proto.RegisterType((*ClusterResponse)(nil), "openstorage.api.ClusterResponse")
	proto.RegisterType((*ActiveRequest)(nil), "openstorage.api.ActiveRequest")
	proto.RegisterType((*ActiveRequests)(nil), "openstorage.api.ActiveRequests")
	proto.RegisterEnum("openstorage.api.Status", Status_name, Status_value)
	proto.RegisterEnum("openstorage.api.DriverType", DriverType_name, DriverType_value)
	proto.RegisterEnum("openstorage.api.FSType", FSType_name, FSType_value)
	proto.RegisterEnum("openstorage.api.GraphDriverChangeType", GraphDriverChangeType_name, GraphDriverChangeType_value)
	proto.RegisterEnum("openstorage.api.SeverityType", SeverityType_name, SeverityType_value)
	proto.RegisterEnum("openstorage.api.ResourceType", ResourceType_name, ResourceType_value)
	proto.RegisterEnum("openstorage.api.AlertActionType", AlertActionType_name, AlertActionType_value)
	proto.RegisterEnum("openstorage.api.VolumeActionParam", VolumeActionParam_name, VolumeActionParam_value)
	proto.RegisterEnum("openstorage.api.CosType", CosType_name, CosType_value)
	proto.RegisterEnum("openstorage.api.IoProfile", IoProfile_name, IoProfile_value)
	proto.RegisterEnum("openstorage.api.VolumeState", VolumeState_name, VolumeState_value)
	proto.RegisterEnum("openstorage.api.VolumeStatus", VolumeStatus_name, VolumeStatus_value)
	proto.RegisterEnum("openstorage.api.StorageMedium", StorageMedium_name, StorageMedium_value)
	proto.RegisterEnum("openstorage.api.ClusterNotify", ClusterNotify_name, ClusterNotify_value)
	proto.RegisterEnum("openstorage.api.AttachState", AttachState_name, AttachState_value)
}

func init() { proto.RegisterFile("api/api.proto", fileDescriptor0) }

var fileDescriptor0 = []byte{
	// 2941 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xac, 0x59, 0x4b, 0x73, 0xe3, 0xc6,
	0xb5, 0x1e, 0xf0, 0x25, 0xf2, 0x50, 0x94, 0xa0, 0x1e, 0x8d, 0xc4, 0xd1, 0xbc, 0x64, 0xd6, 0xb5,
	0xad, 0xd2, 0xf5, 0xd5, 0xb8, 0x74, 0x6d, 0xdf, 0xf1, 0xdc, 0x27, 0x45, 0x82, 0x12, 0xaf, 0xf9,
	0x90, 0x1b, 0x90, 0x66, 0xc6, 0xa9, 0x14, 0x0a, 0x43, 0xb6, 0x24, 0x64, 0x28, 0x02, 0x03, 0x80,
	0x4a, 0xc9, 0x7f, 0x20, 0x9b, 0x54, 0xb2, 0x4a, 0x52, 0x5e, 0xe5, 0x07, 0x78, 0x95, 0x75, 0x16,
	0x59, 0x67, 0x93, 0x5f, 0x92, 0x4d, 0xd6, 0xa9, 0x54, 0xa5, 0xce, 0xe9, 0x06, 0x05, 0x90, 0xd2,
	0x3c, 0x12, 0xef, 0xba, 0xbf, 0xf3, 0xe8, 0xd3, 0xa7, 0xcf, 0x0b, 0x24, 0x54, 0x1c, 0xdf, 0x7d,
	0xec, 0xf8, 0xee, 0x8e, 0x1f, 0x78, 0x91, 0xc7, 0x96, 0x3d, 0x5f, 0x8c, 0xc3, 0xc8, 0x0b, 0x9c,
	0x53, 0xb1, 0xe3, 0xf8, 0xee, 0xc6, 0xa3, 0x53, 0xcf, 0x3b, 0x1d, 0x89, 0xc7, 0x44, 0x7e, 0x39,
	0x39, 0x79, 0x1c, 0xb9, 0xe7, 0x22, 0x8c, 0x9c, 0x73, 0x5f, 0x4a, 0xd4, 0xfe, 0x92, 0x81, 0x65,
	0x53, 0x0a, 0x70, 0x11, 0x7a, 0x93, 0x60, 0x20, 0xd8, 0x12, 0x64, 0xdc, 0x61, 0x55, 0xdb, 0xd4,
	0xb6, 0x4a, 0x3c, 0xe3, 0x0e, 0x19, 0x83, 0x9c, 0xef, 0x44, 0x67, 0xd5, 0x0c, 0x21, 0xb4, 0x66,
	0x5f, 0x40, 0xe1, 0x5c, 0x0c, 0xdd, 0xc9, 0x79, 0x35, 0xbb, 0xa9, 0x6d, 0x2d, 0xed, 0x3e, 0xdc,
	0x99, 0x39, 0x7a, 0x47, 0x69, 0xed, 0x12, 0x17, 0x57, 0xdc, 0x6c, 0x0d, 0x0a, 0xde, 0x78, 0xe4,
	0x8e, 0x45, 0x35, 0xb7, 0xa9, 0x6d, 0x15, 0xb9, 0xda, 0xe1, 0x19, 0xae, 0xe7, 0x87, 0xd5, 0xfc,
	0xa6, 0xb6, 0x95, 0xe3, 0xb4, 0x66, 0xf7, 0xa0, 0x14, 0x8a, 0xd7, 0xf6, 0x4f, 0x03, 0x37, 0x12,
	0xd5, 0xc2, 0xa6, 0xb6, 0xa5, 0xf1, 0x62, 0x28, 0x5e, 0x3f, 0xc3, 0x3d, 0xbb, 0x0b, 0xb8, 0xb6,
	0x03, 0xe1, 0x0c, 0xab, 0x0b, 0x44, 0x5b, 0x08, 0xc5, 0x6b, 0x2e, 0x9c, 0x21, 0x9e, 0x11, 0x38,
	0xe3, 0x21, 0x7f, 0x56, 0x2d, 0x12, 0x41, 0xed, 0xf0, 0x8c, 0xd0, 0xfd, 0x56, 0x54, 0x4b, 0xf2,
	0x0c, 0x5c, 0x23, 0x36, 0x09, 0xc5, 0xb0, 0x0a, 0x12, 0xc3, 0x35, 0xfb, 0x10, 0x96, 0x02, 0x2f,
	0x72, 0x22, 0xd7, 0x1b, 0xdb, 0xa1, 0x2f, 0xc4, 0xb0, 0x5a, 0xa6, 0x9b, 0x57, 0x62, 0xd4, 0x44,
	0x90, 0xfd, 0x07, 0x94, 0x46, 0x4e, 0x18, 0xd9, 0xe1, 0xc0, 0x19, 0x57, 0x17, 0x37, 0xb5, 0xad,
	0xf2, 0xee, 0xc6, 0x8e, 0xf4, 0xf7, 0x4e, 0xec, 0xef, 0x1d, 0x2b, 0xf6, 0x37, 0x2f, 0x22, 0xb3,
	0x39, 0x70, 0xc6, 0xb5, 0x3f, 0x65, 0xa0, 0xac, 0xbc, 0x73, 0xe8, 0x79, 0x23, 0xf4, 0x77, 0xbb,
	0x49, 0xfe, 0xce, 0xf3, 0x8c, 0xdb, 0x64, 0xdb, 0x90, 0x6d, 0x78, 0x21, 0xb9, 0x7b, 0x69, 0xb7,
	0x3a, 0xe7, 0xd8, 0x86, 0x17, 0x5a, 0x97, 0xbe, 0xe0, 0xd9, 0x81, 0x17, 0xe2, 0x3b, 0x74, 0xff,
	0x91, 0x77, 0xb8, 0x0f, 0x25, 0xee, 0xb8, 0xc3, 0x8e, 0xb8, 0x10, 0x23, 0x7a, 0x8a, 0x12, 0x2f,
	0x05, 0x31, 0x80, 0x54, 0xcb, 0x8b, 0x9c, 0x91, 0x89, 0xee, 0x5a, 0x20, 0xd7, 0x94, 0xa2, 0x18,
	0x40, 0x9f, 0x1d, 0xa1, 0xcf, 0x8a, 0x09, 0x9f, 0xfd, 0x1f, 0x14, 0x46, 0xce, 0x4b, 0x31, 0x0a,
	0xab, 0xa5, 0xcd, 0xec, 0x56, 0x79, 0x77, 0xeb, 0x26, 0x3b, 0xf0, 0xc6, 0x3b, 0x1d, 0x62, 0x35,
	0xc6, 0x51, 0x70, 0xc9, 0x95, 0xdc, 0xc6, 0x97, 0x50, 0x4e, 0xc0, 0x4c, 0x87, 0xec, 0x2b, 0x71,
	0xa9, 0xa2, 0x10, 0x97, 0x6c, 0x15, 0xf2, 0x17, 0xce, 0x68, 0x22, 0x54, 0x1c, 0xca, 0xcd, 0xd3,
	0xcc, 0x13, 0xad, 0xf6, 0x7b, 0x0d, 0x2a, 0xc7, 0xde, 0x68, 0x72, 0x2e, 0x3a, 0xde, 0xc0, 0x89,
	0xbc, 0x00, 0x4d, 0x1c, 0x3b, 0xe7, 0x42, 0x89, 0xd3, 0x9a, 0x1d, 0x41, 0xe5, 0x82, 0x98, 0x6c,
	0x65, 0x69, 0x86, 0x2c, 0xfd, 0x74, 0xce, 0xd2, 0x94, 0xaa, 0x78, 0x97, 0xb0, 0x78, 0xf1, 0x22,
	0x01, 0x6d, 0xfc, 0x2f, 0xac, 0xcc, 0xb1, 0xbc, 0x97, 0xf5, 0x9f, 0x41, 0xc1, 0x94, 0x89, 0xb7,
	0x06, 0x05, 0xdf, 0x09, 0xc4, 0x38, 0x52, 0x82, 0x6a, 0x47, 0x81, 0x8b, 0x61, 0xa8, 0x12, 0x10,
	0xd7, 0xb5, 0x75, 0xc8, 0xef, 0x07, 0xde, 0xc4, 0x9f, 0xcd, 0xd6, 0xda, 0x5f, 0x0b, 0x00, 0xd2,
	0x20, 0xd3, 0x17, 0x03, 0x7c, 0x4a, 0xe1, 0x9f, 0x89, 0x73, 0x11, 0x38, 0x23, 0xe2, 0x2a, 0xf2,
	0x2b, 0x60, 0x9a, 0x12, 0x99, 0x44, 0x4a, 0x3c, 0x86, 0xc2, 0x89, 0x17, 0x9c, 0x3b, 0x91, 0x0a,
	0xa9, 0xf5, 0x39, 0x07, 0xb5, 0x4c, 0x0a, 0x40, 0xc5, 0xc6, 0x1e, 0x00, 0xbc, 0x1c, 0x79, 0x83,
	0x57, 0x36, 0xa9, 0xc2, 0x60, 0xca, 0xf2, 0x12, 0x21, 0x14, 0x2e, 0x77, 0xa1, 0x78, 0xe6, 0xd8,
	0x23, 0x8a, 0xb4, 0x3c, 0x11, 0x17, 0xce, 0x1c, 0x19, 0x67, 0xdb, 0x80, 0x41, 0x4c, 0xb9, 0xfd,
	0xd6, 0x48, 0xff, 0x12, 0xc0, 0xf5, 0x6c, 0x3f, 0xf0, 0x4e, 0xdc, 0x91, 0x0c, 0xca, 0xa5, 0xdd,
	0x8d, 0x39, 0x91, 0xb6, 0x77, 0x28, 0x39, 0x78, 0xc9, 0x8d, 0x97, 0xe8, 0xd7, 0xa1, 0x18, 0x4e,
	0x7c, 0x41, 0x21, 0x5b, 0xe4, 0x6a, 0xc7, 0xfe, 0x15, 0x56, 0xc2, 0xb1, 0xe3, 0x87, 0x67, 0x5e,
	0x64, 0xbb, 0xe3, 0x48, 0x04, 0x17, 0xce, 0x88, 0xaa, 0x43, 0x85, 0xeb, 0x31, 0xa1, 0xad, 0x70,
	0xc6, 0x67, 0xc3, 0x07, 0x28, 0x7c, 0xfe, 0xed, 0x86, 0xf0, 0x41, 0xe7, 0xbf, 0x2d, 0x76, 0xd0,
	0xb0, 0xf0, 0xcc, 0x09, 0x54, 0x85, 0x29, 0x72, 0xb5, 0x63, 0xff, 0x05, 0xe5, 0x40, 0xf8, 0x23,
	0x77, 0xe0, 0xd8, 0xa1, 0x88, 0x54, 0x71, 0xb9, 0x37, 0x77, 0x12, 0x97, 0x3c, 0xa6, 0x88, 0x38,
	0x04, 0xd3, 0x35, 0x5e, 0xcb, 0x39, 0x3d, 0x0d, 0xc4, 0xa9, 0x2c, 0x61, 0xd2, 0xf3, 0x15, 0x79,
	0xad, 0x04, 0x61, 0x9a, 0xea, 0x62, 0x3c, 0x08, 0x2e, 0xfd, 0x48, 0x0c, 0xab, 0x4b, 0x2a, 0x3e,
	0x62, 0x80, 0x3d, 0x04, 0xf0, 0x9d, 0x30, 0xf4, 0xcf, 0x02, 0x27, 0x14, 0xd5, 0x65, 0x0a, 0xb2,
	0x04, 0x92, 0xf2, 0x60, 0x38, 0x38, 0x13, 0xc3, 0xc9, 0x48, 0x54, 0x75, 0x62, 0x9b, 0x7a, 0xd0,
	0x54, 0x38, 0xa6, 0x40, 0x38, 0x70, 0x46, 0xa2, 0xba, 0x42, 0xb6, 0xc8, 0x0d, 0xf9, 0x20, 0x72,
	0x07, 0xaf, 0x2e, 0xab, 0x4c, 0xf9, 0x80, 0x76, 0xec, 0x13, 0xc8, 0x9f, 0x62, 0x80, 0x57, 0xef,
	0xd0, 0xed, 0xd7, 0xe6, 0x6e, 0x4f, 0xe1, 0xcf, 0x25, 0x13, 0xd6, 0x6c, 0x5a, 0xd8, 0x62, 0x7c,
	0xe2, 0x05, 0x03, 0x31, 0xac, 0xae, 0x91, 0xb6, 0x0a, 0xa1, 0x86, 0x02, 0xf1, 0x3e, 0x03, 0xef,
	0xdc, 0x0f, 0x44, 0x88, 0x05, 0x6c, 0x9d, 0x58, 0x12, 0xc8, 0x3f, 0x9f, 0xcc, 0x35, 0x80, 0xab,
	0x57, 0x41, 0xbe, 0xb1, 0x37, 0x14, 0x61, 0x55, 0xdb, 0xcc, 0x22, 0x1f, 0x6d, 0x6a, 0xdf, 0x6b,
	0xb0, 0xcc, 0x27, 0x63, 0x6c, 0xc5, 0x66, 0xe4, 0x44, 0xa2, 0xeb, 0xf8, 0xec, 0x19, 0x54, 0x02,
	0x09, 0xd9, 0x21, 0x62, 0x24, 0x51, 0xde, 0xdd, 0x9d, 0x7f, 0xf3, 0xb4, 0x60, 0x6a, 0xaf, 0x42,
	0x2c, 0x48, 0x40, 0x78, 0xa3, 0x39, 0x96, 0xf7, 0xba, 0xd1, 0x6f, 0x8a, 0x50, 0x90, 0x3e, 0x99,
	0x1b, 0x0c, 0x1e, 0x43, 0x41, 0x8e, 0x0c, 0x24, 0x55, 0xbe, 0xa6, 0x52, 0xc8, 0xc2, 0xc6, 0x15,
	0xdb, 0xd5, 0x9b, 0x66, 0xdf, 0xe5, 0x4d, 0x37, 0xa0, 0x88, 0xed, 0xdd, 0x1b, 0x8f, 0x2e, 0xd5,
	0xb4, 0x30, 0xdd, 0xb3, 0x27, 0xb0, 0x30, 0x92, 0x05, 0x9a, 0x6a, 0x4a, 0xf9, 0x9a, 0xc6, 0x97,
	0x2a, 0xe3, 0x3c, 0x66, 0x67, 0x9f, 0x42, 0x7e, 0x80, 0xee, 0xa0, 0xaa, 0xf3, 0xe6, 0x96, 0x2d,
	0x19, 0xd9, 0x63, 0xc8, 0x85, 0xbe, 0x18, 0x50, 0xcd, 0xb9, 0x2e, 0x0d, 0xaf, 0x12, 0x9e, 0x13,
	0x23, 0x3a, 0x73, 0x12, 0x3a, 0xa7, 0x42, 0x75, 0x48, 0xb9, 0x49, 0xcf, 0x0b, 0xa5, 0x77, 0x9f,
	0x17, 0x12, 0x05, 0x19, 0xde, 0xad, 0x20, 0x7f, 0x8e, 0x29, 0xe5, 0x44, 0x93, 0x90, 0xca, 0xca,
	0xd2, 0xee, 0x83, 0x9b, 0x4c, 0x26, 0x26, 0xae, 0x98, 0xd9, 0x2e, 0xe4, 0x65, 0xec, 0x2d, 0x92,
	0xd4, 0xfd, 0x37, 0x48, 0x09, 0x2e, 0x59, 0xd9, 0x23, 0x28, 0x3b, 0x51, 0xe4, 0x60, 0x8a, 0xdb,
	0xde, 0x98, 0xaa, 0x4c, 0x89, 0x43, 0x0c, 0xf5, 0xc7, 0xac, 0x01, 0x4b, 0x53, 0x06, 0xa9, 0x7d,
	0xe9, 0x06, 0xed, 0x75, 0x62, 0x93, 0xda, 0x2b, 0xb1, 0x8c, 0x19, 0x9f, 0x32, 0x14, 0x17, 0xee,
	0x40, 0xd8, 0x34, 0x88, 0xaa, 0x3a, 0x24, 0xa1, 0x43, 0x1c, 0x47, 0x3f, 0x01, 0x16, 0x8a, 0xc1,
	0x24, 0x10, 0x76, 0x92, 0x2f, 0x2e, 0x44, 0x44, 0x69, 0x5e, 0x71, 0x4f, 0x8d, 0x96, 0x6c, 0x2b,
	0x94, 0x9c, 0xca, 0x68, 0x62, 0x38, 0x98, 0x32, 0xb8, 0xe3, 0x13, 0xaf, 0xca, 0x28, 0x17, 0x3f,
	0xbe, 0xc1, 0x1f, 0xca, 0xf0, 0xf6, 0xf8, 0xc4, 0x93, 0x09, 0xa8, 0x34, 0x21, 0xc0, 0xfe, 0x07,
	0x16, 0x13, 0x95, 0x3c, 0xac, 0xde, 0x26, 0x55, 0x6f, 0x2c, 0xe5, 0xe5, 0xab, 0x52, 0x1e, 0x32,
	0x63, 0xb6, 0x2e, 0xac, 0x92, 0x82, 0xcd, 0xb7, 0xd5, 0x85, 0x74, 0x15, 0xc0, 0x88, 0x14, 0x41,
	0xe0, 0x05, 0x54, 0x4c, 0x4b, 0x5c, 0x6e, 0x36, 0xfe, 0x1b, 0x96, 0x67, 0x6c, 0x7f, 0xaf, 0xca,
	0xf0, 0xdb, 0x0c, 0xe4, 0x51, 0x7d, 0x88, 0x3c, 0x98, 0x99, 0x21, 0xc9, 0xe5, 0xb8, 0xdc, 0xb0,
	0x75, 0x58, 0xc0, 0x85, 0x7d, 0x1e, 0xaa, 0xf9, 0xa2, 0x80, 0xdb, 0x6e, 0x88, 0x03, 0x03, 0x11,
	0x5e, 0x5e, 0x46, 0x22, 0xa4, 0x5a, 0x90, 0xe3, 0x25, 0x44, 0xf6, 0x10, 0xc0, 0x8e, 0x40, 0x33,
	0x7f, 0x48, 0x59, 0x9f, 0xe3, 0x6a, 0x87, 0x83, 0x04, 0xad, 0x50, 0xa1, 0xfc, 0x4e, 0x58, 0xa0,
	0x7d, 0x37, 0xc4, 0x17, 0x95, 0x24, 0xa9, 0xb2, 0x40, 0x54, 0x20, 0x48, 0xea, 0x7c, 0x04, 0x65,
	0x39, 0x3d, 0x9c, 0x62, 0xa5, 0x57, 0x33, 0x2d, 0xd0, 0x88, 0x40, 0x08, 0xbb, 0x0d, 0x79, 0xd7,
	0x43, 0xcd, 0xc5, 0xf8, 0x0b, 0x44, 0x1a, 0x4a, 0x0a, 0x6d, 0xfa, 0x46, 0x90, 0xdf, 0x0d, 0x25,
	0x42, 0x70, 0x00, 0x26, 0xa5, 0x6a, 0x3c, 0x40, 0x49, 0x50, 0x4a, 0x15, 0xd4, 0x0d, 0x6b, 0x7f,
	0xce, 0x40, 0xbe, 0x3e, 0x12, 0x41, 0x94, 0x28, 0x9d, 0x59, 0x2a, 0x9d, 0x5f, 0xe2, 0xe7, 0xcb,
	0x85, 0x08, 0xdc, 0xe8, 0x52, 0x0d, 0xfa, 0xf3, 0x49, 0x6a, 0x2a, 0x06, 0xca, 0xed, 0x29, 0x3b,
	0x1a, 0xe5, 0xa0, 0x4e, 0x3b, 0xba, 0xf4, 0x05, 0x79, 0x2f, 0xcb, 0x4b, 0x84, 0x20, 0x23, 0xab,
	0xc2, 0xc2, 0xb9, 0x08, 0xa9, 0xfc, 0xc8, 0xb9, 0x3e, 0xde, 0xb2, 0x27, 0x50, 0x9a, 0x7e, 0xfe,
	0xa9, 0xaa, 0xf9, 0xa6, 0x02, 0x74, 0xc5, 0x8c, 0x17, 0x0d, 0xd4, 0xd7, 0xa1, 0xed, 0x0e, 0xc9,
	0xbd, 0x25, 0x1c, 0x39, 0x24, 0xd4, 0xa6, 0xeb, 0xc4, 0x3b, 0x35, 0x9a, 0x3d, 0xb8, 0x26, 0xc4,
	0x25, 0x83, 0xbc, 0x4e, 0xcc, 0x8e, 0xf6, 0x0e, 0x46, 0x82, 0x86, 0x20, 0x39, 0x9d, 0xc5, 0x5b,
	0x8c, 0xc5, 0x28, 0x1a, 0x29, 0xb7, 0xe3, 0x12, 0xaf, 0x3e, 0x19, 0xbb, 0xaf, 0x27, 0xc2, 0x8e,
	0x9c, 0x53, 0xf2, 0x77, 0x89, 0x97, 0x24, 0x62, 0x39, 0xa7, 0xb5, 0x2f, 0xa0, 0x40, 0xde, 0x0e,
	0xb1, 0xd1, 0x90, 0x47, 0x54, 0x1b, 0x9d, 0x6f, 0x34, 0xc4, 0xc7, 0x25, 0x53, 0xed, 0x77, 0x1a,
	0xdc, 0x96, 0xb9, 0xdc, 0x08, 0x04, 0x96, 0x1f, 0xf1, 0x7a, 0x22, 0xc2, 0x28, 0xd9, 0x64, 0xb4,
	0xf7, 0x6b, 0x32, 0xef, 0xdd, 0x19, 0xe3, 0x1e, 0x93, 0x7d, 0xc7, 0x1e, 0x53, 0xfb, 0x08, 0x96,
	0x24, 0xc6, 0x45, 0xe8, 0x7b, 0xe3, 0x30, 0x91, 0xe3, 0x5a, 0x22, 0xc7, 0x6b, 0x3e, 0xac, 0xa6,
	0xaf, 0xa6, 0xb8, 0x67, 0x7b, 0xf9, 0x01, 0x2c, 0xab, 0xf1, 0x36, 0x50, 0x2c, 0xca, 0xf4, 0x47,
	0x37, 0xd8, 0x12, 0x6b, 0xe2, 0x4b, 0x17, 0xa9, 0x7d, 0xed, 0x6f, 0x5a, 0x3c, 0x44, 0x51, 0xed,
	0xa9, 0x0f, 0x70, 0xd8, 0x64, 0x4f, 0xa1, 0x20, 0xcb, 0x22, 0x9d, 0xb9, 0xb4, 0x5b, 0xbb, 0x41,
	0xad, 0x64, 0x3f, 0x74, 0x02, 0xe7, 0x9c, 0x2b, 0x09, 0xf6, 0x04, 0xf2, 0xe7, 0xde, 0x64, 0x1c,
	0xa9, 0x4c, 0x79, 0x17, 0x51, 0x29, 0x80, 0x01, 0x43, 0x0b, 0x59, 0xe8, 0xb3, 0x32, 0x60, 0x08,
	0x89, 0x1b, 0x41, 0xb2, 0x5f, 0xe4, 0xe6, 0xfa, 0xca, 0x2e, 0xdc, 0x99, 0x8c, 0xa5, 0x86, 0x97,
	0xe2, 0xc4, 0xa3, 0xfe, 0x42, 0x97, 0xc8, 0x53, 0xa8, 0xde, 0x56, 0xc4, 0x3d, 0xa2, 0x35, 0x89,
	0x54, 0xfb, 0x43, 0x06, 0x74, 0x75, 0x7f, 0x11, 0xfd, 0x10, 0xa1, 0x24, 0x23, 0x23, 0xf3, 0xae,
	0xd3, 0x07, 0x7a, 0x9a, 0x3c, 0xa1, 0x82, 0xa9, 0xf6, 0xa6, 0x3e, 0x2e, 0x7d, 0xc6, 0x95, 0x04,
	0x3b, 0x80, 0x05, 0xcf, 0xc7, 0x15, 0xd6, 0x5e, 0xcc, 0x9c, 0x9d, 0x9b, 0x84, 0xa7, 0x57, 0xdb,
	0xe9, 0x4b, 0x01, 0xd9, 0xfb, 0x62, 0xf1, 0x8d, 0xa7, 0xb0, 0x98, 0x24, 0xbc, 0x57, 0x63, 0xf9,
	0xc5, 0x55, 0x04, 0xe1, 0x31, 0x2a, 0x62, 0x1f, 0x43, 0x41, 0x46, 0x9a, 0xf2, 0xe0, 0xfa, 0x4d,
	0x81, 0xa9, 0xd8, 0x7e, 0xc0, 0x90, 0xbe, 0x84, 0x15, 0x73, 0xec, 0xf8, 0xe9, 0xea, 0x30, 0x9b,
	0x41, 0x89, 0x27, 0xce, 0xbc, 0xdf, 0x13, 0x27, 0x07, 0xdd, 0x6c, 0x7a, 0xd0, 0xad, 0xbd, 0x06,
	0x96, 0x3c, 0x5a, 0xf9, 0xe2, 0x47, 0xb0, 0xa6, 0xae, 0x36, 0x20, 0xc2, 0xd5, 0x0d, 0xa5, 0x6f,
	0x3e, 0xbc, 0xe1, 0xe8, 0xb4, 0x1a, 0xbe, 0x7a, 0x71, 0x0d, 0x5a, 0x8b, 0xe2, 0x1f, 0x10, 0x68,
	0x82, 0xb9, 0x07, 0x25, 0x75, 0xd4, 0xf4, 0xb6, 0x45, 0x09, 0xb4, 0xaf, 0xff, 0x69, 0xf0, 0x73,
	0x58, 0x50, 0x07, 0xbf, 0x4b, 0x35, 0x8b, 0x79, 0x6b, 0x43, 0x60, 0xfb, 0x81, 0xe3, 0x9f, 0x35,
	0x03, 0xf7, 0x42, 0x04, 0x8d, 0x33, 0x67, 0x7c, 0x2a, 0xc2, 0xe9, 0x01, 0x5a, 0xe2, 0x80, 0xa7,
	0x90, 0x7b, 0xe5, 0x8e, 0x87, 0xaa, 0x1a, 0x7c, 0x74, 0xcd, 0x47, 0xc4, 0x8c, 0x1a, 0xea, 0x38,
	0x24, 0x53, 0xfb, 0x18, 0x96, 0x1b, 0xa3, 0x49, 0x18, 0x89, 0xe0, 0x2d, 0x75, 0xf3, 0xd7, 0x1a,
	0x54, 0x30, 0x39, 0x2e, 0xa6, 0xef, 0x7d, 0x00, 0x45, 0x2e, 0x5e, 0x8b, 0x30, 0xfa, 0xea, 0x58,
	0xb5, 0x95, 0x4f, 0xe6, 0xdb, 0x4a, 0x52, 0x62, 0x27, 0x66, 0x97, 0xa9, 0x51, 0x0c, 0xd4, 0x76,
	0xe3, 0x3f, 0xa1, 0x92, 0x22, 0x25, 0x93, 0x23, 0xfb, 0xb6, 0xe4, 0xf8, 0x16, 0x96, 0x52, 0xa7,
	0x84, 0xac, 0x06, 0x8b, 0x6a, 0xdd, 0xa0, 0x2a, 0x29, 0xd5, 0x2c, 0x06, 0x09, 0x8c, 0x35, 0x67,
	0x6e, 0xa3, 0x7e, 0xfc, 0x7a, 0xf8, 0xe6, 0x1b, 0xf0, 0x8a, 0x93, 0xdc, 0x6e, 0xff, 0x31, 0x03,
	0x05, 0xf9, 0xd1, 0xc0, 0x96, 0xa1, 0x6c, 0x5a, 0x75, 0xeb, 0xc8, 0xb4, 0x7b, 0xfd, 0x9e, 0xa1,
	0xdf, 0x4a, 0x00, 0xed, 0x5e, 0xdb, 0xd2, 0x35, 0x56, 0x81, 0x92, 0x02, 0xfa, 0x5f, 0xe9, 0x19,
	0xc6, 0x60, 0x29, 0xde, 0xb6, 0x5a, 0x9d, 0x76, 0xcf, 0xd0, 0xb3, 0x4c, 0x87, 0x45, 0x85, 0x19,
	0x9c, 0xf7, 0xb9, 0x9e, 0x63, 0x55, 0x58, 0x9d, 0xaa, 0xb5, 0xec, 0x76, 0xcf, 0xfe, 0xfa, 0xa8,
	0xcf, 0x8f, 0xba, 0x7a, 0x9e, 0xad, 0xc3, 0x6d, 0x45, 0x69, 0x1a, 0x8d, 0x7e, 0xb7, 0xdb, 0x36,
	0xcd, 0x76, 0xbf, 0xa7, 0x17, 0xd8, 0x1a, 0x30, 0x45, 0xe8, 0xd6, 0xdb, 0x3d, 0xcb, 0xe8, 0xd5,
	0x7b, 0x0d, 0x43, 0x5f, 0x48, 0x08, 0x98, 0x56, 0x9f, 0xd7, 0xf7, 0x0d, 0xbb, 0xd9, 0x7f, 0xd6,
	0xd3, 0x8b, 0xec, 0x1e, 0xac, 0xcf, 0x12, 0x8c, 0x7d, 0x5e, 0x6f, 0x1a, 0x4d, 0xbd, 0x94, 0x90,
	0xea, 0x19, 0x46, 0xd3, 0xb4, 0xb9, 0xb1, 0xd7, 0xef, 0x5b, 0x3a, 0xb0, 0xfb, 0x50, 0x9d, 0x91,
	0xe2, 0xc6, 0x5e, 0xbd, 0x43, 0x87, 0x95, 0xd9, 0x26, 0xdc, 0x9f, 0xd5, 0xc9, 0xdb, 0xc7, 0xc8,
	0x73, 0xd8, 0xa9, 0x37, 0x0c, 0x7d, 0x91, 0x2d, 0x01, 0x4c, 0xcd, 0x7c, 0xae, 0x57, 0xb6, 0xbf,
	0xd3, 0x00, 0x64, 0x90, 0xd2, 0xd8, 0xb6, 0x0a, 0x3a, 0x49, 0x70, 0xdb, 0x7a, 0x71, 0x68, 0xc4,
	0x4e, 0x9d, 0x41, 0x5b, 0xed, 0x8e, 0xa1, 0x6b, 0xec, 0x0e, 0xac, 0x24, 0xd1, 0xbd, 0x4e, 0xbf,
	0x81, 0x1e, 0x5e, 0x03, 0x96, 0x84, 0xfb, 0x7b, 0xff, 0x6f, 0x34, 0x2c, 0x3d, 0xcb, 0xee, 0xc2,
	0x9d, 0x24, 0xde, 0xe8, 0x1c, 0x99, 0x96, 0xc1, 0x8d, 0xa6, 0x9e, 0x9b, 0xd5, 0xb4, 0xcf, 0xeb,
	0x87, 0x07, 0x7a, 0x7e, 0xfb, 0x57, 0x1a, 0x14, 0xe4, 0x37, 0x25, 0x3e, 0x51, 0xcb, 0x4c, 0xd9,
	0xb4, 0x02, 0x95, 0x18, 0xd9, 0xb3, 0x78, 0xcb, 0xd4, 0xb5, 0x24, 0x93, 0xf1, 0xdc, 0xfa, 0x4c,
	0xcf, 0x24, 0x91, 0xd6, 0x91, 0x89, 0x6f, 0xbd, 0x0c, 0xe5, 0xa9, 0xa2, 0x96, 0xa9, 0xe7, 0x92,
	0xc0, 0x71, 0xcb, 0xd4, 0xf3, 0x49, 0xe0, 0x79, 0xcb, 0xd4, 0x0b, 0x49, 0xe0, 0x9b, 0x96, 0xa9,
	0x2f, 0x6c, 0x7f, 0xaf, 0xc1, 0x9d, 0x6b, 0xb3, 0x9b, 0x7d, 0x00, 0x0f, 0xc8, 0x78, 0x5b, 0x5d,
	0xa7, 0x71, 0x50, 0xef, 0xed, 0x1b, 0x29, 0xbb, 0x3f, 0x84, 0x0f, 0x6e, 0x64, 0xe9, 0xf6, 0x9b,
	0xed, 0x56, 0xdb, 0x68, 0xea, 0x1a, 0xab, 0xc1, 0xc3, 0x1b, 0xd9, 0xea, 0x4d, 0x0c, 0x92, 0x0c,
	0xfb, 0x17, 0xd8, 0xbc, 0x91, 0xa7, 0x69, 0x74, 0x0c, 0xcb, 0x68, 0xea, 0xd9, 0xed, 0x08, 0x16,
	0x93, 0x23, 0x3c, 0x05, 0xaa, 0x71, 0x6c, 0xf0, 0xb6, 0xf5, 0x22, 0x65, 0x18, 0x86, 0x5c, 0x0a,
	0xaf, 0x77, 0xea, 0xbc, 0xab, 0x6b, 0xf8, 0x70, 0x69, 0xc2, 0xb3, 0x3a, 0xef, 0xb5, 0x7b, 0xfb,
	0x7a, 0x86, 0xf2, 0x64, 0x46, 0x97, 0xd5, 0x6e, 0xbd, 0xd0, 0xb3, 0xdb, 0x3f, 0xd7, 0xb0, 0x1c,
	0x5c, 0x8d, 0xda, 0x78, 0x2c, 0x37, 0xcc, 0xfe, 0x11, 0x6f, 0xa4, 0xfd, 0x51, 0x85, 0xd5, 0x34,
	0x7e, 0xdc, 0xef, 0x1c, 0x75, 0x31, 0xbe, 0xae, 0x91, 0x68, 0x1a, 0x7a, 0x06, 0xed, 0x49, 0xe3,
	0x2a, 0x94, 0xf4, 0x2c, 0xde, 0x21, 0x4d, 0x22, 0xcf, 0xe8, 0xb9, 0xed, 0x9f, 0x69, 0xb0, 0x4c,
	0xc3, 0xb6, 0x9c, 0x34, 0xc8, 0xa2, 0x0d, 0x58, 0xab, 0x77, 0x0c, 0x6e, 0xd9, 0xf5, 0x86, 0xd5,
	0xee, 0xf7, 0x52, 0x56, 0xdd, 0x87, 0xea, 0x3c, 0x4d, 0xfa, 0x54, 0xd7, 0xae, 0xa7, 0x36, 0xb8,
	0x51, 0xb7, 0xd0, 0xbe, 0x6b, 0xa9, 0x47, 0x87, 0x4d, 0xa4, 0x66, 0xb7, 0x7f, 0x12, 0x0f, 0x15,
	0x89, 0x39, 0x11, 0x45, 0xe4, 0xb5, 0x63, 0x99, 0xc3, 0x3a, 0xaf, 0x77, 0x63, 0x63, 0xee, 0xc1,
	0xfa, 0x75, 0xd4, 0x7e, 0xab, 0xa5, 0x6b, 0x78, 0x8b, 0x6b, 0x89, 0x3d, 0x3d, 0xb3, 0xbd, 0x0b,
	0x0b, 0xea, 0xc7, 0x6b, 0x56, 0x84, 0x9c, 0xd2, 0xb6, 0x00, 0xd9, 0x4e, 0xff, 0x99, 0xae, 0x31,
	0x80, 0x42, 0xd7, 0x68, 0xb6, 0x8f, 0xba, 0x7a, 0x06, 0xc9, 0x07, 0xed, 0xfd, 0x03, 0xb2, 0xaf,
	0x34, 0xfd, 0xf5, 0x1a, 0x5d, 0xdd, 0xee, 0xdb, 0x87, 0xbc, 0x8f, 0x29, 0x6f, 0x9b, 0xc6, 0xd7,
	0x47, 0x46, 0xcf, 0x6a, 0xd7, 0x3b, 0xfa, 0x2d, 0xcc, 0xd9, 0x04, 0x89, 0xd7, 0x7b, 0xcd, 0x3e,
	0x06, 0xcb, 0x0a, 0x54, 0x12, 0x70, 0x73, 0x4f, 0x06, 0x49, 0x0a, 0xb2, 0xb9, 0xd1, 0xed, 0x93,
	0x2f, 0xbe, 0xcb, 0x40, 0x39, 0x31, 0x05, 0xa2, 0x4e, 0x75, 0x17, 0xac, 0x51, 0xc9, 0x10, 0x49,
	0xc1, 0x87, 0x46, 0xaf, 0x89, 0xf1, 0x97, 0xbc, 0xbc, 0xa4, 0xd4, 0x8f, 0xeb, 0xed, 0x4e, 0x7d,
	0xaf, 0xa3, 0xc2, 0x24, 0x4d, 0xb3, 0xac, 0x7a, 0xe3, 0x00, 0x53, 0x62, 0x8e, 0xd4, 0x34, 0x14,
	0x29, 0x97, 0xf0, 0xf5, 0x15, 0xc9, 0x6a, 0x1c, 0xe0, 0x71, 0x79, 0x8c, 0xc8, 0x14, 0x51, 0xb6,
	0x8b, 0xc2, 0x9c, 0x81, 0x71, 0xf2, 0x2d, 0xb0, 0x87, 0xb0, 0x91, 0xa2, 0x58, 0xfc, 0x85, 0x3a,
	0x0d, 0x35, 0x16, 0xe7, 0x24, 0xb9, 0x81, 0x85, 0xdb, 0xd0, 0x4b, 0xdb, 0xbf, 0xd4, 0x60, 0x31,
	0xf9, 0xfb, 0xd8, 0xcc, 0xe1, 0x57, 0x1d, 0xef, 0x01, 0xdc, 0x9d, 0xc5, 0x2d, 0xfb, 0x90, 0x1b,
	0xa6, 0xd1, 0xc3, 0xfe, 0xb7, 0x0a, 0x7a, 0x9a, 0x7c, 0x74, 0x28, 0x8b, 0x74, 0x1a, 0xa5, 0xa6,
	0x94, 0x9d, 0x71, 0x28, 0x75, 0x39, 0xd5, 0x93, 0x72, 0xdb, 0x3f, 0x86, 0x4a, 0xea, 0x5f, 0x3c,
	0xd9, 0xc1, 0x64, 0x9b, 0x91, 0x81, 0x64, 0x77, 0xeb, 0xfb, 0x3d, 0xc3, 0x6a, 0x37, 0xf4, 0x5b,
	0xb2, 0x1f, 0xa6, 0x88, 0xa6, 0x89, 0x85, 0x8d, 0x3a, 0x5b, 0x0a, 0xef, 0x1d, 0x77, 0x0d, 0x3d,
	0xb3, 0xbd, 0x05, 0x15, 0x35, 0x13, 0xf5, 0xbc, 0xc8, 0x3d, 0xb9, 0x44, 0x4e, 0x95, 0xd9, 0xaa,
	0xac, 0x48, 0x23, 0x6f, 0x6d, 0x0b, 0x28, 0x27, 0x7e, 0xa5, 0xc3, 0xd7, 0x94, 0x6f, 0x1b, 0xbf,
	0xca, 0x73, 0xcb, 0xe0, 0x3d, 0x0a, 0xd2, 0x59, 0x12, 0x36, 0x66, 0x22, 0x69, 0xd8, 0x2a, 0xaf,
	0x25, 0xd9, 0xe6, 0xb3, 0xb6, 0xd5, 0x38, 0xd0, 0x33, 0x7b, 0xf7, 0xe1, 0xf6, 0xc0, 0x3b, 0x9f,
	0x1d, 0x4d, 0x0e, 0xb5, 0x6f, 0xb2, 0x8e, 0xef, 0xbe, 0x2c, 0xd0, 0x6f, 0x15, 0xff, 0xfe, 0xf7,
	0x00, 0x00, 0x00, 0xff, 0xff, 0xcd, 0xbf, 0x37, 0x4d, 0xfc, 0x1e, 0x00, 0x00,
}
