/*
Copyright 2021 Google LLC

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

https://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// This file was generated by "go run gen/main.go > gen.go". Do not edit
// directly.

package cloud

import (
	"context"
	"fmt"
	"net/http"
	"sync"

	"google.golang.org/api/googleapi"
	"k8s.io/klog/v2"

	"github.com/GoogleCloudPlatform/k8s-cloud-provider/pkg/cloud/filter"
	"github.com/GoogleCloudPlatform/k8s-cloud-provider/pkg/cloud/meta"

	alpha "google.golang.org/api/compute/v0.alpha"
	beta "google.golang.org/api/compute/v0.beta"
	ga "google.golang.org/api/compute/v1"
)

// Cloud is an interface for the GCE compute API.
type Cloud interface {
	Addresses() Addresses
	AlphaAddresses() AlphaAddresses
	BetaAddresses() BetaAddresses
	AlphaGlobalAddresses() AlphaGlobalAddresses
	BetaGlobalAddresses() BetaGlobalAddresses
	GlobalAddresses() GlobalAddresses
	BackendServices() BackendServices
	BetaBackendServices() BetaBackendServices
	AlphaBackendServices() AlphaBackendServices
	RegionBackendServices() RegionBackendServices
	AlphaRegionBackendServices() AlphaRegionBackendServices
	BetaRegionBackendServices() BetaRegionBackendServices
	Disks() Disks
	RegionDisks() RegionDisks
	AlphaFirewalls() AlphaFirewalls
	BetaFirewalls() BetaFirewalls
	Firewalls() Firewalls
	ForwardingRules() ForwardingRules
	AlphaForwardingRules() AlphaForwardingRules
	BetaForwardingRules() BetaForwardingRules
	AlphaGlobalForwardingRules() AlphaGlobalForwardingRules
	BetaGlobalForwardingRules() BetaGlobalForwardingRules
	GlobalForwardingRules() GlobalForwardingRules
	HealthChecks() HealthChecks
	AlphaHealthChecks() AlphaHealthChecks
	BetaHealthChecks() BetaHealthChecks
	AlphaRegionHealthChecks() AlphaRegionHealthChecks
	BetaRegionHealthChecks() BetaRegionHealthChecks
	RegionHealthChecks() RegionHealthChecks
	HttpHealthChecks() HttpHealthChecks
	HttpsHealthChecks() HttpsHealthChecks
	InstanceGroups() InstanceGroups
	Instances() Instances
	BetaInstances() BetaInstances
	AlphaInstances() AlphaInstances
	AlphaNetworks() AlphaNetworks
	BetaNetworks() BetaNetworks
	Networks() Networks
	AlphaNetworkEndpointGroups() AlphaNetworkEndpointGroups
	BetaNetworkEndpointGroups() BetaNetworkEndpointGroups
	NetworkEndpointGroups() NetworkEndpointGroups
	Projects() Projects
	Regions() Regions
	AlphaRouters() AlphaRouters
	BetaRouters() BetaRouters
	Routers() Routers
	Routes() Routes
	BetaSecurityPolicies() BetaSecurityPolicies
	BetaServiceAttachments() BetaServiceAttachments
	AlphaServiceAttachments() AlphaServiceAttachments
	SslCertificates() SslCertificates
	BetaSslCertificates() BetaSslCertificates
	AlphaSslCertificates() AlphaSslCertificates
	AlphaRegionSslCertificates() AlphaRegionSslCertificates
	BetaRegionSslCertificates() BetaRegionSslCertificates
	RegionSslCertificates() RegionSslCertificates
	SslPolicies() SslPolicies
	AlphaSubnetworks() AlphaSubnetworks
	BetaSubnetworks() BetaSubnetworks
	Subnetworks() Subnetworks
	AlphaTargetHttpProxies() AlphaTargetHttpProxies
	BetaTargetHttpProxies() BetaTargetHttpProxies
	TargetHttpProxies() TargetHttpProxies
	AlphaRegionTargetHttpProxies() AlphaRegionTargetHttpProxies
	BetaRegionTargetHttpProxies() BetaRegionTargetHttpProxies
	RegionTargetHttpProxies() RegionTargetHttpProxies
	TargetHttpsProxies() TargetHttpsProxies
	AlphaTargetHttpsProxies() AlphaTargetHttpsProxies
	BetaTargetHttpsProxies() BetaTargetHttpsProxies
	AlphaRegionTargetHttpsProxies() AlphaRegionTargetHttpsProxies
	BetaRegionTargetHttpsProxies() BetaRegionTargetHttpsProxies
	RegionTargetHttpsProxies() RegionTargetHttpsProxies
	TargetPools() TargetPools
	AlphaTargetTcpProxies() AlphaTargetTcpProxies
	BetaTargetTcpProxies() BetaTargetTcpProxies
	AlphaUrlMaps() AlphaUrlMaps
	BetaUrlMaps() BetaUrlMaps
	UrlMaps() UrlMaps
	AlphaRegionUrlMaps() AlphaRegionUrlMaps
	BetaRegionUrlMaps() BetaRegionUrlMaps
	RegionUrlMaps() RegionUrlMaps
	Zones() Zones
}

// NewGCE returns a GCE.
func NewGCE(s *Service) *GCE {
	g := &GCE{
		gceAddresses:                     &GCEAddresses{s},
		gceAlphaAddresses:                &GCEAlphaAddresses{s},
		gceBetaAddresses:                 &GCEBetaAddresses{s},
		gceAlphaGlobalAddresses:          &GCEAlphaGlobalAddresses{s},
		gceBetaGlobalAddresses:           &GCEBetaGlobalAddresses{s},
		gceGlobalAddresses:               &GCEGlobalAddresses{s},
		gceBackendServices:               &GCEBackendServices{s},
		gceBetaBackendServices:           &GCEBetaBackendServices{s},
		gceAlphaBackendServices:          &GCEAlphaBackendServices{s},
		gceRegionBackendServices:         &GCERegionBackendServices{s},
		gceAlphaRegionBackendServices:    &GCEAlphaRegionBackendServices{s},
		gceBetaRegionBackendServices:     &GCEBetaRegionBackendServices{s},
		gceDisks:                         &GCEDisks{s},
		gceRegionDisks:                   &GCERegionDisks{s},
		gceAlphaFirewalls:                &GCEAlphaFirewalls{s},
		gceBetaFirewalls:                 &GCEBetaFirewalls{s},
		gceFirewalls:                     &GCEFirewalls{s},
		gceForwardingRules:               &GCEForwardingRules{s},
		gceAlphaForwardingRules:          &GCEAlphaForwardingRules{s},
		gceBetaForwardingRules:           &GCEBetaForwardingRules{s},
		gceAlphaGlobalForwardingRules:    &GCEAlphaGlobalForwardingRules{s},
		gceBetaGlobalForwardingRules:     &GCEBetaGlobalForwardingRules{s},
		gceGlobalForwardingRules:         &GCEGlobalForwardingRules{s},
		gceHealthChecks:                  &GCEHealthChecks{s},
		gceAlphaHealthChecks:             &GCEAlphaHealthChecks{s},
		gceBetaHealthChecks:              &GCEBetaHealthChecks{s},
		gceAlphaRegionHealthChecks:       &GCEAlphaRegionHealthChecks{s},
		gceBetaRegionHealthChecks:        &GCEBetaRegionHealthChecks{s},
		gceRegionHealthChecks:            &GCERegionHealthChecks{s},
		gceHttpHealthChecks:              &GCEHttpHealthChecks{s},
		gceHttpsHealthChecks:             &GCEHttpsHealthChecks{s},
		gceInstanceGroups:                &GCEInstanceGroups{s},
		gceInstances:                     &GCEInstances{s},
		gceBetaInstances:                 &GCEBetaInstances{s},
		gceAlphaInstances:                &GCEAlphaInstances{s},
		gceAlphaNetworks:                 &GCEAlphaNetworks{s},
		gceBetaNetworks:                  &GCEBetaNetworks{s},
		gceNetworks:                      &GCENetworks{s},
		gceAlphaNetworkEndpointGroups:    &GCEAlphaNetworkEndpointGroups{s},
		gceBetaNetworkEndpointGroups:     &GCEBetaNetworkEndpointGroups{s},
		gceNetworkEndpointGroups:         &GCENetworkEndpointGroups{s},
		gceProjects:                      &GCEProjects{s},
		gceRegions:                       &GCERegions{s},
		gceAlphaRouters:                  &GCEAlphaRouters{s},
		gceBetaRouters:                   &GCEBetaRouters{s},
		gceRouters:                       &GCERouters{s},
		gceRoutes:                        &GCERoutes{s},
		gceBetaSecurityPolicies:          &GCEBetaSecurityPolicies{s},
		gceBetaServiceAttachments:        &GCEBetaServiceAttachments{s},
		gceAlphaServiceAttachments:       &GCEAlphaServiceAttachments{s},
		gceSslCertificates:               &GCESslCertificates{s},
		gceBetaSslCertificates:           &GCEBetaSslCertificates{s},
		gceAlphaSslCertificates:          &GCEAlphaSslCertificates{s},
		gceAlphaRegionSslCertificates:    &GCEAlphaRegionSslCertificates{s},
		gceBetaRegionSslCertificates:     &GCEBetaRegionSslCertificates{s},
		gceRegionSslCertificates:         &GCERegionSslCertificates{s},
		gceSslPolicies:                   &GCESslPolicies{s},
		gceAlphaSubnetworks:              &GCEAlphaSubnetworks{s},
		gceBetaSubnetworks:               &GCEBetaSubnetworks{s},
		gceSubnetworks:                   &GCESubnetworks{s},
		gceAlphaTargetHttpProxies:        &GCEAlphaTargetHttpProxies{s},
		gceBetaTargetHttpProxies:         &GCEBetaTargetHttpProxies{s},
		gceTargetHttpProxies:             &GCETargetHttpProxies{s},
		gceAlphaRegionTargetHttpProxies:  &GCEAlphaRegionTargetHttpProxies{s},
		gceBetaRegionTargetHttpProxies:   &GCEBetaRegionTargetHttpProxies{s},
		gceRegionTargetHttpProxies:       &GCERegionTargetHttpProxies{s},
		gceTargetHttpsProxies:            &GCETargetHttpsProxies{s},
		gceAlphaTargetHttpsProxies:       &GCEAlphaTargetHttpsProxies{s},
		gceBetaTargetHttpsProxies:        &GCEBetaTargetHttpsProxies{s},
		gceAlphaRegionTargetHttpsProxies: &GCEAlphaRegionTargetHttpsProxies{s},
		gceBetaRegionTargetHttpsProxies:  &GCEBetaRegionTargetHttpsProxies{s},
		gceRegionTargetHttpsProxies:      &GCERegionTargetHttpsProxies{s},
		gceTargetPools:                   &GCETargetPools{s},
		gceAlphaTargetTcpProxies:         &GCEAlphaTargetTcpProxies{s},
		gceBetaTargetTcpProxies:          &GCEBetaTargetTcpProxies{s},
		gceAlphaUrlMaps:                  &GCEAlphaUrlMaps{s},
		gceBetaUrlMaps:                   &GCEBetaUrlMaps{s},
		gceUrlMaps:                       &GCEUrlMaps{s},
		gceAlphaRegionUrlMaps:            &GCEAlphaRegionUrlMaps{s},
		gceBetaRegionUrlMaps:             &GCEBetaRegionUrlMaps{s},
		gceRegionUrlMaps:                 &GCERegionUrlMaps{s},
		gceZones:                         &GCEZones{s},
	}
	return g
}

// GCE implements Cloud.
var _ Cloud = (*GCE)(nil)

// GCE is the golang adapter for the compute APIs.
type GCE struct {
	gceAddresses                     *GCEAddresses
	gceAlphaAddresses                *GCEAlphaAddresses
	gceBetaAddresses                 *GCEBetaAddresses
	gceAlphaGlobalAddresses          *GCEAlphaGlobalAddresses
	gceBetaGlobalAddresses           *GCEBetaGlobalAddresses
	gceGlobalAddresses               *GCEGlobalAddresses
	gceBackendServices               *GCEBackendServices
	gceBetaBackendServices           *GCEBetaBackendServices
	gceAlphaBackendServices          *GCEAlphaBackendServices
	gceRegionBackendServices         *GCERegionBackendServices
	gceAlphaRegionBackendServices    *GCEAlphaRegionBackendServices
	gceBetaRegionBackendServices     *GCEBetaRegionBackendServices
	gceDisks                         *GCEDisks
	gceRegionDisks                   *GCERegionDisks
	gceAlphaFirewalls                *GCEAlphaFirewalls
	gceBetaFirewalls                 *GCEBetaFirewalls
	gceFirewalls                     *GCEFirewalls
	gceForwardingRules               *GCEForwardingRules
	gceAlphaForwardingRules          *GCEAlphaForwardingRules
	gceBetaForwardingRules           *GCEBetaForwardingRules
	gceAlphaGlobalForwardingRules    *GCEAlphaGlobalForwardingRules
	gceBetaGlobalForwardingRules     *GCEBetaGlobalForwardingRules
	gceGlobalForwardingRules         *GCEGlobalForwardingRules
	gceHealthChecks                  *GCEHealthChecks
	gceAlphaHealthChecks             *GCEAlphaHealthChecks
	gceBetaHealthChecks              *GCEBetaHealthChecks
	gceAlphaRegionHealthChecks       *GCEAlphaRegionHealthChecks
	gceBetaRegionHealthChecks        *GCEBetaRegionHealthChecks
	gceRegionHealthChecks            *GCERegionHealthChecks
	gceHttpHealthChecks              *GCEHttpHealthChecks
	gceHttpsHealthChecks             *GCEHttpsHealthChecks
	gceInstanceGroups                *GCEInstanceGroups
	gceInstances                     *GCEInstances
	gceBetaInstances                 *GCEBetaInstances
	gceAlphaInstances                *GCEAlphaInstances
	gceAlphaNetworks                 *GCEAlphaNetworks
	gceBetaNetworks                  *GCEBetaNetworks
	gceNetworks                      *GCENetworks
	gceAlphaNetworkEndpointGroups    *GCEAlphaNetworkEndpointGroups
	gceBetaNetworkEndpointGroups     *GCEBetaNetworkEndpointGroups
	gceNetworkEndpointGroups         *GCENetworkEndpointGroups
	gceProjects                      *GCEProjects
	gceRegions                       *GCERegions
	gceAlphaRouters                  *GCEAlphaRouters
	gceBetaRouters                   *GCEBetaRouters
	gceRouters                       *GCERouters
	gceRoutes                        *GCERoutes
	gceBetaSecurityPolicies          *GCEBetaSecurityPolicies
	gceBetaServiceAttachments        *GCEBetaServiceAttachments
	gceAlphaServiceAttachments       *GCEAlphaServiceAttachments
	gceSslCertificates               *GCESslCertificates
	gceBetaSslCertificates           *GCEBetaSslCertificates
	gceAlphaSslCertificates          *GCEAlphaSslCertificates
	gceAlphaRegionSslCertificates    *GCEAlphaRegionSslCertificates
	gceBetaRegionSslCertificates     *GCEBetaRegionSslCertificates
	gceRegionSslCertificates         *GCERegionSslCertificates
	gceSslPolicies                   *GCESslPolicies
	gceAlphaSubnetworks              *GCEAlphaSubnetworks
	gceBetaSubnetworks               *GCEBetaSubnetworks
	gceSubnetworks                   *GCESubnetworks
	gceAlphaTargetHttpProxies        *GCEAlphaTargetHttpProxies
	gceBetaTargetHttpProxies         *GCEBetaTargetHttpProxies
	gceTargetHttpProxies             *GCETargetHttpProxies
	gceAlphaRegionTargetHttpProxies  *GCEAlphaRegionTargetHttpProxies
	gceBetaRegionTargetHttpProxies   *GCEBetaRegionTargetHttpProxies
	gceRegionTargetHttpProxies       *GCERegionTargetHttpProxies
	gceTargetHttpsProxies            *GCETargetHttpsProxies
	gceAlphaTargetHttpsProxies       *GCEAlphaTargetHttpsProxies
	gceBetaTargetHttpsProxies        *GCEBetaTargetHttpsProxies
	gceAlphaRegionTargetHttpsProxies *GCEAlphaRegionTargetHttpsProxies
	gceBetaRegionTargetHttpsProxies  *GCEBetaRegionTargetHttpsProxies
	gceRegionTargetHttpsProxies      *GCERegionTargetHttpsProxies
	gceTargetPools                   *GCETargetPools
	gceAlphaTargetTcpProxies         *GCEAlphaTargetTcpProxies
	gceBetaTargetTcpProxies          *GCEBetaTargetTcpProxies
	gceAlphaUrlMaps                  *GCEAlphaUrlMaps
	gceBetaUrlMaps                   *GCEBetaUrlMaps
	gceUrlMaps                       *GCEUrlMaps
	gceAlphaRegionUrlMaps            *GCEAlphaRegionUrlMaps
	gceBetaRegionUrlMaps             *GCEBetaRegionUrlMaps
	gceRegionUrlMaps                 *GCERegionUrlMaps
	gceZones                         *GCEZones
}

// Addresses returns the interface for the ga Addresses.
func (gce *GCE) Addresses() Addresses {
	return gce.gceAddresses
}

// AlphaAddresses returns the interface for the alpha Addresses.
func (gce *GCE) AlphaAddresses() AlphaAddresses {
	return gce.gceAlphaAddresses
}

// BetaAddresses returns the interface for the beta Addresses.
func (gce *GCE) BetaAddresses() BetaAddresses {
	return gce.gceBetaAddresses
}

// AlphaGlobalAddresses returns the interface for the alpha GlobalAddresses.
func (gce *GCE) AlphaGlobalAddresses() AlphaGlobalAddresses {
	return gce.gceAlphaGlobalAddresses
}

// BetaGlobalAddresses returns the interface for the beta GlobalAddresses.
func (gce *GCE) BetaGlobalAddresses() BetaGlobalAddresses {
	return gce.gceBetaGlobalAddresses
}

// GlobalAddresses returns the interface for the ga GlobalAddresses.
func (gce *GCE) GlobalAddresses() GlobalAddresses {
	return gce.gceGlobalAddresses
}

// BackendServices returns the interface for the ga BackendServices.
func (gce *GCE) BackendServices() BackendServices {
	return gce.gceBackendServices
}

// BetaBackendServices returns the interface for the beta BackendServices.
func (gce *GCE) BetaBackendServices() BetaBackendServices {
	return gce.gceBetaBackendServices
}

// AlphaBackendServices returns the interface for the alpha BackendServices.
func (gce *GCE) AlphaBackendServices() AlphaBackendServices {
	return gce.gceAlphaBackendServices
}

// RegionBackendServices returns the interface for the ga RegionBackendServices.
func (gce *GCE) RegionBackendServices() RegionBackendServices {
	return gce.gceRegionBackendServices
}

// AlphaRegionBackendServices returns the interface for the alpha RegionBackendServices.
func (gce *GCE) AlphaRegionBackendServices() AlphaRegionBackendServices {
	return gce.gceAlphaRegionBackendServices
}

// BetaRegionBackendServices returns the interface for the beta RegionBackendServices.
func (gce *GCE) BetaRegionBackendServices() BetaRegionBackendServices {
	return gce.gceBetaRegionBackendServices
}

// Disks returns the interface for the ga Disks.
func (gce *GCE) Disks() Disks {
	return gce.gceDisks
}

// RegionDisks returns the interface for the ga RegionDisks.
func (gce *GCE) RegionDisks() RegionDisks {
	return gce.gceRegionDisks
}

// AlphaFirewalls returns the interface for the alpha Firewalls.
func (gce *GCE) AlphaFirewalls() AlphaFirewalls {
	return gce.gceAlphaFirewalls
}

// BetaFirewalls returns the interface for the beta Firewalls.
func (gce *GCE) BetaFirewalls() BetaFirewalls {
	return gce.gceBetaFirewalls
}

// Firewalls returns the interface for the ga Firewalls.
func (gce *GCE) Firewalls() Firewalls {
	return gce.gceFirewalls
}

// ForwardingRules returns the interface for the ga ForwardingRules.
func (gce *GCE) ForwardingRules() ForwardingRules {
	return gce.gceForwardingRules
}

// AlphaForwardingRules returns the interface for the alpha ForwardingRules.
func (gce *GCE) AlphaForwardingRules() AlphaForwardingRules {
	return gce.gceAlphaForwardingRules
}

// BetaForwardingRules returns the interface for the beta ForwardingRules.
func (gce *GCE) BetaForwardingRules() BetaForwardingRules {
	return gce.gceBetaForwardingRules
}

// AlphaGlobalForwardingRules returns the interface for the alpha GlobalForwardingRules.
func (gce *GCE) AlphaGlobalForwardingRules() AlphaGlobalForwardingRules {
	return gce.gceAlphaGlobalForwardingRules
}

// BetaGlobalForwardingRules returns the interface for the beta GlobalForwardingRules.
func (gce *GCE) BetaGlobalForwardingRules() BetaGlobalForwardingRules {
	return gce.gceBetaGlobalForwardingRules
}

// GlobalForwardingRules returns the interface for the ga GlobalForwardingRules.
func (gce *GCE) GlobalForwardingRules() GlobalForwardingRules {
	return gce.gceGlobalForwardingRules
}

// HealthChecks returns the interface for the ga HealthChecks.
func (gce *GCE) HealthChecks() HealthChecks {
	return gce.gceHealthChecks
}

// AlphaHealthChecks returns the interface for the alpha HealthChecks.
func (gce *GCE) AlphaHealthChecks() AlphaHealthChecks {
	return gce.gceAlphaHealthChecks
}

// BetaHealthChecks returns the interface for the beta HealthChecks.
func (gce *GCE) BetaHealthChecks() BetaHealthChecks {
	return gce.gceBetaHealthChecks
}

// AlphaRegionHealthChecks returns the interface for the alpha RegionHealthChecks.
func (gce *GCE) AlphaRegionHealthChecks() AlphaRegionHealthChecks {
	return gce.gceAlphaRegionHealthChecks
}

// BetaRegionHealthChecks returns the interface for the beta RegionHealthChecks.
func (gce *GCE) BetaRegionHealthChecks() BetaRegionHealthChecks {
	return gce.gceBetaRegionHealthChecks
}

// RegionHealthChecks returns the interface for the ga RegionHealthChecks.
func (gce *GCE) RegionHealthChecks() RegionHealthChecks {
	return gce.gceRegionHealthChecks
}

// HttpHealthChecks returns the interface for the ga HttpHealthChecks.
func (gce *GCE) HttpHealthChecks() HttpHealthChecks {
	return gce.gceHttpHealthChecks
}

// HttpsHealthChecks returns the interface for the ga HttpsHealthChecks.
func (gce *GCE) HttpsHealthChecks() HttpsHealthChecks {
	return gce.gceHttpsHealthChecks
}

// InstanceGroups returns the interface for the ga InstanceGroups.
func (gce *GCE) InstanceGroups() InstanceGroups {
	return gce.gceInstanceGroups
}

// Instances returns the interface for the ga Instances.
func (gce *GCE) Instances() Instances {
	return gce.gceInstances
}

// BetaInstances returns the interface for the beta Instances.
func (gce *GCE) BetaInstances() BetaInstances {
	return gce.gceBetaInstances
}

// AlphaInstances returns the interface for the alpha Instances.
func (gce *GCE) AlphaInstances() AlphaInstances {
	return gce.gceAlphaInstances
}

// AlphaNetworks returns the interface for the alpha Networks.
func (gce *GCE) AlphaNetworks() AlphaNetworks {
	return gce.gceAlphaNetworks
}

// BetaNetworks returns the interface for the beta Networks.
func (gce *GCE) BetaNetworks() BetaNetworks {
	return gce.gceBetaNetworks
}

// Networks returns the interface for the ga Networks.
func (gce *GCE) Networks() Networks {
	return gce.gceNetworks
}

// AlphaNetworkEndpointGroups returns the interface for the alpha NetworkEndpointGroups.
func (gce *GCE) AlphaNetworkEndpointGroups() AlphaNetworkEndpointGroups {
	return gce.gceAlphaNetworkEndpointGroups
}

// BetaNetworkEndpointGroups returns the interface for the beta NetworkEndpointGroups.
func (gce *GCE) BetaNetworkEndpointGroups() BetaNetworkEndpointGroups {
	return gce.gceBetaNetworkEndpointGroups
}

// NetworkEndpointGroups returns the interface for the ga NetworkEndpointGroups.
func (gce *GCE) NetworkEndpointGroups() NetworkEndpointGroups {
	return gce.gceNetworkEndpointGroups
}

// Projects returns the interface for the ga Projects.
func (gce *GCE) Projects() Projects {
	return gce.gceProjects
}

// Regions returns the interface for the ga Regions.
func (gce *GCE) Regions() Regions {
	return gce.gceRegions
}

// AlphaRouters returns the interface for the alpha Routers.
func (gce *GCE) AlphaRouters() AlphaRouters {
	return gce.gceAlphaRouters
}

// BetaRouters returns the interface for the beta Routers.
func (gce *GCE) BetaRouters() BetaRouters {
	return gce.gceBetaRouters
}

// Routers returns the interface for the ga Routers.
func (gce *GCE) Routers() Routers {
	return gce.gceRouters
}

// Routes returns the interface for the ga Routes.
func (gce *GCE) Routes() Routes {
	return gce.gceRoutes
}

// BetaSecurityPolicies returns the interface for the beta SecurityPolicies.
func (gce *GCE) BetaSecurityPolicies() BetaSecurityPolicies {
	return gce.gceBetaSecurityPolicies
}

// BetaServiceAttachments returns the interface for the beta ServiceAttachments.
func (gce *GCE) BetaServiceAttachments() BetaServiceAttachments {
	return gce.gceBetaServiceAttachments
}

// AlphaServiceAttachments returns the interface for the alpha ServiceAttachments.
func (gce *GCE) AlphaServiceAttachments() AlphaServiceAttachments {
	return gce.gceAlphaServiceAttachments
}

// SslCertificates returns the interface for the ga SslCertificates.
func (gce *GCE) SslCertificates() SslCertificates {
	return gce.gceSslCertificates
}

// BetaSslCertificates returns the interface for the beta SslCertificates.
func (gce *GCE) BetaSslCertificates() BetaSslCertificates {
	return gce.gceBetaSslCertificates
}

// AlphaSslCertificates returns the interface for the alpha SslCertificates.
func (gce *GCE) AlphaSslCertificates() AlphaSslCertificates {
	return gce.gceAlphaSslCertificates
}

// AlphaRegionSslCertificates returns the interface for the alpha RegionSslCertificates.
func (gce *GCE) AlphaRegionSslCertificates() AlphaRegionSslCertificates {
	return gce.gceAlphaRegionSslCertificates
}

// BetaRegionSslCertificates returns the interface for the beta RegionSslCertificates.
func (gce *GCE) BetaRegionSslCertificates() BetaRegionSslCertificates {
	return gce.gceBetaRegionSslCertificates
}

// RegionSslCertificates returns the interface for the ga RegionSslCertificates.
func (gce *GCE) RegionSslCertificates() RegionSslCertificates {
	return gce.gceRegionSslCertificates
}

// SslPolicies returns the interface for the ga SslPolicies.
func (gce *GCE) SslPolicies() SslPolicies {
	return gce.gceSslPolicies
}

// AlphaSubnetworks returns the interface for the alpha Subnetworks.
func (gce *GCE) AlphaSubnetworks() AlphaSubnetworks {
	return gce.gceAlphaSubnetworks
}

// BetaSubnetworks returns the interface for the beta Subnetworks.
func (gce *GCE) BetaSubnetworks() BetaSubnetworks {
	return gce.gceBetaSubnetworks
}

// Subnetworks returns the interface for the ga Subnetworks.
func (gce *GCE) Subnetworks() Subnetworks {
	return gce.gceSubnetworks
}

// AlphaTargetHttpProxies returns the interface for the alpha TargetHttpProxies.
func (gce *GCE) AlphaTargetHttpProxies() AlphaTargetHttpProxies {
	return gce.gceAlphaTargetHttpProxies
}

// BetaTargetHttpProxies returns the interface for the beta TargetHttpProxies.
func (gce *GCE) BetaTargetHttpProxies() BetaTargetHttpProxies {
	return gce.gceBetaTargetHttpProxies
}

// TargetHttpProxies returns the interface for the ga TargetHttpProxies.
func (gce *GCE) TargetHttpProxies() TargetHttpProxies {
	return gce.gceTargetHttpProxies
}

// AlphaRegionTargetHttpProxies returns the interface for the alpha RegionTargetHttpProxies.
func (gce *GCE) AlphaRegionTargetHttpProxies() AlphaRegionTargetHttpProxies {
	return gce.gceAlphaRegionTargetHttpProxies
}

// BetaRegionTargetHttpProxies returns the interface for the beta RegionTargetHttpProxies.
func (gce *GCE) BetaRegionTargetHttpProxies() BetaRegionTargetHttpProxies {
	return gce.gceBetaRegionTargetHttpProxies
}

// RegionTargetHttpProxies returns the interface for the ga RegionTargetHttpProxies.
func (gce *GCE) RegionTargetHttpProxies() RegionTargetHttpProxies {
	return gce.gceRegionTargetHttpProxies
}

// TargetHttpsProxies returns the interface for the ga TargetHttpsProxies.
func (gce *GCE) TargetHttpsProxies() TargetHttpsProxies {
	return gce.gceTargetHttpsProxies
}

// AlphaTargetHttpsProxies returns the interface for the alpha TargetHttpsProxies.
func (gce *GCE) AlphaTargetHttpsProxies() AlphaTargetHttpsProxies {
	return gce.gceAlphaTargetHttpsProxies
}

// BetaTargetHttpsProxies returns the interface for the beta TargetHttpsProxies.
func (gce *GCE) BetaTargetHttpsProxies() BetaTargetHttpsProxies {
	return gce.gceBetaTargetHttpsProxies
}

// AlphaRegionTargetHttpsProxies returns the interface for the alpha RegionTargetHttpsProxies.
func (gce *GCE) AlphaRegionTargetHttpsProxies() AlphaRegionTargetHttpsProxies {
	return gce.gceAlphaRegionTargetHttpsProxies
}

// BetaRegionTargetHttpsProxies returns the interface for the beta RegionTargetHttpsProxies.
func (gce *GCE) BetaRegionTargetHttpsProxies() BetaRegionTargetHttpsProxies {
	return gce.gceBetaRegionTargetHttpsProxies
}

// RegionTargetHttpsProxies returns the interface for the ga RegionTargetHttpsProxies.
func (gce *GCE) RegionTargetHttpsProxies() RegionTargetHttpsProxies {
	return gce.gceRegionTargetHttpsProxies
}

// TargetPools returns the interface for the ga TargetPools.
func (gce *GCE) TargetPools() TargetPools {
	return gce.gceTargetPools
}

// AlphaTargetTcpProxies returns the interface for the alpha TargetTcpProxies.
func (gce *GCE) AlphaTargetTcpProxies() AlphaTargetTcpProxies {
	return gce.gceAlphaTargetTcpProxies
}

// BetaTargetTcpProxies returns the interface for the beta TargetTcpProxies.
func (gce *GCE) BetaTargetTcpProxies() BetaTargetTcpProxies {
	return gce.gceBetaTargetTcpProxies
}

// AlphaUrlMaps returns the interface for the alpha UrlMaps.
func (gce *GCE) AlphaUrlMaps() AlphaUrlMaps {
	return gce.gceAlphaUrlMaps
}

// BetaUrlMaps returns the interface for the beta UrlMaps.
func (gce *GCE) BetaUrlMaps() BetaUrlMaps {
	return gce.gceBetaUrlMaps
}

// UrlMaps returns the interface for the ga UrlMaps.
func (gce *GCE) UrlMaps() UrlMaps {
	return gce.gceUrlMaps
}

// AlphaRegionUrlMaps returns the interface for the alpha RegionUrlMaps.
func (gce *GCE) AlphaRegionUrlMaps() AlphaRegionUrlMaps {
	return gce.gceAlphaRegionUrlMaps
}

// BetaRegionUrlMaps returns the interface for the beta RegionUrlMaps.
func (gce *GCE) BetaRegionUrlMaps() BetaRegionUrlMaps {
	return gce.gceBetaRegionUrlMaps
}

// RegionUrlMaps returns the interface for the ga RegionUrlMaps.
func (gce *GCE) RegionUrlMaps() RegionUrlMaps {
	return gce.gceRegionUrlMaps
}

// Zones returns the interface for the ga Zones.
func (gce *GCE) Zones() Zones {
	return gce.gceZones
}

// NewMockGCE returns a new mock for GCE.
func NewMockGCE(projectRouter ProjectRouter) *MockGCE {
	mockAddressesObjs := map[meta.Key]*MockAddressesObj{}
	mockBackendServicesObjs := map[meta.Key]*MockBackendServicesObj{}
	mockDisksObjs := map[meta.Key]*MockDisksObj{}
	mockFirewallsObjs := map[meta.Key]*MockFirewallsObj{}
	mockForwardingRulesObjs := map[meta.Key]*MockForwardingRulesObj{}
	mockGlobalAddressesObjs := map[meta.Key]*MockGlobalAddressesObj{}
	mockGlobalForwardingRulesObjs := map[meta.Key]*MockGlobalForwardingRulesObj{}
	mockHealthChecksObjs := map[meta.Key]*MockHealthChecksObj{}
	mockHttpHealthChecksObjs := map[meta.Key]*MockHttpHealthChecksObj{}
	mockHttpsHealthChecksObjs := map[meta.Key]*MockHttpsHealthChecksObj{}
	mockInstanceGroupsObjs := map[meta.Key]*MockInstanceGroupsObj{}
	mockInstancesObjs := map[meta.Key]*MockInstancesObj{}
	mockNetworkEndpointGroupsObjs := map[meta.Key]*MockNetworkEndpointGroupsObj{}
	mockNetworksObjs := map[meta.Key]*MockNetworksObj{}
	mockProjectsObjs := map[meta.Key]*MockProjectsObj{}
	mockRegionBackendServicesObjs := map[meta.Key]*MockRegionBackendServicesObj{}
	mockRegionDisksObjs := map[meta.Key]*MockRegionDisksObj{}
	mockRegionHealthChecksObjs := map[meta.Key]*MockRegionHealthChecksObj{}
	mockRegionSslCertificatesObjs := map[meta.Key]*MockRegionSslCertificatesObj{}
	mockRegionTargetHttpProxiesObjs := map[meta.Key]*MockRegionTargetHttpProxiesObj{}
	mockRegionTargetHttpsProxiesObjs := map[meta.Key]*MockRegionTargetHttpsProxiesObj{}
	mockRegionUrlMapsObjs := map[meta.Key]*MockRegionUrlMapsObj{}
	mockRegionsObjs := map[meta.Key]*MockRegionsObj{}
	mockRoutersObjs := map[meta.Key]*MockRoutersObj{}
	mockRoutesObjs := map[meta.Key]*MockRoutesObj{}
	mockSecurityPoliciesObjs := map[meta.Key]*MockSecurityPoliciesObj{}
	mockServiceAttachmentsObjs := map[meta.Key]*MockServiceAttachmentsObj{}
	mockSslCertificatesObjs := map[meta.Key]*MockSslCertificatesObj{}
	mockSslPoliciesObjs := map[meta.Key]*MockSslPoliciesObj{}
	mockSubnetworksObjs := map[meta.Key]*MockSubnetworksObj{}
	mockTargetHttpProxiesObjs := map[meta.Key]*MockTargetHttpProxiesObj{}
	mockTargetHttpsProxiesObjs := map[meta.Key]*MockTargetHttpsProxiesObj{}
	mockTargetPoolsObjs := map[meta.Key]*MockTargetPoolsObj{}
	mockTargetTcpProxiesObjs := map[meta.Key]*MockTargetTcpProxiesObj{}
	mockUrlMapsObjs := map[meta.Key]*MockUrlMapsObj{}
	mockZonesObjs := map[meta.Key]*MockZonesObj{}

	mock := &MockGCE{
		MockAddresses:                     NewMockAddresses(projectRouter, mockAddressesObjs),
		MockAlphaAddresses:                NewMockAlphaAddresses(projectRouter, mockAddressesObjs),
		MockBetaAddresses:                 NewMockBetaAddresses(projectRouter, mockAddressesObjs),
		MockAlphaGlobalAddresses:          NewMockAlphaGlobalAddresses(projectRouter, mockGlobalAddressesObjs),
		MockBetaGlobalAddresses:           NewMockBetaGlobalAddresses(projectRouter, mockGlobalAddressesObjs),
		MockGlobalAddresses:               NewMockGlobalAddresses(projectRouter, mockGlobalAddressesObjs),
		MockBackendServices:               NewMockBackendServices(projectRouter, mockBackendServicesObjs),
		MockBetaBackendServices:           NewMockBetaBackendServices(projectRouter, mockBackendServicesObjs),
		MockAlphaBackendServices:          NewMockAlphaBackendServices(projectRouter, mockBackendServicesObjs),
		MockRegionBackendServices:         NewMockRegionBackendServices(projectRouter, mockRegionBackendServicesObjs),
		MockAlphaRegionBackendServices:    NewMockAlphaRegionBackendServices(projectRouter, mockRegionBackendServicesObjs),
		MockBetaRegionBackendServices:     NewMockBetaRegionBackendServices(projectRouter, mockRegionBackendServicesObjs),
		MockDisks:                         NewMockDisks(projectRouter, mockDisksObjs),
		MockRegionDisks:                   NewMockRegionDisks(projectRouter, mockRegionDisksObjs),
		MockAlphaFirewalls:                NewMockAlphaFirewalls(projectRouter, mockFirewallsObjs),
		MockBetaFirewalls:                 NewMockBetaFirewalls(projectRouter, mockFirewallsObjs),
		MockFirewalls:                     NewMockFirewalls(projectRouter, mockFirewallsObjs),
		MockForwardingRules:               NewMockForwardingRules(projectRouter, mockForwardingRulesObjs),
		MockAlphaForwardingRules:          NewMockAlphaForwardingRules(projectRouter, mockForwardingRulesObjs),
		MockBetaForwardingRules:           NewMockBetaForwardingRules(projectRouter, mockForwardingRulesObjs),
		MockAlphaGlobalForwardingRules:    NewMockAlphaGlobalForwardingRules(projectRouter, mockGlobalForwardingRulesObjs),
		MockBetaGlobalForwardingRules:     NewMockBetaGlobalForwardingRules(projectRouter, mockGlobalForwardingRulesObjs),
		MockGlobalForwardingRules:         NewMockGlobalForwardingRules(projectRouter, mockGlobalForwardingRulesObjs),
		MockHealthChecks:                  NewMockHealthChecks(projectRouter, mockHealthChecksObjs),
		MockAlphaHealthChecks:             NewMockAlphaHealthChecks(projectRouter, mockHealthChecksObjs),
		MockBetaHealthChecks:              NewMockBetaHealthChecks(projectRouter, mockHealthChecksObjs),
		MockAlphaRegionHealthChecks:       NewMockAlphaRegionHealthChecks(projectRouter, mockRegionHealthChecksObjs),
		MockBetaRegionHealthChecks:        NewMockBetaRegionHealthChecks(projectRouter, mockRegionHealthChecksObjs),
		MockRegionHealthChecks:            NewMockRegionHealthChecks(projectRouter, mockRegionHealthChecksObjs),
		MockHttpHealthChecks:              NewMockHttpHealthChecks(projectRouter, mockHttpHealthChecksObjs),
		MockHttpsHealthChecks:             NewMockHttpsHealthChecks(projectRouter, mockHttpsHealthChecksObjs),
		MockInstanceGroups:                NewMockInstanceGroups(projectRouter, mockInstanceGroupsObjs),
		MockInstances:                     NewMockInstances(projectRouter, mockInstancesObjs),
		MockBetaInstances:                 NewMockBetaInstances(projectRouter, mockInstancesObjs),
		MockAlphaInstances:                NewMockAlphaInstances(projectRouter, mockInstancesObjs),
		MockAlphaNetworks:                 NewMockAlphaNetworks(projectRouter, mockNetworksObjs),
		MockBetaNetworks:                  NewMockBetaNetworks(projectRouter, mockNetworksObjs),
		MockNetworks:                      NewMockNetworks(projectRouter, mockNetworksObjs),
		MockAlphaNetworkEndpointGroups:    NewMockAlphaNetworkEndpointGroups(projectRouter, mockNetworkEndpointGroupsObjs),
		MockBetaNetworkEndpointGroups:     NewMockBetaNetworkEndpointGroups(projectRouter, mockNetworkEndpointGroupsObjs),
		MockNetworkEndpointGroups:         NewMockNetworkEndpointGroups(projectRouter, mockNetworkEndpointGroupsObjs),
		MockProjects:                      NewMockProjects(projectRouter, mockProjectsObjs),
		MockRegions:                       NewMockRegions(projectRouter, mockRegionsObjs),
		MockAlphaRouters:                  NewMockAlphaRouters(projectRouter, mockRoutersObjs),
		MockBetaRouters:                   NewMockBetaRouters(projectRouter, mockRoutersObjs),
		MockRouters:                       NewMockRouters(projectRouter, mockRoutersObjs),
		MockRoutes:                        NewMockRoutes(projectRouter, mockRoutesObjs),
		MockBetaSecurityPolicies:          NewMockBetaSecurityPolicies(projectRouter, mockSecurityPoliciesObjs),
		MockBetaServiceAttachments:        NewMockBetaServiceAttachments(projectRouter, mockServiceAttachmentsObjs),
		MockAlphaServiceAttachments:       NewMockAlphaServiceAttachments(projectRouter, mockServiceAttachmentsObjs),
		MockSslCertificates:               NewMockSslCertificates(projectRouter, mockSslCertificatesObjs),
		MockBetaSslCertificates:           NewMockBetaSslCertificates(projectRouter, mockSslCertificatesObjs),
		MockAlphaSslCertificates:          NewMockAlphaSslCertificates(projectRouter, mockSslCertificatesObjs),
		MockAlphaRegionSslCertificates:    NewMockAlphaRegionSslCertificates(projectRouter, mockRegionSslCertificatesObjs),
		MockBetaRegionSslCertificates:     NewMockBetaRegionSslCertificates(projectRouter, mockRegionSslCertificatesObjs),
		MockRegionSslCertificates:         NewMockRegionSslCertificates(projectRouter, mockRegionSslCertificatesObjs),
		MockSslPolicies:                   NewMockSslPolicies(projectRouter, mockSslPoliciesObjs),
		MockAlphaSubnetworks:              NewMockAlphaSubnetworks(projectRouter, mockSubnetworksObjs),
		MockBetaSubnetworks:               NewMockBetaSubnetworks(projectRouter, mockSubnetworksObjs),
		MockSubnetworks:                   NewMockSubnetworks(projectRouter, mockSubnetworksObjs),
		MockAlphaTargetHttpProxies:        NewMockAlphaTargetHttpProxies(projectRouter, mockTargetHttpProxiesObjs),
		MockBetaTargetHttpProxies:         NewMockBetaTargetHttpProxies(projectRouter, mockTargetHttpProxiesObjs),
		MockTargetHttpProxies:             NewMockTargetHttpProxies(projectRouter, mockTargetHttpProxiesObjs),
		MockAlphaRegionTargetHttpProxies:  NewMockAlphaRegionTargetHttpProxies(projectRouter, mockRegionTargetHttpProxiesObjs),
		MockBetaRegionTargetHttpProxies:   NewMockBetaRegionTargetHttpProxies(projectRouter, mockRegionTargetHttpProxiesObjs),
		MockRegionTargetHttpProxies:       NewMockRegionTargetHttpProxies(projectRouter, mockRegionTargetHttpProxiesObjs),
		MockTargetHttpsProxies:            NewMockTargetHttpsProxies(projectRouter, mockTargetHttpsProxiesObjs),
		MockAlphaTargetHttpsProxies:       NewMockAlphaTargetHttpsProxies(projectRouter, mockTargetHttpsProxiesObjs),
		MockBetaTargetHttpsProxies:        NewMockBetaTargetHttpsProxies(projectRouter, mockTargetHttpsProxiesObjs),
		MockAlphaRegionTargetHttpsProxies: NewMockAlphaRegionTargetHttpsProxies(projectRouter, mockRegionTargetHttpsProxiesObjs),
		MockBetaRegionTargetHttpsProxies:  NewMockBetaRegionTargetHttpsProxies(projectRouter, mockRegionTargetHttpsProxiesObjs),
		MockRegionTargetHttpsProxies:      NewMockRegionTargetHttpsProxies(projectRouter, mockRegionTargetHttpsProxiesObjs),
		MockTargetPools:                   NewMockTargetPools(projectRouter, mockTargetPoolsObjs),
		MockAlphaTargetTcpProxies:         NewMockAlphaTargetTcpProxies(projectRouter, mockTargetTcpProxiesObjs),
		MockBetaTargetTcpProxies:          NewMockBetaTargetTcpProxies(projectRouter, mockTargetTcpProxiesObjs),
		MockAlphaUrlMaps:                  NewMockAlphaUrlMaps(projectRouter, mockUrlMapsObjs),
		MockBetaUrlMaps:                   NewMockBetaUrlMaps(projectRouter, mockUrlMapsObjs),
		MockUrlMaps:                       NewMockUrlMaps(projectRouter, mockUrlMapsObjs),
		MockAlphaRegionUrlMaps:            NewMockAlphaRegionUrlMaps(projectRouter, mockRegionUrlMapsObjs),
		MockBetaRegionUrlMaps:             NewMockBetaRegionUrlMaps(projectRouter, mockRegionUrlMapsObjs),
		MockRegionUrlMaps:                 NewMockRegionUrlMaps(projectRouter, mockRegionUrlMapsObjs),
		MockZones:                         NewMockZones(projectRouter, mockZonesObjs),
	}
	return mock
}

// MockGCE implements Cloud.
var _ Cloud = (*MockGCE)(nil)

// MockGCE is the mock for the compute API.
type MockGCE struct {
	MockAddresses                     *MockAddresses
	MockAlphaAddresses                *MockAlphaAddresses
	MockBetaAddresses                 *MockBetaAddresses
	MockAlphaGlobalAddresses          *MockAlphaGlobalAddresses
	MockBetaGlobalAddresses           *MockBetaGlobalAddresses
	MockGlobalAddresses               *MockGlobalAddresses
	MockBackendServices               *MockBackendServices
	MockBetaBackendServices           *MockBetaBackendServices
	MockAlphaBackendServices          *MockAlphaBackendServices
	MockRegionBackendServices         *MockRegionBackendServices
	MockAlphaRegionBackendServices    *MockAlphaRegionBackendServices
	MockBetaRegionBackendServices     *MockBetaRegionBackendServices
	MockDisks                         *MockDisks
	MockRegionDisks                   *MockRegionDisks
	MockAlphaFirewalls                *MockAlphaFirewalls
	MockBetaFirewalls                 *MockBetaFirewalls
	MockFirewalls                     *MockFirewalls
	MockForwardingRules               *MockForwardingRules
	MockAlphaForwardingRules          *MockAlphaForwardingRules
	MockBetaForwardingRules           *MockBetaForwardingRules
	MockAlphaGlobalForwardingRules    *MockAlphaGlobalForwardingRules
	MockBetaGlobalForwardingRules     *MockBetaGlobalForwardingRules
	MockGlobalForwardingRules         *MockGlobalForwardingRules
	MockHealthChecks                  *MockHealthChecks
	MockAlphaHealthChecks             *MockAlphaHealthChecks
	MockBetaHealthChecks              *MockBetaHealthChecks
	MockAlphaRegionHealthChecks       *MockAlphaRegionHealthChecks
	MockBetaRegionHealthChecks        *MockBetaRegionHealthChecks
	MockRegionHealthChecks            *MockRegionHealthChecks
	MockHttpHealthChecks              *MockHttpHealthChecks
	MockHttpsHealthChecks             *MockHttpsHealthChecks
	MockInstanceGroups                *MockInstanceGroups
	MockInstances                     *MockInstances
	MockBetaInstances                 *MockBetaInstances
	MockAlphaInstances                *MockAlphaInstances
	MockAlphaNetworks                 *MockAlphaNetworks
	MockBetaNetworks                  *MockBetaNetworks
	MockNetworks                      *MockNetworks
	MockAlphaNetworkEndpointGroups    *MockAlphaNetworkEndpointGroups
	MockBetaNetworkEndpointGroups     *MockBetaNetworkEndpointGroups
	MockNetworkEndpointGroups         *MockNetworkEndpointGroups
	MockProjects                      *MockProjects
	MockRegions                       *MockRegions
	MockAlphaRouters                  *MockAlphaRouters
	MockBetaRouters                   *MockBetaRouters
	MockRouters                       *MockRouters
	MockRoutes                        *MockRoutes
	MockBetaSecurityPolicies          *MockBetaSecurityPolicies
	MockBetaServiceAttachments        *MockBetaServiceAttachments
	MockAlphaServiceAttachments       *MockAlphaServiceAttachments
	MockSslCertificates               *MockSslCertificates
	MockBetaSslCertificates           *MockBetaSslCertificates
	MockAlphaSslCertificates          *MockAlphaSslCertificates
	MockAlphaRegionSslCertificates    *MockAlphaRegionSslCertificates
	MockBetaRegionSslCertificates     *MockBetaRegionSslCertificates
	MockRegionSslCertificates         *MockRegionSslCertificates
	MockSslPolicies                   *MockSslPolicies
	MockAlphaSubnetworks              *MockAlphaSubnetworks
	MockBetaSubnetworks               *MockBetaSubnetworks
	MockSubnetworks                   *MockSubnetworks
	MockAlphaTargetHttpProxies        *MockAlphaTargetHttpProxies
	MockBetaTargetHttpProxies         *MockBetaTargetHttpProxies
	MockTargetHttpProxies             *MockTargetHttpProxies
	MockAlphaRegionTargetHttpProxies  *MockAlphaRegionTargetHttpProxies
	MockBetaRegionTargetHttpProxies   *MockBetaRegionTargetHttpProxies
	MockRegionTargetHttpProxies       *MockRegionTargetHttpProxies
	MockTargetHttpsProxies            *MockTargetHttpsProxies
	MockAlphaTargetHttpsProxies       *MockAlphaTargetHttpsProxies
	MockBetaTargetHttpsProxies        *MockBetaTargetHttpsProxies
	MockAlphaRegionTargetHttpsProxies *MockAlphaRegionTargetHttpsProxies
	MockBetaRegionTargetHttpsProxies  *MockBetaRegionTargetHttpsProxies
	MockRegionTargetHttpsProxies      *MockRegionTargetHttpsProxies
	MockTargetPools                   *MockTargetPools
	MockAlphaTargetTcpProxies         *MockAlphaTargetTcpProxies
	MockBetaTargetTcpProxies          *MockBetaTargetTcpProxies
	MockAlphaUrlMaps                  *MockAlphaUrlMaps
	MockBetaUrlMaps                   *MockBetaUrlMaps
	MockUrlMaps                       *MockUrlMaps
	MockAlphaRegionUrlMaps            *MockAlphaRegionUrlMaps
	MockBetaRegionUrlMaps             *MockBetaRegionUrlMaps
	MockRegionUrlMaps                 *MockRegionUrlMaps
	MockZones                         *MockZones
}

// Addresses returns the interface for the ga Addresses.
func (mock *MockGCE) Addresses() Addresses {
	return mock.MockAddresses
}

// AlphaAddresses returns the interface for the alpha Addresses.
func (mock *MockGCE) AlphaAddresses() AlphaAddresses {
	return mock.MockAlphaAddresses
}

// BetaAddresses returns the interface for the beta Addresses.
func (mock *MockGCE) BetaAddresses() BetaAddresses {
	return mock.MockBetaAddresses
}

// AlphaGlobalAddresses returns the interface for the alpha GlobalAddresses.
func (mock *MockGCE) AlphaGlobalAddresses() AlphaGlobalAddresses {
	return mock.MockAlphaGlobalAddresses
}

// BetaGlobalAddresses returns the interface for the beta GlobalAddresses.
func (mock *MockGCE) BetaGlobalAddresses() BetaGlobalAddresses {
	return mock.MockBetaGlobalAddresses
}

// GlobalAddresses returns the interface for the ga GlobalAddresses.
func (mock *MockGCE) GlobalAddresses() GlobalAddresses {
	return mock.MockGlobalAddresses
}

// BackendServices returns the interface for the ga BackendServices.
func (mock *MockGCE) BackendServices() BackendServices {
	return mock.MockBackendServices
}

// BetaBackendServices returns the interface for the beta BackendServices.
func (mock *MockGCE) BetaBackendServices() BetaBackendServices {
	return mock.MockBetaBackendServices
}

// AlphaBackendServices returns the interface for the alpha BackendServices.
func (mock *MockGCE) AlphaBackendServices() AlphaBackendServices {
	return mock.MockAlphaBackendServices
}

// RegionBackendServices returns the interface for the ga RegionBackendServices.
func (mock *MockGCE) RegionBackendServices() RegionBackendServices {
	return mock.MockRegionBackendServices
}

// AlphaRegionBackendServices returns the interface for the alpha RegionBackendServices.
func (mock *MockGCE) AlphaRegionBackendServices() AlphaRegionBackendServices {
	return mock.MockAlphaRegionBackendServices
}

// BetaRegionBackendServices returns the interface for the beta RegionBackendServices.
func (mock *MockGCE) BetaRegionBackendServices() BetaRegionBackendServices {
	return mock.MockBetaRegionBackendServices
}

// Disks returns the interface for the ga Disks.
func (mock *MockGCE) Disks() Disks {
	return mock.MockDisks
}

// RegionDisks returns the interface for the ga RegionDisks.
func (mock *MockGCE) RegionDisks() RegionDisks {
	return mock.MockRegionDisks
}

// AlphaFirewalls returns the interface for the alpha Firewalls.
func (mock *MockGCE) AlphaFirewalls() AlphaFirewalls {
	return mock.MockAlphaFirewalls
}

// BetaFirewalls returns the interface for the beta Firewalls.
func (mock *MockGCE) BetaFirewalls() BetaFirewalls {
	return mock.MockBetaFirewalls
}

// Firewalls returns the interface for the ga Firewalls.
func (mock *MockGCE) Firewalls() Firewalls {
	return mock.MockFirewalls
}

// ForwardingRules returns the interface for the ga ForwardingRules.
func (mock *MockGCE) ForwardingRules() ForwardingRules {
	return mock.MockForwardingRules
}

// AlphaForwardingRules returns the interface for the alpha ForwardingRules.
func (mock *MockGCE) AlphaForwardingRules() AlphaForwardingRules {
	return mock.MockAlphaForwardingRules
}

// BetaForwardingRules returns the interface for the beta ForwardingRules.
func (mock *MockGCE) BetaForwardingRules() BetaForwardingRules {
	return mock.MockBetaForwardingRules
}

// AlphaGlobalForwardingRules returns the interface for the alpha GlobalForwardingRules.
func (mock *MockGCE) AlphaGlobalForwardingRules() AlphaGlobalForwardingRules {
	return mock.MockAlphaGlobalForwardingRules
}

// BetaGlobalForwardingRules returns the interface for the beta GlobalForwardingRules.
func (mock *MockGCE) BetaGlobalForwardingRules() BetaGlobalForwardingRules {
	return mock.MockBetaGlobalForwardingRules
}

// GlobalForwardingRules returns the interface for the ga GlobalForwardingRules.
func (mock *MockGCE) GlobalForwardingRules() GlobalForwardingRules {
	return mock.MockGlobalForwardingRules
}

// HealthChecks returns the interface for the ga HealthChecks.
func (mock *MockGCE) HealthChecks() HealthChecks {
	return mock.MockHealthChecks
}

// AlphaHealthChecks returns the interface for the alpha HealthChecks.
func (mock *MockGCE) AlphaHealthChecks() AlphaHealthChecks {
	return mock.MockAlphaHealthChecks
}

// BetaHealthChecks returns the interface for the beta HealthChecks.
func (mock *MockGCE) BetaHealthChecks() BetaHealthChecks {
	return mock.MockBetaHealthChecks
}

// AlphaRegionHealthChecks returns the interface for the alpha RegionHealthChecks.
func (mock *MockGCE) AlphaRegionHealthChecks() AlphaRegionHealthChecks {
	return mock.MockAlphaRegionHealthChecks
}

// BetaRegionHealthChecks returns the interface for the beta RegionHealthChecks.
func (mock *MockGCE) BetaRegionHealthChecks() BetaRegionHealthChecks {
	return mock.MockBetaRegionHealthChecks
}

// RegionHealthChecks returns the interface for the ga RegionHealthChecks.
func (mock *MockGCE) RegionHealthChecks() RegionHealthChecks {
	return mock.MockRegionHealthChecks
}

// HttpHealthChecks returns the interface for the ga HttpHealthChecks.
func (mock *MockGCE) HttpHealthChecks() HttpHealthChecks {
	return mock.MockHttpHealthChecks
}

// HttpsHealthChecks returns the interface for the ga HttpsHealthChecks.
func (mock *MockGCE) HttpsHealthChecks() HttpsHealthChecks {
	return mock.MockHttpsHealthChecks
}

// InstanceGroups returns the interface for the ga InstanceGroups.
func (mock *MockGCE) InstanceGroups() InstanceGroups {
	return mock.MockInstanceGroups
}

// Instances returns the interface for the ga Instances.
func (mock *MockGCE) Instances() Instances {
	return mock.MockInstances
}

// BetaInstances returns the interface for the beta Instances.
func (mock *MockGCE) BetaInstances() BetaInstances {
	return mock.MockBetaInstances
}

// AlphaInstances returns the interface for the alpha Instances.
func (mock *MockGCE) AlphaInstances() AlphaInstances {
	return mock.MockAlphaInstances
}

// AlphaNetworks returns the interface for the alpha Networks.
func (mock *MockGCE) AlphaNetworks() AlphaNetworks {
	return mock.MockAlphaNetworks
}

// BetaNetworks returns the interface for the beta Networks.
func (mock *MockGCE) BetaNetworks() BetaNetworks {
	return mock.MockBetaNetworks
}

// Networks returns the interface for the ga Networks.
func (mock *MockGCE) Networks() Networks {
	return mock.MockNetworks
}

// AlphaNetworkEndpointGroups returns the interface for the alpha NetworkEndpointGroups.
func (mock *MockGCE) AlphaNetworkEndpointGroups() AlphaNetworkEndpointGroups {
	return mock.MockAlphaNetworkEndpointGroups
}

// BetaNetworkEndpointGroups returns the interface for the beta NetworkEndpointGroups.
func (mock *MockGCE) BetaNetworkEndpointGroups() BetaNetworkEndpointGroups {
	return mock.MockBetaNetworkEndpointGroups
}

// NetworkEndpointGroups returns the interface for the ga NetworkEndpointGroups.
func (mock *MockGCE) NetworkEndpointGroups() NetworkEndpointGroups {
	return mock.MockNetworkEndpointGroups
}

// Projects returns the interface for the ga Projects.
func (mock *MockGCE) Projects() Projects {
	return mock.MockProjects
}

// Regions returns the interface for the ga Regions.
func (mock *MockGCE) Regions() Regions {
	return mock.MockRegions
}

// AlphaRouters returns the interface for the alpha Routers.
func (mock *MockGCE) AlphaRouters() AlphaRouters {
	return mock.MockAlphaRouters
}

// BetaRouters returns the interface for the beta Routers.
func (mock *MockGCE) BetaRouters() BetaRouters {
	return mock.MockBetaRouters
}

// Routers returns the interface for the ga Routers.
func (mock *MockGCE) Routers() Routers {
	return mock.MockRouters
}

// Routes returns the interface for the ga Routes.
func (mock *MockGCE) Routes() Routes {
	return mock.MockRoutes
}

// BetaSecurityPolicies returns the interface for the beta SecurityPolicies.
func (mock *MockGCE) BetaSecurityPolicies() BetaSecurityPolicies {
	return mock.MockBetaSecurityPolicies
}

// BetaServiceAttachments returns the interface for the beta ServiceAttachments.
func (mock *MockGCE) BetaServiceAttachments() BetaServiceAttachments {
	return mock.MockBetaServiceAttachments
}

// AlphaServiceAttachments returns the interface for the alpha ServiceAttachments.
func (mock *MockGCE) AlphaServiceAttachments() AlphaServiceAttachments {
	return mock.MockAlphaServiceAttachments
}

// SslCertificates returns the interface for the ga SslCertificates.
func (mock *MockGCE) SslCertificates() SslCertificates {
	return mock.MockSslCertificates
}

// BetaSslCertificates returns the interface for the beta SslCertificates.
func (mock *MockGCE) BetaSslCertificates() BetaSslCertificates {
	return mock.MockBetaSslCertificates
}

// AlphaSslCertificates returns the interface for the alpha SslCertificates.
func (mock *MockGCE) AlphaSslCertificates() AlphaSslCertificates {
	return mock.MockAlphaSslCertificates
}

// AlphaRegionSslCertificates returns the interface for the alpha RegionSslCertificates.
func (mock *MockGCE) AlphaRegionSslCertificates() AlphaRegionSslCertificates {
	return mock.MockAlphaRegionSslCertificates
}

// BetaRegionSslCertificates returns the interface for the beta RegionSslCertificates.
func (mock *MockGCE) BetaRegionSslCertificates() BetaRegionSslCertificates {
	return mock.MockBetaRegionSslCertificates
}

// RegionSslCertificates returns the interface for the ga RegionSslCertificates.
func (mock *MockGCE) RegionSslCertificates() RegionSslCertificates {
	return mock.MockRegionSslCertificates
}

// SslPolicies returns the interface for the ga SslPolicies.
func (mock *MockGCE) SslPolicies() SslPolicies {
	return mock.MockSslPolicies
}

// AlphaSubnetworks returns the interface for the alpha Subnetworks.
func (mock *MockGCE) AlphaSubnetworks() AlphaSubnetworks {
	return mock.MockAlphaSubnetworks
}

// BetaSubnetworks returns the interface for the beta Subnetworks.
func (mock *MockGCE) BetaSubnetworks() BetaSubnetworks {
	return mock.MockBetaSubnetworks
}

// Subnetworks returns the interface for the ga Subnetworks.
func (mock *MockGCE) Subnetworks() Subnetworks {
	return mock.MockSubnetworks
}

// AlphaTargetHttpProxies returns the interface for the alpha TargetHttpProxies.
func (mock *MockGCE) AlphaTargetHttpProxies() AlphaTargetHttpProxies {
	return mock.MockAlphaTargetHttpProxies
}

// BetaTargetHttpProxies returns the interface for the beta TargetHttpProxies.
func (mock *MockGCE) BetaTargetHttpProxies() BetaTargetHttpProxies {
	return mock.MockBetaTargetHttpProxies
}

// TargetHttpProxies returns the interface for the ga TargetHttpProxies.
func (mock *MockGCE) TargetHttpProxies() TargetHttpProxies {
	return mock.MockTargetHttpProxies
}

// AlphaRegionTargetHttpProxies returns the interface for the alpha RegionTargetHttpProxies.
func (mock *MockGCE) AlphaRegionTargetHttpProxies() AlphaRegionTargetHttpProxies {
	return mock.MockAlphaRegionTargetHttpProxies
}

// BetaRegionTargetHttpProxies returns the interface for the beta RegionTargetHttpProxies.
func (mock *MockGCE) BetaRegionTargetHttpProxies() BetaRegionTargetHttpProxies {
	return mock.MockBetaRegionTargetHttpProxies
}

// RegionTargetHttpProxies returns the interface for the ga RegionTargetHttpProxies.
func (mock *MockGCE) RegionTargetHttpProxies() RegionTargetHttpProxies {
	return mock.MockRegionTargetHttpProxies
}

// TargetHttpsProxies returns the interface for the ga TargetHttpsProxies.
func (mock *MockGCE) TargetHttpsProxies() TargetHttpsProxies {
	return mock.MockTargetHttpsProxies
}

// AlphaTargetHttpsProxies returns the interface for the alpha TargetHttpsProxies.
func (mock *MockGCE) AlphaTargetHttpsProxies() AlphaTargetHttpsProxies {
	return mock.MockAlphaTargetHttpsProxies
}

// BetaTargetHttpsProxies returns the interface for the beta TargetHttpsProxies.
func (mock *MockGCE) BetaTargetHttpsProxies() BetaTargetHttpsProxies {
	return mock.MockBetaTargetHttpsProxies
}

// AlphaRegionTargetHttpsProxies returns the interface for the alpha RegionTargetHttpsProxies.
func (mock *MockGCE) AlphaRegionTargetHttpsProxies() AlphaRegionTargetHttpsProxies {
	return mock.MockAlphaRegionTargetHttpsProxies
}

// BetaRegionTargetHttpsProxies returns the interface for the beta RegionTargetHttpsProxies.
func (mock *MockGCE) BetaRegionTargetHttpsProxies() BetaRegionTargetHttpsProxies {
	return mock.MockBetaRegionTargetHttpsProxies
}

// RegionTargetHttpsProxies returns the interface for the ga RegionTargetHttpsProxies.
func (mock *MockGCE) RegionTargetHttpsProxies() RegionTargetHttpsProxies {
	return mock.MockRegionTargetHttpsProxies
}

// TargetPools returns the interface for the ga TargetPools.
func (mock *MockGCE) TargetPools() TargetPools {
	return mock.MockTargetPools
}

// AlphaTargetTcpProxies returns the interface for the alpha TargetTcpProxies.
func (mock *MockGCE) AlphaTargetTcpProxies() AlphaTargetTcpProxies {
	return mock.MockAlphaTargetTcpProxies
}

// BetaTargetTcpProxies returns the interface for the beta TargetTcpProxies.
func (mock *MockGCE) BetaTargetTcpProxies() BetaTargetTcpProxies {
	return mock.MockBetaTargetTcpProxies
}

// AlphaUrlMaps returns the interface for the alpha UrlMaps.
func (mock *MockGCE) AlphaUrlMaps() AlphaUrlMaps {
	return mock.MockAlphaUrlMaps
}

// BetaUrlMaps returns the interface for the beta UrlMaps.
func (mock *MockGCE) BetaUrlMaps() BetaUrlMaps {
	return mock.MockBetaUrlMaps
}

// UrlMaps returns the interface for the ga UrlMaps.
func (mock *MockGCE) UrlMaps() UrlMaps {
	return mock.MockUrlMaps
}

// AlphaRegionUrlMaps returns the interface for the alpha RegionUrlMaps.
func (mock *MockGCE) AlphaRegionUrlMaps() AlphaRegionUrlMaps {
	return mock.MockAlphaRegionUrlMaps
}

// BetaRegionUrlMaps returns the interface for the beta RegionUrlMaps.
func (mock *MockGCE) BetaRegionUrlMaps() BetaRegionUrlMaps {
	return mock.MockBetaRegionUrlMaps
}

// RegionUrlMaps returns the interface for the ga RegionUrlMaps.
func (mock *MockGCE) RegionUrlMaps() RegionUrlMaps {
	return mock.MockRegionUrlMaps
}

// Zones returns the interface for the ga Zones.
func (mock *MockGCE) Zones() Zones {
	return mock.MockZones
}

// MockAddressesObj is used to store the various object versions in the shared
// map of mocked objects. This allows for multiple API versions to co-exist and
// share the same "view" of the objects in the backend.
type MockAddressesObj struct {
	Obj interface{}
}

// ToAlpha retrieves the given version of the object.
func (m *MockAddressesObj) ToAlpha() *alpha.Address {
	if ret, ok := m.Obj.(*alpha.Address); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &alpha.Address{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *alpha.Address via JSON: %v", m.Obj, err)
	}
	return ret
}

// ToBeta retrieves the given version of the object.
func (m *MockAddressesObj) ToBeta() *beta.Address {
	if ret, ok := m.Obj.(*beta.Address); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &beta.Address{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *beta.Address via JSON: %v", m.Obj, err)
	}
	return ret
}

// ToGA retrieves the given version of the object.
func (m *MockAddressesObj) ToGA() *ga.Address {
	if ret, ok := m.Obj.(*ga.Address); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &ga.Address{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *ga.Address via JSON: %v", m.Obj, err)
	}
	return ret
}

// MockBackendServicesObj is used to store the various object versions in the shared
// map of mocked objects. This allows for multiple API versions to co-exist and
// share the same "view" of the objects in the backend.
type MockBackendServicesObj struct {
	Obj interface{}
}

// ToAlpha retrieves the given version of the object.
func (m *MockBackendServicesObj) ToAlpha() *alpha.BackendService {
	if ret, ok := m.Obj.(*alpha.BackendService); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &alpha.BackendService{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *alpha.BackendService via JSON: %v", m.Obj, err)
	}
	return ret
}

// ToBeta retrieves the given version of the object.
func (m *MockBackendServicesObj) ToBeta() *beta.BackendService {
	if ret, ok := m.Obj.(*beta.BackendService); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &beta.BackendService{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *beta.BackendService via JSON: %v", m.Obj, err)
	}
	return ret
}

// ToGA retrieves the given version of the object.
func (m *MockBackendServicesObj) ToGA() *ga.BackendService {
	if ret, ok := m.Obj.(*ga.BackendService); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &ga.BackendService{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *ga.BackendService via JSON: %v", m.Obj, err)
	}
	return ret
}

// MockDisksObj is used to store the various object versions in the shared
// map of mocked objects. This allows for multiple API versions to co-exist and
// share the same "view" of the objects in the backend.
type MockDisksObj struct {
	Obj interface{}
}

// ToGA retrieves the given version of the object.
func (m *MockDisksObj) ToGA() *ga.Disk {
	if ret, ok := m.Obj.(*ga.Disk); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &ga.Disk{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *ga.Disk via JSON: %v", m.Obj, err)
	}
	return ret
}

// MockFirewallsObj is used to store the various object versions in the shared
// map of mocked objects. This allows for multiple API versions to co-exist and
// share the same "view" of the objects in the backend.
type MockFirewallsObj struct {
	Obj interface{}
}

// ToAlpha retrieves the given version of the object.
func (m *MockFirewallsObj) ToAlpha() *alpha.Firewall {
	if ret, ok := m.Obj.(*alpha.Firewall); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &alpha.Firewall{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *alpha.Firewall via JSON: %v", m.Obj, err)
	}
	return ret
}

// ToBeta retrieves the given version of the object.
func (m *MockFirewallsObj) ToBeta() *beta.Firewall {
	if ret, ok := m.Obj.(*beta.Firewall); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &beta.Firewall{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *beta.Firewall via JSON: %v", m.Obj, err)
	}
	return ret
}

// ToGA retrieves the given version of the object.
func (m *MockFirewallsObj) ToGA() *ga.Firewall {
	if ret, ok := m.Obj.(*ga.Firewall); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &ga.Firewall{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *ga.Firewall via JSON: %v", m.Obj, err)
	}
	return ret
}

// MockForwardingRulesObj is used to store the various object versions in the shared
// map of mocked objects. This allows for multiple API versions to co-exist and
// share the same "view" of the objects in the backend.
type MockForwardingRulesObj struct {
	Obj interface{}
}

// ToAlpha retrieves the given version of the object.
func (m *MockForwardingRulesObj) ToAlpha() *alpha.ForwardingRule {
	if ret, ok := m.Obj.(*alpha.ForwardingRule); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &alpha.ForwardingRule{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *alpha.ForwardingRule via JSON: %v", m.Obj, err)
	}
	return ret
}

// ToBeta retrieves the given version of the object.
func (m *MockForwardingRulesObj) ToBeta() *beta.ForwardingRule {
	if ret, ok := m.Obj.(*beta.ForwardingRule); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &beta.ForwardingRule{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *beta.ForwardingRule via JSON: %v", m.Obj, err)
	}
	return ret
}

// ToGA retrieves the given version of the object.
func (m *MockForwardingRulesObj) ToGA() *ga.ForwardingRule {
	if ret, ok := m.Obj.(*ga.ForwardingRule); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &ga.ForwardingRule{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *ga.ForwardingRule via JSON: %v", m.Obj, err)
	}
	return ret
}

// MockGlobalAddressesObj is used to store the various object versions in the shared
// map of mocked objects. This allows for multiple API versions to co-exist and
// share the same "view" of the objects in the backend.
type MockGlobalAddressesObj struct {
	Obj interface{}
}

// ToAlpha retrieves the given version of the object.
func (m *MockGlobalAddressesObj) ToAlpha() *alpha.Address {
	if ret, ok := m.Obj.(*alpha.Address); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &alpha.Address{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *alpha.Address via JSON: %v", m.Obj, err)
	}
	return ret
}

// ToBeta retrieves the given version of the object.
func (m *MockGlobalAddressesObj) ToBeta() *beta.Address {
	if ret, ok := m.Obj.(*beta.Address); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &beta.Address{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *beta.Address via JSON: %v", m.Obj, err)
	}
	return ret
}

// ToGA retrieves the given version of the object.
func (m *MockGlobalAddressesObj) ToGA() *ga.Address {
	if ret, ok := m.Obj.(*ga.Address); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &ga.Address{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *ga.Address via JSON: %v", m.Obj, err)
	}
	return ret
}

// MockGlobalForwardingRulesObj is used to store the various object versions in the shared
// map of mocked objects. This allows for multiple API versions to co-exist and
// share the same "view" of the objects in the backend.
type MockGlobalForwardingRulesObj struct {
	Obj interface{}
}

// ToAlpha retrieves the given version of the object.
func (m *MockGlobalForwardingRulesObj) ToAlpha() *alpha.ForwardingRule {
	if ret, ok := m.Obj.(*alpha.ForwardingRule); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &alpha.ForwardingRule{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *alpha.ForwardingRule via JSON: %v", m.Obj, err)
	}
	return ret
}

// ToBeta retrieves the given version of the object.
func (m *MockGlobalForwardingRulesObj) ToBeta() *beta.ForwardingRule {
	if ret, ok := m.Obj.(*beta.ForwardingRule); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &beta.ForwardingRule{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *beta.ForwardingRule via JSON: %v", m.Obj, err)
	}
	return ret
}

// ToGA retrieves the given version of the object.
func (m *MockGlobalForwardingRulesObj) ToGA() *ga.ForwardingRule {
	if ret, ok := m.Obj.(*ga.ForwardingRule); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &ga.ForwardingRule{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *ga.ForwardingRule via JSON: %v", m.Obj, err)
	}
	return ret
}

// MockHealthChecksObj is used to store the various object versions in the shared
// map of mocked objects. This allows for multiple API versions to co-exist and
// share the same "view" of the objects in the backend.
type MockHealthChecksObj struct {
	Obj interface{}
}

// ToAlpha retrieves the given version of the object.
func (m *MockHealthChecksObj) ToAlpha() *alpha.HealthCheck {
	if ret, ok := m.Obj.(*alpha.HealthCheck); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &alpha.HealthCheck{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *alpha.HealthCheck via JSON: %v", m.Obj, err)
	}
	return ret
}

// ToBeta retrieves the given version of the object.
func (m *MockHealthChecksObj) ToBeta() *beta.HealthCheck {
	if ret, ok := m.Obj.(*beta.HealthCheck); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &beta.HealthCheck{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *beta.HealthCheck via JSON: %v", m.Obj, err)
	}
	return ret
}

// ToGA retrieves the given version of the object.
func (m *MockHealthChecksObj) ToGA() *ga.HealthCheck {
	if ret, ok := m.Obj.(*ga.HealthCheck); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &ga.HealthCheck{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *ga.HealthCheck via JSON: %v", m.Obj, err)
	}
	return ret
}

// MockHttpHealthChecksObj is used to store the various object versions in the shared
// map of mocked objects. This allows for multiple API versions to co-exist and
// share the same "view" of the objects in the backend.
type MockHttpHealthChecksObj struct {
	Obj interface{}
}

// ToGA retrieves the given version of the object.
func (m *MockHttpHealthChecksObj) ToGA() *ga.HttpHealthCheck {
	if ret, ok := m.Obj.(*ga.HttpHealthCheck); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &ga.HttpHealthCheck{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *ga.HttpHealthCheck via JSON: %v", m.Obj, err)
	}
	return ret
}

// MockHttpsHealthChecksObj is used to store the various object versions in the shared
// map of mocked objects. This allows for multiple API versions to co-exist and
// share the same "view" of the objects in the backend.
type MockHttpsHealthChecksObj struct {
	Obj interface{}
}

// ToGA retrieves the given version of the object.
func (m *MockHttpsHealthChecksObj) ToGA() *ga.HttpsHealthCheck {
	if ret, ok := m.Obj.(*ga.HttpsHealthCheck); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &ga.HttpsHealthCheck{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *ga.HttpsHealthCheck via JSON: %v", m.Obj, err)
	}
	return ret
}

// MockInstanceGroupsObj is used to store the various object versions in the shared
// map of mocked objects. This allows for multiple API versions to co-exist and
// share the same "view" of the objects in the backend.
type MockInstanceGroupsObj struct {
	Obj interface{}
}

// ToGA retrieves the given version of the object.
func (m *MockInstanceGroupsObj) ToGA() *ga.InstanceGroup {
	if ret, ok := m.Obj.(*ga.InstanceGroup); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &ga.InstanceGroup{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *ga.InstanceGroup via JSON: %v", m.Obj, err)
	}
	return ret
}

// MockInstancesObj is used to store the various object versions in the shared
// map of mocked objects. This allows for multiple API versions to co-exist and
// share the same "view" of the objects in the backend.
type MockInstancesObj struct {
	Obj interface{}
}

// ToAlpha retrieves the given version of the object.
func (m *MockInstancesObj) ToAlpha() *alpha.Instance {
	if ret, ok := m.Obj.(*alpha.Instance); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &alpha.Instance{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *alpha.Instance via JSON: %v", m.Obj, err)
	}
	return ret
}

// ToBeta retrieves the given version of the object.
func (m *MockInstancesObj) ToBeta() *beta.Instance {
	if ret, ok := m.Obj.(*beta.Instance); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &beta.Instance{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *beta.Instance via JSON: %v", m.Obj, err)
	}
	return ret
}

// ToGA retrieves the given version of the object.
func (m *MockInstancesObj) ToGA() *ga.Instance {
	if ret, ok := m.Obj.(*ga.Instance); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &ga.Instance{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *ga.Instance via JSON: %v", m.Obj, err)
	}
	return ret
}

// MockNetworkEndpointGroupsObj is used to store the various object versions in the shared
// map of mocked objects. This allows for multiple API versions to co-exist and
// share the same "view" of the objects in the backend.
type MockNetworkEndpointGroupsObj struct {
	Obj interface{}
}

// ToAlpha retrieves the given version of the object.
func (m *MockNetworkEndpointGroupsObj) ToAlpha() *alpha.NetworkEndpointGroup {
	if ret, ok := m.Obj.(*alpha.NetworkEndpointGroup); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &alpha.NetworkEndpointGroup{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *alpha.NetworkEndpointGroup via JSON: %v", m.Obj, err)
	}
	return ret
}

// ToBeta retrieves the given version of the object.
func (m *MockNetworkEndpointGroupsObj) ToBeta() *beta.NetworkEndpointGroup {
	if ret, ok := m.Obj.(*beta.NetworkEndpointGroup); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &beta.NetworkEndpointGroup{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *beta.NetworkEndpointGroup via JSON: %v", m.Obj, err)
	}
	return ret
}

// ToGA retrieves the given version of the object.
func (m *MockNetworkEndpointGroupsObj) ToGA() *ga.NetworkEndpointGroup {
	if ret, ok := m.Obj.(*ga.NetworkEndpointGroup); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &ga.NetworkEndpointGroup{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *ga.NetworkEndpointGroup via JSON: %v", m.Obj, err)
	}
	return ret
}

// MockNetworksObj is used to store the various object versions in the shared
// map of mocked objects. This allows for multiple API versions to co-exist and
// share the same "view" of the objects in the backend.
type MockNetworksObj struct {
	Obj interface{}
}

// ToAlpha retrieves the given version of the object.
func (m *MockNetworksObj) ToAlpha() *alpha.Network {
	if ret, ok := m.Obj.(*alpha.Network); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &alpha.Network{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *alpha.Network via JSON: %v", m.Obj, err)
	}
	return ret
}

// ToBeta retrieves the given version of the object.
func (m *MockNetworksObj) ToBeta() *beta.Network {
	if ret, ok := m.Obj.(*beta.Network); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &beta.Network{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *beta.Network via JSON: %v", m.Obj, err)
	}
	return ret
}

// ToGA retrieves the given version of the object.
func (m *MockNetworksObj) ToGA() *ga.Network {
	if ret, ok := m.Obj.(*ga.Network); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &ga.Network{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *ga.Network via JSON: %v", m.Obj, err)
	}
	return ret
}

// MockProjectsObj is used to store the various object versions in the shared
// map of mocked objects. This allows for multiple API versions to co-exist and
// share the same "view" of the objects in the backend.
type MockProjectsObj struct {
	Obj interface{}
}

// ToGA retrieves the given version of the object.
func (m *MockProjectsObj) ToGA() *ga.Project {
	if ret, ok := m.Obj.(*ga.Project); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &ga.Project{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *ga.Project via JSON: %v", m.Obj, err)
	}
	return ret
}

// MockRegionBackendServicesObj is used to store the various object versions in the shared
// map of mocked objects. This allows for multiple API versions to co-exist and
// share the same "view" of the objects in the backend.
type MockRegionBackendServicesObj struct {
	Obj interface{}
}

// ToAlpha retrieves the given version of the object.
func (m *MockRegionBackendServicesObj) ToAlpha() *alpha.BackendService {
	if ret, ok := m.Obj.(*alpha.BackendService); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &alpha.BackendService{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *alpha.BackendService via JSON: %v", m.Obj, err)
	}
	return ret
}

// ToBeta retrieves the given version of the object.
func (m *MockRegionBackendServicesObj) ToBeta() *beta.BackendService {
	if ret, ok := m.Obj.(*beta.BackendService); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &beta.BackendService{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *beta.BackendService via JSON: %v", m.Obj, err)
	}
	return ret
}

// ToGA retrieves the given version of the object.
func (m *MockRegionBackendServicesObj) ToGA() *ga.BackendService {
	if ret, ok := m.Obj.(*ga.BackendService); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &ga.BackendService{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *ga.BackendService via JSON: %v", m.Obj, err)
	}
	return ret
}

// MockRegionDisksObj is used to store the various object versions in the shared
// map of mocked objects. This allows for multiple API versions to co-exist and
// share the same "view" of the objects in the backend.
type MockRegionDisksObj struct {
	Obj interface{}
}

// ToGA retrieves the given version of the object.
func (m *MockRegionDisksObj) ToGA() *ga.Disk {
	if ret, ok := m.Obj.(*ga.Disk); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &ga.Disk{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *ga.Disk via JSON: %v", m.Obj, err)
	}
	return ret
}

// MockRegionHealthChecksObj is used to store the various object versions in the shared
// map of mocked objects. This allows for multiple API versions to co-exist and
// share the same "view" of the objects in the backend.
type MockRegionHealthChecksObj struct {
	Obj interface{}
}

// ToAlpha retrieves the given version of the object.
func (m *MockRegionHealthChecksObj) ToAlpha() *alpha.HealthCheck {
	if ret, ok := m.Obj.(*alpha.HealthCheck); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &alpha.HealthCheck{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *alpha.HealthCheck via JSON: %v", m.Obj, err)
	}
	return ret
}

// ToBeta retrieves the given version of the object.
func (m *MockRegionHealthChecksObj) ToBeta() *beta.HealthCheck {
	if ret, ok := m.Obj.(*beta.HealthCheck); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &beta.HealthCheck{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *beta.HealthCheck via JSON: %v", m.Obj, err)
	}
	return ret
}

// ToGA retrieves the given version of the object.
func (m *MockRegionHealthChecksObj) ToGA() *ga.HealthCheck {
	if ret, ok := m.Obj.(*ga.HealthCheck); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &ga.HealthCheck{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *ga.HealthCheck via JSON: %v", m.Obj, err)
	}
	return ret
}

// MockRegionSslCertificatesObj is used to store the various object versions in the shared
// map of mocked objects. This allows for multiple API versions to co-exist and
// share the same "view" of the objects in the backend.
type MockRegionSslCertificatesObj struct {
	Obj interface{}
}

// ToAlpha retrieves the given version of the object.
func (m *MockRegionSslCertificatesObj) ToAlpha() *alpha.SslCertificate {
	if ret, ok := m.Obj.(*alpha.SslCertificate); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &alpha.SslCertificate{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *alpha.SslCertificate via JSON: %v", m.Obj, err)
	}
	return ret
}

// ToBeta retrieves the given version of the object.
func (m *MockRegionSslCertificatesObj) ToBeta() *beta.SslCertificate {
	if ret, ok := m.Obj.(*beta.SslCertificate); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &beta.SslCertificate{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *beta.SslCertificate via JSON: %v", m.Obj, err)
	}
	return ret
}

// ToGA retrieves the given version of the object.
func (m *MockRegionSslCertificatesObj) ToGA() *ga.SslCertificate {
	if ret, ok := m.Obj.(*ga.SslCertificate); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &ga.SslCertificate{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *ga.SslCertificate via JSON: %v", m.Obj, err)
	}
	return ret
}

// MockRegionTargetHttpProxiesObj is used to store the various object versions in the shared
// map of mocked objects. This allows for multiple API versions to co-exist and
// share the same "view" of the objects in the backend.
type MockRegionTargetHttpProxiesObj struct {
	Obj interface{}
}

// ToAlpha retrieves the given version of the object.
func (m *MockRegionTargetHttpProxiesObj) ToAlpha() *alpha.TargetHttpProxy {
	if ret, ok := m.Obj.(*alpha.TargetHttpProxy); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &alpha.TargetHttpProxy{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *alpha.TargetHttpProxy via JSON: %v", m.Obj, err)
	}
	return ret
}

// ToBeta retrieves the given version of the object.
func (m *MockRegionTargetHttpProxiesObj) ToBeta() *beta.TargetHttpProxy {
	if ret, ok := m.Obj.(*beta.TargetHttpProxy); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &beta.TargetHttpProxy{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *beta.TargetHttpProxy via JSON: %v", m.Obj, err)
	}
	return ret
}

// ToGA retrieves the given version of the object.
func (m *MockRegionTargetHttpProxiesObj) ToGA() *ga.TargetHttpProxy {
	if ret, ok := m.Obj.(*ga.TargetHttpProxy); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &ga.TargetHttpProxy{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *ga.TargetHttpProxy via JSON: %v", m.Obj, err)
	}
	return ret
}

// MockRegionTargetHttpsProxiesObj is used to store the various object versions in the shared
// map of mocked objects. This allows for multiple API versions to co-exist and
// share the same "view" of the objects in the backend.
type MockRegionTargetHttpsProxiesObj struct {
	Obj interface{}
}

// ToAlpha retrieves the given version of the object.
func (m *MockRegionTargetHttpsProxiesObj) ToAlpha() *alpha.TargetHttpsProxy {
	if ret, ok := m.Obj.(*alpha.TargetHttpsProxy); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &alpha.TargetHttpsProxy{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *alpha.TargetHttpsProxy via JSON: %v", m.Obj, err)
	}
	return ret
}

// ToBeta retrieves the given version of the object.
func (m *MockRegionTargetHttpsProxiesObj) ToBeta() *beta.TargetHttpsProxy {
	if ret, ok := m.Obj.(*beta.TargetHttpsProxy); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &beta.TargetHttpsProxy{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *beta.TargetHttpsProxy via JSON: %v", m.Obj, err)
	}
	return ret
}

// ToGA retrieves the given version of the object.
func (m *MockRegionTargetHttpsProxiesObj) ToGA() *ga.TargetHttpsProxy {
	if ret, ok := m.Obj.(*ga.TargetHttpsProxy); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &ga.TargetHttpsProxy{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *ga.TargetHttpsProxy via JSON: %v", m.Obj, err)
	}
	return ret
}

// MockRegionUrlMapsObj is used to store the various object versions in the shared
// map of mocked objects. This allows for multiple API versions to co-exist and
// share the same "view" of the objects in the backend.
type MockRegionUrlMapsObj struct {
	Obj interface{}
}

// ToAlpha retrieves the given version of the object.
func (m *MockRegionUrlMapsObj) ToAlpha() *alpha.UrlMap {
	if ret, ok := m.Obj.(*alpha.UrlMap); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &alpha.UrlMap{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *alpha.UrlMap via JSON: %v", m.Obj, err)
	}
	return ret
}

// ToBeta retrieves the given version of the object.
func (m *MockRegionUrlMapsObj) ToBeta() *beta.UrlMap {
	if ret, ok := m.Obj.(*beta.UrlMap); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &beta.UrlMap{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *beta.UrlMap via JSON: %v", m.Obj, err)
	}
	return ret
}

// ToGA retrieves the given version of the object.
func (m *MockRegionUrlMapsObj) ToGA() *ga.UrlMap {
	if ret, ok := m.Obj.(*ga.UrlMap); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &ga.UrlMap{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *ga.UrlMap via JSON: %v", m.Obj, err)
	}
	return ret
}

// MockRegionsObj is used to store the various object versions in the shared
// map of mocked objects. This allows for multiple API versions to co-exist and
// share the same "view" of the objects in the backend.
type MockRegionsObj struct {
	Obj interface{}
}

// ToGA retrieves the given version of the object.
func (m *MockRegionsObj) ToGA() *ga.Region {
	if ret, ok := m.Obj.(*ga.Region); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &ga.Region{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *ga.Region via JSON: %v", m.Obj, err)
	}
	return ret
}

// MockRoutersObj is used to store the various object versions in the shared
// map of mocked objects. This allows for multiple API versions to co-exist and
// share the same "view" of the objects in the backend.
type MockRoutersObj struct {
	Obj interface{}
}

// ToAlpha retrieves the given version of the object.
func (m *MockRoutersObj) ToAlpha() *alpha.Router {
	if ret, ok := m.Obj.(*alpha.Router); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &alpha.Router{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *alpha.Router via JSON: %v", m.Obj, err)
	}
	return ret
}

// ToBeta retrieves the given version of the object.
func (m *MockRoutersObj) ToBeta() *beta.Router {
	if ret, ok := m.Obj.(*beta.Router); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &beta.Router{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *beta.Router via JSON: %v", m.Obj, err)
	}
	return ret
}

// ToGA retrieves the given version of the object.
func (m *MockRoutersObj) ToGA() *ga.Router {
	if ret, ok := m.Obj.(*ga.Router); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &ga.Router{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *ga.Router via JSON: %v", m.Obj, err)
	}
	return ret
}

// MockRoutesObj is used to store the various object versions in the shared
// map of mocked objects. This allows for multiple API versions to co-exist and
// share the same "view" of the objects in the backend.
type MockRoutesObj struct {
	Obj interface{}
}

// ToGA retrieves the given version of the object.
func (m *MockRoutesObj) ToGA() *ga.Route {
	if ret, ok := m.Obj.(*ga.Route); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &ga.Route{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *ga.Route via JSON: %v", m.Obj, err)
	}
	return ret
}

// MockSecurityPoliciesObj is used to store the various object versions in the shared
// map of mocked objects. This allows for multiple API versions to co-exist and
// share the same "view" of the objects in the backend.
type MockSecurityPoliciesObj struct {
	Obj interface{}
}

// ToBeta retrieves the given version of the object.
func (m *MockSecurityPoliciesObj) ToBeta() *beta.SecurityPolicy {
	if ret, ok := m.Obj.(*beta.SecurityPolicy); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &beta.SecurityPolicy{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *beta.SecurityPolicy via JSON: %v", m.Obj, err)
	}
	return ret
}

// MockServiceAttachmentsObj is used to store the various object versions in the shared
// map of mocked objects. This allows for multiple API versions to co-exist and
// share the same "view" of the objects in the backend.
type MockServiceAttachmentsObj struct {
	Obj interface{}
}

// ToAlpha retrieves the given version of the object.
func (m *MockServiceAttachmentsObj) ToAlpha() *alpha.ServiceAttachment {
	if ret, ok := m.Obj.(*alpha.ServiceAttachment); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &alpha.ServiceAttachment{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *alpha.ServiceAttachment via JSON: %v", m.Obj, err)
	}
	return ret
}

// ToBeta retrieves the given version of the object.
func (m *MockServiceAttachmentsObj) ToBeta() *beta.ServiceAttachment {
	if ret, ok := m.Obj.(*beta.ServiceAttachment); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &beta.ServiceAttachment{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *beta.ServiceAttachment via JSON: %v", m.Obj, err)
	}
	return ret
}

// MockSslCertificatesObj is used to store the various object versions in the shared
// map of mocked objects. This allows for multiple API versions to co-exist and
// share the same "view" of the objects in the backend.
type MockSslCertificatesObj struct {
	Obj interface{}
}

// ToAlpha retrieves the given version of the object.
func (m *MockSslCertificatesObj) ToAlpha() *alpha.SslCertificate {
	if ret, ok := m.Obj.(*alpha.SslCertificate); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &alpha.SslCertificate{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *alpha.SslCertificate via JSON: %v", m.Obj, err)
	}
	return ret
}

// ToBeta retrieves the given version of the object.
func (m *MockSslCertificatesObj) ToBeta() *beta.SslCertificate {
	if ret, ok := m.Obj.(*beta.SslCertificate); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &beta.SslCertificate{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *beta.SslCertificate via JSON: %v", m.Obj, err)
	}
	return ret
}

// ToGA retrieves the given version of the object.
func (m *MockSslCertificatesObj) ToGA() *ga.SslCertificate {
	if ret, ok := m.Obj.(*ga.SslCertificate); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &ga.SslCertificate{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *ga.SslCertificate via JSON: %v", m.Obj, err)
	}
	return ret
}

// MockSslPoliciesObj is used to store the various object versions in the shared
// map of mocked objects. This allows for multiple API versions to co-exist and
// share the same "view" of the objects in the backend.
type MockSslPoliciesObj struct {
	Obj interface{}
}

// ToGA retrieves the given version of the object.
func (m *MockSslPoliciesObj) ToGA() *ga.SslPolicy {
	if ret, ok := m.Obj.(*ga.SslPolicy); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &ga.SslPolicy{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *ga.SslPolicy via JSON: %v", m.Obj, err)
	}
	return ret
}

// MockSubnetworksObj is used to store the various object versions in the shared
// map of mocked objects. This allows for multiple API versions to co-exist and
// share the same "view" of the objects in the backend.
type MockSubnetworksObj struct {
	Obj interface{}
}

// ToAlpha retrieves the given version of the object.
func (m *MockSubnetworksObj) ToAlpha() *alpha.Subnetwork {
	if ret, ok := m.Obj.(*alpha.Subnetwork); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &alpha.Subnetwork{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *alpha.Subnetwork via JSON: %v", m.Obj, err)
	}
	return ret
}

// ToBeta retrieves the given version of the object.
func (m *MockSubnetworksObj) ToBeta() *beta.Subnetwork {
	if ret, ok := m.Obj.(*beta.Subnetwork); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &beta.Subnetwork{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *beta.Subnetwork via JSON: %v", m.Obj, err)
	}
	return ret
}

// ToGA retrieves the given version of the object.
func (m *MockSubnetworksObj) ToGA() *ga.Subnetwork {
	if ret, ok := m.Obj.(*ga.Subnetwork); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &ga.Subnetwork{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *ga.Subnetwork via JSON: %v", m.Obj, err)
	}
	return ret
}

// MockTargetHttpProxiesObj is used to store the various object versions in the shared
// map of mocked objects. This allows for multiple API versions to co-exist and
// share the same "view" of the objects in the backend.
type MockTargetHttpProxiesObj struct {
	Obj interface{}
}

// ToAlpha retrieves the given version of the object.
func (m *MockTargetHttpProxiesObj) ToAlpha() *alpha.TargetHttpProxy {
	if ret, ok := m.Obj.(*alpha.TargetHttpProxy); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &alpha.TargetHttpProxy{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *alpha.TargetHttpProxy via JSON: %v", m.Obj, err)
	}
	return ret
}

// ToBeta retrieves the given version of the object.
func (m *MockTargetHttpProxiesObj) ToBeta() *beta.TargetHttpProxy {
	if ret, ok := m.Obj.(*beta.TargetHttpProxy); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &beta.TargetHttpProxy{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *beta.TargetHttpProxy via JSON: %v", m.Obj, err)
	}
	return ret
}

// ToGA retrieves the given version of the object.
func (m *MockTargetHttpProxiesObj) ToGA() *ga.TargetHttpProxy {
	if ret, ok := m.Obj.(*ga.TargetHttpProxy); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &ga.TargetHttpProxy{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *ga.TargetHttpProxy via JSON: %v", m.Obj, err)
	}
	return ret
}

// MockTargetHttpsProxiesObj is used to store the various object versions in the shared
// map of mocked objects. This allows for multiple API versions to co-exist and
// share the same "view" of the objects in the backend.
type MockTargetHttpsProxiesObj struct {
	Obj interface{}
}

// ToAlpha retrieves the given version of the object.
func (m *MockTargetHttpsProxiesObj) ToAlpha() *alpha.TargetHttpsProxy {
	if ret, ok := m.Obj.(*alpha.TargetHttpsProxy); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &alpha.TargetHttpsProxy{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *alpha.TargetHttpsProxy via JSON: %v", m.Obj, err)
	}
	return ret
}

// ToBeta retrieves the given version of the object.
func (m *MockTargetHttpsProxiesObj) ToBeta() *beta.TargetHttpsProxy {
	if ret, ok := m.Obj.(*beta.TargetHttpsProxy); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &beta.TargetHttpsProxy{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *beta.TargetHttpsProxy via JSON: %v", m.Obj, err)
	}
	return ret
}

// ToGA retrieves the given version of the object.
func (m *MockTargetHttpsProxiesObj) ToGA() *ga.TargetHttpsProxy {
	if ret, ok := m.Obj.(*ga.TargetHttpsProxy); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &ga.TargetHttpsProxy{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *ga.TargetHttpsProxy via JSON: %v", m.Obj, err)
	}
	return ret
}

// MockTargetPoolsObj is used to store the various object versions in the shared
// map of mocked objects. This allows for multiple API versions to co-exist and
// share the same "view" of the objects in the backend.
type MockTargetPoolsObj struct {
	Obj interface{}
}

// ToGA retrieves the given version of the object.
func (m *MockTargetPoolsObj) ToGA() *ga.TargetPool {
	if ret, ok := m.Obj.(*ga.TargetPool); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &ga.TargetPool{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *ga.TargetPool via JSON: %v", m.Obj, err)
	}
	return ret
}

// MockTargetTcpProxiesObj is used to store the various object versions in the shared
// map of mocked objects. This allows for multiple API versions to co-exist and
// share the same "view" of the objects in the backend.
type MockTargetTcpProxiesObj struct {
	Obj interface{}
}

// ToAlpha retrieves the given version of the object.
func (m *MockTargetTcpProxiesObj) ToAlpha() *alpha.TargetTcpProxy {
	if ret, ok := m.Obj.(*alpha.TargetTcpProxy); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &alpha.TargetTcpProxy{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *alpha.TargetTcpProxy via JSON: %v", m.Obj, err)
	}
	return ret
}

// ToBeta retrieves the given version of the object.
func (m *MockTargetTcpProxiesObj) ToBeta() *beta.TargetTcpProxy {
	if ret, ok := m.Obj.(*beta.TargetTcpProxy); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &beta.TargetTcpProxy{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *beta.TargetTcpProxy via JSON: %v", m.Obj, err)
	}
	return ret
}

// MockUrlMapsObj is used to store the various object versions in the shared
// map of mocked objects. This allows for multiple API versions to co-exist and
// share the same "view" of the objects in the backend.
type MockUrlMapsObj struct {
	Obj interface{}
}

// ToAlpha retrieves the given version of the object.
func (m *MockUrlMapsObj) ToAlpha() *alpha.UrlMap {
	if ret, ok := m.Obj.(*alpha.UrlMap); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &alpha.UrlMap{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *alpha.UrlMap via JSON: %v", m.Obj, err)
	}
	return ret
}

// ToBeta retrieves the given version of the object.
func (m *MockUrlMapsObj) ToBeta() *beta.UrlMap {
	if ret, ok := m.Obj.(*beta.UrlMap); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &beta.UrlMap{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *beta.UrlMap via JSON: %v", m.Obj, err)
	}
	return ret
}

// ToGA retrieves the given version of the object.
func (m *MockUrlMapsObj) ToGA() *ga.UrlMap {
	if ret, ok := m.Obj.(*ga.UrlMap); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &ga.UrlMap{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *ga.UrlMap via JSON: %v", m.Obj, err)
	}
	return ret
}

// MockZonesObj is used to store the various object versions in the shared
// map of mocked objects. This allows for multiple API versions to co-exist and
// share the same "view" of the objects in the backend.
type MockZonesObj struct {
	Obj interface{}
}

// ToGA retrieves the given version of the object.
func (m *MockZonesObj) ToGA() *ga.Zone {
	if ret, ok := m.Obj.(*ga.Zone); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &ga.Zone{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *ga.Zone via JSON: %v", m.Obj, err)
	}
	return ret
}

// Addresses is an interface that allows for mocking of Addresses.
type Addresses interface {
	Get(ctx context.Context, key *meta.Key) (*ga.Address, error)
	List(ctx context.Context, region string, fl *filter.F) ([]*ga.Address, error)
	Insert(ctx context.Context, key *meta.Key, obj *ga.Address) error
	Delete(ctx context.Context, key *meta.Key) error
	AggregatedList(ctx context.Context, fl *filter.F) (map[string][]*ga.Address, error)
}

// NewMockAddresses returns a new mock for Addresses.
func NewMockAddresses(pr ProjectRouter, objs map[meta.Key]*MockAddressesObj) *MockAddresses {
	mock := &MockAddresses{
		ProjectRouter: pr,

		Objects:     objs,
		GetError:    map[meta.Key]error{},
		InsertError: map[meta.Key]error{},
		DeleteError: map[meta.Key]error{},
	}
	return mock
}

// MockAddresses is the mock for Addresses.
type MockAddresses struct {
	Lock sync.Mutex

	ProjectRouter ProjectRouter

	// Objects maintained by the mock.
	Objects map[meta.Key]*MockAddressesObj

	// If an entry exists for the given key and operation, then the error
	// will be returned instead of the operation.
	GetError            map[meta.Key]error
	ListError           *error
	InsertError         map[meta.Key]error
	DeleteError         map[meta.Key]error
	AggregatedListError *error

	// xxxHook allow you to intercept the standard processing of the mock in
	// order to add your own logic. Return (true, _, _) to prevent the normal
	// execution flow of the mock. Return (false, nil, nil) to continue with
	// normal mock behavior/ after the hook function executes.
	GetHook            func(ctx context.Context, key *meta.Key, m *MockAddresses) (bool, *ga.Address, error)
	ListHook           func(ctx context.Context, region string, fl *filter.F, m *MockAddresses) (bool, []*ga.Address, error)
	InsertHook         func(ctx context.Context, key *meta.Key, obj *ga.Address, m *MockAddresses) (bool, error)
	DeleteHook         func(ctx context.Context, key *meta.Key, m *MockAddresses) (bool, error)
	AggregatedListHook func(ctx context.Context, fl *filter.F, m *MockAddresses) (bool, map[string][]*ga.Address, error)

	// X is extra state that can be used as part of the mock. Generated code
	// will not use this field.
	X interface{}
}

// Get returns the object from the mock.
func (m *MockAddresses) Get(ctx context.Context, key *meta.Key) (*ga.Address, error) {
	if m.GetHook != nil {
		if intercept, obj, err := m.GetHook(ctx, key, m); intercept {
			klog.V(5).Infof("MockAddresses.Get(%v, %s) = %+v, %v", ctx, key, obj, err)
			return obj, err
		}
	}
	if !key.Valid() {
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.GetError[*key]; ok {
		klog.V(5).Infof("MockAddresses.Get(%v, %s) = nil, %v", ctx, key, err)
		return nil, err
	}
	if obj, ok := m.Objects[*key]; ok {
		typedObj := obj.ToGA()
		klog.V(5).Infof("MockAddresses.Get(%v, %s) = %+v, nil", ctx, key, typedObj)
		return typedObj, nil
	}

	err := &googleapi.Error{
		Code:    http.StatusNotFound,
		Message: fmt.Sprintf("MockAddresses %v not found", key),
	}
	klog.V(5).Infof("MockAddresses.Get(%v, %s) = nil, %v", ctx, key, err)
	return nil, err
}

// List all of the objects in the mock in the given region.
func (m *MockAddresses) List(ctx context.Context, region string, fl *filter.F) ([]*ga.Address, error) {
	if m.ListHook != nil {
		if intercept, objs, err := m.ListHook(ctx, region, fl, m); intercept {
			klog.V(5).Infof("MockAddresses.List(%v, %q, %v) = [%v items], %v", ctx, region, fl, len(objs), err)
			return objs, err
		}
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if m.ListError != nil {
		err := *m.ListError
		klog.V(5).Infof("MockAddresses.List(%v, %q, %v) = nil, %v", ctx, region, fl, err)

		return nil, *m.ListError
	}

	var objs []*ga.Address
	for key, obj := range m.Objects {
		if key.Region != region {
			continue
		}
		if !fl.Match(obj.ToGA()) {
			continue
		}
		objs = append(objs, obj.ToGA())
	}

	klog.V(5).Infof("MockAddresses.List(%v, %q, %v) = [%v items], nil", ctx, region, fl, len(objs))
	return objs, nil
}

// Insert is a mock for inserting/creating a new object.
func (m *MockAddresses) Insert(ctx context.Context, key *meta.Key, obj *ga.Address) error {
	if m.InsertHook != nil {
		if intercept, err := m.InsertHook(ctx, key, obj, m); intercept {
			klog.V(5).Infof("MockAddresses.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.InsertError[*key]; ok {
		klog.V(5).Infof("MockAddresses.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}
	if _, ok := m.Objects[*key]; ok {
		err := &googleapi.Error{
			Code:    http.StatusConflict,
			Message: fmt.Sprintf("MockAddresses %v exists", key),
		}
		klog.V(5).Infof("MockAddresses.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}

	obj.Name = key.Name
	projectID := m.ProjectRouter.ProjectID(ctx, "ga", "addresses")
	obj.SelfLink = SelfLink(meta.VersionGA, projectID, "addresses", key)

	m.Objects[*key] = &MockAddressesObj{obj}
	klog.V(5).Infof("MockAddresses.Insert(%v, %v, %+v) = nil", ctx, key, obj)
	return nil
}

// Delete is a mock for deleting the object.
func (m *MockAddresses) Delete(ctx context.Context, key *meta.Key) error {
	if m.DeleteHook != nil {
		if intercept, err := m.DeleteHook(ctx, key, m); intercept {
			klog.V(5).Infof("MockAddresses.Delete(%v, %v) = %v", ctx, key, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.DeleteError[*key]; ok {
		klog.V(5).Infof("MockAddresses.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}
	if _, ok := m.Objects[*key]; !ok {
		err := &googleapi.Error{
			Code:    http.StatusNotFound,
			Message: fmt.Sprintf("MockAddresses %v not found", key),
		}
		klog.V(5).Infof("MockAddresses.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	delete(m.Objects, *key)
	klog.V(5).Infof("MockAddresses.Delete(%v, %v) = nil", ctx, key)
	return nil
}

// AggregatedList is a mock for AggregatedList.
func (m *MockAddresses) AggregatedList(ctx context.Context, fl *filter.F) (map[string][]*ga.Address, error) {
	if m.AggregatedListHook != nil {
		if intercept, objs, err := m.AggregatedListHook(ctx, fl, m); intercept {
			klog.V(5).Infof("MockAddresses.AggregatedList(%v, %v) = [%v items], %v", ctx, fl, len(objs), err)
			return objs, err
		}
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if m.AggregatedListError != nil {
		err := *m.AggregatedListError
		klog.V(5).Infof("MockAddresses.AggregatedList(%v, %v) = nil, %v", ctx, fl, err)
		return nil, err
	}

	objs := map[string][]*ga.Address{}
	for _, obj := range m.Objects {
		res, err := ParseResourceURL(obj.ToGA().SelfLink)
		if err != nil {
			klog.V(5).Infof("MockAddresses.AggregatedList(%v, %v) = nil, %v", ctx, fl, err)
			return nil, err
		}
		if !fl.Match(obj.ToGA()) {
			continue
		}
		location := aggregatedListKey(res.Key)
		objs[location] = append(objs[location], obj.ToGA())
	}
	klog.V(5).Infof("MockAddresses.AggregatedList(%v, %v) = [%v items], nil", ctx, fl, len(objs))
	return objs, nil
}

// Obj wraps the object for use in the mock.
func (m *MockAddresses) Obj(o *ga.Address) *MockAddressesObj {
	return &MockAddressesObj{o}
}

// GCEAddresses is a simplifying adapter for the GCE Addresses.
type GCEAddresses struct {
	s *Service
}

// Get the Address named by key.
func (g *GCEAddresses) Get(ctx context.Context, key *meta.Key) (*ga.Address, error) {
	klog.V(5).Infof("GCEAddresses.Get(%v, %v): called", ctx, key)

	if !key.Valid() {
		klog.V(2).Infof("GCEAddresses.Get(%v, %v): key is invalid (%#v)", ctx, key, key)
		return nil, fmt.Errorf("invalid GCE key (%#v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "Addresses")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Get",
		Version:   meta.Version("ga"),
		Service:   "Addresses",
	}
	klog.V(5).Infof("GCEAddresses.Get(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEAddresses.Get(%v, %v): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.GA.Addresses.Get(projectID, key.Region, key.Name)
	call.Context(ctx)
	v, err := call.Do()
	klog.V(4).Infof("GCEAddresses.Get(%v, %v) = %+v, %v", ctx, key, v, err)
	return v, err
}

// List all Address objects.
func (g *GCEAddresses) List(ctx context.Context, region string, fl *filter.F) ([]*ga.Address, error) {
	klog.V(5).Infof("GCEAddresses.List(%v, %v, %v) called", ctx, region, fl)
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "Addresses")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "List",
		Version:   meta.Version("ga"),
		Service:   "Addresses",
	}
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		return nil, err
	}
	klog.V(5).Infof("GCEAddresses.List(%v, %v, %v): projectID = %v, rk = %+v", ctx, region, fl, projectID, rk)
	call := g.s.GA.Addresses.List(projectID, region)
	if fl != filter.None {
		call.Filter(fl.String())
	}
	var all []*ga.Address
	f := func(l *ga.AddressList) error {
		klog.V(5).Infof("GCEAddresses.List(%v, ..., %v): page %+v", ctx, fl, l)
		all = append(all, l.Items...)
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		klog.V(4).Infof("GCEAddresses.List(%v, ..., %v) = %v, %v", ctx, fl, nil, err)
		return nil, err
	}

	if klog.V(4).Enabled() {
		klog.V(4).Infof("GCEAddresses.List(%v, ..., %v) = [%v items], %v", ctx, fl, len(all), nil)
	} else if klog.V(5).Enabled() {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		klog.V(5).Infof("GCEAddresses.List(%v, ..., %v) = %v, %v", ctx, fl, asStr, nil)
	}

	return all, nil
}

// Insert Address with key of value obj.
func (g *GCEAddresses) Insert(ctx context.Context, key *meta.Key, obj *ga.Address) error {
	klog.V(5).Infof("GCEAddresses.Insert(%v, %v, %+v): called", ctx, key, obj)
	if !key.Valid() {
		klog.V(2).Infof("GCEAddresses.Insert(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "Addresses")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Insert",
		Version:   meta.Version("ga"),
		Service:   "Addresses",
	}
	klog.V(5).Infof("GCEAddresses.Insert(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEAddresses.Insert(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	obj.Name = key.Name
	call := g.s.GA.Addresses.Insert(projectID, key.Region, obj)
	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCEAddresses.Insert(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEAddresses.Insert(%v, %v, %+v) = %+v", ctx, key, obj, err)
	return err
}

// Delete the Address referenced by key.
func (g *GCEAddresses) Delete(ctx context.Context, key *meta.Key) error {
	klog.V(5).Infof("GCEAddresses.Delete(%v, %v): called", ctx, key)
	if !key.Valid() {
		klog.V(2).Infof("GCEAddresses.Delete(%v, %v): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "Addresses")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Delete",
		Version:   meta.Version("ga"),
		Service:   "Addresses",
	}
	klog.V(5).Infof("GCEAddresses.Delete(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEAddresses.Delete(%v, %v): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.GA.Addresses.Delete(projectID, key.Region, key.Name)
	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCEAddresses.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEAddresses.Delete(%v, %v) = %v", ctx, key, err)
	return err
}

// AggregatedList lists all resources of the given type across all locations.
func (g *GCEAddresses) AggregatedList(ctx context.Context, fl *filter.F) (map[string][]*ga.Address, error) {
	klog.V(5).Infof("GCEAddresses.AggregatedList(%v, %v) called", ctx, fl)

	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "Addresses")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "AggregatedList",
		Version:   meta.Version("ga"),
		Service:   "Addresses",
	}

	klog.V(5).Infof("GCEAddresses.AggregatedList(%v, %v): projectID = %v, rk = %+v", ctx, fl, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(5).Infof("GCEAddresses.AggregatedList(%v, %v): RateLimiter error: %v", ctx, fl, err)
		return nil, err
	}

	call := g.s.GA.Addresses.AggregatedList(projectID)
	call.Context(ctx)
	if fl != filter.None {
		call.Filter(fl.String())
	}

	all := map[string][]*ga.Address{}
	f := func(l *ga.AddressAggregatedList) error {
		for k, v := range l.Items {
			klog.V(5).Infof("GCEAddresses.AggregatedList(%v, %v): page[%v]%+v", ctx, fl, k, v)
			all[k] = append(all[k], v.Addresses...)
		}
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		klog.V(4).Infof("GCEAddresses.AggregatedList(%v, %v) = %v, %v", ctx, fl, nil, err)
		return nil, err
	}
	if klog.V(4).Enabled() {
		klog.V(4).Infof("GCEAddresses.AggregatedList(%v, %v) = [%v items], %v", ctx, fl, len(all), nil)
	} else if klog.V(5).Enabled() {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		klog.V(5).Infof("GCEAddresses.AggregatedList(%v, %v) = %v, %v", ctx, fl, asStr, nil)
	}
	return all, nil
}

// AlphaAddresses is an interface that allows for mocking of Addresses.
type AlphaAddresses interface {
	Get(ctx context.Context, key *meta.Key) (*alpha.Address, error)
	List(ctx context.Context, region string, fl *filter.F) ([]*alpha.Address, error)
	Insert(ctx context.Context, key *meta.Key, obj *alpha.Address) error
	Delete(ctx context.Context, key *meta.Key) error
	AggregatedList(ctx context.Context, fl *filter.F) (map[string][]*alpha.Address, error)
}

// NewMockAlphaAddresses returns a new mock for Addresses.
func NewMockAlphaAddresses(pr ProjectRouter, objs map[meta.Key]*MockAddressesObj) *MockAlphaAddresses {
	mock := &MockAlphaAddresses{
		ProjectRouter: pr,

		Objects:     objs,
		GetError:    map[meta.Key]error{},
		InsertError: map[meta.Key]error{},
		DeleteError: map[meta.Key]error{},
	}
	return mock
}

// MockAlphaAddresses is the mock for Addresses.
type MockAlphaAddresses struct {
	Lock sync.Mutex

	ProjectRouter ProjectRouter

	// Objects maintained by the mock.
	Objects map[meta.Key]*MockAddressesObj

	// If an entry exists for the given key and operation, then the error
	// will be returned instead of the operation.
	GetError            map[meta.Key]error
	ListError           *error
	InsertError         map[meta.Key]error
	DeleteError         map[meta.Key]error
	AggregatedListError *error

	// xxxHook allow you to intercept the standard processing of the mock in
	// order to add your own logic. Return (true, _, _) to prevent the normal
	// execution flow of the mock. Return (false, nil, nil) to continue with
	// normal mock behavior/ after the hook function executes.
	GetHook            func(ctx context.Context, key *meta.Key, m *MockAlphaAddresses) (bool, *alpha.Address, error)
	ListHook           func(ctx context.Context, region string, fl *filter.F, m *MockAlphaAddresses) (bool, []*alpha.Address, error)
	InsertHook         func(ctx context.Context, key *meta.Key, obj *alpha.Address, m *MockAlphaAddresses) (bool, error)
	DeleteHook         func(ctx context.Context, key *meta.Key, m *MockAlphaAddresses) (bool, error)
	AggregatedListHook func(ctx context.Context, fl *filter.F, m *MockAlphaAddresses) (bool, map[string][]*alpha.Address, error)

	// X is extra state that can be used as part of the mock. Generated code
	// will not use this field.
	X interface{}
}

// Get returns the object from the mock.
func (m *MockAlphaAddresses) Get(ctx context.Context, key *meta.Key) (*alpha.Address, error) {
	if m.GetHook != nil {
		if intercept, obj, err := m.GetHook(ctx, key, m); intercept {
			klog.V(5).Infof("MockAlphaAddresses.Get(%v, %s) = %+v, %v", ctx, key, obj, err)
			return obj, err
		}
	}
	if !key.Valid() {
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.GetError[*key]; ok {
		klog.V(5).Infof("MockAlphaAddresses.Get(%v, %s) = nil, %v", ctx, key, err)
		return nil, err
	}
	if obj, ok := m.Objects[*key]; ok {
		typedObj := obj.ToAlpha()
		klog.V(5).Infof("MockAlphaAddresses.Get(%v, %s) = %+v, nil", ctx, key, typedObj)
		return typedObj, nil
	}

	err := &googleapi.Error{
		Code:    http.StatusNotFound,
		Message: fmt.Sprintf("MockAlphaAddresses %v not found", key),
	}
	klog.V(5).Infof("MockAlphaAddresses.Get(%v, %s) = nil, %v", ctx, key, err)
	return nil, err
}

// List all of the objects in the mock in the given region.
func (m *MockAlphaAddresses) List(ctx context.Context, region string, fl *filter.F) ([]*alpha.Address, error) {
	if m.ListHook != nil {
		if intercept, objs, err := m.ListHook(ctx, region, fl, m); intercept {
			klog.V(5).Infof("MockAlphaAddresses.List(%v, %q, %v) = [%v items], %v", ctx, region, fl, len(objs), err)
			return objs, err
		}
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if m.ListError != nil {
		err := *m.ListError
		klog.V(5).Infof("MockAlphaAddresses.List(%v, %q, %v) = nil, %v", ctx, region, fl, err)

		return nil, *m.ListError
	}

	var objs []*alpha.Address
	for key, obj := range m.Objects {
		if key.Region != region {
			continue
		}
		if !fl.Match(obj.ToAlpha()) {
			continue
		}
		objs = append(objs, obj.ToAlpha())
	}

	klog.V(5).Infof("MockAlphaAddresses.List(%v, %q, %v) = [%v items], nil", ctx, region, fl, len(objs))
	return objs, nil
}

// Insert is a mock for inserting/creating a new object.
func (m *MockAlphaAddresses) Insert(ctx context.Context, key *meta.Key, obj *alpha.Address) error {
	if m.InsertHook != nil {
		if intercept, err := m.InsertHook(ctx, key, obj, m); intercept {
			klog.V(5).Infof("MockAlphaAddresses.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.InsertError[*key]; ok {
		klog.V(5).Infof("MockAlphaAddresses.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}
	if _, ok := m.Objects[*key]; ok {
		err := &googleapi.Error{
			Code:    http.StatusConflict,
			Message: fmt.Sprintf("MockAlphaAddresses %v exists", key),
		}
		klog.V(5).Infof("MockAlphaAddresses.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}

	obj.Name = key.Name
	projectID := m.ProjectRouter.ProjectID(ctx, "alpha", "addresses")
	obj.SelfLink = SelfLink(meta.VersionAlpha, projectID, "addresses", key)

	m.Objects[*key] = &MockAddressesObj{obj}
	klog.V(5).Infof("MockAlphaAddresses.Insert(%v, %v, %+v) = nil", ctx, key, obj)
	return nil
}

// Delete is a mock for deleting the object.
func (m *MockAlphaAddresses) Delete(ctx context.Context, key *meta.Key) error {
	if m.DeleteHook != nil {
		if intercept, err := m.DeleteHook(ctx, key, m); intercept {
			klog.V(5).Infof("MockAlphaAddresses.Delete(%v, %v) = %v", ctx, key, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.DeleteError[*key]; ok {
		klog.V(5).Infof("MockAlphaAddresses.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}
	if _, ok := m.Objects[*key]; !ok {
		err := &googleapi.Error{
			Code:    http.StatusNotFound,
			Message: fmt.Sprintf("MockAlphaAddresses %v not found", key),
		}
		klog.V(5).Infof("MockAlphaAddresses.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	delete(m.Objects, *key)
	klog.V(5).Infof("MockAlphaAddresses.Delete(%v, %v) = nil", ctx, key)
	return nil
}

// AggregatedList is a mock for AggregatedList.
func (m *MockAlphaAddresses) AggregatedList(ctx context.Context, fl *filter.F) (map[string][]*alpha.Address, error) {
	if m.AggregatedListHook != nil {
		if intercept, objs, err := m.AggregatedListHook(ctx, fl, m); intercept {
			klog.V(5).Infof("MockAlphaAddresses.AggregatedList(%v, %v) = [%v items], %v", ctx, fl, len(objs), err)
			return objs, err
		}
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if m.AggregatedListError != nil {
		err := *m.AggregatedListError
		klog.V(5).Infof("MockAlphaAddresses.AggregatedList(%v, %v) = nil, %v", ctx, fl, err)
		return nil, err
	}

	objs := map[string][]*alpha.Address{}
	for _, obj := range m.Objects {
		res, err := ParseResourceURL(obj.ToAlpha().SelfLink)
		if err != nil {
			klog.V(5).Infof("MockAlphaAddresses.AggregatedList(%v, %v) = nil, %v", ctx, fl, err)
			return nil, err
		}
		if !fl.Match(obj.ToAlpha()) {
			continue
		}
		location := aggregatedListKey(res.Key)
		objs[location] = append(objs[location], obj.ToAlpha())
	}
	klog.V(5).Infof("MockAlphaAddresses.AggregatedList(%v, %v) = [%v items], nil", ctx, fl, len(objs))
	return objs, nil
}

// Obj wraps the object for use in the mock.
func (m *MockAlphaAddresses) Obj(o *alpha.Address) *MockAddressesObj {
	return &MockAddressesObj{o}
}

// GCEAlphaAddresses is a simplifying adapter for the GCE Addresses.
type GCEAlphaAddresses struct {
	s *Service
}

// Get the Address named by key.
func (g *GCEAlphaAddresses) Get(ctx context.Context, key *meta.Key) (*alpha.Address, error) {
	klog.V(5).Infof("GCEAlphaAddresses.Get(%v, %v): called", ctx, key)

	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaAddresses.Get(%v, %v): key is invalid (%#v)", ctx, key, key)
		return nil, fmt.Errorf("invalid GCE key (%#v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "alpha", "Addresses")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Get",
		Version:   meta.Version("alpha"),
		Service:   "Addresses",
	}
	klog.V(5).Infof("GCEAlphaAddresses.Get(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEAlphaAddresses.Get(%v, %v): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.Alpha.Addresses.Get(projectID, key.Region, key.Name)
	call.Context(ctx)
	v, err := call.Do()
	klog.V(4).Infof("GCEAlphaAddresses.Get(%v, %v) = %+v, %v", ctx, key, v, err)
	return v, err
}

// List all Address objects.
func (g *GCEAlphaAddresses) List(ctx context.Context, region string, fl *filter.F) ([]*alpha.Address, error) {
	klog.V(5).Infof("GCEAlphaAddresses.List(%v, %v, %v) called", ctx, region, fl)
	projectID := g.s.ProjectRouter.ProjectID(ctx, "alpha", "Addresses")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "List",
		Version:   meta.Version("alpha"),
		Service:   "Addresses",
	}
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		return nil, err
	}
	klog.V(5).Infof("GCEAlphaAddresses.List(%v, %v, %v): projectID = %v, rk = %+v", ctx, region, fl, projectID, rk)
	call := g.s.Alpha.Addresses.List(projectID, region)
	if fl != filter.None {
		call.Filter(fl.String())
	}
	var all []*alpha.Address
	f := func(l *alpha.AddressList) error {
		klog.V(5).Infof("GCEAlphaAddresses.List(%v, ..., %v): page %+v", ctx, fl, l)
		all = append(all, l.Items...)
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		klog.V(4).Infof("GCEAlphaAddresses.List(%v, ..., %v) = %v, %v", ctx, fl, nil, err)
		return nil, err
	}

	if klog.V(4).Enabled() {
		klog.V(4).Infof("GCEAlphaAddresses.List(%v, ..., %v) = [%v items], %v", ctx, fl, len(all), nil)
	} else if klog.V(5).Enabled() {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		klog.V(5).Infof("GCEAlphaAddresses.List(%v, ..., %v) = %v, %v", ctx, fl, asStr, nil)
	}

	return all, nil
}

// Insert Address with key of value obj.
func (g *GCEAlphaAddresses) Insert(ctx context.Context, key *meta.Key, obj *alpha.Address) error {
	klog.V(5).Infof("GCEAlphaAddresses.Insert(%v, %v, %+v): called", ctx, key, obj)
	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaAddresses.Insert(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "alpha", "Addresses")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Insert",
		Version:   meta.Version("alpha"),
		Service:   "Addresses",
	}
	klog.V(5).Infof("GCEAlphaAddresses.Insert(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEAlphaAddresses.Insert(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	obj.Name = key.Name
	call := g.s.Alpha.Addresses.Insert(projectID, key.Region, obj)
	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCEAlphaAddresses.Insert(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEAlphaAddresses.Insert(%v, %v, %+v) = %+v", ctx, key, obj, err)
	return err
}

// Delete the Address referenced by key.
func (g *GCEAlphaAddresses) Delete(ctx context.Context, key *meta.Key) error {
	klog.V(5).Infof("GCEAlphaAddresses.Delete(%v, %v): called", ctx, key)
	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaAddresses.Delete(%v, %v): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "alpha", "Addresses")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Delete",
		Version:   meta.Version("alpha"),
		Service:   "Addresses",
	}
	klog.V(5).Infof("GCEAlphaAddresses.Delete(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEAlphaAddresses.Delete(%v, %v): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Alpha.Addresses.Delete(projectID, key.Region, key.Name)
	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCEAlphaAddresses.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEAlphaAddresses.Delete(%v, %v) = %v", ctx, key, err)
	return err
}

// AggregatedList lists all resources of the given type across all locations.
func (g *GCEAlphaAddresses) AggregatedList(ctx context.Context, fl *filter.F) (map[string][]*alpha.Address, error) {
	klog.V(5).Infof("GCEAlphaAddresses.AggregatedList(%v, %v) called", ctx, fl)

	projectID := g.s.ProjectRouter.ProjectID(ctx, "alpha", "Addresses")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "AggregatedList",
		Version:   meta.Version("alpha"),
		Service:   "Addresses",
	}

	klog.V(5).Infof("GCEAlphaAddresses.AggregatedList(%v, %v): projectID = %v, rk = %+v", ctx, fl, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(5).Infof("GCEAlphaAddresses.AggregatedList(%v, %v): RateLimiter error: %v", ctx, fl, err)
		return nil, err
	}

	call := g.s.Alpha.Addresses.AggregatedList(projectID)
	call.Context(ctx)
	if fl != filter.None {
		call.Filter(fl.String())
	}

	all := map[string][]*alpha.Address{}
	f := func(l *alpha.AddressAggregatedList) error {
		for k, v := range l.Items {
			klog.V(5).Infof("GCEAlphaAddresses.AggregatedList(%v, %v): page[%v]%+v", ctx, fl, k, v)
			all[k] = append(all[k], v.Addresses...)
		}
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		klog.V(4).Infof("GCEAlphaAddresses.AggregatedList(%v, %v) = %v, %v", ctx, fl, nil, err)
		return nil, err
	}
	if klog.V(4).Enabled() {
		klog.V(4).Infof("GCEAlphaAddresses.AggregatedList(%v, %v) = [%v items], %v", ctx, fl, len(all), nil)
	} else if klog.V(5).Enabled() {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		klog.V(5).Infof("GCEAlphaAddresses.AggregatedList(%v, %v) = %v, %v", ctx, fl, asStr, nil)
	}
	return all, nil
}

// BetaAddresses is an interface that allows for mocking of Addresses.
type BetaAddresses interface {
	Get(ctx context.Context, key *meta.Key) (*beta.Address, error)
	List(ctx context.Context, region string, fl *filter.F) ([]*beta.Address, error)
	Insert(ctx context.Context, key *meta.Key, obj *beta.Address) error
	Delete(ctx context.Context, key *meta.Key) error
	AggregatedList(ctx context.Context, fl *filter.F) (map[string][]*beta.Address, error)
}

// NewMockBetaAddresses returns a new mock for Addresses.
func NewMockBetaAddresses(pr ProjectRouter, objs map[meta.Key]*MockAddressesObj) *MockBetaAddresses {
	mock := &MockBetaAddresses{
		ProjectRouter: pr,

		Objects:     objs,
		GetError:    map[meta.Key]error{},
		InsertError: map[meta.Key]error{},
		DeleteError: map[meta.Key]error{},
	}
	return mock
}

// MockBetaAddresses is the mock for Addresses.
type MockBetaAddresses struct {
	Lock sync.Mutex

	ProjectRouter ProjectRouter

	// Objects maintained by the mock.
	Objects map[meta.Key]*MockAddressesObj

	// If an entry exists for the given key and operation, then the error
	// will be returned instead of the operation.
	GetError            map[meta.Key]error
	ListError           *error
	InsertError         map[meta.Key]error
	DeleteError         map[meta.Key]error
	AggregatedListError *error

	// xxxHook allow you to intercept the standard processing of the mock in
	// order to add your own logic. Return (true, _, _) to prevent the normal
	// execution flow of the mock. Return (false, nil, nil) to continue with
	// normal mock behavior/ after the hook function executes.
	GetHook            func(ctx context.Context, key *meta.Key, m *MockBetaAddresses) (bool, *beta.Address, error)
	ListHook           func(ctx context.Context, region string, fl *filter.F, m *MockBetaAddresses) (bool, []*beta.Address, error)
	InsertHook         func(ctx context.Context, key *meta.Key, obj *beta.Address, m *MockBetaAddresses) (bool, error)
	DeleteHook         func(ctx context.Context, key *meta.Key, m *MockBetaAddresses) (bool, error)
	AggregatedListHook func(ctx context.Context, fl *filter.F, m *MockBetaAddresses) (bool, map[string][]*beta.Address, error)

	// X is extra state that can be used as part of the mock. Generated code
	// will not use this field.
	X interface{}
}

// Get returns the object from the mock.
func (m *MockBetaAddresses) Get(ctx context.Context, key *meta.Key) (*beta.Address, error) {
	if m.GetHook != nil {
		if intercept, obj, err := m.GetHook(ctx, key, m); intercept {
			klog.V(5).Infof("MockBetaAddresses.Get(%v, %s) = %+v, %v", ctx, key, obj, err)
			return obj, err
		}
	}
	if !key.Valid() {
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.GetError[*key]; ok {
		klog.V(5).Infof("MockBetaAddresses.Get(%v, %s) = nil, %v", ctx, key, err)
		return nil, err
	}
	if obj, ok := m.Objects[*key]; ok {
		typedObj := obj.ToBeta()
		klog.V(5).Infof("MockBetaAddresses.Get(%v, %s) = %+v, nil", ctx, key, typedObj)
		return typedObj, nil
	}

	err := &googleapi.Error{
		Code:    http.StatusNotFound,
		Message: fmt.Sprintf("MockBetaAddresses %v not found", key),
	}
	klog.V(5).Infof("MockBetaAddresses.Get(%v, %s) = nil, %v", ctx, key, err)
	return nil, err
}

// List all of the objects in the mock in the given region.
func (m *MockBetaAddresses) List(ctx context.Context, region string, fl *filter.F) ([]*beta.Address, error) {
	if m.ListHook != nil {
		if intercept, objs, err := m.ListHook(ctx, region, fl, m); intercept {
			klog.V(5).Infof("MockBetaAddresses.List(%v, %q, %v) = [%v items], %v", ctx, region, fl, len(objs), err)
			return objs, err
		}
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if m.ListError != nil {
		err := *m.ListError
		klog.V(5).Infof("MockBetaAddresses.List(%v, %q, %v) = nil, %v", ctx, region, fl, err)

		return nil, *m.ListError
	}

	var objs []*beta.Address
	for key, obj := range m.Objects {
		if key.Region != region {
			continue
		}
		if !fl.Match(obj.ToBeta()) {
			continue
		}
		objs = append(objs, obj.ToBeta())
	}

	klog.V(5).Infof("MockBetaAddresses.List(%v, %q, %v) = [%v items], nil", ctx, region, fl, len(objs))
	return objs, nil
}

// Insert is a mock for inserting/creating a new object.
func (m *MockBetaAddresses) Insert(ctx context.Context, key *meta.Key, obj *beta.Address) error {
	if m.InsertHook != nil {
		if intercept, err := m.InsertHook(ctx, key, obj, m); intercept {
			klog.V(5).Infof("MockBetaAddresses.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.InsertError[*key]; ok {
		klog.V(5).Infof("MockBetaAddresses.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}
	if _, ok := m.Objects[*key]; ok {
		err := &googleapi.Error{
			Code:    http.StatusConflict,
			Message: fmt.Sprintf("MockBetaAddresses %v exists", key),
		}
		klog.V(5).Infof("MockBetaAddresses.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}

	obj.Name = key.Name
	projectID := m.ProjectRouter.ProjectID(ctx, "beta", "addresses")
	obj.SelfLink = SelfLink(meta.VersionBeta, projectID, "addresses", key)

	m.Objects[*key] = &MockAddressesObj{obj}
	klog.V(5).Infof("MockBetaAddresses.Insert(%v, %v, %+v) = nil", ctx, key, obj)
	return nil
}

// Delete is a mock for deleting the object.
func (m *MockBetaAddresses) Delete(ctx context.Context, key *meta.Key) error {
	if m.DeleteHook != nil {
		if intercept, err := m.DeleteHook(ctx, key, m); intercept {
			klog.V(5).Infof("MockBetaAddresses.Delete(%v, %v) = %v", ctx, key, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.DeleteError[*key]; ok {
		klog.V(5).Infof("MockBetaAddresses.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}
	if _, ok := m.Objects[*key]; !ok {
		err := &googleapi.Error{
			Code:    http.StatusNotFound,
			Message: fmt.Sprintf("MockBetaAddresses %v not found", key),
		}
		klog.V(5).Infof("MockBetaAddresses.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	delete(m.Objects, *key)
	klog.V(5).Infof("MockBetaAddresses.Delete(%v, %v) = nil", ctx, key)
	return nil
}

// AggregatedList is a mock for AggregatedList.
func (m *MockBetaAddresses) AggregatedList(ctx context.Context, fl *filter.F) (map[string][]*beta.Address, error) {
	if m.AggregatedListHook != nil {
		if intercept, objs, err := m.AggregatedListHook(ctx, fl, m); intercept {
			klog.V(5).Infof("MockBetaAddresses.AggregatedList(%v, %v) = [%v items], %v", ctx, fl, len(objs), err)
			return objs, err
		}
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if m.AggregatedListError != nil {
		err := *m.AggregatedListError
		klog.V(5).Infof("MockBetaAddresses.AggregatedList(%v, %v) = nil, %v", ctx, fl, err)
		return nil, err
	}

	objs := map[string][]*beta.Address{}
	for _, obj := range m.Objects {
		res, err := ParseResourceURL(obj.ToBeta().SelfLink)
		if err != nil {
			klog.V(5).Infof("MockBetaAddresses.AggregatedList(%v, %v) = nil, %v", ctx, fl, err)
			return nil, err
		}
		if !fl.Match(obj.ToBeta()) {
			continue
		}
		location := aggregatedListKey(res.Key)
		objs[location] = append(objs[location], obj.ToBeta())
	}
	klog.V(5).Infof("MockBetaAddresses.AggregatedList(%v, %v) = [%v items], nil", ctx, fl, len(objs))
	return objs, nil
}

// Obj wraps the object for use in the mock.
func (m *MockBetaAddresses) Obj(o *beta.Address) *MockAddressesObj {
	return &MockAddressesObj{o}
}

// GCEBetaAddresses is a simplifying adapter for the GCE Addresses.
type GCEBetaAddresses struct {
	s *Service
}

// Get the Address named by key.
func (g *GCEBetaAddresses) Get(ctx context.Context, key *meta.Key) (*beta.Address, error) {
	klog.V(5).Infof("GCEBetaAddresses.Get(%v, %v): called", ctx, key)

	if !key.Valid() {
		klog.V(2).Infof("GCEBetaAddresses.Get(%v, %v): key is invalid (%#v)", ctx, key, key)
		return nil, fmt.Errorf("invalid GCE key (%#v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "beta", "Addresses")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Get",
		Version:   meta.Version("beta"),
		Service:   "Addresses",
	}
	klog.V(5).Infof("GCEBetaAddresses.Get(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEBetaAddresses.Get(%v, %v): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.Beta.Addresses.Get(projectID, key.Region, key.Name)
	call.Context(ctx)
	v, err := call.Do()
	klog.V(4).Infof("GCEBetaAddresses.Get(%v, %v) = %+v, %v", ctx, key, v, err)
	return v, err
}

// List all Address objects.
func (g *GCEBetaAddresses) List(ctx context.Context, region string, fl *filter.F) ([]*beta.Address, error) {
	klog.V(5).Infof("GCEBetaAddresses.List(%v, %v, %v) called", ctx, region, fl)
	projectID := g.s.ProjectRouter.ProjectID(ctx, "beta", "Addresses")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "List",
		Version:   meta.Version("beta"),
		Service:   "Addresses",
	}
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		return nil, err
	}
	klog.V(5).Infof("GCEBetaAddresses.List(%v, %v, %v): projectID = %v, rk = %+v", ctx, region, fl, projectID, rk)
	call := g.s.Beta.Addresses.List(projectID, region)
	if fl != filter.None {
		call.Filter(fl.String())
	}
	var all []*beta.Address
	f := func(l *beta.AddressList) error {
		klog.V(5).Infof("GCEBetaAddresses.List(%v, ..., %v): page %+v", ctx, fl, l)
		all = append(all, l.Items...)
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		klog.V(4).Infof("GCEBetaAddresses.List(%v, ..., %v) = %v, %v", ctx, fl, nil, err)
		return nil, err
	}

	if klog.V(4).Enabled() {
		klog.V(4).Infof("GCEBetaAddresses.List(%v, ..., %v) = [%v items], %v", ctx, fl, len(all), nil)
	} else if klog.V(5).Enabled() {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		klog.V(5).Infof("GCEBetaAddresses.List(%v, ..., %v) = %v, %v", ctx, fl, asStr, nil)
	}

	return all, nil
}

// Insert Address with key of value obj.
func (g *GCEBetaAddresses) Insert(ctx context.Context, key *meta.Key, obj *beta.Address) error {
	klog.V(5).Infof("GCEBetaAddresses.Insert(%v, %v, %+v): called", ctx, key, obj)
	if !key.Valid() {
		klog.V(2).Infof("GCEBetaAddresses.Insert(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "beta", "Addresses")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Insert",
		Version:   meta.Version("beta"),
		Service:   "Addresses",
	}
	klog.V(5).Infof("GCEBetaAddresses.Insert(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEBetaAddresses.Insert(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	obj.Name = key.Name
	call := g.s.Beta.Addresses.Insert(projectID, key.Region, obj)
	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCEBetaAddresses.Insert(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEBetaAddresses.Insert(%v, %v, %+v) = %+v", ctx, key, obj, err)
	return err
}

// Delete the Address referenced by key.
func (g *GCEBetaAddresses) Delete(ctx context.Context, key *meta.Key) error {
	klog.V(5).Infof("GCEBetaAddresses.Delete(%v, %v): called", ctx, key)
	if !key.Valid() {
		klog.V(2).Infof("GCEBetaAddresses.Delete(%v, %v): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "beta", "Addresses")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Delete",
		Version:   meta.Version("beta"),
		Service:   "Addresses",
	}
	klog.V(5).Infof("GCEBetaAddresses.Delete(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEBetaAddresses.Delete(%v, %v): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Beta.Addresses.Delete(projectID, key.Region, key.Name)
	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCEBetaAddresses.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEBetaAddresses.Delete(%v, %v) = %v", ctx, key, err)
	return err
}

// AggregatedList lists all resources of the given type across all locations.
func (g *GCEBetaAddresses) AggregatedList(ctx context.Context, fl *filter.F) (map[string][]*beta.Address, error) {
	klog.V(5).Infof("GCEBetaAddresses.AggregatedList(%v, %v) called", ctx, fl)

	projectID := g.s.ProjectRouter.ProjectID(ctx, "beta", "Addresses")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "AggregatedList",
		Version:   meta.Version("beta"),
		Service:   "Addresses",
	}

	klog.V(5).Infof("GCEBetaAddresses.AggregatedList(%v, %v): projectID = %v, rk = %+v", ctx, fl, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(5).Infof("GCEBetaAddresses.AggregatedList(%v, %v): RateLimiter error: %v", ctx, fl, err)
		return nil, err
	}

	call := g.s.Beta.Addresses.AggregatedList(projectID)
	call.Context(ctx)
	if fl != filter.None {
		call.Filter(fl.String())
	}

	all := map[string][]*beta.Address{}
	f := func(l *beta.AddressAggregatedList) error {
		for k, v := range l.Items {
			klog.V(5).Infof("GCEBetaAddresses.AggregatedList(%v, %v): page[%v]%+v", ctx, fl, k, v)
			all[k] = append(all[k], v.Addresses...)
		}
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		klog.V(4).Infof("GCEBetaAddresses.AggregatedList(%v, %v) = %v, %v", ctx, fl, nil, err)
		return nil, err
	}
	if klog.V(4).Enabled() {
		klog.V(4).Infof("GCEBetaAddresses.AggregatedList(%v, %v) = [%v items], %v", ctx, fl, len(all), nil)
	} else if klog.V(5).Enabled() {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		klog.V(5).Infof("GCEBetaAddresses.AggregatedList(%v, %v) = %v, %v", ctx, fl, asStr, nil)
	}
	return all, nil
}

// AlphaGlobalAddresses is an interface that allows for mocking of GlobalAddresses.
type AlphaGlobalAddresses interface {
	Get(ctx context.Context, key *meta.Key) (*alpha.Address, error)
	List(ctx context.Context, fl *filter.F) ([]*alpha.Address, error)
	Insert(ctx context.Context, key *meta.Key, obj *alpha.Address) error
	Delete(ctx context.Context, key *meta.Key) error
}

// NewMockAlphaGlobalAddresses returns a new mock for GlobalAddresses.
func NewMockAlphaGlobalAddresses(pr ProjectRouter, objs map[meta.Key]*MockGlobalAddressesObj) *MockAlphaGlobalAddresses {
	mock := &MockAlphaGlobalAddresses{
		ProjectRouter: pr,

		Objects:     objs,
		GetError:    map[meta.Key]error{},
		InsertError: map[meta.Key]error{},
		DeleteError: map[meta.Key]error{},
	}
	return mock
}

// MockAlphaGlobalAddresses is the mock for GlobalAddresses.
type MockAlphaGlobalAddresses struct {
	Lock sync.Mutex

	ProjectRouter ProjectRouter

	// Objects maintained by the mock.
	Objects map[meta.Key]*MockGlobalAddressesObj

	// If an entry exists for the given key and operation, then the error
	// will be returned instead of the operation.
	GetError    map[meta.Key]error
	ListError   *error
	InsertError map[meta.Key]error
	DeleteError map[meta.Key]error

	// xxxHook allow you to intercept the standard processing of the mock in
	// order to add your own logic. Return (true, _, _) to prevent the normal
	// execution flow of the mock. Return (false, nil, nil) to continue with
	// normal mock behavior/ after the hook function executes.
	GetHook    func(ctx context.Context, key *meta.Key, m *MockAlphaGlobalAddresses) (bool, *alpha.Address, error)
	ListHook   func(ctx context.Context, fl *filter.F, m *MockAlphaGlobalAddresses) (bool, []*alpha.Address, error)
	InsertHook func(ctx context.Context, key *meta.Key, obj *alpha.Address, m *MockAlphaGlobalAddresses) (bool, error)
	DeleteHook func(ctx context.Context, key *meta.Key, m *MockAlphaGlobalAddresses) (bool, error)

	// X is extra state that can be used as part of the mock. Generated code
	// will not use this field.
	X interface{}
}

// Get returns the object from the mock.
func (m *MockAlphaGlobalAddresses) Get(ctx context.Context, key *meta.Key) (*alpha.Address, error) {
	if m.GetHook != nil {
		if intercept, obj, err := m.GetHook(ctx, key, m); intercept {
			klog.V(5).Infof("MockAlphaGlobalAddresses.Get(%v, %s) = %+v, %v", ctx, key, obj, err)
			return obj, err
		}
	}
	if !key.Valid() {
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.GetError[*key]; ok {
		klog.V(5).Infof("MockAlphaGlobalAddresses.Get(%v, %s) = nil, %v", ctx, key, err)
		return nil, err
	}
	if obj, ok := m.Objects[*key]; ok {
		typedObj := obj.ToAlpha()
		klog.V(5).Infof("MockAlphaGlobalAddresses.Get(%v, %s) = %+v, nil", ctx, key, typedObj)
		return typedObj, nil
	}

	err := &googleapi.Error{
		Code:    http.StatusNotFound,
		Message: fmt.Sprintf("MockAlphaGlobalAddresses %v not found", key),
	}
	klog.V(5).Infof("MockAlphaGlobalAddresses.Get(%v, %s) = nil, %v", ctx, key, err)
	return nil, err
}

// List all of the objects in the mock.
func (m *MockAlphaGlobalAddresses) List(ctx context.Context, fl *filter.F) ([]*alpha.Address, error) {
	if m.ListHook != nil {
		if intercept, objs, err := m.ListHook(ctx, fl, m); intercept {
			klog.V(5).Infof("MockAlphaGlobalAddresses.List(%v, %v) = [%v items], %v", ctx, fl, len(objs), err)
			return objs, err
		}
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if m.ListError != nil {
		err := *m.ListError
		klog.V(5).Infof("MockAlphaGlobalAddresses.List(%v, %v) = nil, %v", ctx, fl, err)

		return nil, *m.ListError
	}

	var objs []*alpha.Address
	for _, obj := range m.Objects {
		if !fl.Match(obj.ToAlpha()) {
			continue
		}
		objs = append(objs, obj.ToAlpha())
	}

	klog.V(5).Infof("MockAlphaGlobalAddresses.List(%v, %v) = [%v items], nil", ctx, fl, len(objs))
	return objs, nil
}

// Insert is a mock for inserting/creating a new object.
func (m *MockAlphaGlobalAddresses) Insert(ctx context.Context, key *meta.Key, obj *alpha.Address) error {
	if m.InsertHook != nil {
		if intercept, err := m.InsertHook(ctx, key, obj, m); intercept {
			klog.V(5).Infof("MockAlphaGlobalAddresses.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.InsertError[*key]; ok {
		klog.V(5).Infof("MockAlphaGlobalAddresses.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}
	if _, ok := m.Objects[*key]; ok {
		err := &googleapi.Error{
			Code:    http.StatusConflict,
			Message: fmt.Sprintf("MockAlphaGlobalAddresses %v exists", key),
		}
		klog.V(5).Infof("MockAlphaGlobalAddresses.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}

	obj.Name = key.Name
	projectID := m.ProjectRouter.ProjectID(ctx, "alpha", "addresses")
	obj.SelfLink = SelfLink(meta.VersionAlpha, projectID, "addresses", key)

	m.Objects[*key] = &MockGlobalAddressesObj{obj}
	klog.V(5).Infof("MockAlphaGlobalAddresses.Insert(%v, %v, %+v) = nil", ctx, key, obj)
	return nil
}

// Delete is a mock for deleting the object.
func (m *MockAlphaGlobalAddresses) Delete(ctx context.Context, key *meta.Key) error {
	if m.DeleteHook != nil {
		if intercept, err := m.DeleteHook(ctx, key, m); intercept {
			klog.V(5).Infof("MockAlphaGlobalAddresses.Delete(%v, %v) = %v", ctx, key, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.DeleteError[*key]; ok {
		klog.V(5).Infof("MockAlphaGlobalAddresses.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}
	if _, ok := m.Objects[*key]; !ok {
		err := &googleapi.Error{
			Code:    http.StatusNotFound,
			Message: fmt.Sprintf("MockAlphaGlobalAddresses %v not found", key),
		}
		klog.V(5).Infof("MockAlphaGlobalAddresses.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	delete(m.Objects, *key)
	klog.V(5).Infof("MockAlphaGlobalAddresses.Delete(%v, %v) = nil", ctx, key)
	return nil
}

// Obj wraps the object for use in the mock.
func (m *MockAlphaGlobalAddresses) Obj(o *alpha.Address) *MockGlobalAddressesObj {
	return &MockGlobalAddressesObj{o}
}

// GCEAlphaGlobalAddresses is a simplifying adapter for the GCE GlobalAddresses.
type GCEAlphaGlobalAddresses struct {
	s *Service
}

// Get the Address named by key.
func (g *GCEAlphaGlobalAddresses) Get(ctx context.Context, key *meta.Key) (*alpha.Address, error) {
	klog.V(5).Infof("GCEAlphaGlobalAddresses.Get(%v, %v): called", ctx, key)

	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaGlobalAddresses.Get(%v, %v): key is invalid (%#v)", ctx, key, key)
		return nil, fmt.Errorf("invalid GCE key (%#v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "alpha", "GlobalAddresses")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Get",
		Version:   meta.Version("alpha"),
		Service:   "GlobalAddresses",
	}
	klog.V(5).Infof("GCEAlphaGlobalAddresses.Get(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEAlphaGlobalAddresses.Get(%v, %v): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.Alpha.GlobalAddresses.Get(projectID, key.Name)
	call.Context(ctx)
	v, err := call.Do()
	klog.V(4).Infof("GCEAlphaGlobalAddresses.Get(%v, %v) = %+v, %v", ctx, key, v, err)
	return v, err
}

// List all Address objects.
func (g *GCEAlphaGlobalAddresses) List(ctx context.Context, fl *filter.F) ([]*alpha.Address, error) {
	klog.V(5).Infof("GCEAlphaGlobalAddresses.List(%v, %v) called", ctx, fl)
	projectID := g.s.ProjectRouter.ProjectID(ctx, "alpha", "GlobalAddresses")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "List",
		Version:   meta.Version("alpha"),
		Service:   "GlobalAddresses",
	}
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		return nil, err
	}
	klog.V(5).Infof("GCEAlphaGlobalAddresses.List(%v, %v): projectID = %v, rk = %+v", ctx, fl, projectID, rk)
	call := g.s.Alpha.GlobalAddresses.List(projectID)
	if fl != filter.None {
		call.Filter(fl.String())
	}
	var all []*alpha.Address
	f := func(l *alpha.AddressList) error {
		klog.V(5).Infof("GCEAlphaGlobalAddresses.List(%v, ..., %v): page %+v", ctx, fl, l)
		all = append(all, l.Items...)
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		klog.V(4).Infof("GCEAlphaGlobalAddresses.List(%v, ..., %v) = %v, %v", ctx, fl, nil, err)
		return nil, err
	}

	if klog.V(4).Enabled() {
		klog.V(4).Infof("GCEAlphaGlobalAddresses.List(%v, ..., %v) = [%v items], %v", ctx, fl, len(all), nil)
	} else if klog.V(5).Enabled() {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		klog.V(5).Infof("GCEAlphaGlobalAddresses.List(%v, ..., %v) = %v, %v", ctx, fl, asStr, nil)
	}

	return all, nil
}

// Insert Address with key of value obj.
func (g *GCEAlphaGlobalAddresses) Insert(ctx context.Context, key *meta.Key, obj *alpha.Address) error {
	klog.V(5).Infof("GCEAlphaGlobalAddresses.Insert(%v, %v, %+v): called", ctx, key, obj)
	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaGlobalAddresses.Insert(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "alpha", "GlobalAddresses")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Insert",
		Version:   meta.Version("alpha"),
		Service:   "GlobalAddresses",
	}
	klog.V(5).Infof("GCEAlphaGlobalAddresses.Insert(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEAlphaGlobalAddresses.Insert(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	obj.Name = key.Name
	call := g.s.Alpha.GlobalAddresses.Insert(projectID, obj)
	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCEAlphaGlobalAddresses.Insert(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEAlphaGlobalAddresses.Insert(%v, %v, %+v) = %+v", ctx, key, obj, err)
	return err
}

// Delete the Address referenced by key.
func (g *GCEAlphaGlobalAddresses) Delete(ctx context.Context, key *meta.Key) error {
	klog.V(5).Infof("GCEAlphaGlobalAddresses.Delete(%v, %v): called", ctx, key)
	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaGlobalAddresses.Delete(%v, %v): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "alpha", "GlobalAddresses")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Delete",
		Version:   meta.Version("alpha"),
		Service:   "GlobalAddresses",
	}
	klog.V(5).Infof("GCEAlphaGlobalAddresses.Delete(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEAlphaGlobalAddresses.Delete(%v, %v): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Alpha.GlobalAddresses.Delete(projectID, key.Name)

	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCEAlphaGlobalAddresses.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEAlphaGlobalAddresses.Delete(%v, %v) = %v", ctx, key, err)
	return err
}

// BetaGlobalAddresses is an interface that allows for mocking of GlobalAddresses.
type BetaGlobalAddresses interface {
	Get(ctx context.Context, key *meta.Key) (*beta.Address, error)
	List(ctx context.Context, fl *filter.F) ([]*beta.Address, error)
	Insert(ctx context.Context, key *meta.Key, obj *beta.Address) error
	Delete(ctx context.Context, key *meta.Key) error
}

// NewMockBetaGlobalAddresses returns a new mock for GlobalAddresses.
func NewMockBetaGlobalAddresses(pr ProjectRouter, objs map[meta.Key]*MockGlobalAddressesObj) *MockBetaGlobalAddresses {
	mock := &MockBetaGlobalAddresses{
		ProjectRouter: pr,

		Objects:     objs,
		GetError:    map[meta.Key]error{},
		InsertError: map[meta.Key]error{},
		DeleteError: map[meta.Key]error{},
	}
	return mock
}

// MockBetaGlobalAddresses is the mock for GlobalAddresses.
type MockBetaGlobalAddresses struct {
	Lock sync.Mutex

	ProjectRouter ProjectRouter

	// Objects maintained by the mock.
	Objects map[meta.Key]*MockGlobalAddressesObj

	// If an entry exists for the given key and operation, then the error
	// will be returned instead of the operation.
	GetError    map[meta.Key]error
	ListError   *error
	InsertError map[meta.Key]error
	DeleteError map[meta.Key]error

	// xxxHook allow you to intercept the standard processing of the mock in
	// order to add your own logic. Return (true, _, _) to prevent the normal
	// execution flow of the mock. Return (false, nil, nil) to continue with
	// normal mock behavior/ after the hook function executes.
	GetHook    func(ctx context.Context, key *meta.Key, m *MockBetaGlobalAddresses) (bool, *beta.Address, error)
	ListHook   func(ctx context.Context, fl *filter.F, m *MockBetaGlobalAddresses) (bool, []*beta.Address, error)
	InsertHook func(ctx context.Context, key *meta.Key, obj *beta.Address, m *MockBetaGlobalAddresses) (bool, error)
	DeleteHook func(ctx context.Context, key *meta.Key, m *MockBetaGlobalAddresses) (bool, error)

	// X is extra state that can be used as part of the mock. Generated code
	// will not use this field.
	X interface{}
}

// Get returns the object from the mock.
func (m *MockBetaGlobalAddresses) Get(ctx context.Context, key *meta.Key) (*beta.Address, error) {
	if m.GetHook != nil {
		if intercept, obj, err := m.GetHook(ctx, key, m); intercept {
			klog.V(5).Infof("MockBetaGlobalAddresses.Get(%v, %s) = %+v, %v", ctx, key, obj, err)
			return obj, err
		}
	}
	if !key.Valid() {
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.GetError[*key]; ok {
		klog.V(5).Infof("MockBetaGlobalAddresses.Get(%v, %s) = nil, %v", ctx, key, err)
		return nil, err
	}
	if obj, ok := m.Objects[*key]; ok {
		typedObj := obj.ToBeta()
		klog.V(5).Infof("MockBetaGlobalAddresses.Get(%v, %s) = %+v, nil", ctx, key, typedObj)
		return typedObj, nil
	}

	err := &googleapi.Error{
		Code:    http.StatusNotFound,
		Message: fmt.Sprintf("MockBetaGlobalAddresses %v not found", key),
	}
	klog.V(5).Infof("MockBetaGlobalAddresses.Get(%v, %s) = nil, %v", ctx, key, err)
	return nil, err
}

// List all of the objects in the mock.
func (m *MockBetaGlobalAddresses) List(ctx context.Context, fl *filter.F) ([]*beta.Address, error) {
	if m.ListHook != nil {
		if intercept, objs, err := m.ListHook(ctx, fl, m); intercept {
			klog.V(5).Infof("MockBetaGlobalAddresses.List(%v, %v) = [%v items], %v", ctx, fl, len(objs), err)
			return objs, err
		}
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if m.ListError != nil {
		err := *m.ListError
		klog.V(5).Infof("MockBetaGlobalAddresses.List(%v, %v) = nil, %v", ctx, fl, err)

		return nil, *m.ListError
	}

	var objs []*beta.Address
	for _, obj := range m.Objects {
		if !fl.Match(obj.ToBeta()) {
			continue
		}
		objs = append(objs, obj.ToBeta())
	}

	klog.V(5).Infof("MockBetaGlobalAddresses.List(%v, %v) = [%v items], nil", ctx, fl, len(objs))
	return objs, nil
}

// Insert is a mock for inserting/creating a new object.
func (m *MockBetaGlobalAddresses) Insert(ctx context.Context, key *meta.Key, obj *beta.Address) error {
	if m.InsertHook != nil {
		if intercept, err := m.InsertHook(ctx, key, obj, m); intercept {
			klog.V(5).Infof("MockBetaGlobalAddresses.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.InsertError[*key]; ok {
		klog.V(5).Infof("MockBetaGlobalAddresses.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}
	if _, ok := m.Objects[*key]; ok {
		err := &googleapi.Error{
			Code:    http.StatusConflict,
			Message: fmt.Sprintf("MockBetaGlobalAddresses %v exists", key),
		}
		klog.V(5).Infof("MockBetaGlobalAddresses.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}

	obj.Name = key.Name
	projectID := m.ProjectRouter.ProjectID(ctx, "beta", "addresses")
	obj.SelfLink = SelfLink(meta.VersionBeta, projectID, "addresses", key)

	m.Objects[*key] = &MockGlobalAddressesObj{obj}
	klog.V(5).Infof("MockBetaGlobalAddresses.Insert(%v, %v, %+v) = nil", ctx, key, obj)
	return nil
}

// Delete is a mock for deleting the object.
func (m *MockBetaGlobalAddresses) Delete(ctx context.Context, key *meta.Key) error {
	if m.DeleteHook != nil {
		if intercept, err := m.DeleteHook(ctx, key, m); intercept {
			klog.V(5).Infof("MockBetaGlobalAddresses.Delete(%v, %v) = %v", ctx, key, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.DeleteError[*key]; ok {
		klog.V(5).Infof("MockBetaGlobalAddresses.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}
	if _, ok := m.Objects[*key]; !ok {
		err := &googleapi.Error{
			Code:    http.StatusNotFound,
			Message: fmt.Sprintf("MockBetaGlobalAddresses %v not found", key),
		}
		klog.V(5).Infof("MockBetaGlobalAddresses.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	delete(m.Objects, *key)
	klog.V(5).Infof("MockBetaGlobalAddresses.Delete(%v, %v) = nil", ctx, key)
	return nil
}

// Obj wraps the object for use in the mock.
func (m *MockBetaGlobalAddresses) Obj(o *beta.Address) *MockGlobalAddressesObj {
	return &MockGlobalAddressesObj{o}
}

// GCEBetaGlobalAddresses is a simplifying adapter for the GCE GlobalAddresses.
type GCEBetaGlobalAddresses struct {
	s *Service
}

// Get the Address named by key.
func (g *GCEBetaGlobalAddresses) Get(ctx context.Context, key *meta.Key) (*beta.Address, error) {
	klog.V(5).Infof("GCEBetaGlobalAddresses.Get(%v, %v): called", ctx, key)

	if !key.Valid() {
		klog.V(2).Infof("GCEBetaGlobalAddresses.Get(%v, %v): key is invalid (%#v)", ctx, key, key)
		return nil, fmt.Errorf("invalid GCE key (%#v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "beta", "GlobalAddresses")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Get",
		Version:   meta.Version("beta"),
		Service:   "GlobalAddresses",
	}
	klog.V(5).Infof("GCEBetaGlobalAddresses.Get(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEBetaGlobalAddresses.Get(%v, %v): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.Beta.GlobalAddresses.Get(projectID, key.Name)
	call.Context(ctx)
	v, err := call.Do()
	klog.V(4).Infof("GCEBetaGlobalAddresses.Get(%v, %v) = %+v, %v", ctx, key, v, err)
	return v, err
}

// List all Address objects.
func (g *GCEBetaGlobalAddresses) List(ctx context.Context, fl *filter.F) ([]*beta.Address, error) {
	klog.V(5).Infof("GCEBetaGlobalAddresses.List(%v, %v) called", ctx, fl)
	projectID := g.s.ProjectRouter.ProjectID(ctx, "beta", "GlobalAddresses")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "List",
		Version:   meta.Version("beta"),
		Service:   "GlobalAddresses",
	}
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		return nil, err
	}
	klog.V(5).Infof("GCEBetaGlobalAddresses.List(%v, %v): projectID = %v, rk = %+v", ctx, fl, projectID, rk)
	call := g.s.Beta.GlobalAddresses.List(projectID)
	if fl != filter.None {
		call.Filter(fl.String())
	}
	var all []*beta.Address
	f := func(l *beta.AddressList) error {
		klog.V(5).Infof("GCEBetaGlobalAddresses.List(%v, ..., %v): page %+v", ctx, fl, l)
		all = append(all, l.Items...)
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		klog.V(4).Infof("GCEBetaGlobalAddresses.List(%v, ..., %v) = %v, %v", ctx, fl, nil, err)
		return nil, err
	}

	if klog.V(4).Enabled() {
		klog.V(4).Infof("GCEBetaGlobalAddresses.List(%v, ..., %v) = [%v items], %v", ctx, fl, len(all), nil)
	} else if klog.V(5).Enabled() {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		klog.V(5).Infof("GCEBetaGlobalAddresses.List(%v, ..., %v) = %v, %v", ctx, fl, asStr, nil)
	}

	return all, nil
}

// Insert Address with key of value obj.
func (g *GCEBetaGlobalAddresses) Insert(ctx context.Context, key *meta.Key, obj *beta.Address) error {
	klog.V(5).Infof("GCEBetaGlobalAddresses.Insert(%v, %v, %+v): called", ctx, key, obj)
	if !key.Valid() {
		klog.V(2).Infof("GCEBetaGlobalAddresses.Insert(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "beta", "GlobalAddresses")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Insert",
		Version:   meta.Version("beta"),
		Service:   "GlobalAddresses",
	}
	klog.V(5).Infof("GCEBetaGlobalAddresses.Insert(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEBetaGlobalAddresses.Insert(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	obj.Name = key.Name
	call := g.s.Beta.GlobalAddresses.Insert(projectID, obj)
	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCEBetaGlobalAddresses.Insert(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEBetaGlobalAddresses.Insert(%v, %v, %+v) = %+v", ctx, key, obj, err)
	return err
}

// Delete the Address referenced by key.
func (g *GCEBetaGlobalAddresses) Delete(ctx context.Context, key *meta.Key) error {
	klog.V(5).Infof("GCEBetaGlobalAddresses.Delete(%v, %v): called", ctx, key)
	if !key.Valid() {
		klog.V(2).Infof("GCEBetaGlobalAddresses.Delete(%v, %v): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "beta", "GlobalAddresses")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Delete",
		Version:   meta.Version("beta"),
		Service:   "GlobalAddresses",
	}
	klog.V(5).Infof("GCEBetaGlobalAddresses.Delete(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEBetaGlobalAddresses.Delete(%v, %v): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Beta.GlobalAddresses.Delete(projectID, key.Name)

	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCEBetaGlobalAddresses.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEBetaGlobalAddresses.Delete(%v, %v) = %v", ctx, key, err)
	return err
}

// GlobalAddresses is an interface that allows for mocking of GlobalAddresses.
type GlobalAddresses interface {
	Get(ctx context.Context, key *meta.Key) (*ga.Address, error)
	List(ctx context.Context, fl *filter.F) ([]*ga.Address, error)
	Insert(ctx context.Context, key *meta.Key, obj *ga.Address) error
	Delete(ctx context.Context, key *meta.Key) error
}

// NewMockGlobalAddresses returns a new mock for GlobalAddresses.
func NewMockGlobalAddresses(pr ProjectRouter, objs map[meta.Key]*MockGlobalAddressesObj) *MockGlobalAddresses {
	mock := &MockGlobalAddresses{
		ProjectRouter: pr,

		Objects:     objs,
		GetError:    map[meta.Key]error{},
		InsertError: map[meta.Key]error{},
		DeleteError: map[meta.Key]error{},
	}
	return mock
}

// MockGlobalAddresses is the mock for GlobalAddresses.
type MockGlobalAddresses struct {
	Lock sync.Mutex

	ProjectRouter ProjectRouter

	// Objects maintained by the mock.
	Objects map[meta.Key]*MockGlobalAddressesObj

	// If an entry exists for the given key and operation, then the error
	// will be returned instead of the operation.
	GetError    map[meta.Key]error
	ListError   *error
	InsertError map[meta.Key]error
	DeleteError map[meta.Key]error

	// xxxHook allow you to intercept the standard processing of the mock in
	// order to add your own logic. Return (true, _, _) to prevent the normal
	// execution flow of the mock. Return (false, nil, nil) to continue with
	// normal mock behavior/ after the hook function executes.
	GetHook    func(ctx context.Context, key *meta.Key, m *MockGlobalAddresses) (bool, *ga.Address, error)
	ListHook   func(ctx context.Context, fl *filter.F, m *MockGlobalAddresses) (bool, []*ga.Address, error)
	InsertHook func(ctx context.Context, key *meta.Key, obj *ga.Address, m *MockGlobalAddresses) (bool, error)
	DeleteHook func(ctx context.Context, key *meta.Key, m *MockGlobalAddresses) (bool, error)

	// X is extra state that can be used as part of the mock. Generated code
	// will not use this field.
	X interface{}
}

// Get returns the object from the mock.
func (m *MockGlobalAddresses) Get(ctx context.Context, key *meta.Key) (*ga.Address, error) {
	if m.GetHook != nil {
		if intercept, obj, err := m.GetHook(ctx, key, m); intercept {
			klog.V(5).Infof("MockGlobalAddresses.Get(%v, %s) = %+v, %v", ctx, key, obj, err)
			return obj, err
		}
	}
	if !key.Valid() {
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.GetError[*key]; ok {
		klog.V(5).Infof("MockGlobalAddresses.Get(%v, %s) = nil, %v", ctx, key, err)
		return nil, err
	}
	if obj, ok := m.Objects[*key]; ok {
		typedObj := obj.ToGA()
		klog.V(5).Infof("MockGlobalAddresses.Get(%v, %s) = %+v, nil", ctx, key, typedObj)
		return typedObj, nil
	}

	err := &googleapi.Error{
		Code:    http.StatusNotFound,
		Message: fmt.Sprintf("MockGlobalAddresses %v not found", key),
	}
	klog.V(5).Infof("MockGlobalAddresses.Get(%v, %s) = nil, %v", ctx, key, err)
	return nil, err
}

// List all of the objects in the mock.
func (m *MockGlobalAddresses) List(ctx context.Context, fl *filter.F) ([]*ga.Address, error) {
	if m.ListHook != nil {
		if intercept, objs, err := m.ListHook(ctx, fl, m); intercept {
			klog.V(5).Infof("MockGlobalAddresses.List(%v, %v) = [%v items], %v", ctx, fl, len(objs), err)
			return objs, err
		}
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if m.ListError != nil {
		err := *m.ListError
		klog.V(5).Infof("MockGlobalAddresses.List(%v, %v) = nil, %v", ctx, fl, err)

		return nil, *m.ListError
	}

	var objs []*ga.Address
	for _, obj := range m.Objects {
		if !fl.Match(obj.ToGA()) {
			continue
		}
		objs = append(objs, obj.ToGA())
	}

	klog.V(5).Infof("MockGlobalAddresses.List(%v, %v) = [%v items], nil", ctx, fl, len(objs))
	return objs, nil
}

// Insert is a mock for inserting/creating a new object.
func (m *MockGlobalAddresses) Insert(ctx context.Context, key *meta.Key, obj *ga.Address) error {
	if m.InsertHook != nil {
		if intercept, err := m.InsertHook(ctx, key, obj, m); intercept {
			klog.V(5).Infof("MockGlobalAddresses.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.InsertError[*key]; ok {
		klog.V(5).Infof("MockGlobalAddresses.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}
	if _, ok := m.Objects[*key]; ok {
		err := &googleapi.Error{
			Code:    http.StatusConflict,
			Message: fmt.Sprintf("MockGlobalAddresses %v exists", key),
		}
		klog.V(5).Infof("MockGlobalAddresses.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}

	obj.Name = key.Name
	projectID := m.ProjectRouter.ProjectID(ctx, "ga", "addresses")
	obj.SelfLink = SelfLink(meta.VersionGA, projectID, "addresses", key)

	m.Objects[*key] = &MockGlobalAddressesObj{obj}
	klog.V(5).Infof("MockGlobalAddresses.Insert(%v, %v, %+v) = nil", ctx, key, obj)
	return nil
}

// Delete is a mock for deleting the object.
func (m *MockGlobalAddresses) Delete(ctx context.Context, key *meta.Key) error {
	if m.DeleteHook != nil {
		if intercept, err := m.DeleteHook(ctx, key, m); intercept {
			klog.V(5).Infof("MockGlobalAddresses.Delete(%v, %v) = %v", ctx, key, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.DeleteError[*key]; ok {
		klog.V(5).Infof("MockGlobalAddresses.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}
	if _, ok := m.Objects[*key]; !ok {
		err := &googleapi.Error{
			Code:    http.StatusNotFound,
			Message: fmt.Sprintf("MockGlobalAddresses %v not found", key),
		}
		klog.V(5).Infof("MockGlobalAddresses.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	delete(m.Objects, *key)
	klog.V(5).Infof("MockGlobalAddresses.Delete(%v, %v) = nil", ctx, key)
	return nil
}

// Obj wraps the object for use in the mock.
func (m *MockGlobalAddresses) Obj(o *ga.Address) *MockGlobalAddressesObj {
	return &MockGlobalAddressesObj{o}
}

// GCEGlobalAddresses is a simplifying adapter for the GCE GlobalAddresses.
type GCEGlobalAddresses struct {
	s *Service
}

// Get the Address named by key.
func (g *GCEGlobalAddresses) Get(ctx context.Context, key *meta.Key) (*ga.Address, error) {
	klog.V(5).Infof("GCEGlobalAddresses.Get(%v, %v): called", ctx, key)

	if !key.Valid() {
		klog.V(2).Infof("GCEGlobalAddresses.Get(%v, %v): key is invalid (%#v)", ctx, key, key)
		return nil, fmt.Errorf("invalid GCE key (%#v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "GlobalAddresses")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Get",
		Version:   meta.Version("ga"),
		Service:   "GlobalAddresses",
	}
	klog.V(5).Infof("GCEGlobalAddresses.Get(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEGlobalAddresses.Get(%v, %v): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.GA.GlobalAddresses.Get(projectID, key.Name)
	call.Context(ctx)
	v, err := call.Do()
	klog.V(4).Infof("GCEGlobalAddresses.Get(%v, %v) = %+v, %v", ctx, key, v, err)
	return v, err
}

// List all Address objects.
func (g *GCEGlobalAddresses) List(ctx context.Context, fl *filter.F) ([]*ga.Address, error) {
	klog.V(5).Infof("GCEGlobalAddresses.List(%v, %v) called", ctx, fl)
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "GlobalAddresses")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "List",
		Version:   meta.Version("ga"),
		Service:   "GlobalAddresses",
	}
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		return nil, err
	}
	klog.V(5).Infof("GCEGlobalAddresses.List(%v, %v): projectID = %v, rk = %+v", ctx, fl, projectID, rk)
	call := g.s.GA.GlobalAddresses.List(projectID)
	if fl != filter.None {
		call.Filter(fl.String())
	}
	var all []*ga.Address
	f := func(l *ga.AddressList) error {
		klog.V(5).Infof("GCEGlobalAddresses.List(%v, ..., %v): page %+v", ctx, fl, l)
		all = append(all, l.Items...)
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		klog.V(4).Infof("GCEGlobalAddresses.List(%v, ..., %v) = %v, %v", ctx, fl, nil, err)
		return nil, err
	}

	if klog.V(4).Enabled() {
		klog.V(4).Infof("GCEGlobalAddresses.List(%v, ..., %v) = [%v items], %v", ctx, fl, len(all), nil)
	} else if klog.V(5).Enabled() {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		klog.V(5).Infof("GCEGlobalAddresses.List(%v, ..., %v) = %v, %v", ctx, fl, asStr, nil)
	}

	return all, nil
}

// Insert Address with key of value obj.
func (g *GCEGlobalAddresses) Insert(ctx context.Context, key *meta.Key, obj *ga.Address) error {
	klog.V(5).Infof("GCEGlobalAddresses.Insert(%v, %v, %+v): called", ctx, key, obj)
	if !key.Valid() {
		klog.V(2).Infof("GCEGlobalAddresses.Insert(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "GlobalAddresses")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Insert",
		Version:   meta.Version("ga"),
		Service:   "GlobalAddresses",
	}
	klog.V(5).Infof("GCEGlobalAddresses.Insert(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEGlobalAddresses.Insert(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	obj.Name = key.Name
	call := g.s.GA.GlobalAddresses.Insert(projectID, obj)
	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCEGlobalAddresses.Insert(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEGlobalAddresses.Insert(%v, %v, %+v) = %+v", ctx, key, obj, err)
	return err
}

// Delete the Address referenced by key.
func (g *GCEGlobalAddresses) Delete(ctx context.Context, key *meta.Key) error {
	klog.V(5).Infof("GCEGlobalAddresses.Delete(%v, %v): called", ctx, key)
	if !key.Valid() {
		klog.V(2).Infof("GCEGlobalAddresses.Delete(%v, %v): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "GlobalAddresses")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Delete",
		Version:   meta.Version("ga"),
		Service:   "GlobalAddresses",
	}
	klog.V(5).Infof("GCEGlobalAddresses.Delete(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEGlobalAddresses.Delete(%v, %v): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.GA.GlobalAddresses.Delete(projectID, key.Name)

	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCEGlobalAddresses.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEGlobalAddresses.Delete(%v, %v) = %v", ctx, key, err)
	return err
}

// BackendServices is an interface that allows for mocking of BackendServices.
type BackendServices interface {
	Get(ctx context.Context, key *meta.Key) (*ga.BackendService, error)
	List(ctx context.Context, fl *filter.F) ([]*ga.BackendService, error)
	Insert(ctx context.Context, key *meta.Key, obj *ga.BackendService) error
	Delete(ctx context.Context, key *meta.Key) error
	AggregatedList(ctx context.Context, fl *filter.F) (map[string][]*ga.BackendService, error)
	GetHealth(context.Context, *meta.Key, *ga.ResourceGroupReference) (*ga.BackendServiceGroupHealth, error)
	Patch(context.Context, *meta.Key, *ga.BackendService) error
	SetSecurityPolicy(context.Context, *meta.Key, *ga.SecurityPolicyReference) error
	Update(context.Context, *meta.Key, *ga.BackendService) error
}

// NewMockBackendServices returns a new mock for BackendServices.
func NewMockBackendServices(pr ProjectRouter, objs map[meta.Key]*MockBackendServicesObj) *MockBackendServices {
	mock := &MockBackendServices{
		ProjectRouter: pr,

		Objects:     objs,
		GetError:    map[meta.Key]error{},
		InsertError: map[meta.Key]error{},
		DeleteError: map[meta.Key]error{},
	}
	return mock
}

// MockBackendServices is the mock for BackendServices.
type MockBackendServices struct {
	Lock sync.Mutex

	ProjectRouter ProjectRouter

	// Objects maintained by the mock.
	Objects map[meta.Key]*MockBackendServicesObj

	// If an entry exists for the given key and operation, then the error
	// will be returned instead of the operation.
	GetError            map[meta.Key]error
	ListError           *error
	InsertError         map[meta.Key]error
	DeleteError         map[meta.Key]error
	AggregatedListError *error

	// xxxHook allow you to intercept the standard processing of the mock in
	// order to add your own logic. Return (true, _, _) to prevent the normal
	// execution flow of the mock. Return (false, nil, nil) to continue with
	// normal mock behavior/ after the hook function executes.
	GetHook               func(ctx context.Context, key *meta.Key, m *MockBackendServices) (bool, *ga.BackendService, error)
	ListHook              func(ctx context.Context, fl *filter.F, m *MockBackendServices) (bool, []*ga.BackendService, error)
	InsertHook            func(ctx context.Context, key *meta.Key, obj *ga.BackendService, m *MockBackendServices) (bool, error)
	DeleteHook            func(ctx context.Context, key *meta.Key, m *MockBackendServices) (bool, error)
	AggregatedListHook    func(ctx context.Context, fl *filter.F, m *MockBackendServices) (bool, map[string][]*ga.BackendService, error)
	GetHealthHook         func(context.Context, *meta.Key, *ga.ResourceGroupReference, *MockBackendServices) (*ga.BackendServiceGroupHealth, error)
	PatchHook             func(context.Context, *meta.Key, *ga.BackendService, *MockBackendServices) error
	SetSecurityPolicyHook func(context.Context, *meta.Key, *ga.SecurityPolicyReference, *MockBackendServices) error
	UpdateHook            func(context.Context, *meta.Key, *ga.BackendService, *MockBackendServices) error

	// X is extra state that can be used as part of the mock. Generated code
	// will not use this field.
	X interface{}
}

// Get returns the object from the mock.
func (m *MockBackendServices) Get(ctx context.Context, key *meta.Key) (*ga.BackendService, error) {
	if m.GetHook != nil {
		if intercept, obj, err := m.GetHook(ctx, key, m); intercept {
			klog.V(5).Infof("MockBackendServices.Get(%v, %s) = %+v, %v", ctx, key, obj, err)
			return obj, err
		}
	}
	if !key.Valid() {
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.GetError[*key]; ok {
		klog.V(5).Infof("MockBackendServices.Get(%v, %s) = nil, %v", ctx, key, err)
		return nil, err
	}
	if obj, ok := m.Objects[*key]; ok {
		typedObj := obj.ToGA()
		klog.V(5).Infof("MockBackendServices.Get(%v, %s) = %+v, nil", ctx, key, typedObj)
		return typedObj, nil
	}

	err := &googleapi.Error{
		Code:    http.StatusNotFound,
		Message: fmt.Sprintf("MockBackendServices %v not found", key),
	}
	klog.V(5).Infof("MockBackendServices.Get(%v, %s) = nil, %v", ctx, key, err)
	return nil, err
}

// List all of the objects in the mock.
func (m *MockBackendServices) List(ctx context.Context, fl *filter.F) ([]*ga.BackendService, error) {
	if m.ListHook != nil {
		if intercept, objs, err := m.ListHook(ctx, fl, m); intercept {
			klog.V(5).Infof("MockBackendServices.List(%v, %v) = [%v items], %v", ctx, fl, len(objs), err)
			return objs, err
		}
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if m.ListError != nil {
		err := *m.ListError
		klog.V(5).Infof("MockBackendServices.List(%v, %v) = nil, %v", ctx, fl, err)

		return nil, *m.ListError
	}

	var objs []*ga.BackendService
	for _, obj := range m.Objects {
		if !fl.Match(obj.ToGA()) {
			continue
		}
		objs = append(objs, obj.ToGA())
	}

	klog.V(5).Infof("MockBackendServices.List(%v, %v) = [%v items], nil", ctx, fl, len(objs))
	return objs, nil
}

// Insert is a mock for inserting/creating a new object.
func (m *MockBackendServices) Insert(ctx context.Context, key *meta.Key, obj *ga.BackendService) error {
	if m.InsertHook != nil {
		if intercept, err := m.InsertHook(ctx, key, obj, m); intercept {
			klog.V(5).Infof("MockBackendServices.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.InsertError[*key]; ok {
		klog.V(5).Infof("MockBackendServices.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}
	if _, ok := m.Objects[*key]; ok {
		err := &googleapi.Error{
			Code:    http.StatusConflict,
			Message: fmt.Sprintf("MockBackendServices %v exists", key),
		}
		klog.V(5).Infof("MockBackendServices.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}

	obj.Name = key.Name
	projectID := m.ProjectRouter.ProjectID(ctx, "ga", "backendServices")
	obj.SelfLink = SelfLink(meta.VersionGA, projectID, "backendServices", key)

	m.Objects[*key] = &MockBackendServicesObj{obj}
	klog.V(5).Infof("MockBackendServices.Insert(%v, %v, %+v) = nil", ctx, key, obj)
	return nil
}

// Delete is a mock for deleting the object.
func (m *MockBackendServices) Delete(ctx context.Context, key *meta.Key) error {
	if m.DeleteHook != nil {
		if intercept, err := m.DeleteHook(ctx, key, m); intercept {
			klog.V(5).Infof("MockBackendServices.Delete(%v, %v) = %v", ctx, key, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.DeleteError[*key]; ok {
		klog.V(5).Infof("MockBackendServices.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}
	if _, ok := m.Objects[*key]; !ok {
		err := &googleapi.Error{
			Code:    http.StatusNotFound,
			Message: fmt.Sprintf("MockBackendServices %v not found", key),
		}
		klog.V(5).Infof("MockBackendServices.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	delete(m.Objects, *key)
	klog.V(5).Infof("MockBackendServices.Delete(%v, %v) = nil", ctx, key)
	return nil
}

// AggregatedList is a mock for AggregatedList.
func (m *MockBackendServices) AggregatedList(ctx context.Context, fl *filter.F) (map[string][]*ga.BackendService, error) {
	if m.AggregatedListHook != nil {
		if intercept, objs, err := m.AggregatedListHook(ctx, fl, m); intercept {
			klog.V(5).Infof("MockBackendServices.AggregatedList(%v, %v) = [%v items], %v", ctx, fl, len(objs), err)
			return objs, err
		}
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if m.AggregatedListError != nil {
		err := *m.AggregatedListError
		klog.V(5).Infof("MockBackendServices.AggregatedList(%v, %v) = nil, %v", ctx, fl, err)
		return nil, err
	}

	objs := map[string][]*ga.BackendService{}
	for _, obj := range m.Objects {
		res, err := ParseResourceURL(obj.ToGA().SelfLink)
		if err != nil {
			klog.V(5).Infof("MockBackendServices.AggregatedList(%v, %v) = nil, %v", ctx, fl, err)
			return nil, err
		}
		if !fl.Match(obj.ToGA()) {
			continue
		}
		location := aggregatedListKey(res.Key)
		objs[location] = append(objs[location], obj.ToGA())
	}
	klog.V(5).Infof("MockBackendServices.AggregatedList(%v, %v) = [%v items], nil", ctx, fl, len(objs))
	return objs, nil
}

// Obj wraps the object for use in the mock.
func (m *MockBackendServices) Obj(o *ga.BackendService) *MockBackendServicesObj {
	return &MockBackendServicesObj{o}
}

// GetHealth is a mock for the corresponding method.
func (m *MockBackendServices) GetHealth(ctx context.Context, key *meta.Key, arg0 *ga.ResourceGroupReference) (*ga.BackendServiceGroupHealth, error) {
	if m.GetHealthHook != nil {
		return m.GetHealthHook(ctx, key, arg0, m)
	}
	return nil, fmt.Errorf("GetHealthHook must be set")
}

// Patch is a mock for the corresponding method.
func (m *MockBackendServices) Patch(ctx context.Context, key *meta.Key, arg0 *ga.BackendService) error {
	if m.PatchHook != nil {
		return m.PatchHook(ctx, key, arg0, m)
	}
	return nil
}

// SetSecurityPolicy is a mock for the corresponding method.
func (m *MockBackendServices) SetSecurityPolicy(ctx context.Context, key *meta.Key, arg0 *ga.SecurityPolicyReference) error {
	if m.SetSecurityPolicyHook != nil {
		return m.SetSecurityPolicyHook(ctx, key, arg0, m)
	}
	return nil
}

// Update is a mock for the corresponding method.
func (m *MockBackendServices) Update(ctx context.Context, key *meta.Key, arg0 *ga.BackendService) error {
	if m.UpdateHook != nil {
		return m.UpdateHook(ctx, key, arg0, m)
	}
	return nil
}

// GCEBackendServices is a simplifying adapter for the GCE BackendServices.
type GCEBackendServices struct {
	s *Service
}

// Get the BackendService named by key.
func (g *GCEBackendServices) Get(ctx context.Context, key *meta.Key) (*ga.BackendService, error) {
	klog.V(5).Infof("GCEBackendServices.Get(%v, %v): called", ctx, key)

	if !key.Valid() {
		klog.V(2).Infof("GCEBackendServices.Get(%v, %v): key is invalid (%#v)", ctx, key, key)
		return nil, fmt.Errorf("invalid GCE key (%#v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "BackendServices")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Get",
		Version:   meta.Version("ga"),
		Service:   "BackendServices",
	}
	klog.V(5).Infof("GCEBackendServices.Get(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEBackendServices.Get(%v, %v): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.GA.BackendServices.Get(projectID, key.Name)
	call.Context(ctx)
	v, err := call.Do()
	klog.V(4).Infof("GCEBackendServices.Get(%v, %v) = %+v, %v", ctx, key, v, err)
	return v, err
}

// List all BackendService objects.
func (g *GCEBackendServices) List(ctx context.Context, fl *filter.F) ([]*ga.BackendService, error) {
	klog.V(5).Infof("GCEBackendServices.List(%v, %v) called", ctx, fl)
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "BackendServices")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "List",
		Version:   meta.Version("ga"),
		Service:   "BackendServices",
	}
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		return nil, err
	}
	klog.V(5).Infof("GCEBackendServices.List(%v, %v): projectID = %v, rk = %+v", ctx, fl, projectID, rk)
	call := g.s.GA.BackendServices.List(projectID)
	if fl != filter.None {
		call.Filter(fl.String())
	}
	var all []*ga.BackendService
	f := func(l *ga.BackendServiceList) error {
		klog.V(5).Infof("GCEBackendServices.List(%v, ..., %v): page %+v", ctx, fl, l)
		all = append(all, l.Items...)
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		klog.V(4).Infof("GCEBackendServices.List(%v, ..., %v) = %v, %v", ctx, fl, nil, err)
		return nil, err
	}

	if klog.V(4).Enabled() {
		klog.V(4).Infof("GCEBackendServices.List(%v, ..., %v) = [%v items], %v", ctx, fl, len(all), nil)
	} else if klog.V(5).Enabled() {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		klog.V(5).Infof("GCEBackendServices.List(%v, ..., %v) = %v, %v", ctx, fl, asStr, nil)
	}

	return all, nil
}

// Insert BackendService with key of value obj.
func (g *GCEBackendServices) Insert(ctx context.Context, key *meta.Key, obj *ga.BackendService) error {
	klog.V(5).Infof("GCEBackendServices.Insert(%v, %v, %+v): called", ctx, key, obj)
	if !key.Valid() {
		klog.V(2).Infof("GCEBackendServices.Insert(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "BackendServices")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Insert",
		Version:   meta.Version("ga"),
		Service:   "BackendServices",
	}
	klog.V(5).Infof("GCEBackendServices.Insert(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEBackendServices.Insert(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	obj.Name = key.Name
	call := g.s.GA.BackendServices.Insert(projectID, obj)
	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCEBackendServices.Insert(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEBackendServices.Insert(%v, %v, %+v) = %+v", ctx, key, obj, err)
	return err
}

// Delete the BackendService referenced by key.
func (g *GCEBackendServices) Delete(ctx context.Context, key *meta.Key) error {
	klog.V(5).Infof("GCEBackendServices.Delete(%v, %v): called", ctx, key)
	if !key.Valid() {
		klog.V(2).Infof("GCEBackendServices.Delete(%v, %v): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "BackendServices")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Delete",
		Version:   meta.Version("ga"),
		Service:   "BackendServices",
	}
	klog.V(5).Infof("GCEBackendServices.Delete(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEBackendServices.Delete(%v, %v): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.GA.BackendServices.Delete(projectID, key.Name)

	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCEBackendServices.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEBackendServices.Delete(%v, %v) = %v", ctx, key, err)
	return err
}

// AggregatedList lists all resources of the given type across all locations.
func (g *GCEBackendServices) AggregatedList(ctx context.Context, fl *filter.F) (map[string][]*ga.BackendService, error) {
	klog.V(5).Infof("GCEBackendServices.AggregatedList(%v, %v) called", ctx, fl)

	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "BackendServices")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "AggregatedList",
		Version:   meta.Version("ga"),
		Service:   "BackendServices",
	}

	klog.V(5).Infof("GCEBackendServices.AggregatedList(%v, %v): projectID = %v, rk = %+v", ctx, fl, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(5).Infof("GCEBackendServices.AggregatedList(%v, %v): RateLimiter error: %v", ctx, fl, err)
		return nil, err
	}

	call := g.s.GA.BackendServices.AggregatedList(projectID)
	call.Context(ctx)
	if fl != filter.None {
		call.Filter(fl.String())
	}

	all := map[string][]*ga.BackendService{}
	f := func(l *ga.BackendServiceAggregatedList) error {
		for k, v := range l.Items {
			klog.V(5).Infof("GCEBackendServices.AggregatedList(%v, %v): page[%v]%+v", ctx, fl, k, v)
			all[k] = append(all[k], v.BackendServices...)
		}
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		klog.V(4).Infof("GCEBackendServices.AggregatedList(%v, %v) = %v, %v", ctx, fl, nil, err)
		return nil, err
	}
	if klog.V(4).Enabled() {
		klog.V(4).Infof("GCEBackendServices.AggregatedList(%v, %v) = [%v items], %v", ctx, fl, len(all), nil)
	} else if klog.V(5).Enabled() {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		klog.V(5).Infof("GCEBackendServices.AggregatedList(%v, %v) = %v, %v", ctx, fl, asStr, nil)
	}
	return all, nil
}

// GetHealth is a method on GCEBackendServices.
func (g *GCEBackendServices) GetHealth(ctx context.Context, key *meta.Key, arg0 *ga.ResourceGroupReference) (*ga.BackendServiceGroupHealth, error) {
	klog.V(5).Infof("GCEBackendServices.GetHealth(%v, %v, ...): called", ctx, key)

	if !key.Valid() {
		klog.V(2).Infof("GCEBackendServices.GetHealth(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "BackendServices")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "GetHealth",
		Version:   meta.Version("ga"),
		Service:   "BackendServices",
	}
	klog.V(5).Infof("GCEBackendServices.GetHealth(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)

	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEBackendServices.GetHealth(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.GA.BackendServices.GetHealth(projectID, key.Name, arg0)
	call.Context(ctx)
	v, err := call.Do()
	klog.V(4).Infof("GCEBackendServices.GetHealth(%v, %v, ...) = %+v, %v", ctx, key, v, err)
	return v, err
}

// Patch is a method on GCEBackendServices.
func (g *GCEBackendServices) Patch(ctx context.Context, key *meta.Key, arg0 *ga.BackendService) error {
	klog.V(5).Infof("GCEBackendServices.Patch(%v, %v, ...): called", ctx, key)

	if !key.Valid() {
		klog.V(2).Infof("GCEBackendServices.Patch(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "BackendServices")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Patch",
		Version:   meta.Version("ga"),
		Service:   "BackendServices",
	}
	klog.V(5).Infof("GCEBackendServices.Patch(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)

	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEBackendServices.Patch(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.GA.BackendServices.Patch(projectID, key.Name, arg0)
	call.Context(ctx)
	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCEBackendServices.Patch(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}
	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEBackendServices.Patch(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// SetSecurityPolicy is a method on GCEBackendServices.
func (g *GCEBackendServices) SetSecurityPolicy(ctx context.Context, key *meta.Key, arg0 *ga.SecurityPolicyReference) error {
	klog.V(5).Infof("GCEBackendServices.SetSecurityPolicy(%v, %v, ...): called", ctx, key)

	if !key.Valid() {
		klog.V(2).Infof("GCEBackendServices.SetSecurityPolicy(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "BackendServices")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "SetSecurityPolicy",
		Version:   meta.Version("ga"),
		Service:   "BackendServices",
	}
	klog.V(5).Infof("GCEBackendServices.SetSecurityPolicy(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)

	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEBackendServices.SetSecurityPolicy(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.GA.BackendServices.SetSecurityPolicy(projectID, key.Name, arg0)
	call.Context(ctx)
	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCEBackendServices.SetSecurityPolicy(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}
	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEBackendServices.SetSecurityPolicy(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// Update is a method on GCEBackendServices.
func (g *GCEBackendServices) Update(ctx context.Context, key *meta.Key, arg0 *ga.BackendService) error {
	klog.V(5).Infof("GCEBackendServices.Update(%v, %v, ...): called", ctx, key)

	if !key.Valid() {
		klog.V(2).Infof("GCEBackendServices.Update(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "BackendServices")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Update",
		Version:   meta.Version("ga"),
		Service:   "BackendServices",
	}
	klog.V(5).Infof("GCEBackendServices.Update(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)

	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEBackendServices.Update(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.GA.BackendServices.Update(projectID, key.Name, arg0)
	call.Context(ctx)
	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCEBackendServices.Update(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}
	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEBackendServices.Update(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// BetaBackendServices is an interface that allows for mocking of BackendServices.
type BetaBackendServices interface {
	Get(ctx context.Context, key *meta.Key) (*beta.BackendService, error)
	List(ctx context.Context, fl *filter.F) ([]*beta.BackendService, error)
	Insert(ctx context.Context, key *meta.Key, obj *beta.BackendService) error
	Delete(ctx context.Context, key *meta.Key) error
	AggregatedList(ctx context.Context, fl *filter.F) (map[string][]*beta.BackendService, error)
	SetSecurityPolicy(context.Context, *meta.Key, *beta.SecurityPolicyReference) error
	Update(context.Context, *meta.Key, *beta.BackendService) error
}

// NewMockBetaBackendServices returns a new mock for BackendServices.
func NewMockBetaBackendServices(pr ProjectRouter, objs map[meta.Key]*MockBackendServicesObj) *MockBetaBackendServices {
	mock := &MockBetaBackendServices{
		ProjectRouter: pr,

		Objects:     objs,
		GetError:    map[meta.Key]error{},
		InsertError: map[meta.Key]error{},
		DeleteError: map[meta.Key]error{},
	}
	return mock
}

// MockBetaBackendServices is the mock for BackendServices.
type MockBetaBackendServices struct {
	Lock sync.Mutex

	ProjectRouter ProjectRouter

	// Objects maintained by the mock.
	Objects map[meta.Key]*MockBackendServicesObj

	// If an entry exists for the given key and operation, then the error
	// will be returned instead of the operation.
	GetError            map[meta.Key]error
	ListError           *error
	InsertError         map[meta.Key]error
	DeleteError         map[meta.Key]error
	AggregatedListError *error

	// xxxHook allow you to intercept the standard processing of the mock in
	// order to add your own logic. Return (true, _, _) to prevent the normal
	// execution flow of the mock. Return (false, nil, nil) to continue with
	// normal mock behavior/ after the hook function executes.
	GetHook               func(ctx context.Context, key *meta.Key, m *MockBetaBackendServices) (bool, *beta.BackendService, error)
	ListHook              func(ctx context.Context, fl *filter.F, m *MockBetaBackendServices) (bool, []*beta.BackendService, error)
	InsertHook            func(ctx context.Context, key *meta.Key, obj *beta.BackendService, m *MockBetaBackendServices) (bool, error)
	DeleteHook            func(ctx context.Context, key *meta.Key, m *MockBetaBackendServices) (bool, error)
	AggregatedListHook    func(ctx context.Context, fl *filter.F, m *MockBetaBackendServices) (bool, map[string][]*beta.BackendService, error)
	SetSecurityPolicyHook func(context.Context, *meta.Key, *beta.SecurityPolicyReference, *MockBetaBackendServices) error
	UpdateHook            func(context.Context, *meta.Key, *beta.BackendService, *MockBetaBackendServices) error

	// X is extra state that can be used as part of the mock. Generated code
	// will not use this field.
	X interface{}
}

// Get returns the object from the mock.
func (m *MockBetaBackendServices) Get(ctx context.Context, key *meta.Key) (*beta.BackendService, error) {
	if m.GetHook != nil {
		if intercept, obj, err := m.GetHook(ctx, key, m); intercept {
			klog.V(5).Infof("MockBetaBackendServices.Get(%v, %s) = %+v, %v", ctx, key, obj, err)
			return obj, err
		}
	}
	if !key.Valid() {
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.GetError[*key]; ok {
		klog.V(5).Infof("MockBetaBackendServices.Get(%v, %s) = nil, %v", ctx, key, err)
		return nil, err
	}
	if obj, ok := m.Objects[*key]; ok {
		typedObj := obj.ToBeta()
		klog.V(5).Infof("MockBetaBackendServices.Get(%v, %s) = %+v, nil", ctx, key, typedObj)
		return typedObj, nil
	}

	err := &googleapi.Error{
		Code:    http.StatusNotFound,
		Message: fmt.Sprintf("MockBetaBackendServices %v not found", key),
	}
	klog.V(5).Infof("MockBetaBackendServices.Get(%v, %s) = nil, %v", ctx, key, err)
	return nil, err
}

// List all of the objects in the mock.
func (m *MockBetaBackendServices) List(ctx context.Context, fl *filter.F) ([]*beta.BackendService, error) {
	if m.ListHook != nil {
		if intercept, objs, err := m.ListHook(ctx, fl, m); intercept {
			klog.V(5).Infof("MockBetaBackendServices.List(%v, %v) = [%v items], %v", ctx, fl, len(objs), err)
			return objs, err
		}
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if m.ListError != nil {
		err := *m.ListError
		klog.V(5).Infof("MockBetaBackendServices.List(%v, %v) = nil, %v", ctx, fl, err)

		return nil, *m.ListError
	}

	var objs []*beta.BackendService
	for _, obj := range m.Objects {
		if !fl.Match(obj.ToBeta()) {
			continue
		}
		objs = append(objs, obj.ToBeta())
	}

	klog.V(5).Infof("MockBetaBackendServices.List(%v, %v) = [%v items], nil", ctx, fl, len(objs))
	return objs, nil
}

// Insert is a mock for inserting/creating a new object.
func (m *MockBetaBackendServices) Insert(ctx context.Context, key *meta.Key, obj *beta.BackendService) error {
	if m.InsertHook != nil {
		if intercept, err := m.InsertHook(ctx, key, obj, m); intercept {
			klog.V(5).Infof("MockBetaBackendServices.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.InsertError[*key]; ok {
		klog.V(5).Infof("MockBetaBackendServices.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}
	if _, ok := m.Objects[*key]; ok {
		err := &googleapi.Error{
			Code:    http.StatusConflict,
			Message: fmt.Sprintf("MockBetaBackendServices %v exists", key),
		}
		klog.V(5).Infof("MockBetaBackendServices.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}

	obj.Name = key.Name
	projectID := m.ProjectRouter.ProjectID(ctx, "beta", "backendServices")
	obj.SelfLink = SelfLink(meta.VersionBeta, projectID, "backendServices", key)

	m.Objects[*key] = &MockBackendServicesObj{obj}
	klog.V(5).Infof("MockBetaBackendServices.Insert(%v, %v, %+v) = nil", ctx, key, obj)
	return nil
}

// Delete is a mock for deleting the object.
func (m *MockBetaBackendServices) Delete(ctx context.Context, key *meta.Key) error {
	if m.DeleteHook != nil {
		if intercept, err := m.DeleteHook(ctx, key, m); intercept {
			klog.V(5).Infof("MockBetaBackendServices.Delete(%v, %v) = %v", ctx, key, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.DeleteError[*key]; ok {
		klog.V(5).Infof("MockBetaBackendServices.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}
	if _, ok := m.Objects[*key]; !ok {
		err := &googleapi.Error{
			Code:    http.StatusNotFound,
			Message: fmt.Sprintf("MockBetaBackendServices %v not found", key),
		}
		klog.V(5).Infof("MockBetaBackendServices.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	delete(m.Objects, *key)
	klog.V(5).Infof("MockBetaBackendServices.Delete(%v, %v) = nil", ctx, key)
	return nil
}

// AggregatedList is a mock for AggregatedList.
func (m *MockBetaBackendServices) AggregatedList(ctx context.Context, fl *filter.F) (map[string][]*beta.BackendService, error) {
	if m.AggregatedListHook != nil {
		if intercept, objs, err := m.AggregatedListHook(ctx, fl, m); intercept {
			klog.V(5).Infof("MockBetaBackendServices.AggregatedList(%v, %v) = [%v items], %v", ctx, fl, len(objs), err)
			return objs, err
		}
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if m.AggregatedListError != nil {
		err := *m.AggregatedListError
		klog.V(5).Infof("MockBetaBackendServices.AggregatedList(%v, %v) = nil, %v", ctx, fl, err)
		return nil, err
	}

	objs := map[string][]*beta.BackendService{}
	for _, obj := range m.Objects {
		res, err := ParseResourceURL(obj.ToBeta().SelfLink)
		if err != nil {
			klog.V(5).Infof("MockBetaBackendServices.AggregatedList(%v, %v) = nil, %v", ctx, fl, err)
			return nil, err
		}
		if !fl.Match(obj.ToBeta()) {
			continue
		}
		location := aggregatedListKey(res.Key)
		objs[location] = append(objs[location], obj.ToBeta())
	}
	klog.V(5).Infof("MockBetaBackendServices.AggregatedList(%v, %v) = [%v items], nil", ctx, fl, len(objs))
	return objs, nil
}

// Obj wraps the object for use in the mock.
func (m *MockBetaBackendServices) Obj(o *beta.BackendService) *MockBackendServicesObj {
	return &MockBackendServicesObj{o}
}

// SetSecurityPolicy is a mock for the corresponding method.
func (m *MockBetaBackendServices) SetSecurityPolicy(ctx context.Context, key *meta.Key, arg0 *beta.SecurityPolicyReference) error {
	if m.SetSecurityPolicyHook != nil {
		return m.SetSecurityPolicyHook(ctx, key, arg0, m)
	}
	return nil
}

// Update is a mock for the corresponding method.
func (m *MockBetaBackendServices) Update(ctx context.Context, key *meta.Key, arg0 *beta.BackendService) error {
	if m.UpdateHook != nil {
		return m.UpdateHook(ctx, key, arg0, m)
	}
	return nil
}

// GCEBetaBackendServices is a simplifying adapter for the GCE BackendServices.
type GCEBetaBackendServices struct {
	s *Service
}

// Get the BackendService named by key.
func (g *GCEBetaBackendServices) Get(ctx context.Context, key *meta.Key) (*beta.BackendService, error) {
	klog.V(5).Infof("GCEBetaBackendServices.Get(%v, %v): called", ctx, key)

	if !key.Valid() {
		klog.V(2).Infof("GCEBetaBackendServices.Get(%v, %v): key is invalid (%#v)", ctx, key, key)
		return nil, fmt.Errorf("invalid GCE key (%#v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "beta", "BackendServices")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Get",
		Version:   meta.Version("beta"),
		Service:   "BackendServices",
	}
	klog.V(5).Infof("GCEBetaBackendServices.Get(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEBetaBackendServices.Get(%v, %v): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.Beta.BackendServices.Get(projectID, key.Name)
	call.Context(ctx)
	v, err := call.Do()
	klog.V(4).Infof("GCEBetaBackendServices.Get(%v, %v) = %+v, %v", ctx, key, v, err)
	return v, err
}

// List all BackendService objects.
func (g *GCEBetaBackendServices) List(ctx context.Context, fl *filter.F) ([]*beta.BackendService, error) {
	klog.V(5).Infof("GCEBetaBackendServices.List(%v, %v) called", ctx, fl)
	projectID := g.s.ProjectRouter.ProjectID(ctx, "beta", "BackendServices")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "List",
		Version:   meta.Version("beta"),
		Service:   "BackendServices",
	}
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		return nil, err
	}
	klog.V(5).Infof("GCEBetaBackendServices.List(%v, %v): projectID = %v, rk = %+v", ctx, fl, projectID, rk)
	call := g.s.Beta.BackendServices.List(projectID)
	if fl != filter.None {
		call.Filter(fl.String())
	}
	var all []*beta.BackendService
	f := func(l *beta.BackendServiceList) error {
		klog.V(5).Infof("GCEBetaBackendServices.List(%v, ..., %v): page %+v", ctx, fl, l)
		all = append(all, l.Items...)
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		klog.V(4).Infof("GCEBetaBackendServices.List(%v, ..., %v) = %v, %v", ctx, fl, nil, err)
		return nil, err
	}

	if klog.V(4).Enabled() {
		klog.V(4).Infof("GCEBetaBackendServices.List(%v, ..., %v) = [%v items], %v", ctx, fl, len(all), nil)
	} else if klog.V(5).Enabled() {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		klog.V(5).Infof("GCEBetaBackendServices.List(%v, ..., %v) = %v, %v", ctx, fl, asStr, nil)
	}

	return all, nil
}

// Insert BackendService with key of value obj.
func (g *GCEBetaBackendServices) Insert(ctx context.Context, key *meta.Key, obj *beta.BackendService) error {
	klog.V(5).Infof("GCEBetaBackendServices.Insert(%v, %v, %+v): called", ctx, key, obj)
	if !key.Valid() {
		klog.V(2).Infof("GCEBetaBackendServices.Insert(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "beta", "BackendServices")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Insert",
		Version:   meta.Version("beta"),
		Service:   "BackendServices",
	}
	klog.V(5).Infof("GCEBetaBackendServices.Insert(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEBetaBackendServices.Insert(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	obj.Name = key.Name
	call := g.s.Beta.BackendServices.Insert(projectID, obj)
	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCEBetaBackendServices.Insert(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEBetaBackendServices.Insert(%v, %v, %+v) = %+v", ctx, key, obj, err)
	return err
}

// Delete the BackendService referenced by key.
func (g *GCEBetaBackendServices) Delete(ctx context.Context, key *meta.Key) error {
	klog.V(5).Infof("GCEBetaBackendServices.Delete(%v, %v): called", ctx, key)
	if !key.Valid() {
		klog.V(2).Infof("GCEBetaBackendServices.Delete(%v, %v): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "beta", "BackendServices")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Delete",
		Version:   meta.Version("beta"),
		Service:   "BackendServices",
	}
	klog.V(5).Infof("GCEBetaBackendServices.Delete(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEBetaBackendServices.Delete(%v, %v): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Beta.BackendServices.Delete(projectID, key.Name)

	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCEBetaBackendServices.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEBetaBackendServices.Delete(%v, %v) = %v", ctx, key, err)
	return err
}

// AggregatedList lists all resources of the given type across all locations.
func (g *GCEBetaBackendServices) AggregatedList(ctx context.Context, fl *filter.F) (map[string][]*beta.BackendService, error) {
	klog.V(5).Infof("GCEBetaBackendServices.AggregatedList(%v, %v) called", ctx, fl)

	projectID := g.s.ProjectRouter.ProjectID(ctx, "beta", "BackendServices")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "AggregatedList",
		Version:   meta.Version("beta"),
		Service:   "BackendServices",
	}

	klog.V(5).Infof("GCEBetaBackendServices.AggregatedList(%v, %v): projectID = %v, rk = %+v", ctx, fl, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(5).Infof("GCEBetaBackendServices.AggregatedList(%v, %v): RateLimiter error: %v", ctx, fl, err)
		return nil, err
	}

	call := g.s.Beta.BackendServices.AggregatedList(projectID)
	call.Context(ctx)
	if fl != filter.None {
		call.Filter(fl.String())
	}

	all := map[string][]*beta.BackendService{}
	f := func(l *beta.BackendServiceAggregatedList) error {
		for k, v := range l.Items {
			klog.V(5).Infof("GCEBetaBackendServices.AggregatedList(%v, %v): page[%v]%+v", ctx, fl, k, v)
			all[k] = append(all[k], v.BackendServices...)
		}
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		klog.V(4).Infof("GCEBetaBackendServices.AggregatedList(%v, %v) = %v, %v", ctx, fl, nil, err)
		return nil, err
	}
	if klog.V(4).Enabled() {
		klog.V(4).Infof("GCEBetaBackendServices.AggregatedList(%v, %v) = [%v items], %v", ctx, fl, len(all), nil)
	} else if klog.V(5).Enabled() {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		klog.V(5).Infof("GCEBetaBackendServices.AggregatedList(%v, %v) = %v, %v", ctx, fl, asStr, nil)
	}
	return all, nil
}

// SetSecurityPolicy is a method on GCEBetaBackendServices.
func (g *GCEBetaBackendServices) SetSecurityPolicy(ctx context.Context, key *meta.Key, arg0 *beta.SecurityPolicyReference) error {
	klog.V(5).Infof("GCEBetaBackendServices.SetSecurityPolicy(%v, %v, ...): called", ctx, key)

	if !key.Valid() {
		klog.V(2).Infof("GCEBetaBackendServices.SetSecurityPolicy(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "beta", "BackendServices")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "SetSecurityPolicy",
		Version:   meta.Version("beta"),
		Service:   "BackendServices",
	}
	klog.V(5).Infof("GCEBetaBackendServices.SetSecurityPolicy(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)

	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEBetaBackendServices.SetSecurityPolicy(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Beta.BackendServices.SetSecurityPolicy(projectID, key.Name, arg0)
	call.Context(ctx)
	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCEBetaBackendServices.SetSecurityPolicy(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}
	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEBetaBackendServices.SetSecurityPolicy(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// Update is a method on GCEBetaBackendServices.
func (g *GCEBetaBackendServices) Update(ctx context.Context, key *meta.Key, arg0 *beta.BackendService) error {
	klog.V(5).Infof("GCEBetaBackendServices.Update(%v, %v, ...): called", ctx, key)

	if !key.Valid() {
		klog.V(2).Infof("GCEBetaBackendServices.Update(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "beta", "BackendServices")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Update",
		Version:   meta.Version("beta"),
		Service:   "BackendServices",
	}
	klog.V(5).Infof("GCEBetaBackendServices.Update(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)

	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEBetaBackendServices.Update(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Beta.BackendServices.Update(projectID, key.Name, arg0)
	call.Context(ctx)
	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCEBetaBackendServices.Update(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}
	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEBetaBackendServices.Update(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// AlphaBackendServices is an interface that allows for mocking of BackendServices.
type AlphaBackendServices interface {
	Get(ctx context.Context, key *meta.Key) (*alpha.BackendService, error)
	List(ctx context.Context, fl *filter.F) ([]*alpha.BackendService, error)
	Insert(ctx context.Context, key *meta.Key, obj *alpha.BackendService) error
	Delete(ctx context.Context, key *meta.Key) error
	AggregatedList(ctx context.Context, fl *filter.F) (map[string][]*alpha.BackendService, error)
	SetSecurityPolicy(context.Context, *meta.Key, *alpha.SecurityPolicyReference) error
	Update(context.Context, *meta.Key, *alpha.BackendService) error
}

// NewMockAlphaBackendServices returns a new mock for BackendServices.
func NewMockAlphaBackendServices(pr ProjectRouter, objs map[meta.Key]*MockBackendServicesObj) *MockAlphaBackendServices {
	mock := &MockAlphaBackendServices{
		ProjectRouter: pr,

		Objects:     objs,
		GetError:    map[meta.Key]error{},
		InsertError: map[meta.Key]error{},
		DeleteError: map[meta.Key]error{},
	}
	return mock
}

// MockAlphaBackendServices is the mock for BackendServices.
type MockAlphaBackendServices struct {
	Lock sync.Mutex

	ProjectRouter ProjectRouter

	// Objects maintained by the mock.
	Objects map[meta.Key]*MockBackendServicesObj

	// If an entry exists for the given key and operation, then the error
	// will be returned instead of the operation.
	GetError            map[meta.Key]error
	ListError           *error
	InsertError         map[meta.Key]error
	DeleteError         map[meta.Key]error
	AggregatedListError *error

	// xxxHook allow you to intercept the standard processing of the mock in
	// order to add your own logic. Return (true, _, _) to prevent the normal
	// execution flow of the mock. Return (false, nil, nil) to continue with
	// normal mock behavior/ after the hook function executes.
	GetHook               func(ctx context.Context, key *meta.Key, m *MockAlphaBackendServices) (bool, *alpha.BackendService, error)
	ListHook              func(ctx context.Context, fl *filter.F, m *MockAlphaBackendServices) (bool, []*alpha.BackendService, error)
	InsertHook            func(ctx context.Context, key *meta.Key, obj *alpha.BackendService, m *MockAlphaBackendServices) (bool, error)
	DeleteHook            func(ctx context.Context, key *meta.Key, m *MockAlphaBackendServices) (bool, error)
	AggregatedListHook    func(ctx context.Context, fl *filter.F, m *MockAlphaBackendServices) (bool, map[string][]*alpha.BackendService, error)
	SetSecurityPolicyHook func(context.Context, *meta.Key, *alpha.SecurityPolicyReference, *MockAlphaBackendServices) error
	UpdateHook            func(context.Context, *meta.Key, *alpha.BackendService, *MockAlphaBackendServices) error

	// X is extra state that can be used as part of the mock. Generated code
	// will not use this field.
	X interface{}
}

// Get returns the object from the mock.
func (m *MockAlphaBackendServices) Get(ctx context.Context, key *meta.Key) (*alpha.BackendService, error) {
	if m.GetHook != nil {
		if intercept, obj, err := m.GetHook(ctx, key, m); intercept {
			klog.V(5).Infof("MockAlphaBackendServices.Get(%v, %s) = %+v, %v", ctx, key, obj, err)
			return obj, err
		}
	}
	if !key.Valid() {
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.GetError[*key]; ok {
		klog.V(5).Infof("MockAlphaBackendServices.Get(%v, %s) = nil, %v", ctx, key, err)
		return nil, err
	}
	if obj, ok := m.Objects[*key]; ok {
		typedObj := obj.ToAlpha()
		klog.V(5).Infof("MockAlphaBackendServices.Get(%v, %s) = %+v, nil", ctx, key, typedObj)
		return typedObj, nil
	}

	err := &googleapi.Error{
		Code:    http.StatusNotFound,
		Message: fmt.Sprintf("MockAlphaBackendServices %v not found", key),
	}
	klog.V(5).Infof("MockAlphaBackendServices.Get(%v, %s) = nil, %v", ctx, key, err)
	return nil, err
}

// List all of the objects in the mock.
func (m *MockAlphaBackendServices) List(ctx context.Context, fl *filter.F) ([]*alpha.BackendService, error) {
	if m.ListHook != nil {
		if intercept, objs, err := m.ListHook(ctx, fl, m); intercept {
			klog.V(5).Infof("MockAlphaBackendServices.List(%v, %v) = [%v items], %v", ctx, fl, len(objs), err)
			return objs, err
		}
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if m.ListError != nil {
		err := *m.ListError
		klog.V(5).Infof("MockAlphaBackendServices.List(%v, %v) = nil, %v", ctx, fl, err)

		return nil, *m.ListError
	}

	var objs []*alpha.BackendService
	for _, obj := range m.Objects {
		if !fl.Match(obj.ToAlpha()) {
			continue
		}
		objs = append(objs, obj.ToAlpha())
	}

	klog.V(5).Infof("MockAlphaBackendServices.List(%v, %v) = [%v items], nil", ctx, fl, len(objs))
	return objs, nil
}

// Insert is a mock for inserting/creating a new object.
func (m *MockAlphaBackendServices) Insert(ctx context.Context, key *meta.Key, obj *alpha.BackendService) error {
	if m.InsertHook != nil {
		if intercept, err := m.InsertHook(ctx, key, obj, m); intercept {
			klog.V(5).Infof("MockAlphaBackendServices.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.InsertError[*key]; ok {
		klog.V(5).Infof("MockAlphaBackendServices.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}
	if _, ok := m.Objects[*key]; ok {
		err := &googleapi.Error{
			Code:    http.StatusConflict,
			Message: fmt.Sprintf("MockAlphaBackendServices %v exists", key),
		}
		klog.V(5).Infof("MockAlphaBackendServices.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}

	obj.Name = key.Name
	projectID := m.ProjectRouter.ProjectID(ctx, "alpha", "backendServices")
	obj.SelfLink = SelfLink(meta.VersionAlpha, projectID, "backendServices", key)

	m.Objects[*key] = &MockBackendServicesObj{obj}
	klog.V(5).Infof("MockAlphaBackendServices.Insert(%v, %v, %+v) = nil", ctx, key, obj)
	return nil
}

// Delete is a mock for deleting the object.
func (m *MockAlphaBackendServices) Delete(ctx context.Context, key *meta.Key) error {
	if m.DeleteHook != nil {
		if intercept, err := m.DeleteHook(ctx, key, m); intercept {
			klog.V(5).Infof("MockAlphaBackendServices.Delete(%v, %v) = %v", ctx, key, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.DeleteError[*key]; ok {
		klog.V(5).Infof("MockAlphaBackendServices.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}
	if _, ok := m.Objects[*key]; !ok {
		err := &googleapi.Error{
			Code:    http.StatusNotFound,
			Message: fmt.Sprintf("MockAlphaBackendServices %v not found", key),
		}
		klog.V(5).Infof("MockAlphaBackendServices.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	delete(m.Objects, *key)
	klog.V(5).Infof("MockAlphaBackendServices.Delete(%v, %v) = nil", ctx, key)
	return nil
}

// AggregatedList is a mock for AggregatedList.
func (m *MockAlphaBackendServices) AggregatedList(ctx context.Context, fl *filter.F) (map[string][]*alpha.BackendService, error) {
	if m.AggregatedListHook != nil {
		if intercept, objs, err := m.AggregatedListHook(ctx, fl, m); intercept {
			klog.V(5).Infof("MockAlphaBackendServices.AggregatedList(%v, %v) = [%v items], %v", ctx, fl, len(objs), err)
			return objs, err
		}
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if m.AggregatedListError != nil {
		err := *m.AggregatedListError
		klog.V(5).Infof("MockAlphaBackendServices.AggregatedList(%v, %v) = nil, %v", ctx, fl, err)
		return nil, err
	}

	objs := map[string][]*alpha.BackendService{}
	for _, obj := range m.Objects {
		res, err := ParseResourceURL(obj.ToAlpha().SelfLink)
		if err != nil {
			klog.V(5).Infof("MockAlphaBackendServices.AggregatedList(%v, %v) = nil, %v", ctx, fl, err)
			return nil, err
		}
		if !fl.Match(obj.ToAlpha()) {
			continue
		}
		location := aggregatedListKey(res.Key)
		objs[location] = append(objs[location], obj.ToAlpha())
	}
	klog.V(5).Infof("MockAlphaBackendServices.AggregatedList(%v, %v) = [%v items], nil", ctx, fl, len(objs))
	return objs, nil
}

// Obj wraps the object for use in the mock.
func (m *MockAlphaBackendServices) Obj(o *alpha.BackendService) *MockBackendServicesObj {
	return &MockBackendServicesObj{o}
}

// SetSecurityPolicy is a mock for the corresponding method.
func (m *MockAlphaBackendServices) SetSecurityPolicy(ctx context.Context, key *meta.Key, arg0 *alpha.SecurityPolicyReference) error {
	if m.SetSecurityPolicyHook != nil {
		return m.SetSecurityPolicyHook(ctx, key, arg0, m)
	}
	return nil
}

// Update is a mock for the corresponding method.
func (m *MockAlphaBackendServices) Update(ctx context.Context, key *meta.Key, arg0 *alpha.BackendService) error {
	if m.UpdateHook != nil {
		return m.UpdateHook(ctx, key, arg0, m)
	}
	return nil
}

// GCEAlphaBackendServices is a simplifying adapter for the GCE BackendServices.
type GCEAlphaBackendServices struct {
	s *Service
}

// Get the BackendService named by key.
func (g *GCEAlphaBackendServices) Get(ctx context.Context, key *meta.Key) (*alpha.BackendService, error) {
	klog.V(5).Infof("GCEAlphaBackendServices.Get(%v, %v): called", ctx, key)

	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaBackendServices.Get(%v, %v): key is invalid (%#v)", ctx, key, key)
		return nil, fmt.Errorf("invalid GCE key (%#v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "alpha", "BackendServices")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Get",
		Version:   meta.Version("alpha"),
		Service:   "BackendServices",
	}
	klog.V(5).Infof("GCEAlphaBackendServices.Get(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEAlphaBackendServices.Get(%v, %v): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.Alpha.BackendServices.Get(projectID, key.Name)
	call.Context(ctx)
	v, err := call.Do()
	klog.V(4).Infof("GCEAlphaBackendServices.Get(%v, %v) = %+v, %v", ctx, key, v, err)
	return v, err
}

// List all BackendService objects.
func (g *GCEAlphaBackendServices) List(ctx context.Context, fl *filter.F) ([]*alpha.BackendService, error) {
	klog.V(5).Infof("GCEAlphaBackendServices.List(%v, %v) called", ctx, fl)
	projectID := g.s.ProjectRouter.ProjectID(ctx, "alpha", "BackendServices")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "List",
		Version:   meta.Version("alpha"),
		Service:   "BackendServices",
	}
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		return nil, err
	}
	klog.V(5).Infof("GCEAlphaBackendServices.List(%v, %v): projectID = %v, rk = %+v", ctx, fl, projectID, rk)
	call := g.s.Alpha.BackendServices.List(projectID)
	if fl != filter.None {
		call.Filter(fl.String())
	}
	var all []*alpha.BackendService
	f := func(l *alpha.BackendServiceList) error {
		klog.V(5).Infof("GCEAlphaBackendServices.List(%v, ..., %v): page %+v", ctx, fl, l)
		all = append(all, l.Items...)
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		klog.V(4).Infof("GCEAlphaBackendServices.List(%v, ..., %v) = %v, %v", ctx, fl, nil, err)
		return nil, err
	}

	if klog.V(4).Enabled() {
		klog.V(4).Infof("GCEAlphaBackendServices.List(%v, ..., %v) = [%v items], %v", ctx, fl, len(all), nil)
	} else if klog.V(5).Enabled() {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		klog.V(5).Infof("GCEAlphaBackendServices.List(%v, ..., %v) = %v, %v", ctx, fl, asStr, nil)
	}

	return all, nil
}

// Insert BackendService with key of value obj.
func (g *GCEAlphaBackendServices) Insert(ctx context.Context, key *meta.Key, obj *alpha.BackendService) error {
	klog.V(5).Infof("GCEAlphaBackendServices.Insert(%v, %v, %+v): called", ctx, key, obj)
	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaBackendServices.Insert(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "alpha", "BackendServices")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Insert",
		Version:   meta.Version("alpha"),
		Service:   "BackendServices",
	}
	klog.V(5).Infof("GCEAlphaBackendServices.Insert(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEAlphaBackendServices.Insert(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	obj.Name = key.Name
	call := g.s.Alpha.BackendServices.Insert(projectID, obj)
	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCEAlphaBackendServices.Insert(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEAlphaBackendServices.Insert(%v, %v, %+v) = %+v", ctx, key, obj, err)
	return err
}

// Delete the BackendService referenced by key.
func (g *GCEAlphaBackendServices) Delete(ctx context.Context, key *meta.Key) error {
	klog.V(5).Infof("GCEAlphaBackendServices.Delete(%v, %v): called", ctx, key)
	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaBackendServices.Delete(%v, %v): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "alpha", "BackendServices")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Delete",
		Version:   meta.Version("alpha"),
		Service:   "BackendServices",
	}
	klog.V(5).Infof("GCEAlphaBackendServices.Delete(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEAlphaBackendServices.Delete(%v, %v): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Alpha.BackendServices.Delete(projectID, key.Name)

	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCEAlphaBackendServices.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEAlphaBackendServices.Delete(%v, %v) = %v", ctx, key, err)
	return err
}

// AggregatedList lists all resources of the given type across all locations.
func (g *GCEAlphaBackendServices) AggregatedList(ctx context.Context, fl *filter.F) (map[string][]*alpha.BackendService, error) {
	klog.V(5).Infof("GCEAlphaBackendServices.AggregatedList(%v, %v) called", ctx, fl)

	projectID := g.s.ProjectRouter.ProjectID(ctx, "alpha", "BackendServices")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "AggregatedList",
		Version:   meta.Version("alpha"),
		Service:   "BackendServices",
	}

	klog.V(5).Infof("GCEAlphaBackendServices.AggregatedList(%v, %v): projectID = %v, rk = %+v", ctx, fl, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(5).Infof("GCEAlphaBackendServices.AggregatedList(%v, %v): RateLimiter error: %v", ctx, fl, err)
		return nil, err
	}

	call := g.s.Alpha.BackendServices.AggregatedList(projectID)
	call.Context(ctx)
	if fl != filter.None {
		call.Filter(fl.String())
	}

	all := map[string][]*alpha.BackendService{}
	f := func(l *alpha.BackendServiceAggregatedList) error {
		for k, v := range l.Items {
			klog.V(5).Infof("GCEAlphaBackendServices.AggregatedList(%v, %v): page[%v]%+v", ctx, fl, k, v)
			all[k] = append(all[k], v.BackendServices...)
		}
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		klog.V(4).Infof("GCEAlphaBackendServices.AggregatedList(%v, %v) = %v, %v", ctx, fl, nil, err)
		return nil, err
	}
	if klog.V(4).Enabled() {
		klog.V(4).Infof("GCEAlphaBackendServices.AggregatedList(%v, %v) = [%v items], %v", ctx, fl, len(all), nil)
	} else if klog.V(5).Enabled() {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		klog.V(5).Infof("GCEAlphaBackendServices.AggregatedList(%v, %v) = %v, %v", ctx, fl, asStr, nil)
	}
	return all, nil
}

// SetSecurityPolicy is a method on GCEAlphaBackendServices.
func (g *GCEAlphaBackendServices) SetSecurityPolicy(ctx context.Context, key *meta.Key, arg0 *alpha.SecurityPolicyReference) error {
	klog.V(5).Infof("GCEAlphaBackendServices.SetSecurityPolicy(%v, %v, ...): called", ctx, key)

	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaBackendServices.SetSecurityPolicy(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "alpha", "BackendServices")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "SetSecurityPolicy",
		Version:   meta.Version("alpha"),
		Service:   "BackendServices",
	}
	klog.V(5).Infof("GCEAlphaBackendServices.SetSecurityPolicy(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)

	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEAlphaBackendServices.SetSecurityPolicy(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Alpha.BackendServices.SetSecurityPolicy(projectID, key.Name, arg0)
	call.Context(ctx)
	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCEAlphaBackendServices.SetSecurityPolicy(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}
	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEAlphaBackendServices.SetSecurityPolicy(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// Update is a method on GCEAlphaBackendServices.
func (g *GCEAlphaBackendServices) Update(ctx context.Context, key *meta.Key, arg0 *alpha.BackendService) error {
	klog.V(5).Infof("GCEAlphaBackendServices.Update(%v, %v, ...): called", ctx, key)

	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaBackendServices.Update(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "alpha", "BackendServices")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Update",
		Version:   meta.Version("alpha"),
		Service:   "BackendServices",
	}
	klog.V(5).Infof("GCEAlphaBackendServices.Update(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)

	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEAlphaBackendServices.Update(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Alpha.BackendServices.Update(projectID, key.Name, arg0)
	call.Context(ctx)
	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCEAlphaBackendServices.Update(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}
	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEAlphaBackendServices.Update(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// RegionBackendServices is an interface that allows for mocking of RegionBackendServices.
type RegionBackendServices interface {
	Get(ctx context.Context, key *meta.Key) (*ga.BackendService, error)
	List(ctx context.Context, region string, fl *filter.F) ([]*ga.BackendService, error)
	Insert(ctx context.Context, key *meta.Key, obj *ga.BackendService) error
	Delete(ctx context.Context, key *meta.Key) error
	GetHealth(context.Context, *meta.Key, *ga.ResourceGroupReference) (*ga.BackendServiceGroupHealth, error)
	Update(context.Context, *meta.Key, *ga.BackendService) error
}

// NewMockRegionBackendServices returns a new mock for RegionBackendServices.
func NewMockRegionBackendServices(pr ProjectRouter, objs map[meta.Key]*MockRegionBackendServicesObj) *MockRegionBackendServices {
	mock := &MockRegionBackendServices{
		ProjectRouter: pr,

		Objects:     objs,
		GetError:    map[meta.Key]error{},
		InsertError: map[meta.Key]error{},
		DeleteError: map[meta.Key]error{},
	}
	return mock
}

// MockRegionBackendServices is the mock for RegionBackendServices.
type MockRegionBackendServices struct {
	Lock sync.Mutex

	ProjectRouter ProjectRouter

	// Objects maintained by the mock.
	Objects map[meta.Key]*MockRegionBackendServicesObj

	// If an entry exists for the given key and operation, then the error
	// will be returned instead of the operation.
	GetError    map[meta.Key]error
	ListError   *error
	InsertError map[meta.Key]error
	DeleteError map[meta.Key]error

	// xxxHook allow you to intercept the standard processing of the mock in
	// order to add your own logic. Return (true, _, _) to prevent the normal
	// execution flow of the mock. Return (false, nil, nil) to continue with
	// normal mock behavior/ after the hook function executes.
	GetHook       func(ctx context.Context, key *meta.Key, m *MockRegionBackendServices) (bool, *ga.BackendService, error)
	ListHook      func(ctx context.Context, region string, fl *filter.F, m *MockRegionBackendServices) (bool, []*ga.BackendService, error)
	InsertHook    func(ctx context.Context, key *meta.Key, obj *ga.BackendService, m *MockRegionBackendServices) (bool, error)
	DeleteHook    func(ctx context.Context, key *meta.Key, m *MockRegionBackendServices) (bool, error)
	GetHealthHook func(context.Context, *meta.Key, *ga.ResourceGroupReference, *MockRegionBackendServices) (*ga.BackendServiceGroupHealth, error)
	UpdateHook    func(context.Context, *meta.Key, *ga.BackendService, *MockRegionBackendServices) error

	// X is extra state that can be used as part of the mock. Generated code
	// will not use this field.
	X interface{}
}

// Get returns the object from the mock.
func (m *MockRegionBackendServices) Get(ctx context.Context, key *meta.Key) (*ga.BackendService, error) {
	if m.GetHook != nil {
		if intercept, obj, err := m.GetHook(ctx, key, m); intercept {
			klog.V(5).Infof("MockRegionBackendServices.Get(%v, %s) = %+v, %v", ctx, key, obj, err)
			return obj, err
		}
	}
	if !key.Valid() {
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.GetError[*key]; ok {
		klog.V(5).Infof("MockRegionBackendServices.Get(%v, %s) = nil, %v", ctx, key, err)
		return nil, err
	}
	if obj, ok := m.Objects[*key]; ok {
		typedObj := obj.ToGA()
		klog.V(5).Infof("MockRegionBackendServices.Get(%v, %s) = %+v, nil", ctx, key, typedObj)
		return typedObj, nil
	}

	err := &googleapi.Error{
		Code:    http.StatusNotFound,
		Message: fmt.Sprintf("MockRegionBackendServices %v not found", key),
	}
	klog.V(5).Infof("MockRegionBackendServices.Get(%v, %s) = nil, %v", ctx, key, err)
	return nil, err
}

// List all of the objects in the mock in the given region.
func (m *MockRegionBackendServices) List(ctx context.Context, region string, fl *filter.F) ([]*ga.BackendService, error) {
	if m.ListHook != nil {
		if intercept, objs, err := m.ListHook(ctx, region, fl, m); intercept {
			klog.V(5).Infof("MockRegionBackendServices.List(%v, %q, %v) = [%v items], %v", ctx, region, fl, len(objs), err)
			return objs, err
		}
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if m.ListError != nil {
		err := *m.ListError
		klog.V(5).Infof("MockRegionBackendServices.List(%v, %q, %v) = nil, %v", ctx, region, fl, err)

		return nil, *m.ListError
	}

	var objs []*ga.BackendService
	for key, obj := range m.Objects {
		if key.Region != region {
			continue
		}
		if !fl.Match(obj.ToGA()) {
			continue
		}
		objs = append(objs, obj.ToGA())
	}

	klog.V(5).Infof("MockRegionBackendServices.List(%v, %q, %v) = [%v items], nil", ctx, region, fl, len(objs))
	return objs, nil
}

// Insert is a mock for inserting/creating a new object.
func (m *MockRegionBackendServices) Insert(ctx context.Context, key *meta.Key, obj *ga.BackendService) error {
	if m.InsertHook != nil {
		if intercept, err := m.InsertHook(ctx, key, obj, m); intercept {
			klog.V(5).Infof("MockRegionBackendServices.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.InsertError[*key]; ok {
		klog.V(5).Infof("MockRegionBackendServices.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}
	if _, ok := m.Objects[*key]; ok {
		err := &googleapi.Error{
			Code:    http.StatusConflict,
			Message: fmt.Sprintf("MockRegionBackendServices %v exists", key),
		}
		klog.V(5).Infof("MockRegionBackendServices.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}

	obj.Name = key.Name
	projectID := m.ProjectRouter.ProjectID(ctx, "ga", "backendServices")
	obj.SelfLink = SelfLink(meta.VersionGA, projectID, "backendServices", key)

	m.Objects[*key] = &MockRegionBackendServicesObj{obj}
	klog.V(5).Infof("MockRegionBackendServices.Insert(%v, %v, %+v) = nil", ctx, key, obj)
	return nil
}

// Delete is a mock for deleting the object.
func (m *MockRegionBackendServices) Delete(ctx context.Context, key *meta.Key) error {
	if m.DeleteHook != nil {
		if intercept, err := m.DeleteHook(ctx, key, m); intercept {
			klog.V(5).Infof("MockRegionBackendServices.Delete(%v, %v) = %v", ctx, key, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.DeleteError[*key]; ok {
		klog.V(5).Infof("MockRegionBackendServices.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}
	if _, ok := m.Objects[*key]; !ok {
		err := &googleapi.Error{
			Code:    http.StatusNotFound,
			Message: fmt.Sprintf("MockRegionBackendServices %v not found", key),
		}
		klog.V(5).Infof("MockRegionBackendServices.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	delete(m.Objects, *key)
	klog.V(5).Infof("MockRegionBackendServices.Delete(%v, %v) = nil", ctx, key)
	return nil
}

// Obj wraps the object for use in the mock.
func (m *MockRegionBackendServices) Obj(o *ga.BackendService) *MockRegionBackendServicesObj {
	return &MockRegionBackendServicesObj{o}
}

// GetHealth is a mock for the corresponding method.
func (m *MockRegionBackendServices) GetHealth(ctx context.Context, key *meta.Key, arg0 *ga.ResourceGroupReference) (*ga.BackendServiceGroupHealth, error) {
	if m.GetHealthHook != nil {
		return m.GetHealthHook(ctx, key, arg0, m)
	}
	return nil, fmt.Errorf("GetHealthHook must be set")
}

// Update is a mock for the corresponding method.
func (m *MockRegionBackendServices) Update(ctx context.Context, key *meta.Key, arg0 *ga.BackendService) error {
	if m.UpdateHook != nil {
		return m.UpdateHook(ctx, key, arg0, m)
	}
	return nil
}

// GCERegionBackendServices is a simplifying adapter for the GCE RegionBackendServices.
type GCERegionBackendServices struct {
	s *Service
}

// Get the BackendService named by key.
func (g *GCERegionBackendServices) Get(ctx context.Context, key *meta.Key) (*ga.BackendService, error) {
	klog.V(5).Infof("GCERegionBackendServices.Get(%v, %v): called", ctx, key)

	if !key.Valid() {
		klog.V(2).Infof("GCERegionBackendServices.Get(%v, %v): key is invalid (%#v)", ctx, key, key)
		return nil, fmt.Errorf("invalid GCE key (%#v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "RegionBackendServices")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Get",
		Version:   meta.Version("ga"),
		Service:   "RegionBackendServices",
	}
	klog.V(5).Infof("GCERegionBackendServices.Get(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCERegionBackendServices.Get(%v, %v): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.GA.RegionBackendServices.Get(projectID, key.Region, key.Name)
	call.Context(ctx)
	v, err := call.Do()
	klog.V(4).Infof("GCERegionBackendServices.Get(%v, %v) = %+v, %v", ctx, key, v, err)
	return v, err
}

// List all BackendService objects.
func (g *GCERegionBackendServices) List(ctx context.Context, region string, fl *filter.F) ([]*ga.BackendService, error) {
	klog.V(5).Infof("GCERegionBackendServices.List(%v, %v, %v) called", ctx, region, fl)
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "RegionBackendServices")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "List",
		Version:   meta.Version("ga"),
		Service:   "RegionBackendServices",
	}
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		return nil, err
	}
	klog.V(5).Infof("GCERegionBackendServices.List(%v, %v, %v): projectID = %v, rk = %+v", ctx, region, fl, projectID, rk)
	call := g.s.GA.RegionBackendServices.List(projectID, region)
	if fl != filter.None {
		call.Filter(fl.String())
	}
	var all []*ga.BackendService
	f := func(l *ga.BackendServiceList) error {
		klog.V(5).Infof("GCERegionBackendServices.List(%v, ..., %v): page %+v", ctx, fl, l)
		all = append(all, l.Items...)
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		klog.V(4).Infof("GCERegionBackendServices.List(%v, ..., %v) = %v, %v", ctx, fl, nil, err)
		return nil, err
	}

	if klog.V(4).Enabled() {
		klog.V(4).Infof("GCERegionBackendServices.List(%v, ..., %v) = [%v items], %v", ctx, fl, len(all), nil)
	} else if klog.V(5).Enabled() {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		klog.V(5).Infof("GCERegionBackendServices.List(%v, ..., %v) = %v, %v", ctx, fl, asStr, nil)
	}

	return all, nil
}

// Insert BackendService with key of value obj.
func (g *GCERegionBackendServices) Insert(ctx context.Context, key *meta.Key, obj *ga.BackendService) error {
	klog.V(5).Infof("GCERegionBackendServices.Insert(%v, %v, %+v): called", ctx, key, obj)
	if !key.Valid() {
		klog.V(2).Infof("GCERegionBackendServices.Insert(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "RegionBackendServices")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Insert",
		Version:   meta.Version("ga"),
		Service:   "RegionBackendServices",
	}
	klog.V(5).Infof("GCERegionBackendServices.Insert(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCERegionBackendServices.Insert(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	obj.Name = key.Name
	call := g.s.GA.RegionBackendServices.Insert(projectID, key.Region, obj)
	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCERegionBackendServices.Insert(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCERegionBackendServices.Insert(%v, %v, %+v) = %+v", ctx, key, obj, err)
	return err
}

// Delete the BackendService referenced by key.
func (g *GCERegionBackendServices) Delete(ctx context.Context, key *meta.Key) error {
	klog.V(5).Infof("GCERegionBackendServices.Delete(%v, %v): called", ctx, key)
	if !key.Valid() {
		klog.V(2).Infof("GCERegionBackendServices.Delete(%v, %v): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "RegionBackendServices")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Delete",
		Version:   meta.Version("ga"),
		Service:   "RegionBackendServices",
	}
	klog.V(5).Infof("GCERegionBackendServices.Delete(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCERegionBackendServices.Delete(%v, %v): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.GA.RegionBackendServices.Delete(projectID, key.Region, key.Name)
	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCERegionBackendServices.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCERegionBackendServices.Delete(%v, %v) = %v", ctx, key, err)
	return err
}

// GetHealth is a method on GCERegionBackendServices.
func (g *GCERegionBackendServices) GetHealth(ctx context.Context, key *meta.Key, arg0 *ga.ResourceGroupReference) (*ga.BackendServiceGroupHealth, error) {
	klog.V(5).Infof("GCERegionBackendServices.GetHealth(%v, %v, ...): called", ctx, key)

	if !key.Valid() {
		klog.V(2).Infof("GCERegionBackendServices.GetHealth(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "RegionBackendServices")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "GetHealth",
		Version:   meta.Version("ga"),
		Service:   "RegionBackendServices",
	}
	klog.V(5).Infof("GCERegionBackendServices.GetHealth(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)

	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCERegionBackendServices.GetHealth(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.GA.RegionBackendServices.GetHealth(projectID, key.Region, key.Name, arg0)
	call.Context(ctx)
	v, err := call.Do()
	klog.V(4).Infof("GCERegionBackendServices.GetHealth(%v, %v, ...) = %+v, %v", ctx, key, v, err)
	return v, err
}

// Update is a method on GCERegionBackendServices.
func (g *GCERegionBackendServices) Update(ctx context.Context, key *meta.Key, arg0 *ga.BackendService) error {
	klog.V(5).Infof("GCERegionBackendServices.Update(%v, %v, ...): called", ctx, key)

	if !key.Valid() {
		klog.V(2).Infof("GCERegionBackendServices.Update(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "RegionBackendServices")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Update",
		Version:   meta.Version("ga"),
		Service:   "RegionBackendServices",
	}
	klog.V(5).Infof("GCERegionBackendServices.Update(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)

	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCERegionBackendServices.Update(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.GA.RegionBackendServices.Update(projectID, key.Region, key.Name, arg0)
	call.Context(ctx)
	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCERegionBackendServices.Update(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}
	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCERegionBackendServices.Update(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// AlphaRegionBackendServices is an interface that allows for mocking of RegionBackendServices.
type AlphaRegionBackendServices interface {
	Get(ctx context.Context, key *meta.Key) (*alpha.BackendService, error)
	List(ctx context.Context, region string, fl *filter.F) ([]*alpha.BackendService, error)
	Insert(ctx context.Context, key *meta.Key, obj *alpha.BackendService) error
	Delete(ctx context.Context, key *meta.Key) error
	GetHealth(context.Context, *meta.Key, *alpha.ResourceGroupReference) (*alpha.BackendServiceGroupHealth, error)
	Update(context.Context, *meta.Key, *alpha.BackendService) error
}

// NewMockAlphaRegionBackendServices returns a new mock for RegionBackendServices.
func NewMockAlphaRegionBackendServices(pr ProjectRouter, objs map[meta.Key]*MockRegionBackendServicesObj) *MockAlphaRegionBackendServices {
	mock := &MockAlphaRegionBackendServices{
		ProjectRouter: pr,

		Objects:     objs,
		GetError:    map[meta.Key]error{},
		InsertError: map[meta.Key]error{},
		DeleteError: map[meta.Key]error{},
	}
	return mock
}

// MockAlphaRegionBackendServices is the mock for RegionBackendServices.
type MockAlphaRegionBackendServices struct {
	Lock sync.Mutex

	ProjectRouter ProjectRouter

	// Objects maintained by the mock.
	Objects map[meta.Key]*MockRegionBackendServicesObj

	// If an entry exists for the given key and operation, then the error
	// will be returned instead of the operation.
	GetError    map[meta.Key]error
	ListError   *error
	InsertError map[meta.Key]error
	DeleteError map[meta.Key]error

	// xxxHook allow you to intercept the standard processing of the mock in
	// order to add your own logic. Return (true, _, _) to prevent the normal
	// execution flow of the mock. Return (false, nil, nil) to continue with
	// normal mock behavior/ after the hook function executes.
	GetHook       func(ctx context.Context, key *meta.Key, m *MockAlphaRegionBackendServices) (bool, *alpha.BackendService, error)
	ListHook      func(ctx context.Context, region string, fl *filter.F, m *MockAlphaRegionBackendServices) (bool, []*alpha.BackendService, error)
	InsertHook    func(ctx context.Context, key *meta.Key, obj *alpha.BackendService, m *MockAlphaRegionBackendServices) (bool, error)
	DeleteHook    func(ctx context.Context, key *meta.Key, m *MockAlphaRegionBackendServices) (bool, error)
	GetHealthHook func(context.Context, *meta.Key, *alpha.ResourceGroupReference, *MockAlphaRegionBackendServices) (*alpha.BackendServiceGroupHealth, error)
	UpdateHook    func(context.Context, *meta.Key, *alpha.BackendService, *MockAlphaRegionBackendServices) error

	// X is extra state that can be used as part of the mock. Generated code
	// will not use this field.
	X interface{}
}

// Get returns the object from the mock.
func (m *MockAlphaRegionBackendServices) Get(ctx context.Context, key *meta.Key) (*alpha.BackendService, error) {
	if m.GetHook != nil {
		if intercept, obj, err := m.GetHook(ctx, key, m); intercept {
			klog.V(5).Infof("MockAlphaRegionBackendServices.Get(%v, %s) = %+v, %v", ctx, key, obj, err)
			return obj, err
		}
	}
	if !key.Valid() {
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.GetError[*key]; ok {
		klog.V(5).Infof("MockAlphaRegionBackendServices.Get(%v, %s) = nil, %v", ctx, key, err)
		return nil, err
	}
	if obj, ok := m.Objects[*key]; ok {
		typedObj := obj.ToAlpha()
		klog.V(5).Infof("MockAlphaRegionBackendServices.Get(%v, %s) = %+v, nil", ctx, key, typedObj)
		return typedObj, nil
	}

	err := &googleapi.Error{
		Code:    http.StatusNotFound,
		Message: fmt.Sprintf("MockAlphaRegionBackendServices %v not found", key),
	}
	klog.V(5).Infof("MockAlphaRegionBackendServices.Get(%v, %s) = nil, %v", ctx, key, err)
	return nil, err
}

// List all of the objects in the mock in the given region.
func (m *MockAlphaRegionBackendServices) List(ctx context.Context, region string, fl *filter.F) ([]*alpha.BackendService, error) {
	if m.ListHook != nil {
		if intercept, objs, err := m.ListHook(ctx, region, fl, m); intercept {
			klog.V(5).Infof("MockAlphaRegionBackendServices.List(%v, %q, %v) = [%v items], %v", ctx, region, fl, len(objs), err)
			return objs, err
		}
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if m.ListError != nil {
		err := *m.ListError
		klog.V(5).Infof("MockAlphaRegionBackendServices.List(%v, %q, %v) = nil, %v", ctx, region, fl, err)

		return nil, *m.ListError
	}

	var objs []*alpha.BackendService
	for key, obj := range m.Objects {
		if key.Region != region {
			continue
		}
		if !fl.Match(obj.ToAlpha()) {
			continue
		}
		objs = append(objs, obj.ToAlpha())
	}

	klog.V(5).Infof("MockAlphaRegionBackendServices.List(%v, %q, %v) = [%v items], nil", ctx, region, fl, len(objs))
	return objs, nil
}

// Insert is a mock for inserting/creating a new object.
func (m *MockAlphaRegionBackendServices) Insert(ctx context.Context, key *meta.Key, obj *alpha.BackendService) error {
	if m.InsertHook != nil {
		if intercept, err := m.InsertHook(ctx, key, obj, m); intercept {
			klog.V(5).Infof("MockAlphaRegionBackendServices.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.InsertError[*key]; ok {
		klog.V(5).Infof("MockAlphaRegionBackendServices.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}
	if _, ok := m.Objects[*key]; ok {
		err := &googleapi.Error{
			Code:    http.StatusConflict,
			Message: fmt.Sprintf("MockAlphaRegionBackendServices %v exists", key),
		}
		klog.V(5).Infof("MockAlphaRegionBackendServices.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}

	obj.Name = key.Name
	projectID := m.ProjectRouter.ProjectID(ctx, "alpha", "backendServices")
	obj.SelfLink = SelfLink(meta.VersionAlpha, projectID, "backendServices", key)

	m.Objects[*key] = &MockRegionBackendServicesObj{obj}
	klog.V(5).Infof("MockAlphaRegionBackendServices.Insert(%v, %v, %+v) = nil", ctx, key, obj)
	return nil
}

// Delete is a mock for deleting the object.
func (m *MockAlphaRegionBackendServices) Delete(ctx context.Context, key *meta.Key) error {
	if m.DeleteHook != nil {
		if intercept, err := m.DeleteHook(ctx, key, m); intercept {
			klog.V(5).Infof("MockAlphaRegionBackendServices.Delete(%v, %v) = %v", ctx, key, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.DeleteError[*key]; ok {
		klog.V(5).Infof("MockAlphaRegionBackendServices.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}
	if _, ok := m.Objects[*key]; !ok {
		err := &googleapi.Error{
			Code:    http.StatusNotFound,
			Message: fmt.Sprintf("MockAlphaRegionBackendServices %v not found", key),
		}
		klog.V(5).Infof("MockAlphaRegionBackendServices.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	delete(m.Objects, *key)
	klog.V(5).Infof("MockAlphaRegionBackendServices.Delete(%v, %v) = nil", ctx, key)
	return nil
}

// Obj wraps the object for use in the mock.
func (m *MockAlphaRegionBackendServices) Obj(o *alpha.BackendService) *MockRegionBackendServicesObj {
	return &MockRegionBackendServicesObj{o}
}

// GetHealth is a mock for the corresponding method.
func (m *MockAlphaRegionBackendServices) GetHealth(ctx context.Context, key *meta.Key, arg0 *alpha.ResourceGroupReference) (*alpha.BackendServiceGroupHealth, error) {
	if m.GetHealthHook != nil {
		return m.GetHealthHook(ctx, key, arg0, m)
	}
	return nil, fmt.Errorf("GetHealthHook must be set")
}

// Update is a mock for the corresponding method.
func (m *MockAlphaRegionBackendServices) Update(ctx context.Context, key *meta.Key, arg0 *alpha.BackendService) error {
	if m.UpdateHook != nil {
		return m.UpdateHook(ctx, key, arg0, m)
	}
	return nil
}

// GCEAlphaRegionBackendServices is a simplifying adapter for the GCE RegionBackendServices.
type GCEAlphaRegionBackendServices struct {
	s *Service
}

// Get the BackendService named by key.
func (g *GCEAlphaRegionBackendServices) Get(ctx context.Context, key *meta.Key) (*alpha.BackendService, error) {
	klog.V(5).Infof("GCEAlphaRegionBackendServices.Get(%v, %v): called", ctx, key)

	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaRegionBackendServices.Get(%v, %v): key is invalid (%#v)", ctx, key, key)
		return nil, fmt.Errorf("invalid GCE key (%#v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "alpha", "RegionBackendServices")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Get",
		Version:   meta.Version("alpha"),
		Service:   "RegionBackendServices",
	}
	klog.V(5).Infof("GCEAlphaRegionBackendServices.Get(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEAlphaRegionBackendServices.Get(%v, %v): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.Alpha.RegionBackendServices.Get(projectID, key.Region, key.Name)
	call.Context(ctx)
	v, err := call.Do()
	klog.V(4).Infof("GCEAlphaRegionBackendServices.Get(%v, %v) = %+v, %v", ctx, key, v, err)
	return v, err
}

// List all BackendService objects.
func (g *GCEAlphaRegionBackendServices) List(ctx context.Context, region string, fl *filter.F) ([]*alpha.BackendService, error) {
	klog.V(5).Infof("GCEAlphaRegionBackendServices.List(%v, %v, %v) called", ctx, region, fl)
	projectID := g.s.ProjectRouter.ProjectID(ctx, "alpha", "RegionBackendServices")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "List",
		Version:   meta.Version("alpha"),
		Service:   "RegionBackendServices",
	}
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		return nil, err
	}
	klog.V(5).Infof("GCEAlphaRegionBackendServices.List(%v, %v, %v): projectID = %v, rk = %+v", ctx, region, fl, projectID, rk)
	call := g.s.Alpha.RegionBackendServices.List(projectID, region)
	if fl != filter.None {
		call.Filter(fl.String())
	}
	var all []*alpha.BackendService
	f := func(l *alpha.BackendServiceList) error {
		klog.V(5).Infof("GCEAlphaRegionBackendServices.List(%v, ..., %v): page %+v", ctx, fl, l)
		all = append(all, l.Items...)
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		klog.V(4).Infof("GCEAlphaRegionBackendServices.List(%v, ..., %v) = %v, %v", ctx, fl, nil, err)
		return nil, err
	}

	if klog.V(4).Enabled() {
		klog.V(4).Infof("GCEAlphaRegionBackendServices.List(%v, ..., %v) = [%v items], %v", ctx, fl, len(all), nil)
	} else if klog.V(5).Enabled() {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		klog.V(5).Infof("GCEAlphaRegionBackendServices.List(%v, ..., %v) = %v, %v", ctx, fl, asStr, nil)
	}

	return all, nil
}

// Insert BackendService with key of value obj.
func (g *GCEAlphaRegionBackendServices) Insert(ctx context.Context, key *meta.Key, obj *alpha.BackendService) error {
	klog.V(5).Infof("GCEAlphaRegionBackendServices.Insert(%v, %v, %+v): called", ctx, key, obj)
	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaRegionBackendServices.Insert(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "alpha", "RegionBackendServices")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Insert",
		Version:   meta.Version("alpha"),
		Service:   "RegionBackendServices",
	}
	klog.V(5).Infof("GCEAlphaRegionBackendServices.Insert(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEAlphaRegionBackendServices.Insert(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	obj.Name = key.Name
	call := g.s.Alpha.RegionBackendServices.Insert(projectID, key.Region, obj)
	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCEAlphaRegionBackendServices.Insert(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEAlphaRegionBackendServices.Insert(%v, %v, %+v) = %+v", ctx, key, obj, err)
	return err
}

// Delete the BackendService referenced by key.
func (g *GCEAlphaRegionBackendServices) Delete(ctx context.Context, key *meta.Key) error {
	klog.V(5).Infof("GCEAlphaRegionBackendServices.Delete(%v, %v): called", ctx, key)
	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaRegionBackendServices.Delete(%v, %v): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "alpha", "RegionBackendServices")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Delete",
		Version:   meta.Version("alpha"),
		Service:   "RegionBackendServices",
	}
	klog.V(5).Infof("GCEAlphaRegionBackendServices.Delete(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEAlphaRegionBackendServices.Delete(%v, %v): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Alpha.RegionBackendServices.Delete(projectID, key.Region, key.Name)
	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCEAlphaRegionBackendServices.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEAlphaRegionBackendServices.Delete(%v, %v) = %v", ctx, key, err)
	return err
}

// GetHealth is a method on GCEAlphaRegionBackendServices.
func (g *GCEAlphaRegionBackendServices) GetHealth(ctx context.Context, key *meta.Key, arg0 *alpha.ResourceGroupReference) (*alpha.BackendServiceGroupHealth, error) {
	klog.V(5).Infof("GCEAlphaRegionBackendServices.GetHealth(%v, %v, ...): called", ctx, key)

	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaRegionBackendServices.GetHealth(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "alpha", "RegionBackendServices")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "GetHealth",
		Version:   meta.Version("alpha"),
		Service:   "RegionBackendServices",
	}
	klog.V(5).Infof("GCEAlphaRegionBackendServices.GetHealth(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)

	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEAlphaRegionBackendServices.GetHealth(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.Alpha.RegionBackendServices.GetHealth(projectID, key.Region, key.Name, arg0)
	call.Context(ctx)
	v, err := call.Do()
	klog.V(4).Infof("GCEAlphaRegionBackendServices.GetHealth(%v, %v, ...) = %+v, %v", ctx, key, v, err)
	return v, err
}

// Update is a method on GCEAlphaRegionBackendServices.
func (g *GCEAlphaRegionBackendServices) Update(ctx context.Context, key *meta.Key, arg0 *alpha.BackendService) error {
	klog.V(5).Infof("GCEAlphaRegionBackendServices.Update(%v, %v, ...): called", ctx, key)

	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaRegionBackendServices.Update(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "alpha", "RegionBackendServices")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Update",
		Version:   meta.Version("alpha"),
		Service:   "RegionBackendServices",
	}
	klog.V(5).Infof("GCEAlphaRegionBackendServices.Update(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)

	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEAlphaRegionBackendServices.Update(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Alpha.RegionBackendServices.Update(projectID, key.Region, key.Name, arg0)
	call.Context(ctx)
	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCEAlphaRegionBackendServices.Update(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}
	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEAlphaRegionBackendServices.Update(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// BetaRegionBackendServices is an interface that allows for mocking of RegionBackendServices.
type BetaRegionBackendServices interface {
	Get(ctx context.Context, key *meta.Key) (*beta.BackendService, error)
	List(ctx context.Context, region string, fl *filter.F) ([]*beta.BackendService, error)
	Insert(ctx context.Context, key *meta.Key, obj *beta.BackendService) error
	Delete(ctx context.Context, key *meta.Key) error
	GetHealth(context.Context, *meta.Key, *beta.ResourceGroupReference) (*beta.BackendServiceGroupHealth, error)
	Update(context.Context, *meta.Key, *beta.BackendService) error
}

// NewMockBetaRegionBackendServices returns a new mock for RegionBackendServices.
func NewMockBetaRegionBackendServices(pr ProjectRouter, objs map[meta.Key]*MockRegionBackendServicesObj) *MockBetaRegionBackendServices {
	mock := &MockBetaRegionBackendServices{
		ProjectRouter: pr,

		Objects:     objs,
		GetError:    map[meta.Key]error{},
		InsertError: map[meta.Key]error{},
		DeleteError: map[meta.Key]error{},
	}
	return mock
}

// MockBetaRegionBackendServices is the mock for RegionBackendServices.
type MockBetaRegionBackendServices struct {
	Lock sync.Mutex

	ProjectRouter ProjectRouter

	// Objects maintained by the mock.
	Objects map[meta.Key]*MockRegionBackendServicesObj

	// If an entry exists for the given key and operation, then the error
	// will be returned instead of the operation.
	GetError    map[meta.Key]error
	ListError   *error
	InsertError map[meta.Key]error
	DeleteError map[meta.Key]error

	// xxxHook allow you to intercept the standard processing of the mock in
	// order to add your own logic. Return (true, _, _) to prevent the normal
	// execution flow of the mock. Return (false, nil, nil) to continue with
	// normal mock behavior/ after the hook function executes.
	GetHook       func(ctx context.Context, key *meta.Key, m *MockBetaRegionBackendServices) (bool, *beta.BackendService, error)
	ListHook      func(ctx context.Context, region string, fl *filter.F, m *MockBetaRegionBackendServices) (bool, []*beta.BackendService, error)
	InsertHook    func(ctx context.Context, key *meta.Key, obj *beta.BackendService, m *MockBetaRegionBackendServices) (bool, error)
	DeleteHook    func(ctx context.Context, key *meta.Key, m *MockBetaRegionBackendServices) (bool, error)
	GetHealthHook func(context.Context, *meta.Key, *beta.ResourceGroupReference, *MockBetaRegionBackendServices) (*beta.BackendServiceGroupHealth, error)
	UpdateHook    func(context.Context, *meta.Key, *beta.BackendService, *MockBetaRegionBackendServices) error

	// X is extra state that can be used as part of the mock. Generated code
	// will not use this field.
	X interface{}
}

// Get returns the object from the mock.
func (m *MockBetaRegionBackendServices) Get(ctx context.Context, key *meta.Key) (*beta.BackendService, error) {
	if m.GetHook != nil {
		if intercept, obj, err := m.GetHook(ctx, key, m); intercept {
			klog.V(5).Infof("MockBetaRegionBackendServices.Get(%v, %s) = %+v, %v", ctx, key, obj, err)
			return obj, err
		}
	}
	if !key.Valid() {
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.GetError[*key]; ok {
		klog.V(5).Infof("MockBetaRegionBackendServices.Get(%v, %s) = nil, %v", ctx, key, err)
		return nil, err
	}
	if obj, ok := m.Objects[*key]; ok {
		typedObj := obj.ToBeta()
		klog.V(5).Infof("MockBetaRegionBackendServices.Get(%v, %s) = %+v, nil", ctx, key, typedObj)
		return typedObj, nil
	}

	err := &googleapi.Error{
		Code:    http.StatusNotFound,
		Message: fmt.Sprintf("MockBetaRegionBackendServices %v not found", key),
	}
	klog.V(5).Infof("MockBetaRegionBackendServices.Get(%v, %s) = nil, %v", ctx, key, err)
	return nil, err
}

// List all of the objects in the mock in the given region.
func (m *MockBetaRegionBackendServices) List(ctx context.Context, region string, fl *filter.F) ([]*beta.BackendService, error) {
	if m.ListHook != nil {
		if intercept, objs, err := m.ListHook(ctx, region, fl, m); intercept {
			klog.V(5).Infof("MockBetaRegionBackendServices.List(%v, %q, %v) = [%v items], %v", ctx, region, fl, len(objs), err)
			return objs, err
		}
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if m.ListError != nil {
		err := *m.ListError
		klog.V(5).Infof("MockBetaRegionBackendServices.List(%v, %q, %v) = nil, %v", ctx, region, fl, err)

		return nil, *m.ListError
	}

	var objs []*beta.BackendService
	for key, obj := range m.Objects {
		if key.Region != region {
			continue
		}
		if !fl.Match(obj.ToBeta()) {
			continue
		}
		objs = append(objs, obj.ToBeta())
	}

	klog.V(5).Infof("MockBetaRegionBackendServices.List(%v, %q, %v) = [%v items], nil", ctx, region, fl, len(objs))
	return objs, nil
}

// Insert is a mock for inserting/creating a new object.
func (m *MockBetaRegionBackendServices) Insert(ctx context.Context, key *meta.Key, obj *beta.BackendService) error {
	if m.InsertHook != nil {
		if intercept, err := m.InsertHook(ctx, key, obj, m); intercept {
			klog.V(5).Infof("MockBetaRegionBackendServices.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.InsertError[*key]; ok {
		klog.V(5).Infof("MockBetaRegionBackendServices.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}
	if _, ok := m.Objects[*key]; ok {
		err := &googleapi.Error{
			Code:    http.StatusConflict,
			Message: fmt.Sprintf("MockBetaRegionBackendServices %v exists", key),
		}
		klog.V(5).Infof("MockBetaRegionBackendServices.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}

	obj.Name = key.Name
	projectID := m.ProjectRouter.ProjectID(ctx, "beta", "backendServices")
	obj.SelfLink = SelfLink(meta.VersionBeta, projectID, "backendServices", key)

	m.Objects[*key] = &MockRegionBackendServicesObj{obj}
	klog.V(5).Infof("MockBetaRegionBackendServices.Insert(%v, %v, %+v) = nil", ctx, key, obj)
	return nil
}

// Delete is a mock for deleting the object.
func (m *MockBetaRegionBackendServices) Delete(ctx context.Context, key *meta.Key) error {
	if m.DeleteHook != nil {
		if intercept, err := m.DeleteHook(ctx, key, m); intercept {
			klog.V(5).Infof("MockBetaRegionBackendServices.Delete(%v, %v) = %v", ctx, key, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.DeleteError[*key]; ok {
		klog.V(5).Infof("MockBetaRegionBackendServices.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}
	if _, ok := m.Objects[*key]; !ok {
		err := &googleapi.Error{
			Code:    http.StatusNotFound,
			Message: fmt.Sprintf("MockBetaRegionBackendServices %v not found", key),
		}
		klog.V(5).Infof("MockBetaRegionBackendServices.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	delete(m.Objects, *key)
	klog.V(5).Infof("MockBetaRegionBackendServices.Delete(%v, %v) = nil", ctx, key)
	return nil
}

// Obj wraps the object for use in the mock.
func (m *MockBetaRegionBackendServices) Obj(o *beta.BackendService) *MockRegionBackendServicesObj {
	return &MockRegionBackendServicesObj{o}
}

// GetHealth is a mock for the corresponding method.
func (m *MockBetaRegionBackendServices) GetHealth(ctx context.Context, key *meta.Key, arg0 *beta.ResourceGroupReference) (*beta.BackendServiceGroupHealth, error) {
	if m.GetHealthHook != nil {
		return m.GetHealthHook(ctx, key, arg0, m)
	}
	return nil, fmt.Errorf("GetHealthHook must be set")
}

// Update is a mock for the corresponding method.
func (m *MockBetaRegionBackendServices) Update(ctx context.Context, key *meta.Key, arg0 *beta.BackendService) error {
	if m.UpdateHook != nil {
		return m.UpdateHook(ctx, key, arg0, m)
	}
	return nil
}

// GCEBetaRegionBackendServices is a simplifying adapter for the GCE RegionBackendServices.
type GCEBetaRegionBackendServices struct {
	s *Service
}

// Get the BackendService named by key.
func (g *GCEBetaRegionBackendServices) Get(ctx context.Context, key *meta.Key) (*beta.BackendService, error) {
	klog.V(5).Infof("GCEBetaRegionBackendServices.Get(%v, %v): called", ctx, key)

	if !key.Valid() {
		klog.V(2).Infof("GCEBetaRegionBackendServices.Get(%v, %v): key is invalid (%#v)", ctx, key, key)
		return nil, fmt.Errorf("invalid GCE key (%#v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "beta", "RegionBackendServices")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Get",
		Version:   meta.Version("beta"),
		Service:   "RegionBackendServices",
	}
	klog.V(5).Infof("GCEBetaRegionBackendServices.Get(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEBetaRegionBackendServices.Get(%v, %v): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.Beta.RegionBackendServices.Get(projectID, key.Region, key.Name)
	call.Context(ctx)
	v, err := call.Do()
	klog.V(4).Infof("GCEBetaRegionBackendServices.Get(%v, %v) = %+v, %v", ctx, key, v, err)
	return v, err
}

// List all BackendService objects.
func (g *GCEBetaRegionBackendServices) List(ctx context.Context, region string, fl *filter.F) ([]*beta.BackendService, error) {
	klog.V(5).Infof("GCEBetaRegionBackendServices.List(%v, %v, %v) called", ctx, region, fl)
	projectID := g.s.ProjectRouter.ProjectID(ctx, "beta", "RegionBackendServices")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "List",
		Version:   meta.Version("beta"),
		Service:   "RegionBackendServices",
	}
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		return nil, err
	}
	klog.V(5).Infof("GCEBetaRegionBackendServices.List(%v, %v, %v): projectID = %v, rk = %+v", ctx, region, fl, projectID, rk)
	call := g.s.Beta.RegionBackendServices.List(projectID, region)
	if fl != filter.None {
		call.Filter(fl.String())
	}
	var all []*beta.BackendService
	f := func(l *beta.BackendServiceList) error {
		klog.V(5).Infof("GCEBetaRegionBackendServices.List(%v, ..., %v): page %+v", ctx, fl, l)
		all = append(all, l.Items...)
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		klog.V(4).Infof("GCEBetaRegionBackendServices.List(%v, ..., %v) = %v, %v", ctx, fl, nil, err)
		return nil, err
	}

	if klog.V(4).Enabled() {
		klog.V(4).Infof("GCEBetaRegionBackendServices.List(%v, ..., %v) = [%v items], %v", ctx, fl, len(all), nil)
	} else if klog.V(5).Enabled() {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		klog.V(5).Infof("GCEBetaRegionBackendServices.List(%v, ..., %v) = %v, %v", ctx, fl, asStr, nil)
	}

	return all, nil
}

// Insert BackendService with key of value obj.
func (g *GCEBetaRegionBackendServices) Insert(ctx context.Context, key *meta.Key, obj *beta.BackendService) error {
	klog.V(5).Infof("GCEBetaRegionBackendServices.Insert(%v, %v, %+v): called", ctx, key, obj)
	if !key.Valid() {
		klog.V(2).Infof("GCEBetaRegionBackendServices.Insert(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "beta", "RegionBackendServices")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Insert",
		Version:   meta.Version("beta"),
		Service:   "RegionBackendServices",
	}
	klog.V(5).Infof("GCEBetaRegionBackendServices.Insert(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEBetaRegionBackendServices.Insert(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	obj.Name = key.Name
	call := g.s.Beta.RegionBackendServices.Insert(projectID, key.Region, obj)
	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCEBetaRegionBackendServices.Insert(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEBetaRegionBackendServices.Insert(%v, %v, %+v) = %+v", ctx, key, obj, err)
	return err
}

// Delete the BackendService referenced by key.
func (g *GCEBetaRegionBackendServices) Delete(ctx context.Context, key *meta.Key) error {
	klog.V(5).Infof("GCEBetaRegionBackendServices.Delete(%v, %v): called", ctx, key)
	if !key.Valid() {
		klog.V(2).Infof("GCEBetaRegionBackendServices.Delete(%v, %v): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "beta", "RegionBackendServices")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Delete",
		Version:   meta.Version("beta"),
		Service:   "RegionBackendServices",
	}
	klog.V(5).Infof("GCEBetaRegionBackendServices.Delete(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEBetaRegionBackendServices.Delete(%v, %v): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Beta.RegionBackendServices.Delete(projectID, key.Region, key.Name)
	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCEBetaRegionBackendServices.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEBetaRegionBackendServices.Delete(%v, %v) = %v", ctx, key, err)
	return err
}

// GetHealth is a method on GCEBetaRegionBackendServices.
func (g *GCEBetaRegionBackendServices) GetHealth(ctx context.Context, key *meta.Key, arg0 *beta.ResourceGroupReference) (*beta.BackendServiceGroupHealth, error) {
	klog.V(5).Infof("GCEBetaRegionBackendServices.GetHealth(%v, %v, ...): called", ctx, key)

	if !key.Valid() {
		klog.V(2).Infof("GCEBetaRegionBackendServices.GetHealth(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "beta", "RegionBackendServices")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "GetHealth",
		Version:   meta.Version("beta"),
		Service:   "RegionBackendServices",
	}
	klog.V(5).Infof("GCEBetaRegionBackendServices.GetHealth(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)

	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEBetaRegionBackendServices.GetHealth(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.Beta.RegionBackendServices.GetHealth(projectID, key.Region, key.Name, arg0)
	call.Context(ctx)
	v, err := call.Do()
	klog.V(4).Infof("GCEBetaRegionBackendServices.GetHealth(%v, %v, ...) = %+v, %v", ctx, key, v, err)
	return v, err
}

// Update is a method on GCEBetaRegionBackendServices.
func (g *GCEBetaRegionBackendServices) Update(ctx context.Context, key *meta.Key, arg0 *beta.BackendService) error {
	klog.V(5).Infof("GCEBetaRegionBackendServices.Update(%v, %v, ...): called", ctx, key)

	if !key.Valid() {
		klog.V(2).Infof("GCEBetaRegionBackendServices.Update(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "beta", "RegionBackendServices")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Update",
		Version:   meta.Version("beta"),
		Service:   "RegionBackendServices",
	}
	klog.V(5).Infof("GCEBetaRegionBackendServices.Update(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)

	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEBetaRegionBackendServices.Update(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Beta.RegionBackendServices.Update(projectID, key.Region, key.Name, arg0)
	call.Context(ctx)
	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCEBetaRegionBackendServices.Update(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}
	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEBetaRegionBackendServices.Update(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// Disks is an interface that allows for mocking of Disks.
type Disks interface {
	Get(ctx context.Context, key *meta.Key) (*ga.Disk, error)
	List(ctx context.Context, zone string, fl *filter.F) ([]*ga.Disk, error)
	Insert(ctx context.Context, key *meta.Key, obj *ga.Disk) error
	Delete(ctx context.Context, key *meta.Key) error
	Resize(context.Context, *meta.Key, *ga.DisksResizeRequest) error
}

// NewMockDisks returns a new mock for Disks.
func NewMockDisks(pr ProjectRouter, objs map[meta.Key]*MockDisksObj) *MockDisks {
	mock := &MockDisks{
		ProjectRouter: pr,

		Objects:     objs,
		GetError:    map[meta.Key]error{},
		InsertError: map[meta.Key]error{},
		DeleteError: map[meta.Key]error{},
	}
	return mock
}

// MockDisks is the mock for Disks.
type MockDisks struct {
	Lock sync.Mutex

	ProjectRouter ProjectRouter

	// Objects maintained by the mock.
	Objects map[meta.Key]*MockDisksObj

	// If an entry exists for the given key and operation, then the error
	// will be returned instead of the operation.
	GetError    map[meta.Key]error
	ListError   *error
	InsertError map[meta.Key]error
	DeleteError map[meta.Key]error

	// xxxHook allow you to intercept the standard processing of the mock in
	// order to add your own logic. Return (true, _, _) to prevent the normal
	// execution flow of the mock. Return (false, nil, nil) to continue with
	// normal mock behavior/ after the hook function executes.
	GetHook    func(ctx context.Context, key *meta.Key, m *MockDisks) (bool, *ga.Disk, error)
	ListHook   func(ctx context.Context, zone string, fl *filter.F, m *MockDisks) (bool, []*ga.Disk, error)
	InsertHook func(ctx context.Context, key *meta.Key, obj *ga.Disk, m *MockDisks) (bool, error)
	DeleteHook func(ctx context.Context, key *meta.Key, m *MockDisks) (bool, error)
	ResizeHook func(context.Context, *meta.Key, *ga.DisksResizeRequest, *MockDisks) error

	// X is extra state that can be used as part of the mock. Generated code
	// will not use this field.
	X interface{}
}

// Get returns the object from the mock.
func (m *MockDisks) Get(ctx context.Context, key *meta.Key) (*ga.Disk, error) {
	if m.GetHook != nil {
		if intercept, obj, err := m.GetHook(ctx, key, m); intercept {
			klog.V(5).Infof("MockDisks.Get(%v, %s) = %+v, %v", ctx, key, obj, err)
			return obj, err
		}
	}
	if !key.Valid() {
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.GetError[*key]; ok {
		klog.V(5).Infof("MockDisks.Get(%v, %s) = nil, %v", ctx, key, err)
		return nil, err
	}
	if obj, ok := m.Objects[*key]; ok {
		typedObj := obj.ToGA()
		klog.V(5).Infof("MockDisks.Get(%v, %s) = %+v, nil", ctx, key, typedObj)
		return typedObj, nil
	}

	err := &googleapi.Error{
		Code:    http.StatusNotFound,
		Message: fmt.Sprintf("MockDisks %v not found", key),
	}
	klog.V(5).Infof("MockDisks.Get(%v, %s) = nil, %v", ctx, key, err)
	return nil, err
}

// List all of the objects in the mock in the given zone.
func (m *MockDisks) List(ctx context.Context, zone string, fl *filter.F) ([]*ga.Disk, error) {
	if m.ListHook != nil {
		if intercept, objs, err := m.ListHook(ctx, zone, fl, m); intercept {
			klog.V(5).Infof("MockDisks.List(%v, %q, %v) = [%v items], %v", ctx, zone, fl, len(objs), err)
			return objs, err
		}
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if m.ListError != nil {
		err := *m.ListError
		klog.V(5).Infof("MockDisks.List(%v, %q, %v) = nil, %v", ctx, zone, fl, err)

		return nil, *m.ListError
	}

	var objs []*ga.Disk
	for key, obj := range m.Objects {
		if key.Zone != zone {
			continue
		}
		if !fl.Match(obj.ToGA()) {
			continue
		}
		objs = append(objs, obj.ToGA())
	}

	klog.V(5).Infof("MockDisks.List(%v, %q, %v) = [%v items], nil", ctx, zone, fl, len(objs))
	return objs, nil
}

// Insert is a mock for inserting/creating a new object.
func (m *MockDisks) Insert(ctx context.Context, key *meta.Key, obj *ga.Disk) error {
	if m.InsertHook != nil {
		if intercept, err := m.InsertHook(ctx, key, obj, m); intercept {
			klog.V(5).Infof("MockDisks.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.InsertError[*key]; ok {
		klog.V(5).Infof("MockDisks.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}
	if _, ok := m.Objects[*key]; ok {
		err := &googleapi.Error{
			Code:    http.StatusConflict,
			Message: fmt.Sprintf("MockDisks %v exists", key),
		}
		klog.V(5).Infof("MockDisks.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}

	obj.Name = key.Name
	projectID := m.ProjectRouter.ProjectID(ctx, "ga", "disks")
	obj.SelfLink = SelfLink(meta.VersionGA, projectID, "disks", key)

	m.Objects[*key] = &MockDisksObj{obj}
	klog.V(5).Infof("MockDisks.Insert(%v, %v, %+v) = nil", ctx, key, obj)
	return nil
}

// Delete is a mock for deleting the object.
func (m *MockDisks) Delete(ctx context.Context, key *meta.Key) error {
	if m.DeleteHook != nil {
		if intercept, err := m.DeleteHook(ctx, key, m); intercept {
			klog.V(5).Infof("MockDisks.Delete(%v, %v) = %v", ctx, key, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.DeleteError[*key]; ok {
		klog.V(5).Infof("MockDisks.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}
	if _, ok := m.Objects[*key]; !ok {
		err := &googleapi.Error{
			Code:    http.StatusNotFound,
			Message: fmt.Sprintf("MockDisks %v not found", key),
		}
		klog.V(5).Infof("MockDisks.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	delete(m.Objects, *key)
	klog.V(5).Infof("MockDisks.Delete(%v, %v) = nil", ctx, key)
	return nil
}

// Obj wraps the object for use in the mock.
func (m *MockDisks) Obj(o *ga.Disk) *MockDisksObj {
	return &MockDisksObj{o}
}

// Resize is a mock for the corresponding method.
func (m *MockDisks) Resize(ctx context.Context, key *meta.Key, arg0 *ga.DisksResizeRequest) error {
	if m.ResizeHook != nil {
		return m.ResizeHook(ctx, key, arg0, m)
	}
	return nil
}

// GCEDisks is a simplifying adapter for the GCE Disks.
type GCEDisks struct {
	s *Service
}

// Get the Disk named by key.
func (g *GCEDisks) Get(ctx context.Context, key *meta.Key) (*ga.Disk, error) {
	klog.V(5).Infof("GCEDisks.Get(%v, %v): called", ctx, key)

	if !key.Valid() {
		klog.V(2).Infof("GCEDisks.Get(%v, %v): key is invalid (%#v)", ctx, key, key)
		return nil, fmt.Errorf("invalid GCE key (%#v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "Disks")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Get",
		Version:   meta.Version("ga"),
		Service:   "Disks",
	}
	klog.V(5).Infof("GCEDisks.Get(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEDisks.Get(%v, %v): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.GA.Disks.Get(projectID, key.Zone, key.Name)
	call.Context(ctx)
	v, err := call.Do()
	klog.V(4).Infof("GCEDisks.Get(%v, %v) = %+v, %v", ctx, key, v, err)
	return v, err
}

// List all Disk objects.
func (g *GCEDisks) List(ctx context.Context, zone string, fl *filter.F) ([]*ga.Disk, error) {
	klog.V(5).Infof("GCEDisks.List(%v, %v, %v) called", ctx, zone, fl)
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "Disks")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "List",
		Version:   meta.Version("ga"),
		Service:   "Disks",
	}
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		return nil, err
	}
	klog.V(5).Infof("GCEDisks.List(%v, %v, %v): projectID = %v, rk = %+v", ctx, zone, fl, projectID, rk)
	call := g.s.GA.Disks.List(projectID, zone)
	if fl != filter.None {
		call.Filter(fl.String())
	}
	var all []*ga.Disk
	f := func(l *ga.DiskList) error {
		klog.V(5).Infof("GCEDisks.List(%v, ..., %v): page %+v", ctx, fl, l)
		all = append(all, l.Items...)
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		klog.V(4).Infof("GCEDisks.List(%v, ..., %v) = %v, %v", ctx, fl, nil, err)
		return nil, err
	}

	if klog.V(4).Enabled() {
		klog.V(4).Infof("GCEDisks.List(%v, ..., %v) = [%v items], %v", ctx, fl, len(all), nil)
	} else if klog.V(5).Enabled() {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		klog.V(5).Infof("GCEDisks.List(%v, ..., %v) = %v, %v", ctx, fl, asStr, nil)
	}

	return all, nil
}

// Insert Disk with key of value obj.
func (g *GCEDisks) Insert(ctx context.Context, key *meta.Key, obj *ga.Disk) error {
	klog.V(5).Infof("GCEDisks.Insert(%v, %v, %+v): called", ctx, key, obj)
	if !key.Valid() {
		klog.V(2).Infof("GCEDisks.Insert(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "Disks")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Insert",
		Version:   meta.Version("ga"),
		Service:   "Disks",
	}
	klog.V(5).Infof("GCEDisks.Insert(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEDisks.Insert(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	obj.Name = key.Name
	call := g.s.GA.Disks.Insert(projectID, key.Zone, obj)
	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCEDisks.Insert(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEDisks.Insert(%v, %v, %+v) = %+v", ctx, key, obj, err)
	return err
}

// Delete the Disk referenced by key.
func (g *GCEDisks) Delete(ctx context.Context, key *meta.Key) error {
	klog.V(5).Infof("GCEDisks.Delete(%v, %v): called", ctx, key)
	if !key.Valid() {
		klog.V(2).Infof("GCEDisks.Delete(%v, %v): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "Disks")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Delete",
		Version:   meta.Version("ga"),
		Service:   "Disks",
	}
	klog.V(5).Infof("GCEDisks.Delete(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEDisks.Delete(%v, %v): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.GA.Disks.Delete(projectID, key.Zone, key.Name)
	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCEDisks.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEDisks.Delete(%v, %v) = %v", ctx, key, err)
	return err
}

// Resize is a method on GCEDisks.
func (g *GCEDisks) Resize(ctx context.Context, key *meta.Key, arg0 *ga.DisksResizeRequest) error {
	klog.V(5).Infof("GCEDisks.Resize(%v, %v, ...): called", ctx, key)

	if !key.Valid() {
		klog.V(2).Infof("GCEDisks.Resize(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "Disks")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Resize",
		Version:   meta.Version("ga"),
		Service:   "Disks",
	}
	klog.V(5).Infof("GCEDisks.Resize(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)

	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEDisks.Resize(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.GA.Disks.Resize(projectID, key.Zone, key.Name, arg0)
	call.Context(ctx)
	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCEDisks.Resize(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}
	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEDisks.Resize(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// RegionDisks is an interface that allows for mocking of RegionDisks.
type RegionDisks interface {
	Get(ctx context.Context, key *meta.Key) (*ga.Disk, error)
	List(ctx context.Context, region string, fl *filter.F) ([]*ga.Disk, error)
	Insert(ctx context.Context, key *meta.Key, obj *ga.Disk) error
	Delete(ctx context.Context, key *meta.Key) error
	Resize(context.Context, *meta.Key, *ga.RegionDisksResizeRequest) error
}

// NewMockRegionDisks returns a new mock for RegionDisks.
func NewMockRegionDisks(pr ProjectRouter, objs map[meta.Key]*MockRegionDisksObj) *MockRegionDisks {
	mock := &MockRegionDisks{
		ProjectRouter: pr,

		Objects:     objs,
		GetError:    map[meta.Key]error{},
		InsertError: map[meta.Key]error{},
		DeleteError: map[meta.Key]error{},
	}
	return mock
}

// MockRegionDisks is the mock for RegionDisks.
type MockRegionDisks struct {
	Lock sync.Mutex

	ProjectRouter ProjectRouter

	// Objects maintained by the mock.
	Objects map[meta.Key]*MockRegionDisksObj

	// If an entry exists for the given key and operation, then the error
	// will be returned instead of the operation.
	GetError    map[meta.Key]error
	ListError   *error
	InsertError map[meta.Key]error
	DeleteError map[meta.Key]error

	// xxxHook allow you to intercept the standard processing of the mock in
	// order to add your own logic. Return (true, _, _) to prevent the normal
	// execution flow of the mock. Return (false, nil, nil) to continue with
	// normal mock behavior/ after the hook function executes.
	GetHook    func(ctx context.Context, key *meta.Key, m *MockRegionDisks) (bool, *ga.Disk, error)
	ListHook   func(ctx context.Context, region string, fl *filter.F, m *MockRegionDisks) (bool, []*ga.Disk, error)
	InsertHook func(ctx context.Context, key *meta.Key, obj *ga.Disk, m *MockRegionDisks) (bool, error)
	DeleteHook func(ctx context.Context, key *meta.Key, m *MockRegionDisks) (bool, error)
	ResizeHook func(context.Context, *meta.Key, *ga.RegionDisksResizeRequest, *MockRegionDisks) error

	// X is extra state that can be used as part of the mock. Generated code
	// will not use this field.
	X interface{}
}

// Get returns the object from the mock.
func (m *MockRegionDisks) Get(ctx context.Context, key *meta.Key) (*ga.Disk, error) {
	if m.GetHook != nil {
		if intercept, obj, err := m.GetHook(ctx, key, m); intercept {
			klog.V(5).Infof("MockRegionDisks.Get(%v, %s) = %+v, %v", ctx, key, obj, err)
			return obj, err
		}
	}
	if !key.Valid() {
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.GetError[*key]; ok {
		klog.V(5).Infof("MockRegionDisks.Get(%v, %s) = nil, %v", ctx, key, err)
		return nil, err
	}
	if obj, ok := m.Objects[*key]; ok {
		typedObj := obj.ToGA()
		klog.V(5).Infof("MockRegionDisks.Get(%v, %s) = %+v, nil", ctx, key, typedObj)
		return typedObj, nil
	}

	err := &googleapi.Error{
		Code:    http.StatusNotFound,
		Message: fmt.Sprintf("MockRegionDisks %v not found", key),
	}
	klog.V(5).Infof("MockRegionDisks.Get(%v, %s) = nil, %v", ctx, key, err)
	return nil, err
}

// List all of the objects in the mock in the given region.
func (m *MockRegionDisks) List(ctx context.Context, region string, fl *filter.F) ([]*ga.Disk, error) {
	if m.ListHook != nil {
		if intercept, objs, err := m.ListHook(ctx, region, fl, m); intercept {
			klog.V(5).Infof("MockRegionDisks.List(%v, %q, %v) = [%v items], %v", ctx, region, fl, len(objs), err)
			return objs, err
		}
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if m.ListError != nil {
		err := *m.ListError
		klog.V(5).Infof("MockRegionDisks.List(%v, %q, %v) = nil, %v", ctx, region, fl, err)

		return nil, *m.ListError
	}

	var objs []*ga.Disk
	for key, obj := range m.Objects {
		if key.Region != region {
			continue
		}
		if !fl.Match(obj.ToGA()) {
			continue
		}
		objs = append(objs, obj.ToGA())
	}

	klog.V(5).Infof("MockRegionDisks.List(%v, %q, %v) = [%v items], nil", ctx, region, fl, len(objs))
	return objs, nil
}

// Insert is a mock for inserting/creating a new object.
func (m *MockRegionDisks) Insert(ctx context.Context, key *meta.Key, obj *ga.Disk) error {
	if m.InsertHook != nil {
		if intercept, err := m.InsertHook(ctx, key, obj, m); intercept {
			klog.V(5).Infof("MockRegionDisks.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.InsertError[*key]; ok {
		klog.V(5).Infof("MockRegionDisks.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}
	if _, ok := m.Objects[*key]; ok {
		err := &googleapi.Error{
			Code:    http.StatusConflict,
			Message: fmt.Sprintf("MockRegionDisks %v exists", key),
		}
		klog.V(5).Infof("MockRegionDisks.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}

	obj.Name = key.Name
	projectID := m.ProjectRouter.ProjectID(ctx, "ga", "disks")
	obj.SelfLink = SelfLink(meta.VersionGA, projectID, "disks", key)

	m.Objects[*key] = &MockRegionDisksObj{obj}
	klog.V(5).Infof("MockRegionDisks.Insert(%v, %v, %+v) = nil", ctx, key, obj)
	return nil
}

// Delete is a mock for deleting the object.
func (m *MockRegionDisks) Delete(ctx context.Context, key *meta.Key) error {
	if m.DeleteHook != nil {
		if intercept, err := m.DeleteHook(ctx, key, m); intercept {
			klog.V(5).Infof("MockRegionDisks.Delete(%v, %v) = %v", ctx, key, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.DeleteError[*key]; ok {
		klog.V(5).Infof("MockRegionDisks.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}
	if _, ok := m.Objects[*key]; !ok {
		err := &googleapi.Error{
			Code:    http.StatusNotFound,
			Message: fmt.Sprintf("MockRegionDisks %v not found", key),
		}
		klog.V(5).Infof("MockRegionDisks.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	delete(m.Objects, *key)
	klog.V(5).Infof("MockRegionDisks.Delete(%v, %v) = nil", ctx, key)
	return nil
}

// Obj wraps the object for use in the mock.
func (m *MockRegionDisks) Obj(o *ga.Disk) *MockRegionDisksObj {
	return &MockRegionDisksObj{o}
}

// Resize is a mock for the corresponding method.
func (m *MockRegionDisks) Resize(ctx context.Context, key *meta.Key, arg0 *ga.RegionDisksResizeRequest) error {
	if m.ResizeHook != nil {
		return m.ResizeHook(ctx, key, arg0, m)
	}
	return nil
}

// GCERegionDisks is a simplifying adapter for the GCE RegionDisks.
type GCERegionDisks struct {
	s *Service
}

// Get the Disk named by key.
func (g *GCERegionDisks) Get(ctx context.Context, key *meta.Key) (*ga.Disk, error) {
	klog.V(5).Infof("GCERegionDisks.Get(%v, %v): called", ctx, key)

	if !key.Valid() {
		klog.V(2).Infof("GCERegionDisks.Get(%v, %v): key is invalid (%#v)", ctx, key, key)
		return nil, fmt.Errorf("invalid GCE key (%#v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "RegionDisks")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Get",
		Version:   meta.Version("ga"),
		Service:   "RegionDisks",
	}
	klog.V(5).Infof("GCERegionDisks.Get(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCERegionDisks.Get(%v, %v): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.GA.RegionDisks.Get(projectID, key.Region, key.Name)
	call.Context(ctx)
	v, err := call.Do()
	klog.V(4).Infof("GCERegionDisks.Get(%v, %v) = %+v, %v", ctx, key, v, err)
	return v, err
}

// List all Disk objects.
func (g *GCERegionDisks) List(ctx context.Context, region string, fl *filter.F) ([]*ga.Disk, error) {
	klog.V(5).Infof("GCERegionDisks.List(%v, %v, %v) called", ctx, region, fl)
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "RegionDisks")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "List",
		Version:   meta.Version("ga"),
		Service:   "RegionDisks",
	}
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		return nil, err
	}
	klog.V(5).Infof("GCERegionDisks.List(%v, %v, %v): projectID = %v, rk = %+v", ctx, region, fl, projectID, rk)
	call := g.s.GA.RegionDisks.List(projectID, region)
	if fl != filter.None {
		call.Filter(fl.String())
	}
	var all []*ga.Disk
	f := func(l *ga.DiskList) error {
		klog.V(5).Infof("GCERegionDisks.List(%v, ..., %v): page %+v", ctx, fl, l)
		all = append(all, l.Items...)
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		klog.V(4).Infof("GCERegionDisks.List(%v, ..., %v) = %v, %v", ctx, fl, nil, err)
		return nil, err
	}

	if klog.V(4).Enabled() {
		klog.V(4).Infof("GCERegionDisks.List(%v, ..., %v) = [%v items], %v", ctx, fl, len(all), nil)
	} else if klog.V(5).Enabled() {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		klog.V(5).Infof("GCERegionDisks.List(%v, ..., %v) = %v, %v", ctx, fl, asStr, nil)
	}

	return all, nil
}

// Insert Disk with key of value obj.
func (g *GCERegionDisks) Insert(ctx context.Context, key *meta.Key, obj *ga.Disk) error {
	klog.V(5).Infof("GCERegionDisks.Insert(%v, %v, %+v): called", ctx, key, obj)
	if !key.Valid() {
		klog.V(2).Infof("GCERegionDisks.Insert(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "RegionDisks")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Insert",
		Version:   meta.Version("ga"),
		Service:   "RegionDisks",
	}
	klog.V(5).Infof("GCERegionDisks.Insert(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCERegionDisks.Insert(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	obj.Name = key.Name
	call := g.s.GA.RegionDisks.Insert(projectID, key.Region, obj)
	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCERegionDisks.Insert(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCERegionDisks.Insert(%v, %v, %+v) = %+v", ctx, key, obj, err)
	return err
}

// Delete the Disk referenced by key.
func (g *GCERegionDisks) Delete(ctx context.Context, key *meta.Key) error {
	klog.V(5).Infof("GCERegionDisks.Delete(%v, %v): called", ctx, key)
	if !key.Valid() {
		klog.V(2).Infof("GCERegionDisks.Delete(%v, %v): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "RegionDisks")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Delete",
		Version:   meta.Version("ga"),
		Service:   "RegionDisks",
	}
	klog.V(5).Infof("GCERegionDisks.Delete(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCERegionDisks.Delete(%v, %v): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.GA.RegionDisks.Delete(projectID, key.Region, key.Name)
	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCERegionDisks.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCERegionDisks.Delete(%v, %v) = %v", ctx, key, err)
	return err
}

// Resize is a method on GCERegionDisks.
func (g *GCERegionDisks) Resize(ctx context.Context, key *meta.Key, arg0 *ga.RegionDisksResizeRequest) error {
	klog.V(5).Infof("GCERegionDisks.Resize(%v, %v, ...): called", ctx, key)

	if !key.Valid() {
		klog.V(2).Infof("GCERegionDisks.Resize(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "RegionDisks")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Resize",
		Version:   meta.Version("ga"),
		Service:   "RegionDisks",
	}
	klog.V(5).Infof("GCERegionDisks.Resize(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)

	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCERegionDisks.Resize(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.GA.RegionDisks.Resize(projectID, key.Region, key.Name, arg0)
	call.Context(ctx)
	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCERegionDisks.Resize(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}
	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCERegionDisks.Resize(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// AlphaFirewalls is an interface that allows for mocking of Firewalls.
type AlphaFirewalls interface {
	Get(ctx context.Context, key *meta.Key) (*alpha.Firewall, error)
	List(ctx context.Context, fl *filter.F) ([]*alpha.Firewall, error)
	Insert(ctx context.Context, key *meta.Key, obj *alpha.Firewall) error
	Delete(ctx context.Context, key *meta.Key) error
	Update(context.Context, *meta.Key, *alpha.Firewall) error
}

// NewMockAlphaFirewalls returns a new mock for Firewalls.
func NewMockAlphaFirewalls(pr ProjectRouter, objs map[meta.Key]*MockFirewallsObj) *MockAlphaFirewalls {
	mock := &MockAlphaFirewalls{
		ProjectRouter: pr,

		Objects:     objs,
		GetError:    map[meta.Key]error{},
		InsertError: map[meta.Key]error{},
		DeleteError: map[meta.Key]error{},
	}
	return mock
}

// MockAlphaFirewalls is the mock for Firewalls.
type MockAlphaFirewalls struct {
	Lock sync.Mutex

	ProjectRouter ProjectRouter

	// Objects maintained by the mock.
	Objects map[meta.Key]*MockFirewallsObj

	// If an entry exists for the given key and operation, then the error
	// will be returned instead of the operation.
	GetError    map[meta.Key]error
	ListError   *error
	InsertError map[meta.Key]error
	DeleteError map[meta.Key]error

	// xxxHook allow you to intercept the standard processing of the mock in
	// order to add your own logic. Return (true, _, _) to prevent the normal
	// execution flow of the mock. Return (false, nil, nil) to continue with
	// normal mock behavior/ after the hook function executes.
	GetHook    func(ctx context.Context, key *meta.Key, m *MockAlphaFirewalls) (bool, *alpha.Firewall, error)
	ListHook   func(ctx context.Context, fl *filter.F, m *MockAlphaFirewalls) (bool, []*alpha.Firewall, error)
	InsertHook func(ctx context.Context, key *meta.Key, obj *alpha.Firewall, m *MockAlphaFirewalls) (bool, error)
	DeleteHook func(ctx context.Context, key *meta.Key, m *MockAlphaFirewalls) (bool, error)
	UpdateHook func(context.Context, *meta.Key, *alpha.Firewall, *MockAlphaFirewalls) error

	// X is extra state that can be used as part of the mock. Generated code
	// will not use this field.
	X interface{}
}

// Get returns the object from the mock.
func (m *MockAlphaFirewalls) Get(ctx context.Context, key *meta.Key) (*alpha.Firewall, error) {
	if m.GetHook != nil {
		if intercept, obj, err := m.GetHook(ctx, key, m); intercept {
			klog.V(5).Infof("MockAlphaFirewalls.Get(%v, %s) = %+v, %v", ctx, key, obj, err)
			return obj, err
		}
	}
	if !key.Valid() {
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.GetError[*key]; ok {
		klog.V(5).Infof("MockAlphaFirewalls.Get(%v, %s) = nil, %v", ctx, key, err)
		return nil, err
	}
	if obj, ok := m.Objects[*key]; ok {
		typedObj := obj.ToAlpha()
		klog.V(5).Infof("MockAlphaFirewalls.Get(%v, %s) = %+v, nil", ctx, key, typedObj)
		return typedObj, nil
	}

	err := &googleapi.Error{
		Code:    http.StatusNotFound,
		Message: fmt.Sprintf("MockAlphaFirewalls %v not found", key),
	}
	klog.V(5).Infof("MockAlphaFirewalls.Get(%v, %s) = nil, %v", ctx, key, err)
	return nil, err
}

// List all of the objects in the mock.
func (m *MockAlphaFirewalls) List(ctx context.Context, fl *filter.F) ([]*alpha.Firewall, error) {
	if m.ListHook != nil {
		if intercept, objs, err := m.ListHook(ctx, fl, m); intercept {
			klog.V(5).Infof("MockAlphaFirewalls.List(%v, %v) = [%v items], %v", ctx, fl, len(objs), err)
			return objs, err
		}
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if m.ListError != nil {
		err := *m.ListError
		klog.V(5).Infof("MockAlphaFirewalls.List(%v, %v) = nil, %v", ctx, fl, err)

		return nil, *m.ListError
	}

	var objs []*alpha.Firewall
	for _, obj := range m.Objects {
		if !fl.Match(obj.ToAlpha()) {
			continue
		}
		objs = append(objs, obj.ToAlpha())
	}

	klog.V(5).Infof("MockAlphaFirewalls.List(%v, %v) = [%v items], nil", ctx, fl, len(objs))
	return objs, nil
}

// Insert is a mock for inserting/creating a new object.
func (m *MockAlphaFirewalls) Insert(ctx context.Context, key *meta.Key, obj *alpha.Firewall) error {
	if m.InsertHook != nil {
		if intercept, err := m.InsertHook(ctx, key, obj, m); intercept {
			klog.V(5).Infof("MockAlphaFirewalls.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.InsertError[*key]; ok {
		klog.V(5).Infof("MockAlphaFirewalls.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}
	if _, ok := m.Objects[*key]; ok {
		err := &googleapi.Error{
			Code:    http.StatusConflict,
			Message: fmt.Sprintf("MockAlphaFirewalls %v exists", key),
		}
		klog.V(5).Infof("MockAlphaFirewalls.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}

	obj.Name = key.Name
	projectID := m.ProjectRouter.ProjectID(ctx, "alpha", "firewalls")
	obj.SelfLink = SelfLink(meta.VersionAlpha, projectID, "firewalls", key)

	m.Objects[*key] = &MockFirewallsObj{obj}
	klog.V(5).Infof("MockAlphaFirewalls.Insert(%v, %v, %+v) = nil", ctx, key, obj)
	return nil
}

// Delete is a mock for deleting the object.
func (m *MockAlphaFirewalls) Delete(ctx context.Context, key *meta.Key) error {
	if m.DeleteHook != nil {
		if intercept, err := m.DeleteHook(ctx, key, m); intercept {
			klog.V(5).Infof("MockAlphaFirewalls.Delete(%v, %v) = %v", ctx, key, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.DeleteError[*key]; ok {
		klog.V(5).Infof("MockAlphaFirewalls.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}
	if _, ok := m.Objects[*key]; !ok {
		err := &googleapi.Error{
			Code:    http.StatusNotFound,
			Message: fmt.Sprintf("MockAlphaFirewalls %v not found", key),
		}
		klog.V(5).Infof("MockAlphaFirewalls.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	delete(m.Objects, *key)
	klog.V(5).Infof("MockAlphaFirewalls.Delete(%v, %v) = nil", ctx, key)
	return nil
}

// Obj wraps the object for use in the mock.
func (m *MockAlphaFirewalls) Obj(o *alpha.Firewall) *MockFirewallsObj {
	return &MockFirewallsObj{o}
}

// Update is a mock for the corresponding method.
func (m *MockAlphaFirewalls) Update(ctx context.Context, key *meta.Key, arg0 *alpha.Firewall) error {
	if m.UpdateHook != nil {
		return m.UpdateHook(ctx, key, arg0, m)
	}
	return nil
}

// GCEAlphaFirewalls is a simplifying adapter for the GCE Firewalls.
type GCEAlphaFirewalls struct {
	s *Service
}

// Get the Firewall named by key.
func (g *GCEAlphaFirewalls) Get(ctx context.Context, key *meta.Key) (*alpha.Firewall, error) {
	klog.V(5).Infof("GCEAlphaFirewalls.Get(%v, %v): called", ctx, key)

	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaFirewalls.Get(%v, %v): key is invalid (%#v)", ctx, key, key)
		return nil, fmt.Errorf("invalid GCE key (%#v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "alpha", "Firewalls")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Get",
		Version:   meta.Version("alpha"),
		Service:   "Firewalls",
	}
	klog.V(5).Infof("GCEAlphaFirewalls.Get(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEAlphaFirewalls.Get(%v, %v): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.Alpha.Firewalls.Get(projectID, key.Name)
	call.Context(ctx)
	v, err := call.Do()
	klog.V(4).Infof("GCEAlphaFirewalls.Get(%v, %v) = %+v, %v", ctx, key, v, err)
	return v, err
}

// List all Firewall objects.
func (g *GCEAlphaFirewalls) List(ctx context.Context, fl *filter.F) ([]*alpha.Firewall, error) {
	klog.V(5).Infof("GCEAlphaFirewalls.List(%v, %v) called", ctx, fl)
	projectID := g.s.ProjectRouter.ProjectID(ctx, "alpha", "Firewalls")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "List",
		Version:   meta.Version("alpha"),
		Service:   "Firewalls",
	}
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		return nil, err
	}
	klog.V(5).Infof("GCEAlphaFirewalls.List(%v, %v): projectID = %v, rk = %+v", ctx, fl, projectID, rk)
	call := g.s.Alpha.Firewalls.List(projectID)
	if fl != filter.None {
		call.Filter(fl.String())
	}
	var all []*alpha.Firewall
	f := func(l *alpha.FirewallList) error {
		klog.V(5).Infof("GCEAlphaFirewalls.List(%v, ..., %v): page %+v", ctx, fl, l)
		all = append(all, l.Items...)
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		klog.V(4).Infof("GCEAlphaFirewalls.List(%v, ..., %v) = %v, %v", ctx, fl, nil, err)
		return nil, err
	}

	if klog.V(4).Enabled() {
		klog.V(4).Infof("GCEAlphaFirewalls.List(%v, ..., %v) = [%v items], %v", ctx, fl, len(all), nil)
	} else if klog.V(5).Enabled() {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		klog.V(5).Infof("GCEAlphaFirewalls.List(%v, ..., %v) = %v, %v", ctx, fl, asStr, nil)
	}

	return all, nil
}

// Insert Firewall with key of value obj.
func (g *GCEAlphaFirewalls) Insert(ctx context.Context, key *meta.Key, obj *alpha.Firewall) error {
	klog.V(5).Infof("GCEAlphaFirewalls.Insert(%v, %v, %+v): called", ctx, key, obj)
	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaFirewalls.Insert(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "alpha", "Firewalls")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Insert",
		Version:   meta.Version("alpha"),
		Service:   "Firewalls",
	}
	klog.V(5).Infof("GCEAlphaFirewalls.Insert(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEAlphaFirewalls.Insert(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	obj.Name = key.Name
	call := g.s.Alpha.Firewalls.Insert(projectID, obj)
	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCEAlphaFirewalls.Insert(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEAlphaFirewalls.Insert(%v, %v, %+v) = %+v", ctx, key, obj, err)
	return err
}

// Delete the Firewall referenced by key.
func (g *GCEAlphaFirewalls) Delete(ctx context.Context, key *meta.Key) error {
	klog.V(5).Infof("GCEAlphaFirewalls.Delete(%v, %v): called", ctx, key)
	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaFirewalls.Delete(%v, %v): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "alpha", "Firewalls")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Delete",
		Version:   meta.Version("alpha"),
		Service:   "Firewalls",
	}
	klog.V(5).Infof("GCEAlphaFirewalls.Delete(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEAlphaFirewalls.Delete(%v, %v): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Alpha.Firewalls.Delete(projectID, key.Name)

	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCEAlphaFirewalls.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEAlphaFirewalls.Delete(%v, %v) = %v", ctx, key, err)
	return err
}

// Update is a method on GCEAlphaFirewalls.
func (g *GCEAlphaFirewalls) Update(ctx context.Context, key *meta.Key, arg0 *alpha.Firewall) error {
	klog.V(5).Infof("GCEAlphaFirewalls.Update(%v, %v, ...): called", ctx, key)

	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaFirewalls.Update(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "alpha", "Firewalls")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Update",
		Version:   meta.Version("alpha"),
		Service:   "Firewalls",
	}
	klog.V(5).Infof("GCEAlphaFirewalls.Update(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)

	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEAlphaFirewalls.Update(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Alpha.Firewalls.Update(projectID, key.Name, arg0)
	call.Context(ctx)
	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCEAlphaFirewalls.Update(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}
	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEAlphaFirewalls.Update(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// BetaFirewalls is an interface that allows for mocking of Firewalls.
type BetaFirewalls interface {
	Get(ctx context.Context, key *meta.Key) (*beta.Firewall, error)
	List(ctx context.Context, fl *filter.F) ([]*beta.Firewall, error)
	Insert(ctx context.Context, key *meta.Key, obj *beta.Firewall) error
	Delete(ctx context.Context, key *meta.Key) error
	Update(context.Context, *meta.Key, *beta.Firewall) error
}

// NewMockBetaFirewalls returns a new mock for Firewalls.
func NewMockBetaFirewalls(pr ProjectRouter, objs map[meta.Key]*MockFirewallsObj) *MockBetaFirewalls {
	mock := &MockBetaFirewalls{
		ProjectRouter: pr,

		Objects:     objs,
		GetError:    map[meta.Key]error{},
		InsertError: map[meta.Key]error{},
		DeleteError: map[meta.Key]error{},
	}
	return mock
}

// MockBetaFirewalls is the mock for Firewalls.
type MockBetaFirewalls struct {
	Lock sync.Mutex

	ProjectRouter ProjectRouter

	// Objects maintained by the mock.
	Objects map[meta.Key]*MockFirewallsObj

	// If an entry exists for the given key and operation, then the error
	// will be returned instead of the operation.
	GetError    map[meta.Key]error
	ListError   *error
	InsertError map[meta.Key]error
	DeleteError map[meta.Key]error

	// xxxHook allow you to intercept the standard processing of the mock in
	// order to add your own logic. Return (true, _, _) to prevent the normal
	// execution flow of the mock. Return (false, nil, nil) to continue with
	// normal mock behavior/ after the hook function executes.
	GetHook    func(ctx context.Context, key *meta.Key, m *MockBetaFirewalls) (bool, *beta.Firewall, error)
	ListHook   func(ctx context.Context, fl *filter.F, m *MockBetaFirewalls) (bool, []*beta.Firewall, error)
	InsertHook func(ctx context.Context, key *meta.Key, obj *beta.Firewall, m *MockBetaFirewalls) (bool, error)
	DeleteHook func(ctx context.Context, key *meta.Key, m *MockBetaFirewalls) (bool, error)
	UpdateHook func(context.Context, *meta.Key, *beta.Firewall, *MockBetaFirewalls) error

	// X is extra state that can be used as part of the mock. Generated code
	// will not use this field.
	X interface{}
}

// Get returns the object from the mock.
func (m *MockBetaFirewalls) Get(ctx context.Context, key *meta.Key) (*beta.Firewall, error) {
	if m.GetHook != nil {
		if intercept, obj, err := m.GetHook(ctx, key, m); intercept {
			klog.V(5).Infof("MockBetaFirewalls.Get(%v, %s) = %+v, %v", ctx, key, obj, err)
			return obj, err
		}
	}
	if !key.Valid() {
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.GetError[*key]; ok {
		klog.V(5).Infof("MockBetaFirewalls.Get(%v, %s) = nil, %v", ctx, key, err)
		return nil, err
	}
	if obj, ok := m.Objects[*key]; ok {
		typedObj := obj.ToBeta()
		klog.V(5).Infof("MockBetaFirewalls.Get(%v, %s) = %+v, nil", ctx, key, typedObj)
		return typedObj, nil
	}

	err := &googleapi.Error{
		Code:    http.StatusNotFound,
		Message: fmt.Sprintf("MockBetaFirewalls %v not found", key),
	}
	klog.V(5).Infof("MockBetaFirewalls.Get(%v, %s) = nil, %v", ctx, key, err)
	return nil, err
}

// List all of the objects in the mock.
func (m *MockBetaFirewalls) List(ctx context.Context, fl *filter.F) ([]*beta.Firewall, error) {
	if m.ListHook != nil {
		if intercept, objs, err := m.ListHook(ctx, fl, m); intercept {
			klog.V(5).Infof("MockBetaFirewalls.List(%v, %v) = [%v items], %v", ctx, fl, len(objs), err)
			return objs, err
		}
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if m.ListError != nil {
		err := *m.ListError
		klog.V(5).Infof("MockBetaFirewalls.List(%v, %v) = nil, %v", ctx, fl, err)

		return nil, *m.ListError
	}

	var objs []*beta.Firewall
	for _, obj := range m.Objects {
		if !fl.Match(obj.ToBeta()) {
			continue
		}
		objs = append(objs, obj.ToBeta())
	}

	klog.V(5).Infof("MockBetaFirewalls.List(%v, %v) = [%v items], nil", ctx, fl, len(objs))
	return objs, nil
}

// Insert is a mock for inserting/creating a new object.
func (m *MockBetaFirewalls) Insert(ctx context.Context, key *meta.Key, obj *beta.Firewall) error {
	if m.InsertHook != nil {
		if intercept, err := m.InsertHook(ctx, key, obj, m); intercept {
			klog.V(5).Infof("MockBetaFirewalls.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.InsertError[*key]; ok {
		klog.V(5).Infof("MockBetaFirewalls.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}
	if _, ok := m.Objects[*key]; ok {
		err := &googleapi.Error{
			Code:    http.StatusConflict,
			Message: fmt.Sprintf("MockBetaFirewalls %v exists", key),
		}
		klog.V(5).Infof("MockBetaFirewalls.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}

	obj.Name = key.Name
	projectID := m.ProjectRouter.ProjectID(ctx, "beta", "firewalls")
	obj.SelfLink = SelfLink(meta.VersionBeta, projectID, "firewalls", key)

	m.Objects[*key] = &MockFirewallsObj{obj}
	klog.V(5).Infof("MockBetaFirewalls.Insert(%v, %v, %+v) = nil", ctx, key, obj)
	return nil
}

// Delete is a mock for deleting the object.
func (m *MockBetaFirewalls) Delete(ctx context.Context, key *meta.Key) error {
	if m.DeleteHook != nil {
		if intercept, err := m.DeleteHook(ctx, key, m); intercept {
			klog.V(5).Infof("MockBetaFirewalls.Delete(%v, %v) = %v", ctx, key, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.DeleteError[*key]; ok {
		klog.V(5).Infof("MockBetaFirewalls.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}
	if _, ok := m.Objects[*key]; !ok {
		err := &googleapi.Error{
			Code:    http.StatusNotFound,
			Message: fmt.Sprintf("MockBetaFirewalls %v not found", key),
		}
		klog.V(5).Infof("MockBetaFirewalls.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	delete(m.Objects, *key)
	klog.V(5).Infof("MockBetaFirewalls.Delete(%v, %v) = nil", ctx, key)
	return nil
}

// Obj wraps the object for use in the mock.
func (m *MockBetaFirewalls) Obj(o *beta.Firewall) *MockFirewallsObj {
	return &MockFirewallsObj{o}
}

// Update is a mock for the corresponding method.
func (m *MockBetaFirewalls) Update(ctx context.Context, key *meta.Key, arg0 *beta.Firewall) error {
	if m.UpdateHook != nil {
		return m.UpdateHook(ctx, key, arg0, m)
	}
	return nil
}

// GCEBetaFirewalls is a simplifying adapter for the GCE Firewalls.
type GCEBetaFirewalls struct {
	s *Service
}

// Get the Firewall named by key.
func (g *GCEBetaFirewalls) Get(ctx context.Context, key *meta.Key) (*beta.Firewall, error) {
	klog.V(5).Infof("GCEBetaFirewalls.Get(%v, %v): called", ctx, key)

	if !key.Valid() {
		klog.V(2).Infof("GCEBetaFirewalls.Get(%v, %v): key is invalid (%#v)", ctx, key, key)
		return nil, fmt.Errorf("invalid GCE key (%#v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "beta", "Firewalls")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Get",
		Version:   meta.Version("beta"),
		Service:   "Firewalls",
	}
	klog.V(5).Infof("GCEBetaFirewalls.Get(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEBetaFirewalls.Get(%v, %v): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.Beta.Firewalls.Get(projectID, key.Name)
	call.Context(ctx)
	v, err := call.Do()
	klog.V(4).Infof("GCEBetaFirewalls.Get(%v, %v) = %+v, %v", ctx, key, v, err)
	return v, err
}

// List all Firewall objects.
func (g *GCEBetaFirewalls) List(ctx context.Context, fl *filter.F) ([]*beta.Firewall, error) {
	klog.V(5).Infof("GCEBetaFirewalls.List(%v, %v) called", ctx, fl)
	projectID := g.s.ProjectRouter.ProjectID(ctx, "beta", "Firewalls")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "List",
		Version:   meta.Version("beta"),
		Service:   "Firewalls",
	}
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		return nil, err
	}
	klog.V(5).Infof("GCEBetaFirewalls.List(%v, %v): projectID = %v, rk = %+v", ctx, fl, projectID, rk)
	call := g.s.Beta.Firewalls.List(projectID)
	if fl != filter.None {
		call.Filter(fl.String())
	}
	var all []*beta.Firewall
	f := func(l *beta.FirewallList) error {
		klog.V(5).Infof("GCEBetaFirewalls.List(%v, ..., %v): page %+v", ctx, fl, l)
		all = append(all, l.Items...)
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		klog.V(4).Infof("GCEBetaFirewalls.List(%v, ..., %v) = %v, %v", ctx, fl, nil, err)
		return nil, err
	}

	if klog.V(4).Enabled() {
		klog.V(4).Infof("GCEBetaFirewalls.List(%v, ..., %v) = [%v items], %v", ctx, fl, len(all), nil)
	} else if klog.V(5).Enabled() {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		klog.V(5).Infof("GCEBetaFirewalls.List(%v, ..., %v) = %v, %v", ctx, fl, asStr, nil)
	}

	return all, nil
}

// Insert Firewall with key of value obj.
func (g *GCEBetaFirewalls) Insert(ctx context.Context, key *meta.Key, obj *beta.Firewall) error {
	klog.V(5).Infof("GCEBetaFirewalls.Insert(%v, %v, %+v): called", ctx, key, obj)
	if !key.Valid() {
		klog.V(2).Infof("GCEBetaFirewalls.Insert(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "beta", "Firewalls")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Insert",
		Version:   meta.Version("beta"),
		Service:   "Firewalls",
	}
	klog.V(5).Infof("GCEBetaFirewalls.Insert(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEBetaFirewalls.Insert(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	obj.Name = key.Name
	call := g.s.Beta.Firewalls.Insert(projectID, obj)
	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCEBetaFirewalls.Insert(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEBetaFirewalls.Insert(%v, %v, %+v) = %+v", ctx, key, obj, err)
	return err
}

// Delete the Firewall referenced by key.
func (g *GCEBetaFirewalls) Delete(ctx context.Context, key *meta.Key) error {
	klog.V(5).Infof("GCEBetaFirewalls.Delete(%v, %v): called", ctx, key)
	if !key.Valid() {
		klog.V(2).Infof("GCEBetaFirewalls.Delete(%v, %v): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "beta", "Firewalls")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Delete",
		Version:   meta.Version("beta"),
		Service:   "Firewalls",
	}
	klog.V(5).Infof("GCEBetaFirewalls.Delete(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEBetaFirewalls.Delete(%v, %v): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Beta.Firewalls.Delete(projectID, key.Name)

	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCEBetaFirewalls.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEBetaFirewalls.Delete(%v, %v) = %v", ctx, key, err)
	return err
}

// Update is a method on GCEBetaFirewalls.
func (g *GCEBetaFirewalls) Update(ctx context.Context, key *meta.Key, arg0 *beta.Firewall) error {
	klog.V(5).Infof("GCEBetaFirewalls.Update(%v, %v, ...): called", ctx, key)

	if !key.Valid() {
		klog.V(2).Infof("GCEBetaFirewalls.Update(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "beta", "Firewalls")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Update",
		Version:   meta.Version("beta"),
		Service:   "Firewalls",
	}
	klog.V(5).Infof("GCEBetaFirewalls.Update(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)

	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEBetaFirewalls.Update(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Beta.Firewalls.Update(projectID, key.Name, arg0)
	call.Context(ctx)
	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCEBetaFirewalls.Update(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}
	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEBetaFirewalls.Update(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// Firewalls is an interface that allows for mocking of Firewalls.
type Firewalls interface {
	Get(ctx context.Context, key *meta.Key) (*ga.Firewall, error)
	List(ctx context.Context, fl *filter.F) ([]*ga.Firewall, error)
	Insert(ctx context.Context, key *meta.Key, obj *ga.Firewall) error
	Delete(ctx context.Context, key *meta.Key) error
	Update(context.Context, *meta.Key, *ga.Firewall) error
}

// NewMockFirewalls returns a new mock for Firewalls.
func NewMockFirewalls(pr ProjectRouter, objs map[meta.Key]*MockFirewallsObj) *MockFirewalls {
	mock := &MockFirewalls{
		ProjectRouter: pr,

		Objects:     objs,
		GetError:    map[meta.Key]error{},
		InsertError: map[meta.Key]error{},
		DeleteError: map[meta.Key]error{},
	}
	return mock
}

// MockFirewalls is the mock for Firewalls.
type MockFirewalls struct {
	Lock sync.Mutex

	ProjectRouter ProjectRouter

	// Objects maintained by the mock.
	Objects map[meta.Key]*MockFirewallsObj

	// If an entry exists for the given key and operation, then the error
	// will be returned instead of the operation.
	GetError    map[meta.Key]error
	ListError   *error
	InsertError map[meta.Key]error
	DeleteError map[meta.Key]error

	// xxxHook allow you to intercept the standard processing of the mock in
	// order to add your own logic. Return (true, _, _) to prevent the normal
	// execution flow of the mock. Return (false, nil, nil) to continue with
	// normal mock behavior/ after the hook function executes.
	GetHook    func(ctx context.Context, key *meta.Key, m *MockFirewalls) (bool, *ga.Firewall, error)
	ListHook   func(ctx context.Context, fl *filter.F, m *MockFirewalls) (bool, []*ga.Firewall, error)
	InsertHook func(ctx context.Context, key *meta.Key, obj *ga.Firewall, m *MockFirewalls) (bool, error)
	DeleteHook func(ctx context.Context, key *meta.Key, m *MockFirewalls) (bool, error)
	UpdateHook func(context.Context, *meta.Key, *ga.Firewall, *MockFirewalls) error

	// X is extra state that can be used as part of the mock. Generated code
	// will not use this field.
	X interface{}
}

// Get returns the object from the mock.
func (m *MockFirewalls) Get(ctx context.Context, key *meta.Key) (*ga.Firewall, error) {
	if m.GetHook != nil {
		if intercept, obj, err := m.GetHook(ctx, key, m); intercept {
			klog.V(5).Infof("MockFirewalls.Get(%v, %s) = %+v, %v", ctx, key, obj, err)
			return obj, err
		}
	}
	if !key.Valid() {
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.GetError[*key]; ok {
		klog.V(5).Infof("MockFirewalls.Get(%v, %s) = nil, %v", ctx, key, err)
		return nil, err
	}
	if obj, ok := m.Objects[*key]; ok {
		typedObj := obj.ToGA()
		klog.V(5).Infof("MockFirewalls.Get(%v, %s) = %+v, nil", ctx, key, typedObj)
		return typedObj, nil
	}

	err := &googleapi.Error{
		Code:    http.StatusNotFound,
		Message: fmt.Sprintf("MockFirewalls %v not found", key),
	}
	klog.V(5).Infof("MockFirewalls.Get(%v, %s) = nil, %v", ctx, key, err)
	return nil, err
}

// List all of the objects in the mock.
func (m *MockFirewalls) List(ctx context.Context, fl *filter.F) ([]*ga.Firewall, error) {
	if m.ListHook != nil {
		if intercept, objs, err := m.ListHook(ctx, fl, m); intercept {
			klog.V(5).Infof("MockFirewalls.List(%v, %v) = [%v items], %v", ctx, fl, len(objs), err)
			return objs, err
		}
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if m.ListError != nil {
		err := *m.ListError
		klog.V(5).Infof("MockFirewalls.List(%v, %v) = nil, %v", ctx, fl, err)

		return nil, *m.ListError
	}

	var objs []*ga.Firewall
	for _, obj := range m.Objects {
		if !fl.Match(obj.ToGA()) {
			continue
		}
		objs = append(objs, obj.ToGA())
	}

	klog.V(5).Infof("MockFirewalls.List(%v, %v) = [%v items], nil", ctx, fl, len(objs))
	return objs, nil
}

// Insert is a mock for inserting/creating a new object.
func (m *MockFirewalls) Insert(ctx context.Context, key *meta.Key, obj *ga.Firewall) error {
	if m.InsertHook != nil {
		if intercept, err := m.InsertHook(ctx, key, obj, m); intercept {
			klog.V(5).Infof("MockFirewalls.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.InsertError[*key]; ok {
		klog.V(5).Infof("MockFirewalls.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}
	if _, ok := m.Objects[*key]; ok {
		err := &googleapi.Error{
			Code:    http.StatusConflict,
			Message: fmt.Sprintf("MockFirewalls %v exists", key),
		}
		klog.V(5).Infof("MockFirewalls.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}

	obj.Name = key.Name
	projectID := m.ProjectRouter.ProjectID(ctx, "ga", "firewalls")
	obj.SelfLink = SelfLink(meta.VersionGA, projectID, "firewalls", key)

	m.Objects[*key] = &MockFirewallsObj{obj}
	klog.V(5).Infof("MockFirewalls.Insert(%v, %v, %+v) = nil", ctx, key, obj)
	return nil
}

// Delete is a mock for deleting the object.
func (m *MockFirewalls) Delete(ctx context.Context, key *meta.Key) error {
	if m.DeleteHook != nil {
		if intercept, err := m.DeleteHook(ctx, key, m); intercept {
			klog.V(5).Infof("MockFirewalls.Delete(%v, %v) = %v", ctx, key, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.DeleteError[*key]; ok {
		klog.V(5).Infof("MockFirewalls.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}
	if _, ok := m.Objects[*key]; !ok {
		err := &googleapi.Error{
			Code:    http.StatusNotFound,
			Message: fmt.Sprintf("MockFirewalls %v not found", key),
		}
		klog.V(5).Infof("MockFirewalls.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	delete(m.Objects, *key)
	klog.V(5).Infof("MockFirewalls.Delete(%v, %v) = nil", ctx, key)
	return nil
}

// Obj wraps the object for use in the mock.
func (m *MockFirewalls) Obj(o *ga.Firewall) *MockFirewallsObj {
	return &MockFirewallsObj{o}
}

// Update is a mock for the corresponding method.
func (m *MockFirewalls) Update(ctx context.Context, key *meta.Key, arg0 *ga.Firewall) error {
	if m.UpdateHook != nil {
		return m.UpdateHook(ctx, key, arg0, m)
	}
	return nil
}

// GCEFirewalls is a simplifying adapter for the GCE Firewalls.
type GCEFirewalls struct {
	s *Service
}

// Get the Firewall named by key.
func (g *GCEFirewalls) Get(ctx context.Context, key *meta.Key) (*ga.Firewall, error) {
	klog.V(5).Infof("GCEFirewalls.Get(%v, %v): called", ctx, key)

	if !key.Valid() {
		klog.V(2).Infof("GCEFirewalls.Get(%v, %v): key is invalid (%#v)", ctx, key, key)
		return nil, fmt.Errorf("invalid GCE key (%#v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "Firewalls")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Get",
		Version:   meta.Version("ga"),
		Service:   "Firewalls",
	}
	klog.V(5).Infof("GCEFirewalls.Get(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEFirewalls.Get(%v, %v): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.GA.Firewalls.Get(projectID, key.Name)
	call.Context(ctx)
	v, err := call.Do()
	klog.V(4).Infof("GCEFirewalls.Get(%v, %v) = %+v, %v", ctx, key, v, err)
	return v, err
}

// List all Firewall objects.
func (g *GCEFirewalls) List(ctx context.Context, fl *filter.F) ([]*ga.Firewall, error) {
	klog.V(5).Infof("GCEFirewalls.List(%v, %v) called", ctx, fl)
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "Firewalls")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "List",
		Version:   meta.Version("ga"),
		Service:   "Firewalls",
	}
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		return nil, err
	}
	klog.V(5).Infof("GCEFirewalls.List(%v, %v): projectID = %v, rk = %+v", ctx, fl, projectID, rk)
	call := g.s.GA.Firewalls.List(projectID)
	if fl != filter.None {
		call.Filter(fl.String())
	}
	var all []*ga.Firewall
	f := func(l *ga.FirewallList) error {
		klog.V(5).Infof("GCEFirewalls.List(%v, ..., %v): page %+v", ctx, fl, l)
		all = append(all, l.Items...)
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		klog.V(4).Infof("GCEFirewalls.List(%v, ..., %v) = %v, %v", ctx, fl, nil, err)
		return nil, err
	}

	if klog.V(4).Enabled() {
		klog.V(4).Infof("GCEFirewalls.List(%v, ..., %v) = [%v items], %v", ctx, fl, len(all), nil)
	} else if klog.V(5).Enabled() {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		klog.V(5).Infof("GCEFirewalls.List(%v, ..., %v) = %v, %v", ctx, fl, asStr, nil)
	}

	return all, nil
}

// Insert Firewall with key of value obj.
func (g *GCEFirewalls) Insert(ctx context.Context, key *meta.Key, obj *ga.Firewall) error {
	klog.V(5).Infof("GCEFirewalls.Insert(%v, %v, %+v): called", ctx, key, obj)
	if !key.Valid() {
		klog.V(2).Infof("GCEFirewalls.Insert(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "Firewalls")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Insert",
		Version:   meta.Version("ga"),
		Service:   "Firewalls",
	}
	klog.V(5).Infof("GCEFirewalls.Insert(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEFirewalls.Insert(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	obj.Name = key.Name
	call := g.s.GA.Firewalls.Insert(projectID, obj)
	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCEFirewalls.Insert(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEFirewalls.Insert(%v, %v, %+v) = %+v", ctx, key, obj, err)
	return err
}

// Delete the Firewall referenced by key.
func (g *GCEFirewalls) Delete(ctx context.Context, key *meta.Key) error {
	klog.V(5).Infof("GCEFirewalls.Delete(%v, %v): called", ctx, key)
	if !key.Valid() {
		klog.V(2).Infof("GCEFirewalls.Delete(%v, %v): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "Firewalls")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Delete",
		Version:   meta.Version("ga"),
		Service:   "Firewalls",
	}
	klog.V(5).Infof("GCEFirewalls.Delete(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEFirewalls.Delete(%v, %v): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.GA.Firewalls.Delete(projectID, key.Name)

	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCEFirewalls.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEFirewalls.Delete(%v, %v) = %v", ctx, key, err)
	return err
}

// Update is a method on GCEFirewalls.
func (g *GCEFirewalls) Update(ctx context.Context, key *meta.Key, arg0 *ga.Firewall) error {
	klog.V(5).Infof("GCEFirewalls.Update(%v, %v, ...): called", ctx, key)

	if !key.Valid() {
		klog.V(2).Infof("GCEFirewalls.Update(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "Firewalls")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Update",
		Version:   meta.Version("ga"),
		Service:   "Firewalls",
	}
	klog.V(5).Infof("GCEFirewalls.Update(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)

	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEFirewalls.Update(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.GA.Firewalls.Update(projectID, key.Name, arg0)
	call.Context(ctx)
	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCEFirewalls.Update(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}
	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEFirewalls.Update(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// ForwardingRules is an interface that allows for mocking of ForwardingRules.
type ForwardingRules interface {
	Get(ctx context.Context, key *meta.Key) (*ga.ForwardingRule, error)
	List(ctx context.Context, region string, fl *filter.F) ([]*ga.ForwardingRule, error)
	Insert(ctx context.Context, key *meta.Key, obj *ga.ForwardingRule) error
	Delete(ctx context.Context, key *meta.Key) error
	SetTarget(context.Context, *meta.Key, *ga.TargetReference) error
}

// NewMockForwardingRules returns a new mock for ForwardingRules.
func NewMockForwardingRules(pr ProjectRouter, objs map[meta.Key]*MockForwardingRulesObj) *MockForwardingRules {
	mock := &MockForwardingRules{
		ProjectRouter: pr,

		Objects:     objs,
		GetError:    map[meta.Key]error{},
		InsertError: map[meta.Key]error{},
		DeleteError: map[meta.Key]error{},
	}
	return mock
}

// MockForwardingRules is the mock for ForwardingRules.
type MockForwardingRules struct {
	Lock sync.Mutex

	ProjectRouter ProjectRouter

	// Objects maintained by the mock.
	Objects map[meta.Key]*MockForwardingRulesObj

	// If an entry exists for the given key and operation, then the error
	// will be returned instead of the operation.
	GetError    map[meta.Key]error
	ListError   *error
	InsertError map[meta.Key]error
	DeleteError map[meta.Key]error

	// xxxHook allow you to intercept the standard processing of the mock in
	// order to add your own logic. Return (true, _, _) to prevent the normal
	// execution flow of the mock. Return (false, nil, nil) to continue with
	// normal mock behavior/ after the hook function executes.
	GetHook       func(ctx context.Context, key *meta.Key, m *MockForwardingRules) (bool, *ga.ForwardingRule, error)
	ListHook      func(ctx context.Context, region string, fl *filter.F, m *MockForwardingRules) (bool, []*ga.ForwardingRule, error)
	InsertHook    func(ctx context.Context, key *meta.Key, obj *ga.ForwardingRule, m *MockForwardingRules) (bool, error)
	DeleteHook    func(ctx context.Context, key *meta.Key, m *MockForwardingRules) (bool, error)
	SetTargetHook func(context.Context, *meta.Key, *ga.TargetReference, *MockForwardingRules) error

	// X is extra state that can be used as part of the mock. Generated code
	// will not use this field.
	X interface{}
}

// Get returns the object from the mock.
func (m *MockForwardingRules) Get(ctx context.Context, key *meta.Key) (*ga.ForwardingRule, error) {
	if m.GetHook != nil {
		if intercept, obj, err := m.GetHook(ctx, key, m); intercept {
			klog.V(5).Infof("MockForwardingRules.Get(%v, %s) = %+v, %v", ctx, key, obj, err)
			return obj, err
		}
	}
	if !key.Valid() {
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.GetError[*key]; ok {
		klog.V(5).Infof("MockForwardingRules.Get(%v, %s) = nil, %v", ctx, key, err)
		return nil, err
	}
	if obj, ok := m.Objects[*key]; ok {
		typedObj := obj.ToGA()
		klog.V(5).Infof("MockForwardingRules.Get(%v, %s) = %+v, nil", ctx, key, typedObj)
		return typedObj, nil
	}

	err := &googleapi.Error{
		Code:    http.StatusNotFound,
		Message: fmt.Sprintf("MockForwardingRules %v not found", key),
	}
	klog.V(5).Infof("MockForwardingRules.Get(%v, %s) = nil, %v", ctx, key, err)
	return nil, err
}

// List all of the objects in the mock in the given region.
func (m *MockForwardingRules) List(ctx context.Context, region string, fl *filter.F) ([]*ga.ForwardingRule, error) {
	if m.ListHook != nil {
		if intercept, objs, err := m.ListHook(ctx, region, fl, m); intercept {
			klog.V(5).Infof("MockForwardingRules.List(%v, %q, %v) = [%v items], %v", ctx, region, fl, len(objs), err)
			return objs, err
		}
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if m.ListError != nil {
		err := *m.ListError
		klog.V(5).Infof("MockForwardingRules.List(%v, %q, %v) = nil, %v", ctx, region, fl, err)

		return nil, *m.ListError
	}

	var objs []*ga.ForwardingRule
	for key, obj := range m.Objects {
		if key.Region != region {
			continue
		}
		if !fl.Match(obj.ToGA()) {
			continue
		}
		objs = append(objs, obj.ToGA())
	}

	klog.V(5).Infof("MockForwardingRules.List(%v, %q, %v) = [%v items], nil", ctx, region, fl, len(objs))
	return objs, nil
}

// Insert is a mock for inserting/creating a new object.
func (m *MockForwardingRules) Insert(ctx context.Context, key *meta.Key, obj *ga.ForwardingRule) error {
	if m.InsertHook != nil {
		if intercept, err := m.InsertHook(ctx, key, obj, m); intercept {
			klog.V(5).Infof("MockForwardingRules.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.InsertError[*key]; ok {
		klog.V(5).Infof("MockForwardingRules.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}
	if _, ok := m.Objects[*key]; ok {
		err := &googleapi.Error{
			Code:    http.StatusConflict,
			Message: fmt.Sprintf("MockForwardingRules %v exists", key),
		}
		klog.V(5).Infof("MockForwardingRules.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}

	obj.Name = key.Name
	projectID := m.ProjectRouter.ProjectID(ctx, "ga", "forwardingRules")
	obj.SelfLink = SelfLink(meta.VersionGA, projectID, "forwardingRules", key)

	m.Objects[*key] = &MockForwardingRulesObj{obj}
	klog.V(5).Infof("MockForwardingRules.Insert(%v, %v, %+v) = nil", ctx, key, obj)
	return nil
}

// Delete is a mock for deleting the object.
func (m *MockForwardingRules) Delete(ctx context.Context, key *meta.Key) error {
	if m.DeleteHook != nil {
		if intercept, err := m.DeleteHook(ctx, key, m); intercept {
			klog.V(5).Infof("MockForwardingRules.Delete(%v, %v) = %v", ctx, key, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.DeleteError[*key]; ok {
		klog.V(5).Infof("MockForwardingRules.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}
	if _, ok := m.Objects[*key]; !ok {
		err := &googleapi.Error{
			Code:    http.StatusNotFound,
			Message: fmt.Sprintf("MockForwardingRules %v not found", key),
		}
		klog.V(5).Infof("MockForwardingRules.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	delete(m.Objects, *key)
	klog.V(5).Infof("MockForwardingRules.Delete(%v, %v) = nil", ctx, key)
	return nil
}

// Obj wraps the object for use in the mock.
func (m *MockForwardingRules) Obj(o *ga.ForwardingRule) *MockForwardingRulesObj {
	return &MockForwardingRulesObj{o}
}

// SetTarget is a mock for the corresponding method.
func (m *MockForwardingRules) SetTarget(ctx context.Context, key *meta.Key, arg0 *ga.TargetReference) error {
	if m.SetTargetHook != nil {
		return m.SetTargetHook(ctx, key, arg0, m)
	}
	return nil
}

// GCEForwardingRules is a simplifying adapter for the GCE ForwardingRules.
type GCEForwardingRules struct {
	s *Service
}

// Get the ForwardingRule named by key.
func (g *GCEForwardingRules) Get(ctx context.Context, key *meta.Key) (*ga.ForwardingRule, error) {
	klog.V(5).Infof("GCEForwardingRules.Get(%v, %v): called", ctx, key)

	if !key.Valid() {
		klog.V(2).Infof("GCEForwardingRules.Get(%v, %v): key is invalid (%#v)", ctx, key, key)
		return nil, fmt.Errorf("invalid GCE key (%#v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "ForwardingRules")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Get",
		Version:   meta.Version("ga"),
		Service:   "ForwardingRules",
	}
	klog.V(5).Infof("GCEForwardingRules.Get(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEForwardingRules.Get(%v, %v): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.GA.ForwardingRules.Get(projectID, key.Region, key.Name)
	call.Context(ctx)
	v, err := call.Do()
	klog.V(4).Infof("GCEForwardingRules.Get(%v, %v) = %+v, %v", ctx, key, v, err)
	return v, err
}

// List all ForwardingRule objects.
func (g *GCEForwardingRules) List(ctx context.Context, region string, fl *filter.F) ([]*ga.ForwardingRule, error) {
	klog.V(5).Infof("GCEForwardingRules.List(%v, %v, %v) called", ctx, region, fl)
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "ForwardingRules")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "List",
		Version:   meta.Version("ga"),
		Service:   "ForwardingRules",
	}
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		return nil, err
	}
	klog.V(5).Infof("GCEForwardingRules.List(%v, %v, %v): projectID = %v, rk = %+v", ctx, region, fl, projectID, rk)
	call := g.s.GA.ForwardingRules.List(projectID, region)
	if fl != filter.None {
		call.Filter(fl.String())
	}
	var all []*ga.ForwardingRule
	f := func(l *ga.ForwardingRuleList) error {
		klog.V(5).Infof("GCEForwardingRules.List(%v, ..., %v): page %+v", ctx, fl, l)
		all = append(all, l.Items...)
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		klog.V(4).Infof("GCEForwardingRules.List(%v, ..., %v) = %v, %v", ctx, fl, nil, err)
		return nil, err
	}

	if klog.V(4).Enabled() {
		klog.V(4).Infof("GCEForwardingRules.List(%v, ..., %v) = [%v items], %v", ctx, fl, len(all), nil)
	} else if klog.V(5).Enabled() {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		klog.V(5).Infof("GCEForwardingRules.List(%v, ..., %v) = %v, %v", ctx, fl, asStr, nil)
	}

	return all, nil
}

// Insert ForwardingRule with key of value obj.
func (g *GCEForwardingRules) Insert(ctx context.Context, key *meta.Key, obj *ga.ForwardingRule) error {
	klog.V(5).Infof("GCEForwardingRules.Insert(%v, %v, %+v): called", ctx, key, obj)
	if !key.Valid() {
		klog.V(2).Infof("GCEForwardingRules.Insert(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "ForwardingRules")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Insert",
		Version:   meta.Version("ga"),
		Service:   "ForwardingRules",
	}
	klog.V(5).Infof("GCEForwardingRules.Insert(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEForwardingRules.Insert(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	obj.Name = key.Name
	call := g.s.GA.ForwardingRules.Insert(projectID, key.Region, obj)
	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCEForwardingRules.Insert(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEForwardingRules.Insert(%v, %v, %+v) = %+v", ctx, key, obj, err)
	return err
}

// Delete the ForwardingRule referenced by key.
func (g *GCEForwardingRules) Delete(ctx context.Context, key *meta.Key) error {
	klog.V(5).Infof("GCEForwardingRules.Delete(%v, %v): called", ctx, key)
	if !key.Valid() {
		klog.V(2).Infof("GCEForwardingRules.Delete(%v, %v): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "ForwardingRules")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Delete",
		Version:   meta.Version("ga"),
		Service:   "ForwardingRules",
	}
	klog.V(5).Infof("GCEForwardingRules.Delete(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEForwardingRules.Delete(%v, %v): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.GA.ForwardingRules.Delete(projectID, key.Region, key.Name)
	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCEForwardingRules.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEForwardingRules.Delete(%v, %v) = %v", ctx, key, err)
	return err
}

// SetTarget is a method on GCEForwardingRules.
func (g *GCEForwardingRules) SetTarget(ctx context.Context, key *meta.Key, arg0 *ga.TargetReference) error {
	klog.V(5).Infof("GCEForwardingRules.SetTarget(%v, %v, ...): called", ctx, key)

	if !key.Valid() {
		klog.V(2).Infof("GCEForwardingRules.SetTarget(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "ForwardingRules")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "SetTarget",
		Version:   meta.Version("ga"),
		Service:   "ForwardingRules",
	}
	klog.V(5).Infof("GCEForwardingRules.SetTarget(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)

	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEForwardingRules.SetTarget(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.GA.ForwardingRules.SetTarget(projectID, key.Region, key.Name, arg0)
	call.Context(ctx)
	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCEForwardingRules.SetTarget(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}
	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEForwardingRules.SetTarget(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// AlphaForwardingRules is an interface that allows for mocking of ForwardingRules.
type AlphaForwardingRules interface {
	Get(ctx context.Context, key *meta.Key) (*alpha.ForwardingRule, error)
	List(ctx context.Context, region string, fl *filter.F) ([]*alpha.ForwardingRule, error)
	Insert(ctx context.Context, key *meta.Key, obj *alpha.ForwardingRule) error
	Delete(ctx context.Context, key *meta.Key) error
	SetTarget(context.Context, *meta.Key, *alpha.TargetReference) error
}

// NewMockAlphaForwardingRules returns a new mock for ForwardingRules.
func NewMockAlphaForwardingRules(pr ProjectRouter, objs map[meta.Key]*MockForwardingRulesObj) *MockAlphaForwardingRules {
	mock := &MockAlphaForwardingRules{
		ProjectRouter: pr,

		Objects:     objs,
		GetError:    map[meta.Key]error{},
		InsertError: map[meta.Key]error{},
		DeleteError: map[meta.Key]error{},
	}
	return mock
}

// MockAlphaForwardingRules is the mock for ForwardingRules.
type MockAlphaForwardingRules struct {
	Lock sync.Mutex

	ProjectRouter ProjectRouter

	// Objects maintained by the mock.
	Objects map[meta.Key]*MockForwardingRulesObj

	// If an entry exists for the given key and operation, then the error
	// will be returned instead of the operation.
	GetError    map[meta.Key]error
	ListError   *error
	InsertError map[meta.Key]error
	DeleteError map[meta.Key]error

	// xxxHook allow you to intercept the standard processing of the mock in
	// order to add your own logic. Return (true, _, _) to prevent the normal
	// execution flow of the mock. Return (false, nil, nil) to continue with
	// normal mock behavior/ after the hook function executes.
	GetHook       func(ctx context.Context, key *meta.Key, m *MockAlphaForwardingRules) (bool, *alpha.ForwardingRule, error)
	ListHook      func(ctx context.Context, region string, fl *filter.F, m *MockAlphaForwardingRules) (bool, []*alpha.ForwardingRule, error)
	InsertHook    func(ctx context.Context, key *meta.Key, obj *alpha.ForwardingRule, m *MockAlphaForwardingRules) (bool, error)
	DeleteHook    func(ctx context.Context, key *meta.Key, m *MockAlphaForwardingRules) (bool, error)
	SetTargetHook func(context.Context, *meta.Key, *alpha.TargetReference, *MockAlphaForwardingRules) error

	// X is extra state that can be used as part of the mock. Generated code
	// will not use this field.
	X interface{}
}

// Get returns the object from the mock.
func (m *MockAlphaForwardingRules) Get(ctx context.Context, key *meta.Key) (*alpha.ForwardingRule, error) {
	if m.GetHook != nil {
		if intercept, obj, err := m.GetHook(ctx, key, m); intercept {
			klog.V(5).Infof("MockAlphaForwardingRules.Get(%v, %s) = %+v, %v", ctx, key, obj, err)
			return obj, err
		}
	}
	if !key.Valid() {
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.GetError[*key]; ok {
		klog.V(5).Infof("MockAlphaForwardingRules.Get(%v, %s) = nil, %v", ctx, key, err)
		return nil, err
	}
	if obj, ok := m.Objects[*key]; ok {
		typedObj := obj.ToAlpha()
		klog.V(5).Infof("MockAlphaForwardingRules.Get(%v, %s) = %+v, nil", ctx, key, typedObj)
		return typedObj, nil
	}

	err := &googleapi.Error{
		Code:    http.StatusNotFound,
		Message: fmt.Sprintf("MockAlphaForwardingRules %v not found", key),
	}
	klog.V(5).Infof("MockAlphaForwardingRules.Get(%v, %s) = nil, %v", ctx, key, err)
	return nil, err
}

// List all of the objects in the mock in the given region.
func (m *MockAlphaForwardingRules) List(ctx context.Context, region string, fl *filter.F) ([]*alpha.ForwardingRule, error) {
	if m.ListHook != nil {
		if intercept, objs, err := m.ListHook(ctx, region, fl, m); intercept {
			klog.V(5).Infof("MockAlphaForwardingRules.List(%v, %q, %v) = [%v items], %v", ctx, region, fl, len(objs), err)
			return objs, err
		}
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if m.ListError != nil {
		err := *m.ListError
		klog.V(5).Infof("MockAlphaForwardingRules.List(%v, %q, %v) = nil, %v", ctx, region, fl, err)

		return nil, *m.ListError
	}

	var objs []*alpha.ForwardingRule
	for key, obj := range m.Objects {
		if key.Region != region {
			continue
		}
		if !fl.Match(obj.ToAlpha()) {
			continue
		}
		objs = append(objs, obj.ToAlpha())
	}

	klog.V(5).Infof("MockAlphaForwardingRules.List(%v, %q, %v) = [%v items], nil", ctx, region, fl, len(objs))
	return objs, nil
}

// Insert is a mock for inserting/creating a new object.
func (m *MockAlphaForwardingRules) Insert(ctx context.Context, key *meta.Key, obj *alpha.ForwardingRule) error {
	if m.InsertHook != nil {
		if intercept, err := m.InsertHook(ctx, key, obj, m); intercept {
			klog.V(5).Infof("MockAlphaForwardingRules.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.InsertError[*key]; ok {
		klog.V(5).Infof("MockAlphaForwardingRules.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}
	if _, ok := m.Objects[*key]; ok {
		err := &googleapi.Error{
			Code:    http.StatusConflict,
			Message: fmt.Sprintf("MockAlphaForwardingRules %v exists", key),
		}
		klog.V(5).Infof("MockAlphaForwardingRules.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}

	obj.Name = key.Name
	projectID := m.ProjectRouter.ProjectID(ctx, "alpha", "forwardingRules")
	obj.SelfLink = SelfLink(meta.VersionAlpha, projectID, "forwardingRules", key)

	m.Objects[*key] = &MockForwardingRulesObj{obj}
	klog.V(5).Infof("MockAlphaForwardingRules.Insert(%v, %v, %+v) = nil", ctx, key, obj)
	return nil
}

// Delete is a mock for deleting the object.
func (m *MockAlphaForwardingRules) Delete(ctx context.Context, key *meta.Key) error {
	if m.DeleteHook != nil {
		if intercept, err := m.DeleteHook(ctx, key, m); intercept {
			klog.V(5).Infof("MockAlphaForwardingRules.Delete(%v, %v) = %v", ctx, key, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.DeleteError[*key]; ok {
		klog.V(5).Infof("MockAlphaForwardingRules.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}
	if _, ok := m.Objects[*key]; !ok {
		err := &googleapi.Error{
			Code:    http.StatusNotFound,
			Message: fmt.Sprintf("MockAlphaForwardingRules %v not found", key),
		}
		klog.V(5).Infof("MockAlphaForwardingRules.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	delete(m.Objects, *key)
	klog.V(5).Infof("MockAlphaForwardingRules.Delete(%v, %v) = nil", ctx, key)
	return nil
}

// Obj wraps the object for use in the mock.
func (m *MockAlphaForwardingRules) Obj(o *alpha.ForwardingRule) *MockForwardingRulesObj {
	return &MockForwardingRulesObj{o}
}

// SetTarget is a mock for the corresponding method.
func (m *MockAlphaForwardingRules) SetTarget(ctx context.Context, key *meta.Key, arg0 *alpha.TargetReference) error {
	if m.SetTargetHook != nil {
		return m.SetTargetHook(ctx, key, arg0, m)
	}
	return nil
}

// GCEAlphaForwardingRules is a simplifying adapter for the GCE ForwardingRules.
type GCEAlphaForwardingRules struct {
	s *Service
}

// Get the ForwardingRule named by key.
func (g *GCEAlphaForwardingRules) Get(ctx context.Context, key *meta.Key) (*alpha.ForwardingRule, error) {
	klog.V(5).Infof("GCEAlphaForwardingRules.Get(%v, %v): called", ctx, key)

	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaForwardingRules.Get(%v, %v): key is invalid (%#v)", ctx, key, key)
		return nil, fmt.Errorf("invalid GCE key (%#v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "alpha", "ForwardingRules")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Get",
		Version:   meta.Version("alpha"),
		Service:   "ForwardingRules",
	}
	klog.V(5).Infof("GCEAlphaForwardingRules.Get(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEAlphaForwardingRules.Get(%v, %v): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.Alpha.ForwardingRules.Get(projectID, key.Region, key.Name)
	call.Context(ctx)
	v, err := call.Do()
	klog.V(4).Infof("GCEAlphaForwardingRules.Get(%v, %v) = %+v, %v", ctx, key, v, err)
	return v, err
}

// List all ForwardingRule objects.
func (g *GCEAlphaForwardingRules) List(ctx context.Context, region string, fl *filter.F) ([]*alpha.ForwardingRule, error) {
	klog.V(5).Infof("GCEAlphaForwardingRules.List(%v, %v, %v) called", ctx, region, fl)
	projectID := g.s.ProjectRouter.ProjectID(ctx, "alpha", "ForwardingRules")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "List",
		Version:   meta.Version("alpha"),
		Service:   "ForwardingRules",
	}
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		return nil, err
	}
	klog.V(5).Infof("GCEAlphaForwardingRules.List(%v, %v, %v): projectID = %v, rk = %+v", ctx, region, fl, projectID, rk)
	call := g.s.Alpha.ForwardingRules.List(projectID, region)
	if fl != filter.None {
		call.Filter(fl.String())
	}
	var all []*alpha.ForwardingRule
	f := func(l *alpha.ForwardingRuleList) error {
		klog.V(5).Infof("GCEAlphaForwardingRules.List(%v, ..., %v): page %+v", ctx, fl, l)
		all = append(all, l.Items...)
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		klog.V(4).Infof("GCEAlphaForwardingRules.List(%v, ..., %v) = %v, %v", ctx, fl, nil, err)
		return nil, err
	}

	if klog.V(4).Enabled() {
		klog.V(4).Infof("GCEAlphaForwardingRules.List(%v, ..., %v) = [%v items], %v", ctx, fl, len(all), nil)
	} else if klog.V(5).Enabled() {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		klog.V(5).Infof("GCEAlphaForwardingRules.List(%v, ..., %v) = %v, %v", ctx, fl, asStr, nil)
	}

	return all, nil
}

// Insert ForwardingRule with key of value obj.
func (g *GCEAlphaForwardingRules) Insert(ctx context.Context, key *meta.Key, obj *alpha.ForwardingRule) error {
	klog.V(5).Infof("GCEAlphaForwardingRules.Insert(%v, %v, %+v): called", ctx, key, obj)
	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaForwardingRules.Insert(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "alpha", "ForwardingRules")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Insert",
		Version:   meta.Version("alpha"),
		Service:   "ForwardingRules",
	}
	klog.V(5).Infof("GCEAlphaForwardingRules.Insert(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEAlphaForwardingRules.Insert(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	obj.Name = key.Name
	call := g.s.Alpha.ForwardingRules.Insert(projectID, key.Region, obj)
	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCEAlphaForwardingRules.Insert(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEAlphaForwardingRules.Insert(%v, %v, %+v) = %+v", ctx, key, obj, err)
	return err
}

// Delete the ForwardingRule referenced by key.
func (g *GCEAlphaForwardingRules) Delete(ctx context.Context, key *meta.Key) error {
	klog.V(5).Infof("GCEAlphaForwardingRules.Delete(%v, %v): called", ctx, key)
	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaForwardingRules.Delete(%v, %v): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "alpha", "ForwardingRules")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Delete",
		Version:   meta.Version("alpha"),
		Service:   "ForwardingRules",
	}
	klog.V(5).Infof("GCEAlphaForwardingRules.Delete(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEAlphaForwardingRules.Delete(%v, %v): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Alpha.ForwardingRules.Delete(projectID, key.Region, key.Name)
	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCEAlphaForwardingRules.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEAlphaForwardingRules.Delete(%v, %v) = %v", ctx, key, err)
	return err
}

// SetTarget is a method on GCEAlphaForwardingRules.
func (g *GCEAlphaForwardingRules) SetTarget(ctx context.Context, key *meta.Key, arg0 *alpha.TargetReference) error {
	klog.V(5).Infof("GCEAlphaForwardingRules.SetTarget(%v, %v, ...): called", ctx, key)

	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaForwardingRules.SetTarget(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "alpha", "ForwardingRules")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "SetTarget",
		Version:   meta.Version("alpha"),
		Service:   "ForwardingRules",
	}
	klog.V(5).Infof("GCEAlphaForwardingRules.SetTarget(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)

	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEAlphaForwardingRules.SetTarget(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Alpha.ForwardingRules.SetTarget(projectID, key.Region, key.Name, arg0)
	call.Context(ctx)
	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCEAlphaForwardingRules.SetTarget(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}
	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEAlphaForwardingRules.SetTarget(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// BetaForwardingRules is an interface that allows for mocking of ForwardingRules.
type BetaForwardingRules interface {
	Get(ctx context.Context, key *meta.Key) (*beta.ForwardingRule, error)
	List(ctx context.Context, region string, fl *filter.F) ([]*beta.ForwardingRule, error)
	Insert(ctx context.Context, key *meta.Key, obj *beta.ForwardingRule) error
	Delete(ctx context.Context, key *meta.Key) error
	SetTarget(context.Context, *meta.Key, *beta.TargetReference) error
}

// NewMockBetaForwardingRules returns a new mock for ForwardingRules.
func NewMockBetaForwardingRules(pr ProjectRouter, objs map[meta.Key]*MockForwardingRulesObj) *MockBetaForwardingRules {
	mock := &MockBetaForwardingRules{
		ProjectRouter: pr,

		Objects:     objs,
		GetError:    map[meta.Key]error{},
		InsertError: map[meta.Key]error{},
		DeleteError: map[meta.Key]error{},
	}
	return mock
}

// MockBetaForwardingRules is the mock for ForwardingRules.
type MockBetaForwardingRules struct {
	Lock sync.Mutex

	ProjectRouter ProjectRouter

	// Objects maintained by the mock.
	Objects map[meta.Key]*MockForwardingRulesObj

	// If an entry exists for the given key and operation, then the error
	// will be returned instead of the operation.
	GetError    map[meta.Key]error
	ListError   *error
	InsertError map[meta.Key]error
	DeleteError map[meta.Key]error

	// xxxHook allow you to intercept the standard processing of the mock in
	// order to add your own logic. Return (true, _, _) to prevent the normal
	// execution flow of the mock. Return (false, nil, nil) to continue with
	// normal mock behavior/ after the hook function executes.
	GetHook       func(ctx context.Context, key *meta.Key, m *MockBetaForwardingRules) (bool, *beta.ForwardingRule, error)
	ListHook      func(ctx context.Context, region string, fl *filter.F, m *MockBetaForwardingRules) (bool, []*beta.ForwardingRule, error)
	InsertHook    func(ctx context.Context, key *meta.Key, obj *beta.ForwardingRule, m *MockBetaForwardingRules) (bool, error)
	DeleteHook    func(ctx context.Context, key *meta.Key, m *MockBetaForwardingRules) (bool, error)
	SetTargetHook func(context.Context, *meta.Key, *beta.TargetReference, *MockBetaForwardingRules) error

	// X is extra state that can be used as part of the mock. Generated code
	// will not use this field.
	X interface{}
}

// Get returns the object from the mock.
func (m *MockBetaForwardingRules) Get(ctx context.Context, key *meta.Key) (*beta.ForwardingRule, error) {
	if m.GetHook != nil {
		if intercept, obj, err := m.GetHook(ctx, key, m); intercept {
			klog.V(5).Infof("MockBetaForwardingRules.Get(%v, %s) = %+v, %v", ctx, key, obj, err)
			return obj, err
		}
	}
	if !key.Valid() {
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.GetError[*key]; ok {
		klog.V(5).Infof("MockBetaForwardingRules.Get(%v, %s) = nil, %v", ctx, key, err)
		return nil, err
	}
	if obj, ok := m.Objects[*key]; ok {
		typedObj := obj.ToBeta()
		klog.V(5).Infof("MockBetaForwardingRules.Get(%v, %s) = %+v, nil", ctx, key, typedObj)
		return typedObj, nil
	}

	err := &googleapi.Error{
		Code:    http.StatusNotFound,
		Message: fmt.Sprintf("MockBetaForwardingRules %v not found", key),
	}
	klog.V(5).Infof("MockBetaForwardingRules.Get(%v, %s) = nil, %v", ctx, key, err)
	return nil, err
}

// List all of the objects in the mock in the given region.
func (m *MockBetaForwardingRules) List(ctx context.Context, region string, fl *filter.F) ([]*beta.ForwardingRule, error) {
	if m.ListHook != nil {
		if intercept, objs, err := m.ListHook(ctx, region, fl, m); intercept {
			klog.V(5).Infof("MockBetaForwardingRules.List(%v, %q, %v) = [%v items], %v", ctx, region, fl, len(objs), err)
			return objs, err
		}
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if m.ListError != nil {
		err := *m.ListError
		klog.V(5).Infof("MockBetaForwardingRules.List(%v, %q, %v) = nil, %v", ctx, region, fl, err)

		return nil, *m.ListError
	}

	var objs []*beta.ForwardingRule
	for key, obj := range m.Objects {
		if key.Region != region {
			continue
		}
		if !fl.Match(obj.ToBeta()) {
			continue
		}
		objs = append(objs, obj.ToBeta())
	}

	klog.V(5).Infof("MockBetaForwardingRules.List(%v, %q, %v) = [%v items], nil", ctx, region, fl, len(objs))
	return objs, nil
}

// Insert is a mock for inserting/creating a new object.
func (m *MockBetaForwardingRules) Insert(ctx context.Context, key *meta.Key, obj *beta.ForwardingRule) error {
	if m.InsertHook != nil {
		if intercept, err := m.InsertHook(ctx, key, obj, m); intercept {
			klog.V(5).Infof("MockBetaForwardingRules.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.InsertError[*key]; ok {
		klog.V(5).Infof("MockBetaForwardingRules.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}
	if _, ok := m.Objects[*key]; ok {
		err := &googleapi.Error{
			Code:    http.StatusConflict,
			Message: fmt.Sprintf("MockBetaForwardingRules %v exists", key),
		}
		klog.V(5).Infof("MockBetaForwardingRules.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}

	obj.Name = key.Name
	projectID := m.ProjectRouter.ProjectID(ctx, "beta", "forwardingRules")
	obj.SelfLink = SelfLink(meta.VersionBeta, projectID, "forwardingRules", key)

	m.Objects[*key] = &MockForwardingRulesObj{obj}
	klog.V(5).Infof("MockBetaForwardingRules.Insert(%v, %v, %+v) = nil", ctx, key, obj)
	return nil
}

// Delete is a mock for deleting the object.
func (m *MockBetaForwardingRules) Delete(ctx context.Context, key *meta.Key) error {
	if m.DeleteHook != nil {
		if intercept, err := m.DeleteHook(ctx, key, m); intercept {
			klog.V(5).Infof("MockBetaForwardingRules.Delete(%v, %v) = %v", ctx, key, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.DeleteError[*key]; ok {
		klog.V(5).Infof("MockBetaForwardingRules.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}
	if _, ok := m.Objects[*key]; !ok {
		err := &googleapi.Error{
			Code:    http.StatusNotFound,
			Message: fmt.Sprintf("MockBetaForwardingRules %v not found", key),
		}
		klog.V(5).Infof("MockBetaForwardingRules.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	delete(m.Objects, *key)
	klog.V(5).Infof("MockBetaForwardingRules.Delete(%v, %v) = nil", ctx, key)
	return nil
}

// Obj wraps the object for use in the mock.
func (m *MockBetaForwardingRules) Obj(o *beta.ForwardingRule) *MockForwardingRulesObj {
	return &MockForwardingRulesObj{o}
}

// SetTarget is a mock for the corresponding method.
func (m *MockBetaForwardingRules) SetTarget(ctx context.Context, key *meta.Key, arg0 *beta.TargetReference) error {
	if m.SetTargetHook != nil {
		return m.SetTargetHook(ctx, key, arg0, m)
	}
	return nil
}

// GCEBetaForwardingRules is a simplifying adapter for the GCE ForwardingRules.
type GCEBetaForwardingRules struct {
	s *Service
}

// Get the ForwardingRule named by key.
func (g *GCEBetaForwardingRules) Get(ctx context.Context, key *meta.Key) (*beta.ForwardingRule, error) {
	klog.V(5).Infof("GCEBetaForwardingRules.Get(%v, %v): called", ctx, key)

	if !key.Valid() {
		klog.V(2).Infof("GCEBetaForwardingRules.Get(%v, %v): key is invalid (%#v)", ctx, key, key)
		return nil, fmt.Errorf("invalid GCE key (%#v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "beta", "ForwardingRules")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Get",
		Version:   meta.Version("beta"),
		Service:   "ForwardingRules",
	}
	klog.V(5).Infof("GCEBetaForwardingRules.Get(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEBetaForwardingRules.Get(%v, %v): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.Beta.ForwardingRules.Get(projectID, key.Region, key.Name)
	call.Context(ctx)
	v, err := call.Do()
	klog.V(4).Infof("GCEBetaForwardingRules.Get(%v, %v) = %+v, %v", ctx, key, v, err)
	return v, err
}

// List all ForwardingRule objects.
func (g *GCEBetaForwardingRules) List(ctx context.Context, region string, fl *filter.F) ([]*beta.ForwardingRule, error) {
	klog.V(5).Infof("GCEBetaForwardingRules.List(%v, %v, %v) called", ctx, region, fl)
	projectID := g.s.ProjectRouter.ProjectID(ctx, "beta", "ForwardingRules")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "List",
		Version:   meta.Version("beta"),
		Service:   "ForwardingRules",
	}
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		return nil, err
	}
	klog.V(5).Infof("GCEBetaForwardingRules.List(%v, %v, %v): projectID = %v, rk = %+v", ctx, region, fl, projectID, rk)
	call := g.s.Beta.ForwardingRules.List(projectID, region)
	if fl != filter.None {
		call.Filter(fl.String())
	}
	var all []*beta.ForwardingRule
	f := func(l *beta.ForwardingRuleList) error {
		klog.V(5).Infof("GCEBetaForwardingRules.List(%v, ..., %v): page %+v", ctx, fl, l)
		all = append(all, l.Items...)
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		klog.V(4).Infof("GCEBetaForwardingRules.List(%v, ..., %v) = %v, %v", ctx, fl, nil, err)
		return nil, err
	}

	if klog.V(4).Enabled() {
		klog.V(4).Infof("GCEBetaForwardingRules.List(%v, ..., %v) = [%v items], %v", ctx, fl, len(all), nil)
	} else if klog.V(5).Enabled() {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		klog.V(5).Infof("GCEBetaForwardingRules.List(%v, ..., %v) = %v, %v", ctx, fl, asStr, nil)
	}

	return all, nil
}

// Insert ForwardingRule with key of value obj.
func (g *GCEBetaForwardingRules) Insert(ctx context.Context, key *meta.Key, obj *beta.ForwardingRule) error {
	klog.V(5).Infof("GCEBetaForwardingRules.Insert(%v, %v, %+v): called", ctx, key, obj)
	if !key.Valid() {
		klog.V(2).Infof("GCEBetaForwardingRules.Insert(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "beta", "ForwardingRules")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Insert",
		Version:   meta.Version("beta"),
		Service:   "ForwardingRules",
	}
	klog.V(5).Infof("GCEBetaForwardingRules.Insert(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEBetaForwardingRules.Insert(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	obj.Name = key.Name
	call := g.s.Beta.ForwardingRules.Insert(projectID, key.Region, obj)
	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCEBetaForwardingRules.Insert(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEBetaForwardingRules.Insert(%v, %v, %+v) = %+v", ctx, key, obj, err)
	return err
}

// Delete the ForwardingRule referenced by key.
func (g *GCEBetaForwardingRules) Delete(ctx context.Context, key *meta.Key) error {
	klog.V(5).Infof("GCEBetaForwardingRules.Delete(%v, %v): called", ctx, key)
	if !key.Valid() {
		klog.V(2).Infof("GCEBetaForwardingRules.Delete(%v, %v): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "beta", "ForwardingRules")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Delete",
		Version:   meta.Version("beta"),
		Service:   "ForwardingRules",
	}
	klog.V(5).Infof("GCEBetaForwardingRules.Delete(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEBetaForwardingRules.Delete(%v, %v): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Beta.ForwardingRules.Delete(projectID, key.Region, key.Name)
	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCEBetaForwardingRules.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEBetaForwardingRules.Delete(%v, %v) = %v", ctx, key, err)
	return err
}

// SetTarget is a method on GCEBetaForwardingRules.
func (g *GCEBetaForwardingRules) SetTarget(ctx context.Context, key *meta.Key, arg0 *beta.TargetReference) error {
	klog.V(5).Infof("GCEBetaForwardingRules.SetTarget(%v, %v, ...): called", ctx, key)

	if !key.Valid() {
		klog.V(2).Infof("GCEBetaForwardingRules.SetTarget(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "beta", "ForwardingRules")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "SetTarget",
		Version:   meta.Version("beta"),
		Service:   "ForwardingRules",
	}
	klog.V(5).Infof("GCEBetaForwardingRules.SetTarget(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)

	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEBetaForwardingRules.SetTarget(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Beta.ForwardingRules.SetTarget(projectID, key.Region, key.Name, arg0)
	call.Context(ctx)
	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCEBetaForwardingRules.SetTarget(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}
	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEBetaForwardingRules.SetTarget(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// AlphaGlobalForwardingRules is an interface that allows for mocking of GlobalForwardingRules.
type AlphaGlobalForwardingRules interface {
	Get(ctx context.Context, key *meta.Key) (*alpha.ForwardingRule, error)
	List(ctx context.Context, fl *filter.F) ([]*alpha.ForwardingRule, error)
	Insert(ctx context.Context, key *meta.Key, obj *alpha.ForwardingRule) error
	Delete(ctx context.Context, key *meta.Key) error
	SetTarget(context.Context, *meta.Key, *alpha.TargetReference) error
}

// NewMockAlphaGlobalForwardingRules returns a new mock for GlobalForwardingRules.
func NewMockAlphaGlobalForwardingRules(pr ProjectRouter, objs map[meta.Key]*MockGlobalForwardingRulesObj) *MockAlphaGlobalForwardingRules {
	mock := &MockAlphaGlobalForwardingRules{
		ProjectRouter: pr,

		Objects:     objs,
		GetError:    map[meta.Key]error{},
		InsertError: map[meta.Key]error{},
		DeleteError: map[meta.Key]error{},
	}
	return mock
}

// MockAlphaGlobalForwardingRules is the mock for GlobalForwardingRules.
type MockAlphaGlobalForwardingRules struct {
	Lock sync.Mutex

	ProjectRouter ProjectRouter

	// Objects maintained by the mock.
	Objects map[meta.Key]*MockGlobalForwardingRulesObj

	// If an entry exists for the given key and operation, then the error
	// will be returned instead of the operation.
	GetError    map[meta.Key]error
	ListError   *error
	InsertError map[meta.Key]error
	DeleteError map[meta.Key]error

	// xxxHook allow you to intercept the standard processing of the mock in
	// order to add your own logic. Return (true, _, _) to prevent the normal
	// execution flow of the mock. Return (false, nil, nil) to continue with
	// normal mock behavior/ after the hook function executes.
	GetHook       func(ctx context.Context, key *meta.Key, m *MockAlphaGlobalForwardingRules) (bool, *alpha.ForwardingRule, error)
	ListHook      func(ctx context.Context, fl *filter.F, m *MockAlphaGlobalForwardingRules) (bool, []*alpha.ForwardingRule, error)
	InsertHook    func(ctx context.Context, key *meta.Key, obj *alpha.ForwardingRule, m *MockAlphaGlobalForwardingRules) (bool, error)
	DeleteHook    func(ctx context.Context, key *meta.Key, m *MockAlphaGlobalForwardingRules) (bool, error)
	SetTargetHook func(context.Context, *meta.Key, *alpha.TargetReference, *MockAlphaGlobalForwardingRules) error

	// X is extra state that can be used as part of the mock. Generated code
	// will not use this field.
	X interface{}
}

// Get returns the object from the mock.
func (m *MockAlphaGlobalForwardingRules) Get(ctx context.Context, key *meta.Key) (*alpha.ForwardingRule, error) {
	if m.GetHook != nil {
		if intercept, obj, err := m.GetHook(ctx, key, m); intercept {
			klog.V(5).Infof("MockAlphaGlobalForwardingRules.Get(%v, %s) = %+v, %v", ctx, key, obj, err)
			return obj, err
		}
	}
	if !key.Valid() {
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.GetError[*key]; ok {
		klog.V(5).Infof("MockAlphaGlobalForwardingRules.Get(%v, %s) = nil, %v", ctx, key, err)
		return nil, err
	}
	if obj, ok := m.Objects[*key]; ok {
		typedObj := obj.ToAlpha()
		klog.V(5).Infof("MockAlphaGlobalForwardingRules.Get(%v, %s) = %+v, nil", ctx, key, typedObj)
		return typedObj, nil
	}

	err := &googleapi.Error{
		Code:    http.StatusNotFound,
		Message: fmt.Sprintf("MockAlphaGlobalForwardingRules %v not found", key),
	}
	klog.V(5).Infof("MockAlphaGlobalForwardingRules.Get(%v, %s) = nil, %v", ctx, key, err)
	return nil, err
}

// List all of the objects in the mock.
func (m *MockAlphaGlobalForwardingRules) List(ctx context.Context, fl *filter.F) ([]*alpha.ForwardingRule, error) {
	if m.ListHook != nil {
		if intercept, objs, err := m.ListHook(ctx, fl, m); intercept {
			klog.V(5).Infof("MockAlphaGlobalForwardingRules.List(%v, %v) = [%v items], %v", ctx, fl, len(objs), err)
			return objs, err
		}
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if m.ListError != nil {
		err := *m.ListError
		klog.V(5).Infof("MockAlphaGlobalForwardingRules.List(%v, %v) = nil, %v", ctx, fl, err)

		return nil, *m.ListError
	}

	var objs []*alpha.ForwardingRule
	for _, obj := range m.Objects {
		if !fl.Match(obj.ToAlpha()) {
			continue
		}
		objs = append(objs, obj.ToAlpha())
	}

	klog.V(5).Infof("MockAlphaGlobalForwardingRules.List(%v, %v) = [%v items], nil", ctx, fl, len(objs))
	return objs, nil
}

// Insert is a mock for inserting/creating a new object.
func (m *MockAlphaGlobalForwardingRules) Insert(ctx context.Context, key *meta.Key, obj *alpha.ForwardingRule) error {
	if m.InsertHook != nil {
		if intercept, err := m.InsertHook(ctx, key, obj, m); intercept {
			klog.V(5).Infof("MockAlphaGlobalForwardingRules.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.InsertError[*key]; ok {
		klog.V(5).Infof("MockAlphaGlobalForwardingRules.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}
	if _, ok := m.Objects[*key]; ok {
		err := &googleapi.Error{
			Code:    http.StatusConflict,
			Message: fmt.Sprintf("MockAlphaGlobalForwardingRules %v exists", key),
		}
		klog.V(5).Infof("MockAlphaGlobalForwardingRules.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}

	obj.Name = key.Name
	projectID := m.ProjectRouter.ProjectID(ctx, "alpha", "forwardingRules")
	obj.SelfLink = SelfLink(meta.VersionAlpha, projectID, "forwardingRules", key)

	m.Objects[*key] = &MockGlobalForwardingRulesObj{obj}
	klog.V(5).Infof("MockAlphaGlobalForwardingRules.Insert(%v, %v, %+v) = nil", ctx, key, obj)
	return nil
}

// Delete is a mock for deleting the object.
func (m *MockAlphaGlobalForwardingRules) Delete(ctx context.Context, key *meta.Key) error {
	if m.DeleteHook != nil {
		if intercept, err := m.DeleteHook(ctx, key, m); intercept {
			klog.V(5).Infof("MockAlphaGlobalForwardingRules.Delete(%v, %v) = %v", ctx, key, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.DeleteError[*key]; ok {
		klog.V(5).Infof("MockAlphaGlobalForwardingRules.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}
	if _, ok := m.Objects[*key]; !ok {
		err := &googleapi.Error{
			Code:    http.StatusNotFound,
			Message: fmt.Sprintf("MockAlphaGlobalForwardingRules %v not found", key),
		}
		klog.V(5).Infof("MockAlphaGlobalForwardingRules.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	delete(m.Objects, *key)
	klog.V(5).Infof("MockAlphaGlobalForwardingRules.Delete(%v, %v) = nil", ctx, key)
	return nil
}

// Obj wraps the object for use in the mock.
func (m *MockAlphaGlobalForwardingRules) Obj(o *alpha.ForwardingRule) *MockGlobalForwardingRulesObj {
	return &MockGlobalForwardingRulesObj{o}
}

// SetTarget is a mock for the corresponding method.
func (m *MockAlphaGlobalForwardingRules) SetTarget(ctx context.Context, key *meta.Key, arg0 *alpha.TargetReference) error {
	if m.SetTargetHook != nil {
		return m.SetTargetHook(ctx, key, arg0, m)
	}
	return nil
}

// GCEAlphaGlobalForwardingRules is a simplifying adapter for the GCE GlobalForwardingRules.
type GCEAlphaGlobalForwardingRules struct {
	s *Service
}

// Get the ForwardingRule named by key.
func (g *GCEAlphaGlobalForwardingRules) Get(ctx context.Context, key *meta.Key) (*alpha.ForwardingRule, error) {
	klog.V(5).Infof("GCEAlphaGlobalForwardingRules.Get(%v, %v): called", ctx, key)

	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaGlobalForwardingRules.Get(%v, %v): key is invalid (%#v)", ctx, key, key)
		return nil, fmt.Errorf("invalid GCE key (%#v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "alpha", "GlobalForwardingRules")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Get",
		Version:   meta.Version("alpha"),
		Service:   "GlobalForwardingRules",
	}
	klog.V(5).Infof("GCEAlphaGlobalForwardingRules.Get(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEAlphaGlobalForwardingRules.Get(%v, %v): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.Alpha.GlobalForwardingRules.Get(projectID, key.Name)
	call.Context(ctx)
	v, err := call.Do()
	klog.V(4).Infof("GCEAlphaGlobalForwardingRules.Get(%v, %v) = %+v, %v", ctx, key, v, err)
	return v, err
}

// List all ForwardingRule objects.
func (g *GCEAlphaGlobalForwardingRules) List(ctx context.Context, fl *filter.F) ([]*alpha.ForwardingRule, error) {
	klog.V(5).Infof("GCEAlphaGlobalForwardingRules.List(%v, %v) called", ctx, fl)
	projectID := g.s.ProjectRouter.ProjectID(ctx, "alpha", "GlobalForwardingRules")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "List",
		Version:   meta.Version("alpha"),
		Service:   "GlobalForwardingRules",
	}
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		return nil, err
	}
	klog.V(5).Infof("GCEAlphaGlobalForwardingRules.List(%v, %v): projectID = %v, rk = %+v", ctx, fl, projectID, rk)
	call := g.s.Alpha.GlobalForwardingRules.List(projectID)
	if fl != filter.None {
		call.Filter(fl.String())
	}
	var all []*alpha.ForwardingRule
	f := func(l *alpha.ForwardingRuleList) error {
		klog.V(5).Infof("GCEAlphaGlobalForwardingRules.List(%v, ..., %v): page %+v", ctx, fl, l)
		all = append(all, l.Items...)
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		klog.V(4).Infof("GCEAlphaGlobalForwardingRules.List(%v, ..., %v) = %v, %v", ctx, fl, nil, err)
		return nil, err
	}

	if klog.V(4).Enabled() {
		klog.V(4).Infof("GCEAlphaGlobalForwardingRules.List(%v, ..., %v) = [%v items], %v", ctx, fl, len(all), nil)
	} else if klog.V(5).Enabled() {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		klog.V(5).Infof("GCEAlphaGlobalForwardingRules.List(%v, ..., %v) = %v, %v", ctx, fl, asStr, nil)
	}

	return all, nil
}

// Insert ForwardingRule with key of value obj.
func (g *GCEAlphaGlobalForwardingRules) Insert(ctx context.Context, key *meta.Key, obj *alpha.ForwardingRule) error {
	klog.V(5).Infof("GCEAlphaGlobalForwardingRules.Insert(%v, %v, %+v): called", ctx, key, obj)
	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaGlobalForwardingRules.Insert(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "alpha", "GlobalForwardingRules")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Insert",
		Version:   meta.Version("alpha"),
		Service:   "GlobalForwardingRules",
	}
	klog.V(5).Infof("GCEAlphaGlobalForwardingRules.Insert(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEAlphaGlobalForwardingRules.Insert(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	obj.Name = key.Name
	call := g.s.Alpha.GlobalForwardingRules.Insert(projectID, obj)
	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCEAlphaGlobalForwardingRules.Insert(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEAlphaGlobalForwardingRules.Insert(%v, %v, %+v) = %+v", ctx, key, obj, err)
	return err
}

// Delete the ForwardingRule referenced by key.
func (g *GCEAlphaGlobalForwardingRules) Delete(ctx context.Context, key *meta.Key) error {
	klog.V(5).Infof("GCEAlphaGlobalForwardingRules.Delete(%v, %v): called", ctx, key)
	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaGlobalForwardingRules.Delete(%v, %v): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "alpha", "GlobalForwardingRules")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Delete",
		Version:   meta.Version("alpha"),
		Service:   "GlobalForwardingRules",
	}
	klog.V(5).Infof("GCEAlphaGlobalForwardingRules.Delete(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEAlphaGlobalForwardingRules.Delete(%v, %v): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Alpha.GlobalForwardingRules.Delete(projectID, key.Name)

	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCEAlphaGlobalForwardingRules.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEAlphaGlobalForwardingRules.Delete(%v, %v) = %v", ctx, key, err)
	return err
}

// SetTarget is a method on GCEAlphaGlobalForwardingRules.
func (g *GCEAlphaGlobalForwardingRules) SetTarget(ctx context.Context, key *meta.Key, arg0 *alpha.TargetReference) error {
	klog.V(5).Infof("GCEAlphaGlobalForwardingRules.SetTarget(%v, %v, ...): called", ctx, key)

	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaGlobalForwardingRules.SetTarget(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "alpha", "GlobalForwardingRules")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "SetTarget",
		Version:   meta.Version("alpha"),
		Service:   "GlobalForwardingRules",
	}
	klog.V(5).Infof("GCEAlphaGlobalForwardingRules.SetTarget(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)

	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEAlphaGlobalForwardingRules.SetTarget(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Alpha.GlobalForwardingRules.SetTarget(projectID, key.Name, arg0)
	call.Context(ctx)
	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCEAlphaGlobalForwardingRules.SetTarget(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}
	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEAlphaGlobalForwardingRules.SetTarget(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// BetaGlobalForwardingRules is an interface that allows for mocking of GlobalForwardingRules.
type BetaGlobalForwardingRules interface {
	Get(ctx context.Context, key *meta.Key) (*beta.ForwardingRule, error)
	List(ctx context.Context, fl *filter.F) ([]*beta.ForwardingRule, error)
	Insert(ctx context.Context, key *meta.Key, obj *beta.ForwardingRule) error
	Delete(ctx context.Context, key *meta.Key) error
	SetTarget(context.Context, *meta.Key, *beta.TargetReference) error
}

// NewMockBetaGlobalForwardingRules returns a new mock for GlobalForwardingRules.
func NewMockBetaGlobalForwardingRules(pr ProjectRouter, objs map[meta.Key]*MockGlobalForwardingRulesObj) *MockBetaGlobalForwardingRules {
	mock := &MockBetaGlobalForwardingRules{
		ProjectRouter: pr,

		Objects:     objs,
		GetError:    map[meta.Key]error{},
		InsertError: map[meta.Key]error{},
		DeleteError: map[meta.Key]error{},
	}
	return mock
}

// MockBetaGlobalForwardingRules is the mock for GlobalForwardingRules.
type MockBetaGlobalForwardingRules struct {
	Lock sync.Mutex

	ProjectRouter ProjectRouter

	// Objects maintained by the mock.
	Objects map[meta.Key]*MockGlobalForwardingRulesObj

	// If an entry exists for the given key and operation, then the error
	// will be returned instead of the operation.
	GetError    map[meta.Key]error
	ListError   *error
	InsertError map[meta.Key]error
	DeleteError map[meta.Key]error

	// xxxHook allow you to intercept the standard processing of the mock in
	// order to add your own logic. Return (true, _, _) to prevent the normal
	// execution flow of the mock. Return (false, nil, nil) to continue with
	// normal mock behavior/ after the hook function executes.
	GetHook       func(ctx context.Context, key *meta.Key, m *MockBetaGlobalForwardingRules) (bool, *beta.ForwardingRule, error)
	ListHook      func(ctx context.Context, fl *filter.F, m *MockBetaGlobalForwardingRules) (bool, []*beta.ForwardingRule, error)
	InsertHook    func(ctx context.Context, key *meta.Key, obj *beta.ForwardingRule, m *MockBetaGlobalForwardingRules) (bool, error)
	DeleteHook    func(ctx context.Context, key *meta.Key, m *MockBetaGlobalForwardingRules) (bool, error)
	SetTargetHook func(context.Context, *meta.Key, *beta.TargetReference, *MockBetaGlobalForwardingRules) error

	// X is extra state that can be used as part of the mock. Generated code
	// will not use this field.
	X interface{}
}

// Get returns the object from the mock.
func (m *MockBetaGlobalForwardingRules) Get(ctx context.Context, key *meta.Key) (*beta.ForwardingRule, error) {
	if m.GetHook != nil {
		if intercept, obj, err := m.GetHook(ctx, key, m); intercept {
			klog.V(5).Infof("MockBetaGlobalForwardingRules.Get(%v, %s) = %+v, %v", ctx, key, obj, err)
			return obj, err
		}
	}
	if !key.Valid() {
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.GetError[*key]; ok {
		klog.V(5).Infof("MockBetaGlobalForwardingRules.Get(%v, %s) = nil, %v", ctx, key, err)
		return nil, err
	}
	if obj, ok := m.Objects[*key]; ok {
		typedObj := obj.ToBeta()
		klog.V(5).Infof("MockBetaGlobalForwardingRules.Get(%v, %s) = %+v, nil", ctx, key, typedObj)
		return typedObj, nil
	}

	err := &googleapi.Error{
		Code:    http.StatusNotFound,
		Message: fmt.Sprintf("MockBetaGlobalForwardingRules %v not found", key),
	}
	klog.V(5).Infof("MockBetaGlobalForwardingRules.Get(%v, %s) = nil, %v", ctx, key, err)
	return nil, err
}

// List all of the objects in the mock.
func (m *MockBetaGlobalForwardingRules) List(ctx context.Context, fl *filter.F) ([]*beta.ForwardingRule, error) {
	if m.ListHook != nil {
		if intercept, objs, err := m.ListHook(ctx, fl, m); intercept {
			klog.V(5).Infof("MockBetaGlobalForwardingRules.List(%v, %v) = [%v items], %v", ctx, fl, len(objs), err)
			return objs, err
		}
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if m.ListError != nil {
		err := *m.ListError
		klog.V(5).Infof("MockBetaGlobalForwardingRules.List(%v, %v) = nil, %v", ctx, fl, err)

		return nil, *m.ListError
	}

	var objs []*beta.ForwardingRule
	for _, obj := range m.Objects {
		if !fl.Match(obj.ToBeta()) {
			continue
		}
		objs = append(objs, obj.ToBeta())
	}

	klog.V(5).Infof("MockBetaGlobalForwardingRules.List(%v, %v) = [%v items], nil", ctx, fl, len(objs))
	return objs, nil
}

// Insert is a mock for inserting/creating a new object.
func (m *MockBetaGlobalForwardingRules) Insert(ctx context.Context, key *meta.Key, obj *beta.ForwardingRule) error {
	if m.InsertHook != nil {
		if intercept, err := m.InsertHook(ctx, key, obj, m); intercept {
			klog.V(5).Infof("MockBetaGlobalForwardingRules.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.InsertError[*key]; ok {
		klog.V(5).Infof("MockBetaGlobalForwardingRules.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}
	if _, ok := m.Objects[*key]; ok {
		err := &googleapi.Error{
			Code:    http.StatusConflict,
			Message: fmt.Sprintf("MockBetaGlobalForwardingRules %v exists", key),
		}
		klog.V(5).Infof("MockBetaGlobalForwardingRules.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}

	obj.Name = key.Name
	projectID := m.ProjectRouter.ProjectID(ctx, "beta", "forwardingRules")
	obj.SelfLink = SelfLink(meta.VersionBeta, projectID, "forwardingRules", key)

	m.Objects[*key] = &MockGlobalForwardingRulesObj{obj}
	klog.V(5).Infof("MockBetaGlobalForwardingRules.Insert(%v, %v, %+v) = nil", ctx, key, obj)
	return nil
}

// Delete is a mock for deleting the object.
func (m *MockBetaGlobalForwardingRules) Delete(ctx context.Context, key *meta.Key) error {
	if m.DeleteHook != nil {
		if intercept, err := m.DeleteHook(ctx, key, m); intercept {
			klog.V(5).Infof("MockBetaGlobalForwardingRules.Delete(%v, %v) = %v", ctx, key, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.DeleteError[*key]; ok {
		klog.V(5).Infof("MockBetaGlobalForwardingRules.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}
	if _, ok := m.Objects[*key]; !ok {
		err := &googleapi.Error{
			Code:    http.StatusNotFound,
			Message: fmt.Sprintf("MockBetaGlobalForwardingRules %v not found", key),
		}
		klog.V(5).Infof("MockBetaGlobalForwardingRules.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	delete(m.Objects, *key)
	klog.V(5).Infof("MockBetaGlobalForwardingRules.Delete(%v, %v) = nil", ctx, key)
	return nil
}

// Obj wraps the object for use in the mock.
func (m *MockBetaGlobalForwardingRules) Obj(o *beta.ForwardingRule) *MockGlobalForwardingRulesObj {
	return &MockGlobalForwardingRulesObj{o}
}

// SetTarget is a mock for the corresponding method.
func (m *MockBetaGlobalForwardingRules) SetTarget(ctx context.Context, key *meta.Key, arg0 *beta.TargetReference) error {
	if m.SetTargetHook != nil {
		return m.SetTargetHook(ctx, key, arg0, m)
	}
	return nil
}

// GCEBetaGlobalForwardingRules is a simplifying adapter for the GCE GlobalForwardingRules.
type GCEBetaGlobalForwardingRules struct {
	s *Service
}

// Get the ForwardingRule named by key.
func (g *GCEBetaGlobalForwardingRules) Get(ctx context.Context, key *meta.Key) (*beta.ForwardingRule, error) {
	klog.V(5).Infof("GCEBetaGlobalForwardingRules.Get(%v, %v): called", ctx, key)

	if !key.Valid() {
		klog.V(2).Infof("GCEBetaGlobalForwardingRules.Get(%v, %v): key is invalid (%#v)", ctx, key, key)
		return nil, fmt.Errorf("invalid GCE key (%#v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "beta", "GlobalForwardingRules")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Get",
		Version:   meta.Version("beta"),
		Service:   "GlobalForwardingRules",
	}
	klog.V(5).Infof("GCEBetaGlobalForwardingRules.Get(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEBetaGlobalForwardingRules.Get(%v, %v): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.Beta.GlobalForwardingRules.Get(projectID, key.Name)
	call.Context(ctx)
	v, err := call.Do()
	klog.V(4).Infof("GCEBetaGlobalForwardingRules.Get(%v, %v) = %+v, %v", ctx, key, v, err)
	return v, err
}

// List all ForwardingRule objects.
func (g *GCEBetaGlobalForwardingRules) List(ctx context.Context, fl *filter.F) ([]*beta.ForwardingRule, error) {
	klog.V(5).Infof("GCEBetaGlobalForwardingRules.List(%v, %v) called", ctx, fl)
	projectID := g.s.ProjectRouter.ProjectID(ctx, "beta", "GlobalForwardingRules")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "List",
		Version:   meta.Version("beta"),
		Service:   "GlobalForwardingRules",
	}
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		return nil, err
	}
	klog.V(5).Infof("GCEBetaGlobalForwardingRules.List(%v, %v): projectID = %v, rk = %+v", ctx, fl, projectID, rk)
	call := g.s.Beta.GlobalForwardingRules.List(projectID)
	if fl != filter.None {
		call.Filter(fl.String())
	}
	var all []*beta.ForwardingRule
	f := func(l *beta.ForwardingRuleList) error {
		klog.V(5).Infof("GCEBetaGlobalForwardingRules.List(%v, ..., %v): page %+v", ctx, fl, l)
		all = append(all, l.Items...)
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		klog.V(4).Infof("GCEBetaGlobalForwardingRules.List(%v, ..., %v) = %v, %v", ctx, fl, nil, err)
		return nil, err
	}

	if klog.V(4).Enabled() {
		klog.V(4).Infof("GCEBetaGlobalForwardingRules.List(%v, ..., %v) = [%v items], %v", ctx, fl, len(all), nil)
	} else if klog.V(5).Enabled() {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		klog.V(5).Infof("GCEBetaGlobalForwardingRules.List(%v, ..., %v) = %v, %v", ctx, fl, asStr, nil)
	}

	return all, nil
}

// Insert ForwardingRule with key of value obj.
func (g *GCEBetaGlobalForwardingRules) Insert(ctx context.Context, key *meta.Key, obj *beta.ForwardingRule) error {
	klog.V(5).Infof("GCEBetaGlobalForwardingRules.Insert(%v, %v, %+v): called", ctx, key, obj)
	if !key.Valid() {
		klog.V(2).Infof("GCEBetaGlobalForwardingRules.Insert(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "beta", "GlobalForwardingRules")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Insert",
		Version:   meta.Version("beta"),
		Service:   "GlobalForwardingRules",
	}
	klog.V(5).Infof("GCEBetaGlobalForwardingRules.Insert(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEBetaGlobalForwardingRules.Insert(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	obj.Name = key.Name
	call := g.s.Beta.GlobalForwardingRules.Insert(projectID, obj)
	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCEBetaGlobalForwardingRules.Insert(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEBetaGlobalForwardingRules.Insert(%v, %v, %+v) = %+v", ctx, key, obj, err)
	return err
}

// Delete the ForwardingRule referenced by key.
func (g *GCEBetaGlobalForwardingRules) Delete(ctx context.Context, key *meta.Key) error {
	klog.V(5).Infof("GCEBetaGlobalForwardingRules.Delete(%v, %v): called", ctx, key)
	if !key.Valid() {
		klog.V(2).Infof("GCEBetaGlobalForwardingRules.Delete(%v, %v): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "beta", "GlobalForwardingRules")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Delete",
		Version:   meta.Version("beta"),
		Service:   "GlobalForwardingRules",
	}
	klog.V(5).Infof("GCEBetaGlobalForwardingRules.Delete(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEBetaGlobalForwardingRules.Delete(%v, %v): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Beta.GlobalForwardingRules.Delete(projectID, key.Name)

	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCEBetaGlobalForwardingRules.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEBetaGlobalForwardingRules.Delete(%v, %v) = %v", ctx, key, err)
	return err
}

// SetTarget is a method on GCEBetaGlobalForwardingRules.
func (g *GCEBetaGlobalForwardingRules) SetTarget(ctx context.Context, key *meta.Key, arg0 *beta.TargetReference) error {
	klog.V(5).Infof("GCEBetaGlobalForwardingRules.SetTarget(%v, %v, ...): called", ctx, key)

	if !key.Valid() {
		klog.V(2).Infof("GCEBetaGlobalForwardingRules.SetTarget(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "beta", "GlobalForwardingRules")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "SetTarget",
		Version:   meta.Version("beta"),
		Service:   "GlobalForwardingRules",
	}
	klog.V(5).Infof("GCEBetaGlobalForwardingRules.SetTarget(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)

	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEBetaGlobalForwardingRules.SetTarget(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Beta.GlobalForwardingRules.SetTarget(projectID, key.Name, arg0)
	call.Context(ctx)
	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCEBetaGlobalForwardingRules.SetTarget(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}
	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEBetaGlobalForwardingRules.SetTarget(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// GlobalForwardingRules is an interface that allows for mocking of GlobalForwardingRules.
type GlobalForwardingRules interface {
	Get(ctx context.Context, key *meta.Key) (*ga.ForwardingRule, error)
	List(ctx context.Context, fl *filter.F) ([]*ga.ForwardingRule, error)
	Insert(ctx context.Context, key *meta.Key, obj *ga.ForwardingRule) error
	Delete(ctx context.Context, key *meta.Key) error
	SetTarget(context.Context, *meta.Key, *ga.TargetReference) error
}

// NewMockGlobalForwardingRules returns a new mock for GlobalForwardingRules.
func NewMockGlobalForwardingRules(pr ProjectRouter, objs map[meta.Key]*MockGlobalForwardingRulesObj) *MockGlobalForwardingRules {
	mock := &MockGlobalForwardingRules{
		ProjectRouter: pr,

		Objects:     objs,
		GetError:    map[meta.Key]error{},
		InsertError: map[meta.Key]error{},
		DeleteError: map[meta.Key]error{},
	}
	return mock
}

// MockGlobalForwardingRules is the mock for GlobalForwardingRules.
type MockGlobalForwardingRules struct {
	Lock sync.Mutex

	ProjectRouter ProjectRouter

	// Objects maintained by the mock.
	Objects map[meta.Key]*MockGlobalForwardingRulesObj

	// If an entry exists for the given key and operation, then the error
	// will be returned instead of the operation.
	GetError    map[meta.Key]error
	ListError   *error
	InsertError map[meta.Key]error
	DeleteError map[meta.Key]error

	// xxxHook allow you to intercept the standard processing of the mock in
	// order to add your own logic. Return (true, _, _) to prevent the normal
	// execution flow of the mock. Return (false, nil, nil) to continue with
	// normal mock behavior/ after the hook function executes.
	GetHook       func(ctx context.Context, key *meta.Key, m *MockGlobalForwardingRules) (bool, *ga.ForwardingRule, error)
	ListHook      func(ctx context.Context, fl *filter.F, m *MockGlobalForwardingRules) (bool, []*ga.ForwardingRule, error)
	InsertHook    func(ctx context.Context, key *meta.Key, obj *ga.ForwardingRule, m *MockGlobalForwardingRules) (bool, error)
	DeleteHook    func(ctx context.Context, key *meta.Key, m *MockGlobalForwardingRules) (bool, error)
	SetTargetHook func(context.Context, *meta.Key, *ga.TargetReference, *MockGlobalForwardingRules) error

	// X is extra state that can be used as part of the mock. Generated code
	// will not use this field.
	X interface{}
}

// Get returns the object from the mock.
func (m *MockGlobalForwardingRules) Get(ctx context.Context, key *meta.Key) (*ga.ForwardingRule, error) {
	if m.GetHook != nil {
		if intercept, obj, err := m.GetHook(ctx, key, m); intercept {
			klog.V(5).Infof("MockGlobalForwardingRules.Get(%v, %s) = %+v, %v", ctx, key, obj, err)
			return obj, err
		}
	}
	if !key.Valid() {
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.GetError[*key]; ok {
		klog.V(5).Infof("MockGlobalForwardingRules.Get(%v, %s) = nil, %v", ctx, key, err)
		return nil, err
	}
	if obj, ok := m.Objects[*key]; ok {
		typedObj := obj.ToGA()
		klog.V(5).Infof("MockGlobalForwardingRules.Get(%v, %s) = %+v, nil", ctx, key, typedObj)
		return typedObj, nil
	}

	err := &googleapi.Error{
		Code:    http.StatusNotFound,
		Message: fmt.Sprintf("MockGlobalForwardingRules %v not found", key),
	}
	klog.V(5).Infof("MockGlobalForwardingRules.Get(%v, %s) = nil, %v", ctx, key, err)
	return nil, err
}

// List all of the objects in the mock.
func (m *MockGlobalForwardingRules) List(ctx context.Context, fl *filter.F) ([]*ga.ForwardingRule, error) {
	if m.ListHook != nil {
		if intercept, objs, err := m.ListHook(ctx, fl, m); intercept {
			klog.V(5).Infof("MockGlobalForwardingRules.List(%v, %v) = [%v items], %v", ctx, fl, len(objs), err)
			return objs, err
		}
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if m.ListError != nil {
		err := *m.ListError
		klog.V(5).Infof("MockGlobalForwardingRules.List(%v, %v) = nil, %v", ctx, fl, err)

		return nil, *m.ListError
	}

	var objs []*ga.ForwardingRule
	for _, obj := range m.Objects {
		if !fl.Match(obj.ToGA()) {
			continue
		}
		objs = append(objs, obj.ToGA())
	}

	klog.V(5).Infof("MockGlobalForwardingRules.List(%v, %v) = [%v items], nil", ctx, fl, len(objs))
	return objs, nil
}

// Insert is a mock for inserting/creating a new object.
func (m *MockGlobalForwardingRules) Insert(ctx context.Context, key *meta.Key, obj *ga.ForwardingRule) error {
	if m.InsertHook != nil {
		if intercept, err := m.InsertHook(ctx, key, obj, m); intercept {
			klog.V(5).Infof("MockGlobalForwardingRules.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.InsertError[*key]; ok {
		klog.V(5).Infof("MockGlobalForwardingRules.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}
	if _, ok := m.Objects[*key]; ok {
		err := &googleapi.Error{
			Code:    http.StatusConflict,
			Message: fmt.Sprintf("MockGlobalForwardingRules %v exists", key),
		}
		klog.V(5).Infof("MockGlobalForwardingRules.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}

	obj.Name = key.Name
	projectID := m.ProjectRouter.ProjectID(ctx, "ga", "forwardingRules")
	obj.SelfLink = SelfLink(meta.VersionGA, projectID, "forwardingRules", key)

	m.Objects[*key] = &MockGlobalForwardingRulesObj{obj}
	klog.V(5).Infof("MockGlobalForwardingRules.Insert(%v, %v, %+v) = nil", ctx, key, obj)
	return nil
}

// Delete is a mock for deleting the object.
func (m *MockGlobalForwardingRules) Delete(ctx context.Context, key *meta.Key) error {
	if m.DeleteHook != nil {
		if intercept, err := m.DeleteHook(ctx, key, m); intercept {
			klog.V(5).Infof("MockGlobalForwardingRules.Delete(%v, %v) = %v", ctx, key, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.DeleteError[*key]; ok {
		klog.V(5).Infof("MockGlobalForwardingRules.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}
	if _, ok := m.Objects[*key]; !ok {
		err := &googleapi.Error{
			Code:    http.StatusNotFound,
			Message: fmt.Sprintf("MockGlobalForwardingRules %v not found", key),
		}
		klog.V(5).Infof("MockGlobalForwardingRules.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	delete(m.Objects, *key)
	klog.V(5).Infof("MockGlobalForwardingRules.Delete(%v, %v) = nil", ctx, key)
	return nil
}

// Obj wraps the object for use in the mock.
func (m *MockGlobalForwardingRules) Obj(o *ga.ForwardingRule) *MockGlobalForwardingRulesObj {
	return &MockGlobalForwardingRulesObj{o}
}

// SetTarget is a mock for the corresponding method.
func (m *MockGlobalForwardingRules) SetTarget(ctx context.Context, key *meta.Key, arg0 *ga.TargetReference) error {
	if m.SetTargetHook != nil {
		return m.SetTargetHook(ctx, key, arg0, m)
	}
	return nil
}

// GCEGlobalForwardingRules is a simplifying adapter for the GCE GlobalForwardingRules.
type GCEGlobalForwardingRules struct {
	s *Service
}

// Get the ForwardingRule named by key.
func (g *GCEGlobalForwardingRules) Get(ctx context.Context, key *meta.Key) (*ga.ForwardingRule, error) {
	klog.V(5).Infof("GCEGlobalForwardingRules.Get(%v, %v): called", ctx, key)

	if !key.Valid() {
		klog.V(2).Infof("GCEGlobalForwardingRules.Get(%v, %v): key is invalid (%#v)", ctx, key, key)
		return nil, fmt.Errorf("invalid GCE key (%#v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "GlobalForwardingRules")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Get",
		Version:   meta.Version("ga"),
		Service:   "GlobalForwardingRules",
	}
	klog.V(5).Infof("GCEGlobalForwardingRules.Get(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEGlobalForwardingRules.Get(%v, %v): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.GA.GlobalForwardingRules.Get(projectID, key.Name)
	call.Context(ctx)
	v, err := call.Do()
	klog.V(4).Infof("GCEGlobalForwardingRules.Get(%v, %v) = %+v, %v", ctx, key, v, err)
	return v, err
}

// List all ForwardingRule objects.
func (g *GCEGlobalForwardingRules) List(ctx context.Context, fl *filter.F) ([]*ga.ForwardingRule, error) {
	klog.V(5).Infof("GCEGlobalForwardingRules.List(%v, %v) called", ctx, fl)
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "GlobalForwardingRules")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "List",
		Version:   meta.Version("ga"),
		Service:   "GlobalForwardingRules",
	}
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		return nil, err
	}
	klog.V(5).Infof("GCEGlobalForwardingRules.List(%v, %v): projectID = %v, rk = %+v", ctx, fl, projectID, rk)
	call := g.s.GA.GlobalForwardingRules.List(projectID)
	if fl != filter.None {
		call.Filter(fl.String())
	}
	var all []*ga.ForwardingRule
	f := func(l *ga.ForwardingRuleList) error {
		klog.V(5).Infof("GCEGlobalForwardingRules.List(%v, ..., %v): page %+v", ctx, fl, l)
		all = append(all, l.Items...)
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		klog.V(4).Infof("GCEGlobalForwardingRules.List(%v, ..., %v) = %v, %v", ctx, fl, nil, err)
		return nil, err
	}

	if klog.V(4).Enabled() {
		klog.V(4).Infof("GCEGlobalForwardingRules.List(%v, ..., %v) = [%v items], %v", ctx, fl, len(all), nil)
	} else if klog.V(5).Enabled() {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		klog.V(5).Infof("GCEGlobalForwardingRules.List(%v, ..., %v) = %v, %v", ctx, fl, asStr, nil)
	}

	return all, nil
}

// Insert ForwardingRule with key of value obj.
func (g *GCEGlobalForwardingRules) Insert(ctx context.Context, key *meta.Key, obj *ga.ForwardingRule) error {
	klog.V(5).Infof("GCEGlobalForwardingRules.Insert(%v, %v, %+v): called", ctx, key, obj)
	if !key.Valid() {
		klog.V(2).Infof("GCEGlobalForwardingRules.Insert(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "GlobalForwardingRules")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Insert",
		Version:   meta.Version("ga"),
		Service:   "GlobalForwardingRules",
	}
	klog.V(5).Infof("GCEGlobalForwardingRules.Insert(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEGlobalForwardingRules.Insert(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	obj.Name = key.Name
	call := g.s.GA.GlobalForwardingRules.Insert(projectID, obj)
	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCEGlobalForwardingRules.Insert(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEGlobalForwardingRules.Insert(%v, %v, %+v) = %+v", ctx, key, obj, err)
	return err
}

// Delete the ForwardingRule referenced by key.
func (g *GCEGlobalForwardingRules) Delete(ctx context.Context, key *meta.Key) error {
	klog.V(5).Infof("GCEGlobalForwardingRules.Delete(%v, %v): called", ctx, key)
	if !key.Valid() {
		klog.V(2).Infof("GCEGlobalForwardingRules.Delete(%v, %v): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "GlobalForwardingRules")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Delete",
		Version:   meta.Version("ga"),
		Service:   "GlobalForwardingRules",
	}
	klog.V(5).Infof("GCEGlobalForwardingRules.Delete(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEGlobalForwardingRules.Delete(%v, %v): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.GA.GlobalForwardingRules.Delete(projectID, key.Name)

	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCEGlobalForwardingRules.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEGlobalForwardingRules.Delete(%v, %v) = %v", ctx, key, err)
	return err
}

// SetTarget is a method on GCEGlobalForwardingRules.
func (g *GCEGlobalForwardingRules) SetTarget(ctx context.Context, key *meta.Key, arg0 *ga.TargetReference) error {
	klog.V(5).Infof("GCEGlobalForwardingRules.SetTarget(%v, %v, ...): called", ctx, key)

	if !key.Valid() {
		klog.V(2).Infof("GCEGlobalForwardingRules.SetTarget(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "GlobalForwardingRules")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "SetTarget",
		Version:   meta.Version("ga"),
		Service:   "GlobalForwardingRules",
	}
	klog.V(5).Infof("GCEGlobalForwardingRules.SetTarget(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)

	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEGlobalForwardingRules.SetTarget(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.GA.GlobalForwardingRules.SetTarget(projectID, key.Name, arg0)
	call.Context(ctx)
	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCEGlobalForwardingRules.SetTarget(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}
	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEGlobalForwardingRules.SetTarget(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// HealthChecks is an interface that allows for mocking of HealthChecks.
type HealthChecks interface {
	Get(ctx context.Context, key *meta.Key) (*ga.HealthCheck, error)
	List(ctx context.Context, fl *filter.F) ([]*ga.HealthCheck, error)
	Insert(ctx context.Context, key *meta.Key, obj *ga.HealthCheck) error
	Delete(ctx context.Context, key *meta.Key) error
	Update(context.Context, *meta.Key, *ga.HealthCheck) error
}

// NewMockHealthChecks returns a new mock for HealthChecks.
func NewMockHealthChecks(pr ProjectRouter, objs map[meta.Key]*MockHealthChecksObj) *MockHealthChecks {
	mock := &MockHealthChecks{
		ProjectRouter: pr,

		Objects:     objs,
		GetError:    map[meta.Key]error{},
		InsertError: map[meta.Key]error{},
		DeleteError: map[meta.Key]error{},
	}
	return mock
}

// MockHealthChecks is the mock for HealthChecks.
type MockHealthChecks struct {
	Lock sync.Mutex

	ProjectRouter ProjectRouter

	// Objects maintained by the mock.
	Objects map[meta.Key]*MockHealthChecksObj

	// If an entry exists for the given key and operation, then the error
	// will be returned instead of the operation.
	GetError    map[meta.Key]error
	ListError   *error
	InsertError map[meta.Key]error
	DeleteError map[meta.Key]error

	// xxxHook allow you to intercept the standard processing of the mock in
	// order to add your own logic. Return (true, _, _) to prevent the normal
	// execution flow of the mock. Return (false, nil, nil) to continue with
	// normal mock behavior/ after the hook function executes.
	GetHook    func(ctx context.Context, key *meta.Key, m *MockHealthChecks) (bool, *ga.HealthCheck, error)
	ListHook   func(ctx context.Context, fl *filter.F, m *MockHealthChecks) (bool, []*ga.HealthCheck, error)
	InsertHook func(ctx context.Context, key *meta.Key, obj *ga.HealthCheck, m *MockHealthChecks) (bool, error)
	DeleteHook func(ctx context.Context, key *meta.Key, m *MockHealthChecks) (bool, error)
	UpdateHook func(context.Context, *meta.Key, *ga.HealthCheck, *MockHealthChecks) error

	// X is extra state that can be used as part of the mock. Generated code
	// will not use this field.
	X interface{}
}

// Get returns the object from the mock.
func (m *MockHealthChecks) Get(ctx context.Context, key *meta.Key) (*ga.HealthCheck, error) {
	if m.GetHook != nil {
		if intercept, obj, err := m.GetHook(ctx, key, m); intercept {
			klog.V(5).Infof("MockHealthChecks.Get(%v, %s) = %+v, %v", ctx, key, obj, err)
			return obj, err
		}
	}
	if !key.Valid() {
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.GetError[*key]; ok {
		klog.V(5).Infof("MockHealthChecks.Get(%v, %s) = nil, %v", ctx, key, err)
		return nil, err
	}
	if obj, ok := m.Objects[*key]; ok {
		typedObj := obj.ToGA()
		klog.V(5).Infof("MockHealthChecks.Get(%v, %s) = %+v, nil", ctx, key, typedObj)
		return typedObj, nil
	}

	err := &googleapi.Error{
		Code:    http.StatusNotFound,
		Message: fmt.Sprintf("MockHealthChecks %v not found", key),
	}
	klog.V(5).Infof("MockHealthChecks.Get(%v, %s) = nil, %v", ctx, key, err)
	return nil, err
}

// List all of the objects in the mock.
func (m *MockHealthChecks) List(ctx context.Context, fl *filter.F) ([]*ga.HealthCheck, error) {
	if m.ListHook != nil {
		if intercept, objs, err := m.ListHook(ctx, fl, m); intercept {
			klog.V(5).Infof("MockHealthChecks.List(%v, %v) = [%v items], %v", ctx, fl, len(objs), err)
			return objs, err
		}
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if m.ListError != nil {
		err := *m.ListError
		klog.V(5).Infof("MockHealthChecks.List(%v, %v) = nil, %v", ctx, fl, err)

		return nil, *m.ListError
	}

	var objs []*ga.HealthCheck
	for _, obj := range m.Objects {
		if !fl.Match(obj.ToGA()) {
			continue
		}
		objs = append(objs, obj.ToGA())
	}

	klog.V(5).Infof("MockHealthChecks.List(%v, %v) = [%v items], nil", ctx, fl, len(objs))
	return objs, nil
}

// Insert is a mock for inserting/creating a new object.
func (m *MockHealthChecks) Insert(ctx context.Context, key *meta.Key, obj *ga.HealthCheck) error {
	if m.InsertHook != nil {
		if intercept, err := m.InsertHook(ctx, key, obj, m); intercept {
			klog.V(5).Infof("MockHealthChecks.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.InsertError[*key]; ok {
		klog.V(5).Infof("MockHealthChecks.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}
	if _, ok := m.Objects[*key]; ok {
		err := &googleapi.Error{
			Code:    http.StatusConflict,
			Message: fmt.Sprintf("MockHealthChecks %v exists", key),
		}
		klog.V(5).Infof("MockHealthChecks.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}

	obj.Name = key.Name
	projectID := m.ProjectRouter.ProjectID(ctx, "ga", "healthChecks")
	obj.SelfLink = SelfLink(meta.VersionGA, projectID, "healthChecks", key)

	m.Objects[*key] = &MockHealthChecksObj{obj}
	klog.V(5).Infof("MockHealthChecks.Insert(%v, %v, %+v) = nil", ctx, key, obj)
	return nil
}

// Delete is a mock for deleting the object.
func (m *MockHealthChecks) Delete(ctx context.Context, key *meta.Key) error {
	if m.DeleteHook != nil {
		if intercept, err := m.DeleteHook(ctx, key, m); intercept {
			klog.V(5).Infof("MockHealthChecks.Delete(%v, %v) = %v", ctx, key, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.DeleteError[*key]; ok {
		klog.V(5).Infof("MockHealthChecks.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}
	if _, ok := m.Objects[*key]; !ok {
		err := &googleapi.Error{
			Code:    http.StatusNotFound,
			Message: fmt.Sprintf("MockHealthChecks %v not found", key),
		}
		klog.V(5).Infof("MockHealthChecks.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	delete(m.Objects, *key)
	klog.V(5).Infof("MockHealthChecks.Delete(%v, %v) = nil", ctx, key)
	return nil
}

// Obj wraps the object for use in the mock.
func (m *MockHealthChecks) Obj(o *ga.HealthCheck) *MockHealthChecksObj {
	return &MockHealthChecksObj{o}
}

// Update is a mock for the corresponding method.
func (m *MockHealthChecks) Update(ctx context.Context, key *meta.Key, arg0 *ga.HealthCheck) error {
	if m.UpdateHook != nil {
		return m.UpdateHook(ctx, key, arg0, m)
	}
	return nil
}

// GCEHealthChecks is a simplifying adapter for the GCE HealthChecks.
type GCEHealthChecks struct {
	s *Service
}

// Get the HealthCheck named by key.
func (g *GCEHealthChecks) Get(ctx context.Context, key *meta.Key) (*ga.HealthCheck, error) {
	klog.V(5).Infof("GCEHealthChecks.Get(%v, %v): called", ctx, key)

	if !key.Valid() {
		klog.V(2).Infof("GCEHealthChecks.Get(%v, %v): key is invalid (%#v)", ctx, key, key)
		return nil, fmt.Errorf("invalid GCE key (%#v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "HealthChecks")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Get",
		Version:   meta.Version("ga"),
		Service:   "HealthChecks",
	}
	klog.V(5).Infof("GCEHealthChecks.Get(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEHealthChecks.Get(%v, %v): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.GA.HealthChecks.Get(projectID, key.Name)
	call.Context(ctx)
	v, err := call.Do()
	klog.V(4).Infof("GCEHealthChecks.Get(%v, %v) = %+v, %v", ctx, key, v, err)
	return v, err
}

// List all HealthCheck objects.
func (g *GCEHealthChecks) List(ctx context.Context, fl *filter.F) ([]*ga.HealthCheck, error) {
	klog.V(5).Infof("GCEHealthChecks.List(%v, %v) called", ctx, fl)
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "HealthChecks")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "List",
		Version:   meta.Version("ga"),
		Service:   "HealthChecks",
	}
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		return nil, err
	}
	klog.V(5).Infof("GCEHealthChecks.List(%v, %v): projectID = %v, rk = %+v", ctx, fl, projectID, rk)
	call := g.s.GA.HealthChecks.List(projectID)
	if fl != filter.None {
		call.Filter(fl.String())
	}
	var all []*ga.HealthCheck
	f := func(l *ga.HealthCheckList) error {
		klog.V(5).Infof("GCEHealthChecks.List(%v, ..., %v): page %+v", ctx, fl, l)
		all = append(all, l.Items...)
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		klog.V(4).Infof("GCEHealthChecks.List(%v, ..., %v) = %v, %v", ctx, fl, nil, err)
		return nil, err
	}

	if klog.V(4).Enabled() {
		klog.V(4).Infof("GCEHealthChecks.List(%v, ..., %v) = [%v items], %v", ctx, fl, len(all), nil)
	} else if klog.V(5).Enabled() {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		klog.V(5).Infof("GCEHealthChecks.List(%v, ..., %v) = %v, %v", ctx, fl, asStr, nil)
	}

	return all, nil
}

// Insert HealthCheck with key of value obj.
func (g *GCEHealthChecks) Insert(ctx context.Context, key *meta.Key, obj *ga.HealthCheck) error {
	klog.V(5).Infof("GCEHealthChecks.Insert(%v, %v, %+v): called", ctx, key, obj)
	if !key.Valid() {
		klog.V(2).Infof("GCEHealthChecks.Insert(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "HealthChecks")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Insert",
		Version:   meta.Version("ga"),
		Service:   "HealthChecks",
	}
	klog.V(5).Infof("GCEHealthChecks.Insert(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEHealthChecks.Insert(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	obj.Name = key.Name
	call := g.s.GA.HealthChecks.Insert(projectID, obj)
	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCEHealthChecks.Insert(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEHealthChecks.Insert(%v, %v, %+v) = %+v", ctx, key, obj, err)
	return err
}

// Delete the HealthCheck referenced by key.
func (g *GCEHealthChecks) Delete(ctx context.Context, key *meta.Key) error {
	klog.V(5).Infof("GCEHealthChecks.Delete(%v, %v): called", ctx, key)
	if !key.Valid() {
		klog.V(2).Infof("GCEHealthChecks.Delete(%v, %v): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "HealthChecks")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Delete",
		Version:   meta.Version("ga"),
		Service:   "HealthChecks",
	}
	klog.V(5).Infof("GCEHealthChecks.Delete(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEHealthChecks.Delete(%v, %v): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.GA.HealthChecks.Delete(projectID, key.Name)

	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCEHealthChecks.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEHealthChecks.Delete(%v, %v) = %v", ctx, key, err)
	return err
}

// Update is a method on GCEHealthChecks.
func (g *GCEHealthChecks) Update(ctx context.Context, key *meta.Key, arg0 *ga.HealthCheck) error {
	klog.V(5).Infof("GCEHealthChecks.Update(%v, %v, ...): called", ctx, key)

	if !key.Valid() {
		klog.V(2).Infof("GCEHealthChecks.Update(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "HealthChecks")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Update",
		Version:   meta.Version("ga"),
		Service:   "HealthChecks",
	}
	klog.V(5).Infof("GCEHealthChecks.Update(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)

	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEHealthChecks.Update(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.GA.HealthChecks.Update(projectID, key.Name, arg0)
	call.Context(ctx)
	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCEHealthChecks.Update(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}
	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEHealthChecks.Update(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// AlphaHealthChecks is an interface that allows for mocking of HealthChecks.
type AlphaHealthChecks interface {
	Get(ctx context.Context, key *meta.Key) (*alpha.HealthCheck, error)
	List(ctx context.Context, fl *filter.F) ([]*alpha.HealthCheck, error)
	Insert(ctx context.Context, key *meta.Key, obj *alpha.HealthCheck) error
	Delete(ctx context.Context, key *meta.Key) error
	Update(context.Context, *meta.Key, *alpha.HealthCheck) error
}

// NewMockAlphaHealthChecks returns a new mock for HealthChecks.
func NewMockAlphaHealthChecks(pr ProjectRouter, objs map[meta.Key]*MockHealthChecksObj) *MockAlphaHealthChecks {
	mock := &MockAlphaHealthChecks{
		ProjectRouter: pr,

		Objects:     objs,
		GetError:    map[meta.Key]error{},
		InsertError: map[meta.Key]error{},
		DeleteError: map[meta.Key]error{},
	}
	return mock
}

// MockAlphaHealthChecks is the mock for HealthChecks.
type MockAlphaHealthChecks struct {
	Lock sync.Mutex

	ProjectRouter ProjectRouter

	// Objects maintained by the mock.
	Objects map[meta.Key]*MockHealthChecksObj

	// If an entry exists for the given key and operation, then the error
	// will be returned instead of the operation.
	GetError    map[meta.Key]error
	ListError   *error
	InsertError map[meta.Key]error
	DeleteError map[meta.Key]error

	// xxxHook allow you to intercept the standard processing of the mock in
	// order to add your own logic. Return (true, _, _) to prevent the normal
	// execution flow of the mock. Return (false, nil, nil) to continue with
	// normal mock behavior/ after the hook function executes.
	GetHook    func(ctx context.Context, key *meta.Key, m *MockAlphaHealthChecks) (bool, *alpha.HealthCheck, error)
	ListHook   func(ctx context.Context, fl *filter.F, m *MockAlphaHealthChecks) (bool, []*alpha.HealthCheck, error)
	InsertHook func(ctx context.Context, key *meta.Key, obj *alpha.HealthCheck, m *MockAlphaHealthChecks) (bool, error)
	DeleteHook func(ctx context.Context, key *meta.Key, m *MockAlphaHealthChecks) (bool, error)
	UpdateHook func(context.Context, *meta.Key, *alpha.HealthCheck, *MockAlphaHealthChecks) error

	// X is extra state that can be used as part of the mock. Generated code
	// will not use this field.
	X interface{}
}

// Get returns the object from the mock.
func (m *MockAlphaHealthChecks) Get(ctx context.Context, key *meta.Key) (*alpha.HealthCheck, error) {
	if m.GetHook != nil {
		if intercept, obj, err := m.GetHook(ctx, key, m); intercept {
			klog.V(5).Infof("MockAlphaHealthChecks.Get(%v, %s) = %+v, %v", ctx, key, obj, err)
			return obj, err
		}
	}
	if !key.Valid() {
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.GetError[*key]; ok {
		klog.V(5).Infof("MockAlphaHealthChecks.Get(%v, %s) = nil, %v", ctx, key, err)
		return nil, err
	}
	if obj, ok := m.Objects[*key]; ok {
		typedObj := obj.ToAlpha()
		klog.V(5).Infof("MockAlphaHealthChecks.Get(%v, %s) = %+v, nil", ctx, key, typedObj)
		return typedObj, nil
	}

	err := &googleapi.Error{
		Code:    http.StatusNotFound,
		Message: fmt.Sprintf("MockAlphaHealthChecks %v not found", key),
	}
	klog.V(5).Infof("MockAlphaHealthChecks.Get(%v, %s) = nil, %v", ctx, key, err)
	return nil, err
}

// List all of the objects in the mock.
func (m *MockAlphaHealthChecks) List(ctx context.Context, fl *filter.F) ([]*alpha.HealthCheck, error) {
	if m.ListHook != nil {
		if intercept, objs, err := m.ListHook(ctx, fl, m); intercept {
			klog.V(5).Infof("MockAlphaHealthChecks.List(%v, %v) = [%v items], %v", ctx, fl, len(objs), err)
			return objs, err
		}
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if m.ListError != nil {
		err := *m.ListError
		klog.V(5).Infof("MockAlphaHealthChecks.List(%v, %v) = nil, %v", ctx, fl, err)

		return nil, *m.ListError
	}

	var objs []*alpha.HealthCheck
	for _, obj := range m.Objects {
		if !fl.Match(obj.ToAlpha()) {
			continue
		}
		objs = append(objs, obj.ToAlpha())
	}

	klog.V(5).Infof("MockAlphaHealthChecks.List(%v, %v) = [%v items], nil", ctx, fl, len(objs))
	return objs, nil
}

// Insert is a mock for inserting/creating a new object.
func (m *MockAlphaHealthChecks) Insert(ctx context.Context, key *meta.Key, obj *alpha.HealthCheck) error {
	if m.InsertHook != nil {
		if intercept, err := m.InsertHook(ctx, key, obj, m); intercept {
			klog.V(5).Infof("MockAlphaHealthChecks.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.InsertError[*key]; ok {
		klog.V(5).Infof("MockAlphaHealthChecks.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}
	if _, ok := m.Objects[*key]; ok {
		err := &googleapi.Error{
			Code:    http.StatusConflict,
			Message: fmt.Sprintf("MockAlphaHealthChecks %v exists", key),
		}
		klog.V(5).Infof("MockAlphaHealthChecks.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}

	obj.Name = key.Name
	projectID := m.ProjectRouter.ProjectID(ctx, "alpha", "healthChecks")
	obj.SelfLink = SelfLink(meta.VersionAlpha, projectID, "healthChecks", key)

	m.Objects[*key] = &MockHealthChecksObj{obj}
	klog.V(5).Infof("MockAlphaHealthChecks.Insert(%v, %v, %+v) = nil", ctx, key, obj)
	return nil
}

// Delete is a mock for deleting the object.
func (m *MockAlphaHealthChecks) Delete(ctx context.Context, key *meta.Key) error {
	if m.DeleteHook != nil {
		if intercept, err := m.DeleteHook(ctx, key, m); intercept {
			klog.V(5).Infof("MockAlphaHealthChecks.Delete(%v, %v) = %v", ctx, key, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.DeleteError[*key]; ok {
		klog.V(5).Infof("MockAlphaHealthChecks.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}
	if _, ok := m.Objects[*key]; !ok {
		err := &googleapi.Error{
			Code:    http.StatusNotFound,
			Message: fmt.Sprintf("MockAlphaHealthChecks %v not found", key),
		}
		klog.V(5).Infof("MockAlphaHealthChecks.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	delete(m.Objects, *key)
	klog.V(5).Infof("MockAlphaHealthChecks.Delete(%v, %v) = nil", ctx, key)
	return nil
}

// Obj wraps the object for use in the mock.
func (m *MockAlphaHealthChecks) Obj(o *alpha.HealthCheck) *MockHealthChecksObj {
	return &MockHealthChecksObj{o}
}

// Update is a mock for the corresponding method.
func (m *MockAlphaHealthChecks) Update(ctx context.Context, key *meta.Key, arg0 *alpha.HealthCheck) error {
	if m.UpdateHook != nil {
		return m.UpdateHook(ctx, key, arg0, m)
	}
	return nil
}

// GCEAlphaHealthChecks is a simplifying adapter for the GCE HealthChecks.
type GCEAlphaHealthChecks struct {
	s *Service
}

// Get the HealthCheck named by key.
func (g *GCEAlphaHealthChecks) Get(ctx context.Context, key *meta.Key) (*alpha.HealthCheck, error) {
	klog.V(5).Infof("GCEAlphaHealthChecks.Get(%v, %v): called", ctx, key)

	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaHealthChecks.Get(%v, %v): key is invalid (%#v)", ctx, key, key)
		return nil, fmt.Errorf("invalid GCE key (%#v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "alpha", "HealthChecks")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Get",
		Version:   meta.Version("alpha"),
		Service:   "HealthChecks",
	}
	klog.V(5).Infof("GCEAlphaHealthChecks.Get(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEAlphaHealthChecks.Get(%v, %v): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.Alpha.HealthChecks.Get(projectID, key.Name)
	call.Context(ctx)
	v, err := call.Do()
	klog.V(4).Infof("GCEAlphaHealthChecks.Get(%v, %v) = %+v, %v", ctx, key, v, err)
	return v, err
}

// List all HealthCheck objects.
func (g *GCEAlphaHealthChecks) List(ctx context.Context, fl *filter.F) ([]*alpha.HealthCheck, error) {
	klog.V(5).Infof("GCEAlphaHealthChecks.List(%v, %v) called", ctx, fl)
	projectID := g.s.ProjectRouter.ProjectID(ctx, "alpha", "HealthChecks")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "List",
		Version:   meta.Version("alpha"),
		Service:   "HealthChecks",
	}
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		return nil, err
	}
	klog.V(5).Infof("GCEAlphaHealthChecks.List(%v, %v): projectID = %v, rk = %+v", ctx, fl, projectID, rk)
	call := g.s.Alpha.HealthChecks.List(projectID)
	if fl != filter.None {
		call.Filter(fl.String())
	}
	var all []*alpha.HealthCheck
	f := func(l *alpha.HealthCheckList) error {
		klog.V(5).Infof("GCEAlphaHealthChecks.List(%v, ..., %v): page %+v", ctx, fl, l)
		all = append(all, l.Items...)
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		klog.V(4).Infof("GCEAlphaHealthChecks.List(%v, ..., %v) = %v, %v", ctx, fl, nil, err)
		return nil, err
	}

	if klog.V(4).Enabled() {
		klog.V(4).Infof("GCEAlphaHealthChecks.List(%v, ..., %v) = [%v items], %v", ctx, fl, len(all), nil)
	} else if klog.V(5).Enabled() {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		klog.V(5).Infof("GCEAlphaHealthChecks.List(%v, ..., %v) = %v, %v", ctx, fl, asStr, nil)
	}

	return all, nil
}

// Insert HealthCheck with key of value obj.
func (g *GCEAlphaHealthChecks) Insert(ctx context.Context, key *meta.Key, obj *alpha.HealthCheck) error {
	klog.V(5).Infof("GCEAlphaHealthChecks.Insert(%v, %v, %+v): called", ctx, key, obj)
	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaHealthChecks.Insert(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "alpha", "HealthChecks")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Insert",
		Version:   meta.Version("alpha"),
		Service:   "HealthChecks",
	}
	klog.V(5).Infof("GCEAlphaHealthChecks.Insert(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEAlphaHealthChecks.Insert(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	obj.Name = key.Name
	call := g.s.Alpha.HealthChecks.Insert(projectID, obj)
	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCEAlphaHealthChecks.Insert(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEAlphaHealthChecks.Insert(%v, %v, %+v) = %+v", ctx, key, obj, err)
	return err
}

// Delete the HealthCheck referenced by key.
func (g *GCEAlphaHealthChecks) Delete(ctx context.Context, key *meta.Key) error {
	klog.V(5).Infof("GCEAlphaHealthChecks.Delete(%v, %v): called", ctx, key)
	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaHealthChecks.Delete(%v, %v): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "alpha", "HealthChecks")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Delete",
		Version:   meta.Version("alpha"),
		Service:   "HealthChecks",
	}
	klog.V(5).Infof("GCEAlphaHealthChecks.Delete(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEAlphaHealthChecks.Delete(%v, %v): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Alpha.HealthChecks.Delete(projectID, key.Name)

	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCEAlphaHealthChecks.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEAlphaHealthChecks.Delete(%v, %v) = %v", ctx, key, err)
	return err
}

// Update is a method on GCEAlphaHealthChecks.
func (g *GCEAlphaHealthChecks) Update(ctx context.Context, key *meta.Key, arg0 *alpha.HealthCheck) error {
	klog.V(5).Infof("GCEAlphaHealthChecks.Update(%v, %v, ...): called", ctx, key)

	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaHealthChecks.Update(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "alpha", "HealthChecks")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Update",
		Version:   meta.Version("alpha"),
		Service:   "HealthChecks",
	}
	klog.V(5).Infof("GCEAlphaHealthChecks.Update(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)

	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEAlphaHealthChecks.Update(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Alpha.HealthChecks.Update(projectID, key.Name, arg0)
	call.Context(ctx)
	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCEAlphaHealthChecks.Update(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}
	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEAlphaHealthChecks.Update(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// BetaHealthChecks is an interface that allows for mocking of HealthChecks.
type BetaHealthChecks interface {
	Get(ctx context.Context, key *meta.Key) (*beta.HealthCheck, error)
	List(ctx context.Context, fl *filter.F) ([]*beta.HealthCheck, error)
	Insert(ctx context.Context, key *meta.Key, obj *beta.HealthCheck) error
	Delete(ctx context.Context, key *meta.Key) error
	Update(context.Context, *meta.Key, *beta.HealthCheck) error
}

// NewMockBetaHealthChecks returns a new mock for HealthChecks.
func NewMockBetaHealthChecks(pr ProjectRouter, objs map[meta.Key]*MockHealthChecksObj) *MockBetaHealthChecks {
	mock := &MockBetaHealthChecks{
		ProjectRouter: pr,

		Objects:     objs,
		GetError:    map[meta.Key]error{},
		InsertError: map[meta.Key]error{},
		DeleteError: map[meta.Key]error{},
	}
	return mock
}

// MockBetaHealthChecks is the mock for HealthChecks.
type MockBetaHealthChecks struct {
	Lock sync.Mutex

	ProjectRouter ProjectRouter

	// Objects maintained by the mock.
	Objects map[meta.Key]*MockHealthChecksObj

	// If an entry exists for the given key and operation, then the error
	// will be returned instead of the operation.
	GetError    map[meta.Key]error
	ListError   *error
	InsertError map[meta.Key]error
	DeleteError map[meta.Key]error

	// xxxHook allow you to intercept the standard processing of the mock in
	// order to add your own logic. Return (true, _, _) to prevent the normal
	// execution flow of the mock. Return (false, nil, nil) to continue with
	// normal mock behavior/ after the hook function executes.
	GetHook    func(ctx context.Context, key *meta.Key, m *MockBetaHealthChecks) (bool, *beta.HealthCheck, error)
	ListHook   func(ctx context.Context, fl *filter.F, m *MockBetaHealthChecks) (bool, []*beta.HealthCheck, error)
	InsertHook func(ctx context.Context, key *meta.Key, obj *beta.HealthCheck, m *MockBetaHealthChecks) (bool, error)
	DeleteHook func(ctx context.Context, key *meta.Key, m *MockBetaHealthChecks) (bool, error)
	UpdateHook func(context.Context, *meta.Key, *beta.HealthCheck, *MockBetaHealthChecks) error

	// X is extra state that can be used as part of the mock. Generated code
	// will not use this field.
	X interface{}
}

// Get returns the object from the mock.
func (m *MockBetaHealthChecks) Get(ctx context.Context, key *meta.Key) (*beta.HealthCheck, error) {
	if m.GetHook != nil {
		if intercept, obj, err := m.GetHook(ctx, key, m); intercept {
			klog.V(5).Infof("MockBetaHealthChecks.Get(%v, %s) = %+v, %v", ctx, key, obj, err)
			return obj, err
		}
	}
	if !key.Valid() {
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.GetError[*key]; ok {
		klog.V(5).Infof("MockBetaHealthChecks.Get(%v, %s) = nil, %v", ctx, key, err)
		return nil, err
	}
	if obj, ok := m.Objects[*key]; ok {
		typedObj := obj.ToBeta()
		klog.V(5).Infof("MockBetaHealthChecks.Get(%v, %s) = %+v, nil", ctx, key, typedObj)
		return typedObj, nil
	}

	err := &googleapi.Error{
		Code:    http.StatusNotFound,
		Message: fmt.Sprintf("MockBetaHealthChecks %v not found", key),
	}
	klog.V(5).Infof("MockBetaHealthChecks.Get(%v, %s) = nil, %v", ctx, key, err)
	return nil, err
}

// List all of the objects in the mock.
func (m *MockBetaHealthChecks) List(ctx context.Context, fl *filter.F) ([]*beta.HealthCheck, error) {
	if m.ListHook != nil {
		if intercept, objs, err := m.ListHook(ctx, fl, m); intercept {
			klog.V(5).Infof("MockBetaHealthChecks.List(%v, %v) = [%v items], %v", ctx, fl, len(objs), err)
			return objs, err
		}
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if m.ListError != nil {
		err := *m.ListError
		klog.V(5).Infof("MockBetaHealthChecks.List(%v, %v) = nil, %v", ctx, fl, err)

		return nil, *m.ListError
	}

	var objs []*beta.HealthCheck
	for _, obj := range m.Objects {
		if !fl.Match(obj.ToBeta()) {
			continue
		}
		objs = append(objs, obj.ToBeta())
	}

	klog.V(5).Infof("MockBetaHealthChecks.List(%v, %v) = [%v items], nil", ctx, fl, len(objs))
	return objs, nil
}

// Insert is a mock for inserting/creating a new object.
func (m *MockBetaHealthChecks) Insert(ctx context.Context, key *meta.Key, obj *beta.HealthCheck) error {
	if m.InsertHook != nil {
		if intercept, err := m.InsertHook(ctx, key, obj, m); intercept {
			klog.V(5).Infof("MockBetaHealthChecks.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.InsertError[*key]; ok {
		klog.V(5).Infof("MockBetaHealthChecks.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}
	if _, ok := m.Objects[*key]; ok {
		err := &googleapi.Error{
			Code:    http.StatusConflict,
			Message: fmt.Sprintf("MockBetaHealthChecks %v exists", key),
		}
		klog.V(5).Infof("MockBetaHealthChecks.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}

	obj.Name = key.Name
	projectID := m.ProjectRouter.ProjectID(ctx, "beta", "healthChecks")
	obj.SelfLink = SelfLink(meta.VersionBeta, projectID, "healthChecks", key)

	m.Objects[*key] = &MockHealthChecksObj{obj}
	klog.V(5).Infof("MockBetaHealthChecks.Insert(%v, %v, %+v) = nil", ctx, key, obj)
	return nil
}

// Delete is a mock for deleting the object.
func (m *MockBetaHealthChecks) Delete(ctx context.Context, key *meta.Key) error {
	if m.DeleteHook != nil {
		if intercept, err := m.DeleteHook(ctx, key, m); intercept {
			klog.V(5).Infof("MockBetaHealthChecks.Delete(%v, %v) = %v", ctx, key, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.DeleteError[*key]; ok {
		klog.V(5).Infof("MockBetaHealthChecks.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}
	if _, ok := m.Objects[*key]; !ok {
		err := &googleapi.Error{
			Code:    http.StatusNotFound,
			Message: fmt.Sprintf("MockBetaHealthChecks %v not found", key),
		}
		klog.V(5).Infof("MockBetaHealthChecks.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	delete(m.Objects, *key)
	klog.V(5).Infof("MockBetaHealthChecks.Delete(%v, %v) = nil", ctx, key)
	return nil
}

// Obj wraps the object for use in the mock.
func (m *MockBetaHealthChecks) Obj(o *beta.HealthCheck) *MockHealthChecksObj {
	return &MockHealthChecksObj{o}
}

// Update is a mock for the corresponding method.
func (m *MockBetaHealthChecks) Update(ctx context.Context, key *meta.Key, arg0 *beta.HealthCheck) error {
	if m.UpdateHook != nil {
		return m.UpdateHook(ctx, key, arg0, m)
	}
	return nil
}

// GCEBetaHealthChecks is a simplifying adapter for the GCE HealthChecks.
type GCEBetaHealthChecks struct {
	s *Service
}

// Get the HealthCheck named by key.
func (g *GCEBetaHealthChecks) Get(ctx context.Context, key *meta.Key) (*beta.HealthCheck, error) {
	klog.V(5).Infof("GCEBetaHealthChecks.Get(%v, %v): called", ctx, key)

	if !key.Valid() {
		klog.V(2).Infof("GCEBetaHealthChecks.Get(%v, %v): key is invalid (%#v)", ctx, key, key)
		return nil, fmt.Errorf("invalid GCE key (%#v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "beta", "HealthChecks")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Get",
		Version:   meta.Version("beta"),
		Service:   "HealthChecks",
	}
	klog.V(5).Infof("GCEBetaHealthChecks.Get(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEBetaHealthChecks.Get(%v, %v): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.Beta.HealthChecks.Get(projectID, key.Name)
	call.Context(ctx)
	v, err := call.Do()
	klog.V(4).Infof("GCEBetaHealthChecks.Get(%v, %v) = %+v, %v", ctx, key, v, err)
	return v, err
}

// List all HealthCheck objects.
func (g *GCEBetaHealthChecks) List(ctx context.Context, fl *filter.F) ([]*beta.HealthCheck, error) {
	klog.V(5).Infof("GCEBetaHealthChecks.List(%v, %v) called", ctx, fl)
	projectID := g.s.ProjectRouter.ProjectID(ctx, "beta", "HealthChecks")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "List",
		Version:   meta.Version("beta"),
		Service:   "HealthChecks",
	}
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		return nil, err
	}
	klog.V(5).Infof("GCEBetaHealthChecks.List(%v, %v): projectID = %v, rk = %+v", ctx, fl, projectID, rk)
	call := g.s.Beta.HealthChecks.List(projectID)
	if fl != filter.None {
		call.Filter(fl.String())
	}
	var all []*beta.HealthCheck
	f := func(l *beta.HealthCheckList) error {
		klog.V(5).Infof("GCEBetaHealthChecks.List(%v, ..., %v): page %+v", ctx, fl, l)
		all = append(all, l.Items...)
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		klog.V(4).Infof("GCEBetaHealthChecks.List(%v, ..., %v) = %v, %v", ctx, fl, nil, err)
		return nil, err
	}

	if klog.V(4).Enabled() {
		klog.V(4).Infof("GCEBetaHealthChecks.List(%v, ..., %v) = [%v items], %v", ctx, fl, len(all), nil)
	} else if klog.V(5).Enabled() {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		klog.V(5).Infof("GCEBetaHealthChecks.List(%v, ..., %v) = %v, %v", ctx, fl, asStr, nil)
	}

	return all, nil
}

// Insert HealthCheck with key of value obj.
func (g *GCEBetaHealthChecks) Insert(ctx context.Context, key *meta.Key, obj *beta.HealthCheck) error {
	klog.V(5).Infof("GCEBetaHealthChecks.Insert(%v, %v, %+v): called", ctx, key, obj)
	if !key.Valid() {
		klog.V(2).Infof("GCEBetaHealthChecks.Insert(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "beta", "HealthChecks")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Insert",
		Version:   meta.Version("beta"),
		Service:   "HealthChecks",
	}
	klog.V(5).Infof("GCEBetaHealthChecks.Insert(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEBetaHealthChecks.Insert(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	obj.Name = key.Name
	call := g.s.Beta.HealthChecks.Insert(projectID, obj)
	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCEBetaHealthChecks.Insert(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEBetaHealthChecks.Insert(%v, %v, %+v) = %+v", ctx, key, obj, err)
	return err
}

// Delete the HealthCheck referenced by key.
func (g *GCEBetaHealthChecks) Delete(ctx context.Context, key *meta.Key) error {
	klog.V(5).Infof("GCEBetaHealthChecks.Delete(%v, %v): called", ctx, key)
	if !key.Valid() {
		klog.V(2).Infof("GCEBetaHealthChecks.Delete(%v, %v): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "beta", "HealthChecks")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Delete",
		Version:   meta.Version("beta"),
		Service:   "HealthChecks",
	}
	klog.V(5).Infof("GCEBetaHealthChecks.Delete(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEBetaHealthChecks.Delete(%v, %v): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Beta.HealthChecks.Delete(projectID, key.Name)

	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCEBetaHealthChecks.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEBetaHealthChecks.Delete(%v, %v) = %v", ctx, key, err)
	return err
}

// Update is a method on GCEBetaHealthChecks.
func (g *GCEBetaHealthChecks) Update(ctx context.Context, key *meta.Key, arg0 *beta.HealthCheck) error {
	klog.V(5).Infof("GCEBetaHealthChecks.Update(%v, %v, ...): called", ctx, key)

	if !key.Valid() {
		klog.V(2).Infof("GCEBetaHealthChecks.Update(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "beta", "HealthChecks")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Update",
		Version:   meta.Version("beta"),
		Service:   "HealthChecks",
	}
	klog.V(5).Infof("GCEBetaHealthChecks.Update(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)

	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEBetaHealthChecks.Update(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Beta.HealthChecks.Update(projectID, key.Name, arg0)
	call.Context(ctx)
	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCEBetaHealthChecks.Update(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}
	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEBetaHealthChecks.Update(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// AlphaRegionHealthChecks is an interface that allows for mocking of RegionHealthChecks.
type AlphaRegionHealthChecks interface {
	Get(ctx context.Context, key *meta.Key) (*alpha.HealthCheck, error)
	List(ctx context.Context, region string, fl *filter.F) ([]*alpha.HealthCheck, error)
	Insert(ctx context.Context, key *meta.Key, obj *alpha.HealthCheck) error
	Delete(ctx context.Context, key *meta.Key) error
	Update(context.Context, *meta.Key, *alpha.HealthCheck) error
}

// NewMockAlphaRegionHealthChecks returns a new mock for RegionHealthChecks.
func NewMockAlphaRegionHealthChecks(pr ProjectRouter, objs map[meta.Key]*MockRegionHealthChecksObj) *MockAlphaRegionHealthChecks {
	mock := &MockAlphaRegionHealthChecks{
		ProjectRouter: pr,

		Objects:     objs,
		GetError:    map[meta.Key]error{},
		InsertError: map[meta.Key]error{},
		DeleteError: map[meta.Key]error{},
	}
	return mock
}

// MockAlphaRegionHealthChecks is the mock for RegionHealthChecks.
type MockAlphaRegionHealthChecks struct {
	Lock sync.Mutex

	ProjectRouter ProjectRouter

	// Objects maintained by the mock.
	Objects map[meta.Key]*MockRegionHealthChecksObj

	// If an entry exists for the given key and operation, then the error
	// will be returned instead of the operation.
	GetError    map[meta.Key]error
	ListError   *error
	InsertError map[meta.Key]error
	DeleteError map[meta.Key]error

	// xxxHook allow you to intercept the standard processing of the mock in
	// order to add your own logic. Return (true, _, _) to prevent the normal
	// execution flow of the mock. Return (false, nil, nil) to continue with
	// normal mock behavior/ after the hook function executes.
	GetHook    func(ctx context.Context, key *meta.Key, m *MockAlphaRegionHealthChecks) (bool, *alpha.HealthCheck, error)
	ListHook   func(ctx context.Context, region string, fl *filter.F, m *MockAlphaRegionHealthChecks) (bool, []*alpha.HealthCheck, error)
	InsertHook func(ctx context.Context, key *meta.Key, obj *alpha.HealthCheck, m *MockAlphaRegionHealthChecks) (bool, error)
	DeleteHook func(ctx context.Context, key *meta.Key, m *MockAlphaRegionHealthChecks) (bool, error)
	UpdateHook func(context.Context, *meta.Key, *alpha.HealthCheck, *MockAlphaRegionHealthChecks) error

	// X is extra state that can be used as part of the mock. Generated code
	// will not use this field.
	X interface{}
}

// Get returns the object from the mock.
func (m *MockAlphaRegionHealthChecks) Get(ctx context.Context, key *meta.Key) (*alpha.HealthCheck, error) {
	if m.GetHook != nil {
		if intercept, obj, err := m.GetHook(ctx, key, m); intercept {
			klog.V(5).Infof("MockAlphaRegionHealthChecks.Get(%v, %s) = %+v, %v", ctx, key, obj, err)
			return obj, err
		}
	}
	if !key.Valid() {
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.GetError[*key]; ok {
		klog.V(5).Infof("MockAlphaRegionHealthChecks.Get(%v, %s) = nil, %v", ctx, key, err)
		return nil, err
	}
	if obj, ok := m.Objects[*key]; ok {
		typedObj := obj.ToAlpha()
		klog.V(5).Infof("MockAlphaRegionHealthChecks.Get(%v, %s) = %+v, nil", ctx, key, typedObj)
		return typedObj, nil
	}

	err := &googleapi.Error{
		Code:    http.StatusNotFound,
		Message: fmt.Sprintf("MockAlphaRegionHealthChecks %v not found", key),
	}
	klog.V(5).Infof("MockAlphaRegionHealthChecks.Get(%v, %s) = nil, %v", ctx, key, err)
	return nil, err
}

// List all of the objects in the mock in the given region.
func (m *MockAlphaRegionHealthChecks) List(ctx context.Context, region string, fl *filter.F) ([]*alpha.HealthCheck, error) {
	if m.ListHook != nil {
		if intercept, objs, err := m.ListHook(ctx, region, fl, m); intercept {
			klog.V(5).Infof("MockAlphaRegionHealthChecks.List(%v, %q, %v) = [%v items], %v", ctx, region, fl, len(objs), err)
			return objs, err
		}
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if m.ListError != nil {
		err := *m.ListError
		klog.V(5).Infof("MockAlphaRegionHealthChecks.List(%v, %q, %v) = nil, %v", ctx, region, fl, err)

		return nil, *m.ListError
	}

	var objs []*alpha.HealthCheck
	for key, obj := range m.Objects {
		if key.Region != region {
			continue
		}
		if !fl.Match(obj.ToAlpha()) {
			continue
		}
		objs = append(objs, obj.ToAlpha())
	}

	klog.V(5).Infof("MockAlphaRegionHealthChecks.List(%v, %q, %v) = [%v items], nil", ctx, region, fl, len(objs))
	return objs, nil
}

// Insert is a mock for inserting/creating a new object.
func (m *MockAlphaRegionHealthChecks) Insert(ctx context.Context, key *meta.Key, obj *alpha.HealthCheck) error {
	if m.InsertHook != nil {
		if intercept, err := m.InsertHook(ctx, key, obj, m); intercept {
			klog.V(5).Infof("MockAlphaRegionHealthChecks.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.InsertError[*key]; ok {
		klog.V(5).Infof("MockAlphaRegionHealthChecks.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}
	if _, ok := m.Objects[*key]; ok {
		err := &googleapi.Error{
			Code:    http.StatusConflict,
			Message: fmt.Sprintf("MockAlphaRegionHealthChecks %v exists", key),
		}
		klog.V(5).Infof("MockAlphaRegionHealthChecks.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}

	obj.Name = key.Name
	projectID := m.ProjectRouter.ProjectID(ctx, "alpha", "healthChecks")
	obj.SelfLink = SelfLink(meta.VersionAlpha, projectID, "healthChecks", key)

	m.Objects[*key] = &MockRegionHealthChecksObj{obj}
	klog.V(5).Infof("MockAlphaRegionHealthChecks.Insert(%v, %v, %+v) = nil", ctx, key, obj)
	return nil
}

// Delete is a mock for deleting the object.
func (m *MockAlphaRegionHealthChecks) Delete(ctx context.Context, key *meta.Key) error {
	if m.DeleteHook != nil {
		if intercept, err := m.DeleteHook(ctx, key, m); intercept {
			klog.V(5).Infof("MockAlphaRegionHealthChecks.Delete(%v, %v) = %v", ctx, key, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.DeleteError[*key]; ok {
		klog.V(5).Infof("MockAlphaRegionHealthChecks.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}
	if _, ok := m.Objects[*key]; !ok {
		err := &googleapi.Error{
			Code:    http.StatusNotFound,
			Message: fmt.Sprintf("MockAlphaRegionHealthChecks %v not found", key),
		}
		klog.V(5).Infof("MockAlphaRegionHealthChecks.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	delete(m.Objects, *key)
	klog.V(5).Infof("MockAlphaRegionHealthChecks.Delete(%v, %v) = nil", ctx, key)
	return nil
}

// Obj wraps the object for use in the mock.
func (m *MockAlphaRegionHealthChecks) Obj(o *alpha.HealthCheck) *MockRegionHealthChecksObj {
	return &MockRegionHealthChecksObj{o}
}

// Update is a mock for the corresponding method.
func (m *MockAlphaRegionHealthChecks) Update(ctx context.Context, key *meta.Key, arg0 *alpha.HealthCheck) error {
	if m.UpdateHook != nil {
		return m.UpdateHook(ctx, key, arg0, m)
	}
	return nil
}

// GCEAlphaRegionHealthChecks is a simplifying adapter for the GCE RegionHealthChecks.
type GCEAlphaRegionHealthChecks struct {
	s *Service
}

// Get the HealthCheck named by key.
func (g *GCEAlphaRegionHealthChecks) Get(ctx context.Context, key *meta.Key) (*alpha.HealthCheck, error) {
	klog.V(5).Infof("GCEAlphaRegionHealthChecks.Get(%v, %v): called", ctx, key)

	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaRegionHealthChecks.Get(%v, %v): key is invalid (%#v)", ctx, key, key)
		return nil, fmt.Errorf("invalid GCE key (%#v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "alpha", "RegionHealthChecks")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Get",
		Version:   meta.Version("alpha"),
		Service:   "RegionHealthChecks",
	}
	klog.V(5).Infof("GCEAlphaRegionHealthChecks.Get(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEAlphaRegionHealthChecks.Get(%v, %v): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.Alpha.RegionHealthChecks.Get(projectID, key.Region, key.Name)
	call.Context(ctx)
	v, err := call.Do()
	klog.V(4).Infof("GCEAlphaRegionHealthChecks.Get(%v, %v) = %+v, %v", ctx, key, v, err)
	return v, err
}

// List all HealthCheck objects.
func (g *GCEAlphaRegionHealthChecks) List(ctx context.Context, region string, fl *filter.F) ([]*alpha.HealthCheck, error) {
	klog.V(5).Infof("GCEAlphaRegionHealthChecks.List(%v, %v, %v) called", ctx, region, fl)
	projectID := g.s.ProjectRouter.ProjectID(ctx, "alpha", "RegionHealthChecks")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "List",
		Version:   meta.Version("alpha"),
		Service:   "RegionHealthChecks",
	}
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		return nil, err
	}
	klog.V(5).Infof("GCEAlphaRegionHealthChecks.List(%v, %v, %v): projectID = %v, rk = %+v", ctx, region, fl, projectID, rk)
	call := g.s.Alpha.RegionHealthChecks.List(projectID, region)
	if fl != filter.None {
		call.Filter(fl.String())
	}
	var all []*alpha.HealthCheck
	f := func(l *alpha.HealthCheckList) error {
		klog.V(5).Infof("GCEAlphaRegionHealthChecks.List(%v, ..., %v): page %+v", ctx, fl, l)
		all = append(all, l.Items...)
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		klog.V(4).Infof("GCEAlphaRegionHealthChecks.List(%v, ..., %v) = %v, %v", ctx, fl, nil, err)
		return nil, err
	}

	if klog.V(4).Enabled() {
		klog.V(4).Infof("GCEAlphaRegionHealthChecks.List(%v, ..., %v) = [%v items], %v", ctx, fl, len(all), nil)
	} else if klog.V(5).Enabled() {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		klog.V(5).Infof("GCEAlphaRegionHealthChecks.List(%v, ..., %v) = %v, %v", ctx, fl, asStr, nil)
	}

	return all, nil
}

// Insert HealthCheck with key of value obj.
func (g *GCEAlphaRegionHealthChecks) Insert(ctx context.Context, key *meta.Key, obj *alpha.HealthCheck) error {
	klog.V(5).Infof("GCEAlphaRegionHealthChecks.Insert(%v, %v, %+v): called", ctx, key, obj)
	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaRegionHealthChecks.Insert(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "alpha", "RegionHealthChecks")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Insert",
		Version:   meta.Version("alpha"),
		Service:   "RegionHealthChecks",
	}
	klog.V(5).Infof("GCEAlphaRegionHealthChecks.Insert(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEAlphaRegionHealthChecks.Insert(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	obj.Name = key.Name
	call := g.s.Alpha.RegionHealthChecks.Insert(projectID, key.Region, obj)
	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCEAlphaRegionHealthChecks.Insert(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEAlphaRegionHealthChecks.Insert(%v, %v, %+v) = %+v", ctx, key, obj, err)
	return err
}

// Delete the HealthCheck referenced by key.
func (g *GCEAlphaRegionHealthChecks) Delete(ctx context.Context, key *meta.Key) error {
	klog.V(5).Infof("GCEAlphaRegionHealthChecks.Delete(%v, %v): called", ctx, key)
	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaRegionHealthChecks.Delete(%v, %v): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "alpha", "RegionHealthChecks")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Delete",
		Version:   meta.Version("alpha"),
		Service:   "RegionHealthChecks",
	}
	klog.V(5).Infof("GCEAlphaRegionHealthChecks.Delete(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEAlphaRegionHealthChecks.Delete(%v, %v): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Alpha.RegionHealthChecks.Delete(projectID, key.Region, key.Name)
	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCEAlphaRegionHealthChecks.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEAlphaRegionHealthChecks.Delete(%v, %v) = %v", ctx, key, err)
	return err
}

// Update is a method on GCEAlphaRegionHealthChecks.
func (g *GCEAlphaRegionHealthChecks) Update(ctx context.Context, key *meta.Key, arg0 *alpha.HealthCheck) error {
	klog.V(5).Infof("GCEAlphaRegionHealthChecks.Update(%v, %v, ...): called", ctx, key)

	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaRegionHealthChecks.Update(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "alpha", "RegionHealthChecks")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Update",
		Version:   meta.Version("alpha"),
		Service:   "RegionHealthChecks",
	}
	klog.V(5).Infof("GCEAlphaRegionHealthChecks.Update(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)

	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEAlphaRegionHealthChecks.Update(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Alpha.RegionHealthChecks.Update(projectID, key.Region, key.Name, arg0)
	call.Context(ctx)
	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCEAlphaRegionHealthChecks.Update(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}
	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEAlphaRegionHealthChecks.Update(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// BetaRegionHealthChecks is an interface that allows for mocking of RegionHealthChecks.
type BetaRegionHealthChecks interface {
	Get(ctx context.Context, key *meta.Key) (*beta.HealthCheck, error)
	List(ctx context.Context, region string, fl *filter.F) ([]*beta.HealthCheck, error)
	Insert(ctx context.Context, key *meta.Key, obj *beta.HealthCheck) error
	Delete(ctx context.Context, key *meta.Key) error
	Update(context.Context, *meta.Key, *beta.HealthCheck) error
}

// NewMockBetaRegionHealthChecks returns a new mock for RegionHealthChecks.
func NewMockBetaRegionHealthChecks(pr ProjectRouter, objs map[meta.Key]*MockRegionHealthChecksObj) *MockBetaRegionHealthChecks {
	mock := &MockBetaRegionHealthChecks{
		ProjectRouter: pr,

		Objects:     objs,
		GetError:    map[meta.Key]error{},
		InsertError: map[meta.Key]error{},
		DeleteError: map[meta.Key]error{},
	}
	return mock
}

// MockBetaRegionHealthChecks is the mock for RegionHealthChecks.
type MockBetaRegionHealthChecks struct {
	Lock sync.Mutex

	ProjectRouter ProjectRouter

	// Objects maintained by the mock.
	Objects map[meta.Key]*MockRegionHealthChecksObj

	// If an entry exists for the given key and operation, then the error
	// will be returned instead of the operation.
	GetError    map[meta.Key]error
	ListError   *error
	InsertError map[meta.Key]error
	DeleteError map[meta.Key]error

	// xxxHook allow you to intercept the standard processing of the mock in
	// order to add your own logic. Return (true, _, _) to prevent the normal
	// execution flow of the mock. Return (false, nil, nil) to continue with
	// normal mock behavior/ after the hook function executes.
	GetHook    func(ctx context.Context, key *meta.Key, m *MockBetaRegionHealthChecks) (bool, *beta.HealthCheck, error)
	ListHook   func(ctx context.Context, region string, fl *filter.F, m *MockBetaRegionHealthChecks) (bool, []*beta.HealthCheck, error)
	InsertHook func(ctx context.Context, key *meta.Key, obj *beta.HealthCheck, m *MockBetaRegionHealthChecks) (bool, error)
	DeleteHook func(ctx context.Context, key *meta.Key, m *MockBetaRegionHealthChecks) (bool, error)
	UpdateHook func(context.Context, *meta.Key, *beta.HealthCheck, *MockBetaRegionHealthChecks) error

	// X is extra state that can be used as part of the mock. Generated code
	// will not use this field.
	X interface{}
}

// Get returns the object from the mock.
func (m *MockBetaRegionHealthChecks) Get(ctx context.Context, key *meta.Key) (*beta.HealthCheck, error) {
	if m.GetHook != nil {
		if intercept, obj, err := m.GetHook(ctx, key, m); intercept {
			klog.V(5).Infof("MockBetaRegionHealthChecks.Get(%v, %s) = %+v, %v", ctx, key, obj, err)
			return obj, err
		}
	}
	if !key.Valid() {
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.GetError[*key]; ok {
		klog.V(5).Infof("MockBetaRegionHealthChecks.Get(%v, %s) = nil, %v", ctx, key, err)
		return nil, err
	}
	if obj, ok := m.Objects[*key]; ok {
		typedObj := obj.ToBeta()
		klog.V(5).Infof("MockBetaRegionHealthChecks.Get(%v, %s) = %+v, nil", ctx, key, typedObj)
		return typedObj, nil
	}

	err := &googleapi.Error{
		Code:    http.StatusNotFound,
		Message: fmt.Sprintf("MockBetaRegionHealthChecks %v not found", key),
	}
	klog.V(5).Infof("MockBetaRegionHealthChecks.Get(%v, %s) = nil, %v", ctx, key, err)
	return nil, err
}

// List all of the objects in the mock in the given region.
func (m *MockBetaRegionHealthChecks) List(ctx context.Context, region string, fl *filter.F) ([]*beta.HealthCheck, error) {
	if m.ListHook != nil {
		if intercept, objs, err := m.ListHook(ctx, region, fl, m); intercept {
			klog.V(5).Infof("MockBetaRegionHealthChecks.List(%v, %q, %v) = [%v items], %v", ctx, region, fl, len(objs), err)
			return objs, err
		}
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if m.ListError != nil {
		err := *m.ListError
		klog.V(5).Infof("MockBetaRegionHealthChecks.List(%v, %q, %v) = nil, %v", ctx, region, fl, err)

		return nil, *m.ListError
	}

	var objs []*beta.HealthCheck
	for key, obj := range m.Objects {
		if key.Region != region {
			continue
		}
		if !fl.Match(obj.ToBeta()) {
			continue
		}
		objs = append(objs, obj.ToBeta())
	}

	klog.V(5).Infof("MockBetaRegionHealthChecks.List(%v, %q, %v) = [%v items], nil", ctx, region, fl, len(objs))
	return objs, nil
}

// Insert is a mock for inserting/creating a new object.
func (m *MockBetaRegionHealthChecks) Insert(ctx context.Context, key *meta.Key, obj *beta.HealthCheck) error {
	if m.InsertHook != nil {
		if intercept, err := m.InsertHook(ctx, key, obj, m); intercept {
			klog.V(5).Infof("MockBetaRegionHealthChecks.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.InsertError[*key]; ok {
		klog.V(5).Infof("MockBetaRegionHealthChecks.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}
	if _, ok := m.Objects[*key]; ok {
		err := &googleapi.Error{
			Code:    http.StatusConflict,
			Message: fmt.Sprintf("MockBetaRegionHealthChecks %v exists", key),
		}
		klog.V(5).Infof("MockBetaRegionHealthChecks.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}

	obj.Name = key.Name
	projectID := m.ProjectRouter.ProjectID(ctx, "beta", "healthChecks")
	obj.SelfLink = SelfLink(meta.VersionBeta, projectID, "healthChecks", key)

	m.Objects[*key] = &MockRegionHealthChecksObj{obj}
	klog.V(5).Infof("MockBetaRegionHealthChecks.Insert(%v, %v, %+v) = nil", ctx, key, obj)
	return nil
}

// Delete is a mock for deleting the object.
func (m *MockBetaRegionHealthChecks) Delete(ctx context.Context, key *meta.Key) error {
	if m.DeleteHook != nil {
		if intercept, err := m.DeleteHook(ctx, key, m); intercept {
			klog.V(5).Infof("MockBetaRegionHealthChecks.Delete(%v, %v) = %v", ctx, key, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.DeleteError[*key]; ok {
		klog.V(5).Infof("MockBetaRegionHealthChecks.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}
	if _, ok := m.Objects[*key]; !ok {
		err := &googleapi.Error{
			Code:    http.StatusNotFound,
			Message: fmt.Sprintf("MockBetaRegionHealthChecks %v not found", key),
		}
		klog.V(5).Infof("MockBetaRegionHealthChecks.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	delete(m.Objects, *key)
	klog.V(5).Infof("MockBetaRegionHealthChecks.Delete(%v, %v) = nil", ctx, key)
	return nil
}

// Obj wraps the object for use in the mock.
func (m *MockBetaRegionHealthChecks) Obj(o *beta.HealthCheck) *MockRegionHealthChecksObj {
	return &MockRegionHealthChecksObj{o}
}

// Update is a mock for the corresponding method.
func (m *MockBetaRegionHealthChecks) Update(ctx context.Context, key *meta.Key, arg0 *beta.HealthCheck) error {
	if m.UpdateHook != nil {
		return m.UpdateHook(ctx, key, arg0, m)
	}
	return nil
}

// GCEBetaRegionHealthChecks is a simplifying adapter for the GCE RegionHealthChecks.
type GCEBetaRegionHealthChecks struct {
	s *Service
}

// Get the HealthCheck named by key.
func (g *GCEBetaRegionHealthChecks) Get(ctx context.Context, key *meta.Key) (*beta.HealthCheck, error) {
	klog.V(5).Infof("GCEBetaRegionHealthChecks.Get(%v, %v): called", ctx, key)

	if !key.Valid() {
		klog.V(2).Infof("GCEBetaRegionHealthChecks.Get(%v, %v): key is invalid (%#v)", ctx, key, key)
		return nil, fmt.Errorf("invalid GCE key (%#v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "beta", "RegionHealthChecks")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Get",
		Version:   meta.Version("beta"),
		Service:   "RegionHealthChecks",
	}
	klog.V(5).Infof("GCEBetaRegionHealthChecks.Get(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEBetaRegionHealthChecks.Get(%v, %v): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.Beta.RegionHealthChecks.Get(projectID, key.Region, key.Name)
	call.Context(ctx)
	v, err := call.Do()
	klog.V(4).Infof("GCEBetaRegionHealthChecks.Get(%v, %v) = %+v, %v", ctx, key, v, err)
	return v, err
}

// List all HealthCheck objects.
func (g *GCEBetaRegionHealthChecks) List(ctx context.Context, region string, fl *filter.F) ([]*beta.HealthCheck, error) {
	klog.V(5).Infof("GCEBetaRegionHealthChecks.List(%v, %v, %v) called", ctx, region, fl)
	projectID := g.s.ProjectRouter.ProjectID(ctx, "beta", "RegionHealthChecks")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "List",
		Version:   meta.Version("beta"),
		Service:   "RegionHealthChecks",
	}
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		return nil, err
	}
	klog.V(5).Infof("GCEBetaRegionHealthChecks.List(%v, %v, %v): projectID = %v, rk = %+v", ctx, region, fl, projectID, rk)
	call := g.s.Beta.RegionHealthChecks.List(projectID, region)
	if fl != filter.None {
		call.Filter(fl.String())
	}
	var all []*beta.HealthCheck
	f := func(l *beta.HealthCheckList) error {
		klog.V(5).Infof("GCEBetaRegionHealthChecks.List(%v, ..., %v): page %+v", ctx, fl, l)
		all = append(all, l.Items...)
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		klog.V(4).Infof("GCEBetaRegionHealthChecks.List(%v, ..., %v) = %v, %v", ctx, fl, nil, err)
		return nil, err
	}

	if klog.V(4).Enabled() {
		klog.V(4).Infof("GCEBetaRegionHealthChecks.List(%v, ..., %v) = [%v items], %v", ctx, fl, len(all), nil)
	} else if klog.V(5).Enabled() {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		klog.V(5).Infof("GCEBetaRegionHealthChecks.List(%v, ..., %v) = %v, %v", ctx, fl, asStr, nil)
	}

	return all, nil
}

// Insert HealthCheck with key of value obj.
func (g *GCEBetaRegionHealthChecks) Insert(ctx context.Context, key *meta.Key, obj *beta.HealthCheck) error {
	klog.V(5).Infof("GCEBetaRegionHealthChecks.Insert(%v, %v, %+v): called", ctx, key, obj)
	if !key.Valid() {
		klog.V(2).Infof("GCEBetaRegionHealthChecks.Insert(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "beta", "RegionHealthChecks")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Insert",
		Version:   meta.Version("beta"),
		Service:   "RegionHealthChecks",
	}
	klog.V(5).Infof("GCEBetaRegionHealthChecks.Insert(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEBetaRegionHealthChecks.Insert(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	obj.Name = key.Name
	call := g.s.Beta.RegionHealthChecks.Insert(projectID, key.Region, obj)
	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCEBetaRegionHealthChecks.Insert(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEBetaRegionHealthChecks.Insert(%v, %v, %+v) = %+v", ctx, key, obj, err)
	return err
}

// Delete the HealthCheck referenced by key.
func (g *GCEBetaRegionHealthChecks) Delete(ctx context.Context, key *meta.Key) error {
	klog.V(5).Infof("GCEBetaRegionHealthChecks.Delete(%v, %v): called", ctx, key)
	if !key.Valid() {
		klog.V(2).Infof("GCEBetaRegionHealthChecks.Delete(%v, %v): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "beta", "RegionHealthChecks")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Delete",
		Version:   meta.Version("beta"),
		Service:   "RegionHealthChecks",
	}
	klog.V(5).Infof("GCEBetaRegionHealthChecks.Delete(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEBetaRegionHealthChecks.Delete(%v, %v): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Beta.RegionHealthChecks.Delete(projectID, key.Region, key.Name)
	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCEBetaRegionHealthChecks.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEBetaRegionHealthChecks.Delete(%v, %v) = %v", ctx, key, err)
	return err
}

// Update is a method on GCEBetaRegionHealthChecks.
func (g *GCEBetaRegionHealthChecks) Update(ctx context.Context, key *meta.Key, arg0 *beta.HealthCheck) error {
	klog.V(5).Infof("GCEBetaRegionHealthChecks.Update(%v, %v, ...): called", ctx, key)

	if !key.Valid() {
		klog.V(2).Infof("GCEBetaRegionHealthChecks.Update(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "beta", "RegionHealthChecks")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Update",
		Version:   meta.Version("beta"),
		Service:   "RegionHealthChecks",
	}
	klog.V(5).Infof("GCEBetaRegionHealthChecks.Update(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)

	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEBetaRegionHealthChecks.Update(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Beta.RegionHealthChecks.Update(projectID, key.Region, key.Name, arg0)
	call.Context(ctx)
	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCEBetaRegionHealthChecks.Update(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}
	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEBetaRegionHealthChecks.Update(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// RegionHealthChecks is an interface that allows for mocking of RegionHealthChecks.
type RegionHealthChecks interface {
	Get(ctx context.Context, key *meta.Key) (*ga.HealthCheck, error)
	List(ctx context.Context, region string, fl *filter.F) ([]*ga.HealthCheck, error)
	Insert(ctx context.Context, key *meta.Key, obj *ga.HealthCheck) error
	Delete(ctx context.Context, key *meta.Key) error
	Update(context.Context, *meta.Key, *ga.HealthCheck) error
}

// NewMockRegionHealthChecks returns a new mock for RegionHealthChecks.
func NewMockRegionHealthChecks(pr ProjectRouter, objs map[meta.Key]*MockRegionHealthChecksObj) *MockRegionHealthChecks {
	mock := &MockRegionHealthChecks{
		ProjectRouter: pr,

		Objects:     objs,
		GetError:    map[meta.Key]error{},
		InsertError: map[meta.Key]error{},
		DeleteError: map[meta.Key]error{},
	}
	return mock
}

// MockRegionHealthChecks is the mock for RegionHealthChecks.
type MockRegionHealthChecks struct {
	Lock sync.Mutex

	ProjectRouter ProjectRouter

	// Objects maintained by the mock.
	Objects map[meta.Key]*MockRegionHealthChecksObj

	// If an entry exists for the given key and operation, then the error
	// will be returned instead of the operation.
	GetError    map[meta.Key]error
	ListError   *error
	InsertError map[meta.Key]error
	DeleteError map[meta.Key]error

	// xxxHook allow you to intercept the standard processing of the mock in
	// order to add your own logic. Return (true, _, _) to prevent the normal
	// execution flow of the mock. Return (false, nil, nil) to continue with
	// normal mock behavior/ after the hook function executes.
	GetHook    func(ctx context.Context, key *meta.Key, m *MockRegionHealthChecks) (bool, *ga.HealthCheck, error)
	ListHook   func(ctx context.Context, region string, fl *filter.F, m *MockRegionHealthChecks) (bool, []*ga.HealthCheck, error)
	InsertHook func(ctx context.Context, key *meta.Key, obj *ga.HealthCheck, m *MockRegionHealthChecks) (bool, error)
	DeleteHook func(ctx context.Context, key *meta.Key, m *MockRegionHealthChecks) (bool, error)
	UpdateHook func(context.Context, *meta.Key, *ga.HealthCheck, *MockRegionHealthChecks) error

	// X is extra state that can be used as part of the mock. Generated code
	// will not use this field.
	X interface{}
}

// Get returns the object from the mock.
func (m *MockRegionHealthChecks) Get(ctx context.Context, key *meta.Key) (*ga.HealthCheck, error) {
	if m.GetHook != nil {
		if intercept, obj, err := m.GetHook(ctx, key, m); intercept {
			klog.V(5).Infof("MockRegionHealthChecks.Get(%v, %s) = %+v, %v", ctx, key, obj, err)
			return obj, err
		}
	}
	if !key.Valid() {
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.GetError[*key]; ok {
		klog.V(5).Infof("MockRegionHealthChecks.Get(%v, %s) = nil, %v", ctx, key, err)
		return nil, err
	}
	if obj, ok := m.Objects[*key]; ok {
		typedObj := obj.ToGA()
		klog.V(5).Infof("MockRegionHealthChecks.Get(%v, %s) = %+v, nil", ctx, key, typedObj)
		return typedObj, nil
	}

	err := &googleapi.Error{
		Code:    http.StatusNotFound,
		Message: fmt.Sprintf("MockRegionHealthChecks %v not found", key),
	}
	klog.V(5).Infof("MockRegionHealthChecks.Get(%v, %s) = nil, %v", ctx, key, err)
	return nil, err
}

// List all of the objects in the mock in the given region.
func (m *MockRegionHealthChecks) List(ctx context.Context, region string, fl *filter.F) ([]*ga.HealthCheck, error) {
	if m.ListHook != nil {
		if intercept, objs, err := m.ListHook(ctx, region, fl, m); intercept {
			klog.V(5).Infof("MockRegionHealthChecks.List(%v, %q, %v) = [%v items], %v", ctx, region, fl, len(objs), err)
			return objs, err
		}
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if m.ListError != nil {
		err := *m.ListError
		klog.V(5).Infof("MockRegionHealthChecks.List(%v, %q, %v) = nil, %v", ctx, region, fl, err)

		return nil, *m.ListError
	}

	var objs []*ga.HealthCheck
	for key, obj := range m.Objects {
		if key.Region != region {
			continue
		}
		if !fl.Match(obj.ToGA()) {
			continue
		}
		objs = append(objs, obj.ToGA())
	}

	klog.V(5).Infof("MockRegionHealthChecks.List(%v, %q, %v) = [%v items], nil", ctx, region, fl, len(objs))
	return objs, nil
}

// Insert is a mock for inserting/creating a new object.
func (m *MockRegionHealthChecks) Insert(ctx context.Context, key *meta.Key, obj *ga.HealthCheck) error {
	if m.InsertHook != nil {
		if intercept, err := m.InsertHook(ctx, key, obj, m); intercept {
			klog.V(5).Infof("MockRegionHealthChecks.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.InsertError[*key]; ok {
		klog.V(5).Infof("MockRegionHealthChecks.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}
	if _, ok := m.Objects[*key]; ok {
		err := &googleapi.Error{
			Code:    http.StatusConflict,
			Message: fmt.Sprintf("MockRegionHealthChecks %v exists", key),
		}
		klog.V(5).Infof("MockRegionHealthChecks.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}

	obj.Name = key.Name
	projectID := m.ProjectRouter.ProjectID(ctx, "ga", "healthChecks")
	obj.SelfLink = SelfLink(meta.VersionGA, projectID, "healthChecks", key)

	m.Objects[*key] = &MockRegionHealthChecksObj{obj}
	klog.V(5).Infof("MockRegionHealthChecks.Insert(%v, %v, %+v) = nil", ctx, key, obj)
	return nil
}

// Delete is a mock for deleting the object.
func (m *MockRegionHealthChecks) Delete(ctx context.Context, key *meta.Key) error {
	if m.DeleteHook != nil {
		if intercept, err := m.DeleteHook(ctx, key, m); intercept {
			klog.V(5).Infof("MockRegionHealthChecks.Delete(%v, %v) = %v", ctx, key, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.DeleteError[*key]; ok {
		klog.V(5).Infof("MockRegionHealthChecks.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}
	if _, ok := m.Objects[*key]; !ok {
		err := &googleapi.Error{
			Code:    http.StatusNotFound,
			Message: fmt.Sprintf("MockRegionHealthChecks %v not found", key),
		}
		klog.V(5).Infof("MockRegionHealthChecks.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	delete(m.Objects, *key)
	klog.V(5).Infof("MockRegionHealthChecks.Delete(%v, %v) = nil", ctx, key)
	return nil
}

// Obj wraps the object for use in the mock.
func (m *MockRegionHealthChecks) Obj(o *ga.HealthCheck) *MockRegionHealthChecksObj {
	return &MockRegionHealthChecksObj{o}
}

// Update is a mock for the corresponding method.
func (m *MockRegionHealthChecks) Update(ctx context.Context, key *meta.Key, arg0 *ga.HealthCheck) error {
	if m.UpdateHook != nil {
		return m.UpdateHook(ctx, key, arg0, m)
	}
	return nil
}

// GCERegionHealthChecks is a simplifying adapter for the GCE RegionHealthChecks.
type GCERegionHealthChecks struct {
	s *Service
}

// Get the HealthCheck named by key.
func (g *GCERegionHealthChecks) Get(ctx context.Context, key *meta.Key) (*ga.HealthCheck, error) {
	klog.V(5).Infof("GCERegionHealthChecks.Get(%v, %v): called", ctx, key)

	if !key.Valid() {
		klog.V(2).Infof("GCERegionHealthChecks.Get(%v, %v): key is invalid (%#v)", ctx, key, key)
		return nil, fmt.Errorf("invalid GCE key (%#v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "RegionHealthChecks")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Get",
		Version:   meta.Version("ga"),
		Service:   "RegionHealthChecks",
	}
	klog.V(5).Infof("GCERegionHealthChecks.Get(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCERegionHealthChecks.Get(%v, %v): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.GA.RegionHealthChecks.Get(projectID, key.Region, key.Name)
	call.Context(ctx)
	v, err := call.Do()
	klog.V(4).Infof("GCERegionHealthChecks.Get(%v, %v) = %+v, %v", ctx, key, v, err)
	return v, err
}

// List all HealthCheck objects.
func (g *GCERegionHealthChecks) List(ctx context.Context, region string, fl *filter.F) ([]*ga.HealthCheck, error) {
	klog.V(5).Infof("GCERegionHealthChecks.List(%v, %v, %v) called", ctx, region, fl)
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "RegionHealthChecks")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "List",
		Version:   meta.Version("ga"),
		Service:   "RegionHealthChecks",
	}
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		return nil, err
	}
	klog.V(5).Infof("GCERegionHealthChecks.List(%v, %v, %v): projectID = %v, rk = %+v", ctx, region, fl, projectID, rk)
	call := g.s.GA.RegionHealthChecks.List(projectID, region)
	if fl != filter.None {
		call.Filter(fl.String())
	}
	var all []*ga.HealthCheck
	f := func(l *ga.HealthCheckList) error {
		klog.V(5).Infof("GCERegionHealthChecks.List(%v, ..., %v): page %+v", ctx, fl, l)
		all = append(all, l.Items...)
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		klog.V(4).Infof("GCERegionHealthChecks.List(%v, ..., %v) = %v, %v", ctx, fl, nil, err)
		return nil, err
	}

	if klog.V(4).Enabled() {
		klog.V(4).Infof("GCERegionHealthChecks.List(%v, ..., %v) = [%v items], %v", ctx, fl, len(all), nil)
	} else if klog.V(5).Enabled() {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		klog.V(5).Infof("GCERegionHealthChecks.List(%v, ..., %v) = %v, %v", ctx, fl, asStr, nil)
	}

	return all, nil
}

// Insert HealthCheck with key of value obj.
func (g *GCERegionHealthChecks) Insert(ctx context.Context, key *meta.Key, obj *ga.HealthCheck) error {
	klog.V(5).Infof("GCERegionHealthChecks.Insert(%v, %v, %+v): called", ctx, key, obj)
	if !key.Valid() {
		klog.V(2).Infof("GCERegionHealthChecks.Insert(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "RegionHealthChecks")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Insert",
		Version:   meta.Version("ga"),
		Service:   "RegionHealthChecks",
	}
	klog.V(5).Infof("GCERegionHealthChecks.Insert(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCERegionHealthChecks.Insert(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	obj.Name = key.Name
	call := g.s.GA.RegionHealthChecks.Insert(projectID, key.Region, obj)
	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCERegionHealthChecks.Insert(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCERegionHealthChecks.Insert(%v, %v, %+v) = %+v", ctx, key, obj, err)
	return err
}

// Delete the HealthCheck referenced by key.
func (g *GCERegionHealthChecks) Delete(ctx context.Context, key *meta.Key) error {
	klog.V(5).Infof("GCERegionHealthChecks.Delete(%v, %v): called", ctx, key)
	if !key.Valid() {
		klog.V(2).Infof("GCERegionHealthChecks.Delete(%v, %v): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "RegionHealthChecks")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Delete",
		Version:   meta.Version("ga"),
		Service:   "RegionHealthChecks",
	}
	klog.V(5).Infof("GCERegionHealthChecks.Delete(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCERegionHealthChecks.Delete(%v, %v): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.GA.RegionHealthChecks.Delete(projectID, key.Region, key.Name)
	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCERegionHealthChecks.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCERegionHealthChecks.Delete(%v, %v) = %v", ctx, key, err)
	return err
}

// Update is a method on GCERegionHealthChecks.
func (g *GCERegionHealthChecks) Update(ctx context.Context, key *meta.Key, arg0 *ga.HealthCheck) error {
	klog.V(5).Infof("GCERegionHealthChecks.Update(%v, %v, ...): called", ctx, key)

	if !key.Valid() {
		klog.V(2).Infof("GCERegionHealthChecks.Update(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "RegionHealthChecks")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Update",
		Version:   meta.Version("ga"),
		Service:   "RegionHealthChecks",
	}
	klog.V(5).Infof("GCERegionHealthChecks.Update(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)

	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCERegionHealthChecks.Update(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.GA.RegionHealthChecks.Update(projectID, key.Region, key.Name, arg0)
	call.Context(ctx)
	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCERegionHealthChecks.Update(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}
	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCERegionHealthChecks.Update(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// HttpHealthChecks is an interface that allows for mocking of HttpHealthChecks.
type HttpHealthChecks interface {
	Get(ctx context.Context, key *meta.Key) (*ga.HttpHealthCheck, error)
	List(ctx context.Context, fl *filter.F) ([]*ga.HttpHealthCheck, error)
	Insert(ctx context.Context, key *meta.Key, obj *ga.HttpHealthCheck) error
	Delete(ctx context.Context, key *meta.Key) error
	Update(context.Context, *meta.Key, *ga.HttpHealthCheck) error
}

// NewMockHttpHealthChecks returns a new mock for HttpHealthChecks.
func NewMockHttpHealthChecks(pr ProjectRouter, objs map[meta.Key]*MockHttpHealthChecksObj) *MockHttpHealthChecks {
	mock := &MockHttpHealthChecks{
		ProjectRouter: pr,

		Objects:     objs,
		GetError:    map[meta.Key]error{},
		InsertError: map[meta.Key]error{},
		DeleteError: map[meta.Key]error{},
	}
	return mock
}

// MockHttpHealthChecks is the mock for HttpHealthChecks.
type MockHttpHealthChecks struct {
	Lock sync.Mutex

	ProjectRouter ProjectRouter

	// Objects maintained by the mock.
	Objects map[meta.Key]*MockHttpHealthChecksObj

	// If an entry exists for the given key and operation, then the error
	// will be returned instead of the operation.
	GetError    map[meta.Key]error
	ListError   *error
	InsertError map[meta.Key]error
	DeleteError map[meta.Key]error

	// xxxHook allow you to intercept the standard processing of the mock in
	// order to add your own logic. Return (true, _, _) to prevent the normal
	// execution flow of the mock. Return (false, nil, nil) to continue with
	// normal mock behavior/ after the hook function executes.
	GetHook    func(ctx context.Context, key *meta.Key, m *MockHttpHealthChecks) (bool, *ga.HttpHealthCheck, error)
	ListHook   func(ctx context.Context, fl *filter.F, m *MockHttpHealthChecks) (bool, []*ga.HttpHealthCheck, error)
	InsertHook func(ctx context.Context, key *meta.Key, obj *ga.HttpHealthCheck, m *MockHttpHealthChecks) (bool, error)
	DeleteHook func(ctx context.Context, key *meta.Key, m *MockHttpHealthChecks) (bool, error)
	UpdateHook func(context.Context, *meta.Key, *ga.HttpHealthCheck, *MockHttpHealthChecks) error

	// X is extra state that can be used as part of the mock. Generated code
	// will not use this field.
	X interface{}
}

// Get returns the object from the mock.
func (m *MockHttpHealthChecks) Get(ctx context.Context, key *meta.Key) (*ga.HttpHealthCheck, error) {
	if m.GetHook != nil {
		if intercept, obj, err := m.GetHook(ctx, key, m); intercept {
			klog.V(5).Infof("MockHttpHealthChecks.Get(%v, %s) = %+v, %v", ctx, key, obj, err)
			return obj, err
		}
	}
	if !key.Valid() {
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.GetError[*key]; ok {
		klog.V(5).Infof("MockHttpHealthChecks.Get(%v, %s) = nil, %v", ctx, key, err)
		return nil, err
	}
	if obj, ok := m.Objects[*key]; ok {
		typedObj := obj.ToGA()
		klog.V(5).Infof("MockHttpHealthChecks.Get(%v, %s) = %+v, nil", ctx, key, typedObj)
		return typedObj, nil
	}

	err := &googleapi.Error{
		Code:    http.StatusNotFound,
		Message: fmt.Sprintf("MockHttpHealthChecks %v not found", key),
	}
	klog.V(5).Infof("MockHttpHealthChecks.Get(%v, %s) = nil, %v", ctx, key, err)
	return nil, err
}

// List all of the objects in the mock.
func (m *MockHttpHealthChecks) List(ctx context.Context, fl *filter.F) ([]*ga.HttpHealthCheck, error) {
	if m.ListHook != nil {
		if intercept, objs, err := m.ListHook(ctx, fl, m); intercept {
			klog.V(5).Infof("MockHttpHealthChecks.List(%v, %v) = [%v items], %v", ctx, fl, len(objs), err)
			return objs, err
		}
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if m.ListError != nil {
		err := *m.ListError
		klog.V(5).Infof("MockHttpHealthChecks.List(%v, %v) = nil, %v", ctx, fl, err)

		return nil, *m.ListError
	}

	var objs []*ga.HttpHealthCheck
	for _, obj := range m.Objects {
		if !fl.Match(obj.ToGA()) {
			continue
		}
		objs = append(objs, obj.ToGA())
	}

	klog.V(5).Infof("MockHttpHealthChecks.List(%v, %v) = [%v items], nil", ctx, fl, len(objs))
	return objs, nil
}

// Insert is a mock for inserting/creating a new object.
func (m *MockHttpHealthChecks) Insert(ctx context.Context, key *meta.Key, obj *ga.HttpHealthCheck) error {
	if m.InsertHook != nil {
		if intercept, err := m.InsertHook(ctx, key, obj, m); intercept {
			klog.V(5).Infof("MockHttpHealthChecks.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.InsertError[*key]; ok {
		klog.V(5).Infof("MockHttpHealthChecks.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}
	if _, ok := m.Objects[*key]; ok {
		err := &googleapi.Error{
			Code:    http.StatusConflict,
			Message: fmt.Sprintf("MockHttpHealthChecks %v exists", key),
		}
		klog.V(5).Infof("MockHttpHealthChecks.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}

	obj.Name = key.Name
	projectID := m.ProjectRouter.ProjectID(ctx, "ga", "httpHealthChecks")
	obj.SelfLink = SelfLink(meta.VersionGA, projectID, "httpHealthChecks", key)

	m.Objects[*key] = &MockHttpHealthChecksObj{obj}
	klog.V(5).Infof("MockHttpHealthChecks.Insert(%v, %v, %+v) = nil", ctx, key, obj)
	return nil
}

// Delete is a mock for deleting the object.
func (m *MockHttpHealthChecks) Delete(ctx context.Context, key *meta.Key) error {
	if m.DeleteHook != nil {
		if intercept, err := m.DeleteHook(ctx, key, m); intercept {
			klog.V(5).Infof("MockHttpHealthChecks.Delete(%v, %v) = %v", ctx, key, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.DeleteError[*key]; ok {
		klog.V(5).Infof("MockHttpHealthChecks.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}
	if _, ok := m.Objects[*key]; !ok {
		err := &googleapi.Error{
			Code:    http.StatusNotFound,
			Message: fmt.Sprintf("MockHttpHealthChecks %v not found", key),
		}
		klog.V(5).Infof("MockHttpHealthChecks.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	delete(m.Objects, *key)
	klog.V(5).Infof("MockHttpHealthChecks.Delete(%v, %v) = nil", ctx, key)
	return nil
}

// Obj wraps the object for use in the mock.
func (m *MockHttpHealthChecks) Obj(o *ga.HttpHealthCheck) *MockHttpHealthChecksObj {
	return &MockHttpHealthChecksObj{o}
}

// Update is a mock for the corresponding method.
func (m *MockHttpHealthChecks) Update(ctx context.Context, key *meta.Key, arg0 *ga.HttpHealthCheck) error {
	if m.UpdateHook != nil {
		return m.UpdateHook(ctx, key, arg0, m)
	}
	return nil
}

// GCEHttpHealthChecks is a simplifying adapter for the GCE HttpHealthChecks.
type GCEHttpHealthChecks struct {
	s *Service
}

// Get the HttpHealthCheck named by key.
func (g *GCEHttpHealthChecks) Get(ctx context.Context, key *meta.Key) (*ga.HttpHealthCheck, error) {
	klog.V(5).Infof("GCEHttpHealthChecks.Get(%v, %v): called", ctx, key)

	if !key.Valid() {
		klog.V(2).Infof("GCEHttpHealthChecks.Get(%v, %v): key is invalid (%#v)", ctx, key, key)
		return nil, fmt.Errorf("invalid GCE key (%#v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "HttpHealthChecks")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Get",
		Version:   meta.Version("ga"),
		Service:   "HttpHealthChecks",
	}
	klog.V(5).Infof("GCEHttpHealthChecks.Get(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEHttpHealthChecks.Get(%v, %v): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.GA.HttpHealthChecks.Get(projectID, key.Name)
	call.Context(ctx)
	v, err := call.Do()
	klog.V(4).Infof("GCEHttpHealthChecks.Get(%v, %v) = %+v, %v", ctx, key, v, err)
	return v, err
}

// List all HttpHealthCheck objects.
func (g *GCEHttpHealthChecks) List(ctx context.Context, fl *filter.F) ([]*ga.HttpHealthCheck, error) {
	klog.V(5).Infof("GCEHttpHealthChecks.List(%v, %v) called", ctx, fl)
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "HttpHealthChecks")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "List",
		Version:   meta.Version("ga"),
		Service:   "HttpHealthChecks",
	}
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		return nil, err
	}
	klog.V(5).Infof("GCEHttpHealthChecks.List(%v, %v): projectID = %v, rk = %+v", ctx, fl, projectID, rk)
	call := g.s.GA.HttpHealthChecks.List(projectID)
	if fl != filter.None {
		call.Filter(fl.String())
	}
	var all []*ga.HttpHealthCheck
	f := func(l *ga.HttpHealthCheckList) error {
		klog.V(5).Infof("GCEHttpHealthChecks.List(%v, ..., %v): page %+v", ctx, fl, l)
		all = append(all, l.Items...)
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		klog.V(4).Infof("GCEHttpHealthChecks.List(%v, ..., %v) = %v, %v", ctx, fl, nil, err)
		return nil, err
	}

	if klog.V(4).Enabled() {
		klog.V(4).Infof("GCEHttpHealthChecks.List(%v, ..., %v) = [%v items], %v", ctx, fl, len(all), nil)
	} else if klog.V(5).Enabled() {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		klog.V(5).Infof("GCEHttpHealthChecks.List(%v, ..., %v) = %v, %v", ctx, fl, asStr, nil)
	}

	return all, nil
}

// Insert HttpHealthCheck with key of value obj.
func (g *GCEHttpHealthChecks) Insert(ctx context.Context, key *meta.Key, obj *ga.HttpHealthCheck) error {
	klog.V(5).Infof("GCEHttpHealthChecks.Insert(%v, %v, %+v): called", ctx, key, obj)
	if !key.Valid() {
		klog.V(2).Infof("GCEHttpHealthChecks.Insert(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "HttpHealthChecks")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Insert",
		Version:   meta.Version("ga"),
		Service:   "HttpHealthChecks",
	}
	klog.V(5).Infof("GCEHttpHealthChecks.Insert(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEHttpHealthChecks.Insert(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	obj.Name = key.Name
	call := g.s.GA.HttpHealthChecks.Insert(projectID, obj)
	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCEHttpHealthChecks.Insert(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEHttpHealthChecks.Insert(%v, %v, %+v) = %+v", ctx, key, obj, err)
	return err
}

// Delete the HttpHealthCheck referenced by key.
func (g *GCEHttpHealthChecks) Delete(ctx context.Context, key *meta.Key) error {
	klog.V(5).Infof("GCEHttpHealthChecks.Delete(%v, %v): called", ctx, key)
	if !key.Valid() {
		klog.V(2).Infof("GCEHttpHealthChecks.Delete(%v, %v): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "HttpHealthChecks")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Delete",
		Version:   meta.Version("ga"),
		Service:   "HttpHealthChecks",
	}
	klog.V(5).Infof("GCEHttpHealthChecks.Delete(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEHttpHealthChecks.Delete(%v, %v): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.GA.HttpHealthChecks.Delete(projectID, key.Name)

	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCEHttpHealthChecks.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEHttpHealthChecks.Delete(%v, %v) = %v", ctx, key, err)
	return err
}

// Update is a method on GCEHttpHealthChecks.
func (g *GCEHttpHealthChecks) Update(ctx context.Context, key *meta.Key, arg0 *ga.HttpHealthCheck) error {
	klog.V(5).Infof("GCEHttpHealthChecks.Update(%v, %v, ...): called", ctx, key)

	if !key.Valid() {
		klog.V(2).Infof("GCEHttpHealthChecks.Update(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "HttpHealthChecks")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Update",
		Version:   meta.Version("ga"),
		Service:   "HttpHealthChecks",
	}
	klog.V(5).Infof("GCEHttpHealthChecks.Update(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)

	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEHttpHealthChecks.Update(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.GA.HttpHealthChecks.Update(projectID, key.Name, arg0)
	call.Context(ctx)
	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCEHttpHealthChecks.Update(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}
	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEHttpHealthChecks.Update(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// HttpsHealthChecks is an interface that allows for mocking of HttpsHealthChecks.
type HttpsHealthChecks interface {
	Get(ctx context.Context, key *meta.Key) (*ga.HttpsHealthCheck, error)
	List(ctx context.Context, fl *filter.F) ([]*ga.HttpsHealthCheck, error)
	Insert(ctx context.Context, key *meta.Key, obj *ga.HttpsHealthCheck) error
	Delete(ctx context.Context, key *meta.Key) error
	Update(context.Context, *meta.Key, *ga.HttpsHealthCheck) error
}

// NewMockHttpsHealthChecks returns a new mock for HttpsHealthChecks.
func NewMockHttpsHealthChecks(pr ProjectRouter, objs map[meta.Key]*MockHttpsHealthChecksObj) *MockHttpsHealthChecks {
	mock := &MockHttpsHealthChecks{
		ProjectRouter: pr,

		Objects:     objs,
		GetError:    map[meta.Key]error{},
		InsertError: map[meta.Key]error{},
		DeleteError: map[meta.Key]error{},
	}
	return mock
}

// MockHttpsHealthChecks is the mock for HttpsHealthChecks.
type MockHttpsHealthChecks struct {
	Lock sync.Mutex

	ProjectRouter ProjectRouter

	// Objects maintained by the mock.
	Objects map[meta.Key]*MockHttpsHealthChecksObj

	// If an entry exists for the given key and operation, then the error
	// will be returned instead of the operation.
	GetError    map[meta.Key]error
	ListError   *error
	InsertError map[meta.Key]error
	DeleteError map[meta.Key]error

	// xxxHook allow you to intercept the standard processing of the mock in
	// order to add your own logic. Return (true, _, _) to prevent the normal
	// execution flow of the mock. Return (false, nil, nil) to continue with
	// normal mock behavior/ after the hook function executes.
	GetHook    func(ctx context.Context, key *meta.Key, m *MockHttpsHealthChecks) (bool, *ga.HttpsHealthCheck, error)
	ListHook   func(ctx context.Context, fl *filter.F, m *MockHttpsHealthChecks) (bool, []*ga.HttpsHealthCheck, error)
	InsertHook func(ctx context.Context, key *meta.Key, obj *ga.HttpsHealthCheck, m *MockHttpsHealthChecks) (bool, error)
	DeleteHook func(ctx context.Context, key *meta.Key, m *MockHttpsHealthChecks) (bool, error)
	UpdateHook func(context.Context, *meta.Key, *ga.HttpsHealthCheck, *MockHttpsHealthChecks) error

	// X is extra state that can be used as part of the mock. Generated code
	// will not use this field.
	X interface{}
}

// Get returns the object from the mock.
func (m *MockHttpsHealthChecks) Get(ctx context.Context, key *meta.Key) (*ga.HttpsHealthCheck, error) {
	if m.GetHook != nil {
		if intercept, obj, err := m.GetHook(ctx, key, m); intercept {
			klog.V(5).Infof("MockHttpsHealthChecks.Get(%v, %s) = %+v, %v", ctx, key, obj, err)
			return obj, err
		}
	}
	if !key.Valid() {
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.GetError[*key]; ok {
		klog.V(5).Infof("MockHttpsHealthChecks.Get(%v, %s) = nil, %v", ctx, key, err)
		return nil, err
	}
	if obj, ok := m.Objects[*key]; ok {
		typedObj := obj.ToGA()
		klog.V(5).Infof("MockHttpsHealthChecks.Get(%v, %s) = %+v, nil", ctx, key, typedObj)
		return typedObj, nil
	}

	err := &googleapi.Error{
		Code:    http.StatusNotFound,
		Message: fmt.Sprintf("MockHttpsHealthChecks %v not found", key),
	}
	klog.V(5).Infof("MockHttpsHealthChecks.Get(%v, %s) = nil, %v", ctx, key, err)
	return nil, err
}

// List all of the objects in the mock.
func (m *MockHttpsHealthChecks) List(ctx context.Context, fl *filter.F) ([]*ga.HttpsHealthCheck, error) {
	if m.ListHook != nil {
		if intercept, objs, err := m.ListHook(ctx, fl, m); intercept {
			klog.V(5).Infof("MockHttpsHealthChecks.List(%v, %v) = [%v items], %v", ctx, fl, len(objs), err)
			return objs, err
		}
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if m.ListError != nil {
		err := *m.ListError
		klog.V(5).Infof("MockHttpsHealthChecks.List(%v, %v) = nil, %v", ctx, fl, err)

		return nil, *m.ListError
	}

	var objs []*ga.HttpsHealthCheck
	for _, obj := range m.Objects {
		if !fl.Match(obj.ToGA()) {
			continue
		}
		objs = append(objs, obj.ToGA())
	}

	klog.V(5).Infof("MockHttpsHealthChecks.List(%v, %v) = [%v items], nil", ctx, fl, len(objs))
	return objs, nil
}

// Insert is a mock for inserting/creating a new object.
func (m *MockHttpsHealthChecks) Insert(ctx context.Context, key *meta.Key, obj *ga.HttpsHealthCheck) error {
	if m.InsertHook != nil {
		if intercept, err := m.InsertHook(ctx, key, obj, m); intercept {
			klog.V(5).Infof("MockHttpsHealthChecks.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.InsertError[*key]; ok {
		klog.V(5).Infof("MockHttpsHealthChecks.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}
	if _, ok := m.Objects[*key]; ok {
		err := &googleapi.Error{
			Code:    http.StatusConflict,
			Message: fmt.Sprintf("MockHttpsHealthChecks %v exists", key),
		}
		klog.V(5).Infof("MockHttpsHealthChecks.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}

	obj.Name = key.Name
	projectID := m.ProjectRouter.ProjectID(ctx, "ga", "httpsHealthChecks")
	obj.SelfLink = SelfLink(meta.VersionGA, projectID, "httpsHealthChecks", key)

	m.Objects[*key] = &MockHttpsHealthChecksObj{obj}
	klog.V(5).Infof("MockHttpsHealthChecks.Insert(%v, %v, %+v) = nil", ctx, key, obj)
	return nil
}

// Delete is a mock for deleting the object.
func (m *MockHttpsHealthChecks) Delete(ctx context.Context, key *meta.Key) error {
	if m.DeleteHook != nil {
		if intercept, err := m.DeleteHook(ctx, key, m); intercept {
			klog.V(5).Infof("MockHttpsHealthChecks.Delete(%v, %v) = %v", ctx, key, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.DeleteError[*key]; ok {
		klog.V(5).Infof("MockHttpsHealthChecks.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}
	if _, ok := m.Objects[*key]; !ok {
		err := &googleapi.Error{
			Code:    http.StatusNotFound,
			Message: fmt.Sprintf("MockHttpsHealthChecks %v not found", key),
		}
		klog.V(5).Infof("MockHttpsHealthChecks.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	delete(m.Objects, *key)
	klog.V(5).Infof("MockHttpsHealthChecks.Delete(%v, %v) = nil", ctx, key)
	return nil
}

// Obj wraps the object for use in the mock.
func (m *MockHttpsHealthChecks) Obj(o *ga.HttpsHealthCheck) *MockHttpsHealthChecksObj {
	return &MockHttpsHealthChecksObj{o}
}

// Update is a mock for the corresponding method.
func (m *MockHttpsHealthChecks) Update(ctx context.Context, key *meta.Key, arg0 *ga.HttpsHealthCheck) error {
	if m.UpdateHook != nil {
		return m.UpdateHook(ctx, key, arg0, m)
	}
	return nil
}

// GCEHttpsHealthChecks is a simplifying adapter for the GCE HttpsHealthChecks.
type GCEHttpsHealthChecks struct {
	s *Service
}

// Get the HttpsHealthCheck named by key.
func (g *GCEHttpsHealthChecks) Get(ctx context.Context, key *meta.Key) (*ga.HttpsHealthCheck, error) {
	klog.V(5).Infof("GCEHttpsHealthChecks.Get(%v, %v): called", ctx, key)

	if !key.Valid() {
		klog.V(2).Infof("GCEHttpsHealthChecks.Get(%v, %v): key is invalid (%#v)", ctx, key, key)
		return nil, fmt.Errorf("invalid GCE key (%#v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "HttpsHealthChecks")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Get",
		Version:   meta.Version("ga"),
		Service:   "HttpsHealthChecks",
	}
	klog.V(5).Infof("GCEHttpsHealthChecks.Get(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEHttpsHealthChecks.Get(%v, %v): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.GA.HttpsHealthChecks.Get(projectID, key.Name)
	call.Context(ctx)
	v, err := call.Do()
	klog.V(4).Infof("GCEHttpsHealthChecks.Get(%v, %v) = %+v, %v", ctx, key, v, err)
	return v, err
}

// List all HttpsHealthCheck objects.
func (g *GCEHttpsHealthChecks) List(ctx context.Context, fl *filter.F) ([]*ga.HttpsHealthCheck, error) {
	klog.V(5).Infof("GCEHttpsHealthChecks.List(%v, %v) called", ctx, fl)
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "HttpsHealthChecks")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "List",
		Version:   meta.Version("ga"),
		Service:   "HttpsHealthChecks",
	}
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		return nil, err
	}
	klog.V(5).Infof("GCEHttpsHealthChecks.List(%v, %v): projectID = %v, rk = %+v", ctx, fl, projectID, rk)
	call := g.s.GA.HttpsHealthChecks.List(projectID)
	if fl != filter.None {
		call.Filter(fl.String())
	}
	var all []*ga.HttpsHealthCheck
	f := func(l *ga.HttpsHealthCheckList) error {
		klog.V(5).Infof("GCEHttpsHealthChecks.List(%v, ..., %v): page %+v", ctx, fl, l)
		all = append(all, l.Items...)
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		klog.V(4).Infof("GCEHttpsHealthChecks.List(%v, ..., %v) = %v, %v", ctx, fl, nil, err)
		return nil, err
	}

	if klog.V(4).Enabled() {
		klog.V(4).Infof("GCEHttpsHealthChecks.List(%v, ..., %v) = [%v items], %v", ctx, fl, len(all), nil)
	} else if klog.V(5).Enabled() {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		klog.V(5).Infof("GCEHttpsHealthChecks.List(%v, ..., %v) = %v, %v", ctx, fl, asStr, nil)
	}

	return all, nil
}

// Insert HttpsHealthCheck with key of value obj.
func (g *GCEHttpsHealthChecks) Insert(ctx context.Context, key *meta.Key, obj *ga.HttpsHealthCheck) error {
	klog.V(5).Infof("GCEHttpsHealthChecks.Insert(%v, %v, %+v): called", ctx, key, obj)
	if !key.Valid() {
		klog.V(2).Infof("GCEHttpsHealthChecks.Insert(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "HttpsHealthChecks")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Insert",
		Version:   meta.Version("ga"),
		Service:   "HttpsHealthChecks",
	}
	klog.V(5).Infof("GCEHttpsHealthChecks.Insert(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEHttpsHealthChecks.Insert(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	obj.Name = key.Name
	call := g.s.GA.HttpsHealthChecks.Insert(projectID, obj)
	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCEHttpsHealthChecks.Insert(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEHttpsHealthChecks.Insert(%v, %v, %+v) = %+v", ctx, key, obj, err)
	return err
}

// Delete the HttpsHealthCheck referenced by key.
func (g *GCEHttpsHealthChecks) Delete(ctx context.Context, key *meta.Key) error {
	klog.V(5).Infof("GCEHttpsHealthChecks.Delete(%v, %v): called", ctx, key)
	if !key.Valid() {
		klog.V(2).Infof("GCEHttpsHealthChecks.Delete(%v, %v): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "HttpsHealthChecks")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Delete",
		Version:   meta.Version("ga"),
		Service:   "HttpsHealthChecks",
	}
	klog.V(5).Infof("GCEHttpsHealthChecks.Delete(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEHttpsHealthChecks.Delete(%v, %v): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.GA.HttpsHealthChecks.Delete(projectID, key.Name)

	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCEHttpsHealthChecks.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEHttpsHealthChecks.Delete(%v, %v) = %v", ctx, key, err)
	return err
}

// Update is a method on GCEHttpsHealthChecks.
func (g *GCEHttpsHealthChecks) Update(ctx context.Context, key *meta.Key, arg0 *ga.HttpsHealthCheck) error {
	klog.V(5).Infof("GCEHttpsHealthChecks.Update(%v, %v, ...): called", ctx, key)

	if !key.Valid() {
		klog.V(2).Infof("GCEHttpsHealthChecks.Update(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "HttpsHealthChecks")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Update",
		Version:   meta.Version("ga"),
		Service:   "HttpsHealthChecks",
	}
	klog.V(5).Infof("GCEHttpsHealthChecks.Update(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)

	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEHttpsHealthChecks.Update(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.GA.HttpsHealthChecks.Update(projectID, key.Name, arg0)
	call.Context(ctx)
	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCEHttpsHealthChecks.Update(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}
	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEHttpsHealthChecks.Update(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// InstanceGroups is an interface that allows for mocking of InstanceGroups.
type InstanceGroups interface {
	Get(ctx context.Context, key *meta.Key) (*ga.InstanceGroup, error)
	List(ctx context.Context, zone string, fl *filter.F) ([]*ga.InstanceGroup, error)
	Insert(ctx context.Context, key *meta.Key, obj *ga.InstanceGroup) error
	Delete(ctx context.Context, key *meta.Key) error
	AddInstances(context.Context, *meta.Key, *ga.InstanceGroupsAddInstancesRequest) error
	ListInstances(context.Context, *meta.Key, *ga.InstanceGroupsListInstancesRequest, *filter.F) ([]*ga.InstanceWithNamedPorts, error)
	RemoveInstances(context.Context, *meta.Key, *ga.InstanceGroupsRemoveInstancesRequest) error
	SetNamedPorts(context.Context, *meta.Key, *ga.InstanceGroupsSetNamedPortsRequest) error
}

// NewMockInstanceGroups returns a new mock for InstanceGroups.
func NewMockInstanceGroups(pr ProjectRouter, objs map[meta.Key]*MockInstanceGroupsObj) *MockInstanceGroups {
	mock := &MockInstanceGroups{
		ProjectRouter: pr,

		Objects:     objs,
		GetError:    map[meta.Key]error{},
		InsertError: map[meta.Key]error{},
		DeleteError: map[meta.Key]error{},
	}
	return mock
}

// MockInstanceGroups is the mock for InstanceGroups.
type MockInstanceGroups struct {
	Lock sync.Mutex

	ProjectRouter ProjectRouter

	// Objects maintained by the mock.
	Objects map[meta.Key]*MockInstanceGroupsObj

	// If an entry exists for the given key and operation, then the error
	// will be returned instead of the operation.
	GetError    map[meta.Key]error
	ListError   *error
	InsertError map[meta.Key]error
	DeleteError map[meta.Key]error

	// xxxHook allow you to intercept the standard processing of the mock in
	// order to add your own logic. Return (true, _, _) to prevent the normal
	// execution flow of the mock. Return (false, nil, nil) to continue with
	// normal mock behavior/ after the hook function executes.
	GetHook             func(ctx context.Context, key *meta.Key, m *MockInstanceGroups) (bool, *ga.InstanceGroup, error)
	ListHook            func(ctx context.Context, zone string, fl *filter.F, m *MockInstanceGroups) (bool, []*ga.InstanceGroup, error)
	InsertHook          func(ctx context.Context, key *meta.Key, obj *ga.InstanceGroup, m *MockInstanceGroups) (bool, error)
	DeleteHook          func(ctx context.Context, key *meta.Key, m *MockInstanceGroups) (bool, error)
	AddInstancesHook    func(context.Context, *meta.Key, *ga.InstanceGroupsAddInstancesRequest, *MockInstanceGroups) error
	ListInstancesHook   func(context.Context, *meta.Key, *ga.InstanceGroupsListInstancesRequest, *filter.F, *MockInstanceGroups) ([]*ga.InstanceWithNamedPorts, error)
	RemoveInstancesHook func(context.Context, *meta.Key, *ga.InstanceGroupsRemoveInstancesRequest, *MockInstanceGroups) error
	SetNamedPortsHook   func(context.Context, *meta.Key, *ga.InstanceGroupsSetNamedPortsRequest, *MockInstanceGroups) error

	// X is extra state that can be used as part of the mock. Generated code
	// will not use this field.
	X interface{}
}

// Get returns the object from the mock.
func (m *MockInstanceGroups) Get(ctx context.Context, key *meta.Key) (*ga.InstanceGroup, error) {
	if m.GetHook != nil {
		if intercept, obj, err := m.GetHook(ctx, key, m); intercept {
			klog.V(5).Infof("MockInstanceGroups.Get(%v, %s) = %+v, %v", ctx, key, obj, err)
			return obj, err
		}
	}
	if !key.Valid() {
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.GetError[*key]; ok {
		klog.V(5).Infof("MockInstanceGroups.Get(%v, %s) = nil, %v", ctx, key, err)
		return nil, err
	}
	if obj, ok := m.Objects[*key]; ok {
		typedObj := obj.ToGA()
		klog.V(5).Infof("MockInstanceGroups.Get(%v, %s) = %+v, nil", ctx, key, typedObj)
		return typedObj, nil
	}

	err := &googleapi.Error{
		Code:    http.StatusNotFound,
		Message: fmt.Sprintf("MockInstanceGroups %v not found", key),
	}
	klog.V(5).Infof("MockInstanceGroups.Get(%v, %s) = nil, %v", ctx, key, err)
	return nil, err
}

// List all of the objects in the mock in the given zone.
func (m *MockInstanceGroups) List(ctx context.Context, zone string, fl *filter.F) ([]*ga.InstanceGroup, error) {
	if m.ListHook != nil {
		if intercept, objs, err := m.ListHook(ctx, zone, fl, m); intercept {
			klog.V(5).Infof("MockInstanceGroups.List(%v, %q, %v) = [%v items], %v", ctx, zone, fl, len(objs), err)
			return objs, err
		}
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if m.ListError != nil {
		err := *m.ListError
		klog.V(5).Infof("MockInstanceGroups.List(%v, %q, %v) = nil, %v", ctx, zone, fl, err)

		return nil, *m.ListError
	}

	var objs []*ga.InstanceGroup
	for key, obj := range m.Objects {
		if key.Zone != zone {
			continue
		}
		if !fl.Match(obj.ToGA()) {
			continue
		}
		objs = append(objs, obj.ToGA())
	}

	klog.V(5).Infof("MockInstanceGroups.List(%v, %q, %v) = [%v items], nil", ctx, zone, fl, len(objs))
	return objs, nil
}

// Insert is a mock for inserting/creating a new object.
func (m *MockInstanceGroups) Insert(ctx context.Context, key *meta.Key, obj *ga.InstanceGroup) error {
	if m.InsertHook != nil {
		if intercept, err := m.InsertHook(ctx, key, obj, m); intercept {
			klog.V(5).Infof("MockInstanceGroups.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.InsertError[*key]; ok {
		klog.V(5).Infof("MockInstanceGroups.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}
	if _, ok := m.Objects[*key]; ok {
		err := &googleapi.Error{
			Code:    http.StatusConflict,
			Message: fmt.Sprintf("MockInstanceGroups %v exists", key),
		}
		klog.V(5).Infof("MockInstanceGroups.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}

	obj.Name = key.Name
	projectID := m.ProjectRouter.ProjectID(ctx, "ga", "instanceGroups")
	obj.SelfLink = SelfLink(meta.VersionGA, projectID, "instanceGroups", key)

	m.Objects[*key] = &MockInstanceGroupsObj{obj}
	klog.V(5).Infof("MockInstanceGroups.Insert(%v, %v, %+v) = nil", ctx, key, obj)
	return nil
}

// Delete is a mock for deleting the object.
func (m *MockInstanceGroups) Delete(ctx context.Context, key *meta.Key) error {
	if m.DeleteHook != nil {
		if intercept, err := m.DeleteHook(ctx, key, m); intercept {
			klog.V(5).Infof("MockInstanceGroups.Delete(%v, %v) = %v", ctx, key, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.DeleteError[*key]; ok {
		klog.V(5).Infof("MockInstanceGroups.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}
	if _, ok := m.Objects[*key]; !ok {
		err := &googleapi.Error{
			Code:    http.StatusNotFound,
			Message: fmt.Sprintf("MockInstanceGroups %v not found", key),
		}
		klog.V(5).Infof("MockInstanceGroups.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	delete(m.Objects, *key)
	klog.V(5).Infof("MockInstanceGroups.Delete(%v, %v) = nil", ctx, key)
	return nil
}

// Obj wraps the object for use in the mock.
func (m *MockInstanceGroups) Obj(o *ga.InstanceGroup) *MockInstanceGroupsObj {
	return &MockInstanceGroupsObj{o}
}

// AddInstances is a mock for the corresponding method.
func (m *MockInstanceGroups) AddInstances(ctx context.Context, key *meta.Key, arg0 *ga.InstanceGroupsAddInstancesRequest) error {
	if m.AddInstancesHook != nil {
		return m.AddInstancesHook(ctx, key, arg0, m)
	}
	return nil
}

// ListInstances is a mock for the corresponding method.
func (m *MockInstanceGroups) ListInstances(ctx context.Context, key *meta.Key, arg0 *ga.InstanceGroupsListInstancesRequest, fl *filter.F) ([]*ga.InstanceWithNamedPorts, error) {
	if m.ListInstancesHook != nil {
		return m.ListInstancesHook(ctx, key, arg0, fl, m)
	}
	return nil, nil
}

// RemoveInstances is a mock for the corresponding method.
func (m *MockInstanceGroups) RemoveInstances(ctx context.Context, key *meta.Key, arg0 *ga.InstanceGroupsRemoveInstancesRequest) error {
	if m.RemoveInstancesHook != nil {
		return m.RemoveInstancesHook(ctx, key, arg0, m)
	}
	return nil
}

// SetNamedPorts is a mock for the corresponding method.
func (m *MockInstanceGroups) SetNamedPorts(ctx context.Context, key *meta.Key, arg0 *ga.InstanceGroupsSetNamedPortsRequest) error {
	if m.SetNamedPortsHook != nil {
		return m.SetNamedPortsHook(ctx, key, arg0, m)
	}
	return nil
}

// GCEInstanceGroups is a simplifying adapter for the GCE InstanceGroups.
type GCEInstanceGroups struct {
	s *Service
}

// Get the InstanceGroup named by key.
func (g *GCEInstanceGroups) Get(ctx context.Context, key *meta.Key) (*ga.InstanceGroup, error) {
	klog.V(5).Infof("GCEInstanceGroups.Get(%v, %v): called", ctx, key)

	if !key.Valid() {
		klog.V(2).Infof("GCEInstanceGroups.Get(%v, %v): key is invalid (%#v)", ctx, key, key)
		return nil, fmt.Errorf("invalid GCE key (%#v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "InstanceGroups")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Get",
		Version:   meta.Version("ga"),
		Service:   "InstanceGroups",
	}
	klog.V(5).Infof("GCEInstanceGroups.Get(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEInstanceGroups.Get(%v, %v): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.GA.InstanceGroups.Get(projectID, key.Zone, key.Name)
	call.Context(ctx)
	v, err := call.Do()
	klog.V(4).Infof("GCEInstanceGroups.Get(%v, %v) = %+v, %v", ctx, key, v, err)
	return v, err
}

// List all InstanceGroup objects.
func (g *GCEInstanceGroups) List(ctx context.Context, zone string, fl *filter.F) ([]*ga.InstanceGroup, error) {
	klog.V(5).Infof("GCEInstanceGroups.List(%v, %v, %v) called", ctx, zone, fl)
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "InstanceGroups")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "List",
		Version:   meta.Version("ga"),
		Service:   "InstanceGroups",
	}
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		return nil, err
	}
	klog.V(5).Infof("GCEInstanceGroups.List(%v, %v, %v): projectID = %v, rk = %+v", ctx, zone, fl, projectID, rk)
	call := g.s.GA.InstanceGroups.List(projectID, zone)
	if fl != filter.None {
		call.Filter(fl.String())
	}
	var all []*ga.InstanceGroup
	f := func(l *ga.InstanceGroupList) error {
		klog.V(5).Infof("GCEInstanceGroups.List(%v, ..., %v): page %+v", ctx, fl, l)
		all = append(all, l.Items...)
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		klog.V(4).Infof("GCEInstanceGroups.List(%v, ..., %v) = %v, %v", ctx, fl, nil, err)
		return nil, err
	}

	if klog.V(4).Enabled() {
		klog.V(4).Infof("GCEInstanceGroups.List(%v, ..., %v) = [%v items], %v", ctx, fl, len(all), nil)
	} else if klog.V(5).Enabled() {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		klog.V(5).Infof("GCEInstanceGroups.List(%v, ..., %v) = %v, %v", ctx, fl, asStr, nil)
	}

	return all, nil
}

// Insert InstanceGroup with key of value obj.
func (g *GCEInstanceGroups) Insert(ctx context.Context, key *meta.Key, obj *ga.InstanceGroup) error {
	klog.V(5).Infof("GCEInstanceGroups.Insert(%v, %v, %+v): called", ctx, key, obj)
	if !key.Valid() {
		klog.V(2).Infof("GCEInstanceGroups.Insert(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "InstanceGroups")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Insert",
		Version:   meta.Version("ga"),
		Service:   "InstanceGroups",
	}
	klog.V(5).Infof("GCEInstanceGroups.Insert(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEInstanceGroups.Insert(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	obj.Name = key.Name
	call := g.s.GA.InstanceGroups.Insert(projectID, key.Zone, obj)
	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCEInstanceGroups.Insert(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEInstanceGroups.Insert(%v, %v, %+v) = %+v", ctx, key, obj, err)
	return err
}

// Delete the InstanceGroup referenced by key.
func (g *GCEInstanceGroups) Delete(ctx context.Context, key *meta.Key) error {
	klog.V(5).Infof("GCEInstanceGroups.Delete(%v, %v): called", ctx, key)
	if !key.Valid() {
		klog.V(2).Infof("GCEInstanceGroups.Delete(%v, %v): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "InstanceGroups")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Delete",
		Version:   meta.Version("ga"),
		Service:   "InstanceGroups",
	}
	klog.V(5).Infof("GCEInstanceGroups.Delete(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEInstanceGroups.Delete(%v, %v): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.GA.InstanceGroups.Delete(projectID, key.Zone, key.Name)
	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCEInstanceGroups.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEInstanceGroups.Delete(%v, %v) = %v", ctx, key, err)
	return err
}

// AddInstances is a method on GCEInstanceGroups.
func (g *GCEInstanceGroups) AddInstances(ctx context.Context, key *meta.Key, arg0 *ga.InstanceGroupsAddInstancesRequest) error {
	klog.V(5).Infof("GCEInstanceGroups.AddInstances(%v, %v, ...): called", ctx, key)

	if !key.Valid() {
		klog.V(2).Infof("GCEInstanceGroups.AddInstances(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "InstanceGroups")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "AddInstances",
		Version:   meta.Version("ga"),
		Service:   "InstanceGroups",
	}
	klog.V(5).Infof("GCEInstanceGroups.AddInstances(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)

	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEInstanceGroups.AddInstances(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.GA.InstanceGroups.AddInstances(projectID, key.Zone, key.Name, arg0)
	call.Context(ctx)
	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCEInstanceGroups.AddInstances(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}
	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEInstanceGroups.AddInstances(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// ListInstances is a method on GCEInstanceGroups.
func (g *GCEInstanceGroups) ListInstances(ctx context.Context, key *meta.Key, arg0 *ga.InstanceGroupsListInstancesRequest, fl *filter.F) ([]*ga.InstanceWithNamedPorts, error) {
	klog.V(5).Infof("GCEInstanceGroups.ListInstances(%v, %v, ...): called", ctx, key)

	if !key.Valid() {
		klog.V(2).Infof("GCEInstanceGroups.ListInstances(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "InstanceGroups")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "ListInstances",
		Version:   meta.Version("ga"),
		Service:   "InstanceGroups",
	}
	klog.V(5).Infof("GCEInstanceGroups.ListInstances(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)

	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEInstanceGroups.ListInstances(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.GA.InstanceGroups.ListInstances(projectID, key.Zone, key.Name, arg0)
	var all []*ga.InstanceWithNamedPorts
	f := func(l *ga.InstanceGroupsListInstances) error {
		klog.V(5).Infof("GCEInstanceGroups.ListInstances(%v, %v, ...): page %+v", ctx, key, l)
		all = append(all, l.Items...)
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		klog.V(4).Infof("GCEInstanceGroups.ListInstances(%v, %v, ...) = %v, %v", ctx, key, nil, err)
		return nil, err
	}
	if klog.V(4).Enabled() {
		klog.V(4).Infof("GCEInstanceGroups.ListInstances(%v, %v, ...) = [%v items], %v", ctx, key, len(all), nil)
	} else if klog.V(5).Enabled() {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		klog.V(5).Infof("GCEInstanceGroups.ListInstances(%v, %v, ...) = %v, %v", ctx, key, asStr, nil)
	}
	return all, nil
}

// RemoveInstances is a method on GCEInstanceGroups.
func (g *GCEInstanceGroups) RemoveInstances(ctx context.Context, key *meta.Key, arg0 *ga.InstanceGroupsRemoveInstancesRequest) error {
	klog.V(5).Infof("GCEInstanceGroups.RemoveInstances(%v, %v, ...): called", ctx, key)

	if !key.Valid() {
		klog.V(2).Infof("GCEInstanceGroups.RemoveInstances(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "InstanceGroups")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "RemoveInstances",
		Version:   meta.Version("ga"),
		Service:   "InstanceGroups",
	}
	klog.V(5).Infof("GCEInstanceGroups.RemoveInstances(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)

	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEInstanceGroups.RemoveInstances(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.GA.InstanceGroups.RemoveInstances(projectID, key.Zone, key.Name, arg0)
	call.Context(ctx)
	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCEInstanceGroups.RemoveInstances(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}
	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEInstanceGroups.RemoveInstances(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// SetNamedPorts is a method on GCEInstanceGroups.
func (g *GCEInstanceGroups) SetNamedPorts(ctx context.Context, key *meta.Key, arg0 *ga.InstanceGroupsSetNamedPortsRequest) error {
	klog.V(5).Infof("GCEInstanceGroups.SetNamedPorts(%v, %v, ...): called", ctx, key)

	if !key.Valid() {
		klog.V(2).Infof("GCEInstanceGroups.SetNamedPorts(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "InstanceGroups")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "SetNamedPorts",
		Version:   meta.Version("ga"),
		Service:   "InstanceGroups",
	}
	klog.V(5).Infof("GCEInstanceGroups.SetNamedPorts(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)

	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEInstanceGroups.SetNamedPorts(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.GA.InstanceGroups.SetNamedPorts(projectID, key.Zone, key.Name, arg0)
	call.Context(ctx)
	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCEInstanceGroups.SetNamedPorts(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}
	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEInstanceGroups.SetNamedPorts(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// Instances is an interface that allows for mocking of Instances.
type Instances interface {
	Get(ctx context.Context, key *meta.Key) (*ga.Instance, error)
	List(ctx context.Context, zone string, fl *filter.F) ([]*ga.Instance, error)
	Insert(ctx context.Context, key *meta.Key, obj *ga.Instance) error
	Delete(ctx context.Context, key *meta.Key) error
	AttachDisk(context.Context, *meta.Key, *ga.AttachedDisk) error
	DetachDisk(context.Context, *meta.Key, string) error
}

// NewMockInstances returns a new mock for Instances.
func NewMockInstances(pr ProjectRouter, objs map[meta.Key]*MockInstancesObj) *MockInstances {
	mock := &MockInstances{
		ProjectRouter: pr,

		Objects:     objs,
		GetError:    map[meta.Key]error{},
		InsertError: map[meta.Key]error{},
		DeleteError: map[meta.Key]error{},
	}
	return mock
}

// MockInstances is the mock for Instances.
type MockInstances struct {
	Lock sync.Mutex

	ProjectRouter ProjectRouter

	// Objects maintained by the mock.
	Objects map[meta.Key]*MockInstancesObj

	// If an entry exists for the given key and operation, then the error
	// will be returned instead of the operation.
	GetError    map[meta.Key]error
	ListError   *error
	InsertError map[meta.Key]error
	DeleteError map[meta.Key]error

	// xxxHook allow you to intercept the standard processing of the mock in
	// order to add your own logic. Return (true, _, _) to prevent the normal
	// execution flow of the mock. Return (false, nil, nil) to continue with
	// normal mock behavior/ after the hook function executes.
	GetHook        func(ctx context.Context, key *meta.Key, m *MockInstances) (bool, *ga.Instance, error)
	ListHook       func(ctx context.Context, zone string, fl *filter.F, m *MockInstances) (bool, []*ga.Instance, error)
	InsertHook     func(ctx context.Context, key *meta.Key, obj *ga.Instance, m *MockInstances) (bool, error)
	DeleteHook     func(ctx context.Context, key *meta.Key, m *MockInstances) (bool, error)
	AttachDiskHook func(context.Context, *meta.Key, *ga.AttachedDisk, *MockInstances) error
	DetachDiskHook func(context.Context, *meta.Key, string, *MockInstances) error

	// X is extra state that can be used as part of the mock. Generated code
	// will not use this field.
	X interface{}
}

// Get returns the object from the mock.
func (m *MockInstances) Get(ctx context.Context, key *meta.Key) (*ga.Instance, error) {
	if m.GetHook != nil {
		if intercept, obj, err := m.GetHook(ctx, key, m); intercept {
			klog.V(5).Infof("MockInstances.Get(%v, %s) = %+v, %v", ctx, key, obj, err)
			return obj, err
		}
	}
	if !key.Valid() {
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.GetError[*key]; ok {
		klog.V(5).Infof("MockInstances.Get(%v, %s) = nil, %v", ctx, key, err)
		return nil, err
	}
	if obj, ok := m.Objects[*key]; ok {
		typedObj := obj.ToGA()
		klog.V(5).Infof("MockInstances.Get(%v, %s) = %+v, nil", ctx, key, typedObj)
		return typedObj, nil
	}

	err := &googleapi.Error{
		Code:    http.StatusNotFound,
		Message: fmt.Sprintf("MockInstances %v not found", key),
	}
	klog.V(5).Infof("MockInstances.Get(%v, %s) = nil, %v", ctx, key, err)
	return nil, err
}

// List all of the objects in the mock in the given zone.
func (m *MockInstances) List(ctx context.Context, zone string, fl *filter.F) ([]*ga.Instance, error) {
	if m.ListHook != nil {
		if intercept, objs, err := m.ListHook(ctx, zone, fl, m); intercept {
			klog.V(5).Infof("MockInstances.List(%v, %q, %v) = [%v items], %v", ctx, zone, fl, len(objs), err)
			return objs, err
		}
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if m.ListError != nil {
		err := *m.ListError
		klog.V(5).Infof("MockInstances.List(%v, %q, %v) = nil, %v", ctx, zone, fl, err)

		return nil, *m.ListError
	}

	var objs []*ga.Instance
	for key, obj := range m.Objects {
		if key.Zone != zone {
			continue
		}
		if !fl.Match(obj.ToGA()) {
			continue
		}
		objs = append(objs, obj.ToGA())
	}

	klog.V(5).Infof("MockInstances.List(%v, %q, %v) = [%v items], nil", ctx, zone, fl, len(objs))
	return objs, nil
}

// Insert is a mock for inserting/creating a new object.
func (m *MockInstances) Insert(ctx context.Context, key *meta.Key, obj *ga.Instance) error {
	if m.InsertHook != nil {
		if intercept, err := m.InsertHook(ctx, key, obj, m); intercept {
			klog.V(5).Infof("MockInstances.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.InsertError[*key]; ok {
		klog.V(5).Infof("MockInstances.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}
	if _, ok := m.Objects[*key]; ok {
		err := &googleapi.Error{
			Code:    http.StatusConflict,
			Message: fmt.Sprintf("MockInstances %v exists", key),
		}
		klog.V(5).Infof("MockInstances.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}

	obj.Name = key.Name
	projectID := m.ProjectRouter.ProjectID(ctx, "ga", "instances")
	obj.SelfLink = SelfLink(meta.VersionGA, projectID, "instances", key)

	m.Objects[*key] = &MockInstancesObj{obj}
	klog.V(5).Infof("MockInstances.Insert(%v, %v, %+v) = nil", ctx, key, obj)
	return nil
}

// Delete is a mock for deleting the object.
func (m *MockInstances) Delete(ctx context.Context, key *meta.Key) error {
	if m.DeleteHook != nil {
		if intercept, err := m.DeleteHook(ctx, key, m); intercept {
			klog.V(5).Infof("MockInstances.Delete(%v, %v) = %v", ctx, key, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.DeleteError[*key]; ok {
		klog.V(5).Infof("MockInstances.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}
	if _, ok := m.Objects[*key]; !ok {
		err := &googleapi.Error{
			Code:    http.StatusNotFound,
			Message: fmt.Sprintf("MockInstances %v not found", key),
		}
		klog.V(5).Infof("MockInstances.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	delete(m.Objects, *key)
	klog.V(5).Infof("MockInstances.Delete(%v, %v) = nil", ctx, key)
	return nil
}

// Obj wraps the object for use in the mock.
func (m *MockInstances) Obj(o *ga.Instance) *MockInstancesObj {
	return &MockInstancesObj{o}
}

// AttachDisk is a mock for the corresponding method.
func (m *MockInstances) AttachDisk(ctx context.Context, key *meta.Key, arg0 *ga.AttachedDisk) error {
	if m.AttachDiskHook != nil {
		return m.AttachDiskHook(ctx, key, arg0, m)
	}
	return nil
}

// DetachDisk is a mock for the corresponding method.
func (m *MockInstances) DetachDisk(ctx context.Context, key *meta.Key, arg0 string) error {
	if m.DetachDiskHook != nil {
		return m.DetachDiskHook(ctx, key, arg0, m)
	}
	return nil
}

// GCEInstances is a simplifying adapter for the GCE Instances.
type GCEInstances struct {
	s *Service
}

// Get the Instance named by key.
func (g *GCEInstances) Get(ctx context.Context, key *meta.Key) (*ga.Instance, error) {
	klog.V(5).Infof("GCEInstances.Get(%v, %v): called", ctx, key)

	if !key.Valid() {
		klog.V(2).Infof("GCEInstances.Get(%v, %v): key is invalid (%#v)", ctx, key, key)
		return nil, fmt.Errorf("invalid GCE key (%#v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "Instances")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Get",
		Version:   meta.Version("ga"),
		Service:   "Instances",
	}
	klog.V(5).Infof("GCEInstances.Get(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEInstances.Get(%v, %v): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.GA.Instances.Get(projectID, key.Zone, key.Name)
	call.Context(ctx)
	v, err := call.Do()
	klog.V(4).Infof("GCEInstances.Get(%v, %v) = %+v, %v", ctx, key, v, err)
	return v, err
}

// List all Instance objects.
func (g *GCEInstances) List(ctx context.Context, zone string, fl *filter.F) ([]*ga.Instance, error) {
	klog.V(5).Infof("GCEInstances.List(%v, %v, %v) called", ctx, zone, fl)
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "Instances")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "List",
		Version:   meta.Version("ga"),
		Service:   "Instances",
	}
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		return nil, err
	}
	klog.V(5).Infof("GCEInstances.List(%v, %v, %v): projectID = %v, rk = %+v", ctx, zone, fl, projectID, rk)
	call := g.s.GA.Instances.List(projectID, zone)
	if fl != filter.None {
		call.Filter(fl.String())
	}
	var all []*ga.Instance
	f := func(l *ga.InstanceList) error {
		klog.V(5).Infof("GCEInstances.List(%v, ..., %v): page %+v", ctx, fl, l)
		all = append(all, l.Items...)
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		klog.V(4).Infof("GCEInstances.List(%v, ..., %v) = %v, %v", ctx, fl, nil, err)
		return nil, err
	}

	if klog.V(4).Enabled() {
		klog.V(4).Infof("GCEInstances.List(%v, ..., %v) = [%v items], %v", ctx, fl, len(all), nil)
	} else if klog.V(5).Enabled() {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		klog.V(5).Infof("GCEInstances.List(%v, ..., %v) = %v, %v", ctx, fl, asStr, nil)
	}

	return all, nil
}

// Insert Instance with key of value obj.
func (g *GCEInstances) Insert(ctx context.Context, key *meta.Key, obj *ga.Instance) error {
	klog.V(5).Infof("GCEInstances.Insert(%v, %v, %+v): called", ctx, key, obj)
	if !key.Valid() {
		klog.V(2).Infof("GCEInstances.Insert(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "Instances")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Insert",
		Version:   meta.Version("ga"),
		Service:   "Instances",
	}
	klog.V(5).Infof("GCEInstances.Insert(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEInstances.Insert(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	obj.Name = key.Name
	call := g.s.GA.Instances.Insert(projectID, key.Zone, obj)
	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCEInstances.Insert(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEInstances.Insert(%v, %v, %+v) = %+v", ctx, key, obj, err)
	return err
}

// Delete the Instance referenced by key.
func (g *GCEInstances) Delete(ctx context.Context, key *meta.Key) error {
	klog.V(5).Infof("GCEInstances.Delete(%v, %v): called", ctx, key)
	if !key.Valid() {
		klog.V(2).Infof("GCEInstances.Delete(%v, %v): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "Instances")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Delete",
		Version:   meta.Version("ga"),
		Service:   "Instances",
	}
	klog.V(5).Infof("GCEInstances.Delete(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEInstances.Delete(%v, %v): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.GA.Instances.Delete(projectID, key.Zone, key.Name)
	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCEInstances.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEInstances.Delete(%v, %v) = %v", ctx, key, err)
	return err
}

// AttachDisk is a method on GCEInstances.
func (g *GCEInstances) AttachDisk(ctx context.Context, key *meta.Key, arg0 *ga.AttachedDisk) error {
	klog.V(5).Infof("GCEInstances.AttachDisk(%v, %v, ...): called", ctx, key)

	if !key.Valid() {
		klog.V(2).Infof("GCEInstances.AttachDisk(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "Instances")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "AttachDisk",
		Version:   meta.Version("ga"),
		Service:   "Instances",
	}
	klog.V(5).Infof("GCEInstances.AttachDisk(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)

	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEInstances.AttachDisk(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.GA.Instances.AttachDisk(projectID, key.Zone, key.Name, arg0)
	call.Context(ctx)
	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCEInstances.AttachDisk(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}
	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEInstances.AttachDisk(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// DetachDisk is a method on GCEInstances.
func (g *GCEInstances) DetachDisk(ctx context.Context, key *meta.Key, arg0 string) error {
	klog.V(5).Infof("GCEInstances.DetachDisk(%v, %v, ...): called", ctx, key)

	if !key.Valid() {
		klog.V(2).Infof("GCEInstances.DetachDisk(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "Instances")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "DetachDisk",
		Version:   meta.Version("ga"),
		Service:   "Instances",
	}
	klog.V(5).Infof("GCEInstances.DetachDisk(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)

	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEInstances.DetachDisk(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.GA.Instances.DetachDisk(projectID, key.Zone, key.Name, arg0)
	call.Context(ctx)
	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCEInstances.DetachDisk(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}
	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEInstances.DetachDisk(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// BetaInstances is an interface that allows for mocking of Instances.
type BetaInstances interface {
	Get(ctx context.Context, key *meta.Key) (*beta.Instance, error)
	List(ctx context.Context, zone string, fl *filter.F) ([]*beta.Instance, error)
	Insert(ctx context.Context, key *meta.Key, obj *beta.Instance) error
	Delete(ctx context.Context, key *meta.Key) error
	AttachDisk(context.Context, *meta.Key, *beta.AttachedDisk) error
	DetachDisk(context.Context, *meta.Key, string) error
	UpdateNetworkInterface(context.Context, *meta.Key, string, *beta.NetworkInterface) error
}

// NewMockBetaInstances returns a new mock for Instances.
func NewMockBetaInstances(pr ProjectRouter, objs map[meta.Key]*MockInstancesObj) *MockBetaInstances {
	mock := &MockBetaInstances{
		ProjectRouter: pr,

		Objects:     objs,
		GetError:    map[meta.Key]error{},
		InsertError: map[meta.Key]error{},
		DeleteError: map[meta.Key]error{},
	}
	return mock
}

// MockBetaInstances is the mock for Instances.
type MockBetaInstances struct {
	Lock sync.Mutex

	ProjectRouter ProjectRouter

	// Objects maintained by the mock.
	Objects map[meta.Key]*MockInstancesObj

	// If an entry exists for the given key and operation, then the error
	// will be returned instead of the operation.
	GetError    map[meta.Key]error
	ListError   *error
	InsertError map[meta.Key]error
	DeleteError map[meta.Key]error

	// xxxHook allow you to intercept the standard processing of the mock in
	// order to add your own logic. Return (true, _, _) to prevent the normal
	// execution flow of the mock. Return (false, nil, nil) to continue with
	// normal mock behavior/ after the hook function executes.
	GetHook                    func(ctx context.Context, key *meta.Key, m *MockBetaInstances) (bool, *beta.Instance, error)
	ListHook                   func(ctx context.Context, zone string, fl *filter.F, m *MockBetaInstances) (bool, []*beta.Instance, error)
	InsertHook                 func(ctx context.Context, key *meta.Key, obj *beta.Instance, m *MockBetaInstances) (bool, error)
	DeleteHook                 func(ctx context.Context, key *meta.Key, m *MockBetaInstances) (bool, error)
	AttachDiskHook             func(context.Context, *meta.Key, *beta.AttachedDisk, *MockBetaInstances) error
	DetachDiskHook             func(context.Context, *meta.Key, string, *MockBetaInstances) error
	UpdateNetworkInterfaceHook func(context.Context, *meta.Key, string, *beta.NetworkInterface, *MockBetaInstances) error

	// X is extra state that can be used as part of the mock. Generated code
	// will not use this field.
	X interface{}
}

// Get returns the object from the mock.
func (m *MockBetaInstances) Get(ctx context.Context, key *meta.Key) (*beta.Instance, error) {
	if m.GetHook != nil {
		if intercept, obj, err := m.GetHook(ctx, key, m); intercept {
			klog.V(5).Infof("MockBetaInstances.Get(%v, %s) = %+v, %v", ctx, key, obj, err)
			return obj, err
		}
	}
	if !key.Valid() {
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.GetError[*key]; ok {
		klog.V(5).Infof("MockBetaInstances.Get(%v, %s) = nil, %v", ctx, key, err)
		return nil, err
	}
	if obj, ok := m.Objects[*key]; ok {
		typedObj := obj.ToBeta()
		klog.V(5).Infof("MockBetaInstances.Get(%v, %s) = %+v, nil", ctx, key, typedObj)
		return typedObj, nil
	}

	err := &googleapi.Error{
		Code:    http.StatusNotFound,
		Message: fmt.Sprintf("MockBetaInstances %v not found", key),
	}
	klog.V(5).Infof("MockBetaInstances.Get(%v, %s) = nil, %v", ctx, key, err)
	return nil, err
}

// List all of the objects in the mock in the given zone.
func (m *MockBetaInstances) List(ctx context.Context, zone string, fl *filter.F) ([]*beta.Instance, error) {
	if m.ListHook != nil {
		if intercept, objs, err := m.ListHook(ctx, zone, fl, m); intercept {
			klog.V(5).Infof("MockBetaInstances.List(%v, %q, %v) = [%v items], %v", ctx, zone, fl, len(objs), err)
			return objs, err
		}
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if m.ListError != nil {
		err := *m.ListError
		klog.V(5).Infof("MockBetaInstances.List(%v, %q, %v) = nil, %v", ctx, zone, fl, err)

		return nil, *m.ListError
	}

	var objs []*beta.Instance
	for key, obj := range m.Objects {
		if key.Zone != zone {
			continue
		}
		if !fl.Match(obj.ToBeta()) {
			continue
		}
		objs = append(objs, obj.ToBeta())
	}

	klog.V(5).Infof("MockBetaInstances.List(%v, %q, %v) = [%v items], nil", ctx, zone, fl, len(objs))
	return objs, nil
}

// Insert is a mock for inserting/creating a new object.
func (m *MockBetaInstances) Insert(ctx context.Context, key *meta.Key, obj *beta.Instance) error {
	if m.InsertHook != nil {
		if intercept, err := m.InsertHook(ctx, key, obj, m); intercept {
			klog.V(5).Infof("MockBetaInstances.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.InsertError[*key]; ok {
		klog.V(5).Infof("MockBetaInstances.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}
	if _, ok := m.Objects[*key]; ok {
		err := &googleapi.Error{
			Code:    http.StatusConflict,
			Message: fmt.Sprintf("MockBetaInstances %v exists", key),
		}
		klog.V(5).Infof("MockBetaInstances.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}

	obj.Name = key.Name
	projectID := m.ProjectRouter.ProjectID(ctx, "beta", "instances")
	obj.SelfLink = SelfLink(meta.VersionBeta, projectID, "instances", key)

	m.Objects[*key] = &MockInstancesObj{obj}
	klog.V(5).Infof("MockBetaInstances.Insert(%v, %v, %+v) = nil", ctx, key, obj)
	return nil
}

// Delete is a mock for deleting the object.
func (m *MockBetaInstances) Delete(ctx context.Context, key *meta.Key) error {
	if m.DeleteHook != nil {
		if intercept, err := m.DeleteHook(ctx, key, m); intercept {
			klog.V(5).Infof("MockBetaInstances.Delete(%v, %v) = %v", ctx, key, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.DeleteError[*key]; ok {
		klog.V(5).Infof("MockBetaInstances.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}
	if _, ok := m.Objects[*key]; !ok {
		err := &googleapi.Error{
			Code:    http.StatusNotFound,
			Message: fmt.Sprintf("MockBetaInstances %v not found", key),
		}
		klog.V(5).Infof("MockBetaInstances.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	delete(m.Objects, *key)
	klog.V(5).Infof("MockBetaInstances.Delete(%v, %v) = nil", ctx, key)
	return nil
}

// Obj wraps the object for use in the mock.
func (m *MockBetaInstances) Obj(o *beta.Instance) *MockInstancesObj {
	return &MockInstancesObj{o}
}

// AttachDisk is a mock for the corresponding method.
func (m *MockBetaInstances) AttachDisk(ctx context.Context, key *meta.Key, arg0 *beta.AttachedDisk) error {
	if m.AttachDiskHook != nil {
		return m.AttachDiskHook(ctx, key, arg0, m)
	}
	return nil
}

// DetachDisk is a mock for the corresponding method.
func (m *MockBetaInstances) DetachDisk(ctx context.Context, key *meta.Key, arg0 string) error {
	if m.DetachDiskHook != nil {
		return m.DetachDiskHook(ctx, key, arg0, m)
	}
	return nil
}

// UpdateNetworkInterface is a mock for the corresponding method.
func (m *MockBetaInstances) UpdateNetworkInterface(ctx context.Context, key *meta.Key, arg0 string, arg1 *beta.NetworkInterface) error {
	if m.UpdateNetworkInterfaceHook != nil {
		return m.UpdateNetworkInterfaceHook(ctx, key, arg0, arg1, m)
	}
	return nil
}

// GCEBetaInstances is a simplifying adapter for the GCE Instances.
type GCEBetaInstances struct {
	s *Service
}

// Get the Instance named by key.
func (g *GCEBetaInstances) Get(ctx context.Context, key *meta.Key) (*beta.Instance, error) {
	klog.V(5).Infof("GCEBetaInstances.Get(%v, %v): called", ctx, key)

	if !key.Valid() {
		klog.V(2).Infof("GCEBetaInstances.Get(%v, %v): key is invalid (%#v)", ctx, key, key)
		return nil, fmt.Errorf("invalid GCE key (%#v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "beta", "Instances")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Get",
		Version:   meta.Version("beta"),
		Service:   "Instances",
	}
	klog.V(5).Infof("GCEBetaInstances.Get(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEBetaInstances.Get(%v, %v): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.Beta.Instances.Get(projectID, key.Zone, key.Name)
	call.Context(ctx)
	v, err := call.Do()
	klog.V(4).Infof("GCEBetaInstances.Get(%v, %v) = %+v, %v", ctx, key, v, err)
	return v, err
}

// List all Instance objects.
func (g *GCEBetaInstances) List(ctx context.Context, zone string, fl *filter.F) ([]*beta.Instance, error) {
	klog.V(5).Infof("GCEBetaInstances.List(%v, %v, %v) called", ctx, zone, fl)
	projectID := g.s.ProjectRouter.ProjectID(ctx, "beta", "Instances")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "List",
		Version:   meta.Version("beta"),
		Service:   "Instances",
	}
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		return nil, err
	}
	klog.V(5).Infof("GCEBetaInstances.List(%v, %v, %v): projectID = %v, rk = %+v", ctx, zone, fl, projectID, rk)
	call := g.s.Beta.Instances.List(projectID, zone)
	if fl != filter.None {
		call.Filter(fl.String())
	}
	var all []*beta.Instance
	f := func(l *beta.InstanceList) error {
		klog.V(5).Infof("GCEBetaInstances.List(%v, ..., %v): page %+v", ctx, fl, l)
		all = append(all, l.Items...)
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		klog.V(4).Infof("GCEBetaInstances.List(%v, ..., %v) = %v, %v", ctx, fl, nil, err)
		return nil, err
	}

	if klog.V(4).Enabled() {
		klog.V(4).Infof("GCEBetaInstances.List(%v, ..., %v) = [%v items], %v", ctx, fl, len(all), nil)
	} else if klog.V(5).Enabled() {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		klog.V(5).Infof("GCEBetaInstances.List(%v, ..., %v) = %v, %v", ctx, fl, asStr, nil)
	}

	return all, nil
}

// Insert Instance with key of value obj.
func (g *GCEBetaInstances) Insert(ctx context.Context, key *meta.Key, obj *beta.Instance) error {
	klog.V(5).Infof("GCEBetaInstances.Insert(%v, %v, %+v): called", ctx, key, obj)
	if !key.Valid() {
		klog.V(2).Infof("GCEBetaInstances.Insert(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "beta", "Instances")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Insert",
		Version:   meta.Version("beta"),
		Service:   "Instances",
	}
	klog.V(5).Infof("GCEBetaInstances.Insert(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEBetaInstances.Insert(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	obj.Name = key.Name
	call := g.s.Beta.Instances.Insert(projectID, key.Zone, obj)
	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCEBetaInstances.Insert(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEBetaInstances.Insert(%v, %v, %+v) = %+v", ctx, key, obj, err)
	return err
}

// Delete the Instance referenced by key.
func (g *GCEBetaInstances) Delete(ctx context.Context, key *meta.Key) error {
	klog.V(5).Infof("GCEBetaInstances.Delete(%v, %v): called", ctx, key)
	if !key.Valid() {
		klog.V(2).Infof("GCEBetaInstances.Delete(%v, %v): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "beta", "Instances")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Delete",
		Version:   meta.Version("beta"),
		Service:   "Instances",
	}
	klog.V(5).Infof("GCEBetaInstances.Delete(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEBetaInstances.Delete(%v, %v): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Beta.Instances.Delete(projectID, key.Zone, key.Name)
	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCEBetaInstances.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEBetaInstances.Delete(%v, %v) = %v", ctx, key, err)
	return err
}

// AttachDisk is a method on GCEBetaInstances.
func (g *GCEBetaInstances) AttachDisk(ctx context.Context, key *meta.Key, arg0 *beta.AttachedDisk) error {
	klog.V(5).Infof("GCEBetaInstances.AttachDisk(%v, %v, ...): called", ctx, key)

	if !key.Valid() {
		klog.V(2).Infof("GCEBetaInstances.AttachDisk(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "beta", "Instances")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "AttachDisk",
		Version:   meta.Version("beta"),
		Service:   "Instances",
	}
	klog.V(5).Infof("GCEBetaInstances.AttachDisk(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)

	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEBetaInstances.AttachDisk(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Beta.Instances.AttachDisk(projectID, key.Zone, key.Name, arg0)
	call.Context(ctx)
	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCEBetaInstances.AttachDisk(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}
	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEBetaInstances.AttachDisk(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// DetachDisk is a method on GCEBetaInstances.
func (g *GCEBetaInstances) DetachDisk(ctx context.Context, key *meta.Key, arg0 string) error {
	klog.V(5).Infof("GCEBetaInstances.DetachDisk(%v, %v, ...): called", ctx, key)

	if !key.Valid() {
		klog.V(2).Infof("GCEBetaInstances.DetachDisk(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "beta", "Instances")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "DetachDisk",
		Version:   meta.Version("beta"),
		Service:   "Instances",
	}
	klog.V(5).Infof("GCEBetaInstances.DetachDisk(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)

	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEBetaInstances.DetachDisk(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Beta.Instances.DetachDisk(projectID, key.Zone, key.Name, arg0)
	call.Context(ctx)
	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCEBetaInstances.DetachDisk(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}
	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEBetaInstances.DetachDisk(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// UpdateNetworkInterface is a method on GCEBetaInstances.
func (g *GCEBetaInstances) UpdateNetworkInterface(ctx context.Context, key *meta.Key, arg0 string, arg1 *beta.NetworkInterface) error {
	klog.V(5).Infof("GCEBetaInstances.UpdateNetworkInterface(%v, %v, ...): called", ctx, key)

	if !key.Valid() {
		klog.V(2).Infof("GCEBetaInstances.UpdateNetworkInterface(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "beta", "Instances")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "UpdateNetworkInterface",
		Version:   meta.Version("beta"),
		Service:   "Instances",
	}
	klog.V(5).Infof("GCEBetaInstances.UpdateNetworkInterface(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)

	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEBetaInstances.UpdateNetworkInterface(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Beta.Instances.UpdateNetworkInterface(projectID, key.Zone, key.Name, arg0, arg1)
	call.Context(ctx)
	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCEBetaInstances.UpdateNetworkInterface(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}
	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEBetaInstances.UpdateNetworkInterface(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// AlphaInstances is an interface that allows for mocking of Instances.
type AlphaInstances interface {
	Get(ctx context.Context, key *meta.Key) (*alpha.Instance, error)
	List(ctx context.Context, zone string, fl *filter.F) ([]*alpha.Instance, error)
	Insert(ctx context.Context, key *meta.Key, obj *alpha.Instance) error
	Delete(ctx context.Context, key *meta.Key) error
	AttachDisk(context.Context, *meta.Key, *alpha.AttachedDisk) error
	DetachDisk(context.Context, *meta.Key, string) error
	UpdateNetworkInterface(context.Context, *meta.Key, string, *alpha.NetworkInterface) error
}

// NewMockAlphaInstances returns a new mock for Instances.
func NewMockAlphaInstances(pr ProjectRouter, objs map[meta.Key]*MockInstancesObj) *MockAlphaInstances {
	mock := &MockAlphaInstances{
		ProjectRouter: pr,

		Objects:     objs,
		GetError:    map[meta.Key]error{},
		InsertError: map[meta.Key]error{},
		DeleteError: map[meta.Key]error{},
	}
	return mock
}

// MockAlphaInstances is the mock for Instances.
type MockAlphaInstances struct {
	Lock sync.Mutex

	ProjectRouter ProjectRouter

	// Objects maintained by the mock.
	Objects map[meta.Key]*MockInstancesObj

	// If an entry exists for the given key and operation, then the error
	// will be returned instead of the operation.
	GetError    map[meta.Key]error
	ListError   *error
	InsertError map[meta.Key]error
	DeleteError map[meta.Key]error

	// xxxHook allow you to intercept the standard processing of the mock in
	// order to add your own logic. Return (true, _, _) to prevent the normal
	// execution flow of the mock. Return (false, nil, nil) to continue with
	// normal mock behavior/ after the hook function executes.
	GetHook                    func(ctx context.Context, key *meta.Key, m *MockAlphaInstances) (bool, *alpha.Instance, error)
	ListHook                   func(ctx context.Context, zone string, fl *filter.F, m *MockAlphaInstances) (bool, []*alpha.Instance, error)
	InsertHook                 func(ctx context.Context, key *meta.Key, obj *alpha.Instance, m *MockAlphaInstances) (bool, error)
	DeleteHook                 func(ctx context.Context, key *meta.Key, m *MockAlphaInstances) (bool, error)
	AttachDiskHook             func(context.Context, *meta.Key, *alpha.AttachedDisk, *MockAlphaInstances) error
	DetachDiskHook             func(context.Context, *meta.Key, string, *MockAlphaInstances) error
	UpdateNetworkInterfaceHook func(context.Context, *meta.Key, string, *alpha.NetworkInterface, *MockAlphaInstances) error

	// X is extra state that can be used as part of the mock. Generated code
	// will not use this field.
	X interface{}
}

// Get returns the object from the mock.
func (m *MockAlphaInstances) Get(ctx context.Context, key *meta.Key) (*alpha.Instance, error) {
	if m.GetHook != nil {
		if intercept, obj, err := m.GetHook(ctx, key, m); intercept {
			klog.V(5).Infof("MockAlphaInstances.Get(%v, %s) = %+v, %v", ctx, key, obj, err)
			return obj, err
		}
	}
	if !key.Valid() {
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.GetError[*key]; ok {
		klog.V(5).Infof("MockAlphaInstances.Get(%v, %s) = nil, %v", ctx, key, err)
		return nil, err
	}
	if obj, ok := m.Objects[*key]; ok {
		typedObj := obj.ToAlpha()
		klog.V(5).Infof("MockAlphaInstances.Get(%v, %s) = %+v, nil", ctx, key, typedObj)
		return typedObj, nil
	}

	err := &googleapi.Error{
		Code:    http.StatusNotFound,
		Message: fmt.Sprintf("MockAlphaInstances %v not found", key),
	}
	klog.V(5).Infof("MockAlphaInstances.Get(%v, %s) = nil, %v", ctx, key, err)
	return nil, err
}

// List all of the objects in the mock in the given zone.
func (m *MockAlphaInstances) List(ctx context.Context, zone string, fl *filter.F) ([]*alpha.Instance, error) {
	if m.ListHook != nil {
		if intercept, objs, err := m.ListHook(ctx, zone, fl, m); intercept {
			klog.V(5).Infof("MockAlphaInstances.List(%v, %q, %v) = [%v items], %v", ctx, zone, fl, len(objs), err)
			return objs, err
		}
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if m.ListError != nil {
		err := *m.ListError
		klog.V(5).Infof("MockAlphaInstances.List(%v, %q, %v) = nil, %v", ctx, zone, fl, err)

		return nil, *m.ListError
	}

	var objs []*alpha.Instance
	for key, obj := range m.Objects {
		if key.Zone != zone {
			continue
		}
		if !fl.Match(obj.ToAlpha()) {
			continue
		}
		objs = append(objs, obj.ToAlpha())
	}

	klog.V(5).Infof("MockAlphaInstances.List(%v, %q, %v) = [%v items], nil", ctx, zone, fl, len(objs))
	return objs, nil
}

// Insert is a mock for inserting/creating a new object.
func (m *MockAlphaInstances) Insert(ctx context.Context, key *meta.Key, obj *alpha.Instance) error {
	if m.InsertHook != nil {
		if intercept, err := m.InsertHook(ctx, key, obj, m); intercept {
			klog.V(5).Infof("MockAlphaInstances.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.InsertError[*key]; ok {
		klog.V(5).Infof("MockAlphaInstances.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}
	if _, ok := m.Objects[*key]; ok {
		err := &googleapi.Error{
			Code:    http.StatusConflict,
			Message: fmt.Sprintf("MockAlphaInstances %v exists", key),
		}
		klog.V(5).Infof("MockAlphaInstances.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}

	obj.Name = key.Name
	projectID := m.ProjectRouter.ProjectID(ctx, "alpha", "instances")
	obj.SelfLink = SelfLink(meta.VersionAlpha, projectID, "instances", key)

	m.Objects[*key] = &MockInstancesObj{obj}
	klog.V(5).Infof("MockAlphaInstances.Insert(%v, %v, %+v) = nil", ctx, key, obj)
	return nil
}

// Delete is a mock for deleting the object.
func (m *MockAlphaInstances) Delete(ctx context.Context, key *meta.Key) error {
	if m.DeleteHook != nil {
		if intercept, err := m.DeleteHook(ctx, key, m); intercept {
			klog.V(5).Infof("MockAlphaInstances.Delete(%v, %v) = %v", ctx, key, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.DeleteError[*key]; ok {
		klog.V(5).Infof("MockAlphaInstances.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}
	if _, ok := m.Objects[*key]; !ok {
		err := &googleapi.Error{
			Code:    http.StatusNotFound,
			Message: fmt.Sprintf("MockAlphaInstances %v not found", key),
		}
		klog.V(5).Infof("MockAlphaInstances.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	delete(m.Objects, *key)
	klog.V(5).Infof("MockAlphaInstances.Delete(%v, %v) = nil", ctx, key)
	return nil
}

// Obj wraps the object for use in the mock.
func (m *MockAlphaInstances) Obj(o *alpha.Instance) *MockInstancesObj {
	return &MockInstancesObj{o}
}

// AttachDisk is a mock for the corresponding method.
func (m *MockAlphaInstances) AttachDisk(ctx context.Context, key *meta.Key, arg0 *alpha.AttachedDisk) error {
	if m.AttachDiskHook != nil {
		return m.AttachDiskHook(ctx, key, arg0, m)
	}
	return nil
}

// DetachDisk is a mock for the corresponding method.
func (m *MockAlphaInstances) DetachDisk(ctx context.Context, key *meta.Key, arg0 string) error {
	if m.DetachDiskHook != nil {
		return m.DetachDiskHook(ctx, key, arg0, m)
	}
	return nil
}

// UpdateNetworkInterface is a mock for the corresponding method.
func (m *MockAlphaInstances) UpdateNetworkInterface(ctx context.Context, key *meta.Key, arg0 string, arg1 *alpha.NetworkInterface) error {
	if m.UpdateNetworkInterfaceHook != nil {
		return m.UpdateNetworkInterfaceHook(ctx, key, arg0, arg1, m)
	}
	return nil
}

// GCEAlphaInstances is a simplifying adapter for the GCE Instances.
type GCEAlphaInstances struct {
	s *Service
}

// Get the Instance named by key.
func (g *GCEAlphaInstances) Get(ctx context.Context, key *meta.Key) (*alpha.Instance, error) {
	klog.V(5).Infof("GCEAlphaInstances.Get(%v, %v): called", ctx, key)

	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaInstances.Get(%v, %v): key is invalid (%#v)", ctx, key, key)
		return nil, fmt.Errorf("invalid GCE key (%#v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "alpha", "Instances")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Get",
		Version:   meta.Version("alpha"),
		Service:   "Instances",
	}
	klog.V(5).Infof("GCEAlphaInstances.Get(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEAlphaInstances.Get(%v, %v): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.Alpha.Instances.Get(projectID, key.Zone, key.Name)
	call.Context(ctx)
	v, err := call.Do()
	klog.V(4).Infof("GCEAlphaInstances.Get(%v, %v) = %+v, %v", ctx, key, v, err)
	return v, err
}

// List all Instance objects.
func (g *GCEAlphaInstances) List(ctx context.Context, zone string, fl *filter.F) ([]*alpha.Instance, error) {
	klog.V(5).Infof("GCEAlphaInstances.List(%v, %v, %v) called", ctx, zone, fl)
	projectID := g.s.ProjectRouter.ProjectID(ctx, "alpha", "Instances")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "List",
		Version:   meta.Version("alpha"),
		Service:   "Instances",
	}
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		return nil, err
	}
	klog.V(5).Infof("GCEAlphaInstances.List(%v, %v, %v): projectID = %v, rk = %+v", ctx, zone, fl, projectID, rk)
	call := g.s.Alpha.Instances.List(projectID, zone)
	if fl != filter.None {
		call.Filter(fl.String())
	}
	var all []*alpha.Instance
	f := func(l *alpha.InstanceList) error {
		klog.V(5).Infof("GCEAlphaInstances.List(%v, ..., %v): page %+v", ctx, fl, l)
		all = append(all, l.Items...)
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		klog.V(4).Infof("GCEAlphaInstances.List(%v, ..., %v) = %v, %v", ctx, fl, nil, err)
		return nil, err
	}

	if klog.V(4).Enabled() {
		klog.V(4).Infof("GCEAlphaInstances.List(%v, ..., %v) = [%v items], %v", ctx, fl, len(all), nil)
	} else if klog.V(5).Enabled() {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		klog.V(5).Infof("GCEAlphaInstances.List(%v, ..., %v) = %v, %v", ctx, fl, asStr, nil)
	}

	return all, nil
}

// Insert Instance with key of value obj.
func (g *GCEAlphaInstances) Insert(ctx context.Context, key *meta.Key, obj *alpha.Instance) error {
	klog.V(5).Infof("GCEAlphaInstances.Insert(%v, %v, %+v): called", ctx, key, obj)
	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaInstances.Insert(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "alpha", "Instances")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Insert",
		Version:   meta.Version("alpha"),
		Service:   "Instances",
	}
	klog.V(5).Infof("GCEAlphaInstances.Insert(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEAlphaInstances.Insert(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	obj.Name = key.Name
	call := g.s.Alpha.Instances.Insert(projectID, key.Zone, obj)
	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCEAlphaInstances.Insert(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEAlphaInstances.Insert(%v, %v, %+v) = %+v", ctx, key, obj, err)
	return err
}

// Delete the Instance referenced by key.
func (g *GCEAlphaInstances) Delete(ctx context.Context, key *meta.Key) error {
	klog.V(5).Infof("GCEAlphaInstances.Delete(%v, %v): called", ctx, key)
	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaInstances.Delete(%v, %v): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "alpha", "Instances")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Delete",
		Version:   meta.Version("alpha"),
		Service:   "Instances",
	}
	klog.V(5).Infof("GCEAlphaInstances.Delete(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEAlphaInstances.Delete(%v, %v): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Alpha.Instances.Delete(projectID, key.Zone, key.Name)
	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCEAlphaInstances.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEAlphaInstances.Delete(%v, %v) = %v", ctx, key, err)
	return err
}

// AttachDisk is a method on GCEAlphaInstances.
func (g *GCEAlphaInstances) AttachDisk(ctx context.Context, key *meta.Key, arg0 *alpha.AttachedDisk) error {
	klog.V(5).Infof("GCEAlphaInstances.AttachDisk(%v, %v, ...): called", ctx, key)

	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaInstances.AttachDisk(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "alpha", "Instances")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "AttachDisk",
		Version:   meta.Version("alpha"),
		Service:   "Instances",
	}
	klog.V(5).Infof("GCEAlphaInstances.AttachDisk(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)

	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEAlphaInstances.AttachDisk(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Alpha.Instances.AttachDisk(projectID, key.Zone, key.Name, arg0)
	call.Context(ctx)
	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCEAlphaInstances.AttachDisk(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}
	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEAlphaInstances.AttachDisk(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// DetachDisk is a method on GCEAlphaInstances.
func (g *GCEAlphaInstances) DetachDisk(ctx context.Context, key *meta.Key, arg0 string) error {
	klog.V(5).Infof("GCEAlphaInstances.DetachDisk(%v, %v, ...): called", ctx, key)

	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaInstances.DetachDisk(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "alpha", "Instances")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "DetachDisk",
		Version:   meta.Version("alpha"),
		Service:   "Instances",
	}
	klog.V(5).Infof("GCEAlphaInstances.DetachDisk(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)

	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEAlphaInstances.DetachDisk(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Alpha.Instances.DetachDisk(projectID, key.Zone, key.Name, arg0)
	call.Context(ctx)
	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCEAlphaInstances.DetachDisk(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}
	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEAlphaInstances.DetachDisk(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// UpdateNetworkInterface is a method on GCEAlphaInstances.
func (g *GCEAlphaInstances) UpdateNetworkInterface(ctx context.Context, key *meta.Key, arg0 string, arg1 *alpha.NetworkInterface) error {
	klog.V(5).Infof("GCEAlphaInstances.UpdateNetworkInterface(%v, %v, ...): called", ctx, key)

	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaInstances.UpdateNetworkInterface(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "alpha", "Instances")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "UpdateNetworkInterface",
		Version:   meta.Version("alpha"),
		Service:   "Instances",
	}
	klog.V(5).Infof("GCEAlphaInstances.UpdateNetworkInterface(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)

	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEAlphaInstances.UpdateNetworkInterface(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Alpha.Instances.UpdateNetworkInterface(projectID, key.Zone, key.Name, arg0, arg1)
	call.Context(ctx)
	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCEAlphaInstances.UpdateNetworkInterface(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}
	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEAlphaInstances.UpdateNetworkInterface(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// AlphaNetworks is an interface that allows for mocking of Networks.
type AlphaNetworks interface {
	Get(ctx context.Context, key *meta.Key) (*alpha.Network, error)
	List(ctx context.Context, fl *filter.F) ([]*alpha.Network, error)
	Insert(ctx context.Context, key *meta.Key, obj *alpha.Network) error
	Delete(ctx context.Context, key *meta.Key) error
}

// NewMockAlphaNetworks returns a new mock for Networks.
func NewMockAlphaNetworks(pr ProjectRouter, objs map[meta.Key]*MockNetworksObj) *MockAlphaNetworks {
	mock := &MockAlphaNetworks{
		ProjectRouter: pr,

		Objects:     objs,
		GetError:    map[meta.Key]error{},
		InsertError: map[meta.Key]error{},
		DeleteError: map[meta.Key]error{},
	}
	return mock
}

// MockAlphaNetworks is the mock for Networks.
type MockAlphaNetworks struct {
	Lock sync.Mutex

	ProjectRouter ProjectRouter

	// Objects maintained by the mock.
	Objects map[meta.Key]*MockNetworksObj

	// If an entry exists for the given key and operation, then the error
	// will be returned instead of the operation.
	GetError    map[meta.Key]error
	ListError   *error
	InsertError map[meta.Key]error
	DeleteError map[meta.Key]error

	// xxxHook allow you to intercept the standard processing of the mock in
	// order to add your own logic. Return (true, _, _) to prevent the normal
	// execution flow of the mock. Return (false, nil, nil) to continue with
	// normal mock behavior/ after the hook function executes.
	GetHook    func(ctx context.Context, key *meta.Key, m *MockAlphaNetworks) (bool, *alpha.Network, error)
	ListHook   func(ctx context.Context, fl *filter.F, m *MockAlphaNetworks) (bool, []*alpha.Network, error)
	InsertHook func(ctx context.Context, key *meta.Key, obj *alpha.Network, m *MockAlphaNetworks) (bool, error)
	DeleteHook func(ctx context.Context, key *meta.Key, m *MockAlphaNetworks) (bool, error)

	// X is extra state that can be used as part of the mock. Generated code
	// will not use this field.
	X interface{}
}

// Get returns the object from the mock.
func (m *MockAlphaNetworks) Get(ctx context.Context, key *meta.Key) (*alpha.Network, error) {
	if m.GetHook != nil {
		if intercept, obj, err := m.GetHook(ctx, key, m); intercept {
			klog.V(5).Infof("MockAlphaNetworks.Get(%v, %s) = %+v, %v", ctx, key, obj, err)
			return obj, err
		}
	}
	if !key.Valid() {
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.GetError[*key]; ok {
		klog.V(5).Infof("MockAlphaNetworks.Get(%v, %s) = nil, %v", ctx, key, err)
		return nil, err
	}
	if obj, ok := m.Objects[*key]; ok {
		typedObj := obj.ToAlpha()
		klog.V(5).Infof("MockAlphaNetworks.Get(%v, %s) = %+v, nil", ctx, key, typedObj)
		return typedObj, nil
	}

	err := &googleapi.Error{
		Code:    http.StatusNotFound,
		Message: fmt.Sprintf("MockAlphaNetworks %v not found", key),
	}
	klog.V(5).Infof("MockAlphaNetworks.Get(%v, %s) = nil, %v", ctx, key, err)
	return nil, err
}

// List all of the objects in the mock.
func (m *MockAlphaNetworks) List(ctx context.Context, fl *filter.F) ([]*alpha.Network, error) {
	if m.ListHook != nil {
		if intercept, objs, err := m.ListHook(ctx, fl, m); intercept {
			klog.V(5).Infof("MockAlphaNetworks.List(%v, %v) = [%v items], %v", ctx, fl, len(objs), err)
			return objs, err
		}
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if m.ListError != nil {
		err := *m.ListError
		klog.V(5).Infof("MockAlphaNetworks.List(%v, %v) = nil, %v", ctx, fl, err)

		return nil, *m.ListError
	}

	var objs []*alpha.Network
	for _, obj := range m.Objects {
		if !fl.Match(obj.ToAlpha()) {
			continue
		}
		objs = append(objs, obj.ToAlpha())
	}

	klog.V(5).Infof("MockAlphaNetworks.List(%v, %v) = [%v items], nil", ctx, fl, len(objs))
	return objs, nil
}

// Insert is a mock for inserting/creating a new object.
func (m *MockAlphaNetworks) Insert(ctx context.Context, key *meta.Key, obj *alpha.Network) error {
	if m.InsertHook != nil {
		if intercept, err := m.InsertHook(ctx, key, obj, m); intercept {
			klog.V(5).Infof("MockAlphaNetworks.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.InsertError[*key]; ok {
		klog.V(5).Infof("MockAlphaNetworks.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}
	if _, ok := m.Objects[*key]; ok {
		err := &googleapi.Error{
			Code:    http.StatusConflict,
			Message: fmt.Sprintf("MockAlphaNetworks %v exists", key),
		}
		klog.V(5).Infof("MockAlphaNetworks.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}

	obj.Name = key.Name
	projectID := m.ProjectRouter.ProjectID(ctx, "alpha", "networks")
	obj.SelfLink = SelfLink(meta.VersionAlpha, projectID, "networks", key)

	m.Objects[*key] = &MockNetworksObj{obj}
	klog.V(5).Infof("MockAlphaNetworks.Insert(%v, %v, %+v) = nil", ctx, key, obj)
	return nil
}

// Delete is a mock for deleting the object.
func (m *MockAlphaNetworks) Delete(ctx context.Context, key *meta.Key) error {
	if m.DeleteHook != nil {
		if intercept, err := m.DeleteHook(ctx, key, m); intercept {
			klog.V(5).Infof("MockAlphaNetworks.Delete(%v, %v) = %v", ctx, key, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.DeleteError[*key]; ok {
		klog.V(5).Infof("MockAlphaNetworks.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}
	if _, ok := m.Objects[*key]; !ok {
		err := &googleapi.Error{
			Code:    http.StatusNotFound,
			Message: fmt.Sprintf("MockAlphaNetworks %v not found", key),
		}
		klog.V(5).Infof("MockAlphaNetworks.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	delete(m.Objects, *key)
	klog.V(5).Infof("MockAlphaNetworks.Delete(%v, %v) = nil", ctx, key)
	return nil
}

// Obj wraps the object for use in the mock.
func (m *MockAlphaNetworks) Obj(o *alpha.Network) *MockNetworksObj {
	return &MockNetworksObj{o}
}

// GCEAlphaNetworks is a simplifying adapter for the GCE Networks.
type GCEAlphaNetworks struct {
	s *Service
}

// Get the Network named by key.
func (g *GCEAlphaNetworks) Get(ctx context.Context, key *meta.Key) (*alpha.Network, error) {
	klog.V(5).Infof("GCEAlphaNetworks.Get(%v, %v): called", ctx, key)

	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaNetworks.Get(%v, %v): key is invalid (%#v)", ctx, key, key)
		return nil, fmt.Errorf("invalid GCE key (%#v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "alpha", "Networks")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Get",
		Version:   meta.Version("alpha"),
		Service:   "Networks",
	}
	klog.V(5).Infof("GCEAlphaNetworks.Get(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEAlphaNetworks.Get(%v, %v): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.Alpha.Networks.Get(projectID, key.Name)
	call.Context(ctx)
	v, err := call.Do()
	klog.V(4).Infof("GCEAlphaNetworks.Get(%v, %v) = %+v, %v", ctx, key, v, err)
	return v, err
}

// List all Network objects.
func (g *GCEAlphaNetworks) List(ctx context.Context, fl *filter.F) ([]*alpha.Network, error) {
	klog.V(5).Infof("GCEAlphaNetworks.List(%v, %v) called", ctx, fl)
	projectID := g.s.ProjectRouter.ProjectID(ctx, "alpha", "Networks")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "List",
		Version:   meta.Version("alpha"),
		Service:   "Networks",
	}
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		return nil, err
	}
	klog.V(5).Infof("GCEAlphaNetworks.List(%v, %v): projectID = %v, rk = %+v", ctx, fl, projectID, rk)
	call := g.s.Alpha.Networks.List(projectID)
	if fl != filter.None {
		call.Filter(fl.String())
	}
	var all []*alpha.Network
	f := func(l *alpha.NetworkList) error {
		klog.V(5).Infof("GCEAlphaNetworks.List(%v, ..., %v): page %+v", ctx, fl, l)
		all = append(all, l.Items...)
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		klog.V(4).Infof("GCEAlphaNetworks.List(%v, ..., %v) = %v, %v", ctx, fl, nil, err)
		return nil, err
	}

	if klog.V(4).Enabled() {
		klog.V(4).Infof("GCEAlphaNetworks.List(%v, ..., %v) = [%v items], %v", ctx, fl, len(all), nil)
	} else if klog.V(5).Enabled() {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		klog.V(5).Infof("GCEAlphaNetworks.List(%v, ..., %v) = %v, %v", ctx, fl, asStr, nil)
	}

	return all, nil
}

// Insert Network with key of value obj.
func (g *GCEAlphaNetworks) Insert(ctx context.Context, key *meta.Key, obj *alpha.Network) error {
	klog.V(5).Infof("GCEAlphaNetworks.Insert(%v, %v, %+v): called", ctx, key, obj)
	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaNetworks.Insert(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "alpha", "Networks")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Insert",
		Version:   meta.Version("alpha"),
		Service:   "Networks",
	}
	klog.V(5).Infof("GCEAlphaNetworks.Insert(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEAlphaNetworks.Insert(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	obj.Name = key.Name
	call := g.s.Alpha.Networks.Insert(projectID, obj)
	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCEAlphaNetworks.Insert(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEAlphaNetworks.Insert(%v, %v, %+v) = %+v", ctx, key, obj, err)
	return err
}

// Delete the Network referenced by key.
func (g *GCEAlphaNetworks) Delete(ctx context.Context, key *meta.Key) error {
	klog.V(5).Infof("GCEAlphaNetworks.Delete(%v, %v): called", ctx, key)
	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaNetworks.Delete(%v, %v): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "alpha", "Networks")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Delete",
		Version:   meta.Version("alpha"),
		Service:   "Networks",
	}
	klog.V(5).Infof("GCEAlphaNetworks.Delete(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEAlphaNetworks.Delete(%v, %v): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Alpha.Networks.Delete(projectID, key.Name)

	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCEAlphaNetworks.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEAlphaNetworks.Delete(%v, %v) = %v", ctx, key, err)
	return err
}

// BetaNetworks is an interface that allows for mocking of Networks.
type BetaNetworks interface {
	Get(ctx context.Context, key *meta.Key) (*beta.Network, error)
	List(ctx context.Context, fl *filter.F) ([]*beta.Network, error)
	Insert(ctx context.Context, key *meta.Key, obj *beta.Network) error
	Delete(ctx context.Context, key *meta.Key) error
}

// NewMockBetaNetworks returns a new mock for Networks.
func NewMockBetaNetworks(pr ProjectRouter, objs map[meta.Key]*MockNetworksObj) *MockBetaNetworks {
	mock := &MockBetaNetworks{
		ProjectRouter: pr,

		Objects:     objs,
		GetError:    map[meta.Key]error{},
		InsertError: map[meta.Key]error{},
		DeleteError: map[meta.Key]error{},
	}
	return mock
}

// MockBetaNetworks is the mock for Networks.
type MockBetaNetworks struct {
	Lock sync.Mutex

	ProjectRouter ProjectRouter

	// Objects maintained by the mock.
	Objects map[meta.Key]*MockNetworksObj

	// If an entry exists for the given key and operation, then the error
	// will be returned instead of the operation.
	GetError    map[meta.Key]error
	ListError   *error
	InsertError map[meta.Key]error
	DeleteError map[meta.Key]error

	// xxxHook allow you to intercept the standard processing of the mock in
	// order to add your own logic. Return (true, _, _) to prevent the normal
	// execution flow of the mock. Return (false, nil, nil) to continue with
	// normal mock behavior/ after the hook function executes.
	GetHook    func(ctx context.Context, key *meta.Key, m *MockBetaNetworks) (bool, *beta.Network, error)
	ListHook   func(ctx context.Context, fl *filter.F, m *MockBetaNetworks) (bool, []*beta.Network, error)
	InsertHook func(ctx context.Context, key *meta.Key, obj *beta.Network, m *MockBetaNetworks) (bool, error)
	DeleteHook func(ctx context.Context, key *meta.Key, m *MockBetaNetworks) (bool, error)

	// X is extra state that can be used as part of the mock. Generated code
	// will not use this field.
	X interface{}
}

// Get returns the object from the mock.
func (m *MockBetaNetworks) Get(ctx context.Context, key *meta.Key) (*beta.Network, error) {
	if m.GetHook != nil {
		if intercept, obj, err := m.GetHook(ctx, key, m); intercept {
			klog.V(5).Infof("MockBetaNetworks.Get(%v, %s) = %+v, %v", ctx, key, obj, err)
			return obj, err
		}
	}
	if !key.Valid() {
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.GetError[*key]; ok {
		klog.V(5).Infof("MockBetaNetworks.Get(%v, %s) = nil, %v", ctx, key, err)
		return nil, err
	}
	if obj, ok := m.Objects[*key]; ok {
		typedObj := obj.ToBeta()
		klog.V(5).Infof("MockBetaNetworks.Get(%v, %s) = %+v, nil", ctx, key, typedObj)
		return typedObj, nil
	}

	err := &googleapi.Error{
		Code:    http.StatusNotFound,
		Message: fmt.Sprintf("MockBetaNetworks %v not found", key),
	}
	klog.V(5).Infof("MockBetaNetworks.Get(%v, %s) = nil, %v", ctx, key, err)
	return nil, err
}

// List all of the objects in the mock.
func (m *MockBetaNetworks) List(ctx context.Context, fl *filter.F) ([]*beta.Network, error) {
	if m.ListHook != nil {
		if intercept, objs, err := m.ListHook(ctx, fl, m); intercept {
			klog.V(5).Infof("MockBetaNetworks.List(%v, %v) = [%v items], %v", ctx, fl, len(objs), err)
			return objs, err
		}
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if m.ListError != nil {
		err := *m.ListError
		klog.V(5).Infof("MockBetaNetworks.List(%v, %v) = nil, %v", ctx, fl, err)

		return nil, *m.ListError
	}

	var objs []*beta.Network
	for _, obj := range m.Objects {
		if !fl.Match(obj.ToBeta()) {
			continue
		}
		objs = append(objs, obj.ToBeta())
	}

	klog.V(5).Infof("MockBetaNetworks.List(%v, %v) = [%v items], nil", ctx, fl, len(objs))
	return objs, nil
}

// Insert is a mock for inserting/creating a new object.
func (m *MockBetaNetworks) Insert(ctx context.Context, key *meta.Key, obj *beta.Network) error {
	if m.InsertHook != nil {
		if intercept, err := m.InsertHook(ctx, key, obj, m); intercept {
			klog.V(5).Infof("MockBetaNetworks.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.InsertError[*key]; ok {
		klog.V(5).Infof("MockBetaNetworks.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}
	if _, ok := m.Objects[*key]; ok {
		err := &googleapi.Error{
			Code:    http.StatusConflict,
			Message: fmt.Sprintf("MockBetaNetworks %v exists", key),
		}
		klog.V(5).Infof("MockBetaNetworks.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}

	obj.Name = key.Name
	projectID := m.ProjectRouter.ProjectID(ctx, "beta", "networks")
	obj.SelfLink = SelfLink(meta.VersionBeta, projectID, "networks", key)

	m.Objects[*key] = &MockNetworksObj{obj}
	klog.V(5).Infof("MockBetaNetworks.Insert(%v, %v, %+v) = nil", ctx, key, obj)
	return nil
}

// Delete is a mock for deleting the object.
func (m *MockBetaNetworks) Delete(ctx context.Context, key *meta.Key) error {
	if m.DeleteHook != nil {
		if intercept, err := m.DeleteHook(ctx, key, m); intercept {
			klog.V(5).Infof("MockBetaNetworks.Delete(%v, %v) = %v", ctx, key, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.DeleteError[*key]; ok {
		klog.V(5).Infof("MockBetaNetworks.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}
	if _, ok := m.Objects[*key]; !ok {
		err := &googleapi.Error{
			Code:    http.StatusNotFound,
			Message: fmt.Sprintf("MockBetaNetworks %v not found", key),
		}
		klog.V(5).Infof("MockBetaNetworks.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	delete(m.Objects, *key)
	klog.V(5).Infof("MockBetaNetworks.Delete(%v, %v) = nil", ctx, key)
	return nil
}

// Obj wraps the object for use in the mock.
func (m *MockBetaNetworks) Obj(o *beta.Network) *MockNetworksObj {
	return &MockNetworksObj{o}
}

// GCEBetaNetworks is a simplifying adapter for the GCE Networks.
type GCEBetaNetworks struct {
	s *Service
}

// Get the Network named by key.
func (g *GCEBetaNetworks) Get(ctx context.Context, key *meta.Key) (*beta.Network, error) {
	klog.V(5).Infof("GCEBetaNetworks.Get(%v, %v): called", ctx, key)

	if !key.Valid() {
		klog.V(2).Infof("GCEBetaNetworks.Get(%v, %v): key is invalid (%#v)", ctx, key, key)
		return nil, fmt.Errorf("invalid GCE key (%#v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "beta", "Networks")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Get",
		Version:   meta.Version("beta"),
		Service:   "Networks",
	}
	klog.V(5).Infof("GCEBetaNetworks.Get(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEBetaNetworks.Get(%v, %v): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.Beta.Networks.Get(projectID, key.Name)
	call.Context(ctx)
	v, err := call.Do()
	klog.V(4).Infof("GCEBetaNetworks.Get(%v, %v) = %+v, %v", ctx, key, v, err)
	return v, err
}

// List all Network objects.
func (g *GCEBetaNetworks) List(ctx context.Context, fl *filter.F) ([]*beta.Network, error) {
	klog.V(5).Infof("GCEBetaNetworks.List(%v, %v) called", ctx, fl)
	projectID := g.s.ProjectRouter.ProjectID(ctx, "beta", "Networks")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "List",
		Version:   meta.Version("beta"),
		Service:   "Networks",
	}
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		return nil, err
	}
	klog.V(5).Infof("GCEBetaNetworks.List(%v, %v): projectID = %v, rk = %+v", ctx, fl, projectID, rk)
	call := g.s.Beta.Networks.List(projectID)
	if fl != filter.None {
		call.Filter(fl.String())
	}
	var all []*beta.Network
	f := func(l *beta.NetworkList) error {
		klog.V(5).Infof("GCEBetaNetworks.List(%v, ..., %v): page %+v", ctx, fl, l)
		all = append(all, l.Items...)
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		klog.V(4).Infof("GCEBetaNetworks.List(%v, ..., %v) = %v, %v", ctx, fl, nil, err)
		return nil, err
	}

	if klog.V(4).Enabled() {
		klog.V(4).Infof("GCEBetaNetworks.List(%v, ..., %v) = [%v items], %v", ctx, fl, len(all), nil)
	} else if klog.V(5).Enabled() {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		klog.V(5).Infof("GCEBetaNetworks.List(%v, ..., %v) = %v, %v", ctx, fl, asStr, nil)
	}

	return all, nil
}

// Insert Network with key of value obj.
func (g *GCEBetaNetworks) Insert(ctx context.Context, key *meta.Key, obj *beta.Network) error {
	klog.V(5).Infof("GCEBetaNetworks.Insert(%v, %v, %+v): called", ctx, key, obj)
	if !key.Valid() {
		klog.V(2).Infof("GCEBetaNetworks.Insert(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "beta", "Networks")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Insert",
		Version:   meta.Version("beta"),
		Service:   "Networks",
	}
	klog.V(5).Infof("GCEBetaNetworks.Insert(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEBetaNetworks.Insert(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	obj.Name = key.Name
	call := g.s.Beta.Networks.Insert(projectID, obj)
	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCEBetaNetworks.Insert(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEBetaNetworks.Insert(%v, %v, %+v) = %+v", ctx, key, obj, err)
	return err
}

// Delete the Network referenced by key.
func (g *GCEBetaNetworks) Delete(ctx context.Context, key *meta.Key) error {
	klog.V(5).Infof("GCEBetaNetworks.Delete(%v, %v): called", ctx, key)
	if !key.Valid() {
		klog.V(2).Infof("GCEBetaNetworks.Delete(%v, %v): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "beta", "Networks")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Delete",
		Version:   meta.Version("beta"),
		Service:   "Networks",
	}
	klog.V(5).Infof("GCEBetaNetworks.Delete(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEBetaNetworks.Delete(%v, %v): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Beta.Networks.Delete(projectID, key.Name)

	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCEBetaNetworks.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEBetaNetworks.Delete(%v, %v) = %v", ctx, key, err)
	return err
}

// Networks is an interface that allows for mocking of Networks.
type Networks interface {
	Get(ctx context.Context, key *meta.Key) (*ga.Network, error)
	List(ctx context.Context, fl *filter.F) ([]*ga.Network, error)
	Insert(ctx context.Context, key *meta.Key, obj *ga.Network) error
	Delete(ctx context.Context, key *meta.Key) error
}

// NewMockNetworks returns a new mock for Networks.
func NewMockNetworks(pr ProjectRouter, objs map[meta.Key]*MockNetworksObj) *MockNetworks {
	mock := &MockNetworks{
		ProjectRouter: pr,

		Objects:     objs,
		GetError:    map[meta.Key]error{},
		InsertError: map[meta.Key]error{},
		DeleteError: map[meta.Key]error{},
	}
	return mock
}

// MockNetworks is the mock for Networks.
type MockNetworks struct {
	Lock sync.Mutex

	ProjectRouter ProjectRouter

	// Objects maintained by the mock.
	Objects map[meta.Key]*MockNetworksObj

	// If an entry exists for the given key and operation, then the error
	// will be returned instead of the operation.
	GetError    map[meta.Key]error
	ListError   *error
	InsertError map[meta.Key]error
	DeleteError map[meta.Key]error

	// xxxHook allow you to intercept the standard processing of the mock in
	// order to add your own logic. Return (true, _, _) to prevent the normal
	// execution flow of the mock. Return (false, nil, nil) to continue with
	// normal mock behavior/ after the hook function executes.
	GetHook    func(ctx context.Context, key *meta.Key, m *MockNetworks) (bool, *ga.Network, error)
	ListHook   func(ctx context.Context, fl *filter.F, m *MockNetworks) (bool, []*ga.Network, error)
	InsertHook func(ctx context.Context, key *meta.Key, obj *ga.Network, m *MockNetworks) (bool, error)
	DeleteHook func(ctx context.Context, key *meta.Key, m *MockNetworks) (bool, error)

	// X is extra state that can be used as part of the mock. Generated code
	// will not use this field.
	X interface{}
}

// Get returns the object from the mock.
func (m *MockNetworks) Get(ctx context.Context, key *meta.Key) (*ga.Network, error) {
	if m.GetHook != nil {
		if intercept, obj, err := m.GetHook(ctx, key, m); intercept {
			klog.V(5).Infof("MockNetworks.Get(%v, %s) = %+v, %v", ctx, key, obj, err)
			return obj, err
		}
	}
	if !key.Valid() {
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.GetError[*key]; ok {
		klog.V(5).Infof("MockNetworks.Get(%v, %s) = nil, %v", ctx, key, err)
		return nil, err
	}
	if obj, ok := m.Objects[*key]; ok {
		typedObj := obj.ToGA()
		klog.V(5).Infof("MockNetworks.Get(%v, %s) = %+v, nil", ctx, key, typedObj)
		return typedObj, nil
	}

	err := &googleapi.Error{
		Code:    http.StatusNotFound,
		Message: fmt.Sprintf("MockNetworks %v not found", key),
	}
	klog.V(5).Infof("MockNetworks.Get(%v, %s) = nil, %v", ctx, key, err)
	return nil, err
}

// List all of the objects in the mock.
func (m *MockNetworks) List(ctx context.Context, fl *filter.F) ([]*ga.Network, error) {
	if m.ListHook != nil {
		if intercept, objs, err := m.ListHook(ctx, fl, m); intercept {
			klog.V(5).Infof("MockNetworks.List(%v, %v) = [%v items], %v", ctx, fl, len(objs), err)
			return objs, err
		}
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if m.ListError != nil {
		err := *m.ListError
		klog.V(5).Infof("MockNetworks.List(%v, %v) = nil, %v", ctx, fl, err)

		return nil, *m.ListError
	}

	var objs []*ga.Network
	for _, obj := range m.Objects {
		if !fl.Match(obj.ToGA()) {
			continue
		}
		objs = append(objs, obj.ToGA())
	}

	klog.V(5).Infof("MockNetworks.List(%v, %v) = [%v items], nil", ctx, fl, len(objs))
	return objs, nil
}

// Insert is a mock for inserting/creating a new object.
func (m *MockNetworks) Insert(ctx context.Context, key *meta.Key, obj *ga.Network) error {
	if m.InsertHook != nil {
		if intercept, err := m.InsertHook(ctx, key, obj, m); intercept {
			klog.V(5).Infof("MockNetworks.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.InsertError[*key]; ok {
		klog.V(5).Infof("MockNetworks.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}
	if _, ok := m.Objects[*key]; ok {
		err := &googleapi.Error{
			Code:    http.StatusConflict,
			Message: fmt.Sprintf("MockNetworks %v exists", key),
		}
		klog.V(5).Infof("MockNetworks.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}

	obj.Name = key.Name
	projectID := m.ProjectRouter.ProjectID(ctx, "ga", "networks")
	obj.SelfLink = SelfLink(meta.VersionGA, projectID, "networks", key)

	m.Objects[*key] = &MockNetworksObj{obj}
	klog.V(5).Infof("MockNetworks.Insert(%v, %v, %+v) = nil", ctx, key, obj)
	return nil
}

// Delete is a mock for deleting the object.
func (m *MockNetworks) Delete(ctx context.Context, key *meta.Key) error {
	if m.DeleteHook != nil {
		if intercept, err := m.DeleteHook(ctx, key, m); intercept {
			klog.V(5).Infof("MockNetworks.Delete(%v, %v) = %v", ctx, key, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.DeleteError[*key]; ok {
		klog.V(5).Infof("MockNetworks.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}
	if _, ok := m.Objects[*key]; !ok {
		err := &googleapi.Error{
			Code:    http.StatusNotFound,
			Message: fmt.Sprintf("MockNetworks %v not found", key),
		}
		klog.V(5).Infof("MockNetworks.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	delete(m.Objects, *key)
	klog.V(5).Infof("MockNetworks.Delete(%v, %v) = nil", ctx, key)
	return nil
}

// Obj wraps the object for use in the mock.
func (m *MockNetworks) Obj(o *ga.Network) *MockNetworksObj {
	return &MockNetworksObj{o}
}

// GCENetworks is a simplifying adapter for the GCE Networks.
type GCENetworks struct {
	s *Service
}

// Get the Network named by key.
func (g *GCENetworks) Get(ctx context.Context, key *meta.Key) (*ga.Network, error) {
	klog.V(5).Infof("GCENetworks.Get(%v, %v): called", ctx, key)

	if !key.Valid() {
		klog.V(2).Infof("GCENetworks.Get(%v, %v): key is invalid (%#v)", ctx, key, key)
		return nil, fmt.Errorf("invalid GCE key (%#v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "Networks")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Get",
		Version:   meta.Version("ga"),
		Service:   "Networks",
	}
	klog.V(5).Infof("GCENetworks.Get(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCENetworks.Get(%v, %v): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.GA.Networks.Get(projectID, key.Name)
	call.Context(ctx)
	v, err := call.Do()
	klog.V(4).Infof("GCENetworks.Get(%v, %v) = %+v, %v", ctx, key, v, err)
	return v, err
}

// List all Network objects.
func (g *GCENetworks) List(ctx context.Context, fl *filter.F) ([]*ga.Network, error) {
	klog.V(5).Infof("GCENetworks.List(%v, %v) called", ctx, fl)
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "Networks")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "List",
		Version:   meta.Version("ga"),
		Service:   "Networks",
	}
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		return nil, err
	}
	klog.V(5).Infof("GCENetworks.List(%v, %v): projectID = %v, rk = %+v", ctx, fl, projectID, rk)
	call := g.s.GA.Networks.List(projectID)
	if fl != filter.None {
		call.Filter(fl.String())
	}
	var all []*ga.Network
	f := func(l *ga.NetworkList) error {
		klog.V(5).Infof("GCENetworks.List(%v, ..., %v): page %+v", ctx, fl, l)
		all = append(all, l.Items...)
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		klog.V(4).Infof("GCENetworks.List(%v, ..., %v) = %v, %v", ctx, fl, nil, err)
		return nil, err
	}

	if klog.V(4).Enabled() {
		klog.V(4).Infof("GCENetworks.List(%v, ..., %v) = [%v items], %v", ctx, fl, len(all), nil)
	} else if klog.V(5).Enabled() {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		klog.V(5).Infof("GCENetworks.List(%v, ..., %v) = %v, %v", ctx, fl, asStr, nil)
	}

	return all, nil
}

// Insert Network with key of value obj.
func (g *GCENetworks) Insert(ctx context.Context, key *meta.Key, obj *ga.Network) error {
	klog.V(5).Infof("GCENetworks.Insert(%v, %v, %+v): called", ctx, key, obj)
	if !key.Valid() {
		klog.V(2).Infof("GCENetworks.Insert(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "Networks")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Insert",
		Version:   meta.Version("ga"),
		Service:   "Networks",
	}
	klog.V(5).Infof("GCENetworks.Insert(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCENetworks.Insert(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	obj.Name = key.Name
	call := g.s.GA.Networks.Insert(projectID, obj)
	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCENetworks.Insert(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCENetworks.Insert(%v, %v, %+v) = %+v", ctx, key, obj, err)
	return err
}

// Delete the Network referenced by key.
func (g *GCENetworks) Delete(ctx context.Context, key *meta.Key) error {
	klog.V(5).Infof("GCENetworks.Delete(%v, %v): called", ctx, key)
	if !key.Valid() {
		klog.V(2).Infof("GCENetworks.Delete(%v, %v): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "Networks")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Delete",
		Version:   meta.Version("ga"),
		Service:   "Networks",
	}
	klog.V(5).Infof("GCENetworks.Delete(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCENetworks.Delete(%v, %v): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.GA.Networks.Delete(projectID, key.Name)

	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCENetworks.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCENetworks.Delete(%v, %v) = %v", ctx, key, err)
	return err
}

// AlphaNetworkEndpointGroups is an interface that allows for mocking of NetworkEndpointGroups.
type AlphaNetworkEndpointGroups interface {
	Get(ctx context.Context, key *meta.Key) (*alpha.NetworkEndpointGroup, error)
	List(ctx context.Context, zone string, fl *filter.F) ([]*alpha.NetworkEndpointGroup, error)
	Insert(ctx context.Context, key *meta.Key, obj *alpha.NetworkEndpointGroup) error
	Delete(ctx context.Context, key *meta.Key) error
	AggregatedList(ctx context.Context, fl *filter.F) (map[string][]*alpha.NetworkEndpointGroup, error)
	AttachNetworkEndpoints(context.Context, *meta.Key, *alpha.NetworkEndpointGroupsAttachEndpointsRequest) error
	DetachNetworkEndpoints(context.Context, *meta.Key, *alpha.NetworkEndpointGroupsDetachEndpointsRequest) error
	ListNetworkEndpoints(context.Context, *meta.Key, *alpha.NetworkEndpointGroupsListEndpointsRequest, *filter.F) ([]*alpha.NetworkEndpointWithHealthStatus, error)
}

// NewMockAlphaNetworkEndpointGroups returns a new mock for NetworkEndpointGroups.
func NewMockAlphaNetworkEndpointGroups(pr ProjectRouter, objs map[meta.Key]*MockNetworkEndpointGroupsObj) *MockAlphaNetworkEndpointGroups {
	mock := &MockAlphaNetworkEndpointGroups{
		ProjectRouter: pr,

		Objects:     objs,
		GetError:    map[meta.Key]error{},
		InsertError: map[meta.Key]error{},
		DeleteError: map[meta.Key]error{},
	}
	return mock
}

// MockAlphaNetworkEndpointGroups is the mock for NetworkEndpointGroups.
type MockAlphaNetworkEndpointGroups struct {
	Lock sync.Mutex

	ProjectRouter ProjectRouter

	// Objects maintained by the mock.
	Objects map[meta.Key]*MockNetworkEndpointGroupsObj

	// If an entry exists for the given key and operation, then the error
	// will be returned instead of the operation.
	GetError            map[meta.Key]error
	ListError           *error
	InsertError         map[meta.Key]error
	DeleteError         map[meta.Key]error
	AggregatedListError *error

	// xxxHook allow you to intercept the standard processing of the mock in
	// order to add your own logic. Return (true, _, _) to prevent the normal
	// execution flow of the mock. Return (false, nil, nil) to continue with
	// normal mock behavior/ after the hook function executes.
	GetHook                    func(ctx context.Context, key *meta.Key, m *MockAlphaNetworkEndpointGroups) (bool, *alpha.NetworkEndpointGroup, error)
	ListHook                   func(ctx context.Context, zone string, fl *filter.F, m *MockAlphaNetworkEndpointGroups) (bool, []*alpha.NetworkEndpointGroup, error)
	InsertHook                 func(ctx context.Context, key *meta.Key, obj *alpha.NetworkEndpointGroup, m *MockAlphaNetworkEndpointGroups) (bool, error)
	DeleteHook                 func(ctx context.Context, key *meta.Key, m *MockAlphaNetworkEndpointGroups) (bool, error)
	AggregatedListHook         func(ctx context.Context, fl *filter.F, m *MockAlphaNetworkEndpointGroups) (bool, map[string][]*alpha.NetworkEndpointGroup, error)
	AttachNetworkEndpointsHook func(context.Context, *meta.Key, *alpha.NetworkEndpointGroupsAttachEndpointsRequest, *MockAlphaNetworkEndpointGroups) error
	DetachNetworkEndpointsHook func(context.Context, *meta.Key, *alpha.NetworkEndpointGroupsDetachEndpointsRequest, *MockAlphaNetworkEndpointGroups) error
	ListNetworkEndpointsHook   func(context.Context, *meta.Key, *alpha.NetworkEndpointGroupsListEndpointsRequest, *filter.F, *MockAlphaNetworkEndpointGroups) ([]*alpha.NetworkEndpointWithHealthStatus, error)

	// X is extra state that can be used as part of the mock. Generated code
	// will not use this field.
	X interface{}
}

// Get returns the object from the mock.
func (m *MockAlphaNetworkEndpointGroups) Get(ctx context.Context, key *meta.Key) (*alpha.NetworkEndpointGroup, error) {
	if m.GetHook != nil {
		if intercept, obj, err := m.GetHook(ctx, key, m); intercept {
			klog.V(5).Infof("MockAlphaNetworkEndpointGroups.Get(%v, %s) = %+v, %v", ctx, key, obj, err)
			return obj, err
		}
	}
	if !key.Valid() {
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.GetError[*key]; ok {
		klog.V(5).Infof("MockAlphaNetworkEndpointGroups.Get(%v, %s) = nil, %v", ctx, key, err)
		return nil, err
	}
	if obj, ok := m.Objects[*key]; ok {
		typedObj := obj.ToAlpha()
		klog.V(5).Infof("MockAlphaNetworkEndpointGroups.Get(%v, %s) = %+v, nil", ctx, key, typedObj)
		return typedObj, nil
	}

	err := &googleapi.Error{
		Code:    http.StatusNotFound,
		Message: fmt.Sprintf("MockAlphaNetworkEndpointGroups %v not found", key),
	}
	klog.V(5).Infof("MockAlphaNetworkEndpointGroups.Get(%v, %s) = nil, %v", ctx, key, err)
	return nil, err
}

// List all of the objects in the mock in the given zone.
func (m *MockAlphaNetworkEndpointGroups) List(ctx context.Context, zone string, fl *filter.F) ([]*alpha.NetworkEndpointGroup, error) {
	if m.ListHook != nil {
		if intercept, objs, err := m.ListHook(ctx, zone, fl, m); intercept {
			klog.V(5).Infof("MockAlphaNetworkEndpointGroups.List(%v, %q, %v) = [%v items], %v", ctx, zone, fl, len(objs), err)
			return objs, err
		}
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if m.ListError != nil {
		err := *m.ListError
		klog.V(5).Infof("MockAlphaNetworkEndpointGroups.List(%v, %q, %v) = nil, %v", ctx, zone, fl, err)

		return nil, *m.ListError
	}

	var objs []*alpha.NetworkEndpointGroup
	for key, obj := range m.Objects {
		if key.Zone != zone {
			continue
		}
		if !fl.Match(obj.ToAlpha()) {
			continue
		}
		objs = append(objs, obj.ToAlpha())
	}

	klog.V(5).Infof("MockAlphaNetworkEndpointGroups.List(%v, %q, %v) = [%v items], nil", ctx, zone, fl, len(objs))
	return objs, nil
}

// Insert is a mock for inserting/creating a new object.
func (m *MockAlphaNetworkEndpointGroups) Insert(ctx context.Context, key *meta.Key, obj *alpha.NetworkEndpointGroup) error {
	if m.InsertHook != nil {
		if intercept, err := m.InsertHook(ctx, key, obj, m); intercept {
			klog.V(5).Infof("MockAlphaNetworkEndpointGroups.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.InsertError[*key]; ok {
		klog.V(5).Infof("MockAlphaNetworkEndpointGroups.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}
	if _, ok := m.Objects[*key]; ok {
		err := &googleapi.Error{
			Code:    http.StatusConflict,
			Message: fmt.Sprintf("MockAlphaNetworkEndpointGroups %v exists", key),
		}
		klog.V(5).Infof("MockAlphaNetworkEndpointGroups.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}

	obj.Name = key.Name
	projectID := m.ProjectRouter.ProjectID(ctx, "alpha", "networkEndpointGroups")
	obj.SelfLink = SelfLink(meta.VersionAlpha, projectID, "networkEndpointGroups", key)

	m.Objects[*key] = &MockNetworkEndpointGroupsObj{obj}
	klog.V(5).Infof("MockAlphaNetworkEndpointGroups.Insert(%v, %v, %+v) = nil", ctx, key, obj)
	return nil
}

// Delete is a mock for deleting the object.
func (m *MockAlphaNetworkEndpointGroups) Delete(ctx context.Context, key *meta.Key) error {
	if m.DeleteHook != nil {
		if intercept, err := m.DeleteHook(ctx, key, m); intercept {
			klog.V(5).Infof("MockAlphaNetworkEndpointGroups.Delete(%v, %v) = %v", ctx, key, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.DeleteError[*key]; ok {
		klog.V(5).Infof("MockAlphaNetworkEndpointGroups.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}
	if _, ok := m.Objects[*key]; !ok {
		err := &googleapi.Error{
			Code:    http.StatusNotFound,
			Message: fmt.Sprintf("MockAlphaNetworkEndpointGroups %v not found", key),
		}
		klog.V(5).Infof("MockAlphaNetworkEndpointGroups.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	delete(m.Objects, *key)
	klog.V(5).Infof("MockAlphaNetworkEndpointGroups.Delete(%v, %v) = nil", ctx, key)
	return nil
}

// AggregatedList is a mock for AggregatedList.
func (m *MockAlphaNetworkEndpointGroups) AggregatedList(ctx context.Context, fl *filter.F) (map[string][]*alpha.NetworkEndpointGroup, error) {
	if m.AggregatedListHook != nil {
		if intercept, objs, err := m.AggregatedListHook(ctx, fl, m); intercept {
			klog.V(5).Infof("MockAlphaNetworkEndpointGroups.AggregatedList(%v, %v) = [%v items], %v", ctx, fl, len(objs), err)
			return objs, err
		}
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if m.AggregatedListError != nil {
		err := *m.AggregatedListError
		klog.V(5).Infof("MockAlphaNetworkEndpointGroups.AggregatedList(%v, %v) = nil, %v", ctx, fl, err)
		return nil, err
	}

	objs := map[string][]*alpha.NetworkEndpointGroup{}
	for _, obj := range m.Objects {
		res, err := ParseResourceURL(obj.ToAlpha().SelfLink)
		if err != nil {
			klog.V(5).Infof("MockAlphaNetworkEndpointGroups.AggregatedList(%v, %v) = nil, %v", ctx, fl, err)
			return nil, err
		}
		if !fl.Match(obj.ToAlpha()) {
			continue
		}
		location := aggregatedListKey(res.Key)
		objs[location] = append(objs[location], obj.ToAlpha())
	}
	klog.V(5).Infof("MockAlphaNetworkEndpointGroups.AggregatedList(%v, %v) = [%v items], nil", ctx, fl, len(objs))
	return objs, nil
}

// Obj wraps the object for use in the mock.
func (m *MockAlphaNetworkEndpointGroups) Obj(o *alpha.NetworkEndpointGroup) *MockNetworkEndpointGroupsObj {
	return &MockNetworkEndpointGroupsObj{o}
}

// AttachNetworkEndpoints is a mock for the corresponding method.
func (m *MockAlphaNetworkEndpointGroups) AttachNetworkEndpoints(ctx context.Context, key *meta.Key, arg0 *alpha.NetworkEndpointGroupsAttachEndpointsRequest) error {
	if m.AttachNetworkEndpointsHook != nil {
		return m.AttachNetworkEndpointsHook(ctx, key, arg0, m)
	}
	return nil
}

// DetachNetworkEndpoints is a mock for the corresponding method.
func (m *MockAlphaNetworkEndpointGroups) DetachNetworkEndpoints(ctx context.Context, key *meta.Key, arg0 *alpha.NetworkEndpointGroupsDetachEndpointsRequest) error {
	if m.DetachNetworkEndpointsHook != nil {
		return m.DetachNetworkEndpointsHook(ctx, key, arg0, m)
	}
	return nil
}

// ListNetworkEndpoints is a mock for the corresponding method.
func (m *MockAlphaNetworkEndpointGroups) ListNetworkEndpoints(ctx context.Context, key *meta.Key, arg0 *alpha.NetworkEndpointGroupsListEndpointsRequest, fl *filter.F) ([]*alpha.NetworkEndpointWithHealthStatus, error) {
	if m.ListNetworkEndpointsHook != nil {
		return m.ListNetworkEndpointsHook(ctx, key, arg0, fl, m)
	}
	return nil, nil
}

// GCEAlphaNetworkEndpointGroups is a simplifying adapter for the GCE NetworkEndpointGroups.
type GCEAlphaNetworkEndpointGroups struct {
	s *Service
}

// Get the NetworkEndpointGroup named by key.
func (g *GCEAlphaNetworkEndpointGroups) Get(ctx context.Context, key *meta.Key) (*alpha.NetworkEndpointGroup, error) {
	klog.V(5).Infof("GCEAlphaNetworkEndpointGroups.Get(%v, %v): called", ctx, key)

	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaNetworkEndpointGroups.Get(%v, %v): key is invalid (%#v)", ctx, key, key)
		return nil, fmt.Errorf("invalid GCE key (%#v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "alpha", "NetworkEndpointGroups")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Get",
		Version:   meta.Version("alpha"),
		Service:   "NetworkEndpointGroups",
	}
	klog.V(5).Infof("GCEAlphaNetworkEndpointGroups.Get(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEAlphaNetworkEndpointGroups.Get(%v, %v): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.Alpha.NetworkEndpointGroups.Get(projectID, key.Zone, key.Name)
	call.Context(ctx)
	v, err := call.Do()
	klog.V(4).Infof("GCEAlphaNetworkEndpointGroups.Get(%v, %v) = %+v, %v", ctx, key, v, err)
	return v, err
}

// List all NetworkEndpointGroup objects.
func (g *GCEAlphaNetworkEndpointGroups) List(ctx context.Context, zone string, fl *filter.F) ([]*alpha.NetworkEndpointGroup, error) {
	klog.V(5).Infof("GCEAlphaNetworkEndpointGroups.List(%v, %v, %v) called", ctx, zone, fl)
	projectID := g.s.ProjectRouter.ProjectID(ctx, "alpha", "NetworkEndpointGroups")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "List",
		Version:   meta.Version("alpha"),
		Service:   "NetworkEndpointGroups",
	}
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		return nil, err
	}
	klog.V(5).Infof("GCEAlphaNetworkEndpointGroups.List(%v, %v, %v): projectID = %v, rk = %+v", ctx, zone, fl, projectID, rk)
	call := g.s.Alpha.NetworkEndpointGroups.List(projectID, zone)
	if fl != filter.None {
		call.Filter(fl.String())
	}
	var all []*alpha.NetworkEndpointGroup
	f := func(l *alpha.NetworkEndpointGroupList) error {
		klog.V(5).Infof("GCEAlphaNetworkEndpointGroups.List(%v, ..., %v): page %+v", ctx, fl, l)
		all = append(all, l.Items...)
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		klog.V(4).Infof("GCEAlphaNetworkEndpointGroups.List(%v, ..., %v) = %v, %v", ctx, fl, nil, err)
		return nil, err
	}

	if klog.V(4).Enabled() {
		klog.V(4).Infof("GCEAlphaNetworkEndpointGroups.List(%v, ..., %v) = [%v items], %v", ctx, fl, len(all), nil)
	} else if klog.V(5).Enabled() {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		klog.V(5).Infof("GCEAlphaNetworkEndpointGroups.List(%v, ..., %v) = %v, %v", ctx, fl, asStr, nil)
	}

	return all, nil
}

// Insert NetworkEndpointGroup with key of value obj.
func (g *GCEAlphaNetworkEndpointGroups) Insert(ctx context.Context, key *meta.Key, obj *alpha.NetworkEndpointGroup) error {
	klog.V(5).Infof("GCEAlphaNetworkEndpointGroups.Insert(%v, %v, %+v): called", ctx, key, obj)
	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaNetworkEndpointGroups.Insert(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "alpha", "NetworkEndpointGroups")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Insert",
		Version:   meta.Version("alpha"),
		Service:   "NetworkEndpointGroups",
	}
	klog.V(5).Infof("GCEAlphaNetworkEndpointGroups.Insert(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEAlphaNetworkEndpointGroups.Insert(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	obj.Name = key.Name
	call := g.s.Alpha.NetworkEndpointGroups.Insert(projectID, key.Zone, obj)
	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCEAlphaNetworkEndpointGroups.Insert(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEAlphaNetworkEndpointGroups.Insert(%v, %v, %+v) = %+v", ctx, key, obj, err)
	return err
}

// Delete the NetworkEndpointGroup referenced by key.
func (g *GCEAlphaNetworkEndpointGroups) Delete(ctx context.Context, key *meta.Key) error {
	klog.V(5).Infof("GCEAlphaNetworkEndpointGroups.Delete(%v, %v): called", ctx, key)
	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaNetworkEndpointGroups.Delete(%v, %v): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "alpha", "NetworkEndpointGroups")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Delete",
		Version:   meta.Version("alpha"),
		Service:   "NetworkEndpointGroups",
	}
	klog.V(5).Infof("GCEAlphaNetworkEndpointGroups.Delete(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEAlphaNetworkEndpointGroups.Delete(%v, %v): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Alpha.NetworkEndpointGroups.Delete(projectID, key.Zone, key.Name)
	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCEAlphaNetworkEndpointGroups.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEAlphaNetworkEndpointGroups.Delete(%v, %v) = %v", ctx, key, err)
	return err
}

// AggregatedList lists all resources of the given type across all locations.
func (g *GCEAlphaNetworkEndpointGroups) AggregatedList(ctx context.Context, fl *filter.F) (map[string][]*alpha.NetworkEndpointGroup, error) {
	klog.V(5).Infof("GCEAlphaNetworkEndpointGroups.AggregatedList(%v, %v) called", ctx, fl)

	projectID := g.s.ProjectRouter.ProjectID(ctx, "alpha", "NetworkEndpointGroups")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "AggregatedList",
		Version:   meta.Version("alpha"),
		Service:   "NetworkEndpointGroups",
	}

	klog.V(5).Infof("GCEAlphaNetworkEndpointGroups.AggregatedList(%v, %v): projectID = %v, rk = %+v", ctx, fl, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(5).Infof("GCEAlphaNetworkEndpointGroups.AggregatedList(%v, %v): RateLimiter error: %v", ctx, fl, err)
		return nil, err
	}

	call := g.s.Alpha.NetworkEndpointGroups.AggregatedList(projectID)
	call.Context(ctx)
	if fl != filter.None {
		call.Filter(fl.String())
	}

	all := map[string][]*alpha.NetworkEndpointGroup{}
	f := func(l *alpha.NetworkEndpointGroupAggregatedList) error {
		for k, v := range l.Items {
			klog.V(5).Infof("GCEAlphaNetworkEndpointGroups.AggregatedList(%v, %v): page[%v]%+v", ctx, fl, k, v)
			all[k] = append(all[k], v.NetworkEndpointGroups...)
		}
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		klog.V(4).Infof("GCEAlphaNetworkEndpointGroups.AggregatedList(%v, %v) = %v, %v", ctx, fl, nil, err)
		return nil, err
	}
	if klog.V(4).Enabled() {
		klog.V(4).Infof("GCEAlphaNetworkEndpointGroups.AggregatedList(%v, %v) = [%v items], %v", ctx, fl, len(all), nil)
	} else if klog.V(5).Enabled() {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		klog.V(5).Infof("GCEAlphaNetworkEndpointGroups.AggregatedList(%v, %v) = %v, %v", ctx, fl, asStr, nil)
	}
	return all, nil
}

// AttachNetworkEndpoints is a method on GCEAlphaNetworkEndpointGroups.
func (g *GCEAlphaNetworkEndpointGroups) AttachNetworkEndpoints(ctx context.Context, key *meta.Key, arg0 *alpha.NetworkEndpointGroupsAttachEndpointsRequest) error {
	klog.V(5).Infof("GCEAlphaNetworkEndpointGroups.AttachNetworkEndpoints(%v, %v, ...): called", ctx, key)

	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaNetworkEndpointGroups.AttachNetworkEndpoints(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "alpha", "NetworkEndpointGroups")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "AttachNetworkEndpoints",
		Version:   meta.Version("alpha"),
		Service:   "NetworkEndpointGroups",
	}
	klog.V(5).Infof("GCEAlphaNetworkEndpointGroups.AttachNetworkEndpoints(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)

	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEAlphaNetworkEndpointGroups.AttachNetworkEndpoints(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Alpha.NetworkEndpointGroups.AttachNetworkEndpoints(projectID, key.Zone, key.Name, arg0)
	call.Context(ctx)
	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCEAlphaNetworkEndpointGroups.AttachNetworkEndpoints(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}
	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEAlphaNetworkEndpointGroups.AttachNetworkEndpoints(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// DetachNetworkEndpoints is a method on GCEAlphaNetworkEndpointGroups.
func (g *GCEAlphaNetworkEndpointGroups) DetachNetworkEndpoints(ctx context.Context, key *meta.Key, arg0 *alpha.NetworkEndpointGroupsDetachEndpointsRequest) error {
	klog.V(5).Infof("GCEAlphaNetworkEndpointGroups.DetachNetworkEndpoints(%v, %v, ...): called", ctx, key)

	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaNetworkEndpointGroups.DetachNetworkEndpoints(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "alpha", "NetworkEndpointGroups")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "DetachNetworkEndpoints",
		Version:   meta.Version("alpha"),
		Service:   "NetworkEndpointGroups",
	}
	klog.V(5).Infof("GCEAlphaNetworkEndpointGroups.DetachNetworkEndpoints(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)

	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEAlphaNetworkEndpointGroups.DetachNetworkEndpoints(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Alpha.NetworkEndpointGroups.DetachNetworkEndpoints(projectID, key.Zone, key.Name, arg0)
	call.Context(ctx)
	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCEAlphaNetworkEndpointGroups.DetachNetworkEndpoints(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}
	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEAlphaNetworkEndpointGroups.DetachNetworkEndpoints(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// ListNetworkEndpoints is a method on GCEAlphaNetworkEndpointGroups.
func (g *GCEAlphaNetworkEndpointGroups) ListNetworkEndpoints(ctx context.Context, key *meta.Key, arg0 *alpha.NetworkEndpointGroupsListEndpointsRequest, fl *filter.F) ([]*alpha.NetworkEndpointWithHealthStatus, error) {
	klog.V(5).Infof("GCEAlphaNetworkEndpointGroups.ListNetworkEndpoints(%v, %v, ...): called", ctx, key)

	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaNetworkEndpointGroups.ListNetworkEndpoints(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "alpha", "NetworkEndpointGroups")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "ListNetworkEndpoints",
		Version:   meta.Version("alpha"),
		Service:   "NetworkEndpointGroups",
	}
	klog.V(5).Infof("GCEAlphaNetworkEndpointGroups.ListNetworkEndpoints(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)

	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEAlphaNetworkEndpointGroups.ListNetworkEndpoints(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.Alpha.NetworkEndpointGroups.ListNetworkEndpoints(projectID, key.Zone, key.Name, arg0)
	var all []*alpha.NetworkEndpointWithHealthStatus
	f := func(l *alpha.NetworkEndpointGroupsListNetworkEndpoints) error {
		klog.V(5).Infof("GCEAlphaNetworkEndpointGroups.ListNetworkEndpoints(%v, %v, ...): page %+v", ctx, key, l)
		all = append(all, l.Items...)
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		klog.V(4).Infof("GCEAlphaNetworkEndpointGroups.ListNetworkEndpoints(%v, %v, ...) = %v, %v", ctx, key, nil, err)
		return nil, err
	}
	if klog.V(4).Enabled() {
		klog.V(4).Infof("GCEAlphaNetworkEndpointGroups.ListNetworkEndpoints(%v, %v, ...) = [%v items], %v", ctx, key, len(all), nil)
	} else if klog.V(5).Enabled() {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		klog.V(5).Infof("GCEAlphaNetworkEndpointGroups.ListNetworkEndpoints(%v, %v, ...) = %v, %v", ctx, key, asStr, nil)
	}
	return all, nil
}

// BetaNetworkEndpointGroups is an interface that allows for mocking of NetworkEndpointGroups.
type BetaNetworkEndpointGroups interface {
	Get(ctx context.Context, key *meta.Key) (*beta.NetworkEndpointGroup, error)
	List(ctx context.Context, zone string, fl *filter.F) ([]*beta.NetworkEndpointGroup, error)
	Insert(ctx context.Context, key *meta.Key, obj *beta.NetworkEndpointGroup) error
	Delete(ctx context.Context, key *meta.Key) error
	AggregatedList(ctx context.Context, fl *filter.F) (map[string][]*beta.NetworkEndpointGroup, error)
	AttachNetworkEndpoints(context.Context, *meta.Key, *beta.NetworkEndpointGroupsAttachEndpointsRequest) error
	DetachNetworkEndpoints(context.Context, *meta.Key, *beta.NetworkEndpointGroupsDetachEndpointsRequest) error
	ListNetworkEndpoints(context.Context, *meta.Key, *beta.NetworkEndpointGroupsListEndpointsRequest, *filter.F) ([]*beta.NetworkEndpointWithHealthStatus, error)
}

// NewMockBetaNetworkEndpointGroups returns a new mock for NetworkEndpointGroups.
func NewMockBetaNetworkEndpointGroups(pr ProjectRouter, objs map[meta.Key]*MockNetworkEndpointGroupsObj) *MockBetaNetworkEndpointGroups {
	mock := &MockBetaNetworkEndpointGroups{
		ProjectRouter: pr,

		Objects:     objs,
		GetError:    map[meta.Key]error{},
		InsertError: map[meta.Key]error{},
		DeleteError: map[meta.Key]error{},
	}
	return mock
}

// MockBetaNetworkEndpointGroups is the mock for NetworkEndpointGroups.
type MockBetaNetworkEndpointGroups struct {
	Lock sync.Mutex

	ProjectRouter ProjectRouter

	// Objects maintained by the mock.
	Objects map[meta.Key]*MockNetworkEndpointGroupsObj

	// If an entry exists for the given key and operation, then the error
	// will be returned instead of the operation.
	GetError            map[meta.Key]error
	ListError           *error
	InsertError         map[meta.Key]error
	DeleteError         map[meta.Key]error
	AggregatedListError *error

	// xxxHook allow you to intercept the standard processing of the mock in
	// order to add your own logic. Return (true, _, _) to prevent the normal
	// execution flow of the mock. Return (false, nil, nil) to continue with
	// normal mock behavior/ after the hook function executes.
	GetHook                    func(ctx context.Context, key *meta.Key, m *MockBetaNetworkEndpointGroups) (bool, *beta.NetworkEndpointGroup, error)
	ListHook                   func(ctx context.Context, zone string, fl *filter.F, m *MockBetaNetworkEndpointGroups) (bool, []*beta.NetworkEndpointGroup, error)
	InsertHook                 func(ctx context.Context, key *meta.Key, obj *beta.NetworkEndpointGroup, m *MockBetaNetworkEndpointGroups) (bool, error)
	DeleteHook                 func(ctx context.Context, key *meta.Key, m *MockBetaNetworkEndpointGroups) (bool, error)
	AggregatedListHook         func(ctx context.Context, fl *filter.F, m *MockBetaNetworkEndpointGroups) (bool, map[string][]*beta.NetworkEndpointGroup, error)
	AttachNetworkEndpointsHook func(context.Context, *meta.Key, *beta.NetworkEndpointGroupsAttachEndpointsRequest, *MockBetaNetworkEndpointGroups) error
	DetachNetworkEndpointsHook func(context.Context, *meta.Key, *beta.NetworkEndpointGroupsDetachEndpointsRequest, *MockBetaNetworkEndpointGroups) error
	ListNetworkEndpointsHook   func(context.Context, *meta.Key, *beta.NetworkEndpointGroupsListEndpointsRequest, *filter.F, *MockBetaNetworkEndpointGroups) ([]*beta.NetworkEndpointWithHealthStatus, error)

	// X is extra state that can be used as part of the mock. Generated code
	// will not use this field.
	X interface{}
}

// Get returns the object from the mock.
func (m *MockBetaNetworkEndpointGroups) Get(ctx context.Context, key *meta.Key) (*beta.NetworkEndpointGroup, error) {
	if m.GetHook != nil {
		if intercept, obj, err := m.GetHook(ctx, key, m); intercept {
			klog.V(5).Infof("MockBetaNetworkEndpointGroups.Get(%v, %s) = %+v, %v", ctx, key, obj, err)
			return obj, err
		}
	}
	if !key.Valid() {
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.GetError[*key]; ok {
		klog.V(5).Infof("MockBetaNetworkEndpointGroups.Get(%v, %s) = nil, %v", ctx, key, err)
		return nil, err
	}
	if obj, ok := m.Objects[*key]; ok {
		typedObj := obj.ToBeta()
		klog.V(5).Infof("MockBetaNetworkEndpointGroups.Get(%v, %s) = %+v, nil", ctx, key, typedObj)
		return typedObj, nil
	}

	err := &googleapi.Error{
		Code:    http.StatusNotFound,
		Message: fmt.Sprintf("MockBetaNetworkEndpointGroups %v not found", key),
	}
	klog.V(5).Infof("MockBetaNetworkEndpointGroups.Get(%v, %s) = nil, %v", ctx, key, err)
	return nil, err
}

// List all of the objects in the mock in the given zone.
func (m *MockBetaNetworkEndpointGroups) List(ctx context.Context, zone string, fl *filter.F) ([]*beta.NetworkEndpointGroup, error) {
	if m.ListHook != nil {
		if intercept, objs, err := m.ListHook(ctx, zone, fl, m); intercept {
			klog.V(5).Infof("MockBetaNetworkEndpointGroups.List(%v, %q, %v) = [%v items], %v", ctx, zone, fl, len(objs), err)
			return objs, err
		}
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if m.ListError != nil {
		err := *m.ListError
		klog.V(5).Infof("MockBetaNetworkEndpointGroups.List(%v, %q, %v) = nil, %v", ctx, zone, fl, err)

		return nil, *m.ListError
	}

	var objs []*beta.NetworkEndpointGroup
	for key, obj := range m.Objects {
		if key.Zone != zone {
			continue
		}
		if !fl.Match(obj.ToBeta()) {
			continue
		}
		objs = append(objs, obj.ToBeta())
	}

	klog.V(5).Infof("MockBetaNetworkEndpointGroups.List(%v, %q, %v) = [%v items], nil", ctx, zone, fl, len(objs))
	return objs, nil
}

// Insert is a mock for inserting/creating a new object.
func (m *MockBetaNetworkEndpointGroups) Insert(ctx context.Context, key *meta.Key, obj *beta.NetworkEndpointGroup) error {
	if m.InsertHook != nil {
		if intercept, err := m.InsertHook(ctx, key, obj, m); intercept {
			klog.V(5).Infof("MockBetaNetworkEndpointGroups.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.InsertError[*key]; ok {
		klog.V(5).Infof("MockBetaNetworkEndpointGroups.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}
	if _, ok := m.Objects[*key]; ok {
		err := &googleapi.Error{
			Code:    http.StatusConflict,
			Message: fmt.Sprintf("MockBetaNetworkEndpointGroups %v exists", key),
		}
		klog.V(5).Infof("MockBetaNetworkEndpointGroups.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}

	obj.Name = key.Name
	projectID := m.ProjectRouter.ProjectID(ctx, "beta", "networkEndpointGroups")
	obj.SelfLink = SelfLink(meta.VersionBeta, projectID, "networkEndpointGroups", key)

	m.Objects[*key] = &MockNetworkEndpointGroupsObj{obj}
	klog.V(5).Infof("MockBetaNetworkEndpointGroups.Insert(%v, %v, %+v) = nil", ctx, key, obj)
	return nil
}

// Delete is a mock for deleting the object.
func (m *MockBetaNetworkEndpointGroups) Delete(ctx context.Context, key *meta.Key) error {
	if m.DeleteHook != nil {
		if intercept, err := m.DeleteHook(ctx, key, m); intercept {
			klog.V(5).Infof("MockBetaNetworkEndpointGroups.Delete(%v, %v) = %v", ctx, key, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.DeleteError[*key]; ok {
		klog.V(5).Infof("MockBetaNetworkEndpointGroups.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}
	if _, ok := m.Objects[*key]; !ok {
		err := &googleapi.Error{
			Code:    http.StatusNotFound,
			Message: fmt.Sprintf("MockBetaNetworkEndpointGroups %v not found", key),
		}
		klog.V(5).Infof("MockBetaNetworkEndpointGroups.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	delete(m.Objects, *key)
	klog.V(5).Infof("MockBetaNetworkEndpointGroups.Delete(%v, %v) = nil", ctx, key)
	return nil
}

// AggregatedList is a mock for AggregatedList.
func (m *MockBetaNetworkEndpointGroups) AggregatedList(ctx context.Context, fl *filter.F) (map[string][]*beta.NetworkEndpointGroup, error) {
	if m.AggregatedListHook != nil {
		if intercept, objs, err := m.AggregatedListHook(ctx, fl, m); intercept {
			klog.V(5).Infof("MockBetaNetworkEndpointGroups.AggregatedList(%v, %v) = [%v items], %v", ctx, fl, len(objs), err)
			return objs, err
		}
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if m.AggregatedListError != nil {
		err := *m.AggregatedListError
		klog.V(5).Infof("MockBetaNetworkEndpointGroups.AggregatedList(%v, %v) = nil, %v", ctx, fl, err)
		return nil, err
	}

	objs := map[string][]*beta.NetworkEndpointGroup{}
	for _, obj := range m.Objects {
		res, err := ParseResourceURL(obj.ToBeta().SelfLink)
		if err != nil {
			klog.V(5).Infof("MockBetaNetworkEndpointGroups.AggregatedList(%v, %v) = nil, %v", ctx, fl, err)
			return nil, err
		}
		if !fl.Match(obj.ToBeta()) {
			continue
		}
		location := aggregatedListKey(res.Key)
		objs[location] = append(objs[location], obj.ToBeta())
	}
	klog.V(5).Infof("MockBetaNetworkEndpointGroups.AggregatedList(%v, %v) = [%v items], nil", ctx, fl, len(objs))
	return objs, nil
}

// Obj wraps the object for use in the mock.
func (m *MockBetaNetworkEndpointGroups) Obj(o *beta.NetworkEndpointGroup) *MockNetworkEndpointGroupsObj {
	return &MockNetworkEndpointGroupsObj{o}
}

// AttachNetworkEndpoints is a mock for the corresponding method.
func (m *MockBetaNetworkEndpointGroups) AttachNetworkEndpoints(ctx context.Context, key *meta.Key, arg0 *beta.NetworkEndpointGroupsAttachEndpointsRequest) error {
	if m.AttachNetworkEndpointsHook != nil {
		return m.AttachNetworkEndpointsHook(ctx, key, arg0, m)
	}
	return nil
}

// DetachNetworkEndpoints is a mock for the corresponding method.
func (m *MockBetaNetworkEndpointGroups) DetachNetworkEndpoints(ctx context.Context, key *meta.Key, arg0 *beta.NetworkEndpointGroupsDetachEndpointsRequest) error {
	if m.DetachNetworkEndpointsHook != nil {
		return m.DetachNetworkEndpointsHook(ctx, key, arg0, m)
	}
	return nil
}

// ListNetworkEndpoints is a mock for the corresponding method.
func (m *MockBetaNetworkEndpointGroups) ListNetworkEndpoints(ctx context.Context, key *meta.Key, arg0 *beta.NetworkEndpointGroupsListEndpointsRequest, fl *filter.F) ([]*beta.NetworkEndpointWithHealthStatus, error) {
	if m.ListNetworkEndpointsHook != nil {
		return m.ListNetworkEndpointsHook(ctx, key, arg0, fl, m)
	}
	return nil, nil
}

// GCEBetaNetworkEndpointGroups is a simplifying adapter for the GCE NetworkEndpointGroups.
type GCEBetaNetworkEndpointGroups struct {
	s *Service
}

// Get the NetworkEndpointGroup named by key.
func (g *GCEBetaNetworkEndpointGroups) Get(ctx context.Context, key *meta.Key) (*beta.NetworkEndpointGroup, error) {
	klog.V(5).Infof("GCEBetaNetworkEndpointGroups.Get(%v, %v): called", ctx, key)

	if !key.Valid() {
		klog.V(2).Infof("GCEBetaNetworkEndpointGroups.Get(%v, %v): key is invalid (%#v)", ctx, key, key)
		return nil, fmt.Errorf("invalid GCE key (%#v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "beta", "NetworkEndpointGroups")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Get",
		Version:   meta.Version("beta"),
		Service:   "NetworkEndpointGroups",
	}
	klog.V(5).Infof("GCEBetaNetworkEndpointGroups.Get(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEBetaNetworkEndpointGroups.Get(%v, %v): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.Beta.NetworkEndpointGroups.Get(projectID, key.Zone, key.Name)
	call.Context(ctx)
	v, err := call.Do()
	klog.V(4).Infof("GCEBetaNetworkEndpointGroups.Get(%v, %v) = %+v, %v", ctx, key, v, err)
	return v, err
}

// List all NetworkEndpointGroup objects.
func (g *GCEBetaNetworkEndpointGroups) List(ctx context.Context, zone string, fl *filter.F) ([]*beta.NetworkEndpointGroup, error) {
	klog.V(5).Infof("GCEBetaNetworkEndpointGroups.List(%v, %v, %v) called", ctx, zone, fl)
	projectID := g.s.ProjectRouter.ProjectID(ctx, "beta", "NetworkEndpointGroups")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "List",
		Version:   meta.Version("beta"),
		Service:   "NetworkEndpointGroups",
	}
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		return nil, err
	}
	klog.V(5).Infof("GCEBetaNetworkEndpointGroups.List(%v, %v, %v): projectID = %v, rk = %+v", ctx, zone, fl, projectID, rk)
	call := g.s.Beta.NetworkEndpointGroups.List(projectID, zone)
	if fl != filter.None {
		call.Filter(fl.String())
	}
	var all []*beta.NetworkEndpointGroup
	f := func(l *beta.NetworkEndpointGroupList) error {
		klog.V(5).Infof("GCEBetaNetworkEndpointGroups.List(%v, ..., %v): page %+v", ctx, fl, l)
		all = append(all, l.Items...)
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		klog.V(4).Infof("GCEBetaNetworkEndpointGroups.List(%v, ..., %v) = %v, %v", ctx, fl, nil, err)
		return nil, err
	}

	if klog.V(4).Enabled() {
		klog.V(4).Infof("GCEBetaNetworkEndpointGroups.List(%v, ..., %v) = [%v items], %v", ctx, fl, len(all), nil)
	} else if klog.V(5).Enabled() {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		klog.V(5).Infof("GCEBetaNetworkEndpointGroups.List(%v, ..., %v) = %v, %v", ctx, fl, asStr, nil)
	}

	return all, nil
}

// Insert NetworkEndpointGroup with key of value obj.
func (g *GCEBetaNetworkEndpointGroups) Insert(ctx context.Context, key *meta.Key, obj *beta.NetworkEndpointGroup) error {
	klog.V(5).Infof("GCEBetaNetworkEndpointGroups.Insert(%v, %v, %+v): called", ctx, key, obj)
	if !key.Valid() {
		klog.V(2).Infof("GCEBetaNetworkEndpointGroups.Insert(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "beta", "NetworkEndpointGroups")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Insert",
		Version:   meta.Version("beta"),
		Service:   "NetworkEndpointGroups",
	}
	klog.V(5).Infof("GCEBetaNetworkEndpointGroups.Insert(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEBetaNetworkEndpointGroups.Insert(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	obj.Name = key.Name
	call := g.s.Beta.NetworkEndpointGroups.Insert(projectID, key.Zone, obj)
	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCEBetaNetworkEndpointGroups.Insert(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEBetaNetworkEndpointGroups.Insert(%v, %v, %+v) = %+v", ctx, key, obj, err)
	return err
}

// Delete the NetworkEndpointGroup referenced by key.
func (g *GCEBetaNetworkEndpointGroups) Delete(ctx context.Context, key *meta.Key) error {
	klog.V(5).Infof("GCEBetaNetworkEndpointGroups.Delete(%v, %v): called", ctx, key)
	if !key.Valid() {
		klog.V(2).Infof("GCEBetaNetworkEndpointGroups.Delete(%v, %v): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "beta", "NetworkEndpointGroups")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Delete",
		Version:   meta.Version("beta"),
		Service:   "NetworkEndpointGroups",
	}
	klog.V(5).Infof("GCEBetaNetworkEndpointGroups.Delete(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEBetaNetworkEndpointGroups.Delete(%v, %v): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Beta.NetworkEndpointGroups.Delete(projectID, key.Zone, key.Name)
	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCEBetaNetworkEndpointGroups.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEBetaNetworkEndpointGroups.Delete(%v, %v) = %v", ctx, key, err)
	return err
}

// AggregatedList lists all resources of the given type across all locations.
func (g *GCEBetaNetworkEndpointGroups) AggregatedList(ctx context.Context, fl *filter.F) (map[string][]*beta.NetworkEndpointGroup, error) {
	klog.V(5).Infof("GCEBetaNetworkEndpointGroups.AggregatedList(%v, %v) called", ctx, fl)

	projectID := g.s.ProjectRouter.ProjectID(ctx, "beta", "NetworkEndpointGroups")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "AggregatedList",
		Version:   meta.Version("beta"),
		Service:   "NetworkEndpointGroups",
	}

	klog.V(5).Infof("GCEBetaNetworkEndpointGroups.AggregatedList(%v, %v): projectID = %v, rk = %+v", ctx, fl, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(5).Infof("GCEBetaNetworkEndpointGroups.AggregatedList(%v, %v): RateLimiter error: %v", ctx, fl, err)
		return nil, err
	}

	call := g.s.Beta.NetworkEndpointGroups.AggregatedList(projectID)
	call.Context(ctx)
	if fl != filter.None {
		call.Filter(fl.String())
	}

	all := map[string][]*beta.NetworkEndpointGroup{}
	f := func(l *beta.NetworkEndpointGroupAggregatedList) error {
		for k, v := range l.Items {
			klog.V(5).Infof("GCEBetaNetworkEndpointGroups.AggregatedList(%v, %v): page[%v]%+v", ctx, fl, k, v)
			all[k] = append(all[k], v.NetworkEndpointGroups...)
		}
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		klog.V(4).Infof("GCEBetaNetworkEndpointGroups.AggregatedList(%v, %v) = %v, %v", ctx, fl, nil, err)
		return nil, err
	}
	if klog.V(4).Enabled() {
		klog.V(4).Infof("GCEBetaNetworkEndpointGroups.AggregatedList(%v, %v) = [%v items], %v", ctx, fl, len(all), nil)
	} else if klog.V(5).Enabled() {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		klog.V(5).Infof("GCEBetaNetworkEndpointGroups.AggregatedList(%v, %v) = %v, %v", ctx, fl, asStr, nil)
	}
	return all, nil
}

// AttachNetworkEndpoints is a method on GCEBetaNetworkEndpointGroups.
func (g *GCEBetaNetworkEndpointGroups) AttachNetworkEndpoints(ctx context.Context, key *meta.Key, arg0 *beta.NetworkEndpointGroupsAttachEndpointsRequest) error {
	klog.V(5).Infof("GCEBetaNetworkEndpointGroups.AttachNetworkEndpoints(%v, %v, ...): called", ctx, key)

	if !key.Valid() {
		klog.V(2).Infof("GCEBetaNetworkEndpointGroups.AttachNetworkEndpoints(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "beta", "NetworkEndpointGroups")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "AttachNetworkEndpoints",
		Version:   meta.Version("beta"),
		Service:   "NetworkEndpointGroups",
	}
	klog.V(5).Infof("GCEBetaNetworkEndpointGroups.AttachNetworkEndpoints(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)

	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEBetaNetworkEndpointGroups.AttachNetworkEndpoints(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Beta.NetworkEndpointGroups.AttachNetworkEndpoints(projectID, key.Zone, key.Name, arg0)
	call.Context(ctx)
	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCEBetaNetworkEndpointGroups.AttachNetworkEndpoints(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}
	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEBetaNetworkEndpointGroups.AttachNetworkEndpoints(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// DetachNetworkEndpoints is a method on GCEBetaNetworkEndpointGroups.
func (g *GCEBetaNetworkEndpointGroups) DetachNetworkEndpoints(ctx context.Context, key *meta.Key, arg0 *beta.NetworkEndpointGroupsDetachEndpointsRequest) error {
	klog.V(5).Infof("GCEBetaNetworkEndpointGroups.DetachNetworkEndpoints(%v, %v, ...): called", ctx, key)

	if !key.Valid() {
		klog.V(2).Infof("GCEBetaNetworkEndpointGroups.DetachNetworkEndpoints(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "beta", "NetworkEndpointGroups")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "DetachNetworkEndpoints",
		Version:   meta.Version("beta"),
		Service:   "NetworkEndpointGroups",
	}
	klog.V(5).Infof("GCEBetaNetworkEndpointGroups.DetachNetworkEndpoints(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)

	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEBetaNetworkEndpointGroups.DetachNetworkEndpoints(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Beta.NetworkEndpointGroups.DetachNetworkEndpoints(projectID, key.Zone, key.Name, arg0)
	call.Context(ctx)
	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCEBetaNetworkEndpointGroups.DetachNetworkEndpoints(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}
	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEBetaNetworkEndpointGroups.DetachNetworkEndpoints(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// ListNetworkEndpoints is a method on GCEBetaNetworkEndpointGroups.
func (g *GCEBetaNetworkEndpointGroups) ListNetworkEndpoints(ctx context.Context, key *meta.Key, arg0 *beta.NetworkEndpointGroupsListEndpointsRequest, fl *filter.F) ([]*beta.NetworkEndpointWithHealthStatus, error) {
	klog.V(5).Infof("GCEBetaNetworkEndpointGroups.ListNetworkEndpoints(%v, %v, ...): called", ctx, key)

	if !key.Valid() {
		klog.V(2).Infof("GCEBetaNetworkEndpointGroups.ListNetworkEndpoints(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "beta", "NetworkEndpointGroups")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "ListNetworkEndpoints",
		Version:   meta.Version("beta"),
		Service:   "NetworkEndpointGroups",
	}
	klog.V(5).Infof("GCEBetaNetworkEndpointGroups.ListNetworkEndpoints(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)

	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEBetaNetworkEndpointGroups.ListNetworkEndpoints(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.Beta.NetworkEndpointGroups.ListNetworkEndpoints(projectID, key.Zone, key.Name, arg0)
	var all []*beta.NetworkEndpointWithHealthStatus
	f := func(l *beta.NetworkEndpointGroupsListNetworkEndpoints) error {
		klog.V(5).Infof("GCEBetaNetworkEndpointGroups.ListNetworkEndpoints(%v, %v, ...): page %+v", ctx, key, l)
		all = append(all, l.Items...)
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		klog.V(4).Infof("GCEBetaNetworkEndpointGroups.ListNetworkEndpoints(%v, %v, ...) = %v, %v", ctx, key, nil, err)
		return nil, err
	}
	if klog.V(4).Enabled() {
		klog.V(4).Infof("GCEBetaNetworkEndpointGroups.ListNetworkEndpoints(%v, %v, ...) = [%v items], %v", ctx, key, len(all), nil)
	} else if klog.V(5).Enabled() {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		klog.V(5).Infof("GCEBetaNetworkEndpointGroups.ListNetworkEndpoints(%v, %v, ...) = %v, %v", ctx, key, asStr, nil)
	}
	return all, nil
}

// NetworkEndpointGroups is an interface that allows for mocking of NetworkEndpointGroups.
type NetworkEndpointGroups interface {
	Get(ctx context.Context, key *meta.Key) (*ga.NetworkEndpointGroup, error)
	List(ctx context.Context, zone string, fl *filter.F) ([]*ga.NetworkEndpointGroup, error)
	Insert(ctx context.Context, key *meta.Key, obj *ga.NetworkEndpointGroup) error
	Delete(ctx context.Context, key *meta.Key) error
	AggregatedList(ctx context.Context, fl *filter.F) (map[string][]*ga.NetworkEndpointGroup, error)
	AttachNetworkEndpoints(context.Context, *meta.Key, *ga.NetworkEndpointGroupsAttachEndpointsRequest) error
	DetachNetworkEndpoints(context.Context, *meta.Key, *ga.NetworkEndpointGroupsDetachEndpointsRequest) error
	ListNetworkEndpoints(context.Context, *meta.Key, *ga.NetworkEndpointGroupsListEndpointsRequest, *filter.F) ([]*ga.NetworkEndpointWithHealthStatus, error)
}

// NewMockNetworkEndpointGroups returns a new mock for NetworkEndpointGroups.
func NewMockNetworkEndpointGroups(pr ProjectRouter, objs map[meta.Key]*MockNetworkEndpointGroupsObj) *MockNetworkEndpointGroups {
	mock := &MockNetworkEndpointGroups{
		ProjectRouter: pr,

		Objects:     objs,
		GetError:    map[meta.Key]error{},
		InsertError: map[meta.Key]error{},
		DeleteError: map[meta.Key]error{},
	}
	return mock
}

// MockNetworkEndpointGroups is the mock for NetworkEndpointGroups.
type MockNetworkEndpointGroups struct {
	Lock sync.Mutex

	ProjectRouter ProjectRouter

	// Objects maintained by the mock.
	Objects map[meta.Key]*MockNetworkEndpointGroupsObj

	// If an entry exists for the given key and operation, then the error
	// will be returned instead of the operation.
	GetError            map[meta.Key]error
	ListError           *error
	InsertError         map[meta.Key]error
	DeleteError         map[meta.Key]error
	AggregatedListError *error

	// xxxHook allow you to intercept the standard processing of the mock in
	// order to add your own logic. Return (true, _, _) to prevent the normal
	// execution flow of the mock. Return (false, nil, nil) to continue with
	// normal mock behavior/ after the hook function executes.
	GetHook                    func(ctx context.Context, key *meta.Key, m *MockNetworkEndpointGroups) (bool, *ga.NetworkEndpointGroup, error)
	ListHook                   func(ctx context.Context, zone string, fl *filter.F, m *MockNetworkEndpointGroups) (bool, []*ga.NetworkEndpointGroup, error)
	InsertHook                 func(ctx context.Context, key *meta.Key, obj *ga.NetworkEndpointGroup, m *MockNetworkEndpointGroups) (bool, error)
	DeleteHook                 func(ctx context.Context, key *meta.Key, m *MockNetworkEndpointGroups) (bool, error)
	AggregatedListHook         func(ctx context.Context, fl *filter.F, m *MockNetworkEndpointGroups) (bool, map[string][]*ga.NetworkEndpointGroup, error)
	AttachNetworkEndpointsHook func(context.Context, *meta.Key, *ga.NetworkEndpointGroupsAttachEndpointsRequest, *MockNetworkEndpointGroups) error
	DetachNetworkEndpointsHook func(context.Context, *meta.Key, *ga.NetworkEndpointGroupsDetachEndpointsRequest, *MockNetworkEndpointGroups) error
	ListNetworkEndpointsHook   func(context.Context, *meta.Key, *ga.NetworkEndpointGroupsListEndpointsRequest, *filter.F, *MockNetworkEndpointGroups) ([]*ga.NetworkEndpointWithHealthStatus, error)

	// X is extra state that can be used as part of the mock. Generated code
	// will not use this field.
	X interface{}
}

// Get returns the object from the mock.
func (m *MockNetworkEndpointGroups) Get(ctx context.Context, key *meta.Key) (*ga.NetworkEndpointGroup, error) {
	if m.GetHook != nil {
		if intercept, obj, err := m.GetHook(ctx, key, m); intercept {
			klog.V(5).Infof("MockNetworkEndpointGroups.Get(%v, %s) = %+v, %v", ctx, key, obj, err)
			return obj, err
		}
	}
	if !key.Valid() {
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.GetError[*key]; ok {
		klog.V(5).Infof("MockNetworkEndpointGroups.Get(%v, %s) = nil, %v", ctx, key, err)
		return nil, err
	}
	if obj, ok := m.Objects[*key]; ok {
		typedObj := obj.ToGA()
		klog.V(5).Infof("MockNetworkEndpointGroups.Get(%v, %s) = %+v, nil", ctx, key, typedObj)
		return typedObj, nil
	}

	err := &googleapi.Error{
		Code:    http.StatusNotFound,
		Message: fmt.Sprintf("MockNetworkEndpointGroups %v not found", key),
	}
	klog.V(5).Infof("MockNetworkEndpointGroups.Get(%v, %s) = nil, %v", ctx, key, err)
	return nil, err
}

// List all of the objects in the mock in the given zone.
func (m *MockNetworkEndpointGroups) List(ctx context.Context, zone string, fl *filter.F) ([]*ga.NetworkEndpointGroup, error) {
	if m.ListHook != nil {
		if intercept, objs, err := m.ListHook(ctx, zone, fl, m); intercept {
			klog.V(5).Infof("MockNetworkEndpointGroups.List(%v, %q, %v) = [%v items], %v", ctx, zone, fl, len(objs), err)
			return objs, err
		}
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if m.ListError != nil {
		err := *m.ListError
		klog.V(5).Infof("MockNetworkEndpointGroups.List(%v, %q, %v) = nil, %v", ctx, zone, fl, err)

		return nil, *m.ListError
	}

	var objs []*ga.NetworkEndpointGroup
	for key, obj := range m.Objects {
		if key.Zone != zone {
			continue
		}
		if !fl.Match(obj.ToGA()) {
			continue
		}
		objs = append(objs, obj.ToGA())
	}

	klog.V(5).Infof("MockNetworkEndpointGroups.List(%v, %q, %v) = [%v items], nil", ctx, zone, fl, len(objs))
	return objs, nil
}

// Insert is a mock for inserting/creating a new object.
func (m *MockNetworkEndpointGroups) Insert(ctx context.Context, key *meta.Key, obj *ga.NetworkEndpointGroup) error {
	if m.InsertHook != nil {
		if intercept, err := m.InsertHook(ctx, key, obj, m); intercept {
			klog.V(5).Infof("MockNetworkEndpointGroups.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.InsertError[*key]; ok {
		klog.V(5).Infof("MockNetworkEndpointGroups.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}
	if _, ok := m.Objects[*key]; ok {
		err := &googleapi.Error{
			Code:    http.StatusConflict,
			Message: fmt.Sprintf("MockNetworkEndpointGroups %v exists", key),
		}
		klog.V(5).Infof("MockNetworkEndpointGroups.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}

	obj.Name = key.Name
	projectID := m.ProjectRouter.ProjectID(ctx, "ga", "networkEndpointGroups")
	obj.SelfLink = SelfLink(meta.VersionGA, projectID, "networkEndpointGroups", key)

	m.Objects[*key] = &MockNetworkEndpointGroupsObj{obj}
	klog.V(5).Infof("MockNetworkEndpointGroups.Insert(%v, %v, %+v) = nil", ctx, key, obj)
	return nil
}

// Delete is a mock for deleting the object.
func (m *MockNetworkEndpointGroups) Delete(ctx context.Context, key *meta.Key) error {
	if m.DeleteHook != nil {
		if intercept, err := m.DeleteHook(ctx, key, m); intercept {
			klog.V(5).Infof("MockNetworkEndpointGroups.Delete(%v, %v) = %v", ctx, key, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.DeleteError[*key]; ok {
		klog.V(5).Infof("MockNetworkEndpointGroups.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}
	if _, ok := m.Objects[*key]; !ok {
		err := &googleapi.Error{
			Code:    http.StatusNotFound,
			Message: fmt.Sprintf("MockNetworkEndpointGroups %v not found", key),
		}
		klog.V(5).Infof("MockNetworkEndpointGroups.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	delete(m.Objects, *key)
	klog.V(5).Infof("MockNetworkEndpointGroups.Delete(%v, %v) = nil", ctx, key)
	return nil
}

// AggregatedList is a mock for AggregatedList.
func (m *MockNetworkEndpointGroups) AggregatedList(ctx context.Context, fl *filter.F) (map[string][]*ga.NetworkEndpointGroup, error) {
	if m.AggregatedListHook != nil {
		if intercept, objs, err := m.AggregatedListHook(ctx, fl, m); intercept {
			klog.V(5).Infof("MockNetworkEndpointGroups.AggregatedList(%v, %v) = [%v items], %v", ctx, fl, len(objs), err)
			return objs, err
		}
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if m.AggregatedListError != nil {
		err := *m.AggregatedListError
		klog.V(5).Infof("MockNetworkEndpointGroups.AggregatedList(%v, %v) = nil, %v", ctx, fl, err)
		return nil, err
	}

	objs := map[string][]*ga.NetworkEndpointGroup{}
	for _, obj := range m.Objects {
		res, err := ParseResourceURL(obj.ToGA().SelfLink)
		if err != nil {
			klog.V(5).Infof("MockNetworkEndpointGroups.AggregatedList(%v, %v) = nil, %v", ctx, fl, err)
			return nil, err
		}
		if !fl.Match(obj.ToGA()) {
			continue
		}
		location := aggregatedListKey(res.Key)
		objs[location] = append(objs[location], obj.ToGA())
	}
	klog.V(5).Infof("MockNetworkEndpointGroups.AggregatedList(%v, %v) = [%v items], nil", ctx, fl, len(objs))
	return objs, nil
}

// Obj wraps the object for use in the mock.
func (m *MockNetworkEndpointGroups) Obj(o *ga.NetworkEndpointGroup) *MockNetworkEndpointGroupsObj {
	return &MockNetworkEndpointGroupsObj{o}
}

// AttachNetworkEndpoints is a mock for the corresponding method.
func (m *MockNetworkEndpointGroups) AttachNetworkEndpoints(ctx context.Context, key *meta.Key, arg0 *ga.NetworkEndpointGroupsAttachEndpointsRequest) error {
	if m.AttachNetworkEndpointsHook != nil {
		return m.AttachNetworkEndpointsHook(ctx, key, arg0, m)
	}
	return nil
}

// DetachNetworkEndpoints is a mock for the corresponding method.
func (m *MockNetworkEndpointGroups) DetachNetworkEndpoints(ctx context.Context, key *meta.Key, arg0 *ga.NetworkEndpointGroupsDetachEndpointsRequest) error {
	if m.DetachNetworkEndpointsHook != nil {
		return m.DetachNetworkEndpointsHook(ctx, key, arg0, m)
	}
	return nil
}

// ListNetworkEndpoints is a mock for the corresponding method.
func (m *MockNetworkEndpointGroups) ListNetworkEndpoints(ctx context.Context, key *meta.Key, arg0 *ga.NetworkEndpointGroupsListEndpointsRequest, fl *filter.F) ([]*ga.NetworkEndpointWithHealthStatus, error) {
	if m.ListNetworkEndpointsHook != nil {
		return m.ListNetworkEndpointsHook(ctx, key, arg0, fl, m)
	}
	return nil, nil
}

// GCENetworkEndpointGroups is a simplifying adapter for the GCE NetworkEndpointGroups.
type GCENetworkEndpointGroups struct {
	s *Service
}

// Get the NetworkEndpointGroup named by key.
func (g *GCENetworkEndpointGroups) Get(ctx context.Context, key *meta.Key) (*ga.NetworkEndpointGroup, error) {
	klog.V(5).Infof("GCENetworkEndpointGroups.Get(%v, %v): called", ctx, key)

	if !key.Valid() {
		klog.V(2).Infof("GCENetworkEndpointGroups.Get(%v, %v): key is invalid (%#v)", ctx, key, key)
		return nil, fmt.Errorf("invalid GCE key (%#v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "NetworkEndpointGroups")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Get",
		Version:   meta.Version("ga"),
		Service:   "NetworkEndpointGroups",
	}
	klog.V(5).Infof("GCENetworkEndpointGroups.Get(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCENetworkEndpointGroups.Get(%v, %v): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.GA.NetworkEndpointGroups.Get(projectID, key.Zone, key.Name)
	call.Context(ctx)
	v, err := call.Do()
	klog.V(4).Infof("GCENetworkEndpointGroups.Get(%v, %v) = %+v, %v", ctx, key, v, err)
	return v, err
}

// List all NetworkEndpointGroup objects.
func (g *GCENetworkEndpointGroups) List(ctx context.Context, zone string, fl *filter.F) ([]*ga.NetworkEndpointGroup, error) {
	klog.V(5).Infof("GCENetworkEndpointGroups.List(%v, %v, %v) called", ctx, zone, fl)
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "NetworkEndpointGroups")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "List",
		Version:   meta.Version("ga"),
		Service:   "NetworkEndpointGroups",
	}
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		return nil, err
	}
	klog.V(5).Infof("GCENetworkEndpointGroups.List(%v, %v, %v): projectID = %v, rk = %+v", ctx, zone, fl, projectID, rk)
	call := g.s.GA.NetworkEndpointGroups.List(projectID, zone)
	if fl != filter.None {
		call.Filter(fl.String())
	}
	var all []*ga.NetworkEndpointGroup
	f := func(l *ga.NetworkEndpointGroupList) error {
		klog.V(5).Infof("GCENetworkEndpointGroups.List(%v, ..., %v): page %+v", ctx, fl, l)
		all = append(all, l.Items...)
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		klog.V(4).Infof("GCENetworkEndpointGroups.List(%v, ..., %v) = %v, %v", ctx, fl, nil, err)
		return nil, err
	}

	if klog.V(4).Enabled() {
		klog.V(4).Infof("GCENetworkEndpointGroups.List(%v, ..., %v) = [%v items], %v", ctx, fl, len(all), nil)
	} else if klog.V(5).Enabled() {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		klog.V(5).Infof("GCENetworkEndpointGroups.List(%v, ..., %v) = %v, %v", ctx, fl, asStr, nil)
	}

	return all, nil
}

// Insert NetworkEndpointGroup with key of value obj.
func (g *GCENetworkEndpointGroups) Insert(ctx context.Context, key *meta.Key, obj *ga.NetworkEndpointGroup) error {
	klog.V(5).Infof("GCENetworkEndpointGroups.Insert(%v, %v, %+v): called", ctx, key, obj)
	if !key.Valid() {
		klog.V(2).Infof("GCENetworkEndpointGroups.Insert(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "NetworkEndpointGroups")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Insert",
		Version:   meta.Version("ga"),
		Service:   "NetworkEndpointGroups",
	}
	klog.V(5).Infof("GCENetworkEndpointGroups.Insert(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCENetworkEndpointGroups.Insert(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	obj.Name = key.Name
	call := g.s.GA.NetworkEndpointGroups.Insert(projectID, key.Zone, obj)
	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCENetworkEndpointGroups.Insert(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCENetworkEndpointGroups.Insert(%v, %v, %+v) = %+v", ctx, key, obj, err)
	return err
}

// Delete the NetworkEndpointGroup referenced by key.
func (g *GCENetworkEndpointGroups) Delete(ctx context.Context, key *meta.Key) error {
	klog.V(5).Infof("GCENetworkEndpointGroups.Delete(%v, %v): called", ctx, key)
	if !key.Valid() {
		klog.V(2).Infof("GCENetworkEndpointGroups.Delete(%v, %v): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "NetworkEndpointGroups")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Delete",
		Version:   meta.Version("ga"),
		Service:   "NetworkEndpointGroups",
	}
	klog.V(5).Infof("GCENetworkEndpointGroups.Delete(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCENetworkEndpointGroups.Delete(%v, %v): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.GA.NetworkEndpointGroups.Delete(projectID, key.Zone, key.Name)
	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCENetworkEndpointGroups.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCENetworkEndpointGroups.Delete(%v, %v) = %v", ctx, key, err)
	return err
}

// AggregatedList lists all resources of the given type across all locations.
func (g *GCENetworkEndpointGroups) AggregatedList(ctx context.Context, fl *filter.F) (map[string][]*ga.NetworkEndpointGroup, error) {
	klog.V(5).Infof("GCENetworkEndpointGroups.AggregatedList(%v, %v) called", ctx, fl)

	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "NetworkEndpointGroups")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "AggregatedList",
		Version:   meta.Version("ga"),
		Service:   "NetworkEndpointGroups",
	}

	klog.V(5).Infof("GCENetworkEndpointGroups.AggregatedList(%v, %v): projectID = %v, rk = %+v", ctx, fl, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(5).Infof("GCENetworkEndpointGroups.AggregatedList(%v, %v): RateLimiter error: %v", ctx, fl, err)
		return nil, err
	}

	call := g.s.GA.NetworkEndpointGroups.AggregatedList(projectID)
	call.Context(ctx)
	if fl != filter.None {
		call.Filter(fl.String())
	}

	all := map[string][]*ga.NetworkEndpointGroup{}
	f := func(l *ga.NetworkEndpointGroupAggregatedList) error {
		for k, v := range l.Items {
			klog.V(5).Infof("GCENetworkEndpointGroups.AggregatedList(%v, %v): page[%v]%+v", ctx, fl, k, v)
			all[k] = append(all[k], v.NetworkEndpointGroups...)
		}
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		klog.V(4).Infof("GCENetworkEndpointGroups.AggregatedList(%v, %v) = %v, %v", ctx, fl, nil, err)
		return nil, err
	}
	if klog.V(4).Enabled() {
		klog.V(4).Infof("GCENetworkEndpointGroups.AggregatedList(%v, %v) = [%v items], %v", ctx, fl, len(all), nil)
	} else if klog.V(5).Enabled() {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		klog.V(5).Infof("GCENetworkEndpointGroups.AggregatedList(%v, %v) = %v, %v", ctx, fl, asStr, nil)
	}
	return all, nil
}

// AttachNetworkEndpoints is a method on GCENetworkEndpointGroups.
func (g *GCENetworkEndpointGroups) AttachNetworkEndpoints(ctx context.Context, key *meta.Key, arg0 *ga.NetworkEndpointGroupsAttachEndpointsRequest) error {
	klog.V(5).Infof("GCENetworkEndpointGroups.AttachNetworkEndpoints(%v, %v, ...): called", ctx, key)

	if !key.Valid() {
		klog.V(2).Infof("GCENetworkEndpointGroups.AttachNetworkEndpoints(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "NetworkEndpointGroups")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "AttachNetworkEndpoints",
		Version:   meta.Version("ga"),
		Service:   "NetworkEndpointGroups",
	}
	klog.V(5).Infof("GCENetworkEndpointGroups.AttachNetworkEndpoints(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)

	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCENetworkEndpointGroups.AttachNetworkEndpoints(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.GA.NetworkEndpointGroups.AttachNetworkEndpoints(projectID, key.Zone, key.Name, arg0)
	call.Context(ctx)
	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCENetworkEndpointGroups.AttachNetworkEndpoints(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}
	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCENetworkEndpointGroups.AttachNetworkEndpoints(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// DetachNetworkEndpoints is a method on GCENetworkEndpointGroups.
func (g *GCENetworkEndpointGroups) DetachNetworkEndpoints(ctx context.Context, key *meta.Key, arg0 *ga.NetworkEndpointGroupsDetachEndpointsRequest) error {
	klog.V(5).Infof("GCENetworkEndpointGroups.DetachNetworkEndpoints(%v, %v, ...): called", ctx, key)

	if !key.Valid() {
		klog.V(2).Infof("GCENetworkEndpointGroups.DetachNetworkEndpoints(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "NetworkEndpointGroups")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "DetachNetworkEndpoints",
		Version:   meta.Version("ga"),
		Service:   "NetworkEndpointGroups",
	}
	klog.V(5).Infof("GCENetworkEndpointGroups.DetachNetworkEndpoints(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)

	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCENetworkEndpointGroups.DetachNetworkEndpoints(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.GA.NetworkEndpointGroups.DetachNetworkEndpoints(projectID, key.Zone, key.Name, arg0)
	call.Context(ctx)
	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCENetworkEndpointGroups.DetachNetworkEndpoints(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}
	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCENetworkEndpointGroups.DetachNetworkEndpoints(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// ListNetworkEndpoints is a method on GCENetworkEndpointGroups.
func (g *GCENetworkEndpointGroups) ListNetworkEndpoints(ctx context.Context, key *meta.Key, arg0 *ga.NetworkEndpointGroupsListEndpointsRequest, fl *filter.F) ([]*ga.NetworkEndpointWithHealthStatus, error) {
	klog.V(5).Infof("GCENetworkEndpointGroups.ListNetworkEndpoints(%v, %v, ...): called", ctx, key)

	if !key.Valid() {
		klog.V(2).Infof("GCENetworkEndpointGroups.ListNetworkEndpoints(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "NetworkEndpointGroups")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "ListNetworkEndpoints",
		Version:   meta.Version("ga"),
		Service:   "NetworkEndpointGroups",
	}
	klog.V(5).Infof("GCENetworkEndpointGroups.ListNetworkEndpoints(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)

	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCENetworkEndpointGroups.ListNetworkEndpoints(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.GA.NetworkEndpointGroups.ListNetworkEndpoints(projectID, key.Zone, key.Name, arg0)
	var all []*ga.NetworkEndpointWithHealthStatus
	f := func(l *ga.NetworkEndpointGroupsListNetworkEndpoints) error {
		klog.V(5).Infof("GCENetworkEndpointGroups.ListNetworkEndpoints(%v, %v, ...): page %+v", ctx, key, l)
		all = append(all, l.Items...)
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		klog.V(4).Infof("GCENetworkEndpointGroups.ListNetworkEndpoints(%v, %v, ...) = %v, %v", ctx, key, nil, err)
		return nil, err
	}
	if klog.V(4).Enabled() {
		klog.V(4).Infof("GCENetworkEndpointGroups.ListNetworkEndpoints(%v, %v, ...) = [%v items], %v", ctx, key, len(all), nil)
	} else if klog.V(5).Enabled() {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		klog.V(5).Infof("GCENetworkEndpointGroups.ListNetworkEndpoints(%v, %v, ...) = %v, %v", ctx, key, asStr, nil)
	}
	return all, nil
}

// Projects is an interface that allows for mocking of Projects.
type Projects interface {
	// ProjectsOps is an interface with additional non-CRUD type methods.
	// This interface is expected to be implemented by hand (non-autogenerated).
	ProjectsOps
}

// NewMockProjects returns a new mock for Projects.
func NewMockProjects(pr ProjectRouter, objs map[meta.Key]*MockProjectsObj) *MockProjects {
	mock := &MockProjects{
		ProjectRouter: pr,

		Objects: objs,
	}
	return mock
}

// MockProjects is the mock for Projects.
type MockProjects struct {
	Lock sync.Mutex

	ProjectRouter ProjectRouter

	// Objects maintained by the mock.
	Objects map[meta.Key]*MockProjectsObj

	// If an entry exists for the given key and operation, then the error
	// will be returned instead of the operation.

	// xxxHook allow you to intercept the standard processing of the mock in
	// order to add your own logic. Return (true, _, _) to prevent the normal
	// execution flow of the mock. Return (false, nil, nil) to continue with
	// normal mock behavior/ after the hook function executes.

	// X is extra state that can be used as part of the mock. Generated code
	// will not use this field.
	X interface{}
}

// Obj wraps the object for use in the mock.
func (m *MockProjects) Obj(o *ga.Project) *MockProjectsObj {
	return &MockProjectsObj{o}
}

// GCEProjects is a simplifying adapter for the GCE Projects.
type GCEProjects struct {
	s *Service
}

// Regions is an interface that allows for mocking of Regions.
type Regions interface {
	Get(ctx context.Context, key *meta.Key) (*ga.Region, error)
	List(ctx context.Context, fl *filter.F) ([]*ga.Region, error)
}

// NewMockRegions returns a new mock for Regions.
func NewMockRegions(pr ProjectRouter, objs map[meta.Key]*MockRegionsObj) *MockRegions {
	mock := &MockRegions{
		ProjectRouter: pr,

		Objects:  objs,
		GetError: map[meta.Key]error{},
	}
	return mock
}

// MockRegions is the mock for Regions.
type MockRegions struct {
	Lock sync.Mutex

	ProjectRouter ProjectRouter

	// Objects maintained by the mock.
	Objects map[meta.Key]*MockRegionsObj

	// If an entry exists for the given key and operation, then the error
	// will be returned instead of the operation.
	GetError  map[meta.Key]error
	ListError *error

	// xxxHook allow you to intercept the standard processing of the mock in
	// order to add your own logic. Return (true, _, _) to prevent the normal
	// execution flow of the mock. Return (false, nil, nil) to continue with
	// normal mock behavior/ after the hook function executes.
	GetHook  func(ctx context.Context, key *meta.Key, m *MockRegions) (bool, *ga.Region, error)
	ListHook func(ctx context.Context, fl *filter.F, m *MockRegions) (bool, []*ga.Region, error)

	// X is extra state that can be used as part of the mock. Generated code
	// will not use this field.
	X interface{}
}

// Get returns the object from the mock.
func (m *MockRegions) Get(ctx context.Context, key *meta.Key) (*ga.Region, error) {
	if m.GetHook != nil {
		if intercept, obj, err := m.GetHook(ctx, key, m); intercept {
			klog.V(5).Infof("MockRegions.Get(%v, %s) = %+v, %v", ctx, key, obj, err)
			return obj, err
		}
	}
	if !key.Valid() {
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.GetError[*key]; ok {
		klog.V(5).Infof("MockRegions.Get(%v, %s) = nil, %v", ctx, key, err)
		return nil, err
	}
	if obj, ok := m.Objects[*key]; ok {
		typedObj := obj.ToGA()
		klog.V(5).Infof("MockRegions.Get(%v, %s) = %+v, nil", ctx, key, typedObj)
		return typedObj, nil
	}

	err := &googleapi.Error{
		Code:    http.StatusNotFound,
		Message: fmt.Sprintf("MockRegions %v not found", key),
	}
	klog.V(5).Infof("MockRegions.Get(%v, %s) = nil, %v", ctx, key, err)
	return nil, err
}

// List all of the objects in the mock.
func (m *MockRegions) List(ctx context.Context, fl *filter.F) ([]*ga.Region, error) {
	if m.ListHook != nil {
		if intercept, objs, err := m.ListHook(ctx, fl, m); intercept {
			klog.V(5).Infof("MockRegions.List(%v, %v) = [%v items], %v", ctx, fl, len(objs), err)
			return objs, err
		}
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if m.ListError != nil {
		err := *m.ListError
		klog.V(5).Infof("MockRegions.List(%v, %v) = nil, %v", ctx, fl, err)

		return nil, *m.ListError
	}

	var objs []*ga.Region
	for _, obj := range m.Objects {
		if !fl.Match(obj.ToGA()) {
			continue
		}
		objs = append(objs, obj.ToGA())
	}

	klog.V(5).Infof("MockRegions.List(%v, %v) = [%v items], nil", ctx, fl, len(objs))
	return objs, nil
}

// Obj wraps the object for use in the mock.
func (m *MockRegions) Obj(o *ga.Region) *MockRegionsObj {
	return &MockRegionsObj{o}
}

// GCERegions is a simplifying adapter for the GCE Regions.
type GCERegions struct {
	s *Service
}

// Get the Region named by key.
func (g *GCERegions) Get(ctx context.Context, key *meta.Key) (*ga.Region, error) {
	klog.V(5).Infof("GCERegions.Get(%v, %v): called", ctx, key)

	if !key.Valid() {
		klog.V(2).Infof("GCERegions.Get(%v, %v): key is invalid (%#v)", ctx, key, key)
		return nil, fmt.Errorf("invalid GCE key (%#v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "Regions")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Get",
		Version:   meta.Version("ga"),
		Service:   "Regions",
	}
	klog.V(5).Infof("GCERegions.Get(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCERegions.Get(%v, %v): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.GA.Regions.Get(projectID, key.Name)
	call.Context(ctx)
	v, err := call.Do()
	klog.V(4).Infof("GCERegions.Get(%v, %v) = %+v, %v", ctx, key, v, err)
	return v, err
}

// List all Region objects.
func (g *GCERegions) List(ctx context.Context, fl *filter.F) ([]*ga.Region, error) {
	klog.V(5).Infof("GCERegions.List(%v, %v) called", ctx, fl)
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "Regions")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "List",
		Version:   meta.Version("ga"),
		Service:   "Regions",
	}
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		return nil, err
	}
	klog.V(5).Infof("GCERegions.List(%v, %v): projectID = %v, rk = %+v", ctx, fl, projectID, rk)
	call := g.s.GA.Regions.List(projectID)
	if fl != filter.None {
		call.Filter(fl.String())
	}
	var all []*ga.Region
	f := func(l *ga.RegionList) error {
		klog.V(5).Infof("GCERegions.List(%v, ..., %v): page %+v", ctx, fl, l)
		all = append(all, l.Items...)
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		klog.V(4).Infof("GCERegions.List(%v, ..., %v) = %v, %v", ctx, fl, nil, err)
		return nil, err
	}

	if klog.V(4).Enabled() {
		klog.V(4).Infof("GCERegions.List(%v, ..., %v) = [%v items], %v", ctx, fl, len(all), nil)
	} else if klog.V(5).Enabled() {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		klog.V(5).Infof("GCERegions.List(%v, ..., %v) = %v, %v", ctx, fl, asStr, nil)
	}

	return all, nil
}

// AlphaRouters is an interface that allows for mocking of Routers.
type AlphaRouters interface {
	Get(ctx context.Context, key *meta.Key) (*alpha.Router, error)
	List(ctx context.Context, region string, fl *filter.F) ([]*alpha.Router, error)
	Insert(ctx context.Context, key *meta.Key, obj *alpha.Router) error
	Delete(ctx context.Context, key *meta.Key) error
	AggregatedList(ctx context.Context, fl *filter.F) (map[string][]*alpha.Router, error)
	GetRouterStatus(context.Context, *meta.Key) (*alpha.RouterStatusResponse, error)
	Patch(context.Context, *meta.Key, *alpha.Router) error
	Preview(context.Context, *meta.Key, *alpha.Router) (*alpha.RoutersPreviewResponse, error)
	TestIamPermissions(context.Context, *meta.Key, *alpha.TestPermissionsRequest) (*alpha.TestPermissionsResponse, error)
}

// NewMockAlphaRouters returns a new mock for Routers.
func NewMockAlphaRouters(pr ProjectRouter, objs map[meta.Key]*MockRoutersObj) *MockAlphaRouters {
	mock := &MockAlphaRouters{
		ProjectRouter: pr,

		Objects:     objs,
		GetError:    map[meta.Key]error{},
		InsertError: map[meta.Key]error{},
		DeleteError: map[meta.Key]error{},
	}
	return mock
}

// MockAlphaRouters is the mock for Routers.
type MockAlphaRouters struct {
	Lock sync.Mutex

	ProjectRouter ProjectRouter

	// Objects maintained by the mock.
	Objects map[meta.Key]*MockRoutersObj

	// If an entry exists for the given key and operation, then the error
	// will be returned instead of the operation.
	GetError            map[meta.Key]error
	ListError           *error
	InsertError         map[meta.Key]error
	DeleteError         map[meta.Key]error
	AggregatedListError *error

	// xxxHook allow you to intercept the standard processing of the mock in
	// order to add your own logic. Return (true, _, _) to prevent the normal
	// execution flow of the mock. Return (false, nil, nil) to continue with
	// normal mock behavior/ after the hook function executes.
	GetHook                func(ctx context.Context, key *meta.Key, m *MockAlphaRouters) (bool, *alpha.Router, error)
	ListHook               func(ctx context.Context, region string, fl *filter.F, m *MockAlphaRouters) (bool, []*alpha.Router, error)
	InsertHook             func(ctx context.Context, key *meta.Key, obj *alpha.Router, m *MockAlphaRouters) (bool, error)
	DeleteHook             func(ctx context.Context, key *meta.Key, m *MockAlphaRouters) (bool, error)
	AggregatedListHook     func(ctx context.Context, fl *filter.F, m *MockAlphaRouters) (bool, map[string][]*alpha.Router, error)
	GetRouterStatusHook    func(context.Context, *meta.Key, *MockAlphaRouters) (*alpha.RouterStatusResponse, error)
	PatchHook              func(context.Context, *meta.Key, *alpha.Router, *MockAlphaRouters) error
	PreviewHook            func(context.Context, *meta.Key, *alpha.Router, *MockAlphaRouters) (*alpha.RoutersPreviewResponse, error)
	TestIamPermissionsHook func(context.Context, *meta.Key, *alpha.TestPermissionsRequest, *MockAlphaRouters) (*alpha.TestPermissionsResponse, error)

	// X is extra state that can be used as part of the mock. Generated code
	// will not use this field.
	X interface{}
}

// Get returns the object from the mock.
func (m *MockAlphaRouters) Get(ctx context.Context, key *meta.Key) (*alpha.Router, error) {
	if m.GetHook != nil {
		if intercept, obj, err := m.GetHook(ctx, key, m); intercept {
			klog.V(5).Infof("MockAlphaRouters.Get(%v, %s) = %+v, %v", ctx, key, obj, err)
			return obj, err
		}
	}
	if !key.Valid() {
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.GetError[*key]; ok {
		klog.V(5).Infof("MockAlphaRouters.Get(%v, %s) = nil, %v", ctx, key, err)
		return nil, err
	}
	if obj, ok := m.Objects[*key]; ok {
		typedObj := obj.ToAlpha()
		klog.V(5).Infof("MockAlphaRouters.Get(%v, %s) = %+v, nil", ctx, key, typedObj)
		return typedObj, nil
	}

	err := &googleapi.Error{
		Code:    http.StatusNotFound,
		Message: fmt.Sprintf("MockAlphaRouters %v not found", key),
	}
	klog.V(5).Infof("MockAlphaRouters.Get(%v, %s) = nil, %v", ctx, key, err)
	return nil, err
}

// List all of the objects in the mock in the given region.
func (m *MockAlphaRouters) List(ctx context.Context, region string, fl *filter.F) ([]*alpha.Router, error) {
	if m.ListHook != nil {
		if intercept, objs, err := m.ListHook(ctx, region, fl, m); intercept {
			klog.V(5).Infof("MockAlphaRouters.List(%v, %q, %v) = [%v items], %v", ctx, region, fl, len(objs), err)
			return objs, err
		}
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if m.ListError != nil {
		err := *m.ListError
		klog.V(5).Infof("MockAlphaRouters.List(%v, %q, %v) = nil, %v", ctx, region, fl, err)

		return nil, *m.ListError
	}

	var objs []*alpha.Router
	for key, obj := range m.Objects {
		if key.Region != region {
			continue
		}
		if !fl.Match(obj.ToAlpha()) {
			continue
		}
		objs = append(objs, obj.ToAlpha())
	}

	klog.V(5).Infof("MockAlphaRouters.List(%v, %q, %v) = [%v items], nil", ctx, region, fl, len(objs))
	return objs, nil
}

// Insert is a mock for inserting/creating a new object.
func (m *MockAlphaRouters) Insert(ctx context.Context, key *meta.Key, obj *alpha.Router) error {
	if m.InsertHook != nil {
		if intercept, err := m.InsertHook(ctx, key, obj, m); intercept {
			klog.V(5).Infof("MockAlphaRouters.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.InsertError[*key]; ok {
		klog.V(5).Infof("MockAlphaRouters.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}
	if _, ok := m.Objects[*key]; ok {
		err := &googleapi.Error{
			Code:    http.StatusConflict,
			Message: fmt.Sprintf("MockAlphaRouters %v exists", key),
		}
		klog.V(5).Infof("MockAlphaRouters.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}

	obj.Name = key.Name
	projectID := m.ProjectRouter.ProjectID(ctx, "alpha", "routers")
	obj.SelfLink = SelfLink(meta.VersionAlpha, projectID, "routers", key)

	m.Objects[*key] = &MockRoutersObj{obj}
	klog.V(5).Infof("MockAlphaRouters.Insert(%v, %v, %+v) = nil", ctx, key, obj)
	return nil
}

// Delete is a mock for deleting the object.
func (m *MockAlphaRouters) Delete(ctx context.Context, key *meta.Key) error {
	if m.DeleteHook != nil {
		if intercept, err := m.DeleteHook(ctx, key, m); intercept {
			klog.V(5).Infof("MockAlphaRouters.Delete(%v, %v) = %v", ctx, key, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.DeleteError[*key]; ok {
		klog.V(5).Infof("MockAlphaRouters.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}
	if _, ok := m.Objects[*key]; !ok {
		err := &googleapi.Error{
			Code:    http.StatusNotFound,
			Message: fmt.Sprintf("MockAlphaRouters %v not found", key),
		}
		klog.V(5).Infof("MockAlphaRouters.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	delete(m.Objects, *key)
	klog.V(5).Infof("MockAlphaRouters.Delete(%v, %v) = nil", ctx, key)
	return nil
}

// AggregatedList is a mock for AggregatedList.
func (m *MockAlphaRouters) AggregatedList(ctx context.Context, fl *filter.F) (map[string][]*alpha.Router, error) {
	if m.AggregatedListHook != nil {
		if intercept, objs, err := m.AggregatedListHook(ctx, fl, m); intercept {
			klog.V(5).Infof("MockAlphaRouters.AggregatedList(%v, %v) = [%v items], %v", ctx, fl, len(objs), err)
			return objs, err
		}
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if m.AggregatedListError != nil {
		err := *m.AggregatedListError
		klog.V(5).Infof("MockAlphaRouters.AggregatedList(%v, %v) = nil, %v", ctx, fl, err)
		return nil, err
	}

	objs := map[string][]*alpha.Router{}
	for _, obj := range m.Objects {
		res, err := ParseResourceURL(obj.ToAlpha().SelfLink)
		if err != nil {
			klog.V(5).Infof("MockAlphaRouters.AggregatedList(%v, %v) = nil, %v", ctx, fl, err)
			return nil, err
		}
		if !fl.Match(obj.ToAlpha()) {
			continue
		}
		location := aggregatedListKey(res.Key)
		objs[location] = append(objs[location], obj.ToAlpha())
	}
	klog.V(5).Infof("MockAlphaRouters.AggregatedList(%v, %v) = [%v items], nil", ctx, fl, len(objs))
	return objs, nil
}

// Obj wraps the object for use in the mock.
func (m *MockAlphaRouters) Obj(o *alpha.Router) *MockRoutersObj {
	return &MockRoutersObj{o}
}

// GetRouterStatus is a mock for the corresponding method.
func (m *MockAlphaRouters) GetRouterStatus(ctx context.Context, key *meta.Key) (*alpha.RouterStatusResponse, error) {
	if m.GetRouterStatusHook != nil {
		return m.GetRouterStatusHook(ctx, key, m)
	}
	return nil, fmt.Errorf("GetRouterStatusHook must be set")
}

// Patch is a mock for the corresponding method.
func (m *MockAlphaRouters) Patch(ctx context.Context, key *meta.Key, arg0 *alpha.Router) error {
	if m.PatchHook != nil {
		return m.PatchHook(ctx, key, arg0, m)
	}
	return nil
}

// Preview is a mock for the corresponding method.
func (m *MockAlphaRouters) Preview(ctx context.Context, key *meta.Key, arg0 *alpha.Router) (*alpha.RoutersPreviewResponse, error) {
	if m.PreviewHook != nil {
		return m.PreviewHook(ctx, key, arg0, m)
	}
	return nil, fmt.Errorf("PreviewHook must be set")
}

// TestIamPermissions is a mock for the corresponding method.
func (m *MockAlphaRouters) TestIamPermissions(ctx context.Context, key *meta.Key, arg0 *alpha.TestPermissionsRequest) (*alpha.TestPermissionsResponse, error) {
	if m.TestIamPermissionsHook != nil {
		return m.TestIamPermissionsHook(ctx, key, arg0, m)
	}
	return nil, fmt.Errorf("TestIamPermissionsHook must be set")
}

// GCEAlphaRouters is a simplifying adapter for the GCE Routers.
type GCEAlphaRouters struct {
	s *Service
}

// Get the Router named by key.
func (g *GCEAlphaRouters) Get(ctx context.Context, key *meta.Key) (*alpha.Router, error) {
	klog.V(5).Infof("GCEAlphaRouters.Get(%v, %v): called", ctx, key)

	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaRouters.Get(%v, %v): key is invalid (%#v)", ctx, key, key)
		return nil, fmt.Errorf("invalid GCE key (%#v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "alpha", "Routers")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Get",
		Version:   meta.Version("alpha"),
		Service:   "Routers",
	}
	klog.V(5).Infof("GCEAlphaRouters.Get(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEAlphaRouters.Get(%v, %v): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.Alpha.Routers.Get(projectID, key.Region, key.Name)
	call.Context(ctx)
	v, err := call.Do()
	klog.V(4).Infof("GCEAlphaRouters.Get(%v, %v) = %+v, %v", ctx, key, v, err)
	return v, err
}

// List all Router objects.
func (g *GCEAlphaRouters) List(ctx context.Context, region string, fl *filter.F) ([]*alpha.Router, error) {
	klog.V(5).Infof("GCEAlphaRouters.List(%v, %v, %v) called", ctx, region, fl)
	projectID := g.s.ProjectRouter.ProjectID(ctx, "alpha", "Routers")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "List",
		Version:   meta.Version("alpha"),
		Service:   "Routers",
	}
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		return nil, err
	}
	klog.V(5).Infof("GCEAlphaRouters.List(%v, %v, %v): projectID = %v, rk = %+v", ctx, region, fl, projectID, rk)
	call := g.s.Alpha.Routers.List(projectID, region)
	if fl != filter.None {
		call.Filter(fl.String())
	}
	var all []*alpha.Router
	f := func(l *alpha.RouterList) error {
		klog.V(5).Infof("GCEAlphaRouters.List(%v, ..., %v): page %+v", ctx, fl, l)
		all = append(all, l.Items...)
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		klog.V(4).Infof("GCEAlphaRouters.List(%v, ..., %v) = %v, %v", ctx, fl, nil, err)
		return nil, err
	}

	if klog.V(4).Enabled() {
		klog.V(4).Infof("GCEAlphaRouters.List(%v, ..., %v) = [%v items], %v", ctx, fl, len(all), nil)
	} else if klog.V(5).Enabled() {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		klog.V(5).Infof("GCEAlphaRouters.List(%v, ..., %v) = %v, %v", ctx, fl, asStr, nil)
	}

	return all, nil
}

// Insert Router with key of value obj.
func (g *GCEAlphaRouters) Insert(ctx context.Context, key *meta.Key, obj *alpha.Router) error {
	klog.V(5).Infof("GCEAlphaRouters.Insert(%v, %v, %+v): called", ctx, key, obj)
	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaRouters.Insert(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "alpha", "Routers")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Insert",
		Version:   meta.Version("alpha"),
		Service:   "Routers",
	}
	klog.V(5).Infof("GCEAlphaRouters.Insert(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEAlphaRouters.Insert(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	obj.Name = key.Name
	call := g.s.Alpha.Routers.Insert(projectID, key.Region, obj)
	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCEAlphaRouters.Insert(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEAlphaRouters.Insert(%v, %v, %+v) = %+v", ctx, key, obj, err)
	return err
}

// Delete the Router referenced by key.
func (g *GCEAlphaRouters) Delete(ctx context.Context, key *meta.Key) error {
	klog.V(5).Infof("GCEAlphaRouters.Delete(%v, %v): called", ctx, key)
	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaRouters.Delete(%v, %v): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "alpha", "Routers")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Delete",
		Version:   meta.Version("alpha"),
		Service:   "Routers",
	}
	klog.V(5).Infof("GCEAlphaRouters.Delete(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEAlphaRouters.Delete(%v, %v): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Alpha.Routers.Delete(projectID, key.Region, key.Name)
	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCEAlphaRouters.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEAlphaRouters.Delete(%v, %v) = %v", ctx, key, err)
	return err
}

// AggregatedList lists all resources of the given type across all locations.
func (g *GCEAlphaRouters) AggregatedList(ctx context.Context, fl *filter.F) (map[string][]*alpha.Router, error) {
	klog.V(5).Infof("GCEAlphaRouters.AggregatedList(%v, %v) called", ctx, fl)

	projectID := g.s.ProjectRouter.ProjectID(ctx, "alpha", "Routers")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "AggregatedList",
		Version:   meta.Version("alpha"),
		Service:   "Routers",
	}

	klog.V(5).Infof("GCEAlphaRouters.AggregatedList(%v, %v): projectID = %v, rk = %+v", ctx, fl, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(5).Infof("GCEAlphaRouters.AggregatedList(%v, %v): RateLimiter error: %v", ctx, fl, err)
		return nil, err
	}

	call := g.s.Alpha.Routers.AggregatedList(projectID)
	call.Context(ctx)
	if fl != filter.None {
		call.Filter(fl.String())
	}

	all := map[string][]*alpha.Router{}
	f := func(l *alpha.RouterAggregatedList) error {
		for k, v := range l.Items {
			klog.V(5).Infof("GCEAlphaRouters.AggregatedList(%v, %v): page[%v]%+v", ctx, fl, k, v)
			all[k] = append(all[k], v.Routers...)
		}
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		klog.V(4).Infof("GCEAlphaRouters.AggregatedList(%v, %v) = %v, %v", ctx, fl, nil, err)
		return nil, err
	}
	if klog.V(4).Enabled() {
		klog.V(4).Infof("GCEAlphaRouters.AggregatedList(%v, %v) = [%v items], %v", ctx, fl, len(all), nil)
	} else if klog.V(5).Enabled() {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		klog.V(5).Infof("GCEAlphaRouters.AggregatedList(%v, %v) = %v, %v", ctx, fl, asStr, nil)
	}
	return all, nil
}

// GetRouterStatus is a method on GCEAlphaRouters.
func (g *GCEAlphaRouters) GetRouterStatus(ctx context.Context, key *meta.Key) (*alpha.RouterStatusResponse, error) {
	klog.V(5).Infof("GCEAlphaRouters.GetRouterStatus(%v, %v, ...): called", ctx, key)

	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaRouters.GetRouterStatus(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "alpha", "Routers")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "GetRouterStatus",
		Version:   meta.Version("alpha"),
		Service:   "Routers",
	}
	klog.V(5).Infof("GCEAlphaRouters.GetRouterStatus(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)

	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEAlphaRouters.GetRouterStatus(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.Alpha.Routers.GetRouterStatus(projectID, key.Region, key.Name)
	call.Context(ctx)
	v, err := call.Do()
	klog.V(4).Infof("GCEAlphaRouters.GetRouterStatus(%v, %v, ...) = %+v, %v", ctx, key, v, err)
	return v, err
}

// Patch is a method on GCEAlphaRouters.
func (g *GCEAlphaRouters) Patch(ctx context.Context, key *meta.Key, arg0 *alpha.Router) error {
	klog.V(5).Infof("GCEAlphaRouters.Patch(%v, %v, ...): called", ctx, key)

	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaRouters.Patch(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "alpha", "Routers")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Patch",
		Version:   meta.Version("alpha"),
		Service:   "Routers",
	}
	klog.V(5).Infof("GCEAlphaRouters.Patch(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)

	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEAlphaRouters.Patch(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Alpha.Routers.Patch(projectID, key.Region, key.Name, arg0)
	call.Context(ctx)
	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCEAlphaRouters.Patch(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}
	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEAlphaRouters.Patch(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// Preview is a method on GCEAlphaRouters.
func (g *GCEAlphaRouters) Preview(ctx context.Context, key *meta.Key, arg0 *alpha.Router) (*alpha.RoutersPreviewResponse, error) {
	klog.V(5).Infof("GCEAlphaRouters.Preview(%v, %v, ...): called", ctx, key)

	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaRouters.Preview(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "alpha", "Routers")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Preview",
		Version:   meta.Version("alpha"),
		Service:   "Routers",
	}
	klog.V(5).Infof("GCEAlphaRouters.Preview(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)

	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEAlphaRouters.Preview(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.Alpha.Routers.Preview(projectID, key.Region, key.Name, arg0)
	call.Context(ctx)
	v, err := call.Do()
	klog.V(4).Infof("GCEAlphaRouters.Preview(%v, %v, ...) = %+v, %v", ctx, key, v, err)
	return v, err
}

// TestIamPermissions is a method on GCEAlphaRouters.
func (g *GCEAlphaRouters) TestIamPermissions(ctx context.Context, key *meta.Key, arg0 *alpha.TestPermissionsRequest) (*alpha.TestPermissionsResponse, error) {
	klog.V(5).Infof("GCEAlphaRouters.TestIamPermissions(%v, %v, ...): called", ctx, key)

	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaRouters.TestIamPermissions(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "alpha", "Routers")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "TestIamPermissions",
		Version:   meta.Version("alpha"),
		Service:   "Routers",
	}
	klog.V(5).Infof("GCEAlphaRouters.TestIamPermissions(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)

	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEAlphaRouters.TestIamPermissions(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.Alpha.Routers.TestIamPermissions(projectID, key.Region, key.Name, arg0)
	call.Context(ctx)
	v, err := call.Do()
	klog.V(4).Infof("GCEAlphaRouters.TestIamPermissions(%v, %v, ...) = %+v, %v", ctx, key, v, err)
	return v, err
}

// BetaRouters is an interface that allows for mocking of Routers.
type BetaRouters interface {
	Get(ctx context.Context, key *meta.Key) (*beta.Router, error)
	List(ctx context.Context, region string, fl *filter.F) ([]*beta.Router, error)
	Insert(ctx context.Context, key *meta.Key, obj *beta.Router) error
	Delete(ctx context.Context, key *meta.Key) error
	AggregatedList(ctx context.Context, fl *filter.F) (map[string][]*beta.Router, error)
	GetRouterStatus(context.Context, *meta.Key) (*beta.RouterStatusResponse, error)
	Patch(context.Context, *meta.Key, *beta.Router) error
	Preview(context.Context, *meta.Key, *beta.Router) (*beta.RoutersPreviewResponse, error)
	TestIamPermissions(context.Context, *meta.Key, *beta.TestPermissionsRequest) (*beta.TestPermissionsResponse, error)
}

// NewMockBetaRouters returns a new mock for Routers.
func NewMockBetaRouters(pr ProjectRouter, objs map[meta.Key]*MockRoutersObj) *MockBetaRouters {
	mock := &MockBetaRouters{
		ProjectRouter: pr,

		Objects:     objs,
		GetError:    map[meta.Key]error{},
		InsertError: map[meta.Key]error{},
		DeleteError: map[meta.Key]error{},
	}
	return mock
}

// MockBetaRouters is the mock for Routers.
type MockBetaRouters struct {
	Lock sync.Mutex

	ProjectRouter ProjectRouter

	// Objects maintained by the mock.
	Objects map[meta.Key]*MockRoutersObj

	// If an entry exists for the given key and operation, then the error
	// will be returned instead of the operation.
	GetError            map[meta.Key]error
	ListError           *error
	InsertError         map[meta.Key]error
	DeleteError         map[meta.Key]error
	AggregatedListError *error

	// xxxHook allow you to intercept the standard processing of the mock in
	// order to add your own logic. Return (true, _, _) to prevent the normal
	// execution flow of the mock. Return (false, nil, nil) to continue with
	// normal mock behavior/ after the hook function executes.
	GetHook                func(ctx context.Context, key *meta.Key, m *MockBetaRouters) (bool, *beta.Router, error)
	ListHook               func(ctx context.Context, region string, fl *filter.F, m *MockBetaRouters) (bool, []*beta.Router, error)
	InsertHook             func(ctx context.Context, key *meta.Key, obj *beta.Router, m *MockBetaRouters) (bool, error)
	DeleteHook             func(ctx context.Context, key *meta.Key, m *MockBetaRouters) (bool, error)
	AggregatedListHook     func(ctx context.Context, fl *filter.F, m *MockBetaRouters) (bool, map[string][]*beta.Router, error)
	GetRouterStatusHook    func(context.Context, *meta.Key, *MockBetaRouters) (*beta.RouterStatusResponse, error)
	PatchHook              func(context.Context, *meta.Key, *beta.Router, *MockBetaRouters) error
	PreviewHook            func(context.Context, *meta.Key, *beta.Router, *MockBetaRouters) (*beta.RoutersPreviewResponse, error)
	TestIamPermissionsHook func(context.Context, *meta.Key, *beta.TestPermissionsRequest, *MockBetaRouters) (*beta.TestPermissionsResponse, error)

	// X is extra state that can be used as part of the mock. Generated code
	// will not use this field.
	X interface{}
}

// Get returns the object from the mock.
func (m *MockBetaRouters) Get(ctx context.Context, key *meta.Key) (*beta.Router, error) {
	if m.GetHook != nil {
		if intercept, obj, err := m.GetHook(ctx, key, m); intercept {
			klog.V(5).Infof("MockBetaRouters.Get(%v, %s) = %+v, %v", ctx, key, obj, err)
			return obj, err
		}
	}
	if !key.Valid() {
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.GetError[*key]; ok {
		klog.V(5).Infof("MockBetaRouters.Get(%v, %s) = nil, %v", ctx, key, err)
		return nil, err
	}
	if obj, ok := m.Objects[*key]; ok {
		typedObj := obj.ToBeta()
		klog.V(5).Infof("MockBetaRouters.Get(%v, %s) = %+v, nil", ctx, key, typedObj)
		return typedObj, nil
	}

	err := &googleapi.Error{
		Code:    http.StatusNotFound,
		Message: fmt.Sprintf("MockBetaRouters %v not found", key),
	}
	klog.V(5).Infof("MockBetaRouters.Get(%v, %s) = nil, %v", ctx, key, err)
	return nil, err
}

// List all of the objects in the mock in the given region.
func (m *MockBetaRouters) List(ctx context.Context, region string, fl *filter.F) ([]*beta.Router, error) {
	if m.ListHook != nil {
		if intercept, objs, err := m.ListHook(ctx, region, fl, m); intercept {
			klog.V(5).Infof("MockBetaRouters.List(%v, %q, %v) = [%v items], %v", ctx, region, fl, len(objs), err)
			return objs, err
		}
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if m.ListError != nil {
		err := *m.ListError
		klog.V(5).Infof("MockBetaRouters.List(%v, %q, %v) = nil, %v", ctx, region, fl, err)

		return nil, *m.ListError
	}

	var objs []*beta.Router
	for key, obj := range m.Objects {
		if key.Region != region {
			continue
		}
		if !fl.Match(obj.ToBeta()) {
			continue
		}
		objs = append(objs, obj.ToBeta())
	}

	klog.V(5).Infof("MockBetaRouters.List(%v, %q, %v) = [%v items], nil", ctx, region, fl, len(objs))
	return objs, nil
}

// Insert is a mock for inserting/creating a new object.
func (m *MockBetaRouters) Insert(ctx context.Context, key *meta.Key, obj *beta.Router) error {
	if m.InsertHook != nil {
		if intercept, err := m.InsertHook(ctx, key, obj, m); intercept {
			klog.V(5).Infof("MockBetaRouters.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.InsertError[*key]; ok {
		klog.V(5).Infof("MockBetaRouters.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}
	if _, ok := m.Objects[*key]; ok {
		err := &googleapi.Error{
			Code:    http.StatusConflict,
			Message: fmt.Sprintf("MockBetaRouters %v exists", key),
		}
		klog.V(5).Infof("MockBetaRouters.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}

	obj.Name = key.Name
	projectID := m.ProjectRouter.ProjectID(ctx, "beta", "routers")
	obj.SelfLink = SelfLink(meta.VersionBeta, projectID, "routers", key)

	m.Objects[*key] = &MockRoutersObj{obj}
	klog.V(5).Infof("MockBetaRouters.Insert(%v, %v, %+v) = nil", ctx, key, obj)
	return nil
}

// Delete is a mock for deleting the object.
func (m *MockBetaRouters) Delete(ctx context.Context, key *meta.Key) error {
	if m.DeleteHook != nil {
		if intercept, err := m.DeleteHook(ctx, key, m); intercept {
			klog.V(5).Infof("MockBetaRouters.Delete(%v, %v) = %v", ctx, key, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.DeleteError[*key]; ok {
		klog.V(5).Infof("MockBetaRouters.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}
	if _, ok := m.Objects[*key]; !ok {
		err := &googleapi.Error{
			Code:    http.StatusNotFound,
			Message: fmt.Sprintf("MockBetaRouters %v not found", key),
		}
		klog.V(5).Infof("MockBetaRouters.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	delete(m.Objects, *key)
	klog.V(5).Infof("MockBetaRouters.Delete(%v, %v) = nil", ctx, key)
	return nil
}

// AggregatedList is a mock for AggregatedList.
func (m *MockBetaRouters) AggregatedList(ctx context.Context, fl *filter.F) (map[string][]*beta.Router, error) {
	if m.AggregatedListHook != nil {
		if intercept, objs, err := m.AggregatedListHook(ctx, fl, m); intercept {
			klog.V(5).Infof("MockBetaRouters.AggregatedList(%v, %v) = [%v items], %v", ctx, fl, len(objs), err)
			return objs, err
		}
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if m.AggregatedListError != nil {
		err := *m.AggregatedListError
		klog.V(5).Infof("MockBetaRouters.AggregatedList(%v, %v) = nil, %v", ctx, fl, err)
		return nil, err
	}

	objs := map[string][]*beta.Router{}
	for _, obj := range m.Objects {
		res, err := ParseResourceURL(obj.ToBeta().SelfLink)
		if err != nil {
			klog.V(5).Infof("MockBetaRouters.AggregatedList(%v, %v) = nil, %v", ctx, fl, err)
			return nil, err
		}
		if !fl.Match(obj.ToBeta()) {
			continue
		}
		location := aggregatedListKey(res.Key)
		objs[location] = append(objs[location], obj.ToBeta())
	}
	klog.V(5).Infof("MockBetaRouters.AggregatedList(%v, %v) = [%v items], nil", ctx, fl, len(objs))
	return objs, nil
}

// Obj wraps the object for use in the mock.
func (m *MockBetaRouters) Obj(o *beta.Router) *MockRoutersObj {
	return &MockRoutersObj{o}
}

// GetRouterStatus is a mock for the corresponding method.
func (m *MockBetaRouters) GetRouterStatus(ctx context.Context, key *meta.Key) (*beta.RouterStatusResponse, error) {
	if m.GetRouterStatusHook != nil {
		return m.GetRouterStatusHook(ctx, key, m)
	}
	return nil, fmt.Errorf("GetRouterStatusHook must be set")
}

// Patch is a mock for the corresponding method.
func (m *MockBetaRouters) Patch(ctx context.Context, key *meta.Key, arg0 *beta.Router) error {
	if m.PatchHook != nil {
		return m.PatchHook(ctx, key, arg0, m)
	}
	return nil
}

// Preview is a mock for the corresponding method.
func (m *MockBetaRouters) Preview(ctx context.Context, key *meta.Key, arg0 *beta.Router) (*beta.RoutersPreviewResponse, error) {
	if m.PreviewHook != nil {
		return m.PreviewHook(ctx, key, arg0, m)
	}
	return nil, fmt.Errorf("PreviewHook must be set")
}

// TestIamPermissions is a mock for the corresponding method.
func (m *MockBetaRouters) TestIamPermissions(ctx context.Context, key *meta.Key, arg0 *beta.TestPermissionsRequest) (*beta.TestPermissionsResponse, error) {
	if m.TestIamPermissionsHook != nil {
		return m.TestIamPermissionsHook(ctx, key, arg0, m)
	}
	return nil, fmt.Errorf("TestIamPermissionsHook must be set")
}

// GCEBetaRouters is a simplifying adapter for the GCE Routers.
type GCEBetaRouters struct {
	s *Service
}

// Get the Router named by key.
func (g *GCEBetaRouters) Get(ctx context.Context, key *meta.Key) (*beta.Router, error) {
	klog.V(5).Infof("GCEBetaRouters.Get(%v, %v): called", ctx, key)

	if !key.Valid() {
		klog.V(2).Infof("GCEBetaRouters.Get(%v, %v): key is invalid (%#v)", ctx, key, key)
		return nil, fmt.Errorf("invalid GCE key (%#v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "beta", "Routers")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Get",
		Version:   meta.Version("beta"),
		Service:   "Routers",
	}
	klog.V(5).Infof("GCEBetaRouters.Get(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEBetaRouters.Get(%v, %v): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.Beta.Routers.Get(projectID, key.Region, key.Name)
	call.Context(ctx)
	v, err := call.Do()
	klog.V(4).Infof("GCEBetaRouters.Get(%v, %v) = %+v, %v", ctx, key, v, err)
	return v, err
}

// List all Router objects.
func (g *GCEBetaRouters) List(ctx context.Context, region string, fl *filter.F) ([]*beta.Router, error) {
	klog.V(5).Infof("GCEBetaRouters.List(%v, %v, %v) called", ctx, region, fl)
	projectID := g.s.ProjectRouter.ProjectID(ctx, "beta", "Routers")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "List",
		Version:   meta.Version("beta"),
		Service:   "Routers",
	}
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		return nil, err
	}
	klog.V(5).Infof("GCEBetaRouters.List(%v, %v, %v): projectID = %v, rk = %+v", ctx, region, fl, projectID, rk)
	call := g.s.Beta.Routers.List(projectID, region)
	if fl != filter.None {
		call.Filter(fl.String())
	}
	var all []*beta.Router
	f := func(l *beta.RouterList) error {
		klog.V(5).Infof("GCEBetaRouters.List(%v, ..., %v): page %+v", ctx, fl, l)
		all = append(all, l.Items...)
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		klog.V(4).Infof("GCEBetaRouters.List(%v, ..., %v) = %v, %v", ctx, fl, nil, err)
		return nil, err
	}

	if klog.V(4).Enabled() {
		klog.V(4).Infof("GCEBetaRouters.List(%v, ..., %v) = [%v items], %v", ctx, fl, len(all), nil)
	} else if klog.V(5).Enabled() {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		klog.V(5).Infof("GCEBetaRouters.List(%v, ..., %v) = %v, %v", ctx, fl, asStr, nil)
	}

	return all, nil
}

// Insert Router with key of value obj.
func (g *GCEBetaRouters) Insert(ctx context.Context, key *meta.Key, obj *beta.Router) error {
	klog.V(5).Infof("GCEBetaRouters.Insert(%v, %v, %+v): called", ctx, key, obj)
	if !key.Valid() {
		klog.V(2).Infof("GCEBetaRouters.Insert(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "beta", "Routers")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Insert",
		Version:   meta.Version("beta"),
		Service:   "Routers",
	}
	klog.V(5).Infof("GCEBetaRouters.Insert(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEBetaRouters.Insert(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	obj.Name = key.Name
	call := g.s.Beta.Routers.Insert(projectID, key.Region, obj)
	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCEBetaRouters.Insert(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEBetaRouters.Insert(%v, %v, %+v) = %+v", ctx, key, obj, err)
	return err
}

// Delete the Router referenced by key.
func (g *GCEBetaRouters) Delete(ctx context.Context, key *meta.Key) error {
	klog.V(5).Infof("GCEBetaRouters.Delete(%v, %v): called", ctx, key)
	if !key.Valid() {
		klog.V(2).Infof("GCEBetaRouters.Delete(%v, %v): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "beta", "Routers")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Delete",
		Version:   meta.Version("beta"),
		Service:   "Routers",
	}
	klog.V(5).Infof("GCEBetaRouters.Delete(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEBetaRouters.Delete(%v, %v): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Beta.Routers.Delete(projectID, key.Region, key.Name)
	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCEBetaRouters.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEBetaRouters.Delete(%v, %v) = %v", ctx, key, err)
	return err
}

// AggregatedList lists all resources of the given type across all locations.
func (g *GCEBetaRouters) AggregatedList(ctx context.Context, fl *filter.F) (map[string][]*beta.Router, error) {
	klog.V(5).Infof("GCEBetaRouters.AggregatedList(%v, %v) called", ctx, fl)

	projectID := g.s.ProjectRouter.ProjectID(ctx, "beta", "Routers")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "AggregatedList",
		Version:   meta.Version("beta"),
		Service:   "Routers",
	}

	klog.V(5).Infof("GCEBetaRouters.AggregatedList(%v, %v): projectID = %v, rk = %+v", ctx, fl, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(5).Infof("GCEBetaRouters.AggregatedList(%v, %v): RateLimiter error: %v", ctx, fl, err)
		return nil, err
	}

	call := g.s.Beta.Routers.AggregatedList(projectID)
	call.Context(ctx)
	if fl != filter.None {
		call.Filter(fl.String())
	}

	all := map[string][]*beta.Router{}
	f := func(l *beta.RouterAggregatedList) error {
		for k, v := range l.Items {
			klog.V(5).Infof("GCEBetaRouters.AggregatedList(%v, %v): page[%v]%+v", ctx, fl, k, v)
			all[k] = append(all[k], v.Routers...)
		}
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		klog.V(4).Infof("GCEBetaRouters.AggregatedList(%v, %v) = %v, %v", ctx, fl, nil, err)
		return nil, err
	}
	if klog.V(4).Enabled() {
		klog.V(4).Infof("GCEBetaRouters.AggregatedList(%v, %v) = [%v items], %v", ctx, fl, len(all), nil)
	} else if klog.V(5).Enabled() {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		klog.V(5).Infof("GCEBetaRouters.AggregatedList(%v, %v) = %v, %v", ctx, fl, asStr, nil)
	}
	return all, nil
}

// GetRouterStatus is a method on GCEBetaRouters.
func (g *GCEBetaRouters) GetRouterStatus(ctx context.Context, key *meta.Key) (*beta.RouterStatusResponse, error) {
	klog.V(5).Infof("GCEBetaRouters.GetRouterStatus(%v, %v, ...): called", ctx, key)

	if !key.Valid() {
		klog.V(2).Infof("GCEBetaRouters.GetRouterStatus(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "beta", "Routers")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "GetRouterStatus",
		Version:   meta.Version("beta"),
		Service:   "Routers",
	}
	klog.V(5).Infof("GCEBetaRouters.GetRouterStatus(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)

	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEBetaRouters.GetRouterStatus(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.Beta.Routers.GetRouterStatus(projectID, key.Region, key.Name)
	call.Context(ctx)
	v, err := call.Do()
	klog.V(4).Infof("GCEBetaRouters.GetRouterStatus(%v, %v, ...) = %+v, %v", ctx, key, v, err)
	return v, err
}

// Patch is a method on GCEBetaRouters.
func (g *GCEBetaRouters) Patch(ctx context.Context, key *meta.Key, arg0 *beta.Router) error {
	klog.V(5).Infof("GCEBetaRouters.Patch(%v, %v, ...): called", ctx, key)

	if !key.Valid() {
		klog.V(2).Infof("GCEBetaRouters.Patch(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "beta", "Routers")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Patch",
		Version:   meta.Version("beta"),
		Service:   "Routers",
	}
	klog.V(5).Infof("GCEBetaRouters.Patch(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)

	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEBetaRouters.Patch(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Beta.Routers.Patch(projectID, key.Region, key.Name, arg0)
	call.Context(ctx)
	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCEBetaRouters.Patch(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}
	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEBetaRouters.Patch(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// Preview is a method on GCEBetaRouters.
func (g *GCEBetaRouters) Preview(ctx context.Context, key *meta.Key, arg0 *beta.Router) (*beta.RoutersPreviewResponse, error) {
	klog.V(5).Infof("GCEBetaRouters.Preview(%v, %v, ...): called", ctx, key)

	if !key.Valid() {
		klog.V(2).Infof("GCEBetaRouters.Preview(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "beta", "Routers")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Preview",
		Version:   meta.Version("beta"),
		Service:   "Routers",
	}
	klog.V(5).Infof("GCEBetaRouters.Preview(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)

	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEBetaRouters.Preview(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.Beta.Routers.Preview(projectID, key.Region, key.Name, arg0)
	call.Context(ctx)
	v, err := call.Do()
	klog.V(4).Infof("GCEBetaRouters.Preview(%v, %v, ...) = %+v, %v", ctx, key, v, err)
	return v, err
}

// TestIamPermissions is a method on GCEBetaRouters.
func (g *GCEBetaRouters) TestIamPermissions(ctx context.Context, key *meta.Key, arg0 *beta.TestPermissionsRequest) (*beta.TestPermissionsResponse, error) {
	klog.V(5).Infof("GCEBetaRouters.TestIamPermissions(%v, %v, ...): called", ctx, key)

	if !key.Valid() {
		klog.V(2).Infof("GCEBetaRouters.TestIamPermissions(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "beta", "Routers")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "TestIamPermissions",
		Version:   meta.Version("beta"),
		Service:   "Routers",
	}
	klog.V(5).Infof("GCEBetaRouters.TestIamPermissions(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)

	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEBetaRouters.TestIamPermissions(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.Beta.Routers.TestIamPermissions(projectID, key.Region, key.Name, arg0)
	call.Context(ctx)
	v, err := call.Do()
	klog.V(4).Infof("GCEBetaRouters.TestIamPermissions(%v, %v, ...) = %+v, %v", ctx, key, v, err)
	return v, err
}

// Routers is an interface that allows for mocking of Routers.
type Routers interface {
	Get(ctx context.Context, key *meta.Key) (*ga.Router, error)
	List(ctx context.Context, region string, fl *filter.F) ([]*ga.Router, error)
	Insert(ctx context.Context, key *meta.Key, obj *ga.Router) error
	Delete(ctx context.Context, key *meta.Key) error
	AggregatedList(ctx context.Context, fl *filter.F) (map[string][]*ga.Router, error)
	GetRouterStatus(context.Context, *meta.Key) (*ga.RouterStatusResponse, error)
	Patch(context.Context, *meta.Key, *ga.Router) error
	Preview(context.Context, *meta.Key, *ga.Router) (*ga.RoutersPreviewResponse, error)
}

// NewMockRouters returns a new mock for Routers.
func NewMockRouters(pr ProjectRouter, objs map[meta.Key]*MockRoutersObj) *MockRouters {
	mock := &MockRouters{
		ProjectRouter: pr,

		Objects:     objs,
		GetError:    map[meta.Key]error{},
		InsertError: map[meta.Key]error{},
		DeleteError: map[meta.Key]error{},
	}
	return mock
}

// MockRouters is the mock for Routers.
type MockRouters struct {
	Lock sync.Mutex

	ProjectRouter ProjectRouter

	// Objects maintained by the mock.
	Objects map[meta.Key]*MockRoutersObj

	// If an entry exists for the given key and operation, then the error
	// will be returned instead of the operation.
	GetError            map[meta.Key]error
	ListError           *error
	InsertError         map[meta.Key]error
	DeleteError         map[meta.Key]error
	AggregatedListError *error

	// xxxHook allow you to intercept the standard processing of the mock in
	// order to add your own logic. Return (true, _, _) to prevent the normal
	// execution flow of the mock. Return (false, nil, nil) to continue with
	// normal mock behavior/ after the hook function executes.
	GetHook             func(ctx context.Context, key *meta.Key, m *MockRouters) (bool, *ga.Router, error)
	ListHook            func(ctx context.Context, region string, fl *filter.F, m *MockRouters) (bool, []*ga.Router, error)
	InsertHook          func(ctx context.Context, key *meta.Key, obj *ga.Router, m *MockRouters) (bool, error)
	DeleteHook          func(ctx context.Context, key *meta.Key, m *MockRouters) (bool, error)
	AggregatedListHook  func(ctx context.Context, fl *filter.F, m *MockRouters) (bool, map[string][]*ga.Router, error)
	GetRouterStatusHook func(context.Context, *meta.Key, *MockRouters) (*ga.RouterStatusResponse, error)
	PatchHook           func(context.Context, *meta.Key, *ga.Router, *MockRouters) error
	PreviewHook         func(context.Context, *meta.Key, *ga.Router, *MockRouters) (*ga.RoutersPreviewResponse, error)

	// X is extra state that can be used as part of the mock. Generated code
	// will not use this field.
	X interface{}
}

// Get returns the object from the mock.
func (m *MockRouters) Get(ctx context.Context, key *meta.Key) (*ga.Router, error) {
	if m.GetHook != nil {
		if intercept, obj, err := m.GetHook(ctx, key, m); intercept {
			klog.V(5).Infof("MockRouters.Get(%v, %s) = %+v, %v", ctx, key, obj, err)
			return obj, err
		}
	}
	if !key.Valid() {
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.GetError[*key]; ok {
		klog.V(5).Infof("MockRouters.Get(%v, %s) = nil, %v", ctx, key, err)
		return nil, err
	}
	if obj, ok := m.Objects[*key]; ok {
		typedObj := obj.ToGA()
		klog.V(5).Infof("MockRouters.Get(%v, %s) = %+v, nil", ctx, key, typedObj)
		return typedObj, nil
	}

	err := &googleapi.Error{
		Code:    http.StatusNotFound,
		Message: fmt.Sprintf("MockRouters %v not found", key),
	}
	klog.V(5).Infof("MockRouters.Get(%v, %s) = nil, %v", ctx, key, err)
	return nil, err
}

// List all of the objects in the mock in the given region.
func (m *MockRouters) List(ctx context.Context, region string, fl *filter.F) ([]*ga.Router, error) {
	if m.ListHook != nil {
		if intercept, objs, err := m.ListHook(ctx, region, fl, m); intercept {
			klog.V(5).Infof("MockRouters.List(%v, %q, %v) = [%v items], %v", ctx, region, fl, len(objs), err)
			return objs, err
		}
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if m.ListError != nil {
		err := *m.ListError
		klog.V(5).Infof("MockRouters.List(%v, %q, %v) = nil, %v", ctx, region, fl, err)

		return nil, *m.ListError
	}

	var objs []*ga.Router
	for key, obj := range m.Objects {
		if key.Region != region {
			continue
		}
		if !fl.Match(obj.ToGA()) {
			continue
		}
		objs = append(objs, obj.ToGA())
	}

	klog.V(5).Infof("MockRouters.List(%v, %q, %v) = [%v items], nil", ctx, region, fl, len(objs))
	return objs, nil
}

// Insert is a mock for inserting/creating a new object.
func (m *MockRouters) Insert(ctx context.Context, key *meta.Key, obj *ga.Router) error {
	if m.InsertHook != nil {
		if intercept, err := m.InsertHook(ctx, key, obj, m); intercept {
			klog.V(5).Infof("MockRouters.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.InsertError[*key]; ok {
		klog.V(5).Infof("MockRouters.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}
	if _, ok := m.Objects[*key]; ok {
		err := &googleapi.Error{
			Code:    http.StatusConflict,
			Message: fmt.Sprintf("MockRouters %v exists", key),
		}
		klog.V(5).Infof("MockRouters.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}

	obj.Name = key.Name
	projectID := m.ProjectRouter.ProjectID(ctx, "ga", "routers")
	obj.SelfLink = SelfLink(meta.VersionGA, projectID, "routers", key)

	m.Objects[*key] = &MockRoutersObj{obj}
	klog.V(5).Infof("MockRouters.Insert(%v, %v, %+v) = nil", ctx, key, obj)
	return nil
}

// Delete is a mock for deleting the object.
func (m *MockRouters) Delete(ctx context.Context, key *meta.Key) error {
	if m.DeleteHook != nil {
		if intercept, err := m.DeleteHook(ctx, key, m); intercept {
			klog.V(5).Infof("MockRouters.Delete(%v, %v) = %v", ctx, key, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.DeleteError[*key]; ok {
		klog.V(5).Infof("MockRouters.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}
	if _, ok := m.Objects[*key]; !ok {
		err := &googleapi.Error{
			Code:    http.StatusNotFound,
			Message: fmt.Sprintf("MockRouters %v not found", key),
		}
		klog.V(5).Infof("MockRouters.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	delete(m.Objects, *key)
	klog.V(5).Infof("MockRouters.Delete(%v, %v) = nil", ctx, key)
	return nil
}

// AggregatedList is a mock for AggregatedList.
func (m *MockRouters) AggregatedList(ctx context.Context, fl *filter.F) (map[string][]*ga.Router, error) {
	if m.AggregatedListHook != nil {
		if intercept, objs, err := m.AggregatedListHook(ctx, fl, m); intercept {
			klog.V(5).Infof("MockRouters.AggregatedList(%v, %v) = [%v items], %v", ctx, fl, len(objs), err)
			return objs, err
		}
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if m.AggregatedListError != nil {
		err := *m.AggregatedListError
		klog.V(5).Infof("MockRouters.AggregatedList(%v, %v) = nil, %v", ctx, fl, err)
		return nil, err
	}

	objs := map[string][]*ga.Router{}
	for _, obj := range m.Objects {
		res, err := ParseResourceURL(obj.ToGA().SelfLink)
		if err != nil {
			klog.V(5).Infof("MockRouters.AggregatedList(%v, %v) = nil, %v", ctx, fl, err)
			return nil, err
		}
		if !fl.Match(obj.ToGA()) {
			continue
		}
		location := aggregatedListKey(res.Key)
		objs[location] = append(objs[location], obj.ToGA())
	}
	klog.V(5).Infof("MockRouters.AggregatedList(%v, %v) = [%v items], nil", ctx, fl, len(objs))
	return objs, nil
}

// Obj wraps the object for use in the mock.
func (m *MockRouters) Obj(o *ga.Router) *MockRoutersObj {
	return &MockRoutersObj{o}
}

// GetRouterStatus is a mock for the corresponding method.
func (m *MockRouters) GetRouterStatus(ctx context.Context, key *meta.Key) (*ga.RouterStatusResponse, error) {
	if m.GetRouterStatusHook != nil {
		return m.GetRouterStatusHook(ctx, key, m)
	}
	return nil, fmt.Errorf("GetRouterStatusHook must be set")
}

// Patch is a mock for the corresponding method.
func (m *MockRouters) Patch(ctx context.Context, key *meta.Key, arg0 *ga.Router) error {
	if m.PatchHook != nil {
		return m.PatchHook(ctx, key, arg0, m)
	}
	return nil
}

// Preview is a mock for the corresponding method.
func (m *MockRouters) Preview(ctx context.Context, key *meta.Key, arg0 *ga.Router) (*ga.RoutersPreviewResponse, error) {
	if m.PreviewHook != nil {
		return m.PreviewHook(ctx, key, arg0, m)
	}
	return nil, fmt.Errorf("PreviewHook must be set")
}

// GCERouters is a simplifying adapter for the GCE Routers.
type GCERouters struct {
	s *Service
}

// Get the Router named by key.
func (g *GCERouters) Get(ctx context.Context, key *meta.Key) (*ga.Router, error) {
	klog.V(5).Infof("GCERouters.Get(%v, %v): called", ctx, key)

	if !key.Valid() {
		klog.V(2).Infof("GCERouters.Get(%v, %v): key is invalid (%#v)", ctx, key, key)
		return nil, fmt.Errorf("invalid GCE key (%#v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "Routers")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Get",
		Version:   meta.Version("ga"),
		Service:   "Routers",
	}
	klog.V(5).Infof("GCERouters.Get(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCERouters.Get(%v, %v): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.GA.Routers.Get(projectID, key.Region, key.Name)
	call.Context(ctx)
	v, err := call.Do()
	klog.V(4).Infof("GCERouters.Get(%v, %v) = %+v, %v", ctx, key, v, err)
	return v, err
}

// List all Router objects.
func (g *GCERouters) List(ctx context.Context, region string, fl *filter.F) ([]*ga.Router, error) {
	klog.V(5).Infof("GCERouters.List(%v, %v, %v) called", ctx, region, fl)
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "Routers")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "List",
		Version:   meta.Version("ga"),
		Service:   "Routers",
	}
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		return nil, err
	}
	klog.V(5).Infof("GCERouters.List(%v, %v, %v): projectID = %v, rk = %+v", ctx, region, fl, projectID, rk)
	call := g.s.GA.Routers.List(projectID, region)
	if fl != filter.None {
		call.Filter(fl.String())
	}
	var all []*ga.Router
	f := func(l *ga.RouterList) error {
		klog.V(5).Infof("GCERouters.List(%v, ..., %v): page %+v", ctx, fl, l)
		all = append(all, l.Items...)
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		klog.V(4).Infof("GCERouters.List(%v, ..., %v) = %v, %v", ctx, fl, nil, err)
		return nil, err
	}

	if klog.V(4).Enabled() {
		klog.V(4).Infof("GCERouters.List(%v, ..., %v) = [%v items], %v", ctx, fl, len(all), nil)
	} else if klog.V(5).Enabled() {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		klog.V(5).Infof("GCERouters.List(%v, ..., %v) = %v, %v", ctx, fl, asStr, nil)
	}

	return all, nil
}

// Insert Router with key of value obj.
func (g *GCERouters) Insert(ctx context.Context, key *meta.Key, obj *ga.Router) error {
	klog.V(5).Infof("GCERouters.Insert(%v, %v, %+v): called", ctx, key, obj)
	if !key.Valid() {
		klog.V(2).Infof("GCERouters.Insert(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "Routers")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Insert",
		Version:   meta.Version("ga"),
		Service:   "Routers",
	}
	klog.V(5).Infof("GCERouters.Insert(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCERouters.Insert(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	obj.Name = key.Name
	call := g.s.GA.Routers.Insert(projectID, key.Region, obj)
	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCERouters.Insert(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCERouters.Insert(%v, %v, %+v) = %+v", ctx, key, obj, err)
	return err
}

// Delete the Router referenced by key.
func (g *GCERouters) Delete(ctx context.Context, key *meta.Key) error {
	klog.V(5).Infof("GCERouters.Delete(%v, %v): called", ctx, key)
	if !key.Valid() {
		klog.V(2).Infof("GCERouters.Delete(%v, %v): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "Routers")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Delete",
		Version:   meta.Version("ga"),
		Service:   "Routers",
	}
	klog.V(5).Infof("GCERouters.Delete(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCERouters.Delete(%v, %v): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.GA.Routers.Delete(projectID, key.Region, key.Name)
	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCERouters.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCERouters.Delete(%v, %v) = %v", ctx, key, err)
	return err
}

// AggregatedList lists all resources of the given type across all locations.
func (g *GCERouters) AggregatedList(ctx context.Context, fl *filter.F) (map[string][]*ga.Router, error) {
	klog.V(5).Infof("GCERouters.AggregatedList(%v, %v) called", ctx, fl)

	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "Routers")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "AggregatedList",
		Version:   meta.Version("ga"),
		Service:   "Routers",
	}

	klog.V(5).Infof("GCERouters.AggregatedList(%v, %v): projectID = %v, rk = %+v", ctx, fl, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(5).Infof("GCERouters.AggregatedList(%v, %v): RateLimiter error: %v", ctx, fl, err)
		return nil, err
	}

	call := g.s.GA.Routers.AggregatedList(projectID)
	call.Context(ctx)
	if fl != filter.None {
		call.Filter(fl.String())
	}

	all := map[string][]*ga.Router{}
	f := func(l *ga.RouterAggregatedList) error {
		for k, v := range l.Items {
			klog.V(5).Infof("GCERouters.AggregatedList(%v, %v): page[%v]%+v", ctx, fl, k, v)
			all[k] = append(all[k], v.Routers...)
		}
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		klog.V(4).Infof("GCERouters.AggregatedList(%v, %v) = %v, %v", ctx, fl, nil, err)
		return nil, err
	}
	if klog.V(4).Enabled() {
		klog.V(4).Infof("GCERouters.AggregatedList(%v, %v) = [%v items], %v", ctx, fl, len(all), nil)
	} else if klog.V(5).Enabled() {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		klog.V(5).Infof("GCERouters.AggregatedList(%v, %v) = %v, %v", ctx, fl, asStr, nil)
	}
	return all, nil
}

// GetRouterStatus is a method on GCERouters.
func (g *GCERouters) GetRouterStatus(ctx context.Context, key *meta.Key) (*ga.RouterStatusResponse, error) {
	klog.V(5).Infof("GCERouters.GetRouterStatus(%v, %v, ...): called", ctx, key)

	if !key.Valid() {
		klog.V(2).Infof("GCERouters.GetRouterStatus(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "Routers")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "GetRouterStatus",
		Version:   meta.Version("ga"),
		Service:   "Routers",
	}
	klog.V(5).Infof("GCERouters.GetRouterStatus(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)

	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCERouters.GetRouterStatus(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.GA.Routers.GetRouterStatus(projectID, key.Region, key.Name)
	call.Context(ctx)
	v, err := call.Do()
	klog.V(4).Infof("GCERouters.GetRouterStatus(%v, %v, ...) = %+v, %v", ctx, key, v, err)
	return v, err
}

// Patch is a method on GCERouters.
func (g *GCERouters) Patch(ctx context.Context, key *meta.Key, arg0 *ga.Router) error {
	klog.V(5).Infof("GCERouters.Patch(%v, %v, ...): called", ctx, key)

	if !key.Valid() {
		klog.V(2).Infof("GCERouters.Patch(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "Routers")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Patch",
		Version:   meta.Version("ga"),
		Service:   "Routers",
	}
	klog.V(5).Infof("GCERouters.Patch(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)

	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCERouters.Patch(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.GA.Routers.Patch(projectID, key.Region, key.Name, arg0)
	call.Context(ctx)
	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCERouters.Patch(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}
	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCERouters.Patch(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// Preview is a method on GCERouters.
func (g *GCERouters) Preview(ctx context.Context, key *meta.Key, arg0 *ga.Router) (*ga.RoutersPreviewResponse, error) {
	klog.V(5).Infof("GCERouters.Preview(%v, %v, ...): called", ctx, key)

	if !key.Valid() {
		klog.V(2).Infof("GCERouters.Preview(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "Routers")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Preview",
		Version:   meta.Version("ga"),
		Service:   "Routers",
	}
	klog.V(5).Infof("GCERouters.Preview(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)

	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCERouters.Preview(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.GA.Routers.Preview(projectID, key.Region, key.Name, arg0)
	call.Context(ctx)
	v, err := call.Do()
	klog.V(4).Infof("GCERouters.Preview(%v, %v, ...) = %+v, %v", ctx, key, v, err)
	return v, err
}

// Routes is an interface that allows for mocking of Routes.
type Routes interface {
	Get(ctx context.Context, key *meta.Key) (*ga.Route, error)
	List(ctx context.Context, fl *filter.F) ([]*ga.Route, error)
	Insert(ctx context.Context, key *meta.Key, obj *ga.Route) error
	Delete(ctx context.Context, key *meta.Key) error
}

// NewMockRoutes returns a new mock for Routes.
func NewMockRoutes(pr ProjectRouter, objs map[meta.Key]*MockRoutesObj) *MockRoutes {
	mock := &MockRoutes{
		ProjectRouter: pr,

		Objects:     objs,
		GetError:    map[meta.Key]error{},
		InsertError: map[meta.Key]error{},
		DeleteError: map[meta.Key]error{},
	}
	return mock
}

// MockRoutes is the mock for Routes.
type MockRoutes struct {
	Lock sync.Mutex

	ProjectRouter ProjectRouter

	// Objects maintained by the mock.
	Objects map[meta.Key]*MockRoutesObj

	// If an entry exists for the given key and operation, then the error
	// will be returned instead of the operation.
	GetError    map[meta.Key]error
	ListError   *error
	InsertError map[meta.Key]error
	DeleteError map[meta.Key]error

	// xxxHook allow you to intercept the standard processing of the mock in
	// order to add your own logic. Return (true, _, _) to prevent the normal
	// execution flow of the mock. Return (false, nil, nil) to continue with
	// normal mock behavior/ after the hook function executes.
	GetHook    func(ctx context.Context, key *meta.Key, m *MockRoutes) (bool, *ga.Route, error)
	ListHook   func(ctx context.Context, fl *filter.F, m *MockRoutes) (bool, []*ga.Route, error)
	InsertHook func(ctx context.Context, key *meta.Key, obj *ga.Route, m *MockRoutes) (bool, error)
	DeleteHook func(ctx context.Context, key *meta.Key, m *MockRoutes) (bool, error)

	// X is extra state that can be used as part of the mock. Generated code
	// will not use this field.
	X interface{}
}

// Get returns the object from the mock.
func (m *MockRoutes) Get(ctx context.Context, key *meta.Key) (*ga.Route, error) {
	if m.GetHook != nil {
		if intercept, obj, err := m.GetHook(ctx, key, m); intercept {
			klog.V(5).Infof("MockRoutes.Get(%v, %s) = %+v, %v", ctx, key, obj, err)
			return obj, err
		}
	}
	if !key.Valid() {
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.GetError[*key]; ok {
		klog.V(5).Infof("MockRoutes.Get(%v, %s) = nil, %v", ctx, key, err)
		return nil, err
	}
	if obj, ok := m.Objects[*key]; ok {
		typedObj := obj.ToGA()
		klog.V(5).Infof("MockRoutes.Get(%v, %s) = %+v, nil", ctx, key, typedObj)
		return typedObj, nil
	}

	err := &googleapi.Error{
		Code:    http.StatusNotFound,
		Message: fmt.Sprintf("MockRoutes %v not found", key),
	}
	klog.V(5).Infof("MockRoutes.Get(%v, %s) = nil, %v", ctx, key, err)
	return nil, err
}

// List all of the objects in the mock.
func (m *MockRoutes) List(ctx context.Context, fl *filter.F) ([]*ga.Route, error) {
	if m.ListHook != nil {
		if intercept, objs, err := m.ListHook(ctx, fl, m); intercept {
			klog.V(5).Infof("MockRoutes.List(%v, %v) = [%v items], %v", ctx, fl, len(objs), err)
			return objs, err
		}
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if m.ListError != nil {
		err := *m.ListError
		klog.V(5).Infof("MockRoutes.List(%v, %v) = nil, %v", ctx, fl, err)

		return nil, *m.ListError
	}

	var objs []*ga.Route
	for _, obj := range m.Objects {
		if !fl.Match(obj.ToGA()) {
			continue
		}
		objs = append(objs, obj.ToGA())
	}

	klog.V(5).Infof("MockRoutes.List(%v, %v) = [%v items], nil", ctx, fl, len(objs))
	return objs, nil
}

// Insert is a mock for inserting/creating a new object.
func (m *MockRoutes) Insert(ctx context.Context, key *meta.Key, obj *ga.Route) error {
	if m.InsertHook != nil {
		if intercept, err := m.InsertHook(ctx, key, obj, m); intercept {
			klog.V(5).Infof("MockRoutes.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.InsertError[*key]; ok {
		klog.V(5).Infof("MockRoutes.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}
	if _, ok := m.Objects[*key]; ok {
		err := &googleapi.Error{
			Code:    http.StatusConflict,
			Message: fmt.Sprintf("MockRoutes %v exists", key),
		}
		klog.V(5).Infof("MockRoutes.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}

	obj.Name = key.Name
	projectID := m.ProjectRouter.ProjectID(ctx, "ga", "routes")
	obj.SelfLink = SelfLink(meta.VersionGA, projectID, "routes", key)

	m.Objects[*key] = &MockRoutesObj{obj}
	klog.V(5).Infof("MockRoutes.Insert(%v, %v, %+v) = nil", ctx, key, obj)
	return nil
}

// Delete is a mock for deleting the object.
func (m *MockRoutes) Delete(ctx context.Context, key *meta.Key) error {
	if m.DeleteHook != nil {
		if intercept, err := m.DeleteHook(ctx, key, m); intercept {
			klog.V(5).Infof("MockRoutes.Delete(%v, %v) = %v", ctx, key, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.DeleteError[*key]; ok {
		klog.V(5).Infof("MockRoutes.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}
	if _, ok := m.Objects[*key]; !ok {
		err := &googleapi.Error{
			Code:    http.StatusNotFound,
			Message: fmt.Sprintf("MockRoutes %v not found", key),
		}
		klog.V(5).Infof("MockRoutes.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	delete(m.Objects, *key)
	klog.V(5).Infof("MockRoutes.Delete(%v, %v) = nil", ctx, key)
	return nil
}

// Obj wraps the object for use in the mock.
func (m *MockRoutes) Obj(o *ga.Route) *MockRoutesObj {
	return &MockRoutesObj{o}
}

// GCERoutes is a simplifying adapter for the GCE Routes.
type GCERoutes struct {
	s *Service
}

// Get the Route named by key.
func (g *GCERoutes) Get(ctx context.Context, key *meta.Key) (*ga.Route, error) {
	klog.V(5).Infof("GCERoutes.Get(%v, %v): called", ctx, key)

	if !key.Valid() {
		klog.V(2).Infof("GCERoutes.Get(%v, %v): key is invalid (%#v)", ctx, key, key)
		return nil, fmt.Errorf("invalid GCE key (%#v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "Routes")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Get",
		Version:   meta.Version("ga"),
		Service:   "Routes",
	}
	klog.V(5).Infof("GCERoutes.Get(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCERoutes.Get(%v, %v): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.GA.Routes.Get(projectID, key.Name)
	call.Context(ctx)
	v, err := call.Do()
	klog.V(4).Infof("GCERoutes.Get(%v, %v) = %+v, %v", ctx, key, v, err)
	return v, err
}

// List all Route objects.
func (g *GCERoutes) List(ctx context.Context, fl *filter.F) ([]*ga.Route, error) {
	klog.V(5).Infof("GCERoutes.List(%v, %v) called", ctx, fl)
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "Routes")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "List",
		Version:   meta.Version("ga"),
		Service:   "Routes",
	}
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		return nil, err
	}
	klog.V(5).Infof("GCERoutes.List(%v, %v): projectID = %v, rk = %+v", ctx, fl, projectID, rk)
	call := g.s.GA.Routes.List(projectID)
	if fl != filter.None {
		call.Filter(fl.String())
	}
	var all []*ga.Route
	f := func(l *ga.RouteList) error {
		klog.V(5).Infof("GCERoutes.List(%v, ..., %v): page %+v", ctx, fl, l)
		all = append(all, l.Items...)
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		klog.V(4).Infof("GCERoutes.List(%v, ..., %v) = %v, %v", ctx, fl, nil, err)
		return nil, err
	}

	if klog.V(4).Enabled() {
		klog.V(4).Infof("GCERoutes.List(%v, ..., %v) = [%v items], %v", ctx, fl, len(all), nil)
	} else if klog.V(5).Enabled() {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		klog.V(5).Infof("GCERoutes.List(%v, ..., %v) = %v, %v", ctx, fl, asStr, nil)
	}

	return all, nil
}

// Insert Route with key of value obj.
func (g *GCERoutes) Insert(ctx context.Context, key *meta.Key, obj *ga.Route) error {
	klog.V(5).Infof("GCERoutes.Insert(%v, %v, %+v): called", ctx, key, obj)
	if !key.Valid() {
		klog.V(2).Infof("GCERoutes.Insert(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "Routes")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Insert",
		Version:   meta.Version("ga"),
		Service:   "Routes",
	}
	klog.V(5).Infof("GCERoutes.Insert(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCERoutes.Insert(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	obj.Name = key.Name
	call := g.s.GA.Routes.Insert(projectID, obj)
	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCERoutes.Insert(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCERoutes.Insert(%v, %v, %+v) = %+v", ctx, key, obj, err)
	return err
}

// Delete the Route referenced by key.
func (g *GCERoutes) Delete(ctx context.Context, key *meta.Key) error {
	klog.V(5).Infof("GCERoutes.Delete(%v, %v): called", ctx, key)
	if !key.Valid() {
		klog.V(2).Infof("GCERoutes.Delete(%v, %v): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "Routes")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Delete",
		Version:   meta.Version("ga"),
		Service:   "Routes",
	}
	klog.V(5).Infof("GCERoutes.Delete(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCERoutes.Delete(%v, %v): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.GA.Routes.Delete(projectID, key.Name)

	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCERoutes.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCERoutes.Delete(%v, %v) = %v", ctx, key, err)
	return err
}

// BetaSecurityPolicies is an interface that allows for mocking of SecurityPolicies.
type BetaSecurityPolicies interface {
	Get(ctx context.Context, key *meta.Key) (*beta.SecurityPolicy, error)
	List(ctx context.Context, fl *filter.F) ([]*beta.SecurityPolicy, error)
	Insert(ctx context.Context, key *meta.Key, obj *beta.SecurityPolicy) error
	Delete(ctx context.Context, key *meta.Key) error
	AddRule(context.Context, *meta.Key, *beta.SecurityPolicyRule) error
	GetRule(context.Context, *meta.Key) (*beta.SecurityPolicyRule, error)
	Patch(context.Context, *meta.Key, *beta.SecurityPolicy) error
	PatchRule(context.Context, *meta.Key, *beta.SecurityPolicyRule) error
	RemoveRule(context.Context, *meta.Key) error
}

// NewMockBetaSecurityPolicies returns a new mock for SecurityPolicies.
func NewMockBetaSecurityPolicies(pr ProjectRouter, objs map[meta.Key]*MockSecurityPoliciesObj) *MockBetaSecurityPolicies {
	mock := &MockBetaSecurityPolicies{
		ProjectRouter: pr,

		Objects:     objs,
		GetError:    map[meta.Key]error{},
		InsertError: map[meta.Key]error{},
		DeleteError: map[meta.Key]error{},
	}
	return mock
}

// MockBetaSecurityPolicies is the mock for SecurityPolicies.
type MockBetaSecurityPolicies struct {
	Lock sync.Mutex

	ProjectRouter ProjectRouter

	// Objects maintained by the mock.
	Objects map[meta.Key]*MockSecurityPoliciesObj

	// If an entry exists for the given key and operation, then the error
	// will be returned instead of the operation.
	GetError    map[meta.Key]error
	ListError   *error
	InsertError map[meta.Key]error
	DeleteError map[meta.Key]error

	// xxxHook allow you to intercept the standard processing of the mock in
	// order to add your own logic. Return (true, _, _) to prevent the normal
	// execution flow of the mock. Return (false, nil, nil) to continue with
	// normal mock behavior/ after the hook function executes.
	GetHook        func(ctx context.Context, key *meta.Key, m *MockBetaSecurityPolicies) (bool, *beta.SecurityPolicy, error)
	ListHook       func(ctx context.Context, fl *filter.F, m *MockBetaSecurityPolicies) (bool, []*beta.SecurityPolicy, error)
	InsertHook     func(ctx context.Context, key *meta.Key, obj *beta.SecurityPolicy, m *MockBetaSecurityPolicies) (bool, error)
	DeleteHook     func(ctx context.Context, key *meta.Key, m *MockBetaSecurityPolicies) (bool, error)
	AddRuleHook    func(context.Context, *meta.Key, *beta.SecurityPolicyRule, *MockBetaSecurityPolicies) error
	GetRuleHook    func(context.Context, *meta.Key, *MockBetaSecurityPolicies) (*beta.SecurityPolicyRule, error)
	PatchHook      func(context.Context, *meta.Key, *beta.SecurityPolicy, *MockBetaSecurityPolicies) error
	PatchRuleHook  func(context.Context, *meta.Key, *beta.SecurityPolicyRule, *MockBetaSecurityPolicies) error
	RemoveRuleHook func(context.Context, *meta.Key, *MockBetaSecurityPolicies) error

	// X is extra state that can be used as part of the mock. Generated code
	// will not use this field.
	X interface{}
}

// Get returns the object from the mock.
func (m *MockBetaSecurityPolicies) Get(ctx context.Context, key *meta.Key) (*beta.SecurityPolicy, error) {
	if m.GetHook != nil {
		if intercept, obj, err := m.GetHook(ctx, key, m); intercept {
			klog.V(5).Infof("MockBetaSecurityPolicies.Get(%v, %s) = %+v, %v", ctx, key, obj, err)
			return obj, err
		}
	}
	if !key.Valid() {
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.GetError[*key]; ok {
		klog.V(5).Infof("MockBetaSecurityPolicies.Get(%v, %s) = nil, %v", ctx, key, err)
		return nil, err
	}
	if obj, ok := m.Objects[*key]; ok {
		typedObj := obj.ToBeta()
		klog.V(5).Infof("MockBetaSecurityPolicies.Get(%v, %s) = %+v, nil", ctx, key, typedObj)
		return typedObj, nil
	}

	err := &googleapi.Error{
		Code:    http.StatusNotFound,
		Message: fmt.Sprintf("MockBetaSecurityPolicies %v not found", key),
	}
	klog.V(5).Infof("MockBetaSecurityPolicies.Get(%v, %s) = nil, %v", ctx, key, err)
	return nil, err
}

// List all of the objects in the mock.
func (m *MockBetaSecurityPolicies) List(ctx context.Context, fl *filter.F) ([]*beta.SecurityPolicy, error) {
	if m.ListHook != nil {
		if intercept, objs, err := m.ListHook(ctx, fl, m); intercept {
			klog.V(5).Infof("MockBetaSecurityPolicies.List(%v, %v) = [%v items], %v", ctx, fl, len(objs), err)
			return objs, err
		}
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if m.ListError != nil {
		err := *m.ListError
		klog.V(5).Infof("MockBetaSecurityPolicies.List(%v, %v) = nil, %v", ctx, fl, err)

		return nil, *m.ListError
	}

	var objs []*beta.SecurityPolicy
	for _, obj := range m.Objects {
		if !fl.Match(obj.ToBeta()) {
			continue
		}
		objs = append(objs, obj.ToBeta())
	}

	klog.V(5).Infof("MockBetaSecurityPolicies.List(%v, %v) = [%v items], nil", ctx, fl, len(objs))
	return objs, nil
}

// Insert is a mock for inserting/creating a new object.
func (m *MockBetaSecurityPolicies) Insert(ctx context.Context, key *meta.Key, obj *beta.SecurityPolicy) error {
	if m.InsertHook != nil {
		if intercept, err := m.InsertHook(ctx, key, obj, m); intercept {
			klog.V(5).Infof("MockBetaSecurityPolicies.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.InsertError[*key]; ok {
		klog.V(5).Infof("MockBetaSecurityPolicies.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}
	if _, ok := m.Objects[*key]; ok {
		err := &googleapi.Error{
			Code:    http.StatusConflict,
			Message: fmt.Sprintf("MockBetaSecurityPolicies %v exists", key),
		}
		klog.V(5).Infof("MockBetaSecurityPolicies.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}

	obj.Name = key.Name
	projectID := m.ProjectRouter.ProjectID(ctx, "beta", "securityPolicies")
	obj.SelfLink = SelfLink(meta.VersionBeta, projectID, "securityPolicies", key)

	m.Objects[*key] = &MockSecurityPoliciesObj{obj}
	klog.V(5).Infof("MockBetaSecurityPolicies.Insert(%v, %v, %+v) = nil", ctx, key, obj)
	return nil
}

// Delete is a mock for deleting the object.
func (m *MockBetaSecurityPolicies) Delete(ctx context.Context, key *meta.Key) error {
	if m.DeleteHook != nil {
		if intercept, err := m.DeleteHook(ctx, key, m); intercept {
			klog.V(5).Infof("MockBetaSecurityPolicies.Delete(%v, %v) = %v", ctx, key, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.DeleteError[*key]; ok {
		klog.V(5).Infof("MockBetaSecurityPolicies.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}
	if _, ok := m.Objects[*key]; !ok {
		err := &googleapi.Error{
			Code:    http.StatusNotFound,
			Message: fmt.Sprintf("MockBetaSecurityPolicies %v not found", key),
		}
		klog.V(5).Infof("MockBetaSecurityPolicies.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	delete(m.Objects, *key)
	klog.V(5).Infof("MockBetaSecurityPolicies.Delete(%v, %v) = nil", ctx, key)
	return nil
}

// Obj wraps the object for use in the mock.
func (m *MockBetaSecurityPolicies) Obj(o *beta.SecurityPolicy) *MockSecurityPoliciesObj {
	return &MockSecurityPoliciesObj{o}
}

// AddRule is a mock for the corresponding method.
func (m *MockBetaSecurityPolicies) AddRule(ctx context.Context, key *meta.Key, arg0 *beta.SecurityPolicyRule) error {
	if m.AddRuleHook != nil {
		return m.AddRuleHook(ctx, key, arg0, m)
	}
	return nil
}

// GetRule is a mock for the corresponding method.
func (m *MockBetaSecurityPolicies) GetRule(ctx context.Context, key *meta.Key) (*beta.SecurityPolicyRule, error) {
	if m.GetRuleHook != nil {
		return m.GetRuleHook(ctx, key, m)
	}
	return nil, fmt.Errorf("GetRuleHook must be set")
}

// Patch is a mock for the corresponding method.
func (m *MockBetaSecurityPolicies) Patch(ctx context.Context, key *meta.Key, arg0 *beta.SecurityPolicy) error {
	if m.PatchHook != nil {
		return m.PatchHook(ctx, key, arg0, m)
	}
	return nil
}

// PatchRule is a mock for the corresponding method.
func (m *MockBetaSecurityPolicies) PatchRule(ctx context.Context, key *meta.Key, arg0 *beta.SecurityPolicyRule) error {
	if m.PatchRuleHook != nil {
		return m.PatchRuleHook(ctx, key, arg0, m)
	}
	return nil
}

// RemoveRule is a mock for the corresponding method.
func (m *MockBetaSecurityPolicies) RemoveRule(ctx context.Context, key *meta.Key) error {
	if m.RemoveRuleHook != nil {
		return m.RemoveRuleHook(ctx, key, m)
	}
	return nil
}

// GCEBetaSecurityPolicies is a simplifying adapter for the GCE SecurityPolicies.
type GCEBetaSecurityPolicies struct {
	s *Service
}

// Get the SecurityPolicy named by key.
func (g *GCEBetaSecurityPolicies) Get(ctx context.Context, key *meta.Key) (*beta.SecurityPolicy, error) {
	klog.V(5).Infof("GCEBetaSecurityPolicies.Get(%v, %v): called", ctx, key)

	if !key.Valid() {
		klog.V(2).Infof("GCEBetaSecurityPolicies.Get(%v, %v): key is invalid (%#v)", ctx, key, key)
		return nil, fmt.Errorf("invalid GCE key (%#v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "beta", "SecurityPolicies")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Get",
		Version:   meta.Version("beta"),
		Service:   "SecurityPolicies",
	}
	klog.V(5).Infof("GCEBetaSecurityPolicies.Get(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEBetaSecurityPolicies.Get(%v, %v): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.Beta.SecurityPolicies.Get(projectID, key.Name)
	call.Context(ctx)
	v, err := call.Do()
	klog.V(4).Infof("GCEBetaSecurityPolicies.Get(%v, %v) = %+v, %v", ctx, key, v, err)
	return v, err
}

// List all SecurityPolicy objects.
func (g *GCEBetaSecurityPolicies) List(ctx context.Context, fl *filter.F) ([]*beta.SecurityPolicy, error) {
	klog.V(5).Infof("GCEBetaSecurityPolicies.List(%v, %v) called", ctx, fl)
	projectID := g.s.ProjectRouter.ProjectID(ctx, "beta", "SecurityPolicies")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "List",
		Version:   meta.Version("beta"),
		Service:   "SecurityPolicies",
	}
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		return nil, err
	}
	klog.V(5).Infof("GCEBetaSecurityPolicies.List(%v, %v): projectID = %v, rk = %+v", ctx, fl, projectID, rk)
	call := g.s.Beta.SecurityPolicies.List(projectID)
	if fl != filter.None {
		call.Filter(fl.String())
	}
	var all []*beta.SecurityPolicy
	f := func(l *beta.SecurityPolicyList) error {
		klog.V(5).Infof("GCEBetaSecurityPolicies.List(%v, ..., %v): page %+v", ctx, fl, l)
		all = append(all, l.Items...)
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		klog.V(4).Infof("GCEBetaSecurityPolicies.List(%v, ..., %v) = %v, %v", ctx, fl, nil, err)
		return nil, err
	}

	if klog.V(4).Enabled() {
		klog.V(4).Infof("GCEBetaSecurityPolicies.List(%v, ..., %v) = [%v items], %v", ctx, fl, len(all), nil)
	} else if klog.V(5).Enabled() {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		klog.V(5).Infof("GCEBetaSecurityPolicies.List(%v, ..., %v) = %v, %v", ctx, fl, asStr, nil)
	}

	return all, nil
}

// Insert SecurityPolicy with key of value obj.
func (g *GCEBetaSecurityPolicies) Insert(ctx context.Context, key *meta.Key, obj *beta.SecurityPolicy) error {
	klog.V(5).Infof("GCEBetaSecurityPolicies.Insert(%v, %v, %+v): called", ctx, key, obj)
	if !key.Valid() {
		klog.V(2).Infof("GCEBetaSecurityPolicies.Insert(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "beta", "SecurityPolicies")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Insert",
		Version:   meta.Version("beta"),
		Service:   "SecurityPolicies",
	}
	klog.V(5).Infof("GCEBetaSecurityPolicies.Insert(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEBetaSecurityPolicies.Insert(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	obj.Name = key.Name
	call := g.s.Beta.SecurityPolicies.Insert(projectID, obj)
	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCEBetaSecurityPolicies.Insert(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEBetaSecurityPolicies.Insert(%v, %v, %+v) = %+v", ctx, key, obj, err)
	return err
}

// Delete the SecurityPolicy referenced by key.
func (g *GCEBetaSecurityPolicies) Delete(ctx context.Context, key *meta.Key) error {
	klog.V(5).Infof("GCEBetaSecurityPolicies.Delete(%v, %v): called", ctx, key)
	if !key.Valid() {
		klog.V(2).Infof("GCEBetaSecurityPolicies.Delete(%v, %v): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "beta", "SecurityPolicies")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Delete",
		Version:   meta.Version("beta"),
		Service:   "SecurityPolicies",
	}
	klog.V(5).Infof("GCEBetaSecurityPolicies.Delete(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEBetaSecurityPolicies.Delete(%v, %v): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Beta.SecurityPolicies.Delete(projectID, key.Name)

	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCEBetaSecurityPolicies.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEBetaSecurityPolicies.Delete(%v, %v) = %v", ctx, key, err)
	return err
}

// AddRule is a method on GCEBetaSecurityPolicies.
func (g *GCEBetaSecurityPolicies) AddRule(ctx context.Context, key *meta.Key, arg0 *beta.SecurityPolicyRule) error {
	klog.V(5).Infof("GCEBetaSecurityPolicies.AddRule(%v, %v, ...): called", ctx, key)

	if !key.Valid() {
		klog.V(2).Infof("GCEBetaSecurityPolicies.AddRule(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "beta", "SecurityPolicies")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "AddRule",
		Version:   meta.Version("beta"),
		Service:   "SecurityPolicies",
	}
	klog.V(5).Infof("GCEBetaSecurityPolicies.AddRule(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)

	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEBetaSecurityPolicies.AddRule(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Beta.SecurityPolicies.AddRule(projectID, key.Name, arg0)
	call.Context(ctx)
	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCEBetaSecurityPolicies.AddRule(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}
	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEBetaSecurityPolicies.AddRule(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// GetRule is a method on GCEBetaSecurityPolicies.
func (g *GCEBetaSecurityPolicies) GetRule(ctx context.Context, key *meta.Key) (*beta.SecurityPolicyRule, error) {
	klog.V(5).Infof("GCEBetaSecurityPolicies.GetRule(%v, %v, ...): called", ctx, key)

	if !key.Valid() {
		klog.V(2).Infof("GCEBetaSecurityPolicies.GetRule(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "beta", "SecurityPolicies")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "GetRule",
		Version:   meta.Version("beta"),
		Service:   "SecurityPolicies",
	}
	klog.V(5).Infof("GCEBetaSecurityPolicies.GetRule(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)

	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEBetaSecurityPolicies.GetRule(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.Beta.SecurityPolicies.GetRule(projectID, key.Name)
	call.Context(ctx)
	v, err := call.Do()
	klog.V(4).Infof("GCEBetaSecurityPolicies.GetRule(%v, %v, ...) = %+v, %v", ctx, key, v, err)
	return v, err
}

// Patch is a method on GCEBetaSecurityPolicies.
func (g *GCEBetaSecurityPolicies) Patch(ctx context.Context, key *meta.Key, arg0 *beta.SecurityPolicy) error {
	klog.V(5).Infof("GCEBetaSecurityPolicies.Patch(%v, %v, ...): called", ctx, key)

	if !key.Valid() {
		klog.V(2).Infof("GCEBetaSecurityPolicies.Patch(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "beta", "SecurityPolicies")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Patch",
		Version:   meta.Version("beta"),
		Service:   "SecurityPolicies",
	}
	klog.V(5).Infof("GCEBetaSecurityPolicies.Patch(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)

	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEBetaSecurityPolicies.Patch(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Beta.SecurityPolicies.Patch(projectID, key.Name, arg0)
	call.Context(ctx)
	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCEBetaSecurityPolicies.Patch(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}
	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEBetaSecurityPolicies.Patch(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// PatchRule is a method on GCEBetaSecurityPolicies.
func (g *GCEBetaSecurityPolicies) PatchRule(ctx context.Context, key *meta.Key, arg0 *beta.SecurityPolicyRule) error {
	klog.V(5).Infof("GCEBetaSecurityPolicies.PatchRule(%v, %v, ...): called", ctx, key)

	if !key.Valid() {
		klog.V(2).Infof("GCEBetaSecurityPolicies.PatchRule(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "beta", "SecurityPolicies")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "PatchRule",
		Version:   meta.Version("beta"),
		Service:   "SecurityPolicies",
	}
	klog.V(5).Infof("GCEBetaSecurityPolicies.PatchRule(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)

	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEBetaSecurityPolicies.PatchRule(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Beta.SecurityPolicies.PatchRule(projectID, key.Name, arg0)
	call.Context(ctx)
	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCEBetaSecurityPolicies.PatchRule(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}
	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEBetaSecurityPolicies.PatchRule(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// RemoveRule is a method on GCEBetaSecurityPolicies.
func (g *GCEBetaSecurityPolicies) RemoveRule(ctx context.Context, key *meta.Key) error {
	klog.V(5).Infof("GCEBetaSecurityPolicies.RemoveRule(%v, %v, ...): called", ctx, key)

	if !key.Valid() {
		klog.V(2).Infof("GCEBetaSecurityPolicies.RemoveRule(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "beta", "SecurityPolicies")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "RemoveRule",
		Version:   meta.Version("beta"),
		Service:   "SecurityPolicies",
	}
	klog.V(5).Infof("GCEBetaSecurityPolicies.RemoveRule(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)

	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEBetaSecurityPolicies.RemoveRule(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Beta.SecurityPolicies.RemoveRule(projectID, key.Name)
	call.Context(ctx)
	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCEBetaSecurityPolicies.RemoveRule(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}
	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEBetaSecurityPolicies.RemoveRule(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// BetaServiceAttachments is an interface that allows for mocking of ServiceAttachments.
type BetaServiceAttachments interface {
	Get(ctx context.Context, key *meta.Key) (*beta.ServiceAttachment, error)
	List(ctx context.Context, region string, fl *filter.F) ([]*beta.ServiceAttachment, error)
	Insert(ctx context.Context, key *meta.Key, obj *beta.ServiceAttachment) error
	Delete(ctx context.Context, key *meta.Key) error
	Patch(context.Context, *meta.Key, *beta.ServiceAttachment) error
}

// NewMockBetaServiceAttachments returns a new mock for ServiceAttachments.
func NewMockBetaServiceAttachments(pr ProjectRouter, objs map[meta.Key]*MockServiceAttachmentsObj) *MockBetaServiceAttachments {
	mock := &MockBetaServiceAttachments{
		ProjectRouter: pr,

		Objects:     objs,
		GetError:    map[meta.Key]error{},
		InsertError: map[meta.Key]error{},
		DeleteError: map[meta.Key]error{},
	}
	return mock
}

// MockBetaServiceAttachments is the mock for ServiceAttachments.
type MockBetaServiceAttachments struct {
	Lock sync.Mutex

	ProjectRouter ProjectRouter

	// Objects maintained by the mock.
	Objects map[meta.Key]*MockServiceAttachmentsObj

	// If an entry exists for the given key and operation, then the error
	// will be returned instead of the operation.
	GetError    map[meta.Key]error
	ListError   *error
	InsertError map[meta.Key]error
	DeleteError map[meta.Key]error

	// xxxHook allow you to intercept the standard processing of the mock in
	// order to add your own logic. Return (true, _, _) to prevent the normal
	// execution flow of the mock. Return (false, nil, nil) to continue with
	// normal mock behavior/ after the hook function executes.
	GetHook    func(ctx context.Context, key *meta.Key, m *MockBetaServiceAttachments) (bool, *beta.ServiceAttachment, error)
	ListHook   func(ctx context.Context, region string, fl *filter.F, m *MockBetaServiceAttachments) (bool, []*beta.ServiceAttachment, error)
	InsertHook func(ctx context.Context, key *meta.Key, obj *beta.ServiceAttachment, m *MockBetaServiceAttachments) (bool, error)
	DeleteHook func(ctx context.Context, key *meta.Key, m *MockBetaServiceAttachments) (bool, error)
	PatchHook  func(context.Context, *meta.Key, *beta.ServiceAttachment, *MockBetaServiceAttachments) error

	// X is extra state that can be used as part of the mock. Generated code
	// will not use this field.
	X interface{}
}

// Get returns the object from the mock.
func (m *MockBetaServiceAttachments) Get(ctx context.Context, key *meta.Key) (*beta.ServiceAttachment, error) {
	if m.GetHook != nil {
		if intercept, obj, err := m.GetHook(ctx, key, m); intercept {
			klog.V(5).Infof("MockBetaServiceAttachments.Get(%v, %s) = %+v, %v", ctx, key, obj, err)
			return obj, err
		}
	}
	if !key.Valid() {
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.GetError[*key]; ok {
		klog.V(5).Infof("MockBetaServiceAttachments.Get(%v, %s) = nil, %v", ctx, key, err)
		return nil, err
	}
	if obj, ok := m.Objects[*key]; ok {
		typedObj := obj.ToBeta()
		klog.V(5).Infof("MockBetaServiceAttachments.Get(%v, %s) = %+v, nil", ctx, key, typedObj)
		return typedObj, nil
	}

	err := &googleapi.Error{
		Code:    http.StatusNotFound,
		Message: fmt.Sprintf("MockBetaServiceAttachments %v not found", key),
	}
	klog.V(5).Infof("MockBetaServiceAttachments.Get(%v, %s) = nil, %v", ctx, key, err)
	return nil, err
}

// List all of the objects in the mock in the given region.
func (m *MockBetaServiceAttachments) List(ctx context.Context, region string, fl *filter.F) ([]*beta.ServiceAttachment, error) {
	if m.ListHook != nil {
		if intercept, objs, err := m.ListHook(ctx, region, fl, m); intercept {
			klog.V(5).Infof("MockBetaServiceAttachments.List(%v, %q, %v) = [%v items], %v", ctx, region, fl, len(objs), err)
			return objs, err
		}
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if m.ListError != nil {
		err := *m.ListError
		klog.V(5).Infof("MockBetaServiceAttachments.List(%v, %q, %v) = nil, %v", ctx, region, fl, err)

		return nil, *m.ListError
	}

	var objs []*beta.ServiceAttachment
	for key, obj := range m.Objects {
		if key.Region != region {
			continue
		}
		if !fl.Match(obj.ToBeta()) {
			continue
		}
		objs = append(objs, obj.ToBeta())
	}

	klog.V(5).Infof("MockBetaServiceAttachments.List(%v, %q, %v) = [%v items], nil", ctx, region, fl, len(objs))
	return objs, nil
}

// Insert is a mock for inserting/creating a new object.
func (m *MockBetaServiceAttachments) Insert(ctx context.Context, key *meta.Key, obj *beta.ServiceAttachment) error {
	if m.InsertHook != nil {
		if intercept, err := m.InsertHook(ctx, key, obj, m); intercept {
			klog.V(5).Infof("MockBetaServiceAttachments.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.InsertError[*key]; ok {
		klog.V(5).Infof("MockBetaServiceAttachments.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}
	if _, ok := m.Objects[*key]; ok {
		err := &googleapi.Error{
			Code:    http.StatusConflict,
			Message: fmt.Sprintf("MockBetaServiceAttachments %v exists", key),
		}
		klog.V(5).Infof("MockBetaServiceAttachments.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}

	obj.Name = key.Name
	projectID := m.ProjectRouter.ProjectID(ctx, "beta", "serviceAttachments")
	obj.SelfLink = SelfLink(meta.VersionBeta, projectID, "serviceAttachments", key)

	m.Objects[*key] = &MockServiceAttachmentsObj{obj}
	klog.V(5).Infof("MockBetaServiceAttachments.Insert(%v, %v, %+v) = nil", ctx, key, obj)
	return nil
}

// Delete is a mock for deleting the object.
func (m *MockBetaServiceAttachments) Delete(ctx context.Context, key *meta.Key) error {
	if m.DeleteHook != nil {
		if intercept, err := m.DeleteHook(ctx, key, m); intercept {
			klog.V(5).Infof("MockBetaServiceAttachments.Delete(%v, %v) = %v", ctx, key, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.DeleteError[*key]; ok {
		klog.V(5).Infof("MockBetaServiceAttachments.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}
	if _, ok := m.Objects[*key]; !ok {
		err := &googleapi.Error{
			Code:    http.StatusNotFound,
			Message: fmt.Sprintf("MockBetaServiceAttachments %v not found", key),
		}
		klog.V(5).Infof("MockBetaServiceAttachments.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	delete(m.Objects, *key)
	klog.V(5).Infof("MockBetaServiceAttachments.Delete(%v, %v) = nil", ctx, key)
	return nil
}

// Obj wraps the object for use in the mock.
func (m *MockBetaServiceAttachments) Obj(o *beta.ServiceAttachment) *MockServiceAttachmentsObj {
	return &MockServiceAttachmentsObj{o}
}

// Patch is a mock for the corresponding method.
func (m *MockBetaServiceAttachments) Patch(ctx context.Context, key *meta.Key, arg0 *beta.ServiceAttachment) error {
	if m.PatchHook != nil {
		return m.PatchHook(ctx, key, arg0, m)
	}
	return nil
}

// GCEBetaServiceAttachments is a simplifying adapter for the GCE ServiceAttachments.
type GCEBetaServiceAttachments struct {
	s *Service
}

// Get the ServiceAttachment named by key.
func (g *GCEBetaServiceAttachments) Get(ctx context.Context, key *meta.Key) (*beta.ServiceAttachment, error) {
	klog.V(5).Infof("GCEBetaServiceAttachments.Get(%v, %v): called", ctx, key)

	if !key.Valid() {
		klog.V(2).Infof("GCEBetaServiceAttachments.Get(%v, %v): key is invalid (%#v)", ctx, key, key)
		return nil, fmt.Errorf("invalid GCE key (%#v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "beta", "ServiceAttachments")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Get",
		Version:   meta.Version("beta"),
		Service:   "ServiceAttachments",
	}
	klog.V(5).Infof("GCEBetaServiceAttachments.Get(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEBetaServiceAttachments.Get(%v, %v): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.Beta.ServiceAttachments.Get(projectID, key.Region, key.Name)
	call.Context(ctx)
	v, err := call.Do()
	klog.V(4).Infof("GCEBetaServiceAttachments.Get(%v, %v) = %+v, %v", ctx, key, v, err)
	return v, err
}

// List all ServiceAttachment objects.
func (g *GCEBetaServiceAttachments) List(ctx context.Context, region string, fl *filter.F) ([]*beta.ServiceAttachment, error) {
	klog.V(5).Infof("GCEBetaServiceAttachments.List(%v, %v, %v) called", ctx, region, fl)
	projectID := g.s.ProjectRouter.ProjectID(ctx, "beta", "ServiceAttachments")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "List",
		Version:   meta.Version("beta"),
		Service:   "ServiceAttachments",
	}
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		return nil, err
	}
	klog.V(5).Infof("GCEBetaServiceAttachments.List(%v, %v, %v): projectID = %v, rk = %+v", ctx, region, fl, projectID, rk)
	call := g.s.Beta.ServiceAttachments.List(projectID, region)
	if fl != filter.None {
		call.Filter(fl.String())
	}
	var all []*beta.ServiceAttachment
	f := func(l *beta.ServiceAttachmentList) error {
		klog.V(5).Infof("GCEBetaServiceAttachments.List(%v, ..., %v): page %+v", ctx, fl, l)
		all = append(all, l.Items...)
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		klog.V(4).Infof("GCEBetaServiceAttachments.List(%v, ..., %v) = %v, %v", ctx, fl, nil, err)
		return nil, err
	}

	if klog.V(4).Enabled() {
		klog.V(4).Infof("GCEBetaServiceAttachments.List(%v, ..., %v) = [%v items], %v", ctx, fl, len(all), nil)
	} else if klog.V(5).Enabled() {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		klog.V(5).Infof("GCEBetaServiceAttachments.List(%v, ..., %v) = %v, %v", ctx, fl, asStr, nil)
	}

	return all, nil
}

// Insert ServiceAttachment with key of value obj.
func (g *GCEBetaServiceAttachments) Insert(ctx context.Context, key *meta.Key, obj *beta.ServiceAttachment) error {
	klog.V(5).Infof("GCEBetaServiceAttachments.Insert(%v, %v, %+v): called", ctx, key, obj)
	if !key.Valid() {
		klog.V(2).Infof("GCEBetaServiceAttachments.Insert(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "beta", "ServiceAttachments")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Insert",
		Version:   meta.Version("beta"),
		Service:   "ServiceAttachments",
	}
	klog.V(5).Infof("GCEBetaServiceAttachments.Insert(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEBetaServiceAttachments.Insert(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	obj.Name = key.Name
	call := g.s.Beta.ServiceAttachments.Insert(projectID, key.Region, obj)
	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCEBetaServiceAttachments.Insert(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEBetaServiceAttachments.Insert(%v, %v, %+v) = %+v", ctx, key, obj, err)
	return err
}

// Delete the ServiceAttachment referenced by key.
func (g *GCEBetaServiceAttachments) Delete(ctx context.Context, key *meta.Key) error {
	klog.V(5).Infof("GCEBetaServiceAttachments.Delete(%v, %v): called", ctx, key)
	if !key.Valid() {
		klog.V(2).Infof("GCEBetaServiceAttachments.Delete(%v, %v): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "beta", "ServiceAttachments")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Delete",
		Version:   meta.Version("beta"),
		Service:   "ServiceAttachments",
	}
	klog.V(5).Infof("GCEBetaServiceAttachments.Delete(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEBetaServiceAttachments.Delete(%v, %v): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Beta.ServiceAttachments.Delete(projectID, key.Region, key.Name)
	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCEBetaServiceAttachments.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEBetaServiceAttachments.Delete(%v, %v) = %v", ctx, key, err)
	return err
}

// Patch is a method on GCEBetaServiceAttachments.
func (g *GCEBetaServiceAttachments) Patch(ctx context.Context, key *meta.Key, arg0 *beta.ServiceAttachment) error {
	klog.V(5).Infof("GCEBetaServiceAttachments.Patch(%v, %v, ...): called", ctx, key)

	if !key.Valid() {
		klog.V(2).Infof("GCEBetaServiceAttachments.Patch(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "beta", "ServiceAttachments")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Patch",
		Version:   meta.Version("beta"),
		Service:   "ServiceAttachments",
	}
	klog.V(5).Infof("GCEBetaServiceAttachments.Patch(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)

	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEBetaServiceAttachments.Patch(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Beta.ServiceAttachments.Patch(projectID, key.Region, key.Name, arg0)
	call.Context(ctx)
	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCEBetaServiceAttachments.Patch(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}
	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEBetaServiceAttachments.Patch(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// AlphaServiceAttachments is an interface that allows for mocking of ServiceAttachments.
type AlphaServiceAttachments interface {
	Get(ctx context.Context, key *meta.Key) (*alpha.ServiceAttachment, error)
	List(ctx context.Context, region string, fl *filter.F) ([]*alpha.ServiceAttachment, error)
	Insert(ctx context.Context, key *meta.Key, obj *alpha.ServiceAttachment) error
	Delete(ctx context.Context, key *meta.Key) error
	Patch(context.Context, *meta.Key, *alpha.ServiceAttachment) error
}

// NewMockAlphaServiceAttachments returns a new mock for ServiceAttachments.
func NewMockAlphaServiceAttachments(pr ProjectRouter, objs map[meta.Key]*MockServiceAttachmentsObj) *MockAlphaServiceAttachments {
	mock := &MockAlphaServiceAttachments{
		ProjectRouter: pr,

		Objects:     objs,
		GetError:    map[meta.Key]error{},
		InsertError: map[meta.Key]error{},
		DeleteError: map[meta.Key]error{},
	}
	return mock
}

// MockAlphaServiceAttachments is the mock for ServiceAttachments.
type MockAlphaServiceAttachments struct {
	Lock sync.Mutex

	ProjectRouter ProjectRouter

	// Objects maintained by the mock.
	Objects map[meta.Key]*MockServiceAttachmentsObj

	// If an entry exists for the given key and operation, then the error
	// will be returned instead of the operation.
	GetError    map[meta.Key]error
	ListError   *error
	InsertError map[meta.Key]error
	DeleteError map[meta.Key]error

	// xxxHook allow you to intercept the standard processing of the mock in
	// order to add your own logic. Return (true, _, _) to prevent the normal
	// execution flow of the mock. Return (false, nil, nil) to continue with
	// normal mock behavior/ after the hook function executes.
	GetHook    func(ctx context.Context, key *meta.Key, m *MockAlphaServiceAttachments) (bool, *alpha.ServiceAttachment, error)
	ListHook   func(ctx context.Context, region string, fl *filter.F, m *MockAlphaServiceAttachments) (bool, []*alpha.ServiceAttachment, error)
	InsertHook func(ctx context.Context, key *meta.Key, obj *alpha.ServiceAttachment, m *MockAlphaServiceAttachments) (bool, error)
	DeleteHook func(ctx context.Context, key *meta.Key, m *MockAlphaServiceAttachments) (bool, error)
	PatchHook  func(context.Context, *meta.Key, *alpha.ServiceAttachment, *MockAlphaServiceAttachments) error

	// X is extra state that can be used as part of the mock. Generated code
	// will not use this field.
	X interface{}
}

// Get returns the object from the mock.
func (m *MockAlphaServiceAttachments) Get(ctx context.Context, key *meta.Key) (*alpha.ServiceAttachment, error) {
	if m.GetHook != nil {
		if intercept, obj, err := m.GetHook(ctx, key, m); intercept {
			klog.V(5).Infof("MockAlphaServiceAttachments.Get(%v, %s) = %+v, %v", ctx, key, obj, err)
			return obj, err
		}
	}
	if !key.Valid() {
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.GetError[*key]; ok {
		klog.V(5).Infof("MockAlphaServiceAttachments.Get(%v, %s) = nil, %v", ctx, key, err)
		return nil, err
	}
	if obj, ok := m.Objects[*key]; ok {
		typedObj := obj.ToAlpha()
		klog.V(5).Infof("MockAlphaServiceAttachments.Get(%v, %s) = %+v, nil", ctx, key, typedObj)
		return typedObj, nil
	}

	err := &googleapi.Error{
		Code:    http.StatusNotFound,
		Message: fmt.Sprintf("MockAlphaServiceAttachments %v not found", key),
	}
	klog.V(5).Infof("MockAlphaServiceAttachments.Get(%v, %s) = nil, %v", ctx, key, err)
	return nil, err
}

// List all of the objects in the mock in the given region.
func (m *MockAlphaServiceAttachments) List(ctx context.Context, region string, fl *filter.F) ([]*alpha.ServiceAttachment, error) {
	if m.ListHook != nil {
		if intercept, objs, err := m.ListHook(ctx, region, fl, m); intercept {
			klog.V(5).Infof("MockAlphaServiceAttachments.List(%v, %q, %v) = [%v items], %v", ctx, region, fl, len(objs), err)
			return objs, err
		}
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if m.ListError != nil {
		err := *m.ListError
		klog.V(5).Infof("MockAlphaServiceAttachments.List(%v, %q, %v) = nil, %v", ctx, region, fl, err)

		return nil, *m.ListError
	}

	var objs []*alpha.ServiceAttachment
	for key, obj := range m.Objects {
		if key.Region != region {
			continue
		}
		if !fl.Match(obj.ToAlpha()) {
			continue
		}
		objs = append(objs, obj.ToAlpha())
	}

	klog.V(5).Infof("MockAlphaServiceAttachments.List(%v, %q, %v) = [%v items], nil", ctx, region, fl, len(objs))
	return objs, nil
}

// Insert is a mock for inserting/creating a new object.
func (m *MockAlphaServiceAttachments) Insert(ctx context.Context, key *meta.Key, obj *alpha.ServiceAttachment) error {
	if m.InsertHook != nil {
		if intercept, err := m.InsertHook(ctx, key, obj, m); intercept {
			klog.V(5).Infof("MockAlphaServiceAttachments.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.InsertError[*key]; ok {
		klog.V(5).Infof("MockAlphaServiceAttachments.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}
	if _, ok := m.Objects[*key]; ok {
		err := &googleapi.Error{
			Code:    http.StatusConflict,
			Message: fmt.Sprintf("MockAlphaServiceAttachments %v exists", key),
		}
		klog.V(5).Infof("MockAlphaServiceAttachments.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}

	obj.Name = key.Name
	projectID := m.ProjectRouter.ProjectID(ctx, "alpha", "serviceAttachments")
	obj.SelfLink = SelfLink(meta.VersionAlpha, projectID, "serviceAttachments", key)

	m.Objects[*key] = &MockServiceAttachmentsObj{obj}
	klog.V(5).Infof("MockAlphaServiceAttachments.Insert(%v, %v, %+v) = nil", ctx, key, obj)
	return nil
}

// Delete is a mock for deleting the object.
func (m *MockAlphaServiceAttachments) Delete(ctx context.Context, key *meta.Key) error {
	if m.DeleteHook != nil {
		if intercept, err := m.DeleteHook(ctx, key, m); intercept {
			klog.V(5).Infof("MockAlphaServiceAttachments.Delete(%v, %v) = %v", ctx, key, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.DeleteError[*key]; ok {
		klog.V(5).Infof("MockAlphaServiceAttachments.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}
	if _, ok := m.Objects[*key]; !ok {
		err := &googleapi.Error{
			Code:    http.StatusNotFound,
			Message: fmt.Sprintf("MockAlphaServiceAttachments %v not found", key),
		}
		klog.V(5).Infof("MockAlphaServiceAttachments.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	delete(m.Objects, *key)
	klog.V(5).Infof("MockAlphaServiceAttachments.Delete(%v, %v) = nil", ctx, key)
	return nil
}

// Obj wraps the object for use in the mock.
func (m *MockAlphaServiceAttachments) Obj(o *alpha.ServiceAttachment) *MockServiceAttachmentsObj {
	return &MockServiceAttachmentsObj{o}
}

// Patch is a mock for the corresponding method.
func (m *MockAlphaServiceAttachments) Patch(ctx context.Context, key *meta.Key, arg0 *alpha.ServiceAttachment) error {
	if m.PatchHook != nil {
		return m.PatchHook(ctx, key, arg0, m)
	}
	return nil
}

// GCEAlphaServiceAttachments is a simplifying adapter for the GCE ServiceAttachments.
type GCEAlphaServiceAttachments struct {
	s *Service
}

// Get the ServiceAttachment named by key.
func (g *GCEAlphaServiceAttachments) Get(ctx context.Context, key *meta.Key) (*alpha.ServiceAttachment, error) {
	klog.V(5).Infof("GCEAlphaServiceAttachments.Get(%v, %v): called", ctx, key)

	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaServiceAttachments.Get(%v, %v): key is invalid (%#v)", ctx, key, key)
		return nil, fmt.Errorf("invalid GCE key (%#v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "alpha", "ServiceAttachments")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Get",
		Version:   meta.Version("alpha"),
		Service:   "ServiceAttachments",
	}
	klog.V(5).Infof("GCEAlphaServiceAttachments.Get(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEAlphaServiceAttachments.Get(%v, %v): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.Alpha.ServiceAttachments.Get(projectID, key.Region, key.Name)
	call.Context(ctx)
	v, err := call.Do()
	klog.V(4).Infof("GCEAlphaServiceAttachments.Get(%v, %v) = %+v, %v", ctx, key, v, err)
	return v, err
}

// List all ServiceAttachment objects.
func (g *GCEAlphaServiceAttachments) List(ctx context.Context, region string, fl *filter.F) ([]*alpha.ServiceAttachment, error) {
	klog.V(5).Infof("GCEAlphaServiceAttachments.List(%v, %v, %v) called", ctx, region, fl)
	projectID := g.s.ProjectRouter.ProjectID(ctx, "alpha", "ServiceAttachments")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "List",
		Version:   meta.Version("alpha"),
		Service:   "ServiceAttachments",
	}
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		return nil, err
	}
	klog.V(5).Infof("GCEAlphaServiceAttachments.List(%v, %v, %v): projectID = %v, rk = %+v", ctx, region, fl, projectID, rk)
	call := g.s.Alpha.ServiceAttachments.List(projectID, region)
	if fl != filter.None {
		call.Filter(fl.String())
	}
	var all []*alpha.ServiceAttachment
	f := func(l *alpha.ServiceAttachmentList) error {
		klog.V(5).Infof("GCEAlphaServiceAttachments.List(%v, ..., %v): page %+v", ctx, fl, l)
		all = append(all, l.Items...)
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		klog.V(4).Infof("GCEAlphaServiceAttachments.List(%v, ..., %v) = %v, %v", ctx, fl, nil, err)
		return nil, err
	}

	if klog.V(4).Enabled() {
		klog.V(4).Infof("GCEAlphaServiceAttachments.List(%v, ..., %v) = [%v items], %v", ctx, fl, len(all), nil)
	} else if klog.V(5).Enabled() {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		klog.V(5).Infof("GCEAlphaServiceAttachments.List(%v, ..., %v) = %v, %v", ctx, fl, asStr, nil)
	}

	return all, nil
}

// Insert ServiceAttachment with key of value obj.
func (g *GCEAlphaServiceAttachments) Insert(ctx context.Context, key *meta.Key, obj *alpha.ServiceAttachment) error {
	klog.V(5).Infof("GCEAlphaServiceAttachments.Insert(%v, %v, %+v): called", ctx, key, obj)
	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaServiceAttachments.Insert(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "alpha", "ServiceAttachments")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Insert",
		Version:   meta.Version("alpha"),
		Service:   "ServiceAttachments",
	}
	klog.V(5).Infof("GCEAlphaServiceAttachments.Insert(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEAlphaServiceAttachments.Insert(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	obj.Name = key.Name
	call := g.s.Alpha.ServiceAttachments.Insert(projectID, key.Region, obj)
	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCEAlphaServiceAttachments.Insert(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEAlphaServiceAttachments.Insert(%v, %v, %+v) = %+v", ctx, key, obj, err)
	return err
}

// Delete the ServiceAttachment referenced by key.
func (g *GCEAlphaServiceAttachments) Delete(ctx context.Context, key *meta.Key) error {
	klog.V(5).Infof("GCEAlphaServiceAttachments.Delete(%v, %v): called", ctx, key)
	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaServiceAttachments.Delete(%v, %v): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "alpha", "ServiceAttachments")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Delete",
		Version:   meta.Version("alpha"),
		Service:   "ServiceAttachments",
	}
	klog.V(5).Infof("GCEAlphaServiceAttachments.Delete(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEAlphaServiceAttachments.Delete(%v, %v): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Alpha.ServiceAttachments.Delete(projectID, key.Region, key.Name)
	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCEAlphaServiceAttachments.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEAlphaServiceAttachments.Delete(%v, %v) = %v", ctx, key, err)
	return err
}

// Patch is a method on GCEAlphaServiceAttachments.
func (g *GCEAlphaServiceAttachments) Patch(ctx context.Context, key *meta.Key, arg0 *alpha.ServiceAttachment) error {
	klog.V(5).Infof("GCEAlphaServiceAttachments.Patch(%v, %v, ...): called", ctx, key)

	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaServiceAttachments.Patch(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "alpha", "ServiceAttachments")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Patch",
		Version:   meta.Version("alpha"),
		Service:   "ServiceAttachments",
	}
	klog.V(5).Infof("GCEAlphaServiceAttachments.Patch(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)

	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEAlphaServiceAttachments.Patch(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Alpha.ServiceAttachments.Patch(projectID, key.Region, key.Name, arg0)
	call.Context(ctx)
	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCEAlphaServiceAttachments.Patch(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}
	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEAlphaServiceAttachments.Patch(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// SslCertificates is an interface that allows for mocking of SslCertificates.
type SslCertificates interface {
	Get(ctx context.Context, key *meta.Key) (*ga.SslCertificate, error)
	List(ctx context.Context, fl *filter.F) ([]*ga.SslCertificate, error)
	Insert(ctx context.Context, key *meta.Key, obj *ga.SslCertificate) error
	Delete(ctx context.Context, key *meta.Key) error
}

// NewMockSslCertificates returns a new mock for SslCertificates.
func NewMockSslCertificates(pr ProjectRouter, objs map[meta.Key]*MockSslCertificatesObj) *MockSslCertificates {
	mock := &MockSslCertificates{
		ProjectRouter: pr,

		Objects:     objs,
		GetError:    map[meta.Key]error{},
		InsertError: map[meta.Key]error{},
		DeleteError: map[meta.Key]error{},
	}
	return mock
}

// MockSslCertificates is the mock for SslCertificates.
type MockSslCertificates struct {
	Lock sync.Mutex

	ProjectRouter ProjectRouter

	// Objects maintained by the mock.
	Objects map[meta.Key]*MockSslCertificatesObj

	// If an entry exists for the given key and operation, then the error
	// will be returned instead of the operation.
	GetError    map[meta.Key]error
	ListError   *error
	InsertError map[meta.Key]error
	DeleteError map[meta.Key]error

	// xxxHook allow you to intercept the standard processing of the mock in
	// order to add your own logic. Return (true, _, _) to prevent the normal
	// execution flow of the mock. Return (false, nil, nil) to continue with
	// normal mock behavior/ after the hook function executes.
	GetHook    func(ctx context.Context, key *meta.Key, m *MockSslCertificates) (bool, *ga.SslCertificate, error)
	ListHook   func(ctx context.Context, fl *filter.F, m *MockSslCertificates) (bool, []*ga.SslCertificate, error)
	InsertHook func(ctx context.Context, key *meta.Key, obj *ga.SslCertificate, m *MockSslCertificates) (bool, error)
	DeleteHook func(ctx context.Context, key *meta.Key, m *MockSslCertificates) (bool, error)

	// X is extra state that can be used as part of the mock. Generated code
	// will not use this field.
	X interface{}
}

// Get returns the object from the mock.
func (m *MockSslCertificates) Get(ctx context.Context, key *meta.Key) (*ga.SslCertificate, error) {
	if m.GetHook != nil {
		if intercept, obj, err := m.GetHook(ctx, key, m); intercept {
			klog.V(5).Infof("MockSslCertificates.Get(%v, %s) = %+v, %v", ctx, key, obj, err)
			return obj, err
		}
	}
	if !key.Valid() {
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.GetError[*key]; ok {
		klog.V(5).Infof("MockSslCertificates.Get(%v, %s) = nil, %v", ctx, key, err)
		return nil, err
	}
	if obj, ok := m.Objects[*key]; ok {
		typedObj := obj.ToGA()
		klog.V(5).Infof("MockSslCertificates.Get(%v, %s) = %+v, nil", ctx, key, typedObj)
		return typedObj, nil
	}

	err := &googleapi.Error{
		Code:    http.StatusNotFound,
		Message: fmt.Sprintf("MockSslCertificates %v not found", key),
	}
	klog.V(5).Infof("MockSslCertificates.Get(%v, %s) = nil, %v", ctx, key, err)
	return nil, err
}

// List all of the objects in the mock.
func (m *MockSslCertificates) List(ctx context.Context, fl *filter.F) ([]*ga.SslCertificate, error) {
	if m.ListHook != nil {
		if intercept, objs, err := m.ListHook(ctx, fl, m); intercept {
			klog.V(5).Infof("MockSslCertificates.List(%v, %v) = [%v items], %v", ctx, fl, len(objs), err)
			return objs, err
		}
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if m.ListError != nil {
		err := *m.ListError
		klog.V(5).Infof("MockSslCertificates.List(%v, %v) = nil, %v", ctx, fl, err)

		return nil, *m.ListError
	}

	var objs []*ga.SslCertificate
	for _, obj := range m.Objects {
		if !fl.Match(obj.ToGA()) {
			continue
		}
		objs = append(objs, obj.ToGA())
	}

	klog.V(5).Infof("MockSslCertificates.List(%v, %v) = [%v items], nil", ctx, fl, len(objs))
	return objs, nil
}

// Insert is a mock for inserting/creating a new object.
func (m *MockSslCertificates) Insert(ctx context.Context, key *meta.Key, obj *ga.SslCertificate) error {
	if m.InsertHook != nil {
		if intercept, err := m.InsertHook(ctx, key, obj, m); intercept {
			klog.V(5).Infof("MockSslCertificates.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.InsertError[*key]; ok {
		klog.V(5).Infof("MockSslCertificates.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}
	if _, ok := m.Objects[*key]; ok {
		err := &googleapi.Error{
			Code:    http.StatusConflict,
			Message: fmt.Sprintf("MockSslCertificates %v exists", key),
		}
		klog.V(5).Infof("MockSslCertificates.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}

	obj.Name = key.Name
	projectID := m.ProjectRouter.ProjectID(ctx, "ga", "sslCertificates")
	obj.SelfLink = SelfLink(meta.VersionGA, projectID, "sslCertificates", key)

	m.Objects[*key] = &MockSslCertificatesObj{obj}
	klog.V(5).Infof("MockSslCertificates.Insert(%v, %v, %+v) = nil", ctx, key, obj)
	return nil
}

// Delete is a mock for deleting the object.
func (m *MockSslCertificates) Delete(ctx context.Context, key *meta.Key) error {
	if m.DeleteHook != nil {
		if intercept, err := m.DeleteHook(ctx, key, m); intercept {
			klog.V(5).Infof("MockSslCertificates.Delete(%v, %v) = %v", ctx, key, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.DeleteError[*key]; ok {
		klog.V(5).Infof("MockSslCertificates.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}
	if _, ok := m.Objects[*key]; !ok {
		err := &googleapi.Error{
			Code:    http.StatusNotFound,
			Message: fmt.Sprintf("MockSslCertificates %v not found", key),
		}
		klog.V(5).Infof("MockSslCertificates.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	delete(m.Objects, *key)
	klog.V(5).Infof("MockSslCertificates.Delete(%v, %v) = nil", ctx, key)
	return nil
}

// Obj wraps the object for use in the mock.
func (m *MockSslCertificates) Obj(o *ga.SslCertificate) *MockSslCertificatesObj {
	return &MockSslCertificatesObj{o}
}

// GCESslCertificates is a simplifying adapter for the GCE SslCertificates.
type GCESslCertificates struct {
	s *Service
}

// Get the SslCertificate named by key.
func (g *GCESslCertificates) Get(ctx context.Context, key *meta.Key) (*ga.SslCertificate, error) {
	klog.V(5).Infof("GCESslCertificates.Get(%v, %v): called", ctx, key)

	if !key.Valid() {
		klog.V(2).Infof("GCESslCertificates.Get(%v, %v): key is invalid (%#v)", ctx, key, key)
		return nil, fmt.Errorf("invalid GCE key (%#v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "SslCertificates")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Get",
		Version:   meta.Version("ga"),
		Service:   "SslCertificates",
	}
	klog.V(5).Infof("GCESslCertificates.Get(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCESslCertificates.Get(%v, %v): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.GA.SslCertificates.Get(projectID, key.Name)
	call.Context(ctx)
	v, err := call.Do()
	klog.V(4).Infof("GCESslCertificates.Get(%v, %v) = %+v, %v", ctx, key, v, err)
	return v, err
}

// List all SslCertificate objects.
func (g *GCESslCertificates) List(ctx context.Context, fl *filter.F) ([]*ga.SslCertificate, error) {
	klog.V(5).Infof("GCESslCertificates.List(%v, %v) called", ctx, fl)
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "SslCertificates")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "List",
		Version:   meta.Version("ga"),
		Service:   "SslCertificates",
	}
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		return nil, err
	}
	klog.V(5).Infof("GCESslCertificates.List(%v, %v): projectID = %v, rk = %+v", ctx, fl, projectID, rk)
	call := g.s.GA.SslCertificates.List(projectID)
	if fl != filter.None {
		call.Filter(fl.String())
	}
	var all []*ga.SslCertificate
	f := func(l *ga.SslCertificateList) error {
		klog.V(5).Infof("GCESslCertificates.List(%v, ..., %v): page %+v", ctx, fl, l)
		all = append(all, l.Items...)
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		klog.V(4).Infof("GCESslCertificates.List(%v, ..., %v) = %v, %v", ctx, fl, nil, err)
		return nil, err
	}

	if klog.V(4).Enabled() {
		klog.V(4).Infof("GCESslCertificates.List(%v, ..., %v) = [%v items], %v", ctx, fl, len(all), nil)
	} else if klog.V(5).Enabled() {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		klog.V(5).Infof("GCESslCertificates.List(%v, ..., %v) = %v, %v", ctx, fl, asStr, nil)
	}

	return all, nil
}

// Insert SslCertificate with key of value obj.
func (g *GCESslCertificates) Insert(ctx context.Context, key *meta.Key, obj *ga.SslCertificate) error {
	klog.V(5).Infof("GCESslCertificates.Insert(%v, %v, %+v): called", ctx, key, obj)
	if !key.Valid() {
		klog.V(2).Infof("GCESslCertificates.Insert(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "SslCertificates")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Insert",
		Version:   meta.Version("ga"),
		Service:   "SslCertificates",
	}
	klog.V(5).Infof("GCESslCertificates.Insert(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCESslCertificates.Insert(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	obj.Name = key.Name
	call := g.s.GA.SslCertificates.Insert(projectID, obj)
	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCESslCertificates.Insert(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCESslCertificates.Insert(%v, %v, %+v) = %+v", ctx, key, obj, err)
	return err
}

// Delete the SslCertificate referenced by key.
func (g *GCESslCertificates) Delete(ctx context.Context, key *meta.Key) error {
	klog.V(5).Infof("GCESslCertificates.Delete(%v, %v): called", ctx, key)
	if !key.Valid() {
		klog.V(2).Infof("GCESslCertificates.Delete(%v, %v): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "SslCertificates")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Delete",
		Version:   meta.Version("ga"),
		Service:   "SslCertificates",
	}
	klog.V(5).Infof("GCESslCertificates.Delete(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCESslCertificates.Delete(%v, %v): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.GA.SslCertificates.Delete(projectID, key.Name)

	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCESslCertificates.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCESslCertificates.Delete(%v, %v) = %v", ctx, key, err)
	return err
}

// BetaSslCertificates is an interface that allows for mocking of SslCertificates.
type BetaSslCertificates interface {
	Get(ctx context.Context, key *meta.Key) (*beta.SslCertificate, error)
	List(ctx context.Context, fl *filter.F) ([]*beta.SslCertificate, error)
	Insert(ctx context.Context, key *meta.Key, obj *beta.SslCertificate) error
	Delete(ctx context.Context, key *meta.Key) error
}

// NewMockBetaSslCertificates returns a new mock for SslCertificates.
func NewMockBetaSslCertificates(pr ProjectRouter, objs map[meta.Key]*MockSslCertificatesObj) *MockBetaSslCertificates {
	mock := &MockBetaSslCertificates{
		ProjectRouter: pr,

		Objects:     objs,
		GetError:    map[meta.Key]error{},
		InsertError: map[meta.Key]error{},
		DeleteError: map[meta.Key]error{},
	}
	return mock
}

// MockBetaSslCertificates is the mock for SslCertificates.
type MockBetaSslCertificates struct {
	Lock sync.Mutex

	ProjectRouter ProjectRouter

	// Objects maintained by the mock.
	Objects map[meta.Key]*MockSslCertificatesObj

	// If an entry exists for the given key and operation, then the error
	// will be returned instead of the operation.
	GetError    map[meta.Key]error
	ListError   *error
	InsertError map[meta.Key]error
	DeleteError map[meta.Key]error

	// xxxHook allow you to intercept the standard processing of the mock in
	// order to add your own logic. Return (true, _, _) to prevent the normal
	// execution flow of the mock. Return (false, nil, nil) to continue with
	// normal mock behavior/ after the hook function executes.
	GetHook    func(ctx context.Context, key *meta.Key, m *MockBetaSslCertificates) (bool, *beta.SslCertificate, error)
	ListHook   func(ctx context.Context, fl *filter.F, m *MockBetaSslCertificates) (bool, []*beta.SslCertificate, error)
	InsertHook func(ctx context.Context, key *meta.Key, obj *beta.SslCertificate, m *MockBetaSslCertificates) (bool, error)
	DeleteHook func(ctx context.Context, key *meta.Key, m *MockBetaSslCertificates) (bool, error)

	// X is extra state that can be used as part of the mock. Generated code
	// will not use this field.
	X interface{}
}

// Get returns the object from the mock.
func (m *MockBetaSslCertificates) Get(ctx context.Context, key *meta.Key) (*beta.SslCertificate, error) {
	if m.GetHook != nil {
		if intercept, obj, err := m.GetHook(ctx, key, m); intercept {
			klog.V(5).Infof("MockBetaSslCertificates.Get(%v, %s) = %+v, %v", ctx, key, obj, err)
			return obj, err
		}
	}
	if !key.Valid() {
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.GetError[*key]; ok {
		klog.V(5).Infof("MockBetaSslCertificates.Get(%v, %s) = nil, %v", ctx, key, err)
		return nil, err
	}
	if obj, ok := m.Objects[*key]; ok {
		typedObj := obj.ToBeta()
		klog.V(5).Infof("MockBetaSslCertificates.Get(%v, %s) = %+v, nil", ctx, key, typedObj)
		return typedObj, nil
	}

	err := &googleapi.Error{
		Code:    http.StatusNotFound,
		Message: fmt.Sprintf("MockBetaSslCertificates %v not found", key),
	}
	klog.V(5).Infof("MockBetaSslCertificates.Get(%v, %s) = nil, %v", ctx, key, err)
	return nil, err
}

// List all of the objects in the mock.
func (m *MockBetaSslCertificates) List(ctx context.Context, fl *filter.F) ([]*beta.SslCertificate, error) {
	if m.ListHook != nil {
		if intercept, objs, err := m.ListHook(ctx, fl, m); intercept {
			klog.V(5).Infof("MockBetaSslCertificates.List(%v, %v) = [%v items], %v", ctx, fl, len(objs), err)
			return objs, err
		}
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if m.ListError != nil {
		err := *m.ListError
		klog.V(5).Infof("MockBetaSslCertificates.List(%v, %v) = nil, %v", ctx, fl, err)

		return nil, *m.ListError
	}

	var objs []*beta.SslCertificate
	for _, obj := range m.Objects {
		if !fl.Match(obj.ToBeta()) {
			continue
		}
		objs = append(objs, obj.ToBeta())
	}

	klog.V(5).Infof("MockBetaSslCertificates.List(%v, %v) = [%v items], nil", ctx, fl, len(objs))
	return objs, nil
}

// Insert is a mock for inserting/creating a new object.
func (m *MockBetaSslCertificates) Insert(ctx context.Context, key *meta.Key, obj *beta.SslCertificate) error {
	if m.InsertHook != nil {
		if intercept, err := m.InsertHook(ctx, key, obj, m); intercept {
			klog.V(5).Infof("MockBetaSslCertificates.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.InsertError[*key]; ok {
		klog.V(5).Infof("MockBetaSslCertificates.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}
	if _, ok := m.Objects[*key]; ok {
		err := &googleapi.Error{
			Code:    http.StatusConflict,
			Message: fmt.Sprintf("MockBetaSslCertificates %v exists", key),
		}
		klog.V(5).Infof("MockBetaSslCertificates.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}

	obj.Name = key.Name
	projectID := m.ProjectRouter.ProjectID(ctx, "beta", "sslCertificates")
	obj.SelfLink = SelfLink(meta.VersionBeta, projectID, "sslCertificates", key)

	m.Objects[*key] = &MockSslCertificatesObj{obj}
	klog.V(5).Infof("MockBetaSslCertificates.Insert(%v, %v, %+v) = nil", ctx, key, obj)
	return nil
}

// Delete is a mock for deleting the object.
func (m *MockBetaSslCertificates) Delete(ctx context.Context, key *meta.Key) error {
	if m.DeleteHook != nil {
		if intercept, err := m.DeleteHook(ctx, key, m); intercept {
			klog.V(5).Infof("MockBetaSslCertificates.Delete(%v, %v) = %v", ctx, key, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.DeleteError[*key]; ok {
		klog.V(5).Infof("MockBetaSslCertificates.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}
	if _, ok := m.Objects[*key]; !ok {
		err := &googleapi.Error{
			Code:    http.StatusNotFound,
			Message: fmt.Sprintf("MockBetaSslCertificates %v not found", key),
		}
		klog.V(5).Infof("MockBetaSslCertificates.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	delete(m.Objects, *key)
	klog.V(5).Infof("MockBetaSslCertificates.Delete(%v, %v) = nil", ctx, key)
	return nil
}

// Obj wraps the object for use in the mock.
func (m *MockBetaSslCertificates) Obj(o *beta.SslCertificate) *MockSslCertificatesObj {
	return &MockSslCertificatesObj{o}
}

// GCEBetaSslCertificates is a simplifying adapter for the GCE SslCertificates.
type GCEBetaSslCertificates struct {
	s *Service
}

// Get the SslCertificate named by key.
func (g *GCEBetaSslCertificates) Get(ctx context.Context, key *meta.Key) (*beta.SslCertificate, error) {
	klog.V(5).Infof("GCEBetaSslCertificates.Get(%v, %v): called", ctx, key)

	if !key.Valid() {
		klog.V(2).Infof("GCEBetaSslCertificates.Get(%v, %v): key is invalid (%#v)", ctx, key, key)
		return nil, fmt.Errorf("invalid GCE key (%#v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "beta", "SslCertificates")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Get",
		Version:   meta.Version("beta"),
		Service:   "SslCertificates",
	}
	klog.V(5).Infof("GCEBetaSslCertificates.Get(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEBetaSslCertificates.Get(%v, %v): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.Beta.SslCertificates.Get(projectID, key.Name)
	call.Context(ctx)
	v, err := call.Do()
	klog.V(4).Infof("GCEBetaSslCertificates.Get(%v, %v) = %+v, %v", ctx, key, v, err)
	return v, err
}

// List all SslCertificate objects.
func (g *GCEBetaSslCertificates) List(ctx context.Context, fl *filter.F) ([]*beta.SslCertificate, error) {
	klog.V(5).Infof("GCEBetaSslCertificates.List(%v, %v) called", ctx, fl)
	projectID := g.s.ProjectRouter.ProjectID(ctx, "beta", "SslCertificates")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "List",
		Version:   meta.Version("beta"),
		Service:   "SslCertificates",
	}
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		return nil, err
	}
	klog.V(5).Infof("GCEBetaSslCertificates.List(%v, %v): projectID = %v, rk = %+v", ctx, fl, projectID, rk)
	call := g.s.Beta.SslCertificates.List(projectID)
	if fl != filter.None {
		call.Filter(fl.String())
	}
	var all []*beta.SslCertificate
	f := func(l *beta.SslCertificateList) error {
		klog.V(5).Infof("GCEBetaSslCertificates.List(%v, ..., %v): page %+v", ctx, fl, l)
		all = append(all, l.Items...)
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		klog.V(4).Infof("GCEBetaSslCertificates.List(%v, ..., %v) = %v, %v", ctx, fl, nil, err)
		return nil, err
	}

	if klog.V(4).Enabled() {
		klog.V(4).Infof("GCEBetaSslCertificates.List(%v, ..., %v) = [%v items], %v", ctx, fl, len(all), nil)
	} else if klog.V(5).Enabled() {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		klog.V(5).Infof("GCEBetaSslCertificates.List(%v, ..., %v) = %v, %v", ctx, fl, asStr, nil)
	}

	return all, nil
}

// Insert SslCertificate with key of value obj.
func (g *GCEBetaSslCertificates) Insert(ctx context.Context, key *meta.Key, obj *beta.SslCertificate) error {
	klog.V(5).Infof("GCEBetaSslCertificates.Insert(%v, %v, %+v): called", ctx, key, obj)
	if !key.Valid() {
		klog.V(2).Infof("GCEBetaSslCertificates.Insert(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "beta", "SslCertificates")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Insert",
		Version:   meta.Version("beta"),
		Service:   "SslCertificates",
	}
	klog.V(5).Infof("GCEBetaSslCertificates.Insert(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEBetaSslCertificates.Insert(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	obj.Name = key.Name
	call := g.s.Beta.SslCertificates.Insert(projectID, obj)
	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCEBetaSslCertificates.Insert(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEBetaSslCertificates.Insert(%v, %v, %+v) = %+v", ctx, key, obj, err)
	return err
}

// Delete the SslCertificate referenced by key.
func (g *GCEBetaSslCertificates) Delete(ctx context.Context, key *meta.Key) error {
	klog.V(5).Infof("GCEBetaSslCertificates.Delete(%v, %v): called", ctx, key)
	if !key.Valid() {
		klog.V(2).Infof("GCEBetaSslCertificates.Delete(%v, %v): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "beta", "SslCertificates")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Delete",
		Version:   meta.Version("beta"),
		Service:   "SslCertificates",
	}
	klog.V(5).Infof("GCEBetaSslCertificates.Delete(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEBetaSslCertificates.Delete(%v, %v): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Beta.SslCertificates.Delete(projectID, key.Name)

	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCEBetaSslCertificates.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEBetaSslCertificates.Delete(%v, %v) = %v", ctx, key, err)
	return err
}

// AlphaSslCertificates is an interface that allows for mocking of SslCertificates.
type AlphaSslCertificates interface {
	Get(ctx context.Context, key *meta.Key) (*alpha.SslCertificate, error)
	List(ctx context.Context, fl *filter.F) ([]*alpha.SslCertificate, error)
	Insert(ctx context.Context, key *meta.Key, obj *alpha.SslCertificate) error
	Delete(ctx context.Context, key *meta.Key) error
}

// NewMockAlphaSslCertificates returns a new mock for SslCertificates.
func NewMockAlphaSslCertificates(pr ProjectRouter, objs map[meta.Key]*MockSslCertificatesObj) *MockAlphaSslCertificates {
	mock := &MockAlphaSslCertificates{
		ProjectRouter: pr,

		Objects:     objs,
		GetError:    map[meta.Key]error{},
		InsertError: map[meta.Key]error{},
		DeleteError: map[meta.Key]error{},
	}
	return mock
}

// MockAlphaSslCertificates is the mock for SslCertificates.
type MockAlphaSslCertificates struct {
	Lock sync.Mutex

	ProjectRouter ProjectRouter

	// Objects maintained by the mock.
	Objects map[meta.Key]*MockSslCertificatesObj

	// If an entry exists for the given key and operation, then the error
	// will be returned instead of the operation.
	GetError    map[meta.Key]error
	ListError   *error
	InsertError map[meta.Key]error
	DeleteError map[meta.Key]error

	// xxxHook allow you to intercept the standard processing of the mock in
	// order to add your own logic. Return (true, _, _) to prevent the normal
	// execution flow of the mock. Return (false, nil, nil) to continue with
	// normal mock behavior/ after the hook function executes.
	GetHook    func(ctx context.Context, key *meta.Key, m *MockAlphaSslCertificates) (bool, *alpha.SslCertificate, error)
	ListHook   func(ctx context.Context, fl *filter.F, m *MockAlphaSslCertificates) (bool, []*alpha.SslCertificate, error)
	InsertHook func(ctx context.Context, key *meta.Key, obj *alpha.SslCertificate, m *MockAlphaSslCertificates) (bool, error)
	DeleteHook func(ctx context.Context, key *meta.Key, m *MockAlphaSslCertificates) (bool, error)

	// X is extra state that can be used as part of the mock. Generated code
	// will not use this field.
	X interface{}
}

// Get returns the object from the mock.
func (m *MockAlphaSslCertificates) Get(ctx context.Context, key *meta.Key) (*alpha.SslCertificate, error) {
	if m.GetHook != nil {
		if intercept, obj, err := m.GetHook(ctx, key, m); intercept {
			klog.V(5).Infof("MockAlphaSslCertificates.Get(%v, %s) = %+v, %v", ctx, key, obj, err)
			return obj, err
		}
	}
	if !key.Valid() {
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.GetError[*key]; ok {
		klog.V(5).Infof("MockAlphaSslCertificates.Get(%v, %s) = nil, %v", ctx, key, err)
		return nil, err
	}
	if obj, ok := m.Objects[*key]; ok {
		typedObj := obj.ToAlpha()
		klog.V(5).Infof("MockAlphaSslCertificates.Get(%v, %s) = %+v, nil", ctx, key, typedObj)
		return typedObj, nil
	}

	err := &googleapi.Error{
		Code:    http.StatusNotFound,
		Message: fmt.Sprintf("MockAlphaSslCertificates %v not found", key),
	}
	klog.V(5).Infof("MockAlphaSslCertificates.Get(%v, %s) = nil, %v", ctx, key, err)
	return nil, err
}

// List all of the objects in the mock.
func (m *MockAlphaSslCertificates) List(ctx context.Context, fl *filter.F) ([]*alpha.SslCertificate, error) {
	if m.ListHook != nil {
		if intercept, objs, err := m.ListHook(ctx, fl, m); intercept {
			klog.V(5).Infof("MockAlphaSslCertificates.List(%v, %v) = [%v items], %v", ctx, fl, len(objs), err)
			return objs, err
		}
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if m.ListError != nil {
		err := *m.ListError
		klog.V(5).Infof("MockAlphaSslCertificates.List(%v, %v) = nil, %v", ctx, fl, err)

		return nil, *m.ListError
	}

	var objs []*alpha.SslCertificate
	for _, obj := range m.Objects {
		if !fl.Match(obj.ToAlpha()) {
			continue
		}
		objs = append(objs, obj.ToAlpha())
	}

	klog.V(5).Infof("MockAlphaSslCertificates.List(%v, %v) = [%v items], nil", ctx, fl, len(objs))
	return objs, nil
}

// Insert is a mock for inserting/creating a new object.
func (m *MockAlphaSslCertificates) Insert(ctx context.Context, key *meta.Key, obj *alpha.SslCertificate) error {
	if m.InsertHook != nil {
		if intercept, err := m.InsertHook(ctx, key, obj, m); intercept {
			klog.V(5).Infof("MockAlphaSslCertificates.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.InsertError[*key]; ok {
		klog.V(5).Infof("MockAlphaSslCertificates.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}
	if _, ok := m.Objects[*key]; ok {
		err := &googleapi.Error{
			Code:    http.StatusConflict,
			Message: fmt.Sprintf("MockAlphaSslCertificates %v exists", key),
		}
		klog.V(5).Infof("MockAlphaSslCertificates.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}

	obj.Name = key.Name
	projectID := m.ProjectRouter.ProjectID(ctx, "alpha", "sslCertificates")
	obj.SelfLink = SelfLink(meta.VersionAlpha, projectID, "sslCertificates", key)

	m.Objects[*key] = &MockSslCertificatesObj{obj}
	klog.V(5).Infof("MockAlphaSslCertificates.Insert(%v, %v, %+v) = nil", ctx, key, obj)
	return nil
}

// Delete is a mock for deleting the object.
func (m *MockAlphaSslCertificates) Delete(ctx context.Context, key *meta.Key) error {
	if m.DeleteHook != nil {
		if intercept, err := m.DeleteHook(ctx, key, m); intercept {
			klog.V(5).Infof("MockAlphaSslCertificates.Delete(%v, %v) = %v", ctx, key, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.DeleteError[*key]; ok {
		klog.V(5).Infof("MockAlphaSslCertificates.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}
	if _, ok := m.Objects[*key]; !ok {
		err := &googleapi.Error{
			Code:    http.StatusNotFound,
			Message: fmt.Sprintf("MockAlphaSslCertificates %v not found", key),
		}
		klog.V(5).Infof("MockAlphaSslCertificates.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	delete(m.Objects, *key)
	klog.V(5).Infof("MockAlphaSslCertificates.Delete(%v, %v) = nil", ctx, key)
	return nil
}

// Obj wraps the object for use in the mock.
func (m *MockAlphaSslCertificates) Obj(o *alpha.SslCertificate) *MockSslCertificatesObj {
	return &MockSslCertificatesObj{o}
}

// GCEAlphaSslCertificates is a simplifying adapter for the GCE SslCertificates.
type GCEAlphaSslCertificates struct {
	s *Service
}

// Get the SslCertificate named by key.
func (g *GCEAlphaSslCertificates) Get(ctx context.Context, key *meta.Key) (*alpha.SslCertificate, error) {
	klog.V(5).Infof("GCEAlphaSslCertificates.Get(%v, %v): called", ctx, key)

	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaSslCertificates.Get(%v, %v): key is invalid (%#v)", ctx, key, key)
		return nil, fmt.Errorf("invalid GCE key (%#v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "alpha", "SslCertificates")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Get",
		Version:   meta.Version("alpha"),
		Service:   "SslCertificates",
	}
	klog.V(5).Infof("GCEAlphaSslCertificates.Get(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEAlphaSslCertificates.Get(%v, %v): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.Alpha.SslCertificates.Get(projectID, key.Name)
	call.Context(ctx)
	v, err := call.Do()
	klog.V(4).Infof("GCEAlphaSslCertificates.Get(%v, %v) = %+v, %v", ctx, key, v, err)
	return v, err
}

// List all SslCertificate objects.
func (g *GCEAlphaSslCertificates) List(ctx context.Context, fl *filter.F) ([]*alpha.SslCertificate, error) {
	klog.V(5).Infof("GCEAlphaSslCertificates.List(%v, %v) called", ctx, fl)
	projectID := g.s.ProjectRouter.ProjectID(ctx, "alpha", "SslCertificates")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "List",
		Version:   meta.Version("alpha"),
		Service:   "SslCertificates",
	}
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		return nil, err
	}
	klog.V(5).Infof("GCEAlphaSslCertificates.List(%v, %v): projectID = %v, rk = %+v", ctx, fl, projectID, rk)
	call := g.s.Alpha.SslCertificates.List(projectID)
	if fl != filter.None {
		call.Filter(fl.String())
	}
	var all []*alpha.SslCertificate
	f := func(l *alpha.SslCertificateList) error {
		klog.V(5).Infof("GCEAlphaSslCertificates.List(%v, ..., %v): page %+v", ctx, fl, l)
		all = append(all, l.Items...)
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		klog.V(4).Infof("GCEAlphaSslCertificates.List(%v, ..., %v) = %v, %v", ctx, fl, nil, err)
		return nil, err
	}

	if klog.V(4).Enabled() {
		klog.V(4).Infof("GCEAlphaSslCertificates.List(%v, ..., %v) = [%v items], %v", ctx, fl, len(all), nil)
	} else if klog.V(5).Enabled() {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		klog.V(5).Infof("GCEAlphaSslCertificates.List(%v, ..., %v) = %v, %v", ctx, fl, asStr, nil)
	}

	return all, nil
}

// Insert SslCertificate with key of value obj.
func (g *GCEAlphaSslCertificates) Insert(ctx context.Context, key *meta.Key, obj *alpha.SslCertificate) error {
	klog.V(5).Infof("GCEAlphaSslCertificates.Insert(%v, %v, %+v): called", ctx, key, obj)
	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaSslCertificates.Insert(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "alpha", "SslCertificates")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Insert",
		Version:   meta.Version("alpha"),
		Service:   "SslCertificates",
	}
	klog.V(5).Infof("GCEAlphaSslCertificates.Insert(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEAlphaSslCertificates.Insert(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	obj.Name = key.Name
	call := g.s.Alpha.SslCertificates.Insert(projectID, obj)
	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCEAlphaSslCertificates.Insert(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEAlphaSslCertificates.Insert(%v, %v, %+v) = %+v", ctx, key, obj, err)
	return err
}

// Delete the SslCertificate referenced by key.
func (g *GCEAlphaSslCertificates) Delete(ctx context.Context, key *meta.Key) error {
	klog.V(5).Infof("GCEAlphaSslCertificates.Delete(%v, %v): called", ctx, key)
	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaSslCertificates.Delete(%v, %v): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "alpha", "SslCertificates")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Delete",
		Version:   meta.Version("alpha"),
		Service:   "SslCertificates",
	}
	klog.V(5).Infof("GCEAlphaSslCertificates.Delete(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEAlphaSslCertificates.Delete(%v, %v): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Alpha.SslCertificates.Delete(projectID, key.Name)

	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCEAlphaSslCertificates.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEAlphaSslCertificates.Delete(%v, %v) = %v", ctx, key, err)
	return err
}

// AlphaRegionSslCertificates is an interface that allows for mocking of RegionSslCertificates.
type AlphaRegionSslCertificates interface {
	Get(ctx context.Context, key *meta.Key) (*alpha.SslCertificate, error)
	List(ctx context.Context, region string, fl *filter.F) ([]*alpha.SslCertificate, error)
	Insert(ctx context.Context, key *meta.Key, obj *alpha.SslCertificate) error
	Delete(ctx context.Context, key *meta.Key) error
}

// NewMockAlphaRegionSslCertificates returns a new mock for RegionSslCertificates.
func NewMockAlphaRegionSslCertificates(pr ProjectRouter, objs map[meta.Key]*MockRegionSslCertificatesObj) *MockAlphaRegionSslCertificates {
	mock := &MockAlphaRegionSslCertificates{
		ProjectRouter: pr,

		Objects:     objs,
		GetError:    map[meta.Key]error{},
		InsertError: map[meta.Key]error{},
		DeleteError: map[meta.Key]error{},
	}
	return mock
}

// MockAlphaRegionSslCertificates is the mock for RegionSslCertificates.
type MockAlphaRegionSslCertificates struct {
	Lock sync.Mutex

	ProjectRouter ProjectRouter

	// Objects maintained by the mock.
	Objects map[meta.Key]*MockRegionSslCertificatesObj

	// If an entry exists for the given key and operation, then the error
	// will be returned instead of the operation.
	GetError    map[meta.Key]error
	ListError   *error
	InsertError map[meta.Key]error
	DeleteError map[meta.Key]error

	// xxxHook allow you to intercept the standard processing of the mock in
	// order to add your own logic. Return (true, _, _) to prevent the normal
	// execution flow of the mock. Return (false, nil, nil) to continue with
	// normal mock behavior/ after the hook function executes.
	GetHook    func(ctx context.Context, key *meta.Key, m *MockAlphaRegionSslCertificates) (bool, *alpha.SslCertificate, error)
	ListHook   func(ctx context.Context, region string, fl *filter.F, m *MockAlphaRegionSslCertificates) (bool, []*alpha.SslCertificate, error)
	InsertHook func(ctx context.Context, key *meta.Key, obj *alpha.SslCertificate, m *MockAlphaRegionSslCertificates) (bool, error)
	DeleteHook func(ctx context.Context, key *meta.Key, m *MockAlphaRegionSslCertificates) (bool, error)

	// X is extra state that can be used as part of the mock. Generated code
	// will not use this field.
	X interface{}
}

// Get returns the object from the mock.
func (m *MockAlphaRegionSslCertificates) Get(ctx context.Context, key *meta.Key) (*alpha.SslCertificate, error) {
	if m.GetHook != nil {
		if intercept, obj, err := m.GetHook(ctx, key, m); intercept {
			klog.V(5).Infof("MockAlphaRegionSslCertificates.Get(%v, %s) = %+v, %v", ctx, key, obj, err)
			return obj, err
		}
	}
	if !key.Valid() {
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.GetError[*key]; ok {
		klog.V(5).Infof("MockAlphaRegionSslCertificates.Get(%v, %s) = nil, %v", ctx, key, err)
		return nil, err
	}
	if obj, ok := m.Objects[*key]; ok {
		typedObj := obj.ToAlpha()
		klog.V(5).Infof("MockAlphaRegionSslCertificates.Get(%v, %s) = %+v, nil", ctx, key, typedObj)
		return typedObj, nil
	}

	err := &googleapi.Error{
		Code:    http.StatusNotFound,
		Message: fmt.Sprintf("MockAlphaRegionSslCertificates %v not found", key),
	}
	klog.V(5).Infof("MockAlphaRegionSslCertificates.Get(%v, %s) = nil, %v", ctx, key, err)
	return nil, err
}

// List all of the objects in the mock in the given region.
func (m *MockAlphaRegionSslCertificates) List(ctx context.Context, region string, fl *filter.F) ([]*alpha.SslCertificate, error) {
	if m.ListHook != nil {
		if intercept, objs, err := m.ListHook(ctx, region, fl, m); intercept {
			klog.V(5).Infof("MockAlphaRegionSslCertificates.List(%v, %q, %v) = [%v items], %v", ctx, region, fl, len(objs), err)
			return objs, err
		}
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if m.ListError != nil {
		err := *m.ListError
		klog.V(5).Infof("MockAlphaRegionSslCertificates.List(%v, %q, %v) = nil, %v", ctx, region, fl, err)

		return nil, *m.ListError
	}

	var objs []*alpha.SslCertificate
	for key, obj := range m.Objects {
		if key.Region != region {
			continue
		}
		if !fl.Match(obj.ToAlpha()) {
			continue
		}
		objs = append(objs, obj.ToAlpha())
	}

	klog.V(5).Infof("MockAlphaRegionSslCertificates.List(%v, %q, %v) = [%v items], nil", ctx, region, fl, len(objs))
	return objs, nil
}

// Insert is a mock for inserting/creating a new object.
func (m *MockAlphaRegionSslCertificates) Insert(ctx context.Context, key *meta.Key, obj *alpha.SslCertificate) error {
	if m.InsertHook != nil {
		if intercept, err := m.InsertHook(ctx, key, obj, m); intercept {
			klog.V(5).Infof("MockAlphaRegionSslCertificates.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.InsertError[*key]; ok {
		klog.V(5).Infof("MockAlphaRegionSslCertificates.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}
	if _, ok := m.Objects[*key]; ok {
		err := &googleapi.Error{
			Code:    http.StatusConflict,
			Message: fmt.Sprintf("MockAlphaRegionSslCertificates %v exists", key),
		}
		klog.V(5).Infof("MockAlphaRegionSslCertificates.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}

	obj.Name = key.Name
	projectID := m.ProjectRouter.ProjectID(ctx, "alpha", "sslCertificates")
	obj.SelfLink = SelfLink(meta.VersionAlpha, projectID, "sslCertificates", key)

	m.Objects[*key] = &MockRegionSslCertificatesObj{obj}
	klog.V(5).Infof("MockAlphaRegionSslCertificates.Insert(%v, %v, %+v) = nil", ctx, key, obj)
	return nil
}

// Delete is a mock for deleting the object.
func (m *MockAlphaRegionSslCertificates) Delete(ctx context.Context, key *meta.Key) error {
	if m.DeleteHook != nil {
		if intercept, err := m.DeleteHook(ctx, key, m); intercept {
			klog.V(5).Infof("MockAlphaRegionSslCertificates.Delete(%v, %v) = %v", ctx, key, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.DeleteError[*key]; ok {
		klog.V(5).Infof("MockAlphaRegionSslCertificates.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}
	if _, ok := m.Objects[*key]; !ok {
		err := &googleapi.Error{
			Code:    http.StatusNotFound,
			Message: fmt.Sprintf("MockAlphaRegionSslCertificates %v not found", key),
		}
		klog.V(5).Infof("MockAlphaRegionSslCertificates.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	delete(m.Objects, *key)
	klog.V(5).Infof("MockAlphaRegionSslCertificates.Delete(%v, %v) = nil", ctx, key)
	return nil
}

// Obj wraps the object for use in the mock.
func (m *MockAlphaRegionSslCertificates) Obj(o *alpha.SslCertificate) *MockRegionSslCertificatesObj {
	return &MockRegionSslCertificatesObj{o}
}

// GCEAlphaRegionSslCertificates is a simplifying adapter for the GCE RegionSslCertificates.
type GCEAlphaRegionSslCertificates struct {
	s *Service
}

// Get the SslCertificate named by key.
func (g *GCEAlphaRegionSslCertificates) Get(ctx context.Context, key *meta.Key) (*alpha.SslCertificate, error) {
	klog.V(5).Infof("GCEAlphaRegionSslCertificates.Get(%v, %v): called", ctx, key)

	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaRegionSslCertificates.Get(%v, %v): key is invalid (%#v)", ctx, key, key)
		return nil, fmt.Errorf("invalid GCE key (%#v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "alpha", "RegionSslCertificates")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Get",
		Version:   meta.Version("alpha"),
		Service:   "RegionSslCertificates",
	}
	klog.V(5).Infof("GCEAlphaRegionSslCertificates.Get(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEAlphaRegionSslCertificates.Get(%v, %v): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.Alpha.RegionSslCertificates.Get(projectID, key.Region, key.Name)
	call.Context(ctx)
	v, err := call.Do()
	klog.V(4).Infof("GCEAlphaRegionSslCertificates.Get(%v, %v) = %+v, %v", ctx, key, v, err)
	return v, err
}

// List all SslCertificate objects.
func (g *GCEAlphaRegionSslCertificates) List(ctx context.Context, region string, fl *filter.F) ([]*alpha.SslCertificate, error) {
	klog.V(5).Infof("GCEAlphaRegionSslCertificates.List(%v, %v, %v) called", ctx, region, fl)
	projectID := g.s.ProjectRouter.ProjectID(ctx, "alpha", "RegionSslCertificates")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "List",
		Version:   meta.Version("alpha"),
		Service:   "RegionSslCertificates",
	}
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		return nil, err
	}
	klog.V(5).Infof("GCEAlphaRegionSslCertificates.List(%v, %v, %v): projectID = %v, rk = %+v", ctx, region, fl, projectID, rk)
	call := g.s.Alpha.RegionSslCertificates.List(projectID, region)
	if fl != filter.None {
		call.Filter(fl.String())
	}
	var all []*alpha.SslCertificate
	f := func(l *alpha.SslCertificateList) error {
		klog.V(5).Infof("GCEAlphaRegionSslCertificates.List(%v, ..., %v): page %+v", ctx, fl, l)
		all = append(all, l.Items...)
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		klog.V(4).Infof("GCEAlphaRegionSslCertificates.List(%v, ..., %v) = %v, %v", ctx, fl, nil, err)
		return nil, err
	}

	if klog.V(4).Enabled() {
		klog.V(4).Infof("GCEAlphaRegionSslCertificates.List(%v, ..., %v) = [%v items], %v", ctx, fl, len(all), nil)
	} else if klog.V(5).Enabled() {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		klog.V(5).Infof("GCEAlphaRegionSslCertificates.List(%v, ..., %v) = %v, %v", ctx, fl, asStr, nil)
	}

	return all, nil
}

// Insert SslCertificate with key of value obj.
func (g *GCEAlphaRegionSslCertificates) Insert(ctx context.Context, key *meta.Key, obj *alpha.SslCertificate) error {
	klog.V(5).Infof("GCEAlphaRegionSslCertificates.Insert(%v, %v, %+v): called", ctx, key, obj)
	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaRegionSslCertificates.Insert(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "alpha", "RegionSslCertificates")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Insert",
		Version:   meta.Version("alpha"),
		Service:   "RegionSslCertificates",
	}
	klog.V(5).Infof("GCEAlphaRegionSslCertificates.Insert(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEAlphaRegionSslCertificates.Insert(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	obj.Name = key.Name
	call := g.s.Alpha.RegionSslCertificates.Insert(projectID, key.Region, obj)
	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCEAlphaRegionSslCertificates.Insert(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEAlphaRegionSslCertificates.Insert(%v, %v, %+v) = %+v", ctx, key, obj, err)
	return err
}

// Delete the SslCertificate referenced by key.
func (g *GCEAlphaRegionSslCertificates) Delete(ctx context.Context, key *meta.Key) error {
	klog.V(5).Infof("GCEAlphaRegionSslCertificates.Delete(%v, %v): called", ctx, key)
	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaRegionSslCertificates.Delete(%v, %v): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "alpha", "RegionSslCertificates")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Delete",
		Version:   meta.Version("alpha"),
		Service:   "RegionSslCertificates",
	}
	klog.V(5).Infof("GCEAlphaRegionSslCertificates.Delete(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEAlphaRegionSslCertificates.Delete(%v, %v): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Alpha.RegionSslCertificates.Delete(projectID, key.Region, key.Name)
	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCEAlphaRegionSslCertificates.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEAlphaRegionSslCertificates.Delete(%v, %v) = %v", ctx, key, err)
	return err
}

// BetaRegionSslCertificates is an interface that allows for mocking of RegionSslCertificates.
type BetaRegionSslCertificates interface {
	Get(ctx context.Context, key *meta.Key) (*beta.SslCertificate, error)
	List(ctx context.Context, region string, fl *filter.F) ([]*beta.SslCertificate, error)
	Insert(ctx context.Context, key *meta.Key, obj *beta.SslCertificate) error
	Delete(ctx context.Context, key *meta.Key) error
}

// NewMockBetaRegionSslCertificates returns a new mock for RegionSslCertificates.
func NewMockBetaRegionSslCertificates(pr ProjectRouter, objs map[meta.Key]*MockRegionSslCertificatesObj) *MockBetaRegionSslCertificates {
	mock := &MockBetaRegionSslCertificates{
		ProjectRouter: pr,

		Objects:     objs,
		GetError:    map[meta.Key]error{},
		InsertError: map[meta.Key]error{},
		DeleteError: map[meta.Key]error{},
	}
	return mock
}

// MockBetaRegionSslCertificates is the mock for RegionSslCertificates.
type MockBetaRegionSslCertificates struct {
	Lock sync.Mutex

	ProjectRouter ProjectRouter

	// Objects maintained by the mock.
	Objects map[meta.Key]*MockRegionSslCertificatesObj

	// If an entry exists for the given key and operation, then the error
	// will be returned instead of the operation.
	GetError    map[meta.Key]error
	ListError   *error
	InsertError map[meta.Key]error
	DeleteError map[meta.Key]error

	// xxxHook allow you to intercept the standard processing of the mock in
	// order to add your own logic. Return (true, _, _) to prevent the normal
	// execution flow of the mock. Return (false, nil, nil) to continue with
	// normal mock behavior/ after the hook function executes.
	GetHook    func(ctx context.Context, key *meta.Key, m *MockBetaRegionSslCertificates) (bool, *beta.SslCertificate, error)
	ListHook   func(ctx context.Context, region string, fl *filter.F, m *MockBetaRegionSslCertificates) (bool, []*beta.SslCertificate, error)
	InsertHook func(ctx context.Context, key *meta.Key, obj *beta.SslCertificate, m *MockBetaRegionSslCertificates) (bool, error)
	DeleteHook func(ctx context.Context, key *meta.Key, m *MockBetaRegionSslCertificates) (bool, error)

	// X is extra state that can be used as part of the mock. Generated code
	// will not use this field.
	X interface{}
}

// Get returns the object from the mock.
func (m *MockBetaRegionSslCertificates) Get(ctx context.Context, key *meta.Key) (*beta.SslCertificate, error) {
	if m.GetHook != nil {
		if intercept, obj, err := m.GetHook(ctx, key, m); intercept {
			klog.V(5).Infof("MockBetaRegionSslCertificates.Get(%v, %s) = %+v, %v", ctx, key, obj, err)
			return obj, err
		}
	}
	if !key.Valid() {
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.GetError[*key]; ok {
		klog.V(5).Infof("MockBetaRegionSslCertificates.Get(%v, %s) = nil, %v", ctx, key, err)
		return nil, err
	}
	if obj, ok := m.Objects[*key]; ok {
		typedObj := obj.ToBeta()
		klog.V(5).Infof("MockBetaRegionSslCertificates.Get(%v, %s) = %+v, nil", ctx, key, typedObj)
		return typedObj, nil
	}

	err := &googleapi.Error{
		Code:    http.StatusNotFound,
		Message: fmt.Sprintf("MockBetaRegionSslCertificates %v not found", key),
	}
	klog.V(5).Infof("MockBetaRegionSslCertificates.Get(%v, %s) = nil, %v", ctx, key, err)
	return nil, err
}

// List all of the objects in the mock in the given region.
func (m *MockBetaRegionSslCertificates) List(ctx context.Context, region string, fl *filter.F) ([]*beta.SslCertificate, error) {
	if m.ListHook != nil {
		if intercept, objs, err := m.ListHook(ctx, region, fl, m); intercept {
			klog.V(5).Infof("MockBetaRegionSslCertificates.List(%v, %q, %v) = [%v items], %v", ctx, region, fl, len(objs), err)
			return objs, err
		}
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if m.ListError != nil {
		err := *m.ListError
		klog.V(5).Infof("MockBetaRegionSslCertificates.List(%v, %q, %v) = nil, %v", ctx, region, fl, err)

		return nil, *m.ListError
	}

	var objs []*beta.SslCertificate
	for key, obj := range m.Objects {
		if key.Region != region {
			continue
		}
		if !fl.Match(obj.ToBeta()) {
			continue
		}
		objs = append(objs, obj.ToBeta())
	}

	klog.V(5).Infof("MockBetaRegionSslCertificates.List(%v, %q, %v) = [%v items], nil", ctx, region, fl, len(objs))
	return objs, nil
}

// Insert is a mock for inserting/creating a new object.
func (m *MockBetaRegionSslCertificates) Insert(ctx context.Context, key *meta.Key, obj *beta.SslCertificate) error {
	if m.InsertHook != nil {
		if intercept, err := m.InsertHook(ctx, key, obj, m); intercept {
			klog.V(5).Infof("MockBetaRegionSslCertificates.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.InsertError[*key]; ok {
		klog.V(5).Infof("MockBetaRegionSslCertificates.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}
	if _, ok := m.Objects[*key]; ok {
		err := &googleapi.Error{
			Code:    http.StatusConflict,
			Message: fmt.Sprintf("MockBetaRegionSslCertificates %v exists", key),
		}
		klog.V(5).Infof("MockBetaRegionSslCertificates.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}

	obj.Name = key.Name
	projectID := m.ProjectRouter.ProjectID(ctx, "beta", "sslCertificates")
	obj.SelfLink = SelfLink(meta.VersionBeta, projectID, "sslCertificates", key)

	m.Objects[*key] = &MockRegionSslCertificatesObj{obj}
	klog.V(5).Infof("MockBetaRegionSslCertificates.Insert(%v, %v, %+v) = nil", ctx, key, obj)
	return nil
}

// Delete is a mock for deleting the object.
func (m *MockBetaRegionSslCertificates) Delete(ctx context.Context, key *meta.Key) error {
	if m.DeleteHook != nil {
		if intercept, err := m.DeleteHook(ctx, key, m); intercept {
			klog.V(5).Infof("MockBetaRegionSslCertificates.Delete(%v, %v) = %v", ctx, key, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.DeleteError[*key]; ok {
		klog.V(5).Infof("MockBetaRegionSslCertificates.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}
	if _, ok := m.Objects[*key]; !ok {
		err := &googleapi.Error{
			Code:    http.StatusNotFound,
			Message: fmt.Sprintf("MockBetaRegionSslCertificates %v not found", key),
		}
		klog.V(5).Infof("MockBetaRegionSslCertificates.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	delete(m.Objects, *key)
	klog.V(5).Infof("MockBetaRegionSslCertificates.Delete(%v, %v) = nil", ctx, key)
	return nil
}

// Obj wraps the object for use in the mock.
func (m *MockBetaRegionSslCertificates) Obj(o *beta.SslCertificate) *MockRegionSslCertificatesObj {
	return &MockRegionSslCertificatesObj{o}
}

// GCEBetaRegionSslCertificates is a simplifying adapter for the GCE RegionSslCertificates.
type GCEBetaRegionSslCertificates struct {
	s *Service
}

// Get the SslCertificate named by key.
func (g *GCEBetaRegionSslCertificates) Get(ctx context.Context, key *meta.Key) (*beta.SslCertificate, error) {
	klog.V(5).Infof("GCEBetaRegionSslCertificates.Get(%v, %v): called", ctx, key)

	if !key.Valid() {
		klog.V(2).Infof("GCEBetaRegionSslCertificates.Get(%v, %v): key is invalid (%#v)", ctx, key, key)
		return nil, fmt.Errorf("invalid GCE key (%#v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "beta", "RegionSslCertificates")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Get",
		Version:   meta.Version("beta"),
		Service:   "RegionSslCertificates",
	}
	klog.V(5).Infof("GCEBetaRegionSslCertificates.Get(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEBetaRegionSslCertificates.Get(%v, %v): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.Beta.RegionSslCertificates.Get(projectID, key.Region, key.Name)
	call.Context(ctx)
	v, err := call.Do()
	klog.V(4).Infof("GCEBetaRegionSslCertificates.Get(%v, %v) = %+v, %v", ctx, key, v, err)
	return v, err
}

// List all SslCertificate objects.
func (g *GCEBetaRegionSslCertificates) List(ctx context.Context, region string, fl *filter.F) ([]*beta.SslCertificate, error) {
	klog.V(5).Infof("GCEBetaRegionSslCertificates.List(%v, %v, %v) called", ctx, region, fl)
	projectID := g.s.ProjectRouter.ProjectID(ctx, "beta", "RegionSslCertificates")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "List",
		Version:   meta.Version("beta"),
		Service:   "RegionSslCertificates",
	}
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		return nil, err
	}
	klog.V(5).Infof("GCEBetaRegionSslCertificates.List(%v, %v, %v): projectID = %v, rk = %+v", ctx, region, fl, projectID, rk)
	call := g.s.Beta.RegionSslCertificates.List(projectID, region)
	if fl != filter.None {
		call.Filter(fl.String())
	}
	var all []*beta.SslCertificate
	f := func(l *beta.SslCertificateList) error {
		klog.V(5).Infof("GCEBetaRegionSslCertificates.List(%v, ..., %v): page %+v", ctx, fl, l)
		all = append(all, l.Items...)
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		klog.V(4).Infof("GCEBetaRegionSslCertificates.List(%v, ..., %v) = %v, %v", ctx, fl, nil, err)
		return nil, err
	}

	if klog.V(4).Enabled() {
		klog.V(4).Infof("GCEBetaRegionSslCertificates.List(%v, ..., %v) = [%v items], %v", ctx, fl, len(all), nil)
	} else if klog.V(5).Enabled() {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		klog.V(5).Infof("GCEBetaRegionSslCertificates.List(%v, ..., %v) = %v, %v", ctx, fl, asStr, nil)
	}

	return all, nil
}

// Insert SslCertificate with key of value obj.
func (g *GCEBetaRegionSslCertificates) Insert(ctx context.Context, key *meta.Key, obj *beta.SslCertificate) error {
	klog.V(5).Infof("GCEBetaRegionSslCertificates.Insert(%v, %v, %+v): called", ctx, key, obj)
	if !key.Valid() {
		klog.V(2).Infof("GCEBetaRegionSslCertificates.Insert(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "beta", "RegionSslCertificates")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Insert",
		Version:   meta.Version("beta"),
		Service:   "RegionSslCertificates",
	}
	klog.V(5).Infof("GCEBetaRegionSslCertificates.Insert(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEBetaRegionSslCertificates.Insert(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	obj.Name = key.Name
	call := g.s.Beta.RegionSslCertificates.Insert(projectID, key.Region, obj)
	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCEBetaRegionSslCertificates.Insert(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEBetaRegionSslCertificates.Insert(%v, %v, %+v) = %+v", ctx, key, obj, err)
	return err
}

// Delete the SslCertificate referenced by key.
func (g *GCEBetaRegionSslCertificates) Delete(ctx context.Context, key *meta.Key) error {
	klog.V(5).Infof("GCEBetaRegionSslCertificates.Delete(%v, %v): called", ctx, key)
	if !key.Valid() {
		klog.V(2).Infof("GCEBetaRegionSslCertificates.Delete(%v, %v): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "beta", "RegionSslCertificates")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Delete",
		Version:   meta.Version("beta"),
		Service:   "RegionSslCertificates",
	}
	klog.V(5).Infof("GCEBetaRegionSslCertificates.Delete(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEBetaRegionSslCertificates.Delete(%v, %v): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Beta.RegionSslCertificates.Delete(projectID, key.Region, key.Name)
	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCEBetaRegionSslCertificates.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEBetaRegionSslCertificates.Delete(%v, %v) = %v", ctx, key, err)
	return err
}

// RegionSslCertificates is an interface that allows for mocking of RegionSslCertificates.
type RegionSslCertificates interface {
	Get(ctx context.Context, key *meta.Key) (*ga.SslCertificate, error)
	List(ctx context.Context, region string, fl *filter.F) ([]*ga.SslCertificate, error)
	Insert(ctx context.Context, key *meta.Key, obj *ga.SslCertificate) error
	Delete(ctx context.Context, key *meta.Key) error
}

// NewMockRegionSslCertificates returns a new mock for RegionSslCertificates.
func NewMockRegionSslCertificates(pr ProjectRouter, objs map[meta.Key]*MockRegionSslCertificatesObj) *MockRegionSslCertificates {
	mock := &MockRegionSslCertificates{
		ProjectRouter: pr,

		Objects:     objs,
		GetError:    map[meta.Key]error{},
		InsertError: map[meta.Key]error{},
		DeleteError: map[meta.Key]error{},
	}
	return mock
}

// MockRegionSslCertificates is the mock for RegionSslCertificates.
type MockRegionSslCertificates struct {
	Lock sync.Mutex

	ProjectRouter ProjectRouter

	// Objects maintained by the mock.
	Objects map[meta.Key]*MockRegionSslCertificatesObj

	// If an entry exists for the given key and operation, then the error
	// will be returned instead of the operation.
	GetError    map[meta.Key]error
	ListError   *error
	InsertError map[meta.Key]error
	DeleteError map[meta.Key]error

	// xxxHook allow you to intercept the standard processing of the mock in
	// order to add your own logic. Return (true, _, _) to prevent the normal
	// execution flow of the mock. Return (false, nil, nil) to continue with
	// normal mock behavior/ after the hook function executes.
	GetHook    func(ctx context.Context, key *meta.Key, m *MockRegionSslCertificates) (bool, *ga.SslCertificate, error)
	ListHook   func(ctx context.Context, region string, fl *filter.F, m *MockRegionSslCertificates) (bool, []*ga.SslCertificate, error)
	InsertHook func(ctx context.Context, key *meta.Key, obj *ga.SslCertificate, m *MockRegionSslCertificates) (bool, error)
	DeleteHook func(ctx context.Context, key *meta.Key, m *MockRegionSslCertificates) (bool, error)

	// X is extra state that can be used as part of the mock. Generated code
	// will not use this field.
	X interface{}
}

// Get returns the object from the mock.
func (m *MockRegionSslCertificates) Get(ctx context.Context, key *meta.Key) (*ga.SslCertificate, error) {
	if m.GetHook != nil {
		if intercept, obj, err := m.GetHook(ctx, key, m); intercept {
			klog.V(5).Infof("MockRegionSslCertificates.Get(%v, %s) = %+v, %v", ctx, key, obj, err)
			return obj, err
		}
	}
	if !key.Valid() {
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.GetError[*key]; ok {
		klog.V(5).Infof("MockRegionSslCertificates.Get(%v, %s) = nil, %v", ctx, key, err)
		return nil, err
	}
	if obj, ok := m.Objects[*key]; ok {
		typedObj := obj.ToGA()
		klog.V(5).Infof("MockRegionSslCertificates.Get(%v, %s) = %+v, nil", ctx, key, typedObj)
		return typedObj, nil
	}

	err := &googleapi.Error{
		Code:    http.StatusNotFound,
		Message: fmt.Sprintf("MockRegionSslCertificates %v not found", key),
	}
	klog.V(5).Infof("MockRegionSslCertificates.Get(%v, %s) = nil, %v", ctx, key, err)
	return nil, err
}

// List all of the objects in the mock in the given region.
func (m *MockRegionSslCertificates) List(ctx context.Context, region string, fl *filter.F) ([]*ga.SslCertificate, error) {
	if m.ListHook != nil {
		if intercept, objs, err := m.ListHook(ctx, region, fl, m); intercept {
			klog.V(5).Infof("MockRegionSslCertificates.List(%v, %q, %v) = [%v items], %v", ctx, region, fl, len(objs), err)
			return objs, err
		}
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if m.ListError != nil {
		err := *m.ListError
		klog.V(5).Infof("MockRegionSslCertificates.List(%v, %q, %v) = nil, %v", ctx, region, fl, err)

		return nil, *m.ListError
	}

	var objs []*ga.SslCertificate
	for key, obj := range m.Objects {
		if key.Region != region {
			continue
		}
		if !fl.Match(obj.ToGA()) {
			continue
		}
		objs = append(objs, obj.ToGA())
	}

	klog.V(5).Infof("MockRegionSslCertificates.List(%v, %q, %v) = [%v items], nil", ctx, region, fl, len(objs))
	return objs, nil
}

// Insert is a mock for inserting/creating a new object.
func (m *MockRegionSslCertificates) Insert(ctx context.Context, key *meta.Key, obj *ga.SslCertificate) error {
	if m.InsertHook != nil {
		if intercept, err := m.InsertHook(ctx, key, obj, m); intercept {
			klog.V(5).Infof("MockRegionSslCertificates.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.InsertError[*key]; ok {
		klog.V(5).Infof("MockRegionSslCertificates.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}
	if _, ok := m.Objects[*key]; ok {
		err := &googleapi.Error{
			Code:    http.StatusConflict,
			Message: fmt.Sprintf("MockRegionSslCertificates %v exists", key),
		}
		klog.V(5).Infof("MockRegionSslCertificates.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}

	obj.Name = key.Name
	projectID := m.ProjectRouter.ProjectID(ctx, "ga", "sslCertificates")
	obj.SelfLink = SelfLink(meta.VersionGA, projectID, "sslCertificates", key)

	m.Objects[*key] = &MockRegionSslCertificatesObj{obj}
	klog.V(5).Infof("MockRegionSslCertificates.Insert(%v, %v, %+v) = nil", ctx, key, obj)
	return nil
}

// Delete is a mock for deleting the object.
func (m *MockRegionSslCertificates) Delete(ctx context.Context, key *meta.Key) error {
	if m.DeleteHook != nil {
		if intercept, err := m.DeleteHook(ctx, key, m); intercept {
			klog.V(5).Infof("MockRegionSslCertificates.Delete(%v, %v) = %v", ctx, key, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.DeleteError[*key]; ok {
		klog.V(5).Infof("MockRegionSslCertificates.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}
	if _, ok := m.Objects[*key]; !ok {
		err := &googleapi.Error{
			Code:    http.StatusNotFound,
			Message: fmt.Sprintf("MockRegionSslCertificates %v not found", key),
		}
		klog.V(5).Infof("MockRegionSslCertificates.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	delete(m.Objects, *key)
	klog.V(5).Infof("MockRegionSslCertificates.Delete(%v, %v) = nil", ctx, key)
	return nil
}

// Obj wraps the object for use in the mock.
func (m *MockRegionSslCertificates) Obj(o *ga.SslCertificate) *MockRegionSslCertificatesObj {
	return &MockRegionSslCertificatesObj{o}
}

// GCERegionSslCertificates is a simplifying adapter for the GCE RegionSslCertificates.
type GCERegionSslCertificates struct {
	s *Service
}

// Get the SslCertificate named by key.
func (g *GCERegionSslCertificates) Get(ctx context.Context, key *meta.Key) (*ga.SslCertificate, error) {
	klog.V(5).Infof("GCERegionSslCertificates.Get(%v, %v): called", ctx, key)

	if !key.Valid() {
		klog.V(2).Infof("GCERegionSslCertificates.Get(%v, %v): key is invalid (%#v)", ctx, key, key)
		return nil, fmt.Errorf("invalid GCE key (%#v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "RegionSslCertificates")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Get",
		Version:   meta.Version("ga"),
		Service:   "RegionSslCertificates",
	}
	klog.V(5).Infof("GCERegionSslCertificates.Get(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCERegionSslCertificates.Get(%v, %v): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.GA.RegionSslCertificates.Get(projectID, key.Region, key.Name)
	call.Context(ctx)
	v, err := call.Do()
	klog.V(4).Infof("GCERegionSslCertificates.Get(%v, %v) = %+v, %v", ctx, key, v, err)
	return v, err
}

// List all SslCertificate objects.
func (g *GCERegionSslCertificates) List(ctx context.Context, region string, fl *filter.F) ([]*ga.SslCertificate, error) {
	klog.V(5).Infof("GCERegionSslCertificates.List(%v, %v, %v) called", ctx, region, fl)
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "RegionSslCertificates")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "List",
		Version:   meta.Version("ga"),
		Service:   "RegionSslCertificates",
	}
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		return nil, err
	}
	klog.V(5).Infof("GCERegionSslCertificates.List(%v, %v, %v): projectID = %v, rk = %+v", ctx, region, fl, projectID, rk)
	call := g.s.GA.RegionSslCertificates.List(projectID, region)
	if fl != filter.None {
		call.Filter(fl.String())
	}
	var all []*ga.SslCertificate
	f := func(l *ga.SslCertificateList) error {
		klog.V(5).Infof("GCERegionSslCertificates.List(%v, ..., %v): page %+v", ctx, fl, l)
		all = append(all, l.Items...)
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		klog.V(4).Infof("GCERegionSslCertificates.List(%v, ..., %v) = %v, %v", ctx, fl, nil, err)
		return nil, err
	}

	if klog.V(4).Enabled() {
		klog.V(4).Infof("GCERegionSslCertificates.List(%v, ..., %v) = [%v items], %v", ctx, fl, len(all), nil)
	} else if klog.V(5).Enabled() {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		klog.V(5).Infof("GCERegionSslCertificates.List(%v, ..., %v) = %v, %v", ctx, fl, asStr, nil)
	}

	return all, nil
}

// Insert SslCertificate with key of value obj.
func (g *GCERegionSslCertificates) Insert(ctx context.Context, key *meta.Key, obj *ga.SslCertificate) error {
	klog.V(5).Infof("GCERegionSslCertificates.Insert(%v, %v, %+v): called", ctx, key, obj)
	if !key.Valid() {
		klog.V(2).Infof("GCERegionSslCertificates.Insert(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "RegionSslCertificates")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Insert",
		Version:   meta.Version("ga"),
		Service:   "RegionSslCertificates",
	}
	klog.V(5).Infof("GCERegionSslCertificates.Insert(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCERegionSslCertificates.Insert(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	obj.Name = key.Name
	call := g.s.GA.RegionSslCertificates.Insert(projectID, key.Region, obj)
	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCERegionSslCertificates.Insert(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCERegionSslCertificates.Insert(%v, %v, %+v) = %+v", ctx, key, obj, err)
	return err
}

// Delete the SslCertificate referenced by key.
func (g *GCERegionSslCertificates) Delete(ctx context.Context, key *meta.Key) error {
	klog.V(5).Infof("GCERegionSslCertificates.Delete(%v, %v): called", ctx, key)
	if !key.Valid() {
		klog.V(2).Infof("GCERegionSslCertificates.Delete(%v, %v): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "RegionSslCertificates")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Delete",
		Version:   meta.Version("ga"),
		Service:   "RegionSslCertificates",
	}
	klog.V(5).Infof("GCERegionSslCertificates.Delete(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCERegionSslCertificates.Delete(%v, %v): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.GA.RegionSslCertificates.Delete(projectID, key.Region, key.Name)
	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCERegionSslCertificates.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCERegionSslCertificates.Delete(%v, %v) = %v", ctx, key, err)
	return err
}

// SslPolicies is an interface that allows for mocking of SslPolicies.
type SslPolicies interface {
	Get(ctx context.Context, key *meta.Key) (*ga.SslPolicy, error)
	Insert(ctx context.Context, key *meta.Key, obj *ga.SslPolicy) error
	Delete(ctx context.Context, key *meta.Key) error
}

// NewMockSslPolicies returns a new mock for SslPolicies.
func NewMockSslPolicies(pr ProjectRouter, objs map[meta.Key]*MockSslPoliciesObj) *MockSslPolicies {
	mock := &MockSslPolicies{
		ProjectRouter: pr,

		Objects:     objs,
		GetError:    map[meta.Key]error{},
		InsertError: map[meta.Key]error{},
		DeleteError: map[meta.Key]error{},
	}
	return mock
}

// MockSslPolicies is the mock for SslPolicies.
type MockSslPolicies struct {
	Lock sync.Mutex

	ProjectRouter ProjectRouter

	// Objects maintained by the mock.
	Objects map[meta.Key]*MockSslPoliciesObj

	// If an entry exists for the given key and operation, then the error
	// will be returned instead of the operation.
	GetError    map[meta.Key]error
	InsertError map[meta.Key]error
	DeleteError map[meta.Key]error

	// xxxHook allow you to intercept the standard processing of the mock in
	// order to add your own logic. Return (true, _, _) to prevent the normal
	// execution flow of the mock. Return (false, nil, nil) to continue with
	// normal mock behavior/ after the hook function executes.
	GetHook    func(ctx context.Context, key *meta.Key, m *MockSslPolicies) (bool, *ga.SslPolicy, error)
	InsertHook func(ctx context.Context, key *meta.Key, obj *ga.SslPolicy, m *MockSslPolicies) (bool, error)
	DeleteHook func(ctx context.Context, key *meta.Key, m *MockSslPolicies) (bool, error)

	// X is extra state that can be used as part of the mock. Generated code
	// will not use this field.
	X interface{}
}

// Get returns the object from the mock.
func (m *MockSslPolicies) Get(ctx context.Context, key *meta.Key) (*ga.SslPolicy, error) {
	if m.GetHook != nil {
		if intercept, obj, err := m.GetHook(ctx, key, m); intercept {
			klog.V(5).Infof("MockSslPolicies.Get(%v, %s) = %+v, %v", ctx, key, obj, err)
			return obj, err
		}
	}
	if !key.Valid() {
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.GetError[*key]; ok {
		klog.V(5).Infof("MockSslPolicies.Get(%v, %s) = nil, %v", ctx, key, err)
		return nil, err
	}
	if obj, ok := m.Objects[*key]; ok {
		typedObj := obj.ToGA()
		klog.V(5).Infof("MockSslPolicies.Get(%v, %s) = %+v, nil", ctx, key, typedObj)
		return typedObj, nil
	}

	err := &googleapi.Error{
		Code:    http.StatusNotFound,
		Message: fmt.Sprintf("MockSslPolicies %v not found", key),
	}
	klog.V(5).Infof("MockSslPolicies.Get(%v, %s) = nil, %v", ctx, key, err)
	return nil, err
}

// Insert is a mock for inserting/creating a new object.
func (m *MockSslPolicies) Insert(ctx context.Context, key *meta.Key, obj *ga.SslPolicy) error {
	if m.InsertHook != nil {
		if intercept, err := m.InsertHook(ctx, key, obj, m); intercept {
			klog.V(5).Infof("MockSslPolicies.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.InsertError[*key]; ok {
		klog.V(5).Infof("MockSslPolicies.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}
	if _, ok := m.Objects[*key]; ok {
		err := &googleapi.Error{
			Code:    http.StatusConflict,
			Message: fmt.Sprintf("MockSslPolicies %v exists", key),
		}
		klog.V(5).Infof("MockSslPolicies.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}

	obj.Name = key.Name
	projectID := m.ProjectRouter.ProjectID(ctx, "ga", "sslPolicies")
	obj.SelfLink = SelfLink(meta.VersionGA, projectID, "sslPolicies", key)

	m.Objects[*key] = &MockSslPoliciesObj{obj}
	klog.V(5).Infof("MockSslPolicies.Insert(%v, %v, %+v) = nil", ctx, key, obj)
	return nil
}

// Delete is a mock for deleting the object.
func (m *MockSslPolicies) Delete(ctx context.Context, key *meta.Key) error {
	if m.DeleteHook != nil {
		if intercept, err := m.DeleteHook(ctx, key, m); intercept {
			klog.V(5).Infof("MockSslPolicies.Delete(%v, %v) = %v", ctx, key, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.DeleteError[*key]; ok {
		klog.V(5).Infof("MockSslPolicies.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}
	if _, ok := m.Objects[*key]; !ok {
		err := &googleapi.Error{
			Code:    http.StatusNotFound,
			Message: fmt.Sprintf("MockSslPolicies %v not found", key),
		}
		klog.V(5).Infof("MockSslPolicies.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	delete(m.Objects, *key)
	klog.V(5).Infof("MockSslPolicies.Delete(%v, %v) = nil", ctx, key)
	return nil
}

// Obj wraps the object for use in the mock.
func (m *MockSslPolicies) Obj(o *ga.SslPolicy) *MockSslPoliciesObj {
	return &MockSslPoliciesObj{o}
}

// GCESslPolicies is a simplifying adapter for the GCE SslPolicies.
type GCESslPolicies struct {
	s *Service
}

// Get the SslPolicy named by key.
func (g *GCESslPolicies) Get(ctx context.Context, key *meta.Key) (*ga.SslPolicy, error) {
	klog.V(5).Infof("GCESslPolicies.Get(%v, %v): called", ctx, key)

	if !key.Valid() {
		klog.V(2).Infof("GCESslPolicies.Get(%v, %v): key is invalid (%#v)", ctx, key, key)
		return nil, fmt.Errorf("invalid GCE key (%#v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "SslPolicies")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Get",
		Version:   meta.Version("ga"),
		Service:   "SslPolicies",
	}
	klog.V(5).Infof("GCESslPolicies.Get(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCESslPolicies.Get(%v, %v): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.GA.SslPolicies.Get(projectID, key.Name)
	call.Context(ctx)
	v, err := call.Do()
	klog.V(4).Infof("GCESslPolicies.Get(%v, %v) = %+v, %v", ctx, key, v, err)
	return v, err
}

// Insert SslPolicy with key of value obj.
func (g *GCESslPolicies) Insert(ctx context.Context, key *meta.Key, obj *ga.SslPolicy) error {
	klog.V(5).Infof("GCESslPolicies.Insert(%v, %v, %+v): called", ctx, key, obj)
	if !key.Valid() {
		klog.V(2).Infof("GCESslPolicies.Insert(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "SslPolicies")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Insert",
		Version:   meta.Version("ga"),
		Service:   "SslPolicies",
	}
	klog.V(5).Infof("GCESslPolicies.Insert(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCESslPolicies.Insert(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	obj.Name = key.Name
	call := g.s.GA.SslPolicies.Insert(projectID, obj)
	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCESslPolicies.Insert(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCESslPolicies.Insert(%v, %v, %+v) = %+v", ctx, key, obj, err)
	return err
}

// Delete the SslPolicy referenced by key.
func (g *GCESslPolicies) Delete(ctx context.Context, key *meta.Key) error {
	klog.V(5).Infof("GCESslPolicies.Delete(%v, %v): called", ctx, key)
	if !key.Valid() {
		klog.V(2).Infof("GCESslPolicies.Delete(%v, %v): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "SslPolicies")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Delete",
		Version:   meta.Version("ga"),
		Service:   "SslPolicies",
	}
	klog.V(5).Infof("GCESslPolicies.Delete(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCESslPolicies.Delete(%v, %v): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.GA.SslPolicies.Delete(projectID, key.Name)

	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCESslPolicies.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCESslPolicies.Delete(%v, %v) = %v", ctx, key, err)
	return err
}

// AlphaSubnetworks is an interface that allows for mocking of Subnetworks.
type AlphaSubnetworks interface {
	Get(ctx context.Context, key *meta.Key) (*alpha.Subnetwork, error)
	List(ctx context.Context, region string, fl *filter.F) ([]*alpha.Subnetwork, error)
	Insert(ctx context.Context, key *meta.Key, obj *alpha.Subnetwork) error
	Delete(ctx context.Context, key *meta.Key) error
	ListUsable(ctx context.Context, fl *filter.F) ([]*alpha.UsableSubnetwork, error)
}

// NewMockAlphaSubnetworks returns a new mock for Subnetworks.
func NewMockAlphaSubnetworks(pr ProjectRouter, objs map[meta.Key]*MockSubnetworksObj) *MockAlphaSubnetworks {
	mock := &MockAlphaSubnetworks{
		ProjectRouter: pr,

		Objects:     objs,
		GetError:    map[meta.Key]error{},
		InsertError: map[meta.Key]error{},
		DeleteError: map[meta.Key]error{},
	}
	return mock
}

// MockAlphaSubnetworks is the mock for Subnetworks.
type MockAlphaSubnetworks struct {
	Lock sync.Mutex

	ProjectRouter ProjectRouter

	// Objects maintained by the mock.
	Objects map[meta.Key]*MockSubnetworksObj

	// If an entry exists for the given key and operation, then the error
	// will be returned instead of the operation.
	GetError        map[meta.Key]error
	ListError       *error
	InsertError     map[meta.Key]error
	DeleteError     map[meta.Key]error
	ListUsableError *error

	// xxxHook allow you to intercept the standard processing of the mock in
	// order to add your own logic. Return (true, _, _) to prevent the normal
	// execution flow of the mock. Return (false, nil, nil) to continue with
	// normal mock behavior/ after the hook function executes.
	GetHook        func(ctx context.Context, key *meta.Key, m *MockAlphaSubnetworks) (bool, *alpha.Subnetwork, error)
	ListHook       func(ctx context.Context, region string, fl *filter.F, m *MockAlphaSubnetworks) (bool, []*alpha.Subnetwork, error)
	InsertHook     func(ctx context.Context, key *meta.Key, obj *alpha.Subnetwork, m *MockAlphaSubnetworks) (bool, error)
	DeleteHook     func(ctx context.Context, key *meta.Key, m *MockAlphaSubnetworks) (bool, error)
	ListUsableHook func(ctx context.Context, fl *filter.F, m *MockAlphaSubnetworks) (bool, []*alpha.UsableSubnetwork, error)

	// X is extra state that can be used as part of the mock. Generated code
	// will not use this field.
	X interface{}
}

// Get returns the object from the mock.
func (m *MockAlphaSubnetworks) Get(ctx context.Context, key *meta.Key) (*alpha.Subnetwork, error) {
	if m.GetHook != nil {
		if intercept, obj, err := m.GetHook(ctx, key, m); intercept {
			klog.V(5).Infof("MockAlphaSubnetworks.Get(%v, %s) = %+v, %v", ctx, key, obj, err)
			return obj, err
		}
	}
	if !key.Valid() {
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.GetError[*key]; ok {
		klog.V(5).Infof("MockAlphaSubnetworks.Get(%v, %s) = nil, %v", ctx, key, err)
		return nil, err
	}
	if obj, ok := m.Objects[*key]; ok {
		typedObj := obj.ToAlpha()
		klog.V(5).Infof("MockAlphaSubnetworks.Get(%v, %s) = %+v, nil", ctx, key, typedObj)
		return typedObj, nil
	}

	err := &googleapi.Error{
		Code:    http.StatusNotFound,
		Message: fmt.Sprintf("MockAlphaSubnetworks %v not found", key),
	}
	klog.V(5).Infof("MockAlphaSubnetworks.Get(%v, %s) = nil, %v", ctx, key, err)
	return nil, err
}

// List all of the objects in the mock in the given region.
func (m *MockAlphaSubnetworks) List(ctx context.Context, region string, fl *filter.F) ([]*alpha.Subnetwork, error) {
	if m.ListHook != nil {
		if intercept, objs, err := m.ListHook(ctx, region, fl, m); intercept {
			klog.V(5).Infof("MockAlphaSubnetworks.List(%v, %q, %v) = [%v items], %v", ctx, region, fl, len(objs), err)
			return objs, err
		}
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if m.ListError != nil {
		err := *m.ListError
		klog.V(5).Infof("MockAlphaSubnetworks.List(%v, %q, %v) = nil, %v", ctx, region, fl, err)

		return nil, *m.ListError
	}

	var objs []*alpha.Subnetwork
	for key, obj := range m.Objects {
		if key.Region != region {
			continue
		}
		if !fl.Match(obj.ToAlpha()) {
			continue
		}
		objs = append(objs, obj.ToAlpha())
	}

	klog.V(5).Infof("MockAlphaSubnetworks.List(%v, %q, %v) = [%v items], nil", ctx, region, fl, len(objs))
	return objs, nil
}

// Insert is a mock for inserting/creating a new object.
func (m *MockAlphaSubnetworks) Insert(ctx context.Context, key *meta.Key, obj *alpha.Subnetwork) error {
	if m.InsertHook != nil {
		if intercept, err := m.InsertHook(ctx, key, obj, m); intercept {
			klog.V(5).Infof("MockAlphaSubnetworks.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.InsertError[*key]; ok {
		klog.V(5).Infof("MockAlphaSubnetworks.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}
	if _, ok := m.Objects[*key]; ok {
		err := &googleapi.Error{
			Code:    http.StatusConflict,
			Message: fmt.Sprintf("MockAlphaSubnetworks %v exists", key),
		}
		klog.V(5).Infof("MockAlphaSubnetworks.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}

	obj.Name = key.Name
	projectID := m.ProjectRouter.ProjectID(ctx, "alpha", "subnetworks")
	obj.SelfLink = SelfLink(meta.VersionAlpha, projectID, "subnetworks", key)

	m.Objects[*key] = &MockSubnetworksObj{obj}
	klog.V(5).Infof("MockAlphaSubnetworks.Insert(%v, %v, %+v) = nil", ctx, key, obj)
	return nil
}

// Delete is a mock for deleting the object.
func (m *MockAlphaSubnetworks) Delete(ctx context.Context, key *meta.Key) error {
	if m.DeleteHook != nil {
		if intercept, err := m.DeleteHook(ctx, key, m); intercept {
			klog.V(5).Infof("MockAlphaSubnetworks.Delete(%v, %v) = %v", ctx, key, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.DeleteError[*key]; ok {
		klog.V(5).Infof("MockAlphaSubnetworks.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}
	if _, ok := m.Objects[*key]; !ok {
		err := &googleapi.Error{
			Code:    http.StatusNotFound,
			Message: fmt.Sprintf("MockAlphaSubnetworks %v not found", key),
		}
		klog.V(5).Infof("MockAlphaSubnetworks.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	delete(m.Objects, *key)
	klog.V(5).Infof("MockAlphaSubnetworks.Delete(%v, %v) = nil", ctx, key)
	return nil
}

// List all of the objects in the mock.
func (m *MockAlphaSubnetworks) ListUsable(ctx context.Context, fl *filter.F) ([]*alpha.UsableSubnetwork, error) {
	if m.ListUsableHook != nil {
		if intercept, objs, err := m.ListUsableHook(ctx, fl, m); intercept {
			klog.V(5).Infof("MockAlphaSubnetworks.ListUsable(%v, %v) = [%v items], %v", ctx, fl, len(objs), err)
			return objs, err
		}
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if m.ListError != nil {
		err := *m.ListError
		klog.V(5).Infof("MockAlphaSubnetworks.ListUsable(%v, %v) = nil, %v", ctx, fl, err)
		return nil, *m.ListError
	}

	var objs []*alpha.UsableSubnetwork

	for _, obj := range m.Objects {
		if !fl.Match(obj.ToAlpha()) {
			continue
		}
		alphaObj := obj.ToAlpha()
		dest := &alpha.UsableSubnetwork{}
		// Convert to Usable type to avoid separate Usable struct
		if err := copyViaJSON(dest, alphaObj); err != nil {
			klog.Errorf("Could not convert %T to *alpha.UsableSubnetwork via JSON: %v", alphaObj, err)
		}
		objs = append(objs, dest)
	}
	klog.V(5).Infof("MockAlphaSubnetworks.ListUsable(%v, %v) = [%v items], nil", ctx, fl, len(objs))
	return objs, nil
}

// Obj wraps the object for use in the mock.
func (m *MockAlphaSubnetworks) Obj(o *alpha.Subnetwork) *MockSubnetworksObj {
	return &MockSubnetworksObj{o}
}

// GCEAlphaSubnetworks is a simplifying adapter for the GCE Subnetworks.
type GCEAlphaSubnetworks struct {
	s *Service
}

// Get the Subnetwork named by key.
func (g *GCEAlphaSubnetworks) Get(ctx context.Context, key *meta.Key) (*alpha.Subnetwork, error) {
	klog.V(5).Infof("GCEAlphaSubnetworks.Get(%v, %v): called", ctx, key)

	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaSubnetworks.Get(%v, %v): key is invalid (%#v)", ctx, key, key)
		return nil, fmt.Errorf("invalid GCE key (%#v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "alpha", "Subnetworks")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Get",
		Version:   meta.Version("alpha"),
		Service:   "Subnetworks",
	}
	klog.V(5).Infof("GCEAlphaSubnetworks.Get(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEAlphaSubnetworks.Get(%v, %v): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.Alpha.Subnetworks.Get(projectID, key.Region, key.Name)
	call.Context(ctx)
	v, err := call.Do()
	klog.V(4).Infof("GCEAlphaSubnetworks.Get(%v, %v) = %+v, %v", ctx, key, v, err)
	return v, err
}

// List all Subnetwork objects.
func (g *GCEAlphaSubnetworks) List(ctx context.Context, region string, fl *filter.F) ([]*alpha.Subnetwork, error) {
	klog.V(5).Infof("GCEAlphaSubnetworks.List(%v, %v, %v) called", ctx, region, fl)
	projectID := g.s.ProjectRouter.ProjectID(ctx, "alpha", "Subnetworks")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "List",
		Version:   meta.Version("alpha"),
		Service:   "Subnetworks",
	}
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		return nil, err
	}
	klog.V(5).Infof("GCEAlphaSubnetworks.List(%v, %v, %v): projectID = %v, rk = %+v", ctx, region, fl, projectID, rk)
	call := g.s.Alpha.Subnetworks.List(projectID, region)
	if fl != filter.None {
		call.Filter(fl.String())
	}
	var all []*alpha.Subnetwork
	f := func(l *alpha.SubnetworkList) error {
		klog.V(5).Infof("GCEAlphaSubnetworks.List(%v, ..., %v): page %+v", ctx, fl, l)
		all = append(all, l.Items...)
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		klog.V(4).Infof("GCEAlphaSubnetworks.List(%v, ..., %v) = %v, %v", ctx, fl, nil, err)
		return nil, err
	}

	if klog.V(4).Enabled() {
		klog.V(4).Infof("GCEAlphaSubnetworks.List(%v, ..., %v) = [%v items], %v", ctx, fl, len(all), nil)
	} else if klog.V(5).Enabled() {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		klog.V(5).Infof("GCEAlphaSubnetworks.List(%v, ..., %v) = %v, %v", ctx, fl, asStr, nil)
	}

	return all, nil
}

// Insert Subnetwork with key of value obj.
func (g *GCEAlphaSubnetworks) Insert(ctx context.Context, key *meta.Key, obj *alpha.Subnetwork) error {
	klog.V(5).Infof("GCEAlphaSubnetworks.Insert(%v, %v, %+v): called", ctx, key, obj)
	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaSubnetworks.Insert(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "alpha", "Subnetworks")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Insert",
		Version:   meta.Version("alpha"),
		Service:   "Subnetworks",
	}
	klog.V(5).Infof("GCEAlphaSubnetworks.Insert(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEAlphaSubnetworks.Insert(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	obj.Name = key.Name
	call := g.s.Alpha.Subnetworks.Insert(projectID, key.Region, obj)
	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCEAlphaSubnetworks.Insert(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEAlphaSubnetworks.Insert(%v, %v, %+v) = %+v", ctx, key, obj, err)
	return err
}

// Delete the Subnetwork referenced by key.
func (g *GCEAlphaSubnetworks) Delete(ctx context.Context, key *meta.Key) error {
	klog.V(5).Infof("GCEAlphaSubnetworks.Delete(%v, %v): called", ctx, key)
	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaSubnetworks.Delete(%v, %v): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "alpha", "Subnetworks")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Delete",
		Version:   meta.Version("alpha"),
		Service:   "Subnetworks",
	}
	klog.V(5).Infof("GCEAlphaSubnetworks.Delete(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEAlphaSubnetworks.Delete(%v, %v): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Alpha.Subnetworks.Delete(projectID, key.Region, key.Name)
	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCEAlphaSubnetworks.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEAlphaSubnetworks.Delete(%v, %v) = %v", ctx, key, err)
	return err
}

// List all Usable Subnetwork objects.
func (g *GCEAlphaSubnetworks) ListUsable(ctx context.Context, fl *filter.F) ([]*alpha.UsableSubnetwork, error) {
	klog.V(5).Infof("GCEAlphaSubnetworks.ListUsable(%v, %v) called", ctx, fl)
	projectID := g.s.ProjectRouter.ProjectID(ctx, "alpha", "Subnetworks")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "ListUsable",
		Version:   meta.Version("alpha"),
		Service:   "Subnetworks",
	}
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		return nil, err
	}
	klog.V(5).Infof("GCEAlphaSubnetworks.ListUsable(%v, %v): projectID = %v, rk = %+v", ctx, fl, projectID, rk)
	call := g.s.Alpha.Subnetworks.ListUsable(projectID)
	if fl != filter.None {
		call.Filter(fl.String())
	}
	var all []*alpha.UsableSubnetwork
	f := func(l *alpha.UsableSubnetworksAggregatedList) error {
		klog.V(5).Infof("GCEAlphaSubnetworks.ListUsable(%v, ..., %v): page %+v", ctx, fl, l)
		all = append(all, l.Items...)
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		klog.V(4).Infof("GCEAlphaSubnetworks.ListUsable(%v, ..., %v) = %v, %v", ctx, fl, nil, err)
		return nil, err
	}

	if klog.V(4).Enabled() {
		klog.V(4).Infof("GCEAlphaSubnetworks.ListUsable(%v, ..., %v) = [%v items], %v", ctx, fl, len(all), nil)
	} else if klog.V(5).Enabled() {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		klog.V(5).Infof("GCEAlphaSubnetworks.ListUsable(%v, ..., %v) = %v, %v", ctx, fl, asStr, nil)
	}

	return all, nil
}

// BetaSubnetworks is an interface that allows for mocking of Subnetworks.
type BetaSubnetworks interface {
	Get(ctx context.Context, key *meta.Key) (*beta.Subnetwork, error)
	List(ctx context.Context, region string, fl *filter.F) ([]*beta.Subnetwork, error)
	Insert(ctx context.Context, key *meta.Key, obj *beta.Subnetwork) error
	Delete(ctx context.Context, key *meta.Key) error
	ListUsable(ctx context.Context, fl *filter.F) ([]*beta.UsableSubnetwork, error)
}

// NewMockBetaSubnetworks returns a new mock for Subnetworks.
func NewMockBetaSubnetworks(pr ProjectRouter, objs map[meta.Key]*MockSubnetworksObj) *MockBetaSubnetworks {
	mock := &MockBetaSubnetworks{
		ProjectRouter: pr,

		Objects:     objs,
		GetError:    map[meta.Key]error{},
		InsertError: map[meta.Key]error{},
		DeleteError: map[meta.Key]error{},
	}
	return mock
}

// MockBetaSubnetworks is the mock for Subnetworks.
type MockBetaSubnetworks struct {
	Lock sync.Mutex

	ProjectRouter ProjectRouter

	// Objects maintained by the mock.
	Objects map[meta.Key]*MockSubnetworksObj

	// If an entry exists for the given key and operation, then the error
	// will be returned instead of the operation.
	GetError        map[meta.Key]error
	ListError       *error
	InsertError     map[meta.Key]error
	DeleteError     map[meta.Key]error
	ListUsableError *error

	// xxxHook allow you to intercept the standard processing of the mock in
	// order to add your own logic. Return (true, _, _) to prevent the normal
	// execution flow of the mock. Return (false, nil, nil) to continue with
	// normal mock behavior/ after the hook function executes.
	GetHook        func(ctx context.Context, key *meta.Key, m *MockBetaSubnetworks) (bool, *beta.Subnetwork, error)
	ListHook       func(ctx context.Context, region string, fl *filter.F, m *MockBetaSubnetworks) (bool, []*beta.Subnetwork, error)
	InsertHook     func(ctx context.Context, key *meta.Key, obj *beta.Subnetwork, m *MockBetaSubnetworks) (bool, error)
	DeleteHook     func(ctx context.Context, key *meta.Key, m *MockBetaSubnetworks) (bool, error)
	ListUsableHook func(ctx context.Context, fl *filter.F, m *MockBetaSubnetworks) (bool, []*beta.UsableSubnetwork, error)

	// X is extra state that can be used as part of the mock. Generated code
	// will not use this field.
	X interface{}
}

// Get returns the object from the mock.
func (m *MockBetaSubnetworks) Get(ctx context.Context, key *meta.Key) (*beta.Subnetwork, error) {
	if m.GetHook != nil {
		if intercept, obj, err := m.GetHook(ctx, key, m); intercept {
			klog.V(5).Infof("MockBetaSubnetworks.Get(%v, %s) = %+v, %v", ctx, key, obj, err)
			return obj, err
		}
	}
	if !key.Valid() {
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.GetError[*key]; ok {
		klog.V(5).Infof("MockBetaSubnetworks.Get(%v, %s) = nil, %v", ctx, key, err)
		return nil, err
	}
	if obj, ok := m.Objects[*key]; ok {
		typedObj := obj.ToBeta()
		klog.V(5).Infof("MockBetaSubnetworks.Get(%v, %s) = %+v, nil", ctx, key, typedObj)
		return typedObj, nil
	}

	err := &googleapi.Error{
		Code:    http.StatusNotFound,
		Message: fmt.Sprintf("MockBetaSubnetworks %v not found", key),
	}
	klog.V(5).Infof("MockBetaSubnetworks.Get(%v, %s) = nil, %v", ctx, key, err)
	return nil, err
}

// List all of the objects in the mock in the given region.
func (m *MockBetaSubnetworks) List(ctx context.Context, region string, fl *filter.F) ([]*beta.Subnetwork, error) {
	if m.ListHook != nil {
		if intercept, objs, err := m.ListHook(ctx, region, fl, m); intercept {
			klog.V(5).Infof("MockBetaSubnetworks.List(%v, %q, %v) = [%v items], %v", ctx, region, fl, len(objs), err)
			return objs, err
		}
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if m.ListError != nil {
		err := *m.ListError
		klog.V(5).Infof("MockBetaSubnetworks.List(%v, %q, %v) = nil, %v", ctx, region, fl, err)

		return nil, *m.ListError
	}

	var objs []*beta.Subnetwork
	for key, obj := range m.Objects {
		if key.Region != region {
			continue
		}
		if !fl.Match(obj.ToBeta()) {
			continue
		}
		objs = append(objs, obj.ToBeta())
	}

	klog.V(5).Infof("MockBetaSubnetworks.List(%v, %q, %v) = [%v items], nil", ctx, region, fl, len(objs))
	return objs, nil
}

// Insert is a mock for inserting/creating a new object.
func (m *MockBetaSubnetworks) Insert(ctx context.Context, key *meta.Key, obj *beta.Subnetwork) error {
	if m.InsertHook != nil {
		if intercept, err := m.InsertHook(ctx, key, obj, m); intercept {
			klog.V(5).Infof("MockBetaSubnetworks.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.InsertError[*key]; ok {
		klog.V(5).Infof("MockBetaSubnetworks.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}
	if _, ok := m.Objects[*key]; ok {
		err := &googleapi.Error{
			Code:    http.StatusConflict,
			Message: fmt.Sprintf("MockBetaSubnetworks %v exists", key),
		}
		klog.V(5).Infof("MockBetaSubnetworks.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}

	obj.Name = key.Name
	projectID := m.ProjectRouter.ProjectID(ctx, "beta", "subnetworks")
	obj.SelfLink = SelfLink(meta.VersionBeta, projectID, "subnetworks", key)

	m.Objects[*key] = &MockSubnetworksObj{obj}
	klog.V(5).Infof("MockBetaSubnetworks.Insert(%v, %v, %+v) = nil", ctx, key, obj)
	return nil
}

// Delete is a mock for deleting the object.
func (m *MockBetaSubnetworks) Delete(ctx context.Context, key *meta.Key) error {
	if m.DeleteHook != nil {
		if intercept, err := m.DeleteHook(ctx, key, m); intercept {
			klog.V(5).Infof("MockBetaSubnetworks.Delete(%v, %v) = %v", ctx, key, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.DeleteError[*key]; ok {
		klog.V(5).Infof("MockBetaSubnetworks.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}
	if _, ok := m.Objects[*key]; !ok {
		err := &googleapi.Error{
			Code:    http.StatusNotFound,
			Message: fmt.Sprintf("MockBetaSubnetworks %v not found", key),
		}
		klog.V(5).Infof("MockBetaSubnetworks.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	delete(m.Objects, *key)
	klog.V(5).Infof("MockBetaSubnetworks.Delete(%v, %v) = nil", ctx, key)
	return nil
}

// List all of the objects in the mock.
func (m *MockBetaSubnetworks) ListUsable(ctx context.Context, fl *filter.F) ([]*beta.UsableSubnetwork, error) {
	if m.ListUsableHook != nil {
		if intercept, objs, err := m.ListUsableHook(ctx, fl, m); intercept {
			klog.V(5).Infof("MockBetaSubnetworks.ListUsable(%v, %v) = [%v items], %v", ctx, fl, len(objs), err)
			return objs, err
		}
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if m.ListError != nil {
		err := *m.ListError
		klog.V(5).Infof("MockBetaSubnetworks.ListUsable(%v, %v) = nil, %v", ctx, fl, err)
		return nil, *m.ListError
	}

	var objs []*beta.UsableSubnetwork

	for _, obj := range m.Objects {
		if !fl.Match(obj.ToBeta()) {
			continue
		}
		betaObj := obj.ToBeta()
		dest := &beta.UsableSubnetwork{}
		// Convert to Usable type to avoid separate Usable struct
		if err := copyViaJSON(dest, betaObj); err != nil {
			klog.Errorf("Could not convert %T to *beta.UsableSubnetwork via JSON: %v", betaObj, err)
		}
		objs = append(objs, dest)
	}
	klog.V(5).Infof("MockBetaSubnetworks.ListUsable(%v, %v) = [%v items], nil", ctx, fl, len(objs))
	return objs, nil
}

// Obj wraps the object for use in the mock.
func (m *MockBetaSubnetworks) Obj(o *beta.Subnetwork) *MockSubnetworksObj {
	return &MockSubnetworksObj{o}
}

// GCEBetaSubnetworks is a simplifying adapter for the GCE Subnetworks.
type GCEBetaSubnetworks struct {
	s *Service
}

// Get the Subnetwork named by key.
func (g *GCEBetaSubnetworks) Get(ctx context.Context, key *meta.Key) (*beta.Subnetwork, error) {
	klog.V(5).Infof("GCEBetaSubnetworks.Get(%v, %v): called", ctx, key)

	if !key.Valid() {
		klog.V(2).Infof("GCEBetaSubnetworks.Get(%v, %v): key is invalid (%#v)", ctx, key, key)
		return nil, fmt.Errorf("invalid GCE key (%#v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "beta", "Subnetworks")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Get",
		Version:   meta.Version("beta"),
		Service:   "Subnetworks",
	}
	klog.V(5).Infof("GCEBetaSubnetworks.Get(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEBetaSubnetworks.Get(%v, %v): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.Beta.Subnetworks.Get(projectID, key.Region, key.Name)
	call.Context(ctx)
	v, err := call.Do()
	klog.V(4).Infof("GCEBetaSubnetworks.Get(%v, %v) = %+v, %v", ctx, key, v, err)
	return v, err
}

// List all Subnetwork objects.
func (g *GCEBetaSubnetworks) List(ctx context.Context, region string, fl *filter.F) ([]*beta.Subnetwork, error) {
	klog.V(5).Infof("GCEBetaSubnetworks.List(%v, %v, %v) called", ctx, region, fl)
	projectID := g.s.ProjectRouter.ProjectID(ctx, "beta", "Subnetworks")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "List",
		Version:   meta.Version("beta"),
		Service:   "Subnetworks",
	}
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		return nil, err
	}
	klog.V(5).Infof("GCEBetaSubnetworks.List(%v, %v, %v): projectID = %v, rk = %+v", ctx, region, fl, projectID, rk)
	call := g.s.Beta.Subnetworks.List(projectID, region)
	if fl != filter.None {
		call.Filter(fl.String())
	}
	var all []*beta.Subnetwork
	f := func(l *beta.SubnetworkList) error {
		klog.V(5).Infof("GCEBetaSubnetworks.List(%v, ..., %v): page %+v", ctx, fl, l)
		all = append(all, l.Items...)
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		klog.V(4).Infof("GCEBetaSubnetworks.List(%v, ..., %v) = %v, %v", ctx, fl, nil, err)
		return nil, err
	}

	if klog.V(4).Enabled() {
		klog.V(4).Infof("GCEBetaSubnetworks.List(%v, ..., %v) = [%v items], %v", ctx, fl, len(all), nil)
	} else if klog.V(5).Enabled() {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		klog.V(5).Infof("GCEBetaSubnetworks.List(%v, ..., %v) = %v, %v", ctx, fl, asStr, nil)
	}

	return all, nil
}

// Insert Subnetwork with key of value obj.
func (g *GCEBetaSubnetworks) Insert(ctx context.Context, key *meta.Key, obj *beta.Subnetwork) error {
	klog.V(5).Infof("GCEBetaSubnetworks.Insert(%v, %v, %+v): called", ctx, key, obj)
	if !key.Valid() {
		klog.V(2).Infof("GCEBetaSubnetworks.Insert(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "beta", "Subnetworks")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Insert",
		Version:   meta.Version("beta"),
		Service:   "Subnetworks",
	}
	klog.V(5).Infof("GCEBetaSubnetworks.Insert(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEBetaSubnetworks.Insert(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	obj.Name = key.Name
	call := g.s.Beta.Subnetworks.Insert(projectID, key.Region, obj)
	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCEBetaSubnetworks.Insert(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEBetaSubnetworks.Insert(%v, %v, %+v) = %+v", ctx, key, obj, err)
	return err
}

// Delete the Subnetwork referenced by key.
func (g *GCEBetaSubnetworks) Delete(ctx context.Context, key *meta.Key) error {
	klog.V(5).Infof("GCEBetaSubnetworks.Delete(%v, %v): called", ctx, key)
	if !key.Valid() {
		klog.V(2).Infof("GCEBetaSubnetworks.Delete(%v, %v): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "beta", "Subnetworks")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Delete",
		Version:   meta.Version("beta"),
		Service:   "Subnetworks",
	}
	klog.V(5).Infof("GCEBetaSubnetworks.Delete(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEBetaSubnetworks.Delete(%v, %v): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Beta.Subnetworks.Delete(projectID, key.Region, key.Name)
	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCEBetaSubnetworks.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEBetaSubnetworks.Delete(%v, %v) = %v", ctx, key, err)
	return err
}

// List all Usable Subnetwork objects.
func (g *GCEBetaSubnetworks) ListUsable(ctx context.Context, fl *filter.F) ([]*beta.UsableSubnetwork, error) {
	klog.V(5).Infof("GCEBetaSubnetworks.ListUsable(%v, %v) called", ctx, fl)
	projectID := g.s.ProjectRouter.ProjectID(ctx, "beta", "Subnetworks")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "ListUsable",
		Version:   meta.Version("beta"),
		Service:   "Subnetworks",
	}
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		return nil, err
	}
	klog.V(5).Infof("GCEBetaSubnetworks.ListUsable(%v, %v): projectID = %v, rk = %+v", ctx, fl, projectID, rk)
	call := g.s.Beta.Subnetworks.ListUsable(projectID)
	if fl != filter.None {
		call.Filter(fl.String())
	}
	var all []*beta.UsableSubnetwork
	f := func(l *beta.UsableSubnetworksAggregatedList) error {
		klog.V(5).Infof("GCEBetaSubnetworks.ListUsable(%v, ..., %v): page %+v", ctx, fl, l)
		all = append(all, l.Items...)
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		klog.V(4).Infof("GCEBetaSubnetworks.ListUsable(%v, ..., %v) = %v, %v", ctx, fl, nil, err)
		return nil, err
	}

	if klog.V(4).Enabled() {
		klog.V(4).Infof("GCEBetaSubnetworks.ListUsable(%v, ..., %v) = [%v items], %v", ctx, fl, len(all), nil)
	} else if klog.V(5).Enabled() {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		klog.V(5).Infof("GCEBetaSubnetworks.ListUsable(%v, ..., %v) = %v, %v", ctx, fl, asStr, nil)
	}

	return all, nil
}

// Subnetworks is an interface that allows for mocking of Subnetworks.
type Subnetworks interface {
	Get(ctx context.Context, key *meta.Key) (*ga.Subnetwork, error)
	List(ctx context.Context, region string, fl *filter.F) ([]*ga.Subnetwork, error)
	Insert(ctx context.Context, key *meta.Key, obj *ga.Subnetwork) error
	Delete(ctx context.Context, key *meta.Key) error
	ListUsable(ctx context.Context, fl *filter.F) ([]*ga.UsableSubnetwork, error)
}

// NewMockSubnetworks returns a new mock for Subnetworks.
func NewMockSubnetworks(pr ProjectRouter, objs map[meta.Key]*MockSubnetworksObj) *MockSubnetworks {
	mock := &MockSubnetworks{
		ProjectRouter: pr,

		Objects:     objs,
		GetError:    map[meta.Key]error{},
		InsertError: map[meta.Key]error{},
		DeleteError: map[meta.Key]error{},
	}
	return mock
}

// MockSubnetworks is the mock for Subnetworks.
type MockSubnetworks struct {
	Lock sync.Mutex

	ProjectRouter ProjectRouter

	// Objects maintained by the mock.
	Objects map[meta.Key]*MockSubnetworksObj

	// If an entry exists for the given key and operation, then the error
	// will be returned instead of the operation.
	GetError        map[meta.Key]error
	ListError       *error
	InsertError     map[meta.Key]error
	DeleteError     map[meta.Key]error
	ListUsableError *error

	// xxxHook allow you to intercept the standard processing of the mock in
	// order to add your own logic. Return (true, _, _) to prevent the normal
	// execution flow of the mock. Return (false, nil, nil) to continue with
	// normal mock behavior/ after the hook function executes.
	GetHook        func(ctx context.Context, key *meta.Key, m *MockSubnetworks) (bool, *ga.Subnetwork, error)
	ListHook       func(ctx context.Context, region string, fl *filter.F, m *MockSubnetworks) (bool, []*ga.Subnetwork, error)
	InsertHook     func(ctx context.Context, key *meta.Key, obj *ga.Subnetwork, m *MockSubnetworks) (bool, error)
	DeleteHook     func(ctx context.Context, key *meta.Key, m *MockSubnetworks) (bool, error)
	ListUsableHook func(ctx context.Context, fl *filter.F, m *MockSubnetworks) (bool, []*ga.UsableSubnetwork, error)

	// X is extra state that can be used as part of the mock. Generated code
	// will not use this field.
	X interface{}
}

// Get returns the object from the mock.
func (m *MockSubnetworks) Get(ctx context.Context, key *meta.Key) (*ga.Subnetwork, error) {
	if m.GetHook != nil {
		if intercept, obj, err := m.GetHook(ctx, key, m); intercept {
			klog.V(5).Infof("MockSubnetworks.Get(%v, %s) = %+v, %v", ctx, key, obj, err)
			return obj, err
		}
	}
	if !key.Valid() {
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.GetError[*key]; ok {
		klog.V(5).Infof("MockSubnetworks.Get(%v, %s) = nil, %v", ctx, key, err)
		return nil, err
	}
	if obj, ok := m.Objects[*key]; ok {
		typedObj := obj.ToGA()
		klog.V(5).Infof("MockSubnetworks.Get(%v, %s) = %+v, nil", ctx, key, typedObj)
		return typedObj, nil
	}

	err := &googleapi.Error{
		Code:    http.StatusNotFound,
		Message: fmt.Sprintf("MockSubnetworks %v not found", key),
	}
	klog.V(5).Infof("MockSubnetworks.Get(%v, %s) = nil, %v", ctx, key, err)
	return nil, err
}

// List all of the objects in the mock in the given region.
func (m *MockSubnetworks) List(ctx context.Context, region string, fl *filter.F) ([]*ga.Subnetwork, error) {
	if m.ListHook != nil {
		if intercept, objs, err := m.ListHook(ctx, region, fl, m); intercept {
			klog.V(5).Infof("MockSubnetworks.List(%v, %q, %v) = [%v items], %v", ctx, region, fl, len(objs), err)
			return objs, err
		}
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if m.ListError != nil {
		err := *m.ListError
		klog.V(5).Infof("MockSubnetworks.List(%v, %q, %v) = nil, %v", ctx, region, fl, err)

		return nil, *m.ListError
	}

	var objs []*ga.Subnetwork
	for key, obj := range m.Objects {
		if key.Region != region {
			continue
		}
		if !fl.Match(obj.ToGA()) {
			continue
		}
		objs = append(objs, obj.ToGA())
	}

	klog.V(5).Infof("MockSubnetworks.List(%v, %q, %v) = [%v items], nil", ctx, region, fl, len(objs))
	return objs, nil
}

// Insert is a mock for inserting/creating a new object.
func (m *MockSubnetworks) Insert(ctx context.Context, key *meta.Key, obj *ga.Subnetwork) error {
	if m.InsertHook != nil {
		if intercept, err := m.InsertHook(ctx, key, obj, m); intercept {
			klog.V(5).Infof("MockSubnetworks.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.InsertError[*key]; ok {
		klog.V(5).Infof("MockSubnetworks.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}
	if _, ok := m.Objects[*key]; ok {
		err := &googleapi.Error{
			Code:    http.StatusConflict,
			Message: fmt.Sprintf("MockSubnetworks %v exists", key),
		}
		klog.V(5).Infof("MockSubnetworks.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}

	obj.Name = key.Name
	projectID := m.ProjectRouter.ProjectID(ctx, "ga", "subnetworks")
	obj.SelfLink = SelfLink(meta.VersionGA, projectID, "subnetworks", key)

	m.Objects[*key] = &MockSubnetworksObj{obj}
	klog.V(5).Infof("MockSubnetworks.Insert(%v, %v, %+v) = nil", ctx, key, obj)
	return nil
}

// Delete is a mock for deleting the object.
func (m *MockSubnetworks) Delete(ctx context.Context, key *meta.Key) error {
	if m.DeleteHook != nil {
		if intercept, err := m.DeleteHook(ctx, key, m); intercept {
			klog.V(5).Infof("MockSubnetworks.Delete(%v, %v) = %v", ctx, key, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.DeleteError[*key]; ok {
		klog.V(5).Infof("MockSubnetworks.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}
	if _, ok := m.Objects[*key]; !ok {
		err := &googleapi.Error{
			Code:    http.StatusNotFound,
			Message: fmt.Sprintf("MockSubnetworks %v not found", key),
		}
		klog.V(5).Infof("MockSubnetworks.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	delete(m.Objects, *key)
	klog.V(5).Infof("MockSubnetworks.Delete(%v, %v) = nil", ctx, key)
	return nil
}

// List all of the objects in the mock.
func (m *MockSubnetworks) ListUsable(ctx context.Context, fl *filter.F) ([]*ga.UsableSubnetwork, error) {
	if m.ListUsableHook != nil {
		if intercept, objs, err := m.ListUsableHook(ctx, fl, m); intercept {
			klog.V(5).Infof("MockSubnetworks.ListUsable(%v, %v) = [%v items], %v", ctx, fl, len(objs), err)
			return objs, err
		}
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if m.ListError != nil {
		err := *m.ListError
		klog.V(5).Infof("MockSubnetworks.ListUsable(%v, %v) = nil, %v", ctx, fl, err)
		return nil, *m.ListError
	}

	var objs []*ga.UsableSubnetwork

	for _, obj := range m.Objects {
		if !fl.Match(obj.ToGA()) {
			continue
		}
		gaObj := obj.ToGA()
		dest := &ga.UsableSubnetwork{}
		// Convert to Usable type to avoid separate Usable struct
		if err := copyViaJSON(dest, gaObj); err != nil {
			klog.Errorf("Could not convert %T to *ga.UsableSubnetwork via JSON: %v", gaObj, err)
		}
		objs = append(objs, dest)
	}
	klog.V(5).Infof("MockSubnetworks.ListUsable(%v, %v) = [%v items], nil", ctx, fl, len(objs))
	return objs, nil
}

// Obj wraps the object for use in the mock.
func (m *MockSubnetworks) Obj(o *ga.Subnetwork) *MockSubnetworksObj {
	return &MockSubnetworksObj{o}
}

// GCESubnetworks is a simplifying adapter for the GCE Subnetworks.
type GCESubnetworks struct {
	s *Service
}

// Get the Subnetwork named by key.
func (g *GCESubnetworks) Get(ctx context.Context, key *meta.Key) (*ga.Subnetwork, error) {
	klog.V(5).Infof("GCESubnetworks.Get(%v, %v): called", ctx, key)

	if !key.Valid() {
		klog.V(2).Infof("GCESubnetworks.Get(%v, %v): key is invalid (%#v)", ctx, key, key)
		return nil, fmt.Errorf("invalid GCE key (%#v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "Subnetworks")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Get",
		Version:   meta.Version("ga"),
		Service:   "Subnetworks",
	}
	klog.V(5).Infof("GCESubnetworks.Get(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCESubnetworks.Get(%v, %v): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.GA.Subnetworks.Get(projectID, key.Region, key.Name)
	call.Context(ctx)
	v, err := call.Do()
	klog.V(4).Infof("GCESubnetworks.Get(%v, %v) = %+v, %v", ctx, key, v, err)
	return v, err
}

// List all Subnetwork objects.
func (g *GCESubnetworks) List(ctx context.Context, region string, fl *filter.F) ([]*ga.Subnetwork, error) {
	klog.V(5).Infof("GCESubnetworks.List(%v, %v, %v) called", ctx, region, fl)
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "Subnetworks")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "List",
		Version:   meta.Version("ga"),
		Service:   "Subnetworks",
	}
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		return nil, err
	}
	klog.V(5).Infof("GCESubnetworks.List(%v, %v, %v): projectID = %v, rk = %+v", ctx, region, fl, projectID, rk)
	call := g.s.GA.Subnetworks.List(projectID, region)
	if fl != filter.None {
		call.Filter(fl.String())
	}
	var all []*ga.Subnetwork
	f := func(l *ga.SubnetworkList) error {
		klog.V(5).Infof("GCESubnetworks.List(%v, ..., %v): page %+v", ctx, fl, l)
		all = append(all, l.Items...)
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		klog.V(4).Infof("GCESubnetworks.List(%v, ..., %v) = %v, %v", ctx, fl, nil, err)
		return nil, err
	}

	if klog.V(4).Enabled() {
		klog.V(4).Infof("GCESubnetworks.List(%v, ..., %v) = [%v items], %v", ctx, fl, len(all), nil)
	} else if klog.V(5).Enabled() {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		klog.V(5).Infof("GCESubnetworks.List(%v, ..., %v) = %v, %v", ctx, fl, asStr, nil)
	}

	return all, nil
}

// Insert Subnetwork with key of value obj.
func (g *GCESubnetworks) Insert(ctx context.Context, key *meta.Key, obj *ga.Subnetwork) error {
	klog.V(5).Infof("GCESubnetworks.Insert(%v, %v, %+v): called", ctx, key, obj)
	if !key.Valid() {
		klog.V(2).Infof("GCESubnetworks.Insert(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "Subnetworks")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Insert",
		Version:   meta.Version("ga"),
		Service:   "Subnetworks",
	}
	klog.V(5).Infof("GCESubnetworks.Insert(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCESubnetworks.Insert(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	obj.Name = key.Name
	call := g.s.GA.Subnetworks.Insert(projectID, key.Region, obj)
	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCESubnetworks.Insert(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCESubnetworks.Insert(%v, %v, %+v) = %+v", ctx, key, obj, err)
	return err
}

// Delete the Subnetwork referenced by key.
func (g *GCESubnetworks) Delete(ctx context.Context, key *meta.Key) error {
	klog.V(5).Infof("GCESubnetworks.Delete(%v, %v): called", ctx, key)
	if !key.Valid() {
		klog.V(2).Infof("GCESubnetworks.Delete(%v, %v): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "Subnetworks")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Delete",
		Version:   meta.Version("ga"),
		Service:   "Subnetworks",
	}
	klog.V(5).Infof("GCESubnetworks.Delete(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCESubnetworks.Delete(%v, %v): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.GA.Subnetworks.Delete(projectID, key.Region, key.Name)
	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCESubnetworks.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCESubnetworks.Delete(%v, %v) = %v", ctx, key, err)
	return err
}

// List all Usable Subnetwork objects.
func (g *GCESubnetworks) ListUsable(ctx context.Context, fl *filter.F) ([]*ga.UsableSubnetwork, error) {
	klog.V(5).Infof("GCESubnetworks.ListUsable(%v, %v) called", ctx, fl)
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "Subnetworks")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "ListUsable",
		Version:   meta.Version("ga"),
		Service:   "Subnetworks",
	}
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		return nil, err
	}
	klog.V(5).Infof("GCESubnetworks.ListUsable(%v, %v): projectID = %v, rk = %+v", ctx, fl, projectID, rk)
	call := g.s.GA.Subnetworks.ListUsable(projectID)
	if fl != filter.None {
		call.Filter(fl.String())
	}
	var all []*ga.UsableSubnetwork
	f := func(l *ga.UsableSubnetworksAggregatedList) error {
		klog.V(5).Infof("GCESubnetworks.ListUsable(%v, ..., %v): page %+v", ctx, fl, l)
		all = append(all, l.Items...)
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		klog.V(4).Infof("GCESubnetworks.ListUsable(%v, ..., %v) = %v, %v", ctx, fl, nil, err)
		return nil, err
	}

	if klog.V(4).Enabled() {
		klog.V(4).Infof("GCESubnetworks.ListUsable(%v, ..., %v) = [%v items], %v", ctx, fl, len(all), nil)
	} else if klog.V(5).Enabled() {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		klog.V(5).Infof("GCESubnetworks.ListUsable(%v, ..., %v) = %v, %v", ctx, fl, asStr, nil)
	}

	return all, nil
}

// AlphaTargetHttpProxies is an interface that allows for mocking of TargetHttpProxies.
type AlphaTargetHttpProxies interface {
	Get(ctx context.Context, key *meta.Key) (*alpha.TargetHttpProxy, error)
	List(ctx context.Context, fl *filter.F) ([]*alpha.TargetHttpProxy, error)
	Insert(ctx context.Context, key *meta.Key, obj *alpha.TargetHttpProxy) error
	Delete(ctx context.Context, key *meta.Key) error
	SetUrlMap(context.Context, *meta.Key, *alpha.UrlMapReference) error
}

// NewMockAlphaTargetHttpProxies returns a new mock for TargetHttpProxies.
func NewMockAlphaTargetHttpProxies(pr ProjectRouter, objs map[meta.Key]*MockTargetHttpProxiesObj) *MockAlphaTargetHttpProxies {
	mock := &MockAlphaTargetHttpProxies{
		ProjectRouter: pr,

		Objects:     objs,
		GetError:    map[meta.Key]error{},
		InsertError: map[meta.Key]error{},
		DeleteError: map[meta.Key]error{},
	}
	return mock
}

// MockAlphaTargetHttpProxies is the mock for TargetHttpProxies.
type MockAlphaTargetHttpProxies struct {
	Lock sync.Mutex

	ProjectRouter ProjectRouter

	// Objects maintained by the mock.
	Objects map[meta.Key]*MockTargetHttpProxiesObj

	// If an entry exists for the given key and operation, then the error
	// will be returned instead of the operation.
	GetError    map[meta.Key]error
	ListError   *error
	InsertError map[meta.Key]error
	DeleteError map[meta.Key]error

	// xxxHook allow you to intercept the standard processing of the mock in
	// order to add your own logic. Return (true, _, _) to prevent the normal
	// execution flow of the mock. Return (false, nil, nil) to continue with
	// normal mock behavior/ after the hook function executes.
	GetHook       func(ctx context.Context, key *meta.Key, m *MockAlphaTargetHttpProxies) (bool, *alpha.TargetHttpProxy, error)
	ListHook      func(ctx context.Context, fl *filter.F, m *MockAlphaTargetHttpProxies) (bool, []*alpha.TargetHttpProxy, error)
	InsertHook    func(ctx context.Context, key *meta.Key, obj *alpha.TargetHttpProxy, m *MockAlphaTargetHttpProxies) (bool, error)
	DeleteHook    func(ctx context.Context, key *meta.Key, m *MockAlphaTargetHttpProxies) (bool, error)
	SetUrlMapHook func(context.Context, *meta.Key, *alpha.UrlMapReference, *MockAlphaTargetHttpProxies) error

	// X is extra state that can be used as part of the mock. Generated code
	// will not use this field.
	X interface{}
}

// Get returns the object from the mock.
func (m *MockAlphaTargetHttpProxies) Get(ctx context.Context, key *meta.Key) (*alpha.TargetHttpProxy, error) {
	if m.GetHook != nil {
		if intercept, obj, err := m.GetHook(ctx, key, m); intercept {
			klog.V(5).Infof("MockAlphaTargetHttpProxies.Get(%v, %s) = %+v, %v", ctx, key, obj, err)
			return obj, err
		}
	}
	if !key.Valid() {
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.GetError[*key]; ok {
		klog.V(5).Infof("MockAlphaTargetHttpProxies.Get(%v, %s) = nil, %v", ctx, key, err)
		return nil, err
	}
	if obj, ok := m.Objects[*key]; ok {
		typedObj := obj.ToAlpha()
		klog.V(5).Infof("MockAlphaTargetHttpProxies.Get(%v, %s) = %+v, nil", ctx, key, typedObj)
		return typedObj, nil
	}

	err := &googleapi.Error{
		Code:    http.StatusNotFound,
		Message: fmt.Sprintf("MockAlphaTargetHttpProxies %v not found", key),
	}
	klog.V(5).Infof("MockAlphaTargetHttpProxies.Get(%v, %s) = nil, %v", ctx, key, err)
	return nil, err
}

// List all of the objects in the mock.
func (m *MockAlphaTargetHttpProxies) List(ctx context.Context, fl *filter.F) ([]*alpha.TargetHttpProxy, error) {
	if m.ListHook != nil {
		if intercept, objs, err := m.ListHook(ctx, fl, m); intercept {
			klog.V(5).Infof("MockAlphaTargetHttpProxies.List(%v, %v) = [%v items], %v", ctx, fl, len(objs), err)
			return objs, err
		}
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if m.ListError != nil {
		err := *m.ListError
		klog.V(5).Infof("MockAlphaTargetHttpProxies.List(%v, %v) = nil, %v", ctx, fl, err)

		return nil, *m.ListError
	}

	var objs []*alpha.TargetHttpProxy
	for _, obj := range m.Objects {
		if !fl.Match(obj.ToAlpha()) {
			continue
		}
		objs = append(objs, obj.ToAlpha())
	}

	klog.V(5).Infof("MockAlphaTargetHttpProxies.List(%v, %v) = [%v items], nil", ctx, fl, len(objs))
	return objs, nil
}

// Insert is a mock for inserting/creating a new object.
func (m *MockAlphaTargetHttpProxies) Insert(ctx context.Context, key *meta.Key, obj *alpha.TargetHttpProxy) error {
	if m.InsertHook != nil {
		if intercept, err := m.InsertHook(ctx, key, obj, m); intercept {
			klog.V(5).Infof("MockAlphaTargetHttpProxies.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.InsertError[*key]; ok {
		klog.V(5).Infof("MockAlphaTargetHttpProxies.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}
	if _, ok := m.Objects[*key]; ok {
		err := &googleapi.Error{
			Code:    http.StatusConflict,
			Message: fmt.Sprintf("MockAlphaTargetHttpProxies %v exists", key),
		}
		klog.V(5).Infof("MockAlphaTargetHttpProxies.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}

	obj.Name = key.Name
	projectID := m.ProjectRouter.ProjectID(ctx, "alpha", "targetHttpProxies")
	obj.SelfLink = SelfLink(meta.VersionAlpha, projectID, "targetHttpProxies", key)

	m.Objects[*key] = &MockTargetHttpProxiesObj{obj}
	klog.V(5).Infof("MockAlphaTargetHttpProxies.Insert(%v, %v, %+v) = nil", ctx, key, obj)
	return nil
}

// Delete is a mock for deleting the object.
func (m *MockAlphaTargetHttpProxies) Delete(ctx context.Context, key *meta.Key) error {
	if m.DeleteHook != nil {
		if intercept, err := m.DeleteHook(ctx, key, m); intercept {
			klog.V(5).Infof("MockAlphaTargetHttpProxies.Delete(%v, %v) = %v", ctx, key, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.DeleteError[*key]; ok {
		klog.V(5).Infof("MockAlphaTargetHttpProxies.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}
	if _, ok := m.Objects[*key]; !ok {
		err := &googleapi.Error{
			Code:    http.StatusNotFound,
			Message: fmt.Sprintf("MockAlphaTargetHttpProxies %v not found", key),
		}
		klog.V(5).Infof("MockAlphaTargetHttpProxies.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	delete(m.Objects, *key)
	klog.V(5).Infof("MockAlphaTargetHttpProxies.Delete(%v, %v) = nil", ctx, key)
	return nil
}

// Obj wraps the object for use in the mock.
func (m *MockAlphaTargetHttpProxies) Obj(o *alpha.TargetHttpProxy) *MockTargetHttpProxiesObj {
	return &MockTargetHttpProxiesObj{o}
}

// SetUrlMap is a mock for the corresponding method.
func (m *MockAlphaTargetHttpProxies) SetUrlMap(ctx context.Context, key *meta.Key, arg0 *alpha.UrlMapReference) error {
	if m.SetUrlMapHook != nil {
		return m.SetUrlMapHook(ctx, key, arg0, m)
	}
	return nil
}

// GCEAlphaTargetHttpProxies is a simplifying adapter for the GCE TargetHttpProxies.
type GCEAlphaTargetHttpProxies struct {
	s *Service
}

// Get the TargetHttpProxy named by key.
func (g *GCEAlphaTargetHttpProxies) Get(ctx context.Context, key *meta.Key) (*alpha.TargetHttpProxy, error) {
	klog.V(5).Infof("GCEAlphaTargetHttpProxies.Get(%v, %v): called", ctx, key)

	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaTargetHttpProxies.Get(%v, %v): key is invalid (%#v)", ctx, key, key)
		return nil, fmt.Errorf("invalid GCE key (%#v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "alpha", "TargetHttpProxies")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Get",
		Version:   meta.Version("alpha"),
		Service:   "TargetHttpProxies",
	}
	klog.V(5).Infof("GCEAlphaTargetHttpProxies.Get(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEAlphaTargetHttpProxies.Get(%v, %v): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.Alpha.TargetHttpProxies.Get(projectID, key.Name)
	call.Context(ctx)
	v, err := call.Do()
	klog.V(4).Infof("GCEAlphaTargetHttpProxies.Get(%v, %v) = %+v, %v", ctx, key, v, err)
	return v, err
}

// List all TargetHttpProxy objects.
func (g *GCEAlphaTargetHttpProxies) List(ctx context.Context, fl *filter.F) ([]*alpha.TargetHttpProxy, error) {
	klog.V(5).Infof("GCEAlphaTargetHttpProxies.List(%v, %v) called", ctx, fl)
	projectID := g.s.ProjectRouter.ProjectID(ctx, "alpha", "TargetHttpProxies")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "List",
		Version:   meta.Version("alpha"),
		Service:   "TargetHttpProxies",
	}
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		return nil, err
	}
	klog.V(5).Infof("GCEAlphaTargetHttpProxies.List(%v, %v): projectID = %v, rk = %+v", ctx, fl, projectID, rk)
	call := g.s.Alpha.TargetHttpProxies.List(projectID)
	if fl != filter.None {
		call.Filter(fl.String())
	}
	var all []*alpha.TargetHttpProxy
	f := func(l *alpha.TargetHttpProxyList) error {
		klog.V(5).Infof("GCEAlphaTargetHttpProxies.List(%v, ..., %v): page %+v", ctx, fl, l)
		all = append(all, l.Items...)
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		klog.V(4).Infof("GCEAlphaTargetHttpProxies.List(%v, ..., %v) = %v, %v", ctx, fl, nil, err)
		return nil, err
	}

	if klog.V(4).Enabled() {
		klog.V(4).Infof("GCEAlphaTargetHttpProxies.List(%v, ..., %v) = [%v items], %v", ctx, fl, len(all), nil)
	} else if klog.V(5).Enabled() {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		klog.V(5).Infof("GCEAlphaTargetHttpProxies.List(%v, ..., %v) = %v, %v", ctx, fl, asStr, nil)
	}

	return all, nil
}

// Insert TargetHttpProxy with key of value obj.
func (g *GCEAlphaTargetHttpProxies) Insert(ctx context.Context, key *meta.Key, obj *alpha.TargetHttpProxy) error {
	klog.V(5).Infof("GCEAlphaTargetHttpProxies.Insert(%v, %v, %+v): called", ctx, key, obj)
	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaTargetHttpProxies.Insert(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "alpha", "TargetHttpProxies")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Insert",
		Version:   meta.Version("alpha"),
		Service:   "TargetHttpProxies",
	}
	klog.V(5).Infof("GCEAlphaTargetHttpProxies.Insert(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEAlphaTargetHttpProxies.Insert(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	obj.Name = key.Name
	call := g.s.Alpha.TargetHttpProxies.Insert(projectID, obj)
	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCEAlphaTargetHttpProxies.Insert(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEAlphaTargetHttpProxies.Insert(%v, %v, %+v) = %+v", ctx, key, obj, err)
	return err
}

// Delete the TargetHttpProxy referenced by key.
func (g *GCEAlphaTargetHttpProxies) Delete(ctx context.Context, key *meta.Key) error {
	klog.V(5).Infof("GCEAlphaTargetHttpProxies.Delete(%v, %v): called", ctx, key)
	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaTargetHttpProxies.Delete(%v, %v): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "alpha", "TargetHttpProxies")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Delete",
		Version:   meta.Version("alpha"),
		Service:   "TargetHttpProxies",
	}
	klog.V(5).Infof("GCEAlphaTargetHttpProxies.Delete(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEAlphaTargetHttpProxies.Delete(%v, %v): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Alpha.TargetHttpProxies.Delete(projectID, key.Name)

	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCEAlphaTargetHttpProxies.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEAlphaTargetHttpProxies.Delete(%v, %v) = %v", ctx, key, err)
	return err
}

// SetUrlMap is a method on GCEAlphaTargetHttpProxies.
func (g *GCEAlphaTargetHttpProxies) SetUrlMap(ctx context.Context, key *meta.Key, arg0 *alpha.UrlMapReference) error {
	klog.V(5).Infof("GCEAlphaTargetHttpProxies.SetUrlMap(%v, %v, ...): called", ctx, key)

	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaTargetHttpProxies.SetUrlMap(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "alpha", "TargetHttpProxies")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "SetUrlMap",
		Version:   meta.Version("alpha"),
		Service:   "TargetHttpProxies",
	}
	klog.V(5).Infof("GCEAlphaTargetHttpProxies.SetUrlMap(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)

	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEAlphaTargetHttpProxies.SetUrlMap(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Alpha.TargetHttpProxies.SetUrlMap(projectID, key.Name, arg0)
	call.Context(ctx)
	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCEAlphaTargetHttpProxies.SetUrlMap(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}
	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEAlphaTargetHttpProxies.SetUrlMap(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// BetaTargetHttpProxies is an interface that allows for mocking of TargetHttpProxies.
type BetaTargetHttpProxies interface {
	Get(ctx context.Context, key *meta.Key) (*beta.TargetHttpProxy, error)
	List(ctx context.Context, fl *filter.F) ([]*beta.TargetHttpProxy, error)
	Insert(ctx context.Context, key *meta.Key, obj *beta.TargetHttpProxy) error
	Delete(ctx context.Context, key *meta.Key) error
	SetUrlMap(context.Context, *meta.Key, *beta.UrlMapReference) error
}

// NewMockBetaTargetHttpProxies returns a new mock for TargetHttpProxies.
func NewMockBetaTargetHttpProxies(pr ProjectRouter, objs map[meta.Key]*MockTargetHttpProxiesObj) *MockBetaTargetHttpProxies {
	mock := &MockBetaTargetHttpProxies{
		ProjectRouter: pr,

		Objects:     objs,
		GetError:    map[meta.Key]error{},
		InsertError: map[meta.Key]error{},
		DeleteError: map[meta.Key]error{},
	}
	return mock
}

// MockBetaTargetHttpProxies is the mock for TargetHttpProxies.
type MockBetaTargetHttpProxies struct {
	Lock sync.Mutex

	ProjectRouter ProjectRouter

	// Objects maintained by the mock.
	Objects map[meta.Key]*MockTargetHttpProxiesObj

	// If an entry exists for the given key and operation, then the error
	// will be returned instead of the operation.
	GetError    map[meta.Key]error
	ListError   *error
	InsertError map[meta.Key]error
	DeleteError map[meta.Key]error

	// xxxHook allow you to intercept the standard processing of the mock in
	// order to add your own logic. Return (true, _, _) to prevent the normal
	// execution flow of the mock. Return (false, nil, nil) to continue with
	// normal mock behavior/ after the hook function executes.
	GetHook       func(ctx context.Context, key *meta.Key, m *MockBetaTargetHttpProxies) (bool, *beta.TargetHttpProxy, error)
	ListHook      func(ctx context.Context, fl *filter.F, m *MockBetaTargetHttpProxies) (bool, []*beta.TargetHttpProxy, error)
	InsertHook    func(ctx context.Context, key *meta.Key, obj *beta.TargetHttpProxy, m *MockBetaTargetHttpProxies) (bool, error)
	DeleteHook    func(ctx context.Context, key *meta.Key, m *MockBetaTargetHttpProxies) (bool, error)
	SetUrlMapHook func(context.Context, *meta.Key, *beta.UrlMapReference, *MockBetaTargetHttpProxies) error

	// X is extra state that can be used as part of the mock. Generated code
	// will not use this field.
	X interface{}
}

// Get returns the object from the mock.
func (m *MockBetaTargetHttpProxies) Get(ctx context.Context, key *meta.Key) (*beta.TargetHttpProxy, error) {
	if m.GetHook != nil {
		if intercept, obj, err := m.GetHook(ctx, key, m); intercept {
			klog.V(5).Infof("MockBetaTargetHttpProxies.Get(%v, %s) = %+v, %v", ctx, key, obj, err)
			return obj, err
		}
	}
	if !key.Valid() {
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.GetError[*key]; ok {
		klog.V(5).Infof("MockBetaTargetHttpProxies.Get(%v, %s) = nil, %v", ctx, key, err)
		return nil, err
	}
	if obj, ok := m.Objects[*key]; ok {
		typedObj := obj.ToBeta()
		klog.V(5).Infof("MockBetaTargetHttpProxies.Get(%v, %s) = %+v, nil", ctx, key, typedObj)
		return typedObj, nil
	}

	err := &googleapi.Error{
		Code:    http.StatusNotFound,
		Message: fmt.Sprintf("MockBetaTargetHttpProxies %v not found", key),
	}
	klog.V(5).Infof("MockBetaTargetHttpProxies.Get(%v, %s) = nil, %v", ctx, key, err)
	return nil, err
}

// List all of the objects in the mock.
func (m *MockBetaTargetHttpProxies) List(ctx context.Context, fl *filter.F) ([]*beta.TargetHttpProxy, error) {
	if m.ListHook != nil {
		if intercept, objs, err := m.ListHook(ctx, fl, m); intercept {
			klog.V(5).Infof("MockBetaTargetHttpProxies.List(%v, %v) = [%v items], %v", ctx, fl, len(objs), err)
			return objs, err
		}
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if m.ListError != nil {
		err := *m.ListError
		klog.V(5).Infof("MockBetaTargetHttpProxies.List(%v, %v) = nil, %v", ctx, fl, err)

		return nil, *m.ListError
	}

	var objs []*beta.TargetHttpProxy
	for _, obj := range m.Objects {
		if !fl.Match(obj.ToBeta()) {
			continue
		}
		objs = append(objs, obj.ToBeta())
	}

	klog.V(5).Infof("MockBetaTargetHttpProxies.List(%v, %v) = [%v items], nil", ctx, fl, len(objs))
	return objs, nil
}

// Insert is a mock for inserting/creating a new object.
func (m *MockBetaTargetHttpProxies) Insert(ctx context.Context, key *meta.Key, obj *beta.TargetHttpProxy) error {
	if m.InsertHook != nil {
		if intercept, err := m.InsertHook(ctx, key, obj, m); intercept {
			klog.V(5).Infof("MockBetaTargetHttpProxies.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.InsertError[*key]; ok {
		klog.V(5).Infof("MockBetaTargetHttpProxies.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}
	if _, ok := m.Objects[*key]; ok {
		err := &googleapi.Error{
			Code:    http.StatusConflict,
			Message: fmt.Sprintf("MockBetaTargetHttpProxies %v exists", key),
		}
		klog.V(5).Infof("MockBetaTargetHttpProxies.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}

	obj.Name = key.Name
	projectID := m.ProjectRouter.ProjectID(ctx, "beta", "targetHttpProxies")
	obj.SelfLink = SelfLink(meta.VersionBeta, projectID, "targetHttpProxies", key)

	m.Objects[*key] = &MockTargetHttpProxiesObj{obj}
	klog.V(5).Infof("MockBetaTargetHttpProxies.Insert(%v, %v, %+v) = nil", ctx, key, obj)
	return nil
}

// Delete is a mock for deleting the object.
func (m *MockBetaTargetHttpProxies) Delete(ctx context.Context, key *meta.Key) error {
	if m.DeleteHook != nil {
		if intercept, err := m.DeleteHook(ctx, key, m); intercept {
			klog.V(5).Infof("MockBetaTargetHttpProxies.Delete(%v, %v) = %v", ctx, key, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.DeleteError[*key]; ok {
		klog.V(5).Infof("MockBetaTargetHttpProxies.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}
	if _, ok := m.Objects[*key]; !ok {
		err := &googleapi.Error{
			Code:    http.StatusNotFound,
			Message: fmt.Sprintf("MockBetaTargetHttpProxies %v not found", key),
		}
		klog.V(5).Infof("MockBetaTargetHttpProxies.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	delete(m.Objects, *key)
	klog.V(5).Infof("MockBetaTargetHttpProxies.Delete(%v, %v) = nil", ctx, key)
	return nil
}

// Obj wraps the object for use in the mock.
func (m *MockBetaTargetHttpProxies) Obj(o *beta.TargetHttpProxy) *MockTargetHttpProxiesObj {
	return &MockTargetHttpProxiesObj{o}
}

// SetUrlMap is a mock for the corresponding method.
func (m *MockBetaTargetHttpProxies) SetUrlMap(ctx context.Context, key *meta.Key, arg0 *beta.UrlMapReference) error {
	if m.SetUrlMapHook != nil {
		return m.SetUrlMapHook(ctx, key, arg0, m)
	}
	return nil
}

// GCEBetaTargetHttpProxies is a simplifying adapter for the GCE TargetHttpProxies.
type GCEBetaTargetHttpProxies struct {
	s *Service
}

// Get the TargetHttpProxy named by key.
func (g *GCEBetaTargetHttpProxies) Get(ctx context.Context, key *meta.Key) (*beta.TargetHttpProxy, error) {
	klog.V(5).Infof("GCEBetaTargetHttpProxies.Get(%v, %v): called", ctx, key)

	if !key.Valid() {
		klog.V(2).Infof("GCEBetaTargetHttpProxies.Get(%v, %v): key is invalid (%#v)", ctx, key, key)
		return nil, fmt.Errorf("invalid GCE key (%#v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "beta", "TargetHttpProxies")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Get",
		Version:   meta.Version("beta"),
		Service:   "TargetHttpProxies",
	}
	klog.V(5).Infof("GCEBetaTargetHttpProxies.Get(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEBetaTargetHttpProxies.Get(%v, %v): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.Beta.TargetHttpProxies.Get(projectID, key.Name)
	call.Context(ctx)
	v, err := call.Do()
	klog.V(4).Infof("GCEBetaTargetHttpProxies.Get(%v, %v) = %+v, %v", ctx, key, v, err)
	return v, err
}

// List all TargetHttpProxy objects.
func (g *GCEBetaTargetHttpProxies) List(ctx context.Context, fl *filter.F) ([]*beta.TargetHttpProxy, error) {
	klog.V(5).Infof("GCEBetaTargetHttpProxies.List(%v, %v) called", ctx, fl)
	projectID := g.s.ProjectRouter.ProjectID(ctx, "beta", "TargetHttpProxies")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "List",
		Version:   meta.Version("beta"),
		Service:   "TargetHttpProxies",
	}
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		return nil, err
	}
	klog.V(5).Infof("GCEBetaTargetHttpProxies.List(%v, %v): projectID = %v, rk = %+v", ctx, fl, projectID, rk)
	call := g.s.Beta.TargetHttpProxies.List(projectID)
	if fl != filter.None {
		call.Filter(fl.String())
	}
	var all []*beta.TargetHttpProxy
	f := func(l *beta.TargetHttpProxyList) error {
		klog.V(5).Infof("GCEBetaTargetHttpProxies.List(%v, ..., %v): page %+v", ctx, fl, l)
		all = append(all, l.Items...)
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		klog.V(4).Infof("GCEBetaTargetHttpProxies.List(%v, ..., %v) = %v, %v", ctx, fl, nil, err)
		return nil, err
	}

	if klog.V(4).Enabled() {
		klog.V(4).Infof("GCEBetaTargetHttpProxies.List(%v, ..., %v) = [%v items], %v", ctx, fl, len(all), nil)
	} else if klog.V(5).Enabled() {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		klog.V(5).Infof("GCEBetaTargetHttpProxies.List(%v, ..., %v) = %v, %v", ctx, fl, asStr, nil)
	}

	return all, nil
}

// Insert TargetHttpProxy with key of value obj.
func (g *GCEBetaTargetHttpProxies) Insert(ctx context.Context, key *meta.Key, obj *beta.TargetHttpProxy) error {
	klog.V(5).Infof("GCEBetaTargetHttpProxies.Insert(%v, %v, %+v): called", ctx, key, obj)
	if !key.Valid() {
		klog.V(2).Infof("GCEBetaTargetHttpProxies.Insert(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "beta", "TargetHttpProxies")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Insert",
		Version:   meta.Version("beta"),
		Service:   "TargetHttpProxies",
	}
	klog.V(5).Infof("GCEBetaTargetHttpProxies.Insert(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEBetaTargetHttpProxies.Insert(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	obj.Name = key.Name
	call := g.s.Beta.TargetHttpProxies.Insert(projectID, obj)
	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCEBetaTargetHttpProxies.Insert(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEBetaTargetHttpProxies.Insert(%v, %v, %+v) = %+v", ctx, key, obj, err)
	return err
}

// Delete the TargetHttpProxy referenced by key.
func (g *GCEBetaTargetHttpProxies) Delete(ctx context.Context, key *meta.Key) error {
	klog.V(5).Infof("GCEBetaTargetHttpProxies.Delete(%v, %v): called", ctx, key)
	if !key.Valid() {
		klog.V(2).Infof("GCEBetaTargetHttpProxies.Delete(%v, %v): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "beta", "TargetHttpProxies")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Delete",
		Version:   meta.Version("beta"),
		Service:   "TargetHttpProxies",
	}
	klog.V(5).Infof("GCEBetaTargetHttpProxies.Delete(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEBetaTargetHttpProxies.Delete(%v, %v): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Beta.TargetHttpProxies.Delete(projectID, key.Name)

	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCEBetaTargetHttpProxies.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEBetaTargetHttpProxies.Delete(%v, %v) = %v", ctx, key, err)
	return err
}

// SetUrlMap is a method on GCEBetaTargetHttpProxies.
func (g *GCEBetaTargetHttpProxies) SetUrlMap(ctx context.Context, key *meta.Key, arg0 *beta.UrlMapReference) error {
	klog.V(5).Infof("GCEBetaTargetHttpProxies.SetUrlMap(%v, %v, ...): called", ctx, key)

	if !key.Valid() {
		klog.V(2).Infof("GCEBetaTargetHttpProxies.SetUrlMap(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "beta", "TargetHttpProxies")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "SetUrlMap",
		Version:   meta.Version("beta"),
		Service:   "TargetHttpProxies",
	}
	klog.V(5).Infof("GCEBetaTargetHttpProxies.SetUrlMap(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)

	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEBetaTargetHttpProxies.SetUrlMap(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Beta.TargetHttpProxies.SetUrlMap(projectID, key.Name, arg0)
	call.Context(ctx)
	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCEBetaTargetHttpProxies.SetUrlMap(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}
	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEBetaTargetHttpProxies.SetUrlMap(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// TargetHttpProxies is an interface that allows for mocking of TargetHttpProxies.
type TargetHttpProxies interface {
	Get(ctx context.Context, key *meta.Key) (*ga.TargetHttpProxy, error)
	List(ctx context.Context, fl *filter.F) ([]*ga.TargetHttpProxy, error)
	Insert(ctx context.Context, key *meta.Key, obj *ga.TargetHttpProxy) error
	Delete(ctx context.Context, key *meta.Key) error
	SetUrlMap(context.Context, *meta.Key, *ga.UrlMapReference) error
}

// NewMockTargetHttpProxies returns a new mock for TargetHttpProxies.
func NewMockTargetHttpProxies(pr ProjectRouter, objs map[meta.Key]*MockTargetHttpProxiesObj) *MockTargetHttpProxies {
	mock := &MockTargetHttpProxies{
		ProjectRouter: pr,

		Objects:     objs,
		GetError:    map[meta.Key]error{},
		InsertError: map[meta.Key]error{},
		DeleteError: map[meta.Key]error{},
	}
	return mock
}

// MockTargetHttpProxies is the mock for TargetHttpProxies.
type MockTargetHttpProxies struct {
	Lock sync.Mutex

	ProjectRouter ProjectRouter

	// Objects maintained by the mock.
	Objects map[meta.Key]*MockTargetHttpProxiesObj

	// If an entry exists for the given key and operation, then the error
	// will be returned instead of the operation.
	GetError    map[meta.Key]error
	ListError   *error
	InsertError map[meta.Key]error
	DeleteError map[meta.Key]error

	// xxxHook allow you to intercept the standard processing of the mock in
	// order to add your own logic. Return (true, _, _) to prevent the normal
	// execution flow of the mock. Return (false, nil, nil) to continue with
	// normal mock behavior/ after the hook function executes.
	GetHook       func(ctx context.Context, key *meta.Key, m *MockTargetHttpProxies) (bool, *ga.TargetHttpProxy, error)
	ListHook      func(ctx context.Context, fl *filter.F, m *MockTargetHttpProxies) (bool, []*ga.TargetHttpProxy, error)
	InsertHook    func(ctx context.Context, key *meta.Key, obj *ga.TargetHttpProxy, m *MockTargetHttpProxies) (bool, error)
	DeleteHook    func(ctx context.Context, key *meta.Key, m *MockTargetHttpProxies) (bool, error)
	SetUrlMapHook func(context.Context, *meta.Key, *ga.UrlMapReference, *MockTargetHttpProxies) error

	// X is extra state that can be used as part of the mock. Generated code
	// will not use this field.
	X interface{}
}

// Get returns the object from the mock.
func (m *MockTargetHttpProxies) Get(ctx context.Context, key *meta.Key) (*ga.TargetHttpProxy, error) {
	if m.GetHook != nil {
		if intercept, obj, err := m.GetHook(ctx, key, m); intercept {
			klog.V(5).Infof("MockTargetHttpProxies.Get(%v, %s) = %+v, %v", ctx, key, obj, err)
			return obj, err
		}
	}
	if !key.Valid() {
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.GetError[*key]; ok {
		klog.V(5).Infof("MockTargetHttpProxies.Get(%v, %s) = nil, %v", ctx, key, err)
		return nil, err
	}
	if obj, ok := m.Objects[*key]; ok {
		typedObj := obj.ToGA()
		klog.V(5).Infof("MockTargetHttpProxies.Get(%v, %s) = %+v, nil", ctx, key, typedObj)
		return typedObj, nil
	}

	err := &googleapi.Error{
		Code:    http.StatusNotFound,
		Message: fmt.Sprintf("MockTargetHttpProxies %v not found", key),
	}
	klog.V(5).Infof("MockTargetHttpProxies.Get(%v, %s) = nil, %v", ctx, key, err)
	return nil, err
}

// List all of the objects in the mock.
func (m *MockTargetHttpProxies) List(ctx context.Context, fl *filter.F) ([]*ga.TargetHttpProxy, error) {
	if m.ListHook != nil {
		if intercept, objs, err := m.ListHook(ctx, fl, m); intercept {
			klog.V(5).Infof("MockTargetHttpProxies.List(%v, %v) = [%v items], %v", ctx, fl, len(objs), err)
			return objs, err
		}
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if m.ListError != nil {
		err := *m.ListError
		klog.V(5).Infof("MockTargetHttpProxies.List(%v, %v) = nil, %v", ctx, fl, err)

		return nil, *m.ListError
	}

	var objs []*ga.TargetHttpProxy
	for _, obj := range m.Objects {
		if !fl.Match(obj.ToGA()) {
			continue
		}
		objs = append(objs, obj.ToGA())
	}

	klog.V(5).Infof("MockTargetHttpProxies.List(%v, %v) = [%v items], nil", ctx, fl, len(objs))
	return objs, nil
}

// Insert is a mock for inserting/creating a new object.
func (m *MockTargetHttpProxies) Insert(ctx context.Context, key *meta.Key, obj *ga.TargetHttpProxy) error {
	if m.InsertHook != nil {
		if intercept, err := m.InsertHook(ctx, key, obj, m); intercept {
			klog.V(5).Infof("MockTargetHttpProxies.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.InsertError[*key]; ok {
		klog.V(5).Infof("MockTargetHttpProxies.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}
	if _, ok := m.Objects[*key]; ok {
		err := &googleapi.Error{
			Code:    http.StatusConflict,
			Message: fmt.Sprintf("MockTargetHttpProxies %v exists", key),
		}
		klog.V(5).Infof("MockTargetHttpProxies.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}

	obj.Name = key.Name
	projectID := m.ProjectRouter.ProjectID(ctx, "ga", "targetHttpProxies")
	obj.SelfLink = SelfLink(meta.VersionGA, projectID, "targetHttpProxies", key)

	m.Objects[*key] = &MockTargetHttpProxiesObj{obj}
	klog.V(5).Infof("MockTargetHttpProxies.Insert(%v, %v, %+v) = nil", ctx, key, obj)
	return nil
}

// Delete is a mock for deleting the object.
func (m *MockTargetHttpProxies) Delete(ctx context.Context, key *meta.Key) error {
	if m.DeleteHook != nil {
		if intercept, err := m.DeleteHook(ctx, key, m); intercept {
			klog.V(5).Infof("MockTargetHttpProxies.Delete(%v, %v) = %v", ctx, key, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.DeleteError[*key]; ok {
		klog.V(5).Infof("MockTargetHttpProxies.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}
	if _, ok := m.Objects[*key]; !ok {
		err := &googleapi.Error{
			Code:    http.StatusNotFound,
			Message: fmt.Sprintf("MockTargetHttpProxies %v not found", key),
		}
		klog.V(5).Infof("MockTargetHttpProxies.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	delete(m.Objects, *key)
	klog.V(5).Infof("MockTargetHttpProxies.Delete(%v, %v) = nil", ctx, key)
	return nil
}

// Obj wraps the object for use in the mock.
func (m *MockTargetHttpProxies) Obj(o *ga.TargetHttpProxy) *MockTargetHttpProxiesObj {
	return &MockTargetHttpProxiesObj{o}
}

// SetUrlMap is a mock for the corresponding method.
func (m *MockTargetHttpProxies) SetUrlMap(ctx context.Context, key *meta.Key, arg0 *ga.UrlMapReference) error {
	if m.SetUrlMapHook != nil {
		return m.SetUrlMapHook(ctx, key, arg0, m)
	}
	return nil
}

// GCETargetHttpProxies is a simplifying adapter for the GCE TargetHttpProxies.
type GCETargetHttpProxies struct {
	s *Service
}

// Get the TargetHttpProxy named by key.
func (g *GCETargetHttpProxies) Get(ctx context.Context, key *meta.Key) (*ga.TargetHttpProxy, error) {
	klog.V(5).Infof("GCETargetHttpProxies.Get(%v, %v): called", ctx, key)

	if !key.Valid() {
		klog.V(2).Infof("GCETargetHttpProxies.Get(%v, %v): key is invalid (%#v)", ctx, key, key)
		return nil, fmt.Errorf("invalid GCE key (%#v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "TargetHttpProxies")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Get",
		Version:   meta.Version("ga"),
		Service:   "TargetHttpProxies",
	}
	klog.V(5).Infof("GCETargetHttpProxies.Get(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCETargetHttpProxies.Get(%v, %v): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.GA.TargetHttpProxies.Get(projectID, key.Name)
	call.Context(ctx)
	v, err := call.Do()
	klog.V(4).Infof("GCETargetHttpProxies.Get(%v, %v) = %+v, %v", ctx, key, v, err)
	return v, err
}

// List all TargetHttpProxy objects.
func (g *GCETargetHttpProxies) List(ctx context.Context, fl *filter.F) ([]*ga.TargetHttpProxy, error) {
	klog.V(5).Infof("GCETargetHttpProxies.List(%v, %v) called", ctx, fl)
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "TargetHttpProxies")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "List",
		Version:   meta.Version("ga"),
		Service:   "TargetHttpProxies",
	}
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		return nil, err
	}
	klog.V(5).Infof("GCETargetHttpProxies.List(%v, %v): projectID = %v, rk = %+v", ctx, fl, projectID, rk)
	call := g.s.GA.TargetHttpProxies.List(projectID)
	if fl != filter.None {
		call.Filter(fl.String())
	}
	var all []*ga.TargetHttpProxy
	f := func(l *ga.TargetHttpProxyList) error {
		klog.V(5).Infof("GCETargetHttpProxies.List(%v, ..., %v): page %+v", ctx, fl, l)
		all = append(all, l.Items...)
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		klog.V(4).Infof("GCETargetHttpProxies.List(%v, ..., %v) = %v, %v", ctx, fl, nil, err)
		return nil, err
	}

	if klog.V(4).Enabled() {
		klog.V(4).Infof("GCETargetHttpProxies.List(%v, ..., %v) = [%v items], %v", ctx, fl, len(all), nil)
	} else if klog.V(5).Enabled() {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		klog.V(5).Infof("GCETargetHttpProxies.List(%v, ..., %v) = %v, %v", ctx, fl, asStr, nil)
	}

	return all, nil
}

// Insert TargetHttpProxy with key of value obj.
func (g *GCETargetHttpProxies) Insert(ctx context.Context, key *meta.Key, obj *ga.TargetHttpProxy) error {
	klog.V(5).Infof("GCETargetHttpProxies.Insert(%v, %v, %+v): called", ctx, key, obj)
	if !key.Valid() {
		klog.V(2).Infof("GCETargetHttpProxies.Insert(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "TargetHttpProxies")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Insert",
		Version:   meta.Version("ga"),
		Service:   "TargetHttpProxies",
	}
	klog.V(5).Infof("GCETargetHttpProxies.Insert(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCETargetHttpProxies.Insert(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	obj.Name = key.Name
	call := g.s.GA.TargetHttpProxies.Insert(projectID, obj)
	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCETargetHttpProxies.Insert(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCETargetHttpProxies.Insert(%v, %v, %+v) = %+v", ctx, key, obj, err)
	return err
}

// Delete the TargetHttpProxy referenced by key.
func (g *GCETargetHttpProxies) Delete(ctx context.Context, key *meta.Key) error {
	klog.V(5).Infof("GCETargetHttpProxies.Delete(%v, %v): called", ctx, key)
	if !key.Valid() {
		klog.V(2).Infof("GCETargetHttpProxies.Delete(%v, %v): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "TargetHttpProxies")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Delete",
		Version:   meta.Version("ga"),
		Service:   "TargetHttpProxies",
	}
	klog.V(5).Infof("GCETargetHttpProxies.Delete(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCETargetHttpProxies.Delete(%v, %v): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.GA.TargetHttpProxies.Delete(projectID, key.Name)

	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCETargetHttpProxies.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCETargetHttpProxies.Delete(%v, %v) = %v", ctx, key, err)
	return err
}

// SetUrlMap is a method on GCETargetHttpProxies.
func (g *GCETargetHttpProxies) SetUrlMap(ctx context.Context, key *meta.Key, arg0 *ga.UrlMapReference) error {
	klog.V(5).Infof("GCETargetHttpProxies.SetUrlMap(%v, %v, ...): called", ctx, key)

	if !key.Valid() {
		klog.V(2).Infof("GCETargetHttpProxies.SetUrlMap(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "TargetHttpProxies")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "SetUrlMap",
		Version:   meta.Version("ga"),
		Service:   "TargetHttpProxies",
	}
	klog.V(5).Infof("GCETargetHttpProxies.SetUrlMap(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)

	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCETargetHttpProxies.SetUrlMap(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.GA.TargetHttpProxies.SetUrlMap(projectID, key.Name, arg0)
	call.Context(ctx)
	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCETargetHttpProxies.SetUrlMap(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}
	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCETargetHttpProxies.SetUrlMap(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// AlphaRegionTargetHttpProxies is an interface that allows for mocking of RegionTargetHttpProxies.
type AlphaRegionTargetHttpProxies interface {
	Get(ctx context.Context, key *meta.Key) (*alpha.TargetHttpProxy, error)
	List(ctx context.Context, region string, fl *filter.F) ([]*alpha.TargetHttpProxy, error)
	Insert(ctx context.Context, key *meta.Key, obj *alpha.TargetHttpProxy) error
	Delete(ctx context.Context, key *meta.Key) error
	SetUrlMap(context.Context, *meta.Key, *alpha.UrlMapReference) error
}

// NewMockAlphaRegionTargetHttpProxies returns a new mock for RegionTargetHttpProxies.
func NewMockAlphaRegionTargetHttpProxies(pr ProjectRouter, objs map[meta.Key]*MockRegionTargetHttpProxiesObj) *MockAlphaRegionTargetHttpProxies {
	mock := &MockAlphaRegionTargetHttpProxies{
		ProjectRouter: pr,

		Objects:     objs,
		GetError:    map[meta.Key]error{},
		InsertError: map[meta.Key]error{},
		DeleteError: map[meta.Key]error{},
	}
	return mock
}

// MockAlphaRegionTargetHttpProxies is the mock for RegionTargetHttpProxies.
type MockAlphaRegionTargetHttpProxies struct {
	Lock sync.Mutex

	ProjectRouter ProjectRouter

	// Objects maintained by the mock.
	Objects map[meta.Key]*MockRegionTargetHttpProxiesObj

	// If an entry exists for the given key and operation, then the error
	// will be returned instead of the operation.
	GetError    map[meta.Key]error
	ListError   *error
	InsertError map[meta.Key]error
	DeleteError map[meta.Key]error

	// xxxHook allow you to intercept the standard processing of the mock in
	// order to add your own logic. Return (true, _, _) to prevent the normal
	// execution flow of the mock. Return (false, nil, nil) to continue with
	// normal mock behavior/ after the hook function executes.
	GetHook       func(ctx context.Context, key *meta.Key, m *MockAlphaRegionTargetHttpProxies) (bool, *alpha.TargetHttpProxy, error)
	ListHook      func(ctx context.Context, region string, fl *filter.F, m *MockAlphaRegionTargetHttpProxies) (bool, []*alpha.TargetHttpProxy, error)
	InsertHook    func(ctx context.Context, key *meta.Key, obj *alpha.TargetHttpProxy, m *MockAlphaRegionTargetHttpProxies) (bool, error)
	DeleteHook    func(ctx context.Context, key *meta.Key, m *MockAlphaRegionTargetHttpProxies) (bool, error)
	SetUrlMapHook func(context.Context, *meta.Key, *alpha.UrlMapReference, *MockAlphaRegionTargetHttpProxies) error

	// X is extra state that can be used as part of the mock. Generated code
	// will not use this field.
	X interface{}
}

// Get returns the object from the mock.
func (m *MockAlphaRegionTargetHttpProxies) Get(ctx context.Context, key *meta.Key) (*alpha.TargetHttpProxy, error) {
	if m.GetHook != nil {
		if intercept, obj, err := m.GetHook(ctx, key, m); intercept {
			klog.V(5).Infof("MockAlphaRegionTargetHttpProxies.Get(%v, %s) = %+v, %v", ctx, key, obj, err)
			return obj, err
		}
	}
	if !key.Valid() {
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.GetError[*key]; ok {
		klog.V(5).Infof("MockAlphaRegionTargetHttpProxies.Get(%v, %s) = nil, %v", ctx, key, err)
		return nil, err
	}
	if obj, ok := m.Objects[*key]; ok {
		typedObj := obj.ToAlpha()
		klog.V(5).Infof("MockAlphaRegionTargetHttpProxies.Get(%v, %s) = %+v, nil", ctx, key, typedObj)
		return typedObj, nil
	}

	err := &googleapi.Error{
		Code:    http.StatusNotFound,
		Message: fmt.Sprintf("MockAlphaRegionTargetHttpProxies %v not found", key),
	}
	klog.V(5).Infof("MockAlphaRegionTargetHttpProxies.Get(%v, %s) = nil, %v", ctx, key, err)
	return nil, err
}

// List all of the objects in the mock in the given region.
func (m *MockAlphaRegionTargetHttpProxies) List(ctx context.Context, region string, fl *filter.F) ([]*alpha.TargetHttpProxy, error) {
	if m.ListHook != nil {
		if intercept, objs, err := m.ListHook(ctx, region, fl, m); intercept {
			klog.V(5).Infof("MockAlphaRegionTargetHttpProxies.List(%v, %q, %v) = [%v items], %v", ctx, region, fl, len(objs), err)
			return objs, err
		}
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if m.ListError != nil {
		err := *m.ListError
		klog.V(5).Infof("MockAlphaRegionTargetHttpProxies.List(%v, %q, %v) = nil, %v", ctx, region, fl, err)

		return nil, *m.ListError
	}

	var objs []*alpha.TargetHttpProxy
	for key, obj := range m.Objects {
		if key.Region != region {
			continue
		}
		if !fl.Match(obj.ToAlpha()) {
			continue
		}
		objs = append(objs, obj.ToAlpha())
	}

	klog.V(5).Infof("MockAlphaRegionTargetHttpProxies.List(%v, %q, %v) = [%v items], nil", ctx, region, fl, len(objs))
	return objs, nil
}

// Insert is a mock for inserting/creating a new object.
func (m *MockAlphaRegionTargetHttpProxies) Insert(ctx context.Context, key *meta.Key, obj *alpha.TargetHttpProxy) error {
	if m.InsertHook != nil {
		if intercept, err := m.InsertHook(ctx, key, obj, m); intercept {
			klog.V(5).Infof("MockAlphaRegionTargetHttpProxies.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.InsertError[*key]; ok {
		klog.V(5).Infof("MockAlphaRegionTargetHttpProxies.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}
	if _, ok := m.Objects[*key]; ok {
		err := &googleapi.Error{
			Code:    http.StatusConflict,
			Message: fmt.Sprintf("MockAlphaRegionTargetHttpProxies %v exists", key),
		}
		klog.V(5).Infof("MockAlphaRegionTargetHttpProxies.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}

	obj.Name = key.Name
	projectID := m.ProjectRouter.ProjectID(ctx, "alpha", "targetHttpProxies")
	obj.SelfLink = SelfLink(meta.VersionAlpha, projectID, "targetHttpProxies", key)

	m.Objects[*key] = &MockRegionTargetHttpProxiesObj{obj}
	klog.V(5).Infof("MockAlphaRegionTargetHttpProxies.Insert(%v, %v, %+v) = nil", ctx, key, obj)
	return nil
}

// Delete is a mock for deleting the object.
func (m *MockAlphaRegionTargetHttpProxies) Delete(ctx context.Context, key *meta.Key) error {
	if m.DeleteHook != nil {
		if intercept, err := m.DeleteHook(ctx, key, m); intercept {
			klog.V(5).Infof("MockAlphaRegionTargetHttpProxies.Delete(%v, %v) = %v", ctx, key, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.DeleteError[*key]; ok {
		klog.V(5).Infof("MockAlphaRegionTargetHttpProxies.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}
	if _, ok := m.Objects[*key]; !ok {
		err := &googleapi.Error{
			Code:    http.StatusNotFound,
			Message: fmt.Sprintf("MockAlphaRegionTargetHttpProxies %v not found", key),
		}
		klog.V(5).Infof("MockAlphaRegionTargetHttpProxies.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	delete(m.Objects, *key)
	klog.V(5).Infof("MockAlphaRegionTargetHttpProxies.Delete(%v, %v) = nil", ctx, key)
	return nil
}

// Obj wraps the object for use in the mock.
func (m *MockAlphaRegionTargetHttpProxies) Obj(o *alpha.TargetHttpProxy) *MockRegionTargetHttpProxiesObj {
	return &MockRegionTargetHttpProxiesObj{o}
}

// SetUrlMap is a mock for the corresponding method.
func (m *MockAlphaRegionTargetHttpProxies) SetUrlMap(ctx context.Context, key *meta.Key, arg0 *alpha.UrlMapReference) error {
	if m.SetUrlMapHook != nil {
		return m.SetUrlMapHook(ctx, key, arg0, m)
	}
	return nil
}

// GCEAlphaRegionTargetHttpProxies is a simplifying adapter for the GCE RegionTargetHttpProxies.
type GCEAlphaRegionTargetHttpProxies struct {
	s *Service
}

// Get the TargetHttpProxy named by key.
func (g *GCEAlphaRegionTargetHttpProxies) Get(ctx context.Context, key *meta.Key) (*alpha.TargetHttpProxy, error) {
	klog.V(5).Infof("GCEAlphaRegionTargetHttpProxies.Get(%v, %v): called", ctx, key)

	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaRegionTargetHttpProxies.Get(%v, %v): key is invalid (%#v)", ctx, key, key)
		return nil, fmt.Errorf("invalid GCE key (%#v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "alpha", "RegionTargetHttpProxies")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Get",
		Version:   meta.Version("alpha"),
		Service:   "RegionTargetHttpProxies",
	}
	klog.V(5).Infof("GCEAlphaRegionTargetHttpProxies.Get(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEAlphaRegionTargetHttpProxies.Get(%v, %v): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.Alpha.RegionTargetHttpProxies.Get(projectID, key.Region, key.Name)
	call.Context(ctx)
	v, err := call.Do()
	klog.V(4).Infof("GCEAlphaRegionTargetHttpProxies.Get(%v, %v) = %+v, %v", ctx, key, v, err)
	return v, err
}

// List all TargetHttpProxy objects.
func (g *GCEAlphaRegionTargetHttpProxies) List(ctx context.Context, region string, fl *filter.F) ([]*alpha.TargetHttpProxy, error) {
	klog.V(5).Infof("GCEAlphaRegionTargetHttpProxies.List(%v, %v, %v) called", ctx, region, fl)
	projectID := g.s.ProjectRouter.ProjectID(ctx, "alpha", "RegionTargetHttpProxies")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "List",
		Version:   meta.Version("alpha"),
		Service:   "RegionTargetHttpProxies",
	}
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		return nil, err
	}
	klog.V(5).Infof("GCEAlphaRegionTargetHttpProxies.List(%v, %v, %v): projectID = %v, rk = %+v", ctx, region, fl, projectID, rk)
	call := g.s.Alpha.RegionTargetHttpProxies.List(projectID, region)
	if fl != filter.None {
		call.Filter(fl.String())
	}
	var all []*alpha.TargetHttpProxy
	f := func(l *alpha.TargetHttpProxyList) error {
		klog.V(5).Infof("GCEAlphaRegionTargetHttpProxies.List(%v, ..., %v): page %+v", ctx, fl, l)
		all = append(all, l.Items...)
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		klog.V(4).Infof("GCEAlphaRegionTargetHttpProxies.List(%v, ..., %v) = %v, %v", ctx, fl, nil, err)
		return nil, err
	}

	if klog.V(4).Enabled() {
		klog.V(4).Infof("GCEAlphaRegionTargetHttpProxies.List(%v, ..., %v) = [%v items], %v", ctx, fl, len(all), nil)
	} else if klog.V(5).Enabled() {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		klog.V(5).Infof("GCEAlphaRegionTargetHttpProxies.List(%v, ..., %v) = %v, %v", ctx, fl, asStr, nil)
	}

	return all, nil
}

// Insert TargetHttpProxy with key of value obj.
func (g *GCEAlphaRegionTargetHttpProxies) Insert(ctx context.Context, key *meta.Key, obj *alpha.TargetHttpProxy) error {
	klog.V(5).Infof("GCEAlphaRegionTargetHttpProxies.Insert(%v, %v, %+v): called", ctx, key, obj)
	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaRegionTargetHttpProxies.Insert(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "alpha", "RegionTargetHttpProxies")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Insert",
		Version:   meta.Version("alpha"),
		Service:   "RegionTargetHttpProxies",
	}
	klog.V(5).Infof("GCEAlphaRegionTargetHttpProxies.Insert(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEAlphaRegionTargetHttpProxies.Insert(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	obj.Name = key.Name
	call := g.s.Alpha.RegionTargetHttpProxies.Insert(projectID, key.Region, obj)
	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCEAlphaRegionTargetHttpProxies.Insert(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEAlphaRegionTargetHttpProxies.Insert(%v, %v, %+v) = %+v", ctx, key, obj, err)
	return err
}

// Delete the TargetHttpProxy referenced by key.
func (g *GCEAlphaRegionTargetHttpProxies) Delete(ctx context.Context, key *meta.Key) error {
	klog.V(5).Infof("GCEAlphaRegionTargetHttpProxies.Delete(%v, %v): called", ctx, key)
	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaRegionTargetHttpProxies.Delete(%v, %v): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "alpha", "RegionTargetHttpProxies")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Delete",
		Version:   meta.Version("alpha"),
		Service:   "RegionTargetHttpProxies",
	}
	klog.V(5).Infof("GCEAlphaRegionTargetHttpProxies.Delete(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEAlphaRegionTargetHttpProxies.Delete(%v, %v): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Alpha.RegionTargetHttpProxies.Delete(projectID, key.Region, key.Name)
	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCEAlphaRegionTargetHttpProxies.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEAlphaRegionTargetHttpProxies.Delete(%v, %v) = %v", ctx, key, err)
	return err
}

// SetUrlMap is a method on GCEAlphaRegionTargetHttpProxies.
func (g *GCEAlphaRegionTargetHttpProxies) SetUrlMap(ctx context.Context, key *meta.Key, arg0 *alpha.UrlMapReference) error {
	klog.V(5).Infof("GCEAlphaRegionTargetHttpProxies.SetUrlMap(%v, %v, ...): called", ctx, key)

	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaRegionTargetHttpProxies.SetUrlMap(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "alpha", "RegionTargetHttpProxies")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "SetUrlMap",
		Version:   meta.Version("alpha"),
		Service:   "RegionTargetHttpProxies",
	}
	klog.V(5).Infof("GCEAlphaRegionTargetHttpProxies.SetUrlMap(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)

	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		klog.V(4).Infof("GCEAlphaRegionTargetHttpProxies.SetUrlMap(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Alpha.RegionTargetHttpProxies.SetUrlMap(projectID, key.Region, key.Name, arg0)
	call.Context(ctx)
	op, err := call.Do()
	if err != nil {
		klog.V(4).Infof("GCEAlphaRegionTargetHttpProxies.SetUrlMap(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}
	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEAlphaRegionTargetHttpProxies.SetUrlMap(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// BetaRegionTargetHttpProxies is an interface that allows for mocking of RegionTargetHttpProxies.
type BetaRegionTargetHttpProxies interface {
	Get(ctx context.Context, key *meta.Key) (*beta.TargetHttpProxy, error)
	List(ctx context.Context, region string, fl *filter.F) ([