# Contributing guidelines

Welcome to Kubernetes. We are excited about the prospect of you joining our [community](https://git.k8s.io/community)! The Kubernetes community abides by the CNCF [code of conduct](code-of-conduct.md). Here is an excerpt:

_As contributors and maintainers of this project, and in the interest of fostering an open and welcoming community, we pledge to respect all people who contribute through reporting issues, posting feature requests, updating documentation, submitting pull requests or patches, and other activities._

## How to become a contributor and submit your own code

This repository does not directly accept contributions. Code in this repository is currently being copied from staging within the [Kubernetes repository](https://github.com/kubernetes/kubernetes/tree/master/staging). In order to contribute code to this repository, the coder must modify kubectl code in [staging](https://github.com/kubernetes/kubernetes/tree/master/staging/src/k8s.io/controller-manager).

See [this doc](https://github.com/kubernetes/community/tree/master/sig-api-machinery) and [this doc](https://github.com/kubernetes/community/tree/master/sig-cloud-provider) for information about contributing.

## Getting Started

We have full documentation on how to get started contributing here:

- [Contributor License Agreement](https://git.k8s.io/community/CLA.md) Kubernetes projects require that you sign a Contributor License Agreement (CLA) before we can accept your pull requests
- [Kubernetes Contributor Guide](https://git.k8s.io/community/contributors/guide) - Main contributor documentation, or you can just jump directly to the [contributing section](https://git.k8s.io/community/contributors/guide#contributing)
- [Contributor Cheat Sheet](https://git.k8s.io/community/contributors/guide/contributor-cheatsheet) - Common resources for existing developers

## Mentorship

- [Mentoring Initiatives](https://git.k8s.io/community/mentoring) - We have a diverse set of mentorship programs available that are always looking for volunteers!
