# ---------------------------------------------------------------------------------------------------------------------
# PIN TERRAFORM VERSION TO >= 0.12
# ---------------------------------------------------------------------------------------------------------------------

terraform {
  # This module is now only being tested with Terraform 0.13.x. However, to make upgrading easier, we are setting
  # 0.12.26 as the minimum version, as that version added support for required_providers with source URLs, making it
  # forwards compatible with 0.13.x code.
  required_version = ">= 0.12.26"
}

# ---------------------------------------------------------------------------------------------------------------------
# CREATE A FLOATING ENI WITH SECURITY GROUP AND ATTACH TO INSTANCE
# ---------------------------------------------------------------------------------------------------------------------

resource "aws_instance" "test" {
  ami           = data.aws_ami.ubuntu.id
  instance_type = module.instance_types.recommended_instance_type
  subnet_id     = module.floating_eni.subnet_id

  tags = {
    Name = "${var.prefix}-kubergrunt-test"
  }
}

resource "aws_network_interface_attachment" "test" {
  instance_id          = aws_instance.test.id
  network_interface_id = module.floating_eni.eni_id
  device_index         = 1
}

module "floating_eni" {
  source = "../unattached-ni"
  prefix = var.prefix
}

module "instance_types" {
  source = "git::git@github.com:gruntwork-io/terraform-aws-utilities.git//modules/instance-type?ref=v0.4.0"

  instance_types = ["t2.micro", "t3.micro"]
}


# ---------------------------------------------------------------------------------------------------------------------
# LOOK UP THE LATEST UBUNTU AMI
# ---------------------------------------------------------------------------------------------------------------------

data "aws_ami" "ubuntu" {
  most_recent = true
  owners      = ["099720109477"] # Canonical

  filter {
    name   = "virtualization-type"
    values = ["hvm"]
  }

  filter {
    name   = "architecture"
    values = ["x86_64"]
  }

  filter {
    name   = "image-type"
    values = ["machine"]
  }

  filter {
    name   = "name"
    values = ["ubuntu/images/hvm-ssd/ubuntu-focal-20.04-amd64-server-*"]
  }
}
