package parquet

import (
	"math"
	"testing"
)

func TestDoublePlainDecoder(t *testing.T) {
	testValuesDecoder(t, &doublePlainDecoder{}, []decoderTestCase{
		{
			data: []byte{
				// 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF8, 0x7F,
				0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF0, 0xFF,
				0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF0, 0x7F,
				0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
				0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF8, 0x3F,
				0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF4, 0xBF,
			},
			decoded: []interface{}{
				// math.NaN(),
				math.Inf(-1),
				math.Inf(+1),
				0.0,
				1.5,
				-1.25,
			},
		},
	})
}
