package parquet

import (
	"testing"
)

func TestByteArrayPlainDecoder(t *testing.T) {
	testValuesDecoder(t, &byteArrayPlainDecoder{}, []decoderTestCase{
		{
			data: []byte{
				0x03, 0x00, 0x00, 0x00, 0x31, 0x32, 0x33,
				0x00, 0x00, 0x00, 0x00,
				0x06, 0x00, 0x00, 0x00, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46,
			},
			decoded: []interface{}{
				[]byte("123"),
				[]byte(""),
				[]byte("ABCDEF"),
			},
		},
	})
}

func TestFixedLenByteArrayPlainDecoder(t *testing.T) {
	testValuesDecoder(t, &byteArrayPlainDecoder{length: 3}, []decoderTestCase{
		{
			data: []byte{
				0x31, 0x32, 0x33,
				0x41, 0x42, 0x43,
				0x44, 0x45, 0x46,
			},
			decoded: []interface{}{
				[]byte("123"),
				[]byte("ABC"),
				[]byte("DEF"),
			},
		},
	})
}

func TestByteArrayDeltaLengthDecoder(t *testing.T) {
	testValuesDecoder(t, &byteArrayDeltaLengthDecoder{}, []decoderTestCase{
		{
			data: []byte{
				0x80, 0x01, 0x04, 0x05, 0x0A, 0x0B, 0x03, 0x00, 0x00, 0x00,
				0xBE, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
				0x00, 0x00, 0x48, 0x65, 0x6C, 0x6C, 0x6F, 0x57, 0x6F, 0x72,
				0x6C, 0x64, 0x46, 0x6F, 0x6F, 0x62, 0x61, 0x72, 0x41, 0x42,
				0x43, 0x44, 0x45, 0x46,
			},
			decoded: []interface{}{
				[]byte("Hello"),
				[]byte("World"),
				[]byte("Foobar"),
				[]byte("ABCDEF"),
				[]byte(""),
			},
		},
	})
}

func TestByteArrayDeltaDecoder(t *testing.T) {
	testValuesDecoder(t, &byteArrayDeltaDecoder{}, []decoderTestCase{
		{
			data: []byte{
				0x80, 0x01, 0x04, 0x06, 0x00, 0x05, 0x03, 0x00, 0x00, 0x00,
				0x33, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
				0x00, 0x00, 0x80, 0x01, 0x04, 0x06, 0x00, 0x09, 0x04, 0x00,
				0x00, 0x00, 0x58, 0x57, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
				0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x41, 0x42,
				0x43, 0x44, 0x45, 0x46, 0x48, 0x65, 0x6C, 0x6C, 0x6F, 0x57,
				0x6F, 0x72, 0x6C, 0x64,
			},
			decoded: []interface{}{
				[]byte(""),
				[]byte("ABC"),
				[]byte("ABCDEF"),
				[]byte("Hello"),
				[]byte("World"),
				[]byte(""),
			},
		},
	})
}
