// +build ignore

package main

import (
	"bytes"
	"fmt"
	"go/format"
	"io"
	"io/ioutil"
	"log"
)

func genExpr(maxWidth int, bw int, i int, startBit int) (expr string, newStartBit int) {
	byteShift := 0
	firstCurByteBit := startBit - startBit%8
	for bw != 0 {
		curByte := startBit / 8
		bitsInCurByte := bw
		if bitsLeft := startBit - firstCurByteBit + 1; bitsInCurByte > bitsLeft {
			bitsInCurByte = bitsLeft
		}
		shiftSize := 7 - startBit%8
		mask := 1<<uint(bitsInCurByte) - 1

		if len(expr) != 0 {
			expr += " | "
		}
		expr += fmt.Sprintf("uint%d((data[%d] >> %d) & %d) << %d",
			maxWidth, curByte, shiftSize, mask, byteShift)

		bw -= bitsInCurByte
		startBit -= bitsInCurByte
		if startBit < firstCurByteBit {
			startBit = firstCurByteBit + 15
			firstCurByteBit += 8
		}
		byteShift += bitsInCurByte
	}
	return expr, startBit
}

func genFunc(out io.Writer, maxWidth int, bw int) {
	fmt.Fprintf(out, "func unpack8int%d_%d(data []byte) (a [8]int%d) {\n", maxWidth, bw, maxWidth)
	fmt.Fprintf(out, "\t_ = data[%d]\n", bw-1)
	startBit := 7
	var expr string
	for i := 0; i < 8; i++ {
		expr, startBit = genExpr(maxWidth, bw, i, startBit)
		fmt.Fprintf(out, "\ta[%d] = int%d(%s)\n", i, maxWidth, expr)
	}
	fmt.Fprintf(out, "\treturn\n")
	fmt.Fprintf(out, "}\n\n")
}

func genPackage(fn string, maxWidth int) {
	buf := new(bytes.Buffer)

	fmt.Fprintf(buf, "package parquet\n\n")
	fmt.Fprint(buf, "// Code generated by \"bitpacking_gen.go\"; DO NOT EDIT.\n\n")
	for i := 1; i <= maxWidth; i++ {
		genFunc(buf, maxWidth, i)
	}

	src, err := format.Source(buf.Bytes())
	if err != nil {
		log.Fatal(err)
	}

	err = ioutil.WriteFile(fn, src, 0644)
	if err != nil {
		log.Fatal(err)
	}
}

func main() {
	genPackage("bitbacking32.go", 32)
	genPackage("bitpacking64.go", 64)
}
