// Code generated by aws/endpoints/v3model_codegen.go. DO NOT EDIT.

package endpoints

import (
	"regexp"
)

// Partition identifiers
const (
	AwsPartitionID      = "aws"        // AWS Standard partition.
	AwsCnPartitionID    = "aws-cn"     // AWS China partition.
	AwsUsGovPartitionID = "aws-us-gov" // AWS GovCloud (US) partition.
	AwsIsoPartitionID   = "aws-iso"    // AWS ISO (US) partition.
	AwsIsoBPartitionID  = "aws-iso-b"  // AWS ISOB (US) partition.
	AwsIsoEPartitionID  = "aws-iso-e"  // AWS ISOE (Europe) partition.
	AwsIsoFPartitionID  = "aws-iso-f"  // AWS ISOF partition.
)

// AWS Standard partition's regions.
const (
	AfSouth1RegionID     = "af-south-1"     // Africa (Cape Town).
	ApEast1RegionID      = "ap-east-1"      // Asia Pacific (Hong Kong).
	ApNortheast1RegionID = "ap-northeast-1" // Asia Pacific (Tokyo).
	ApNortheast2RegionID = "ap-northeast-2" // Asia Pacific (Seoul).
	ApNortheast3RegionID = "ap-northeast-3" // Asia Pacific (Osaka).
	ApSouth1RegionID     = "ap-south-1"     // Asia Pacific (Mumbai).
	ApSouth2RegionID     = "ap-south-2"     // Asia Pacific (Hyderabad).
	ApSoutheast1RegionID = "ap-southeast-1" // Asia Pacific (Singapore).
	ApSoutheast2RegionID = "ap-southeast-2" // Asia Pacific (Sydney).
	ApSoutheast3RegionID = "ap-southeast-3" // Asia Pacific (Jakarta).
	ApSoutheast4RegionID = "ap-southeast-4" // Asia Pacific (Melbourne).
	CaCentral1RegionID   = "ca-central-1"   // Canada (Central).
	CaWest1RegionID      = "ca-west-1"      // Canada West (Calgary).
	EuCentral1RegionID   = "eu-central-1"   // Europe (Frankfurt).
	EuCentral2RegionID   = "eu-central-2"   // Europe (Zurich).
	EuNorth1RegionID     = "eu-north-1"     // Europe (Stockholm).
	EuSouth1RegionID     = "eu-south-1"     // Europe (Milan).
	EuSouth2RegionID     = "eu-south-2"     // Europe (Spain).
	EuWest1RegionID      = "eu-west-1"      // Europe (Ireland).
	EuWest2RegionID      = "eu-west-2"      // Europe (London).
	EuWest3RegionID      = "eu-west-3"      // Europe (Paris).
	IlCentral1RegionID   = "il-central-1"   // Israel (Tel Aviv).
	MeCentral1RegionID   = "me-central-1"   // Middle East (UAE).
	MeSouth1RegionID     = "me-south-1"     // Middle East (Bahrain).
	SaEast1RegionID      = "sa-east-1"      // South America (Sao Paulo).
	UsEast1RegionID      = "us-east-1"      // US East (N. Virginia).
	UsEast2RegionID      = "us-east-2"      // US East (Ohio).
	UsWest1RegionID      = "us-west-1"      // US West (N. California).
	UsWest2RegionID      = "us-west-2"      // US West (Oregon).
)

// AWS China partition's regions.
const (
	CnNorth1RegionID     = "cn-north-1"     // China (Beijing).
	CnNorthwest1RegionID = "cn-northwest-1" // China (Ningxia).
)

// AWS GovCloud (US) partition's regions.
const (
	UsGovEast1RegionID = "us-gov-east-1" // AWS GovCloud (US-East).
	UsGovWest1RegionID = "us-gov-west-1" // AWS GovCloud (US-West).
)

// AWS ISO (US) partition's regions.
const (
	UsIsoEast1RegionID = "us-iso-east-1" // US ISO East.
	UsIsoWest1RegionID = "us-iso-west-1" // US ISO WEST.
)

// AWS ISOB (US) partition's regions.
const (
	UsIsobEast1RegionID = "us-isob-east-1" // US ISOB East (Ohio).
)

// AWS ISOE (Europe) partition's regions.
const ()

// AWS ISOF partition's regions.
const ()

// DefaultResolver returns an Endpoint resolver that will be able
// to resolve endpoints for: AWS Standard, AWS China, AWS GovCloud (US), AWS ISO (US), AWS ISOB (US), AWS ISOE (Europe), and AWS ISOF.
//
// Use DefaultPartitions() to get the list of the default partitions.
func DefaultResolver() Resolver {
	return defaultPartitions
}

// DefaultPartitions returns a list of the partitions the SDK is bundled
// with. The available partitions are: AWS Standard, AWS China, AWS GovCloud (US), AWS ISO (US), AWS ISOB (US), AWS ISOE (Europe), and AWS ISOF.
//
//    partitions := endpoints.DefaultPartitions
//    for _, p := range partitions {
//        // ... inspect partitions
//    }
func DefaultPartitions() []Partition {
	return defaultPartitions.Partitions()
}

var defaultPartitions = partitions{
	awsPartition,
	awscnPartition,
	awsusgovPartition,
	awsisoPartition,
	awsisobPartition,
	awsisoePartition,
	awsisofPartition,
}

// AwsPartition returns the Resolver for AWS Standard.
func AwsPartition() Partition {
	return awsPartition.Partition()
}

var awsPartition = partition{
	ID:        "aws",
	Name:      "AWS Standard",
	DNSSuffix: "amazonaws.com",
	RegionRegex: regionRegex{
		Regexp: func() *regexp.Regexp {
			reg, _ := regexp.Compile("^(us|eu|ap|sa|ca|me|af|il)\\-\\w+\\-\\d+$")
			return reg
		}(),
	},
	Defaults: endpointDefaults{
		defaultKey{}: endpoint{
			Hostname:          "{service}.{region}.{dnsSuffix}",
			Protocols:         []string{"https"},
			SignatureVersions: []string{"v4"},
		},
		defaultKey{
			Variant: dualStackVariant,
		}: endpoint{
			Hostname:          "{service}.{region}.{dnsSuffix}",
			DNSSuffix:         "api.aws",
			Protocols:         []string{"https"},
			SignatureVersions: []string{"v4"},
		},
		defaultKey{
			Variant: fipsVariant,
		}: endpoint{
			Hostname:          "{service}-fips.{region}.{dnsSuffix}",
			DNSSuffix:         "amazonaws.com",
			Protocols:         []string{"https"},
			SignatureVersions: []string{"v4"},
		},
		defaultKey{
			Variant: fipsVariant | dualStackVariant,
		}: endpoint{
			Hostname:          "{service}-fips.{region}.{dnsSuffix}",
			DNSSuffix:         "api.aws",
			Protocols:         []string{"https"},
			SignatureVersions: []string{"v4"},
		},
	},
	Regions: regions{
		"af-south-1": region{
			Description: "Africa (Cape Town)",
		},
		"ap-east-1": region{
			Description: "Asia Pacific (Hong Kong)",
		},
		"ap-northeast-1": region{
			Description: "Asia Pacific (Tokyo)",
		},
		"ap-northeast-2": region{
			Description: "Asia Pacific (Seoul)",
		},
		"ap-northeast-3": region{
			Description: "Asia Pacific (Osaka)",
		},
		"ap-south-1": region{
			Description: "Asia Pacific (Mumbai)",
		},
		"ap-south-2": region{
			Description: "Asia Pacific (Hyderabad)",
		},
		"ap-southeast-1": region{
			Description: "Asia Pacific (Singapore)",
		},
		"ap-southeast-2": region{
			Description: "Asia Pacific (Sydney)",
		},
		"ap-southeast-3": region{
			Description: "Asia Pacific (Jakarta)",
		},
		"ap-southeast-4": region{
			Description: "Asia Pacific (Melbourne)",
		},
		"ca-central-1": region{
			Description: "Canada (Central)",
		},
		"ca-west-1": region{
			Description: "Canada West (Calgary)",
		},
		"eu-central-1": region{
			Description: "Europe (Frankfurt)",
		},
		"eu-central-2": region{
			Description: "Europe (Zurich)",
		},
		"eu-north-1": region{
			Description: "Europe (Stockholm)",
		},
		"eu-south-1": region{
			Description: "Europe (Milan)",
		},
		"eu-south-2": region{
			Description: "Europe (Spain)",
		},
		"eu-west-1": region{
			Description: "Europe (Ireland)",
		},
		"eu-west-2": region{
			Description: "Europe (London)",
		},
		"eu-west-3": region{
			Description: "Europe (Paris)",
		},
		"il-central-1": region{
			Description: "Israel (Tel Aviv)",
		},
		"me-central-1": region{
			Description: "Middle East (UAE)",
		},
		"me-south-1": region{
			Description: "Middle East (Bahrain)",
		},
		"sa-east-1": region{
			Description: "South America (Sao Paulo)",
		},
		"us-east-1": region{
			Description: "US East (N. Virginia)",
		},
		"us-east-2": region{
			Description: "US East (Ohio)",
		},
		"us-west-1": region{
			Description: "US West (N. California)",
		},
		"us-west-2": region{
			Description: "US West (Oregon)",
		},
	},
	Services: services{
		"a4b": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
			},
		},
		"access-analyzer": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-4",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region:  "ca-central-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "access-analyzer-fips.ca-central-1.amazonaws.com",
				},
				endpointKey{
					Region: "ca-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "fips-ca-central-1",
				}: endpoint{
					Hostname: "access-analyzer-fips.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "access-analyzer-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "access-analyzer-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-1",
				}: endpoint{
					Hostname: "access-analyzer-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "access-analyzer-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "il-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "access-analyzer-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "access-analyzer-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "access-analyzer-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "access-analyzer-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"account": service{
			PartitionEndpoint: "aws-global",
			IsRegionalized:    boxedFalse,
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "aws-global",
				}: endpoint{
					Hostname: "account.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
			},
		},
		"acm": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-4",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region:  "ca-central-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "acm-fips.ca-central-1.amazonaws.com",
				},
				endpointKey{
					Region: "ca-central-1-fips",
				}: endpoint{
					Hostname: "acm-fips.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "ca-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "ca-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "acm-fips.ca-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "ca-west-1-fips",
				}: endpoint{
					Hostname: "acm-fips.ca-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "il-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "acm-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-1-fips",
				}: endpoint{
					Hostname: "acm-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "acm-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2-fips",
				}: endpoint{
					Hostname: "acm-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "acm-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1-fips",
				}: endpoint{
					Hostname: "acm-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "acm-fips.us-west-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2-fips",
				}: endpoint{
					Hostname: "acm-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
			},
		},
		"acm-pca": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					Protocols: []string{"https"},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-4",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region:  "ca-central-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "acm-pca-fips.ca-central-1.amazonaws.com",
				},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "fips-ca-central-1",
				}: endpoint{
					Hostname: "acm-pca-fips.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "acm-pca-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "acm-pca-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-1",
				}: endpoint{
					Hostname: "acm-pca-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "acm-pca-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "il-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "acm-pca-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "acm-pca-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "acm-pca-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "acm-pca-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"agreement-marketplace": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
			},
		},
		"airflow": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"amplify": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"amplifybackend": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"amplifyuibuilder": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"aoss": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"api.detective": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					Protocols: []string{"https"},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region:  "ca-central-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "api.detective-fips.ca-central-1.amazonaws.com",
				},
				endpointKey{
					Region: "ca-central-1-fips",
				}: endpoint{
					Hostname: "api.detective-fips.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "il-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "api.detective-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-1-fips",
				}: endpoint{
					Hostname: "api.detective-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "api.detective-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2-fips",
				}: endpoint{
					Hostname: "api.detective-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "api.detective-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1-fips",
				}: endpoint{
					Hostname: "api.detective-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "api.detective-fips.us-west-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2-fips",
				}: endpoint{
					Hostname: "api.detective-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
			},
		},
		"api.ecr": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{},
				defaultKey{
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "ecr-fips.{region}.{dnsSuffix}",
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{
					Hostname: "api.ecr.af-south-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "af-south-1",
					},
				},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{
					Hostname: "api.ecr.ap-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-east-1",
					},
				},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{
					Hostname: "api.ecr.ap-northeast-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-northeast-1",
					},
				},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{
					Hostname: "api.ecr.ap-northeast-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-northeast-2",
					},
				},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{
					Hostname: "api.ecr.ap-northeast-3.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-northeast-3",
					},
				},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{
					Hostname: "api.ecr.ap-south-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-south-1",
					},
				},
				endpointKey{
					Region: "ap-south-2",
				}: endpoint{
					Hostname: "api.ecr.ap-south-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-south-2",
					},
				},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{
					Hostname: "api.ecr.ap-southeast-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-southeast-1",
					},
				},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{
					Hostname: "api.ecr.ap-southeast-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-southeast-2",
					},
				},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{
					Hostname: "api.ecr.ap-southeast-3.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-southeast-3",
					},
				},
				endpointKey{
					Region: "ap-southeast-4",
				}: endpoint{
					Hostname: "api.ecr.ap-southeast-4.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-southeast-4",
					},
				},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{
					Hostname: "api.ecr.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
				},
				endpointKey{
					Region: "ca-west-1",
				}: endpoint{
					Hostname: "api.ecr.ca-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-west-1",
					},
				},
				endpointKey{
					Region: "dkr-us-east-1",
				}: endpoint{
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region:  "dkr-us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "ecr-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "dkr-us-east-2",
				}: endpoint{
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region:  "dkr-us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "ecr-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "dkr-us-west-1",
				}: endpoint{
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region:  "dkr-us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "ecr-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "dkr-us-west-2",
				}: endpoint{
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region:  "dkr-us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "ecr-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{
					Hostname: "api.ecr.eu-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-central-1",
					},
				},
				endpointKey{
					Region: "eu-central-2",
				}: endpoint{
					Hostname: "api.ecr.eu-central-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-central-2",
					},
				},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{
					Hostname: "api.ecr.eu-north-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-north-1",
					},
				},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{
					Hostname: "api.ecr.eu-south-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-south-1",
					},
				},
				endpointKey{
					Region: "eu-south-2",
				}: endpoint{
					Hostname: "api.ecr.eu-south-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-south-2",
					},
				},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{
					Hostname: "api.ecr.eu-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-west-1",
					},
				},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{
					Hostname: "api.ecr.eu-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-west-2",
					},
				},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{
					Hostname: "api.ecr.eu-west-3.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-west-3",
					},
				},
				endpointKey{
					Region: "fips-dkr-us-east-1",
				}: endpoint{
					Hostname: "ecr-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-dkr-us-east-2",
				}: endpoint{
					Hostname: "ecr-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-dkr-us-west-1",
				}: endpoint{
					Hostname: "ecr-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-dkr-us-west-2",
				}: endpoint{
					Hostname: "ecr-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "ecr-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "ecr-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-1",
				}: endpoint{
					Hostname: "ecr-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "ecr-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "il-central-1",
				}: endpoint{
					Hostname: "api.ecr.il-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "il-central-1",
					},
				},
				endpointKey{
					Region: "me-central-1",
				}: endpoint{
					Hostname: "api.ecr.me-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "me-central-1",
					},
				},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{
					Hostname: "api.ecr.me-south-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "me-south-1",
					},
				},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{
					Hostname: "api.ecr.sa-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "sa-east-1",
					},
				},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{
					Hostname: "api.ecr.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "ecr-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{
					Hostname: "api.ecr.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
				},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "ecr-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{
					Hostname: "api.ecr.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
				},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "ecr-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{
					Hostname: "api.ecr.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
				},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "ecr-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
				},
			},
		},
		"api.ecr-public": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-east-1",
				}: endpoint{
					Hostname: "api.ecr-public.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{
					Hostname: "api.ecr-public.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
				},
			},
		},
		"api.elastic-inference": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{
					Hostname: "api.elastic-inference.ap-northeast-1.amazonaws.com",
				},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{
					Hostname: "api.elastic-inference.ap-northeast-2.amazonaws.com",
				},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{
					Hostname: "api.elastic-inference.eu-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{
					Hostname: "api.elastic-inference.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{
					Hostname: "api.elastic-inference.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{
					Hostname: "api.elastic-inference.us-west-2.amazonaws.com",
				},
			},
		},
		"api.fleethub.iot": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region:  "ca-central-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "api.fleethub.iot-fips.ca-central-1.amazonaws.com",
				},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "fips-ca-central-1",
				}: endpoint{
					Hostname: "api.fleethub.iot-fips.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "api.fleethub.iot-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "api.fleethub.iot-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "api.fleethub.iot-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "api.fleethub.iot-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "api.fleethub.iot-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "api.fleethub.iot-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"api.iotdeviceadvisor": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{
					Hostname: "api.iotdeviceadvisor.ap-northeast-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-northeast-1",
					},
				},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{
					Hostname: "api.iotdeviceadvisor.eu-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-west-1",
					},
				},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{
					Hostname: "api.iotdeviceadvisor.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{
					Hostname: "api.iotdeviceadvisor.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
				},
			},
		},
		"api.iotwireless": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{
					Hostname: "api.iotwireless.ap-northeast-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-northeast-1",
					},
				},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{
					Hostname: "api.iotwireless.ap-southeast-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-southeast-2",
					},
				},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{
					Hostname: "api.iotwireless.eu-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-central-1",
					},
				},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{
					Hostname: "api.iotwireless.eu-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-west-1",
					},
				},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{
					Hostname: "api.iotwireless.sa-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "sa-east-1",
					},
				},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{
					Hostname: "api.iotwireless.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{
					Hostname: "api.iotwireless.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
				},
			},
		},
		"api.mediatailor": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-4",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"api.pricing": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					CredentialScope: credentialScope{
						Service: "pricing",
					},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
			},
		},
		"api.sagemaker": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{},
				defaultKey{
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "api-fips.sagemaker.{region}.{dnsSuffix}",
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-4",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "ca-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "il-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "api-fips.sagemaker.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-1-fips",
				}: endpoint{
					Hostname: "api-fips.sagemaker.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "api-fips.sagemaker.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2-fips",
				}: endpoint{
					Hostname: "api-fips.sagemaker.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "api-fips.sagemaker.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1-fips",
				}: endpoint{
					Hostname: "api-fips.sagemaker.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "api-fips.sagemaker.us-west-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2-fips",
				}: endpoint{
					Hostname: "api-fips.sagemaker.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
			},
		},
		"api.tunneling.iot": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{},
				defaultKey{
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "api.tunneling.iot-fips.{region}.{dnsSuffix}",
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region:  "ca-central-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "api.tunneling.iot-fips.ca-central-1.amazonaws.com",
				},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "fips-ca-central-1",
				}: endpoint{
					Hostname: "api.tunneling.iot-fips.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "api.tunneling.iot-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "api.tunneling.iot-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-1",
				}: endpoint{
					Hostname: "api.tunneling.iot-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "api.tunneling.iot-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "me-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "api.tunneling.iot-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "api.tunneling.iot-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "api.tunneling.iot-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "api.tunneling.iot-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"apigateway": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-4",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region:  "ca-central-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "apigateway-fips.ca-central-1.amazonaws.com",
				},
				endpointKey{
					Region: "ca-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "ca-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "apigateway-fips.ca-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "fips-ca-central-1",
				}: endpoint{
					Hostname: "apigateway-fips.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-ca-west-1",
				}: endpoint{
					Hostname: "apigateway-fips.ca-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "apigateway-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "apigateway-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-1",
				}: endpoint{
					Hostname: "apigateway-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "apigateway-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "il-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "apigateway-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "apigateway-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "apigateway-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "apigateway-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"app-integrations": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"appconfig": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-4",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "ca-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "il-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"appconfigdata": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-4",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "ca-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "il-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"appflow": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "appflow-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "appflow-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-1",
				}: endpoint{
					Hostname: "appflow-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "appflow-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "appflow-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "appflow-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "appflow-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "appflow-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"application-autoscaling": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					Protocols: []string{"http", "https"},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-4",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "ca-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "il-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"applicationinsights": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "me-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"appmesh": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region:  "af-south-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "appmesh.af-south-1.api.aws",
				},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "ap-east-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "appmesh.ap-east-1.api.aws",
				},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region:  "ap-northeast-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "appmesh.ap-northeast-1.api.aws",
				},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region:  "ap-northeast-2",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "appmesh.ap-northeast-2.api.aws",
				},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region:  "ap-northeast-3",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "appmesh.ap-northeast-3.api.aws",
				},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region:  "ap-south-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "appmesh.ap-south-1.api.aws",
				},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region:  "ap-southeast-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "appmesh.ap-southeast-1.api.aws",
				},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region:  "ap-southeast-2",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "appmesh.ap-southeast-2.api.aws",
				},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{},
				endpointKey{
					Region:  "ap-southeast-3",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "appmesh.ap-southeast-3.api.aws",
				},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region:  "ca-central-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "appmesh.ca-central-1.api.aws",
				},
				endpointKey{
					Region:  "ca-central-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "appmesh-fips.ca-central-1.amazonaws.com",
				},
				endpointKey{
					Region:  "ca-central-1",
					Variant: fipsVariant | dualStackVariant,
				}: endpoint{
					Hostname: "appmesh-fips.ca-central-1.api.aws",
				},
				endpointKey{
					Region: "ca-central-1-fips",
				}: endpoint{
					Hostname: "appmesh-fips.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region:  "eu-central-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "appmesh.eu-central-1.api.aws",
				},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region:  "eu-north-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "appmesh.eu-north-1.api.aws",
				},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region:  "eu-south-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "appmesh.eu-south-1.api.aws",
				},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "eu-west-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "appmesh.eu-west-1.api.aws",
				},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "eu-west-2",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "appmesh.eu-west-2.api.aws",
				},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region:  "eu-west-3",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "appmesh.eu-west-3.api.aws",
				},
				endpointKey{
					Region: "il-central-1",
				}: endpoint{},
				endpointKey{
					Region:  "il-central-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "appmesh.il-central-1.api.aws",
				},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region:  "me-south-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "appmesh.me-south-1.api.aws",
				},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "sa-east-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "appmesh.sa-east-1.api.aws",
				},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "appmesh.us-east-1.api.aws",
				},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "appmesh-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant | dualStackVariant,
				}: endpoint{
					Hostname: "appmesh-fips.us-east-1.api.aws",
				},
				endpointKey{
					Region: "us-east-1-fips",
				}: endpoint{
					Hostname: "appmesh-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "appmesh.us-east-2.api.aws",
				},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "appmesh-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant | dualStackVariant,
				}: endpoint{
					Hostname: "appmesh-fips.us-east-2.api.aws",
				},
				endpointKey{
					Region: "us-east-2-fips",
				}: endpoint{
					Hostname: "appmesh-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "appmesh.us-west-1.api.aws",
				},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "appmesh-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant | dualStackVariant,
				}: endpoint{
					Hostname: "appmesh-fips.us-west-1.api.aws",
				},
				endpointKey{
					Region: "us-west-1-fips",
				}: endpoint{
					Hostname: "appmesh-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "appmesh.us-west-2.api.aws",
				},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "appmesh-fips.us-west-2.amazonaws.com",
				},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant | dualStackVariant,
				}: endpoint{
					Hostname: "appmesh-fips.us-west-2.api.aws",
				},
				endpointKey{
					Region: "us-west-2-fips",
				}: endpoint{
					Hostname: "appmesh-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
			},
		},
		"apprunner": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "apprunner-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "apprunner-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "apprunner-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "apprunner-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "apprunner-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "apprunner-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"appstream2": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					Protocols: []string{"https"},
					CredentialScope: credentialScope{
						Service: "appstream",
					},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "fips",
				}: endpoint{
					Hostname: "appstream2-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "appstream2-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-1-fips",
				}: endpoint{
					Hostname: "appstream2-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "appstream2-fips.us-west-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2-fips",
				}: endpoint{
					Hostname: "appstream2-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
			},
		},
		"appsync": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "me-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"aps": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					Protocols: []string{"https"},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"arc-zonal-shift": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-4",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "ca-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "il-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"athena": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region:  "af-south-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "athena.af-south-1.api.aws",
				},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "ap-east-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "athena.ap-east-1.api.aws",
				},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region:  "ap-northeast-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "athena.ap-northeast-1.api.aws",
				},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region:  "ap-northeast-2",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "athena.ap-northeast-2.api.aws",
				},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region:  "ap-northeast-3",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "athena.ap-northeast-3.api.aws",
				},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region:  "ap-south-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "athena.ap-south-1.api.aws",
				},
				endpointKey{
					Region: "ap-south-2",
				}: endpoint{},
				endpointKey{
					Region:  "ap-south-2",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "athena.ap-south-2.api.aws",
				},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region:  "ap-southeast-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "athena.ap-southeast-1.api.aws",
				},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region:  "ap-southeast-2",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "athena.ap-southeast-2.api.aws",
				},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{},
				endpointKey{
					Region:  "ap-southeast-3",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "athena.ap-southeast-3.api.aws",
				},
				endpointKey{
					Region: "ap-southeast-4",
				}: endpoint{},
				endpointKey{
					Region:  "ap-southeast-4",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "athena.ap-southeast-4.api.aws",
				},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region:  "ca-central-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "athena.ca-central-1.api.aws",
				},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region:  "eu-central-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "athena.eu-central-1.api.aws",
				},
				endpointKey{
					Region: "eu-central-2",
				}: endpoint{},
				endpointKey{
					Region:  "eu-central-2",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "athena.eu-central-2.api.aws",
				},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region:  "eu-north-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "athena.eu-north-1.api.aws",
				},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region:  "eu-south-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "athena.eu-south-1.api.aws",
				},
				endpointKey{
					Region: "eu-south-2",
				}: endpoint{},
				endpointKey{
					Region:  "eu-south-2",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "athena.eu-south-2.api.aws",
				},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "eu-west-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "athena.eu-west-1.api.aws",
				},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "eu-west-2",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "athena.eu-west-2.api.aws",
				},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region:  "eu-west-3",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "athena.eu-west-3.api.aws",
				},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "athena-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "athena-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-1",
				}: endpoint{
					Hostname: "athena-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "athena-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "il-central-1",
				}: endpoint{},
				endpointKey{
					Region:  "il-central-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "athena.il-central-1.api.aws",
				},
				endpointKey{
					Region: "me-central-1",
				}: endpoint{},
				endpointKey{
					Region:  "me-central-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "athena.me-central-1.api.aws",
				},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region:  "me-south-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "athena.me-south-1.api.aws",
				},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "sa-east-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "athena.sa-east-1.api.aws",
				},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "athena.us-east-1.api.aws",
				},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "athena-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant | dualStackVariant,
				}: endpoint{
					Hostname: "athena-fips.us-east-1.api.aws",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "athena.us-east-2.api.aws",
				},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "athena-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant | dualStackVariant,
				}: endpoint{
					Hostname: "athena-fips.us-east-2.api.aws",
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "athena.us-west-1.api.aws",
				},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "athena-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant | dualStackVariant,
				}: endpoint{
					Hostname: "athena-fips.us-west-1.api.aws",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "athena.us-west-2.api.aws",
				},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "athena-fips.us-west-2.amazonaws.com",
				},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant | dualStackVariant,
				}: endpoint{
					Hostname: "athena-fips.us-west-2.api.aws",
				},
			},
		},
		"auditmanager": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"autoscaling": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					Protocols: []string{"http", "https"},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-4",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region:  "ca-central-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "autoscaling-fips.ca-central-1.amazonaws.com",
				},
				endpointKey{
					Region: "ca-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "ca-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "autoscaling-fips.ca-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "fips-ca-central-1",
				}: endpoint{
					Hostname: "autoscaling-fips.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-ca-west-1",
				}: endpoint{
					Hostname: "autoscaling-fips.ca-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "autoscaling-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "autoscaling-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-1",
				}: endpoint{
					Hostname: "autoscaling-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "autoscaling-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "il-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "autoscaling-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "autoscaling-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "autoscaling-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "autoscaling-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"autoscaling-plans": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					Protocols: []string{"http", "https"},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"backup": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-4",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "il-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"backup-gateway": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"backupstorage": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-4",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "me-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"batch": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{},
				defaultKey{
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "fips.batch.{region}.{dnsSuffix}",
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-4",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "ca-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "fips.batch.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "fips.batch.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-1",
				}: endpoint{
					Hostname: "fips.batch.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "fips.batch.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "il-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "fips.batch.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "fips.batch.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "fips.batch.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "fips.batch.us-west-2.amazonaws.com",
				},
			},
		},
		"bedrock": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "bedrock-ap-northeast-1",
				}: endpoint{
					Hostname: "bedrock.ap-northeast-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-northeast-1",
					},
				},
				endpointKey{
					Region: "bedrock-ap-southeast-1",
				}: endpoint{
					Hostname: "bedrock.ap-southeast-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-southeast-1",
					},
				},
				endpointKey{
					Region: "bedrock-eu-central-1",
				}: endpoint{
					Hostname: "bedrock.eu-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-central-1",
					},
				},
				endpointKey{
					Region: "bedrock-fips-us-east-1",
				}: endpoint{
					Hostname: "bedrock-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				endpointKey{
					Region: "bedrock-fips-us-west-2",
				}: endpoint{
					Hostname: "bedrock-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
				},
				endpointKey{
					Region: "bedrock-runtime-ap-northeast-1",
				}: endpoint{
					Hostname: "bedrock-runtime.ap-northeast-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-northeast-1",
					},
				},
				endpointKey{
					Region: "bedrock-runtime-ap-southeast-1",
				}: endpoint{
					Hostname: "bedrock-runtime.ap-southeast-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-southeast-1",
					},
				},
				endpointKey{
					Region: "bedrock-runtime-eu-central-1",
				}: endpoint{
					Hostname: "bedrock-runtime.eu-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-central-1",
					},
				},
				endpointKey{
					Region: "bedrock-runtime-fips-us-east-1",
				}: endpoint{
					Hostname: "bedrock-runtime-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				endpointKey{
					Region: "bedrock-runtime-fips-us-west-2",
				}: endpoint{
					Hostname: "bedrock-runtime-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
				},
				endpointKey{
					Region: "bedrock-runtime-us-east-1",
				}: endpoint{
					Hostname: "bedrock-runtime.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				endpointKey{
					Region: "bedrock-runtime-us-west-2",
				}: endpoint{
					Hostname: "bedrock-runtime.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
				},
				endpointKey{
					Region: "bedrock-us-east-1",
				}: endpoint{
					Hostname: "bedrock.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				endpointKey{
					Region: "bedrock-us-west-2",
				}: endpoint{
					Hostname: "bedrock.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
				},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"billingconductor": service{
			PartitionEndpoint: "aws-global",
			IsRegionalized:    boxedFalse,
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "aws-global",
				}: endpoint{
					Hostname: "billingconductor.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
			},
		},
		"braket": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"budgets": service{
			PartitionEndpoint: "aws-global",
			IsRegionalized:    boxedFalse,
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "aws-global",
				}: endpoint{
					Hostname: "budgets.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
			},
		},
		"cases": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{

					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{

					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{},
			},
		},
		"cassandra": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "cassandra-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "cassandra-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "cassandra-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "cassandra-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"catalog.marketplace": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
			},
		},
		"ce": service{
			PartitionEndpoint: "aws-global",
			IsRegionalized:    boxedFalse,
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "aws-global",
				}: endpoint{
					Hostname: "ce.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
			},
		},
		"chime": service{
			PartitionEndpoint: "aws-global",
			IsRegionalized:    boxedFalse,
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					Protocols: []string{"https"},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "aws-global",
				}: endpoint{
					Hostname:  "chime.us-east-1.amazonaws.com",
					Protocols: []string{"https"},
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
			},
		},
		"cleanrooms": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"cloud9": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "il-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"cloudcontrolapi": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-4",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region:  "ca-central-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "cloudcontrolapi-fips.ca-central-1.amazonaws.com",
				},
				endpointKey{
					Region: "ca-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "ca-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "cloudcontrolapi-fips.ca-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "fips-ca-central-1",
				}: endpoint{
					Hostname: "cloudcontrolapi-fips.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-ca-west-1",
				}: endpoint{
					Hostname: "cloudcontrolapi-fips.ca-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "cloudcontrolapi-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "cloudcontrolapi-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-1",
				}: endpoint{
					Hostname: "cloudcontrolapi-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "cloudcontrolapi-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "il-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "cloudcontrolapi-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "cloudcontrolapi-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "cloudcontrolapi-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "cloudcontrolapi-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"clouddirectory": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"cloudformation": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-4",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "ca-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "il-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "cloudformation-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-1-fips",
				}: endpoint{
					Hostname: "cloudformation-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "cloudformation-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2-fips",
				}: endpoint{
					Hostname: "cloudformation-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "cloudformation-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1-fips",
				}: endpoint{
					Hostname: "cloudformation-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "cloudformation-fips.us-west-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2-fips",
				}: endpoint{
					Hostname: "cloudformation-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
			},
		},
		"cloudfront": service{
			PartitionEndpoint: "aws-global",
			IsRegionalized:    boxedFalse,
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "aws-global",
				}: endpoint{
					Hostname:  "cloudfront.amazonaws.com",
					Protocols: []string{"http", "https"},
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
			},
		},
		"cloudhsm": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
			},
		},
		"cloudhsmv2": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					CredentialScope: credentialScope{
						Service: "cloudhsm",
					},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "il-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"cloudsearch": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"cloudtrail": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-4",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "ca-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "cloudtrail-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "cloudtrail-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-1",
				}: endpoint{
					Hostname: "cloudtrail-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "cloudtrail-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "il-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "cloudtrail-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "cloudtrail-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "cloudtrail-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "cloudtrail-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"cloudtrail-data": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"codeartifact": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"codebuild": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-4",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "il-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "codebuild-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-1-fips",
				}: endpoint{
					Hostname: "codebuild-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "codebuild-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2-fips",
				}: endpoint{
					Hostname: "codebuild-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "codebuild-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1-fips",
				}: endpoint{
					Hostname: "codebuild-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "codebuild-fips.us-west-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2-fips",
				}: endpoint{
					Hostname: "codebuild-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
			},
		},
		"codecatalyst": service{
			PartitionEndpoint: "aws-global",
			IsRegionalized:    boxedFalse,
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "aws-global",
				}: endpoint{
					Hostname: "codecatalyst.global.api.aws",
				},
			},
		},
		"codecommit": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region:  "ca-central-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "codecommit-fips.ca-central-1.amazonaws.com",
				},
				endpointKey{
					Region: "ca-central-1-fips",
				}: endpoint{
					Hostname: "codecommit-fips.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "fips",
				}: endpoint{
					Hostname: "codecommit-fips.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "il-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "codecommit-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-1-fips",
				}: endpoint{
					Hostname: "codecommit-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "codecommit-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2-fips",
				}: endpoint{
					Hostname: "codecommit-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "codecommit-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1-fips",
				}: endpoint{
					Hostname: "codecommit-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "codecommit-fips.us-west-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2-fips",
				}: endpoint{
					Hostname: "codecommit-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
			},
		},
		"codedeploy": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-4",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "ca-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "il-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "codedeploy-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-1-fips",
				}: endpoint{
					Hostname: "codedeploy-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "codedeploy-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2-fips",
				}: endpoint{
					Hostname: "codedeploy-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "codedeploy-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1-fips",
				}: endpoint{
					Hostname: "codedeploy-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "codedeploy-fips.us-west-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2-fips",
				}: endpoint{
					Hostname: "codedeploy-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
			},
		},
		"codeguru-reviewer": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"codepipeline": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-4",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region:  "ca-central-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "codepipeline-fips.ca-central-1.amazonaws.com",
				},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "fips-ca-central-1",
				}: endpoint{
					Hostname: "codepipeline-fips.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "codepipeline-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "codepipeline-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-1",
				}: endpoint{
					Hostname: "codepipeline-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "codepipeline-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "il-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "codepipeline-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "codepipeline-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "codepipeline-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "codepipeline-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"codestar": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"codestar-connections": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"codestar-notifications": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"cognito-identity": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "cognito-identity-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "cognito-identity-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-1",
				}: endpoint{
					Hostname: "cognito-identity-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "cognito-identity-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "il-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "cognito-identity-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "cognito-identity-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "cognito-identity-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "cognito-identity-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"cognito-idp": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "cognito-idp-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "cognito-idp-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-1",
				}: endpoint{
					Hostname: "cognito-idp-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "cognito-idp-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "il-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "cognito-idp-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "cognito-idp-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "cognito-idp-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "cognito-idp-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"cognito-sync": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"comprehend": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					Protocols: []string{"https"},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "comprehend-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "comprehend-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "comprehend-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "comprehend-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "comprehend-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "comprehend-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"comprehendmedical": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "comprehendmedical-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "comprehendmedical-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "comprehendmedical-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "comprehendmedical-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "comprehendmedical-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "comprehendmedical-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"compute-optimizer": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{
					Hostname: "compute-optimizer.af-south-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "af-south-1",
					},
				},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{
					Hostname: "compute-optimizer.ap-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-east-1",
					},
				},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{
					Hostname: "compute-optimizer.ap-northeast-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-northeast-1",
					},
				},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{
					Hostname: "compute-optimizer.ap-northeast-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-northeast-2",
					},
				},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{
					Hostname: "compute-optimizer.ap-northeast-3.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-northeast-3",
					},
				},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{
					Hostname: "compute-optimizer.ap-south-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-south-1",
					},
				},
				endpointKey{
					Region: "ap-south-2",
				}: endpoint{
					Hostname: "compute-optimizer.ap-south-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-south-2",
					},
				},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{
					Hostname: "compute-optimizer.ap-southeast-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-southeast-1",
					},
				},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{
					Hostname: "compute-optimizer.ap-southeast-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-southeast-2",
					},
				},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{
					Hostname: "compute-optimizer.ap-southeast-3.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-southeast-3",
					},
				},
				endpointKey{
					Region: "ap-southeast-4",
				}: endpoint{
					Hostname: "compute-optimizer.ap-southeast-4.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-southeast-4",
					},
				},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{
					Hostname: "compute-optimizer.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
				},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{
					Hostname: "compute-optimizer.eu-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-central-1",
					},
				},
				endpointKey{
					Region: "eu-central-2",
				}: endpoint{
					Hostname: "compute-optimizer.eu-central-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-central-2",
					},
				},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{
					Hostname: "compute-optimizer.eu-north-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-north-1",
					},
				},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{
					Hostname: "compute-optimizer.eu-south-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-south-1",
					},
				},
				endpointKey{
					Region: "eu-south-2",
				}: endpoint{
					Hostname: "compute-optimizer.eu-south-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-south-2",
					},
				},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{
					Hostname: "compute-optimizer.eu-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-west-1",
					},
				},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{
					Hostname: "compute-optimizer.eu-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-west-2",
					},
				},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{
					Hostname: "compute-optimizer.eu-west-3.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-west-3",
					},
				},
				endpointKey{
					Region: "il-central-1",
				}: endpoint{
					Hostname: "compute-optimizer.il-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "il-central-1",
					},
				},
				endpointKey{
					Region: "me-central-1",
				}: endpoint{
					Hostname: "compute-optimizer.me-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "me-central-1",
					},
				},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{
					Hostname: "compute-optimizer.me-south-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "me-south-1",
					},
				},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{
					Hostname: "compute-optimizer.sa-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "sa-east-1",
					},
				},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{
					Hostname: "compute-optimizer.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{
					Hostname: "compute-optimizer.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{
					Hostname: "compute-optimizer.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{
					Hostname: "compute-optimizer.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
				},
			},
		},
		"config": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-4",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "ca-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "config-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "config-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-1",
				}: endpoint{
					Hostname: "config-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "config-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "il-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "config-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "config-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "config-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "config-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"connect": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "connect-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "connect-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "connect-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "connect-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"connect-campaigns": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "connect-campaigns-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "connect-campaigns-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "connect-campaigns-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "connect-campaigns-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"contact-lens": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"controltower": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-4",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region:  "ca-central-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "controltower-fips.ca-central-1.amazonaws.com",
				},
				endpointKey{
					Region: "ca-central-1-fips",
				}: endpoint{
					Hostname: "controltower-fips.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "il-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "controltower-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-1-fips",
				}: endpoint{
					Hostname: "controltower-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "controltower-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2-fips",
				}: endpoint{
					Hostname: "controltower-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "controltower-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1-fips",
				}: endpoint{
					Hostname: "controltower-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "controltower-fips.us-west-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2-fips",
				}: endpoint{
					Hostname: "controltower-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
			},
		},
		"cost-optimization-hub": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-east-1",
				}: endpoint{
					Hostname: "cost-optimization-hub.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
			},
		},
		"cur": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
			},
		},
		"data-ats.iot": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					Protocols: []string{"https"},
					CredentialScope: credentialScope{
						Service: "iotdata",
					},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region:  "ca-central-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "data.iot-fips.ca-central-1.amazonaws.com",
				},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "fips-ca-central-1",
				}: endpoint{
					Hostname: "data.iot-fips.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Service: "iotdata",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "data.iot-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Service: "iotdata",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "data.iot-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Service: "iotdata",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-1",
				}: endpoint{
					Hostname: "data.iot-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Service: "iotdata",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "data.iot-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Service: "iotdata",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "me-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "data.iot-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "data.iot-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "data.iot-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "data.iot-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"data.jobs.iot": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region:  "ca-central-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "data.jobs.iot-fips.ca-central-1.amazonaws.com",
				},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "fips-ca-central-1",
				}: endpoint{
					Hostname: "data.jobs.iot-fips.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "data.jobs.iot-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "data.jobs.iot-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-1",
				}: endpoint{
					Hostname: "data.jobs.iot-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "data.jobs.iot-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "data.jobs.iot-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "data.jobs.iot-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "data.jobs.iot-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "data.jobs.iot-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"data.mediastore": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"databrew": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "databrew-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "databrew-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-1",
				}: endpoint{
					Hostname: "databrew-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "databrew-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "databrew-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "databrew-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "databrew-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "databrew-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"dataexchange": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"datapipeline": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"datasync": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-4",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region:  "ca-central-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "datasync-fips.ca-central-1.amazonaws.com",
				},
				endpointKey{
					Region: "ca-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "ca-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "datasync-fips.ca-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "fips-ca-central-1",
				}: endpoint{
					Hostname: "datasync-fips.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-ca-west-1",
				}: endpoint{
					Hostname: "datasync-fips.ca-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "datasync-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "datasync-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-1",
				}: endpoint{
					Hostname: "datasync-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "datasync-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "il-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "datasync-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "datasync-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "datasync-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "datasync-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"datazone": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					DNSSuffix: "api.aws",
				},
				defaultKey{
					Variant: fipsVariant,
				}: endpoint{
					Hostname:  "{service}-fips.{region}.{dnsSuffix}",
					DNSSuffix: "api.aws",
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{
					Hostname: "datazone.af-south-1.api.aws",
				},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{
					Hostname: "datazone.ap-east-1.api.aws",
				},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{
					Hostname: "datazone.ap-northeast-1.api.aws",
				},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{
					Hostname: "datazone.ap-northeast-2.api.aws",
				},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{
					Hostname: "datazone.ap-northeast-3.api.aws",
				},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{
					Hostname: "datazone.ap-south-1.api.aws",
				},
				endpointKey{
					Region: "ap-south-2",
				}: endpoint{
					Hostname: "datazone.ap-south-2.api.aws",
				},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{
					Hostname: "datazone.ap-southeast-1.api.aws",
				},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{
					Hostname: "datazone.ap-southeast-2.api.aws",
				},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{
					Hostname: "datazone.ap-southeast-3.api.aws",
				},
				endpointKey{
					Region: "ap-southeast-4",
				}: endpoint{
					Hostname: "datazone.ap-southeast-4.api.aws",
				},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{
					Hostname: "datazone.ca-central-1.api.aws",
				},
				endpointKey{
					Region:  "ca-central-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "datazone-fips.ca-central-1.amazonaws.com",
				},
				endpointKey{
					Region: "ca-west-1",
				}: endpoint{
					Hostname: "datazone.ca-west-1.api.aws",
				},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{
					Hostname: "datazone.eu-central-1.api.aws",
				},
				endpointKey{
					Region: "eu-central-2",
				}: endpoint{
					Hostname: "datazone.eu-central-2.api.aws",
				},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{
					Hostname: "datazone.eu-north-1.api.aws",
				},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{
					Hostname: "datazone.eu-south-1.api.aws",
				},
				endpointKey{
					Region: "eu-south-2",
				}: endpoint{
					Hostname: "datazone.eu-south-2.api.aws",
				},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{
					Hostname: "datazone.eu-west-1.api.aws",
				},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{
					Hostname: "datazone.eu-west-2.api.aws",
				},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{
					Hostname: "datazone.eu-west-3.api.aws",
				},
				endpointKey{
					Region: "il-central-1",
				}: endpoint{
					Hostname: "datazone.il-central-1.api.aws",
				},
				endpointKey{
					Region: "me-central-1",
				}: endpoint{
					Hostname: "datazone.me-central-1.api.aws",
				},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{
					Hostname: "datazone.me-south-1.api.aws",
				},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{
					Hostname: "datazone.sa-east-1.api.aws",
				},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{
					Hostname: "datazone.us-east-1.api.aws",
				},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "datazone-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{
					Hostname: "datazone.us-east-2.api.aws",
				},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "datazone-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{
					Hostname: "datazone.us-west-1.api.aws",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{
					Hostname: "datazone.us-west-2.api.aws",
				},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "datazone-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"dax": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"devicefarm": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"devops-guru": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					Protocols: []string{"https"},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region:  "ca-central-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "devops-guru-fips.ca-central-1.amazonaws.com",
				},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "fips-ca-central-1",
				}: endpoint{
					Hostname: "devops-guru-fips.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "devops-guru-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "devops-guru-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-1",
				}: endpoint{
					Hostname: "devops-guru-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "devops-guru-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "devops-guru-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "devops-guru-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "devops-guru-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "devops-guru-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"directconnect": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-4",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "ca-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "directconnect-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "directconnect-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-1",
				}: endpoint{
					Hostname: "directconnect-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "directconnect-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "il-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "directconnect-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "directconnect-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "directconnect-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "directconnect-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"discovery": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"dlm": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-4",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "ca-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "il-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"dms": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-4",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "ca-west-1",
				}: endpoint{},
				endpointKey{
					Region: "dms",
				}: endpoint{
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region:  "dms",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "dms-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "dms-fips",
				}: endpoint{
					Hostname: "dms-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "il-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "dms-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-1-fips",
				}: endpoint{
					Hostname: "dms-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "dms-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2-fips",
				}: endpoint{
					Hostname: "dms-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "dms-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1-fips",
				}: endpoint{
					Hostname: "dms-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "dms-fips.us-west-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2-fips",
				}: endpoint{
					Hostname: "dms-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
			},
		},
		"docdb": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{
					Hostname: "rds.ap-northeast-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-northeast-1",
					},
				},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{
					Hostname: "rds.ap-northeast-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-northeast-2",
					},
				},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{
					Hostname: "rds.ap-south-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-south-1",
					},
				},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{
					Hostname: "rds.ap-southeast-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-southeast-1",
					},
				},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{
					Hostname: "rds.ap-southeast-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-southeast-2",
					},
				},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{
					Hostname: "rds.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
				},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{
					Hostname: "rds.eu-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-central-1",
					},
				},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{
					Hostname: "rds.eu-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-west-1",
					},
				},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{
					Hostname: "rds.eu-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-west-2",
					},
				},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{
					Hostname: "rds.eu-west-3.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-west-3",
					},
				},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{
					Hostname: "rds.sa-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "sa-east-1",
					},
				},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{
					Hostname: "rds.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{
					Hostname: "rds.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{
					Hostname: "rds.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
				},
			},
		},
		"drs": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-4",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "drs-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "drs-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-1",
				}: endpoint{
					Hostname: "drs-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "drs-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "il-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "drs-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "drs-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "drs-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "drs-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"ds": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-4",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region:  "ca-central-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "ds-fips.ca-central-1.amazonaws.com",
				},
				endpointKey{
					Region: "ca-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "ca-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "ds-fips.ca-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "fips-ca-central-1",
				}: endpoint{
					Hostname: "ds-fips.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-ca-west-1",
				}: endpoint{
					Hostname: "ds-fips.ca-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "ds-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "ds-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-1",
				}: endpoint{
					Hostname: "ds-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "ds-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "il-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "ds-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "ds-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "ds-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "ds-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"dynamodb": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					Protocols: []string{"http", "https"},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-4",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region:  "ca-central-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "dynamodb-fips.ca-central-1.amazonaws.com",
				},
				endpointKey{
					Region: "ca-central-1-fips",
				}: endpoint{
					Hostname: "dynamodb-fips.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "ca-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "ca-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "dynamodb-fips.ca-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "ca-west-1-fips",
				}: endpoint{
					Hostname: "dynamodb-fips.ca-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "il-central-1",
				}: endpoint{},
				endpointKey{
					Region: "local",
				}: endpoint{
					Hostname:  "localhost:8000",
					Protocols: []string{"http"},
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				endpointKey{
					Region: "me-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "dynamodb-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-1-fips",
				}: endpoint{
					Hostname: "dynamodb-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "dynamodb-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2-fips",
				}: endpoint{
					Hostname: "dynamodb-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "dynamodb-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1-fips",
				}: endpoint{
					Hostname: "dynamodb-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "dynamodb-fips.us-west-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2-fips",
				}: endpoint{
					Hostname: "dynamodb-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
			},
		},
		"ebs": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-4",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region:  "ca-central-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "ebs-fips.ca-central-1.amazonaws.com",
				},
				endpointKey{
					Region: "ca-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "ca-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "ebs-fips.ca-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "fips-ca-central-1",
				}: endpoint{
					Hostname: "ebs-fips.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-ca-west-1",
				}: endpoint{
					Hostname: "ebs-fips.ca-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "ebs-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "ebs-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-1",
				}: endpoint{
					Hostname: "ebs-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "ebs-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "il-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "ebs-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "ebs-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "ebs-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "ebs-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"ec2": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					Protocols: []string{"http", "https"},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region:  "ap-south-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "ec2.ap-south-1.api.aws",
				},
				endpointKey{
					Region: "ap-south-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-4",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region:  "ca-central-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "ec2-fips.ca-central-1.amazonaws.com",
				},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "eu-west-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "ec2.eu-west-1.api.aws",
				},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "fips-ca-central-1",
				}: endpoint{
					Hostname: "ec2-fips.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "ec2-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "ec2-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-1",
				}: endpoint{
					Hostname: "ec2-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "ec2-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "il-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "sa-east-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "ec2.sa-east-1.api.aws",
				},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "ec2.us-east-1.api.aws",
				},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "ec2-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "ec2.us-east-2.api.aws",
				},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "ec2-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "ec2-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "ec2.us-west-2.api.aws",
				},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "ec2-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"ecs": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-4",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "ca-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "ecs-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "ecs-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-1",
				}: endpoint{
					Hostname: "ecs-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "ecs-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "il-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "ecs-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "ecs-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "ecs-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "ecs-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"edge.sagemaker": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"eks": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					Protocols: []string{"http", "https"},
				},
				defaultKey{
					Variant: fipsVariant,
				}: endpoint{
					Hostname:  "fips.eks.{region}.{dnsSuffix}",
					Protocols: []string{"http", "https"},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-4",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "ca-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "fips.eks.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "fips.eks.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-1",
				}: endpoint{
					Hostname: "fips.eks.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "fips.eks.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "il-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "fips.eks.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "fips.eks.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "fips.eks.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "fips.eks.us-west-2.amazonaws.com",
				},
			},
		},
		"eks-auth": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					DNSSuffix: "api.aws",
				},
				defaultKey{
					Variant: fipsVariant,
				}: endpoint{
					Hostname:  "{service}-fips.{region}.{dnsSuffix}",
					DNSSuffix: "api.aws",
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{
					Hostname: "eks-auth.af-south-1.api.aws",
				},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{
					Hostname: "eks-auth.ap-east-1.api.aws",
				},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{
					Hostname: "eks-auth.ap-northeast-1.api.aws",
				},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{
					Hostname: "eks-auth.ap-northeast-2.api.aws",
				},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{
					Hostname: "eks-auth.ap-northeast-3.api.aws",
				},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{
					Hostname: "eks-auth.ap-south-1.api.aws",
				},
				endpointKey{
					Region: "ap-south-2",
				}: endpoint{
					Hostname: "eks-auth.ap-south-2.api.aws",
				},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{
					Hostname: "eks-auth.ap-southeast-1.api.aws",
				},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{
					Hostname: "eks-auth.ap-southeast-2.api.aws",
				},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{
					Hostname: "eks-auth.ap-southeast-3.api.aws",
				},
				endpointKey{
					Region: "ap-southeast-4",
				}: endpoint{
					Hostname: "eks-auth.ap-southeast-4.api.aws",
				},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{
					Hostname: "eks-auth.ca-central-1.api.aws",
				},
				endpointKey{
					Region: "ca-west-1",
				}: endpoint{
					Hostname: "eks-auth.ca-west-1.api.aws",
				},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{
					Hostname: "eks-auth.eu-central-1.api.aws",
				},
				endpointKey{
					Region: "eu-central-2",
				}: endpoint{
					Hostname: "eks-auth.eu-central-2.api.aws",
				},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{
					Hostname: "eks-auth.eu-north-1.api.aws",
				},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{
					Hostname: "eks-auth.eu-south-1.api.aws",
				},
				endpointKey{
					Region: "eu-south-2",
				}: endpoint{
					Hostname: "eks-auth.eu-south-2.api.aws",
				},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{
					Hostname: "eks-auth.eu-west-1.api.aws",
				},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{
					Hostname: "eks-auth.eu-west-2.api.aws",
				},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{
					Hostname: "eks-auth.eu-west-3.api.aws",
				},
				endpointKey{
					Region: "il-central-1",
				}: endpoint{
					Hostname: "eks-auth.il-central-1.api.aws",
				},
				endpointKey{
					Region: "me-central-1",
				}: endpoint{
					Hostname: "eks-auth.me-central-1.api.aws",
				},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{
					Hostname: "eks-auth.me-south-1.api.aws",
				},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{
					Hostname: "eks-auth.sa-east-1.api.aws",
				},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{
					Hostname: "eks-auth.us-east-1.api.aws",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{
					Hostname: "eks-auth.us-east-2.api.aws",
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{
					Hostname: "eks-auth.us-west-1.api.aws",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{
					Hostname: "eks-auth.us-west-2.api.aws",
				},
			},
		},
		"elasticache": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-4",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "ca-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "fips",
				}: endpoint{
					Hostname: "elasticache-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "il-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "elasticache-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-1-fips",
				}: endpoint{
					Hostname: "elasticache-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "elasticache-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2-fips",
				}: endpoint{
					Hostname: "elasticache-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "elasticache-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1-fips",
				}: endpoint{
					Hostname: "elasticache-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "elasticache-fips.us-west-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2-fips",
				}: endpoint{
					Hostname: "elasticache-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
			},
		},
		"elasticbeanstalk": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "elasticbeanstalk-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "elasticbeanstalk-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-1",
				}: endpoint{
					Hostname: "elasticbeanstalk-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "elasticbeanstalk-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "il-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "elasticbeanstalk-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "elasticbeanstalk-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "elasticbeanstalk-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "elasticbeanstalk-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"elasticfilesystem": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region:  "af-south-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "elasticfilesystem-fips.af-south-1.amazonaws.com",
				},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "ap-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "elasticfilesystem-fips.ap-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region:  "ap-northeast-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "elasticfilesystem-fips.ap-northeast-1.amazonaws.com",
				},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region:  "ap-northeast-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "elasticfilesystem-fips.ap-northeast-2.amazonaws.com",
				},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region:  "ap-northeast-3",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "elasticfilesystem-fips.ap-northeast-3.amazonaws.com",
				},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region:  "ap-south-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "elasticfilesystem-fips.ap-south-1.amazonaws.com",
				},
				endpointKey{
					Region: "ap-south-2",
				}: endpoint{},
				endpointKey{
					Region:  "ap-south-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "elasticfilesystem-fips.ap-south-2.amazonaws.com",
				},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region:  "ap-southeast-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "elasticfilesystem-fips.ap-southeast-1.amazonaws.com",
				},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region:  "ap-southeast-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "elasticfilesystem-fips.ap-southeast-2.amazonaws.com",
				},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{},
				endpointKey{
					Region:  "ap-southeast-3",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "elasticfilesystem-fips.ap-southeast-3.amazonaws.com",
				},
				endpointKey{
					Region: "ap-southeast-4",
				}: endpoint{},
				endpointKey{
					Region:  "ap-southeast-4",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "elasticfilesystem-fips.ap-southeast-4.amazonaws.com",
				},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region:  "ca-central-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "elasticfilesystem-fips.ca-central-1.amazonaws.com",
				},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region:  "eu-central-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "elasticfilesystem-fips.eu-central-1.amazonaws.com",
				},
				endpointKey{
					Region: "eu-central-2",
				}: endpoint{},
				endpointKey{
					Region:  "eu-central-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "elasticfilesystem-fips.eu-central-2.amazonaws.com",
				},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region:  "eu-north-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "elasticfilesystem-fips.eu-north-1.amazonaws.com",
				},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region:  "eu-south-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "elasticfilesystem-fips.eu-south-1.amazonaws.com",
				},
				endpointKey{
					Region: "eu-south-2",
				}: endpoint{},
				endpointKey{
					Region:  "eu-south-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "elasticfilesystem-fips.eu-south-2.amazonaws.com",
				},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "eu-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "elasticfilesystem-fips.eu-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "eu-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "elasticfilesystem-fips.eu-west-2.amazonaws.com",
				},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region:  "eu-west-3",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "elasticfilesystem-fips.eu-west-3.amazonaws.com",
				},
				endpointKey{
					Region: "fips-af-south-1",
				}: endpoint{
					Hostname: "elasticfilesystem-fips.af-south-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "af-south-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-ap-east-1",
				}: endpoint{
					Hostname: "elasticfilesystem-fips.ap-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-ap-northeast-1",
				}: endpoint{
					Hostname: "elasticfilesystem-fips.ap-northeast-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-northeast-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-ap-northeast-2",
				}: endpoint{
					Hostname: "elasticfilesystem-fips.ap-northeast-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-northeast-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-ap-northeast-3",
				}: endpoint{
					Hostname: "elasticfilesystem-fips.ap-northeast-3.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-northeast-3",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-ap-south-1",
				}: endpoint{
					Hostname: "elasticfilesystem-fips.ap-south-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-south-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-ap-south-2",
				}: endpoint{
					Hostname: "elasticfilesystem-fips.ap-south-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-south-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-ap-southeast-1",
				}: endpoint{
					Hostname: "elasticfilesystem-fips.ap-southeast-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-southeast-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-ap-southeast-2",
				}: endpoint{
					Hostname: "elasticfilesystem-fips.ap-southeast-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-southeast-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-ap-southeast-3",
				}: endpoint{
					Hostname: "elasticfilesystem-fips.ap-southeast-3.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-southeast-3",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-ap-southeast-4",
				}: endpoint{
					Hostname: "elasticfilesystem-fips.ap-southeast-4.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-southeast-4",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-ca-central-1",
				}: endpoint{
					Hostname: "elasticfilesystem-fips.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-eu-central-1",
				}: endpoint{
					Hostname: "elasticfilesystem-fips.eu-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-central-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-eu-central-2",
				}: endpoint{
					Hostname: "elasticfilesystem-fips.eu-central-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-central-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-eu-north-1",
				}: endpoint{
					Hostname: "elasticfilesystem-fips.eu-north-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-north-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-eu-south-1",
				}: endpoint{
					Hostname: "elasticfilesystem-fips.eu-south-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-south-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-eu-south-2",
				}: endpoint{
					Hostname: "elasticfilesystem-fips.eu-south-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-south-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-eu-west-1",
				}: endpoint{
					Hostname: "elasticfilesystem-fips.eu-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-eu-west-2",
				}: endpoint{
					Hostname: "elasticfilesystem-fips.eu-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-eu-west-3",
				}: endpoint{
					Hostname: "elasticfilesystem-fips.eu-west-3.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-west-3",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-il-central-1",
				}: endpoint{
					Hostname: "elasticfilesystem-fips.il-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "il-central-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-me-central-1",
				}: endpoint{
					Hostname: "elasticfilesystem-fips.me-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "me-central-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-me-south-1",
				}: endpoint{
					Hostname: "elasticfilesystem-fips.me-south-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "me-south-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-sa-east-1",
				}: endpoint{
					Hostname: "elasticfilesystem-fips.sa-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "sa-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "elasticfilesystem-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "elasticfilesystem-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-1",
				}: endpoint{
					Hostname: "elasticfilesystem-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "elasticfilesystem-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "il-central-1",
				}: endpoint{},
				endpointKey{
					Region:  "il-central-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "elasticfilesystem-fips.il-central-1.amazonaws.com",
				},
				endpointKey{
					Region: "me-central-1",
				}: endpoint{},
				endpointKey{
					Region:  "me-central-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "elasticfilesystem-fips.me-central-1.amazonaws.com",
				},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region:  "me-south-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "elasticfilesystem-fips.me-south-1.amazonaws.com",
				},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "sa-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "elasticfilesystem-fips.sa-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "elasticfilesystem-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "elasticfilesystem-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "elasticfilesystem-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "elasticfilesystem-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"elasticloadbalancing": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					Protocols: []string{"https"},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-4",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "ca-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "elasticloadbalancing-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "elasticloadbalancing-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-1",
				}: endpoint{
					Hostname: "elasticloadbalancing-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "elasticloadbalancing-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "il-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "elasticloadbalancing-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "elasticloadbalancing-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "elasticloadbalancing-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "elasticloadbalancing-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"elasticmapreduce": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					SSLCommonName: "{region}.{service}.{dnsSuffix}",
					Protocols:     []string{"https"},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-4",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region:  "ca-central-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "elasticmapreduce-fips.ca-central-1.amazonaws.com",
				},
				endpointKey{
					Region: "ca-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "ca-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "elasticmapreduce-fips.ca-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{
					SSLCommonName: "{service}.{region}.{dnsSuffix}",
				},
				endpointKey{
					Region: "eu-central-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "fips-ca-central-1",
				}: endpoint{
					Hostname: "elasticmapreduce-fips.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-ca-west-1",
				}: endpoint{
					Hostname: "elasticmapreduce-fips.ca-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "elasticmapreduce-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "elasticmapreduce-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-1",
				}: endpoint{
					Hostname: "elasticmapreduce-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "elasticmapreduce-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "il-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{
					SSLCommonName: "{service}.{region}.{dnsSuffix}",
				},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname:      "elasticmapreduce-fips.us-east-1.amazonaws.com",
					SSLCommonName: "{service}.{region}.{dnsSuffix}",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "elasticmapreduce.us-east-2.api.aws",
				},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "elasticmapreduce-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "elasticmapreduce-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "elasticmapreduce-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"elastictranscoder": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"email": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region:  "ca-central-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "email-fips.ca-central-1.amazonaws.com",
				},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "fips-ca-central-1",
				}: endpoint{
					Hostname: "email-fips.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "email-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "email-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-1",
				}: endpoint{
					Hostname: "email-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "email-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "il-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "email-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "email-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "email-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "email-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"emr-containers": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region:  "ca-central-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "emr-containers-fips.ca-central-1.amazonaws.com",
				},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "fips-ca-central-1",
				}: endpoint{
					Hostname: "emr-containers-fips.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "emr-containers-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "emr-containers-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-1",
				}: endpoint{
					Hostname: "emr-containers-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "emr-containers-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "me-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "emr-containers-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "emr-containers-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "emr-containers-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "emr-containers-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"emr-serverless": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region:  "ca-central-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "emr-serverless-fips.ca-central-1.amazonaws.com",
				},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "fips-ca-central-1",
				}: endpoint{
					Hostname: "emr-serverless-fips.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "emr-serverless-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "emr-serverless-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-1",
				}: endpoint{
					Hostname: "emr-serverless-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "emr-serverless-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "me-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "emr-serverless-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "emr-serverless-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "emr-serverless-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "emr-serverless-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"entitlement.marketplace": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					CredentialScope: credentialScope{
						Service: "aws-marketplace",
					},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
			},
		},
		"es": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region:  "af-south-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "aos.af-south-1.api.aws",
				},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "ap-east-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "aos.ap-east-1.api.aws",
				},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region:  "ap-northeast-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "aos.ap-northeast-1.api.aws",
				},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region:  "ap-northeast-2",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "aos.ap-northeast-2.api.aws",
				},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region:  "ap-northeast-3",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "aos.ap-northeast-3.api.aws",
				},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region:  "ap-south-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "aos.ap-south-1.api.aws",
				},
				endpointKey{
					Region: "ap-south-2",
				}: endpoint{},
				endpointKey{
					Region:  "ap-south-2",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "aos.ap-south-2.api.aws",
				},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region:  "ap-southeast-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "aos.ap-southeast-1.api.aws",
				},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region:  "ap-southeast-2",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "aos.ap-southeast-2.api.aws",
				},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{},
				endpointKey{
					Region:  "ap-southeast-3",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "aos.ap-southeast-3.api.aws",
				},
				endpointKey{
					Region: "ap-southeast-4",
				}: endpoint{},
				endpointKey{
					Region:  "ap-southeast-4",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "aos.ap-southeast-4.api.aws",
				},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region:  "ca-central-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "aos.ca-central-1.api.aws",
				},
				endpointKey{
					Region: "ca-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "ca-west-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "aos.ca-west-1.api.aws",
				},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region:  "eu-central-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "aos.eu-central-1.api.aws",
				},
				endpointKey{
					Region: "eu-central-2",
				}: endpoint{},
				endpointKey{
					Region:  "eu-central-2",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "aos.eu-central-2.api.aws",
				},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region:  "eu-north-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "aos.eu-north-1.api.aws",
				},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region:  "eu-south-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "aos.eu-south-1.api.aws",
				},
				endpointKey{
					Region: "eu-south-2",
				}: endpoint{},
				endpointKey{
					Region:  "eu-south-2",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "aos.eu-south-2.api.aws",
				},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "eu-west-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "aos.eu-west-1.api.aws",
				},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "eu-west-2",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "aos.eu-west-2.api.aws",
				},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region:  "eu-west-3",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "aos.eu-west-3.api.aws",
				},
				endpointKey{
					Region: "fips",
				}: endpoint{
					Hostname: "es-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "il-central-1",
				}: endpoint{},
				endpointKey{
					Region:  "il-central-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "aos.il-central-1.api.aws",
				},
				endpointKey{
					Region: "me-central-1",
				}: endpoint{},
				endpointKey{
					Region:  "me-central-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "aos.me-central-1.api.aws",
				},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region:  "me-south-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "aos.me-south-1.api.aws",
				},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "sa-east-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "aos.sa-east-1.api.aws",
				},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "aos.us-east-1.api.aws",
				},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "es-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-1-fips",
				}: endpoint{
					Hostname: "es-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "aos.us-east-2.api.aws",
				},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "es-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2-fips",
				}: endpoint{
					Hostname: "es-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "aos.us-west-1.api.aws",
				},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "es-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1-fips",
				}: endpoint{
					Hostname: "es-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "aos.us-west-2.api.aws",
				},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "es-fips.us-west-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2-fips",
				}: endpoint{
					Hostname: "es-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
			},
		},
		"events": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-4",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "ca-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "events-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "events-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-1",
				}: endpoint{
					Hostname: "events-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "events-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "il-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "events-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "events-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "events-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "events-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"evidently": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{
					Hostname: "evidently.ap-northeast-1.amazonaws.com",
				},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{
					Hostname: "evidently.ap-southeast-1.amazonaws.com",
				},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{
					Hostname: "evidently.ap-southeast-2.amazonaws.com",
				},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{
					Hostname: "evidently.eu-central-1.amazonaws.com",
				},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{
					Hostname: "evidently.eu-north-1.amazonaws.com",
				},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{
					Hostname: "evidently.eu-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{
					Hostname: "evidently.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{
					Hostname: "evidently.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{
					Hostname: "evidently.us-west-2.amazonaws.com",
				},
			},
		},
		"finspace": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"finspace-api": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"firehose": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-4",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "ca-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "firehose-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "firehose-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-1",
				}: endpoint{
					Hostname: "firehose-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "firehose-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "il-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "firehose-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "firehose-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "firehose-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "firehose-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"fms": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					Protocols: []string{"https"},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region:  "af-south-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "fms-fips.af-south-1.amazonaws.com",
				},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "ap-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "fms-fips.ap-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region:  "ap-northeast-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "fms-fips.ap-northeast-1.amazonaws.com",
				},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region:  "ap-northeast-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "fms-fips.ap-northeast-2.amazonaws.com",
				},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region:  "ap-south-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "fms-fips.ap-south-1.amazonaws.com",
				},
				endpointKey{
					Region: "ap-south-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region:  "ap-southeast-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "fms-fips.ap-southeast-1.amazonaws.com",
				},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region:  "ap-southeast-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "fms-fips.ap-southeast-2.amazonaws.com",
				},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-4",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region:  "ca-central-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "fms-fips.ca-central-1.amazonaws.com",
				},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region:  "eu-central-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "fms-fips.eu-central-1.amazonaws.com",
				},
				endpointKey{
					Region: "eu-central-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region:  "eu-south-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "fms-fips.eu-south-1.amazonaws.com",
				},
				endpointKey{
					Region: "eu-south-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "eu-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "fms-fips.eu-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "eu-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "fms-fips.eu-west-2.amazonaws.com",
				},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region:  "eu-west-3",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "fms-fips.eu-west-3.amazonaws.com",
				},
				endpointKey{
					Region: "fips-af-south-1",
				}: endpoint{
					Hostname: "fms-fips.af-south-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "af-south-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-ap-east-1",
				}: endpoint{
					Hostname: "fms-fips.ap-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-ap-northeast-1",
				}: endpoint{
					Hostname: "fms-fips.ap-northeast-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-northeast-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-ap-northeast-2",
				}: endpoint{
					Hostname: "fms-fips.ap-northeast-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-northeast-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-ap-south-1",
				}: endpoint{
					Hostname: "fms-fips.ap-south-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-south-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-ap-southeast-1",
				}: endpoint{
					Hostname: "fms-fips.ap-southeast-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-southeast-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-ap-southeast-2",
				}: endpoint{
					Hostname: "fms-fips.ap-southeast-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-southeast-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-ca-central-1",
				}: endpoint{
					Hostname: "fms-fips.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-eu-central-1",
				}: endpoint{
					Hostname: "fms-fips.eu-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-central-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-eu-south-1",
				}: endpoint{
					Hostname: "fms-fips.eu-south-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-south-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-eu-west-1",
				}: endpoint{
					Hostname: "fms-fips.eu-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-eu-west-2",
				}: endpoint{
					Hostname: "fms-fips.eu-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-eu-west-3",
				}: endpoint{
					Hostname: "fms-fips.eu-west-3.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-west-3",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-me-south-1",
				}: endpoint{
					Hostname: "fms-fips.me-south-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "me-south-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-sa-east-1",
				}: endpoint{
					Hostname: "fms-fips.sa-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "sa-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "fms-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "fms-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-1",
				}: endpoint{
					Hostname: "fms-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "fms-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "il-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region:  "me-south-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "fms-fips.me-south-1.amazonaws.com",
				},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "sa-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "fms-fips.sa-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "fms-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "fms-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "fms-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "fms-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"forecast": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "forecast-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "forecast-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "forecast-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "forecast-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "forecast-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "forecast-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"forecastquery": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "forecastquery-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "forecastquery-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "forecastquery-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "forecastquery-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "forecastquery-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "forecastquery-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"frauddetector": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"fsx": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-4",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region:  "ca-central-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "fsx-fips.ca-central-1.amazonaws.com",
				},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "fips-ca-central-1",
				}: endpoint{
					Hostname: "fsx-fips.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-prod-ca-central-1",
				}: endpoint{
					Hostname: "fsx-fips.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-prod-us-east-1",
				}: endpoint{
					Hostname: "fsx-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-prod-us-east-2",
				}: endpoint{
					Hostname: "fsx-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-prod-us-west-1",
				}: endpoint{
					Hostname: "fsx-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-prod-us-west-2",
				}: endpoint{
					Hostname: "fsx-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "fsx-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "fsx-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-1",
				}: endpoint{
					Hostname: "fsx-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "fsx-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "il-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "prod-ca-central-1",
				}: endpoint{
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region:  "prod-ca-central-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "fsx-fips.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "prod-us-east-1",
				}: endpoint{
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region:  "prod-us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "fsx-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "prod-us-east-2",
				}: endpoint{
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region:  "prod-us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "fsx-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "prod-us-west-1",
				}: endpoint{
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region:  "prod-us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "fsx-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "prod-us-west-2",
				}: endpoint{
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region:  "prod-us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "fsx-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "fsx-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "fsx-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "fsx-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "fsx-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"gamelift": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"geo": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"glacier": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					Protocols: []string{"http", "https"},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region:  "ca-central-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "glacier-fips.ca-central-1.amazonaws.com",
				},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "fips-ca-central-1",
				}: endpoint{
					Hostname: "glacier-fips.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "glacier-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "glacier-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-1",
				}: endpoint{
					Hostname: "glacier-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "glacier-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "glacier-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "glacier-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "glacier-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "glacier-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"glue": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-4",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "glue-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "glue-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-1",
				}: endpoint{
					Hostname: "glue-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "glue-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "il-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "glue-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "glue-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "glue-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "glue-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"grafana": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{
					Hostname: "grafana.ap-northeast-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-northeast-1",
					},
				},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{
					Hostname: "grafana.ap-northeast-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-northeast-2",
					},
				},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{
					Hostname: "grafana.ap-southeast-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-southeast-1",
					},
				},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{
					Hostname: "grafana.ap-southeast-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-southeast-2",
					},
				},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{
					Hostname: "grafana.eu-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-central-1",
					},
				},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{
					Hostname: "grafana.eu-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-west-1",
					},
				},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{
					Hostname: "grafana.eu-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-west-2",
					},
				},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{
					Hostname: "grafana.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{
					Hostname: "grafana.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{
					Hostname: "grafana.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
				},
			},
		},
		"greengrass": service{
			IsRegionalized: boxedTrue,
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					Protocols: []string{"https"},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region:  "ca-central-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "greengrass-fips.ca-central-1.amazonaws.com",
				},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "fips-ca-central-1",
				}: endpoint{
					Hostname: "greengrass-fips.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "greengrass-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "greengrass-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "greengrass-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "greengrass-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "greengrass-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "greengrass-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"groundstation": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "groundstation-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "groundstation-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "groundstation-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "groundstation-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "groundstation-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "groundstation-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"guardduty": service{
			IsRegionalized: boxedTrue,
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					Protocols: []string{"https"},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-4",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "il-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "guardduty-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-1-fips",
				}: endpoint{
					Hostname: "guardduty-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "guardduty-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2-fips",
				}: endpoint{
					Hostname: "guardduty-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "guardduty-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1-fips",
				}: endpoint{
					Hostname: "guardduty-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "guardduty-fips.us-west-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2-fips",
				}: endpoint{
					Hostname: "guardduty-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
			},
		},
		"health": service{
			PartitionEndpoint: "aws-global",
			IsRegionalized:    boxedFalse,
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					SSLCommonName: "health.us-east-1.amazonaws.com",
					Protocols:     []string{"https"},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "aws-global",
				}: endpoint{
					Hostname: "global.health.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "health-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "health-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
			},
		},
		"healthlake": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					Protocols: []string{"https"},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"honeycode": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"iam": service{
			PartitionEndpoint: "aws-global",
			IsRegionalized:    boxedFalse,
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "aws-global",
				}: endpoint{
					Hostname: "iam.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				endpointKey{
					Region:  "aws-global",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "iam-fips.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				endpointKey{
					Region: "aws-global-fips",
				}: endpoint{
					Hostname: "iam-fips.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "iam",
				}: endpoint{
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region:  "iam",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "iam-fips.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "iam-fips",
				}: endpoint{
					Hostname: "iam-fips.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
			},
		},
		"identity-chime": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "identity-chime-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-1-fips",
				}: endpoint{
					Hostname: "identity-chime-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
			},
		},
		"identitystore": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-4",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "il-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"importexport": service{
			PartitionEndpoint: "aws-global",
			IsRegionalized:    boxedFalse,
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "aws-global",
				}: endpoint{
					Hostname:          "importexport.amazonaws.com",
					SignatureVersions: []string{"v2", "v4"},
					CredentialScope: credentialScope{
						Region:  "us-east-1",
						Service: "IngestionService",
					},
				},
			},
		},
		"ingest.timestream": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "ingest-fips-us-east-1",
				}: endpoint{
					Hostname: "ingest.timestream-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "ingest-fips-us-east-2",
				}: endpoint{
					Hostname: "ingest.timestream-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "ingest-fips-us-west-2",
				}: endpoint{
					Hostname: "ingest.timestream-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "ingest-us-east-1",
				}: endpoint{
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region:  "ingest-us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "ingest.timestream-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "ingest-us-east-2",
				}: endpoint{
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region:  "ingest-us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "ingest.timestream-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "ingest-us-west-2",
				}: endpoint{
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region:  "ingest-us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "ingest.timestream-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"inspector": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "inspector-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "inspector-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-1",
				}: endpoint{
					Hostname: "inspector-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "inspector-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "inspector-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "inspector-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "inspector-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "inspector-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"inspector2": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "inspector2-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "inspector2-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-1",
				}: endpoint{
					Hostname: "inspector2-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "inspector2-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "inspector2-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "inspector2-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "inspector2-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "inspector2-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"internetmonitor": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					DNSSuffix: "api.aws",
				},
				defaultKey{
					Variant: fipsVariant,
				}: endpoint{
					Hostname:  "{service}-fips.{region}.{dnsSuffix}",
					DNSSuffix: "api.aws",
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{
					Hostname: "internetmonitor.af-south-1.api.aws",
				},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{
					Hostname: "internetmonitor.ap-east-1.api.aws",
				},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{
					Hostname: "internetmonitor.ap-northeast-1.api.aws",
				},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{
					Hostname: "internetmonitor.ap-northeast-2.api.aws",
				},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{
					Hostname: "internetmonitor.ap-northeast-3.api.aws",
				},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{
					Hostname: "internetmonitor.ap-south-1.api.aws",
				},
				endpointKey{
					Region: "ap-south-2",
				}: endpoint{
					Hostname: "internetmonitor.ap-south-2.api.aws",
				},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{
					Hostname: "internetmonitor.ap-southeast-1.api.aws",
				},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{
					Hostname: "internetmonitor.ap-southeast-2.api.aws",
				},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{
					Hostname: "internetmonitor.ap-southeast-3.api.aws",
				},
				endpointKey{
					Region: "ap-southeast-4",
				}: endpoint{
					Hostname: "internetmonitor.ap-southeast-4.api.aws",
				},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{
					Hostname: "internetmonitor.ca-central-1.api.aws",
				},
				endpointKey{
					Region:  "ca-central-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "internetmonitor-fips.ca-central-1.amazonaws.com",
				},
				endpointKey{
					Region: "ca-west-1",
				}: endpoint{
					Hostname: "internetmonitor.ca-west-1.api.aws",
				},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{
					Hostname: "internetmonitor.eu-central-1.api.aws",
				},
				endpointKey{
					Region: "eu-central-2",
				}: endpoint{
					Hostname: "internetmonitor.eu-central-2.api.aws",
				},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{
					Hostname: "internetmonitor.eu-north-1.api.aws",
				},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{
					Hostname: "internetmonitor.eu-south-1.api.aws",
				},
				endpointKey{
					Region: "eu-south-2",
				}: endpoint{
					Hostname: "internetmonitor.eu-south-2.api.aws",
				},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{
					Hostname: "internetmonitor.eu-west-1.api.aws",
				},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{
					Hostname: "internetmonitor.eu-west-2.api.aws",
				},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{
					Hostname: "internetmonitor.eu-west-3.api.aws",
				},
				endpointKey{
					Region: "il-central-1",
				}: endpoint{
					Hostname: "internetmonitor.il-central-1.api.aws",
				},
				endpointKey{
					Region: "me-central-1",
				}: endpoint{
					Hostname: "internetmonitor.me-central-1.api.aws",
				},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{
					Hostname: "internetmonitor.me-south-1.api.aws",
				},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{
					Hostname: "internetmonitor.sa-east-1.api.aws",
				},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{
					Hostname: "internetmonitor.us-east-1.api.aws",
				},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "internetmonitor-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{
					Hostname: "internetmonitor.us-east-2.api.aws",
				},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "internetmonitor-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{
					Hostname: "internetmonitor.us-west-1.api.aws",
				},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "internetmonitor-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{
					Hostname: "internetmonitor.us-west-2.api.aws",
				},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "internetmonitor-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"iot": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region:  "ca-central-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "iot-fips.ca-central-1.amazonaws.com",
				},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "fips-ca-central-1",
				}: endpoint{
					Hostname: "iot-fips.ca-central-1.amazonaws.com",

					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "iot-fips.us-east-1.amazonaws.com",

					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "iot-fips.us-east-2.amazonaws.com",

					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-1",
				}: endpoint{
					Hostname: "iot-fips.us-west-1.amazonaws.com",

					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "iot-fips.us-west-2.amazonaws.com",

					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "me-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "iot-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "iot-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "iot-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "iot-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"iotanalytics": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"iotevents": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region:  "ca-central-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "iotevents-fips.ca-central-1.amazonaws.com",
				},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "fips-ca-central-1",
				}: endpoint{
					Hostname: "iotevents-fips.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "iotevents-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "iotevents-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "iotevents-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "iotevents-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "iotevents-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "iotevents-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"ioteventsdata": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{
					Hostname: "data.iotevents.ap-northeast-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-northeast-1",
					},
				},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{
					Hostname: "data.iotevents.ap-northeast-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-northeast-2",
					},
				},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{
					Hostname: "data.iotevents.ap-south-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-south-1",
					},
				},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{
					Hostname: "data.iotevents.ap-southeast-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-southeast-1",
					},
				},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{
					Hostname: "data.iotevents.ap-southeast-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-southeast-2",
					},
				},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{
					Hostname: "data.iotevents.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
				},
				endpointKey{
					Region:  "ca-central-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "data.iotevents-fips.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
				},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{
					Hostname: "data.iotevents.eu-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-central-1",
					},
				},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{
					Hostname: "data.iotevents.eu-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-west-1",
					},
				},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{
					Hostname: "data.iotevents.eu-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-west-2",
					},
				},
				endpointKey{
					Region: "fips-ca-central-1",
				}: endpoint{
					Hostname: "data.iotevents-fips.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "data.iotevents-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "data.iotevents-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "data.iotevents-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{
					Hostname: "data.iotevents.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "data.iotevents-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{
					Hostname: "data.iotevents.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
				},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "data.iotevents-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{
					Hostname: "data.iotevents.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
				},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "data.iotevents-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
				},
			},
		},
		"iotfleetwise": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
			},
		},
		"iotroborunner": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
			},
		},
		"iotsecuredtunneling": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{},
				defaultKey{
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "api.tunneling.iot-fips.{region}.{dnsSuffix}",
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region:  "ca-central-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "api.tunneling.iot-fips.ca-central-1.amazonaws.com",
				},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "fips-ca-central-1",
				}: endpoint{
					Hostname: "api.tunneling.iot-fips.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "api.tunneling.iot-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "api.tunneling.iot-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-1",
				}: endpoint{
					Hostname: "api.tunneling.iot-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "api.tunneling.iot-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "api.tunneling.iot-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "api.tunneling.iot-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "api.tunneling.iot-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "api.tunneling.iot-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"iotsitewise": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region:  "ca-central-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "iotsitewise-fips.ca-central-1.amazonaws.com",
				},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "fips-ca-central-1",
				}: endpoint{
					Hostname: "iotsitewise-fips.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "iotsitewise-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "iotsitewise-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "iotsitewise-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "iotsitewise-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "iotsitewise-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "iotsitewise-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"iotthingsgraph": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					CredentialScope: credentialScope{
						Service: "iotthingsgraph",
					},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"iottwinmaker": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "api-ap-northeast-1",
				}: endpoint{
					Hostname: "api.iottwinmaker.ap-northeast-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-northeast-1",
					},
				},
				endpointKey{
					Region: "api-ap-northeast-2",
				}: endpoint{
					Hostname: "api.iottwinmaker.ap-northeast-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-northeast-2",
					},
				},
				endpointKey{
					Region: "api-ap-south-1",
				}: endpoint{
					Hostname: "api.iottwinmaker.ap-south-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-south-1",
					},
				},
				endpointKey{
					Region: "api-ap-southeast-1",
				}: endpoint{
					Hostname: "api.iottwinmaker.ap-southeast-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-southeast-1",
					},
				},
				endpointKey{
					Region: "api-ap-southeast-2",
				}: endpoint{
					Hostname: "api.iottwinmaker.ap-southeast-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-southeast-2",
					},
				},
				endpointKey{
					Region: "api-eu-central-1",
				}: endpoint{
					Hostname: "api.iottwinmaker.eu-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-central-1",
					},
				},
				endpointKey{
					Region: "api-eu-west-1",
				}: endpoint{
					Hostname: "api.iottwinmaker.eu-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-west-1",
					},
				},
				endpointKey{
					Region: "api-us-east-1",
				}: endpoint{
					Hostname: "api.iottwinmaker.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				endpointKey{
					Region: "api-us-west-2",
				}: endpoint{
					Hostname: "api.iottwinmaker.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
				},
				endpointKey{
					Region: "data-ap-northeast-1",
				}: endpoint{
					Hostname: "data.iottwinmaker.ap-northeast-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-northeast-1",
					},
				},
				endpointKey{
					Region: "data-ap-northeast-2",
				}: endpoint{
					Hostname: "data.iottwinmaker.ap-northeast-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-northeast-2",
					},
				},
				endpointKey{
					Region: "data-ap-south-1",
				}: endpoint{
					Hostname: "data.iottwinmaker.ap-south-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-south-1",
					},
				},
				endpointKey{
					Region: "data-ap-southeast-1",
				}: endpoint{
					Hostname: "data.iottwinmaker.ap-southeast-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-southeast-1",
					},
				},
				endpointKey{
					Region: "data-ap-southeast-2",
				}: endpoint{
					Hostname: "data.iottwinmaker.ap-southeast-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-southeast-2",
					},
				},
				endpointKey{
					Region: "data-eu-central-1",
				}: endpoint{
					Hostname: "data.iottwinmaker.eu-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-central-1",
					},
				},
				endpointKey{
					Region: "data-eu-west-1",
				}: endpoint{
					Hostname: "data.iottwinmaker.eu-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-west-1",
					},
				},
				endpointKey{
					Region: "data-us-east-1",
				}: endpoint{
					Hostname: "data.iottwinmaker.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				endpointKey{
					Region: "data-us-west-2",
				}: endpoint{
					Hostname: "data.iottwinmaker.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
				},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "fips-api-us-east-1",
				}: endpoint{
					Hostname: "api.iottwinmaker-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				endpointKey{
					Region: "fips-api-us-west-2",
				}: endpoint{
					Hostname: "api.iottwinmaker-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
				},
				endpointKey{
					Region: "fips-data-us-east-1",
				}: endpoint{
					Hostname: "data.iottwinmaker-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				endpointKey{
					Region: "fips-data-us-west-2",
				}: endpoint{
					Hostname: "data.iottwinmaker-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
				},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "iottwinmaker-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "iottwinmaker-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "iottwinmaker-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "iottwinmaker-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"iotwireless": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{
					Hostname: "api.iotwireless.ap-northeast-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-northeast-1",
					},
				},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{
					Hostname: "api.iotwireless.ap-southeast-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-southeast-2",
					},
				},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{
					Hostname: "api.iotwireless.eu-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-west-1",
					},
				},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{
					Hostname: "api.iotwireless.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{
					Hostname: "api.iotwireless.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
				},
			},
		},
		"ivs": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"ivschat": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"ivsrealtime": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"kafka": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-4",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region:  "ca-central-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "kafka-fips.ca-central-1.amazonaws.com",
				},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "fips-ca-central-1",
				}: endpoint{
					Hostname: "kafka-fips.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "kafka-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "kafka-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-1",
				}: endpoint{
					Hostname: "kafka-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "kafka-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "il-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "kafka-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "kafka-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "kafka-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "kafka-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"kafkaconnect": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"kendra": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "kendra-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "kendra-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "kendra-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "kendra-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "kendra-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "kendra-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"kendra-ranking": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					DNSSuffix: "api.aws",
				},
				defaultKey{
					Variant: fipsVariant,
				}: endpoint{
					Hostname:  "{service}-fips.{region}.{dnsSuffix}",
					DNSSuffix: "api.aws",
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{
					Hostname: "kendra-ranking.af-south-1.api.aws",
				},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{
					Hostname: "kendra-ranking.ap-east-1.api.aws",
				},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{
					Hostname: "kendra-ranking.ap-northeast-1.api.aws",
				},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{
					Hostname: "kendra-ranking.ap-northeast-2.api.aws",
				},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{
					Hostname: "kendra-ranking.ap-northeast-3.api.aws",
				},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{
					Hostname: "kendra-ranking.ap-south-1.api.aws",
				},
				endpointKey{
					Region: "ap-south-2",
				}: endpoint{
					Hostname: "kendra-ranking.ap-south-2.api.aws",
				},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{
					Hostname: "kendra-ranking.ap-southeast-1.api.aws",
				},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{
					Hostname: "kendra-ranking.ap-southeast-2.api.aws",
				},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{
					Hostname: "kendra-ranking.ap-southeast-3.api.aws",
				},
				endpointKey{
					Region: "ap-southeast-4",
				}: endpoint{
					Hostname: "kendra-ranking.ap-southeast-4.api.aws",
				},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{
					Hostname: "kendra-ranking.ca-central-1.api.aws",
				},
				endpointKey{
					Region:  "ca-central-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "kendra-ranking-fips.ca-central-1.api.aws",
				},
				endpointKey{
					Region: "ca-west-1",
				}: endpoint{
					Hostname: "kendra-ranking.ca-west-1.api.aws",
				},
				endpointKey{
					Region: "eu-central-2",
				}: endpoint{
					Hostname: "kendra-ranking.eu-central-2.api.aws",
				},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{
					Hostname: "kendra-ranking.eu-north-1.api.aws",
				},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{
					Hostname: "kendra-ranking.eu-south-1.api.aws",
				},
				endpointKey{
					Region: "eu-south-2",
				}: endpoint{
					Hostname: "kendra-ranking.eu-south-2.api.aws",
				},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{
					Hostname: "kendra-ranking.eu-west-1.api.aws",
				},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{
					Hostname: "kendra-ranking.eu-west-3.api.aws",
				},
				endpointKey{
					Region: "il-central-1",
				}: endpoint{
					Hostname: "kendra-ranking.il-central-1.api.aws",
				},
				endpointKey{
					Region: "me-central-1",
				}: endpoint{
					Hostname: "kendra-ranking.me-central-1.api.aws",
				},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{
					Hostname: "kendra-ranking.me-south-1.api.aws",
				},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{
					Hostname: "kendra-ranking.sa-east-1.api.aws",
				},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{
					Hostname: "kendra-ranking.us-east-1.api.aws",
				},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "kendra-ranking-fips.us-east-1.api.aws",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{
					Hostname: "kendra-ranking.us-east-2.api.aws",
				},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "kendra-ranking-fips.us-east-2.api.aws",
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{
					Hostname: "kendra-ranking.us-west-1.api.aws",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{
					Hostname: "kendra-ranking.us-west-2.api.aws",
				},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "kendra-ranking-fips.us-west-2.api.aws",
				},
			},
		},
		"kinesis": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-4",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "ca-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "kinesis-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "kinesis-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-1",
				}: endpoint{
					Hostname: "kinesis-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "kinesis-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "il-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "kinesis-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "kinesis-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "kinesis-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "kinesis-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"kinesisanalytics": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-4",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "il-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"kinesisvideo": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"kms": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ProdFips",
				}: endpoint{
					Hostname: "kms-fips.eu-central-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-central-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region:  "af-south-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "kms-fips.af-south-1.amazonaws.com",
				},
				endpointKey{
					Region: "af-south-1-fips",
				}: endpoint{
					Hostname: "kms-fips.af-south-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "af-south-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "ap-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "kms-fips.ap-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "ap-east-1-fips",
				}: endpoint{
					Hostname: "kms-fips.ap-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region:  "ap-northeast-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "kms-fips.ap-northeast-1.amazonaws.com",
				},
				endpointKey{
					Region: "ap-northeast-1-fips",
				}: endpoint{
					Hostname: "kms-fips.ap-northeast-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-northeast-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region:  "ap-northeast-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "kms-fips.ap-northeast-2.amazonaws.com",
				},
				endpointKey{
					Region: "ap-northeast-2-fips",
				}: endpoint{
					Hostname: "kms-fips.ap-northeast-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-northeast-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region:  "ap-northeast-3",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "kms-fips.ap-northeast-3.amazonaws.com",
				},
				endpointKey{
					Region: "ap-northeast-3-fips",
				}: endpoint{
					Hostname: "kms-fips.ap-northeast-3.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-northeast-3",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region:  "ap-south-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "kms-fips.ap-south-1.amazonaws.com",
				},
				endpointKey{
					Region: "ap-south-1-fips",
				}: endpoint{
					Hostname: "kms-fips.ap-south-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-south-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "ap-south-2",
				}: endpoint{},
				endpointKey{
					Region:  "ap-south-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "kms-fips.ap-south-2.amazonaws.com",
				},
				endpointKey{
					Region: "ap-south-2-fips",
				}: endpoint{
					Hostname: "kms-fips.ap-south-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-south-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region:  "ap-southeast-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "kms-fips.ap-southeast-1.amazonaws.com",
				},
				endpointKey{
					Region: "ap-southeast-1-fips",
				}: endpoint{
					Hostname: "kms-fips.ap-southeast-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-southeast-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region:  "ap-southeast-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "kms-fips.ap-southeast-2.amazonaws.com",
				},
				endpointKey{
					Region: "ap-southeast-2-fips",
				}: endpoint{
					Hostname: "kms-fips.ap-southeast-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-southeast-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{},
				endpointKey{
					Region:  "ap-southeast-3",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "kms-fips.ap-southeast-3.amazonaws.com",
				},
				endpointKey{
					Region: "ap-southeast-3-fips",
				}: endpoint{
					Hostname: "kms-fips.ap-southeast-3.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-southeast-3",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "ap-southeast-4",
				}: endpoint{},
				endpointKey{
					Region:  "ap-southeast-4",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "kms-fips.ap-southeast-4.amazonaws.com",
				},
				endpointKey{
					Region: "ap-southeast-4-fips",
				}: endpoint{
					Hostname: "kms-fips.ap-southeast-4.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-southeast-4",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region:  "ca-central-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "kms-fips.ca-central-1.amazonaws.com",
				},
				endpointKey{
					Region: "ca-central-1-fips",
				}: endpoint{
					Hostname: "kms-fips.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "ca-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "ca-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "kms-fips.ca-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "ca-west-1-fips",
				}: endpoint{
					Hostname: "kms-fips.ca-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region:  "eu-central-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "kms-fips.eu-central-1.amazonaws.com",
				},
				endpointKey{
					Region: "eu-central-1-fips",
				}: endpoint{
					Hostname: "kms-fips.eu-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-central-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "eu-central-2",
				}: endpoint{},
				endpointKey{
					Region:  "eu-central-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "kms-fips.eu-central-2.amazonaws.com",
				},
				endpointKey{
					Region: "eu-central-2-fips",
				}: endpoint{
					Hostname: "kms-fips.eu-central-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-central-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region:  "eu-north-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "kms-fips.eu-north-1.amazonaws.com",
				},
				endpointKey{
					Region: "eu-north-1-fips",
				}: endpoint{
					Hostname: "kms-fips.eu-north-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-north-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region:  "eu-south-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "kms-fips.eu-south-1.amazonaws.com",
				},
				endpointKey{
					Region: "eu-south-1-fips",
				}: endpoint{
					Hostname: "kms-fips.eu-south-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-south-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "eu-south-2",
				}: endpoint{},
				endpointKey{
					Region:  "eu-south-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "kms-fips.eu-south-2.amazonaws.com",
				},
				endpointKey{
					Region: "eu-south-2-fips",
				}: endpoint{
					Hostname: "kms-fips.eu-south-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-south-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "eu-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "kms-fips.eu-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "eu-west-1-fips",
				}: endpoint{
					Hostname: "kms-fips.eu-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "eu-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "kms-fips.eu-west-2.amazonaws.com",
				},
				endpointKey{
					Region: "eu-west-2-fips",
				}: endpoint{
					Hostname: "kms-fips.eu-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region:  "eu-west-3",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "kms-fips.eu-west-3.amazonaws.com",
				},
				endpointKey{
					Region: "eu-west-3-fips",
				}: endpoint{
					Hostname: "kms-fips.eu-west-3.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-west-3",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "il-central-1",
				}: endpoint{},
				endpointKey{
					Region:  "il-central-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "kms-fips.il-central-1.amazonaws.com",
				},
				endpointKey{
					Region: "il-central-1-fips",
				}: endpoint{
					Hostname: "kms-fips.il-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "il-central-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "me-central-1",
				}: endpoint{},
				endpointKey{
					Region:  "me-central-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "kms-fips.me-central-1.amazonaws.com",
				},
				endpointKey{
					Region: "me-central-1-fips",
				}: endpoint{
					Hostname: "kms-fips.me-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "me-central-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region:  "me-south-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "kms-fips.me-south-1.amazonaws.com",
				},
				endpointKey{
					Region: "me-south-1-fips",
				}: endpoint{
					Hostname: "kms-fips.me-south-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "me-south-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "sa-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "kms-fips.sa-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "sa-east-1-fips",
				}: endpoint{
					Hostname: "kms-fips.sa-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "sa-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "kms-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-1-fips",
				}: endpoint{
					Hostname: "kms-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "kms-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2-fips",
				}: endpoint{
					Hostname: "kms-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "kms-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1-fips",
				}: endpoint{
					Hostname: "kms-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "kms-fips.us-west-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2-fips",
				}: endpoint{
					Hostname: "kms-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
			},
		},
		"lakeformation": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-4",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "lakeformation-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "lakeformation-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-1",
				}: endpoint{
					Hostname: "lakeformation-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "lakeformation-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "il-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "lakeformation-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "lakeformation-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "lakeformation-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "lakeformation-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"lambda": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region:  "af-south-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "lambda.af-south-1.api.aws",
				},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "ap-east-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "lambda.ap-east-1.api.aws",
				},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region:  "ap-northeast-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "lambda.ap-northeast-1.api.aws",
				},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region:  "ap-northeast-2",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "lambda.ap-northeast-2.api.aws",
				},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region:  "ap-northeast-3",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "lambda.ap-northeast-3.api.aws",
				},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region:  "ap-south-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "lambda.ap-south-1.api.aws",
				},
				endpointKey{
					Region: "ap-south-2",
				}: endpoint{},
				endpointKey{
					Region:  "ap-south-2",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "lambda.ap-south-2.api.aws",
				},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region:  "ap-southeast-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "lambda.ap-southeast-1.api.aws",
				},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region:  "ap-southeast-2",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "lambda.ap-southeast-2.api.aws",
				},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{},
				endpointKey{
					Region:  "ap-southeast-3",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "lambda.ap-southeast-3.api.aws",
				},
				endpointKey{
					Region: "ap-southeast-4",
				}: endpoint{},
				endpointKey{
					Region:  "ap-southeast-4",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "lambda.ap-southeast-4.api.aws",
				},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region:  "ca-central-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "lambda.ca-central-1.api.aws",
				},
				endpointKey{
					Region: "ca-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "ca-west-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "lambda.ca-west-1.api.aws",
				},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region:  "eu-central-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "lambda.eu-central-1.api.aws",
				},
				endpointKey{
					Region: "eu-central-2",
				}: endpoint{},
				endpointKey{
					Region:  "eu-central-2",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "lambda.eu-central-2.api.aws",
				},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region:  "eu-north-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "lambda.eu-north-1.api.aws",
				},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region:  "eu-south-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "lambda.eu-south-1.api.aws",
				},
				endpointKey{
					Region: "eu-south-2",
				}: endpoint{},
				endpointKey{
					Region:  "eu-south-2",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "lambda.eu-south-2.api.aws",
				},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "eu-west-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "lambda.eu-west-1.api.aws",
				},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "eu-west-2",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "lambda.eu-west-2.api.aws",
				},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region:  "eu-west-3",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "lambda.eu-west-3.api.aws",
				},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "lambda-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "lambda-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-1",
				}: endpoint{
					Hostname: "lambda-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "lambda-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "il-central-1",
				}: endpoint{},
				endpointKey{
					Region:  "il-central-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "lambda.il-central-1.api.aws",
				},
				endpointKey{
					Region: "me-central-1",
				}: endpoint{},
				endpointKey{
					Region:  "me-central-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "lambda.me-central-1.api.aws",
				},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region:  "me-south-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "lambda.me-south-1.api.aws",
				},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "sa-east-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "lambda.sa-east-1.api.aws",
				},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "lambda.us-east-1.api.aws",
				},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "lambda-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "lambda.us-east-2.api.aws",
				},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "lambda-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "lambda.us-west-1.api.aws",
				},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "lambda-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "lambda.us-west-2.api.aws",
				},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "lambda-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"license-manager": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-4",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "license-manager-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "license-manager-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-1",
				}: endpoint{
					Hostname: "license-manager-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "license-manager-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "il-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "license-manager-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "license-manager-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "license-manager-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "license-manager-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"license-manager-linux-subscriptions": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-4",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "ca-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "license-manager-linux-subscriptions-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "license-manager-linux-subscriptions-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-1",
				}: endpoint{
					Hostname: "license-manager-linux-subscriptions-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "license-manager-linux-subscriptions-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "il-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "license-manager-linux-subscriptions-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "license-manager-linux-subscriptions-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "license-manager-linux-subscriptions-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "license-manager-linux-subscriptions-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"license-manager-user-subscriptions": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-4",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "license-manager-user-subscriptions-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "license-manager-user-subscriptions-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-1",
				}: endpoint{
					Hostname: "license-manager-user-subscriptions-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "license-manager-user-subscriptions-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "il-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "license-manager-user-subscriptions-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "license-manager-user-subscriptions-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "license-manager-user-subscriptions-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "license-manager-user-subscriptions-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"lightsail": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"logs": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-4",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "ca-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "logs-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "logs-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-1",
				}: endpoint{
					Hostname: "logs-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "logs-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "il-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "logs-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "logs-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "logs-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "logs-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"lookoutequipment": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
			},
		},
		"lookoutmetrics": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"lookoutvision": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"m2": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region:  "ca-central-1",
					Variant: fipsVariant,
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "fips-ca-central-1",
				}: endpoint{

					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{

					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{

					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-1",
				}: endpoint{

					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{

					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{},
			},
		},
		"machinelearning": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
			},
		},
		"macie2": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "macie2-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "macie2-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-1",
				}: endpoint{
					Hostname: "macie2-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "macie2-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "il-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "macie2-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "macie2-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "macie2-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "macie2-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"managedblockchain": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
			},
		},
		"managedblockchain-query": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
			},
		},
		"marketplacecommerceanalytics": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
			},
		},
		"media-pipelines-chime": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "media-pipelines-chime-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-1-fips",
				}: endpoint{
					Hostname: "media-pipelines-chime-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "media-pipelines-chime-fips.us-west-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2-fips",
				}: endpoint{
					Hostname: "media-pipelines-chime-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
			},
		},
		"mediaconnect": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-4",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "me-central-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"mediaconvert": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-4",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region:  "ca-central-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "mediaconvert-fips.ca-central-1.amazonaws.com",
				},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "fips-ca-central-1",
				}: endpoint{
					Hostname: "mediaconvert-fips.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "mediaconvert-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "mediaconvert-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-1",
				}: endpoint{
					Hostname: "mediaconvert-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "mediaconvert-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "mediaconvert-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "mediaconvert-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "mediaconvert-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "mediaconvert-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"medialive": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "medialive-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "medialive-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "medialive-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "medialive-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "medialive-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "medialive-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"mediapackage": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-4",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"mediapackage-vod": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-4",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"mediapackagev2": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-4",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"mediastore": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"meetings-chime": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "il-central-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "meetings-chime-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-1-fips",
				}: endpoint{
					Hostname: "meetings-chime-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "meetings-chime-fips.us-west-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2-fips",
				}: endpoint{
					Hostname: "meetings-chime-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
			},
		},
		"memory-db": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "fips",
				}: endpoint{
					Hostname: "memory-db-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
				},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"messaging-chime": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "messaging-chime-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-1-fips",
				}: endpoint{
					Hostname: "messaging-chime-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
			},
		},
		"metering.marketplace": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					CredentialScope: credentialScope{
						Service: "aws-marketplace",
					},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-4",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "il-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"metrics.sagemaker": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-4",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "ca-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "il-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"mgh": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"mgn": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-4",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "mgn-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "mgn-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-1",
				}: endpoint{
					Hostname: "mgn-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "mgn-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "il-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "mgn-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "mgn-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "mgn-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "mgn-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"migrationhub-orchestrator": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"migrationhub-strategy": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"mobileanalytics": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
			},
		},
		"models-v2-lex": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"models.lex": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					CredentialScope: credentialScope{
						Service: "lex",
					},
				},
				defaultKey{
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "models-fips.lex.{region}.{dnsSuffix}",
					CredentialScope: credentialScope{
						Service: "lex",
					},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "models-fips.lex.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-1-fips",
				}: endpoint{
					Hostname: "models-fips.lex.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "models-fips.lex.us-west-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2-fips",
				}: endpoint{
					Hostname: "models-fips.lex.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
			},
		},
		"monitoring": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					Protocols: []string{"http", "https"},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-4",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "ca-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "monitoring-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "monitoring-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-1",
				}: endpoint{
					Hostname: "monitoring-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "monitoring-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "il-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "monitoring-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "monitoring-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "monitoring-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "monitoring-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"mq": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-4",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "mq-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "mq-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-1",
				}: endpoint{
					Hostname: "mq-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "mq-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "il-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "mq-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "mq-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "mq-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "mq-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"mturk-requester": service{
			IsRegionalized: boxedFalse,
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "sandbox",
				}: endpoint{
					Hostname: "mturk-requester-sandbox.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
			},
		},
		"neptune": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{
					Hostname: "rds.ap-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-east-1",
					},
				},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{
					Hostname: "rds.ap-northeast-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-northeast-1",
					},
				},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{
					Hostname: "rds.ap-northeast-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-northeast-2",
					},
				},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{
					Hostname: "rds.ap-south-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-south-1",
					},
				},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{
					Hostname: "rds.ap-southeast-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-southeast-1",
					},
				},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{
					Hostname: "rds.ap-southeast-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-southeast-2",
					},
				},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{
					Hostname: "rds.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
				},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{
					Hostname: "rds.eu-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-central-1",
					},
				},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{
					Hostname: "rds.eu-north-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-north-1",
					},
				},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{
					Hostname: "rds.eu-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-west-1",
					},
				},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{
					Hostname: "rds.eu-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-west-2",
					},
				},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{
					Hostname: "rds.eu-west-3.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-west-3",
					},
				},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{
					Hostname: "rds.me-south-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "me-south-1",
					},
				},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{
					Hostname: "rds.sa-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "sa-east-1",
					},
				},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{
					Hostname: "rds.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{
					Hostname: "rds.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{
					Hostname: "rds.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{
					Hostname: "rds.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
				},
			},
		},
		"network-firewall": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-4",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region:  "ca-central-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "network-firewall-fips.ca-central-1.amazonaws.com",
				},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "fips-ca-central-1",
				}: endpoint{
					Hostname: "network-firewall-fips.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "network-firewall-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "network-firewall-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-1",
				}: endpoint{
					Hostname: "network-firewall-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "network-firewall-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "il-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "network-firewall-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "network-firewall-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "network-firewall-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "network-firewall-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"networkmanager": service{
			PartitionEndpoint: "aws-global",
			IsRegionalized:    boxedFalse,
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "aws-global",
				}: endpoint{
					Hostname: "networkmanager.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
				},
				endpointKey{
					Region:  "aws-global",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "networkmanager-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
				},
				endpointKey{
					Region: "fips-aws-global",
				}: endpoint{
					Hostname: "networkmanager-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
			},
		},
		"nimble": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"oam": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-4",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "ca-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "il-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"oidc": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{
					Hostname: "oidc.af-south-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "af-south-1",
					},
				},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{
					Hostname: "oidc.ap-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-east-1",
					},
				},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{
					Hostname: "oidc.ap-northeast-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-northeast-1",
					},
				},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{
					Hostname: "oidc.ap-northeast-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-northeast-2",
					},
				},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{
					Hostname: "oidc.ap-northeast-3.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-northeast-3",
					},
				},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{
					Hostname: "oidc.ap-south-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-south-1",
					},
				},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{
					Hostname: "oidc.ap-southeast-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-southeast-1",
					},
				},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{
					Hostname: "oidc.ap-southeast-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-southeast-2",
					},
				},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{
					Hostname: "oidc.ap-southeast-3.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-southeast-3",
					},
				},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{
					Hostname: "oidc.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
				},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{
					Hostname: "oidc.eu-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-central-1",
					},
				},
				endpointKey{
					Region: "eu-central-2",
				}: endpoint{
					Hostname: "oidc.eu-central-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-central-2",
					},
				},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{
					Hostname: "oidc.eu-north-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-north-1",
					},
				},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{
					Hostname: "oidc.eu-south-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-south-1",
					},
				},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{
					Hostname: "oidc.eu-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-west-1",
					},
				},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{
					Hostname: "oidc.eu-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-west-2",
					},
				},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{
					Hostname: "oidc.eu-west-3.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-west-3",
					},
				},
				endpointKey{
					Region: "il-central-1",
				}: endpoint{
					Hostname: "oidc.il-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "il-central-1",
					},
				},
				endpointKey{
					Region: "me-central-1",
				}: endpoint{
					Hostname: "oidc.me-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "me-central-1",
					},
				},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{
					Hostname: "oidc.me-south-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "me-south-1",
					},
				},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{
					Hostname: "oidc.sa-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "sa-east-1",
					},
				},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{
					Hostname: "oidc.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{
					Hostname: "oidc.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{
					Hostname: "oidc.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{
					Hostname: "oidc.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
				},
			},
		},
		"omics": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{
					Hostname: "omics.ap-southeast-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-southeast-1",
					},
				},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{
					Hostname: "omics.eu-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-central-1",
					},
				},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{
					Hostname: "omics.eu-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-west-1",
					},
				},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{
					Hostname: "omics.eu-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-west-2",
					},
				},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "omics-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "omics-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "il-central-1",
				}: endpoint{
					Hostname: "omics.il-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "il-central-1",
					},
				},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{
					Hostname: "omics.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "omics-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{
					Hostname: "omics.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
				},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "omics-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
				},
			},
		},
		"opsworks": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"opsworks-cm": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"organizations": service{
			PartitionEndpoint: "aws-global",
			IsRegionalized:    boxedFalse,
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "aws-global",
				}: endpoint{
					Hostname: "organizations.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				endpointKey{
					Region:  "aws-global",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "organizations-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				endpointKey{
					Region: "fips-aws-global",
				}: endpoint{
					Hostname: "organizations-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
			},
		},
		"osis": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"outposts": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region:  "ca-central-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "outposts-fips.ca-central-1.amazonaws.com",
				},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "fips-ca-central-1",
				}: endpoint{
					Hostname: "outposts-fips.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "outposts-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "outposts-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-1",
				}: endpoint{
					Hostname: "outposts-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "outposts-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "il-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "outposts-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "outposts-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "outposts-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "outposts-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"participant.connect": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "participant.connect-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "participant.connect-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "participant.connect-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "participant.connect-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"personalize": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"pi": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-4",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "ca-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "il-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"pinpoint": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					CredentialScope: credentialScope{
						Service: "mobiletargeting",
					},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{
					Hostname: "pinpoint.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
				},
				endpointKey{
					Region:  "ca-central-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "pinpoint-fips.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
				},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "fips-ca-central-1",
				}: endpoint{
					Hostname: "pinpoint-fips.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "pinpoint-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "pinpoint-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "pinpoint-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{
					Hostname: "pinpoint.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "pinpoint-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{
					Hostname: "pinpoint.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
				},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "pinpoint-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{
					Hostname: "pinpoint.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
				},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "pinpoint-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
				},
			},
		},
		"pipes": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "me-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"polly": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "polly-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "polly-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-1",
				}: endpoint{
					Hostname: "polly-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "polly-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "polly-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "polly-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "polly-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "polly-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"portal.sso": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{
					Hostname: "portal.sso.af-south-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "af-south-1",
					},
				},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{
					Hostname: "portal.sso.ap-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-east-1",
					},
				},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{
					Hostname: "portal.sso.ap-northeast-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-northeast-1",
					},
				},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{
					Hostname: "portal.sso.ap-northeast-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-northeast-2",
					},
				},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{
					Hostname: "portal.sso.ap-northeast-3.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-northeast-3",
					},
				},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{
					Hostname: "portal.sso.ap-south-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-south-1",
					},
				},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{
					Hostname: "portal.sso.ap-southeast-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-southeast-1",
					},
				},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{
					Hostname: "portal.sso.ap-southeast-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-southeast-2",
					},
				},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{
					Hostname: "portal.sso.ap-southeast-3.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-southeast-3",
					},
				},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{
					Hostname: "portal.sso.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
				},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{
					Hostname: "portal.sso.eu-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-central-1",
					},
				},
				endpointKey{
					Region: "eu-central-2",
				}: endpoint{
					Hostname: "portal.sso.eu-central-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-central-2",
					},
				},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{
					Hostname: "portal.sso.eu-north-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-north-1",
					},
				},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{
					Hostname: "portal.sso.eu-south-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-south-1",
					},
				},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{
					Hostname: "portal.sso.eu-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-west-1",
					},
				},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{
					Hostname: "portal.sso.eu-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-west-2",
					},
				},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{
					Hostname: "portal.sso.eu-west-3.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-west-3",
					},
				},
				endpointKey{
					Region: "il-central-1",
				}: endpoint{
					Hostname: "portal.sso.il-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "il-central-1",
					},
				},
				endpointKey{
					Region: "me-central-1",
				}: endpoint{
					Hostname: "portal.sso.me-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "me-central-1",
					},
				},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{
					Hostname: "portal.sso.me-south-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "me-south-1",
					},
				},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{
					Hostname: "portal.sso.sa-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "sa-east-1",
					},
				},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{
					Hostname: "portal.sso.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{
					Hostname: "portal.sso.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{
					Hostname: "portal.sso.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{
					Hostname: "portal.sso.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
				},
			},
		},
		"profile": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region:  "ca-central-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "profile-fips.ca-central-1.amazonaws.com",
				},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "fips-ca-central-1",
				}: endpoint{
					Hostname: "profile-fips.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "profile-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "profile-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "profile-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "profile-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"projects.iot1click": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"proton": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"qbusiness": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					DNSSuffix: "api.aws",
				},
				defaultKey{
					Variant: fipsVariant,
				}: endpoint{
					Hostname:  "{service}-fips.{region}.{dnsSuffix}",
					DNSSuffix: "api.aws",
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{
					Hostname: "qbusiness.af-south-1.api.aws",
				},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{
					Hostname: "qbusiness.ap-east-1.api.aws",
				},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{
					Hostname: "qbusiness.ap-northeast-1.api.aws",
				},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{
					Hostname: "qbusiness.ap-northeast-2.api.aws",
				},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{
					Hostname: "qbusiness.ap-northeast-3.api.aws",
				},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{
					Hostname: "qbusiness.ap-south-1.api.aws",
				},
				endpointKey{
					Region: "ap-south-2",
				}: endpoint{
					Hostname: "qbusiness.ap-south-2.api.aws",
				},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{
					Hostname: "qbusiness.ap-southeast-1.api.aws",
				},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{
					Hostname: "qbusiness.ap-southeast-2.api.aws",
				},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{
					Hostname: "qbusiness.ap-southeast-3.api.aws",
				},
				endpointKey{
					Region: "ap-southeast-4",
				}: endpoint{
					Hostname: "qbusiness.ap-southeast-4.api.aws",
				},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{
					Hostname: "qbusiness.ca-central-1.api.aws",
				},
				endpointKey{
					Region: "ca-west-1",
				}: endpoint{
					Hostname: "qbusiness.ca-west-1.api.aws",
				},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{
					Hostname: "qbusiness.eu-central-1.api.aws",
				},
				endpointKey{
					Region: "eu-central-2",
				}: endpoint{
					Hostname: "qbusiness.eu-central-2.api.aws",
				},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{
					Hostname: "qbusiness.eu-north-1.api.aws",
				},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{
					Hostname: "qbusiness.eu-south-1.api.aws",
				},
				endpointKey{
					Region: "eu-south-2",
				}: endpoint{
					Hostname: "qbusiness.eu-south-2.api.aws",
				},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{
					Hostname: "qbusiness.eu-west-1.api.aws",
				},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{
					Hostname: "qbusiness.eu-west-2.api.aws",
				},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{
					Hostname: "qbusiness.eu-west-3.api.aws",
				},
				endpointKey{
					Region: "il-central-1",
				}: endpoint{
					Hostname: "qbusiness.il-central-1.api.aws",
				},
				endpointKey{
					Region: "me-central-1",
				}: endpoint{
					Hostname: "qbusiness.me-central-1.api.aws",
				},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{
					Hostname: "qbusiness.me-south-1.api.aws",
				},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{
					Hostname: "qbusiness.sa-east-1.api.aws",
				},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{
					Hostname: "qbusiness.us-east-1.api.aws",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{
					Hostname: "qbusiness.us-east-2.api.aws",
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{
					Hostname: "qbusiness.us-west-1.api.aws",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{
					Hostname: "qbusiness.us-west-2.api.aws",
				},
			},
		},
		"qldb": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region:  "ca-central-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "qldb-fips.ca-central-1.amazonaws.com",
				},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "fips-ca-central-1",
				}: endpoint{
					Hostname: "qldb-fips.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "qldb-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "qldb-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "qldb-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "qldb-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "qldb-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "qldb-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"quicksight": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"ram": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-4",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region:  "ca-central-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "ram-fips.ca-central-1.amazonaws.com",
				},
				endpointKey{
					Region: "ca-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "ca-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "ram-fips.ca-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "fips-ca-central-1",
				}: endpoint{
					Hostname: "ram-fips.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-ca-west-1",
				}: endpoint{
					Hostname: "ram-fips.ca-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "ram-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "ram-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-1",
				}: endpoint{
					Hostname: "ram-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "ram-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "il-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "ram-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "ram-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "ram-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "ram-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"rbin": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-4",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region:  "ca-central-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "rbin-fips.ca-central-1.amazonaws.com",
				},
				endpointKey{
					Region: "ca-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "ca-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "rbin-fips.ca-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "fips-ca-central-1",
				}: endpoint{
					Hostname: "rbin-fips.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-ca-west-1",
				}: endpoint{
					Hostname: "rbin-fips.ca-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "rbin-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "rbin-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-1",
				}: endpoint{
					Hostname: "rbin-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "rbin-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "il-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "rbin-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "rbin-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "rbin-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "rbin-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"rds": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-4",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region:  "ca-central-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "rds-fips.ca-central-1.amazonaws.com",
				},
				endpointKey{
					Region: "ca-central-1-fips",
				}: endpoint{
					Hostname: "rds-fips.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "ca-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "ca-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "rds-fips.ca-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "ca-west-1-fips",
				}: endpoint{
					Hostname: "rds-fips.ca-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "il-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "rds-fips.ca-central-1",
				}: endpoint{
					Hostname: "rds-fips.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "rds-fips.ca-west-1",
				}: endpoint{
					Hostname: "rds-fips.ca-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "rds-fips.us-east-1",
				}: endpoint{
					Hostname: "rds-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "rds-fips.us-east-2",
				}: endpoint{
					Hostname: "rds-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "rds-fips.us-west-1",
				}: endpoint{
					Hostname: "rds-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "rds-fips.us-west-2",
				}: endpoint{
					Hostname: "rds-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "rds.ca-central-1",
				}: endpoint{
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region:  "rds.ca-central-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "rds-fips.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "rds.ca-west-1",
				}: endpoint{
					CredentialScope: credentialScope{
						Region: "ca-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region:  "rds.ca-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "rds-fips.ca-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "rds.us-east-1",
				}: endpoint{
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region:  "rds.us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "rds-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "rds.us-east-2",
				}: endpoint{
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region:  "rds.us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "rds-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "rds.us-west-1",
				}: endpoint{
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region:  "rds.us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "rds-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "rds.us-west-2",
				}: endpoint{
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region:  "rds.us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "rds-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{
					SSLCommonName: "{service}.{dnsSuffix}",
				},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname:      "rds-fips.us-east-1.amazonaws.com",
					SSLCommonName: "{service}.{dnsSuffix}",
				},
				endpointKey{
					Region: "us-east-1-fips",
				}: endpoint{
					Hostname: "rds-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "rds-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2-fips",
				}: endpoint{
					Hostname: "rds-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "rds-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1-fips",
				}: endpoint{
					Hostname: "rds-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "rds-fips.us-west-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2-fips",
				}: endpoint{
					Hostname: "rds-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
			},
		},
		"rds-data": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "rds-data-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "rds-data-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-1",
				}: endpoint{
					Hostname: "rds-data-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "rds-data-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "rds-data-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "rds-data-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "rds-data-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "rds-data-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"redshift": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-4",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region:  "ca-central-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "redshift-fips.ca-central-1.amazonaws.com",
				},
				endpointKey{
					Region: "ca-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "ca-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "redshift-fips.ca-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "fips-ca-central-1",
				}: endpoint{
					Hostname: "redshift-fips.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-ca-west-1",
				}: endpoint{
					Hostname: "redshift-fips.ca-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "redshift-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "redshift-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-1",
				}: endpoint{
					Hostname: "redshift-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "redshift-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "il-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "redshift-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "redshift-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "redshift-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "redshift-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"redshift-serverless": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"rekognition": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region:  "ca-central-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "rekognition-fips.ca-central-1.amazonaws.com",
				},
				endpointKey{
					Region: "ca-central-1-fips",
				}: endpoint{
					Hostname: "rekognition-fips.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "il-central-1",
				}: endpoint{},
				endpointKey{
					Region: "rekognition-fips.ca-central-1",
				}: endpoint{
					Hostname: "rekognition-fips.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "rekognition-fips.us-east-1",
				}: endpoint{
					Hostname: "rekognition-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "rekognition-fips.us-east-2",
				}: endpoint{
					Hostname: "rekognition-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "rekognition-fips.us-west-1",
				}: endpoint{
					Hostname: "rekognition-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "rekognition-fips.us-west-2",
				}: endpoint{
					Hostname: "rekognition-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "rekognition.ca-central-1",
				}: endpoint{
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region:  "rekognition.ca-central-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "rekognition-fips.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "rekognition.us-east-1",
				}: endpoint{
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region:  "rekognition.us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "rekognition-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "rekognition.us-east-2",
				}: endpoint{
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region:  "rekognition.us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "rekognition-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "rekognition.us-west-1",
				}: endpoint{
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region:  "rekognition.us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "rekognition-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "rekognition.us-west-2",
				}: endpoint{
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region:  "rekognition.us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "rekognition-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "rekognition-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-1-fips",
				}: endpoint{
					Hostname: "rekognition-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "rekognition-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2-fips",
				}: endpoint{
					Hostname: "rekognition-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "rekognition-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1-fips",
				}: endpoint{
					Hostname: "rekognition-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "rekognition-fips.us-west-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2-fips",
				}: endpoint{
					Hostname: "rekognition-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
			},
		},
		"resiliencehub": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"resource-explorer-2": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					DNSSuffix: "api.aws",
				},
				defaultKey{
					Variant: fipsVariant,
				}: endpoint{
					Hostname:  "{service}-fips.{region}.{dnsSuffix}",
					DNSSuffix: "api.aws",
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{
					Hostname: "resource-explorer-2.af-south-1.api.aws",
				},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{
					Hostname: "resource-explorer-2.ap-east-1.api.aws",
				},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{
					Hostname: "resource-explorer-2.ap-northeast-1.api.aws",
				},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{
					Hostname: "resource-explorer-2.ap-northeast-2.api.aws",
				},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{
					Hostname: "resource-explorer-2.ap-northeast-3.api.aws",
				},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{
					Hostname: "resource-explorer-2.ap-south-1.api.aws",
				},
				endpointKey{
					Region: "ap-south-2",
				}: endpoint{
					Hostname: "resource-explorer-2.ap-south-2.api.aws",
				},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{
					Hostname: "resource-explorer-2.ap-southeast-1.api.aws",
				},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{
					Hostname: "resource-explorer-2.ap-southeast-2.api.aws",
				},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{
					Hostname: "resource-explorer-2.ap-southeast-3.api.aws",
				},
				endpointKey{
					Region: "ap-southeast-4",
				}: endpoint{
					Hostname: "resource-explorer-2.ap-southeast-4.api.aws",
				},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{
					Hostname: "resource-explorer-2.ca-central-1.api.aws",
				},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{
					Hostname: "resource-explorer-2.eu-central-1.api.aws",
				},
				endpointKey{
					Region: "eu-central-2",
				}: endpoint{
					Hostname: "resource-explorer-2.eu-central-2.api.aws",
				},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{
					Hostname: "resource-explorer-2.eu-north-1.api.aws",
				},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{
					Hostname: "resource-explorer-2.eu-south-1.api.aws",
				},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{
					Hostname: "resource-explorer-2.eu-west-1.api.aws",
				},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{
					Hostname: "resource-explorer-2.eu-west-2.api.aws",
				},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{
					Hostname: "resource-explorer-2.eu-west-3.api.aws",
				},
				endpointKey{
					Region: "il-central-1",
				}: endpoint{
					Hostname: "resource-explorer-2.il-central-1.api.aws",
				},
				endpointKey{
					Region: "me-central-1",
				}: endpoint{
					Hostname: "resource-explorer-2.me-central-1.api.aws",
				},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{
					Hostname: "resource-explorer-2.me-south-1.api.aws",
				},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{
					Hostname: "resource-explorer-2.sa-east-1.api.aws",
				},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{
					Hostname: "resource-explorer-2.us-east-1.api.aws",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{
					Hostname: "resource-explorer-2.us-east-2.api.aws",
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{
					Hostname: "resource-explorer-2.us-west-1.api.aws",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{
					Hostname: "resource-explorer-2.us-west-2.api.aws",
				},
			},
		},
		"resource-groups": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-4",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "ca-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "resource-groups-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "resource-groups-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-1",
				}: endpoint{
					Hostname: "resource-groups-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "resource-groups-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "il-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "resource-groups-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "resource-groups-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "resource-groups-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "resource-groups-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"robomaker": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"rolesanywhere": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-4",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "rolesanywhere-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "rolesanywhere-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-1",
				}: endpoint{
					Hostname: "rolesanywhere-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "rolesanywhere-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "il-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "rolesanywhere-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "rolesanywhere-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "rolesanywhere-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "rolesanywhere-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"route53": service{
			PartitionEndpoint: "aws-global",
			IsRegionalized:    boxedFalse,
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "aws-global",
				}: endpoint{
					Hostname: "route53.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				endpointKey{
					Region:  "aws-global",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "route53-fips.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				endpointKey{
					Region: "fips-aws-global",
				}: endpoint{
					Hostname: "route53-fips.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
			},
		},
		"route53-recovery-control-config": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "aws-global",
				}: endpoint{
					Hostname: "route53-recovery-control-config.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
				},
			},
		},
		"route53domains": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
			},
		},
		"route53resolver": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					Protocols: []string{"https"},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-4",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "ca-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "il-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"rum": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"runtime-v2-lex": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"runtime.lex": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					CredentialScope: credentialScope{
						Service: "lex",
					},
				},
				defaultKey{
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "runtime-fips.lex.{region}.{dnsSuffix}",
					CredentialScope: credentialScope{
						Service: "lex",
					},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "runtime-fips.lex.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-1-fips",
				}: endpoint{
					Hostname: "runtime-fips.lex.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "runtime-fips.lex.us-west-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2-fips",
				}: endpoint{
					Hostname: "runtime-fips.lex.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
			},
		},
		"runtime.sagemaker": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{},
				defaultKey{
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "runtime-fips.sagemaker.{region}.{dnsSuffix}",
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-4",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "ca-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "il-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "runtime-fips.sagemaker.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-1-fips",
				}: endpoint{
					Hostname: "runtime-fips.sagemaker.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "runtime-fips.sagemaker.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2-fips",
				}: endpoint{
					Hostname: "runtime-fips.sagemaker.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "runtime-fips.sagemaker.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1-fips",
				}: endpoint{
					Hostname: "runtime-fips.sagemaker.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "runtime-fips.sagemaker.us-west-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2-fips",
				}: endpoint{
					Hostname: "runtime-fips.sagemaker.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
			},
		},
		"s3": service{
			PartitionEndpoint: "aws-global",
			IsRegionalized:    boxedTrue,
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					Protocols:         []string{"http", "https"},
					SignatureVersions: []string{"s3v4"},
				},
				defaultKey{
					Variant: dualStackVariant,
				}: endpoint{
					Hostname:          "{service}.dualstack.{region}.{dnsSuffix}",
					DNSSuffix:         "amazonaws.com",
					Protocols:         []string{"http", "https"},
					SignatureVersions: []string{"s3v4"},
				},
				defaultKey{
					Variant: fipsVariant | dualStackVariant,
				}: endpoint{
					Hostname:          "{service}-fips.dualstack.{region}.{dnsSuffix}",
					DNSSuffix:         "amazonaws.com",
					Protocols:         []string{"http", "https"},
					SignatureVersions: []string{"s3v4"},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region:  "af-south-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "s3.dualstack.af-south-1.amazonaws.com",
				},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "ap-east-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "s3.dualstack.ap-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{
					Hostname:          "s3.ap-northeast-1.amazonaws.com",
					SignatureVersions: []string{"s3", "s3v4"},
				},
				endpointKey{
					Region:  "ap-northeast-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname:          "s3.dualstack.ap-northeast-1.amazonaws.com",
					SignatureVersions: []string{"s3", "s3v4"},
				},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region:  "ap-northeast-2",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "s3.dualstack.ap-northeast-2.amazonaws.com",
				},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region:  "ap-northeast-3",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "s3.dualstack.ap-northeast-3.amazonaws.com",
				},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region:  "ap-south-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "s3.dualstack.ap-south-1.amazonaws.com",
				},
				endpointKey{
					Region: "ap-south-2",
				}: endpoint{},
				endpointKey{
					Region:  "ap-south-2",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "s3.dualstack.ap-south-2.amazonaws.com",
				},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{
					Hostname:          "s3.ap-southeast-1.amazonaws.com",
					SignatureVersions: []string{"s3", "s3v4"},
				},
				endpointKey{
					Region:  "ap-southeast-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname:          "s3.dualstack.ap-southeast-1.amazonaws.com",
					SignatureVersions: []string{"s3", "s3v4"},
				},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{
					Hostname:          "s3.ap-southeast-2.amazonaws.com",
					SignatureVersions: []string{"s3", "s3v4"},
				},
				endpointKey{
					Region:  "ap-southeast-2",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname:          "s3.dualstack.ap-southeast-2.amazonaws.com",
					SignatureVersions: []string{"s3", "s3v4"},
				},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{},
				endpointKey{
					Region:  "ap-southeast-3",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "s3.dualstack.ap-southeast-3.amazonaws.com",
				},
				endpointKey{
					Region: "ap-southeast-4",
				}: endpoint{},
				endpointKey{
					Region:  "ap-southeast-4",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "s3.dualstack.ap-southeast-4.amazonaws.com",
				},
				endpointKey{
					Region: "aws-global",
				}: endpoint{
					Hostname:          "s3.amazonaws.com",
					SignatureVersions: []string{"s3", "s3v4"},
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region:  "ca-central-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "s3.dualstack.ca-central-1.amazonaws.com",
				},
				endpointKey{
					Region:  "ca-central-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "s3-fips.ca-central-1.amazonaws.com",
				},
				endpointKey{
					Region:  "ca-central-1",
					Variant: fipsVariant | dualStackVariant,
				}: endpoint{
					Hostname: "s3-fips.dualstack.ca-central-1.amazonaws.com",
				},
				endpointKey{
					Region: "ca-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "ca-west-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "s3.dualstack.ca-west-1.amazonaws.com",
				},
				endpointKey{
					Region:  "ca-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "s3-fips.ca-west-1.amazonaws.com",
				},
				endpointKey{
					Region:  "ca-west-1",
					Variant: fipsVariant | dualStackVariant,
				}: endpoint{
					Hostname: "s3-fips.dualstack.ca-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region:  "eu-central-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "s3.dualstack.eu-central-1.amazonaws.com",
				},
				endpointKey{
					Region: "eu-central-2",
				}: endpoint{},
				endpointKey{
					Region:  "eu-central-2",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "s3.dualstack.eu-central-2.amazonaws.com",
				},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region:  "eu-north-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "s3.dualstack.eu-north-1.amazonaws.com",
				},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region:  "eu-south-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "s3.dualstack.eu-south-1.amazonaws.com",
				},
				endpointKey{
					Region: "eu-south-2",
				}: endpoint{},
				endpointKey{
					Region:  "eu-south-2",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "s3.dualstack.eu-south-2.amazonaws.com",
				},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{
					Hostname:          "s3.eu-west-1.amazonaws.com",
					SignatureVersions: []string{"s3", "s3v4"},
				},
				endpointKey{
					Region:  "eu-west-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname:          "s3.dualstack.eu-west-1.amazonaws.com",
					SignatureVersions: []string{"s3", "s3v4"},
				},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "eu-west-2",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "s3.dualstack.eu-west-2.amazonaws.com",
				},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region:  "eu-west-3",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "s3.dualstack.eu-west-3.amazonaws.com",
				},
				endpointKey{
					Region: "fips-ca-central-1",
				}: endpoint{
					Hostname: "s3-fips.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-ca-west-1",
				}: endpoint{
					Hostname: "s3-fips.ca-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "s3-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "s3-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-1",
				}: endpoint{
					Hostname: "s3-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "s3-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "il-central-1",
				}: endpoint{},
				endpointKey{
					Region:  "il-central-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "s3.dualstack.il-central-1.amazonaws.com",
				},
				endpointKey{
					Region: "me-central-1",
				}: endpoint{},
				endpointKey{
					Region:  "me-central-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "s3.dualstack.me-central-1.amazonaws.com",
				},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region:  "me-south-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "s3.dualstack.me-south-1.amazonaws.com",
				},
				endpointKey{
					Region: "s3-external-1",
				}: endpoint{
					Hostname:          "s3-external-1.amazonaws.com",
					SignatureVersions: []string{"s3", "s3v4"},
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{
					Hostname:          "s3.sa-east-1.amazonaws.com",
					SignatureVersions: []string{"s3", "s3v4"},
				},
				endpointKey{
					Region:  "sa-east-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname:          "s3.dualstack.sa-east-1.amazonaws.com",
					SignatureVersions: []string{"s3", "s3v4"},
				},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{
					Hostname:          "s3.us-east-1.amazonaws.com",
					SignatureVersions: []string{"s3", "s3v4"},
				},
				endpointKey{
					Region:  "us-east-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname:          "s3.dualstack.us-east-1.amazonaws.com",
					SignatureVersions: []string{"s3", "s3v4"},
				},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname:          "s3-fips.us-east-1.amazonaws.com",
					SignatureVersions: []string{"s3", "s3v4"},
				},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant | dualStackVariant,
				}: endpoint{
					Hostname:          "s3-fips.dualstack.us-east-1.amazonaws.com",
					SignatureVersions: []string{"s3", "s3v4"},
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "s3.dualstack.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "s3-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant | dualStackVariant,
				}: endpoint{
					Hostname: "s3-fips.dualstack.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{
					Hostname:          "s3.us-west-1.amazonaws.com",
					SignatureVersions: []string{"s3", "s3v4"},
				},
				endpointKey{
					Region:  "us-west-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname:          "s3.dualstack.us-west-1.amazonaws.com",
					SignatureVersions: []string{"s3", "s3v4"},
				},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname:          "s3-fips.us-west-1.amazonaws.com",
					SignatureVersions: []string{"s3", "s3v4"},
				},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant | dualStackVariant,
				}: endpoint{
					Hostname:          "s3-fips.dualstack.us-west-1.amazonaws.com",
					SignatureVersions: []string{"s3", "s3v4"},
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{
					Hostname:          "s3.us-west-2.amazonaws.com",
					SignatureVersions: []string{"s3", "s3v4"},
				},
				endpointKey{
					Region:  "us-west-2",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname:          "s3.dualstack.us-west-2.amazonaws.com",
					SignatureVersions: []string{"s3", "s3v4"},
				},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname:          "s3-fips.us-west-2.amazonaws.com",
					SignatureVersions: []string{"s3", "s3v4"},
				},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant | dualStackVariant,
				}: endpoint{
					Hostname:          "s3-fips.dualstack.us-west-2.amazonaws.com",
					SignatureVersions: []string{"s3", "s3v4"},
				},
			},
		},
		"s3-control": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					Protocols:         []string{"https"},
					SignatureVersions: []string{"s3v4"},
				},
				defaultKey{
					Variant: dualStackVariant,
				}: endpoint{
					Hostname:          "{service}.dualstack.{region}.{dnsSuffix}",
					DNSSuffix:         "amazonaws.com",
					Protocols:         []string{"https"},
					SignatureVersions: []string{"s3v4"},
				},
				defaultKey{
					Variant: fipsVariant | dualStackVariant,
				}: endpoint{
					Hostname:          "{service}-fips.dualstack.{region}.{dnsSuffix}",
					DNSSuffix:         "amazonaws.com",
					Protocols:         []string{"https"},
					SignatureVersions: []string{"s3v4"},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{
					Hostname:          "s3-control.ap-northeast-1.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
					CredentialScope: credentialScope{
						Region: "ap-northeast-1",
					},
				},
				endpointKey{
					Region:  "ap-northeast-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname:          "s3-control.dualstack.ap-northeast-1.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
					CredentialScope: credentialScope{
						Region: "ap-northeast-1",
					},
				},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{
					Hostname:          "s3-control.ap-northeast-2.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
					CredentialScope: credentialScope{
						Region: "ap-northeast-2",
					},
				},
				endpointKey{
					Region:  "ap-northeast-2",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname:          "s3-control.dualstack.ap-northeast-2.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
					CredentialScope: credentialScope{
						Region: "ap-northeast-2",
					},
				},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{
					Hostname:          "s3-control.ap-northeast-3.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
					CredentialScope: credentialScope{
						Region: "ap-northeast-3",
					},
				},
				endpointKey{
					Region:  "ap-northeast-3",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname:          "s3-control.dualstack.ap-northeast-3.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
					CredentialScope: credentialScope{
						Region: "ap-northeast-3",
					},
				},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{
					Hostname:          "s3-control.ap-south-1.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
					CredentialScope: credentialScope{
						Region: "ap-south-1",
					},
				},
				endpointKey{
					Region:  "ap-south-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname:          "s3-control.dualstack.ap-south-1.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
					CredentialScope: credentialScope{
						Region: "ap-south-1",
					},
				},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{
					Hostname:          "s3-control.ap-southeast-1.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
					CredentialScope: credentialScope{
						Region: "ap-southeast-1",
					},
				},
				endpointKey{
					Region:  "ap-southeast-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname:          "s3-control.dualstack.ap-southeast-1.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
					CredentialScope: credentialScope{
						Region: "ap-southeast-1",
					},
				},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{
					Hostname:          "s3-control.ap-southeast-2.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
					CredentialScope: credentialScope{
						Region: "ap-southeast-2",
					},
				},
				endpointKey{
					Region:  "ap-southeast-2",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname:          "s3-control.dualstack.ap-southeast-2.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
					CredentialScope: credentialScope{
						Region: "ap-southeast-2",
					},
				},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{
					Hostname:          "s3-control.ca-central-1.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
				},
				endpointKey{
					Region:  "ca-central-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname:          "s3-control.dualstack.ca-central-1.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
				},
				endpointKey{
					Region:  "ca-central-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname:          "s3-control-fips.ca-central-1.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
				},
				endpointKey{
					Region:  "ca-central-1",
					Variant: fipsVariant | dualStackVariant,
				}: endpoint{
					Hostname:          "s3-control-fips.dualstack.ca-central-1.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
				},
				endpointKey{
					Region: "ca-central-1-fips",
				}: endpoint{
					Hostname:          "s3-control-fips.ca-central-1.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{
					Hostname:          "s3-control.eu-central-1.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
					CredentialScope: credentialScope{
						Region: "eu-central-1",
					},
				},
				endpointKey{
					Region:  "eu-central-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname:          "s3-control.dualstack.eu-central-1.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
					CredentialScope: credentialScope{
						Region: "eu-central-1",
					},
				},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{
					Hostname:          "s3-control.eu-north-1.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
					CredentialScope: credentialScope{
						Region: "eu-north-1",
					},
				},
				endpointKey{
					Region:  "eu-north-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname:          "s3-control.dualstack.eu-north-1.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
					CredentialScope: credentialScope{
						Region: "eu-north-1",
					},
				},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{
					Hostname:          "s3-control.eu-west-1.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
					CredentialScope: credentialScope{
						Region: "eu-west-1",
					},
				},
				endpointKey{
					Region:  "eu-west-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname:          "s3-control.dualstack.eu-west-1.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
					CredentialScope: credentialScope{
						Region: "eu-west-1",
					},
				},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{
					Hostname:          "s3-control.eu-west-2.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
					CredentialScope: credentialScope{
						Region: "eu-west-2",
					},
				},
				endpointKey{
					Region:  "eu-west-2",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname:          "s3-control.dualstack.eu-west-2.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
					CredentialScope: credentialScope{
						Region: "eu-west-2",
					},
				},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{
					Hostname:          "s3-control.eu-west-3.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
					CredentialScope: credentialScope{
						Region: "eu-west-3",
					},
				},
				endpointKey{
					Region:  "eu-west-3",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname:          "s3-control.dualstack.eu-west-3.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
					CredentialScope: credentialScope{
						Region: "eu-west-3",
					},
				},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{
					Hostname:          "s3-control.sa-east-1.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
					CredentialScope: credentialScope{
						Region: "sa-east-1",
					},
				},
				endpointKey{
					Region:  "sa-east-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname:          "s3-control.dualstack.sa-east-1.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
					CredentialScope: credentialScope{
						Region: "sa-east-1",
					},
				},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{
					Hostname:          "s3-control.us-east-1.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				endpointKey{
					Region:  "us-east-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname:          "s3-control.dualstack.us-east-1.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname:          "s3-control-fips.us-east-1.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant | dualStackVariant,
				}: endpoint{
					Hostname:          "s3-control-fips.dualstack.us-east-1.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				endpointKey{
					Region: "us-east-1-fips",
				}: endpoint{
					Hostname:          "s3-control-fips.us-east-1.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{
					Hostname:          "s3-control.us-east-2.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
				},
				endpointKey{
					Region:  "us-east-2",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname:          "s3-control.dualstack.us-east-2.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
				},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname:          "s3-control-fips.us-east-2.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
				},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant | dualStackVariant,
				}: endpoint{
					Hostname:          "s3-control-fips.dualstack.us-east-2.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
				},
				endpointKey{
					Region: "us-east-2-fips",
				}: endpoint{
					Hostname:          "s3-control-fips.us-east-2.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{
					Hostname:          "s3-control.us-west-1.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
				},
				endpointKey{
					Region:  "us-west-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname:          "s3-control.dualstack.us-west-1.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
				},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname:          "s3-control-fips.us-west-1.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
				},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant | dualStackVariant,
				}: endpoint{
					Hostname:          "s3-control-fips.dualstack.us-west-1.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
				},
				endpointKey{
					Region: "us-west-1-fips",
				}: endpoint{
					Hostname:          "s3-control-fips.us-west-1.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{
					Hostname:          "s3-control.us-west-2.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
				},
				endpointKey{
					Region:  "us-west-2",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname:          "s3-control.dualstack.us-west-2.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
				},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname:          "s3-control-fips.us-west-2.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
				},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant | dualStackVariant,
				}: endpoint{
					Hostname:          "s3-control-fips.dualstack.us-west-2.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
				},
				endpointKey{
					Region: "us-west-2-fips",
				}: endpoint{
					Hostname:          "s3-control-fips.us-west-2.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
			},
		},
		"s3-outposts": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region:  "af-south-1",
					Variant: dualStackVariant,
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "ap-east-1",
					Variant: dualStackVariant,
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region:  "ap-northeast-1",
					Variant: dualStackVariant,
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region:  "ap-northeast-2",
					Variant: dualStackVariant,
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region:  "ap-northeast-3",
					Variant: dualStackVariant,
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region:  "ap-south-1",
					Variant: dualStackVariant,
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region:  "ap-southeast-1",
					Variant: dualStackVariant,
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region:  "ap-southeast-2",
					Variant: dualStackVariant,
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{},
				endpointKey{
					Region:  "ap-southeast-3",
					Variant: dualStackVariant,
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region:  "ca-central-1",
					Variant: dualStackVariant,
				}: endpoint{},
				endpointKey{
					Region:  "ca-central-1",
					Variant: fipsVariant,
				}: endpoint{},
				endpointKey{
					Region:  "ca-central-1",
					Variant: fipsVariant | dualStackVariant,
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region:  "eu-central-1",
					Variant: dualStackVariant,
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region:  "eu-north-1",
					Variant: dualStackVariant,
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region:  "eu-south-1",
					Variant: dualStackVariant,
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "eu-west-1",
					Variant: dualStackVariant,
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "eu-west-2",
					Variant: dualStackVariant,
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region:  "eu-west-3",
					Variant: dualStackVariant,
				}: endpoint{},
				endpointKey{
					Region: "fips-ca-central-1",
				}: endpoint{

					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{

					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{

					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-1",
				}: endpoint{

					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{

					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "il-central-1",
				}: endpoint{},
				endpointKey{
					Region:  "il-central-1",
					Variant: dualStackVariant,
				}: endpoint{},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region:  "me-south-1",
					Variant: dualStackVariant,
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "sa-east-1",
					Variant: dualStackVariant,
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: dualStackVariant,
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant | dualStackVariant,
				}: endpoint{},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: dualStackVariant,
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant | dualStackVariant,
				}: endpoint{},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: dualStackVariant,
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant | dualStackVariant,
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: dualStackVariant,
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant | dualStackVariant,
				}: endpoint{},
			},
		},
		"sagemaker-geospatial": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"savingsplans": service{
			PartitionEndpoint: "aws-global",
			IsRegionalized:    boxedFalse,
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "aws-global",
				}: endpoint{
					Hostname: "savingsplans.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
			},
		},
		"scheduler": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-4",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "me-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"schemas": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "me-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"sdb": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					Protocols:         []string{"http", "https"},
					SignatureVersions: []string{"v2"},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{
					Hostname: "sdb.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"secretsmanager": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region:  "af-south-1",
					Variant: dualStackVariant,
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "ap-east-1",
					Variant: dualStackVariant,
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region:  "ap-northeast-1",
					Variant: dualStackVariant,
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region:  "ap-northeast-2",
					Variant: dualStackVariant,
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region:  "ap-northeast-3",
					Variant: dualStackVariant,
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region:  "ap-south-1",
					Variant: dualStackVariant,
				}: endpoint{},
				endpointKey{
					Region: "ap-south-2",
				}: endpoint{},
				endpointKey{
					Region:  "ap-south-2",
					Variant: dualStackVariant,
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region:  "ap-southeast-1",
					Variant: dualStackVariant,
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region:  "ap-southeast-2",
					Variant: dualStackVariant,
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{},
				endpointKey{
					Region:  "ap-southeast-3",
					Variant: dualStackVariant,
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-4",
				}: endpoint{},
				endpointKey{
					Region:  "ap-southeast-4",
					Variant: dualStackVariant,
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region:  "ca-central-1",
					Variant: dualStackVariant,
				}: endpoint{},
				endpointKey{
					Region:  "ca-central-1",
					Variant: fipsVariant,
				}: endpoint{},
				endpointKey{
					Region:  "ca-central-1",
					Variant: fipsVariant | dualStackVariant,
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1-fips",
				}: endpoint{

					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "ca-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "ca-west-1",
					Variant: dualStackVariant,
				}: endpoint{},
				endpointKey{
					Region:  "ca-west-1",
					Variant: fipsVariant,
				}: endpoint{},
				endpointKey{
					Region:  "ca-west-1",
					Variant: fipsVariant | dualStackVariant,
				}: endpoint{},
				endpointKey{
					Region: "ca-west-1-fips",
				}: endpoint{

					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region:  "eu-central-1",
					Variant: dualStackVariant,
				}: endpoint{},
				endpointKey{
					Region: "eu-central-2",
				}: endpoint{},
				endpointKey{
					Region:  "eu-central-2",
					Variant: dualStackVariant,
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region:  "eu-north-1",
					Variant: dualStackVariant,
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region:  "eu-south-1",
					Variant: dualStackVariant,
				}: endpoint{},
				endpointKey{
					Region: "eu-south-2",
				}: endpoint{},
				endpointKey{
					Region:  "eu-south-2",
					Variant: dualStackVariant,
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "eu-west-1",
					Variant: dualStackVariant,
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "eu-west-2",
					Variant: dualStackVariant,
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region:  "eu-west-3",
					Variant: dualStackVariant,
				}: endpoint{},
				endpointKey{
					Region: "il-central-1",
				}: endpoint{},
				endpointKey{
					Region:  "il-central-1",
					Variant: dualStackVariant,
				}: endpoint{},
				endpointKey{
					Region: "me-central-1",
				}: endpoint{},
				endpointKey{
					Region:  "me-central-1",
					Variant: dualStackVariant,
				}: endpoint{},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region:  "me-south-1",
					Variant: dualStackVariant,
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "sa-east-1",
					Variant: dualStackVariant,
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: dualStackVariant,
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant | dualStackVariant,
				}: endpoint{},
				endpointKey{
					Region: "us-east-1-fips",
				}: endpoint{

					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: dualStackVariant,
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant | dualStackVariant,
				}: endpoint{},
				endpointKey{
					Region: "us-east-2-fips",
				}: endpoint{

					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: dualStackVariant,
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant | dualStackVariant,
				}: endpoint{},
				endpointKey{
					Region: "us-west-1-fips",
				}: endpoint{

					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: dualStackVariant,
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant | dualStackVariant,
				}: endpoint{},
				endpointKey{
					Region: "us-west-2-fips",
				}: endpoint{

					Deprecated: boxedTrue,
				},
			},
		},
		"securityhub": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-4",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "ca-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "securityhub-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "securityhub-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-1",
				}: endpoint{
					Hostname: "securityhub-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "securityhub-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "il-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "securityhub-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "securityhub-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "securityhub-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "securityhub-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"securitylake": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "securitylake-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "securitylake-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-1",
				}: endpoint{
					Hostname: "securitylake-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "securitylake-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "securitylake-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "securitylake-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "securitylake-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "securitylake-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"serverlessrepo": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					Protocols: []string{"https"},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{
					Protocols: []string{"https"},
				},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{
					Protocols: []string{"https"},
				},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{
					Protocols: []string{"https"},
				},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{
					Protocols: []string{"https"},
				},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{
					Protocols: []string{"https"},
				},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{
					Protocols: []string{"https"},
				},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{
					Protocols: []string{"https"},
				},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{
					Protocols: []string{"https"},
				},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{
					Protocols: []string{"https"},
				},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{
					Protocols: []string{"https"},
				},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{
					Protocols: []string{"https"},
				},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{
					Protocols: []string{"https"},
				},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{
					Protocols: []string{"https"},
				},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{
					Protocols: []string{"https"},
				},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{
					Protocols: []string{"https"},
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{
					Protocols: []string{"https"},
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{
					Protocols: []string{"https"},
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{
					Protocols: []string{"https"},
				},
			},
		},
		"servicecatalog": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-4",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "il-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "servicecatalog-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-1-fips",
				}: endpoint{
					Hostname: "servicecatalog-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "servicecatalog-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2-fips",
				}: endpoint{
					Hostname: "servicecatalog-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "servicecatalog-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1-fips",
				}: endpoint{
					Hostname: "servicecatalog-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "servicecatalog-fips.us-west-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2-fips",
				}: endpoint{
					Hostname: "servicecatalog-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
			},
		},
		"servicecatalog-appregistry": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-4",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region:  "ca-central-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "servicecatalog-appregistry-fips.ca-central-1.amazonaws.com",
				},
				endpointKey{
					Region: "ca-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "fips-ca-central-1",
				}: endpoint{
					Hostname: "servicecatalog-appregistry-fips.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "servicecatalog-appregistry-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "servicecatalog-appregistry-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-1",
				}: endpoint{
					Hostname: "servicecatalog-appregistry-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "servicecatalog-appregistry-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "il-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "servicecatalog-appregistry-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "servicecatalog-appregistry-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "servicecatalog-appregistry-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "servicecatalog-appregistry-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"servicediscovery": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region:  "af-south-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "servicediscovery.af-south-1.api.aws",
				},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "ap-east-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "servicediscovery.ap-east-1.api.aws",
				},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region:  "ap-northeast-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "servicediscovery.ap-northeast-1.api.aws",
				},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region:  "ap-northeast-2",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "servicediscovery.ap-northeast-2.api.aws",
				},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region:  "ap-northeast-3",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "servicediscovery.ap-northeast-3.api.aws",
				},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region:  "ap-south-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "servicediscovery.ap-south-1.api.aws",
				},
				endpointKey{
					Region: "ap-south-2",
				}: endpoint{},
				endpointKey{
					Region:  "ap-south-2",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "servicediscovery.ap-south-2.api.aws",
				},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region:  "ap-southeast-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "servicediscovery.ap-southeast-1.api.aws",
				},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region:  "ap-southeast-2",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "servicediscovery.ap-southeast-2.api.aws",
				},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{},
				endpointKey{
					Region:  "ap-southeast-3",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "servicediscovery.ap-southeast-3.api.aws",
				},
				endpointKey{
					Region: "ap-southeast-4",
				}: endpoint{},
				endpointKey{
					Region:  "ap-southeast-4",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "servicediscovery.ap-southeast-4.api.aws",
				},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region:  "ca-central-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "servicediscovery.ca-central-1.api.aws",
				},
				endpointKey{
					Region:  "ca-central-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "servicediscovery-fips.ca-central-1.amazonaws.com",
				},
				endpointKey{
					Region:  "ca-central-1",
					Variant: fipsVariant | dualStackVariant,
				}: endpoint{
					Hostname: "servicediscovery-fips.ca-central-1.api.aws",
				},
				endpointKey{
					Region: "ca-central-1-fips",
				}: endpoint{
					Hostname: "servicediscovery-fips.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region:  "eu-central-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "servicediscovery.eu-central-1.api.aws",
				},
				endpointKey{
					Region: "eu-central-2",
				}: endpoint{},
				endpointKey{
					Region:  "eu-central-2",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "servicediscovery.eu-central-2.api.aws",
				},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region:  "eu-north-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "servicediscovery.eu-north-1.api.aws",
				},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region:  "eu-south-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "servicediscovery.eu-south-1.api.aws",
				},
				endpointKey{
					Region: "eu-south-2",
				}: endpoint{},
				endpointKey{
					Region:  "eu-south-2",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "servicediscovery.eu-south-2.api.aws",
				},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "eu-west-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "servicediscovery.eu-west-1.api.aws",
				},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "eu-west-2",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "servicediscovery.eu-west-2.api.aws",
				},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region:  "eu-west-3",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "servicediscovery.eu-west-3.api.aws",
				},
				endpointKey{
					Region: "il-central-1",
				}: endpoint{},
				endpointKey{
					Region:  "il-central-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "servicediscovery.il-central-1.api.aws",
				},
				endpointKey{
					Region: "me-central-1",
				}: endpoint{},
				endpointKey{
					Region:  "me-central-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "servicediscovery.me-central-1.api.aws",
				},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region:  "me-south-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "servicediscovery.me-south-1.api.aws",
				},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "sa-east-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "servicediscovery.sa-east-1.api.aws",
				},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "servicediscovery.us-east-1.api.aws",
				},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "servicediscovery-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant | dualStackVariant,
				}: endpoint{
					Hostname: "servicediscovery-fips.us-east-1.api.aws",
				},
				endpointKey{
					Region: "us-east-1-fips",
				}: endpoint{
					Hostname: "servicediscovery-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "servicediscovery.us-east-2.api.aws",
				},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "servicediscovery-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant | dualStackVariant,
				}: endpoint{
					Hostname: "servicediscovery-fips.us-east-2.api.aws",
				},
				endpointKey{
					Region: "us-east-2-fips",
				}: endpoint{
					Hostname: "servicediscovery-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "servicediscovery.us-west-1.api.aws",
				},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "servicediscovery-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant | dualStackVariant,
				}: endpoint{
					Hostname: "servicediscovery-fips.us-west-1.api.aws",
				},
				endpointKey{
					Region: "us-west-1-fips",
				}: endpoint{
					Hostname: "servicediscovery-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "servicediscovery.us-west-2.api.aws",
				},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "servicediscovery-fips.us-west-2.amazonaws.com",
				},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant | dualStackVariant,
				}: endpoint{
					Hostname: "servicediscovery-fips.us-west-2.api.aws",
				},
				endpointKey{
					Region: "us-west-2-fips",
				}: endpoint{
					Hostname: "servicediscovery-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
			},
		},
		"servicequotas": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					Protocols: []string{"https"},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-4",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "ca-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "il-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"session.qldb": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "session.qldb-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "session.qldb-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "session.qldb-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "session.qldb-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "session.qldb-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "session.qldb-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"shield": service{
			PartitionEndpoint: "aws-global",
			IsRegionalized:    boxedFalse,
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					SSLCommonName: "shield.us-east-1.amazonaws.com",
					Protocols:     []string{"https"},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "aws-global",
				}: endpoint{
					Hostname: "shield.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				endpointKey{
					Region:  "aws-global",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "shield-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				endpointKey{
					Region: "fips-aws-global",
				}: endpoint{
					Hostname: "shield-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
			},
		},
		"signer": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "signer-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "signer-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-1",
				}: endpoint{
					Hostname: "signer-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "signer-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-verification-us-east-1",
				}: endpoint{
					Hostname: "verification.signer-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				endpointKey{
					Region: "fips-verification-us-east-2",
				}: endpoint{
					Hostname: "verification.signer-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
				},
				endpointKey{
					Region: "fips-verification-us-west-1",
				}: endpoint{
					Hostname: "verification.signer-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
				},
				endpointKey{
					Region: "fips-verification-us-west-2",
				}: endpoint{
					Hostname: "verification.signer-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
				},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "signer-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "signer-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "signer-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "signer-fips.us-west-2.amazonaws.com",
				},
				endpointKey{
					Region: "verification-af-south-1",
				}: endpoint{
					Hostname: "verification.signer.af-south-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "af-south-1",
					},
				},
				endpointKey{
					Region: "verification-ap-east-1",
				}: endpoint{
					Hostname: "verification.signer.ap-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-east-1",
					},
				},
				endpointKey{
					Region: "verification-ap-northeast-1",
				}: endpoint{
					Hostname: "verification.signer.ap-northeast-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-northeast-1",
					},
				},
				endpointKey{
					Region: "verification-ap-northeast-2",
				}: endpoint{
					Hostname: "verification.signer.ap-northeast-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-northeast-2",
					},
				},
				endpointKey{
					Region: "verification-ap-south-1",
				}: endpoint{
					Hostname: "verification.signer.ap-south-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-south-1",
					},
				},
				endpointKey{
					Region: "verification-ap-southeast-1",
				}: endpoint{
					Hostname: "verification.signer.ap-southeast-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-southeast-1",
					},
				},
				endpointKey{
					Region: "verification-ap-southeast-2",
				}: endpoint{
					Hostname: "verification.signer.ap-southeast-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-southeast-2",
					},
				},
				endpointKey{
					Region: "verification-ca-central-1",
				}: endpoint{
					Hostname: "verification.signer.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
				},
				endpointKey{
					Region: "verification-eu-central-1",
				}: endpoint{
					Hostname: "verification.signer.eu-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-central-1",
					},
				},
				endpointKey{
					Region: "verification-eu-north-1",
				}: endpoint{
					Hostname: "verification.signer.eu-north-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-north-1",
					},
				},
				endpointKey{
					Region: "verification-eu-south-1",
				}: endpoint{
					Hostname: "verification.signer.eu-south-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-south-1",
					},
				},
				endpointKey{
					Region: "verification-eu-west-1",
				}: endpoint{
					Hostname: "verification.signer.eu-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-west-1",
					},
				},
				endpointKey{
					Region: "verification-eu-west-2",
				}: endpoint{
					Hostname: "verification.signer.eu-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-west-2",
					},
				},
				endpointKey{
					Region: "verification-eu-west-3",
				}: endpoint{
					Hostname: "verification.signer.eu-west-3.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-west-3",
					},
				},
				endpointKey{
					Region: "verification-me-south-1",
				}: endpoint{
					Hostname: "verification.signer.me-south-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "me-south-1",
					},
				},
				endpointKey{
					Region: "verification-sa-east-1",
				}: endpoint{
					Hostname: "verification.signer.sa-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "sa-east-1",
					},
				},
				endpointKey{
					Region: "verification-us-east-1",
				}: endpoint{
					Hostname: "verification.signer.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				endpointKey{
					Region: "verification-us-east-2",
				}: endpoint{
					Hostname: "verification.signer.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
				},
				endpointKey{
					Region: "verification-us-west-1",
				}: endpoint{
					Hostname: "verification.signer.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
				},
				endpointKey{
					Region: "verification-us-west-2",
				}: endpoint{
					Hostname: "verification.signer.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
				},
			},
		},
		"simspaceweaver": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"sms": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "sms-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "sms-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"sms-voice": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region:  "ca-central-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "sms-voice-fips.ca-central-1.amazonaws.com",
				},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "fips-ca-central-1",
				}: endpoint{
					Hostname: "sms-voice-fips.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "sms-voice-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "sms-voice-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "sms-voice-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "sms-voice-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"snowball": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region:  "ap-northeast-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "snowball-fips.ap-northeast-1.amazonaws.com",
				},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region:  "ap-northeast-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "snowball-fips.ap-northeast-2.amazonaws.com",
				},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region:  "ap-northeast-3",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "snowball-fips.ap-northeast-3.amazonaws.com",
				},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region:  "ap-south-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "snowball-fips.ap-south-1.amazonaws.com",
				},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region:  "ap-southeast-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "snowball-fips.ap-southeast-1.amazonaws.com",
				},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region:  "ap-southeast-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "snowball-fips.ap-southeast-2.amazonaws.com",
				},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region:  "ca-central-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "snowball-fips.ca-central-1.amazonaws.com",
				},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region:  "eu-central-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "snowball-fips.eu-central-1.amazonaws.com",
				},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "eu-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "snowball-fips.eu-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "eu-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "snowball-fips.eu-west-2.amazonaws.com",
				},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region:  "eu-west-3",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "snowball-fips.eu-west-3.amazonaws.com",
				},
				endpointKey{
					Region: "fips-ap-northeast-1",
				}: endpoint{
					Hostname: "snowball-fips.ap-northeast-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-northeast-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-ap-northeast-2",
				}: endpoint{
					Hostname: "snowball-fips.ap-northeast-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-northeast-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-ap-northeast-3",
				}: endpoint{
					Hostname: "snowball-fips.ap-northeast-3.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-northeast-3",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-ap-south-1",
				}: endpoint{
					Hostname: "snowball-fips.ap-south-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-south-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-ap-southeast-1",
				}: endpoint{
					Hostname: "snowball-fips.ap-southeast-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-southeast-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-ap-southeast-2",
				}: endpoint{
					Hostname: "snowball-fips.ap-southeast-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-southeast-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-ca-central-1",
				}: endpoint{
					Hostname: "snowball-fips.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-eu-central-1",
				}: endpoint{
					Hostname: "snowball-fips.eu-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-central-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-eu-west-1",
				}: endpoint{
					Hostname: "snowball-fips.eu-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-eu-west-2",
				}: endpoint{
					Hostname: "snowball-fips.eu-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-eu-west-3",
				}: endpoint{
					Hostname: "snowball-fips.eu-west-3.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-west-3",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-sa-east-1",
				}: endpoint{
					Hostname: "snowball-fips.sa-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "sa-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "snowball-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "snowball-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-1",
				}: endpoint{
					Hostname: "snowball-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "snowball-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "me-central-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "sa-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "snowball-fips.sa-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "snowball-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "snowball-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "snowball-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "snowball-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"sns": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					Protocols: []string{"http", "https"},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-4",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "ca-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "ca-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "sns-fips.ca-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "fips-ca-west-1",
				}: endpoint{
					Hostname: "sns-fips.ca-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "sns-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "sns-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-1",
				}: endpoint{
					Hostname: "sns-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "sns-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "il-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "sns-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "sns-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "sns-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "sns-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"sqs": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					SSLCommonName: "{region}.queue.{dnsSuffix}",
					Protocols:     []string{"http", "https"},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-4",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "ca-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "sqs-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "sqs-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-1",
				}: endpoint{
					Hostname: "sqs-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "sqs-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "il-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{
					SSLCommonName: "queue.{dnsSuffix}",
				},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname:      "sqs-fips.us-east-1.amazonaws.com",
					SSLCommonName: "queue.{dnsSuffix}",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "sqs-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "sqs-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "sqs-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"ssm": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-4",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region:  "ca-central-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "ssm-fips.ca-central-1.amazonaws.com",
				},
				endpointKey{
					Region: "ca-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "ca-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "ssm-fips.ca-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "fips-ca-central-1",
				}: endpoint{
					Hostname: "ssm-fips.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-ca-west-1",
				}: endpoint{
					Hostname: "ssm-fips.ca-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "ssm-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "ssm-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-1",
				}: endpoint{
					Hostname: "ssm-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "ssm-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "il-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "ssm-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "ssm-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "ssm-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "ssm-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"ssm-contacts": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "ssm-contacts-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "ssm-contacts-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-1",
				}: endpoint{
					Hostname: "ssm-contacts-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "ssm-contacts-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "ssm-contacts-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "ssm-contacts-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "ssm-contacts-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "ssm-contacts-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"ssm-incidents": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region:  "ca-central-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "ssm-incidents-fips.ca-central-1.amazonaws.com",
				},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "fips-ca-central-1",
				}: endpoint{
					Hostname: "ssm-incidents-fips.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "ssm-incidents-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "ssm-incidents-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-1",
				}: endpoint{
					Hostname: "ssm-incidents-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "ssm-incidents-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "ssm-incidents-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "ssm-incidents-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "ssm-incidents-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "ssm-incidents-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"ssm-sap": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region:  "ca-central-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "ssm-sap-fips.ca-central-1.amazonaws.com",
				},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "fips-ca-central-1",
				}: endpoint{
					Hostname: "ssm-sap-fips.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "ssm-sap-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "ssm-sap-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-1",
				}: endpoint{
					Hostname: "ssm-sap-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "ssm-sap-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "ssm-sap-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "ssm-sap-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "ssm-sap-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "ssm-sap-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"sso": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "il-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"states": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-4",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "ca-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "states-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "states-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-1",
				}: endpoint{
					Hostname: "states-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "states-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "il-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "states-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "states-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "states-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "states-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"storagegateway": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-4",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region:  "ca-central-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "storagegateway-fips.ca-central-1.amazonaws.com",
				},
				endpointKey{
					Region: "ca-central-1-fips",
				}: endpoint{
					Hostname: "storagegateway-fips.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "il-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "storagegateway-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-1-fips",
				}: endpoint{
					Hostname: "storagegateway-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "storagegateway-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2-fips",
				}: endpoint{
					Hostname: "storagegateway-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "storagegateway-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1-fips",
				}: endpoint{
					Hostname: "storagegateway-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "storagegateway-fips.us-west-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2-fips",
				}: endpoint{
					Hostname: "storagegateway-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
			},
		},
		"streams.dynamodb": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					Protocols: []string{"http", "https"},
					CredentialScope: credentialScope{
						Service: "dynamodb",
					},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-4",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "ca-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "il-central-1",
				}: endpoint{},
				endpointKey{
					Region: "local",
				}: endpoint{
					Hostname:  "localhost:8000",
					Protocols: []string{"http"},
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				endpointKey{
					Region: "me-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"sts": service{
			PartitionEndpoint: "aws-global",
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-4",
				}: endpoint{},
				endpointKey{
					Region: "aws-global",
				}: endpoint{
					Hostname: "sts.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "ca-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "il-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "sts-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-1-fips",
				}: endpoint{
					Hostname: "sts-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "sts-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2-fips",
				}: endpoint{
					Hostname: "sts-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "sts-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1-fips",
				}: endpoint{
					Hostname: "sts-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "sts-fips.us-west-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2-fips",
				}: endpoint{
					Hostname: "sts-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
			},
		},
		"support": service{
			PartitionEndpoint: "aws-global",
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "aws-global",
				}: endpoint{
					Hostname: "support.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
			},
		},
		"supportapp": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"swf": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-4",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "ca-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "swf-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "swf-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-1",
				}: endpoint{
					Hostname: "swf-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "swf-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "il-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "swf-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "swf-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "swf-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "swf-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"synthetics": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-4",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "ca-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "synthetics-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "synthetics-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-1",
				}: endpoint{
					Hostname: "synthetics-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "synthetics-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "il-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "synthetics-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "synthetics-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "synthetics-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "synthetics-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"tagging": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-4",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "ca-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "il-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"textract": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region:  "ca-central-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "textract-fips.ca-central-1.amazonaws.com",
				},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "fips-ca-central-1",
				}: endpoint{
					Hostname: "textract-fips.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "textract-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "textract-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-1",
				}: endpoint{
					Hostname: "textract-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "textract-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "textract-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "textract-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "textract-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "textract-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"thinclient": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"tnb": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"transcribe": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					Protocols: []string{"https"},
				},
				defaultKey{
					Variant: fipsVariant,
				}: endpoint{
					Hostname:  "fips.transcribe.{region}.{dnsSuffix}",
					Protocols: []string{"https"},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region:  "ca-central-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "fips.transcribe.ca-central-1.amazonaws.com",
				},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "fips-ca-central-1",
				}: endpoint{
					Hostname: "fips.transcribe.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "fips.transcribe.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "fips.transcribe.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-1",
				}: endpoint{
					Hostname: "fips.transcribe.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "fips.transcribe.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "fips.transcribe.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "fips.transcribe.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "fips.transcribe.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "fips.transcribe.us-west-2.amazonaws.com",
				},
			},
		},
		"transcribestreaming": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "transcribestreaming-ca-central-1",
				}: endpoint{
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region:  "transcribestreaming-ca-central-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "transcribestreaming-fips.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "transcribestreaming-fips-ca-central-1",
				}: endpoint{
					Hostname: "transcribestreaming-fips.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "transcribestreaming-fips-us-east-1",
				}: endpoint{
					Hostname: "transcribestreaming-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "transcribestreaming-fips-us-east-2",
				}: endpoint{
					Hostname: "transcribestreaming-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "transcribestreaming-fips-us-west-2",
				}: endpoint{
					Hostname: "transcribestreaming-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "transcribestreaming-us-east-1",
				}: endpoint{
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region:  "transcribestreaming-us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "transcribestreaming-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "transcribestreaming-us-east-2",
				}: endpoint{
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region:  "transcribestreaming-us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "transcribestreaming-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "transcribestreaming-us-west-2",
				}: endpoint{
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region:  "transcribestreaming-us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "transcribestreaming-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"transfer": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-4",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region:  "ca-central-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "transfer-fips.ca-central-1.amazonaws.com",
				},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "fips-ca-central-1",
				}: endpoint{
					Hostname: "transfer-fips.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "transfer-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "transfer-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-1",
				}: endpoint{
					Hostname: "transfer-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "transfer-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "il-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "transfer-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "transfer-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "transfer-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "transfer-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"translate": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					Protocols: []string{"https"},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "translate-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-1-fips",
				}: endpoint{
					Hostname: "translate-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "translate-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2-fips",
				}: endpoint{
					Hostname: "translate-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "translate-fips.us-west-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2-fips",
				}: endpoint{
					Hostname: "translate-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
			},
		},
		"verifiedpermissions": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-4",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "me-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"voice-chime": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region:  "ca-central-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "voice-chime-fips.ca-central-1.amazonaws.com",
				},
				endpointKey{
					Region: "ca-central-1-fips",
				}: endpoint{
					Hostname: "voice-chime-fips.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "voice-chime-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-1-fips",
				}: endpoint{
					Hostname: "voice-chime-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "voice-chime-fips.us-west-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2-fips",
				}: endpoint{
					Hostname: "voice-chime-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
			},
		},
		"voiceid": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region:  "ca-central-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "voiceid-fips.ca-central-1.amazonaws.com",
				},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "fips-ca-central-1",
				}: endpoint{
					Hostname: "voiceid-fips.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "voiceid-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "voiceid-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "voiceid-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "voiceid-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"vpc-lattice": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"waf": service{
			PartitionEndpoint: "aws-global",
			IsRegionalized:    boxedFalse,
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "aws",
				}: endpoint{
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region:  "aws",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "waf-fips.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "aws-fips",
				}: endpoint{
					Hostname: "waf-fips.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "aws-global",
				}: endpoint{
					Hostname: "waf.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				endpointKey{
					Region:  "aws-global",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "waf-fips.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				endpointKey{
					Region: "aws-global-fips",
				}: endpoint{
					Hostname: "waf-fips.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
			},
		},
		"waf-regional": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{
					Hostname: "waf-regional.af-south-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "af-south-1",
					},
				},
				endpointKey{
					Region:  "af-south-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "waf-regional-fips.af-south-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "af-south-1",
					},
				},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{
					Hostname: "waf-regional.ap-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-east-1",
					},
				},
				endpointKey{
					Region:  "ap-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "waf-regional-fips.ap-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-east-1",
					},
				},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{
					Hostname: "waf-regional.ap-northeast-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-northeast-1",
					},
				},
				endpointKey{
					Region:  "ap-northeast-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "waf-regional-fips.ap-northeast-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-northeast-1",
					},
				},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{
					Hostname: "waf-regional.ap-northeast-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-northeast-2",
					},
				},
				endpointKey{
					Region:  "ap-northeast-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "waf-regional-fips.ap-northeast-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-northeast-2",
					},
				},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{
					Hostname: "waf-regional.ap-northeast-3.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-northeast-3",
					},
				},
				endpointKey{
					Region:  "ap-northeast-3",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "waf-regional-fips.ap-northeast-3.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-northeast-3",
					},
				},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{
					Hostname: "waf-regional.ap-south-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-south-1",
					},
				},
				endpointKey{
					Region:  "ap-south-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "waf-regional-fips.ap-south-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-south-1",
					},
				},
				endpointKey{
					Region: "ap-south-2",
				}: endpoint{
					Hostname: "waf-regional.ap-south-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-south-2",
					},
				},
				endpointKey{
					Region:  "ap-south-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "waf-regional-fips.ap-south-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-south-2",
					},
				},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{
					Hostname: "waf-regional.ap-southeast-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-southeast-1",
					},
				},
				endpointKey{
					Region:  "ap-southeast-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "waf-regional-fips.ap-southeast-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-southeast-1",
					},
				},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{
					Hostname: "waf-regional.ap-southeast-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-southeast-2",
					},
				},
				endpointKey{
					Region:  "ap-southeast-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "waf-regional-fips.ap-southeast-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-southeast-2",
					},
				},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{
					Hostname: "waf-regional.ap-southeast-3.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-southeast-3",
					},
				},
				endpointKey{
					Region:  "ap-southeast-3",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "waf-regional-fips.ap-southeast-3.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-southeast-3",
					},
				},
				endpointKey{
					Region: "ap-southeast-4",
				}: endpoint{
					Hostname: "waf-regional.ap-southeast-4.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-southeast-4",
					},
				},
				endpointKey{
					Region:  "ap-southeast-4",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "waf-regional-fips.ap-southeast-4.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-southeast-4",
					},
				},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{
					Hostname: "waf-regional.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
				},
				endpointKey{
					Region:  "ca-central-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "waf-regional-fips.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
				},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{
					Hostname: "waf-regional.eu-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-central-1",
					},
				},
				endpointKey{
					Region:  "eu-central-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "waf-regional-fips.eu-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-central-1",
					},
				},
				endpointKey{
					Region: "eu-central-2",
				}: endpoint{
					Hostname: "waf-regional.eu-central-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-central-2",
					},
				},
				endpointKey{
					Region:  "eu-central-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "waf-regional-fips.eu-central-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-central-2",
					},
				},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{
					Hostname: "waf-regional.eu-north-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-north-1",
					},
				},
				endpointKey{
					Region:  "eu-north-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "waf-regional-fips.eu-north-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-north-1",
					},
				},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{
					Hostname: "waf-regional.eu-south-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-south-1",
					},
				},
				endpointKey{
					Region:  "eu-south-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "waf-regional-fips.eu-south-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-south-1",
					},
				},
				endpointKey{
					Region: "eu-south-2",
				}: endpoint{
					Hostname: "waf-regional.eu-south-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-south-2",
					},
				},
				endpointKey{
					Region:  "eu-south-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "waf-regional-fips.eu-south-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-south-2",
					},
				},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{
					Hostname: "waf-regional.eu-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-west-1",
					},
				},
				endpointKey{
					Region:  "eu-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "waf-regional-fips.eu-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-west-1",
					},
				},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{
					Hostname: "waf-regional.eu-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-west-2",
					},
				},
				endpointKey{
					Region:  "eu-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "waf-regional-fips.eu-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-west-2",
					},
				},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{
					Hostname: "waf-regional.eu-west-3.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-west-3",
					},
				},
				endpointKey{
					Region:  "eu-west-3",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "waf-regional-fips.eu-west-3.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-west-3",
					},
				},
				endpointKey{
					Region: "fips-af-south-1",
				}: endpoint{
					Hostname: "waf-regional-fips.af-south-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "af-south-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-ap-east-1",
				}: endpoint{
					Hostname: "waf-regional-fips.ap-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-ap-northeast-1",
				}: endpoint{
					Hostname: "waf-regional-fips.ap-northeast-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-northeast-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-ap-northeast-2",
				}: endpoint{
					Hostname: "waf-regional-fips.ap-northeast-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-northeast-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-ap-northeast-3",
				}: endpoint{
					Hostname: "waf-regional-fips.ap-northeast-3.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-northeast-3",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-ap-south-1",
				}: endpoint{
					Hostname: "waf-regional-fips.ap-south-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-south-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-ap-south-2",
				}: endpoint{
					Hostname: "waf-regional-fips.ap-south-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-south-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-ap-southeast-1",
				}: endpoint{
					Hostname: "waf-regional-fips.ap-southeast-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-southeast-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-ap-southeast-2",
				}: endpoint{
					Hostname: "waf-regional-fips.ap-southeast-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-southeast-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-ap-southeast-3",
				}: endpoint{
					Hostname: "waf-regional-fips.ap-southeast-3.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-southeast-3",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-ap-southeast-4",
				}: endpoint{
					Hostname: "waf-regional-fips.ap-southeast-4.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-southeast-4",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-ca-central-1",
				}: endpoint{
					Hostname: "waf-regional-fips.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-eu-central-1",
				}: endpoint{
					Hostname: "waf-regional-fips.eu-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-central-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-eu-central-2",
				}: endpoint{
					Hostname: "waf-regional-fips.eu-central-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-central-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-eu-north-1",
				}: endpoint{
					Hostname: "waf-regional-fips.eu-north-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-north-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-eu-south-1",
				}: endpoint{
					Hostname: "waf-regional-fips.eu-south-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-south-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-eu-south-2",
				}: endpoint{
					Hostname: "waf-regional-fips.eu-south-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-south-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-eu-west-1",
				}: endpoint{
					Hostname: "waf-regional-fips.eu-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-eu-west-2",
				}: endpoint{
					Hostname: "waf-regional-fips.eu-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-eu-west-3",
				}: endpoint{
					Hostname: "waf-regional-fips.eu-west-3.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-west-3",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-il-central-1",
				}: endpoint{
					Hostname: "waf-regional-fips.il-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "il-central-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-me-central-1",
				}: endpoint{
					Hostname: "waf-regional-fips.me-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "me-central-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-me-south-1",
				}: endpoint{
					Hostname: "waf-regional-fips.me-south-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "me-south-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-sa-east-1",
				}: endpoint{
					Hostname: "waf-regional-fips.sa-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "sa-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "waf-regional-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "waf-regional-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-1",
				}: endpoint{
					Hostname: "waf-regional-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "waf-regional-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "il-central-1",
				}: endpoint{
					Hostname: "waf-regional.il-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "il-central-1",
					},
				},
				endpointKey{
					Region:  "il-central-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "waf-regional-fips.il-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "il-central-1",
					},
				},
				endpointKey{
					Region: "me-central-1",
				}: endpoint{
					Hostname: "waf-regional.me-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "me-central-1",
					},
				},
				endpointKey{
					Region:  "me-central-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "waf-regional-fips.me-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "me-central-1",
					},
				},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{
					Hostname: "waf-regional.me-south-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "me-south-1",
					},
				},
				endpointKey{
					Region:  "me-south-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "waf-regional-fips.me-south-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "me-south-1",
					},
				},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{
					Hostname: "waf-regional.sa-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "sa-east-1",
					},
				},
				endpointKey{
					Region:  "sa-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "waf-regional-fips.sa-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "sa-east-1",
					},
				},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{
					Hostname: "waf-regional.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "waf-regional-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{
					Hostname: "waf-regional.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
				},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "waf-regional-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{
					Hostname: "waf-regional.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
				},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "waf-regional-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{
					Hostname: "waf-regional.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
				},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "waf-regional-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
				},
			},
		},
		"wafv2": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{
					Hostname: "wafv2.af-south-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "af-south-1",
					},
				},
				endpointKey{
					Region:  "af-south-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "wafv2-fips.af-south-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "af-south-1",
					},
				},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{
					Hostname: "wafv2.ap-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-east-1",
					},
				},
				endpointKey{
					Region:  "ap-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "wafv2-fips.ap-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-east-1",
					},
				},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{
					Hostname: "wafv2.ap-northeast-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-northeast-1",
					},
				},
				endpointKey{
					Region:  "ap-northeast-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "wafv2-fips.ap-northeast-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-northeast-1",
					},
				},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{
					Hostname: "wafv2.ap-northeast-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-northeast-2",
					},
				},
				endpointKey{
					Region:  "ap-northeast-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "wafv2-fips.ap-northeast-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-northeast-2",
					},
				},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{
					Hostname: "wafv2.ap-northeast-3.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-northeast-3",
					},
				},
				endpointKey{
					Region:  "ap-northeast-3",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "wafv2-fips.ap-northeast-3.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-northeast-3",
					},
				},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{
					Hostname: "wafv2.ap-south-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-south-1",
					},
				},
				endpointKey{
					Region:  "ap-south-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "wafv2-fips.ap-south-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-south-1",
					},
				},
				endpointKey{
					Region: "ap-south-2",
				}: endpoint{
					Hostname: "wafv2.ap-south-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-south-2",
					},
				},
				endpointKey{
					Region:  "ap-south-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "wafv2-fips.ap-south-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-south-2",
					},
				},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{
					Hostname: "wafv2.ap-southeast-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-southeast-1",
					},
				},
				endpointKey{
					Region:  "ap-southeast-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "wafv2-fips.ap-southeast-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-southeast-1",
					},
				},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{
					Hostname: "wafv2.ap-southeast-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-southeast-2",
					},
				},
				endpointKey{
					Region:  "ap-southeast-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "wafv2-fips.ap-southeast-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-southeast-2",
					},
				},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{
					Hostname: "wafv2.ap-southeast-3.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-southeast-3",
					},
				},
				endpointKey{
					Region:  "ap-southeast-3",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "wafv2-fips.ap-southeast-3.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-southeast-3",
					},
				},
				endpointKey{
					Region: "ap-southeast-4",
				}: endpoint{
					Hostname: "wafv2.ap-southeast-4.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-southeast-4",
					},
				},
				endpointKey{
					Region:  "ap-southeast-4",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "wafv2-fips.ap-southeast-4.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-southeast-4",
					},
				},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{
					Hostname: "wafv2.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
				},
				endpointKey{
					Region:  "ca-central-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "wafv2-fips.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
				},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{
					Hostname: "wafv2.eu-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-central-1",
					},
				},
				endpointKey{
					Region:  "eu-central-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "wafv2-fips.eu-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-central-1",
					},
				},
				endpointKey{
					Region: "eu-central-2",
				}: endpoint{
					Hostname: "wafv2.eu-central-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-central-2",
					},
				},
				endpointKey{
					Region:  "eu-central-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "wafv2-fips.eu-central-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-central-2",
					},
				},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{
					Hostname: "wafv2.eu-north-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-north-1",
					},
				},
				endpointKey{
					Region:  "eu-north-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "wafv2-fips.eu-north-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-north-1",
					},
				},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{
					Hostname: "wafv2.eu-south-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-south-1",
					},
				},
				endpointKey{
					Region:  "eu-south-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "wafv2-fips.eu-south-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-south-1",
					},
				},
				endpointKey{
					Region: "eu-south-2",
				}: endpoint{
					Hostname: "wafv2.eu-south-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-south-2",
					},
				},
				endpointKey{
					Region:  "eu-south-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "wafv2-fips.eu-south-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-south-2",
					},
				},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{
					Hostname: "wafv2.eu-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-west-1",
					},
				},
				endpointKey{
					Region:  "eu-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "wafv2-fips.eu-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-west-1",
					},
				},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{
					Hostname: "wafv2.eu-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-west-2",
					},
				},
				endpointKey{
					Region:  "eu-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "wafv2-fips.eu-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-west-2",
					},
				},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{
					Hostname: "wafv2.eu-west-3.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-west-3",
					},
				},
				endpointKey{
					Region:  "eu-west-3",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "wafv2-fips.eu-west-3.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-west-3",
					},
				},
				endpointKey{
					Region: "fips-af-south-1",
				}: endpoint{
					Hostname: "wafv2-fips.af-south-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "af-south-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-ap-east-1",
				}: endpoint{
					Hostname: "wafv2-fips.ap-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-ap-northeast-1",
				}: endpoint{
					Hostname: "wafv2-fips.ap-northeast-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-northeast-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-ap-northeast-2",
				}: endpoint{
					Hostname: "wafv2-fips.ap-northeast-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-northeast-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-ap-northeast-3",
				}: endpoint{
					Hostname: "wafv2-fips.ap-northeast-3.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-northeast-3",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-ap-south-1",
				}: endpoint{
					Hostname: "wafv2-fips.ap-south-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-south-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-ap-south-2",
				}: endpoint{
					Hostname: "wafv2-fips.ap-south-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-south-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-ap-southeast-1",
				}: endpoint{
					Hostname: "wafv2-fips.ap-southeast-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-southeast-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-ap-southeast-2",
				}: endpoint{
					Hostname: "wafv2-fips.ap-southeast-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-southeast-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-ap-southeast-3",
				}: endpoint{
					Hostname: "wafv2-fips.ap-southeast-3.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-southeast-3",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-ap-southeast-4",
				}: endpoint{
					Hostname: "wafv2-fips.ap-southeast-4.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-southeast-4",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-ca-central-1",
				}: endpoint{
					Hostname: "wafv2-fips.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-eu-central-1",
				}: endpoint{
					Hostname: "wafv2-fips.eu-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-central-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-eu-central-2",
				}: endpoint{
					Hostname: "wafv2-fips.eu-central-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-central-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-eu-north-1",
				}: endpoint{
					Hostname: "wafv2-fips.eu-north-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-north-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-eu-south-1",
				}: endpoint{
					Hostname: "wafv2-fips.eu-south-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-south-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-eu-south-2",
				}: endpoint{
					Hostname: "wafv2-fips.eu-south-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-south-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-eu-west-1",
				}: endpoint{
					Hostname: "wafv2-fips.eu-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-eu-west-2",
				}: endpoint{
					Hostname: "wafv2-fips.eu-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-eu-west-3",
				}: endpoint{
					Hostname: "wafv2-fips.eu-west-3.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-west-3",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-il-central-1",
				}: endpoint{
					Hostname: "wafv2-fips.il-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "il-central-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-me-central-1",
				}: endpoint{
					Hostname: "wafv2-fips.me-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "me-central-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-me-south-1",
				}: endpoint{
					Hostname: "wafv2-fips.me-south-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "me-south-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-sa-east-1",
				}: endpoint{
					Hostname: "wafv2-fips.sa-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "sa-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "wafv2-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "wafv2-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-1",
				}: endpoint{
					Hostname: "wafv2-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "wafv2-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "il-central-1",
				}: endpoint{
					Hostname: "wafv2.il-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "il-central-1",
					},
				},
				endpointKey{
					Region:  "il-central-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "wafv2-fips.il-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "il-central-1",
					},
				},
				endpointKey{
					Region: "me-central-1",
				}: endpoint{
					Hostname: "wafv2.me-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "me-central-1",
					},
				},
				endpointKey{
					Region:  "me-central-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "wafv2-fips.me-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "me-central-1",
					},
				},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{
					Hostname: "wafv2.me-south-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "me-south-1",
					},
				},
				endpointKey{
					Region:  "me-south-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "wafv2-fips.me-south-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "me-south-1",
					},
				},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{
					Hostname: "wafv2.sa-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "sa-east-1",
					},
				},
				endpointKey{
					Region:  "sa-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "wafv2-fips.sa-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "sa-east-1",
					},
				},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{
					Hostname: "wafv2.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "wafv2-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{
					Hostname: "wafv2.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
				},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "wafv2-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{
					Hostname: "wafv2.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
				},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "wafv2-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{
					Hostname: "wafv2.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
				},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "wafv2-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
				},
			},
		},
		"wellarchitected": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"wisdom": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{

					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{

					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "ui-ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ui-ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ui-eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "ui-eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "ui-us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ui-us-west-2",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{},
			},
		},
		"workdocs": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "workdocs-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "workdocs-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "workdocs-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "workdocs-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"workmail": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					Protocols: []string{"https"},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"workspaces": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "workspaces-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "workspaces-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "il-central-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "workspaces-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "workspaces-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"workspaces-web": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"xray": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-4",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "ca-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "xray-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "xray-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-1",
				}: endpoint{
					Hostname: "xray-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "xray-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "il-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-central-1",
				}: endpoint{},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "xray-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "xray-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "xray-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "xray-fips.us-west-2.amazonaws.com",
				},
			},
		},
	},
}

// AwsCnPartition returns the Resolver for AWS China.
func AwsCnPartition() Partition {
	return awscnPartition.Partition()
}

var awscnPartition = partition{
	ID:        "aws-cn",
	Name:      "AWS China",
	DNSSuffix: "amazonaws.com.cn",
	RegionRegex: regionRegex{
		Regexp: func() *regexp.Regexp {
			reg, _ := regexp.Compile("^cn\\-\\w+\\-\\d+$")
			return reg
		}(),
	},
	Defaults: endpointDefaults{
		defaultKey{}: endpoint{
			Hostname:          "{service}.{region}.{dnsSuffix}",
			Protocols:         []string{"https"},
			SignatureVersions: []string{"v4"},
		},
		defaultKey{
			Variant: dualStackVariant,
		}: endpoint{
			Hostname:          "{service}.{region}.{dnsSuffix}",
			DNSSuffix:         "api.amazonwebservices.com.cn",
			Protocols:         []string{"https"},
			SignatureVersions: []string{"v4"},
		},
		defaultKey{
			Variant: fipsVariant,
		}: endpoint{
			Hostname:          "{service}-fips.{region}.{dnsSuffix}",
			DNSSuffix:         "amazonaws.com.cn",
			Protocols:         []string{"https"},
			SignatureVersions: []string{"v4"},
		},
		defaultKey{
			Variant: fipsVariant | dualStackVariant,
		}: endpoint{
			Hostname:          "{service}-fips.{region}.{dnsSuffix}",
			DNSSuffix:         "api.amazonwebservices.com.cn",
			Protocols:         []string{"https"},
			SignatureVersions: []string{"v4"},
		},
	},
	Regions: regions{
		"cn-north-1": region{
			Description: "China (Beijing)",
		},
		"cn-northwest-1": region{
			Description: "China (Ningxia)",
		},
	},
	Services: services{
		"access-analyzer": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"account": service{
			PartitionEndpoint: "aws-cn-global",
			IsRegionalized:    boxedFalse,
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "aws-cn-global",
				}: endpoint{
					Hostname: "account.cn-northwest-1.amazonaws.com.cn",
					CredentialScope: credentialScope{
						Region: "cn-northwest-1",
					},
				},
			},
		},
		"acm": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"airflow": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"api.ecr": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{
					Hostname: "api.ecr.cn-north-1.amazonaws.com.cn",
					CredentialScope: credentialScope{
						Region: "cn-north-1",
					},
				},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{
					Hostname: "api.ecr.cn-northwest-1.amazonaws.com.cn",
					CredentialScope: credentialScope{
						Region: "cn-northwest-1",
					},
				},
			},
		},
		"api.pricing": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					CredentialScope: credentialScope{
						Service: "pricing",
					},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"api.sagemaker": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"api.tunneling.iot": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"apigateway": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"appconfig": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"appconfigdata": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"application-autoscaling": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					Protocols: []string{"http", "https"},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"applicationinsights": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"appmesh": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region:  "cn-north-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "appmesh.cn-north-1.api.amazonwebservices.com.cn",
				},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
				endpointKey{
					Region:  "cn-northwest-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "appmesh.cn-northwest-1.api.amazonwebservices.com.cn",
				},
			},
		},
		"appsync": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"arc-zonal-shift": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"athena": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region:  "cn-north-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "athena.cn-north-1.api.amazonwebservices.com.cn",
				},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
				endpointKey{
					Region:  "cn-northwest-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "athena.cn-northwest-1.api.amazonwebservices.com.cn",
				},
			},
		},
		"autoscaling": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					Protocols: []string{"http", "https"},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"autoscaling-plans": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					Protocols: []string{"http", "https"},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"backup": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"backupstorage": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"batch": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"budgets": service{
			PartitionEndpoint: "aws-cn-global",
			IsRegionalized:    boxedFalse,
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "aws-cn-global",
				}: endpoint{
					Hostname: "budgets.amazonaws.com.cn",
					CredentialScope: credentialScope{
						Region: "cn-northwest-1",
					},
				},
			},
		},
		"cassandra": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"ce": service{
			PartitionEndpoint: "aws-cn-global",
			IsRegionalized:    boxedFalse,
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "aws-cn-global",
				}: endpoint{
					Hostname: "ce.cn-northwest-1.amazonaws.com.cn",
					CredentialScope: credentialScope{
						Region: "cn-northwest-1",
					},
				},
			},
		},
		"cloudcontrolapi": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"cloudformation": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"cloudfront": service{
			PartitionEndpoint: "aws-cn-global",
			IsRegionalized:    boxedFalse,
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "aws-cn-global",
				}: endpoint{
					Hostname:  "cloudfront.cn-northwest-1.amazonaws.com.cn",
					Protocols: []string{"http", "https"},
					CredentialScope: credentialScope{
						Region: "cn-northwest-1",
					},
				},
			},
		},
		"cloudtrail": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"codebuild": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"codecommit": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"codedeploy": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"codepipeline": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"cognito-identity": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
			},
		},
		"compute-optimizer": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{
					Hostname: "compute-optimizer.cn-north-1.amazonaws.com.cn",
					CredentialScope: credentialScope{
						Region: "cn-north-1",
					},
				},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{
					Hostname: "compute-optimizer.cn-northwest-1.amazonaws.com.cn",
					CredentialScope: credentialScope{
						Region: "cn-northwest-1",
					},
				},
			},
		},
		"config": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"cur": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"data-ats.iot": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					Protocols: []string{"https"},
					CredentialScope: credentialScope{
						Service: "iotdata",
					},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{
					Hostname:  "data.ats.iot.cn-north-1.amazonaws.com.cn",
					Protocols: []string{"https"},
				},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"data.jobs.iot": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"databrew": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"datasync": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"datazone": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					DNSSuffix: "api.amazonwebservices.com.cn",
				},
				defaultKey{
					Variant: fipsVariant,
				}: endpoint{
					Hostname:  "{service}-fips.{region}.{dnsSuffix}",
					DNSSuffix: "api.amazonwebservices.com.cn",
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{
					Hostname: "datazone.cn-north-1.api.amazonwebservices.com.cn",
				},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{
					Hostname: "datazone.cn-northwest-1.api.amazonwebservices.com.cn",
				},
			},
		},
		"dax": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"directconnect": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"dlm": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"dms": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"docdb": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{
					Hostname: "rds.cn-northwest-1.amazonaws.com.cn",
					CredentialScope: credentialScope{
						Region: "cn-northwest-1",
					},
				},
			},
		},
		"ds": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"dynamodb": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					Protocols: []string{"http", "https"},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"ebs": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"ec2": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					Protocols: []string{"http", "https"},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"ecs": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"eks": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					Protocols: []string{"http", "https"},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"eks-auth": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					DNSSuffix: "api.amazonwebservices.com.cn",
				},
				defaultKey{
					Variant: fipsVariant,
				}: endpoint{
					Hostname:  "{service}-fips.{region}.{dnsSuffix}",
					DNSSuffix: "api.amazonwebservices.com.cn",
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{
					Hostname: "eks-auth.cn-north-1.api.amazonwebservices.com.cn",
				},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{
					Hostname: "eks-auth.cn-northwest-1.api.amazonwebservices.com.cn",
				},
			},
		},
		"elasticache": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"elasticbeanstalk": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"elasticfilesystem": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region:  "cn-north-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "elasticfilesystem-fips.cn-north-1.amazonaws.com.cn",
				},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
				endpointKey{
					Region:  "cn-northwest-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "elasticfilesystem-fips.cn-northwest-1.amazonaws.com.cn",
				},
				endpointKey{
					Region: "fips-cn-north-1",
				}: endpoint{
					Hostname: "elasticfilesystem-fips.cn-north-1.amazonaws.com.cn",
					CredentialScope: credentialScope{
						Region: "cn-north-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-cn-northwest-1",
				}: endpoint{
					Hostname: "elasticfilesystem-fips.cn-northwest-1.amazonaws.com.cn",
					CredentialScope: credentialScope{
						Region: "cn-northwest-1",
					},
					Deprecated: boxedTrue,
				},
			},
		},
		"elasticloadbalancing": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					Protocols: []string{"https"},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"elasticmapreduce": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					Protocols: []string{"https"},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region:  "cn-north-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "elasticmapreduce.cn-north-1.api.amazonwebservices.com.cn",
				},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
				endpointKey{
					Region:  "cn-northwest-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "elasticmapreduce.cn-northwest-1.api.amazonwebservices.com.cn",
				},
			},
		},
		"emr-containers": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"emr-serverless": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"es": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region:  "cn-north-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "aos.cn-north-1.api.amazonwebservices.com.cn",
				},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
				endpointKey{
					Region:  "cn-northwest-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "aos.cn-northwest-1.api.amazonwebservices.com.cn",
				},
			},
		},
		"events": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"firehose": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region:  "cn-north-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "firehose.cn-north-1.api.amazonwebservices.com.cn",
				},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
				endpointKey{
					Region:  "cn-northwest-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "firehose.cn-northwest-1.api.amazonwebservices.com.cn",
				},
			},
		},
		"fms": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					Protocols: []string{"https"},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"fsx": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"gamelift": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"glacier": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					Protocols: []string{"http", "https"},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"glue": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"greengrass": service{
			IsRegionalized: boxedTrue,
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					Protocols: []string{"https"},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
			},
		},
		"guardduty": service{
			IsRegionalized: boxedTrue,
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					Protocols: []string{"https"},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"health": service{
			PartitionEndpoint: "aws-cn-global",
			IsRegionalized:    boxedFalse,
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					SSLCommonName: "health.cn-northwest-1.amazonaws.com.cn",
					Protocols:     []string{"https"},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "aws-cn-global",
				}: endpoint{
					Hostname: "global.health.amazonaws.com.cn",
					CredentialScope: credentialScope{
						Region: "cn-northwest-1",
					},
				},
			},
		},
		"iam": service{
			PartitionEndpoint: "aws-cn-global",
			IsRegionalized:    boxedFalse,
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "aws-cn-global",
				}: endpoint{
					Hostname: "iam.cn-north-1.amazonaws.com.cn",
					CredentialScope: credentialScope{
						Region: "cn-north-1",
					},
				},
			},
		},
		"identitystore": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"internetmonitor": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					DNSSuffix: "api.amazonwebservices.com.cn",
				},
				defaultKey{
					Variant: fipsVariant,
				}: endpoint{
					Hostname:  "{service}-fips.{region}.{dnsSuffix}",
					DNSSuffix: "api.amazonwebservices.com.cn",
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{
					Hostname: "internetmonitor.cn-north-1.api.amazonwebservices.com.cn",
				},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{
					Hostname: "internetmonitor.cn-northwest-1.api.amazonwebservices.com.cn",
				},
			},
		},
		"iot": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"iotanalytics": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
			},
		},
		"iotevents": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
			},
		},
		"ioteventsdata": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{
					Hostname: "data.iotevents.cn-north-1.amazonaws.com.cn",
					CredentialScope: credentialScope{
						Region: "cn-north-1",
					},
				},
			},
		},
		"iotsecuredtunneling": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"iotsitewise": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
			},
		},
		"iottwinmaker": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "api-cn-north-1",
				}: endpoint{
					Hostname: "api.iottwinmaker.cn-north-1.amazonaws.com.cn",
					CredentialScope: credentialScope{
						Region: "cn-north-1",
					},
				},
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "data-cn-north-1",
				}: endpoint{
					Hostname: "data.iottwinmaker.cn-north-1.amazonaws.com.cn",
					CredentialScope: credentialScope{
						Region: "cn-north-1",
					},
				},
			},
		},
		"kafka": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"kendra-ranking": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					DNSSuffix: "api.amazonwebservices.com.cn",
				},
				defaultKey{
					Variant: fipsVariant,
				}: endpoint{
					Hostname:  "{service}-fips.{region}.{dnsSuffix}",
					DNSSuffix: "api.amazonwebservices.com.cn",
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{
					Hostname: "kendra-ranking.cn-north-1.api.amazonwebservices.com.cn",
				},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{
					Hostname: "kendra-ranking.cn-northwest-1.api.amazonwebservices.com.cn",
				},
			},
		},
		"kinesis": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"kinesisanalytics": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"kinesisvideo": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
			},
		},
		"kms": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"lakeformation": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"lambda": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region:  "cn-north-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "lambda.cn-north-1.api.amazonwebservices.com.cn",
				},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
				endpointKey{
					Region:  "cn-northwest-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "lambda.cn-northwest-1.api.amazonwebservices.com.cn",
				},
			},
		},
		"license-manager": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"license-manager-linux-subscriptions": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"logs": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"mediaconvert": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{
					Hostname: "subscribe.mediaconvert.cn-northwest-1.amazonaws.com.cn",
					CredentialScope: credentialScope{
						Region: "cn-northwest-1",
					},
				},
			},
		},
		"memory-db": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"metrics.sagemaker": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"monitoring": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					Protocols: []string{"http", "https"},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"mq": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"neptune": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{
					Hostname: "rds.cn-north-1.amazonaws.com.cn",
					CredentialScope: credentialScope{
						Region: "cn-north-1",
					},
				},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{
					Hostname: "rds.cn-northwest-1.amazonaws.com.cn",
					CredentialScope: credentialScope{
						Region: "cn-northwest-1",
					},
				},
			},
		},
		"oam": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"oidc": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{
					Hostname: "oidc.cn-north-1.amazonaws.com.cn",
					CredentialScope: credentialScope{
						Region: "cn-north-1",
					},
				},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{
					Hostname: "oidc.cn-northwest-1.amazonaws.com.cn",
					CredentialScope: credentialScope{
						Region: "cn-northwest-1",
					},
				},
			},
		},
		"organizations": service{
			PartitionEndpoint: "aws-cn-global",
			IsRegionalized:    boxedFalse,
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "aws-cn-global",
				}: endpoint{
					Hostname: "organizations.cn-northwest-1.amazonaws.com.cn",
					CredentialScope: credentialScope{
						Region: "cn-northwest-1",
					},
				},
			},
		},
		"personalize": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
			},
		},
		"pi": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"pipes": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"polly": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"portal.sso": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{
					Hostname: "portal.sso.cn-north-1.amazonaws.com.cn",
					CredentialScope: credentialScope{
						Region: "cn-north-1",
					},
				},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{
					Hostname: "portal.sso.cn-northwest-1.amazonaws.com.cn",
					CredentialScope: credentialScope{
						Region: "cn-northwest-1",
					},
				},
			},
		},
		"qbusiness": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					DNSSuffix: "api.amazonwebservices.com.cn",
				},
				defaultKey{
					Variant: fipsVariant,
				}: endpoint{
					Hostname:  "{service}-fips.{region}.{dnsSuffix}",
					DNSSuffix: "api.amazonwebservices.com.cn",
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{
					Hostname: "qbusiness.cn-north-1.api.amazonwebservices.com.cn",
				},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{
					Hostname: "qbusiness.cn-northwest-1.api.amazonwebservices.com.cn",
				},
			},
		},
		"ram": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"rbin": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"rds": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"redshift": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"redshift-serverless": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
			},
		},
		"resource-explorer-2": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					DNSSuffix: "api.amazonwebservices.com.cn",
				},
				defaultKey{
					Variant: fipsVariant,
				}: endpoint{
					Hostname:  "{service}-fips.{region}.{dnsSuffix}",
					DNSSuffix: "api.amazonwebservices.com.cn",
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{
					Hostname: "resource-explorer-2.cn-north-1.api.amazonwebservices.com.cn",
				},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{
					Hostname: "resource-explorer-2.cn-northwest-1.api.amazonwebservices.com.cn",
				},
			},
		},
		"resource-groups": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"rolesanywhere": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"route53": service{
			PartitionEndpoint: "aws-cn-global",
			IsRegionalized:    boxedFalse,
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "aws-cn-global",
				}: endpoint{
					Hostname: "route53.amazonaws.com.cn",
					CredentialScope: credentialScope{
						Region: "cn-northwest-1",
					},
				},
			},
		},
		"route53resolver": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					Protocols: []string{"https"},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"runtime.sagemaker": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"s3": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					Protocols:         []string{"http", "https"},
					SignatureVersions: []string{"s3v4"},
				},
				defaultKey{
					Variant: dualStackVariant,
				}: endpoint{
					Hostname:          "{service}.dualstack.{region}.{dnsSuffix}",
					DNSSuffix:         "amazonaws.com.cn",
					Protocols:         []string{"http", "https"},
					SignatureVersions: []string{"s3v4"},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region:  "cn-north-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "s3.dualstack.cn-north-1.amazonaws.com.cn",
				},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
				endpointKey{
					Region:  "cn-northwest-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "s3.dualstack.cn-northwest-1.amazonaws.com.cn",
				},
			},
		},
		"s3-control": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					Protocols:         []string{"https"},
					SignatureVersions: []string{"s3v4"},
				},
				defaultKey{
					Variant: dualStackVariant,
				}: endpoint{
					Hostname:          "{service}.dualstack.{region}.{dnsSuffix}",
					DNSSuffix:         "amazonaws.com.cn",
					Protocols:         []string{"https"},
					SignatureVersions: []string{"s3v4"},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{
					Hostname:          "s3-control.cn-north-1.amazonaws.com.cn",
					SignatureVersions: []string{"s3v4"},
					CredentialScope: credentialScope{
						Region: "cn-north-1",
					},
				},
				endpointKey{
					Region:  "cn-north-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname:          "s3-control.dualstack.cn-north-1.amazonaws.com.cn",
					SignatureVersions: []string{"s3v4"},
					CredentialScope: credentialScope{
						Region: "cn-north-1",
					},
				},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{
					Hostname:          "s3-control.cn-northwest-1.amazonaws.com.cn",
					SignatureVersions: []string{"s3v4"},
					CredentialScope: credentialScope{
						Region: "cn-northwest-1",
					},
				},
				endpointKey{
					Region:  "cn-northwest-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname:          "s3-control.dualstack.cn-northwest-1.amazonaws.com.cn",
					SignatureVersions: []string{"s3v4"},
					CredentialScope: credentialScope{
						Region: "cn-northwest-1",
					},
				},
			},
		},
		"savingsplans": service{
			IsRegionalized: boxedTrue,
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{
					Hostname: "savingsplans.cn-north-1.amazonaws.com.cn",
					CredentialScope: credentialScope{
						Region: "cn-north-1",
					},
				},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{
					Hostname: "savingsplans.cn-northwest-1.amazonaws.com.cn",
					CredentialScope: credentialScope{
						Region: "cn-northwest-1",
					},
				},
			},
		},
		"schemas": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"secretsmanager": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region:  "cn-north-1",
					Variant: dualStackVariant,
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
				endpointKey{
					Region:  "cn-northwest-1",
					Variant: dualStackVariant,
				}: endpoint{},
			},
		},
		"securityhub": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"serverlessrepo": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					Protocols: []string{"https"},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{
					Protocols: []string{"https"},
				},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{
					Protocols: []string{"https"},
				},
			},
		},
		"servicecatalog": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"servicediscovery": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region:  "cn-north-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "servicediscovery.cn-north-1.api.amazonwebservices.com.cn",
				},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
				endpointKey{
					Region:  "cn-northwest-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "servicediscovery.cn-northwest-1.api.amazonwebservices.com.cn",
				},
			},
		},
		"servicequotas": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					Protocols: []string{"https"},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"signer": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
				endpointKey{
					Region: "verification-cn-north-1",
				}: endpoint{
					Hostname: "verification.signer.cn-north-1.amazonaws.com.cn",
					CredentialScope: credentialScope{
						Region: "cn-north-1",
					},
				},
				endpointKey{
					Region: "verification-cn-northwest-1",
				}: endpoint{
					Hostname: "verification.signer.cn-northwest-1.amazonaws.com.cn",
					CredentialScope: credentialScope{
						Region: "cn-northwest-1",
					},
				},
			},
		},
		"sms": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
			},
		},
		"snowball": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region:  "cn-north-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "snowball-fips.cn-north-1.amazonaws.com.cn",
				},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
				endpointKey{
					Region:  "cn-northwest-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "snowball-fips.cn-northwest-1.amazonaws.com.cn",
				},
				endpointKey{
					Region: "fips-cn-north-1",
				}: endpoint{
					Hostname: "snowball-fips.cn-north-1.amazonaws.com.cn",
					CredentialScope: credentialScope{
						Region: "cn-north-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-cn-northwest-1",
				}: endpoint{
					Hostname: "snowball-fips.cn-northwest-1.amazonaws.com.cn",
					CredentialScope: credentialScope{
						Region: "cn-northwest-1",
					},
					Deprecated: boxedTrue,
				},
			},
		},
		"sns": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					Protocols: []string{"http", "https"},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"sqs": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					SSLCommonName: "{region}.queue.{dnsSuffix}",
					Protocols:     []string{"http", "https"},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"ssm": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"sso": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"states": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region:  "cn-north-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "states.cn-north-1.api.amazonwebservices.com.cn",
				},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
				endpointKey{
					Region:  "cn-northwest-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "states.cn-northwest-1.api.amazonwebservices.com.cn",
				},
			},
		},
		"storagegateway": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"streams.dynamodb": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					Protocols: []string{"http", "https"},
					CredentialScope: credentialScope{
						Service: "dynamodb",
					},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"sts": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"support": service{
			PartitionEndpoint: "aws-cn-global",
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "aws-cn-global",
				}: endpoint{
					Hostname: "support.cn-north-1.amazonaws.com.cn",
					CredentialScope: credentialScope{
						Region: "cn-north-1",
					},
				},
			},
		},
		"swf": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"synthetics": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"tagging": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"transcribe": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					Protocols: []string{"https"},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{
					Hostname: "cn.transcribe.cn-north-1.amazonaws.com.cn",
					CredentialScope: credentialScope{
						Region: "cn-north-1",
					},
				},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{
					Hostname: "cn.transcribe.cn-northwest-1.amazonaws.com.cn",
					CredentialScope: credentialScope{
						Region: "cn-northwest-1",
					},
				},
			},
		},
		"transcribestreaming": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"transfer": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"waf-regional": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{
					Hostname: "waf-regional.cn-north-1.amazonaws.com.cn",
					CredentialScope: credentialScope{
						Region: "cn-north-1",
					},
				},
				endpointKey{
					Region:  "cn-north-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "waf-regional-fips.cn-north-1.amazonaws.com.cn",
					CredentialScope: credentialScope{
						Region: "cn-north-1",
					},
				},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{
					Hostname: "waf-regional.cn-northwest-1.amazonaws.com.cn",
					CredentialScope: credentialScope{
						Region: "cn-northwest-1",
					},
				},
				endpointKey{
					Region:  "cn-northwest-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "waf-regional-fips.cn-northwest-1.amazonaws.com.cn",
					CredentialScope: credentialScope{
						Region: "cn-northwest-1",
					},
				},
				endpointKey{
					Region: "fips-cn-north-1",
				}: endpoint{
					Hostname: "waf-regional-fips.cn-north-1.amazonaws.com.cn",
					CredentialScope: credentialScope{
						Region: "cn-north-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-cn-northwest-1",
				}: endpoint{
					Hostname: "waf-regional-fips.cn-northwest-1.amazonaws.com.cn",
					CredentialScope: credentialScope{
						Region: "cn-northwest-1",
					},
					Deprecated: boxedTrue,
				},
			},
		},
		"wafv2": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{
					Hostname: "wafv2.cn-north-1.amazonaws.com.cn",
					CredentialScope: credentialScope{
						Region: "cn-north-1",
					},
				},
				endpointKey{
					Region:  "cn-north-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "wafv2-fips.cn-north-1.amazonaws.com.cn",
					CredentialScope: credentialScope{
						Region: "cn-north-1",
					},
				},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{
					Hostname: "wafv2.cn-northwest-1.amazonaws.com.cn",
					CredentialScope: credentialScope{
						Region: "cn-northwest-1",
					},
				},
				endpointKey{
					Region:  "cn-northwest-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "wafv2-fips.cn-northwest-1.amazonaws.com.cn",
					CredentialScope: credentialScope{
						Region: "cn-northwest-1",
					},
				},
				endpointKey{
					Region: "fips-cn-north-1",
				}: endpoint{
					Hostname: "wafv2-fips.cn-north-1.amazonaws.com.cn",
					CredentialScope: credentialScope{
						Region: "cn-north-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-cn-northwest-1",
				}: endpoint{
					Hostname: "wafv2-fips.cn-northwest-1.amazonaws.com.cn",
					CredentialScope: credentialScope{
						Region: "cn-northwest-1",
					},
					Deprecated: boxedTrue,
				},
			},
		},
		"workspaces": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"xray": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
	},
}

// AwsUsGovPartition returns the Resolver for AWS GovCloud (US).
func AwsUsGovPartition() Partition {
	return awsusgovPartition.Partition()
}

var awsusgovPartition = partition{
	ID:        "aws-us-gov",
	Name:      "AWS GovCloud (US)",
	DNSSuffix: "amazonaws.com",
	RegionRegex: regionRegex{
		Regexp: func() *regexp.Regexp {
			reg, _ := regexp.Compile("^us\\-gov\\-\\w+\\-\\d+$")
			return reg
		}(),
	},
	Defaults: endpointDefaults{
		defaultKey{}: endpoint{
			Hostname:          "{service}.{region}.{dnsSuffix}",
			Protocols:         []string{"https"},
			SignatureVersions: []string{"v4"},
		},
		defaultKey{
			Variant: dualStackVariant,
		}: endpoint{
			Hostname:          "{service}.{region}.{dnsSuffix}",
			DNSSuffix:         "api.aws",
			Protocols:         []string{"https"},
			SignatureVersions: []string{"v4"},
		},
		defaultKey{
			Variant: fipsVariant,
		}: endpoint{
			Hostname:          "{service}-fips.{region}.{dnsSuffix}",
			DNSSuffix:         "amazonaws.com",
			Protocols:         []string{"https"},
			SignatureVersions: []string{"v4"},
		},
		defaultKey{
			Variant: fipsVariant | dualStackVariant,
		}: endpoint{
			Hostname:          "{service}-fips.{region}.{dnsSuffix}",
			DNSSuffix:         "api.aws",
			Protocols:         []string{"https"},
			SignatureVersions: []string{"v4"},
		},
	},
	Regions: regions{
		"us-gov-east-1": region{
			Description: "AWS GovCloud (US-East)",
		},
		"us-gov-west-1": region{
			Description: "AWS GovCloud (US-West)",
		},
	},
	Services: services{
		"access-analyzer": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{
					Hostname: "access-analyzer.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
				},
				endpointKey{
					Region:  "us-gov-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "access-analyzer.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
				},
				endpointKey{
					Region: "us-gov-east-1-fips",
				}: endpoint{
					Hostname: "access-analyzer.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{
					Hostname: "access-analyzer.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "access-analyzer.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
				endpointKey{
					Region: "us-gov-west-1-fips",
				}: endpoint{
					Hostname: "access-analyzer.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
			},
		},
		"acm": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{},
				defaultKey{
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "acm.{region}.{dnsSuffix}",
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{
					Hostname: "acm.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{
					Hostname: "acm.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
			},
		},
		"acm-pca": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					Protocols: []string{"https"},
				},
				defaultKey{
					Variant: fipsVariant,
				}: endpoint{
					Hostname:  "acm-pca.{region}.{dnsSuffix}",
					Protocols: []string{"https"},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "fips-us-gov-east-1",
				}: endpoint{
					Hostname: "acm-pca.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-gov-west-1",
				}: endpoint{
					Hostname: "acm-pca.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "acm-pca.us-gov-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "acm-pca.us-gov-west-1.amazonaws.com",
				},
			},
		},
		"api.detective": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					Protocols: []string{"https"},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "api.detective-fips.us-gov-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-gov-east-1-fips",
				}: endpoint{
					Hostname: "api.detective-fips.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "api.detective-fips.us-gov-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-gov-west-1-fips",
				}: endpoint{
					Hostname: "api.detective-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
			},
		},
		"api.ecr": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{},
				defaultKey{
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "ecr-fips.{region}.{dnsSuffix}",
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "dkr-us-gov-east-1",
				}: endpoint{
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region:  "dkr-us-gov-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "ecr-fips.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "dkr-us-gov-west-1",
				}: endpoint{
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region:  "dkr-us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "ecr-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-dkr-us-gov-east-1",
				}: endpoint{
					Hostname: "ecr-fips.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-dkr-us-gov-west-1",
				}: endpoint{
					Hostname: "ecr-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-gov-east-1",
				}: endpoint{
					Hostname: "ecr-fips.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-gov-west-1",
				}: endpoint{
					Hostname: "ecr-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{
					Hostname: "api.ecr.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
				},
				endpointKey{
					Region:  "us-gov-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "ecr-fips.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{
					Hostname: "api.ecr.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "ecr-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
			},
		},
		"api.sagemaker": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{},
				defaultKey{
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "api-fips.sagemaker.{region}.{dnsSuffix}",
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "api-fips.sagemaker.us-gov-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-gov-west-1-fips",
				}: endpoint{
					Hostname: "api-fips.sagemaker.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-west-1-fips-secondary",
				}: endpoint{
					Hostname: "api.sagemaker.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-west-1-secondary",
				}: endpoint{
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region:  "us-gov-west-1-secondary",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "api.sagemaker.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
			},
		},
		"api.tunneling.iot": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{},
				defaultKey{
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "api.tunneling.iot-fips.{region}.{dnsSuffix}",
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "fips-us-gov-east-1",
				}: endpoint{
					Hostname: "api.tunneling.iot-fips.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-gov-west-1",
				}: endpoint{
					Hostname: "api.tunneling.iot-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "api.tunneling.iot-fips.us-gov-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "api.tunneling.iot-fips.us-gov-west-1.amazonaws.com",
				},
			},
		},
		"apigateway": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
			},
		},
		"appconfig": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "fips-us-gov-east-1",
				}: endpoint{
					Hostname: "appconfig.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-gov-west-1",
				}: endpoint{
					Hostname: "appconfig.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "appconfig.us-gov-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "appconfig.us-gov-west-1.amazonaws.com",
				},
			},
		},
		"appconfigdata": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "fips-us-gov-east-1",
				}: endpoint{
					Hostname: "appconfigdata.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-gov-west-1",
				}: endpoint{
					Hostname: "appconfigdata.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "appconfigdata.us-gov-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "appconfigdata.us-gov-west-1.amazonaws.com",
				},
			},
		},
		"application-autoscaling": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					Hostname:  "autoscaling.{region}.amazonaws.com",
					Protocols: []string{"http", "https"},
					CredentialScope: credentialScope{
						Service: "application-autoscaling",
					},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{
					Hostname:  "application-autoscaling.us-gov-east-1.amazonaws.com",
					Protocols: []string{"http", "https"},
				},
				endpointKey{
					Region:  "us-gov-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname:  "application-autoscaling.us-gov-east-1.amazonaws.com",
					Protocols: []string{"http", "https"},
				},
				endpointKey{
					Region: "us-gov-east-1-fips",
				}: endpoint{
					Hostname:  "application-autoscaling.us-gov-east-1.amazonaws.com",
					Protocols: []string{"http", "https"},

					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{
					Hostname:  "application-autoscaling.us-gov-west-1.amazonaws.com",
					Protocols: []string{"http", "https"},
				},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname:  "application-autoscaling.us-gov-west-1.amazonaws.com",
					Protocols: []string{"http", "https"},
				},
				endpointKey{
					Region: "us-gov-west-1-fips",
				}: endpoint{
					Hostname:  "application-autoscaling.us-gov-west-1.amazonaws.com",
					Protocols: []string{"http", "https"},

					Deprecated: boxedTrue,
				},
			},
		},
		"applicationinsights": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{
					Hostname: "applicationinsights.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{
					Hostname: "applicationinsights.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
			},
		},
		"appstream2": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					Protocols: []string{"https"},
					CredentialScope: credentialScope{
						Service: "appstream",
					},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "fips",
				}: endpoint{
					Hostname: "appstream2-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "appstream2-fips.us-gov-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-gov-east-1-fips",
				}: endpoint{
					Hostname: "appstream2-fips.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "appstream2-fips.us-gov-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-gov-west-1-fips",
				}: endpoint{
					Hostname: "appstream2-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
			},
		},
		"arc-zonal-shift": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
			},
		},
		"athena": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "fips-us-gov-east-1",
				}: endpoint{
					Hostname: "athena-fips.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-gov-west-1",
				}: endpoint{
					Hostname: "athena-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-east-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "athena.us-gov-east-1.api.aws",
				},
				endpointKey{
					Region:  "us-gov-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "athena-fips.us-gov-east-1.amazonaws.com",
				},
				endpointKey{
					Region:  "us-gov-east-1",
					Variant: fipsVariant | dualStackVariant,
				}: endpoint{
					Hostname: "athena-fips.us-gov-east-1.api.aws",
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "athena.us-gov-west-1.api.aws",
				},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "athena-fips.us-gov-west-1.amazonaws.com",
				},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant | dualStackVariant,
				}: endpoint{
					Hostname: "athena-fips.us-gov-west-1.api.aws",
				},
			},
		},
		"autoscaling": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{},
				defaultKey{
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "autoscaling.{region}.{dnsSuffix}",
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{
					Protocols: []string{"http", "https"},
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{
					Protocols: []string{"http", "https"},
				},
			},
		},
		"autoscaling-plans": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					Protocols: []string{"http", "https"},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{
					Protocols: []string{"http", "https"},
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{
					Protocols: []string{"http", "https"},
				},
			},
		},
		"backup": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
			},
		},
		"backup-gateway": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
			},
		},
		"backupstorage": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
			},
		},
		"batch": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{},
				defaultKey{
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "batch.{region}.{dnsSuffix}",
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "fips-us-gov-east-1",
				}: endpoint{
					Hostname: "batch.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-gov-west-1",
				}: endpoint{
					Hostname: "batch.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "batch.us-gov-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "batch.us-gov-west-1.amazonaws.com",
				},
			},
		},
		"bedrock": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
			},
		},
		"cassandra": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{
					Hostname: "cassandra.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
				},
				endpointKey{
					Region:  "us-gov-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "cassandra.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
				},
				endpointKey{
					Region: "us-gov-east-1-fips",
				}: endpoint{
					Hostname: "cassandra.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{
					Hostname: "cassandra.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "cassandra.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
				endpointKey{
					Region: "us-gov-west-1-fips",
				}: endpoint{
					Hostname: "cassandra.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
			},
		},
		"cloudcontrolapi": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "fips-us-gov-east-1",
				}: endpoint{
					Hostname: "cloudcontrolapi-fips.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-gov-west-1",
				}: endpoint{
					Hostname: "cloudcontrolapi-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "cloudcontrolapi-fips.us-gov-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "cloudcontrolapi-fips.us-gov-west-1.amazonaws.com",
				},
			},
		},
		"clouddirectory": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "clouddirectory.us-gov-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-gov-west-1-fips",
				}: endpoint{
					Hostname: "clouddirectory.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
			},
		},
		"cloudformation": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{
					Hostname: "cloudformation.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
				},
				endpointKey{
					Region:  "us-gov-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "cloudformation.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
				},
				endpointKey{
					Region: "us-gov-east-1-fips",
				}: endpoint{
					Hostname: "cloudformation.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{
					Hostname: "cloudformation.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "cloudformation.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
				endpointKey{
					Region: "us-gov-west-1-fips",
				}: endpoint{
					Hostname: "cloudformation.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
			},
		},
		"cloudhsm": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
			},
		},
		"cloudhsmv2": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					CredentialScope: credentialScope{
						Service: "cloudhsm",
					},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
			},
		},
		"cloudtrail": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{},
				defaultKey{
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "cloudtrail.us-gov-west-1.amazonaws.com",
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "fips-us-gov-east-1",
				}: endpoint{
					Hostname: "cloudtrail.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-gov-west-1",
				}: endpoint{
					Hostname: "cloudtrail.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "cloudtrail.us-gov-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "cloudtrail.us-gov-west-1.amazonaws.com",
				},
			},
		},
		"codebuild": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "codebuild-fips.us-gov-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-gov-east-1-fips",
				}: endpoint{
					Hostname: "codebuild-fips.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "codebuild-fips.us-gov-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-gov-west-1-fips",
				}: endpoint{
					Hostname: "codebuild-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
			},
		},
		"codecommit": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "fips",
				}: endpoint{
					Hostname: "codecommit-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "codecommit-fips.us-gov-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-gov-east-1-fips",
				}: endpoint{
					Hostname: "codecommit-fips.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "codecommit-fips.us-gov-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-gov-west-1-fips",
				}: endpoint{
					Hostname: "codecommit-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
			},
		},
		"codedeploy": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "codedeploy-fips.us-gov-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-gov-east-1-fips",
				}: endpoint{
					Hostname: "codedeploy-fips.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "codedeploy-fips.us-gov-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-gov-west-1-fips",
				}: endpoint{
					Hostname: "codedeploy-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
			},
		},
		"codepipeline": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "fips-us-gov-east-1",
				}: endpoint{
					Hostname: "codepipeline-fips.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-gov-west-1",
				}: endpoint{
					Hostname: "codepipeline-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "codepipeline-fips.us-gov-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "codepipeline-fips.us-gov-west-1.amazonaws.com",
				},
			},
		},
		"codestar-connections": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{},
			},
		},
		"cognito-identity": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "fips-us-gov-west-1",
				}: endpoint{
					Hostname: "cognito-identity-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "cognito-identity-fips.us-gov-west-1.amazonaws.com",
				},
			},
		},
		"cognito-idp": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "fips-us-gov-west-1",
				}: endpoint{
					Hostname: "cognito-idp-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "cognito-idp-fips.us-gov-west-1.amazonaws.com",
				},
			},
		},
		"comprehend": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					Protocols: []string{"https"},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "fips-us-gov-west-1",
				}: endpoint{
					Hostname: "comprehend-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "comprehend-fips.us-gov-west-1.amazonaws.com",
				},
			},
		},
		"comprehendmedical": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "fips-us-gov-west-1",
				}: endpoint{
					Hostname: "comprehendmedical-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "comprehendmedical-fips.us-gov-west-1.amazonaws.com",
				},
			},
		},
		"compute-optimizer": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{
					Hostname: "compute-optimizer-fips.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{
					Hostname: "compute-optimizer-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
			},
		},
		"config": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{},
				defaultKey{
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "config.{region}.{dnsSuffix}",
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "fips-us-gov-east-1",
				}: endpoint{
					Hostname: "config.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-gov-west-1",
				}: endpoint{
					Hostname: "config.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "config.us-gov-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "config.us-gov-west-1.amazonaws.com",
				},
			},
		},
		"connect": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "fips-us-gov-west-1",
				}: endpoint{
					Hostname: "connect.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "connect.us-gov-west-1.amazonaws.com",
				},
			},
		},
		"controltower": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
			},
		},
		"data-ats.iot": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					Protocols: []string{"https"},
					CredentialScope: credentialScope{
						Service: "iotdata",
					},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "fips-us-gov-east-1",
				}: endpoint{
					Hostname: "data.iot-fips.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Service: "iotdata",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-gov-west-1",
				}: endpoint{
					Hostname: "data.iot-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Service: "iotdata",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "data.iot-fips.us-gov-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "data.iot-fips.us-gov-west-1.amazonaws.com",
				},
			},
		},
		"data.jobs.iot": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "fips-us-gov-east-1",
				}: endpoint{
					Hostname: "data.jobs.iot-fips.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-gov-west-1",
				}: endpoint{
					Hostname: "data.jobs.iot-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "data.jobs.iot-fips.us-gov-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "data.jobs.iot-fips.us-gov-west-1.amazonaws.com",
				},
			},
		},
		"databrew": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "fips-us-gov-west-1",
				}: endpoint{
					Hostname: "databrew.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "databrew.us-gov-west-1.amazonaws.com",
				},
			},
		},
		"datasync": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "fips-us-gov-east-1",
				}: endpoint{
					Hostname: "datasync-fips.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-gov-west-1",
				}: endpoint{
					Hostname: "datasync-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "datasync-fips.us-gov-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "datasync-fips.us-gov-west-1.amazonaws.com",
				},
			},
		},
		"datazone": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					DNSSuffix: "api.aws",
				},
				defaultKey{
					Variant: fipsVariant,
				}: endpoint{
					Hostname:  "{service}-fips.{region}.{dnsSuffix}",
					DNSSuffix: "api.aws",
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{
					Hostname: "datazone.us-gov-east-1.api.aws",
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{
					Hostname: "datazone.us-gov-west-1.api.aws",
				},
			},
		},
		"directconnect": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{
					Hostname: "directconnect.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{
					Hostname: "directconnect.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
			},
		},
		"dlm": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "dlm.us-gov-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-gov-east-1-fips",
				}: endpoint{
					Hostname: "dlm.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "dlm.us-gov-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-gov-west-1-fips",
				}: endpoint{
					Hostname: "dlm.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
			},
		},
		"dms": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{},
				defaultKey{
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "dms.{region}.{dnsSuffix}",
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "dms",
				}: endpoint{
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region:  "dms",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "dms.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "dms-fips",
				}: endpoint{
					Hostname: "dms.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "dms.us-gov-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-gov-east-1-fips",
				}: endpoint{
					Hostname: "dms.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "dms.us-gov-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-gov-west-1-fips",
				}: endpoint{
					Hostname: "dms.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
			},
		},
		"docdb": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{
					Hostname: "rds.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
			},
		},
		"drs": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "fips-us-gov-east-1",
				}: endpoint{
					Hostname: "drs-fips.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-gov-west-1",
				}: endpoint{
					Hostname: "drs-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "drs-fips.us-gov-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "drs-fips.us-gov-west-1.amazonaws.com",
				},
			},
		},
		"ds": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "fips-us-gov-east-1",
				}: endpoint{
					Hostname: "ds-fips.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-gov-west-1",
				}: endpoint{
					Hostname: "ds-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "ds-fips.us-gov-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "ds-fips.us-gov-west-1.amazonaws.com",
				},
			},
		},
		"dynamodb": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{},
				defaultKey{
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "dynamodb.{region}.{dnsSuffix}",
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "dynamodb.us-gov-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-gov-east-1-fips",
				}: endpoint{
					Hostname: "dynamodb.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "dynamodb.us-gov-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-gov-west-1-fips",
				}: endpoint{
					Hostname: "dynamodb.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
			},
		},
		"ebs": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
			},
		},
		"ec2": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{},
				defaultKey{
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "ec2.{region}.{dnsSuffix}",
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{
					Hostname: "ec2.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
				},
				endpointKey{
					Region:  "us-gov-east-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "ec2.us-gov-east-1.api.aws",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{
					Hostname: "ec2.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "ec2.us-gov-west-1.api.aws",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
			},
		},
		"ecs": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "fips-us-gov-east-1",
				}: endpoint{
					Hostname: "ecs-fips.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-gov-west-1",
				}: endpoint{
					Hostname: "ecs-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "ecs-fips.us-gov-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "ecs-fips.us-gov-west-1.amazonaws.com",
				},
			},
		},
		"eks": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					Protocols: []string{"http", "https"},
				},
				defaultKey{
					Variant: fipsVariant,
				}: endpoint{
					Hostname:  "eks.{region}.{dnsSuffix}",
					Protocols: []string{"http", "https"},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "fips-us-gov-east-1",
				}: endpoint{
					Hostname: "eks.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-gov-west-1",
				}: endpoint{
					Hostname: "eks.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "eks.us-gov-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "eks.us-gov-west-1.amazonaws.com",
				},
			},
		},
		"eks-auth": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					DNSSuffix: "api.aws",
				},
				defaultKey{
					Variant: fipsVariant,
				}: endpoint{
					Hostname:  "{service}-fips.{region}.{dnsSuffix}",
					DNSSuffix: "api.aws",
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{
					Hostname: "eks-auth.us-gov-east-1.api.aws",
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{
					Hostname: "eks-auth.us-gov-west-1.api.aws",
				},
			},
		},
		"elasticache": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{},
				defaultKey{
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "elasticache.{region}.{dnsSuffix}",
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "fips",
				}: endpoint{
					Hostname: "elasticache.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "elasticache.us-gov-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-gov-west-1-fips",
				}: endpoint{
					Hostname: "elasticache.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
			},
		},
		"elasticbeanstalk": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{
					Hostname: "elasticbeanstalk.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
				},
				endpointKey{
					Region:  "us-gov-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "elasticbeanstalk.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
				},
				endpointKey{
					Region: "us-gov-east-1-fips",
				}: endpoint{
					Hostname: "elasticbeanstalk.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{
					Hostname: "elasticbeanstalk.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "elasticbeanstalk.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
				endpointKey{
					Region: "us-gov-west-1-fips",
				}: endpoint{
					Hostname: "elasticbeanstalk.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
			},
		},
		"elasticfilesystem": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "fips-us-gov-east-1",
				}: endpoint{
					Hostname: "elasticfilesystem-fips.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-gov-west-1",
				}: endpoint{
					Hostname: "elasticfilesystem-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "elasticfilesystem-fips.us-gov-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "elasticfilesystem-fips.us-gov-west-1.amazonaws.com",
				},
			},
		},
		"elasticloadbalancing": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{},
				defaultKey{
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "elasticloadbalancing.{region}.{dnsSuffix}",
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "fips-us-gov-east-1",
				}: endpoint{
					Hostname: "elasticloadbalancing.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-gov-west-1",
				}: endpoint{
					Hostname: "elasticloadbalancing.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "elasticloadbalancing.us-gov-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{
					Protocols: []string{"http", "https"},
				},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname:  "elasticloadbalancing.us-gov-west-1.amazonaws.com",
					Protocols: []string{"http", "https"},
				},
			},
		},
		"elasticmapreduce": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{},
				defaultKey{
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "elasticmapreduce.{region}.{dnsSuffix}",
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "fips-us-gov-east-1",
				}: endpoint{
					Hostname: "elasticmapreduce.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-gov-west-1",
				}: endpoint{
					Hostname: "elasticmapreduce.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-east-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "elasticmapreduce.us-gov-east-1.api.aws",
				},
				endpointKey{
					Region:  "us-gov-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "elasticmapreduce.us-gov-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{
					Protocols: []string{"https"},
				},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname:  "elasticmapreduce.us-gov-west-1.api.aws",
					Protocols: []string{"https"},
				},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname:  "elasticmapreduce.us-gov-west-1.amazonaws.com",
					Protocols: []string{"https"},
				},
			},
		},
		"email": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "fips-us-gov-west-1",
				}: endpoint{
					Hostname: "email-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "email-fips.us-gov-west-1.amazonaws.com",
				},
			},
		},
		"emr-containers": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
			},
		},
		"es": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "fips",
				}: endpoint{
					Hostname: "es-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-east-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "aos.us-gov-east-1.api.aws",
				},
				endpointKey{
					Region:  "us-gov-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "es-fips.us-gov-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-gov-east-1-fips",
				}: endpoint{
					Hostname: "es-fips.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "aos.us-gov-west-1.api.aws",
				},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "es-fips.us-gov-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-gov-west-1-fips",
				}: endpoint{
					Hostname: "es-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
			},
		},
		"events": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "fips-us-gov-east-1",
				}: endpoint{
					Hostname: "events.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-gov-west-1",
				}: endpoint{
					Hostname: "events.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "events.us-gov-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "events.us-gov-west-1.amazonaws.com",
				},
			},
		},
		"firehose": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "fips-us-gov-east-1",
				}: endpoint{
					Hostname: "firehose-fips.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-gov-west-1",
				}: endpoint{
					Hostname: "firehose-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "firehose-fips.us-gov-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "firehose-fips.us-gov-west-1.amazonaws.com",
				},
			},
		},
		"fms": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					Protocols: []string{"https"},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "fips-us-gov-east-1",
				}: endpoint{
					Hostname: "fms-fips.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-gov-west-1",
				}: endpoint{
					Hostname: "fms-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "fms-fips.us-gov-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "fms-fips.us-gov-west-1.amazonaws.com",
				},
			},
		},
		"fsx": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "fips-prod-us-gov-east-1",
				}: endpoint{
					Hostname: "fsx-fips.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-prod-us-gov-west-1",
				}: endpoint{
					Hostname: "fsx-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-gov-east-1",
				}: endpoint{
					Hostname: "fsx-fips.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-gov-west-1",
				}: endpoint{
					Hostname: "fsx-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "prod-us-gov-east-1",
				}: endpoint{
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region:  "prod-us-gov-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "fsx-fips.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "prod-us-gov-west-1",
				}: endpoint{
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region:  "prod-us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "fsx-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "fsx-fips.us-gov-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "fsx-fips.us-gov-west-1.amazonaws.com",
				},
			},
		},
		"geo": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "fips-us-gov-west-1",
				}: endpoint{
					Hostname: "geo-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "geo-fips.us-gov-west-1.amazonaws.com",
				},
			},
		},
		"glacier": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "fips-us-gov-east-1",
				}: endpoint{
					Hostname: "glacier.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-gov-west-1",
				}: endpoint{
					Hostname: "glacier.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "glacier.us-gov-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{
					Protocols: []string{"http", "https"},
				},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname:  "glacier.us-gov-west-1.amazonaws.com",
					Protocols: []string{"http", "https"},
				},
			},
		},
		"glue": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "fips-us-gov-east-1",
				}: endpoint{
					Hostname: "glue-fips.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-gov-west-1",
				}: endpoint{
					Hostname: "glue-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-east-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "glue.us-gov-east-1.api.aws",
				},
				endpointKey{
					Region:  "us-gov-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "glue-fips.us-gov-east-1.amazonaws.com",
				},
				endpointKey{
					Region:  "us-gov-east-1",
					Variant: fipsVariant | dualStackVariant,
				}: endpoint{
					Hostname: "glue-fips.us-gov-east-1.api.aws",
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "glue.us-gov-west-1.api.aws",
				},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "glue-fips.us-gov-west-1.amazonaws.com",
				},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant | dualStackVariant,
				}: endpoint{
					Hostname: "glue-fips.us-gov-west-1.api.aws",
				},
			},
		},
		"greengrass": service{
			IsRegionalized: boxedTrue,
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					Protocols: []string{"https"},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "dataplane-us-gov-east-1",
				}: endpoint{
					Hostname: "greengrass-ats.iot.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
				},
				endpointKey{
					Region: "dataplane-us-gov-west-1",
				}: endpoint{
					Hostname: "greengrass-ats.iot.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
				endpointKey{
					Region: "fips-us-gov-east-1",
				}: endpoint{
					Hostname: "greengrass.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-gov-west-1",
				}: endpoint{
					Hostname: "greengrass.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "greengrass.us-gov-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "greengrass.us-gov-west-1.amazonaws.com",
				},
			},
		},
		"guardduty": service{
			IsRegionalized: boxedTrue,
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					Protocols: []string{"https"},
				},
				defaultKey{
					Variant: fipsVariant,
				}: endpoint{
					Hostname:  "guardduty.{region}.{dnsSuffix}",
					Protocols: []string{"https"},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "guardduty.us-gov-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-gov-east-1-fips",
				}: endpoint{
					Hostname: "guardduty.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "guardduty.us-gov-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-gov-west-1-fips",
				}: endpoint{
					Hostname: "guardduty.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
			},
		},
		"health": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					SSLCommonName: "health.us-gov-west-1.amazonaws.com",
					Protocols:     []string{"https"},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "aws-us-gov-global",
				}: endpoint{
					Hostname: "global.health.us-gov.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
				endpointKey{
					Region: "fips-us-gov-west-1",
				}: endpoint{
					Hostname: "health-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "health-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
			},
		},
		"iam": service{
			PartitionEndpoint: "aws-us-gov-global",
			IsRegionalized:    boxedFalse,
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "aws-us-gov-global",
				}: endpoint{
					Hostname: "iam.us-gov.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
				endpointKey{
					Region:  "aws-us-gov-global",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "iam.us-gov.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
				endpointKey{
					Region: "aws-us-gov-global-fips",
				}: endpoint{
					Hostname: "iam.us-gov.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "iam-govcloud",
				}: endpoint{
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region:  "iam-govcloud",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "iam.us-gov.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "iam-govcloud-fips",
				}: endpoint{
					Hostname: "iam.us-gov.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
			},
		},
		"identitystore": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{},
				defaultKey{
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "identitystore.{region}.{dnsSuffix}",
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "fips-us-gov-east-1",
				}: endpoint{
					Hostname: "identitystore.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-gov-west-1",
				}: endpoint{
					Hostname: "identitystore.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "identitystore.us-gov-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "identitystore.us-gov-west-1.amazonaws.com",
				},
			},
		},
		"ingest.timestream": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "ingest.timestream.us-gov-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-gov-west-1-fips",
				}: endpoint{
					Hostname: "ingest.timestream.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
			},
		},
		"inspector": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "fips-us-gov-east-1",
				}: endpoint{
					Hostname: "inspector-fips.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-gov-west-1",
				}: endpoint{
					Hostname: "inspector-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "inspector-fips.us-gov-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "inspector-fips.us-gov-west-1.amazonaws.com",
				},
			},
		},
		"inspector2": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "fips-us-gov-east-1",
				}: endpoint{
					Hostname: "inspector2-fips.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-gov-west-1",
				}: endpoint{
					Hostname: "inspector2-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "inspector2-fips.us-gov-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "inspector2-fips.us-gov-west-1.amazonaws.com",
				},
			},
		},
		"internetmonitor": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					DNSSuffix: "api.aws",
				},
				defaultKey{
					Variant: fipsVariant,
				}: endpoint{
					Hostname:  "{service}-fips.{region}.{dnsSuffix}",
					DNSSuffix: "api.aws",
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{
					Hostname: "internetmonitor.us-gov-east-1.api.aws",
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{
					Hostname: "internetmonitor.us-gov-west-1.api.aws",
				},
			},
		},
		"iot": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "fips-us-gov-east-1",
				}: endpoint{
					Hostname: "iot-fips.us-gov-east-1.amazonaws.com",

					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-gov-west-1",
				}: endpoint{
					Hostname: "iot-fips.us-gov-west-1.amazonaws.com",

					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "iot-fips.us-gov-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "iot-fips.us-gov-west-1.amazonaws.com",
				},
			},
		},
		"iotevents": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "fips-us-gov-west-1",
				}: endpoint{
					Hostname: "iotevents-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "iotevents-fips.us-gov-west-1.amazonaws.com",
				},
			},
		},
		"ioteventsdata": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "fips-us-gov-west-1",
				}: endpoint{
					Hostname: "data.iotevents-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{
					Hostname: "data.iotevents.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "data.iotevents-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
			},
		},
		"iotsecuredtunneling": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{},
				defaultKey{
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "api.tunneling.iot-fips.{region}.{dnsSuffix}",
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "fips-us-gov-east-1",
				}: endpoint{
					Hostname: "api.tunneling.iot-fips.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-gov-west-1",
				}: endpoint{
					Hostname: "api.tunneling.iot-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "api.tunneling.iot-fips.us-gov-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "api.tunneling.iot-fips.us-gov-west-1.amazonaws.com",
				},
			},
		},
		"iotsitewise": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "fips-us-gov-west-1",
				}: endpoint{
					Hostname: "iotsitewise-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "iotsitewise-fips.us-gov-west-1.amazonaws.com",
				},
			},
		},
		"iottwinmaker": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "api-us-gov-west-1",
				}: endpoint{
					Hostname: "api.iottwinmaker.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
				endpointKey{
					Region: "data-us-gov-west-1",
				}: endpoint{
					Hostname: "data.iottwinmaker.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
				endpointKey{
					Region: "fips-api-us-gov-west-1",
				}: endpoint{
					Hostname: "api.iottwinmaker-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
				endpointKey{
					Region: "fips-data-us-gov-west-1",
				}: endpoint{
					Hostname: "data.iottwinmaker-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
				endpointKey{
					Region: "fips-us-gov-west-1",
				}: endpoint{
					Hostname: "iottwinmaker-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "iottwinmaker-fips.us-gov-west-1.amazonaws.com",
				},
			},
		},
		"kafka": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{
					Hostname: "kafka.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
				},
				endpointKey{
					Region:  "us-gov-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "kafka.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
				},
				endpointKey{
					Region: "us-gov-east-1-fips",
				}: endpoint{
					Hostname: "kafka.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{
					Hostname: "kafka.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "kafka.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
				endpointKey{
					Region: "us-gov-west-1-fips",
				}: endpoint{
					Hostname: "kafka.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
			},
		},
		"kendra": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "fips-us-gov-west-1",
				}: endpoint{
					Hostname: "kendra-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "kendra-fips.us-gov-west-1.amazonaws.com",
				},
			},
		},
		"kendra-ranking": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					DNSSuffix: "api.aws",
				},
				defaultKey{
					Variant: fipsVariant,
				}: endpoint{
					Hostname:  "{service}-fips.{region}.{dnsSuffix}",
					DNSSuffix: "api.aws",
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{
					Hostname: "kendra-ranking.us-gov-east-1.api.aws",
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{
					Hostname: "kendra-ranking.us-gov-west-1.api.aws",
				},
			},
		},
		"kinesis": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "fips-us-gov-east-1",
				}: endpoint{
					Hostname: "kinesis.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-gov-west-1",
				}: endpoint{
					Hostname: "kinesis.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{
					Hostname: "kinesis.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
				},
				endpointKey{
					Region:  "us-gov-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "kinesis.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{
					Hostname: "kinesis.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "kinesis.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
			},
		},
		"kinesisanalytics": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
			},
		},
		"kms": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ProdFips",
				}: endpoint{
					Hostname: "kms-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "kms-fips.us-gov-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-gov-east-1-fips",
				}: endpoint{
					Hostname: "kms-fips.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "kms-fips.us-gov-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-gov-west-1-fips",
				}: endpoint{
					Hostname: "kms-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
			},
		},
		"lakeformation": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "fips-us-gov-east-1",
				}: endpoint{
					Hostname: "lakeformation-fips.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-gov-west-1",
				}: endpoint{
					Hostname: "lakeformation-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-east-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "lakeformation.us-gov-east-1.api.aws",
				},
				endpointKey{
					Region:  "us-gov-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "lakeformation-fips.us-gov-east-1.amazonaws.com",
				},
				endpointKey{
					Region:  "us-gov-east-1",
					Variant: fipsVariant | dualStackVariant,
				}: endpoint{
					Hostname: "lakeformation-fips.us-gov-east-1.api.aws",
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "lakeformation.us-gov-west-1.api.aws",
				},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "lakeformation-fips.us-gov-west-1.amazonaws.com",
				},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant | dualStackVariant,
				}: endpoint{
					Hostname: "lakeformation-fips.us-gov-west-1.api.aws",
				},
			},
		},
		"lambda": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "fips-us-gov-east-1",
				}: endpoint{
					Hostname: "lambda-fips.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-gov-west-1",
				}: endpoint{
					Hostname: "lambda-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-east-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "lambda.us-gov-east-1.api.aws",
				},
				endpointKey{
					Region:  "us-gov-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "lambda-fips.us-gov-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "lambda.us-gov-west-1.api.aws",
				},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "lambda-fips.us-gov-west-1.amazonaws.com",
				},
			},
		},
		"license-manager": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "fips-us-gov-east-1",
				}: endpoint{
					Hostname: "license-manager-fips.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-gov-west-1",
				}: endpoint{
					Hostname: "license-manager-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "license-manager-fips.us-gov-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "license-manager-fips.us-gov-west-1.amazonaws.com",
				},
			},
		},
		"license-manager-linux-subscriptions": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
			},
		},
		"logs": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "fips-us-gov-east-1",
				}: endpoint{
					Hostname: "logs.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-gov-west-1",
				}: endpoint{
					Hostname: "logs.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "logs.us-gov-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "logs.us-gov-west-1.amazonaws.com",
				},
			},
		},
		"m2": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "fips-us-gov-east-1",
				}: endpoint{

					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-gov-west-1",
				}: endpoint{

					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-east-1",
					Variant: fipsVariant,
				}: endpoint{},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{},
			},
		},
		"managedblockchain": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
			},
		},
		"mediaconvert": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "fips-us-gov-west-1",
				}: endpoint{
					Hostname: "mediaconvert.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "mediaconvert.us-gov-west-1.amazonaws.com",
				},
			},
		},
		"meetings-chime": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "meetings-chime-fips.us-gov-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-gov-east-1-fips",
				}: endpoint{
					Hostname: "meetings-chime-fips.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "meetings-chime-fips.us-gov-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-gov-west-1-fips",
				}: endpoint{
					Hostname: "meetings-chime-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
			},
		},
		"metering.marketplace": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					CredentialScope: credentialScope{
						Service: "aws-marketplace",
					},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
			},
		},
		"metrics.sagemaker": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
			},
		},
		"mgn": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "fips-us-gov-east-1",
				}: endpoint{
					Hostname: "mgn-fips.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-gov-west-1",
				}: endpoint{
					Hostname: "mgn-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "mgn-fips.us-gov-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "mgn-fips.us-gov-west-1.amazonaws.com",
				},
			},
		},
		"models.lex": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					CredentialScope: credentialScope{
						Service: "lex",
					},
				},
				defaultKey{
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "models-fips.lex.{region}.{dnsSuffix}",
					CredentialScope: credentialScope{
						Service: "lex",
					},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "models-fips.lex.us-gov-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-gov-west-1-fips",
				}: endpoint{
					Hostname: "models-fips.lex.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
			},
		},
		"monitoring": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{},
				defaultKey{
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "monitoring.{region}.{dnsSuffix}",
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "fips-us-gov-east-1",
				}: endpoint{
					Hostname: "monitoring.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-gov-west-1",
				}: endpoint{
					Hostname: "monitoring.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "monitoring.us-gov-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "monitoring.us-gov-west-1.amazonaws.com",
				},
			},
		},
		"mq": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "fips-us-gov-east-1",
				}: endpoint{
					Hostname: "mq-fips.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-gov-west-1",
				}: endpoint{
					Hostname: "mq-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "mq-fips.us-gov-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "mq-fips.us-gov-west-1.amazonaws.com",
				},
			},
		},
		"neptune": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{
					Hostname: "rds.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{
					Hostname: "rds.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
			},
		},
		"network-firewall": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "fips-us-gov-east-1",
				}: endpoint{
					Hostname: "network-firewall-fips.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-gov-west-1",
				}: endpoint{
					Hostname: "network-firewall-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "network-firewall-fips.us-gov-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "network-firewall-fips.us-gov-west-1.amazonaws.com",
				},
			},
		},
		"networkmanager": service{
			PartitionEndpoint: "aws-us-gov-global",
			IsRegionalized:    boxedFalse,
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "aws-us-gov-global",
				}: endpoint{
					Hostname: "networkmanager.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
				endpointKey{
					Region:  "aws-us-gov-global",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "networkmanager.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
				endpointKey{
					Region: "fips-aws-us-gov-global",
				}: endpoint{
					Hostname: "networkmanager.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
			},
		},
		"oidc": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{
					Hostname: "oidc.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{
					Hostname: "oidc.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
			},
		},
		"organizations": service{
			PartitionEndpoint: "aws-us-gov-global",
			IsRegionalized:    boxedFalse,
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "aws-us-gov-global",
				}: endpoint{
					Hostname: "organizations.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
				endpointKey{
					Region:  "aws-us-gov-global",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "organizations.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
				endpointKey{
					Region: "fips-aws-us-gov-global",
				}: endpoint{
					Hostname: "organizations.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
			},
		},
		"outposts": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "fips-us-gov-east-1",
				}: endpoint{
					Hostname: "outposts.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-gov-west-1",
				}: endpoint{
					Hostname: "outposts.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "outposts.us-gov-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "outposts.us-gov-west-1.amazonaws.com",
				},
			},
		},
		"participant.connect": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "fips-us-gov-west-1",
				}: endpoint{
					Hostname: "participant.connect.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "participant.connect.us-gov-west-1.amazonaws.com",
				},
			},
		},
		"pi": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
			},
		},
		"pinpoint": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					CredentialScope: credentialScope{
						Service: "mobiletargeting",
					},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "fips-us-gov-west-1",
				}: endpoint{
					Hostname: "pinpoint-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{
					Hostname: "pinpoint.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "pinpoint-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
			},
		},
		"polly": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "fips-us-gov-west-1",
				}: endpoint{
					Hostname: "polly-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "polly-fips.us-gov-west-1.amazonaws.com",
				},
			},
		},
		"portal.sso": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{
					Hostname: "portal.sso.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{
					Hostname: "portal.sso.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
			},
		},
		"qbusiness": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					DNSSuffix: "api.aws",
				},
				defaultKey{
					Variant: fipsVariant,
				}: endpoint{
					Hostname:  "{service}-fips.{region}.{dnsSuffix}",
					DNSSuffix: "api.aws",
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{
					Hostname: "qbusiness.us-gov-east-1.api.aws",
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{
					Hostname: "qbusiness.us-gov-west-1.api.aws",
				},
			},
		},
		"quicksight": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "api",
				}: endpoint{},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
			},
		},
		"ram": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{
					Hostname: "ram.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
				},
				endpointKey{
					Region:  "us-gov-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "ram.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
				},
				endpointKey{
					Region: "us-gov-east-1-fips",
				}: endpoint{
					Hostname: "ram.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{
					Hostname: "ram.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "ram.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
				endpointKey{
					Region: "us-gov-west-1-fips",
				}: endpoint{
					Hostname: "ram.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
			},
		},
		"rbin": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "fips-us-gov-east-1",
				}: endpoint{
					Hostname: "rbin-fips.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-gov-west-1",
				}: endpoint{
					Hostname: "rbin-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "rbin-fips.us-gov-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "rbin-fips.us-gov-west-1.amazonaws.com",
				},
			},
		},
		"rds": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{},
				defaultKey{
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "rds.{region}.{dnsSuffix}",
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "rds.us-gov-east-1",
				}: endpoint{
					Hostname: "rds.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "rds.us-gov-west-1",
				}: endpoint{
					Hostname: "rds.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "rds.us-gov-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-gov-east-1-fips",
				}: endpoint{
					Hostname: "rds.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "rds.us-gov-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-gov-west-1-fips",
				}: endpoint{
					Hostname: "rds.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
			},
		},
		"redshift": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{
					Hostname: "redshift.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{
					Hostname: "redshift.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
			},
		},
		"rekognition": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "rekognition-fips.us-gov-west-1",
				}: endpoint{
					Hostname: "rekognition-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "rekognition.us-gov-west-1",
				}: endpoint{
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region:  "rekognition.us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "rekognition-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "rekognition-fips.us-gov-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-gov-west-1-fips",
				}: endpoint{
					Hostname: "rekognition-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
			},
		},
		"resiliencehub": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "fips-us-gov-east-1",
				}: endpoint{
					Hostname: "resiliencehub-fips.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-gov-west-1",
				}: endpoint{
					Hostname: "resiliencehub-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "resiliencehub-fips.us-gov-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "resiliencehub-fips.us-gov-west-1.amazonaws.com",
				},
			},
		},
		"resource-explorer-2": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					DNSSuffix: "api.aws",
				},
				defaultKey{
					Variant: fipsVariant,
				}: endpoint{
					Hostname:  "{service}-fips.{region}.{dnsSuffix}",
					DNSSuffix: "api.aws",
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{
					Hostname: "resource-explorer-2.us-gov-east-1.api.aws",
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{
					Hostname: "resource-explorer-2.us-gov-west-1.api.aws",
				},
			},
		},
		"resource-groups": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{},
				defaultKey{
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "resource-groups.{region}.{dnsSuffix}",
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "fips-us-gov-east-1",
				}: endpoint{
					Hostname: "resource-groups.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-gov-west-1",
				}: endpoint{
					Hostname: "resource-groups.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "resource-groups.us-gov-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "resource-groups.us-gov-west-1.amazonaws.com",
				},
			},
		},
		"robomaker": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
			},
		},
		"rolesanywhere": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "fips-us-gov-east-1",
				}: endpoint{
					Hostname: "rolesanywhere-fips.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-gov-west-1",
				}: endpoint{
					Hostname: "rolesanywhere-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "rolesanywhere-fips.us-gov-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "rolesanywhere-fips.us-gov-west-1.amazonaws.com",
				},
			},
		},
		"route53": service{
			PartitionEndpoint: "aws-us-gov-global",
			IsRegionalized:    boxedFalse,
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "aws-us-gov-global",
				}: endpoint{
					Hostname: "route53.us-gov.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
				endpointKey{
					Region:  "aws-us-gov-global",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "route53.us-gov.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
				endpointKey{
					Region: "fips-aws-us-gov-global",
				}: endpoint{
					Hostname: "route53.us-gov.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
			},
		},
		"route53resolver": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "route53resolver.us-gov-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-gov-east-1-fips",
				}: endpoint{
					Hostname: "route53resolver.us-gov-east-1.amazonaws.com",

					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "route53resolver.us-gov-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-gov-west-1-fips",
				}: endpoint{
					Hostname: "route53resolver.us-gov-west-1.amazonaws.com",

					Deprecated: boxedTrue,
				},
			},
		},
		"runtime.lex": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					CredentialScope: credentialScope{
						Service: "lex",
					},
				},
				defaultKey{
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "runtime-fips.lex.{region}.{dnsSuffix}",
					CredentialScope: credentialScope{
						Service: "lex",
					},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "runtime-fips.lex.us-gov-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-gov-west-1-fips",
				}: endpoint{
					Hostname: "runtime-fips.lex.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
			},
		},
		"runtime.sagemaker": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{},
				defaultKey{
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "runtime.sagemaker.{region}.{dnsSuffix}",
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "runtime.sagemaker.us-gov-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-gov-west-1-fips",
				}: endpoint{
					Hostname: "runtime.sagemaker.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
			},
		},
		"s3": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					SignatureVersions: []string{"s3", "s3v4"},
				},
				defaultKey{
					Variant: dualStackVariant,
				}: endpoint{
					Hostname:          "{service}.dualstack.{region}.{dnsSuffix}",
					DNSSuffix:         "amazonaws.com",
					SignatureVersions: []string{"s3", "s3v4"},
				},
				defaultKey{
					Variant: fipsVariant | dualStackVariant,
				}: endpoint{
					Hostname:          "{service}-fips.dualstack.{region}.{dnsSuffix}",
					DNSSuffix:         "amazonaws.com",
					SignatureVersions: []string{"s3", "s3v4"},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "fips-us-gov-east-1",
				}: endpoint{
					Hostname: "s3-fips.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-gov-west-1",
				}: endpoint{
					Hostname: "s3-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{
					Hostname:  "s3.us-gov-east-1.amazonaws.com",
					Protocols: []string{"http", "https"},
				},
				endpointKey{
					Region:  "us-gov-east-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname:  "s3.dualstack.us-gov-east-1.amazonaws.com",
					Protocols: []string{"http", "https"},
				},
				endpointKey{
					Region:  "us-gov-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname:  "s3-fips.us-gov-east-1.amazonaws.com",
					Protocols: []string{"http", "https"},
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{
					Hostname:  "s3.us-gov-west-1.amazonaws.com",
					Protocols: []string{"http", "https"},
				},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname:  "s3.dualstack.us-gov-west-1.amazonaws.com",
					Protocols: []string{"http", "https"},
				},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname:  "s3-fips.us-gov-west-1.amazonaws.com",
					Protocols: []string{"http", "https"},
				},
			},
		},
		"s3-control": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					Protocols:         []string{"https"},
					SignatureVersions: []string{"s3v4"},
				},
				defaultKey{
					Variant: dualStackVariant,
				}: endpoint{
					Hostname:          "{service}.dualstack.{region}.{dnsSuffix}",
					DNSSuffix:         "amazonaws.com",
					Protocols:         []string{"https"},
					SignatureVersions: []string{"s3v4"},
				},
				defaultKey{
					Variant: fipsVariant | dualStackVariant,
				}: endpoint{
					Hostname:          "{service}-fips.dualstack.{region}.{dnsSuffix}",
					DNSSuffix:         "amazonaws.com",
					Protocols:         []string{"https"},
					SignatureVersions: []string{"s3v4"},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{
					Hostname:          "s3-control.us-gov-east-1.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
				},
				endpointKey{
					Region:  "us-gov-east-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname:          "s3-control.dualstack.us-gov-east-1.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
				},
				endpointKey{
					Region:  "us-gov-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname:          "s3-control-fips.us-gov-east-1.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
				},
				endpointKey{
					Region:  "us-gov-east-1",
					Variant: fipsVariant | dualStackVariant,
				}: endpoint{
					Hostname:          "s3-control-fips.dualstack.us-gov-east-1.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
				},
				endpointKey{
					Region: "us-gov-east-1-fips",
				}: endpoint{
					Hostname:          "s3-control-fips.us-gov-east-1.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{
					Hostname:          "s3-control.us-gov-west-1.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname:          "s3-control.dualstack.us-gov-west-1.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname:          "s3-control-fips.us-gov-west-1.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant | dualStackVariant,
				}: endpoint{
					Hostname:          "s3-control-fips.dualstack.us-gov-west-1.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
				endpointKey{
					Region: "us-gov-west-1-fips",
				}: endpoint{
					Hostname:          "s3-control-fips.us-gov-west-1.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
			},
		},
		"s3-outposts": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "fips-us-gov-east-1",
				}: endpoint{

					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-gov-west-1",
				}: endpoint{

					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-east-1",
					Variant: dualStackVariant,
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-east-1",
					Variant: fipsVariant,
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-east-1",
					Variant: fipsVariant | dualStackVariant,
				}: endpoint{},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: dualStackVariant,
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant | dualStackVariant,
				}: endpoint{},
			},
		},
		"secretsmanager": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-east-1",
					Variant: dualStackVariant,
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-east-1",
					Variant: fipsVariant,
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-east-1",
					Variant: fipsVariant | dualStackVariant,
				}: endpoint{},
				endpointKey{
					Region: "us-gov-east-1-fips",
				}: endpoint{

					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: dualStackVariant,
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant | dualStackVariant,
				}: endpoint{},
				endpointKey{
					Region: "us-gov-west-1-fips",
				}: endpoint{

					Deprecated: boxedTrue,
				},
			},
		},
		"securityhub": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "fips-us-gov-east-1",
				}: endpoint{
					Hostname: "securityhub-fips.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-gov-west-1",
				}: endpoint{
					Hostname: "securityhub-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "securityhub-fips.us-gov-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "securityhub-fips.us-gov-west-1.amazonaws.com",
				},
			},
		},
		"serverlessrepo": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					Protocols: []string{"https"},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{
					Protocols: []string{"https"},
				},
				endpointKey{
					Region:  "us-gov-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname:  "serverlessrepo.us-gov-east-1.amazonaws.com",
					Protocols: []string{"https"},
				},
				endpointKey{
					Region: "us-gov-east-1-fips",
				}: endpoint{
					Hostname: "serverlessrepo.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{
					Protocols: []string{"https"},
				},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname:  "serverlessrepo.us-gov-west-1.amazonaws.com",
					Protocols: []string{"https"},
				},
				endpointKey{
					Region: "us-gov-west-1-fips",
				}: endpoint{
					Hostname: "serverlessrepo.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
			},
		},
		"servicecatalog": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "servicecatalog-fips.us-gov-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-gov-east-1-fips",
				}: endpoint{
					Hostname: "servicecatalog-fips.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "servicecatalog-fips.us-gov-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-gov-west-1-fips",
				}: endpoint{
					Hostname: "servicecatalog-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
			},
		},
		"servicecatalog-appregistry": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{},
				defaultKey{
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "servicecatalog-appregistry.{region}.{dnsSuffix}",
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
			},
		},
		"servicediscovery": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "servicediscovery",
				}: endpoint{
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region:  "servicediscovery",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "servicediscovery-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "servicediscovery-fips",
				}: endpoint{
					Hostname: "servicediscovery-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-east-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "servicediscovery.us-gov-east-1.api.aws",
				},
				endpointKey{
					Region:  "us-gov-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "servicediscovery-fips.us-gov-east-1.amazonaws.com",
				},
				endpointKey{
					Region:  "us-gov-east-1",
					Variant: fipsVariant | dualStackVariant,
				}: endpoint{
					Hostname: "servicediscovery-fips.us-gov-east-1.api.aws",
				},
				endpointKey{
					Region: "us-gov-east-1-fips",
				}: endpoint{
					Hostname: "servicediscovery-fips.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "servicediscovery.us-gov-west-1.api.aws",
				},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "servicediscovery-fips.us-gov-west-1.amazonaws.com",
				},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant | dualStackVariant,
				}: endpoint{
					Hostname: "servicediscovery-fips.us-gov-west-1.api.aws",
				},
				endpointKey{
					Region: "us-gov-west-1-fips",
				}: endpoint{
					Hostname: "servicediscovery-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
			},
		},
		"servicequotas": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					Protocols: []string{"https"},
				},
				defaultKey{
					Variant: fipsVariant,
				}: endpoint{
					Hostname:  "servicequotas.{region}.{dnsSuffix}",
					Protocols: []string{"https"},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "fips-us-gov-east-1",
				}: endpoint{
					Hostname: "servicequotas.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-gov-west-1",
				}: endpoint{
					Hostname: "servicequotas.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "servicequotas.us-gov-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "servicequotas.us-gov-west-1.amazonaws.com",
				},
			},
		},
		"simspaceweaver": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "fips-us-gov-east-1",
				}: endpoint{
					Hostname: "simspaceweaver.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-gov-west-1",
				}: endpoint{
					Hostname: "simspaceweaver.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "simspaceweaver.us-gov-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "simspaceweaver.us-gov-west-1.amazonaws.com",
				},
			},
		},
		"sms": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "fips-us-gov-west-1",
				}: endpoint{
					Hostname: "sms-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "sms-fips.us-gov-west-1.amazonaws.com",
				},
			},
		},
		"sms-voice": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "fips-us-gov-west-1",
				}: endpoint{
					Hostname: "sms-voice-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "sms-voice-fips.us-gov-west-1.amazonaws.com",
				},
			},
		},
		"snowball": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "fips-us-gov-east-1",
				}: endpoint{
					Hostname: "snowball-fips.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-gov-west-1",
				}: endpoint{
					Hostname: "snowball-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "snowball-fips.us-gov-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "snowball-fips.us-gov-west-1.amazonaws.com",
				},
			},
		},
		"sns": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "fips-us-gov-east-1",
				}: endpoint{
					Hostname: "sns.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-gov-west-1",
				}: endpoint{
					Hostname: "sns.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "sns.us-gov-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{
					Protocols: []string{"https"},
				},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname:  "sns.us-gov-west-1.amazonaws.com",
					Protocols: []string{"https"},
				},
			},
		},
		"sqs": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{},
				defaultKey{
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "sqs.{region}.{dnsSuffix}",
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{
					Hostname: "sqs.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{
					Hostname:      "sqs.us