
<!--- This file is automatically generated by make gen-cli-docs; changes should be made in the go CLI command code (under cmd/kops) -->

## kops promote keypair

Promote a keypair to be the primary, used for signing.

### Synopsis

Promote a keypair to be the primary, used for signing.

 If no keypair ID is provided, the most recently added keypair that has a private key will be promoted if it was added after the current primary.

 If the keyset is specified as "all", each rotatable keyset will have its most recently added keypair (with a private key and added after the current primary) promoted.

```
kops promote keypair {KEYSET [ID] | all} [flags]
```

### Examples

```
  # Promote the newest kubernetes-ca keypair to be the primary.
  kops promote keypair kubernetes-ca \
  --name k8s-cluster.example.com --state s3://my-state-store
  
  # Promote a specific service-account keypair to be the primary.
  kops promote keypair service-account 5938372002934847 \
  --name k8s-cluster.example.com --state s3://my-state-store
  
  # Promote the newest keypair (having a private key) in each rotatable keyset.
  kops promote keypair all \
  --name k8s-cluster.example.com --state s3://my-state-store
```

### Options

```
  -h, --help   help for keypair
```

### Options inherited from parent commands

```
      --config string   yaml config file (default is $HOME/.kops.yaml)
      --name string     Name of cluster. Overrides KOPS_CLUSTER_NAME environment variable
      --state string    Location of state storage (kops 'config' file). Overrides KOPS_STATE_STORE environment variable
  -v, --v Level         number for the log level verbosity
```

### SEE ALSO

* [kops promote](kops_promote.md)	 - Promote a resource.

