/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1alpha2

import (
	"context"
	"time"

	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
	v1alpha2 "k8s.io/kops/pkg/apis/kops/v1alpha2"
	scheme "k8s.io/kops/pkg/client/clientset_generated/internalclientset/scheme"
)

// KeysetsGetter has a method to return a KeysetInterface.
// A group's client should implement this interface.
type KeysetsGetter interface {
	Keysets(namespace string) KeysetInterface
}

// KeysetInterface has methods to work with Keyset resources.
type KeysetInterface interface {
	Create(ctx context.Context, keyset *v1alpha2.Keyset, opts v1.CreateOptions) (*v1alpha2.Keyset, error)
	Update(ctx context.Context, keyset *v1alpha2.Keyset, opts v1.UpdateOptions) (*v1alpha2.Keyset, error)
	Delete(ctx context.Context, name string, opts v1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error
	Get(ctx context.Context, name string, opts v1.GetOptions) (*v1alpha2.Keyset, error)
	List(ctx context.Context, opts v1.ListOptions) (*v1alpha2.KeysetList, error)
	Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha2.Keyset, err error)
	KeysetExpansion
}

// keysets implements KeysetInterface
type keysets struct {
	client rest.Interface
	ns     string
}

// newKeysets returns a Keysets
func newKeysets(c *KopsV1alpha2Client, namespace string) *keysets {
	return &keysets{
		client: c.RESTClient(),
		ns:     namespace,
	}
}

// Get takes name of the keyset, and returns the corresponding keyset object, and an error if there is any.
func (c *keysets) Get(ctx context.Context, name string, options v1.GetOptions) (result *v1alpha2.Keyset, err error) {
	result = &v1alpha2.Keyset{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("keysets").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do(ctx).
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of Keysets that match those selectors.
func (c *keysets) List(ctx context.Context, opts v1.ListOptions) (result *v1alpha2.KeysetList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1alpha2.KeysetList{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("keysets").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do(ctx).
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested keysets.
func (c *keysets) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Namespace(c.ns).
		Resource("keysets").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch(ctx)
}

// Create takes the representation of a keyset and creates it.  Returns the server's representation of the keyset, and an error, if there is any.
func (c *keysets) Create(ctx context.Context, keyset *v1alpha2.Keyset, opts v1.CreateOptions) (result *v1alpha2.Keyset, err error) {
	result = &v1alpha2.Keyset{}
	err = c.client.Post().
		Namespace(c.ns).
		Resource("keysets").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(keyset).
		Do(ctx).
		Into(result)
	return
}

// Update takes the representation of a keyset and updates it. Returns the server's representation of the keyset, and an error, if there is any.
func (c *keysets) Update(ctx context.Context, keyset *v1alpha2.Keyset, opts v1.UpdateOptions) (result *v1alpha2.Keyset, err error) {
	result = &v1alpha2.Keyset{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("keysets").
		Name(keyset.Name).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(keyset).
		Do(ctx).
		Into(result)
	return
}

// Delete takes name of the keyset and deletes it. Returns an error if one occurs.
func (c *keysets) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	return c.client.Delete().
		Namespace(c.ns).
		Resource("keysets").
		Name(name).
		Body(&opts).
		Do(ctx).
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *keysets) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	var timeout time.Duration
	if listOpts.TimeoutSeconds != nil {
		timeout = time.Duration(*listOpts.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Namespace(c.ns).
		Resource("keysets").
		VersionedParams(&listOpts, scheme.ParameterCodec).
		Timeout(timeout).
		Body(&opts).
		Do(ctx).
		Error()
}

// Patch applies the patch and returns the patched keyset.
func (c *keysets) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha2.Keyset, err error) {
	result = &v1alpha2.Keyset{}
	err = c.client.Patch(pt).
		Namespace(c.ns).
		Resource("keysets").
		Name(name).
		SubResource(subresources...).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}
