
<!--- This file is automatically generated by make gen-cli-docs; changes should be made in the go CLI command code (under cmd/kops) -->

## kops create secret weavepassword

Create a Weave password.

### Synopsis

Create a new weave encryption secret and store it in the state store. Used by Weave networking to encrypt communication between nodes.

 If no password is provided, kOps will generate one at random.

 WARNING: cannot be enabled or changed on a running cluster without downtime.

```
kops create secret weavepassword [CLUSTER] [flags]
```

### Examples

```
  # Create a new random weave password.
  kops create secret weavepassword \
  --name k8s-cluster.example.com --state s3://my-state-store
  
  # Install a specific weave password.
  kops create secret weavepassword -f /path/to/weavepassword \
  --name k8s-cluster.example.com --state s3://my-state-store
  
  # Install a specific weave password via stdin.
  kops create secret weavepassword -f - \
  --name k8s-cluster.example.com --state s3://my-state-store
  
  # Replace an existing weave password.
  kops create secret weavepassword -f /path/to/weavepassword --force \
  --name k8s-cluster.example.com --state s3://my-state-store
```

### Options

```
  -f, --filename string   Path to Weave password file
      --force             Force replace the secret if it already exists
  -h, --help              help for weavepassword
```

### Options inherited from parent commands

```
      --config string   yaml config file (default is $HOME/.kops.yaml)
      --name string     Name of cluster. Overrides KOPS_CLUSTER_NAME environment variable
      --state string    Location of state storage (kops 'config' file). Overrides KOPS_STATE_STORE environment variable
  -v, --v Level         number for the log level verbosity
```

### SEE ALSO

* [kops create secret](kops_create_secret.md)	 - Create a secret.

