# CVE-2019-5736 - runc container breakout

runc through 1.0-rc6, as used in Docker before 18.09.2, allows attackers to
overwrite the host runc binary and consequently obtain host root access.  For
more information, please see the [NIST advisory][NIST advisory]
or the [kubernetes advisory][kubernetes advisory].

For kOps, kOps releases 1.11.1 or later include workarounds, but note that the
fixes depend on the version of kubernetes you are running.  Because kubernetes
1.10 and 1.11 were only validated with Docker version 17.03.x (and earlier), and
because Docker has chosen not to offer fixes for 17.03 in OSS, there is no
patched version.

**You must update to kOps 1.11.1 (or later) if you are running kubernetes <=
  1.11.x to get this fix**

However, there is [an alternative](https://seclists.org/oss-sec/2019/q1/134) to
the patch which is less impactful and requires no source code changes: it is
possible to mark runc as immutable using `chattr`.  Doing so protects against
the known exploits.  The exception is privileged pods (that are effectively root
anyway) and pods that have explicitly been granted CAP_LINUX_IMMUTABLE in the
[`securityContext.capabilities`][securityContext.capabilities].

**If you are running pods that are not privileged but you grant
  CAP_LINUX_IMMUTABLE in the
  [`securityContext.capabilities`][securityContext.capabilities], and are
  running kubernetes 1.11 (or earlier), you should consider one of the
  alternative fixes listed below**

## Summary of fixes that ship with kOps >= 1.11.1

* Kubernetes 1.11 (and earlier): we mark runc with the immutable attribute.
* Kubernetes 1.12 (and later): we install a version of docker that includes a
  fixed runc

## Alternative fixes for users of kubernetes 1.11 (or earlier)

* Anticipate upgrading to kubernetes 1.12 earlier than previously planned.  We are
  accelerating the kOps 1.12 release to facilitate this.
* Consider replacing the docker version with 18.06.3 or later.  Note that this
  will "pin" your docker version and in future you will want to remove this to
  get future docker upgrades.  (Do not select docker 18.06.2 on Redhat/Centos,
  that version was mistakenly packaged by Docker without including the fix)
* Consider replacing just runc - some third parties have backported the fix to
  runc 17.03, and our wonderful community of kOps users has shared their
  approaches to patching runc, see
  [here](https://github.com/kubernetes/kops/issues/6459) and
  [here](https://github.com/kubernetes/kops/issues/6476#issuecomment-465861406).



[NIST advisory]: https://nvd.nist.gov/vuln/detail/CVE-2019-5736
[kubernetes advisory]: https://kubernetes.io/blog/2019/02/11/runc-and-cve-2019-5736/
[securityContext.capabilities]: https://kubernetes.io/docs/tasks/configure-pod-container/security-context/#set-capabilities-for-a-container
