
<!--- This file is automatically generated by make gen-cli-docs; changes should be made in the go CLI command code (under cmd/kops) -->

## kops update cluster

Update a cluster.

### Synopsis

Create or update cloud or cluster resources to match the current cluster and instance group definitions. If the cluster or cloud resources already exist this command may modify those resources.

 If, such as during a Kubernetes upgrade, nodes need updating, a rolling-update may be subsequently required.

```
kops update cluster [CLUSTER] [flags]
```

### Examples

```
  # After the cluster has been edited or upgraded, update the cloud resources with:
  kops update cluster k8s-cluster.example.com --yes --state=s3://my-state-store --yes
```

### Options

```
      --admin duration[=18h0m0s]      Also export a cluster admin user credential with the specified lifetime and add it to the cluster context
      --allow-kops-downgrade          Allow an older version of kOps to update the cluster than last used
      --create-kube-config            Will control automatically creating the kube config file on your local filesystem (default true)
  -h, --help                          help for cluster
      --internal                      Use the cluster's internal DNS name. Implies --create-kube-config
      --lifecycle-overrides strings   comma separated list of phase overrides, example: SecurityGroups=Ignore,InternetGateway=ExistsAndWarnIfChanges
      --out string                    Path to write any local output
      --phase string                  Subset of tasks to run: cluster, network, security
      --ssh-public-key string         SSH public key to use (deprecated: use kops create secret instead)
      --target string                 Target - direct, terraform, cloudformation (default "direct")
      --user string                   Existing user in kubeconfig file to use.  Implies --create-kube-config
  -y, --yes                           Create cloud resources, without --yes update is in dry run mode
```

### Options inherited from parent commands

```
      --config string   yaml config file (default is $HOME/.kops.yaml)
      --name string     Name of cluster. Overrides KOPS_CLUSTER_NAME environment variable
      --state string    Location of state storage (kops 'config' file). Overrides KOPS_STATE_STORE environment variable
  -v, --v Level         number for the log level verbosity
```

### SEE ALSO

* [kops update](kops_update.md)	 - Update a cluster.

