## Release notes for kOps 1.23 series

# Significant changes

* If the Kubernetes version is 1.23 or later and the external AWS Cloud Controller Manager is
being used, then Kubernetes Node resources will be named after their AWS instance ID instead of their domain name and
managed subnets will be configured to launch instances with Resource Based Names.

* Support for [ShutdownGracePeriod and ShutdownGracePeriodCriticalPods](https://kubernetes.io/blog/2021/04/21/graceful-node-shutdown-beta/). By default, kOps will set ShutdownGracePeriod to 30 seconds and ShutdownGracePeriodCriticalPods to 10 seconds if the Kubernetes version is above 1.21.

* By enabling the [pod identity webhook](https://kops.sigs.k8s.io/addons/#pod-identity-webhook), you no longer need to modify your Pod specs to assume IAM roles.

# Breaking changes

* Support for Kubernetes version 1.17 has been removed.

* Support for the Lyft CNI has been removed.

* The Weave CNI is not supported for Kubernetes 1.23 or later.

* Support for CentOS 7 has been removed.

* Support for CentOS 8 has been removed (replaced by Rocky Linux 8).

* Support for Debian 9 has been removed.

* Support for RHEL 7 is has been removed.

* Support for Ubuntu 16.04 (Xenial) has been removed.

* Cilium now has `disable-cnp-status-updates: true` by default. Set this to false if you rely on the CiliumNetworkPolicy status fields.

# Required actions

# Deprecations

* Support for Kubernetes version 1.18 is deprecated and will be removed in kOps 1.24.

* Support for Kubernetes version 1.19 is deprecated and will be removed in kOps 1.25.

* All legacy addons are deprecated in favor of managed addons, including the [metrics server addon](https://github.com/kubernetes/kops/tree/master/addons/metrics-server) and the [autoscaler addon](https://github.com/kubernetes/kops/tree/master/addons/cluster-autoscaler).

* The `node-role.kubernetes.io/master` and `kubernetes.io/role` labels are deprecated and might be removed from control plane nodes in future versions of kOps.

* Due to lack of maintainers, the Aliyun/Alibaba Cloud support has been deprecated and will be removed in kOps 1.24.

* Due to lack of maintainers, the CloudFormation support has been deprecated. The current implementation will be left as-is until the implementation needs updates or otherwise becomes incompatible. At that point, it will be removed. We very much welcome anyone willing to contribute to this target.

# Other changes of note

* The `kops create cluster` command has a new `--discovery-store` flag for specifying a public store for the OIDC-compatible discovery documents.
If this flag is used in AWS, it will enable IRSA.

* If `externalDns.provider` is `external-dns`, then `externalDns.watchIngress` will now default to `true`.

* This release introduces a `v1alpha3` API version. This API version is a work in progress and is likely to be replaced in kOps 1.24.
It is recommended to keep using the `v1alpha2` API version.

* IPv6 pod subnets is in a working state using public IPv6 addresses for the Pod network. This works with both Cilium and Calico. IPv6 is still behind a feature flag until service controllers and addons implement support for IPv6. See [the IPv6 documentation](https://kops.sigs.k8s.io/networking/ipv6/).

* The `kops rolling-update cluster` command has a new `--drain-timeout` flag for specifying the maximum amount of time to wait when attempting to drain a node. Previously, rolling-updates would attempt to drain a node for an indefinite amount of time. If `--drain-timeout` is not specified, a default of 15 minutes is applied.

* Fix inconsistent output of `kops get clusters -ojson`. This will now always return a list (irrespective of a single or multiple clusters) to keep the format consistent. However, note that `kops get cluster dev.example.com -ojson` will continue to work as previously, and will return a single object.

* Digital Ocean kops now has vpc support. You can specify a `network-cidr` range while creating the kops cluster. kops resources will be created in the new vpc range. Also supports shared vpc; you can specify the vpc uuid while creating kops cluster.

# Full change list since 1.22.0 release


## 1.23.0-alpha.1 to 1.23.0-alpha.2

* Release 1.22.0-beta.1 [@johngmyers](https://github.com/johngmyers) [#12211](https://github.com/kubernetes/kops/pull/12211)
* Revert "Release 1.22.0-beta.1" [@johngmyers](https://github.com/johngmyers) [#12213](https://github.com/kubernetes/kops/pull/12213)
* Release 1.23.0-alpha.1 [@johngmyers](https://github.com/johngmyers) [#12210](https://github.com/kubernetes/kops/pull/12210)
* [addons/metrics-server] Bump minor version [@dntosas](https://github.com/dntosas) [#12198](https://github.com/kubernetes/kops/pull/12198)
* Release notes for 1.22.0-beta.1  [@johngmyers](https://github.com/johngmyers) [#12216](https://github.com/kubernetes/kops/pull/12216)
* Remove code for unsupported features [@johngmyers](https://github.com/johngmyers) [#12218](https://github.com/kubernetes/kops/pull/12218)
* Bump cloudbuild images to latest [@rifelpet](https://github.com/rifelpet) [#12222](https://github.com/kubernetes/kops/pull/12222)
* Fix new staticcheck errors [@burntcarrot](https://github.com/burntcarrot) [#12215](https://github.com/kubernetes/kops/pull/12215)
* Move bootstrap RBAC from protokube to core bootstrap addon [@johngmyers](https://github.com/johngmyers) [#12221](https://github.com/kubernetes/kops/pull/12221)
* Update staticcheck to latest [@rifelpet](https://github.com/rifelpet) [#12224](https://github.com/kubernetes/kops/pull/12224)
* [Documentation update] Note for the metrics configuration for etcd [@recollir](https://github.com/recollir) [#12223](https://github.com/kubernetes/kops/pull/12223)
* fix parse semver [@zetaab](https://github.com/zetaab) [#12227](https://github.com/kubernetes/kops/pull/12227)
* check does iface has associations [@zetaab](https://github.com/zetaab) [#12232](https://github.com/kubernetes/kops/pull/12232)
* Bump cert-manager to 1.5.3 [@olemarkus](https://github.com/olemarkus) [#12229](https://github.com/kubernetes/kops/pull/12229)
* Fix etcd3-migration docs link [@RetWolf](https://github.com/RetWolf) [#12238](https://github.com/kubernetes/kops/pull/12238)
* Update metrics-server tag used in e2e scenario [@rifelpet](https://github.com/rifelpet) [#12239](https://github.com/kubernetes/kops/pull/12239)
* Bump node termination handler to 1.13.3 [@olemarkus](https://github.com/olemarkus) [#12237](https://github.com/kubernetes/kops/pull/12237)
* [addons/node-local-dns] Bump version and make image field configurable [@dntosas](https://github.com/dntosas) [#12219](https://github.com/kubernetes/kops/pull/12219)
* Set kube-apiserver as default logs container [@olemarkus](https://github.com/olemarkus) [#12246](https://github.com/kubernetes/kops/pull/12246)
* Enable protect-kernel-defaults by default and set the correct sysctls in nodeup [@olemarkus](https://github.com/olemarkus) [#12193](https://github.com/kubernetes/kops/pull/12193)
* Use node internal IP for metrics-server [@olemarkus](https://github.com/olemarkus) [#12260](https://github.com/kubernetes/kops/pull/12260)
* Set ipv6 nameservers on aws [@olemarkus](https://github.com/olemarkus) [#12259](https://github.com/kubernetes/kops/pull/12259)
* Set NodeIPFamilies in ipv6 mode [@olemarkus](https://github.com/olemarkus) [#12258](https://github.com/kubernetes/kops/pull/12258)
* Disable masquerade means disable masquerade if ipv6 too [@olemarkus](https://github.com/olemarkus) [#12265](https://github.com/kubernetes/kops/pull/12265)
* Update controller-runtime to v0.9.7 [@hakman](https://github.com/hakman) [#12264](https://github.com/kubernetes/kops/pull/12264)
* Try to bootstrap when at least one IP is available [@hakman](https://github.com/hakman) [#12270](https://github.com/kubernetes/kops/pull/12270)
* Fix core manifest [@olemarkus](https://github.com/olemarkus) [#12268](https://github.com/kubernetes/kops/pull/12268)
* update openstack CSI [@zetaab](https://github.com/zetaab) [#12251](https://github.com/kubernetes/kops/pull/12251)
* Fix bootstrap when at least one IP is available [@hakman](https://github.com/hakman) [#12273](https://github.com/kubernetes/kops/pull/12273)
* Fix kernel parameter for IPv6 forwarding [@hakman](https://github.com/hakman) [#12271](https://github.com/kubernetes/kops/pull/12271)
* Dump external-dns and dns-controller pod logs [@rifelpet](https://github.com/rifelpet) [#12276](https://github.com/kubernetes/kops/pull/12276)
* Add .log suffix to dumped pod logs [@rifelpet](https://github.com/rifelpet) [#12278](https://github.com/kubernetes/kops/pull/12278)
* Add support --kernel-memcg-notification Kubelet flag [@hakman](https://github.com/hakman) [#12267](https://github.com/kubernetes/kops/pull/12267)
* Set explicit fsType to be able to mount volumes [@pa1op](https://github.com/pa1op) [#12280](https://github.com/kubernetes/kops/pull/12280)
* dev: hack/update-expected script should clear KOPS_ARCH [@justinsb](https://github.com/justinsb) [#12283](https://github.com/kubernetes/kops/pull/12283)
* Add helper to convert kubemanifest.Object to unstructured [@justinsb](https://github.com/justinsb) [#12284](https://github.com/kubernetes/kops/pull/12284)
* Add notes and docs on external-dns [@olemarkus](https://github.com/olemarkus) [#12279](https://github.com/kubernetes/kops/pull/12279)
* use ipip Always by default in OpenStack [@zetaab](https://github.com/zetaab) [#12286](https://github.com/kubernetes/kops/pull/12286)
* Include kops- prefix in external-dns TXT record [@rifelpet](https://github.com/rifelpet) [#12289](https://github.com/kubernetes/kops/pull/12289)
* External dns fixes [@olemarkus](https://github.com/olemarkus) [#12288](https://github.com/kubernetes/kops/pull/12288)
* Do not set ClusterCIDR for KubeProxy when using CNI networking and kubeProxy.clusterCIDR is not set [@dezmodue](https://github.com/dezmodue) [#12207](https://github.com/kubernetes/kops/pull/12207)
* Update AWS CCM tags [@rifelpet](https://github.com/rifelpet) [#12104](https://github.com/kubernetes/kops/pull/12104)
* Enable IMDS IPv6 endpoint [@rifelpet](https://github.com/rifelpet) [#12290](https://github.com/kubernetes/kops/pull/12290)
* Note about breaking change for apiserver files [@olemarkus](https://github.com/olemarkus) [#12294](https://github.com/kubernetes/kops/pull/12294)
* Use MasterInternalName for gossip cluster SA issuer [@rifelpet](https://github.com/rifelpet) [#12297](https://github.com/kubernetes/kops/pull/12297)
* [kubelet] Add validation for cpuCFSQuotaPeriod after k8s>=1.20 [@dntosas](https://github.com/dntosas) [#12292](https://github.com/kubernetes/kops/pull/12292)
* Recognize Ubuntu 21.10 (Impish Indri) [@hakman](https://github.com/hakman) [#12300](https://github.com/kubernetes/kops/pull/12300)
* Bump snapshot-controller to 4.2.1 [@olemarkus](https://github.com/olemarkus) [#12303](https://github.com/kubernetes/kops/pull/12303)
* Update Go to v1.16.8 [@hakman](https://github.com/hakman) [#12306](https://github.com/kubernetes/kops/pull/12306)
* Bump aws ebs csi driver to 1.2.1 [@olemarkus](https://github.com/olemarkus) [#12310](https://github.com/kubernetes/kops/pull/12310)
* Add ability to yaml-encode unstructured [@justinsb](https://github.com/justinsb) [#12282](https://github.com/kubernetes/kops/pull/12282)
* Pre-install nvidia container runtime + drivers on GPU instances [@olemarkus](https://github.com/olemarkus) [#11628](https://github.com/kubernetes/kops/pull/11628)
* Update Bazel to v4.2.1 [@hakman](https://github.com/hakman) [#12311](https://github.com/kubernetes/kops/pull/12311)
* Do not precreate dns record for api lbs [@olemarkus](https://github.com/olemarkus) [#12308](https://github.com/kubernetes/kops/pull/12308)
* Default to latest staging image for AWS CCM [@hakman](https://github.com/hakman) [#12291](https://github.com/kubernetes/kops/pull/12291)
* Make AWS CCM NodeIPFamilies configurable [@hakman](https://github.com/hakman) [#12305](https://github.com/kubernetes/kops/pull/12305)
* Use sg rule ids and tags where possible [@olemarkus](https://github.com/olemarkus) [#12314](https://github.com/kubernetes/kops/pull/12314)
* Allow arbitrary length terraform literals [@rifelpet](https://github.com/rifelpet) [#12316](https://github.com/kubernetes/kops/pull/12316)
* Report the power state of cloud instances [@yadneshk](https://github.com/yadneshk) [#12326](https://github.com/kubernetes/kops/pull/12326)
* include new required permissions in documentation [@yeus](https://github.com/yeus) [#12328](https://github.com/kubernetes/kops/pull/12328)
* Use TLS for kubescheduler health check as of k8s 1.23 [@olemarkus](https://github.com/olemarkus) [#12333](https://github.com/kubernetes/kops/pull/12333)
* Update ALPHA k8s versions with Sept releases [@MoShitrit](https://github.com/MoShitrit) [#12337](https://github.com/kubernetes/kops/pull/12337)
* Implement support for AWS ipv6 prefixes [@olemarkus](https://github.com/olemarkus) [#12112](https://github.com/kubernetes/kops/pull/12112)
* Add IMDS IPv6 endpoint in terraform [@rifelpet](https://github.com/rifelpet) [#12298](https://github.com/kubernetes/kops/pull/12298)
* Deprecate TerraformJSON feature flag [@rifelpet](https://github.com/rifelpet) [#12341](https://github.com/kubernetes/kops/pull/12341)
* Skip SCTP e2e tests on cilium + k8s 1.23 [@rifelpet](https://github.com/rifelpet) [#12348](https://github.com/kubernetes/kops/pull/12348)
* Use EC2 and Metadata IPv6 endpoints in IPv6 mode for EBS CSI Driver [@hakman](https://github.com/hakman) [#12349](https://github.com/kubernetes/kops/pull/12349)
* fix: remove inconsistent comment [@eddycharly](https://github.com/eddycharly) [#12351](https://github.com/kubernetes/kops/pull/12351)
* fix: etcd backup docs [@eddycharly](https://github.com/eddycharly) [#12352](https://github.com/kubernetes/kops/pull/12352)
* Fix EC2 IPv6 endpoint for EBS CSI Driver controller [@hakman](https://github.com/hakman) [#12353](https://github.com/kubernetes/kops/pull/12353)
* Create a second Terraform provider for managed files [@rifelpet](https://github.com/rifelpet) [#12322](https://github.com/kubernetes/kops/pull/12322)
* Recognize pending EC2 instances as needed deletion [@justinsb](https://github.com/justinsb) [#12357](https://github.com/kubernetes/kops/pull/12357)
* Script for iterating development on AWS [@justinsb](https://github.com/justinsb) [#12356](https://github.com/kubernetes/kops/pull/12356)
* Only add IPv6 IAM permissions if using IPv6 [@justinsb](https://github.com/justinsb) [#12355](https://github.com/kubernetes/kops/pull/12355)
* Fix controller defaults for both bootstrap tokens and ipv6 [@justinsb](https://github.com/justinsb) [#12354](https://github.com/kubernetes/kops/pull/12354)
* Update Calico to v3.20.1 [@hakman](https://github.com/hakman) [#12360](https://github.com/kubernetes/kops/pull/12360)
* Fix version check in cilium SCTP test skipping [@rifelpet](https://github.com/rifelpet) [#12365](https://github.com/kubernetes/kops/pull/12365)
* Only configure IMDSv2 on AWS [@justinsb](https://github.com/justinsb) [#12369](https://github.com/kubernetes/kops/pull/12369)
* AWS: Move some subnet functions into AWS model [@justinsb](https://github.com/justinsb) [#12367](https://github.com/kubernetes/kops/pull/12367)
* Fix nil pointer error where containerd is not in use [@justinsb](https://github.com/justinsb) [#12374](https://github.com/kubernetes/kops/pull/12374)
* kubetest2 - add support for dumping k8s resources via SSH [@rifelpet](https://github.com/rifelpet) [#12372](https://github.com/kubernetes/kops/pull/12372)
* Better logging in setLifecycleOverride [@justinsb](https://github.com/justinsb) [#12376](https://github.com/kubernetes/kops/pull/12376)
* Fix parsing of kops toolbox dump yaml output [@rifelpet](https://github.com/rifelpet) [#12377](https://github.com/kubernetes/kops/pull/12377)
* Move cidrmap to subnet package [@justinsb](https://github.com/justinsb) [#11578](https://github.com/kubernetes/kops/pull/11578)
* GCE: Don't create utility subnets in private topology [@justinsb](https://github.com/justinsb) [#12373](https://github.com/kubernetes/kops/pull/12373)
* GCE: Fix subnet deletion [@justinsb](https://github.com/justinsb) [#12370](https://github.com/kubernetes/kops/pull/12370)
* GCE: Always have IPv6 rules in "ipv6 mode" [@justinsb](https://github.com/justinsb) [#12368](https://github.com/kubernetes/kops/pull/12368)
* [channels] Bump AWS/GCP/Azure Ubuntu AMIs to latest [@dntosas](https://github.com/dntosas) [#12334](https://github.com/kubernetes/kops/pull/12334)
* GCE: For IPAlias or Custom Routes, we must recognize source by CIDR [@justinsb](https://github.com/justinsb) [#12371](https://github.com/kubernetes/kops/pull/12371)
* kubetest2 - fix parsing output from toolbox dump [@rifelpet](https://github.com/rifelpet) [#12379](https://github.com/kubernetes/kops/pull/12379)
* Update Go to v1.17.1 [@hakman](https://github.com/hakman) [#12375](https://github.com/kubernetes/kops/pull/12375)
* GCE: When using calico, need to open up ipip protocol [@justinsb](https://github.com/justinsb) [#12384](https://github.com/kubernetes/kops/pull/12384)
* Remove unneeded network related sysctls [@hakman](https://github.com/hakman) [#12385](https://github.com/kubernetes/kops/pull/12385)
* Add specific taints to dns-controller. [@olemarkus](https://github.com/olemarkus) [#12389](https://github.com/kubernetes/kops/pull/12389)
* Add sleep to upgrade-ab scenario [@olemarkus](https://github.com/olemarkus) [#12391](https://github.com/kubernetes/kops/pull/12391)
* Make channels target phony [@olemarkus](https://github.com/olemarkus) [#12392](https://github.com/kubernetes/kops/pull/12392)
* feat: add support for wildcard in roles generated for IRSA [@eddycharly](https://github.com/eddycharly) [#12342](https://github.com/kubernetes/kops/pull/12342)
* Support zone autocompletion [@justinsb](https://github.com/justinsb),[@hakman](https://github.com/hakman) [#12366](https://github.com/kubernetes/kops/pull/12366)
* Decrease connection timeout when dumping logs from instances [@rifelpet](https://github.com/rifelpet) [#12397](https://github.com/kubernetes/kops/pull/12397)
* Fix list of supported cloud providers in CLI docs [@rifelpet](https://github.com/rifelpet) [#12396](https://github.com/kubernetes/kops/pull/12396)
* Fix link to addons documentation [@johngmyers](https://github.com/johngmyers) [#12402](https://github.com/kubernetes/kops/pull/12402)
* Upgrade terraform to 1.0.7 [@rifelpet](https://github.com/rifelpet),[@hakman](https://github.com/hakman) [#12403](https://github.com/kubernetes/kops/pull/12403)
* Add support to configure Cilium CNI chaining [@choutone](https://github.com/choutone) [#12407](https://github.com/kubernetes/kops/pull/12407)
* Run verify-cloudformation in host network [@rifelpet](https://github.com/rifelpet) [#12410](https://github.com/kubernetes/kops/pull/12410)
* Upgrade cnf-lint to 0.54.2 [@hakman](https://github.com/hakman) [#12411](https://github.com/kubernetes/kops/pull/12411)
* Add option to create an internal load balancer for the bastion [@dezmodue](https://github.com/dezmodue) [#12321](https://github.com/kubernetes/kops/pull/12321)
* Remove critical-pod scheduler annotation. [@rifelpet](https://github.com/rifelpet) [#12398](https://github.com/kubernetes/kops/pull/12398)
* Revert "Remove unneeded network related sysctls" [@olemarkus](https://github.com/olemarkus) [#12415](https://github.com/kubernetes/kops/pull/12415)
* Add bidirectional BPF mount for Cilium >= 1.9.10 or >= 1.10.4 [@ReillyBrogan](https://github.com/ReillyBrogan) [#12394](https://github.com/kubernetes/kops/pull/12394)
* Allow adding more subnets to an NLB [@olemarkus](https://github.com/olemarkus) [#12412](https://github.com/kubernetes/kops/pull/12412)
* release-process.md: Update references to artifact promotion [@justaugustus](https://github.com/justaugustus) [#12386](https://github.com/kubernetes/kops/pull/12386)
* Update google.golang.org/api to 0.57.0 [@justinsb](https://github.com/justinsb) [#12421](https://github.com/kubernetes/kops/pull/12421)
* protokube: don't try to connect to apiserver if not control-plane [@justinsb](https://github.com/justinsb) [#12424](https://github.com/kubernetes/kops/pull/12424)
* Refactor bootstrap verifier/authenticator into its own package [@justinsb](https://github.com/justinsb) [#12422](https://github.com/kubernetes/kops/pull/12422)
* Add kubetest2-kops template for testing dedicated APIServer nodes [@rifelpet](https://github.com/rifelpet) [#12428](https://github.com/kubernetes/kops/pull/12428)
* Have toolbox dump include contents of /etc/hosts [@rifelpet](https://github.com/rifelpet) [#12427](https://github.com/kubernetes/kops/pull/12427)
* Allow aws-iam-authenticator to be scheduled onto dedicated apiserver nodes [@rifelpet](https://github.com/rifelpet) [#12426](https://github.com/kubernetes/kops/pull/12426)
* Mount cgroupv2 for cilium at a custom location [@olemarkus](https://github.com/olemarkus) [#12431](https://github.com/kubernetes/kops/pull/12431)
* Update Amazon Linux 2 documentation to mention the 5.10 kernel [@rifelpet](https://github.com/rifelpet) [#12430](https://github.com/kubernetes/kops/pull/12430)
* Add ability to provide custom CoreDNS tolerations and affinity [@hierynomus](https://github.com/hierynomus) [#12234](https://github.com/kubernetes/kops/pull/12234)
* Document cloud-init behaviour [@dezmodue](https://github.com/dezmodue) [#12438](https://github.com/kubernetes/kops/pull/12438)
* Skip certain e2e tests in GCE [@rifelpet](https://github.com/rifelpet) [#12434](https://github.com/kubernetes/kops/pull/12434)
* Fix AWS IAM Authenticator support for k8s 1.22 [@rifelpet](https://github.com/rifelpet) [#12425](https://github.com/kubernetes/kops/pull/12425)
* feat: add support for custom audience in aws oidc provider [@eddycharly](https://github.com/eddycharly) [#12419](https://github.com/kubernetes/kops/pull/12419)
* Fix typo in name of new 'UseServiceAccountExternalPermissions' variable. [@ev-hines](https://github.com/ev-hines) [#12440](https://github.com/kubernetes/kops/pull/12440)
* Truncate cluster name in NTH EventBridgeRules [@rifelpet](https://github.com/rifelpet) [#12439](https://github.com/kubernetes/kops/pull/12439)
* Use separate cloud.config file for in-tree vs out-of-tree components [@rifelpet](https://github.com/rifelpet) [#12435](https://github.com/kubernetes/kops/pull/12435)
* Add fixed version to all addons [@olemarkus](https://github.com/olemarkus) [#12416](https://github.com/kubernetes/kops/pull/12416)
* Add support for YAML/JSON output to 'kops get instances' [@hierynomus](https://github.com/hierynomus) [#12442](https://github.com/kubernetes/kops/pull/12442)
* Update stable k8s versions [@MoShitrit](https://github.com/MoShitrit) [#12454](https://github.com/kubernetes/kops/pull/12454)
* Bump  aws-cni version to 1.9.1 [@MoShitrit](https://github.com/MoShitrit) [#12455](https://github.com/kubernetes/kops/pull/12455)
* Skip load balancer test in IPv6 clusters [@rifelpet](https://github.com/rifelpet) [#12452](https://github.com/kubernetes/kops/pull/12452)
* Update containerd to v1.4.10 [@hakman](https://github.com/hakman) [#12459](https://github.com/kubernetes/kops/pull/12459)
* Remove unnecessary sysctl "net.ipv6.conf.all.accept_ra=2" [@hakman](https://github.com/hakman) [#12461](https://github.com/kubernetes/kops/pull/12461)
* Bump Cluster Autoscaler images [@olemarkus](https://github.com/olemarkus) [#12463](https://github.com/kubernetes/kops/pull/12463)
* Create v1alpha3 apiVersion [@johngmyers](https://github.com/johngmyers) [#12406](https://github.com/kubernetes/kops/pull/12406)
* v1alpha3 API fixup [@johngmyers](https://github.com/johngmyers) [#12466](https://github.com/kubernetes/kops/pull/12466)
* Release notes for 1.22.0-beta.2 [@johngmyers](https://github.com/johngmyers) [#12468](https://github.com/kubernetes/kops/pull/12468)
* Fail if an apimachinery conversion is missing [@johngmyers](https://github.com/johngmyers) [#12469](https://github.com/kubernetes/kops/pull/12469)
* kube-controller-manager also doesn't mount /srv/kubernetes [@johngmyers](https://github.com/johngmyers) [#12473](https://github.com/kubernetes/kops/pull/12473)
* Cleanup ClusterSpec code [@johngmyers](https://github.com/johngmyers) [#12472](https://github.com/kubernetes/kops/pull/12472)
* Remove Docker overlayfs upgrade code [@johngmyers](https://github.com/johngmyers) [#12471](https://github.com/kubernetes/kops/pull/12471)
* Spotinst: Update `spotinst/ocean-controller` to v1.0.78 [@liranp](https://github.com/liranp) [#12476](https://github.com/kubernetes/kops/pull/12476)
* Update containerd to v1.4.11 [@hakman](https://github.com/hakman) [#12479](https://github.com/kubernetes/kops/pull/12479)
* Update Docker to v20.10.9 [@hakman](https://github.com/hakman) [#12481](https://github.com/kubernetes/kops/pull/12481)
* Update k8s dependencies to v1.22.2 [@hakman](https://github.com/hakman) [#12483](https://github.com/kubernetes/kops/pull/12483)
* Add Cilium agent pod annotations support to improve personalization [@sterchelen](https://github.com/sterchelen) [#12414](https://github.com/kubernetes/kops/pull/12414)
* [DigitalOcean] Incorporate existing vpc support for kops [@srikiz](https://github.com/srikiz) [#12485](https://github.com/kubernetes/kops/pull/12485)
* Add kubescheduler.config.k8s.io/v1beta2 for k8s 1.22+ [@hakman](https://github.com/hakman) [#12486](https://github.com/kubernetes/kops/pull/12486)
* Update controller-runtime to v0.10.2 [@hakman](https://github.com/hakman) [#12490](https://github.com/kubernetes/kops/pull/12490)
* Update Calico to v3.20.2 [@hakman](https://github.com/hakman) [#12491](https://github.com/kubernetes/kops/pull/12491)
* Replace klog flags with go-runner in k8s 1.23  [@rifelpet](https://github.com/rifelpet) [#12494](https://github.com/kubernetes/kops/pull/12494)
* Support GCE TPM verification [@justinsb](https://github.com/justinsb) [#12420](https://github.com/kubernetes/kops/pull/12420)
* Remove unused fields cluster APIs [@johngmyers](https://github.com/johngmyers) [#12475](https://github.com/kubernetes/kops/pull/12475)
* Update Bazel rules_go to v0.29.0 [@hakman](https://github.com/hakman) [#12496](https://github.com/kubernetes/kops/pull/12496)
* Update etcd-manager to 3.0.20211007 [@hakman](https://github.com/hakman) [#12497](https://github.com/kubernetes/kops/pull/12497)
* Remove some unused fields from v1alpha3 componentconfig [@johngmyers](https://github.com/johngmyers) [#12500](https://github.com/kubernetes/kops/pull/12500)
* Add Cilium + RHEL8 release note [@rifelpet](https://github.com/rifelpet) [#12504](https://github.com/kubernetes/kops/pull/12504)
* Update Go to v1.17.2 [@hakman](https://github.com/hakman) [#12502](https://github.com/kubernetes/kops/pull/12502)
* Convert go.mod files to Go 1.17 [@hakman](https://github.com/hakman) [#12505](https://github.com/kubernetes/kops/pull/12505)
* Release notes for 1.20.3 [@hakman](https://github.com/hakman) [#12512](https://github.com/kubernetes/kops/pull/12512)
* Release notes for 1.21.2 [@hakman](https://github.com/hakman) [#12513](https://github.com/kubernetes/kops/pull/12513)
* Bump channels [@hakman](https://github.com/hakman) [#12516](https://github.com/kubernetes/kops/pull/12516)
* Update release process docs [@hakman](https://github.com/hakman) [#12514](https://github.com/kubernetes/kops/pull/12514)
* Remove more unused fields from v1alpha3 API [@johngmyers](https://github.com/johngmyers) [#12517](https://github.com/kubernetes/kops/pull/12517)
* Update coredns to v1.8.5 [@hakman](https://github.com/hakman) [#12518](https://github.com/kubernetes/kops/pull/12518)
* Fix addon-resource-tracking e2e scenario [@rifelpet](https://github.com/rifelpet) [#12520](https://github.com/kubernetes/kops/pull/12520)
* Spotinst: Support for RI commitments [@liranp](https://github.com/liranp) [#12522](https://github.com/kubernetes/kops/pull/12522)
* tests: create-cluster integration tests should validate additional objects [@justinsb](https://github.com/justinsb) [#12285](https://github.com/kubernetes/kops/pull/12285)
* Update Bazel rules_docker to v0.20.0 [@hakman](https://github.com/hakman) [#12523](https://github.com/kubernetes/kops/pull/12523)
* Enable ingress hostname feature for OpenStack [@zetaab](https://github.com/zetaab) [#12525](https://github.com/kubernetes/kops/pull/12525)
* Upgrade EBS CSI Driver to v1.4.0 [@rifelpet](https://github.com/rifelpet),[@olemarkus](https://github.com/olemarkus) [#12529](https://github.com/kubernetes/kops/pull/12529)
* Release notes for 1.22.0 [@johngmyers](https://github.com/johngmyers) [#12533](https://github.com/kubernetes/kops/pull/12533)
* Spotinst: Permission to create `bigdata.spot.io/bigdataenvironments` [@liranp](https://github.com/liranp) [#12521](https://github.com/kubernetes/kops/pull/12521)
* Add missing "a" to 1.22 release notes [@yurrriq](https://github.com/yurrriq) [#12536](https://github.com/kubernetes/kops/pull/12536)
* Bump cert-manager dependency [@olemarkus](https://github.com/olemarkus) [#12537](https://github.com/kubernetes/kops/pull/12537)
* Don't hard-code the SQS Queue ARN partition [@rifelpet](https://github.com/rifelpet) [#12540](https://github.com/kubernetes/kops/pull/12540)
* Minor updates to releases document [@johngmyers](https://github.com/johngmyers) [#12546](https://github.com/kubernetes/kops/pull/12546)
* Add rolling updates doc to menus [@johngmyers](https://github.com/johngmyers) [#12550](https://github.com/kubernetes/kops/pull/12550)
* [cilium] Add support for bpf-lb-sock-hostns-only field [@dntosas](https://github.com/dntosas) [#12524](https://github.com/kubernetes/kops/pull/12524)
* kops-controller: register coordination scheme [@justinsb](https://github.com/justinsb) [#12553](https://github.com/kubernetes/kops/pull/12553)
* Add capacity-optimized-prioritized as a valid spot allocation strategy [@ripta](https://github.com/ripta) [#12560](https://github.com/kubernetes/kops/pull/12560)
* Disable CNP status updates by default [@olemarkus](https://github.com/olemarkus) [#12564](https://github.com/kubernetes/kops/pull/12564)
* Update google/go-containerregistry to v0.6.0 [@hakman](https://github.com/hakman) [#12566](https://github.com/kubernetes/kops/pull/12566)
* Re-add ec2:DescribeLaunchTemplateVersions to CA IAM policy [@rifelpet](https://github.com/rifelpet) [#12568](https://github.com/kubernetes/kops/pull/12568)
* Upgrade tests - cleanup previous cluster with newer kops version [@rifelpet](https://github.com/rifelpet) [#12570](https://github.com/kubernetes/kops/pull/12570)
* Upgrade AWS VPC CNI to 1.9.3 w/ k8s 1.22 support [@rifelpet](https://github.com/rifelpet) [#12573](https://github.com/kubernetes/kops/pull/12573)
* Update channels [@hakman](https://github.com/hakman) [#12548](https://github.com/kubernetes/kops/pull/12548)
* Make it possible to set CAS max-node-provision-time [@olemarkus](https://github.com/olemarkus) [#12437](https://github.com/kubernetes/kops/pull/12437)
* Update release documentation [@johngmyers](https://github.com/johngmyers) [#12578](https://github.com/kubernetes/kops/pull/12578)
* Release notes for 1.22.1 [@johngmyers](https://github.com/johngmyers) [#12579](https://github.com/kubernetes/kops/pull/12579)
* Prune addons via labels [@justinsb](https://github.com/justinsb) [#12156](https://github.com/kubernetes/kops/pull/12156)
* Support BYO IPv6 [@johngmyers](https://github.com/johngmyers) [#12582](https://github.com/kubernetes/kops/pull/12582)
* Mention KOPS_ARCH in contributor documentation [@johngmyers](https://github.com/johngmyers) [#12586](https://github.com/kubernetes/kops/pull/12586)
* Allow AWS LBC to attach certificates [@olemarkus](https://github.com/olemarkus) [#12309](https://github.com/kubernetes/kops/pull/12309)
* gossip: Seed /etc/hosts in nodeup [@justinsb](https://github.com/justinsb) [#12554](https://github.com/kubernetes/kops/pull/12554)
* GCE: use chrony on Ubuntu + GCE [@justinsb](https://github.com/justinsb) [#12587](https://github.com/kubernetes/kops/pull/12587)
* Upgrade Canal to v3.20 with k8s 1.22 support [@rifelpet](https://github.com/rifelpet) [#12584](https://github.com/kubernetes/kops/pull/12584)
* GCE: Allow network to be marked as shared [@justinsb](https://github.com/justinsb) [#12590](https://github.com/kubernetes/kops/pull/12590)
* Add calico-kube-controllers for Canal [@hakman](https://github.com/hakman) [#12593](https://github.com/kubernetes/kops/pull/12593)
* Support BYO IPv6 [@johngmyers](https://github.com/johngmyers) [#12592](https://github.com/kubernetes/kops/pull/12592)
* gce: allow router to refer to network object [@justinsb](https://github.com/justinsb) [#12591](https://github.com/kubernetes/kops/pull/12591)
* Update Canal based on Calico [@hakman](https://github.com/hakman) [#12594](https://github.com/kubernetes/kops/pull/12594)
* Spotinst: Get instance types from `mixedInstancesPolicy` field [@liranp](https://github.com/liranp) [#12549](https://github.com/kubernetes/kops/pull/12549)
* Rename BAZEL_BIN to BAZEL in Makefile [@hakman](https://github.com/hakman) [#12599](https://github.com/kubernetes/kops/pull/12599)
* gce: open kops-controller port from nodes [@justinsb](https://github.com/justinsb) [#12556](https://github.com/kubernetes/kops/pull/12556)
* Handle keypair items without certificates [@johngmyers](https://github.com/johngmyers) [#12601](https://github.com/kubernetes/kops/pull/12601)
* Respect any MaxPods value the user sets explicitly [@hakman](https://github.com/hakman) [#12603](https://github.com/kubernetes/kops/pull/12603)
* Add permissions needed for KCM to provision NLBs [@olemarkus](https://github.com/olemarkus) [#12611](https://github.com/kubernetes/kops/pull/12611)
* dns-controller: Treat IPv6 node addresses as both internal and external [@johngmyers](https://github.com/johngmyers) [#12608](https://github.com/kubernetes/kops/pull/12608)
* GCE: improve network & subnet terraform support [@justinsb](https://github.com/justinsb) [#12382](https://github.com/kubernetes/kops/pull/12382)
* GCE: support egress specification [@justinsb](https://github.com/justinsb) [#12600](https://github.com/kubernetes/kops/pull/12600)
* Fix GCE router terraform reference [@rifelpet](https://github.com/rifelpet) [#12618](https://github.com/kubernetes/kops/pull/12618)
* Use the SQS Queue's ARN reference [@rifelpet](https://github.com/rifelpet),[@hakman](https://github.com/hakman) [#12571](https://github.com/kubernetes/kops/pull/12571)
* Remove vestigial Cilium ContainerRuntimeLabels code [@johngmyers](https://github.com/johngmyers) [#12615](https://github.com/kubernetes/kops/pull/12615)
*  Improve default CIDR assignments for IPv6  [@johngmyers](https://github.com/johngmyers) [#12617](https://github.com/kubernetes/kops/pull/12617)
* Make dns-controller delete placeholder addresses for IPv6 cluster [@johngmyers](https://github.com/johngmyers) [#12605](https://github.com/kubernetes/kops/pull/12605)
* Use .bazel-bin to help gopls & VSCode [@justinsb](https://github.com/justinsb) [#12498](https://github.com/kubernetes/kops/pull/12498)
* GCE: Delete routes with long cluster names [@justinsb](https://github.com/justinsb) [#12619](https://github.com/kubernetes/kops/pull/12619)
* Use instance metadata to find local IPv6 prefix [@hakman](https://github.com/hakman) [#12622](https://github.com/kubernetes/kops/pull/12622)
* Create placeholder DNS records of correct type for IPv6 clusters [@johngmyers](https://github.com/johngmyers) [#12616](https://github.com/kubernetes/kops/pull/12616)
* kubetest2: remove duplicate admin-access flag [@justinsb](https://github.com/justinsb) [#12625](https://github.com/kubernetes/kops/pull/12625)
* kubetest2: force printing of the plan on cluster creation [@justinsb](https://github.com/justinsb) [#12624](https://github.com/kubernetes/kops/pull/12624)
* Use server-side apply for addons. Identify as kops [@olemarkus](https://github.com/olemarkus) [#12583](https://github.com/kubernetes/kops/pull/12583)
* Use InternalIP as preferred kubelet address only in ivp6 mode [@olemarkus](https://github.com/olemarkus) [#12626](https://github.com/kubernetes/kops/pull/12626)
* Clarify the deployment responsible for API DNS in error message [@rifelpet](https://github.com/rifelpet) [#12277](https://github.com/kubernetes/kops/pull/12277)
* Dump more resource types from kubectl into cluster-info directory [@rifelpet](https://github.com/rifelpet) [#12631](https://github.com/kubernetes/kops/pull/12631)
* Configure aws-iam-authenticator using identityMappings defined in cluster.yaml [@hierynomus](https://github.com/hierynomus) [#12538](https://github.com/kubernetes/kops/pull/12538)
* Never masquerade IPv6 with Cilium [@johngmyers](https://github.com/johngmyers) [#12623](https://github.com/kubernetes/kops/pull/12623)
* Add more IPv6 integration tests [@hakman](https://github.com/hakman) [#12634](https://github.com/kubernetes/kops/pull/12634)
* Log `kops toolbox dump` output to artifacts dir rather than stdout [@rifelpet](https://github.com/rifelpet) [#12639](https://github.com/kubernetes/kops/pull/12639)
* Integration test cleanup [@rifelpet](https://github.com/rifelpet) [#12637](https://github.com/kubernetes/kops/pull/12637)
* Allow kops-controller to describe network interfaces [@hakman](https://github.com/hakman) [#12641](https://github.com/kubernetes/kops/pull/12641)
* Fix hardcoded ARN partitions [@rifelpet](https://github.com/rifelpet) [#12638](https://github.com/kubernetes/kops/pull/12638)
* Check for hardcoded partitions in integration tests [@rifelpet](https://github.com/rifelpet) [#12635](https://github.com/kubernetes/kops/pull/12635)
* Enable Router Advertisements for Debian 11 [@hakman](https://github.com/hakman) [#12642](https://github.com/kubernetes/kops/pull/12642)
* Use prefixes for IPv6 with Calico [@hakman](https://github.com/hakman) [#12643](https://github.com/kubernetes/kops/pull/12643)
* doc: Number subsections that are procedural steps [@johngmyers](https://github.com/johngmyers) [#12645](https://github.com/kubernetes/kops/pull/12645)
* Revert "Make dns-controller delete placeholder addresses for IPv6 cluster" [@johngmyers](https://github.com/johngmyers) [#12646](https://github.com/kubernetes/kops/pull/12646)
* dns-controller: use aliases for internal host-network pods [@johngmyers](https://github.com/johngmyers) [#12640](https://github.com/kubernetes/kops/pull/12640)
* Prohibit masquerading in IPv6 clusters [@johngmyers](https://github.com/johngmyers) [#12647](https://github.com/kubernetes/kops/pull/12647)
* Validate CNI can support IPv6 [@johngmyers](https://github.com/johngmyers) [#12650](https://github.com/kubernetes/kops/pull/12650)
* Remove unused Cilium fields from v1alpha3 API [@johngmyers](https://github.com/johngmyers) [#12610](https://github.com/kubernetes/kops/pull/12610)
* Remove obsolete documents [@johngmyers](https://github.com/johngmyers) [#12648](https://github.com/kubernetes/kops/pull/12648)
* Enable Router Advertisements for Debian 11 on  ens* interfaces [@hakman](https://github.com/hakman) [#12652](https://github.com/kubernetes/kops/pull/12652)
* IPv6 requires external CCM [@johngmyers](https://github.com/johngmyers) [#12651](https://github.com/kubernetes/kops/pull/12651)

## 1.23.0-alpha.2 to 1.23.0-beta.1

* Release 1.23.0-alpha.2 [@johngmyers](https://github.com/johngmyers) [#12654](https://github.com/kubernetes/kops/pull/12654)
* Release notes for 1.23.0-alpha.2 [@johngmyers](https://github.com/johngmyers) [#12655](https://github.com/kubernetes/kops/pull/12655)
* Switch release process to official GitHub client [@johngmyers](https://github.com/johngmyers) [#12656](https://github.com/kubernetes/kops/pull/12656)
* Add initial IPv6 documentation [@johngmyers](https://github.com/johngmyers) [#12649](https://github.com/kubernetes/kops/pull/12649)
* Start IPv6 CIDR numbering from 0 [@hakman](https://github.com/hakman) [#12658](https://github.com/kubernetes/kops/pull/12658)
* Migrate kube-proxy manifest to use go-runner for logging [@rifelpet](https://github.com/rifelpet) [#12664](https://github.com/kubernetes/kops/pull/12664)
* Fix error handling in kubetest2 dumplogs [@rifelpet](https://github.com/rifelpet) [#12667](https://github.com/kubernetes/kops/pull/12667)
* Revert "Migrate kube-proxy manifest to use go-runner for logging" [@rifelpet](https://github.com/rifelpet) [#12668](https://github.com/kubernetes/kops/pull/12668)
* Fix cluster name used in IAM policies [@rifelpet](https://github.com/rifelpet) [#12672](https://github.com/kubernetes/kops/pull/12672)
* Remove tag conditions on certain AWS IAM actions [@rifelpet](https://github.com/rifelpet) [#12674](https://github.com/kubernetes/kops/pull/12674)
* Add arch specific dev-upload-nodeup targets [@johngmyers](https://github.com/johngmyers) [#12675](https://github.com/kubernetes/kops/pull/12675)
* Fix that states AWS IAM Instance Profile blocks IAM Role [@angeloskaltsikis](https://github.com/angeloskaltsikis) [#12677](https://github.com/kubernetes/kops/pull/12677)
* Fix ELB IAM conditions (part 2) [@rifelpet](https://github.com/rifelpet) [#12680](https://github.com/kubernetes/kops/pull/12680)
* Use chrony for synchronizing time in Ubuntu [@hakman](https://github.com/hakman) [#12681](https://github.com/kubernetes/kops/pull/12681)
* Migrate to AWS CCM in k8s 1.24 [@johngmyers](https://github.com/johngmyers) [#12676](https://github.com/kubernetes/kops/pull/12676)
* Increase upup http response header timeout [@AlexLast](https://github.com/AlexLast) [#12694](https://github.com/kubernetes/kops/pull/12694)
* Include the amazonvpc logs in toolbox dump [@johngmyers](https://github.com/johngmyers) [#12690](https://github.com/kubernetes/kops/pull/12690)
* Add docs on how to assign arrays with toolbox template [@rifelpet](https://github.com/rifelpet) [#12688](https://github.com/kubernetes/kops/pull/12688)
* Ignore white space when validating IAM policy size limits [@rifelpet](https://github.com/rifelpet) [#12700](https://github.com/kubernetes/kops/pull/12700)
* Update k8s versions with latest releases. Also bump AWS Ubuntu AMI version [@MoShitrit](https://github.com/MoShitrit) [#12702](https://github.com/kubernetes/kops/pull/12702)
* Spotinst: Update `spotinst/ocean-controller` to v1.0.79 [@liranp](https://github.com/liranp) [#12706](https://github.com/kubernetes/kops/pull/12706)
* gce: don't over-warn on ManagedInstanceGroups filtering [@justinsb](https://github.com/justinsb) [#12710](https://github.com/kubernetes/kops/pull/12710)
* [calico] Add support for allow_ip_forwarding field [@zhengtianbao](https://github.com/zhengtianbao) [#12682](https://github.com/kubernetes/kops/pull/12682)
* set calico-node readiness/liveness timeout to 10s [@estahn](https://github.com/estahn) [#12713](https://github.com/kubernetes/kops/pull/12713)
* Add missing status fields to IAMIdentityMapping v1 CRD [@rifelpet](https://github.com/rifelpet) [#12716](https://github.com/kubernetes/kops/pull/12716)
* Recognize Ubuntu 22.04 (Jammy Jellyfish) [@hakman](https://github.com/hakman) [#12725](https://github.com/kubernetes/kops/pull/12725)
* Populate api-server role label on node [@justinsb](https://github.com/justinsb) [#12711](https://github.com/kubernetes/kops/pull/12711)
* refactor: move from io/ioutil to io and os packages [@Juneezee](https://github.com/Juneezee) [#12722](https://github.com/kubernetes/kops/pull/12722)
* Revert leader migration [@johngmyers](https://github.com/johngmyers) [#12726](https://github.com/kubernetes/kops/pull/12726)
* Fix render template cilium AgentPrometheusPort into a UNICODE char error [@zhengtianbao](https://github.com/zhengtianbao) [#12721](https://github.com/kubernetes/kops/pull/12721)
* Don't fail validation if Nvidia and containerRuntime defaults [@johngmyers](https://github.com/johngmyers) [#12729](https://github.com/kubernetes/kops/pull/12729)
* Watch Ingress by default when using the external-dns provider [@johngmyers](https://github.com/johngmyers) [#12692](https://github.com/kubernetes/kops/pull/12692)
* Fix out of bounds error when instance detach fails [@johngmyers](https://github.com/johngmyers) [#12698](https://github.com/kubernetes/kops/pull/12698)
* Fix use of deprecated method [@johngmyers](https://github.com/johngmyers) [#12730](https://github.com/kubernetes/kops/pull/12730)
* Update containerd to v1.6.0-beta.2 [@hakman](https://github.com/hakman) [#12720](https://github.com/kubernetes/kops/pull/12720)
* Support setting empty maps and structs [@johngmyers](https://github.com/johngmyers) [#12728](https://github.com/kubernetes/kops/pull/12728)
* Upgrade external-dns to 0.10.1 for Kubernetes >= 1.19 [@johngmyers](https://github.com/johngmyers) [#12724](https://github.com/kubernetes/kops/pull/12724)
* kops-controller should log port it is listening on [@justinsb](https://github.com/justinsb) [#12739](https://github.com/kubernetes/kops/pull/12739)
* Show additional ("addon") objects in kops get [@justinsb](https://github.com/justinsb) [#12544](https://github.com/kubernetes/kops/pull/12544)
* Add create cluster flag for enabling IRSA [@johngmyers](https://github.com/johngmyers) [#12741](https://github.com/kubernetes/kops/pull/12741)
* Do not return error when there is no error checking for cgroupfs [@olemarkus](https://github.com/olemarkus) [#12744](https://github.com/kubernetes/kops/pull/12744)
* Makefile: run codegen using go modules [@justinsb](https://github.com/justinsb) [#12748](https://github.com/kubernetes/kops/pull/12748)
* Upgrade aws-sdk-go to v1.42.5 [@johngmyers](https://github.com/johngmyers) [#12751](https://github.com/kubernetes/kops/pull/12751)
* Upgrade amazonvpc to v0.10.1 [@johngmyers](https://github.com/johngmyers) [#12752](https://github.com/kubernetes/kops/pull/12752)
* Update Go to v1.17.3 [@hakman](https://github.com/hakman) [#12753](https://github.com/kubernetes/kops/pull/12753)
* Add ingress hostname suffix configurable to kOps [@zetaab](https://github.com/zetaab) [#12699](https://github.com/kubernetes/kops/pull/12699)
* update gophercloud deps [@zetaab](https://github.com/zetaab) [#12757](https://github.com/kubernetes/kops/pull/12757)
* Shorten filenames in the asset store [@johngmyers](https://github.com/johngmyers) [#12765](https://github.com/kubernetes/kops/pull/12765)
* Add hashes for latest containerd and Docker versions [@hakman](https://github.com/hakman) [#12767](https://github.com/kubernetes/kops/pull/12767)
* Support IPv6 private topology [@johngmyers](https://github.com/johngmyers) [#12759](https://github.com/kubernetes/kops/pull/12759)
* Update containerd to v1.4.12 [@hakman](https://github.com/hakman) [#12772](https://github.com/kubernetes/kops/pull/12772)
* Allow NodeLocalDNS when defaulting to CoreDNS [@johngmyers](https://github.com/johngmyers) [#12774](https://github.com/kubernetes/kops/pull/12774)
* Migrate kube-proxy manifest to use go-runner for logging [@rifelpet](https://github.com/rifelpet) [#12712](https://github.com/kubernetes/kops/pull/12712)
* e2e tests: recognize a full KOPS_BASE_URL as a KOPS_VERSION [@justinsb](https://github.com/justinsb) [#12778](https://github.com/kubernetes/kops/pull/12778)
* Stable-sort subnets by Name [@justinsb](https://github.com/justinsb) [#12780](https://github.com/kubernetes/kops/pull/12780)
* Bump etcd manager to 20211117 [@justinsb](https://github.com/justinsb) [#12763](https://github.com/kubernetes/kops/pull/12763)
* Bump node local dns cache [@olemarkus](https://github.com/olemarkus) [#12783](https://github.com/kubernetes/kops/pull/12783)
* Bump nvidia device plugin to 0.10.0 [@olemarkus](https://github.com/olemarkus) [#12784](https://github.com/kubernetes/kops/pull/12784)
* Bump cert-manager addon and godep to 1.6.1 [@olemarkus](https://github.com/olemarkus) [#12777](https://github.com/kubernetes/kops/pull/12777)
* Fix AWS authentication separator to support multiple objects [@justinsb](https://github.com/justinsb) [#12790](https://github.com/kubernetes/kops/pull/12790)
* Fix volume ratio comparisons [@olemarkus](https://github.com/olemarkus) [#12791](https://github.com/kubernetes/kops/pull/12791)
* Remove warning about IPv6 being experimental [@hakman](https://github.com/hakman) [#12787](https://github.com/kubernetes/kops/pull/12787)
* Update containerd to v1.6.0-beta.3 [@hakman](https://github.com/hakman) [#12795](https://github.com/kubernetes/kops/pull/12795)
* Release notes for 1.22.2 [@johngmyers](https://github.com/johngmyers) [#12801](https://github.com/kubernetes/kops/pull/12801)
* Release notes for 1.21.4 [@johngmyers](https://github.com/johngmyers) [#12802](https://github.com/kubernetes/kops/pull/12802)
* gossip: support resolution of k8s.local names from pods (via services) [@justinsb](https://github.com/justinsb) [#12792](https://github.com/kubernetes/kops/pull/12792)
* Use dualstack endpoint for s3 [@olemarkus](https://github.com/olemarkus) [#12743](https://github.com/kubernetes/kops/pull/12743)
* Update channels [@hakman](https://github.com/hakman) [#12806](https://github.com/kubernetes/kops/pull/12806)
* Rename fields to fit acronym conventions [@johngmyers](https://github.com/johngmyers) [#12811](https://github.com/kubernetes/kops/pull/12811)
* GCE: Fix race around route deletion [@justinsb](https://github.com/justinsb) [#12737](https://github.com/kubernetes/kops/pull/12737)
* Webhook Update cluster_spec.md [@krishna2603](https://github.com/krishna2603) [#12813](https://github.com/kubernetes/kops/pull/12813)
* Bump cilium to 1.10.5 [@olemarkus](https://github.com/olemarkus) [#12814](https://github.com/kubernetes/kops/pull/12814)
* Update Flannel CNI to v0.15.1 [@shamil](https://github.com/shamil) [#12818](https://github.com/kubernetes/kops/pull/12818)
* Check that there are extra fields and not fields explicitly false [@olemarkus](https://github.com/olemarkus) [#12804](https://github.com/kubernetes/kops/pull/12804)
* Add NodeProblemDetector clusterRoleBinding [@zhengtianbao](https://github.com/zhengtianbao) [#12819](https://github.com/kubernetes/kops/pull/12819)
* Add missing namespaces for addon templates [@GMartinez-Sisti](https://github.com/GMartinez-Sisti) [#12820](https://github.com/kubernetes/kops/pull/12820)
* Bump EBS CSI driver to 1.5.0 [@olemarkus](https://github.com/olemarkus) [#12782](https://github.com/kubernetes/kops/pull/12782)
* Add nodeProblemDetector daemonset serviceAccountName [@zhengtianbao](https://github.com/zhengtianbao) [#12822](https://github.com/kubernetes/kops/pull/12822)
* Upgrade aws-sdk-go to v1.42.11 [@johngmyers](https://github.com/johngmyers) [#12823](https://github.com/kubernetes/kops/pull/12823)
* Add support for --dns flag in Docker config [@jwolski2](https://github.com/jwolski2) [#12789](https://github.com/kubernetes/kops/pull/12789)
* Update Calico to v3.21.1 [@hakman](https://github.com/hakman) [#12708](https://github.com/kubernetes/kops/pull/12708)
* Update Canal to v3.21.1 [@hakman](https://github.com/hakman) [#12709](https://github.com/kubernetes/kops/pull/12709)
* Add release note warning about the v1alpha3 API [@johngmyers](https://github.com/johngmyers) [#12831](https://github.com/kubernetes/kops/pull/12831)
* Migrate to AWS CCM in k8s 1.24 [@johngmyers](https://github.com/johngmyers) [#12830](https://github.com/kubernetes/kops/pull/12830)
* Rename fields to fit acronym conventions [@johngmyers](https://github.com/johngmyers) [#12816](https://github.com/kubernetes/kops/pull/12816)
* Change DisableSubnetTags to tagSubnets [@johngmyers](https://github.com/johngmyers) [#12832](https://github.com/kubernetes/kops/pull/12832)
* Promote alpha channel to stable [@hakman](https://github.com/hakman) [#12807](https://github.com/kubernetes/kops/pull/12807)
* Add support for etcd v3.5.1 [@hakman](https://github.com/hakman) [#12826](https://github.com/kubernetes/kops/pull/12826)
* Skip SCTP test on cilium clusters in k8s 1.24 as well [@rifelpet](https://github.com/rifelpet) [#12838](https://github.com/kubernetes/kops/pull/12838)
* Fix enabling of AWS CCM [@johngmyers](https://github.com/johngmyers) [#12837](https://github.com/kubernetes/kops/pull/12837)
* Fix upgrade tests with dest kOps version < 1.22 [@johngmyers](https://github.com/johngmyers) [#12839](https://github.com/kubernetes/kops/pull/12839)
* Pin the aws-lb-controller scenario to k8s 1.21 [@johngmyers](https://github.com/johngmyers) [#12840](https://github.com/kubernetes/kops/pull/12840)
* Change title of iam_roles.md to be specific to instance IAM roles [@johngmyers](https://github.com/johngmyers) [#12845](https://github.com/kubernetes/kops/pull/12845)
* Route NAT64 to NAT Gateway in IPv6 private topology [@johngmyers](https://github.com/johngmyers) [#12842](https://github.com/kubernetes/kops/pull/12842)
* Enable DNS64 in CoreDNS if IPv6 enabled [@johngmyers](https://github.com/johngmyers) [#12766](https://github.com/kubernetes/kops/pull/12766)
* Invert sense of negative-option settings in v1alpha3 [@johngmyers](https://github.com/johngmyers) [#12835](https://github.com/kubernetes/kops/pull/12835)
* Use AWS metadata to retrieve local-hostname in nodeup [@bwagner5](https://github.com/bwagner5) [#12844](https://github.com/kubernetes/kops/pull/12844)
* Fix e2e scenario tests [@johngmyers](https://github.com/johngmyers) [#12847](https://github.com/kubernetes/kops/pull/12847)
* Open nodeport to IPv6 in e2e tests [@johngmyers](https://github.com/johngmyers) [#12848](https://github.com/kubernetes/kops/pull/12848)
* Route NAT64 to NAT Gateway in IPv6 public topology [@johngmyers](https://github.com/johngmyers) [#12843](https://github.com/kubernetes/kops/pull/12843)
* Use NAT64 instead of dual-stack for AWS EBS CSI driver [@hakman](https://github.com/hakman) [#12850](https://github.com/kubernetes/kops/pull/12850)
* Reissue client keypairs on issuer change [@johngmyers](https://github.com/johngmyers) [#12846](https://github.com/kubernetes/kops/pull/12846)
* Remove more non-configurable settings from v1alpha3 [@johngmyers](https://github.com/johngmyers) [#12849](https://github.com/kubernetes/kops/pull/12849)
* Update IPv6 documentation [@johngmyers](https://github.com/johngmyers) [#12852](https://github.com/kubernetes/kops/pull/12852)
* Revert "Open nodeport to IPv6 in e2e tests" [@johngmyers](https://github.com/johngmyers) [#12854](https://github.com/kubernetes/kops/pull/12854)
* Support NodeLocalDNS on IPv6 clusters [@johngmyers](https://github.com/johngmyers) [#12851](https://github.com/kubernetes/kops/pull/12851)
* Fix upgrade tests to kops version < 1.22 [@johngmyers](https://github.com/johngmyers) [#12856](https://github.com/kubernetes/kops/pull/12856)
* Make requests and limits be *resource.Quantity [@johngmyers](https://github.com/johngmyers) [#12857](https://github.com/kubernetes/kops/pull/12857)
* Stop skipping snapshot fields tests in EBS CSI e2e [@rifelpet](https://github.com/rifelpet) [#12531](https://github.com/kubernetes/kops/pull/12531)
* Remove redundant evaluation of hostnameOverride [@olemarkus](https://github.com/olemarkus) [#12858](https://github.com/kubernetes/kops/pull/12858)
* images: use k8s-staging-test-infra/gcb-docker-gcloud [@spiffxp](https://github.com/spiffxp) [#12859](https://github.com/kubernetes/kops/pull/12859)
* images: fix invalid k8s-staging-test-infra/gcb-docker-gcloud tag [@spiffxp](https://github.com/spiffxp) [#12861](https://github.com/kubernetes/kops/pull/12861)
* GCE: fix for metadata-proxy on cilium [@justinsb](https://github.com/justinsb) [#12866](https://github.com/kubernetes/kops/pull/12866)
* [Digital Ocean] Fix load balancer retry logic while retrieving ip [@srikiz](https://github.com/srikiz) [#12758](https://github.com/kubernetes/kops/pull/12758)
* Spotinst: Update spotinst/ocean-controller to v1.0.80 [@liranp](https://github.com/liranp) [#12868](https://github.com/kubernetes/kops/pull/12868)
* Add GCP PD CSI driver addon [@rifelpet](https://github.com/rifelpet) [#12812](https://github.com/kubernetes/kops/pull/12812)
* Fix area/provider/gcp GitHub label assignment [@rifelpet](https://github.com/rifelpet) [#12871](https://github.com/kubernetes/kops/pull/12871)
* Add gofumpt scripts [@hakman](https://github.com/hakman) [#12867](https://github.com/kubernetes/kops/pull/12867)
* Remove unused StorageBucketIam GCE task [@rifelpet](https://github.com/rifelpet) [#12869](https://github.com/kubernetes/kops/pull/12869)
* Don't assign CIDRs to shared subnets [@johngmyers](https://github.com/johngmyers) [#12863](https://github.com/kubernetes/kops/pull/12863)
* Add labels to GCE instance templates [@rifelpet](https://github.com/rifelpet) [#12870](https://github.com/kubernetes/kops/pull/12870)
* Rename imageName to image in v1alpha3 [@johngmyers](https://github.com/johngmyers) [#12872](https://github.com/kubernetes/kops/pull/12872)
* Use v1 certificate for snapshot-validation-service [@olemarkus](https://github.com/olemarkus) [#12874](https://github.com/kubernetes/kops/pull/12874)
* tests gce: fix project arg on gsutil rm [@justinsb](https://github.com/justinsb) [#12875](https://github.com/kubernetes/kops/pull/12875)
* Remove support for CentOS 8 [@johngmyers](https://github.com/johngmyers) [#12877](https://github.com/kubernetes/kops/pull/12877)
* If RBN, use IPv6 address instead of IPv4 [@olemarkus](https://github.com/olemarkus) [#12878](https://github.com/kubernetes/kops/pull/12878)
* Support GSFS Terraform Managed Files [@rifelpet](https://github.com/rifelpet) [#12121](https://github.com/kubernetes/kops/pull/12121)
* Rename bastionPublicName in v1alpha3 API [@johngmyers](https://github.com/johngmyers) [#12876](https://github.com/kubernetes/kops/pull/12876)
* Remove support for old distros [@hakman](https://github.com/hakman) [#12882](https://github.com/kubernetes/kops/pull/12882)
* Update k8s dependencies to v1.23.0-rc.0 [@hakman](https://github.com/hakman) [#12883](https://github.com/kubernetes/kops/pull/12883)
* Add terraform integration test for dedicated apiserver nodes [@rifelpet](https://github.com/rifelpet) [#12884](https://github.com/kubernetes/kops/pull/12884)
* Update k8s dependencies to v1.23.0-rc.1 [@hakman](https://github.com/hakman) [#12888](https://github.com/kubernetes/kops/pull/12888)
* Allow setting cilium 1.11 [@olemarkus](https://github.com/olemarkus) [#12887](https://github.com/kubernetes/kops/pull/12887)
* gce: Add network & subnet to toolbox dump [@justinsb](https://github.com/justinsb) [#12889](https://github.com/kubernetes/kops/pull/12889)
* GCE: Support kops-controller, including in gossip mode [@justinsb](https://github.com/justinsb) [#12742](https://github.com/kubernetes/kops/pull/12742)
* Use instance ID as node name when AWS CCM supports it [@johngmyers](https://github.com/johngmyers) [#12862](https://github.com/kubernetes/kops/pull/12862)
* Update Go to v1.17.4 [@hakman](https://github.com/hakman) [#12896](https://github.com/kubernetes/kops/pull/12896)
* enable connection-draining for aws classic lb [@heybronson](https://github.com/heybronson) [#12881](https://github.com/kubernetes/kops/pull/12881)
* Simplify Flatcar containerd exec command [@pothos](https://github.com/pothos) [#12900](https://github.com/kubernetes/kops/pull/12900)
* pkg/apis/kops: Allow configuring dockerd --max-* upload and download concurrency and retry options. [@anthonyrisinger](https://github.com/anthonyrisinger) [#12320](https://github.com/kubernetes/kops/pull/12320)
* Upgrade node-cache to 1.21.3 [@johngmyers](https://github.com/johngmyers) [#12904](https://github.com/kubernetes/kops/pull/12904)
* Fix external-dns service name [@johngmyers](https://github.com/johngmyers) [#12893](https://github.com/kubernetes/kops/pull/12893)
* Fix error applying AWS CCM leader migration [@hakman](https://github.com/hakman) [#12907](https://github.com/kubernetes/kops/pull/12907)
* Update k8s dependencies to v1.23.0 [@hakman](https://github.com/hakman) [#12908](https://github.com/kubernetes/kops/pull/12908)
* Cleanup GCE loadbalancers created by k8s [@zetaab](https://github.com/zetaab) [#12894](https://github.com/kubernetes/kops/pull/12894)
* Set DNS PDB to a maxUnavailable percentage [@heybronson](https://github.com/heybronson) [#12915](https://github.com/kubernetes/kops/pull/12915)
* Update aws-load-balancer-controller to v2.3.1 [@hakman](https://github.com/hakman) [#12920](https://github.com/kubernetes/kops/pull/12920)
* e2e: fix test flakes where we specify a non-schedulable zone [@justinsb](https://github.com/justinsb) [#12891](https://github.com/kubernetes/kops/pull/12891)
* Ignore InvalidAction errors when tagging IAM Instance Profiles [@rifelpet](https://github.com/rifelpet) [#12629](https://github.com/kubernetes/kops/pull/12629)

## 1.23.0-beta.1 to 1.23.0-beta.2

* Drop support for Weave as of k8s 1.23 [@johngmyers](https://github.com/johngmyers) [#12941](https://github.com/kubernetes/kops/pull/12941)
* Make service topology for cilium configurable [@olemarkus](https://github.com/olemarkus) [#12918](https://github.com/kubernetes/kops/pull/12918)
* Update Go to v1.17.5 [@hakman](https://github.com/hakman) [#12954](https://github.com/kubernetes/kops/pull/12954)
* Update controller-runtime to v0.11.0 [@hakman](https://github.com/hakman) [#12967](https://github.com/kubernetes/kops/pull/12967)
* Update containerd to v1.6.0-beta.4 [@hakman](https://github.com/hakman) [#12968](https://github.com/kubernetes/kops/pull/12968)
* Ignore images hosted in private ECR repositories as containerd cannot pull these [@olemarkus](https://github.com/olemarkus) [#13000](https://github.com/kubernetes/kops/pull/13000)
* Prevent creation of unsupported etcd clusters [@olemarkus](https://github.com/olemarkus) [#13011](https://github.com/kubernetes/kops/pull/13011)
* Update k8s dependencies to v1.23.1 [@hakman](https://github.com/hakman) [#13022](https://github.com/kubernetes/kops/pull/13022)
* Remove TerraformJSON feature flag [@rifelpet](https://github.com/rifelpet) [#13029](https://github.com/kubernetes/kops/pull/13029)
* Add managed-by label to static kube-proxy pods [@olemarkus](https://github.com/olemarkus) [#13039](https://github.com/kubernetes/kops/pull/13039)
* Kube components log to stdout [@olemarkus](https://github.com/olemarkus) [#13038](https://github.com/kubernetes/kops/pull/13038)
* external CCM for GCE [@jiahuif](https://github.com/jiahuif) [#13017](https://github.com/kubernetes/kops/pull/13017)
* Fix OpenStack SecurityGroupRule/LB When CIDR is IPv6 [@iGene](https://github.com/iGene) [#13032](https://github.com/kubernetes/kops/pull/13032)
* update deps [@zetaab](https://github.com/zetaab) [#13048](https://github.com/kubernetes/kops/pull/13048)
* Migrate to GCE CCM in k8s 1.24 [@johngmyers](https://github.com/johngmyers) [#13045](https://github.com/kubernetes/kops/pull/13045)
* Bump Cluster Autoscaler and update manifest [@olemarkus](https://github.com/olemarkus) [#13050](https://github.com/kubernetes/kops/pull/13050)
* Remove the v1alpha3 API version [@johngmyers](https://github.com/johngmyers) [#13054](https://github.com/kubernetes/kops/pull/13054)
* force update dependencies [@zetaab](https://github.com/zetaab) [#13056](https://github.com/kubernetes/kops/pull/13056)
* Add action for automatically tagging releases [@johngmyers](https://github.com/johngmyers) [#12805](https://github.com/kubernetes/kops/pull/12805)
* Bump external-snapshotted to v5.0.0 [@olemarkus](https://github.com/olemarkus) [#13067](https://github.com/kubernetes/kops/pull/13067)
* Support price and priority cluster-autoscaler expanders [@danports](https://github.com/danports) [#13081](https://github.com/kubernetes/kops/pull/13081)
* Update containerd to v1.6.0-beta.5 [@hakman](https://github.com/hakman) [#13084](https://github.com/kubernetes/kops/pull/13084)
* Don't try to add node name to instances without node object [@olemarkus](https://github.com/olemarkus) [#13106](https://github.com/kubernetes/kops/pull/13106)
* Do not create an IAM role for dns-controller on gossip clusters [@olemarkus](https://github.com/olemarkus) [#13110](https://github.com/kubernetes/kops/pull/13110)
* fix ipv4+ipv6 sec groups/listeners in OpenStack [@zetaab](https://github.com/zetaab) [#13093](https://github.com/kubernetes/kops/pull/13093)
* Create helper function for ec2 create/tag-on-create IAM permissions [@olemarkus](https://github.com/olemarkus) [#13104](https://github.com/kubernetes/kops/pull/13104)
* Add DescribeRegions to nodeup privs [@olemarkus](https://github.com/olemarkus) [#13114](https://github.com/kubernetes/kops/pull/13114)
* Update to aws-sdk-go to v1.42.37 [@jinhong-](https://github.com/jinhong-) [#13132](https://github.com/kubernetes/kops/pull/13132)
* expose external ccm metrics for OpenStack [@zetaab](https://github.com/zetaab) [#13131](https://github.com/kubernetes/kops/pull/13131)
* OpenStack - Add loadbalancer pool monitor to API LB [@zetaab](https://github.com/zetaab) [#13096](https://github.com/kubernetes/kops/pull/13096)
* Bump CCM images [@olemarkus](https://github.com/olemarkus) [#13143](https://github.com/kubernetes/kops/pull/13143)
* Don't set unsupported configs by default [@olemarkus](https://github.com/olemarkus) [#13111](https://github.com/kubernetes/kops/pull/13111)
* Update pause image to v3.6 [@hakman](https://github.com/hakman) [#13125](https://github.com/kubernetes/kops/pull/13125)
* Bump etcd-manager to v3.0.20220128 [@olemarkus](https://github.com/olemarkus) [#13158](https://github.com/kubernetes/kops/pull/13158)
* JWKS / IRSA: Expose public ACLs to terraform [@justinsb](https://github.com/justinsb) [#13166](https://github.com/kubernetes/kops/pull/13166)
* add node-drain-timeout flag to rolling-update [@heybronson](https://github.com/heybronson) [#13103](https://github.com/kubernetes/kops/pull/13103)
* Use etcd-manager pre-release until final release has been cut [@olemarkus](https://github.com/olemarkus) [#13183](https://github.com/kubernetes/kops/pull/13183)
* Update Calico and Canal to v3.21.2 [@hakman](https://github.com/hakman) [#12951](https://github.com/kubernetes/kops/pull/12951)
* Fix etcd-manager for ipv6 [@olemarkus](https://github.com/olemarkus) [#13191](https://github.com/kubernetes/kops/pull/13191)
* Update containerd to v1.6.0-rc.2 [@hakman](https://github.com/hakman) [#13198](https://github.com/kubernetes/kops/pull/13198)
* Remove tag condition on listeners [@olemarkus](https://github.com/olemarkus) [#13123](https://github.com/kubernetes/kops/pull/13123)
* use 1.23.1 ccm for openstack [@zetaab](https://github.com/zetaab) [#13136](https://github.com/kubernetes/kops/pull/13136)
* Remove snapshot controller dependency on ebs csi driver [@olemarkus](https://github.com/olemarkus) [#13213](https://github.com/kubernetes/kops/pull/13213)
* Fix CSI migration feature gates [@olemarkus](https://github.com/olemarkus) [#13203](https://github.com/kubernetes/kops/pull/13203)
* Update containerd to v1.6.0-rc.3 [@hakman](https://github.com/hakman) [#13224](https://github.com/kubernetes/kops/pull/13224)
* Always enable Leader Election for cloud-controller-manager [@jiahuif](https://github.com/jiahuif) [#13187](https://github.com/kubernetes/kops/pull/13187)
* always enable Leader Election for openstack CCM [@jiahuif](https://github.com/jiahuif) [#13220](https://github.com/kubernetes/kops/pull/13220)
* [Issue-12293] Fix json output to keep it consistent for single or multiple objects [@srikiz](https://github.com/srikiz) [#13188](https://github.com/kubernetes/kops/pull/13188)
* Fix irsa for k8s < 1.20 [@olemarkus](https://github.com/olemarkus) [#13212](https://github.com/kubernetes/kops/pull/13212)
* Add support for graceful node shutdown [@olemarkus](https://github.com/olemarkus) [#12994](https://github.com/kubernetes/kops/pull/12994)
* Install runc from opencontainers/runc [@hakman](https://github.com/hakman) [#13240](https://github.com/kubernetes/kops/pull/13240)
* Do not enable graceful shutdown if k8s version < 1.21 [@olemarkus](https://github.com/olemarkus) [#13242](https://github.com/kubernetes/kops/pull/13242)
* Install contained from the release package  [@hakman](https://github.com/hakman) [#13248](https://github.com/kubernetes/kops/pull/13248)
* Bump AWS CNI to 1.10.2 [@MoShitrit](https://github.com/MoShitrit),[@hakman](https://github.com/hakman) [#13228](https://github.com/kubernetes/kops/pull/13228)
* Update containerd to v1.6.0 [@hakman](https://github.com/hakman) [#13262](https://github.com/kubernetes/kops/pull/13262)
* Update LBC to 2.4.0 [@olemarkus](https://github.com/olemarkus) [#13267](https://github.com/kubernetes/kops/pull/13267)
* Disable some flags in kube-apiserver when logging-format is not text [@h3poteto](https://github.com/h3poteto) [#13264](https://github.com/kubernetes/kops/pull/13264)
* Enable RBN with AWS CCM 1.22.0-alpha.1 [@johngmyers](https://github.com/johngmyers) [#13268](https://github.com/kubernetes/kops/pull/13268)
* Improve HA for various addons [@olemarkus](https://github.com/olemarkus) [#13027](https://github.com/kubernetes/kops/pull/13027)
* Allow PrefixList for sshAccess and kubernetesApiAccess [@hierynomus](https://github.com/hierynomus) [#13113](https://github.com/kubernetes/kops/pull/13113)
* Validate taints in IG spec [@olemarkus](https://github.com/olemarkus) [#13266](https://github.com/kubernetes/kops/pull/13266)
* Add missing permissions to aws lbc for irsa [@olemarkus](https://github.com/olemarkus) [#13280](https://github.com/kubernetes/kops/pull/13280)
* Do not create a cert-manager namespace [@olemarkus](https://github.com/olemarkus) [#13284](https://github.com/kubernetes/kops/pull/13284)
* [DigitalOcean] Implement new VPC if network-cidr flag is specified [@srikiz](https://github.com/srikiz) [#13060](https://github.com/kubernetes/kops/pull/13060)
* Release 1.23.0-beta.2 [@justinsb](https://github.com/justinsb) [#13302](https://github.com/kubernetes/kops/pull/13302)

## 1.23.0-beta.2 to 1.23.0

* Update to etcd-manager v3.0.20220203 [@justinsb](https://github.com/justinsb) [#13196](https://github.com/kubernetes/kops/pull/13196)
* use own function to define CSI image version [@zetaab](https://github.com/zetaab) [#13311](https://github.com/kubernetes/kops/pull/13311)
* Add support for ed25519 keys in AWS [@aclevername](https://github.com/aclevername) [#13304](https://github.com/kubernetes/kops/pull/13304)
* Backport of #13176: Add support to install EKS Pod Identity Webhook [@h3poteto](https://github.com/h3poteto),[@olemarkus](https://github.com/olemarkus) [#13315](https://github.com/kubernetes/kops/pull/13315)
* Bump AWS SDK to v1.43.11 [@olemarkus](https://github.com/olemarkus) [#13322](https://github.com/kubernetes/kops/pull/13322)
* Update containerd to v1.6.1 [@hakman](https://github.com/hakman) [#13325](https://github.com/kubernetes/kops/pull/13325)
* Use proper image and add health check [@olemarkus](https://github.com/olemarkus) [#13328](https://github.com/kubernetes/kops/pull/13328)
* Append policy config map arguments only if UsePolicyConfigmap is true [@vivekjainx86](https://github.com/vivekjainx86) [#13308](https://github.com/kubernetes/kops/pull/13308)

## 1.23.0 to 1.23.1

* Add missing permissions to aws lbc for IP targeting [@olemarkus](https://github.com/olemarkus) [#13369](https://github.com/kubernetes/kops/pull/13369)
* Add protocol explicitly to services [@olemarkus](https://github.com/olemarkus) [#13383](https://github.com/kubernetes/kops/pull/13383)
* If kubetest2 fails cluster validation, we run down before exiting [@olemarkus](https://github.com/olemarkus) [#13373](https://github.com/kubernetes/kops/pull/13373)
* Allow duplicate taint keys [@olemarkus](https://github.com/olemarkus) [#13366](https://github.com/kubernetes/kops/pull/13366)
* Fix long role names [@olemarkus](https://github.com/olemarkus) [#13364](https://github.com/kubernetes/kops/pull/13364)
* update k8s dependencies [@heybronson](https://github.com/heybronson) [#13397](https://github.com/kubernetes/kops/pull/13397)
* Update golangci-lint to v1.45.0  [@hakman](https://github.com/hakman) [#13403](https://github.com/kubernetes/kops/pull/13403)
* Correctly detect GovCloud regions [@mixja](https://github.com/mixja) [#13410](https://github.com/kubernetes/kops/pull/13410)
* Do not return a '-1' exit if no keys found and json/yaml output [@hierynomus](https://github.com/hierynomus) [#13378](https://github.com/kubernetes/kops/pull/13378)
* Tag on create for remaining CCM privileges [@olemarkus](https://github.com/olemarkus) [#12911](https://github.com/kubernetes/kops/pull/12911)
* Update containerd to v1.6.2 [@hakman](https://github.com/hakman) [#13455](https://github.com/kubernetes/kops/pull/13455)
* Add back hash for containerd v1.6.1 [@hakman](https://github.com/hakman) [#13462](https://github.com/kubernetes/kops/pull/13462)
* Enable etcd corruption check as mitigatio of 3.5 corruption issue [@olemarkus](https://github.com/olemarkus) [#13454](https://github.com/kubernetes/kops/pull/13454)
* Pick the right OS server group when creating cloud groups [@ederst](https://github.com/ederst) [#13461](https://github.com/kubernetes/kops/pull/13461)
* Only delete node object on GCE [@olemarkus](https://github.com/olemarkus) [#13289](https://github.com/kubernetes/kops/pull/13289)
* Bump AWS CNI to version 1.10.3 [@MoShitrit](https://github.com/MoShitrit) [#13488](https://github.com/kubernetes/kops/pull/13488)
* Update Calico and Canal to v3.21.5 [@hakman](https://github.com/hakman) [#13497](https://github.com/kubernetes/kops/pull/13497)
* Update to etcd-manager 3.0.20220417 [@justinsb](https://github.com/justinsb) [#13499](https://github.com/kubernetes/kops/pull/13499)
* Revert "Enable etcd corruption check" [@hakman](https://github.com/hakman) [#13495](https://github.com/kubernetes/kops/pull/13495)
* etcd 3 5 3 [@justinsb](https://github.com/justinsb) [#13501](https://github.com/kubernetes/kops/pull/13501)
* Bump CCM 1.22 and 1.23 images to stable versions [@olemarkus](https://github.com/olemarkus) [#13506](https://github.com/kubernetes/kops/pull/13506)
* Update aws-sdk-go to v1.43.41 [@hakman](https://github.com/hakman) [#13515](https://github.com/kubernetes/kops/pull/13515)
* Revert to using 1.23.0-alpha.0 for AWS CCM [@hakman](https://github.com/hakman) [#13514](https://github.com/kubernetes/kops/pull/13514)
* add cluster autoscaler pod annotations [@heybronson](https://github.com/heybronson) [#13511](https://github.com/kubernetes/kops/pull/13511)

## 1.23.1 to 1.23.2

* Use expected pointer type in type assertion when iterating over GS ACLs [@tesspib](https://github.com/tesspib) [#13534](https://github.com/kubernetes/kops/pull/13534)
* Allow cluster autoscaler to read EC2 instance types to build catalog dynamically [@seh](https://github.com/seh) [#13532](https://github.com/kubernetes/kops/pull/13532)
* Update Go to v1.17.9 [@hakman](https://github.com/hakman) [#13551](https://github.com/kubernetes/kops/pull/13551)
* Add back support for Ubuntu 18.04 [@hakman](https://github.com/hakman) [#13557](https://github.com/kubernetes/kops/pull/13557)
* Update Canal's Flannel to v0.15.1 [@tesspib](https://github.com/tesspib) [#13562](https://github.com/kubernetes/kops/pull/13562)
* Include sysctls in toolbox dump [@rifelpet](https://github.com/rifelpet) [#13570](https://github.com/kubernetes/kops/pull/13570)
* Add support for Rocky Linux 8 [@hakman](https://github.com/hakman) [#13559](https://github.com/kubernetes/kops/pull/13559)
* Fix OIDC Provider cleanup [@rifelpet](https://github.com/rifelpet) [#13571](https://github.com/kubernetes/kops/pull/13571)
* Update containerd to v1.6.3 [@hakman](https://github.com/hakman) [#13578](https://github.com/kubernetes/kops/pull/13578)
* Re-add net.bridge settings for flannel [@rifelpet](https://github.com/rifelpet) [#13564](https://github.com/kubernetes/kops/pull/13564)
* Revert containerd v1.6.3 upgrade [@rifelpet](https://github.com/rifelpet) [#13582](https://github.com/kubernetes/kops/pull/13582)
* Fix unexpected type for object metadata when using gossip DNS [@hakman](https://github.com/hakman) [#13592](https://github.com/kubernetes/kops/pull/13592)
* Update containerd to v1.6.4 [@hakman](https://github.com/hakman) [#13596](https://github.com/kubernetes/kops/pull/13596)
* Update etcd-manager to v3.0.20220503 [@hakman](https://github.com/hakman) [#13598](https://github.com/kubernetes/kops/pull/13598)
* Add hashes for containerd and Docker in order to fix CVE-2022-23648 [@drequena](https://github.com/drequena) [#13606](https://github.com/kubernetes/kops/pull/13606)
* Avoid "/etc/resolv.conf" file loopback for Flatcar Container Linux distribution [@seh](https://github.com/seh) [#13617](https://github.com/kubernetes/kops/pull/13617)

## 1.23.2 to 1.23.3

* Increase timeout for pushing binaries to staging [@hakman](https://github.com/hakman) [#13633](https://github.com/kubernetes/kops/pull/13633)
* Update runc to v1.1.2 [@hakman](https://github.com/hakman) [#13638](https://github.com/kubernetes/kops/pull/13638)
* Add a nameservers parameter for cert-manager. [@jim-barber-he](https://github.com/jim-barber-he) [#13567](https://github.com/kubernetes/kops/pull/13567)
* Remove unused DNS logic from Protokube [@hakman](https://github.com/hakman) [#13689](https://github.com/kubernetes/kops/pull/13689)
* Fix Protokube gossip flag [@hakman](https://github.com/hakman) [#13692](https://github.com/kubernetes/kops/pull/13692)
* Add support for setting mode field on file assets [@yurrriq](https://github.com/yurrriq) [#13715](https://github.com/kubernetes/kops/pull/13715)
* Update containerd and Docker versions [@hakman](https://github.com/hakman) [#13741](https://github.com/kubernetes/kops/pull/13741)
* Fix API group name for ingresses in DNS Controller [@julienperignon](https://github.com/julienperignon) [#13750](https://github.com/kubernetes/kops/pull/13750)
* Update runc to v1.1.3 [@hakman](https://github.com/hakman) [#13763](https://github.com/kubernetes/kops/pull/13763)
* Update AWS CCM images for k8s 1.20-1.22 [@hakman](https://github.com/hakman) [#13748](https://github.com/kubernetes/kops/pull/13748)
* Avoid spurious changes with ed25519 keys [@hakman](https://github.com/hakman) [#13774](https://github.com/kubernetes/kops/pull/13774)
* Update etcd-manager to v3.0.20220617 [@hakman](https://github.com/hakman) [#13824](https://github.com/kubernetes/kops/pull/13824)
* Mount /etc/hosts from host for CoreDNS [@hakman](https://github.com/hakman) [#13922](https://github.com/kubernetes/kops/pull/13922)
* Update etcd-manager to v3.0.20220717 [@hakman](https://github.com/hakman) [#13990](https://github.com/kubernetes/kops/pull/13990)
* Update Go to v1.17.12 for kOps 1.23 [@hakman](https://github.com/hakman) [#13997](https://github.com/kubernetes/kops/pull/13997)
* Switch to latest MacOS version for CI [@hakman](https://github.com/hakman) [#14015](https://github.com/kubernetes/kops/pull/14015)
* Revert to using instance private DNS name to lookup hostname [@hakman](https://github.com/hakman) [#14024](https://github.com/kubernetes/kops/pull/14024)
* Check keyset existence before attempting to distrust [@yurrriq](https://github.com/yurrriq) [#14041](https://github.com/kubernetes/kops/pull/14041)
* Fix SIGSEGV when deleting a Hetzner instance [@hakman](https://github.com/hakman) [#14046](https://github.com/kubernetes/kops/pull/14046)
