// SPDX-License-Identifier: Apache-2.0
// Copyright Authors of K9s

package slogs

const (
	// Error tracks an error logger key.
	Error = "error"

	// Stack tracks a stack logger key.
	Stack = "stack"

	// Subsys tracks a subsystem logger key.
	Subsys = "subsys"

	// SchemaFile tracks a schema file logger key.
	SchemaFile = "schema-file"

	// RefType tracks a reference type.
	RefType = "ref-type"

	// GVR tracks a group version resource logger key.
	GVR = "gvr"

	// AuthorSpec tracks an author spec logger key.
	AuthSpec = "auth-spec"

	// AuthStatus tracks an auth status logger key.
	AuthStatus = "auth-status"

	// AuthReason tracks an auth reason logger key.
	AuthReason = "auth-reason"

	// Ports tracks a ports logger key.
	Port = "port"

	// Address tracks an address logger key.
	Address = "address"

	// ResName tracks a resource name logger key.
	ResName = "res-name"

	// Verb tracks a verb logger key.
	Verb = "verb"

	// ResType tracks a resource type logger key.
	ResType = "res-type"

	// View tracks a view logger key.
	View = "view"

	// GOR tracks a gor logger key.
	GOR = "gor"

	// Shortcut tracks a shortcut logger key.
	Shortcut = "shortcut"

	// Page tracks a page logger key.
	Page = "page"

	// Skin tracks a skin logger key.
	Skin = "skin"

	// CmdHist tracks a command history logger key.
	CmdHist = "cmd-hist"

	// Image tracks an image logger key.
	Image = "image"

	// FQN tracks a fully qualified name logger key.
	FQN = "fqn"

	// ConfigName tracks a config name logger key.
	ConfigName = "config-name"

	// CompName tracks a component name logger key.
	CompName = "comp-name"

	// Command tracks a command logger key.
	Command = "cmd"

	// Context tracks a context logger key.
	Context = "context"
	// Cluster tracks a cluster logger key.
	Cluster = "cluster"

	// Container tracks a container logger key.
	Container = "container"

	// Options tracks an options logger key.
	Options = "options"

	// Count tracks a count logger key.
	Count = "count"

	// MaxRetries tracks a max retries logger key.
	MaxRetries = "max-retries"

	// Retry tracks a retry logger key.
	Retry = "retry"

	// Message tracks a message logger key.
	Message = "message"

	// Index tracks an index logger key.
	Index = "index"

	// Path tracks a path logger key.
	Path = "path"

	// Dir tracks a directory logger key.
	Dir = "dir"

	// FileName tracks a file name logger key.
	FileName = "file-name"

	// Key tracks a key logger key.
	Key = "key"

	// Plugin tracks a plugin logger key.
	Plugin = "plugin"

	// Component tracks a component logger key.
	Component = "component"

	// RowID tracks a row id logger key.
	RowID = "row-id"

	// Cell tracks a cell logger key.
	Cell = "cell"

	// HeaderSize tracks a header size logger key.
	HeaderSize = "row-size"

	// Namespace tracks a namespace logger key.
	Namespace = "ns"

	// AllNS tracks all namespaces logger key.
	AllNS = "all-ns"

	// Max tracks a max logger key.
	Max = "max"

	// Elapsed tracks an elapsed logger key.
	Elapsed = "elapsed"

	// Log tracks a log logger key.
	Log = "log"

	// Annotation tracks an annotation logger key.
	Annotation = "annotation"

	// Bool tracks a boolean logger key.
	Bool = "bool"

	// Replicas tracks a replicas logger key.
	Replicas = "replicas"

	// Revision tracks a revision logger key.
	Revision = "revision"

	// ColName tracks a column name logger key.
	ColName = "col-name"

	// URL tracks a URL logger key.
	URL = "url"

	// Attr tracks an attribute logger key.
	Attr = "attr"

	// Name tracks a name logger key.
	Name = "name"

	// Matches tracks a matches logger key.
	Matches = "matches"

	// Line tracks a line logger key.
	Line = "line"

	// Sig tracks a signal logger key.
	Sig = "signal"

	// Bin tracks a binary logger key.
	Bin = "binary"

	// Args tracks an arguments logger key.
	Args = "args"

	// PodPhase tracks a pod phase logger key.
	PodPhase = "pod-phase"

	// ShellPodCfg tracks a shell pod config logger key.
	ShellPodCfg = "shell-pod-cfg"

	// PFID tracks a port forward id logger key.
	PFID = "port-fwd-id"

	// PFTunnel tracks a port forward tunnel logger key.
	PFTunnel = "port-fwd-tunnel"

	// Config tracks a config logger key.
	Config = "config"

	// ResKind tracks a resource kind logger key.
	ResKind = "res-kind"

	// ResGrpVersion tracks a resource group version logger key.
	ResGrpVersion = "res-grp-version"

	// ID tracks an id logger key.
	ID = "id"

	// ViewSetting tracks a view setting logger key.
	ViewSetting = "view-setting"

	// JQExp tracks a jq expression logger key.
	JQExp = "jq-exp"
)
