provider "azurerm" {
  skip_provider_registration = true
  features {}
}

resource "azurerm_resource_group" "example" {
  name     = "example-resources"
  location = "West Europe"
}

resource "azurerm_virtual_network" "example" {
  name                = "network"
  address_space       = ["10.0.0.0/16"]
  location            = azurerm_resource_group.example.location
  resource_group_name = azurerm_resource_group.example.name
}

resource "azurerm_subnet" "internal" {
  name                 = "internal"
  resource_group_name  = azurerm_resource_group.example.name
  virtual_network_name = azurerm_virtual_network.example.name
  address_prefixes     = ["10.0.1.0/24"]
}

resource "azurerm_private_dns_resolver" "example" {
  name                = "pdnsr-example"
  resource_group_name = azurerm_resource_group.example.name
  location            = azurerm_resource_group.example.location
  virtual_network_id  = azurerm_virtual_network.example.id
}

resource "azurerm_private_dns_resolver_outbound_endpoint" "example" {
  name                    = "droe-example"
  location                = azurerm_resource_group.example.location
  subnet_id               = azurerm_subnet.internal.id
  private_dns_resolver_id = azurerm_private_dns_resolver.example.id
}


resource "azurerm_private_dns_resolver_dns_forwarding_ruleset" "example" {
  name                                       = "drdfr-example"
  resource_group_name                        = azurerm_resource_group.example.name
  location                                   = azurerm_resource_group.example.location
  private_dns_resolver_outbound_endpoint_ids = [azurerm_private_dns_resolver_outbound_endpoint.example.id]
}

